use std::fmt::{Display, Formatter};

#[derive(Debug, Copy, Clone)]
pub enum Usage {
    ChatGPT,
    TurboAPI,
    Dashboard,
    Authorize,
    Config,
}

impl Usage {
    // could be generated by macro
    pub const USAGE_VARS: &'static [Usage] = &[
        Self::TurboAPI,
        Self::ChatGPT,
        Self::Dashboard,
        Self::Authorize,
        Self::Config,
    ];
}

impl Display for Usage {
    fn fmt(&self, f: &mut Formatter<'_>) -> Result<(), std::fmt::Error> {
        match self {
            Usage::TurboAPI => write!(f, "{self:?}  - Turbo API interactive conversation"),
            Usage::ChatGPT => write!(f, "{self:?}   - ChatGPT API interactive conversation"),
            Usage::Dashboard => write!(f, "{self:?} - Dashboard settings"),
            Usage::Authorize => write!(f, "{self:?} - Authorization settings"),
            Usage::Config => write!(f, "{self:?}    - Configuration settings"),
        }
    }
}

#[derive(Debug, Copy, Clone)]
pub enum Authorize {
    Auth,
    OAuth,
}

impl Authorize {
    // could be generated by macro
    pub const AUTHORIZE_VARS: &'static [Authorize] = &[Self::Auth, Self::OAuth];
}

impl Display for Authorize {
    fn fmt(&self, f: &mut Formatter<'_>) -> Result<(), std::fmt::Error> {
        match self {
            Authorize::Auth => write!(f, "{self:?}  - Login Authorization"),
            Authorize::OAuth => write!(f, "{self:?} - OAuth Authorization"),
        }
    }
}

#[derive(Debug, Copy, Clone)]
#[allow(clippy::enum_variant_names)]
pub enum OAuth {
    AccessToken,
    RefreshToken,
    RevokeToken,
}

impl OAuth {
    // could be generated by macro
    pub const OAUTH_VARS: &'static [OAuth] =
        &[Self::AccessToken, Self::RefreshToken, Self::RevokeToken];
}

impl Display for OAuth {
    fn fmt(&self, f: &mut Formatter<'_>) -> Result<(), std::fmt::Error> {
        match self {
            OAuth::AccessToken => write!(f, "{self:?}  - Get AccessToken"),
            OAuth::RefreshToken => write!(f, "{self:?} - Refresh to get AccessToken"),
            OAuth::RevokeToken => write!(f, "{self:?}  - Revoke AccessToken"),
        }
    }
}

#[derive(Debug, Copy, Clone)]
pub enum Auth {
    State,
    Login,
    Logout,
    User,
}

impl Auth {
    // could be generated by macro
    pub const SIGN_IN_VARS: &'static [Auth] = &[Self::User, Self::State, Self::Login, Self::Logout];
}

impl Display for Auth {
    fn fmt(&self, f: &mut Formatter<'_>) -> Result<(), std::fmt::Error> {
        match self {
            Auth::User => write!(f, "{self:?}   - Current account user"),
            Auth::State => write!(f, "{self:?}  - Account login state"),
            Auth::Login => write!(f, "{self:?}  - Account SignIn"),
            Auth::Logout => write!(f, "{self:?} - Account SignOut"),
        }
    }
}

#[derive(Debug, Copy, Clone)]
pub enum Dashboard {
    List,
    Create,
    Delete,
    Billing,
}

impl Dashboard {
    // could be generated by macro
    pub const DASHBOARD_VARS: &'static [Dashboard] =
        &[Self::Billing, Self::List, Self::Create, Self::Delete];
}

impl Display for Dashboard {
    fn fmt(&self, f: &mut Formatter<'_>) -> Result<(), std::fmt::Error> {
        match self {
            Dashboard::Billing => write!(f, "{self:?}  - ApiKey Billing"),
            Dashboard::List => write!(f, "{self:?}     - List ApiKey"),
            Dashboard::Create => write!(f, "{self:?}   - Create ApiKey"),
            Dashboard::Delete => write!(f, "{self:?}   - Delete ApiKey"),
        }
    }
}
