/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.zip;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.nio.file.attribute.FileTime;
import sandbox.java.util.Objects;
import sandbox.java.util.concurrent.TimeUnit;
import sandbox.java.util.zip.ZipConstants;
import sandbox.java.util.zip.ZipUtils;

public class ZipEntry
implements ZipConstants,
Cloneable {
    String name;
    long time;
    FileTime mtime;
    FileTime atime;
    FileTime ctime;
    long crc;
    long size;
    long csize;
    int method;
    int flag;
    byte[] extra;
    String comment;
    public static final int STORED = 0;
    public static final int DEFLATED = 8;

    public ZipEntry(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.time = -1L;
        this.crc = -1L;
        this.size = -1L;
        this.csize = -1L;
        this.method = -1;
        this.flag = 0;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(string, "name");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
        int n = string.length();
        RuntimeCostAccounter.recordJump();
        if (n > 65535) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("entry name too long");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        this.name = string;
    }

    public ZipEntry(ZipEntry zipEntry) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.time = -1L;
        this.crc = -1L;
        this.size = -1L;
        this.csize = -1L;
        this.method = -1;
        this.flag = 0;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(zipEntry, "entry");
        this.name = zipEntry.name;
        this.time = zipEntry.time;
        this.mtime = zipEntry.mtime;
        this.atime = zipEntry.atime;
        this.ctime = zipEntry.ctime;
        this.crc = zipEntry.crc;
        this.size = zipEntry.size;
        this.csize = zipEntry.csize;
        this.method = zipEntry.method;
        this.flag = zipEntry.flag;
        this.extra = zipEntry.extra;
        this.comment = zipEntry.comment;
    }

    ZipEntry() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.time = -1L;
        this.crc = -1L;
        this.size = -1L;
        this.csize = -1L;
        this.method = -1;
        this.flag = 0;
    }

    public String getName() {
        return this.name;
    }

    public void setTime(long l) {
        this.time = l;
        this.mtime = null;
    }

    public long getTime() {
        return this.time;
    }

    public ZipEntry setLastModifiedTime(FileTime fileTime) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(this.name, "time");
        this.mtime = fileTime;
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/file/attribute/FileTime.to:(Ljava/util/concurrent/TimeUnit;)J");
        this.time = fileTime.to(TimeUnit.MILLISECONDS);
        return this;
    }

    public FileTime getLastModifiedTime() {
        RuntimeCostAccounter.recordJump();
        if (this.mtime != null) {
            return this.mtime;
        }
        RuntimeCostAccounter.recordJump();
        if (this.time == -1L) {
            return null;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/file/attribute/FileTime.from:(JLjava/util/concurrent/TimeUnit;)Ljava/nio/file/attribute/FileTime;");
        return FileTime.from((long)this.time, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public ZipEntry setLastAccessTime(FileTime fileTime) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(this.name, "time");
        this.atime = fileTime;
        return this;
    }

    public FileTime getLastAccessTime() {
        return this.atime;
    }

    public ZipEntry setCreationTime(FileTime fileTime) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(this.name, "time");
        this.ctime = fileTime;
        return this;
    }

    public FileTime getCreationTime() {
        return this.ctime;
    }

    public void setSize(long l) {
        RuntimeCostAccounter.recordJump();
        if (l < 0L) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("invalid entry size");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        this.size = l;
    }

    public long getSize() {
        return this.size;
    }

    public long getCompressedSize() {
        return this.csize;
    }

    public void setCompressedSize(long l) {
        this.csize = l;
    }

    public void setCrc(long l) {
        block3: {
            block2: {
                RuntimeCostAccounter.recordJump();
                if (l < 0L) break block2;
                RuntimeCostAccounter.recordJump();
                if (l <= 0xFFFFFFFFL) break block3;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("invalid entry crc-32");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        this.crc = l;
    }

    public long getCrc() {
        return this.crc;
    }

    public void setMethod(int n) {
        RuntimeCostAccounter.recordJump();
        if (n != 0) {
            RuntimeCostAccounter.recordJump();
            if (n != 8) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("invalid compression method");
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
        }
        this.method = n;
    }

    public int getMethod() {
        return this.method;
    }

    public void setExtra(byte[] byArray) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipEntry.setExtra0:([BZ)V");
        this.setExtra0(byArray, false);
    }

    void setExtra0(byte[] byArray, boolean bl) {
        RuntimeCostAccounter.recordJump();
        if (byArray != null) {
            int n = byArray.length;
            RuntimeCostAccounter.recordJump();
            if (n > 65535) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("invalid extra field length");
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            int n2 = 0;
            int n3 = byArray.length;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n2 + 4 >= n3) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.get16:([BI)I");
                int n4 = ZipUtils.get16(byArray, n2);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.get16:([BI)I");
                int n5 = ZipUtils.get16(byArray, n2 + 2);
                RuntimeCostAccounter.recordJump();
                if ((n2 += 4) + n5 > n3) {
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                switch (n4) {
                    case 1: {
                        RuntimeCostAccounter.recordJump();
                        if (!bl) break;
                        RuntimeCostAccounter.recordJump();
                        if (n5 < 16) break;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.get64:([BI)J");
                        this.size = ZipUtils.get64(byArray, n2);
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.get64:([BI)J");
                        this.csize = ZipUtils.get64(byArray, n2 + 8);
                        RuntimeCostAccounter.recordJump();
                        break;
                    }
                    case 10: {
                        int n6 = n2 + 4;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.get16:([BI)I");
                        int n7 = ZipUtils.get16(byArray, n6);
                        RuntimeCostAccounter.recordJump();
                        if (n7 != 1) break;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.get16:([BI)I");
                        int n8 = ZipUtils.get16(byArray, n6 + 2);
                        RuntimeCostAccounter.recordJump();
                        if (n8 != 24) {
                            RuntimeCostAccounter.recordJump();
                            break;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.get64:([BI)J");
                        long l = ZipUtils.get64(byArray, n6 + 4);
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.winTimeToFileTime:(J)Ljava/nio/file/attribute/FileTime;");
                        this.mtime = ZipUtils.winTimeToFileTime(l);
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.get64:([BI)J");
                        long l2 = ZipUtils.get64(byArray, n6 + 12);
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.winTimeToFileTime:(J)Ljava/nio/file/attribute/FileTime;");
                        this.atime = ZipUtils.winTimeToFileTime(l2);
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.get64:([BI)J");
                        long l3 = ZipUtils.get64(byArray, n6 + 20);
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.winTimeToFileTime:(J)Ljava/nio/file/attribute/FileTime;");
                        this.ctime = ZipUtils.winTimeToFileTime(l3);
                        RuntimeCostAccounter.recordJump();
                        break;
                    }
                    case 21589: {
                        byte by = byArray[n2];
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Byte.toUnsignedInt:(B)I");
                        int n9 = Byte.toUnsignedInt(by);
                        int n10 = 1;
                        RuntimeCostAccounter.recordJump();
                        if ((n9 & 1) != 0) {
                            RuntimeCostAccounter.recordJump();
                            if (n10 + 4 <= n5) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.get32:([BI)J");
                                long l = ZipUtils.get32(byArray, n2 + n10);
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.unixTimeToFileTime:(J)Ljava/nio/file/attribute/FileTime;");
                                this.mtime = ZipUtils.unixTimeToFileTime(l);
                                n10 += 4;
                            }
                        }
                        RuntimeCostAccounter.recordJump();
                        if ((n9 & 2) != 0) {
                            RuntimeCostAccounter.recordJump();
                            if (n10 + 4 <= n5) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.get32:([BI)J");
                                long l = ZipUtils.get32(byArray, n2 + n10);
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.unixTimeToFileTime:(J)Ljava/nio/file/attribute/FileTime;");
                                this.atime = ZipUtils.unixTimeToFileTime(l);
                                n10 += 4;
                            }
                        }
                        RuntimeCostAccounter.recordJump();
                        if ((n9 & 4) == 0) break;
                        RuntimeCostAccounter.recordJump();
                        if (n10 + 4 > n5) break;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.get32:([BI)J");
                        long l = ZipUtils.get32(byArray, n2 + n10);
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.unixTimeToFileTime:(J)Ljava/nio/file/attribute/FileTime;");
                        this.ctime = ZipUtils.unixTimeToFileTime(l);
                        n10 += 4;
                        RuntimeCostAccounter.recordJump();
                        break;
                    }
                }
                n2 += n5;
                RuntimeCostAccounter.recordJump();
            }
        }
        this.extra = byArray;
    }

    public byte[] getExtra() {
        return this.extra;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isDirectory() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.endsWith:(Ljava/lang/String;)Z");
        return this.name.endsWith("/");
    }

    public String toString() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipEntry.getName:()Ljava/lang/String;");
        return this.getName();
    }

    public int hashCode() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.hashCode:()I");
        return this.name.hashCode();
    }

    public Object clone() {
        try {
            byte[] byArray;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.clone:()Ljava/lang/Object;");
            ZipEntry zipEntry = (ZipEntry)super.clone();
            RuntimeCostAccounter.recordJump();
            if (this.extra == null) {
                byArray = null;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"[B.clone:()Ljava/lang/Object;");
                byArray = (byte[])this.extra.clone();
            }
            zipEntry.extra = byArray;
            return zipEntry;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/InternalError");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/InternalError.<init>:(Ljava/lang/Throwable;)V");
            InternalError internalError = new InternalError(cloneNotSupportedException);
            RuntimeCostAccounter.recordThrow();
            throw internalError;
        }
    }
}

