/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.concurrent.atomic;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.InvalidObjectException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.Serializable;
import sandbox.java.util.concurrent.atomic.Striped64;

public class LongAdder
extends Striped64
implements Serializable {
    private static final long serialVersionUID = 7249069246863182397L;

    public LongAdder() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/Striped64.<init>:()V");
    }

    public void add(long l) {
        block3: {
            boolean bl;
            block4: {
                Striped64.Cell[] cellArray;
                block2: {
                    cellArray = this.cells;
                    RuntimeCostAccounter.recordJump();
                    if (this.cells != null) break block2;
                    long l2 = this.base;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/LongAdder.casBase:(JJ)Z");
                    boolean bl2 = this.casBase(l2, l2 + l);
                    RuntimeCostAccounter.recordJump();
                    if (bl2) break block3;
                }
                bl = true;
                RuntimeCostAccounter.recordJump();
                if (cellArray == null) break block4;
                int n = cellArray.length - 1;
                RuntimeCostAccounter.recordJump();
                if (n < 0) break block4;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/LongAdder.getProbe:()I");
                Striped64.Cell cell = cellArray[LongAdder.getProbe() & n];
                RuntimeCostAccounter.recordJump();
                if (cell == null) break block4;
                long l3 = cell.value;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/Striped64$Cell.cas:(JJ)Z");
                bl = cell.cas(l3, l3 + l);
                RuntimeCostAccounter.recordJump();
                if (bl) break block3;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/LongAdder.longAccumulate:(JLjava/util/function/LongBinaryOperator;Z)V");
            this.longAccumulate(l, null, bl);
        }
    }

    public void increment() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/LongAdder.add:(J)V");
        this.add(1L);
    }

    public void decrement() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/LongAdder.add:(J)V");
        this.add(-1L);
    }

    public long sum() {
        Striped64.Cell[] cellArray = this.cells;
        long l = this.base;
        RuntimeCostAccounter.recordJump();
        if (cellArray != null) {
            int n = 0;
            while (true) {
                int n2 = cellArray.length;
                RuntimeCostAccounter.recordJump();
                if (n >= n2) break;
                Striped64.Cell cell = cellArray[n];
                RuntimeCostAccounter.recordJump();
                if (cell != null) {
                    l += cell.value;
                }
                ++n;
                RuntimeCostAccounter.recordJump();
            }
        }
        return l;
    }

    public void reset() {
        Striped64.Cell[] cellArray = this.cells;
        this.base = 0L;
        RuntimeCostAccounter.recordJump();
        if (cellArray != null) {
            int n = 0;
            while (true) {
                int n2 = cellArray.length;
                RuntimeCostAccounter.recordJump();
                if (n >= n2) break;
                Striped64.Cell cell = cellArray[n];
                RuntimeCostAccounter.recordJump();
                if (cell != null) {
                    cell.value = 0L;
                }
                ++n;
                RuntimeCostAccounter.recordJump();
            }
        }
    }

    public long sumThenReset() {
        Striped64.Cell[] cellArray = this.cells;
        long l = this.base;
        this.base = 0L;
        RuntimeCostAccounter.recordJump();
        if (cellArray != null) {
            int n = 0;
            while (true) {
                int n2 = cellArray.length;
                RuntimeCostAccounter.recordJump();
                if (n >= n2) break;
                Striped64.Cell cell = cellArray[n];
                RuntimeCostAccounter.recordJump();
                if (cell != null) {
                    l += cell.value;
                    cell.value = 0L;
                }
                ++n;
                RuntimeCostAccounter.recordJump();
            }
        }
        return l;
    }

    public String toString() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/LongAdder.sum:()J");
        long l = this.sum();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.toString:(J)Ljava/lang/String;");
        return Long.toString(l);
    }

    @Override
    public long longValue() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/LongAdder.sum:()J");
        return this.sum();
    }

    @Override
    public int intValue() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/LongAdder.sum:()J");
        return (int)this.sum();
    }

    @Override
    public float floatValue() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/LongAdder.sum:()J");
        return this.sum();
    }

    @Override
    public double doubleValue() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/LongAdder.sum:()J");
        return this.sum();
    }

    private Object writeReplace() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/atomic/LongAdder$SerializationProxy");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/LongAdder$SerializationProxy.<init>:(Ljava/util/concurrent/atomic/LongAdder;)V");
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidObjectException");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidObjectException.<init>:(Ljava/lang/String;)V");
        InvalidObjectException invalidObjectException = new InvalidObjectException("Proxy required");
        RuntimeCostAccounter.recordThrow();
        throw invalidObjectException;
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 7249069246863182397L;
        private final long value;

        SerializationProxy(LongAdder longAdder) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/LongAdder.sum:()J");
            this.value = longAdder.sum();
        }

        private Object readResolve() {
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/atomic/LongAdder");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/LongAdder.<init>:()V");
            LongAdder longAdder = new LongAdder();
            longAdder.base = this.value;
            return longAdder;
        }
    }
}

