/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.concurrent;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.util.concurrent.TimeUnit;
import sandbox.java.util.concurrent.locks.AbstractQueuedSynchronizer;

public class CountDownLatch {
    private final Sync sync;

    public CountDownLatch(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("count < 0");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CountDownLatch$Sync");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CountDownLatch$Sync.<init>:(I)V");
        this.sync = new Sync(n);
    }

    public void await() throws InterruptedException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CountDownLatch$Sync.acquireSharedInterruptibly:(I)V");
        this.sync.acquireSharedInterruptibly(1);
    }

    public boolean await(long l, TimeUnit timeUnit) throws InterruptedException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/TimeUnit.toNanos:(J)J");
        long l2 = timeUnit.toNanos(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CountDownLatch$Sync.tryAcquireSharedNanos:(IJ)Z");
        return this.sync.tryAcquireSharedNanos(1, l2);
    }

    public void countDown() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CountDownLatch$Sync.releaseShared:(I)Z");
        this.sync.releaseShared(1);
    }

    public long getCount() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CountDownLatch$Sync.getCount:()I");
        return this.sync.getCount();
    }

    public String toString() {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.toString:()Ljava/lang/String;");
        String string = super.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append("[Count = ");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CountDownLatch$Sync.getCount:()I");
        int n = this.sync.getCount();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder4 = stringBuilder3.append(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder5 = stringBuilder4.append("]");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        return stringBuilder5.toString();
    }

    private static final class Sync
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = 4982264981922014374L;

        Sync(int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedSynchronizer.<init>:()V");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CountDownLatch$Sync.setState:(I)V");
            this.setState(n);
        }

        int getCount() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CountDownLatch$Sync.getState:()I");
            return this.getState();
        }

        @Override
        protected int tryAcquireShared(int n) {
            int n2;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CountDownLatch$Sync.getState:()I");
            int n3 = this.getState();
            RuntimeCostAccounter.recordJump();
            if (n3 == 0) {
                n2 = 1;
                RuntimeCostAccounter.recordJump();
            } else {
                n2 = -1;
            }
            return n2;
        }

        @Override
        protected boolean tryReleaseShared(int n) {
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CountDownLatch$Sync.getState:()I");
                int n2 = this.getState();
                RuntimeCostAccounter.recordJump();
                if (n2 == 0) {
                    return false;
                }
                int n3 = n2 - 1;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CountDownLatch$Sync.compareAndSetState:(II)Z");
                boolean bl = this.compareAndSetState(n2, n3);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    boolean bl2;
                    RuntimeCostAccounter.recordJump();
                    if (n3 == 0) {
                        bl2 = true;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        bl2 = false;
                    }
                    return bl2;
                }
                RuntimeCostAccounter.recordJump();
            }
        }
    }
}

