/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.util.Iterator;
import sandbox.java.util.Objects;
import sandbox.java.util.Tripwire;
import sandbox.java.util.function.Consumer;
import sandbox.java.util.function.DoubleConsumer;
import sandbox.java.util.function.IntConsumer;
import sandbox.java.util.function.LongConsumer;

public interface PrimitiveIterator<T, T_CONS>
extends Iterator<T> {
    public void forEachRemaining(T_CONS var1);

    public static interface OfDouble
    extends PrimitiveIterator<Double, DoubleConsumer> {
        public double nextDouble();

        @Override
        default public void forEachRemaining(DoubleConsumer doubleConsumer) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
            Objects.requireNonNull(doubleConsumer);
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/PrimitiveIterator$OfDouble.hasNext:()Z");
                boolean bl = this.hasNext();
                RuntimeCostAccounter.recordJump();
                if (!bl) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/PrimitiveIterator$OfDouble.nextDouble:()D");
                double d = this.nextDouble();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/DoubleConsumer.accept:(D)V");
                doubleConsumer.accept(d);
                RuntimeCostAccounter.recordJump();
            }
        }

        @Override
        default public Double next() {
            RuntimeCostAccounter.recordJump();
            if (Tripwire.ENABLED) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
                Class<?> clazz = this.getClass();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Tripwire.trip:(Ljava/lang/Class;Ljava/lang/String;)V");
                Tripwire.trip(clazz, "{0} calling PrimitiveIterator.OfDouble.nextLong()");
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/PrimitiveIterator$OfDouble.nextDouble:()D");
            double d = this.nextDouble();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.valueOf:(D)Ljava/lang/Double;");
            return d;
        }

        @Override
        default public void forEachRemaining(Consumer<? super Double> consumer) {
            boolean bl = consumer instanceof DoubleConsumer;
            RuntimeCostAccounter.recordJump();
            if (bl) {
                DoubleConsumer doubleConsumer = (DoubleConsumer)((Object)consumer);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/PrimitiveIterator$OfDouble.forEachRemaining:(Ljava/util/function/DoubleConsumer;)V");
                this.forEachRemaining(doubleConsumer);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
                Objects.requireNonNull(consumer);
                RuntimeCostAccounter.recordJump();
                if (Tripwire.ENABLED) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
                    Class<?> clazz = this.getClass();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Tripwire.trip:(Ljava/lang/Class;Ljava/lang/String;)V");
                    Tripwire.trip(clazz, "{0} calling PrimitiveIterator.OfDouble.forEachRemainingDouble(action::accept)");
                }
                Consumer<? super Double> consumer2 = consumer;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
                consumer2.getClass();
                DoubleConsumer doubleConsumer = consumer2::accept;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/PrimitiveIterator$OfDouble.forEachRemaining:(Ljava/util/function/DoubleConsumer;)V");
                this.forEachRemaining(doubleConsumer);
            }
        }
    }

    public static interface OfLong
    extends PrimitiveIterator<Long, LongConsumer> {
        public long nextLong();

        @Override
        default public void forEachRemaining(LongConsumer longConsumer) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
            Objects.requireNonNull(longConsumer);
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/PrimitiveIterator$OfLong.hasNext:()Z");
                boolean bl = this.hasNext();
                RuntimeCostAccounter.recordJump();
                if (!bl) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/PrimitiveIterator$OfLong.nextLong:()J");
                long l = this.nextLong();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/LongConsumer.accept:(J)V");
                longConsumer.accept(l);
                RuntimeCostAccounter.recordJump();
            }
        }

        @Override
        default public Long next() {
            RuntimeCostAccounter.recordJump();
            if (Tripwire.ENABLED) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
                Class<?> clazz = this.getClass();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Tripwire.trip:(Ljava/lang/Class;Ljava/lang/String;)V");
                Tripwire.trip(clazz, "{0} calling PrimitiveIterator.OfLong.nextLong()");
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/PrimitiveIterator$OfLong.nextLong:()J");
            long l = this.nextLong();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
            return l;
        }

        @Override
        default public void forEachRemaining(Consumer<? super Long> consumer) {
            boolean bl = consumer instanceof LongConsumer;
            RuntimeCostAccounter.recordJump();
            if (bl) {
                LongConsumer longConsumer = (LongConsumer)((Object)consumer);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/PrimitiveIterator$OfLong.forEachRemaining:(Ljava/util/function/LongConsumer;)V");
                this.forEachRemaining(longConsumer);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
                Objects.requireNonNull(consumer);
                RuntimeCostAccounter.recordJump();
                if (Tripwire.ENABLED) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
                    Class<?> clazz = this.getClass();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Tripwire.trip:(Ljava/lang/Class;Ljava/lang/String;)V");
                    Tripwire.trip(clazz, "{0} calling PrimitiveIterator.OfLong.forEachRemainingLong(action::accept)");
                }
                Consumer<? super Long> consumer2 = consumer;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
                consumer2.getClass();
                LongConsumer longConsumer = consumer2::accept;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/PrimitiveIterator$OfLong.forEachRemaining:(Ljava/util/function/LongConsumer;)V");
                this.forEachRemaining(longConsumer);
            }
        }
    }

    public static interface OfInt
    extends PrimitiveIterator<Integer, IntConsumer> {
        public int nextInt();

        @Override
        default public void forEachRemaining(IntConsumer intConsumer) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
            Objects.requireNonNull(intConsumer);
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/PrimitiveIterator$OfInt.hasNext:()Z");
                boolean bl = this.hasNext();
                RuntimeCostAccounter.recordJump();
                if (!bl) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/PrimitiveIterator$OfInt.nextInt:()I");
                int n = this.nextInt();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/IntConsumer.accept:(I)V");
                intConsumer.accept(n);
                RuntimeCostAccounter.recordJump();
            }
        }

        @Override
        default public Integer next() {
            RuntimeCostAccounter.recordJump();
            if (Tripwire.ENABLED) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
                Class<?> clazz = this.getClass();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Tripwire.trip:(Ljava/lang/Class;Ljava/lang/String;)V");
                Tripwire.trip(clazz, "{0} calling PrimitiveIterator.OfInt.nextInt()");
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/PrimitiveIterator$OfInt.nextInt:()I");
            int n = this.nextInt();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
            return n;
        }

        @Override
        default public void forEachRemaining(Consumer<? super Integer> consumer) {
            boolean bl = consumer instanceof IntConsumer;
            RuntimeCostAccounter.recordJump();
            if (bl) {
                IntConsumer intConsumer = (IntConsumer)((Object)consumer);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/PrimitiveIterator$OfInt.forEachRemaining:(Ljava/util/function/IntConsumer;)V");
                this.forEachRemaining(intConsumer);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
                Objects.requireNonNull(consumer);
                RuntimeCostAccounter.recordJump();
                if (Tripwire.ENABLED) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
                    Class<?> clazz = this.getClass();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Tripwire.trip:(Ljava/lang/Class;Ljava/lang/String;)V");
                    Tripwire.trip(clazz, "{0} calling PrimitiveIterator.OfInt.forEachRemainingInt(action::accept)");
                }
                Consumer<? super Integer> consumer2 = consumer;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
                consumer2.getClass();
                IntConsumer intConsumer = consumer2::accept;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/PrimitiveIterator$OfInt.forEachRemaining:(Ljava/util/function/IntConsumer;)V");
                this.forEachRemaining(intConsumer);
            }
        }
    }
}

