/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util;

import java.lang.reflect.Array;
import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.IOException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.ObjectOutputStream;
import sandbox.java.io.Serializable;
import sandbox.java.util.AbstractList;
import sandbox.java.util.AbstractMap;
import sandbox.java.util.AbstractQueue;
import sandbox.java.util.AbstractSet;
import sandbox.java.util.ArrayList;
import sandbox.java.util.Arrays;
import sandbox.java.util.Collection;
import sandbox.java.util.Comparator;
import sandbox.java.util.Deque;
import sandbox.java.util.Enumeration;
import sandbox.java.util.Iterator;
import sandbox.java.util.List;
import sandbox.java.util.ListIterator;
import sandbox.java.util.Map;
import sandbox.java.util.NavigableMap;
import sandbox.java.util.NavigableSet;
import sandbox.java.util.NoSuchElementException;
import sandbox.java.util.Objects;
import sandbox.java.util.Queue;
import sandbox.java.util.Random;
import sandbox.java.util.RandomAccess;
import sandbox.java.util.Set;
import sandbox.java.util.SortedMap;
import sandbox.java.util.SortedSet;
import sandbox.java.util.Spliterator;
import sandbox.java.util.Spliterators;
import sandbox.java.util.TreeMap;
import sandbox.java.util.TreeSet;
import sandbox.java.util.function.BiConsumer;
import sandbox.java.util.function.BiFunction;
import sandbox.java.util.function.Consumer;
import sandbox.java.util.function.Function;
import sandbox.java.util.function.IntFunction;
import sandbox.java.util.function.Predicate;
import sandbox.java.util.function.UnaryOperator;
import sandbox.java.util.stream.IntStream;
import sandbox.java.util.stream.Stream;
import sandbox.java.util.stream.StreamSupport;

public class Collections {
    private static final int BINARYSEARCH_THRESHOLD = 5000;
    private static final int REVERSE_THRESHOLD = 18;
    private static final int SHUFFLE_THRESHOLD = 5;
    private static final int FILL_THRESHOLD = 25;
    private static final int ROTATE_THRESHOLD = 100;
    private static final int COPY_THRESHOLD = 10;
    private static final int REPLACEALL_THRESHOLD = 11;
    private static final int INDEXOFSUBLIST_THRESHOLD = 35;
    private static Random r;
    public static final Set EMPTY_SET;
    public static final List EMPTY_LIST;
    public static final Map EMPTY_MAP;

    private Collections() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
    }

    public static <T extends Comparable<? super T>> void sort(List<T> list) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.sort:(Ljava/util/Comparator;)V");
        list.sort(null);
    }

    public static <T> void sort(List<T> list, Comparator<? super T> comparator) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.sort:(Ljava/util/Comparator;)V");
        list.sort(comparator);
    }

    public static <T> int binarySearch(List<? extends Comparable<? super T>> list, T t) {
        block3: {
            block2: {
                boolean bl = list instanceof RandomAccess;
                RuntimeCostAccounter.recordJump();
                if (bl) break block2;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.size:()I");
                int n = list.size();
                RuntimeCostAccounter.recordJump();
                if (n >= 5000) break block3;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.indexedBinarySearch:(Ljava/util/List;Ljava/lang/Object;)I");
            return Collections.indexedBinarySearch(list, t);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.iteratorBinarySearch:(Ljava/util/List;Ljava/lang/Object;)I");
        return Collections.iteratorBinarySearch(list, t);
    }

    private static <T> int indexedBinarySearch(List<? extends Comparable<? super T>> list, T t) {
        int n = 0;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.size:()I");
        int n2 = list.size() - 1;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n > n2) break;
            int n3 = n + n2 >>> 1;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.get:(I)Ljava/lang/Object;");
            Comparable<T> comparable = list.get(n3);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Comparable.compareTo:(Ljava/lang/Object;)I");
            int n4 = comparable.compareTo(t);
            RuntimeCostAccounter.recordJump();
            if (n4 < 0) {
                n = n3 + 1;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordJump();
                if (n4 > 0) {
                    n2 = n3 - 1;
                    RuntimeCostAccounter.recordJump();
                } else {
                    return n3;
                }
            }
            RuntimeCostAccounter.recordJump();
        }
        return -(n + 1);
    }

    private static <T> int iteratorBinarySearch(List<? extends Comparable<? super T>> list, T t) {
        int n = 0;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.size:()I");
        int n2 = list.size() - 1;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.listIterator:()Ljava/util/ListIterator;");
        ListIterator<? extends Comparable<? super T>> listIterator = list.listIterator();
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n > n2) break;
            int n3 = n + n2 >>> 1;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.get:(Ljava/util/ListIterator;I)Ljava/lang/Object;");
            Comparable<T> comparable = Collections.get(listIterator, n3);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Comparable.compareTo:(Ljava/lang/Object;)I");
            int n4 = comparable.compareTo(t);
            RuntimeCostAccounter.recordJump();
            if (n4 < 0) {
                n = n3 + 1;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordJump();
                if (n4 > 0) {
                    n2 = n3 - 1;
                    RuntimeCostAccounter.recordJump();
                } else {
                    return n3;
                }
            }
            RuntimeCostAccounter.recordJump();
        }
        return -(n + 1);
    }

    private static <T> T get(ListIterator<? extends T> listIterator, int n) {
        T t = null;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.nextIndex:()I");
        int n2 = listIterator.nextIndex();
        RuntimeCostAccounter.recordJump();
        if (n2 <= n) {
            int n3;
            do {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.next:()Ljava/lang/Object;");
                t = listIterator.next();
                n3 = n2++;
                RuntimeCostAccounter.recordJump();
            } while (n3 < n);
            RuntimeCostAccounter.recordJump();
        } else {
            do {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.previous:()Ljava/lang/Object;");
                t = listIterator.previous();
                RuntimeCostAccounter.recordJump();
            } while (--n2 > n);
        }
        return t;
    }

    public static <T> int binarySearch(List<? extends T> list, T t, Comparator<? super T> comparator) {
        block5: {
            block4: {
                RuntimeCostAccounter.recordJump();
                if (comparator == null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.binarySearch:(Ljava/util/List;Ljava/lang/Object;)I");
                    return Collections.binarySearch(list, t);
                }
                boolean bl = list instanceof RandomAccess;
                RuntimeCostAccounter.recordJump();
                if (bl) break block4;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.size:()I");
                int n = list.size();
                RuntimeCostAccounter.recordJump();
                if (n >= 5000) break block5;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.indexedBinarySearch:(Ljava/util/List;Ljava/lang/Object;Ljava/util/Comparator;)I");
            return Collections.indexedBinarySearch(list, t, comparator);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.iteratorBinarySearch:(Ljava/util/List;Ljava/lang/Object;Ljava/util/Comparator;)I");
        return Collections.iteratorBinarySearch(list, t, comparator);
    }

    private static <T> int indexedBinarySearch(List<? extends T> list, T t, Comparator<? super T> comparator) {
        int n = 0;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.size:()I");
        int n2 = list.size() - 1;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n > n2) break;
            int n3 = n + n2 >>> 1;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.get:(I)Ljava/lang/Object;");
            T t2 = list.get(n3);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Comparator.compare:(Ljava/lang/Object;Ljava/lang/Object;)I");
            int n4 = comparator.compare(t2, t);
            RuntimeCostAccounter.recordJump();
            if (n4 < 0) {
                n = n3 + 1;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordJump();
                if (n4 > 0) {
                    n2 = n3 - 1;
                    RuntimeCostAccounter.recordJump();
                } else {
                    return n3;
                }
            }
            RuntimeCostAccounter.recordJump();
        }
        return -(n + 1);
    }

    private static <T> int iteratorBinarySearch(List<? extends T> list, T t, Comparator<? super T> comparator) {
        int n = 0;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.size:()I");
        int n2 = list.size() - 1;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.listIterator:()Ljava/util/ListIterator;");
        ListIterator<? extends T> listIterator = list.listIterator();
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n > n2) break;
            int n3 = n + n2 >>> 1;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.get:(Ljava/util/ListIterator;I)Ljava/lang/Object;");
            T t2 = Collections.get(listIterator, n3);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Comparator.compare:(Ljava/lang/Object;Ljava/lang/Object;)I");
            int n4 = comparator.compare(t2, t);
            RuntimeCostAccounter.recordJump();
            if (n4 < 0) {
                n = n3 + 1;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordJump();
                if (n4 > 0) {
                    n2 = n3 - 1;
                    RuntimeCostAccounter.recordJump();
                } else {
                    return n3;
                }
            }
            RuntimeCostAccounter.recordJump();
        }
        return -(n + 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void reverse(List<?> list) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.size:()I");
        int n = list.size();
        RuntimeCostAccounter.recordJump();
        if (n >= 18) {
            boolean bl = list instanceof RandomAccess;
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.listIterator:()Ljava/util/ListIterator;");
                ListIterator<?> listIterator = list.listIterator();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.listIterator:(I)Ljava/util/ListIterator;");
                ListIterator<?> listIterator2 = list.listIterator(n);
                int n2 = 0;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.size:()I");
                int n3 = list.size() >> 1;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n2 >= n3) return;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.next:()Ljava/lang/Object;");
                    Object obj = listIterator.next();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.previous:()Ljava/lang/Object;");
                    Object obj2 = listIterator2.previous();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.set:(Ljava/lang/Object;)V");
                    listIterator.set(obj2);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.set:(Ljava/lang/Object;)V");
                    listIterator2.set(obj);
                    ++n2;
                    RuntimeCostAccounter.recordJump();
                }
            }
        }
        int n4 = 0;
        int n5 = n >> 1;
        int n6 = n - 1;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n4 >= n5) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.swap:(Ljava/util/List;II)V");
            Collections.swap(list, n4, n6);
            ++n4;
            --n6;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
    }

    public static void shuffle(List<?> list) {
        Random random = r;
        RuntimeCostAccounter.recordJump();
        if (random == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/Random");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Random.<init>:()V");
            r = random = new Random();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.shuffle:(Ljava/util/List;Ljava/util/Random;)V");
        Collections.shuffle(list, random);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void shuffle(List<?> list, Random random) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.size:()I");
        int n = list.size();
        RuntimeCostAccounter.recordJump();
        if (n >= 5) {
            boolean bl = list instanceof RandomAccess;
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.toArray:()[Ljava/lang/Object;");
                Object[] objectArray = list.toArray();
                int n2 = n;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n2 <= 1) break;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Random.nextInt:(I)I");
                    int n3 = random.nextInt(n2);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.swap:([Ljava/lang/Object;II)V");
                    Collections.swap(objectArray, n2 - 1, n3);
                    --n2;
                    RuntimeCostAccounter.recordJump();
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.listIterator:()Ljava/util/ListIterator;");
                ListIterator<?> listIterator = list.listIterator();
                int n4 = 0;
                while (true) {
                    int n5 = objectArray.length;
                    RuntimeCostAccounter.recordJump();
                    if (n4 >= n5) return;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.next:()Ljava/lang/Object;");
                    listIterator.next();
                    Object object = objectArray[n4];
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.set:(Ljava/lang/Object;)V");
                    listIterator.set(object);
                    ++n4;
                    RuntimeCostAccounter.recordJump();
                }
            }
        }
        int n6 = n;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n6 <= 1) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Random.nextInt:(I)I");
            int n7 = random.nextInt(n6);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.swap:(Ljava/util/List;II)V");
            Collections.swap(list, n6 - 1, n7);
            --n6;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
    }

    public static void swap(List<?> list, int n, int n2) {
        List<?> list2 = list;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.get:(I)Ljava/lang/Object;");
        Object obj = list2.get(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.set:(ILjava/lang/Object;)Ljava/lang/Object;");
        Object obj2 = list2.set(n2, obj);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.set:(ILjava/lang/Object;)Ljava/lang/Object;");
        list2.set(n, obj2);
    }

    private static void swap(Object[] objectArray, int n, int n2) {
        Object object = objectArray[n];
        objectArray[n] = objectArray[n2];
        objectArray[n2] = object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> void fill(List<? super T> list, T t) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.size:()I");
        int n = list.size();
        RuntimeCostAccounter.recordJump();
        if (n >= 25) {
            boolean bl = list instanceof RandomAccess;
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.listIterator:()Ljava/util/ListIterator;");
                ListIterator<T> listIterator = list.listIterator();
                int n2 = 0;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n2 >= n) return;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.next:()Ljava/lang/Object;");
                    listIterator.next();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.set:(Ljava/lang/Object;)V");
                    listIterator.set(t);
                    ++n2;
                    RuntimeCostAccounter.recordJump();
                }
            }
        }
        int n3 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n3 >= n) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.set:(ILjava/lang/Object;)Ljava/lang/Object;");
            list.set(n3, t);
            ++n3;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static <T> void copy(List<? super T> list, List<? extends T> list2) {
        int n;
        block8: {
            block7: {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.size:()I");
                n = list2.size();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.size:()I");
                int n2 = list.size();
                RuntimeCostAccounter.recordJump();
                if (n > n2) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:(Ljava/lang/String;)V");
                    IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException("Source does not fit in dest");
                    RuntimeCostAccounter.recordThrow();
                    throw indexOutOfBoundsException;
                }
                RuntimeCostAccounter.recordJump();
                if (n < 10) break block7;
                boolean bl = list2 instanceof RandomAccess;
                RuntimeCostAccounter.recordJump();
                if (!bl) break block8;
                boolean bl2 = list instanceof RandomAccess;
                RuntimeCostAccounter.recordJump();
                if (!bl2) break block8;
            }
            int n3 = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n3 >= n) {
                    RuntimeCostAccounter.recordJump();
                    return;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.get:(I)Ljava/lang/Object;");
                T t = list2.get(n3);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.set:(ILjava/lang/Object;)Ljava/lang/Object;");
                list.set(n3, t);
                ++n3;
                RuntimeCostAccounter.recordJump();
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.listIterator:()Ljava/util/ListIterator;");
        ListIterator<T> listIterator = list.listIterator();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.listIterator:()Ljava/util/ListIterator;");
        ListIterator<T> listIterator2 = list2.listIterator();
        int n4 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n4 >= n) return;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.next:()Ljava/lang/Object;");
            listIterator.next();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.next:()Ljava/lang/Object;");
            T t = listIterator2.next();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.set:(Ljava/lang/Object;)V");
            listIterator.set(t);
            ++n4;
            RuntimeCostAccounter.recordJump();
        }
    }

    public static <T> T min(Collection<? extends T> collection) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.iterator:()Ljava/util/Iterator;");
        Iterator<T> iterator = collection.iterator();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
        T t = iterator.next();
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
            boolean bl = iterator.hasNext();
            RuntimeCostAccounter.recordJump();
            if (!bl) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
            T t2 = iterator.next();
            Comparable comparable = (Comparable)t2;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Comparable.compareTo:(Ljava/lang/Object;)I");
            int n = comparable.compareTo(t);
            RuntimeCostAccounter.recordJump();
            if (n < 0) {
                t = t2;
            }
            RuntimeCostAccounter.recordJump();
        }
        return t;
    }

    public static <T> T min(Collection<? extends T> collection, Comparator<? super T> comparator) {
        RuntimeCostAccounter.recordJump();
        if (comparator == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.min:(Ljava/util/Collection;)Ljava/lang/Object;");
            return Collections.min(collection);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.iterator:()Ljava/util/Iterator;");
        Iterator<T> iterator = collection.iterator();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
        T t = iterator.next();
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
            boolean bl = iterator.hasNext();
            RuntimeCostAccounter.recordJump();
            if (!bl) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
            T t2 = iterator.next();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Comparator.compare:(Ljava/lang/Object;Ljava/lang/Object;)I");
            int n = comparator.compare(t2, t);
            RuntimeCostAccounter.recordJump();
            if (n < 0) {
                t = t2;
            }
            RuntimeCostAccounter.recordJump();
        }
        return t;
    }

    public static <T> T max(Collection<? extends T> collection) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.iterator:()Ljava/util/Iterator;");
        Iterator<T> iterator = collection.iterator();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
        T t = iterator.next();
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
            boolean bl = iterator.hasNext();
            RuntimeCostAccounter.recordJump();
            if (!bl) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
            T t2 = iterator.next();
            Comparable comparable = (Comparable)t2;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Comparable.compareTo:(Ljava/lang/Object;)I");
            int n = comparable.compareTo(t);
            RuntimeCostAccounter.recordJump();
            if (n > 0) {
                t = t2;
            }
            RuntimeCostAccounter.recordJump();
        }
        return t;
    }

    public static <T> T max(Collection<? extends T> collection, Comparator<? super T> comparator) {
        RuntimeCostAccounter.recordJump();
        if (comparator == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.max:(Ljava/util/Collection;)Ljava/lang/Object;");
            return Collections.max(collection);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.iterator:()Ljava/util/Iterator;");
        Iterator<T> iterator = collection.iterator();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
        T t = iterator.next();
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
            boolean bl = iterator.hasNext();
            RuntimeCostAccounter.recordJump();
            if (!bl) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
            T t2 = iterator.next();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Comparator.compare:(Ljava/lang/Object;Ljava/lang/Object;)I");
            int n = comparator.compare(t2, t);
            RuntimeCostAccounter.recordJump();
            if (n > 0) {
                t = t2;
            }
            RuntimeCostAccounter.recordJump();
        }
        return t;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void rotate(List<?> list, int n) {
        boolean bl = list instanceof RandomAccess;
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.size:()I");
            int n2 = list.size();
            RuntimeCostAccounter.recordJump();
            if (n2 >= 100) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.rotate2:(Ljava/util/List;I)V");
                Collections.rotate2(list, n);
                return;
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.rotate1:(Ljava/util/List;I)V");
        Collections.rotate1(list, n);
        RuntimeCostAccounter.recordJump();
    }

    private static <T> void rotate1(List<T> list, int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.size:()I");
        int n2 = list.size();
        RuntimeCostAccounter.recordJump();
        if (n2 == 0) {
            return;
        }
        RuntimeCostAccounter.recordJump();
        if ((n %= n2) < 0) {
            n += n2;
        }
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            return;
        }
        int n3 = 0;
        int n4 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n4 == n2) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.get:(I)Ljava/lang/Object;");
            T t = list.get(n3);
            int n5 = n3;
            do {
                RuntimeCostAccounter.recordJump();
                if ((n5 += n) >= n2) {
                    n5 -= n2;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.set:(ILjava/lang/Object;)Ljava/lang/Object;");
                t = list.set(n5, t);
                ++n4;
                RuntimeCostAccounter.recordJump();
            } while (n5 != n3);
            ++n3;
            RuntimeCostAccounter.recordJump();
        }
    }

    private static void rotate2(List<?> list, int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.size:()I");
        int n2 = list.size();
        RuntimeCostAccounter.recordJump();
        if (n2 == 0) {
            return;
        }
        int n3 = -n % n2;
        RuntimeCostAccounter.recordJump();
        if (n3 < 0) {
            n3 += n2;
        }
        RuntimeCostAccounter.recordJump();
        if (n3 == 0) {
            return;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.subList:(II)Ljava/util/List;");
        List<?> list2 = list.subList(0, n3);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.reverse:(Ljava/util/List;)V");
        Collections.reverse(list2);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.subList:(II)Ljava/util/List;");
        List<?> list3 = list.subList(n3, n2);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.reverse:(Ljava/util/List;)V");
        Collections.reverse(list3);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.reverse:(Ljava/util/List;)V");
        Collections.reverse(list);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static <T> boolean replaceAll(List<T> list, T t, T t2) {
        int n;
        boolean bl;
        block17: {
            block16: {
                bl = false;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.size:()I");
                n = list.size();
                RuntimeCostAccounter.recordJump();
                if (n < 11) break block16;
                boolean bl2 = list instanceof RandomAccess;
                RuntimeCostAccounter.recordJump();
                if (!bl2) break block17;
            }
            RuntimeCostAccounter.recordJump();
            if (t == null) {
                int n2 = 0;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n2 >= n) {
                        RuntimeCostAccounter.recordJump();
                        return bl;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/List.get:(I)Ljava/lang/Object;");
                    T t3 = list.get(n2);
                    RuntimeCostAccounter.recordJump();
                    if (t3 == null) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.set:(ILjava/lang/Object;)Ljava/lang/Object;");
                        list.set(n2, t2);
                        bl = true;
                    }
                    ++n2;
                    RuntimeCostAccounter.recordJump();
                }
            }
            int n3 = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n3 >= n) {
                    RuntimeCostAccounter.recordJump();
                    return bl;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.get:(I)Ljava/lang/Object;");
                T t4 = list.get(n3);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
                boolean bl3 = t.equals(t4);
                RuntimeCostAccounter.recordJump();
                if (bl3) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/List.set:(ILjava/lang/Object;)Ljava/lang/Object;");
                    list.set(n3, t2);
                    bl = true;
                }
                ++n3;
                RuntimeCostAccounter.recordJump();
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.listIterator:()Ljava/util/ListIterator;");
        ListIterator<T> listIterator = list.listIterator();
        RuntimeCostAccounter.recordJump();
        if (t == null) {
            int n4 = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n4 >= n) {
                    RuntimeCostAccounter.recordJump();
                    return bl;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.next:()Ljava/lang/Object;");
                T t5 = listIterator.next();
                RuntimeCostAccounter.recordJump();
                if (t5 == null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.set:(Ljava/lang/Object;)V");
                    listIterator.set(t2);
                    bl = true;
                }
                ++n4;
                RuntimeCostAccounter.recordJump();
            }
        }
        int n5 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n5 >= n) return bl;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.next:()Ljava/lang/Object;");
            T t6 = listIterator.next();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
            boolean bl4 = t.equals(t6);
            RuntimeCostAccounter.recordJump();
            if (bl4) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.set:(Ljava/lang/Object;)V");
                listIterator.set(t2);
                bl = true;
            }
            ++n5;
            RuntimeCostAccounter.recordJump();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int indexOfSubList(List<?> list, List<?> list2) {
        int n;
        int n2;
        block10: {
            block9: {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.size:()I");
                int n3 = list.size();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.size:()I");
                n2 = list2.size();
                n = n3 - n2;
                RuntimeCostAccounter.recordJump();
                if (n3 < 35) break block9;
                boolean bl = list instanceof RandomAccess;
                RuntimeCostAccounter.recordJump();
                if (!bl) break block10;
                boolean bl2 = list2 instanceof RandomAccess;
                RuntimeCostAccounter.recordJump();
                if (!bl2) break block10;
            }
            int n4 = 0;
            block0: while (true) {
                RuntimeCostAccounter.recordJump();
                if (n4 > n) {
                    RuntimeCostAccounter.recordJump();
                    return -1;
                }
                int n5 = 0;
                int n6 = n4;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n5 >= n2) return n4;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/List.get:(I)Ljava/lang/Object;");
                    Object obj = list2.get(n5);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/List.get:(I)Ljava/lang/Object;");
                    Object obj2 = list.get(n6);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.eq:(Ljava/lang/Object;Ljava/lang/Object;)Z");
                    boolean bl = Collections.eq(obj, obj2);
                    RuntimeCostAccounter.recordJump();
                    if (!bl) {
                        RuntimeCostAccounter.recordJump();
                        ++n4;
                        RuntimeCostAccounter.recordJump();
                        continue block0;
                    }
                    ++n5;
                    ++n6;
                    RuntimeCostAccounter.recordJump();
                }
                break;
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.listIterator:()Ljava/util/ListIterator;");
        ListIterator<?> listIterator = list.listIterator();
        int n7 = 0;
        block2: while (true) {
            RuntimeCostAccounter.recordJump();
            if (n7 > n) return -1;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.listIterator:()Ljava/util/ListIterator;");
            ListIterator<?> listIterator2 = list2.listIterator();
            int n8 = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n8 >= n2) return n7;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.next:()Ljava/lang/Object;");
                Object obj = listIterator2.next();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.next:()Ljava/lang/Object;");
                Object obj3 = listIterator.next();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.eq:(Ljava/lang/Object;Ljava/lang/Object;)Z");
                boolean bl = Collections.eq(obj, obj3);
                RuntimeCostAccounter.recordJump();
                if (!bl) {
                    int n9 = 0;
                    while (true) {
                        RuntimeCostAccounter.recordJump();
                        if (n9 >= n8) break;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.previous:()Ljava/lang/Object;");
                        listIterator.previous();
                        ++n9;
                        RuntimeCostAccounter.recordJump();
                    }
                    RuntimeCostAccounter.recordJump();
                    ++n7;
                    RuntimeCostAccounter.recordJump();
                    continue block2;
                }
                ++n8;
                RuntimeCostAccounter.recordJump();
            }
            break;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int lastIndexOfSubList(List<?> list, List<?> list2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.size:()I");
        int n = list.size();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.size:()I");
        int n2 = list2.size();
        int n3 = n - n2;
        RuntimeCostAccounter.recordJump();
        if (n >= 35) {
            boolean bl = list instanceof RandomAccess;
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                RuntimeCostAccounter.recordJump();
                if (n3 < 0) {
                    return -1;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.listIterator:(I)Ljava/util/ListIterator;");
                ListIterator<?> listIterator = list.listIterator(n3);
                int n4 = n3;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n4 < 0) return -1;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/List.listIterator:()Ljava/util/ListIterator;");
                    ListIterator<?> listIterator2 = list2.listIterator();
                    int n5 = 0;
                    while (true) {
                        RuntimeCostAccounter.recordJump();
                        if (n5 >= n2) return n4;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.next:()Ljava/lang/Object;");
                        Object obj = listIterator2.next();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.next:()Ljava/lang/Object;");
                        Object obj2 = listIterator.next();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.eq:(Ljava/lang/Object;Ljava/lang/Object;)Z");
                        boolean bl2 = Collections.eq(obj, obj2);
                        RuntimeCostAccounter.recordJump();
                        if (!bl2) {
                            RuntimeCostAccounter.recordJump();
                            if (n4 == 0) break;
                            int n6 = 0;
                            while (true) {
                                RuntimeCostAccounter.recordJump();
                                if (n6 > n5 + 1) break;
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.previous:()Ljava/lang/Object;");
                                listIterator.previous();
                                ++n6;
                                RuntimeCostAccounter.recordJump();
                            }
                            RuntimeCostAccounter.recordJump();
                            break;
                        }
                        ++n5;
                        RuntimeCostAccounter.recordJump();
                    }
                    --n4;
                    RuntimeCostAccounter.recordJump();
                }
            }
        }
        int n7 = n3;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n7 < 0) break;
            int n8 = 0;
            int n9 = n7;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n8 >= n2) return n7;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.get:(I)Ljava/lang/Object;");
                Object obj = list2.get(n8);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.get:(I)Ljava/lang/Object;");
                Object obj3 = list.get(n9);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.eq:(Ljava/lang/Object;Ljava/lang/Object;)Z");
                boolean bl = Collections.eq(obj, obj3);
                RuntimeCostAccounter.recordJump();
                if (!bl) break;
                ++n8;
                ++n9;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordJump();
            --n7;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
        return -1;
    }

    public static <T> Collection<T> unmodifiableCollection(Collection<? extends T> collection) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$UnmodifiableCollection");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableCollection.<init>:(Ljava/util/Collection;)V");
        return new UnmodifiableCollection<T>(collection);
    }

    public static <T> Set<T> unmodifiableSet(Set<? extends T> set) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$UnmodifiableSet");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableSet.<init>:(Ljava/util/Set;)V");
        return new UnmodifiableSet<T>(set);
    }

    public static <T> SortedSet<T> unmodifiableSortedSet(SortedSet<T> sortedSet) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$UnmodifiableSortedSet");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableSortedSet.<init>:(Ljava/util/SortedSet;)V");
        return new UnmodifiableSortedSet<T>(sortedSet);
    }

    public static <T> NavigableSet<T> unmodifiableNavigableSet(NavigableSet<T> navigableSet) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$UnmodifiableNavigableSet");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableNavigableSet.<init>:(Ljava/util/NavigableSet;)V");
        return new UnmodifiableNavigableSet<T>(navigableSet);
    }

    public static <T> List<T> unmodifiableList(List<? extends T> list) {
        UnmodifiableList unmodifiableList;
        boolean bl = list instanceof RandomAccess;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$UnmodifiableRandomAccessList");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableRandomAccessList.<init>:(Ljava/util/List;)V");
            unmodifiableList = new UnmodifiableRandomAccessList<T>(list);
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$UnmodifiableList");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableList.<init>:(Ljava/util/List;)V");
            unmodifiableList = new UnmodifiableList<T>(list);
        }
        return unmodifiableList;
    }

    public static <K, V> Map<K, V> unmodifiableMap(Map<? extends K, ? extends V> map) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$UnmodifiableMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableMap.<init>:(Ljava/util/Map;)V");
        return new UnmodifiableMap<K, V>(map);
    }

    public static <K, V> SortedMap<K, V> unmodifiableSortedMap(SortedMap<K, ? extends V> sortedMap) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$UnmodifiableSortedMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableSortedMap.<init>:(Ljava/util/SortedMap;)V");
        return new UnmodifiableSortedMap<K, V>(sortedMap);
    }

    public static <K, V> NavigableMap<K, V> unmodifiableNavigableMap(NavigableMap<K, ? extends V> navigableMap) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$UnmodifiableNavigableMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableNavigableMap.<init>:(Ljava/util/NavigableMap;)V");
        return new UnmodifiableNavigableMap<K, V>(navigableMap);
    }

    public static <T> Collection<T> synchronizedCollection(Collection<T> collection) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$SynchronizedCollection");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedCollection.<init>:(Ljava/util/Collection;)V");
        return new SynchronizedCollection<T>(collection);
    }

    static <T> Collection<T> synchronizedCollection(Collection<T> collection, Object object) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$SynchronizedCollection");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedCollection.<init>:(Ljava/util/Collection;Ljava/lang/Object;)V");
        return new SynchronizedCollection<T>(collection, object);
    }

    public static <T> Set<T> synchronizedSet(Set<T> set) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$SynchronizedSet");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedSet.<init>:(Ljava/util/Set;)V");
        return new SynchronizedSet<T>(set);
    }

    static <T> Set<T> synchronizedSet(Set<T> set, Object object) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$SynchronizedSet");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedSet.<init>:(Ljava/util/Set;Ljava/lang/Object;)V");
        return new SynchronizedSet<T>(set, object);
    }

    public static <T> SortedSet<T> synchronizedSortedSet(SortedSet<T> sortedSet) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$SynchronizedSortedSet");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedSortedSet.<init>:(Ljava/util/SortedSet;)V");
        return new SynchronizedSortedSet<T>(sortedSet);
    }

    public static <T> NavigableSet<T> synchronizedNavigableSet(NavigableSet<T> navigableSet) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$SynchronizedNavigableSet");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedNavigableSet.<init>:(Ljava/util/NavigableSet;)V");
        return new SynchronizedNavigableSet<T>(navigableSet);
    }

    public static <T> List<T> synchronizedList(List<T> list) {
        SynchronizedList synchronizedList;
        boolean bl = list instanceof RandomAccess;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$SynchronizedRandomAccessList");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedRandomAccessList.<init>:(Ljava/util/List;)V");
            synchronizedList = new SynchronizedRandomAccessList<T>(list);
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$SynchronizedList");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedList.<init>:(Ljava/util/List;)V");
            synchronizedList = new SynchronizedList<T>(list);
        }
        return synchronizedList;
    }

    static <T> List<T> synchronizedList(List<T> list, Object object) {
        SynchronizedList synchronizedList;
        boolean bl = list instanceof RandomAccess;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$SynchronizedRandomAccessList");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedRandomAccessList.<init>:(Ljava/util/List;Ljava/lang/Object;)V");
            synchronizedList = new SynchronizedRandomAccessList<T>(list, object);
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$SynchronizedList");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedList.<init>:(Ljava/util/List;Ljava/lang/Object;)V");
            synchronizedList = new SynchronizedList<T>(list, object);
        }
        return synchronizedList;
    }

    public static <K, V> Map<K, V> synchronizedMap(Map<K, V> map) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$SynchronizedMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedMap.<init>:(Ljava/util/Map;)V");
        return new SynchronizedMap<K, V>(map);
    }

    public static <K, V> SortedMap<K, V> synchronizedSortedMap(SortedMap<K, V> sortedMap) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$SynchronizedSortedMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedSortedMap.<init>:(Ljava/util/SortedMap;)V");
        return new SynchronizedSortedMap<K, V>(sortedMap);
    }

    public static <K, V> NavigableMap<K, V> synchronizedNavigableMap(NavigableMap<K, V> navigableMap) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$SynchronizedNavigableMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedNavigableMap.<init>:(Ljava/util/NavigableMap;)V");
        return new SynchronizedNavigableMap<K, V>(navigableMap);
    }

    public static <E> Collection<E> checkedCollection(Collection<E> collection, Class<E> clazz) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$CheckedCollection");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedCollection.<init>:(Ljava/util/Collection;Ljava/lang/Class;)V");
        return new CheckedCollection<E>(collection, clazz);
    }

    static <T> T[] zeroLengthArray(Class<T> clazz) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/reflect/Array.newInstance:(Ljava/lang/Class;I)Ljava/lang/Object;");
        return (Object[])Array.newInstance(clazz, 0);
    }

    public static <E> Queue<E> checkedQueue(Queue<E> queue, Class<E> clazz) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$CheckedQueue");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedQueue.<init>:(Ljava/util/Queue;Ljava/lang/Class;)V");
        return new CheckedQueue<E>(queue, clazz);
    }

    public static <E> Set<E> checkedSet(Set<E> set, Class<E> clazz) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$CheckedSet");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedSet.<init>:(Ljava/util/Set;Ljava/lang/Class;)V");
        return new CheckedSet<E>(set, clazz);
    }

    public static <E> SortedSet<E> checkedSortedSet(SortedSet<E> sortedSet, Class<E> clazz) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$CheckedSortedSet");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedSortedSet.<init>:(Ljava/util/SortedSet;Ljava/lang/Class;)V");
        return new CheckedSortedSet<E>(sortedSet, clazz);
    }

    public static <E> NavigableSet<E> checkedNavigableSet(NavigableSet<E> navigableSet, Class<E> clazz) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$CheckedNavigableSet");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedNavigableSet.<init>:(Ljava/util/NavigableSet;Ljava/lang/Class;)V");
        return new CheckedNavigableSet<E>(navigableSet, clazz);
    }

    public static <E> List<E> checkedList(List<E> list, Class<E> clazz) {
        CheckedList checkedList;
        boolean bl = list instanceof RandomAccess;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$CheckedRandomAccessList");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedRandomAccessList.<init>:(Ljava/util/List;Ljava/lang/Class;)V");
            checkedList = new CheckedRandomAccessList<E>(list, clazz);
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$CheckedList");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedList.<init>:(Ljava/util/List;Ljava/lang/Class;)V");
            checkedList = new CheckedList<E>(list, clazz);
        }
        return checkedList;
    }

    public static <K, V> Map<K, V> checkedMap(Map<K, V> map, Class<K> clazz, Class<V> clazz2) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$CheckedMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedMap.<init>:(Ljava/util/Map;Ljava/lang/Class;Ljava/lang/Class;)V");
        return new CheckedMap<K, V>(map, clazz, clazz2);
    }

    public static <K, V> SortedMap<K, V> checkedSortedMap(SortedMap<K, V> sortedMap, Class<K> clazz, Class<V> clazz2) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$CheckedSortedMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedSortedMap.<init>:(Ljava/util/SortedMap;Ljava/lang/Class;Ljava/lang/Class;)V");
        return new CheckedSortedMap<K, V>(sortedMap, clazz, clazz2);
    }

    public static <K, V> NavigableMap<K, V> checkedNavigableMap(NavigableMap<K, V> navigableMap, Class<K> clazz, Class<V> clazz2) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$CheckedNavigableMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedNavigableMap.<init>:(Ljava/util/NavigableMap;Ljava/lang/Class;Ljava/lang/Class;)V");
        return new CheckedNavigableMap<K, V>(navigableMap, clazz, clazz2);
    }

    public static <T> Iterator<T> emptyIterator() {
        return EmptyIterator.EMPTY_ITERATOR;
    }

    public static <T> ListIterator<T> emptyListIterator() {
        return EmptyListIterator.EMPTY_ITERATOR;
    }

    public static <T> Enumeration<T> emptyEnumeration() {
        return EmptyEnumeration.EMPTY_ENUMERATION;
    }

    public static final <T> Set<T> emptySet() {
        return EMPTY_SET;
    }

    public static <E> SortedSet<E> emptySortedSet() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableNavigableSet.access$000:()Ljava/util/NavigableSet;");
        return UnmodifiableNavigableSet.EMPTY_NAVIGABLE_SET;
    }

    public static <E> NavigableSet<E> emptyNavigableSet() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableNavigableSet.access$000:()Ljava/util/NavigableSet;");
        return UnmodifiableNavigableSet.EMPTY_NAVIGABLE_SET;
    }

    public static final <T> List<T> emptyList() {
        return EMPTY_LIST;
    }

    public static final <K, V> Map<K, V> emptyMap() {
        return EMPTY_MAP;
    }

    public static final <K, V> SortedMap<K, V> emptySortedMap() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableNavigableMap.access$100:()Ljava/util/Collections$UnmodifiableNavigableMap$EmptyNavigableMap;");
        return UnmodifiableNavigableMap.EMPTY_NAVIGABLE_MAP;
    }

    public static final <K, V> NavigableMap<K, V> emptyNavigableMap() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableNavigableMap.access$100:()Ljava/util/Collections$UnmodifiableNavigableMap$EmptyNavigableMap;");
        return UnmodifiableNavigableMap.EMPTY_NAVIGABLE_MAP;
    }

    public static <T> Set<T> singleton(T t) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$SingletonSet");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SingletonSet.<init>:(Ljava/lang/Object;)V");
        return new SingletonSet<T>(t);
    }

    static <E> Iterator<E> singletonIterator(final E e) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$1");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$1.<init>:(Ljava/lang/Object;)V");
        return new Iterator<E>(){
            private boolean hasNext;
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                this.hasNext = true;
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public E next() {
                RuntimeCostAccounter.recordJump();
                if (this.hasNext) {
                    this.hasNext = false;
                    return e;
                }
                RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
                NoSuchElementException noSuchElementException = new NoSuchElementException();
                RuntimeCostAccounter.recordThrow();
                throw noSuchElementException;
            }

            @Override
            public void remove() {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
                UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
                RuntimeCostAccounter.recordThrow();
                throw unsupportedOperationException;
            }

            @Override
            public void forEachRemaining(Consumer<? super E> consumer) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
                Objects.requireNonNull(consumer);
                RuntimeCostAccounter.recordJump();
                if (this.hasNext) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
                    consumer.accept(e);
                    this.hasNext = false;
                }
            }
        };
    }

    static <T> Spliterator<T> singletonSpliterator(final T t) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$2");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$2.<init>:(Ljava/lang/Object;)V");
        return new Spliterator<T>(){
            long est;
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                this.est = 1L;
            }

            @Override
            public Spliterator<T> trySplit() {
                return null;
            }

            @Override
            public boolean tryAdvance(Consumer<? super T> consumer) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
                Objects.requireNonNull(consumer);
                RuntimeCostAccounter.recordJump();
                if (this.est > 0L) {
                    --this.est;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
                    consumer.accept(t);
                    return true;
                }
                return false;
            }

            @Override
            public void forEachRemaining(Consumer<? super T> consumer) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$2.tryAdvance:(Ljava/util/function/Consumer;)Z");
                this.tryAdvance(consumer);
            }

            @Override
            public long estimateSize() {
                return this.est;
            }

            @Override
            public int characteristics() {
                int n;
                RuntimeCostAccounter.recordJump();
                if (t != null) {
                    n = 256;
                    RuntimeCostAccounter.recordJump();
                } else {
                    n = 0;
                }
                int n2 = n;
                return n2 | 0x40 | 0x4000 | 0x400 | 1 | 0x10;
            }
        };
    }

    public static <T> List<T> singletonList(T t) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$SingletonList");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SingletonList.<init>:(Ljava/lang/Object;)V");
        return new SingletonList<T>(t);
    }

    public static <K, V> Map<K, V> singletonMap(K k, V v) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$SingletonMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SingletonMap.<init>:(Ljava/lang/Object;Ljava/lang/Object;)V");
        return new SingletonMap<K, V>(k, v);
    }

    public static <T> List<T> nCopies(int n, T t) {
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("List length = ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$CopiesList");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CopiesList.<init>:(ILjava/lang/Object;)V");
        return new CopiesList<T>(n, t);
    }

    public static <T> Comparator<T> reverseOrder() {
        return ReverseComparator.REVERSE_ORDER;
    }

    public static <T> Comparator<T> reverseOrder(Comparator<T> comparator) {
        RuntimeCostAccounter.recordJump();
        if (comparator == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.reverseOrder:()Ljava/util/Comparator;");
            return Collections.reverseOrder();
        }
        boolean bl = comparator instanceof ReverseComparator2;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return ((ReverseComparator2)comparator).cmp;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$ReverseComparator2");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$ReverseComparator2.<init>:(Ljava/util/Comparator;)V");
        return new ReverseComparator2<T>(comparator);
    }

    public static <T> Enumeration<T> enumeration(final Collection<T> collection) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$3");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$3.<init>:(Ljava/util/Collection;)V");
        return new Enumeration<T>(){
            private final Iterator<T> i;
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.iterator:()Ljava/util/Iterator;");
                this.i = collection.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                return this.i.hasNext();
            }

            @Override
            public T nextElement() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                return this.i.next();
            }
        };
    }

    public static <T> ArrayList<T> list(Enumeration<T> enumeration) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.<init>:()V");
        ArrayList<T> arrayList = new ArrayList<T>();
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Enumeration.hasMoreElements:()Z");
            boolean bl = enumeration.hasMoreElements();
            RuntimeCostAccounter.recordJump();
            if (!bl) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Enumeration.nextElement:()Ljava/lang/Object;");
            T t = enumeration.nextElement();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.add:(Ljava/lang/Object;)Z");
            arrayList.add(t);
            RuntimeCostAccounter.recordJump();
        }
        return arrayList;
    }

    static boolean eq(Object object, Object object2) {
        boolean bl;
        RuntimeCostAccounter.recordJump();
        if (object == null) {
            RuntimeCostAccounter.recordJump();
            if (object2 == null) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
                RuntimeCostAccounter.recordJump();
            }
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
            bl = object.equals(object2);
        }
        return bl;
    }

    public static int frequency(Collection<?> collection, Object object) {
        int n = 0;
        RuntimeCostAccounter.recordJump();
        if (object == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.iterator:()Ljava/util/Iterator;");
            Iterator<?> iterator = collection.iterator();
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                boolean bl = iterator.hasNext();
                RuntimeCostAccounter.recordJump();
                if (!bl) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                Object obj = iterator.next();
                RuntimeCostAccounter.recordJump();
                if (obj == null) {
                    ++n;
                }
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.iterator:()Ljava/util/Iterator;");
            Iterator<?> iterator = collection.iterator();
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                boolean bl = iterator.hasNext();
                RuntimeCostAccounter.recordJump();
                if (!bl) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                Object obj = iterator.next();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
                boolean bl2 = object.equals(obj);
                RuntimeCostAccounter.recordJump();
                if (bl2) {
                    ++n;
                }
                RuntimeCostAccounter.recordJump();
            }
        }
        return n;
    }

    public static boolean disjoint(Collection<?> collection, Collection<?> collection2) {
        Collection<?> collection3;
        Collection<?> collection4;
        block7: {
            int n;
            int n2;
            block9: {
                block8: {
                    block6: {
                        collection4 = collection2;
                        collection3 = collection;
                        boolean bl = collection instanceof Set;
                        RuntimeCostAccounter.recordJump();
                        if (!bl) break block6;
                        collection3 = collection2;
                        collection4 = collection;
                        RuntimeCostAccounter.recordJump();
                        break block7;
                    }
                    boolean bl = collection2 instanceof Set;
                    RuntimeCostAccounter.recordJump();
                    if (bl) break block7;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.size:()I");
                    n2 = collection.size();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.size:()I");
                    n = collection2.size();
                    RuntimeCostAccounter.recordJump();
                    if (n2 == 0) break block8;
                    RuntimeCostAccounter.recordJump();
                    if (n != 0) break block9;
                }
                return true;
            }
            RuntimeCostAccounter.recordJump();
            if (n2 > n) {
                collection3 = collection2;
                collection4 = collection;
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.iterator:()Ljava/util/Iterator;");
        Iterator<?> iterator = collection3.iterator();
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
            boolean bl = iterator.hasNext();
            RuntimeCostAccounter.recordJump();
            if (!bl) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
            Object obj = iterator.next();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.contains:(Ljava/lang/Object;)Z");
            boolean bl2 = collection4.contains(obj);
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                return false;
            }
            RuntimeCostAccounter.recordJump();
        }
        return true;
    }

    @SafeVarargs
    public static <T> boolean addAll(Collection<? super T> collection, T ... TArray) {
        boolean bl = false;
        T[] TArray2 = TArray;
        int n = TArray2.length;
        int n2 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n2 >= n) break;
            T t = TArray2[n2];
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.add:(Ljava/lang/Object;)Z");
            bl |= collection.add(t);
            ++n2;
            RuntimeCostAccounter.recordJump();
        }
        return bl;
    }

    public static <E> Set<E> newSetFromMap(Map<E, Boolean> map) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$SetFromMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SetFromMap.<init>:(Ljava/util/Map;)V");
        return new SetFromMap<E>(map);
    }

    public static <T> Queue<T> asLifoQueue(Deque<T> deque) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$AsLIFOQueue");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$AsLIFOQueue.<init>:(Ljava/util/Deque;)V");
        return new AsLIFOQueue<T>(deque);
    }

    static {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$EmptySet");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$EmptySet.<init>:(Ljava/util/Collections$1;)V");
        EMPTY_SET = new EmptySet(null);
        RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$EmptyList");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$EmptyList.<init>:(Ljava/util/Collections$1;)V");
        EMPTY_LIST = new EmptyList(null);
        RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$EmptyMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$EmptyMap.<init>:(Ljava/util/Collections$1;)V");
        EMPTY_MAP = new EmptyMap(null);
    }

    static class AsLIFOQueue<E>
    extends AbstractQueue<E>
    implements Queue<E>,
    Serializable {
        private static final long serialVersionUID = 1802017725587941708L;
        private final Deque<E> q;

        AsLIFOQueue(Deque<E> deque) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractQueue.<init>:()V");
            this.q = deque;
        }

        @Override
        public boolean add(E e) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Deque.addFirst:(Ljava/lang/Object;)V");
            this.q.addFirst(e);
            return true;
        }

        @Override
        public boolean offer(E e) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Deque.offerFirst:(Ljava/lang/Object;)Z");
            return this.q.offerFirst(e);
        }

        @Override
        public E poll() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Deque.pollFirst:()Ljava/lang/Object;");
            return this.q.pollFirst();
        }

        @Override
        public E remove() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Deque.removeFirst:()Ljava/lang/Object;");
            return this.q.removeFirst();
        }

        @Override
        public E peek() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Deque.peekFirst:()Ljava/lang/Object;");
            return this.q.peekFirst();
        }

        @Override
        public E element() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Deque.getFirst:()Ljava/lang/Object;");
            return this.q.getFirst();
        }

        @Override
        public void clear() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Deque.clear:()V");
            this.q.clear();
        }

        @Override
        public int size() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Deque.size:()I");
            return this.q.size();
        }

        @Override
        public boolean isEmpty() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Deque.isEmpty:()Z");
            return this.q.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Deque.contains:(Ljava/lang/Object;)Z");
            return this.q.contains(object);
        }

        @Override
        public boolean remove(Object object) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Deque.remove:(Ljava/lang/Object;)Z");
            return this.q.remove(object);
        }

        @Override
        public Iterator<E> iterator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Deque.iterator:()Ljava/util/Iterator;");
            return this.q.iterator();
        }

        @Override
        public Object[] toArray() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Deque.toArray:()[Ljava/lang/Object;");
            return this.q.toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Deque.toArray:([Ljava/lang/Object;)[Ljava/lang/Object;");
            return this.q.toArray(TArray);
        }

        @Override
        public String toString() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.toString:()Ljava/lang/String;");
            return this.q.toString();
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Deque.containsAll:(Ljava/util/Collection;)Z");
            return this.q.containsAll(collection);
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Deque.removeAll:(Ljava/util/Collection;)Z");
            return this.q.removeAll(collection);
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Deque.retainAll:(Ljava/util/Collection;)Z");
            return this.q.retainAll(collection);
        }

        @Override
        public void forEach(Consumer<? super E> consumer) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Deque.forEach:(Ljava/util/function/Consumer;)V");
            this.q.forEach(consumer);
        }

        @Override
        public boolean removeIf(Predicate<? super E> predicate) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Deque.removeIf:(Ljava/util/function/Predicate;)Z");
            return this.q.removeIf(predicate);
        }

        @Override
        public Spliterator<E> spliterator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Deque.spliterator:()Ljava/util/Spliterator;");
            return this.q.spliterator();
        }

        @Override
        public Stream<E> stream() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Deque.stream:()Ljava/util/stream/Stream;");
            return this.q.stream();
        }

        @Override
        public Stream<E> parallelStream() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Deque.parallelStream:()Ljava/util/stream/Stream;");
            return this.q.parallelStream();
        }
    }

    private static class SetFromMap<E>
    extends AbstractSet<E>
    implements Set<E>,
    Serializable {
        private final Map<E, Boolean> m;
        private transient Set<E> s;
        private static final long serialVersionUID = 2454657854757543876L;

        SetFromMap(Map<E, Boolean> map) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractSet.<init>:()V");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.isEmpty:()Z");
            boolean bl = map.isEmpty();
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Map is non-empty");
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            this.m = map;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.keySet:()Ljava/util/Set;");
            this.s = map.keySet();
        }

        @Override
        public void clear() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.clear:()V");
            this.m.clear();
        }

        @Override
        public int size() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.size:()I");
            return this.m.size();
        }

        @Override
        public boolean isEmpty() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.isEmpty:()Z");
            return this.m.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
            return this.m.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            boolean bl;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            Boolean bl2 = this.m.remove(object);
            RuntimeCostAccounter.recordJump();
            if (bl2 != null) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public boolean add(E e) {
            boolean bl;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            Boolean bl2 = this.m.put(e, Boolean.TRUE);
            RuntimeCostAccounter.recordJump();
            if (bl2 == null) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public Iterator<E> iterator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.iterator:()Ljava/util/Iterator;");
            return this.s.iterator();
        }

        @Override
        public Object[] toArray() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.toArray:()[Ljava/lang/Object;");
            return this.s.toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.toArray:([Ljava/lang/Object;)[Ljava/lang/Object;");
            return this.s.toArray(TArray);
        }

        @Override
        public String toString() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.toString:()Ljava/lang/String;");
            return this.s.toString();
        }

        @Override
        public int hashCode() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.hashCode:()I");
            return this.s.hashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object object) {
            RuntimeCostAccounter.recordJump();
            if (object != this) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.equals:(Ljava/lang/Object;)Z");
                boolean bl = this.s.equals(object);
                RuntimeCostAccounter.recordJump();
                if (!bl) return false;
            }
            boolean bl = true;
            RuntimeCostAccounter.recordJump();
            return bl;
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.containsAll:(Ljava/util/Collection;)Z");
            return this.s.containsAll(collection);
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.removeAll:(Ljava/util/Collection;)Z");
            return this.s.removeAll(collection);
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.retainAll:(Ljava/util/Collection;)Z");
            return this.s.retainAll(collection);
        }

        @Override
        public void forEach(Consumer<? super E> consumer) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.forEach:(Ljava/util/function/Consumer;)V");
            this.s.forEach(consumer);
        }

        @Override
        public boolean removeIf(Predicate<? super E> predicate) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.removeIf:(Ljava/util/function/Predicate;)Z");
            return this.s.removeIf(predicate);
        }

        @Override
        public Spliterator<E> spliterator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.spliterator:()Ljava/util/Spliterator;");
            return this.s.spliterator();
        }

        @Override
        public Stream<E> stream() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.stream:()Ljava/util/stream/Stream;");
            return this.s.stream();
        }

        @Override
        public Stream<E> parallelStream() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.parallelStream:()Ljava/util/stream/Stream;");
            return this.s.parallelStream();
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.defaultReadObject:()V");
            objectInputStream.defaultReadObject();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.keySet:()Ljava/util/Set;");
            this.s = this.m.keySet();
        }
    }

    private static class ReverseComparator2<T>
    implements Comparator<T>,
    Serializable {
        private static final long serialVersionUID = 4374092139857L;
        final Comparator<T> cmp;
        static final /* synthetic */ boolean $assertionsDisabled;

        ReverseComparator2(Comparator<T> comparator) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            RuntimeCostAccounter.recordJump();
            if (!$assertionsDisabled) {
                RuntimeCostAccounter.recordJump();
                if (comparator == null) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:()V");
                    AssertionError assertionError = new AssertionError();
                    RuntimeCostAccounter.recordThrow();
                    throw assertionError;
                }
            }
            this.cmp = comparator;
        }

        @Override
        public int compare(T t, T t2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Comparator.compare:(Ljava/lang/Object;Ljava/lang/Object;)I");
            return this.cmp.compare(t2, t);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object object) {
            RuntimeCostAccounter.recordJump();
            if (object != this) {
                boolean bl = object instanceof ReverseComparator2;
                RuntimeCostAccounter.recordJump();
                if (!bl) return false;
                Comparator<T> comparator = ((ReverseComparator2)object).cmp;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Comparator.equals:(Ljava/lang/Object;)Z");
                boolean bl2 = this.cmp.equals(comparator);
                RuntimeCostAccounter.recordJump();
                if (!bl2) return false;
            }
            boolean bl = true;
            RuntimeCostAccounter.recordJump();
            return bl;
        }

        public int hashCode() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.hashCode:()I");
            return this.cmp.hashCode() ^ Integer.MIN_VALUE;
        }

        @Override
        public Comparator<T> reversed() {
            return this.cmp;
        }

        static {
            boolean bl;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.desiredAssertionStatus:()Z");
            boolean bl2 = Collections.class.desiredAssertionStatus();
            RuntimeCostAccounter.recordJump();
            if (!bl2) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            $assertionsDisabled = bl;
        }
    }

    private static class ReverseComparator
    implements Comparator<Comparable<Object>>,
    Serializable {
        private static final long serialVersionUID = 7207038068494060240L;
        static final ReverseComparator REVERSE_ORDER;

        private ReverseComparator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        }

        @Override
        public int compare(Comparable<Object> comparable, Comparable<Object> comparable2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Comparable.compareTo:(Ljava/lang/Object;)I");
            return comparable2.compareTo(comparable);
        }

        private Object readResolve() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.reverseOrder:()Ljava/util/Comparator;");
            return Collections.reverseOrder();
        }

        @Override
        public Comparator<Comparable<Object>> reversed() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Comparator.naturalOrder:()Ljava/util/Comparator;");
            return Comparator.naturalOrder();
        }

        static {
            RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$ReverseComparator");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$ReverseComparator.<init>:()V");
            REVERSE_ORDER = new ReverseComparator();
        }
    }

    private static class CopiesList<E>
    extends AbstractList<E>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 2739099268398711800L;
        final int n;
        final E element;
        static final /* synthetic */ boolean $assertionsDisabled;

        CopiesList(int n, E e) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractList.<init>:()V");
            RuntimeCostAccounter.recordJump();
            if (!$assertionsDisabled) {
                RuntimeCostAccounter.recordJump();
                if (n < 0) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:()V");
                    AssertionError assertionError = new AssertionError();
                    RuntimeCostAccounter.recordThrow();
                    throw assertionError;
                }
            }
            this.n = n;
            this.element = e;
        }

        @Override
        public int size() {
            return this.n;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean contains(Object object) {
            RuntimeCostAccounter.recordJump();
            if (this.n == 0) return false;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.eq:(Ljava/lang/Object;Ljava/lang/Object;)Z");
            boolean bl = Collections.eq(object, this.element);
            RuntimeCostAccounter.recordJump();
            if (!bl) return false;
            boolean bl2 = true;
            RuntimeCostAccounter.recordJump();
            return bl2;
        }

        @Override
        public int indexOf(Object object) {
            int n;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CopiesList.contains:(Ljava/lang/Object;)Z");
            boolean bl = this.contains(object);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                n = 0;
                RuntimeCostAccounter.recordJump();
            } else {
                n = -1;
            }
            return n;
        }

        @Override
        public int lastIndexOf(Object object) {
            int n;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CopiesList.contains:(Ljava/lang/Object;)Z");
            boolean bl = this.contains(object);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                n = this.n - 1;
                RuntimeCostAccounter.recordJump();
            } else {
                n = -1;
            }
            return n;
        }

        @Override
        public E get(int n) {
            block3: {
                block2: {
                    RuntimeCostAccounter.recordJump();
                    if (n < 0) break block2;
                    RuntimeCostAccounter.recordJump();
                    if (n < this.n) break block3;
                }
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder2 = stringBuilder.append("Index: ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder3 = stringBuilder2.append(n);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder4 = stringBuilder3.append(", Size: ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder5 = stringBuilder4.append(this.n);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string = stringBuilder5.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:(Ljava/lang/String;)V");
                IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(string);
                RuntimeCostAccounter.recordThrow();
                throw indexOutOfBoundsException;
            }
            return this.element;
        }

        @Override
        public Object[] toArray() {
            int n = this.n;
            RuntimeCostAccounter.recordArrayAllocation((int)n, (int)8);
            Object[] objectArray = new Object[n];
            RuntimeCostAccounter.recordJump();
            if (this.element != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.fill:([Ljava/lang/Object;IILjava/lang/Object;)V");
                Arrays.fill(objectArray, 0, this.n, this.element);
            }
            return objectArray;
        }

        @Override
        public <T> T[] toArray(T[] objectArray) {
            int n = this.n;
            int n2 = objectArray.length;
            RuntimeCostAccounter.recordJump();
            if (n2 < n) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
                Class<?> clazz = objectArray.getClass();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getComponentType:()Ljava/lang/Class;");
                Class<?> clazz2 = clazz.getComponentType();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/reflect/Array.newInstance:(Ljava/lang/Class;I)Ljava/lang/Object;");
                objectArray = (Object[])Array.newInstance(clazz2, n);
                RuntimeCostAccounter.recordJump();
                if (this.element != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.fill:([Ljava/lang/Object;IILjava/lang/Object;)V");
                    Arrays.fill(objectArray, 0, n, this.element);
                    RuntimeCostAccounter.recordJump();
                }
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.fill:([Ljava/lang/Object;IILjava/lang/Object;)V");
                Arrays.fill(objectArray, 0, n, this.element);
                int n3 = objectArray.length;
                RuntimeCostAccounter.recordJump();
                if (n3 > n) {
                    objectArray[n] = null;
                }
            }
            return objectArray;
        }

        @Override
        public List<E> subList(int n, int n2) {
            RuntimeCostAccounter.recordJump();
            if (n < 0) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder2 = stringBuilder.append("fromIndex = ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder3 = stringBuilder2.append(n);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string = stringBuilder3.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:(Ljava/lang/String;)V");
                IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(string);
                RuntimeCostAccounter.recordThrow();
                throw indexOutOfBoundsException;
            }
            RuntimeCostAccounter.recordJump();
            if (n2 > this.n) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder4 = stringBuilder.append("toIndex = ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder5 = stringBuilder4.append(n2);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string = stringBuilder5.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:(Ljava/lang/String;)V");
                IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(string);
                RuntimeCostAccounter.recordThrow();
                throw indexOutOfBoundsException;
            }
            RuntimeCostAccounter.recordJump();
            if (n > n2) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder6 = stringBuilder.append("fromIndex(");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder7 = stringBuilder6.append(n);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder8 = stringBuilder7.append(") > toIndex(");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder9 = stringBuilder8.append(n2);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder10 = stringBuilder9.append(")");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string = stringBuilder10.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$CopiesList");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CopiesList.<init>:(ILjava/lang/Object;)V");
            return new CopiesList<E>(n2 - n, this.element);
        }

        @Override
        public Stream<E> stream() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/IntStream.range:(II)Ljava/util/stream/IntStream;");
            IntStream intStream = IntStream.range(0, this.n);
            IntFunction<Object> intFunction = n -> this.element;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/IntStream.mapToObj:(Ljava/util/function/IntFunction;)Ljava/util/stream/Stream;");
            return intStream.mapToObj(intFunction);
        }

        @Override
        public Stream<E> parallelStream() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/IntStream.range:(II)Ljava/util/stream/IntStream;");
            IntStream intStream = IntStream.range(0, this.n);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/IntStream.parallel:()Ljava/util/stream/IntStream;");
            IntStream intStream2 = intStream.parallel();
            IntFunction<Object> intFunction = n -> this.element;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/IntStream.mapToObj:(Ljava/util/function/IntFunction;)Ljava/util/stream/Stream;");
            return intStream2.mapToObj(intFunction);
        }

        @Override
        public Spliterator<E> spliterator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CopiesList.stream:()Ljava/util/stream/Stream;");
            Stream<E> stream = this.stream();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Stream.spliterator:()Ljava/util/Spliterator;");
            return stream.spliterator();
        }

        static {
            boolean bl;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.desiredAssertionStatus:()Z");
            boolean bl2 = Collections.class.desiredAssertionStatus();
            RuntimeCostAccounter.recordJump();
            if (!bl2) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            $assertionsDisabled = bl;
        }
    }

    private static class SingletonMap<K, V>
    extends AbstractMap<K, V>
    implements Serializable {
        private static final long serialVersionUID = -6979724477215052911L;
        private final K k;
        private final V v;
        private transient Set<K> keySet;
        private transient Set<Map.Entry<K, V>> entrySet;
        private transient Collection<V> values;

        SingletonMap(K k, V v) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractMap.<init>:()V");
            this.k = k;
            this.v = v;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean containsKey(Object object) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.eq:(Ljava/lang/Object;Ljava/lang/Object;)Z");
            return Collections.eq(object, this.k);
        }

        @Override
        public boolean containsValue(Object object) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.eq:(Ljava/lang/Object;Ljava/lang/Object;)Z");
            return Collections.eq(object, this.v);
        }

        @Override
        public V get(Object object) {
            V v;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.eq:(Ljava/lang/Object;Ljava/lang/Object;)Z");
            boolean bl = Collections.eq(object, this.k);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                v = this.v;
                RuntimeCostAccounter.recordJump();
            } else {
                v = null;
            }
            return v;
        }

        @Override
        public Set<K> keySet() {
            RuntimeCostAccounter.recordJump();
            if (this.keySet == null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.singleton:(Ljava/lang/Object;)Ljava/util/Set;");
                this.keySet = Collections.singleton(this.k);
            }
            return this.keySet;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            RuntimeCostAccounter.recordJump();
            if (this.entrySet == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/AbstractMap$SimpleImmutableEntry");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractMap$SimpleImmutableEntry.<init>:(Ljava/lang/Object;Ljava/lang/Object;)V");
                AbstractMap.SimpleImmutableEntry<K, V> simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry<K, V>(this.k, this.v);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.singleton:(Ljava/lang/Object;)Ljava/util/Set;");
                this.entrySet = Collections.singleton(simpleImmutableEntry);
            }
            return this.entrySet;
        }

        @Override
        public Collection<V> values() {
            RuntimeCostAccounter.recordJump();
            if (this.values == null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.singleton:(Ljava/lang/Object;)Ljava/util/Set;");
                this.values = Collections.singleton(this.v);
            }
            return this.values;
        }

        @Override
        public V getOrDefault(Object object, V v) {
            V v2;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.eq:(Ljava/lang/Object;Ljava/lang/Object;)Z");
            boolean bl = Collections.eq(object, this.k);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                v2 = this.v;
                RuntimeCostAccounter.recordJump();
            } else {
                v2 = v;
            }
            return v2;
        }

        @Override
        public void forEach(BiConsumer<? super K, ? super V> biConsumer) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BiConsumer.accept:(Ljava/lang/Object;Ljava/lang/Object;)V");
            biConsumer.accept(this.k, this.v);
        }

        @Override
        public void replaceAll(BiFunction<? super K, ? super V, ? extends V> biFunction) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }

        @Override
        public V putIfAbsent(K k, V v) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }

        @Override
        public boolean remove(Object object, Object object2) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }

        @Override
        public boolean replace(K k, V v, V v2) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }

        @Override
        public V replace(K k, V v) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }

        @Override
        public V computeIfAbsent(K k, Function<? super K, ? extends V> function) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }

        @Override
        public V computeIfPresent(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }

        @Override
        public V compute(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }

        @Override
        public V merge(K k, V v, BiFunction<? super V, ? super V, ? extends V> biFunction) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }
    }

    private static class SingletonList<E>
    extends AbstractList<E>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 3093736618740652951L;
        private final E element;

        SingletonList(E e) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractList.<init>:()V");
            this.element = e;
        }

        @Override
        public Iterator<E> iterator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.singletonIterator:(Ljava/lang/Object;)Ljava/util/Iterator;");
            return Collections.singletonIterator(this.element);
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean contains(Object object) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.eq:(Ljava/lang/Object;Ljava/lang/Object;)Z");
            return Collections.eq(object, this.element);
        }

        @Override
        public E get(int n) {
            RuntimeCostAccounter.recordJump();
            if (n != 0) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder2 = stringBuilder.append("Index: ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder3 = stringBuilder2.append(n);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder4 = stringBuilder3.append(", Size: 1");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string = stringBuilder4.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:(Ljava/lang/String;)V");
                IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(string);
                RuntimeCostAccounter.recordThrow();
                throw indexOutOfBoundsException;
            }
            return this.element;
        }

        @Override
        public void forEach(Consumer<? super E> consumer) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
            consumer.accept(this.element);
        }

        @Override
        public boolean removeIf(Predicate<? super E> predicate) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }

        @Override
        public void replaceAll(UnaryOperator<E> unaryOperator) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }

        @Override
        public void sort(Comparator<? super E> comparator) {
        }

        @Override
        public Spliterator<E> spliterator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.singletonSpliterator:(Ljava/lang/Object;)Ljava/util/Spliterator;");
            return Collections.singletonSpliterator(this.element);
        }
    }

    private static class SingletonSet<E>
    extends AbstractSet<E>
    implements Serializable {
        private static final long serialVersionUID = 3193687207550431679L;
        private final E element;

        SingletonSet(E e) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractSet.<init>:()V");
            this.element = e;
        }

        @Override
        public Iterator<E> iterator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.singletonIterator:(Ljava/lang/Object;)Ljava/util/Iterator;");
            return Collections.singletonIterator(this.element);
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean contains(Object object) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.eq:(Ljava/lang/Object;Ljava/lang/Object;)Z");
            return Collections.eq(object, this.element);
        }

        @Override
        public void forEach(Consumer<? super E> consumer) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
            consumer.accept(this.element);
        }

        @Override
        public Spliterator<E> spliterator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.singletonSpliterator:(Ljava/lang/Object;)Ljava/util/Spliterator;");
            return Collections.singletonSpliterator(this.element);
        }

        @Override
        public boolean removeIf(Predicate<? super E> predicate) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }
    }

    private static class EmptyMap<K, V>
    extends AbstractMap<K, V>
    implements Serializable {
        private static final long serialVersionUID = 6428348081105594320L;

        private EmptyMap() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractMap.<init>:()V");
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean containsKey(Object object) {
            return false;
        }

        @Override
        public boolean containsValue(Object object) {
            return false;
        }

        @Override
        public V get(Object object) {
            return null;
        }

        @Override
        public Set<K> keySet() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.emptySet:()Ljava/util/Set;");
            return Collections.emptySet();
        }

        @Override
        public Collection<V> values() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.emptySet:()Ljava/util/Set;");
            return Collections.emptySet();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.emptySet:()Ljava/util/Set;");
            return Collections.emptySet();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object object) {
            boolean bl = object instanceof Map;
            RuntimeCostAccounter.recordJump();
            if (!bl) return false;
            Map map = (Map)object;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.isEmpty:()Z");
            boolean bl2 = map.isEmpty();
            RuntimeCostAccounter.recordJump();
            if (!bl2) return false;
            boolean bl3 = true;
            RuntimeCostAccounter.recordJump();
            return bl3;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public V getOrDefault(Object object, V v) {
            return v;
        }

        @Override
        public void forEach(BiConsumer<? super K, ? super V> biConsumer) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
            Objects.requireNonNull(biConsumer);
        }

        @Override
        public void replaceAll(BiFunction<? super K, ? super V, ? extends V> biFunction) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
            Objects.requireNonNull(biFunction);
        }

        @Override
        public V putIfAbsent(K k, V v) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }

        @Override
        public boolean remove(Object object, Object object2) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }

        @Override
        public boolean replace(K k, V v, V v2) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }

        @Override
        public V replace(K k, V v) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }

        @Override
        public V computeIfAbsent(K k, Function<? super K, ? extends V> function) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }

        @Override
        public V computeIfPresent(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }

        @Override
        public V compute(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }

        @Override
        public V merge(K k, V v, BiFunction<? super V, ? super V, ? extends V> biFunction) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }

        private Object readResolve() {
            return EMPTY_MAP;
        }

        /* synthetic */ EmptyMap(1 var1_1) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$EmptyMap.<init>:()V");
            this();
        }
    }

    private static class EmptyList<E>
    extends AbstractList<E>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 8842843931221139166L;

        private EmptyList() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractList.<init>:()V");
        }

        @Override
        public Iterator<E> iterator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.emptyIterator:()Ljava/util/Iterator;");
            return Collections.emptyIterator();
        }

        @Override
        public ListIterator<E> listIterator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.emptyListIterator:()Ljava/util/ListIterator;");
            return Collections.emptyListIterator();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean contains(Object object) {
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.isEmpty:()Z");
            return collection.isEmpty();
        }

        @Override
        public Object[] toArray() {
            RuntimeCostAccounter.recordArrayAllocation((int)0, (int)8);
            return new Object[0];
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            int n = TArray.length;
            RuntimeCostAccounter.recordJump();
            if (n > 0) {
                TArray[0] = null;
            }
            return TArray;
        }

        @Override
        public E get(int n) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Index: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:(Ljava/lang/String;)V");
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(string);
            RuntimeCostAccounter.recordThrow();
            throw indexOutOfBoundsException;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object object) {
            boolean bl = object instanceof List;
            RuntimeCostAccounter.recordJump();
            if (!bl) return false;
            List list = (List)object;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.isEmpty:()Z");
            boolean bl2 = list.isEmpty();
            RuntimeCostAccounter.recordJump();
            if (!bl2) return false;
            boolean bl3 = true;
            RuntimeCostAccounter.recordJump();
            return bl3;
        }

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        public boolean removeIf(Predicate<? super E> predicate) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
            Objects.requireNonNull(predicate);
            return false;
        }

        @Override
        public void replaceAll(UnaryOperator<E> unaryOperator) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
            Objects.requireNonNull(unaryOperator);
        }

        @Override
        public void sort(Comparator<? super E> comparator) {
        }

        @Override
        public void forEach(Consumer<? super E> consumer) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
            Objects.requireNonNull(consumer);
        }

        @Override
        public Spliterator<E> spliterator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators.emptySpliterator:()Ljava/util/Spliterator;");
            return Spliterators.emptySpliterator();
        }

        private Object readResolve() {
            return EMPTY_LIST;
        }

        /* synthetic */ EmptyList(1 var1_1) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$EmptyList.<init>:()V");
            this();
        }
    }

    private static class EmptySet<E>
    extends AbstractSet<E>
    implements Serializable {
        private static final long serialVersionUID = 1582296315990362920L;

        private EmptySet() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractSet.<init>:()V");
        }

        @Override
        public Iterator<E> iterator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.emptyIterator:()Ljava/util/Iterator;");
            return Collections.emptyIterator();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean contains(Object object) {
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.isEmpty:()Z");
            return collection.isEmpty();
        }

        @Override
        public Object[] toArray() {
            RuntimeCostAccounter.recordArrayAllocation((int)0, (int)8);
            return new Object[0];
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            int n = TArray.length;
            RuntimeCostAccounter.recordJump();
            if (n > 0) {
                TArray[0] = null;
            }
            return TArray;
        }

        @Override
        public void forEach(Consumer<? super E> consumer) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
            Objects.requireNonNull(consumer);
        }

        @Override
        public boolean removeIf(Predicate<? super E> predicate) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
            Objects.requireNonNull(predicate);
            return false;
        }

        @Override
        public Spliterator<E> spliterator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators.emptySpliterator:()Ljava/util/Spliterator;");
            return Spliterators.emptySpliterator();
        }

        private Object readResolve() {
            return EMPTY_SET;
        }

        /* synthetic */ EmptySet(1 var1_1) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$EmptySet.<init>:()V");
            this();
        }
    }

    private static class EmptyEnumeration<E>
    implements Enumeration<E> {
        static final EmptyEnumeration<Object> EMPTY_ENUMERATION;

        private EmptyEnumeration() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public E nextElement() {
            RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
            NoSuchElementException noSuchElementException = new NoSuchElementException();
            RuntimeCostAccounter.recordThrow();
            throw noSuchElementException;
        }

        static {
            RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$EmptyEnumeration");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$EmptyEnumeration.<init>:()V");
            EMPTY_ENUMERATION = new EmptyEnumeration();
        }
    }

    private static class EmptyListIterator<E>
    extends EmptyIterator<E>
    implements ListIterator<E> {
        static final EmptyListIterator<Object> EMPTY_ITERATOR;

        private EmptyListIterator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$EmptyIterator.<init>:(Ljava/util/Collections$1;)V");
            super(null);
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public E previous() {
            RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
            NoSuchElementException noSuchElementException = new NoSuchElementException();
            RuntimeCostAccounter.recordThrow();
            throw noSuchElementException;
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public int previousIndex() {
            return -1;
        }

        @Override
        public void set(E e) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:()V");
            IllegalStateException illegalStateException = new IllegalStateException();
            RuntimeCostAccounter.recordThrow();
            throw illegalStateException;
        }

        @Override
        public void add(E e) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }

        static {
            RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$EmptyListIterator");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$EmptyListIterator.<init>:()V");
            EMPTY_ITERATOR = new EmptyListIterator();
        }
    }

    private static class EmptyIterator<E>
    implements Iterator<E> {
        static final EmptyIterator<Object> EMPTY_ITERATOR;

        private EmptyIterator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public E next() {
            RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
            NoSuchElementException noSuchElementException = new NoSuchElementException();
            RuntimeCostAccounter.recordThrow();
            throw noSuchElementException;
        }

        @Override
        public void remove() {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:()V");
            IllegalStateException illegalStateException = new IllegalStateException();
            RuntimeCostAccounter.recordThrow();
            throw illegalStateException;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> consumer) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
            Objects.requireNonNull(consumer);
        }

        /* synthetic */ EmptyIterator(1 var1_1) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$EmptyIterator.<init>:()V");
            this();
        }

        static {
            RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$EmptyIterator");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$EmptyIterator.<init>:()V");
            EMPTY_ITERATOR = new EmptyIterator();
        }
    }

    static class CheckedNavigableMap<K, V>
    extends CheckedSortedMap<K, V>
    implements NavigableMap<K, V>,
    Serializable {
        private static final long serialVersionUID = -4852462692372534096L;
        private final NavigableMap<K, V> nm;

        CheckedNavigableMap(NavigableMap<K, V> navigableMap, Class<K> clazz, Class<V> clazz2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedSortedMap.<init>:(Ljava/util/SortedMap;Ljava/lang/Class;Ljava/lang/Class;)V");
            super(navigableMap, clazz, clazz2);
            this.nm = navigableMap;
        }

        @Override
        public Comparator<? super K> comparator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.comparator:()Ljava/util/Comparator;");
            return this.nm.comparator();
        }

        @Override
        public K firstKey() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.firstKey:()Ljava/lang/Object;");
            return this.nm.firstKey();
        }

        @Override
        public K lastKey() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.lastKey:()Ljava/lang/Object;");
            return this.nm.lastKey();
        }

        @Override
        public Map.Entry<K, V> lowerEntry(K k) {
            CheckedMap.CheckedEntrySet.CheckedEntry checkedEntry;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.lowerEntry:(Ljava/lang/Object;)Ljava/util/Map$Entry;");
            Map.Entry<K, V> entry = this.nm.lowerEntry(k);
            RuntimeCostAccounter.recordJump();
            if (null != entry) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$CheckedMap$CheckedEntrySet$CheckedEntry");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedMap$CheckedEntrySet$CheckedEntry.<init>:(Ljava/util/Map$Entry;Ljava/lang/Class;)V");
                checkedEntry = new CheckedMap.CheckedEntrySet.CheckedEntry(entry, this.valueType);
                RuntimeCostAccounter.recordJump();
            } else {
                checkedEntry = null;
            }
            return checkedEntry;
        }

        @Override
        public K lowerKey(K k) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.lowerKey:(Ljava/lang/Object;)Ljava/lang/Object;");
            return this.nm.lowerKey(k);
        }

        @Override
        public Map.Entry<K, V> floorEntry(K k) {
            CheckedMap.CheckedEntrySet.CheckedEntry checkedEntry;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.floorEntry:(Ljava/lang/Object;)Ljava/util/Map$Entry;");
            Map.Entry<K, V> entry = this.nm.floorEntry(k);
            RuntimeCostAccounter.recordJump();
            if (null != entry) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$CheckedMap$CheckedEntrySet$CheckedEntry");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedMap$CheckedEntrySet$CheckedEntry.<init>:(Ljava/util/Map$Entry;Ljava/lang/Class;)V");
                checkedEntry = new CheckedMap.CheckedEntrySet.CheckedEntry(entry, this.valueType);
                RuntimeCostAccounter.recordJump();
            } else {
                checkedEntry = null;
            }
            return checkedEntry;
        }

        @Override
        public K floorKey(K k) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.floorKey:(Ljava/lang/Object;)Ljava/lang/Object;");
            return this.nm.floorKey(k);
        }

        @Override
        public Map.Entry<K, V> ceilingEntry(K k) {
            CheckedMap.CheckedEntrySet.CheckedEntry checkedEntry;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.ceilingEntry:(Ljava/lang/Object;)Ljava/util/Map$Entry;");
            Map.Entry<K, V> entry = this.nm.ceilingEntry(k);
            RuntimeCostAccounter.recordJump();
            if (null != entry) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$CheckedMap$CheckedEntrySet$CheckedEntry");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedMap$CheckedEntrySet$CheckedEntry.<init>:(Ljava/util/Map$Entry;Ljava/lang/Class;)V");
                checkedEntry = new CheckedMap.CheckedEntrySet.CheckedEntry(entry, this.valueType);
                RuntimeCostAccounter.recordJump();
            } else {
                checkedEntry = null;
            }
            return checkedEntry;
        }

        @Override
        public K ceilingKey(K k) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.ceilingKey:(Ljava/lang/Object;)Ljava/lang/Object;");
            return this.nm.ceilingKey(k);
        }

        @Override
        public Map.Entry<K, V> higherEntry(K k) {
            CheckedMap.CheckedEntrySet.CheckedEntry checkedEntry;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.higherEntry:(Ljava/lang/Object;)Ljava/util/Map$Entry;");
            Map.Entry<K, V> entry = this.nm.higherEntry(k);
            RuntimeCostAccounter.recordJump();
            if (null != entry) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$CheckedMap$CheckedEntrySet$CheckedEntry");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedMap$CheckedEntrySet$CheckedEntry.<init>:(Ljava/util/Map$Entry;Ljava/lang/Class;)V");
                checkedEntry = new CheckedMap.CheckedEntrySet.CheckedEntry(entry, this.valueType);
                RuntimeCostAccounter.recordJump();
            } else {
                checkedEntry = null;
            }
            return checkedEntry;
        }

        @Override
        public K higherKey(K k) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.higherKey:(Ljava/lang/Object;)Ljava/lang/Object;");
            return this.nm.higherKey(k);
        }

        @Override
        public Map.Entry<K, V> firstEntry() {
            CheckedMap.CheckedEntrySet.CheckedEntry checkedEntry;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.firstEntry:()Ljava/util/Map$Entry;");
            Map.Entry<K, V> entry = this.nm.firstEntry();
            RuntimeCostAccounter.recordJump();
            if (null != entry) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$CheckedMap$CheckedEntrySet$CheckedEntry");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedMap$CheckedEntrySet$CheckedEntry.<init>:(Ljava/util/Map$Entry;Ljava/lang/Class;)V");
                checkedEntry = new CheckedMap.CheckedEntrySet.CheckedEntry(entry, this.valueType);
                RuntimeCostAccounter.recordJump();
            } else {
                checkedEntry = null;
            }
            return checkedEntry;
        }

        @Override
        public Map.Entry<K, V> lastEntry() {
            CheckedMap.CheckedEntrySet.CheckedEntry checkedEntry;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.lastEntry:()Ljava/util/Map$Entry;");
            Map.Entry<K, V> entry = this.nm.lastEntry();
            RuntimeCostAccounter.recordJump();
            if (null != entry) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$CheckedMap$CheckedEntrySet$CheckedEntry");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedMap$CheckedEntrySet$CheckedEntry.<init>:(Ljava/util/Map$Entry;Ljava/lang/Class;)V");
                checkedEntry = new CheckedMap.CheckedEntrySet.CheckedEntry(entry, this.valueType);
                RuntimeCostAccounter.recordJump();
            } else {
                checkedEntry = null;
            }
            return checkedEntry;
        }

        @Override
        public Map.Entry<K, V> pollFirstEntry() {
            CheckedMap.CheckedEntrySet.CheckedEntry checkedEntry;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.pollFirstEntry:()Ljava/util/Map$Entry;");
            Map.Entry<K, V> entry = this.nm.pollFirstEntry();
            RuntimeCostAccounter.recordJump();
            if (null == entry) {
                checkedEntry = null;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$CheckedMap$CheckedEntrySet$CheckedEntry");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedMap$CheckedEntrySet$CheckedEntry.<init>:(Ljava/util/Map$Entry;Ljava/lang/Class;)V");
                checkedEntry = new CheckedMap.CheckedEntrySet.CheckedEntry(entry, this.valueType);
            }
            return checkedEntry;
        }

        @Override
        public Map.Entry<K, V> pollLastEntry() {
            CheckedMap.CheckedEntrySet.CheckedEntry checkedEntry;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.pollLastEntry:()Ljava/util/Map$Entry;");
            Map.Entry<K, V> entry = this.nm.pollLastEntry();
            RuntimeCostAccounter.recordJump();
            if (null == entry) {
                checkedEntry = null;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$CheckedMap$CheckedEntrySet$CheckedEntry");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedMap$CheckedEntrySet$CheckedEntry.<init>:(Ljava/util/Map$Entry;Ljava/lang/Class;)V");
                checkedEntry = new CheckedMap.CheckedEntrySet.CheckedEntry(entry, this.valueType);
            }
            return checkedEntry;
        }

        @Override
        public NavigableMap<K, V> descendingMap() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.descendingMap:()Ljava/util/NavigableMap;");
            NavigableMap<K, V> navigableMap = this.nm.descendingMap();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.checkedNavigableMap:(Ljava/util/NavigableMap;Ljava/lang/Class;Ljava/lang/Class;)Ljava/util/NavigableMap;");
            return Collections.checkedNavigableMap(navigableMap, this.keyType, this.valueType);
        }

        @Override
        public NavigableSet<K> keySet() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedNavigableMap.navigableKeySet:()Ljava/util/NavigableSet;");
            return this.navigableKeySet();
        }

        @Override
        public NavigableSet<K> navigableKeySet() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.navigableKeySet:()Ljava/util/NavigableSet;");
            NavigableSet<K> navigableSet = this.nm.navigableKeySet();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.checkedNavigableSet:(Ljava/util/NavigableSet;Ljava/lang/Class;)Ljava/util/NavigableSet;");
            return Collections.checkedNavigableSet(navigableSet, this.keyType);
        }

        @Override
        public NavigableSet<K> descendingKeySet() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.descendingKeySet:()Ljava/util/NavigableSet;");
            NavigableSet<K> navigableSet = this.nm.descendingKeySet();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.checkedNavigableSet:(Ljava/util/NavigableSet;Ljava/lang/Class;)Ljava/util/NavigableSet;");
            return Collections.checkedNavigableSet(navigableSet, this.keyType);
        }

        @Override
        public NavigableMap<K, V> subMap(K k, K k2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.subMap:(Ljava/lang/Object;ZLjava/lang/Object;Z)Ljava/util/NavigableMap;");
            NavigableMap<K, V> navigableMap = this.nm.subMap(k, true, k2, false);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.checkedNavigableMap:(Ljava/util/NavigableMap;Ljava/lang/Class;Ljava/lang/Class;)Ljava/util/NavigableMap;");
            return Collections.checkedNavigableMap(navigableMap, this.keyType, this.valueType);
        }

        @Override
        public NavigableMap<K, V> headMap(K k) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.headMap:(Ljava/lang/Object;Z)Ljava/util/NavigableMap;");
            NavigableMap<K, V> navigableMap = this.nm.headMap(k, false);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.checkedNavigableMap:(Ljava/util/NavigableMap;Ljava/lang/Class;Ljava/lang/Class;)Ljava/util/NavigableMap;");
            return Collections.checkedNavigableMap(navigableMap, this.keyType, this.valueType);
        }

        @Override
        public NavigableMap<K, V> tailMap(K k) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.tailMap:(Ljava/lang/Object;Z)Ljava/util/NavigableMap;");
            NavigableMap<K, V> navigableMap = this.nm.tailMap(k, true);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.checkedNavigableMap:(Ljava/util/NavigableMap;Ljava/lang/Class;Ljava/lang/Class;)Ljava/util/NavigableMap;");
            return Collections.checkedNavigableMap(navigableMap, this.keyType, this.valueType);
        }

        @Override
        public NavigableMap<K, V> subMap(K k, boolean bl, K k2, boolean bl2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.subMap:(Ljava/lang/Object;ZLjava/lang/Object;Z)Ljava/util/NavigableMap;");
            NavigableMap<K, V> navigableMap = this.nm.subMap(k, bl, k2, bl2);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.checkedNavigableMap:(Ljava/util/NavigableMap;Ljava/lang/Class;Ljava/lang/Class;)Ljava/util/NavigableMap;");
            return Collections.checkedNavigableMap(navigableMap, this.keyType, this.valueType);
        }

        @Override
        public NavigableMap<K, V> headMap(K k, boolean bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.headMap:(Ljava/lang/Object;Z)Ljava/util/NavigableMap;");
            NavigableMap<K, V> navigableMap = this.nm.headMap(k, bl);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.checkedNavigableMap:(Ljava/util/NavigableMap;Ljava/lang/Class;Ljava/lang/Class;)Ljava/util/NavigableMap;");
            return Collections.checkedNavigableMap(navigableMap, this.keyType, this.valueType);
        }

        @Override
        public NavigableMap<K, V> tailMap(K k, boolean bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.tailMap:(Ljava/lang/Object;Z)Ljava/util/NavigableMap;");
            NavigableMap<K, V> navigableMap = this.nm.tailMap(k, bl);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.checkedNavigableMap:(Ljava/util/NavigableMap;Ljava/lang/Class;Ljava/lang/Class;)Ljava/util/NavigableMap;");
            return Collections.checkedNavigableMap(navigableMap, this.keyType, this.valueType);
        }
    }

    static class CheckedSortedMap<K, V>
    extends CheckedMap<K, V>
    implements SortedMap<K, V>,
    Serializable {
        private static final long serialVersionUID = 1599671320688067438L;
        private final SortedMap<K, V> sm;

        CheckedSortedMap(SortedMap<K, V> sortedMap, Class<K> clazz, Class<V> clazz2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedMap.<init>:(Ljava/util/Map;Ljava/lang/Class;Ljava/lang/Class;)V");
            super(sortedMap, clazz, clazz2);
            this.sm = sortedMap;
        }

        @Override
        public Comparator<? super K> comparator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/SortedMap.comparator:()Ljava/util/Comparator;");
            return this.sm.comparator();
        }

        @Override
        public K firstKey() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/SortedMap.firstKey:()Ljava/lang/Object;");
            return this.sm.firstKey();
        }

        @Override
        public K lastKey() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/SortedMap.lastKey:()Ljava/lang/Object;");
            return this.sm.lastKey();
        }

        @Override
        public SortedMap<K, V> subMap(K k, K k2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/SortedMap.subMap:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/SortedMap;");
            SortedMap<K, V> sortedMap = this.sm.subMap(k, k2);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.checkedSortedMap:(Ljava/util/SortedMap;Ljava/lang/Class;Ljava/lang/Class;)Ljava/util/SortedMap;");
            return Collections.checkedSortedMap(sortedMap, this.keyType, this.valueType);
        }

        @Override
        public SortedMap<K, V> headMap(K k) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/SortedMap.headMap:(Ljava/lang/Object;)Ljava/util/SortedMap;");
            SortedMap<K, V> sortedMap = this.sm.headMap(k);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.checkedSortedMap:(Ljava/util/SortedMap;Ljava/lang/Class;Ljava/lang/Class;)Ljava/util/SortedMap;");
            return Collections.checkedSortedMap(sortedMap, this.keyType, this.valueType);
        }

        @Override
        public SortedMap<K, V> tailMap(K k) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/SortedMap.tailMap:(Ljava/lang/Object;)Ljava/util/SortedMap;");
            SortedMap<K, V> sortedMap = this.sm.tailMap(k);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.checkedSortedMap:(Ljava/util/SortedMap;Ljava/lang/Class;Ljava/lang/Class;)Ljava/util/SortedMap;");
            return Collections.checkedSortedMap(sortedMap, this.keyType, this.valueType);
        }
    }

    private static class CheckedMap<K, V>
    implements Map<K, V>,
    Serializable {
        private static final long serialVersionUID = 5742860141034234728L;
        private final Map<K, V> m;
        final Class<K> keyType;
        final Class<V> valueType;
        private transient Set<Map.Entry<K, V>> entrySet;

        private void typeCheck(Object object, Object object2) {
            RuntimeCostAccounter.recordJump();
            if (object != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.isInstance:(Ljava/lang/Object;)Z");
                boolean bl = this.keyType.isInstance(object);
                RuntimeCostAccounter.recordJump();
                if (!bl) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/ClassCastException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedMap.badKeyMsg:(Ljava/lang/Object;)Ljava/lang/String;");
                    String string = this.badKeyMsg(object);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassCastException.<init>:(Ljava/lang/String;)V");
                    ClassCastException classCastException = new ClassCastException(string);
                    RuntimeCostAccounter.recordThrow();
                    throw classCastException;
                }
            }
            RuntimeCostAccounter.recordJump();
            if (object2 != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.isInstance:(Ljava/lang/Object;)Z");
                boolean bl = this.valueType.isInstance(object2);
                RuntimeCostAccounter.recordJump();
                if (!bl) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/ClassCastException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedMap.badValueMsg:(Ljava/lang/Object;)Ljava/lang/String;");
                    String string = this.badValueMsg(object2);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassCastException.<init>:(Ljava/lang/String;)V");
                    ClassCastException classCastException = new ClassCastException(string);
                    RuntimeCostAccounter.recordThrow();
                    throw classCastException;
                }
            }
        }

        private BiFunction<? super K, ? super V, ? extends V> typeCheck(BiFunction<? super K, ? super V, ? extends V> biFunction) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
            Objects.requireNonNull(biFunction);
            return (object, object2) -> {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BiFunction.apply:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                Object r = biFunction.apply((K)object, (V)object2);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedMap.typeCheck:(Ljava/lang/Object;Ljava/lang/Object;)V");
                this.typeCheck(object, r);
                return r;
            };
        }

        private String badKeyMsg(Object object) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Attempt to insert ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
            Class<?> clazz = object.getClass();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(clazz);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append(" key into map with key type ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append(this.keyType);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            return stringBuilder5.toString();
        }

        private String badValueMsg(Object object) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Attempt to insert ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
            Class<?> clazz = object.getClass();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(clazz);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append(" value into map with value type ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append(this.valueType);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            return stringBuilder5.toString();
        }

        CheckedMap(Map<K, V> map, Class<K> clazz, Class<V> clazz2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
            this.m = Objects.requireNonNull(map);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
            this.keyType = Objects.requireNonNull(clazz);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
            this.valueType = Objects.requireNonNull(clazz2);
        }

        @Override
        public int size() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.size:()I");
            return this.m.size();
        }

        @Override
        public boolean isEmpty() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.isEmpty:()Z");
            return this.m.isEmpty();
        }

        @Override
        public boolean containsKey(Object object) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
            return this.m.containsKey(object);
        }

        @Override
        public boolean containsValue(Object object) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsValue:(Ljava/lang/Object;)Z");
            return this.m.containsValue(object);
        }

        @Override
        public V get(Object object) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
            return this.m.get(object);
        }

        @Override
        public V remove(Object object) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            return this.m.remove(object);
        }

        @Override
        public void clear() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.clear:()V");
            this.m.clear();
        }

        @Override
        public Set<K> keySet() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.keySet:()Ljava/util/Set;");
            return this.m.keySet();
        }

        @Override
        public Collection<V> values() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.values:()Ljava/util/Collection;");
            return this.m.values();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object object) {
            RuntimeCostAccounter.recordJump();
            if (object != this) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.equals:(Ljava/lang/Object;)Z");
                boolean bl = this.m.equals(object);
                RuntimeCostAccounter.recordJump();
                if (!bl) return false;
            }
            boolean bl = true;
            RuntimeCostAccounter.recordJump();
            return bl;
        }

        @Override
        public int hashCode() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.hashCode:()I");
            return this.m.hashCode();
        }

        public String toString() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.toString:()Ljava/lang/String;");
            return this.m.toString();
        }

        @Override
        public V put(K k, V v) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedMap.typeCheck:(Ljava/lang/Object;Ljava/lang/Object;)V");
            this.typeCheck(k, v);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            return this.m.put(k, v);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.entrySet:()Ljava/util/Set;");
            Set<Map.Entry<K, V>> set = map.entrySet();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.toArray:()[Ljava/lang/Object;");
            Object[] objectArray = set.toArray();
            RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList");
            int n = objectArray.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.<init>:(I)V");
            ArrayList arrayList = new ArrayList(n);
            Object object = objectArray;
            int n2 = ((Object[])object).length;
            int n3 = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n3 >= n2) break;
                Object object2 = object[n3];
                Map.Entry entry = (Map.Entry)object2;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
                Object k = entry.getKey();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
                Object v = entry.getValue();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedMap.typeCheck:(Ljava/lang/Object;Ljava/lang/Object;)V");
                this.typeCheck(k, v);
                RuntimeCostAccounter.recordAllocation((String)"java/util/AbstractMap$SimpleImmutableEntry");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractMap$SimpleImmutableEntry.<init>:(Ljava/lang/Object;Ljava/lang/Object;)V");
                AbstractMap.SimpleImmutableEntry simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry(k, v);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.add:(Ljava/lang/Object;)Z");
                arrayList.add(simpleImmutableEntry);
                ++n3;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.iterator:()Ljava/util/Iterator;");
            object = arrayList.iterator();
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                boolean bl = object.hasNext();
                RuntimeCostAccounter.recordJump();
                if (!bl) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                Map.Entry entry = (Map.Entry)object.next();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
                Object k = entry.getKey();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
                Object v = entry.getValue();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                this.m.put(k, v);
                RuntimeCostAccounter.recordJump();
            }
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            RuntimeCostAccounter.recordJump();
            if (this.entrySet == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$CheckedMap$CheckedEntrySet");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.entrySet:()Ljava/util/Set;");
                Set<Map.Entry<K, V>> set = this.m.entrySet();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedMap$CheckedEntrySet.<init>:(Ljava/util/Set;Ljava/lang/Class;)V");
                this.entrySet = new CheckedEntrySet<K, V>(set, this.valueType);
            }
            return this.entrySet;
        }

        @Override
        public void forEach(BiConsumer<? super K, ? super V> biConsumer) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.forEach:(Ljava/util/function/BiConsumer;)V");
            this.m.forEach(biConsumer);
        }

        @Override
        public void replaceAll(BiFunction<? super K, ? super V, ? extends V> biFunction) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedMap.typeCheck:(Ljava/util/function/BiFunction;)Ljava/util/function/BiFunction;");
            BiFunction<? super K, ? extends V, ? extends V> biFunction2 = this.typeCheck(biFunction);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.replaceAll:(Ljava/util/function/BiFunction;)V");
            this.m.replaceAll(biFunction2);
        }

        @Override
        public V putIfAbsent(K k, V v) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedMap.typeCheck:(Ljava/lang/Object;Ljava/lang/Object;)V");
            this.typeCheck(k, v);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.putIfAbsent:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            return this.m.putIfAbsent(k, v);
        }

        @Override
        public boolean remove(Object object, Object object2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;Ljava/lang/Object;)Z");
            return this.m.remove(object, object2);
        }

        @Override
        public boolean replace(K k, V v, V v2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedMap.typeCheck:(Ljava/lang/Object;Ljava/lang/Object;)V");
            this.typeCheck(k, v2);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.replace:(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Z");
            return this.m.replace(k, v, v2);
        }

        @Override
        public V replace(K k, V v) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedMap.typeCheck:(Ljava/lang/Object;Ljava/lang/Object;)V");
            this.typeCheck(k, v);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.replace:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            return this.m.replace(k, v);
        }

        @Override
        public V computeIfAbsent(K k, Function<? super K, ? extends V> function) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
            Objects.requireNonNull(function);
            Function<Object, Object> function2 = object -> {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Function.apply:(Ljava/lang/Object;)Ljava/lang/Object;");
                Object r = function.apply((K)object);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedMap.typeCheck:(Ljava/lang/Object;Ljava/lang/Object;)V");
                this.typeCheck(object, r);
                return r;
            };
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.computeIfAbsent:(Ljava/lang/Object;Ljava/util/function/Function;)Ljava/lang/Object;");
            return (V)this.m.computeIfAbsent(k, function2);
        }

        @Override
        public V computeIfPresent(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedMap.typeCheck:(Ljava/util/function/BiFunction;)Ljava/util/function/BiFunction;");
            BiFunction<? super K, ? extends V, ? extends V> biFunction2 = this.typeCheck(biFunction);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.computeIfPresent:(Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;");
            return this.m.computeIfPresent((K)k, biFunction2);
        }

        @Override
        public V compute(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedMap.typeCheck:(Ljava/util/function/BiFunction;)Ljava/util/function/BiFunction;");
            BiFunction<? super K, ? extends V, ? extends V> biFunction2 = this.typeCheck(biFunction);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.compute:(Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;");
            return this.m.compute((K)k, biFunction2);
        }

        @Override
        public V merge(K k, V v, BiFunction<? super V, ? super V, ? extends V> biFunction) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
            Objects.requireNonNull(biFunction);
            BiFunction<Object, Object, Object> biFunction2 = (object, object2) -> {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BiFunction.apply:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                Object r = biFunction.apply((V)object, (V)object2);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedMap.typeCheck:(Ljava/lang/Object;Ljava/lang/Object;)V");
                this.typeCheck(null, r);
                return r;
            };
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.merge:(Ljava/lang/Object;Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;");
            return (V)this.m.merge(k, v, biFunction2);
        }

        static class CheckedEntrySet<K, V>
        implements Set<Map.Entry<K, V>> {
            private final Set<Map.Entry<K, V>> s;
            private final Class<V> valueType;

            CheckedEntrySet(Set<Map.Entry<K, V>> set, Class<V> clazz) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                this.s = set;
                this.valueType = clazz;
            }

            @Override
            public int size() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.size:()I");
                return this.s.size();
            }

            @Override
            public boolean isEmpty() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.isEmpty:()Z");
                return this.s.isEmpty();
            }

            public String toString() {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.toString:()Ljava/lang/String;");
                return this.s.toString();
            }

            @Override
            public int hashCode() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.hashCode:()I");
                return this.s.hashCode();
            }

            @Override
            public void clear() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.clear:()V");
                this.s.clear();
            }

            @Override
            public boolean add(Map.Entry<K, V> entry) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
                UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
                RuntimeCostAccounter.recordThrow();
                throw unsupportedOperationException;
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<K, V>> collection) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
                UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
                RuntimeCostAccounter.recordThrow();
                throw unsupportedOperationException;
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.iterator:()Ljava/util/Iterator;");
                final Iterator<Map.Entry<K, V>> iterator = this.s.iterator();
                final Class<V> clazz = this.valueType;
                RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$CheckedMap$CheckedEntrySet$1");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedMap$CheckedEntrySet$1.<init>:(Ljava/util/Collections$CheckedMap$CheckedEntrySet;Ljava/util/Iterator;Ljava/lang/Class;)V");
                return new Iterator<Map.Entry<K, V>>(){
                    {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                    }

                    @Override
                    public boolean hasNext() {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                        return iterator.hasNext();
                    }

                    @Override
                    public void remove() {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.remove:()V");
                        iterator.remove();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                        Map.Entry entry = (Map.Entry)iterator.next();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedMap$CheckedEntrySet.checkedEntry:(Ljava/util/Map$Entry;Ljava/lang/Class;)Ljava/util/Collections$CheckedMap$CheckedEntrySet$CheckedEntry;");
                        return CheckedEntrySet.checkedEntry(entry, clazz);
                    }
                };
            }

            @Override
            public Object[] toArray() {
                Object[] objectArray;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.toArray:()[Ljava/lang/Object;");
                Object[] objectArray2 = this.s.toArray();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
                Class<?> clazz = objectArray2.getClass();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getComponentType:()Ljava/lang/Class;");
                Class<?> clazz2 = clazz.getComponentType();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.isInstance:(Ljava/lang/Object;)Z");
                boolean bl = CheckedEntry.class.isInstance(clazz2);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    objectArray = objectArray2;
                    RuntimeCostAccounter.recordJump();
                } else {
                    int n = objectArray2.length;
                    RuntimeCostAccounter.recordArrayAllocation((int)n, (int)8);
                    objectArray = new Object[n];
                }
                Object[] objectArray3 = objectArray;
                int n = 0;
                while (true) {
                    int n2 = objectArray2.length;
                    RuntimeCostAccounter.recordJump();
                    if (n >= n2) break;
                    Map.Entry entry = (Map.Entry)objectArray2[n];
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedMap$CheckedEntrySet.checkedEntry:(Ljava/util/Map$Entry;Ljava/lang/Class;)Ljava/util/Collections$CheckedMap$CheckedEntrySet$CheckedEntry;");
                    objectArray3[n] = CheckedEntrySet.checkedEntry(entry, this.valueType);
                    ++n;
                    RuntimeCostAccounter.recordJump();
                }
                return objectArray3;
            }

            @Override
            public <T> T[] toArray(T[] TArray) {
                T[] TArray2;
                int n = TArray.length;
                RuntimeCostAccounter.recordJump();
                if (n == 0) {
                    TArray2 = TArray;
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([Ljava/lang/Object;I)[Ljava/lang/Object;");
                    TArray2 = Arrays.copyOf(TArray, 0);
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.toArray:([Ljava/lang/Object;)[Ljava/lang/Object;");
                T[] TArray3 = this.s.toArray(TArray2);
                int n2 = 0;
                while (true) {
                    int n3 = TArray3.length;
                    RuntimeCostAccounter.recordJump();
                    if (n2 >= n3) break;
                    Map.Entry entry = (Map.Entry)TArray3[n2];
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedMap$CheckedEntrySet.checkedEntry:(Ljava/util/Map$Entry;Ljava/lang/Class;)Ljava/util/Collections$CheckedMap$CheckedEntrySet$CheckedEntry;");
                    TArray3[n2] = CheckedEntrySet.checkedEntry(entry, this.valueType);
                    ++n2;
                    RuntimeCostAccounter.recordJump();
                }
                int n4 = TArray3.length;
                int n5 = TArray.length;
                RuntimeCostAccounter.recordJump();
                if (n4 > n5) {
                    return TArray3;
                }
                int n6 = TArray3.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
                System.arraycopy(TArray3, 0, TArray, 0, n6);
                int n7 = TArray.length;
                int n8 = TArray3.length;
                RuntimeCostAccounter.recordJump();
                if (n7 > n8) {
                    TArray[TArray3.length] = null;
                }
                return TArray;
            }

            @Override
            public boolean contains(Object object) {
                CheckedEntry<K, V, V> checkedEntry;
                boolean bl = object instanceof Map.Entry;
                RuntimeCostAccounter.recordJump();
                if (!bl) {
                    return false;
                }
                CheckedEntry<K, V, V> checkedEntry2 = (CheckedEntry<K, V, V>)object;
                boolean bl2 = checkedEntry2 instanceof CheckedEntry;
                RuntimeCostAccounter.recordJump();
                if (bl2) {
                    checkedEntry = checkedEntry2;
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedMap$CheckedEntrySet.checkedEntry:(Ljava/util/Map$Entry;Ljava/lang/Class;)Ljava/util/Collections$CheckedMap$CheckedEntrySet$CheckedEntry;");
                    checkedEntry = CheckedEntrySet.checkedEntry(checkedEntry2, this.valueType);
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.contains:(Ljava/lang/Object;)Z");
                return this.s.contains(checkedEntry);
            }

            @Override
            public boolean containsAll(Collection<?> collection) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.iterator:()Ljava/util/Iterator;");
                Iterator<?> iterator = collection.iterator();
                while (true) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                    boolean bl = iterator.hasNext();
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                    Object obj = iterator.next();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedMap$CheckedEntrySet.contains:(Ljava/lang/Object;)Z");
                    boolean bl2 = this.contains(obj);
                    RuntimeCostAccounter.recordJump();
                    if (!bl2) {
                        return false;
                    }
                    RuntimeCostAccounter.recordJump();
                }
                return true;
            }

            @Override
            public boolean remove(Object object) {
                boolean bl = object instanceof Map.Entry;
                RuntimeCostAccounter.recordJump();
                if (!bl) {
                    return false;
                }
                RuntimeCostAccounter.recordAllocation((String)"java/util/AbstractMap$SimpleImmutableEntry");
                Map.Entry entry = (Map.Entry)object;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractMap$SimpleImmutableEntry.<init>:(Ljava/util/Map$Entry;)V");
                AbstractMap.SimpleImmutableEntry simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry(entry);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.remove:(Ljava/lang/Object;)Z");
                return this.s.remove(simpleImmutableEntry);
            }

            @Override
            public boolean removeAll(Collection<?> collection) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedMap$CheckedEntrySet.batchRemove:(Ljava/util/Collection;Z)Z");
                return this.batchRemove(collection, false);
            }

            @Override
            public boolean retainAll(Collection<?> collection) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedMap$CheckedEntrySet.batchRemove:(Ljava/util/Collection;Z)Z");
                return this.batchRemove(collection, true);
            }

            private boolean batchRemove(Collection<?> collection, boolean bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
                Objects.requireNonNull(collection);
                boolean bl2 = false;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedMap$CheckedEntrySet.iterator:()Ljava/util/Iterator;");
                Iterator<Map.Entry<K, V>> iterator = this.iterator();
                while (true) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                    boolean bl3 = iterator.hasNext();
                    RuntimeCostAccounter.recordJump();
                    if (!bl3) break;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                    Map.Entry<K, V> entry = iterator.next();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.contains:(Ljava/lang/Object;)Z");
                    boolean bl4 = collection.contains(entry);
                    RuntimeCostAccounter.recordJump();
                    if (bl4 == bl) continue;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.remove:()V");
                    iterator.remove();
                    bl2 = true;
                    RuntimeCostAccounter.recordJump();
                }
                return bl2;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean equals(Object object) {
                RuntimeCostAccounter.recordJump();
                if (object == this) {
                    return true;
                }
                boolean bl = object instanceof Set;
                RuntimeCostAccounter.recordJump();
                if (!bl) {
                    return false;
                }
                Set set = (Set)object;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.size:()I");
                int n = set.size();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.size:()I");
                int n2 = this.s.size();
                RuntimeCostAccounter.recordJump();
                if (n != n2) return false;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedMap$CheckedEntrySet.containsAll:(Ljava/util/Collection;)Z");
                boolean bl2 = this.containsAll(set);
                RuntimeCostAccounter.recordJump();
                if (!bl2) return false;
                boolean bl3 = true;
                RuntimeCostAccounter.recordJump();
                return bl3;
            }

            static <K, V, T> CheckedEntry<K, V, T> checkedEntry(Map.Entry<K, V> entry, Class<T> clazz) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$CheckedMap$CheckedEntrySet$CheckedEntry");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedMap$CheckedEntrySet$CheckedEntry.<init>:(Ljava/util/Map$Entry;Ljava/lang/Class;)V");
                return new CheckedEntry<K, V, T>(entry, clazz);
            }

            private static class CheckedEntry<K, V, T>
            implements Map.Entry<K, V> {
                private final Map.Entry<K, V> e;
                private final Class<T> valueType;

                CheckedEntry(Map.Entry<K, V> entry, Class<T> clazz) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
                    this.e = Objects.requireNonNull(entry);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
                    this.valueType = Objects.requireNonNull(clazz);
                }

                @Override
                public K getKey() {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
                    return this.e.getKey();
                }

                @Override
                public V getValue() {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
                    return this.e.getValue();
                }

                @Override
                public int hashCode() {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.hashCode:()I");
                    return this.e.hashCode();
                }

                public String toString() {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.toString:()Ljava/lang/String;");
                    return this.e.toString();
                }

                @Override
                public V setValue(V v) {
                    RuntimeCostAccounter.recordJump();
                    if (v != null) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.isInstance:(Ljava/lang/Object;)Z");
                        boolean bl = this.valueType.isInstance(v);
                        RuntimeCostAccounter.recordJump();
                        if (!bl) {
                            RuntimeCostAccounter.recordAllocation((String)"java/lang/ClassCastException");
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedMap$CheckedEntrySet$CheckedEntry.badValueMsg:(Ljava/lang/Object;)Ljava/lang/String;");
                            String string = this.badValueMsg(v);
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassCastException.<init>:(Ljava/lang/String;)V");
                            ClassCastException classCastException = new ClassCastException(string);
                            RuntimeCostAccounter.recordThrow();
                            throw classCastException;
                        }
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.setValue:(Ljava/lang/Object;)Ljava/lang/Object;");
                    return this.e.setValue(v);
                }

                private String badValueMsg(Object object) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                    StringBuilder stringBuilder = new StringBuilder();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder2 = stringBuilder.append("Attempt to insert ");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
                    Class<?> clazz = object.getClass();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder3 = stringBuilder2.append(clazz);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder4 = stringBuilder3.append(" value into map with value type ");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder5 = stringBuilder4.append(this.valueType);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                    return stringBuilder5.toString();
                }

                @Override
                public boolean equals(Object object) {
                    RuntimeCostAccounter.recordJump();
                    if (object == this) {
                        return true;
                    }
                    boolean bl = object instanceof Map.Entry;
                    RuntimeCostAccounter.recordJump();
                    if (!bl) {
                        return false;
                    }
                    RuntimeCostAccounter.recordAllocation((String)"java/util/AbstractMap$SimpleImmutableEntry");
                    Map.Entry entry = (Map.Entry)object;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractMap$SimpleImmutableEntry.<init>:(Ljava/util/Map$Entry;)V");
                    AbstractMap.SimpleImmutableEntry simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry(entry);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.equals:(Ljava/lang/Object;)Z");
                    return this.e.equals(simpleImmutableEntry);
                }
            }
        }
    }

    static class CheckedRandomAccessList<E>
    extends CheckedList<E>
    implements RandomAccess {
        private static final long serialVersionUID = 1638200125423088369L;

        CheckedRandomAccessList(List<E> list, Class<E> clazz) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedList.<init>:(Ljava/util/List;Ljava/lang/Class;)V");
            super(list, clazz);
        }

        @Override
        public List<E> subList(int n, int n2) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$CheckedRandomAccessList");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.subList:(II)Ljava/util/List;");
            List list = this.list.subList(n, n2);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedRandomAccessList.<init>:(Ljava/util/List;Ljava/lang/Class;)V");
            return new CheckedRandomAccessList(list, this.type);
        }
    }

    static class CheckedList<E>
    extends CheckedCollection<E>
    implements List<E> {
        private static final long serialVersionUID = 65247728283967356L;
        final List<E> list;

        CheckedList(List<E> list, Class<E> clazz) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedCollection.<init>:(Ljava/util/Collection;Ljava/lang/Class;)V");
            super(list, clazz);
            this.list = list;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object object) {
            RuntimeCostAccounter.recordJump();
            if (object != this) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.equals:(Ljava/lang/Object;)Z");
                boolean bl = this.list.equals(object);
                RuntimeCostAccounter.recordJump();
                if (!bl) return false;
            }
            boolean bl = true;
            RuntimeCostAccounter.recordJump();
            return bl;
        }

        @Override
        public int hashCode() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.hashCode:()I");
            return this.list.hashCode();
        }

        @Override
        public E get(int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.get:(I)Ljava/lang/Object;");
            return this.list.get(n);
        }

        @Override
        public E remove(int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.remove:(I)Ljava/lang/Object;");
            return this.list.remove(n);
        }

        @Override
        public int indexOf(Object object) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.indexOf:(Ljava/lang/Object;)I");
            return this.list.indexOf(object);
        }

        @Override
        public int lastIndexOf(Object object) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.lastIndexOf:(Ljava/lang/Object;)I");
            return this.list.lastIndexOf(object);
        }

        @Override
        public E set(int n, E e) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedList.typeCheck:(Ljava/lang/Object;)Ljava/lang/Object;");
            Object e2 = this.typeCheck(e);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.set:(ILjava/lang/Object;)Ljava/lang/Object;");
            return this.list.set(n, e2);
        }

        @Override
        public void add(int n, E e) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedList.typeCheck:(Ljava/lang/Object;)Ljava/lang/Object;");
            Object e2 = this.typeCheck(e);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.add:(ILjava/lang/Object;)V");
            this.list.add(n, e2);
        }

        @Override
        public boolean addAll(int n, Collection<? extends E> collection) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedList.checkedCopyOf:(Ljava/util/Collection;)Ljava/util/Collection;");
            Collection<? extends E> collection2 = this.checkedCopyOf(collection);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.addAll:(ILjava/util/Collection;)Z");
            return this.list.addAll(n, collection2);
        }

        @Override
        public ListIterator<E> listIterator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedList.listIterator:(I)Ljava/util/ListIterator;");
            return this.listIterator(0);
        }

        @Override
        public ListIterator<E> listIterator(int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.listIterator:(I)Ljava/util/ListIterator;");
            final ListIterator<E> listIterator = this.list.listIterator(n);
            RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$CheckedList$1");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedList$1.<init>:(Ljava/util/Collections$CheckedList;Ljava/util/ListIterator;)V");
            return new ListIterator<E>(){
                {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                }

                @Override
                public boolean hasNext() {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.hasNext:()Z");
                    return listIterator.hasNext();
                }

                @Override
                public E next() {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.next:()Ljava/lang/Object;");
                    return listIterator.next();
                }

                @Override
                public boolean hasPrevious() {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.hasPrevious:()Z");
                    return listIterator.hasPrevious();
                }

                @Override
                public E previous() {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.previous:()Ljava/lang/Object;");
                    return listIterator.previous();
                }

                @Override
                public int nextIndex() {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.nextIndex:()I");
                    return listIterator.nextIndex();
                }

                @Override
                public int previousIndex() {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.previousIndex:()I");
                    return listIterator.previousIndex();
                }

                @Override
                public void remove() {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.remove:()V");
                    listIterator.remove();
                }

                @Override
                public void set(E e) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedList.typeCheck:(Ljava/lang/Object;)Ljava/lang/Object;");
                    Object e2 = this.typeCheck(e);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.set:(Ljava/lang/Object;)V");
                    listIterator.set(e2);
                }

                @Override
                public void add(E e) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedList.typeCheck:(Ljava/lang/Object;)Ljava/lang/Object;");
                    Object e2 = this.typeCheck(e);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.add:(Ljava/lang/Object;)V");
                    listIterator.add(e2);
                }

                @Override
                public void forEachRemaining(Consumer<? super E> consumer) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.forEachRemaining:(Ljava/util/function/Consumer;)V");
                    listIterator.forEachRemaining(consumer);
                }
            };
        }

        @Override
        public List<E> subList(int n, int n2) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$CheckedList");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.subList:(II)Ljava/util/List;");
            List<E> list = this.list.subList(n, n2);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedList.<init>:(Ljava/util/List;Ljava/lang/Class;)V");
            return new CheckedList<E>(list, this.type);
        }

        @Override
        public void replaceAll(UnaryOperator<E> unaryOperator) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
            Objects.requireNonNull(unaryOperator);
            UnaryOperator unaryOperator2 = object -> {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/UnaryOperator.apply:(Ljava/lang/Object;)Ljava/lang/Object;");
                Object r = unaryOperator.apply(object);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedList.typeCheck:(Ljava/lang/Object;)Ljava/lang/Object;");
                return this.typeCheck(r);
            };
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.replaceAll:(Ljava/util/function/UnaryOperator;)V");
            this.list.replaceAll(unaryOperator2);
        }

        @Override
        public void sort(Comparator<? super E> comparator) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.sort:(Ljava/util/Comparator;)V");
            this.list.sort(comparator);
        }
    }

    static class CheckedNavigableSet<E>
    extends CheckedSortedSet<E>
    implements NavigableSet<E>,
    Serializable {
        private static final long serialVersionUID = -5429120189805438922L;
        private final NavigableSet<E> ns;

        CheckedNavigableSet(NavigableSet<E> navigableSet, Class<E> clazz) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedSortedSet.<init>:(Ljava/util/SortedSet;Ljava/lang/Class;)V");
            super(navigableSet, clazz);
            this.ns = navigableSet;
        }

        @Override
        public E lower(E e) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableSet.lower:(Ljava/lang/Object;)Ljava/lang/Object;");
            return this.ns.lower(e);
        }

        @Override
        public E floor(E e) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableSet.floor:(Ljava/lang/Object;)Ljava/lang/Object;");
            return this.ns.floor(e);
        }

        @Override
        public E ceiling(E e) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableSet.ceiling:(Ljava/lang/Object;)Ljava/lang/Object;");
            return this.ns.ceiling(e);
        }

        @Override
        public E higher(E e) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableSet.higher:(Ljava/lang/Object;)Ljava/lang/Object;");
            return this.ns.higher(e);
        }

        @Override
        public E pollFirst() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableSet.pollFirst:()Ljava/lang/Object;");
            return this.ns.pollFirst();
        }

        @Override
        public E pollLast() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableSet.pollLast:()Ljava/lang/Object;");
            return this.ns.pollLast();
        }

        @Override
        public NavigableSet<E> descendingSet() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableSet.descendingSet:()Ljava/util/NavigableSet;");
            NavigableSet<E> navigableSet = this.ns.descendingSet();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.checkedNavigableSet:(Ljava/util/NavigableSet;Ljava/lang/Class;)Ljava/util/NavigableSet;");
            return Collections.checkedNavigableSet(navigableSet, this.type);
        }

        @Override
        public Iterator<E> descendingIterator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableSet.descendingSet:()Ljava/util/NavigableSet;");
            NavigableSet<E> navigableSet = this.ns.descendingSet();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.checkedNavigableSet:(Ljava/util/NavigableSet;Ljava/lang/Class;)Ljava/util/NavigableSet;");
            NavigableSet<E> navigableSet2 = Collections.checkedNavigableSet(navigableSet, this.type);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableSet.iterator:()Ljava/util/Iterator;");
            return navigableSet2.iterator();
        }

        @Override
        public NavigableSet<E> subSet(E e, E e2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableSet.subSet:(Ljava/lang/Object;ZLjava/lang/Object;Z)Ljava/util/NavigableSet;");
            NavigableSet<E> navigableSet = this.ns.subSet(e, true, e2, false);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.checkedNavigableSet:(Ljava/util/NavigableSet;Ljava/lang/Class;)Ljava/util/NavigableSet;");
            return Collections.checkedNavigableSet(navigableSet, this.type);
        }

        @Override
        public NavigableSet<E> headSet(E e) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableSet.headSet:(Ljava/lang/Object;Z)Ljava/util/NavigableSet;");
            NavigableSet<E> navigableSet = this.ns.headSet(e, false);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.checkedNavigableSet:(Ljava/util/NavigableSet;Ljava/lang/Class;)Ljava/util/NavigableSet;");
            return Collections.checkedNavigableSet(navigableSet, this.type);
        }

        @Override
        public NavigableSet<E> tailSet(E e) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableSet.tailSet:(Ljava/lang/Object;Z)Ljava/util/NavigableSet;");
            NavigableSet<E> navigableSet = this.ns.tailSet(e, true);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.checkedNavigableSet:(Ljava/util/NavigableSet;Ljava/lang/Class;)Ljava/util/NavigableSet;");
            return Collections.checkedNavigableSet(navigableSet, this.type);
        }

        @Override
        public NavigableSet<E> subSet(E e, boolean bl, E e2, boolean bl2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableSet.subSet:(Ljava/lang/Object;ZLjava/lang/Object;Z)Ljava/util/NavigableSet;");
            NavigableSet<E> navigableSet = this.ns.subSet(e, bl, e2, bl2);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.checkedNavigableSet:(Ljava/util/NavigableSet;Ljava/lang/Class;)Ljava/util/NavigableSet;");
            return Collections.checkedNavigableSet(navigableSet, this.type);
        }

        @Override
        public NavigableSet<E> headSet(E e, boolean bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableSet.headSet:(Ljava/lang/Object;Z)Ljava/util/NavigableSet;");
            NavigableSet<E> navigableSet = this.ns.headSet(e, bl);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.checkedNavigableSet:(Ljava/util/NavigableSet;Ljava/lang/Class;)Ljava/util/NavigableSet;");
            return Collections.checkedNavigableSet(navigableSet, this.type);
        }

        @Override
        public NavigableSet<E> tailSet(E e, boolean bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableSet.tailSet:(Ljava/lang/Object;Z)Ljava/util/NavigableSet;");
            NavigableSet<E> navigableSet = this.ns.tailSet(e, bl);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.checkedNavigableSet:(Ljava/util/NavigableSet;Ljava/lang/Class;)Ljava/util/NavigableSet;");
            return Collections.checkedNavigableSet(navigableSet, this.type);
        }
    }

    static class CheckedSortedSet<E>
    extends CheckedSet<E>
    implements SortedSet<E>,
    Serializable {
        private static final long serialVersionUID = 1599911165492914959L;
        private final SortedSet<E> ss;

        CheckedSortedSet(SortedSet<E> sortedSet, Class<E> clazz) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedSet.<init>:(Ljava/util/Set;Ljava/lang/Class;)V");
            super(sortedSet, clazz);
            this.ss = sortedSet;
        }

        @Override
        public Comparator<? super E> comparator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/SortedSet.comparator:()Ljava/util/Comparator;");
            return this.ss.comparator();
        }

        @Override
        public E first() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/SortedSet.first:()Ljava/lang/Object;");
            return this.ss.first();
        }

        @Override
        public E last() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/SortedSet.last:()Ljava/lang/Object;");
            return this.ss.last();
        }

        @Override
        public SortedSet<E> subSet(E e, E e2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/SortedSet.subSet:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/SortedSet;");
            SortedSet<E> sortedSet = this.ss.subSet(e, e2);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.checkedSortedSet:(Ljava/util/SortedSet;Ljava/lang/Class;)Ljava/util/SortedSet;");
            return Collections.checkedSortedSet(sortedSet, this.type);
        }

        @Override
        public SortedSet<E> headSet(E e) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/SortedSet.headSet:(Ljava/lang/Object;)Ljava/util/SortedSet;");
            SortedSet<E> sortedSet = this.ss.headSet(e);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.checkedSortedSet:(Ljava/util/SortedSet;Ljava/lang/Class;)Ljava/util/SortedSet;");
            return Collections.checkedSortedSet(sortedSet, this.type);
        }

        @Override
        public SortedSet<E> tailSet(E e) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/SortedSet.tailSet:(Ljava/lang/Object;)Ljava/util/SortedSet;");
            SortedSet<E> sortedSet = this.ss.tailSet(e);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.checkedSortedSet:(Ljava/util/SortedSet;Ljava/lang/Class;)Ljava/util/SortedSet;");
            return Collections.checkedSortedSet(sortedSet, this.type);
        }
    }

    static class CheckedSet<E>
    extends CheckedCollection<E>
    implements Set<E>,
    Serializable {
        private static final long serialVersionUID = 4694047833775013803L;

        CheckedSet(Set<E> set, Class<E> clazz) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedCollection.<init>:(Ljava/util/Collection;Ljava/lang/Class;)V");
            super(set, clazz);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object object) {
            RuntimeCostAccounter.recordJump();
            if (object != this) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.equals:(Ljava/lang/Object;)Z");
                boolean bl = this.c.equals(object);
                RuntimeCostAccounter.recordJump();
                if (!bl) return false;
            }
            boolean bl = true;
            RuntimeCostAccounter.recordJump();
            return bl;
        }

        @Override
        public int hashCode() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.hashCode:()I");
            return this.c.hashCode();
        }
    }

    static class CheckedQueue<E>
    extends CheckedCollection<E>
    implements Queue<E>,
    Serializable {
        private static final long serialVersionUID = 1433151992604707767L;
        final Queue<E> queue;

        CheckedQueue(Queue<E> queue, Class<E> clazz) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedCollection.<init>:(Ljava/util/Collection;Ljava/lang/Class;)V");
            super(queue, clazz);
            this.queue = queue;
        }

        @Override
        public E element() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Queue.element:()Ljava/lang/Object;");
            return this.queue.element();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object object) {
            RuntimeCostAccounter.recordJump();
            if (object != this) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.equals:(Ljava/lang/Object;)Z");
                boolean bl = this.c.equals(object);
                RuntimeCostAccounter.recordJump();
                if (!bl) return false;
            }
            boolean bl = true;
            RuntimeCostAccounter.recordJump();
            return bl;
        }

        @Override
        public int hashCode() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.hashCode:()I");
            return this.c.hashCode();
        }

        @Override
        public E peek() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Queue.peek:()Ljava/lang/Object;");
            return this.queue.peek();
        }

        @Override
        public E poll() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Queue.poll:()Ljava/lang/Object;");
            return this.queue.poll();
        }

        @Override
        public E remove() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Queue.remove:()Ljava/lang/Object;");
            return this.queue.remove();
        }

        @Override
        public boolean offer(E e) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedQueue.typeCheck:(Ljava/lang/Object;)Ljava/lang/Object;");
            Object e2 = this.typeCheck(e);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Queue.offer:(Ljava/lang/Object;)Z");
            return this.queue.offer(e2);
        }
    }

    static class CheckedCollection<E>
    implements Collection<E>,
    Serializable {
        private static final long serialVersionUID = 1578914078182001775L;
        final Collection<E> c;
        final Class<E> type;
        private E[] zeroLengthElementArray;

        E typeCheck(Object object) {
            RuntimeCostAccounter.recordJump();
            if (object != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.isInstance:(Ljava/lang/Object;)Z");
                boolean bl = this.type.isInstance(object);
                RuntimeCostAccounter.recordJump();
                if (!bl) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/ClassCastException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedCollection.badElementMsg:(Ljava/lang/Object;)Ljava/lang/String;");
                    String string = this.badElementMsg(object);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassCastException.<init>:(Ljava/lang/String;)V");
                    ClassCastException classCastException = new ClassCastException(string);
                    RuntimeCostAccounter.recordThrow();
                    throw classCastException;
                }
            }
            return (E)object;
        }

        private String badElementMsg(Object object) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Attempt to insert ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
            Class<?> clazz = object.getClass();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(clazz);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append(" element into collection with element type ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append(this.type);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            return stringBuilder5.toString();
        }

        CheckedCollection(Collection<E> collection, Class<E> clazz) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
            this.c = Objects.requireNonNull(collection, "c");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
            this.type = Objects.requireNonNull(clazz, "type");
        }

        @Override
        public int size() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.size:()I");
            return this.c.size();
        }

        @Override
        public boolean isEmpty() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.isEmpty:()Z");
            return this.c.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.contains:(Ljava/lang/Object;)Z");
            return this.c.contains(object);
        }

        @Override
        public Object[] toArray() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.toArray:()[Ljava/lang/Object;");
            return this.c.toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.toArray:([Ljava/lang/Object;)[Ljava/lang/Object;");
            return this.c.toArray(TArray);
        }

        public String toString() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.toString:()Ljava/lang/String;");
            return this.c.toString();
        }

        @Override
        public boolean remove(Object object) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.remove:(Ljava/lang/Object;)Z");
            return this.c.remove(object);
        }

        @Override
        public void clear() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.clear:()V");
            this.c.clear();
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.containsAll:(Ljava/util/Collection;)Z");
            return this.c.containsAll(collection);
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.removeAll:(Ljava/util/Collection;)Z");
            return this.c.removeAll(collection);
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.retainAll:(Ljava/util/Collection;)Z");
            return this.c.retainAll(collection);
        }

        @Override
        public Iterator<E> iterator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.iterator:()Ljava/util/Iterator;");
            final Iterator<E> iterator = this.c.iterator();
            RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$CheckedCollection$1");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedCollection$1.<init>:(Ljava/util/Collections$CheckedCollection;Ljava/util/Iterator;)V");
            return new Iterator<E>(){
                {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                }

                @Override
                public boolean hasNext() {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                    return iterator.hasNext();
                }

                @Override
                public E next() {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                    return iterator.next();
                }

                @Override
                public void remove() {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.remove:()V");
                    iterator.remove();
                }
            };
        }

        @Override
        public boolean add(E e) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedCollection.typeCheck:(Ljava/lang/Object;)Ljava/lang/Object;");
            E e2 = this.typeCheck(e);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.add:(Ljava/lang/Object;)Z");
            return this.c.add(e2);
        }

        private E[] zeroLengthElementArray() {
            E[] EArray;
            RuntimeCostAccounter.recordJump();
            if (this.zeroLengthElementArray != null) {
                EArray = this.zeroLengthElementArray;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.zeroLengthArray:(Ljava/lang/Class;)[Ljava/lang/Object;");
                EArray = this.zeroLengthElementArray = Collections.zeroLengthArray(this.type);
            }
            return EArray;
        }

        Collection<E> checkedCopyOf(Collection<? extends E> collection) {
            Object[] objectArray;
            block3: {
                try {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedCollection.zeroLengthElementArray:()[Ljava/lang/Object;");
                    E[] EArray = this.zeroLengthElementArray();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.toArray:([Ljava/lang/Object;)[Ljava/lang/Object;");
                    objectArray = collection.toArray(EArray);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
                    Class<?> clazz = objectArray.getClass();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
                    Class<?> clazz2 = EArray.getClass();
                    RuntimeCostAccounter.recordJump();
                    if (clazz == clazz2) break block3;
                    int n = objectArray.length;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
                    Class<?> clazz3 = EArray.getClass();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([Ljava/lang/Object;ILjava/lang/Class;)[Ljava/lang/Object;");
                    objectArray = Arrays.copyOf(objectArray, n, clazz3);
                }
                catch (ArrayStoreException arrayStoreException) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.toArray:()[Ljava/lang/Object;");
                    Object[] objectArray2 = collection.toArray();
                    RuntimeCostAccounter.recordMethodCall((String)"[Ljava/lang/Object;.clone:()Ljava/lang/Object;");
                    objectArray = (Object[])objectArray2.clone();
                    Object[] objectArray3 = objectArray;
                    int n = objectArray3.length;
                    int n2 = 0;
                    while (true) {
                        RuntimeCostAccounter.recordJump();
                        if (n2 >= n) break;
                        Object object = objectArray3[n2];
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedCollection.typeCheck:(Ljava/lang/Object;)Ljava/lang/Object;");
                        this.typeCheck(object);
                        ++n2;
                        RuntimeCostAccounter.recordJump();
                    }
                }
            }
            RuntimeCostAccounter.recordJump();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.asList:([Ljava/lang/Object;)Ljava/util/List;");
            return Arrays.asList(objectArray);
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$CheckedCollection.checkedCopyOf:(Ljava/util/Collection;)Ljava/util/Collection;");
            Collection<? extends E> collection2 = this.checkedCopyOf(collection);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.addAll:(Ljava/util/Collection;)Z");
            return this.c.addAll(collection2);
        }

        @Override
        public void forEach(Consumer<? super E> consumer) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.forEach:(Ljava/util/function/Consumer;)V");
            this.c.forEach(consumer);
        }

        @Override
        public boolean removeIf(Predicate<? super E> predicate) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.removeIf:(Ljava/util/function/Predicate;)Z");
            return this.c.removeIf(predicate);
        }

        @Override
        public Spliterator<E> spliterator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.spliterator:()Ljava/util/Spliterator;");
            return this.c.spliterator();
        }

        @Override
        public Stream<E> stream() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.stream:()Ljava/util/stream/Stream;");
            return this.c.stream();
        }

        @Override
        public Stream<E> parallelStream() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.parallelStream:()Ljava/util/stream/Stream;");
            return this.c.parallelStream();
        }
    }

    static class SynchronizedNavigableMap<K, V>
    extends SynchronizedSortedMap<K, V>
    implements NavigableMap<K, V> {
        private static final long serialVersionUID = 699392247599746807L;
        private final NavigableMap<K, V> nm;

        SynchronizedNavigableMap(NavigableMap<K, V> navigableMap) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedSortedMap.<init>:(Ljava/util/SortedMap;)V");
            super(navigableMap);
            this.nm = navigableMap;
        }

        SynchronizedNavigableMap(NavigableMap<K, V> navigableMap, Object object) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedSortedMap.<init>:(Ljava/util/SortedMap;Ljava/lang/Object;)V");
            super(navigableMap, object);
            this.nm = navigableMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map.Entry<K, V> lowerEntry(K k) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.lowerEntry:(Ljava/lang/Object;)Ljava/util/Map$Entry;");
                return this.nm.lowerEntry(k);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public K lowerKey(K k) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.lowerKey:(Ljava/lang/Object;)Ljava/lang/Object;");
                return this.nm.lowerKey(k);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map.Entry<K, V> floorEntry(K k) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.floorEntry:(Ljava/lang/Object;)Ljava/util/Map$Entry;");
                return this.nm.floorEntry(k);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public K floorKey(K k) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.floorKey:(Ljava/lang/Object;)Ljava/lang/Object;");
                return this.nm.floorKey(k);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map.Entry<K, V> ceilingEntry(K k) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.ceilingEntry:(Ljava/lang/Object;)Ljava/util/Map$Entry;");
                return this.nm.ceilingEntry(k);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public K ceilingKey(K k) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.ceilingKey:(Ljava/lang/Object;)Ljava/lang/Object;");
                return this.nm.ceilingKey(k);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map.Entry<K, V> higherEntry(K k) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.higherEntry:(Ljava/lang/Object;)Ljava/util/Map$Entry;");
                return this.nm.higherEntry(k);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public K higherKey(K k) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.higherKey:(Ljava/lang/Object;)Ljava/lang/Object;");
                return this.nm.higherKey(k);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map.Entry<K, V> firstEntry() {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.firstEntry:()Ljava/util/Map$Entry;");
                return this.nm.firstEntry();
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map.Entry<K, V> lastEntry() {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.lastEntry:()Ljava/util/Map$Entry;");
                return this.nm.lastEntry();
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map.Entry<K, V> pollFirstEntry() {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.pollFirstEntry:()Ljava/util/Map$Entry;");
                return this.nm.pollFirstEntry();
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map.Entry<K, V> pollLastEntry() {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.pollLastEntry:()Ljava/util/Map$Entry;");
                return this.nm.pollLastEntry();
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NavigableMap<K, V> descendingMap() {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$SynchronizedNavigableMap");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.descendingMap:()Ljava/util/NavigableMap;");
                NavigableMap<K, V> navigableMap = this.nm.descendingMap();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedNavigableMap.<init>:(Ljava/util/NavigableMap;Ljava/lang/Object;)V");
                return new SynchronizedNavigableMap<K, V>(navigableMap, this.mutex);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        @Override
        public NavigableSet<K> keySet() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedNavigableMap.navigableKeySet:()Ljava/util/NavigableSet;");
            return this.navigableKeySet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NavigableSet<K> navigableKeySet() {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$SynchronizedNavigableSet");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.navigableKeySet:()Ljava/util/NavigableSet;");
                NavigableSet<K> navigableSet = this.nm.navigableKeySet();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedNavigableSet.<init>:(Ljava/util/NavigableSet;Ljava/lang/Object;)V");
                return new SynchronizedNavigableSet<K>(navigableSet, this.mutex);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NavigableSet<K> descendingKeySet() {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$SynchronizedNavigableSet");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.descendingKeySet:()Ljava/util/NavigableSet;");
                NavigableSet<K> navigableSet = this.nm.descendingKeySet();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedNavigableSet.<init>:(Ljava/util/NavigableSet;Ljava/lang/Object;)V");
                return new SynchronizedNavigableSet<K>(navigableSet, this.mutex);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedMap<K, V> subMap(K k, K k2) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$SynchronizedNavigableMap");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.subMap:(Ljava/lang/Object;ZLjava/lang/Object;Z)Ljava/util/NavigableMap;");
                NavigableMap<K, V> navigableMap = this.nm.subMap(k, true, k2, false);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedNavigableMap.<init>:(Ljava/util/NavigableMap;Ljava/lang/Object;)V");
                return new SynchronizedNavigableMap<K, V>(navigableMap, this.mutex);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedMap<K, V> headMap(K k) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$SynchronizedNavigableMap");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.headMap:(Ljava/lang/Object;Z)Ljava/util/NavigableMap;");
                NavigableMap<K, V> navigableMap = this.nm.headMap(k, false);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedNavigableMap.<init>:(Ljava/util/NavigableMap;Ljava/lang/Object;)V");
                return new SynchronizedNavigableMap<K, V>(navigableMap, this.mutex);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedMap<K, V> tailMap(K k) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$SynchronizedNavigableMap");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.tailMap:(Ljava/lang/Object;Z)Ljava/util/NavigableMap;");
                NavigableMap<K, V> navigableMap = this.nm.tailMap(k, true);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedNavigableMap.<init>:(Ljava/util/NavigableMap;Ljava/lang/Object;)V");
                return new SynchronizedNavigableMap<K, V>(navigableMap, this.mutex);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NavigableMap<K, V> subMap(K k, boolean bl, K k2, boolean bl2) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$SynchronizedNavigableMap");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.subMap:(Ljava/lang/Object;ZLjava/lang/Object;Z)Ljava/util/NavigableMap;");
                NavigableMap<K, V> navigableMap = this.nm.subMap(k, bl, k2, bl2);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedNavigableMap.<init>:(Ljava/util/NavigableMap;Ljava/lang/Object;)V");
                return new SynchronizedNavigableMap<K, V>(navigableMap, this.mutex);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NavigableMap<K, V> headMap(K k, boolean bl) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$SynchronizedNavigableMap");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.headMap:(Ljava/lang/Object;Z)Ljava/util/NavigableMap;");
                NavigableMap<K, V> navigableMap = this.nm.headMap(k, bl);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedNavigableMap.<init>:(Ljava/util/NavigableMap;Ljava/lang/Object;)V");
                return new SynchronizedNavigableMap<K, V>(navigableMap, this.mutex);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NavigableMap<K, V> tailMap(K k, boolean bl) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$SynchronizedNavigableMap");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.tailMap:(Ljava/lang/Object;Z)Ljava/util/NavigableMap;");
                NavigableMap<K, V> navigableMap = this.nm.tailMap(k, bl);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedNavigableMap.<init>:(Ljava/util/NavigableMap;Ljava/lang/Object;)V");
                return new SynchronizedNavigableMap<K, V>(navigableMap, this.mutex);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }
    }

    static class SynchronizedSortedMap<K, V>
    extends SynchronizedMap<K, V>
    implements SortedMap<K, V> {
        private static final long serialVersionUID = -8798146769416483793L;
        private final SortedMap<K, V> sm;

        SynchronizedSortedMap(SortedMap<K, V> sortedMap) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedMap.<init>:(Ljava/util/Map;)V");
            super(sortedMap);
            this.sm = sortedMap;
        }

        SynchronizedSortedMap(SortedMap<K, V> sortedMap, Object object) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedMap.<init>:(Ljava/util/Map;Ljava/lang/Object;)V");
            super(sortedMap, object);
            this.sm = sortedMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Comparator<? super K> comparator() {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/SortedMap.comparator:()Ljava/util/Comparator;");
                return this.sm.comparator();
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedMap<K, V> subMap(K k, K k2) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$SynchronizedSortedMap");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/SortedMap.subMap:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/SortedMap;");
                SortedMap<K, V> sortedMap = this.sm.subMap(k, k2);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedSortedMap.<init>:(Ljava/util/SortedMap;Ljava/lang/Object;)V");
                return new SynchronizedSortedMap<K, V>(sortedMap, this.mutex);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedMap<K, V> headMap(K k) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$SynchronizedSortedMap");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/SortedMap.headMap:(Ljava/lang/Object;)Ljava/util/SortedMap;");
                SortedMap<K, V> sortedMap = this.sm.headMap(k);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedSortedMap.<init>:(Ljava/util/SortedMap;Ljava/lang/Object;)V");
                return new SynchronizedSortedMap<K, V>(sortedMap, this.mutex);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedMap<K, V> tailMap(K k) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$SynchronizedSortedMap");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/SortedMap.tailMap:(Ljava/lang/Object;)Ljava/util/SortedMap;");
                SortedMap<K, V> sortedMap = this.sm.tailMap(k);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedSortedMap.<init>:(Ljava/util/SortedMap;Ljava/lang/Object;)V");
                return new SynchronizedSortedMap<K, V>(sortedMap, this.mutex);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public K firstKey() {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/SortedMap.firstKey:()Ljava/lang/Object;");
                return this.sm.firstKey();
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public K lastKey() {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/SortedMap.lastKey:()Ljava/lang/Object;");
                return this.sm.lastKey();
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }
    }

    private static class SynchronizedMap<K, V>
    implements Map<K, V>,
    Serializable {
        private static final long serialVersionUID = 1978198479659022715L;
        private final Map<K, V> m;
        final Object mutex;
        private transient Set<K> keySet;
        private transient Set<Map.Entry<K, V>> entrySet;
        private transient Collection<V> values;

        SynchronizedMap(Map<K, V> map) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
            this.m = Objects.requireNonNull(map);
            this.mutex = this;
        }

        SynchronizedMap(Map<K, V> map, Object object) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.m = map;
            this.mutex = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.size:()I");
                return this.m.size();
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.isEmpty:()Z");
                return this.m.isEmpty();
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(Object object) {
            Object object2 = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
                return this.m.containsKey(object);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object object) {
            Object object2 = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsValue:(Ljava/lang/Object;)Z");
                return this.m.containsValue(object);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get(Object object) {
            Object object2 = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
                return this.m.get(object);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V put(K k, V v) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                return this.m.put(k, v);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V remove(Object object) {
            Object object2 = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
                return this.m.remove(object);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.putAll:(Ljava/util/Map;)V");
                this.m.putAll(map);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordJump();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.clear:()V");
                this.m.clear();
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordJump();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<K> keySet() {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordJump();
                if (this.keySet == null) {
                    RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$SynchronizedSet");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.keySet:()Ljava/util/Set;");
                    Set<K> set = this.m.keySet();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedSet.<init>:(Ljava/util/Set;Ljava/lang/Object;)V");
                    this.keySet = new SynchronizedSet<K>(set, this.mutex);
                }
                return this.keySet;
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordJump();
                if (this.entrySet == null) {
                    RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$SynchronizedSet");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.entrySet:()Ljava/util/Set;");
                    Set<Map.Entry<K, V>> set = this.m.entrySet();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedSet.<init>:(Ljava/util/Set;Ljava/lang/Object;)V");
                    this.entrySet = new SynchronizedSet<Map.Entry<K, V>>(set, this.mutex);
                }
                return this.entrySet;
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<V> values() {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordJump();
                if (this.values == null) {
                    RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$SynchronizedCollection");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.values:()Ljava/util/Collection;");
                    Collection<V> collection = this.m.values();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedCollection.<init>:(Ljava/util/Collection;Ljava/lang/Object;)V");
                    this.values = new SynchronizedCollection<V>(collection, this.mutex);
                }
                return this.values;
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object object) {
            RuntimeCostAccounter.recordJump();
            if (this == object) {
                return true;
            }
            Object object2 = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.equals:(Ljava/lang/Object;)Z");
                return this.m.equals(object);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.hashCode:()I");
                return this.m.hashCode();
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.toString:()Ljava/lang/String;");
                return this.m.toString();
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V getOrDefault(Object object, V v) {
            Object object2 = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.getOrDefault:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                return this.m.getOrDefault(object, v);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void forEach(BiConsumer<? super K, ? super V> biConsumer) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.forEach:(Ljava/util/function/BiConsumer;)V");
                this.m.forEach(biConsumer);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordJump();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void replaceAll(BiFunction<? super K, ? super V, ? extends V> biFunction) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.replaceAll:(Ljava/util/function/BiFunction;)V");
                this.m.replaceAll(biFunction);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordJump();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V putIfAbsent(K k, V v) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.putIfAbsent:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                return this.m.putIfAbsent(k, v);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object object, Object object2) {
            Object object3 = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;Ljava/lang/Object;)Z");
                return this.m.remove(object, object2);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean replace(K k, V v, V v2) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.replace:(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Z");
                return this.m.replace(k, v, v2);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V replace(K k, V v) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.replace:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                return this.m.replace(k, v);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V computeIfAbsent(K k, Function<? super K, ? extends V> function) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.computeIfAbsent:(Ljava/lang/Object;Ljava/util/function/Function;)Ljava/lang/Object;");
                return this.m.computeIfAbsent((K)k, function);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V computeIfPresent(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.computeIfPresent:(Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;");
                return this.m.computeIfPresent((K)k, (BiFunction<? super K, ? extends V, ? extends V>)biFunction);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V compute(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.compute:(Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;");
                return this.m.compute((K)k, (BiFunction<? super K, ? extends V, ? extends V>)biFunction);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V merge(K k, V v, BiFunction<? super V, ? super V, ? extends V> biFunction) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.merge:(Ljava/lang/Object;Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;");
                return this.m.merge(k, (V)v, (BiFunction<? extends V, ? extends V, ? extends V>)biFunction);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.defaultWriteObject:()V");
                objectOutputStream.defaultWriteObject();
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    static class SynchronizedRandomAccessList<E>
    extends SynchronizedList<E>
    implements RandomAccess {
        private static final long serialVersionUID = 1530674583602358482L;

        SynchronizedRandomAccessList(List<E> list) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedList.<init>:(Ljava/util/List;)V");
            super(list);
        }

        SynchronizedRandomAccessList(List<E> list, Object object) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedList.<init>:(Ljava/util/List;Ljava/lang/Object;)V");
            super(list, object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<E> subList(int n, int n2) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$SynchronizedRandomAccessList");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.subList:(II)Ljava/util/List;");
                List list = this.list.subList(n, n2);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedRandomAccessList.<init>:(Ljava/util/List;Ljava/lang/Object;)V");
                return new SynchronizedRandomAccessList(list, this.mutex);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        private Object writeReplace() {
            RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$SynchronizedList");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedList.<init>:(Ljava/util/List;)V");
            return new SynchronizedList(this.list);
        }
    }

    static class SynchronizedList<E>
    extends SynchronizedCollection<E>
    implements List<E> {
        private static final long serialVersionUID = -7754090372962971524L;
        final List<E> list;

        SynchronizedList(List<E> list) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedCollection.<init>:(Ljava/util/Collection;)V");
            super(list);
            this.list = list;
        }

        SynchronizedList(List<E> list, Object object) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedCollection.<init>:(Ljava/util/Collection;Ljava/lang/Object;)V");
            super(list, object);
            this.list = list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object object) {
            RuntimeCostAccounter.recordJump();
            if (this == object) {
                return true;
            }
            Object object2 = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.equals:(Ljava/lang/Object;)Z");
                return this.list.equals(object);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.hashCode:()I");
                return this.list.hashCode();
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E get(int n) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.get:(I)Ljava/lang/Object;");
                return this.list.get(n);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E set(int n, E e) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.set:(ILjava/lang/Object;)Ljava/lang/Object;");
                return this.list.set(n, e);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(int n, E e) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.add:(ILjava/lang/Object;)V");
                this.list.add(n, e);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordJump();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E remove(int n) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.remove:(I)Ljava/lang/Object;");
                return this.list.remove(n);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object object) {
            Object object2 = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.indexOf:(Ljava/lang/Object;)I");
                return this.list.indexOf(object);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object object) {
            Object object2 = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.lastIndexOf:(Ljava/lang/Object;)I");
                return this.list.lastIndexOf(object);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(int n, Collection<? extends E> collection) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.addAll:(ILjava/util/Collection;)Z");
                return this.list.addAll(n, collection);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        @Override
        public ListIterator<E> listIterator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.listIterator:()Ljava/util/ListIterator;");
            return this.list.listIterator();
        }

        @Override
        public ListIterator<E> listIterator(int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.listIterator:(I)Ljava/util/ListIterator;");
            return this.list.listIterator(n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<E> subList(int n, int n2) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$SynchronizedList");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.subList:(II)Ljava/util/List;");
                List<E> list = this.list.subList(n, n2);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedList.<init>:(Ljava/util/List;Ljava/lang/Object;)V");
                return new SynchronizedList<E>(list, this.mutex);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void replaceAll(UnaryOperator<E> unaryOperator) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.replaceAll:(Ljava/util/function/UnaryOperator;)V");
                this.list.replaceAll(unaryOperator);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordJump();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort(Comparator<? super E> comparator) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.sort:(Ljava/util/Comparator;)V");
                this.list.sort(comparator);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordJump();
        }

        private Object readResolve() {
            SynchronizedList synchronizedList;
            boolean bl = this.list instanceof RandomAccess;
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$SynchronizedRandomAccessList");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedRandomAccessList.<init>:(Ljava/util/List;)V");
                synchronizedList = new SynchronizedRandomAccessList<E>(this.list);
                RuntimeCostAccounter.recordJump();
            } else {
                synchronizedList = this;
            }
            return synchronizedList;
        }
    }

    static class SynchronizedNavigableSet<E>
    extends SynchronizedSortedSet<E>
    implements NavigableSet<E> {
        private static final long serialVersionUID = -5505529816273629798L;
        private final NavigableSet<E> ns;

        SynchronizedNavigableSet(NavigableSet<E> navigableSet) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedSortedSet.<init>:(Ljava/util/SortedSet;)V");
            super(navigableSet);
            this.ns = navigableSet;
        }

        SynchronizedNavigableSet(NavigableSet<E> navigableSet, Object object) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedSortedSet.<init>:(Ljava/util/SortedSet;Ljava/lang/Object;)V");
            super(navigableSet, object);
            this.ns = navigableSet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E lower(E e) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableSet.lower:(Ljava/lang/Object;)Ljava/lang/Object;");
                return this.ns.lower(e);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E floor(E e) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableSet.floor:(Ljava/lang/Object;)Ljava/lang/Object;");
                return this.ns.floor(e);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E ceiling(E e) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableSet.ceiling:(Ljava/lang/Object;)Ljava/lang/Object;");
                return this.ns.ceiling(e);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E higher(E e) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableSet.higher:(Ljava/lang/Object;)Ljava/lang/Object;");
                return this.ns.higher(e);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E pollFirst() {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableSet.pollFirst:()Ljava/lang/Object;");
                return this.ns.pollFirst();
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E pollLast() {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableSet.pollLast:()Ljava/lang/Object;");
                return this.ns.pollLast();
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NavigableSet<E> descendingSet() {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$SynchronizedNavigableSet");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableSet.descendingSet:()Ljava/util/NavigableSet;");
                NavigableSet<E> navigableSet = this.ns.descendingSet();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedNavigableSet.<init>:(Ljava/util/NavigableSet;Ljava/lang/Object;)V");
                return new SynchronizedNavigableSet<E>(navigableSet, this.mutex);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Iterator<E> descendingIterator() {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedNavigableSet.descendingSet:()Ljava/util/NavigableSet;");
                NavigableSet<E> navigableSet = this.descendingSet();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableSet.iterator:()Ljava/util/Iterator;");
                return navigableSet.iterator();
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NavigableSet<E> subSet(E e, E e2) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$SynchronizedNavigableSet");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableSet.subSet:(Ljava/lang/Object;ZLjava/lang/Object;Z)Ljava/util/NavigableSet;");
                NavigableSet<E> navigableSet = this.ns.subSet(e, true, e2, false);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedNavigableSet.<init>:(Ljava/util/NavigableSet;Ljava/lang/Object;)V");
                return new SynchronizedNavigableSet<E>(navigableSet, this.mutex);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NavigableSet<E> headSet(E e) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$SynchronizedNavigableSet");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableSet.headSet:(Ljava/lang/Object;Z)Ljava/util/NavigableSet;");
                NavigableSet<E> navigableSet = this.ns.headSet(e, false);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedNavigableSet.<init>:(Ljava/util/NavigableSet;Ljava/lang/Object;)V");
                return new SynchronizedNavigableSet<E>(navigableSet, this.mutex);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NavigableSet<E> tailSet(E e) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$SynchronizedNavigableSet");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableSet.tailSet:(Ljava/lang/Object;Z)Ljava/util/NavigableSet;");
                NavigableSet<E> navigableSet = this.ns.tailSet(e, true);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedNavigableSet.<init>:(Ljava/util/NavigableSet;Ljava/lang/Object;)V");
                return new SynchronizedNavigableSet<E>(navigableSet, this.mutex);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NavigableSet<E> subSet(E e, boolean bl, E e2, boolean bl2) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$SynchronizedNavigableSet");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableSet.subSet:(Ljava/lang/Object;ZLjava/lang/Object;Z)Ljava/util/NavigableSet;");
                NavigableSet<E> navigableSet = this.ns.subSet(e, bl, e2, bl2);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedNavigableSet.<init>:(Ljava/util/NavigableSet;Ljava/lang/Object;)V");
                return new SynchronizedNavigableSet<E>(navigableSet, this.mutex);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NavigableSet<E> headSet(E e, boolean bl) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$SynchronizedNavigableSet");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableSet.headSet:(Ljava/lang/Object;Z)Ljava/util/NavigableSet;");
                NavigableSet<E> navigableSet = this.ns.headSet(e, bl);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedNavigableSet.<init>:(Ljava/util/NavigableSet;Ljava/lang/Object;)V");
                return new SynchronizedNavigableSet<E>(navigableSet, this.mutex);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NavigableSet<E> tailSet(E e, boolean bl) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$SynchronizedNavigableSet");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableSet.tailSet:(Ljava/lang/Object;Z)Ljava/util/NavigableSet;");
                NavigableSet<E> navigableSet = this.ns.tailSet(e, bl);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedNavigableSet.<init>:(Ljava/util/NavigableSet;)V");
                return new SynchronizedNavigableSet<E>(navigableSet);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }
    }

    static class SynchronizedSortedSet<E>
    extends SynchronizedSet<E>
    implements SortedSet<E> {
        private static final long serialVersionUID = 8695801310862127406L;
        private final SortedSet<E> ss;

        SynchronizedSortedSet(SortedSet<E> sortedSet) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedSet.<init>:(Ljava/util/Set;)V");
            super(sortedSet);
            this.ss = sortedSet;
        }

        SynchronizedSortedSet(SortedSet<E> sortedSet, Object object) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedSet.<init>:(Ljava/util/Set;Ljava/lang/Object;)V");
            super(sortedSet, object);
            this.ss = sortedSet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Comparator<? super E> comparator() {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/SortedSet.comparator:()Ljava/util/Comparator;");
                return this.ss.comparator();
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedSet<E> subSet(E e, E e2) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$SynchronizedSortedSet");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/SortedSet.subSet:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/SortedSet;");
                SortedSet<E> sortedSet = this.ss.subSet(e, e2);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedSortedSet.<init>:(Ljava/util/SortedSet;Ljava/lang/Object;)V");
                return new SynchronizedSortedSet<E>(sortedSet, this.mutex);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedSet<E> headSet(E e) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$SynchronizedSortedSet");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/SortedSet.headSet:(Ljava/lang/Object;)Ljava/util/SortedSet;");
                SortedSet<E> sortedSet = this.ss.headSet(e);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedSortedSet.<init>:(Ljava/util/SortedSet;Ljava/lang/Object;)V");
                return new SynchronizedSortedSet<E>(sortedSet, this.mutex);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedSet<E> tailSet(E e) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$SynchronizedSortedSet");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/SortedSet.tailSet:(Ljava/lang/Object;)Ljava/util/SortedSet;");
                SortedSet<E> sortedSet = this.ss.tailSet(e);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedSortedSet.<init>:(Ljava/util/SortedSet;Ljava/lang/Object;)V");
                return new SynchronizedSortedSet<E>(sortedSet, this.mutex);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E first() {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/SortedSet.first:()Ljava/lang/Object;");
                return this.ss.first();
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E last() {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/SortedSet.last:()Ljava/lang/Object;");
                return this.ss.last();
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }
    }

    static class SynchronizedSet<E>
    extends SynchronizedCollection<E>
    implements Set<E> {
        private static final long serialVersionUID = 487447009682186044L;

        SynchronizedSet(Set<E> set) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedCollection.<init>:(Ljava/util/Collection;)V");
            super(set);
        }

        SynchronizedSet(Set<E> set, Object object) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$SynchronizedCollection.<init>:(Ljava/util/Collection;Ljava/lang/Object;)V");
            super(set, object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object object) {
            RuntimeCostAccounter.recordJump();
            if (this == object) {
                return true;
            }
            Object object2 = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.equals:(Ljava/lang/Object;)Z");
                return this.c.equals(object);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.hashCode:()I");
                return this.c.hashCode();
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }
    }

    static class SynchronizedCollection<E>
    implements Collection<E>,
    Serializable {
        private static final long serialVersionUID = 3053995032091335093L;
        final Collection<E> c;
        final Object mutex;

        SynchronizedCollection(Collection<E> collection) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
            this.c = Objects.requireNonNull(collection);
            this.mutex = this;
        }

        SynchronizedCollection(Collection<E> collection, Object object) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
            this.c = Objects.requireNonNull(collection);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
            this.mutex = Objects.requireNonNull(object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.size:()I");
                return this.c.size();
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.isEmpty:()Z");
                return this.c.isEmpty();
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object object) {
            Object object2 = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.contains:(Ljava/lang/Object;)Z");
                return this.c.contains(object);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.toArray:()[Ljava/lang/Object;");
                return this.c.toArray();
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] TArray) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.toArray:([Ljava/lang/Object;)[Ljava/lang/Object;");
                return this.c.toArray(TArray);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        @Override
        public Iterator<E> iterator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.iterator:()Ljava/util/Iterator;");
            return this.c.iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(E e) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.add:(Ljava/lang/Object;)Z");
                return this.c.add(e);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object object) {
            Object object2 = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.remove:(Ljava/lang/Object;)Z");
                return this.c.remove(object);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsAll(Collection<?> collection) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.containsAll:(Ljava/util/Collection;)Z");
                return this.c.containsAll(collection);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(Collection<? extends E> collection) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.addAll:(Ljava/util/Collection;)Z");
                return this.c.addAll(collection);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection<?> collection) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.removeAll:(Ljava/util/Collection;)Z");
                return this.c.removeAll(collection);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> collection) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.retainAll:(Ljava/util/Collection;)Z");
                return this.c.retainAll(collection);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.clear:()V");
                this.c.clear();
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordJump();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.toString:()Ljava/lang/String;");
                return this.c.toString();
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void forEach(Consumer<? super E> consumer) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.forEach:(Ljava/util/function/Consumer;)V");
                this.c.forEach(consumer);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordJump();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeIf(Predicate<? super E> predicate) {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.removeIf:(Ljava/util/function/Predicate;)Z");
                return this.c.removeIf(predicate);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }

        @Override
        public Spliterator<E> spliterator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.spliterator:()Ljava/util/Spliterator;");
            return this.c.spliterator();
        }

        @Override
        public Stream<E> stream() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.stream:()Ljava/util/stream/Stream;");
            return this.c.stream();
        }

        @Override
        public Stream<E> parallelStream() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.parallelStream:()Ljava/util/stream/Stream;");
            return this.c.parallelStream();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            Object object = this.mutex;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.defaultWriteObject:()V");
                objectOutputStream.defaultWriteObject();
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    static class UnmodifiableNavigableMap<K, V>
    extends UnmodifiableSortedMap<K, V>
    implements NavigableMap<K, V>,
    Serializable {
        private static final long serialVersionUID = -4858195264774772197L;
        private static final EmptyNavigableMap<?, ?> EMPTY_NAVIGABLE_MAP;
        private final NavigableMap<K, ? extends V> nm;

        UnmodifiableNavigableMap(NavigableMap<K, ? extends V> navigableMap) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableSortedMap.<init>:(Ljava/util/SortedMap;)V");
            super(navigableMap);
            this.nm = navigableMap;
        }

        @Override
        public K lowerKey(K k) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.lowerKey:(Ljava/lang/Object;)Ljava/lang/Object;");
            return this.nm.lowerKey(k);
        }

        @Override
        public K floorKey(K k) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.floorKey:(Ljava/lang/Object;)Ljava/lang/Object;");
            return this.nm.floorKey(k);
        }

        @Override
        public K ceilingKey(K k) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.ceilingKey:(Ljava/lang/Object;)Ljava/lang/Object;");
            return this.nm.ceilingKey(k);
        }

        @Override
        public K higherKey(K k) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.higherKey:(Ljava/lang/Object;)Ljava/lang/Object;");
            return this.nm.higherKey(k);
        }

        @Override
        public Map.Entry<K, V> lowerEntry(K k) {
            UnmodifiableMap.UnmodifiableEntrySet.UnmodifiableEntry<K, ? extends V> unmodifiableEntry;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.lowerEntry:(Ljava/lang/Object;)Ljava/util/Map$Entry;");
            Map.Entry<K, ? extends V> entry = this.nm.lowerEntry(k);
            RuntimeCostAccounter.recordJump();
            if (null != entry) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$UnmodifiableMap$UnmodifiableEntrySet$UnmodifiableEntry");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableMap$UnmodifiableEntrySet$UnmodifiableEntry.<init>:(Ljava/util/Map$Entry;)V");
                unmodifiableEntry = new UnmodifiableMap.UnmodifiableEntrySet.UnmodifiableEntry<K, V>(entry);
                RuntimeCostAccounter.recordJump();
            } else {
                unmodifiableEntry = null;
            }
            return unmodifiableEntry;
        }

        @Override
        public Map.Entry<K, V> floorEntry(K k) {
            UnmodifiableMap.UnmodifiableEntrySet.UnmodifiableEntry<K, ? extends V> unmodifiableEntry;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.floorEntry:(Ljava/lang/Object;)Ljava/util/Map$Entry;");
            Map.Entry<K, ? extends V> entry = this.nm.floorEntry(k);
            RuntimeCostAccounter.recordJump();
            if (null != entry) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$UnmodifiableMap$UnmodifiableEntrySet$UnmodifiableEntry");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableMap$UnmodifiableEntrySet$UnmodifiableEntry.<init>:(Ljava/util/Map$Entry;)V");
                unmodifiableEntry = new UnmodifiableMap.UnmodifiableEntrySet.UnmodifiableEntry<K, V>(entry);
                RuntimeCostAccounter.recordJump();
            } else {
                unmodifiableEntry = null;
            }
            return unmodifiableEntry;
        }

        @Override
        public Map.Entry<K, V> ceilingEntry(K k) {
            UnmodifiableMap.UnmodifiableEntrySet.UnmodifiableEntry<K, ? extends V> unmodifiableEntry;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.ceilingEntry:(Ljava/lang/Object;)Ljava/util/Map$Entry;");
            Map.Entry<K, ? extends V> entry = this.nm.ceilingEntry(k);
            RuntimeCostAccounter.recordJump();
            if (null != entry) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$UnmodifiableMap$UnmodifiableEntrySet$UnmodifiableEntry");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableMap$UnmodifiableEntrySet$UnmodifiableEntry.<init>:(Ljava/util/Map$Entry;)V");
                unmodifiableEntry = new UnmodifiableMap.UnmodifiableEntrySet.UnmodifiableEntry<K, V>(entry);
                RuntimeCostAccounter.recordJump();
            } else {
                unmodifiableEntry = null;
            }
            return unmodifiableEntry;
        }

        @Override
        public Map.Entry<K, V> higherEntry(K k) {
            UnmodifiableMap.UnmodifiableEntrySet.UnmodifiableEntry<K, ? extends V> unmodifiableEntry;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.higherEntry:(Ljava/lang/Object;)Ljava/util/Map$Entry;");
            Map.Entry<K, ? extends V> entry = this.nm.higherEntry(k);
            RuntimeCostAccounter.recordJump();
            if (null != entry) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$UnmodifiableMap$UnmodifiableEntrySet$UnmodifiableEntry");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableMap$UnmodifiableEntrySet$UnmodifiableEntry.<init>:(Ljava/util/Map$Entry;)V");
                unmodifiableEntry = new UnmodifiableMap.UnmodifiableEntrySet.UnmodifiableEntry<K, V>(entry);
                RuntimeCostAccounter.recordJump();
            } else {
                unmodifiableEntry = null;
            }
            return unmodifiableEntry;
        }

        @Override
        public Map.Entry<K, V> firstEntry() {
            UnmodifiableMap.UnmodifiableEntrySet.UnmodifiableEntry<K, ? extends V> unmodifiableEntry;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.firstEntry:()Ljava/util/Map$Entry;");
            Map.Entry<K, ? extends V> entry = this.nm.firstEntry();
            RuntimeCostAccounter.recordJump();
            if (null != entry) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$UnmodifiableMap$UnmodifiableEntrySet$UnmodifiableEntry");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableMap$UnmodifiableEntrySet$UnmodifiableEntry.<init>:(Ljava/util/Map$Entry;)V");
                unmodifiableEntry = new UnmodifiableMap.UnmodifiableEntrySet.UnmodifiableEntry<K, V>(entry);
                RuntimeCostAccounter.recordJump();
            } else {
                unmodifiableEntry = null;
            }
            return unmodifiableEntry;
        }

        @Override
        public Map.Entry<K, V> lastEntry() {
            UnmodifiableMap.UnmodifiableEntrySet.UnmodifiableEntry<K, ? extends V> unmodifiableEntry;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.lastEntry:()Ljava/util/Map$Entry;");
            Map.Entry<K, ? extends V> entry = this.nm.lastEntry();
            RuntimeCostAccounter.recordJump();
            if (null != entry) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$UnmodifiableMap$UnmodifiableEntrySet$UnmodifiableEntry");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableMap$UnmodifiableEntrySet$UnmodifiableEntry.<init>:(Ljava/util/Map$Entry;)V");
                unmodifiableEntry = new UnmodifiableMap.UnmodifiableEntrySet.UnmodifiableEntry<K, V>(entry);
                RuntimeCostAccounter.recordJump();
            } else {
                unmodifiableEntry = null;
            }
            return unmodifiableEntry;
        }

        @Override
        public Map.Entry<K, V> pollFirstEntry() {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }

        @Override
        public Map.Entry<K, V> pollLastEntry() {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }

        @Override
        public NavigableMap<K, V> descendingMap() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.descendingMap:()Ljava/util/NavigableMap;");
            NavigableMap<K, ? extends V> navigableMap = this.nm.descendingMap();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.unmodifiableNavigableMap:(Ljava/util/NavigableMap;)Ljava/util/NavigableMap;");
            return Collections.unmodifiableNavigableMap(navigableMap);
        }

        @Override
        public NavigableSet<K> navigableKeySet() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.navigableKeySet:()Ljava/util/NavigableSet;");
            NavigableSet<K> navigableSet = this.nm.navigableKeySet();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.unmodifiableNavigableSet:(Ljava/util/NavigableSet;)Ljava/util/NavigableSet;");
            return Collections.unmodifiableNavigableSet(navigableSet);
        }

        @Override
        public NavigableSet<K> descendingKeySet() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.descendingKeySet:()Ljava/util/NavigableSet;");
            NavigableSet<K> navigableSet = this.nm.descendingKeySet();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.unmodifiableNavigableSet:(Ljava/util/NavigableSet;)Ljava/util/NavigableSet;");
            return Collections.unmodifiableNavigableSet(navigableSet);
        }

        @Override
        public NavigableMap<K, V> subMap(K k, boolean bl, K k2, boolean bl2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.subMap:(Ljava/lang/Object;ZLjava/lang/Object;Z)Ljava/util/NavigableMap;");
            NavigableMap<K, ? extends V> navigableMap = this.nm.subMap(k, bl, k2, bl2);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.unmodifiableNavigableMap:(Ljava/util/NavigableMap;)Ljava/util/NavigableMap;");
            return Collections.unmodifiableNavigableMap(navigableMap);
        }

        @Override
        public NavigableMap<K, V> headMap(K k, boolean bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.headMap:(Ljava/lang/Object;Z)Ljava/util/NavigableMap;");
            NavigableMap<K, ? extends V> navigableMap = this.nm.headMap(k, bl);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.unmodifiableNavigableMap:(Ljava/util/NavigableMap;)Ljava/util/NavigableMap;");
            return Collections.unmodifiableNavigableMap(navigableMap);
        }

        @Override
        public NavigableMap<K, V> tailMap(K k, boolean bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableMap.tailMap:(Ljava/lang/Object;Z)Ljava/util/NavigableMap;");
            NavigableMap<K, ? extends V> navigableMap = this.nm.tailMap(k, bl);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.unmodifiableNavigableMap:(Ljava/util/NavigableMap;)Ljava/util/NavigableMap;");
            return Collections.unmodifiableNavigableMap(navigableMap);
        }

        static {
            RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$UnmodifiableNavigableMap$EmptyNavigableMap");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableNavigableMap$EmptyNavigableMap.<init>:()V");
            EMPTY_NAVIGABLE_MAP = new EmptyNavigableMap();
        }

        private static class EmptyNavigableMap<K, V>
        extends UnmodifiableNavigableMap<K, V>
        implements Serializable {
            private static final long serialVersionUID = -2239321462712562324L;

            EmptyNavigableMap() {
                RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.<init>:()V");
                TreeMap treeMap = new TreeMap();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableNavigableMap.<init>:(Ljava/util/NavigableMap;)V");
                super(treeMap);
            }

            @Override
            public NavigableSet<K> navigableKeySet() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.emptyNavigableSet:()Ljava/util/NavigableSet;");
                return Collections.emptyNavigableSet();
            }

            private Object readResolve() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableNavigableMap.access$100:()Ljava/util/Collections$UnmodifiableNavigableMap$EmptyNavigableMap;");
                return EMPTY_NAVIGABLE_MAP;
            }
        }
    }

    static class UnmodifiableSortedMap<K, V>
    extends UnmodifiableMap<K, V>
    implements SortedMap<K, V>,
    Serializable {
        private static final long serialVersionUID = -8806743815996713206L;
        private final SortedMap<K, ? extends V> sm;

        UnmodifiableSortedMap(SortedMap<K, ? extends V> sortedMap) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableMap.<init>:(Ljava/util/Map;)V");
            super(sortedMap);
            this.sm = sortedMap;
        }

        @Override
        public Comparator<? super K> comparator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/SortedMap.comparator:()Ljava/util/Comparator;");
            return this.sm.comparator();
        }

        @Override
        public SortedMap<K, V> subMap(K k, K k2) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$UnmodifiableSortedMap");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/SortedMap.subMap:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/SortedMap;");
            SortedMap<K, ? extends V> sortedMap = this.sm.subMap(k, k2);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableSortedMap.<init>:(Ljava/util/SortedMap;)V");
            return new UnmodifiableSortedMap<K, V>(sortedMap);
        }

        @Override
        public SortedMap<K, V> headMap(K k) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$UnmodifiableSortedMap");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/SortedMap.headMap:(Ljava/lang/Object;)Ljava/util/SortedMap;");
            SortedMap<K, ? extends V> sortedMap = this.sm.headMap(k);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableSortedMap.<init>:(Ljava/util/SortedMap;)V");
            return new UnmodifiableSortedMap<K, V>(sortedMap);
        }

        @Override
        public SortedMap<K, V> tailMap(K k) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$UnmodifiableSortedMap");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/SortedMap.tailMap:(Ljava/lang/Object;)Ljava/util/SortedMap;");
            SortedMap<K, ? extends V> sortedMap = this.sm.tailMap(k);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableSortedMap.<init>:(Ljava/util/SortedMap;)V");
            return new UnmodifiableSortedMap<K, V>(sortedMap);
        }

        @Override
        public K firstKey() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/SortedMap.firstKey:()Ljava/lang/Object;");
            return this.sm.firstKey();
        }

        @Override
        public K lastKey() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/SortedMap.lastKey:()Ljava/lang/Object;");
            return this.sm.lastKey();
        }
    }

    private static class UnmodifiableMap<K, V>
    implements Map<K, V>,
    Serializable {
        private static final long serialVersionUID = -1034234728574286014L;
        private final Map<? extends K, ? extends V> m;
        private transient Set<K> keySet;
        private transient Set<Map.Entry<K, V>> entrySet;
        private transient Collection<V> values;

        UnmodifiableMap(Map<? extends K, ? extends V> map) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            RuntimeCostAccounter.recordJump();
            if (map == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            this.m = map;
        }

        @Override
        public int size() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.size:()I");
            return this.m.size();
        }

        @Override
        public boolean isEmpty() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.isEmpty:()Z");
            return this.m.isEmpty();
        }

        @Override
        public boolean containsKey(Object object) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
            return this.m.containsKey(object);
        }

        @Override
        public boolean containsValue(Object object) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsValue:(Ljava/lang/Object;)Z");
            return this.m.containsValue(object);
        }

        @Override
        public V get(Object object) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
            return this.m.get(object);
        }

        @Override
        public V put(K k, V v) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }

        @Override
        public V remove(Object object) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }

        @Override
        public void clear() {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }

        @Override
        public Set<K> keySet() {
            RuntimeCostAccounter.recordJump();
            if (this.keySet == null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.keySet:()Ljava/util/Set;");
                Set<? extends K> set = this.m.keySet();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.unmodifiableSet:(Ljava/util/Set;)Ljava/util/Set;");
                this.keySet = Collections.unmodifiableSet(set);
            }
            return this.keySet;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            RuntimeCostAccounter.recordJump();
            if (this.entrySet == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$UnmodifiableMap$UnmodifiableEntrySet");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.entrySet:()Ljava/util/Set;");
                Set<Map.Entry<? extends K, ? extends V>> set = this.m.entrySet();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableMap$UnmodifiableEntrySet.<init>:(Ljava/util/Set;)V");
                this.entrySet = new UnmodifiableEntrySet<K, V>(set);
            }
            return this.entrySet;
        }

        @Override
        public Collection<V> values() {
            RuntimeCostAccounter.recordJump();
            if (this.values == null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.values:()Ljava/util/Collection;");
                Collection<? extends V> collection = this.m.values();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.unmodifiableCollection:(Ljava/util/Collection;)Ljava/util/Collection;");
                this.values = Collections.unmodifiableCollection(collection);
            }
            return this.values;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object object) {
            RuntimeCostAccounter.recordJump();
            if (object != this) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.equals:(Ljava/lang/Object;)Z");
                boolean bl = this.m.equals(object);
                RuntimeCostAccounter.recordJump();
                if (!bl) return false;
            }
            boolean bl = true;
            RuntimeCostAccounter.recordJump();
            return bl;
        }

        @Override
        public int hashCode() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.hashCode:()I");
            return this.m.hashCode();
        }

        public String toString() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.toString:()Ljava/lang/String;");
            return this.m.toString();
        }

        @Override
        public V getOrDefault(Object object, V v) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.getOrDefault:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            return this.m.getOrDefault(object, v);
        }

        @Override
        public void forEach(BiConsumer<? super K, ? super V> biConsumer) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.forEach:(Ljava/util/function/BiConsumer;)V");
            this.m.forEach(biConsumer);
        }

        @Override
        public void replaceAll(BiFunction<? super K, ? super V, ? extends V> biFunction) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }

        @Override
        public V putIfAbsent(K k, V v) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }

        @Override
        public boolean remove(Object object, Object object2) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }

        @Override
        public boolean replace(K k, V v, V v2) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }

        @Override
        public V replace(K k, V v) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }

        @Override
        public V computeIfAbsent(K k, Function<? super K, ? extends V> function) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }

        @Override
        public V computeIfPresent(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }

        @Override
        public V compute(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }

        @Override
        public V merge(K k, V v, BiFunction<? super V, ? super V, ? extends V> biFunction) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }

        static class UnmodifiableEntrySet<K, V>
        extends UnmodifiableSet<Map.Entry<K, V>> {
            private static final long serialVersionUID = 7854390611657943733L;

            UnmodifiableEntrySet(Set<? extends Map.Entry<? extends K, ? extends V>> set) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableSet.<init>:(Ljava/util/Set;)V");
                super(set);
            }

            static <K, V> Consumer<Map.Entry<K, V>> entryConsumer(Consumer<? super Map.Entry<K, V>> consumer) {
                return entry -> {
                    RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$UnmodifiableMap$UnmodifiableEntrySet$UnmodifiableEntry");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableMap$UnmodifiableEntrySet$UnmodifiableEntry.<init>:(Ljava/util/Map$Entry;)V");
                    UnmodifiableEntry unmodifiableEntry = new UnmodifiableEntry(entry);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
                    consumer.accept(unmodifiableEntry);
                };
            }

            @Override
            public void forEach(Consumer<? super Map.Entry<K, V>> consumer) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
                Objects.requireNonNull(consumer);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableMap$UnmodifiableEntrySet.entryConsumer:(Ljava/util/function/Consumer;)Ljava/util/function/Consumer;");
                Consumer<Map.Entry<K, V>> consumer2 = UnmodifiableEntrySet.entryConsumer(consumer);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.forEach:(Ljava/util/function/Consumer;)V");
                this.c.forEach(consumer2);
            }

            @Override
            public Spliterator<Map.Entry<K, V>> spliterator() {
                RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$UnmodifiableMap$UnmodifiableEntrySet$UnmodifiableEntrySetSpliterator");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.spliterator:()Ljava/util/Spliterator;");
                Spliterator spliterator = this.c.spliterator();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableMap$UnmodifiableEntrySet$UnmodifiableEntrySetSpliterator.<init>:(Ljava/util/Spliterator;)V");
                return new UnmodifiableEntrySetSpliterator(spliterator);
            }

            @Override
            public Stream<Map.Entry<K, V>> stream() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableMap$UnmodifiableEntrySet.spliterator:()Ljava/util/Spliterator;");
                Spliterator<Map.Entry<K, V>> spliterator = this.spliterator();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.stream:(Ljava/util/Spliterator;Z)Ljava/util/stream/Stream;");
                return StreamSupport.stream(spliterator, false);
            }

            @Override
            public Stream<Map.Entry<K, V>> parallelStream() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableMap$UnmodifiableEntrySet.spliterator:()Ljava/util/Spliterator;");
                Spliterator<Map.Entry<K, V>> spliterator = this.spliterator();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.stream:(Ljava/util/Spliterator;Z)Ljava/util/stream/Stream;");
                return StreamSupport.stream(spliterator, true);
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$UnmodifiableMap$UnmodifiableEntrySet$1");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableMap$UnmodifiableEntrySet$1.<init>:(Ljava/util/Collections$UnmodifiableMap$UnmodifiableEntrySet;)V");
                return new Iterator<Map.Entry<K, V>>(){
                    private final Iterator<? extends Map.Entry<? extends K, ? extends V>> i;
                    {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                        Collection collection = c;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.iterator:()Ljava/util/Iterator;");
                        this.i = collection.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                        return this.i.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$UnmodifiableMap$UnmodifiableEntrySet$UnmodifiableEntry");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableMap$UnmodifiableEntrySet$UnmodifiableEntry.<init>:(Ljava/util/Map$Entry;)V");
                        return new UnmodifiableEntry(this.i.next());
                    }

                    @Override
                    public void remove() {
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
                        UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
                        RuntimeCostAccounter.recordThrow();
                        throw unsupportedOperationException;
                    }
                };
            }

            @Override
            public Object[] toArray() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.toArray:()[Ljava/lang/Object;");
                Object[] objectArray = this.c.toArray();
                int n = 0;
                while (true) {
                    int n2 = objectArray.length;
                    RuntimeCostAccounter.recordJump();
                    if (n >= n2) break;
                    RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$UnmodifiableMap$UnmodifiableEntrySet$UnmodifiableEntry");
                    Map.Entry entry = (Map.Entry)objectArray[n];
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableMap$UnmodifiableEntrySet$UnmodifiableEntry.<init>:(Ljava/util/Map$Entry;)V");
                    objectArray[n] = new UnmodifiableEntry(entry);
                    ++n;
                    RuntimeCostAccounter.recordJump();
                }
                return objectArray;
            }

            @Override
            public <T> T[] toArray(T[] TArray) {
                T[] TArray2;
                int n = TArray.length;
                RuntimeCostAccounter.recordJump();
                if (n == 0) {
                    TArray2 = TArray;
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([Ljava/lang/Object;I)[Ljava/lang/Object;");
                    TArray2 = Arrays.copyOf(TArray, 0);
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.toArray:([Ljava/lang/Object;)[Ljava/lang/Object;");
                T[] TArray3 = this.c.toArray(TArray2);
                int n2 = 0;
                while (true) {
                    int n3 = TArray3.length;
                    RuntimeCostAccounter.recordJump();
                    if (n2 >= n3) break;
                    RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$UnmodifiableMap$UnmodifiableEntrySet$UnmodifiableEntry");
                    Map.Entry entry = (Map.Entry)TArray3[n2];
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableMap$UnmodifiableEntrySet$UnmodifiableEntry.<init>:(Ljava/util/Map$Entry;)V");
                    TArray3[n2] = new UnmodifiableEntry(entry);
                    ++n2;
                    RuntimeCostAccounter.recordJump();
                }
                int n4 = TArray3.length;
                int n5 = TArray.length;
                RuntimeCostAccounter.recordJump();
                if (n4 > n5) {
                    return TArray3;
                }
                int n6 = TArray3.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
                System.arraycopy(TArray3, 0, TArray, 0, n6);
                int n7 = TArray.length;
                int n8 = TArray3.length;
                RuntimeCostAccounter.recordJump();
                if (n7 > n8) {
                    TArray[TArray3.length] = null;
                }
                return TArray;
            }

            @Override
            public boolean contains(Object object) {
                boolean bl = object instanceof Map.Entry;
                RuntimeCostAccounter.recordJump();
                if (!bl) {
                    return false;
                }
                RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$UnmodifiableMap$UnmodifiableEntrySet$UnmodifiableEntry");
                Map.Entry entry = (Map.Entry)object;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableMap$UnmodifiableEntrySet$UnmodifiableEntry.<init>:(Ljava/util/Map$Entry;)V");
                UnmodifiableEntry unmodifiableEntry = new UnmodifiableEntry(entry);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.contains:(Ljava/lang/Object;)Z");
                return this.c.contains(unmodifiableEntry);
            }

            @Override
            public boolean containsAll(Collection<?> collection) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.iterator:()Ljava/util/Iterator;");
                Iterator<?> iterator = collection.iterator();
                while (true) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                    boolean bl = iterator.hasNext();
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                    Object obj = iterator.next();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableMap$UnmodifiableEntrySet.contains:(Ljava/lang/Object;)Z");
                    boolean bl2 = this.contains(obj);
                    RuntimeCostAccounter.recordJump();
                    if (!bl2) {
                        return false;
                    }
                    RuntimeCostAccounter.recordJump();
                }
                return true;
            }

            @Override
            public boolean equals(Object object) {
                RuntimeCostAccounter.recordJump();
                if (object == this) {
                    return true;
                }
                boolean bl = object instanceof Set;
                RuntimeCostAccounter.recordJump();
                if (!bl) {
                    return false;
                }
                Set set = (Set)object;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.size:()I");
                int n = set.size();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.size:()I");
                int n2 = this.c.size();
                RuntimeCostAccounter.recordJump();
                if (n != n2) {
                    return false;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableMap$UnmodifiableEntrySet.containsAll:(Ljava/util/Collection;)Z");
                return this.containsAll(set);
            }

            private static class UnmodifiableEntry<K, V>
            implements Map.Entry<K, V> {
                private Map.Entry<? extends K, ? extends V> e;

                UnmodifiableEntry(Map.Entry<? extends K, ? extends V> entry) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
                    this.e = Objects.requireNonNull(entry);
                }

                @Override
                public K getKey() {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
                    return this.e.getKey();
                }

                @Override
                public V getValue() {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
                    return this.e.getValue();
                }

                @Override
                public V setValue(V v) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
                    UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
                    RuntimeCostAccounter.recordThrow();
                    throw unsupportedOperationException;
                }

                @Override
                public int hashCode() {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.hashCode:()I");
                    return this.e.hashCode();
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public boolean equals(Object object) {
                    RuntimeCostAccounter.recordJump();
                    if (this == object) {
                        return true;
                    }
                    boolean bl = object instanceof Map.Entry;
                    RuntimeCostAccounter.recordJump();
                    if (!bl) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
                    K k = this.e.getKey();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
                    Object k2 = entry.getKey();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.eq:(Ljava/lang/Object;Ljava/lang/Object;)Z");
                    boolean bl2 = Collections.eq(k, k2);
                    RuntimeCostAccounter.recordJump();
                    if (!bl2) return false;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
                    V v = this.e.getValue();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
                    Object v2 = entry.getValue();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.eq:(Ljava/lang/Object;Ljava/lang/Object;)Z");
                    boolean bl3 = Collections.eq(v, v2);
                    RuntimeCostAccounter.recordJump();
                    if (!bl3) return false;
                    boolean bl4 = true;
                    RuntimeCostAccounter.recordJump();
                    return bl4;
                }

                public String toString() {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.toString:()Ljava/lang/String;");
                    return this.e.toString();
                }
            }

            static final class UnmodifiableEntrySetSpliterator<K, V>
            implements Spliterator<Map.Entry<K, V>> {
                final Spliterator<Map.Entry<K, V>> s;

                UnmodifiableEntrySetSpliterator(Spliterator<Map.Entry<K, V>> spliterator) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                    this.s = spliterator;
                }

                @Override
                public boolean tryAdvance(Consumer<? super Map.Entry<K, V>> consumer) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
                    Objects.requireNonNull(consumer);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableMap$UnmodifiableEntrySet.entryConsumer:(Ljava/util/function/Consumer;)Ljava/util/function/Consumer;");
                    Consumer consumer2 = UnmodifiableEntrySet.entryConsumer(consumer);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterator.tryAdvance:(Ljava/util/function/Consumer;)Z");
                    return this.s.tryAdvance(consumer2);
                }

                @Override
                public void forEachRemaining(Consumer<? super Map.Entry<K, V>> consumer) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
                    Objects.requireNonNull(consumer);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableMap$UnmodifiableEntrySet.entryConsumer:(Ljava/util/function/Consumer;)Ljava/util/function/Consumer;");
                    Consumer consumer2 = UnmodifiableEntrySet.entryConsumer(consumer);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterator.forEachRemaining:(Ljava/util/function/Consumer;)V");
                    this.s.forEachRemaining(consumer2);
                }

                @Override
                public Spliterator<Map.Entry<K, V>> trySplit() {
                    UnmodifiableEntrySetSpliterator<K, V> unmodifiableEntrySetSpliterator;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterator.trySplit:()Ljava/util/Spliterator;");
                    Spliterator<Map.Entry<K, V>> spliterator = this.s.trySplit();
                    RuntimeCostAccounter.recordJump();
                    if (spliterator == null) {
                        unmodifiableEntrySetSpliterator = null;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$UnmodifiableMap$UnmodifiableEntrySet$UnmodifiableEntrySetSpliterator");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableMap$UnmodifiableEntrySet$UnmodifiableEntrySetSpliterator.<init>:(Ljava/util/Spliterator;)V");
                        unmodifiableEntrySetSpliterator = new UnmodifiableEntrySetSpliterator<K, V>(spliterator);
                    }
                    return unmodifiableEntrySetSpliterator;
                }

                @Override
                public long estimateSize() {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterator.estimateSize:()J");
                    return this.s.estimateSize();
                }

                @Override
                public long getExactSizeIfKnown() {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterator.getExactSizeIfKnown:()J");
                    return this.s.getExactSizeIfKnown();
                }

                @Override
                public int characteristics() {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterator.characteristics:()I");
                    return this.s.characteristics();
                }

                @Override
                public boolean hasCharacteristics(int n) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterator.hasCharacteristics:(I)Z");
                    return this.s.hasCharacteristics(n);
                }

                @Override
                public Comparator<? super Map.Entry<K, V>> getComparator() {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterator.getComparator:()Ljava/util/Comparator;");
                    return this.s.getComparator();
                }
            }
        }
    }

    static class UnmodifiableRandomAccessList<E>
    extends UnmodifiableList<E>
    implements RandomAccess {
        private static final long serialVersionUID = -2542308836966382001L;

        UnmodifiableRandomAccessList(List<? extends E> list) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableList.<init>:(Ljava/util/List;)V");
            super(list);
        }

        @Override
        public List<E> subList(int n, int n2) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$UnmodifiableRandomAccessList");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.subList:(II)Ljava/util/List;");
            List list = this.list.subList(n, n2);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableRandomAccessList.<init>:(Ljava/util/List;)V");
            return new UnmodifiableRandomAccessList(list);
        }

        private Object writeReplace() {
            RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$UnmodifiableList");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableList.<init>:(Ljava/util/List;)V");
            return new UnmodifiableList(this.list);
        }
    }

    static class UnmodifiableList<E>
    extends UnmodifiableCollection<E>
    implements List<E> {
        private static final long serialVersionUID = -283967356065247728L;
        final List<? extends E> list;

        UnmodifiableList(List<? extends E> list) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableCollection.<init>:(Ljava/util/Collection;)V");
            super(list);
            this.list = list;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object object) {
            RuntimeCostAccounter.recordJump();
            if (object != this) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.equals:(Ljava/lang/Object;)Z");
                boolean bl = this.list.equals(object);
                RuntimeCostAccounter.recordJump();
                if (!bl) return false;
            }
            boolean bl = true;
            RuntimeCostAccounter.recordJump();
            return bl;
        }

        @Override
        public int hashCode() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.hashCode:()I");
            return this.list.hashCode();
        }

        @Override
        public E get(int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.get:(I)Ljava/lang/Object;");
            return this.list.get(n);
        }

        @Override
        public E set(int n, E e) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }

        @Override
        public void add(int n, E e) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }

        @Override
        public E remove(int n) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }

        @Override
        public int indexOf(Object object) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.indexOf:(Ljava/lang/Object;)I");
            return this.list.indexOf(object);
        }

        @Override
        public int lastIndexOf(Object object) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.lastIndexOf:(Ljava/lang/Object;)I");
            return this.list.lastIndexOf(object);
        }

        @Override
        public boolean addAll(int n, Collection<? extends E> collection) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }

        @Override
        public void replaceAll(UnaryOperator<E> unaryOperator) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }

        @Override
        public void sort(Comparator<? super E> comparator) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }

        @Override
        public ListIterator<E> listIterator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableList.listIterator:(I)Ljava/util/ListIterator;");
            return this.listIterator(0);
        }

        @Override
        public ListIterator<E> listIterator(final int n) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$UnmodifiableList$1");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableList$1.<init>:(Ljava/util/Collections$UnmodifiableList;I)V");
            return new ListIterator<E>(){
                private final ListIterator<? extends E> i;
                {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                    List list = list;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/List.listIterator:(I)Ljava/util/ListIterator;");
                    this.i = list.listIterator(n);
                }

                @Override
                public boolean hasNext() {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.hasNext:()Z");
                    return this.i.hasNext();
                }

                @Override
                public E next() {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.next:()Ljava/lang/Object;");
                    return this.i.next();
                }

                @Override
                public boolean hasPrevious() {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.hasPrevious:()Z");
                    return this.i.hasPrevious();
                }

                @Override
                public E previous() {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.previous:()Ljava/lang/Object;");
                    return this.i.previous();
                }

                @Override
                public int nextIndex() {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.nextIndex:()I");
                    return this.i.nextIndex();
                }

                @Override
                public int previousIndex() {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.previousIndex:()I");
                    return this.i.previousIndex();
                }

                @Override
                public void remove() {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
                    UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
                    RuntimeCostAccounter.recordThrow();
                    throw unsupportedOperationException;
                }

                @Override
                public void set(E e) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
                    UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
                    RuntimeCostAccounter.recordThrow();
                    throw unsupportedOperationException;
                }

                @Override
                public void add(E e) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
                    UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
                    RuntimeCostAccounter.recordThrow();
                    throw unsupportedOperationException;
                }

                @Override
                public void forEachRemaining(Consumer<? super E> consumer) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ListIterator.forEachRemaining:(Ljava/util/function/Consumer;)V");
                    this.i.forEachRemaining(consumer);
                }
            };
        }

        @Override
        public List<E> subList(int n, int n2) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$UnmodifiableList");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.subList:(II)Ljava/util/List;");
            List<? extends E> list = this.list.subList(n, n2);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableList.<init>:(Ljava/util/List;)V");
            return new UnmodifiableList<E>(list);
        }

        private Object readResolve() {
            UnmodifiableList unmodifiableList;
            boolean bl = this.list instanceof RandomAccess;
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$UnmodifiableRandomAccessList");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableRandomAccessList.<init>:(Ljava/util/List;)V");
                unmodifiableList = new UnmodifiableRandomAccessList<E>(this.list);
                RuntimeCostAccounter.recordJump();
            } else {
                unmodifiableList = this;
            }
            return unmodifiableList;
        }
    }

    static class UnmodifiableNavigableSet<E>
    extends UnmodifiableSortedSet<E>
    implements NavigableSet<E>,
    Serializable {
        private static final long serialVersionUID = -6027448201786391929L;
        private static final NavigableSet<?> EMPTY_NAVIGABLE_SET;
        private final NavigableSet<E> ns;

        UnmodifiableNavigableSet(NavigableSet<E> navigableSet) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableSortedSet.<init>:(Ljava/util/SortedSet;)V");
            super(navigableSet);
            this.ns = navigableSet;
        }

        @Override
        public E lower(E e) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableSet.lower:(Ljava/lang/Object;)Ljava/lang/Object;");
            return this.ns.lower(e);
        }

        @Override
        public E floor(E e) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableSet.floor:(Ljava/lang/Object;)Ljava/lang/Object;");
            return this.ns.floor(e);
        }

        @Override
        public E ceiling(E e) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableSet.ceiling:(Ljava/lang/Object;)Ljava/lang/Object;");
            return this.ns.ceiling(e);
        }

        @Override
        public E higher(E e) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableSet.higher:(Ljava/lang/Object;)Ljava/lang/Object;");
            return this.ns.higher(e);
        }

        @Override
        public E pollFirst() {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }

        @Override
        public E pollLast() {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }

        @Override
        public NavigableSet<E> descendingSet() {
            RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$UnmodifiableNavigableSet");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableSet.descendingSet:()Ljava/util/NavigableSet;");
            NavigableSet<E> navigableSet = this.ns.descendingSet();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableNavigableSet.<init>:(Ljava/util/NavigableSet;)V");
            return new UnmodifiableNavigableSet<E>(navigableSet);
        }

        @Override
        public Iterator<E> descendingIterator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableNavigableSet.descendingSet:()Ljava/util/NavigableSet;");
            NavigableSet<E> navigableSet = this.descendingSet();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableSet.iterator:()Ljava/util/Iterator;");
            return navigableSet.iterator();
        }

        @Override
        public NavigableSet<E> subSet(E e, boolean bl, E e2, boolean bl2) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$UnmodifiableNavigableSet");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableSet.subSet:(Ljava/lang/Object;ZLjava/lang/Object;Z)Ljava/util/NavigableSet;");
            NavigableSet<E> navigableSet = this.ns.subSet(e, bl, e2, bl2);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableNavigableSet.<init>:(Ljava/util/NavigableSet;)V");
            return new UnmodifiableNavigableSet<E>(navigableSet);
        }

        @Override
        public NavigableSet<E> headSet(E e, boolean bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$UnmodifiableNavigableSet");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableSet.headSet:(Ljava/lang/Object;Z)Ljava/util/NavigableSet;");
            NavigableSet<E> navigableSet = this.ns.headSet(e, bl);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableNavigableSet.<init>:(Ljava/util/NavigableSet;)V");
            return new UnmodifiableNavigableSet<E>(navigableSet);
        }

        @Override
        public NavigableSet<E> tailSet(E e, boolean bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$UnmodifiableNavigableSet");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableSet.tailSet:(Ljava/lang/Object;Z)Ljava/util/NavigableSet;");
            NavigableSet<E> navigableSet = this.ns.tailSet(e, bl);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableNavigableSet.<init>:(Ljava/util/NavigableSet;)V");
            return new UnmodifiableNavigableSet<E>(navigableSet);
        }

        static {
            RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$UnmodifiableNavigableSet$EmptyNavigableSet");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableNavigableSet$EmptyNavigableSet.<init>:()V");
            EMPTY_NAVIGABLE_SET = new EmptyNavigableSet();
        }

        private static class EmptyNavigableSet<E>
        extends UnmodifiableNavigableSet<E>
        implements Serializable {
            private static final long serialVersionUID = -6291252904449939134L;

            public EmptyNavigableSet() {
                RuntimeCostAccounter.recordAllocation((String)"java/util/TreeSet");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeSet.<init>:()V");
                TreeSet treeSet = new TreeSet();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableNavigableSet.<init>:(Ljava/util/NavigableSet;)V");
                super(treeSet);
            }

            private Object readResolve() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableNavigableSet.access$000:()Ljava/util/NavigableSet;");
                return EMPTY_NAVIGABLE_SET;
            }
        }
    }

    static class UnmodifiableSortedSet<E>
    extends UnmodifiableSet<E>
    implements SortedSet<E>,
    Serializable {
        private static final long serialVersionUID = -4929149591599911165L;
        private final SortedSet<E> ss;

        UnmodifiableSortedSet(SortedSet<E> sortedSet) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableSet.<init>:(Ljava/util/Set;)V");
            super(sortedSet);
            this.ss = sortedSet;
        }

        @Override
        public Comparator<? super E> comparator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/SortedSet.comparator:()Ljava/util/Comparator;");
            return this.ss.comparator();
        }

        @Override
        public SortedSet<E> subSet(E e, E e2) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$UnmodifiableSortedSet");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/SortedSet.subSet:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/SortedSet;");
            SortedSet<E> sortedSet = this.ss.subSet(e, e2);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableSortedSet.<init>:(Ljava/util/SortedSet;)V");
            return new UnmodifiableSortedSet<E>(sortedSet);
        }

        @Override
        public SortedSet<E> headSet(E e) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$UnmodifiableSortedSet");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/SortedSet.headSet:(Ljava/lang/Object;)Ljava/util/SortedSet;");
            SortedSet<E> sortedSet = this.ss.headSet(e);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableSortedSet.<init>:(Ljava/util/SortedSet;)V");
            return new UnmodifiableSortedSet<E>(sortedSet);
        }

        @Override
        public SortedSet<E> tailSet(E e) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$UnmodifiableSortedSet");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/SortedSet.tailSet:(Ljava/lang/Object;)Ljava/util/SortedSet;");
            SortedSet<E> sortedSet = this.ss.tailSet(e);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableSortedSet.<init>:(Ljava/util/SortedSet;)V");
            return new UnmodifiableSortedSet<E>(sortedSet);
        }

        @Override
        public E first() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/SortedSet.first:()Ljava/lang/Object;");
            return this.ss.first();
        }

        @Override
        public E last() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/SortedSet.last:()Ljava/lang/Object;");
            return this.ss.last();
        }
    }

    static class UnmodifiableSet<E>
    extends UnmodifiableCollection<E>
    implements Set<E>,
    Serializable {
        private static final long serialVersionUID = -9215047833775013803L;

        UnmodifiableSet(Set<? extends E> set) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableCollection.<init>:(Ljava/util/Collection;)V");
            super(set);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object object) {
            RuntimeCostAccounter.recordJump();
            if (object != this) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.equals:(Ljava/lang/Object;)Z");
                boolean bl = this.c.equals(object);
                RuntimeCostAccounter.recordJump();
                if (!bl) return false;
            }
            boolean bl = true;
            RuntimeCostAccounter.recordJump();
            return bl;
        }

        @Override
        public int hashCode() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.hashCode:()I");
            return this.c.hashCode();
        }
    }

    static class UnmodifiableCollection<E>
    implements Collection<E>,
    Serializable {
        private static final long serialVersionUID = 1820017752578914078L;
        final Collection<? extends E> c;

        UnmodifiableCollection(Collection<? extends E> collection) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            RuntimeCostAccounter.recordJump();
            if (collection == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            this.c = collection;
        }

        @Override
        public int size() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.size:()I");
            return this.c.size();
        }

        @Override
        public boolean isEmpty() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.isEmpty:()Z");
            return this.c.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.contains:(Ljava/lang/Object;)Z");
            return this.c.contains(object);
        }

        @Override
        public Object[] toArray() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.toArray:()[Ljava/lang/Object;");
            return this.c.toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.toArray:([Ljava/lang/Object;)[Ljava/lang/Object;");
            return this.c.toArray(TArray);
        }

        public String toString() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.toString:()Ljava/lang/String;");
            return this.c.toString();
        }

        @Override
        public Iterator<E> iterator() {
            RuntimeCostAccounter.recordAllocation((String)"java/util/Collections$UnmodifiableCollection$1");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections$UnmodifiableCollection$1.<init>:(Ljava/util/Collections$UnmodifiableCollection;)V");
            return new Iterator<E>(){
                private final Iterator<? extends E> i;
                {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                    Collection collection = c;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.iterator:()Ljava/util/Iterator;");
                    this.i = collection.iterator();
                }

                @Override
                public boolean hasNext() {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                    return this.i.hasNext();
                }

                @Override
                public E next() {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                    return this.i.next();
                }

                @Override
                public void remove() {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
                    UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
                    RuntimeCostAccounter.recordThrow();
                    throw unsupportedOperationException;
                }

                @Override
                public void forEachRemaining(Consumer<? super E> consumer) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.forEachRemaining:(Ljava/util/function/Consumer;)V");
                    this.i.forEachRemaining(consumer);
                }
            };
        }

        @Override
        public boolean add(E e) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }

        @Override
        public boolean remove(Object object) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.containsAll:(Ljava/util/Collection;)Z");
            return this.c.containsAll(collection);
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }

        @Override
        public void clear() {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }

        @Override
        public void forEach(Consumer<? super E> consumer) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.forEach:(Ljava/util/function/Consumer;)V");
            this.c.forEach(consumer);
        }

        @Override
        public boolean removeIf(Predicate<? super E> predicate) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }

        @Override
        public Spliterator<E> spliterator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.spliterator:()Ljava/util/Spliterator;");
            return this.c.spliterator();
        }

        @Override
        public Stream<E> stream() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.stream:()Ljava/util/stream/Stream;");
            return this.c.stream();
        }

        @Override
        public Stream<E> parallelStream() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.parallelStream:()Ljava/util/stream/Stream;");
            return this.c.parallelStream();
        }
    }
}

