/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.FilterOutputStream;
import sandbox.java.io.IOException;
import sandbox.java.io.InputStream;
import sandbox.java.io.OutputStream;
import sandbox.java.nio.ByteBuffer;
import sandbox.java.nio.charset.StandardCharsets;
import sandbox.java.util.Arrays;
import sandbox.java.util.Objects;

public class Base64 {
    private Base64() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
    }

    public static Encoder getEncoder() {
        return Encoder.RFC4648;
    }

    public static Encoder getUrlEncoder() {
        return Encoder.RFC4648_URLSAFE;
    }

    public static Encoder getMimeEncoder() {
        return Encoder.RFC2045;
    }

    public static Encoder getMimeEncoder(int n, byte[] byArray) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(byArray);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Base64$Decoder.access$000:()[I");
        int[] nArray = Decoder.fromBase64;
        byte[] byArray2 = byArray;
        int n2 = byArray2.length;
        int n3 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n3 >= n2) break;
            byte by = byArray2[n3];
            int n4 = nArray[by & 0xFF];
            RuntimeCostAccounter.recordJump();
            if (n4 != -1) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder2 = stringBuilder.append("Illegal base64 line separator character 0x");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.toString:(II)Ljava/lang/String;");
                String string = Integer.toString(by, 16);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder3 = stringBuilder2.append(string);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string2 = stringBuilder3.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string2);
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            ++n3;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
        if (n <= 0) {
            return Encoder.RFC4648;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/Base64$Encoder");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Base64$Encoder.<init>:(Z[BIZLjava/util/Base64$1;)V");
        return new Encoder(false, byArray, n >> 2 << 2, true, null);
    }

    public static Decoder getDecoder() {
        return Decoder.RFC4648;
    }

    public static Decoder getUrlDecoder() {
        return Decoder.RFC4648_URLSAFE;
    }

    public static Decoder getMimeDecoder() {
        return Decoder.RFC2045;
    }

    private static class DecInputStream
    extends InputStream {
        private final InputStream is;
        private final boolean isMIME;
        private final int[] base64;
        private int bits;
        private int nextin;
        private int nextout;
        private boolean eof;
        private boolean closed;
        private byte[] sbBuf;

        DecInputStream(InputStream inputStream, int[] nArray, boolean bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.<init>:()V");
            this.bits = 0;
            this.nextin = 18;
            this.nextout = -8;
            this.eof = false;
            this.closed = false;
            RuntimeCostAccounter.recordArrayAllocation((int)1, (int)1);
            this.sbBuf = new byte[1];
            this.is = inputStream;
            this.base64 = nArray;
            this.isMIME = bl;
        }

        @Override
        public int read() throws IOException {
            int n;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Base64$DecInputStream.read:([BII)I");
            int n2 = this.read(this.sbBuf, 0, 1);
            RuntimeCostAccounter.recordJump();
            if (n2 == -1) {
                n = -1;
                RuntimeCostAccounter.recordJump();
            } else {
                n = this.sbBuf[0] & 0xFF;
            }
            return n;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            block32: {
                block31: {
                    RuntimeCostAccounter.recordJump();
                    if (this.closed) {
                        RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
                        IOException iOException = new IOException("Stream is closed");
                        RuntimeCostAccounter.recordThrow();
                        throw iOException;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (this.eof) {
                        RuntimeCostAccounter.recordJump();
                        if (this.nextout < 0) {
                            return -1;
                        }
                    }
                    RuntimeCostAccounter.recordJump();
                    if (n < 0) break block31;
                    RuntimeCostAccounter.recordJump();
                    if (n2 < 0) break block31;
                    int n3 = byArray.length - n;
                    RuntimeCostAccounter.recordJump();
                    if (n2 <= n3) break block32;
                }
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:()V");
                IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException();
                RuntimeCostAccounter.recordThrow();
                throw indexOutOfBoundsException;
            }
            int n4 = n;
            RuntimeCostAccounter.recordJump();
            if (this.nextout >= 0) {
                do {
                    RuntimeCostAccounter.recordJump();
                    if (n2 == 0) {
                        return n - n4;
                    }
                    byArray[n++] = (byte)(this.bits >> this.nextout);
                    --n2;
                    this.nextout -= 8;
                    RuntimeCostAccounter.recordJump();
                } while (this.nextout >= 0);
                this.bits = 0;
            }
            while (true) {
                int n5;
                block33: {
                    block35: {
                        block34: {
                            RuntimeCostAccounter.recordJump();
                            if (n2 <= 0) break;
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.read:()I");
                            n5 = this.is.read();
                            RuntimeCostAccounter.recordJump();
                            if (n5 == -1) {
                                this.eof = true;
                                RuntimeCostAccounter.recordJump();
                                if (this.nextin != 18) {
                                    RuntimeCostAccounter.recordJump();
                                    if (this.nextin == 12) {
                                        RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
                                        RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
                                        IOException iOException = new IOException("Base64 stream has one un-decoded dangling byte.");
                                        RuntimeCostAccounter.recordThrow();
                                        throw iOException;
                                    }
                                    byArray[n++] = (byte)(this.bits >> 16);
                                    --n2;
                                    RuntimeCostAccounter.recordJump();
                                    if (this.nextin == 0) {
                                        RuntimeCostAccounter.recordJump();
                                        if (n2 == 0) {
                                            this.bits >>= 8;
                                            this.nextout = 0;
                                            RuntimeCostAccounter.recordJump();
                                        } else {
                                            byArray[n++] = (byte)(this.bits >> 8);
                                        }
                                    }
                                }
                                RuntimeCostAccounter.recordJump();
                                if (n == n4) {
                                    return -1;
                                }
                                return n - n4;
                            }
                            RuntimeCostAccounter.recordJump();
                            if (n5 != 61) break block33;
                            RuntimeCostAccounter.recordJump();
                            if (this.nextin == 18) break block34;
                            RuntimeCostAccounter.recordJump();
                            if (this.nextin == 12) break block34;
                            RuntimeCostAccounter.recordJump();
                            if (this.nextin != 6) break block35;
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.read:()I");
                            int n6 = this.is.read();
                            RuntimeCostAccounter.recordJump();
                            if (n6 == 61) break block35;
                        }
                        RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                        StringBuilder stringBuilder = new StringBuilder();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder2 = stringBuilder.append("Illegal base64 ending sequence:");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder3 = stringBuilder2.append(this.nextin);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                        String string = stringBuilder3.toString();
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
                        IOException iOException = new IOException(string);
                        RuntimeCostAccounter.recordThrow();
                        throw iOException;
                    }
                    byArray[n++] = (byte)(this.bits >> 16);
                    --n2;
                    RuntimeCostAccounter.recordJump();
                    if (this.nextin == 0) {
                        RuntimeCostAccounter.recordJump();
                        if (n2 == 0) {
                            this.bits >>= 8;
                            this.nextout = 0;
                            RuntimeCostAccounter.recordJump();
                        } else {
                            byArray[n++] = (byte)(this.bits >> 8);
                        }
                    }
                    this.eof = true;
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                n5 = this.base64[n5];
                RuntimeCostAccounter.recordJump();
                if (n5 == -1) {
                    RuntimeCostAccounter.recordJump();
                    if (this.isMIME) {
                        RuntimeCostAccounter.recordJump();
                        continue;
                    }
                    RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                    StringBuilder stringBuilder = new StringBuilder();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder4 = stringBuilder.append("Illegal base64 character ");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.toString:(II)Ljava/lang/String;");
                    String string = Integer.toString(n5, 16);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder5 = stringBuilder4.append(string);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                    String string2 = stringBuilder5.toString();
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
                    IOException iOException = new IOException(string2);
                    RuntimeCostAccounter.recordThrow();
                    throw iOException;
                }
                this.bits |= n5 << this.nextin;
                RuntimeCostAccounter.recordJump();
                if (this.nextin == 0) {
                    block30: {
                        this.nextin = 18;
                        this.nextout = 16;
                        while (true) {
                            RuntimeCostAccounter.recordJump();
                            if (this.nextout < 0) break block30;
                            byArray[n++] = (byte)(this.bits >> this.nextout);
                            this.nextout -= 8;
                            RuntimeCostAccounter.recordJump();
                            if (--n2 != 0) continue;
                            RuntimeCostAccounter.recordJump();
                            if (this.nextout >= 0) break;
                        }
                        return n - n4;
                    }
                    this.bits = 0;
                    RuntimeCostAccounter.recordJump();
                } else {
                    this.nextin -= 6;
                }
                RuntimeCostAccounter.recordJump();
            }
            return n - n4;
        }

        @Override
        public int available() throws IOException {
            RuntimeCostAccounter.recordJump();
            if (this.closed) {
                RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
                RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
                IOException iOException = new IOException("Stream is closed");
                RuntimeCostAccounter.recordThrow();
                throw iOException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.available:()I");
            return this.is.available();
        }

        @Override
        public void close() throws IOException {
            RuntimeCostAccounter.recordJump();
            if (!this.closed) {
                this.closed = true;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.close:()V");
                this.is.close();
            }
        }
    }

    private static class EncOutputStream
    extends FilterOutputStream {
        private int leftover;
        private int b0;
        private int b1;
        private int b2;
        private boolean closed;
        private final char[] base64;
        private final byte[] newline;
        private final int linemax;
        private final boolean doPadding;
        private int linepos;

        EncOutputStream(OutputStream outputStream, char[] cArray, byte[] byArray, int n, boolean bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/FilterOutputStream.<init>:(Ljava/io/OutputStream;)V");
            super(outputStream);
            this.leftover = 0;
            this.closed = false;
            this.linepos = 0;
            this.base64 = cArray;
            this.newline = byArray;
            this.linemax = n;
            this.doPadding = bl;
        }

        @Override
        public void write(int n) throws IOException {
            RuntimeCostAccounter.recordArrayAllocation((int)1, (int)1);
            byte[] byArray = new byte[]{(byte)(n & 0xFF)};
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Base64$EncOutputStream.write:([BII)V");
            this.write(byArray, 0, 1);
        }

        private void checkNewline() throws IOException {
            RuntimeCostAccounter.recordJump();
            if (this.linepos == this.linemax) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:([B)V");
                this.out.write(this.newline);
                this.linepos = 0;
            }
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            block13: {
                block12: {
                    RuntimeCostAccounter.recordJump();
                    if (this.closed) {
                        RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
                        IOException iOException = new IOException("Stream is closed");
                        RuntimeCostAccounter.recordThrow();
                        throw iOException;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (n < 0) break block12;
                    RuntimeCostAccounter.recordJump();
                    if (n2 < 0) break block12;
                    int n3 = byArray.length;
                    RuntimeCostAccounter.recordJump();
                    if (n + n2 <= n3) break block13;
                }
                RuntimeCostAccounter.recordAllocation((String)"java/lang/ArrayIndexOutOfBoundsException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/ArrayIndexOutOfBoundsException.<init>:()V");
                ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException = new ArrayIndexOutOfBoundsException();
                RuntimeCostAccounter.recordThrow();
                throw arrayIndexOutOfBoundsException;
            }
            RuntimeCostAccounter.recordJump();
            if (n2 == 0) {
                return;
            }
            RuntimeCostAccounter.recordJump();
            if (this.leftover != 0) {
                RuntimeCostAccounter.recordJump();
                if (this.leftover == 1) {
                    this.b1 = byArray[n++] & 0xFF;
                    RuntimeCostAccounter.recordJump();
                    if (--n2 == 0) {
                        ++this.leftover;
                        return;
                    }
                }
                this.b2 = byArray[n++] & 0xFF;
                --n2;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Base64$EncOutputStream.checkNewline:()V");
                this.checkNewline();
                char c = this.base64[this.b0 >> 2];
                RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:(I)V");
                this.out.write(c);
                char c2 = this.base64[this.b0 << 4 & 0x3F | this.b1 >> 4];
                RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:(I)V");
                this.out.write(c2);
                char c3 = this.base64[this.b1 << 2 & 0x3F | this.b2 >> 6];
                RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:(I)V");
                this.out.write(c3);
                char c4 = this.base64[this.b2 & 0x3F];
                RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:(I)V");
                this.out.write(c4);
                this.linepos += 4;
            }
            int n4 = n2 / 3;
            this.leftover = n2 - n4 * 3;
            while (true) {
                int n5 = n4--;
                RuntimeCostAccounter.recordJump();
                if (n5 <= 0) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Base64$EncOutputStream.checkNewline:()V");
                this.checkNewline();
                int n6 = (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
                char c = this.base64[n6 >>> 18 & 0x3F];
                RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:(I)V");
                this.out.write(c);
                char c5 = this.base64[n6 >>> 12 & 0x3F];
                RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:(I)V");
                this.out.write(c5);
                char c6 = this.base64[n6 >>> 6 & 0x3F];
                RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:(I)V");
                this.out.write(c6);
                char c7 = this.base64[n6 & 0x3F];
                RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:(I)V");
                this.out.write(c7);
                this.linepos += 4;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordJump();
            if (this.leftover == 1) {
                this.b0 = byArray[n++] & 0xFF;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordJump();
                if (this.leftover == 2) {
                    this.b0 = byArray[n++] & 0xFF;
                    this.b1 = byArray[n++] & 0xFF;
                }
            }
        }

        @Override
        public void close() throws IOException {
            RuntimeCostAccounter.recordJump();
            if (!this.closed) {
                this.closed = true;
                RuntimeCostAccounter.recordJump();
                if (this.leftover == 1) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Base64$EncOutputStream.checkNewline:()V");
                    this.checkNewline();
                    char c = this.base64[this.b0 >> 2];
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:(I)V");
                    this.out.write(c);
                    char c2 = this.base64[this.b0 << 4 & 0x3F];
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:(I)V");
                    this.out.write(c2);
                    RuntimeCostAccounter.recordJump();
                    if (this.doPadding) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:(I)V");
                        this.out.write(61);
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:(I)V");
                        this.out.write(61);
                        RuntimeCostAccounter.recordJump();
                    }
                } else {
                    RuntimeCostAccounter.recordJump();
                    if (this.leftover == 2) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Base64$EncOutputStream.checkNewline:()V");
                        this.checkNewline();
                        char c = this.base64[this.b0 >> 2];
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:(I)V");
                        this.out.write(c);
                        char c3 = this.base64[this.b0 << 4 & 0x3F | this.b1 >> 4];
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:(I)V");
                        this.out.write(c3);
                        char c4 = this.base64[this.b1 << 2 & 0x3F];
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:(I)V");
                        this.out.write(c4);
                        RuntimeCostAccounter.recordJump();
                        if (this.doPadding) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:(I)V");
                            this.out.write(61);
                        }
                    }
                }
                this.leftover = 0;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.close:()V");
                this.out.close();
            }
        }
    }

    public static class Decoder {
        private final boolean isURL;
        private final boolean isMIME;
        private static final int[] fromBase64;
        private static final int[] fromBase64URL;
        static final Decoder RFC4648;
        static final Decoder RFC4648_URLSAFE;
        static final Decoder RFC2045;

        private Decoder(boolean bl, boolean bl2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.isURL = bl;
            this.isMIME = bl2;
        }

        public byte[] decode(byte[] byArray) {
            int n = byArray.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Base64$Decoder.outLength:([BII)I");
            int n2 = this.outLength(byArray, 0, n);
            RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)1);
            byte[] byArray2 = new byte[n2];
            int n3 = byArray.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Base64$Decoder.decode0:([BII[B)I");
            int n4 = this.decode0(byArray, 0, n3, byArray2);
            int n5 = byArray2.length;
            RuntimeCostAccounter.recordJump();
            if (n4 != n5) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([BI)[B");
                byArray2 = Arrays.copyOf(byArray2, n4);
            }
            return byArray2;
        }

        public byte[] decode(String string) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.getBytes:(Ljava/nio/charset/Charset;)[B");
            byte[] byArray = string.getBytes(StandardCharsets.ISO_8859_1);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Base64$Decoder.decode:([B)[B");
            return this.decode(byArray);
        }

        public int decode(byte[] byArray, byte[] byArray2) {
            int n = byArray.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Base64$Decoder.outLength:([BII)I");
            int n2 = this.outLength(byArray, 0, n);
            int n3 = byArray2.length;
            RuntimeCostAccounter.recordJump();
            if (n3 < n2) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Output byte array is too small for decoding all input bytes");
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            int n4 = byArray.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Base64$Decoder.decode0:([BII[B)I");
            return this.decode0(byArray, 0, n4, byArray2);
        }

        public ByteBuffer decode(ByteBuffer byteBuffer) {
            RuntimeCostAccounter.recordMethodCall((String)"java/nio/ByteBuffer.position:()I");
            int n = byteBuffer.position();
            try {
                int n2;
                int n3;
                byte[] byArray;
                RuntimeCostAccounter.recordMethodCall((String)"java/nio/ByteBuffer.hasArray:()Z");
                boolean bl = byteBuffer.hasArray();
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/nio/ByteBuffer.array:()[B");
                    byArray = byteBuffer.array();
                    RuntimeCostAccounter.recordMethodCall((String)"java/nio/ByteBuffer.arrayOffset:()I");
                    int n4 = byteBuffer.arrayOffset();
                    RuntimeCostAccounter.recordMethodCall((String)"java/nio/ByteBuffer.position:()I");
                    n3 = n4 + byteBuffer.position();
                    RuntimeCostAccounter.recordMethodCall((String)"java/nio/ByteBuffer.arrayOffset:()I");
                    int n5 = byteBuffer.arrayOffset();
                    RuntimeCostAccounter.recordMethodCall((String)"java/nio/ByteBuffer.limit:()I");
                    n2 = n5 + byteBuffer.limit();
                    RuntimeCostAccounter.recordMethodCall((String)"java/nio/ByteBuffer.limit:()I");
                    int n6 = byteBuffer.limit();
                    RuntimeCostAccounter.recordMethodCall((String)"java/nio/ByteBuffer.position:(I)Ljava/nio/Buffer;");
                    byteBuffer.position(n6);
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordMethodCall((String)"java/nio/ByteBuffer.remaining:()I");
                    int n7 = byteBuffer.remaining();
                    RuntimeCostAccounter.recordArrayAllocation((int)n7, (int)1);
                    byArray = new byte[n7];
                    RuntimeCostAccounter.recordMethodCall((String)"java/nio/ByteBuffer.get:([B)Ljava/nio/ByteBuffer;");
                    byteBuffer.get(byArray);
                    n3 = 0;
                    n2 = byArray.length;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Base64$Decoder.outLength:([BII)I");
                int n8 = this.outLength(byArray, n3, n2);
                RuntimeCostAccounter.recordArrayAllocation((int)n8, (int)1);
                byte[] byArray2 = new byte[n8];
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Base64$Decoder.decode0:([BII[B)I");
                int n9 = this.decode0(byArray, n3, n2, byArray2);
                RuntimeCostAccounter.recordMethodCall((String)"java/nio/ByteBuffer.wrap:([BII)Ljava/nio/ByteBuffer;");
                return ByteBuffer.wrap((byte[])byArray2, (int)0, (int)n9);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                RuntimeCostAccounter.recordMethodCall((String)"java/nio/ByteBuffer.position:(I)Ljava/nio/Buffer;");
                byteBuffer.position(n);
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
        }

        public InputStream wrap(InputStream inputStream) {
            int[] nArray;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
            Objects.requireNonNull(inputStream);
            RuntimeCostAccounter.recordAllocation((String)"java/util/Base64$DecInputStream");
            RuntimeCostAccounter.recordJump();
            if (this.isURL) {
                nArray = fromBase64URL;
                RuntimeCostAccounter.recordJump();
            } else {
                nArray = fromBase64;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Base64$DecInputStream.<init>:(Ljava/io/InputStream;[IZ)V");
            return new DecInputStream(inputStream, nArray, this.isMIME);
        }

        private int outLength(byte[] byArray, int n, int n2) {
            int[] nArray;
            RuntimeCostAccounter.recordJump();
            if (this.isURL) {
                nArray = fromBase64URL;
                RuntimeCostAccounter.recordJump();
            } else {
                nArray = fromBase64;
            }
            int[] nArray2 = nArray;
            int n3 = 0;
            int n4 = n2 - n;
            RuntimeCostAccounter.recordJump();
            if (n4 == 0) {
                return 0;
            }
            RuntimeCostAccounter.recordJump();
            if (n4 < 2) {
                RuntimeCostAccounter.recordJump();
                if (this.isMIME) {
                    int n5 = nArray2[0];
                    RuntimeCostAccounter.recordJump();
                    if (n5 == -1) {
                        return 0;
                    }
                }
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Input byte[] should at least have 2 bytes for base64 bytes");
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            RuntimeCostAccounter.recordJump();
            if (this.isMIME) {
                int n6 = 0;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n >= n2) break;
                    int n7 = byArray[n++] & 0xFF;
                    RuntimeCostAccounter.recordJump();
                    if (n7 == 61) {
                        n4 -= n2 - n + 1;
                        RuntimeCostAccounter.recordJump();
                        break;
                    }
                    n7 = nArray2[n7];
                    RuntimeCostAccounter.recordJump();
                    if (n7 == -1) {
                        ++n6;
                    }
                    RuntimeCostAccounter.recordJump();
                }
                n4 -= n6;
                RuntimeCostAccounter.recordJump();
            } else {
                byte by = byArray[n2 - 1];
                RuntimeCostAccounter.recordJump();
                if (by == 61) {
                    ++n3;
                    byte by2 = byArray[n2 - 2];
                    RuntimeCostAccounter.recordJump();
                    if (by2 == 61) {
                        ++n3;
                    }
                }
            }
            RuntimeCostAccounter.recordJump();
            if (n3 == 0) {
                RuntimeCostAccounter.recordJump();
                if ((n4 & 3) != 0) {
                    n3 = 4 - (n4 & 3);
                }
            }
            return 3 * ((n4 + 3) / 4) - n3;
        }

        private int decode0(byte[] byArray, int n, int n2, byte[] byArray2) {
            int n3;
            block14: {
                int[] nArray;
                RuntimeCostAccounter.recordJump();
                if (this.isURL) {
                    nArray = fromBase64URL;
                    RuntimeCostAccounter.recordJump();
                } else {
                    nArray = fromBase64;
                }
                int[] nArray2 = nArray;
                n3 = 0;
                int n4 = 0;
                int n5 = 18;
                while (true) {
                    int n6;
                    block15: {
                        block16: {
                            block18: {
                                block17: {
                                    RuntimeCostAccounter.recordJump();
                                    if (n >= n2) break;
                                    n6 = byArray[n++] & 0xFF;
                                    n6 = nArray2[n6];
                                    RuntimeCostAccounter.recordJump();
                                    if (n6 >= 0) break block15;
                                    RuntimeCostAccounter.recordJump();
                                    if (n6 != -2) break block16;
                                    RuntimeCostAccounter.recordJump();
                                    if (n5 != 6) break block17;
                                    RuntimeCostAccounter.recordJump();
                                    if (n == n2) break block18;
                                    byte by = byArray[n++];
                                    RuntimeCostAccounter.recordJump();
                                    if (by != 61) break block18;
                                }
                                RuntimeCostAccounter.recordJump();
                                if (n5 != 18) break;
                            }
                            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Input byte array has wrong 4-byte ending unit");
                            RuntimeCostAccounter.recordThrow();
                            throw illegalArgumentException;
                        }
                        RuntimeCostAccounter.recordJump();
                        if (this.isMIME) {
                            RuntimeCostAccounter.recordJump();
                            continue;
                        }
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                        StringBuilder stringBuilder = new StringBuilder();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder2 = stringBuilder.append("Illegal base64 character ");
                        byte by = byArray[n - 1];
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.toString:(II)Ljava/lang/String;");
                        String string = Integer.toString(by, 16);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder3 = stringBuilder2.append(string);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                        String string2 = stringBuilder3.toString();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                        IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string2);
                        RuntimeCostAccounter.recordThrow();
                        throw illegalArgumentException;
                    }
                    n4 |= n6 << n5;
                    RuntimeCostAccounter.recordJump();
                    if ((n5 -= 6) < 0) {
                        byArray2[n3++] = (byte)(n4 >> 16);
                        byArray2[n3++] = (byte)(n4 >> 8);
                        byArray2[n3++] = (byte)n4;
                        n5 = 18;
                        n4 = 0;
                    }
                    RuntimeCostAccounter.recordJump();
                }
                RuntimeCostAccounter.recordJump();
                if (n5 == 6) {
                    byArray2[n3++] = (byte)(n4 >> 16);
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordJump();
                    if (n5 == 0) {
                        byArray2[n3++] = (byte)(n4 >> 16);
                        byArray2[n3++] = (byte)(n4 >> 8);
                        RuntimeCostAccounter.recordJump();
                    } else {
                        RuntimeCostAccounter.recordJump();
                        if (n5 == 12) {
                            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Last unit does not have enough valid bits");
                            RuntimeCostAccounter.recordThrow();
                            throw illegalArgumentException;
                        }
                    }
                }
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n >= n2) break block14;
                    RuntimeCostAccounter.recordJump();
                    if (!this.isMIME) break;
                    int n7 = nArray2[byArray[n++]];
                    RuntimeCostAccounter.recordJump();
                    if (n7 >= 0) break;
                    RuntimeCostAccounter.recordJump();
                }
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder4 = stringBuilder.append("Input byte array has incorrect ending byte at ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder5 = stringBuilder4.append(n);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string = stringBuilder5.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            return n3;
        }

        static {
            RuntimeCostAccounter.recordArrayAllocation((int)256, (int)4);
            fromBase64 = new int[256];
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.fill:([II)V");
            Arrays.fill(fromBase64, -1);
            int n = 0;
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Base64$Encoder.access$200:()[C");
                int n2 = Encoder.toBase64.length;
                RuntimeCostAccounter.recordJump();
                if (n >= n2) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Base64$Encoder.access$200:()[C");
                Decoder.fromBase64[Encoder.toBase64[n]] = n;
                ++n;
                RuntimeCostAccounter.recordJump();
            }
            Decoder.fromBase64[61] = -2;
            RuntimeCostAccounter.recordArrayAllocation((int)256, (int)4);
            fromBase64URL = new int[256];
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.fill:([II)V");
            Arrays.fill(fromBase64URL, -1);
            n = 0;
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Base64$Encoder.access$300:()[C");
                int n3 = Encoder.toBase64URL.length;
                RuntimeCostAccounter.recordJump();
                if (n >= n3) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Base64$Encoder.access$300:()[C");
                Decoder.fromBase64URL[Encoder.toBase64URL[n]] = n;
                ++n;
                RuntimeCostAccounter.recordJump();
            }
            Decoder.fromBase64URL[61] = -2;
            RuntimeCostAccounter.recordAllocation((String)"java/util/Base64$Decoder");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Base64$Decoder.<init>:(ZZ)V");
            RFC4648 = new Decoder(false, false);
            RuntimeCostAccounter.recordAllocation((String)"java/util/Base64$Decoder");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Base64$Decoder.<init>:(ZZ)V");
            RFC4648_URLSAFE = new Decoder(true, false);
            RuntimeCostAccounter.recordAllocation((String)"java/util/Base64$Decoder");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Base64$Decoder.<init>:(ZZ)V");
            RFC2045 = new Decoder(false, true);
        }
    }

    public static class Encoder {
        private final byte[] newline;
        private final int linemax;
        private final boolean isURL;
        private final boolean doPadding;
        private static final char[] toBase64;
        private static final char[] toBase64URL;
        private static final int MIMELINEMAX = 76;
        private static final byte[] CRLF;
        static final Encoder RFC4648;
        static final Encoder RFC4648_URLSAFE;
        static final Encoder RFC2045;

        private Encoder(boolean bl, byte[] byArray, int n, boolean bl2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.isURL = bl;
            this.newline = byArray;
            this.linemax = n;
            this.doPadding = bl2;
        }

        private final int outLength(int n) {
            int n2 = 0;
            RuntimeCostAccounter.recordJump();
            if (this.doPadding) {
                n2 = 4 * ((n + 2) / 3);
                RuntimeCostAccounter.recordJump();
            } else {
                int n3;
                int n4 = n % 3;
                int n5 = 4 * (n / 3);
                RuntimeCostAccounter.recordJump();
                if (n4 == 0) {
                    n3 = 0;
                    RuntimeCostAccounter.recordJump();
                } else {
                    n3 = n4 + 1;
                }
                n2 = n5 + n3;
            }
            RuntimeCostAccounter.recordJump();
            if (this.linemax > 0) {
                n2 += (n2 - 1) / this.linemax * this.newline.length;
            }
            return n2;
        }

        public byte[] encode(byte[] byArray) {
            int n;
            int n2 = byArray.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Base64$Encoder.outLength:(I)I");
            int n3 = n = this.outLength(n2);
            RuntimeCostAccounter.recordArrayAllocation((int)n3, (int)1);
            byte[] byArray2 = new byte[n3];
            int n4 = byArray.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Base64$Encoder.encode0:([BII[B)I");
            int n5 = this.encode0(byArray, 0, n4, byArray2);
            int n6 = byArray2.length;
            RuntimeCostAccounter.recordJump();
            if (n5 != n6) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([BI)[B");
                return Arrays.copyOf(byArray2, n5);
            }
            return byArray2;
        }

        public int encode(byte[] byArray, byte[] byArray2) {
            int n = byArray.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Base64$Encoder.outLength:(I)I");
            int n2 = this.outLength(n);
            int n3 = byArray2.length;
            RuntimeCostAccounter.recordJump();
            if (n3 < n2) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Output byte array is too small for encoding all input bytes");
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            int n4 = byArray.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Base64$Encoder.encode0:([BII[B)I");
            return this.encode0(byArray, 0, n4, byArray2);
        }

        public String encodeToString(byte[] byArray) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Base64$Encoder.encode:([B)[B");
            byte[] byArray2 = this.encode(byArray);
            RuntimeCostAccounter.recordAllocation((String)"java/lang/String");
            int n = byArray2.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.<init>:([BIII)V");
            return new String(byArray2, 0, 0, n);
        }

        public ByteBuffer encode(ByteBuffer byteBuffer) {
            int n;
            RuntimeCostAccounter.recordMethodCall((String)"java/nio/ByteBuffer.remaining:()I");
            int n2 = byteBuffer.remaining();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Base64$Encoder.outLength:(I)I");
            int n3 = n = this.outLength(n2);
            RuntimeCostAccounter.recordArrayAllocation((int)n3, (int)1);
            byte[] byArray = new byte[n3];
            int n4 = 0;
            RuntimeCostAccounter.recordMethodCall((String)"java/nio/ByteBuffer.hasArray:()Z");
            boolean bl = byteBuffer.hasArray();
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/nio/ByteBuffer.array:()[B");
                byte[] byArray2 = byteBuffer.array();
                RuntimeCostAccounter.recordMethodCall((String)"java/nio/ByteBuffer.arrayOffset:()I");
                int n5 = byteBuffer.arrayOffset();
                RuntimeCostAccounter.recordMethodCall((String)"java/nio/ByteBuffer.position:()I");
                int n6 = n5 + byteBuffer.position();
                RuntimeCostAccounter.recordMethodCall((String)"java/nio/ByteBuffer.arrayOffset:()I");
                int n7 = byteBuffer.arrayOffset();
                RuntimeCostAccounter.recordMethodCall((String)"java/nio/ByteBuffer.limit:()I");
                int n8 = n7 + byteBuffer.limit();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Base64$Encoder.encode0:([BII[B)I");
                n4 = this.encode0(byArray2, n6, n8, byArray);
                RuntimeCostAccounter.recordMethodCall((String)"java/nio/ByteBuffer.limit:()I");
                int n9 = byteBuffer.limit();
                RuntimeCostAccounter.recordMethodCall((String)"java/nio/ByteBuffer.position:(I)Ljava/nio/Buffer;");
                byteBuffer.position(n9);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/nio/ByteBuffer.remaining:()I");
                int n10 = byteBuffer.remaining();
                RuntimeCostAccounter.recordArrayAllocation((int)n10, (int)1);
                byte[] byArray3 = new byte[n10];
                RuntimeCostAccounter.recordMethodCall((String)"java/nio/ByteBuffer.get:([B)Ljava/nio/ByteBuffer;");
                byteBuffer.get(byArray3);
                int n11 = byArray3.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Base64$Encoder.encode0:([BII[B)I");
                n4 = this.encode0(byArray3, 0, n11, byArray);
            }
            int n12 = byArray.length;
            RuntimeCostAccounter.recordJump();
            if (n4 != n12) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([BI)[B");
                byArray = Arrays.copyOf(byArray, n4);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/nio/ByteBuffer.wrap:([B)Ljava/nio/ByteBuffer;");
            return ByteBuffer.wrap((byte[])byArray);
        }

        public OutputStream wrap(OutputStream outputStream) {
            char[] cArray;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
            Objects.requireNonNull(outputStream);
            RuntimeCostAccounter.recordAllocation((String)"java/util/Base64$EncOutputStream");
            RuntimeCostAccounter.recordJump();
            if (this.isURL) {
                cArray = toBase64URL;
                RuntimeCostAccounter.recordJump();
            } else {
                cArray = toBase64;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Base64$EncOutputStream.<init>:(Ljava/io/OutputStream;[C[BIZ)V");
            return new EncOutputStream(outputStream, cArray, this.newline, this.linemax, this.doPadding);
        }

        public Encoder withoutPadding() {
            RuntimeCostAccounter.recordJump();
            if (!this.doPadding) {
                return this;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/util/Base64$Encoder");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Base64$Encoder.<init>:(Z[BIZ)V");
            return new Encoder(this.isURL, this.newline, this.linemax, false);
        }

        private int encode0(byte[] byArray, int n, int n2, byte[] byArray2) {
            int n3;
            int n4;
            char[] cArray;
            RuntimeCostAccounter.recordJump();
            if (this.isURL) {
                cArray = toBase64URL;
                RuntimeCostAccounter.recordJump();
            } else {
                cArray = toBase64;
            }
            char[] cArray2 = cArray;
            int n5 = n;
            int n6 = (n2 - n) / 3 * 3;
            int n7 = n + n6;
            RuntimeCostAccounter.recordJump();
            if (this.linemax > 0) {
                int n8 = this.linemax / 4 * 3;
                RuntimeCostAccounter.recordJump();
                if (n6 > n8) {
                    n6 = this.linemax / 4 * 3;
                }
            }
            int n9 = 0;
            while (true) {
                int n10;
                RuntimeCostAccounter.recordJump();
                if (n5 >= n7) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
                n4 = Math.min(n5 + n6, n7);
                n3 = n5;
                int n11 = n9;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n3 >= n4) break;
                    n10 = (byArray[n3++] & 0xFF) << 16 | (byArray[n3++] & 0xFF) << 8 | byArray[n3++] & 0xFF;
                    byArray2[n11++] = (byte)cArray2[n10 >>> 18 & 0x3F];
                    byArray2[n11++] = (byte)cArray2[n10 >>> 12 & 0x3F];
                    byArray2[n11++] = (byte)cArray2[n10 >>> 6 & 0x3F];
                    byArray2[n11++] = (byte)cArray2[n10 & 0x3F];
                    RuntimeCostAccounter.recordJump();
                }
                n3 = (n4 - n5) / 3 * 4;
                n9 += n3;
                n5 = n4;
                RuntimeCostAccounter.recordJump();
                if (n3 == this.linemax) {
                    RuntimeCostAccounter.recordJump();
                    if (n5 < n2) {
                        byte[] byArray3 = this.newline;
                        n10 = byArray3.length;
                        int n12 = 0;
                        while (true) {
                            RuntimeCostAccounter.recordJump();
                            if (n12 >= n10) break;
                            byte by = byArray3[n12];
                            byArray2[n9++] = by;
                            ++n12;
                            RuntimeCostAccounter.recordJump();
                        }
                    }
                }
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordJump();
            if (n5 < n2) {
                n4 = byArray[n5++] & 0xFF;
                byArray2[n9++] = (byte)cArray2[n4 >> 2];
                RuntimeCostAccounter.recordJump();
                if (n5 == n2) {
                    byArray2[n9++] = (byte)cArray2[n4 << 4 & 0x3F];
                    RuntimeCostAccounter.recordJump();
                    if (this.doPadding) {
                        byArray2[n9++] = 61;
                        byArray2[n9++] = 61;
                        RuntimeCostAccounter.recordJump();
                    }
                } else {
                    n3 = byArray[n5++] & 0xFF;
                    byArray2[n9++] = (byte)cArray2[n4 << 4 & 0x3F | n3 >> 4];
                    byArray2[n9++] = (byte)cArray2[n3 << 2 & 0x3F];
                    RuntimeCostAccounter.recordJump();
                    if (this.doPadding) {
                        byArray2[n9++] = 61;
                    }
                }
            }
            return n9;
        }

        /* synthetic */ Encoder(boolean bl, byte[] byArray, int n, boolean bl2, 1 var5_5) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Base64$Encoder.<init>:(Z[BIZ)V");
            this(bl, byArray, n, bl2);
        }

        static {
            RuntimeCostAccounter.recordArrayAllocation((int)64, (int)2);
            toBase64 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
            RuntimeCostAccounter.recordArrayAllocation((int)64, (int)2);
            toBase64URL = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '_'};
            RuntimeCostAccounter.recordArrayAllocation((int)2, (int)1);
            CRLF = new byte[]{13, 10};
            RuntimeCostAccounter.recordAllocation((String)"java/util/Base64$Encoder");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Base64$Encoder.<init>:(Z[BIZ)V");
            RFC4648 = new Encoder(false, null, -1, true);
            RuntimeCostAccounter.recordAllocation((String)"java/util/Base64$Encoder");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Base64$Encoder.<init>:(Z[BIZ)V");
            RFC4648_URLSAFE = new Encoder(true, null, -1, true);
            RuntimeCostAccounter.recordAllocation((String)"java/util/Base64$Encoder");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Base64$Encoder.<init>:(Z[BIZ)V");
            RFC2045 = new Encoder(false, CRLF, 76, true);
        }
    }
}

