/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.time.chrono;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.DataInput;
import sandbox.java.io.DataOutput;
import sandbox.java.io.IOException;
import sandbox.java.io.InvalidObjectException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.Serializable;
import sandbox.java.time.Clock;
import sandbox.java.time.LocalDate;
import sandbox.java.time.LocalTime;
import sandbox.java.time.Period;
import sandbox.java.time.ZoneId;
import sandbox.java.time.chrono.ChronoLocalDate;
import sandbox.java.time.chrono.ChronoLocalDateImpl;
import sandbox.java.time.chrono.ChronoLocalDateTime;
import sandbox.java.time.chrono.ChronoPeriod;
import sandbox.java.time.chrono.MinguoChronology;
import sandbox.java.time.chrono.MinguoEra;
import sandbox.java.time.chrono.Ser;
import sandbox.java.time.temporal.ChronoField;
import sandbox.java.time.temporal.TemporalAccessor;
import sandbox.java.time.temporal.TemporalAdjuster;
import sandbox.java.time.temporal.TemporalAmount;
import sandbox.java.time.temporal.TemporalField;
import sandbox.java.time.temporal.TemporalUnit;
import sandbox.java.time.temporal.UnsupportedTemporalTypeException;
import sandbox.java.time.temporal.ValueRange;
import sandbox.java.util.Objects;

public final class MinguoDate
extends ChronoLocalDateImpl<MinguoDate>
implements ChronoLocalDate,
Serializable {
    private static final long serialVersionUID = 1300372329181994526L;
    private final transient LocalDate isoDate;

    public static MinguoDate now() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.systemDefaultZone:()Ljava/time/Clock;");
        Clock clock = Clock.systemDefaultZone();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoDate.now:(Ljava/time/Clock;)Ljava/time/chrono/MinguoDate;");
        return MinguoDate.now(clock);
    }

    public static MinguoDate now(ZoneId zoneId) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.system:(Ljava/time/ZoneId;)Ljava/time/Clock;");
        Clock clock = Clock.system(zoneId);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoDate.now:(Ljava/time/Clock;)Ljava/time/chrono/MinguoDate;");
        return MinguoDate.now(clock);
    }

    public static MinguoDate now(Clock clock) {
        RuntimeCostAccounter.recordAllocation((String)"java/time/chrono/MinguoDate");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.now:(Ljava/time/Clock;)Ljava/time/LocalDate;");
        LocalDate localDate = LocalDate.now(clock);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoDate.<init>:(Ljava/time/LocalDate;)V");
        return new MinguoDate(localDate);
    }

    public static MinguoDate of(int n, int n2, int n3) {
        RuntimeCostAccounter.recordAllocation((String)"java/time/chrono/MinguoDate");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.of:(III)Ljava/time/LocalDate;");
        LocalDate localDate = LocalDate.of(n + 1911, n2, n3);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoDate.<init>:(Ljava/time/LocalDate;)V");
        return new MinguoDate(localDate);
    }

    public static MinguoDate from(TemporalAccessor temporalAccessor) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoChronology.date:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/chrono/MinguoDate;");
        return MinguoChronology.INSTANCE.date(temporalAccessor);
    }

    MinguoDate(LocalDate localDate) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.<init>:()V");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(localDate, "isoDate");
        this.isoDate = localDate;
    }

    @Override
    public MinguoChronology getChronology() {
        return MinguoChronology.INSTANCE;
    }

    @Override
    public MinguoEra getEra() {
        MinguoEra minguoEra;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoDate.getProlepticYear:()I");
        int n = this.getProlepticYear();
        RuntimeCostAccounter.recordJump();
        if (n >= 1) {
            minguoEra = MinguoEra.ROC;
            RuntimeCostAccounter.recordJump();
        } else {
            minguoEra = MinguoEra.BEFORE_ROC;
        }
        return minguoEra;
    }

    @Override
    public int lengthOfMonth() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.lengthOfMonth:()I");
        return this.isoDate.lengthOfMonth();
    }

    @Override
    public ValueRange range(TemporalField temporalField) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoDate.isSupported:(Ljava/time/temporal/TemporalField;)Z");
            boolean bl2 = this.isSupported(temporalField);
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                ChronoField chronoField = (ChronoField)temporalField;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.ordinal:()I");
                switch (1.$SwitchMap$java$time$temporal$ChronoField[chronoField.ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.range:(Ljava/time/temporal/TemporalField;)Ljava/time/temporal/ValueRange;");
                        return this.isoDate.range(temporalField);
                    }
                    case 4: {
                        long l;
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.range:()Ljava/time/temporal/ValueRange;");
                        ValueRange valueRange = ChronoField.YEAR.range();
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoDate.getProlepticYear:()I");
                        int n = this.getProlepticYear();
                        RuntimeCostAccounter.recordJump();
                        if (n <= 0) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.getMinimum:()J");
                            l = -valueRange.getMinimum() + 1L + 1911L;
                            RuntimeCostAccounter.recordJump();
                        } else {
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.getMaximum:()J");
                            l = valueRange.getMaximum() - 1911L;
                        }
                        long l2 = l;
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.of:(JJ)Ljava/time/temporal/ValueRange;");
                        return ValueRange.of(1L, l2);
                    }
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoDate.getChronology:()Ljava/time/chrono/MinguoChronology;");
                MinguoChronology minguoChronology = this.getChronology();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoChronology.range:(Ljava/time/temporal/ChronoField;)Ljava/time/temporal/ValueRange;");
                return minguoChronology.range(chronoField);
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unsupported field: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(temporalField);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
            UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException(string);
            RuntimeCostAccounter.recordThrow();
            throw unsupportedTemporalTypeException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.rangeRefinedBy:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/temporal/ValueRange;");
        return temporalField.rangeRefinedBy(this);
    }

    @Override
    public long getLong(TemporalField temporalField) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            ChronoField chronoField = (ChronoField)temporalField;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.ordinal:()I");
            switch (1.$SwitchMap$java$time$temporal$ChronoField[chronoField.ordinal()]) {
                case 5: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoDate.getProlepticMonth:()J");
                    return this.getProlepticMonth();
                }
                case 4: {
                    int n;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoDate.getProlepticYear:()I");
                    int n2 = this.getProlepticYear();
                    RuntimeCostAccounter.recordJump();
                    if (n2 >= 1) {
                        n = n2;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        n = 1 - n2;
                    }
                    return n;
                }
                case 6: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoDate.getProlepticYear:()I");
                    return this.getProlepticYear();
                }
                case 7: {
                    int n;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoDate.getProlepticYear:()I");
                    int n3 = this.getProlepticYear();
                    RuntimeCostAccounter.recordJump();
                    if (n3 >= 1) {
                        n = 1;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        n = 0;
                    }
                    return n;
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.getLong:(Ljava/time/temporal/TemporalField;)J");
            return this.isoDate.getLong(temporalField);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.getFrom:(Ljava/time/temporal/TemporalAccessor;)J");
        return temporalField.getFrom(this);
    }

    private long getProlepticMonth() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoDate.getProlepticYear:()I");
        long l = (long)this.getProlepticYear() * 12L;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.getMonthValue:()I");
        return l + (long)this.isoDate.getMonthValue() - 1L;
    }

    private int getProlepticYear() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.getYear:()I");
        return this.isoDate.getYear() - 1911;
    }

    @Override
    public MinguoDate with(TemporalField temporalField, long l) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            ChronoField chronoField = (ChronoField)temporalField;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoDate.getLong:(Ljava/time/temporal/TemporalField;)J");
            long l2 = this.getLong(chronoField) - l;
            long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
            RuntimeCostAccounter.recordJump();
            if (l3 == false) {
                return this;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.ordinal:()I");
            switch (1.$SwitchMap$java$time$temporal$ChronoField[chronoField.ordinal()]) {
                case 5: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoDate.getChronology:()Ljava/time/chrono/MinguoChronology;");
                    MinguoChronology minguoChronology = this.getChronology();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoChronology.range:(Ljava/time/temporal/ChronoField;)Ljava/time/temporal/ValueRange;");
                    ValueRange valueRange = minguoChronology.range(chronoField);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.checkValidValue:(JLjava/time/temporal/TemporalField;)J");
                    valueRange.checkValidValue(l, chronoField);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoDate.getProlepticMonth:()J");
                    long l4 = l - this.getProlepticMonth();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoDate.plusMonths:(J)Ljava/time/chrono/MinguoDate;");
                    return this.plusMonths(l4);
                }
                case 4: 
                case 6: 
                case 7: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoDate.getChronology:()Ljava/time/chrono/MinguoChronology;");
                    MinguoChronology minguoChronology = this.getChronology();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoChronology.range:(Ljava/time/temporal/ChronoField;)Ljava/time/temporal/ValueRange;");
                    ValueRange valueRange = minguoChronology.range(chronoField);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.checkValidIntValue:(JLjava/time/temporal/TemporalField;)I");
                    int n = valueRange.checkValidIntValue(l, chronoField);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.ordinal:()I");
                    switch (1.$SwitchMap$java$time$temporal$ChronoField[chronoField.ordinal()]) {
                        case 4: {
                            int n2;
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoDate.getProlepticYear:()I");
                            int n3 = this.getProlepticYear();
                            RuntimeCostAccounter.recordJump();
                            if (n3 >= 1) {
                                n2 = n + 1911;
                                RuntimeCostAccounter.recordJump();
                            } else {
                                n2 = 1 - n + 1911;
                            }
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.withYear:(I)Ljava/time/LocalDate;");
                            LocalDate localDate = this.isoDate.withYear(n2);
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoDate.with:(Ljava/time/LocalDate;)Ljava/time/chrono/MinguoDate;");
                            return this.with(localDate);
                        }
                        case 6: {
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.withYear:(I)Ljava/time/LocalDate;");
                            LocalDate localDate = this.isoDate.withYear(n + 1911);
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoDate.with:(Ljava/time/LocalDate;)Ljava/time/chrono/MinguoDate;");
                            return this.with(localDate);
                        }
                        case 7: {
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoDate.getProlepticYear:()I");
                            int n4 = 1 - this.getProlepticYear() + 1911;
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.withYear:(I)Ljava/time/LocalDate;");
                            LocalDate localDate = this.isoDate.withYear(n4);
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoDate.with:(Ljava/time/LocalDate;)Ljava/time/chrono/MinguoDate;");
                            return this.with(localDate);
                        }
                    }
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.with:(Ljava/time/temporal/TemporalField;J)Ljava/time/LocalDate;");
            LocalDate localDate = this.isoDate.with(temporalField, l);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoDate.with:(Ljava/time/LocalDate;)Ljava/time/chrono/MinguoDate;");
            return this.with(localDate);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.with:(Ljava/time/temporal/TemporalField;J)Ljava/time/chrono/ChronoLocalDate;");
        return (MinguoDate)super.with(temporalField, l);
    }

    @Override
    public MinguoDate with(TemporalAdjuster temporalAdjuster) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.with:(Ljava/time/temporal/TemporalAdjuster;)Ljava/time/chrono/ChronoLocalDate;");
        return (MinguoDate)super.with(temporalAdjuster);
    }

    @Override
    public MinguoDate plus(TemporalAmount temporalAmount) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.plus:(Ljava/time/temporal/TemporalAmount;)Ljava/time/chrono/ChronoLocalDate;");
        return (MinguoDate)super.plus(temporalAmount);
    }

    @Override
    public MinguoDate minus(TemporalAmount temporalAmount) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.minus:(Ljava/time/temporal/TemporalAmount;)Ljava/time/chrono/ChronoLocalDate;");
        return (MinguoDate)super.minus(temporalAmount);
    }

    @Override
    MinguoDate plusYears(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.plusYears:(J)Ljava/time/LocalDate;");
        LocalDate localDate = this.isoDate.plusYears(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoDate.with:(Ljava/time/LocalDate;)Ljava/time/chrono/MinguoDate;");
        return this.with(localDate);
    }

    @Override
    MinguoDate plusMonths(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.plusMonths:(J)Ljava/time/LocalDate;");
        LocalDate localDate = this.isoDate.plusMonths(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoDate.with:(Ljava/time/LocalDate;)Ljava/time/chrono/MinguoDate;");
        return this.with(localDate);
    }

    @Override
    MinguoDate plusWeeks(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.plusWeeks:(J)Ljava/time/chrono/ChronoLocalDate;");
        return (MinguoDate)super.plusWeeks(l);
    }

    @Override
    MinguoDate plusDays(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.plusDays:(J)Ljava/time/LocalDate;");
        LocalDate localDate = this.isoDate.plusDays(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoDate.with:(Ljava/time/LocalDate;)Ljava/time/chrono/MinguoDate;");
        return this.with(localDate);
    }

    @Override
    public MinguoDate plus(long l, TemporalUnit temporalUnit) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/chrono/ChronoLocalDate;");
        return (MinguoDate)super.plus(l, temporalUnit);
    }

    @Override
    public MinguoDate minus(long l, TemporalUnit temporalUnit) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.minus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/chrono/ChronoLocalDate;");
        return (MinguoDate)super.minus(l, temporalUnit);
    }

    @Override
    MinguoDate minusYears(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.minusYears:(J)Ljava/time/chrono/ChronoLocalDate;");
        return (MinguoDate)super.minusYears(l);
    }

    @Override
    MinguoDate minusMonths(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.minusMonths:(J)Ljava/time/chrono/ChronoLocalDate;");
        return (MinguoDate)super.minusMonths(l);
    }

    @Override
    MinguoDate minusWeeks(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.minusWeeks:(J)Ljava/time/chrono/ChronoLocalDate;");
        return (MinguoDate)super.minusWeeks(l);
    }

    @Override
    MinguoDate minusDays(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.minusDays:(J)Ljava/time/chrono/ChronoLocalDate;");
        return (MinguoDate)super.minusDays(l);
    }

    private MinguoDate with(LocalDate localDate) {
        MinguoDate minguoDate;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.equals:(Ljava/lang/Object;)Z");
        boolean bl = localDate.equals(this.isoDate);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            minguoDate = this;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordAllocation((String)"java/time/chrono/MinguoDate");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoDate.<init>:(Ljava/time/LocalDate;)V");
            minguoDate = new MinguoDate(localDate);
        }
        return minguoDate;
    }

    public final ChronoLocalDateTime<MinguoDate> atTime(LocalTime localTime) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.atTime:(Ljava/time/LocalTime;)Ljava/time/chrono/ChronoLocalDateTime;");
        return super.atTime(localTime);
    }

    @Override
    public ChronoPeriod until(ChronoLocalDate chronoLocalDate) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.until:(Ljava/time/chrono/ChronoLocalDate;)Ljava/time/Period;");
        Period period = this.isoDate.until(chronoLocalDate);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoDate.getChronology:()Ljava/time/chrono/MinguoChronology;");
        MinguoChronology minguoChronology = this.getChronology();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.getYears:()I");
        int n = period.getYears();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.getMonths:()I");
        int n2 = period.getMonths();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.getDays:()I");
        int n3 = period.getDays();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoChronology.period:(III)Ljava/time/chrono/ChronoPeriod;");
        return minguoChronology.period(n, n2, n3);
    }

    @Override
    public long toEpochDay() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.toEpochDay:()J");
        return this.isoDate.toEpochDay();
    }

    @Override
    public boolean equals(Object object) {
        RuntimeCostAccounter.recordJump();
        if (this == object) {
            return true;
        }
        boolean bl = object instanceof MinguoDate;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            MinguoDate minguoDate = (MinguoDate)object;
            LocalDate localDate = minguoDate.isoDate;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.equals:(Ljava/lang/Object;)Z");
            return this.isoDate.equals(localDate);
        }
        return false;
    }

    @Override
    public int hashCode() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoDate.getChronology:()Ljava/time/chrono/MinguoChronology;");
        MinguoChronology minguoChronology = this.getChronology();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoChronology.getId:()Ljava/lang/String;");
        String string = minguoChronology.getId();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.hashCode:()I");
        int n = string.hashCode();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.hashCode:()I");
        return n ^ this.isoDate.hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidObjectException");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidObjectException.<init>:(Ljava/lang/String;)V");
        InvalidObjectException invalidObjectException = new InvalidObjectException("Deserialization via serialization delegate");
        RuntimeCostAccounter.recordThrow();
        throw invalidObjectException;
    }

    private Object writeReplace() {
        RuntimeCostAccounter.recordAllocation((String)"java/time/chrono/Ser");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Ser.<init>:(BLjava/lang/Object;)V");
        return new Ser(7, this);
    }

    void writeExternal(DataOutput dataOutput) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoDate.get:(Ljava/time/temporal/TemporalField;)I");
        int n = this.get(ChronoField.YEAR);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeInt:(I)V");
        dataOutput.writeInt(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoDate.get:(Ljava/time/temporal/TemporalField;)I");
        int n2 = this.get(ChronoField.MONTH_OF_YEAR);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeByte:(I)V");
        dataOutput.writeByte(n2);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoDate.get:(Ljava/time/temporal/TemporalField;)I");
        int n3 = this.get(ChronoField.DAY_OF_MONTH);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeByte:(I)V");
        dataOutput.writeByte(n3);
    }

    static MinguoDate readExternal(DataInput dataInput) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInput.readInt:()I");
        int n = dataInput.readInt();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInput.readByte:()B");
        byte by = dataInput.readByte();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInput.readByte:()B");
        byte by2 = dataInput.readByte();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoChronology.date:(III)Ljava/time/chrono/MinguoDate;");
        return MinguoChronology.INSTANCE.date(n, by, by2);
    }
}

