/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.time.chrono;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.InvalidObjectException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.Serializable;
import sandbox.java.time.Clock;
import sandbox.java.time.DateTimeException;
import sandbox.java.time.Instant;
import sandbox.java.time.LocalDate;
import sandbox.java.time.LocalDateTime;
import sandbox.java.time.Month;
import sandbox.java.time.Period;
import sandbox.java.time.Year;
import sandbox.java.time.ZoneId;
import sandbox.java.time.ZonedDateTime;
import sandbox.java.time.chrono.AbstractChronology;
import sandbox.java.time.chrono.Era;
import sandbox.java.time.chrono.IsoEra;
import sandbox.java.time.format.ResolverStyle;
import sandbox.java.time.temporal.ChronoField;
import sandbox.java.time.temporal.TemporalAccessor;
import sandbox.java.time.temporal.TemporalField;
import sandbox.java.time.temporal.ValueRange;
import sandbox.java.util.Arrays;
import sandbox.java.util.List;
import sandbox.java.util.Map;
import sandbox.java.util.Objects;

public final class IsoChronology
extends AbstractChronology
implements Serializable {
    public static final IsoChronology INSTANCE;
    private static final long serialVersionUID = -1440403870442975015L;

    private IsoChronology() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.<init>:()V");
    }

    @Override
    public String getId() {
        return "ISO";
    }

    @Override
    public String getCalendarType() {
        return "iso8601";
    }

    @Override
    public LocalDate date(Era era, int n, int n2, int n3) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/IsoChronology.prolepticYear:(Ljava/time/chrono/Era;I)I");
        int n4 = this.prolepticYear(era, n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/IsoChronology.date:(III)Ljava/time/LocalDate;");
        return this.date(n4, n2, n3);
    }

    @Override
    public LocalDate date(int n, int n2, int n3) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.of:(III)Ljava/time/LocalDate;");
        return LocalDate.of(n, n2, n3);
    }

    @Override
    public LocalDate dateYearDay(Era era, int n, int n2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/IsoChronology.prolepticYear:(Ljava/time/chrono/Era;I)I");
        int n3 = this.prolepticYear(era, n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/IsoChronology.dateYearDay:(II)Ljava/time/LocalDate;");
        return this.dateYearDay(n3, n2);
    }

    @Override
    public LocalDate dateYearDay(int n, int n2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.ofYearDay:(II)Ljava/time/LocalDate;");
        return LocalDate.ofYearDay(n, n2);
    }

    @Override
    public LocalDate dateEpochDay(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.ofEpochDay:(J)Ljava/time/LocalDate;");
        return LocalDate.ofEpochDay(l);
    }

    @Override
    public LocalDate date(TemporalAccessor temporalAccessor) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.from:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/LocalDate;");
        return LocalDate.from(temporalAccessor);
    }

    public LocalDateTime localDateTime(TemporalAccessor temporalAccessor) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.from:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/LocalDateTime;");
        return LocalDateTime.from(temporalAccessor);
    }

    public ZonedDateTime zonedDateTime(TemporalAccessor temporalAccessor) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.from:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/ZonedDateTime;");
        return ZonedDateTime.from(temporalAccessor);
    }

    public ZonedDateTime zonedDateTime(Instant instant, ZoneId zoneId) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.ofInstant:(Ljava/time/Instant;Ljava/time/ZoneId;)Ljava/time/ZonedDateTime;");
        return ZonedDateTime.ofInstant(instant, zoneId);
    }

    @Override
    public LocalDate dateNow() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.systemDefaultZone:()Ljava/time/Clock;");
        Clock clock = Clock.systemDefaultZone();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/IsoChronology.dateNow:(Ljava/time/Clock;)Ljava/time/LocalDate;");
        return this.dateNow(clock);
    }

    @Override
    public LocalDate dateNow(ZoneId zoneId) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.system:(Ljava/time/ZoneId;)Ljava/time/Clock;");
        Clock clock = Clock.system(zoneId);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/IsoChronology.dateNow:(Ljava/time/Clock;)Ljava/time/LocalDate;");
        return this.dateNow(clock);
    }

    @Override
    public LocalDate dateNow(Clock clock) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(clock, "clock");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.now:(Ljava/time/Clock;)Ljava/time/LocalDate;");
        LocalDate localDate = LocalDate.now(clock);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/IsoChronology.date:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/LocalDate;");
        return this.date(localDate);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isLeapYear(long l) {
        RuntimeCostAccounter.recordJump();
        if ((l & 3L) != 0L) return false;
        RuntimeCostAccounter.recordJump();
        if (l % 100L == 0L) {
            RuntimeCostAccounter.recordJump();
            if (l % 400L != 0L) return false;
        }
        boolean bl = true;
        RuntimeCostAccounter.recordJump();
        return bl;
    }

    @Override
    public int prolepticYear(Era era, int n) {
        int n2;
        boolean bl = era instanceof IsoEra;
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/ClassCastException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassCastException.<init>:(Ljava/lang/String;)V");
            ClassCastException classCastException = new ClassCastException("Era must be IsoEra");
            RuntimeCostAccounter.recordThrow();
            throw classCastException;
        }
        RuntimeCostAccounter.recordJump();
        if (era == IsoEra.CE) {
            n2 = n;
            RuntimeCostAccounter.recordJump();
        } else {
            n2 = 1 - n;
        }
        return n2;
    }

    @Override
    public IsoEra eraOf(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/IsoEra.of:(I)Ljava/time/chrono/IsoEra;");
        return IsoEra.of(n);
    }

    @Override
    public List<Era> eras() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/IsoEra.values:()[Ljava/time/chrono/IsoEra;");
        IsoEra[] isoEraArray = IsoEra.values();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.asList:([Ljava/lang/Object;)Ljava/util/List;");
        return Arrays.asList(isoEraArray);
    }

    @Override
    public LocalDate resolveDate(Map<TemporalField, Long> map, ResolverStyle resolverStyle) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.resolveDate:(Ljava/util/Map;Ljava/time/format/ResolverStyle;)Ljava/time/chrono/ChronoLocalDate;");
        return (LocalDate)super.resolveDate(map, resolverStyle);
    }

    @Override
    void resolveProlepticMonth(Map<TemporalField, Long> map, ResolverStyle resolverStyle) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
        Long l = map.remove(ChronoField.PROLEPTIC_MONTH);
        RuntimeCostAccounter.recordJump();
        if (l != null) {
            RuntimeCostAccounter.recordJump();
            if (resolverStyle != ResolverStyle.LENIENT) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                long l2 = l;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
                ChronoField.PROLEPTIC_MONTH.checkValidValue(l2);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
            long l3 = l;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.floorMod:(JJ)J");
            long l4 = Math.floorMod(l3, 12L) + 1L;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/IsoChronology.addFieldValue:(Ljava/util/Map;Ljava/time/temporal/ChronoField;J)V");
            this.addFieldValue(map, ChronoField.MONTH_OF_YEAR, l4);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
            long l5 = l;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.floorDiv:(JJ)J");
            long l6 = Math.floorDiv(l5, 12L);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/IsoChronology.addFieldValue:(Ljava/util/Map;Ljava/time/temporal/ChronoField;J)V");
            this.addFieldValue(map, ChronoField.YEAR, l6);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    LocalDate resolveYearOfEra(Map<TemporalField, Long> var1_1, ResolverStyle var2_2) {
        block17: {
            block12: {
                block16: {
                    block13: {
                        block15: {
                            block14: {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
                                var3_3 = var1_1.remove(ChronoField.YEAR_OF_ERA);
                                RuntimeCostAccounter.recordJump();
                                if (var3_3 == null) break block12;
                                RuntimeCostAccounter.recordJump();
                                if (var2_2 != ResolverStyle.LENIENT) {
                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                                    v0 = var3_3;
                                    RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
                                    ChronoField.YEAR_OF_ERA.checkValidValue(v0);
                                }
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
                                var4_4 = var1_1.remove(ChronoField.ERA);
                                RuntimeCostAccounter.recordJump();
                                if (var4_4 != null) break block13;
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
                                var5_5 = var1_1.get(ChronoField.YEAR);
                                RuntimeCostAccounter.recordJump();
                                if (var2_2 != ResolverStyle.STRICT) break block14;
                                RuntimeCostAccounter.recordJump();
                                if (var5_5 != null) {
                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                                    cfr_temp_0 = var5_5 - 0L;
                                    v1 = cfr_temp_0 == 0L ? 0 : (cfr_temp_0 < 0L ? -1 : 1);
                                    RuntimeCostAccounter.recordJump();
                                    if (v1 > 0) {
                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                                        v2 = var3_3;
                                        RuntimeCostAccounter.recordJump();
                                    } else {
                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                                        v3 = var3_3;
                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.subtractExact:(JJ)J");
                                        v2 = Math.subtractExact(1L, v3);
                                    }
                                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/IsoChronology.addFieldValue:(Ljava/util/Map;Ljava/time/temporal/ChronoField;J)V");
                                    this.addFieldValue(var1_1, ChronoField.YEAR, v2);
                                    RuntimeCostAccounter.recordJump();
                                } else {
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                                    var1_1.put(ChronoField.YEAR_OF_ERA, var3_3);
                                    RuntimeCostAccounter.recordJump();
                                }
                                break block15;
                            }
                            RuntimeCostAccounter.recordJump();
                            if (var5_5 == null) ** GOTO lbl-1000
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                            cfr_temp_1 = var5_5 - 0L;
                            v4 = cfr_temp_1 == 0L ? 0 : (cfr_temp_1 < 0L ? -1 : 1);
                            RuntimeCostAccounter.recordJump();
                            if (v4 > 0) lbl-1000:
                            // 2 sources

                            {
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                                v5 = var3_3;
                                RuntimeCostAccounter.recordJump();
                            } else {
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                                v6 = var3_3;
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.subtractExact:(JJ)J");
                                v5 = Math.subtractExact(1L, v6);
                            }
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/IsoChronology.addFieldValue:(Ljava/util/Map;Ljava/time/temporal/ChronoField;J)V");
                            this.addFieldValue(var1_1, ChronoField.YEAR, v5);
                        }
                        RuntimeCostAccounter.recordJump();
                        break block16;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                    cfr_temp_2 = var4_4 - 1L;
                    v7 = cfr_temp_2 == 0L ? 0 : (cfr_temp_2 < 0L ? -1 : 1);
                    RuntimeCostAccounter.recordJump();
                    if (v7 == false) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                        v8 = var3_3;
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/IsoChronology.addFieldValue:(Ljava/util/Map;Ljava/time/temporal/ChronoField;J)V");
                        this.addFieldValue(var1_1, ChronoField.YEAR, v8);
                        RuntimeCostAccounter.recordJump();
                    } else {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                        cfr_temp_3 = var4_4 - 0L;
                        v9 = cfr_temp_3 == 0L ? 0 : (cfr_temp_3 < 0L ? -1 : 1);
                        RuntimeCostAccounter.recordJump();
                        if (v9 == false) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                            v10 = var3_3;
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.subtractExact:(JJ)J");
                            v11 = Math.subtractExact(1L, v10);
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/IsoChronology.addFieldValue:(Ljava/util/Map;Ljava/time/temporal/ChronoField;J)V");
                            this.addFieldValue(var1_1, ChronoField.YEAR, v11);
                            RuntimeCostAccounter.recordJump();
                        } else {
                            RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
                            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                            v12 = new StringBuilder();
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                            v13 = v12.append("Invalid value for era: ");
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                            v14 = v13.append(var4_4);
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                            v15 = v14.toString();
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
                            v16 = new DateTimeException(v15);
                            RuntimeCostAccounter.recordThrow();
                            throw v16;
                        }
                    }
                }
                RuntimeCostAccounter.recordJump();
                break block17;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
            v17 = var1_1.containsKey(ChronoField.ERA);
            RuntimeCostAccounter.recordJump();
            if (v17) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                v18 = var1_1.get(ChronoField.ERA);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
                ChronoField.ERA.checkValidValue(v18);
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    LocalDate resolveYMD(Map<TemporalField, Long> var1_1, ResolverStyle var2_2) {
        block4: {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
            v0 = var1_1.remove(ChronoField.YEAR);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidIntValue:(J)I");
            var3_3 = ChronoField.YEAR.checkValidIntValue(v0);
            RuntimeCostAccounter.recordJump();
            if (var2_2 == ResolverStyle.LENIENT) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                v1 = var1_1.remove(ChronoField.MONTH_OF_YEAR);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.subtractExact:(JJ)J");
                var4_4 = Math.subtractExact(v1, 1L);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                v2 = var1_1.remove(ChronoField.DAY_OF_MONTH);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.subtractExact:(JJ)J");
                var6_5 = Math.subtractExact(v2, 1L);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.of:(III)Ljava/time/LocalDate;");
                v3 = LocalDate.of(var3_3, 1, 1);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.plusMonths:(J)Ljava/time/LocalDate;");
                v4 = v3.plusMonths(var4_4);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.plusDays:(J)Ljava/time/LocalDate;");
                return v4.plusDays(var6_5);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
            v5 = var1_1.remove(ChronoField.MONTH_OF_YEAR);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidIntValue:(J)I");
            var8_6 = ChronoField.MONTH_OF_YEAR.checkValidIntValue(v5);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
            v6 = var1_1.remove(ChronoField.DAY_OF_MONTH);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidIntValue:(J)I");
            var9_7 = ChronoField.DAY_OF_MONTH.checkValidIntValue(v6);
            RuntimeCostAccounter.recordJump();
            if (var2_2 != ResolverStyle.SMART) break block4;
            RuntimeCostAccounter.recordJump();
            if (var8_6 == 4) ** GOTO lbl-1000
            RuntimeCostAccounter.recordJump();
            if (var8_6 == 6) ** GOTO lbl-1000
            RuntimeCostAccounter.recordJump();
            if (var8_6 == 9) ** GOTO lbl-1000
            RuntimeCostAccounter.recordJump();
            if (var8_6 == 11) lbl-1000:
            // 4 sources

            {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
                var9_7 = Math.min(var9_7, 30);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordJump();
                if (var8_6 == 2) {
                    v7 = var3_3;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/Year.isLeap:(J)Z");
                    v8 = Year.isLeap(v7);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/Month.length:(Z)I");
                    v9 = Month.FEBRUARY.length(v8);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
                    var9_7 = Math.min(var9_7, v9);
                }
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.of:(III)Ljava/time/LocalDate;");
        return LocalDate.of(var3_3, var8_6, var9_7);
    }

    @Override
    public ValueRange range(ChronoField chronoField) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.range:()Ljava/time/temporal/ValueRange;");
        return chronoField.range();
    }

    @Override
    public Period period(int n, int n2, int n3) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.of:(III)Ljava/time/Period;");
        return Period.of(n, n2, n3);
    }

    @Override
    Object writeReplace() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.writeReplace:()Ljava/lang/Object;");
        return super.writeReplace();
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidObjectException");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidObjectException.<init>:(Ljava/lang/String;)V");
        InvalidObjectException invalidObjectException = new InvalidObjectException("Deserialization via serialization delegate");
        RuntimeCostAccounter.recordThrow();
        throw invalidObjectException;
    }

    static {
        RuntimeCostAccounter.recordAllocation((String)"java/time/chrono/IsoChronology");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/IsoChronology.<init>:()V");
        INSTANCE = new IsoChronology();
    }
}

