/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.io;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.IOException;
import sandbox.java.io.InputStream;
import sandbox.java.io.InterruptedIOException;
import sandbox.java.io.PipedOutputStream;

public class PipedInputStream
extends InputStream {
    boolean closedByWriter;
    volatile boolean closedByReader;
    boolean connected;
    Thread readSide;
    Thread writeSide;
    private static final int DEFAULT_PIPE_SIZE = 1024;
    protected static final int PIPE_SIZE = 1024;
    protected byte[] buffer;
    protected int in;
    protected int out;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PipedInputStream(PipedOutputStream pipedOutputStream) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PipedInputStream.<init>:(Ljava/io/PipedOutputStream;I)V");
        this(pipedOutputStream, 1024);
    }

    public PipedInputStream(PipedOutputStream pipedOutputStream, int n) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.<init>:()V");
        this.closedByWriter = false;
        this.closedByReader = false;
        this.connected = false;
        this.in = -1;
        this.out = 0;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PipedInputStream.initPipe:(I)V");
        this.initPipe(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PipedInputStream.connect:(Ljava/io/PipedOutputStream;)V");
        this.connect(pipedOutputStream);
    }

    public PipedInputStream() {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.<init>:()V");
        this.closedByWriter = false;
        this.closedByReader = false;
        this.connected = false;
        this.in = -1;
        this.out = 0;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PipedInputStream.initPipe:(I)V");
        this.initPipe(1024);
    }

    public PipedInputStream(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.<init>:()V");
        this.closedByWriter = false;
        this.closedByReader = false;
        this.connected = false;
        this.in = -1;
        this.out = 0;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PipedInputStream.initPipe:(I)V");
        this.initPipe(n);
    }

    private void initPipe(int n) {
        RuntimeCostAccounter.recordJump();
        if (n <= 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Pipe Size <= 0");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        int n2 = n;
        RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)1);
        this.buffer = new byte[n2];
    }

    public void connect(PipedOutputStream pipedOutputStream) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PipedOutputStream.connect:(Ljava/io/PipedInputStream;)V");
        pipedOutputStream.connect(this);
    }

    protected synchronized void receive(int n) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PipedInputStream.checkStateForReceive:()V");
        this.checkStateForReceive();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
        this.writeSide = Thread.currentThread();
        RuntimeCostAccounter.recordJump();
        if (this.in == this.out) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PipedInputStream.awaitSpace:()V");
            this.awaitSpace();
        }
        RuntimeCostAccounter.recordJump();
        if (this.in < 0) {
            this.in = 0;
            this.out = 0;
        }
        this.buffer[this.in++] = (byte)(n & 0xFF);
        int n2 = this.buffer.length;
        RuntimeCostAccounter.recordJump();
        if (this.in >= n2) {
            this.in = 0;
        }
    }

    synchronized void receive(byte[] byArray, int n, int n2) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PipedInputStream.checkStateForReceive:()V");
        this.checkStateForReceive();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
        this.writeSide = Thread.currentThread();
        int n3 = n2;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n3 <= 0) break;
            RuntimeCostAccounter.recordJump();
            if (this.in == this.out) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/PipedInputStream.awaitSpace:()V");
                this.awaitSpace();
            }
            int n4 = 0;
            RuntimeCostAccounter.recordJump();
            if (this.out < this.in) {
                n4 = this.buffer.length - this.in;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordJump();
                if (this.in < this.out) {
                    RuntimeCostAccounter.recordJump();
                    if (this.in == -1) {
                        this.out = 0;
                        this.in = 0;
                        n4 = this.buffer.length - this.in;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        n4 = this.out - this.in;
                    }
                }
            }
            RuntimeCostAccounter.recordJump();
            if (n4 > n3) {
                n4 = n3;
            }
            RuntimeCostAccounter.recordJump();
            if (!$assertionsDisabled) {
                RuntimeCostAccounter.recordJump();
                if (n4 <= 0) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:()V");
                    AssertionError assertionError = new AssertionError();
                    RuntimeCostAccounter.recordThrow();
                    throw assertionError;
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
            System.arraycopy(byArray, n, this.buffer, this.in, n4);
            n3 -= n4;
            n += n4;
            this.in += n4;
            int n5 = this.buffer.length;
            RuntimeCostAccounter.recordJump();
            if (this.in >= n5) {
                this.in = 0;
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    private void checkStateForReceive() throws IOException {
        block7: {
            block6: {
                RuntimeCostAccounter.recordJump();
                if (!this.connected) {
                    RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
                    IOException iOException = new IOException("Pipe not connected");
                    RuntimeCostAccounter.recordThrow();
                    throw iOException;
                }
                RuntimeCostAccounter.recordJump();
                if (this.closedByWriter) break block6;
                RuntimeCostAccounter.recordJump();
                if (!this.closedByReader) break block7;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
            IOException iOException = new IOException("Pipe closed");
            RuntimeCostAccounter.recordThrow();
            throw iOException;
        }
        RuntimeCostAccounter.recordJump();
        if (this.readSide != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.isAlive:()Z");
            boolean bl = this.readSide.isAlive();
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
                RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
                IOException iOException = new IOException("Read end dead");
                RuntimeCostAccounter.recordThrow();
                throw iOException;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void awaitSpace() throws IOException {
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (this.in != this.out) {
                return;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PipedInputStream.checkStateForReceive:()V");
            this.checkStateForReceive();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.notifyAll:()V");
            this.notifyAll();
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.wait:(J)V");
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                RuntimeCostAccounter.recordAllocation((String)"java/io/InterruptedIOException");
                RuntimeCostAccounter.recordMethodCall((String)"java/io/InterruptedIOException.<init>:()V");
                InterruptedIOException interruptedIOException = new InterruptedIOException();
                RuntimeCostAccounter.recordThrow();
                throw interruptedIOException;
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    synchronized void receivedLast() {
        this.closedByWriter = true;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.notifyAll:()V");
        this.notifyAll();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized int read() throws IOException {
        RuntimeCostAccounter.recordJump();
        if (!this.connected) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
            IOException iOException = new IOException("Pipe not connected");
            RuntimeCostAccounter.recordThrow();
            throw iOException;
        }
        RuntimeCostAccounter.recordJump();
        if (this.closedByReader) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
            IOException iOException = new IOException("Pipe closed");
            RuntimeCostAccounter.recordThrow();
            throw iOException;
        }
        RuntimeCostAccounter.recordJump();
        if (this.writeSide != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.isAlive:()Z");
            boolean bl = this.writeSide.isAlive();
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                RuntimeCostAccounter.recordJump();
                if (!this.closedByWriter) {
                    RuntimeCostAccounter.recordJump();
                    if (this.in < 0) {
                        RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
                        IOException iOException = new IOException("Write end dead");
                        RuntimeCostAccounter.recordThrow();
                        throw iOException;
                    }
                }
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
        this.readSide = Thread.currentThread();
        int n = 2;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (this.in >= 0) break;
            RuntimeCostAccounter.recordJump();
            if (this.closedByWriter) {
                return -1;
            }
            RuntimeCostAccounter.recordJump();
            if (this.writeSide != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.isAlive:()Z");
                boolean bl = this.writeSide.isAlive();
                RuntimeCostAccounter.recordJump();
                if (!bl) {
                    RuntimeCostAccounter.recordJump();
                    if (--n < 0) {
                        RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
                        IOException iOException = new IOException("Pipe broken");
                        RuntimeCostAccounter.recordThrow();
                        throw iOException;
                    }
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.notifyAll:()V");
            this.notifyAll();
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.wait:(J)V");
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                RuntimeCostAccounter.recordAllocation((String)"java/io/InterruptedIOException");
                RuntimeCostAccounter.recordMethodCall((String)"java/io/InterruptedIOException.<init>:()V");
                InterruptedIOException interruptedIOException = new InterruptedIOException();
                RuntimeCostAccounter.recordThrow();
                throw interruptedIOException;
            }
            RuntimeCostAccounter.recordJump();
        }
        int n2 = this.buffer[this.out++] & 0xFF;
        int n3 = this.buffer.length;
        RuntimeCostAccounter.recordJump();
        if (this.out >= n3) {
            this.out = 0;
        }
        RuntimeCostAccounter.recordJump();
        if (this.in == this.out) {
            this.in = -1;
        }
        return n2;
    }

    @Override
    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        block13: {
            block12: {
                RuntimeCostAccounter.recordJump();
                if (byArray == null) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                    NullPointerException nullPointerException = new NullPointerException();
                    RuntimeCostAccounter.recordThrow();
                    throw nullPointerException;
                }
                RuntimeCostAccounter.recordJump();
                if (n < 0) break block12;
                RuntimeCostAccounter.recordJump();
                if (n2 < 0) break block12;
                int n3 = byArray.length - n;
                RuntimeCostAccounter.recordJump();
                if (n2 <= n3) break block13;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:()V");
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException();
            RuntimeCostAccounter.recordThrow();
            throw indexOutOfBoundsException;
        }
        RuntimeCostAccounter.recordJump();
        if (n2 == 0) {
            return 0;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PipedInputStream.read:()I");
        int n4 = this.read();
        RuntimeCostAccounter.recordJump();
        if (n4 < 0) {
            return -1;
        }
        byArray[n] = (byte)n4;
        int n5 = 1;
        while (true) {
            int n6;
            RuntimeCostAccounter.recordJump();
            if (this.in < 0) break;
            RuntimeCostAccounter.recordJump();
            if (n2 <= 1) break;
            RuntimeCostAccounter.recordJump();
            if (this.in > this.out) {
                int n7 = this.buffer.length - this.out;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
                n6 = Math.min(n7, this.in - this.out);
                RuntimeCostAccounter.recordJump();
            } else {
                n6 = this.buffer.length - this.out;
            }
            RuntimeCostAccounter.recordJump();
            if (n6 > n2 - 1) {
                n6 = n2 - 1;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
            System.arraycopy(this.buffer, this.out, byArray, n + n5, n6);
            this.out += n6;
            n5 += n6;
            n2 -= n6;
            int n8 = this.buffer.length;
            RuntimeCostAccounter.recordJump();
            if (this.out >= n8) {
                this.out = 0;
            }
            RuntimeCostAccounter.recordJump();
            if (this.in == this.out) {
                this.in = -1;
            }
            RuntimeCostAccounter.recordJump();
        }
        return n5;
    }

    @Override
    public synchronized int available() throws IOException {
        RuntimeCostAccounter.recordJump();
        if (this.in < 0) {
            return 0;
        }
        RuntimeCostAccounter.recordJump();
        if (this.in == this.out) {
            return this.buffer.length;
        }
        RuntimeCostAccounter.recordJump();
        if (this.in > this.out) {
            return this.in - this.out;
        }
        return this.in + this.buffer.length - this.out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.closedByReader = true;
        PipedInputStream pipedInputStream = this;
        try {
            this.in = -1;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    static {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.desiredAssertionStatus:()Z");
        boolean bl2 = PipedInputStream.class.desiredAssertionStatus();
        RuntimeCostAccounter.recordJump();
        if (!bl2) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        $assertionsDisabled = bl;
    }
}

