# Changelog

## 1.2.2

- Standardize prompt behaviour with and without `--json`
- Improve detection of `git` servers that do not support shallow clones ([#805](https://github.com/bower/bower/issues/805))
- Ignore remote tags (tags ending with ^{})
- Fix bower not saving the correct endpoint when in some edge cases ([#806](https://github.com/bower/bower/issues/806))


## 1.2.1 - 2013-08-19

- Fix bower throwing on non-semver targets ([#800](https://github.com/bower/bower/issues/800))


## 1.2.0 - 2013-08-19

- __Bower no longer installs a pre-release version by default, that is, if no version/range is specified__ ([#782](https://github.com/bower/bower/issues/782))
- __`bower info <package>` will now show the latest `<package>` information along with the available versions__ ([#759](https://github.com/bower/bower/issues/759))
- __`bower link` no longer requires an elevated user on Windows in most cases__ ([#472](https://github.com/bower/bower/issues/472))
- __Init command now prompts for the whole `bower.json` spec properties, filling in default values for `author` and `homepage` based on `git` settings__ ([#693](https://github.com/bower/bower/issues/693))
- Changes to endpoint sources in `bower.json` are now catched up by `bower install` and `bower update` ([#788](https://github.com/bower/bower/issues/788))
- Allow semver ranges in `bower cache clean`, e.g. `bower cache clean jquery#<2.0.0` ([#688](https://github.com/bower/bower/issues/688))
- Normalize `bower list --paths` on Windows ([#279](https://github.com/bower/bower/issues/279))
- Multiple mains are now correctly outputted as an array in `bower list --paths` ([#784](https://github.com/bower/bower/issues/784))
- Add `--relative` option to `bower list --json` so that Bower outputs relative paths instead of absolute ([#714](https://github.com/bower/bower/issues/714))
- `bower list --paths` now outputs relative paths by default; can be turned off with `--no-relative` ([#785](https://github.com/bower/bower/issues/785))
- Bower no longer fails if `symlinks` to files are present in the `bower_components` folder ([#783](https://github.com/bower/bower/issues/783) and [#791](https://github.com/bower/bower/issues/791))
- Disable git templates/hooks when running `git` ([#761](https://github.com/bower/bower/issues/761))
- Add instructions to setup git workaround for proxies when execution of `git` fails ([#250](https://github.com/bower/bower/issues/250))
- Ignore `component.json` if it looks like a component(1) file ([#556](https://github.com/bower/bower/issues/556))
- Fix multi-user usage on bower when it creates temporary directories to hold some files
- Fix prompting causing an invalid JSON output when running commands with `--json`
- When running Bower commands programmatically, prompting is now disabled by default (see the updated progammatic [usage](https://github.com/bower/bower#programmatic-api) for more info)
- Other minor improvements and fixes

Fix for `#788` requires installed components to be re-installed.


## 1.1.2 - 2013-08-10

- Detect and fallback if the git server does not support `--depth=1` when cloning ([#747](https://github.com/bower/bower/issues/747))


## 1.1.1 - 2013-08-08

- Fix silent fail when spawning child processes in some edge cases ([#722](https://github.com/bower/bower/issues/722))
- Fix `home` command not guessing the correct URL for `GitHub` ssh endpoints (requires `bower cache-clean`)
- Fix bower not correctly filtering packages with symlinks in some cases ([#730](https://github.com/bower/bower/issues/730))
- Fix multi-user usage on bower when it falls back to create a `/tmp/bower` folder ([#743](https://github.com/bower/bower/issues/743))
- Bower now sends a fake user agent when behind a proxy by default, so that corporate proxies do not block requests ([#698](https://github.com/bower/bower/issues/698))
- Bower now translates GitHub public `git://` URLs to `git@` when behind a proxy ([#731](https://github.com/bower/bower/issues/731))
- Minor improvements to the CLI output on small terminals
- Minor programmatic usage improvements
- Minor help usage fixes


## 1.1.0 - 2013-08-03

- __Fix `--save` and `--save-dev` not working correctly for the uninstall command in some situations__
- __Attempting to register a package that declares `"private": true` in `bower.json` will result in an error ([#162](https://github.com/bower/bower/issues/162))__
- __Fix retry strategy on download error that was causing some strange I/O errors__ ([#699](https://github.com/bower/bower/issues/699) and [#704](https://github.com/bower/bower/issues/704))
- __`bower prune` now clears pruned packages dependencies if they are also extraneous__ ([#708](https://github.com/bower/bower/issues/708))
- __`bower uninstall` now uninstalls uninstalled packages dependencies if they are not shared ([#609](https://github.com/bower/bower/issues/609))__
- Fix `bower list` display the `incompatible` label even if they are compatible ([#710](https://github.com/bower/bower/issues/710))
- Fix `bower cache clean` not working correctly when `package#non-semver` is specified
- Implement no operation `completion` command to prevent weird output when hitting tab ([#691](https://github.com/bower/bower/issues/691))
- Fix `bower info --help` ([#703](https://github.com/bower/bower/issues/703))
- Add colorized output for `bower info <package>#<version>` ([#571](https://github.com/bower/bower/issues/571))
- Added `bower ls` as an alias to `bower list`
- Fix regression: do not create a json file when saving is required, warn instead
- Ignore linked packages when reading dependencies in `bower init` ([#709](https://github.com/bower/bower/issues/709))
- `bower list` is now able to (partially) reconstruct the dependency tree, even for dependencies not declared in `bower.json` ([#622](https://github.com/bower/bower/issues/622))


## 1.0.3 - 2013-07-30

- Fix some changes not being saved to bower.json ([#685](https://github.com/bower/bower/issues/685))
- Fix `bower info <package> <property>` not showing information related to property of the latest version of that package ([#684](https://github.com/bower/bower/issues/684))


## 1.0.2 - 2013-07-30

- Fix severe bug originated from a wrong merge that caused conflict messages to not show up correctly


## 1.0.1 - 2013-07-29

- Fix `bower register` going ahead even if the answer was `no` ([#644](https://github.com/bower/bower/issues/644))
- Fix local endpoints with backslashes on Windows ([#2@endpoint-parser](https://github.com/bower/endpoint-parser/pull/2))
- Fix usage of multiple registries in the registry-client ([#3@registry-client](https://github.com/bower/registry-client/pull/3) and [#2@registry-client](https://github.com/bower/registry-client/pull/2))
- File extensions now have more priority than mime types when deciding if extraction is necessary ([#657](https://github.com/bower/bower/pull/657))
- Fix `Bower` not working when calling `.bat`/`.cmd` commands on Windows; it affected people using `Git portable` ([#626](https://github.com/bower/bower/issues/626))
- Fix `bower list --paths` not resolving all files to absolute paths when the `main` property contained multiple files ([660](https://github.com/bower/bower/issues/660))
- Fix `Bower` renaming `bower.json` and `component.json` files to `index.json` when it was the only file in the folder ([#674](https://github.com/bower/bower/issues/674))
- Ignore symlinks when copying/extracting since they are not portable, specially accross different hard-drives ([#665](https://github.com/bower/bower/issues/665))
- Local file/dir endpoints are now exclusively referenced by an absolute path or relative path starting with `.` ([#666](https://github.com/bower/bower/issues/666))
- Linked packages `bower.json` files are now parsed, making `bower list` account linked packages dependencies ([#659](https://github.com/bower/bower/issues/659))
- Bower now fails to run with sudo unless `--allow-root` is passed ([#498](https://github.com/bower/bower/issues/498))
- Add additional system information such as node version, bower version, OS version when an error occurs ([#670](https://github.com/bower/bower/issues/670))
- `bower install` no longer overwrites `linked` packages unless it needs to ([#593](https://github.com/bower/bower/issues/593)).
- All endpoint parts are now trimmed so that the Manager can better detect similar endpoints ([#3@endpoint-parser](https://github.com/bower/endpoint-parser/pull/3))
- `bower register` now shows the server that will be used ([#647](https://github.com/bower/endpoint-parser/pull/647))


## 1.0.0 - 2013-07-23

Total rewrite of bower.
The list bellow highlights the most important stuff.   
For a complete list of changes that this rewrite and release brings please read: https://github.com/bower/bower/wiki/Rewrite-state


- Clear architecture and separation of concerns
- Much much faster
- `--json` output for all commands
- `--offline` usage for all commands, except `register`
- Proper `install` and `update` commands, similar to `npm` in behaviour
- Named endpoints when installing, e.g. `bower install backbone-amd=backbone#~1.0.0`
- New interactive conflict resolution strategy
- Prevent human errors when using `register`
- New `home` command, similar to `npm`
- New `cache list` command
- New `prune` command
- Many many general bug fixes

Non-backwards compatible changes:

- The value of the `json` property from .bowerrc is no longer used
- `--map` and `--sources` from the list command were removed, use `--json` instead
- Programmatic usage changed, specially the commands interface

Users upgrading from `bower-canary` and `bower@~0.x.x` should do a `bower cache clean`.   
Additionally you may remove the `~/.bower` folder manually since it's no longer used.
On Windows the folder is located in `AppData/bower`.


## 0.10.0 - 2013-07-02

- __Allow specific commits to be targeted__ ([#275](https://github.com/bower/bower/issues/275))
- __Change bower default folder from `components` to `bower_components`__ ([#434](https://github.com/bower/bower/issues/434))
- __Support semver pre-releases and builds__ ([#188](https://github.com/bower/bower/issues/188))
- Use `Content-Type` and `Content-Disposition` to guess file types, such as zip files ([#454](https://github.com/bower/bower/pull/454))
- Fix bower failing silently when using an invalid version value in the bower.json file ([#439](https://github.com/bower/bower/issues/439))
- Fix bower slowness when downloading after redirects ([#437](https://github.com/bower/bower/issues/437))
- Detect and error out with a friendly message when `git` is not installed ([#362](https://github.com/bower/bower/issues/362))
- Add `--quiet` and `--silent` CLI options ([#343](https://github.com/bower/bower/issues/343))
- Minor programmatic usage improvements

_NOTE_: The `components` folder will still be used if already created, making it easier for users to upgrade.

## 0.9.2 - 2013-04-28
- Better fix for [#429](https://github.com/bower/bower/issues/429)

## 0.9.1 - 2013-04-27
- Update `package.json`, docs and other stuff to point to the new `Bower` organisation on GitHub
- Fix root label of `bower list` being an absolute path; now uses the package name
- Fix `bower update <pkg>` updating all packages; now throws when updating an unknown package
- Fix `list` command when package use different names than the `guessed` one ([#429](https://github.com/bower/bower/issues/429))

## 0.9.0 - 2013-04-25
- __Change from `component.json` to `bower.json`__ ([#39](https://github.com/bower/bower/issues/39))
- __Compatibility with `node 0.10.x`, including fix hangs/errors when extracting `zip` files__
- Fix `--save` and `--save-dev` not working with URLs that get redirected ([#417](https://github.com/bower/bower/issues/417))
- Fix `init` command targeting `~commit` instead of `*`. ([#385](https://github.com/bower/bower/issues/385))
- Remove temporary directories before exiting ([#345](https://github.com/bower/bower/issues/345))
- Integrate `update-notifier` ([#202](https://github.com/bower/bower/issues/202))
- Use `json` name when a package name was inferred ([#192](https://github.com/bower/bower/issues/192))
- Fix `bin/bower` not exiting with an exit code greater than zero when an error occurs ([#187](https://github.com/bower/bower/issues/187))
- Fix `--save` and `--save-dev` saving resolved shorthands instead of the actual shorthands
- Fix bower using user defined git templates ([#324](https://github.com/bower/bower/issues/324))
- Add command abbreviations ([#262](https://github.com/bower/bower/issues/262))
- Improve help messages and fix abuse of colors in output
- Wait for every package to resolve before printing error messages ([#290](https://github.com/bower/bower/issues/290))
- Add `shorthand_resolver` to allow shorthands to be resolved to repositories other than GitHub ([#278](https://github.com/bower/bower/issues/278))

## 0.8.6 - 2013-04-03
- Emergency fix for `node 0.8.x` users to make `zip` extraction work again

## 0.8.5 - 2013-03-04
- Fix `cache-clean` command clearing the completion cache when the command was called with specific packages
- Add error message when an error is caught parsing an invalid `component.json`

## 0.8.4 - 2013-03-01
- Fix some more duplicate async callbacks being called twice
- Preserve new lines when saving `component.json` ([#285](https://github.com/bower/bower/issues/285))

## 0.8.3 - 2013-02-27
- Fix error when using the `update` command ([#282](https://github.com/bower/bower/issues/282))

## 0.8.2 - 2013-02-26
- Fix some errors in windows while removing directories, had to downgrade `rimraf` ([#274](https://github.com/bower/bower/issues/274))
- Prevent duplicate package names in error summaries ([#277](https://github.com/bower/bower/issues/277))

## 0.8.1 - 2013-02-25
- Fix some async callbacks being fired twice ([#274](https://github.com/bower/bower/issues/274))

## 0.8.0 - 2013-02-24
- __Add init command similar to `npm init`__ ([#219](https://github.com/bower/bower/issues/219))
- __Add devDependencies__ support ([#251](https://github.com/bower/bower/issues/251))
- __Add `--save-dev` flag to install/uninstall commands__ ([#258](https://github.com/bower/bower/issues/258))
- `cache-clean` command now clears links pointing to nonexistent folders ([#182](https://github.com/bower/bower/issues/182))
- Fix issue when downloading assets behind a proxy using `https` ([#230](https://github.com/bower/bower/issues/230))
- Fix --save saving unresolved components ([#240](https://github.com/bower/bower/issues/240))
- Fix issue when extracting some zip files ([#225](https://github.com/bower/bower/issues/225))
- Fix automatic conflict resolver not selecting the correct version
- Add `--sources` option to the `list` command ([#235](https://github.com/bower/bower/issues/235))
- Automatically clear cache when git commands fail with code 128 ([#216](https://github.com/bower/bower/issues/216))
- Fix `bower` not working correctly behind a proxy in some commands ([#208](https://github.com/bower/bower/issues/208))

## 0.7.1 - 2013-02-20
- Remove postinstall script from `bower` installation

## 0.7.0 - 2013-02-01
- __Ability to resolve conflicts__ ([#214](https://github.com/bower/bower/issues/214))
- __Ability to search and publish to different endpoints by specifying them in the `.bowerrc` file__
- __Experimental autocompletion__
- __Ability to exclude (ignore) files__
- Fix minor issues in the cache clean command
- Better error message for invalid semver tags ([#185](https://github.com/bower/bower/issues/185))
- Only show discover message in the list command only if there are packages
- Fix mismatch issue due to reading cached component.json files ([#214](https://github.com/bower/bower/issues/214))
- Better error messages when reading invalid .bowerrc files ([#220](https://github.com/bower/bower/issues/220))
- Fix update command when used in packages pointing to assets ([#197](https://github.com/bower/bower/issues/197))
- Bower now obeys packages's `.bowerrc` if they define a different `json` ([#205](https://github.com/bower/bower/issues/205))

## 0.6.8 - 2012-12-14
- Improve list command
  - Does not fetch versions if not necessary (for --map and --paths options)
  - Add --offline option to prevent versions from being fetched
- Fix uninstall command not firing the `end` event
- Fix error when executing an unknown command ([#179](https://github.com/bower/bower/issues/179))
- Fix help for the ls command (alias of list)

## 0.6.7 - 2012-12-10
- Fix uninstall removing all unsaved dependencies ([#178](https://github.com/bower/bower/issues/178))
- Fix uninstall --force flag in some cases
- Add --silent option to the register option, to avoid questioning
- Fix possible issues with options in some commands
- Fix error reporting when reading invalid project component.json

## 0.6.6 - 2012-12-03
- Improve error handling while reading component.json
- Fix package name not being correctly collected in the error summary

## 0.6.5 - 2012-12-01
- Fix error summary not being displayed in some edge cases
- Fix bower not fetching latest commits correctly in some cases

## 0.6.4 - 2012-11-29
- Fix permission on downloaded files ([#160](https://github.com/bower/bower/issues/160))

## 0.6.3 - 2012-11-24
- Fix version not being correctly set for local packages ([#155](https://github.com/bower/bower/issues/155))

## 0.6.2 - 2012-11-23
- Fix uninstall --save when there is no component.json

## 0.6.1 - 2012-11-22
- Fix uninstall when the project component.json has no deps saved ([#153](https://github.com/bower/bower/issues/153))
- Fix uncaught errors when using file writter (they are now caught and reported)
- Fix temporary directories not being deleted when an exception occurs ([#153](https://github.com/bower/bower/issues/140))

## 0.6.0 - 2012-11-21
- __Add link command__ (similar to npm)
- Fix error reporting for nested deps
- Abort if a repository is detected when installing.
  This is useful to prevent people from loosing their work
- Minor fixes and improvements

## 0.5.1 - 2012-11-20
- Add errors summary to the end of install/update commands
- Add windows instructions to the README

## 0.5.0 - 2012-11-19
- __Remove package.json support__
- __Support for local path repositories__ ([#132](https://github.com/bower/bower/issues/132))
- `install --save` now saves the correct tag (e.g: ~0.0.1) instead of 'latest'
- `install --save` now saves packages pointing directly to assets correctly
- Bower automatically creates a component.json when install with `--save` is used
- Fix issues with list command ([#142](https://github.com/bower/bower/issues/142))
- Fix local paths not being saved when installing with --save ([#114](https://github.com/bower/bower/issues/114))
- `uninstall` now uninstalls nested dependencies if they are not shared ([#83](https://github.com/bower/bower/issues/83))
- `uninstall` now warns when a dependency conflict occurs and aborts.
  It will only proceed if the `--force` flag is passed
- Bower now detects mismatches between the version specified in the component.json and the tag, informing the user
- `bower ls` now informs when a package has a new commit (for non-tagged repos)
- Add jshintrc and fix a lot of issues related with JSHint warnings
- `bower register` now prompts if the user really wants to proceed
