#include <algorithm>
#include <cfloat>
#include <cmath>
#include <vector>

#include "caffe/layer.hpp"
#include "caffe/util/io.hpp"
#include "caffe/util/math_functions.hpp"
#include "caffe/vision_layers.hpp"

namespace caffe {

template <typename Dtype>
void LossLayer<Dtype>::SetUp(
    const vector<Blob<Dtype>*>& bottom, vector<Blob<Dtype>*>* top) {
  Layer<Dtype>::SetUp(bottom, top);
  CHECK_EQ(bottom[0]->num(), bottom[1]->num())
      << "The data and label should have the same number.";
  if (top->size() == 1) {
  // Layers should copy the loss in the top blob
    (*top)[0]->Reshape(1, 1, 1, 1);
  }
  FurtherSetUp(bottom, top);
}

INSTANTIATE_CLASS(LossLayer);

}  // namespace caffe
