/*
 * Decompiled with CFR 0.152.
 */
package impl.krypt.asn1;

import impl.krypt.asn1.Header;
import impl.krypt.asn1.Length;
import impl.krypt.asn1.SerializeException;
import impl.krypt.asn1.Tag;
import impl.krypt.asn1.TagClass;
import java.io.IOException;
import java.io.OutputStream;

public class EncodableHeader
implements Header {
    private final Tag tag;
    private final Length length;

    public EncodableHeader(int tag, TagClass tagClass, boolean isConstructed, boolean isInfinite) {
        this(new Tag(tag, tagClass, isConstructed), new Length(isInfinite));
    }

    public EncodableHeader(Tag tag, Length length) {
        if (tag == null) {
            throw new NullPointerException();
        }
        if (length == null) {
            throw new NullPointerException();
        }
        this.tag = tag;
        this.length = length;
    }

    @Override
    public void encodeTo(OutputStream out) {
        try {
            out.write(this.tag.getEncoding());
            out.write(this.length.getEncoding());
        }
        catch (IOException ex) {
            throw new SerializeException(ex);
        }
    }

    @Override
    public int getHeaderLength() {
        byte[] tagEncoding = this.tag.getEncoding();
        byte[] lengthEncoding = this.length.getEncoding();
        return tagEncoding.length + lengthEncoding.length;
    }

    @Override
    public Length getLength() {
        return this.length;
    }

    @Override
    public Tag getTag() {
        return this.tag;
    }
}

