import React, { PureComponent, Fragment } from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import { track } from 'analytics';
import Sticky from 'react-stickynode';
import { SCREEN_M } from 'utils/constants';

import plusIcon from 'assets/icons/plus.svg?sprite';
import minusIcon from 'assets/icons/minus.svg?sprite';

import Button from 'components/ui/button';
import Icon from 'components/ui/icon';

import './styles.scss';

const isServer = typeof window === 'undefined';

class MapControlsButtons extends PureComponent {
  renderZoomButtons = () => {
    const {
      viewport: { zoom },
      setMapSettings,
      maxZoom,
      minZoom,
    } = this.props;

    return (
      <Fragment>
        <Button
          theme="theme-button-map-control"
          onClick={() => {
            setMapSettings({ zoom: zoom + 1 > maxZoom ? maxZoom : zoom + 1 });
            track('zoomIn');
          }}
          tooltip={{ text: 'Zoom in' }}
          disabled={zoom >= maxZoom}
        >
          <Icon icon={plusIcon} className="plus-icon" />
        </Button>
        <Button
          theme="theme-button-map-control"
          onClick={() => {
            setMapSettings({ zoom: zoom - 1 < minZoom ? minZoom : zoom - 1 });
            track('zoomOut');
          }}
          tooltip={{ text: 'Zoom out' }}
          disabled={zoom <= minZoom}
        >
          <Icon icon={minusIcon} className="minus-icon" />
        </Button>
      </Fragment>
    );
  };

  render() {
    const { className } = this.props;

    return (
      <div className={`c-dashboard-map-controls ${className || ''}`}>
        <Sticky top={!isServer && window.innerWidth >= SCREEN_M ? 15 : 73}>
          {this.renderZoomButtons()}
        </Sticky>
      </div>
    );
  }
}

MapControlsButtons.propTypes = {
  className: PropTypes.string,
  setMapSettings: PropTypes.func,
  viewport: PropTypes.object,
  minZoom: PropTypes.number,
  maxZoom: PropTypes.number,
};

export default connect()(MapControlsButtons);
