import { connect } from 'react-redux';
import reducerRegistry from 'redux/registry';

import * as actions from './actions';
import reducers, { initialState } from './reducers';
import Component from './component';

import sources from './config';

const mapStateToProps = ({ modalSources }) => ({
  open: modalSources && modalSources.open,
  data: (modalSources && sources[modalSources.source]) || {},
});

reducerRegistry.registerModule('modalSources', {
  actions,
  reducers,
  initialState,
});

export default connect(mapStateToProps, actions)(Component);
