/*
 * Copyright 2018 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.samples.apps.sunflower.adapters

import android.support.v7.util.DiffUtil
import com.google.samples.apps.sunflower.data.PlantAndGardenPlantings

class GardenPlantDiffCallback : DiffUtil.ItemCallback<PlantAndGardenPlantings>() {

    override fun areItemsTheSame(
            oldItem: PlantAndGardenPlantings?,
            newItem: PlantAndGardenPlantings?
    ): Boolean {
        return oldItem?.plant?.plantId == newItem?.plant?.plantId
    }

    override fun areContentsTheSame(
            oldItem: PlantAndGardenPlantings?,
            newItem: PlantAndGardenPlantings?
    ): Boolean {
        return oldItem?.plant == newItem?.plant
    }
}