# copied from django-compressor since I like their style
import os
import django

DEBUG = True
TESTING = True

TEST_DIR = os.path.join(os.path.abspath(os.path.dirname(__file__)), "tests")

CACHES = {
    "default": {
        "BACKEND": "django.core.cache.backends.locmem.LocMemCache",
        "LOCATION": "unique-snowflake",
    }
}

DATABASES = {
    "default": {
        "ENGINE": "django.db.backends.sqlite3",
        "NAME": ":memory:",
    }
}

INSTALLED_APPS = [
    "django.contrib.admin",
    "django.contrib.auth",
    "django.contrib.contenttypes",
    "django.contrib.sessions",
    "django.contrib.messages",
    "django.contrib.staticfiles",
    "wooey",
]

STATICFILES_FINDERS = [
    "django.contrib.staticfiles.finders.FileSystemFinder",
    "django.contrib.staticfiles.finders.AppDirectoriesFinder",
]

STATIC_URL = "/static/"

STATIC_ROOT = os.path.join(TEST_DIR, "static")

TEMPLATES = [
    {
        "BACKEND": "django.template.backends.django.DjangoTemplates",
        "DIRS": [],
        "APP_DIRS": True,
        "OPTIONS": {
            "context_processors": [
                "django.template.context_processors.debug",
                "django.template.context_processors.request",
                "django.contrib.auth.context_processors.auth",
                "django.contrib.messages.context_processors.messages",
            ],
        },
    },
]

MEDIA_URL = "/files/"
MEDIA_ROOT = os.path.join(TEST_DIR, "media")

if django.VERSION[:2] < (1, 6):
    TEST_RUNNER = "discover_runner.DiscoverRunner"

SECRET_KEY = "iufoj=mibkpdz*%bob952x(%49rqgv8gg45k36kjcg76&-y5=!"

PASSWORD_HASHERS = ("django.contrib.auth.hashers.UnsaltedMD5PasswordHasher",)

MIDDLEWARE = [
    "django.middleware.security.SecurityMiddleware",
    "django.contrib.sessions.middleware.SessionMiddleware",
    "django.middleware.common.CommonMiddleware",
    "django.middleware.csrf.CsrfViewMiddleware",
    "django.contrib.auth.middleware.AuthenticationMiddleware",
    "django.contrib.messages.middleware.MessageMiddleware",
    "django.middleware.clickjacking.XFrameOptionsMiddleware",
]

ROOT_URLCONF = "wooey.test_urls"

WOOEY_EPHEMERAL_FILES = True
WOOEY_CELERY = False
WOOEY_FILE_DIR = "wooey_test"

if os.environ.get("WOOEY_TEST_S3"):
    STATICFILES_STORAGE = (
        DEFAULT_FILE_STORAGE
    ) = "wooey.wooeystorage.CachedS3BotoStorage"
    from boto.s3.connection import VHostCallingFormat

    INSTALLED_APPS += ("storages",)

    AWS_CALLING_FORMAT = VHostCallingFormat

    AWS_ACCESS_KEY_ID = os.environ.get("AWS_ACCESS_KEY_ID", "")
    AWS_SECRET_ACCESS_KEY = os.environ.get("AWS_SECRET_ACCESS_KEY", "")
    AWS_STORAGE_BUCKET_NAME = os.environ.get("AWS_STORAGE_BUCKET_NAME", "")
    AWS_AUTO_CREATE_BUCKET = True
    AWS_QUERYSTRING_AUTH = False
    AWS_S3_FILE_OVERWRITE = False
    AWS_PRELOAD_METADATA = True
    AWS_S3_CUSTOM_DOMAIN = os.environ.get("AWS_S3_CUSTOM_DOMAIN", "")

    GZIP_CONTENT_TYPES = (
        "text/css",
        "application/javascript",
        "application/x-javascript",
        "text/javascript",
    )

    AWS_EXPIREY = 60 * 60 * 7
    AWS_HEADERS = {
        "Cache-Control": "max-age=%d, s-maxage=%d, must-revalidate"
        % (AWS_EXPIREY, AWS_EXPIREY)
    }

    STATIC_URL = "http://%s.s3.amazonaws.com/" % AWS_STORAGE_BUCKET_NAME
    MEDIA_URL = "/user-uploads/"

else:
    STATICFILES_STORAGE = DEFAULT_FILE_STORAGE = "wooey.wooeystorage.FakeRemoteStorage"
