export var udhr = [
  {
    code: '007',
    name: 'Sãotomense',
    bcp47: 'cri',
    ohchr: '1128',
    iso6393: 'cri',
    direction: 'ltr',
    stage: 4,
    latitude: 6.68,
    longitude: 0.33
  },
  {
    code: '008',
    name: 'Crioulo, Upper Guinea (008)',
    bcp47: 'pov',
    ohchr: null,
    iso6393: 'pov',
    direction: 'ltr',
    stage: 4,
    latitude: 13.23,
    longitude: -15.33
  },
  {
    code: '009',
    name: 'Mbundu (009)',
    bcp47: 'kmb',
    ohchr: null,
    iso6393: 'kmb',
    direction: 'ltr',
    stage: 4,
    latitude: -8.98,
    longitude: 14.89
  },
  {
    code: '010',
    name: 'Tetun Dili',
    bcp47: 'tdt',
    ohchr: null,
    iso6393: 'tdt',
    direction: 'ltr',
    stage: 4,
    latitude: 125.5,
    longitude: -8.5
  },
  {
    code: '011',
    name: 'Umbundu (011)',
    bcp47: 'umb',
    ohchr: null,
    iso6393: 'umb',
    direction: 'ltr',
    stage: 4,
    latitude: -12.48,
    longitude: 14.41
  },
  {
    code: '012',
    name: '(Bizisa)',
    bcp47: 'und',
    ohchr: 'bz1',
    iso6393: 'und',
    direction: 'ltr',
    stage: 4,
    latitude: -75,
    longitude: 30
  },
  {
    code: '013',
    name: '(Mijisa)',
    bcp47: 'und',
    ohchr: 'bz2',
    iso6393: 'und',
    direction: 'ltr',
    stage: 4,
    latitude: -75,
    longitude: 30
  },
  {
    code: '014',
    name: '(Maiunan)',
    bcp47: 'und',
    ohchr: 'ma1',
    iso6393: 'und',
    direction: 'ltr',
    stage: 4,
    latitude: -75,
    longitude: 30
  },
  {
    code: '016',
    name: '(Minjiang, spoken)',
    bcp47: 'und',
    ohchr: 'mi1_spok',
    iso6393: 'und',
    direction: 'ltr',
    stage: 4,
    latitude: -75,
    longitude: 30
  },
  {
    code: '017',
    name: '(Minjiang, written)',
    bcp47: 'und',
    ohchr: 'mi1_written',
    iso6393: 'und',
    direction: 'ltr',
    stage: 4,
    latitude: -75,
    longitude: 30
  },
  {
    code: '020',
    name: 'Drung',
    bcp47: 'duu',
    ohchr: 'ty1',
    iso6393: 'duu',
    direction: 'ltr',
    stage: 4,
    latitude: 28,
    longitude: 98
  },
  {
    code: '026',
    name: '(Yeonbyeon)',
    bcp47: 'und',
    ohchr: 'ye1',
    iso6393: 'und',
    direction: 'ltr',
    stage: 4,
    latitude: -75,
    longitude: 30
  },
  {
    code: 'aar',
    name: 'Afar',
    bcp47: 'aa',
    ohchr: 'aar',
    iso6393: 'aar',
    direction: 'ltr',
    stage: 4,
    latitude: 12.23,
    longitude: 41.81
  },
  {
    code: 'abk',
    name: 'Abkhaz',
    bcp47: 'ab',
    ohchr: 'abk',
    iso6393: 'abk',
    direction: 'ltr',
    stage: 4,
    latitude: 42.23,
    longitude: 41.3
  },
  {
    code: 'ace',
    name: 'Aceh',
    bcp47: 'ace',
    ohchr: 'atj',
    iso6393: 'ace',
    direction: 'ltr',
    stage: 4,
    latitude: 3.91,
    longitude: 96.6
  },
  {
    code: 'acu',
    name: 'Achuar-Shiwiar',
    bcp47: 'acu',
    ohchr: 'acu',
    iso6393: 'acu',
    direction: 'ltr',
    stage: 4,
    latitude: -2.83,
    longitude: -77.26
  },
  {
    code: 'acu_1',
    name: 'Achuar-Shiwiar (1)',
    bcp47: 'acu',
    ohchr: 'jiv',
    iso6393: 'acu',
    direction: 'ltr',
    stage: 4,
    latitude: -2.83,
    longitude: -77.26
  },
  {
    code: 'ada',
    name: 'Dangme',
    bcp47: 'ada',
    ohchr: 'gac1',
    iso6393: 'ada',
    direction: 'ltr',
    stage: 4,
    latitude: 5.94,
    longitude: 0.13
  },
  {
    code: 'ady',
    name: 'Adyghe',
    bcp47: 'ady',
    ohchr: 'ady',
    iso6393: 'ady',
    direction: 'ltr',
    stage: 4,
    latitude: 44,
    longitude: 39.33
  },
  {
    code: 'afr',
    name: 'Afrikaans',
    bcp47: 'af',
    ohchr: 'afk',
    iso6393: 'afr',
    direction: 'ltr',
    stage: 4,
    latitude: -22,
    longitude: 30
  },
  {
    code: 'agr',
    name: 'Aguaruna',
    bcp47: 'agr',
    ohchr: 'agr',
    iso6393: 'agr',
    direction: 'ltr',
    stage: 4,
    latitude: -5.3,
    longitude: -77.92
  },
  {
    code: 'aii',
    name: 'Assyrian Neo-Aramaic',
    bcp47: 'aii',
    ohchr: 'aii',
    iso6393: 'aii',
    direction: 'rtl',
    stage: 4,
    latitude: 36.75,
    longitude: 43
  },
  {
    code: 'ajg',
    name: 'Aja',
    bcp47: 'ajg',
    ohchr: 'ajg',
    iso6393: 'ajg',
    direction: 'ltr',
    stage: 4,
    latitude: 7.07,
    longitude: 1.65
  },
  {
    code: 'aka_akuapem',
    name: 'Twi (Akuapem)',
    bcp47: 'ak-akuapem',
    ohchr: 'tws1',
    iso6393: 'twi',
    direction: 'ltr',
    stage: 4,
    latitude: 6.35,
    longitude: -1.33
  },
  {
    code: 'aka_asante',
    name: 'Twi (Asante)',
    bcp47: 'ak-asante',
    ohchr: 'ass',
    iso6393: 'twi',
    direction: 'ltr',
    stage: 4,
    latitude: 6.35,
    longitude: -1.33
  },
  {
    code: 'aka_fante',
    name: 'Fante',
    bcp47: 'ak',
    ohchr: 'tws3',
    iso6393: 'fat',
    direction: 'ltr',
    stage: 4,
    latitude: 6.35,
    longitude: -1.33
  },
  {
    code: 'als',
    name: 'Albanian, Tosk',
    bcp47: 'als',
    ohchr: 'aln',
    iso6393: 'als',
    direction: 'ltr',
    stage: 4,
    latitude: 41,
    longitude: 20
  },
  {
    code: 'alt',
    name: 'Altai, Southern',
    bcp47: 'alt',
    ohchr: 'alt',
    iso6393: 'alt',
    direction: 'ltr',
    stage: 4,
    latitude: 50.13,
    longitude: 86.87
  },
  {
    code: 'amc',
    name: 'Amahuaca',
    bcp47: 'amc',
    ohchr: 'amc',
    iso6393: 'amc',
    direction: 'ltr',
    stage: 4,
    latitude: -10.2,
    longitude: -72.32
  },
  {
    code: 'ame',
    name: 'Yaneshaʼ',
    bcp47: 'ame',
    ohchr: 'ame',
    iso6393: 'ame',
    direction: 'ltr',
    stage: 4,
    latitude: -10.55,
    longitude: -75.31
  },
  {
    code: 'amh',
    name: 'Amharic',
    bcp47: 'am',
    ohchr: 'amh',
    iso6393: 'amh',
    direction: 'ltr',
    stage: 4,
    latitude: 11.71,
    longitude: 39.54
  },
  {
    code: 'ami',
    name: 'Amis',
    bcp47: 'ami',
    ohchr: 'ami',
    iso6393: 'ami',
    direction: 'ltr',
    stage: 4,
    latitude: 23.5,
    longitude: 121.5
  },
  {
    code: 'amr',
    name: 'Amarakaeri',
    bcp47: 'amr',
    ohchr: 'amr',
    iso6393: 'amr',
    direction: 'ltr',
    stage: 4,
    latitude: -12.49,
    longitude: -70.55
  },
  {
    code: 'arb',
    name: 'Arabic, Standard',
    bcp47: 'ar',
    ohchr: 'arz',
    iso6393: 'arb',
    direction: 'rtl',
    stage: 4,
    latitude: 27.96,
    longitude: 43.85
  },
  {
    code: 'arl',
    name: 'Arabela',
    bcp47: 'arl',
    ohchr: 'arl',
    iso6393: 'arl',
    direction: 'ltr',
    stage: 4,
    latitude: -1.96,
    longitude: -75.06
  },
  {
    code: 'arn',
    name: 'Mapudungun',
    bcp47: 'arn',
    ohchr: 'aru',
    iso6393: 'arn',
    direction: 'ltr',
    stage: 4,
    latitude: -38.74,
    longitude: -71.28
  },
  {
    code: 'ast',
    name: 'Asturian',
    bcp47: 'ast',
    ohchr: 'aub',
    iso6393: 'ast',
    direction: 'ltr',
    stage: 4,
    latitude: 42.42,
    longitude: -6.02
  },
  {
    code: 'auc',
    name: 'Waorani',
    bcp47: 'auc',
    ohchr: '1127',
    iso6393: 'auc',
    direction: 'ltr',
    stage: 4,
    latitude: -1.12,
    longitude: -76.68
  },
  {
    code: 'auv',
    name: 'Occitan (Auvergnat)',
    bcp47: 'oc',
    ohchr: 'auv1',
    iso6393: 'oci',
    direction: 'ltr',
    stage: 4,
    latitude: 44.14,
    longitude: 6.83
  },
  {
    code: 'ayr',
    name: 'Aymara, Central',
    bcp47: 'ay',
    ohchr: 'aym',
    iso6393: 'ayr',
    direction: 'ltr',
    stage: 4,
    latitude: -17,
    longitude: -68.5
  },
  {
    code: 'azj_cyrl',
    name: 'Azerbaijani, North (Cyrillic)',
    bcp47: 'az-Cyrl',
    ohchr: 'azb1',
    iso6393: 'azj',
    direction: 'ltr',
    stage: 4,
    latitude: 40.98,
    longitude: 46.47
  },
  {
    code: 'azj_latn',
    name: 'Azerbaijani, North (Latin)',
    bcp47: 'az-Latn',
    ohchr: 'azb',
    iso6393: 'azj',
    direction: 'ltr',
    stage: 4,
    latitude: 40.98,
    longitude: 46.47
  },
  {
    code: 'bam',
    name: 'Bamanankan',
    bcp47: 'bm',
    ohchr: 'bra',
    iso6393: 'bam',
    direction: 'ltr',
    stage: 4,
    latitude: 12.04,
    longitude: -9.99
  },
  {
    code: 'ban',
    name: 'Bali',
    bcp47: 'ban',
    ohchr: 'bzc',
    iso6393: 'ban',
    direction: 'ltr',
    stage: 4,
    latitude: -8.36,
    longitude: 115.08
  },
  {
    code: 'bax',
    name: 'Bamun',
    bcp47: 'bax',
    ohchr: 'bax',
    iso6393: 'bax',
    direction: 'ltr',
    stage: 4,
    latitude: 9.63,
    longitude: 3
  },
  {
    code: 'bba',
    name: 'Baatonum',
    bcp47: 'bba',
    ohchr: 'bba',
    iso6393: 'bba',
    direction: 'ltr',
    stage: 4,
    latitude: 9.63,
    longitude: 3
  },
  {
    code: 'bci',
    name: 'Baoulé',
    bcp47: 'bci',
    ohchr: 'bci',
    iso6393: 'bci',
    direction: 'ltr',
    stage: 4,
    latitude: 5.43,
    longitude: -4.77
  },
  {
    code: 'bcl',
    name: 'Bicolano, Central',
    bcp47: 'bik',
    ohchr: 'bkl',
    iso6393: 'bcl',
    direction: 'ltr',
    stage: 4,
    latitude: 13.76,
    longitude: 123.4
  },
  {
    code: 'bel',
    name: 'Belarusan',
    bcp47: 'be',
    ohchr: 'ruw',
    iso6393: 'bel',
    direction: 'ltr',
    stage: 4,
    latitude: 53.23,
    longitude: 25.6
  },
  {
    code: 'bem',
    name: 'Bemba',
    bcp47: 'bem',
    ohchr: 'bem',
    iso6393: 'bem',
    direction: 'ltr',
    stage: 4,
    latitude: -10.61,
    longitude: 29.3
  },
  {
    code: 'ben',
    name: 'Bengali',
    bcp47: 'bn',
    ohchr: 'bng',
    iso6393: 'ben',
    direction: 'ltr',
    stage: 4,
    latitude: 24,
    longitude: 90
  },
  {
    code: 'bfa',
    name: 'Bari',
    bcp47: 'bfa',
    ohchr: 'bfa',
    iso6393: 'bfa',
    direction: 'ltr',
    stage: 4,
    latitude: 4.2,
    longitude: 31.07
  },
  {
    code: 'bho',
    name: 'Bhojpuri',
    bcp47: 'bho',
    ohchr: 'bhj',
    iso6393: 'bho',
    direction: 'ltr',
    stage: 4,
    latitude: 26.46,
    longitude: 84.82
  },
  {
    code: 'bin',
    name: 'Edo',
    bcp47: 'bin',
    ohchr: 'edo',
    iso6393: 'bin',
    direction: 'ltr',
    stage: 4,
    latitude: 6.41,
    longitude: 5.7
  },
  {
    code: 'bis',
    name: 'Bislama',
    bcp47: 'bi',
    ohchr: 'bcy',
    iso6393: 'bis',
    direction: 'ltr',
    stage: 4,
    latitude: -19.99,
    longitude: 167.37
  },
  {
    code: 'blt',
    name: 'Tai Dam',
    bcp47: 'blt',
    ohchr: null,
    iso6393: 'blt',
    direction: 'ltr',
    stage: 4,
    latitude: 21.47,
    longitude: 102.7
  },
  {
    code: 'blu',
    name: 'Hmong Njua',
    bcp47: 'hnj',
    ohchr: 'blu',
    iso6393: 'hnj',
    direction: 'ltr',
    stage: 4,
    latitude: 22.56,
    longitude: 101.95
  },
  {
    code: 'boa',
    name: 'Bora',
    bcp47: 'boa',
    ohchr: 'boa',
    iso6393: 'boa',
    direction: 'ltr',
    stage: 4,
    latitude: -2.91,
    longitude: -68.91
  },
  {
    code: 'bod',
    name: 'Tibetan, Central',
    bcp47: 'bo',
    ohchr: 'tic',
    iso6393: 'bod',
    direction: 'ltr',
    stage: 4,
    latitude: 28.37,
    longitude: 90.19
  },
  {
    code: 'bos_cyrl',
    name: 'Bosnian (Cyrillic)',
    bcp47: 'bs-Cyrl',
    ohchr: 'src4',
    iso6393: 'bos',
    direction: 'ltr',
    stage: 4,
    latitude: 42.93,
    longitude: 17.67
  },
  {
    code: 'bos_latn',
    name: 'Bosnian (Latin)',
    bcp47: 'bs-Latn',
    ohchr: 'src1',
    iso6393: 'bos',
    direction: 'ltr',
    stage: 4,
    latitude: 42.93,
    longitude: 17.67
  },
  {
    code: 'bre',
    name: 'Breton',
    bcp47: 'br',
    ohchr: 'brt',
    iso6393: 'bre',
    direction: 'ltr',
    stage: 4,
    latitude: 48.25,
    longitude: -3.79
  },
  {
    code: 'btb',
    name: 'Bulu',
    bcp47: 'bum',
    ohchr: 'btb',
    iso6393: 'bum',
    direction: 'ltr',
    stage: 4,
    latitude: 3.16,
    longitude: 11.64
  },
  {
    code: 'buc',
    name: 'Bushi',
    bcp47: 'buc',
    ohchr: 'buc',
    iso6393: 'buc',
    direction: 'ltr',
    stage: 4,
    latitude: -12.97,
    longitude: 45.14
  },
  {
    code: 'bug',
    name: 'Bugis',
    bcp47: 'bug',
    ohchr: 'bpr',
    iso6393: 'bug',
    direction: 'ltr',
    stage: 4,
    latitude: -0.25,
    longitude: 119.25
  },
  {
    code: 'bul',
    name: 'Bulgarian',
    bcp47: 'bg',
    ohchr: 'blg',
    iso6393: 'bul',
    direction: 'ltr',
    stage: 4,
    latitude: 43.36,
    longitude: 25.05
  },
  {
    code: 'cab',
    name: 'Garifuna',
    bcp47: 'cab',
    ohchr: 'cab',
    iso6393: 'cab',
    direction: 'ltr',
    stage: 4,
    latitude: 15.35,
    longitude: -86.91
  },
  {
    code: 'cak',
    name: 'Kaqchikel, Central',
    bcp47: 'cak',
    ohchr: 'cak1',
    iso6393: 'cak',
    direction: 'ltr',
    stage: 4,
    latitude: 14.47,
    longitude: -90.99
  },
  {
    code: 'cat',
    name: 'Catalan-Valencian-Balear',
    bcp47: 'ca',
    ohchr: 'cln',
    iso6393: 'cat',
    direction: 'ltr',
    stage: 4,
    latitude: 41.9,
    longitude: 3.39
  },
  {
    code: 'cbi',
    name: 'Chachi',
    bcp47: 'cbi',
    ohchr: '1122',
    iso6393: 'cbi',
    direction: 'ltr',
    stage: 4,
    latitude: 0.71,
    longitude: -79.05
  },
  {
    code: 'cbr',
    name: 'Cashibo-Cacataibo',
    bcp47: 'cbr',
    ohchr: 'cbr',
    iso6393: 'cbr',
    direction: 'ltr',
    stage: 4,
    latitude: -8.7,
    longitude: -75.42
  },
  {
    code: 'cbs',
    name: 'Cashinahua',
    bcp47: 'cbs',
    ohchr: 'cbs',
    iso6393: 'cbs',
    direction: 'ltr',
    stage: 4,
    latitude: -9.72,
    longitude: -71.17
  },
  {
    code: 'cbt',
    name: 'Chayahuita',
    bcp47: 'cbt',
    ohchr: 'cbt',
    iso6393: 'cbt',
    direction: 'ltr',
    stage: 4,
    latitude: -5.64,
    longitude: -76.83
  },
  {
    code: 'cbu',
    name: 'Candoshi-Shapra',
    bcp47: 'cbu',
    ohchr: 'cbu',
    iso6393: 'cbu',
    direction: 'ltr',
    stage: 4,
    latitude: -4.24,
    longitude: -76.93
  },
  {
    code: 'ccp',
    name: 'Chakma',
    bcp47: 'ccp',
    ohchr: null,
    iso6393: 'ccp',
    direction: 'ltr',
    stage: 4,
    latitude: 23,
    longitude: 92
  },
  {
    code: 'ccx',
    name: 'Zhuang, Yongbei',
    bcp47: 'za',
    ohchr: 'ccx',
    iso6393: 'zyb',
    direction: 'ltr',
    stage: 4,
    latitude: 23.68,
    longitude: 107.18
  },
  {
    code: 'ceb',
    name: 'Cebuano',
    bcp47: 'ceb',
    ohchr: 'ceb',
    iso6393: 'ceb',
    direction: 'ltr',
    stage: 4,
    latitude: 8.39,
    longitude: 124.37
  },
  {
    code: 'ces',
    name: 'Czech',
    bcp47: 'cs',
    ohchr: 'czc',
    iso6393: 'ces',
    direction: 'ltr',
    stage: 4,
    latitude: 49.87,
    longitude: 15.1
  },
  {
    code: 'cha',
    name: 'Chamorro',
    bcp47: 'ch',
    ohchr: 'cjd',
    iso6393: 'cha',
    direction: 'ltr',
    stage: 4,
    latitude: 14.33,
    longitude: 145.28
  },
  {
    code: 'chj',
    name: 'Chinantec, Ojitlán',
    bcp47: 'chj',
    ohchr: 'chj',
    iso6393: 'chj',
    direction: 'ltr',
    stage: 4,
    latitude: 18.07,
    longitude: -96.34
  },
  {
    code: 'chk',
    name: 'Chuukese',
    bcp47: 'chk',
    ohchr: 'tru1',
    iso6393: 'chk',
    direction: 'ltr',
    stage: 4,
    latitude: 7.34,
    longitude: 151.6
  },
  {
    code: 'chr_cased',
    name: 'Cherokee (cased)',
    bcp47: 'chr',
    ohchr: null,
    iso6393: 'chr',
    direction: 'ltr',
    stage: 4,
    latitude: 35.47,
    longitude: -83.16
  },
  {
    code: 'chr_uppercase',
    name: 'Cherokee (uppercase)',
    bcp47: 'chr',
    ohchr: null,
    iso6393: 'chr',
    direction: 'ltr',
    stage: 4,
    latitude: 35.47,
    longitude: -83.16
  },
  {
    code: 'cic',
    name: 'Chickasaw',
    bcp47: 'cic',
    ohchr: 'cic',
    iso6393: 'cic',
    direction: 'ltr',
    stage: 4,
    latitude: 33.95,
    longitude: -97.13
  },
  {
    code: 'cjk',
    name: 'Chokwe',
    bcp47: 'cjk',
    ohchr: 'cjk',
    iso6393: 'cjk',
    direction: 'ltr',
    stage: 4,
    latitude: -9.66,
    longitude: 21.4
  },
  {
    code: 'cjk_AO',
    name: 'Chokwe (Angola)',
    bcp47: 'cjk',
    ohchr: 'cjk',
    iso6393: 'cjk',
    direction: 'ltr',
    stage: 4,
    latitude: -9.66,
    longitude: 21.4
  },
  {
    code: 'cjs',
    name: 'Shor',
    bcp47: 'cjs',
    ohchr: 'cjs',
    iso6393: 'cjs',
    direction: 'ltr',
    stage: 4,
    latitude: 52.33,
    longitude: 88.43
  },
  {
    code: 'cjy',
    name: 'Chinese, Jinyu',
    bcp47: 'cjy',
    ohchr: 'cjy',
    iso6393: 'cjy',
    direction: 'ltr',
    stage: 4,
    latitude: 38,
    longitude: 111
  },
  {
    code: 'ckb',
    name: 'Kurdish, Central',
    bcp47: 'ckb-Latn',
    ohchr: 'kdb1',
    iso6393: 'ckb',
    direction: 'ltr',
    stage: 4,
    latitude: 35.65,
    longitude: 45.81
  },
  {
    code: 'cmn_hans',
    name: 'Chinese, Mandarin (Simplified)',
    bcp47: 'zh-Hans',
    ohchr: 'chn',
    iso6393: 'cmn',
    direction: 'ltr',
    stage: 4,
    latitude: 40.02,
    longitude: 116.23
  },
  {
    code: 'cmn_hant',
    name: 'Chinese, Mandarin (Traditional)',
    bcp47: 'zh-Hant',
    ohchr: null,
    iso6393: 'cmn',
    direction: 'ltr',
    stage: 4,
    latitude: 40.02,
    longitude: 116.23
  },
  {
    code: 'cnh',
    name: 'Chin, Haka',
    bcp47: 'cnh',
    ohchr: 'hak',
    iso6393: 'cnh',
    direction: 'ltr',
    stage: 4,
    latitude: 22.87,
    longitude: 92.82
  },
  {
    code: 'cni',
    name: 'Asháninka',
    bcp47: 'cni',
    ohchr: 'cni',
    iso6393: 'cni',
    direction: 'ltr',
    stage: 4,
    latitude: -11.93,
    longitude: -73.91
  },
  {
    code: 'cof',
    name: 'Colorado',
    bcp47: 'cof',
    ohchr: 'cof',
    iso6393: 'cof',
    direction: 'ltr',
    stage: 4,
    latitude: -0.21,
    longitude: -79.23
  },
  {
    code: 'cos',
    name: 'Corsican',
    bcp47: 'co',
    ohchr: 'coi',
    iso6393: 'cos',
    direction: 'ltr',
    stage: 4,
    latitude: 41.7,
    longitude: 9.26
  },
  {
    code: 'cot',
    name: 'Caquinte',
    bcp47: 'cot',
    ohchr: 'cot',
    iso6393: 'cot',
    direction: 'ltr',
    stage: 4,
    latitude: -11.48,
    longitude: -73.45
  },
  {
    code: 'cpu',
    name: 'Ashéninka, Pichis',
    bcp47: 'cpu',
    ohchr: 'cpu',
    iso6393: 'cpu',
    direction: 'ltr',
    stage: 4,
    latitude: -10.47,
    longitude: -74.6
  },
  {
    code: 'crh',
    name: 'Crimean Tatar',
    bcp47: 'crh',
    ohchr: 'crh',
    iso6393: 'crh',
    direction: 'ltr',
    stage: 4,
    latitude: 45,
    longitude: 34.08
  },
  {
    code: 'crs',
    name: 'Seselwa Creole French',
    bcp47: 'crs',
    ohchr: 'crs',
    iso6393: 'crs',
    direction: 'ltr',
    stage: 4,
    latitude: -4.62,
    longitude: 55.45
  },
  {
    code: 'csa',
    name: 'Chinantec, Chiltepec',
    bcp47: 'csa',
    ohchr: 'csa',
    iso6393: 'csa',
    direction: 'ltr',
    stage: 4,
    latitude: 18.06,
    longitude: -96.22
  },
  {
    code: 'csw',
    name: 'Cree, Swampy',
    bcp47: 'csw',
    ohchr: 'crm',
    iso6393: 'csw',
    direction: 'ltr',
    stage: 4,
    latitude: 56,
    longitude: -95
  },
  {
    code: 'ctd',
    name: 'Chin, Tedim',
    bcp47: 'ctd',
    ohchr: 'tid',
    iso6393: 'ctd',
    direction: 'ltr',
    stage: 4,
    latitude: 23.61,
    longitude: 93.52
  },
  {
    code: 'cym',
    name: 'Welsh',
    bcp47: 'cy',
    ohchr: 'wls',
    iso6393: 'cym',
    direction: 'ltr',
    stage: 4,
    latitude: 52,
    longitude: -4
  },
  {
    code: 'dag',
    name: 'Dagbani',
    bcp47: 'dag',
    ohchr: 'dag',
    iso6393: 'dag',
    direction: 'ltr',
    stage: 4,
    latitude: 9.65,
    longitude: -0.43
  },
  {
    code: 'dan',
    name: 'Danish',
    bcp47: 'da',
    ohchr: 'dns',
    iso6393: 'dan',
    direction: 'ltr',
    stage: 4,
    latitude: 54.87,
    longitude: 9.36
  },
  {
    code: 'ddn',
    name: 'Dendi',
    bcp47: 'ddn',
    ohchr: 'den',
    iso6393: 'ddn',
    direction: 'ltr',
    stage: 4,
    latitude: 11.67,
    longitude: 3.49
  },
  {
    code: 'deu_1901',
    name: 'German, Standard (1901)',
    bcp47: 'de-1901',
    ohchr: 'ger',
    iso6393: 'deu',
    direction: 'ltr',
    stage: 4,
    latitude: 48.65,
    longitude: 12.47
  },
  {
    code: 'deu_1996',
    name: 'German, Standard (1996)',
    bcp47: 'de-1996',
    ohchr: null,
    iso6393: 'deu',
    direction: 'ltr',
    stage: 4,
    latitude: 48.65,
    longitude: 12.47
  },
  {
    code: 'dga',
    name: 'Dagaare, Southern',
    bcp47: 'dga',
    ohchr: 'dga',
    iso6393: 'dga',
    direction: 'ltr',
    stage: 4,
    latitude: 10.42,
    longitude: -2.52
  },
  {
    code: 'dip',
    name: 'Dinka, Northeastern',
    bcp47: 'dip',
    ohchr: 'dinka',
    iso6393: 'dip',
    direction: 'ltr',
    stage: 4,
    latitude: 9.28,
    longitude: 31.84
  },
  {
    code: 'div',
    name: 'Maldivian',
    bcp47: 'dv',
    ohchr: 'div',
    iso6393: 'div',
    direction: 'rtl',
    stage: 4,
    latitude: 3.83,
    longitude: 73.07
  },
  {
    code: 'dyo',
    name: 'Jola-Fonyi',
    bcp47: 'dyo',
    ohchr: 'dyo',
    iso6393: 'dyo',
    direction: 'ltr',
    stage: 4,
    latitude: 12.76,
    longitude: -15.74
  },
  {
    code: 'dyu',
    name: 'Jula',
    bcp47: 'dyu',
    ohchr: 'dyu',
    iso6393: 'dyu',
    direction: 'ltr',
    stage: 4,
    latitude: 10.45,
    longitude: -4.72
  },
  {
    code: 'dzo',
    name: 'Dzongkha',
    bcp47: 'dz',
    ohchr: 'dzo',
    iso6393: 'dzo',
    direction: 'ltr',
    stage: 4,
    latitude: 27.41,
    longitude: 89.58
  },
  {
    code: 'ell_monotonic',
    name: 'Greek (monotonic)',
    bcp47: 'el-monoton',
    ohchr: 'grk',
    iso6393: 'ell',
    direction: 'ltr',
    stage: 4,
    latitude: 42.32,
    longitude: 24.87
  },
  {
    code: 'ell_polytonic',
    name: 'Greek (polytonic)',
    bcp47: 'el-polyton',
    ohchr: null,
    iso6393: 'ell',
    direction: 'ltr',
    stage: 4,
    latitude: 42.32,
    longitude: 24.87
  },
  {
    code: 'emk',
    name: 'Maninkakan, Eastern',
    bcp47: 'man',
    ohchr: 'mni',
    iso6393: 'emk',
    direction: 'ltr',
    stage: 4,
    latitude: 9.33,
    longitude: -10.54
  },
  {
    code: 'eml',
    name: 'Romagnolo',
    bcp47: 'rgn',
    ohchr: 'eml',
    iso6393: 'rgn',
    direction: 'ltr',
    stage: 4,
    latitude: 44.23,
    longitude: 11.72
  },
  {
    code: 'eng',
    name: 'English',
    bcp47: 'en',
    ohchr: 'eng',
    iso6393: 'eng',
    direction: 'ltr',
    stage: 5,
    latitude: 53,
    longitude: -1
  },
  {
    code: 'epo',
    name: 'Esperanto',
    bcp47: 'eo',
    ohchr: '1115',
    iso6393: 'epo',
    direction: 'ltr',
    stage: 4,
    latitude: 49.33,
    longitude: 2.81
  },
  {
    code: 'ese',
    name: 'Ese Ejja',
    bcp47: 'ese',
    ohchr: 'ese',
    iso6393: 'ese',
    direction: 'ltr',
    stage: 4,
    latitude: -11,
    longitude: -66
  },
  {
    code: 'est',
    name: 'Estonian',
    bcp47: 'et',
    ohchr: 'est',
    iso6393: 'ekk',
    direction: 'ltr',
    stage: 4,
    latitude: 58.55,
    longitude: 25.82
  },
  {
    code: 'eus',
    name: 'Basque',
    bcp47: 'eu',
    ohchr: 'bsq',
    iso6393: 'eus',
    direction: 'ltr',
    stage: 4,
    latitude: 43.28,
    longitude: -1.32
  },
  {
    code: 'eve',
    name: 'Even',
    bcp47: 'eve',
    ohchr: 'eve',
    iso6393: 'eve',
    direction: 'ltr',
    stage: 4,
    latitude: 70.67,
    longitude: 130.91
  },
  {
    code: 'evn',
    name: 'Evenki',
    bcp47: 'evn',
    ohchr: 'evn',
    iso6393: 'evn',
    direction: 'ltr',
    stage: 4,
    latitude: 53.85,
    longitude: 108.63
  },
  {
    code: 'ewe',
    name: 'Éwé',
    bcp47: 'ee',
    ohchr: 'ewe',
    iso6393: 'ewe',
    direction: 'ltr',
    stage: 4,
    latitude: 6.46,
    longitude: 0.81
  },
  {
    code: 'fao',
    name: 'Faroese',
    bcp47: 'fo',
    ohchr: 'fae',
    iso6393: 'fao',
    direction: 'ltr',
    stage: 4,
    latitude: 62.07,
    longitude: -6.88
  },
  {
    code: 'fij',
    name: 'Fijian',
    bcp47: 'fj',
    ohchr: 'fji',
    iso6393: 'fij',
    direction: 'ltr',
    stage: 4,
    latitude: -18,
    longitude: 178.33
  },
  {
    code: 'fin',
    name: 'Finnish',
    bcp47: 'fi',
    ohchr: 'fin',
    iso6393: 'fin',
    direction: 'ltr',
    stage: 4,
    latitude: 64.76,
    longitude: 25.56
  },
  {
    code: 'fkv',
    name: 'Finnish, Kven',
    bcp47: 'fkv',
    ohchr: 'fkv',
    iso6393: 'fkv',
    direction: 'ltr',
    stage: 4,
    latitude: 69.7,
    longitude: 21.21
  },
  {
    code: 'flm',
    name: 'Chin, Falam',
    bcp47: 'cfm',
    ohchr: 'fal',
    iso6393: 'cfm',
    direction: 'ltr',
    stage: 4,
    latitude: 23.79,
    longitude: 92.33
  },
  {
    code: 'fon',
    name: 'Fon',
    bcp47: 'fon',
    ohchr: 'foa',
    iso6393: 'fon',
    direction: 'ltr',
    stage: 4,
    latitude: 7.15,
    longitude: 1.66
  },
  {
    code: 'fra',
    name: 'French',
    bcp47: 'fr',
    ohchr: 'frn',
    iso6393: 'fra',
    direction: 'ltr',
    stage: 5,
    latitude: 48,
    longitude: 2
  },
  {
    code: 'fri',
    name: 'Frisian, Western',
    bcp47: 'fy',
    ohchr: 'fri',
    iso6393: 'fry',
    direction: 'ltr',
    stage: 4,
    latitude: 53.14,
    longitude: 5.86
  },
  {
    code: 'fuf',
    name: 'Pular',
    bcp47: 'fuf',
    ohchr: 'fuf',
    iso6393: 'fuf',
    direction: 'ltr',
    stage: 4,
    latitude: 12.18,
    longitude: -12.73
  },
  {
    code: 'fuf_adlm',
    name: 'Pular (Adlam)',
    bcp47: 'fuf-Adlm',
    ohchr: null,
    iso6393: 'fuf',
    direction: 'rtl',
    stage: 4,
    latitude: 12.18,
    longitude: -12.73
  },
  {
    code: 'fur',
    name: 'Friulian',
    bcp47: 'fur',
    ohchr: 'frl',
    iso6393: 'fur',
    direction: 'ltr',
    stage: 4,
    latitude: 46.15,
    longitude: 13.05
  },
  {
    code: 'fuv',
    name: 'Fulfulde, Nigerian',
    bcp47: 'fuv',
    ohchr: 'fum',
    iso6393: 'fuv',
    direction: 'ltr',
    stage: 4,
    latitude: 11,
    longitude: 11.12
  },
  {
    code: 'fuv2',
    name: 'Fulfulde, Nigerian (2)',
    bcp47: 'fuv',
    ohchr: 'fuv',
    iso6393: 'fuv',
    direction: 'ltr',
    stage: 4,
    latitude: 11,
    longitude: 11.12
  },
  {
    code: 'gaa',
    name: 'Ga',
    bcp47: 'gaa',
    ohchr: 'gac2',
    iso6393: 'gaa',
    direction: 'ltr',
    stage: 4,
    latitude: 5.65,
    longitude: -0.19
  },
  {
    code: 'gag',
    name: 'Gagauz',
    bcp47: 'gag',
    ohchr: 'gag',
    iso6393: 'gag',
    direction: 'ltr',
    stage: 4,
    latitude: 44.6,
    longitude: 28.03
  },
  {
    code: 'gan',
    name: 'Chinese, Gan',
    bcp47: 'gan',
    ohchr: 'gan',
    iso6393: 'gan',
    direction: 'ltr',
    stage: 4,
    latitude: 28,
    longitude: 105
  },
  {
    code: 'gax',
    name: 'Oromo, Borana-Arsi-Guji',
    bcp47: 'om',
    ohchr: 'gax',
    iso6393: 'gaz',
    direction: 'ltr',
    stage: 4,
    latitude: 1.06,
    longitude: 37.88
  },
  {
    code: 'gjn',
    name: 'Gonja',
    bcp47: 'gjn',
    ohchr: 'dum',
    iso6393: 'gjn',
    direction: 'ltr',
    stage: 4,
    latitude: 8.49,
    longitude: -0.73
  },
  {
    code: 'gkp',
    name: 'Kpelle, Guinea',
    bcp47: 'gkp',
    ohchr: 'pke',
    iso6393: 'gkp',
    direction: 'ltr',
    stage: 4,
    latitude: 7.93,
    longitude: -8.99
  },
  {
    code: 'gla',
    name: 'Gaelic, Scottish',
    bcp47: 'gd',
    ohchr: 'gls',
    iso6393: 'gla',
    direction: 'ltr',
    stage: 4,
    latitude: 56.76,
    longitude: -5.24
  },
  {
    code: 'gld',
    name: 'Nanai',
    bcp47: 'gld',
    ohchr: 'gld',
    iso6393: 'gld',
    direction: 'ltr',
    stage: 4,
    latitude: 48.43,
    longitude: 134.8
  },
  {
    code: 'gle',
    name: 'Gaelic, Irish',
    bcp47: 'ga',
    ohchr: 'gli1',
    iso6393: 'gle',
    direction: 'ltr',
    stage: 4,
    latitude: 53.22,
    longitude: -7.62
  },
  {
    code: 'glg',
    name: 'Galician',
    bcp47: 'gl',
    ohchr: 'gln',
    iso6393: 'glg',
    direction: 'ltr',
    stage: 4,
    latitude: 42.24,
    longitude: -7.53
  },
  {
    code: 'glv',
    name: 'Manx',
    bcp47: 'gv',
    ohchr: null,
    iso6393: 'glv',
    direction: 'ltr',
    stage: 4,
    latitude: 54.23,
    longitude: -4.85
  },
  {
    code: 'gsw1',
    name: 'Alemannisch (Elsassisch)',
    bcp47: 'gsw',
    ohchr: 'gsw',
    iso6393: 'gsw',
    direction: 'ltr',
    stage: 4,
    latitude: 48.61,
    longitude: 7.49
  },
  {
    code: 'guc',
    name: 'Wayuu',
    bcp47: 'guc',
    ohchr: 'guc',
    iso6393: 'guc',
    direction: 'ltr',
    stage: 4,
    latitude: 10.23,
    longitude: -71.81
  },
  {
    code: 'gug',
    name: 'Guaraní, Paraguayan',
    bcp47: 'gn',
    ohchr: 'gun',
    iso6393: 'gug',
    direction: 'ltr',
    stage: 4,
    latitude: -25.61,
    longitude: -57.09
  },
  {
    code: 'guj',
    name: 'Gujarati',
    bcp47: 'gu',
    ohchr: 'gjr',
    iso6393: 'guj',
    direction: 'ltr',
    stage: 4,
    latitude: 22.69,
    longitude: 71.1
  },
  {
    code: 'guu',
    name: 'Yanomamö',
    bcp47: 'guu',
    ohchr: 'guu',
    iso6393: 'guu',
    direction: 'ltr',
    stage: 4,
    latitude: 1.68,
    longitude: -64.88
  },
  {
    code: 'gyr',
    name: 'Guarayu',
    bcp47: 'gyr',
    ohchr: 'gua',
    iso6393: 'gyr',
    direction: 'ltr',
    stage: 4,
    latitude: -15.82,
    longitude: -61.69
  },
  {
    code: 'hak',
    name: 'Chinese, Hakka',
    bcp47: 'hak',
    ohchr: 'ha1',
    iso6393: 'hak',
    direction: 'ltr',
    stage: 4,
    latitude: 25,
    longitude: 115
  },
  {
    code: 'hat_kreyol',
    name: 'Haitian Creole French (Kreyol)',
    bcp47: 'ht',
    ohchr: 'hat',
    iso6393: 'hat',
    direction: 'ltr',
    stage: 4,
    latitude: 19,
    longitude: -73.33
  },
  {
    code: 'hat_popular',
    name: 'Haitian Creole French (Popular)',
    bcp47: 'ht',
    ohchr: 'hat1',
    iso6393: 'hat',
    direction: 'ltr',
    stage: 4,
    latitude: 19,
    longitude: -73.33
  },
  {
    code: 'hau_NE',
    name: 'Hausa (Niger)',
    bcp47: 'ha-NE',
    ohchr: 'gej',
    iso6393: 'hau',
    direction: 'ltr',
    stage: 4,
    latitude: 11.15,
    longitude: 8.78
  },
  {
    code: 'hau_NG',
    name: 'Hausa (Nigeria)',
    bcp47: 'ha-NG',
    ohchr: 'gej',
    iso6393: 'hau',
    direction: 'ltr',
    stage: 4,
    latitude: 11.15,
    longitude: 8.78
  },
  {
    code: 'haw',
    name: 'Hawaiian',
    bcp47: 'haw',
    ohchr: 'hwi',
    iso6393: 'haw',
    direction: 'ltr',
    stage: 4,
    latitude: 19.63,
    longitude: -155.43
  },
  {
    code: 'hea',
    name: 'Hmong, Northern Qiandong',
    bcp47: 'hmn',
    ohchr: 'hea',
    iso6393: 'hea',
    direction: 'ltr',
    stage: 4,
    latitude: 26.63,
    longitude: 108.16
  },
  {
    code: 'heb',
    name: 'Hebrew',
    bcp47: 'he',
    ohchr: 'hbr',
    iso6393: 'heb',
    direction: 'rtl',
    stage: 4,
    latitude: 31.11,
    longitude: 35.02
  },
  {
    code: 'hil',
    name: 'Hiligaynon',
    bcp47: 'hil',
    ohchr: 'hil',
    iso6393: 'hil',
    direction: 'ltr',
    stage: 4,
    latitude: 10.4,
    longitude: 122.97
  },
  {
    code: 'hin',
    name: 'Hindi',
    bcp47: 'hi',
    ohchr: 'hnd',
    iso6393: 'hin',
    direction: 'ltr',
    stage: 4,
    latitude: 25,
    longitude: 77
  },
  {
    code: 'hlt',
    name: 'Chin, Matu',
    bcp47: 'hlt',
    ohchr: 'hlt',
    iso6393: 'hlt',
    direction: 'ltr',
    stage: 4,
    latitude: 23.31,
    longitude: 92.83
  },
  {
    code: 'hms',
    name: 'Hmong, Southern Qiandong',
    bcp47: 'hms',
    ohchr: 'hms',
    iso6393: 'hms',
    direction: 'ltr',
    stage: 4,
    latitude: 25.66,
    longitude: 108.53
  },
  {
    code: 'hna',
    name: 'Mina',
    bcp47: 'hna',
    ohchr: 'hna',
    iso6393: 'hna',
    direction: 'ltr',
    stage: 4,
    latitude: 10.38,
    longitude: 13.84
  },
  {
    code: 'hni',
    name: 'Hani',
    bcp47: 'hni',
    ohchr: 'hni',
    iso6393: 'hni',
    direction: 'ltr',
    stage: 4,
    latitude: 22.68,
    longitude: 102.85
  },
  {
    code: 'hns',
    name: 'Hindustani, Sarnami',
    bcp47: 'hns',
    ohchr: 'hns',
    iso6393: 'hns',
    direction: 'ltr',
    stage: 4,
    latitude: 7.67,
    longitude: -58.57
  },
  {
    code: 'hrv',
    name: 'Croatian',
    bcp47: 'hr',
    ohchr: 'src2',
    iso6393: 'hrv',
    direction: 'ltr',
    stage: 4,
    latitude: 45.2,
    longitude: 16.83
  },
  {
    code: 'hsb',
    name: 'Sorbian, Upper',
    bcp47: 'hsb',
    ohchr: 'wee',
    iso6393: 'hsb',
    direction: 'ltr',
    stage: 4,
    latitude: 51.24,
    longitude: 14.41
  },
  {
    code: 'hsf',
    name: 'Huastec (Sierra de Otontepec)',
    bcp47: 'hus',
    ohchr: 'hus',
    iso6393: 'hus',
    direction: 'ltr',
    stage: 4,
    latitude: 21.62,
    longitude: -98.5
  },
  {
    code: 'hun',
    name: 'Hungarian',
    bcp47: 'hu',
    ohchr: 'hng',
    iso6393: 'hun',
    direction: 'ltr',
    stage: 4,
    latitude: 46.91,
    longitude: 19.66
  },
  {
    code: 'hus',
    name: 'Huastec (Veracruz)',
    bcp47: 'hus',
    ohchr: '1118',
    iso6393: 'hus',
    direction: 'ltr',
    stage: 4,
    latitude: 21.62,
    longitude: -98.5
  },
  {
    code: 'huu',
    name: 'Huitoto, Murui',
    bcp47: 'huu',
    ohchr: 'huu',
    iso6393: 'huu',
    direction: 'ltr',
    stage: 4,
    latitude: -1.14,
    longitude: -73.83
  },
  {
    code: 'hva',
    name: 'Huastec (San Luís Potosí)',
    bcp47: 'hus',
    ohchr: 'hva',
    iso6393: 'hus',
    direction: 'ltr',
    stage: 4,
    latitude: 21.62,
    longitude: -98.5
  },
  {
    code: 'hye',
    name: 'Armenian',
    bcp47: 'hy',
    ohchr: 'arm',
    iso6393: 'hye',
    direction: 'ltr',
    stage: 4,
    latitude: 40,
    longitude: 45
  },
  {
    code: 'ibb',
    name: 'Ibibio',
    bcp47: 'ibb',
    ohchr: 'ibb',
    iso6393: 'ibb',
    direction: 'ltr',
    stage: 4,
    latitude: 5.15,
    longitude: 7.87
  },
  {
    code: 'ibo',
    name: 'Igbo',
    bcp47: 'ig',
    ohchr: 'igr',
    iso6393: 'ibo',
    direction: 'ltr',
    stage: 4,
    latitude: 4.63,
    longitude: 7.23
  },
  {
    code: 'ido',
    name: 'Ido',
    bcp47: 'io',
    ohchr: '1120',
    iso6393: 'ido',
    direction: 'ltr',
    stage: 4,
    latitude: -75,
    longitude: 20
  },
  {
    code: 'iii',
    name: 'Nuosu',
    bcp47: 'ii',
    ohchr: 'iii',
    iso6393: 'iii',
    direction: 'ltr',
    stage: 4,
    latitude: 28.19,
    longitude: 102.12
  },
  {
    code: 'ike',
    name: 'Inuktitut, Eastern Canadian',
    bcp47: 'iu',
    ohchr: 'esb',
    iso6393: 'ike',
    direction: 'ltr',
    stage: 4,
    latitude: 62.17,
    longitude: -75.61
  },
  {
    code: 'ilo',
    name: 'Ilocano',
    bcp47: 'ilo',
    ohchr: 'ilo',
    iso6393: 'ilo',
    direction: 'ltr',
    stage: 4,
    latitude: 15.94,
    longitude: 120.99
  },
  {
    code: 'ina',
    name: 'Interlingua',
    bcp47: 'ia',
    ohchr: '1119',
    iso6393: 'ina',
    direction: 'ltr',
    stage: 4,
    latitude: 48.2,
    longitude: 2.62
  },
  {
    code: 'ind',
    name: 'Indonesian',
    bcp47: 'id',
    ohchr: 'inz',
    iso6393: 'ind',
    direction: 'ltr',
    stage: 4,
    latitude: -7.33,
    longitude: 109.72
  },
  {
    code: 'isl',
    name: 'Icelandic',
    bcp47: 'is',
    ohchr: 'ice',
    iso6393: 'isl',
    direction: 'ltr',
    stage: 4,
    latitude: 63.48,
    longitude: -19.02
  },
  {
    code: 'ita',
    name: 'Italian',
    bcp47: 'it',
    ohchr: 'itn',
    iso6393: 'ita',
    direction: 'ltr',
    stage: 4,
    latitude: 43.05,
    longitude: 12.65
  },
  {
    code: 'jav',
    name: 'Javanese (Latin)',
    bcp47: 'jv',
    ohchr: 'jan',
    iso6393: 'jav',
    direction: 'ltr',
    stage: 4,
    latitude: -0.57,
    longitude: 110.89
  },
  {
    code: 'jav_java',
    name: 'Javanese (Javanese)',
    bcp47: 'jv-Java',
    ohchr: null,
    iso6393: 'jav',
    direction: 'ltr',
    stage: 4,
    latitude: -0.57,
    longitude: 110.89
  },
  {
    code: 'jiv',
    name: 'Shuar',
    bcp47: 'jiv',
    ohchr: '1125',
    iso6393: 'jiv',
    direction: 'ltr',
    stage: 4,
    latitude: -3.45,
    longitude: -78.19
  },
  {
    code: 'jpn',
    name: 'Japanese',
    bcp47: 'ja',
    ohchr: 'jpn',
    iso6393: 'jpn',
    direction: 'ltr',
    stage: 4,
    latitude: 35,
    longitude: 135
  },
  {
    code: 'kal',
    name: 'Inuktitut, Greenlandic',
    bcp47: 'kl',
    ohchr: 'esg',
    iso6393: 'kal',
    direction: 'ltr',
    stage: 4,
    latitude: 69.38,
    longitude: -52.86
  },
  {
    code: 'kan',
    name: 'Kannada',
    bcp47: 'kn',
    ohchr: 'kjv',
    iso6393: 'kan',
    direction: 'ltr',
    stage: 4,
    latitude: 13.59,
    longitude: 76.12
  },
  {
    code: 'kat',
    name: 'Georgian',
    bcp47: 'ka',
    ohchr: 'geo',
    iso6393: 'kat',
    direction: 'ltr',
    stage: 5,
    latitude: 39.37,
    longitude: 45.81
  },
  {
    code: 'kaz',
    name: 'Kazakh',
    bcp47: 'kk',
    ohchr: 'kaz',
    iso6393: 'kaz',
    direction: 'ltr',
    stage: 4,
    latitude: 41.87,
    longitude: 65.77
  },
  {
    code: 'kbd',
    name: 'Kabardian',
    bcp47: 'kbd',
    ohchr: 'kbd',
    iso6393: 'kbd',
    direction: 'ltr',
    stage: 4,
    latitude: 43.51,
    longitude: 43.39
  },
  {
    code: 'kbp',
    name: 'Kabiyé',
    bcp47: 'kbp',
    ohchr: 'kbp',
    iso6393: 'kbp',
    direction: 'ltr',
    stage: 4,
    latitude: 8.97,
    longitude: 0.5
  },
  {
    code: 'kde',
    name: 'Makonde',
    bcp47: 'kde',
    ohchr: 'kde',
    iso6393: 'kde',
    direction: 'ltr',
    stage: 4,
    latitude: -10.99,
    longitude: 39.51
  },
  {
    code: 'kdh',
    name: 'Tem',
    bcp47: 'kdh',
    ohchr: 'kdh',
    iso6393: 'kdh',
    direction: 'ltr',
    stage: 4,
    latitude: 8,
    longitude: 1
  },
  {
    code: 'kea',
    name: 'Kabuverdianu',
    bcp47: 'kea',
    ohchr: 'kea',
    iso6393: 'kea',
    direction: 'ltr',
    stage: 4,
    latitude: 15.06,
    longitude: -23.61
  },
  {
    code: 'kek',
    name: "Q'eqchi'",
    bcp47: 'kek',
    ohchr: '1116',
    iso6393: 'kek',
    direction: 'ltr',
    stage: 4,
    latitude: 15.38,
    longitude: -89.25
  },
  {
    code: 'kha',
    name: 'Khasi',
    bcp47: 'kha',
    ohchr: 'kha',
    iso6393: 'kha',
    direction: 'ltr',
    stage: 4,
    latitude: 24.98,
    longitude: 92
  },
  {
    code: 'khk',
    name: 'Mongolian, Halh (Cyrillic)',
    bcp47: 'mn-Cyrl',
    ohchr: 'khk',
    iso6393: 'khk',
    direction: 'ltr',
    stage: 4,
    latitude: 48.32,
    longitude: 106.29
  },
  {
    code: 'khk_mong',
    name: 'Mongolian, Halh (Mongolian)',
    bcp47: 'mn-Mong',
    ohchr: null,
    iso6393: 'khk',
    direction: 'ltr',
    stage: 1,
    latitude: 48.32,
    longitude: 106.29
  },
  {
    code: 'khm',
    name: 'Khmer, Central',
    bcp47: 'km',
    ohchr: 'khm',
    iso6393: 'khm',
    direction: 'ltr',
    stage: 4,
    latitude: 12.05,
    longitude: 105.02
  },
  {
    code: 'kin',
    name: 'Rwanda',
    bcp47: 'rw',
    ohchr: 'rua1',
    iso6393: 'kin',
    direction: 'ltr',
    stage: 4,
    latitude: -1.57,
    longitude: 29.64
  },
  {
    code: 'kir',
    name: 'Kirghiz',
    bcp47: 'ky',
    ohchr: 'kdo',
    iso6393: 'kir',
    direction: 'ltr',
    stage: 4,
    latitude: 42,
    longitude: 74
  },
  {
    code: 'kjh',
    name: 'Khakas',
    bcp47: 'kjh',
    ohchr: 'kjh',
    iso6393: 'kjh',
    direction: 'ltr',
    stage: 4,
    latitude: 50.74,
    longitude: 107.17
  },
  {
    code: 'kkh_lana',
    name: 'Khün',
    bcp47: 'kkh-Lana',
    ohchr: null,
    iso6393: 'kkh',
    direction: 'ltr',
    stage: 4,
    latitude: 20.7,
    longitude: 99.5
  },
  {
    code: 'kmb',
    name: 'Mbundu',
    bcp47: 'kmb',
    ohchr: 'mlo',
    iso6393: 'kmb',
    direction: 'ltr',
    stage: 4,
    latitude: -8.98,
    longitude: 14.89
  },
  {
    code: 'kmr',
    name: 'Kurdish, Northern',
    bcp47: 'ku',
    ohchr: 'kur',
    iso6393: 'kmr',
    direction: 'ltr',
    stage: 4,
    latitude: 37,
    longitude: 43
  },
  {
    code: 'knc',
    name: 'Kanuri, Central',
    bcp47: 'kr',
    ohchr: 'kph',
    iso6393: 'knc',
    direction: 'ltr',
    stage: 4,
    latitude: 11.89,
    longitude: 16.39
  },
  {
    code: 'kng',
    name: 'Koongo',
    bcp47: 'kg',
    ohchr: 'kon',
    iso6393: 'kng',
    direction: 'ltr',
    stage: 4,
    latitude: -5.58,
    longitude: 14.48
  },
  {
    code: 'kng_AO',
    name: 'Koongo (Angola)',
    bcp47: 'kg-AO',
    ohchr: 'kng',
    iso6393: 'kng',
    direction: 'ltr',
    stage: 4,
    latitude: -5.58,
    longitude: 14.48
  },
  {
    code: 'koi',
    name: 'Komi-Permyak',
    bcp47: 'koi',
    ohchr: 'koi',
    iso6393: 'koi',
    direction: 'ltr',
    stage: 4,
    latitude: 59.66,
    longitude: 54.8
  },
  {
    code: 'koo',
    name: 'Konjo',
    bcp47: 'koo',
    ohchr: 'koo1',
    iso6393: 'koo',
    direction: 'ltr',
    stage: 4,
    latitude: 0.32,
    longitude: 29.87
  },
  {
    code: 'kor',
    name: 'Korean',
    bcp47: 'ko',
    ohchr: 'kkn',
    iso6393: 'kor',
    direction: 'ltr',
    stage: 4,
    latitude: 37.5,
    longitude: 128
  },
  {
    code: 'kqn',
    name: 'Kaonde',
    bcp47: 'kqn',
    ohchr: 'kqn',
    iso6393: 'kqn',
    direction: 'ltr',
    stage: 4,
    latitude: -12.41,
    longitude: 25.76
  },
  {
    code: 'kqs',
    name: 'Kissi, Northern',
    bcp47: 'kqs',
    ohchr: 'kqs',
    iso6393: 'kqs',
    direction: 'ltr',
    stage: 4,
    latitude: 9.183333,
    longitude: -10.1
  },
  {
    code: 'kri',
    name: 'Krio',
    bcp47: 'kri',
    ohchr: 'kri',
    iso6393: 'kri',
    direction: 'ltr',
    stage: 4,
    latitude: 10.88,
    longitude: -14.32
  },
  {
    code: 'krl',
    name: 'Karelian',
    bcp47: 'krl',
    ohchr: 'krl',
    iso6393: 'krl',
    direction: 'ltr',
    stage: 4,
    latitude: 65.17,
    longitude: 30.87
  },
  {
    code: 'ktu',
    name: 'Kituba',
    bcp47: 'ktu',
    ohchr: 'ktu',
    iso6393: 'ktu',
    direction: 'ltr',
    stage: 4,
    latitude: -2.3,
    longitude: 17.15
  },
  {
    code: 'kwi',
    name: 'Awa-Cuaiquer',
    bcp47: 'kwi',
    ohchr: 'kwi',
    iso6393: 'kwi',
    direction: 'ltr',
    stage: 4,
    latitude: 1.22,
    longitude: -78.34
  },
  {
    code: 'lad',
    name: 'Ladino',
    bcp47: 'lad',
    ohchr: 'lad',
    iso6393: 'lad',
    direction: 'ltr',
    stage: 4,
    latitude: 41.2,
    longitude: 28.66
  },
  {
    code: 'lao',
    name: 'Lao',
    bcp47: 'lo',
    ohchr: 'nol',
    iso6393: 'lao',
    direction: 'ltr',
    stage: 4,
    latitude: 16.07,
    longitude: 104.57
  },
  {
    code: 'lat',
    name: 'Latin',
    bcp47: 'la',
    ohchr: 'ltn',
    iso6393: 'lat',
    direction: 'ltr',
    stage: 4,
    latitude: 41.9,
    longitude: 12.45
  },
  {
    code: 'lat_1',
    name: 'Latin (1)',
    bcp47: 'la',
    ohchr: 'ltn1',
    iso6393: 'lat',
    direction: 'ltr',
    stage: 4,
    latitude: 41.9,
    longitude: 12.45
  },
  {
    code: 'lav',
    name: 'Latvian',
    bcp47: 'lv',
    ohchr: 'lat',
    iso6393: 'lvs',
    direction: 'ltr',
    stage: 4,
    latitude: 56.83,
    longitude: 24.31
  },
  {
    code: 'lia',
    name: 'Limba, West-Central',
    bcp47: 'lia',
    ohchr: 'lia',
    iso6393: 'lia',
    direction: 'ltr',
    stage: 4,
    latitude: 9.52,
    longitude: -12.31
  },
  {
    code: 'lij',
    name: 'Ligurian',
    bcp47: 'lij',
    ohchr: 'lij',
    iso6393: 'lij',
    direction: 'ltr',
    stage: 4,
    latitude: 44.08,
    longitude: 7.91
  },
  {
    code: 'lin',
    name: 'Lingala',
    bcp47: 'ln',
    ohchr: 'lin',
    iso6393: 'lin',
    direction: 'ltr',
    stage: 4,
    latitude: 1.4,
    longitude: 19.78
  },
  {
    code: 'lin_tones',
    name: 'Lingala (tones)',
    bcp47: 'ln',
    ohchr: null,
    iso6393: 'lin',
    direction: 'ltr',
    stage: 4,
    latitude: 1.4,
    longitude: 19.78
  },
  {
    code: 'lit',
    name: 'Lithuanian',
    bcp47: 'lt',
    ohchr: 'lit',
    iso6393: 'lit',
    direction: 'ltr',
    stage: 4,
    latitude: 55.14,
    longitude: 23.96
  },
  {
    code: 'lld',
    name: 'Ladin',
    bcp47: 'lld',
    ohchr: 'lld',
    iso6393: 'lld',
    direction: 'ltr',
    stage: 4,
    latitude: 46.61,
    longitude: 11.89
  },
  {
    code: 'lnc',
    name: 'Occitan (Languedocien)',
    bcp47: 'oc',
    ohchr: 'prv1',
    iso6393: 'oci',
    direction: 'ltr',
    stage: 4,
    latitude: 44.14,
    longitude: 6.83
  },
  {
    code: 'lns',
    name: "Lamnso'",
    bcp47: 'lns',
    ohchr: 'nso',
    iso6393: 'lns',
    direction: 'ltr',
    stage: 4,
    latitude: 6.4,
    longitude: 11.07
  },
  {
    code: 'lob',
    name: 'Lobi',
    bcp47: 'lob',
    ohchr: 'lob',
    iso6393: 'lob',
    direction: 'ltr',
    stage: 4,
    latitude: 9.96,
    longitude: -3.34
  },
  {
    code: 'lot',
    name: 'Otuho',
    bcp47: 'lot',
    ohchr: 'lot',
    iso6393: 'lot',
    direction: 'ltr',
    stage: 4,
    latitude: 4.16,
    longitude: 32.66
  },
  {
    code: 'loz',
    name: 'Lozi',
    bcp47: 'loz',
    ohchr: 'lbm1',
    iso6393: 'loz',
    direction: 'ltr',
    stage: 4,
    latitude: -17.71,
    longitude: 24.74
  },
  {
    code: 'ltz',
    name: 'Luxembourgeois',
    bcp47: 'lb',
    ohchr: 'lux',
    iso6393: 'ltz',
    direction: 'ltr',
    stage: 4,
    latitude: 49.68,
    longitude: 6.15
  },
  {
    code: 'lua',
    name: 'Luba-Kasai',
    bcp47: 'lua',
    ohchr: 'lub',
    iso6393: 'lua',
    direction: 'ltr',
    stage: 4,
    latitude: -5.73,
    longitude: 22.44
  },
  {
    code: 'lue',
    name: 'Luvale',
    bcp47: 'lue',
    ohchr: 'lue',
    iso6393: 'lue',
    direction: 'ltr',
    stage: 4,
    latitude: -13.54,
    longitude: 22.29
  },
  {
    code: 'lug',
    name: 'Ganda',
    bcp47: 'lg',
    ohchr: 'lap1',
    iso6393: 'lug',
    direction: 'ltr',
    stage: 4,
    latitude: 0.67,
    longitude: 32.15
  },
  {
    code: 'lun',
    name: 'Lunda',
    bcp47: 'lun',
    ohchr: 'mlo1',
    iso6393: 'lun',
    direction: 'ltr',
    stage: 4,
    latitude: -11.18,
    longitude: 23.87
  },
  {
    code: 'lus',
    name: 'Mizo',
    bcp47: 'lus',
    ohchr: 'lus',
    iso6393: 'lus',
    direction: 'ltr',
    stage: 4,
    latitude: 22.61,
    longitude: 92.62
  },
  {
    code: 'mad',
    name: 'Madura',
    bcp47: 'mad',
    ohchr: 'mhj',
    iso6393: 'mad',
    direction: 'ltr',
    stage: 4,
    latitude: -7,
    longitude: 113
  },
  {
    code: 'mag',
    name: 'Magahi',
    bcp47: 'mag',
    ohchr: 'mqm',
    iso6393: 'mag',
    direction: 'ltr',
    stage: 4,
    latitude: 25.09,
    longitude: 85.33
  },
  {
    code: 'mah',
    name: 'Marshallese',
    bcp47: 'mh',
    ohchr: 'mzm',
    iso6393: 'mah',
    direction: 'ltr',
    stage: 4,
    latitude: 3.13,
    longitude: 170.46
  },
  {
    code: 'mai',
    name: 'Maithili',
    bcp47: 'mai',
    ohchr: null,
    iso6393: 'mai',
    direction: 'ltr',
    stage: 4,
    latitude: 26.38,
    longitude: 86.22
  },
  {
    code: 'mal',
    name: 'Malayalam',
    bcp47: 'ml',
    ohchr: 'mjs',
    iso6393: 'mal',
    direction: 'ltr',
    stage: 4,
    latitude: 9.59,
    longitude: 76.77
  },
  {
    code: 'mal_chillus',
    name: 'Malayalam',
    bcp47: 'ml',
    ohchr: 'mjs',
    iso6393: 'mal',
    direction: 'ltr',
    stage: 4,
    latitude: 9.59,
    longitude: 76.77
  },
  {
    code: 'mam',
    name: 'Mam, Northern',
    bcp47: 'mam',
    ohchr: 'mam',
    iso6393: 'mam',
    direction: 'ltr',
    stage: 4,
    latitude: 14.8,
    longitude: -91.72
  },
  {
    code: 'mar',
    name: 'Marathi',
    bcp47: 'mr',
    ohchr: 'mrt',
    iso6393: 'mar',
    direction: 'ltr',
    stage: 4,
    latitude: 17.93,
    longitude: 76.67
  },
  {
    code: 'maz',
    name: 'Mazahua Central',
    bcp47: 'maz',
    ohchr: 'maz',
    iso6393: 'maz',
    direction: 'ltr',
    stage: 4,
    latitude: 19.74,
    longitude: -100.02
  },
  {
    code: 'mcd',
    name: 'Sharanahua',
    bcp47: 'mcd',
    ohchr: 'mcd',
    iso6393: 'mcd',
    direction: 'ltr',
    stage: 4,
    latitude: -9.86,
    longitude: -71.12
  },
  {
    code: 'mcf',
    name: 'Matsés',
    bcp47: 'mcf',
    ohchr: 'mcf',
    iso6393: 'mcf',
    direction: 'ltr',
    stage: 4,
    latitude: -5.74,
    longitude: -72.63
  },
  {
    code: 'men',
    name: 'Mende',
    bcp47: 'men',
    ohchr: 'mfy',
    iso6393: 'men',
    direction: 'ltr',
    stage: 4,
    latitude: 7.91,
    longitude: -10.99
  },
  {
    code: 'mfq',
    name: 'Moba',
    bcp47: 'mfq',
    ohchr: 'mfq',
    iso6393: 'mfq',
    direction: 'ltr',
    stage: 4,
    latitude: 8,
    longitude: 1
  },
  {
    code: 'mic',
    name: 'Micmac',
    bcp47: 'mic',
    ohchr: 'mic',
    iso6393: 'mic',
    direction: 'ltr',
    stage: 4,
    latitude: 45.99,
    longitude: -65.58
  },
  {
    code: 'min',
    name: 'Minangkabau',
    bcp47: 'min',
    ohchr: 'mpu',
    iso6393: 'min',
    direction: 'ltr',
    stage: 4,
    latitude: 4.17,
    longitude: 96.25
  },
  {
    code: 'miq',
    name: 'Mískito',
    bcp47: 'miq',
    ohchr: 'miq',
    iso6393: 'miq',
    direction: 'ltr',
    stage: 4,
    latitude: 15.16,
    longitude: -84.29
  },
  {
    code: 'mkd',
    name: 'Macedonian',
    bcp47: 'mk',
    ohchr: 'mkj',
    iso6393: 'mkd',
    direction: 'ltr',
    stage: 4,
    latitude: 41.6,
    longitude: 21.79
  },
  {
    code: 'mlt',
    name: 'Maltese',
    bcp47: 'mt',
    ohchr: 'mls',
    iso6393: 'mlt',
    direction: 'ltr',
    stage: 4,
    latitude: 35.89,
    longitude: 14.45
  },
  {
    code: 'mly_arab',
    name: 'Malay (Arabic)',
    bcp47: 'zlm-Arab',
    ohchr: null,
    iso6393: 'zlm',
    direction: 'rtl',
    stage: 4,
    latitude: 1.86,
    longitude: 103
  },
  {
    code: 'mly_latn',
    name: 'Malay (Latin)',
    bcp47: 'zlm-Latn',
    ohchr: 'mli',
    iso6393: 'zlm',
    direction: 'ltr',
    stage: 4,
    latitude: 1.86,
    longitude: 103
  },
  {
    code: 'mnw',
    name: 'Mon',
    bcp47: 'mnw',
    ohchr: null,
    iso6393: 'mnw',
    direction: 'ltr',
    stage: 4,
    latitude: 10,
    longitude: 100
  },
  {
    code: 'mos',
    name: 'Mòoré',
    bcp47: 'mos',
    ohchr: 'mhm',
    iso6393: 'mos',
    direction: 'ltr',
    stage: 4,
    latitude: 10.45,
    longitude: -1.17
  },
  {
    code: 'mri',
    name: 'Maori',
    bcp47: 'mi',
    ohchr: 'mbf',
    iso6393: 'mri',
    direction: 'ltr',
    stage: 4,
    latitude: -38.29,
    longitude: 176.54
  },
  {
    code: 'mto',
    name: 'Mixe, Totontepec',
    bcp47: 'mto',
    ohchr: 'mto',
    iso6393: 'mto',
    direction: 'ltr',
    stage: 4,
    latitude: 17.22,
    longitude: -96.02
  },
  {
    code: 'mxi',
    name: 'Mozarabic',
    bcp47: 'mxi',
    ohchr: 'moz',
    iso6393: 'mxi',
    direction: 'ltr',
    stage: 4,
    latitude: 37.88,
    longitude: -1.8
  },
  {
    code: 'mxv',
    name: 'Mixtec, Metlatónoc',
    bcp47: 'mxv',
    ohchr: 'mxv',
    iso6393: 'mxv',
    direction: 'ltr',
    stage: 4,
    latitude: 17.05,
    longitude: -98.35
  },
  {
    code: 'mya',
    name: 'Burmese',
    bcp47: 'my',
    ohchr: 'bms',
    iso6393: 'mya',
    direction: 'ltr',
    stage: 4,
    latitude: 20.79,
    longitude: 93.97
  },
  {
    code: 'mzi',
    name: 'Mazatec, Ixcatlán',
    bcp47: 'mzi',
    ohchr: 'mao',
    iso6393: 'mzi',
    direction: 'ltr',
    stage: 4,
    latitude: 18.15,
    longitude: -96.57
  },
  {
    code: 'nan',
    name: 'Chinese, Min Nan',
    bcp47: 'nan',
    ohchr: 'nan',
    iso6393: 'nan',
    direction: 'ltr',
    stage: 4,
    latitude: 25,
    longitude: 116
  },
  {
    code: 'nav',
    name: 'Navajo',
    bcp47: 'nv',
    ohchr: 'nav',
    iso6393: 'nav',
    direction: 'ltr',
    stage: 4,
    latitude: 36.21,
    longitude: -110.08
  },
  {
    code: 'nba',
    name: 'Nyemba',
    bcp47: 'nba',
    ohchr: 'nba',
    iso6393: 'nba',
    direction: 'ltr',
    stage: 4,
    latitude: -15.71,
    longitude: 18.25
  },
  {
    code: 'nbl',
    name: 'Ndebele',
    bcp47: 'nr',
    ohchr: 'nel',
    iso6393: 'nbl',
    direction: 'ltr',
    stage: 4,
    latitude: -25.63,
    longitude: 29.05
  },
  {
    code: 'ndo',
    name: 'Ndonga',
    bcp47: 'ng',
    ohchr: '1114',
    iso6393: 'ndo',
    direction: 'ltr',
    stage: 4,
    latitude: -17.64,
    longitude: 19.16
  },
  {
    code: 'nds',
    name: 'Saxon, Low',
    bcp47: 'nds',
    ohchr: 'ige',
    iso6393: 'nds',
    direction: 'ltr',
    stage: 4,
    latitude: 50.77,
    longitude: 6.09
  },
  {
    code: 'nep',
    name: 'Nepali',
    bcp47: 'ne',
    ohchr: 'nep',
    iso6393: 'npi',
    direction: 'ltr',
    stage: 4,
    latitude: 27.5,
    longitude: 85
  },
  {
    code: 'nhn',
    name: 'Nahuatl, Central',
    bcp47: 'nhn',
    ohchr: 'nhn',
    iso6393: 'nhn',
    direction: 'ltr',
    stage: 4,
    latitude: 19.12,
    longitude: -98.3
  },
  {
    code: 'nio',
    name: 'Nganasan',
    bcp47: 'nio',
    ohchr: 'nio',
    iso6393: 'nio',
    direction: 'ltr',
    stage: 4,
    latitude: 73.14,
    longitude: 86.21
  },
  {
    code: 'niu',
    name: 'Niue',
    bcp47: 'niu',
    ohchr: 'niu',
    iso6393: 'niu',
    direction: 'ltr',
    stage: 4,
    latitude: -19.05,
    longitude: -169.92
  },
  {
    code: 'njo',
    name: 'Naga, Ao',
    bcp47: 'njo',
    ohchr: 'njo',
    iso6393: 'njo',
    direction: 'ltr',
    stage: 4,
    latitude: 26.32,
    longitude: 94.38
  },
  {
    code: 'nku',
    name: 'Kulango, Bouna',
    bcp47: 'nku',
    ohchr: 'kou',
    iso6393: 'nku',
    direction: 'ltr',
    stage: 4,
    latitude: 8.46,
    longitude: -2.75
  },
  {
    code: 'nld',
    name: 'Dutch',
    bcp47: 'nl',
    ohchr: 'dut',
    iso6393: 'nld',
    direction: 'ltr',
    stage: 4,
    latitude: 52,
    longitude: 5
  },
  {
    code: 'nno',
    name: 'Norwegian, Nynorsk',
    bcp47: 'nn',
    ohchr: 'nrn',
    iso6393: 'nno',
    direction: 'ltr',
    stage: 4,
    latitude: 61,
    longitude: 11
  },
  {
    code: 'nob',
    name: 'Norwegian, Bokmål',
    bcp47: 'nb',
    ohchr: 'nrr',
    iso6393: 'nob',
    direction: 'ltr',
    stage: 4,
    latitude: 61,
    longitude: 8
  },
  {
    code: 'not',
    name: 'Nomatsiguenga',
    bcp47: 'not',
    ohchr: 'not',
    iso6393: 'not',
    direction: 'ltr',
    stage: 4,
    latitude: -11.53,
    longitude: -74.44
  },
  {
    code: 'nso',
    name: 'Sotho, Northern',
    bcp47: 'nso',
    ohchr: 'srt',
    iso6393: 'nso',
    direction: 'ltr',
    stage: 4,
    latitude: -24.8,
    longitude: 29.47
  },
  {
    code: 'nya_chechewa',
    name: 'Nyanja (Chechewa)',
    bcp47: 'ny',
    ohchr: 'nyj1',
    iso6393: 'nya',
    direction: 'ltr',
    stage: 4,
    latitude: -14.8,
    longitude: 32.81
  },
  {
    code: 'nya_chinyanja',
    name: 'Nyanja (Chinyanja)',
    bcp47: 'ny',
    ohchr: 'nyj',
    iso6393: 'nya',
    direction: 'ltr',
    stage: 4,
    latitude: -14.8,
    longitude: 32.81
  },
  {
    code: 'nym',
    name: 'Nyamwezi',
    bcp47: 'nym',
    ohchr: 'nyz',
    iso6393: 'nym',
    direction: 'ltr',
    stage: 4,
    latitude: -5.09,
    longitude: 32.94
  },
  {
    code: 'nyn',
    name: 'Nyankore',
    bcp47: 'nyn',
    ohchr: 'nyn1',
    iso6393: 'nyn',
    direction: 'ltr',
    stage: 4,
    latitude: -0.46,
    longitude: 30.55
  },
  {
    code: 'nzi',
    name: 'Nzema',
    bcp47: 'nzi',
    ohchr: 'nze',
    iso6393: 'nzi',
    direction: 'ltr',
    stage: 4,
    latitude: 5.18,
    longitude: -2.81
  },
  {
    code: 'oaa',
    name: 'Orok',
    bcp47: 'oaa',
    ohchr: 'oaa',
    iso6393: 'oaa',
    direction: 'ltr',
    stage: 4,
    latitude: 49.36,
    longitude: 143.13
  },
  {
    code: 'oci_1',
    name: 'Occitan (Francoprovençal, Fribourg)',
    bcp47: 'oc',
    ohchr: 'Fr3',
    iso6393: 'oci',
    direction: 'ltr',
    stage: 4,
    latitude: 44.14,
    longitude: 6.83
  },
  {
    code: 'oci_2',
    name: 'Occitan (Francoprovençal, Savoie)',
    bcp47: 'oc',
    ohchr: 'fr2',
    iso6393: 'oci',
    direction: 'ltr',
    stage: 4,
    latitude: 44.14,
    longitude: 6.83
  },
  {
    code: 'oci_3',
    name: 'Occitan (Francoprovençal, Vaud)',
    bcp47: 'oc',
    ohchr: 'fr4',
    iso6393: 'oci',
    direction: 'ltr',
    stage: 4,
    latitude: 44.14,
    longitude: 6.83
  },
  {
    code: 'oci_4',
    name: 'Occitan (Francoprovençal, Valais)',
    bcp47: 'oc',
    ohchr: 'frp',
    iso6393: 'oci',
    direction: 'ltr',
    stage: 4,
    latitude: 44.14,
    longitude: 6.83
  },
  {
    code: 'ojb',
    name: 'Ojibwa, Northwestern',
    bcp47: 'ojb',
    ohchr: 'ojb',
    iso6393: 'ojb',
    direction: 'ltr',
    stage: 4,
    latitude: 51.62,
    longitude: -87.79
  },
  {
    code: 'oki',
    name: 'Okiek',
    bcp47: 'oki',
    ohchr: 'oki',
    iso6393: 'oki',
    direction: 'ltr',
    stage: 4,
    latitude: -2.78,
    longitude: 36.6
  },
  {
    code: 'orh',
    name: 'Oroqen',
    bcp47: 'orh',
    ohchr: 'orh',
    iso6393: 'orh',
    direction: 'ltr',
    stage: 4,
    latitude: 50,
    longitude: 125
  },
  {
    code: 'oss',
    name: 'Osetin',
    bcp47: 'os',
    ohchr: 'ose',
    iso6393: 'oss',
    direction: 'ltr',
    stage: 4,
    latitude: 41.79,
    longitude: 43.27
  },
  {
    code: 'ote',
    name: 'Otomi, Mezquital',
    bcp47: 'ote',
    ohchr: '1111',
    iso6393: 'ote',
    direction: 'ltr',
    stage: 4,
    latitude: 20.23,
    longitude: -99.56
  },
  {
    code: 'pam',
    name: 'Pampangan',
    bcp47: 'pam',
    ohchr: 'pmp',
    iso6393: 'pam',
    direction: 'ltr',
    stage: 4,
    latitude: 14.96,
    longitude: 120.5
  },
  {
    code: 'pan',
    name: 'Panjabi, Eastern',
    bcp47: 'pa',
    ohchr: 'pnj1',
    iso6393: 'pan',
    direction: 'ltr',
    stage: 4,
    latitude: 30.04,
    longitude: 75.67
  },
  {
    code: 'pap',
    name: 'Papiamentu',
    bcp47: 'pap',
    ohchr: 'pap',
    iso6393: 'pap',
    direction: 'ltr',
    stage: 4,
    latitude: 12.48,
    longitude: -69.94
  },
  {
    code: 'pau',
    name: 'Palauan',
    bcp47: 'pau',
    ohchr: 'plu',
    iso6393: 'pau',
    direction: 'ltr',
    stage: 4,
    latitude: 7.17,
    longitude: 134.5
  },
  {
    code: 'pbb',
    name: 'Páez',
    bcp47: 'pbb',
    ohchr: 'pbb',
    iso6393: 'pbb',
    direction: 'ltr',
    stage: 4,
    latitude: 2.62,
    longitude: -76.31
  },
  {
    code: 'pbu',
    name: 'Pashto, Northern',
    bcp47: 'ps',
    ohchr: 'pbu',
    iso6393: 'pbu',
    direction: 'rtl',
    stage: 4,
    latitude: 35,
    longitude: 71.33
  },
  {
    code: 'pcd',
    name: 'Picard',
    bcp47: 'pcd',
    ohchr: 'frn2',
    iso6393: 'pcd',
    direction: 'ltr',
    stage: 4,
    latitude: 50.28,
    longitude: 3.25
  },
  {
    code: 'pcm',
    name: 'Pidgin, Nigerian',
    bcp47: 'pcm',
    ohchr: 'pcm',
    iso6393: 'pcm',
    direction: 'ltr',
    stage: 4,
    latitude: 9.66,
    longitude: 4.21
  },
  {
    code: 'pes_1',
    name: 'Farsi, Western',
    bcp47: 'fa',
    ohchr: 'prs',
    iso6393: 'pes',
    direction: 'rtl',
    stage: 4,
    latitude: 28.66,
    longitude: 55.16
  },
  {
    code: 'pes_2',
    name: 'Dari',
    bcp47: 'fa-AF',
    ohchr: 'prs1',
    iso6393: 'prs',
    direction: 'rtl',
    stage: 4,
    latitude: 28.66,
    longitude: 55.16
  },
  {
    code: 'pis',
    name: 'Pijin',
    bcp47: 'pis',
    ohchr: 'pis',
    iso6393: 'pis',
    direction: 'ltr',
    stage: 4,
    latitude: -9.57,
    longitude: 160.14
  },
  {
    code: 'piu',
    name: 'Pintupi-Luritja',
    bcp47: 'piu',
    ohchr: 'piu',
    iso6393: 'piu',
    direction: 'ltr',
    stage: 4,
    latitude: -20.14,
    longitude: 127.98
  },
  {
    code: 'plt',
    name: 'Malagasy, Plateau',
    bcp47: 'mg',
    ohchr: 'mex',
    iso6393: 'plt',
    direction: 'ltr',
    stage: 4,
    latitude: -19.59,
    longitude: 47.12
  },
  {
    code: 'pnb',
    name: 'Panjabi, Western',
    bcp47: 'lah',
    ohchr: null,
    iso6393: 'pnb',
    direction: 'rtl',
    stage: 4,
    latitude: 30.09,
    longitude: 75.35
  },
  {
    code: 'pol',
    name: 'Polish',
    bcp47: 'pl',
    ohchr: 'pql',
    iso6393: 'pol',
    direction: 'ltr',
    stage: 4,
    latitude: 51.84,
    longitude: 18.63
  },
  {
    code: 'pon',
    name: 'Pohnpeian',
    bcp47: 'pon',
    ohchr: 'pnf',
    iso6393: 'pon',
    direction: 'ltr',
    stage: 4,
    latitude: 6.87,
    longitude: 158.22
  },
  {
    code: 'por_BR',
    name: 'Portuguese (Brazil)',
    bcp47: 'pt-BR',
    ohchr: null,
    iso6393: 'por',
    direction: 'ltr',
    stage: 5,
    latitude: -15,
    longitude: -47
  },
  {
    code: 'por_PT',
    name: 'Portuguese (Portugal)',
    bcp47: 'pt-PT',
    ohchr: 'por',
    iso6393: 'por',
    direction: 'ltr',
    stage: 5,
    latitude: 39.91,
    longitude: -8.1
  },
  {
    code: 'pov',
    name: 'Crioulo, Upper Guinea',
    bcp47: 'pov',
    ohchr: 'gbc',
    iso6393: 'pov',
    direction: 'ltr',
    stage: 4,
    latitude: 13.23,
    longitude: -15.33
  },
  {
    code: 'ppl',
    name: 'Pipil',
    bcp47: 'ppl',
    ohchr: 'ppl',
    iso6393: 'ppl',
    direction: 'ltr',
    stage: 4,
    latitude: 13.89,
    longitude: -89.44
  },
  {
    code: 'prv',
    name: 'Occitan',
    bcp47: 'oc',
    ohchr: 'pro',
    iso6393: 'oci',
    direction: 'ltr',
    stage: 4,
    latitude: 44.14,
    longitude: 6.83
  },
  {
    code: 'quc',
    name: "K'iche', Central",
    bcp47: 'quc',
    ohchr: '1117',
    iso6393: 'quc',
    direction: 'ltr',
    stage: 4,
    latitude: 14.53,
    longitude: -91.17
  },
  {
    code: 'qud',
    name: 'Quechua (Unified Quichua, old Hispanic orthography)',
    bcp47: 'qu',
    ohchr: 'qud1',
    iso6393: 'que',
    direction: 'ltr',
    stage: 4,
    latitude: -0.5,
    longitude: -78.5
  },
  {
    code: 'qug',
    name: 'Quichua, Chimborazo Highland',
    bcp47: 'qug',
    ohchr: 'qug',
    iso6393: 'qug',
    direction: 'ltr',
    stage: 4,
    latitude: -1.37,
    longitude: -78.85
  },
  {
    code: 'quy',
    name: 'Quechua, Ayacucho',
    bcp47: 'quy',
    ohchr: 'quy',
    iso6393: 'quy',
    direction: 'ltr',
    stage: 4,
    latitude: -13.85,
    longitude: -74.32
  },
  {
    code: 'quz',
    name: 'Quechua, Cusco',
    bcp47: 'qu',
    ohchr: 'quz',
    iso6393: 'quz',
    direction: 'ltr',
    stage: 4,
    latitude: -14.09,
    longitude: -71.77
  },
  {
    code: 'qva',
    name: 'Quechua, Ambo-Pasco',
    bcp47: 'qva',
    ohchr: 'qeg',
    iso6393: 'qva',
    direction: 'ltr',
    stage: 4,
    latitude: -10.51,
    longitude: -76.11
  },
  {
    code: 'qvc',
    name: 'Quechua, Cajamarca',
    bcp47: 'qvc',
    ohchr: 'qnt',
    iso6393: 'qvc',
    direction: 'ltr',
    stage: 4,
    latitude: -7.09,
    longitude: -78.32
  },
  {
    code: 'qvh',
    name: 'Quechua, Huamalíes-Dos de Mayo Huánuco',
    bcp47: 'qvh',
    ohchr: 'qej',
    iso6393: 'qvh',
    direction: 'ltr',
    stage: 4,
    latitude: -9.16,
    longitude: -76.34
  },
  {
    code: 'qvm',
    name: 'Quechua, Margos-Yarowilca-Lauricocha',
    bcp47: 'qvm',
    ohchr: 'qei',
    iso6393: 'qvm',
    direction: 'ltr',
    stage: 4,
    latitude: -9.84,
    longitude: -76.5
  },
  {
    code: 'qvn',
    name: 'Quechua, North Junín',
    bcp47: 'qvn',
    ohchr: 'qju',
    iso6393: 'qvn',
    direction: 'ltr',
    stage: 4,
    latitude: -11.21,
    longitude: -75.81
  },
  {
    code: 'qwh',
    name: 'Quechua, Huaylas Ancash',
    bcp47: 'qwh',
    ohchr: 'qan',
    iso6393: 'qwh',
    direction: 'ltr',
    stage: 4,
    latitude: -9.39,
    longitude: -77.78
  },
  {
    code: 'qxa',
    name: 'Quechua, South Bolivian',
    bcp47: 'quh',
    ohchr: 'qec1',
    iso6393: 'quh',
    direction: 'ltr',
    stage: 4,
    latitude: -20.92,
    longitude: -66.33
  },
  {
    code: 'qxn',
    name: 'Quechua, Northern Conchucos Ancash',
    bcp47: 'qxn',
    ohchr: 'qed',
    iso6393: 'qxn',
    direction: 'ltr',
    stage: 4,
    latitude: -8.97,
    longitude: -77.41
  },
  {
    code: 'qxu',
    name: 'Quechua, Arequipa-La Unión',
    bcp47: 'qxu',
    ohchr: 'qar',
    iso6393: 'qxu',
    direction: 'ltr',
    stage: 4,
    latitude: -15.18,
    longitude: -72.63
  },
  {
    code: 'rar',
    name: 'Rarotongan',
    bcp47: 'rar',
    ohchr: 'rrt',
    iso6393: 'rar',
    direction: 'ltr',
    stage: 4,
    latitude: -20,
    longitude: -158
  },
  {
    code: 'rmn',
    name: 'Romani, Balkan',
    bcp47: 'rmn',
    ohchr: 'rmn',
    iso6393: 'rmn',
    direction: 'ltr',
    stage: 4,
    latitude: 42.67,
    longitude: 21.17
  },
  {
    code: 'rmn_1',
    name: 'Romani, Balkan (1)',
    bcp47: 'rmn',
    ohchr: 'rmn1',
    iso6393: 'rmn',
    direction: 'ltr',
    stage: 4,
    latitude: 42.67,
    longitude: 21.17
  },
  {
    code: 'rmy',
    name: 'Aromanian',
    bcp47: 'rup',
    ohchr: 'rmy1',
    iso6393: 'rup',
    direction: 'ltr',
    stage: 4,
    latitude: 42.06,
    longitude: 22.65
  },
  {
    code: 'roh',
    name: 'Romansch',
    bcp47: 'rm',
    ohchr: null,
    iso6393: 'roh',
    direction: 'ltr',
    stage: 4,
    latitude: 46.55,
    longitude: 9.93
  },
  {
    code: 'roh_puter',
    name: 'Romansch (Puter)',
    bcp47: 'rm-puter',
    ohchr: null,
    iso6393: 'roh',
    direction: 'ltr',
    stage: 4,
    latitude: 46.55,
    longitude: 9.93
  },
  {
    code: 'roh_rumgr',
    name: 'Romansch (Grischun)',
    bcp47: 'rm-rumgr',
    ohchr: 'rhe',
    iso6393: 'roh',
    direction: 'ltr',
    stage: 4,
    latitude: 46.55,
    longitude: 9.93
  },
  {
    code: 'roh_surmiran',
    name: 'Romansch (Surmiran)',
    bcp47: 'rm-surmiran',
    ohchr: null,
    iso6393: 'roh',
    direction: 'ltr',
    stage: 4,
    latitude: 46.55,
    longitude: 9.93
  },
  {
    code: 'roh_sursilv',
    name: 'Romansch (Sursilvan)',
    bcp47: 'rm-sursilv',
    ohchr: null,
    iso6393: 'roh',
    direction: 'ltr',
    stage: 4,
    latitude: 46.55,
    longitude: 9.93
  },
  {
    code: 'roh_sutsilv',
    name: 'Romansch (Sutsilvan)',
    bcp47: 'rm-sutsilv',
    ohchr: null,
    iso6393: 'roh',
    direction: 'ltr',
    stage: 4,
    latitude: 46.55,
    longitude: 9.93
  },
  {
    code: 'roh_vallader',
    name: 'Romansch (Vallader)',
    bcp47: 'rm-vallader',
    ohchr: null,
    iso6393: 'roh',
    direction: 'ltr',
    stage: 4,
    latitude: 46.55,
    longitude: 9.93
  },
  {
    code: 'ron_1953',
    name: 'Romanian (1953)',
    bcp47: 'ro',
    ohchr: 'rum',
    iso6393: 'ron',
    direction: 'ltr',
    stage: 4,
    latitude: 46.39,
    longitude: 24.23
  },
  {
    code: 'ron_1993',
    name: 'Romanian (1993)',
    bcp47: 'ro',
    ohchr: null,
    iso6393: 'ron',
    direction: 'ltr',
    stage: 4,
    latitude: 46.39,
    longitude: 24.23
  },
  {
    code: 'ron_2006',
    name: 'Romanian (2006)',
    bcp47: 'ro',
    ohchr: null,
    iso6393: 'ron',
    direction: 'ltr',
    stage: 4,
    latitude: 46.39,
    longitude: 24.23
  },
  {
    code: 'run',
    name: 'Rundi',
    bcp47: 'rn',
    ohchr: 'rud1',
    iso6393: 'run',
    direction: 'ltr',
    stage: 4,
    latitude: -1.44,
    longitude: 31.32
  },
  {
    code: 'rus',
    name: 'Russian',
    bcp47: 'ru',
    ohchr: 'rus',
    iso6393: 'rus',
    direction: 'ltr',
    stage: 4,
    latitude: 59,
    longitude: 50
  },
  {
    code: 'sag',
    name: 'Sango',
    bcp47: 'sg',
    ohchr: 'saj',
    iso6393: 'sag',
    direction: 'ltr',
    stage: 4,
    latitude: 6.79,
    longitude: 20.17
  },
  {
    code: 'sah',
    name: 'Yakut',
    bcp47: 'sah',
    ohchr: 'sah',
    iso6393: 'sah',
    direction: 'ltr',
    stage: 4,
    latitude: 61.7,
    longitude: 133.98
  },
  {
    code: 'san',
    name: 'Sanskrit',
    bcp47: 'sa',
    ohchr: 'skt',
    iso6393: 'san',
    direction: 'ltr',
    stage: 4,
    latitude: 20,
    longitude: 77
  },
  {
    code: 'san_gran',
    name: 'Sanskrit (Grantha)',
    bcp47: 'sa-Gran',
    ohchr: null,
    iso6393: 'san',
    direction: 'ltr',
    stage: 4,
    latitude: 20,
    longitude: 77
  },
  {
    code: 'sco',
    name: 'Scots',
    bcp47: 'sco',
    ohchr: 'sco',
    iso6393: 'sco',
    direction: 'ltr',
    stage: 4,
    latitude: 55.54,
    longitude: -6
  },
  {
    code: 'sey',
    name: 'Secoya',
    bcp47: 'sey',
    ohchr: '1123',
    iso6393: 'sey',
    direction: 'ltr',
    stage: 4,
    latitude: 0.46,
    longitude: -75.55
  },
  {
    code: 'shk',
    name: 'Shilluk',
    bcp47: 'shk',
    ohchr: 'shk',
    iso6393: 'shk',
    direction: 'ltr',
    stage: 4,
    latitude: 9.85,
    longitude: 31.79
  },
  {
    code: 'shn',
    name: 'Shan',
    bcp47: 'shn',
    ohchr: 'sjn',
    iso6393: 'shn',
    direction: 'ltr',
    stage: 4,
    latitude: 21.6,
    longitude: 98.03
  },
  {
    code: 'shp',
    name: 'Shipibo-Conibo',
    bcp47: 'shp',
    ohchr: 'shp',
    iso6393: 'shp',
    direction: 'ltr',
    stage: 4,
    latitude: -7.17,
    longitude: -74.82
  },
  {
    code: 'sin',
    name: 'Sinhala',
    bcp47: 'si',
    ohchr: 'snh',
    iso6393: 'sin',
    direction: 'ltr',
    stage: 5,
    latitude: 7,
    longitude: 81
  },
  {
    code: 'skr',
    name: 'Seraiki',
    bcp47: 'skr',
    ohchr: 'skr',
    iso6393: 'skr',
    direction: 'rtl',
    stage: 4,
    latitude: 29.55,
    longitude: 71.91
  },
  {
    code: 'slk',
    name: 'Slovak',
    bcp47: 'sk',
    ohchr: 'slo',
    iso6393: 'slk',
    direction: 'ltr',
    stage: 4,
    latitude: 48.55,
    longitude: 18.78
  },
  {
    code: 'slv',
    name: 'Slovenian',
    bcp47: 'sl',
    ohchr: 'slv',
    iso6393: 'slv',
    direction: 'ltr',
    stage: 4,
    latitude: 46.25,
    longitude: 14.78
  },
  {
    code: 'sme',
    name: 'Saami, North',
    bcp47: 'se',
    ohchr: 'lpi',
    iso6393: 'sme',
    direction: 'ltr',
    stage: 4,
    latitude: 68.72,
    longitude: 22.11
  },
  {
    code: 'smo',
    name: 'Samoan',
    bcp47: 'sm',
    ohchr: 'smy',
    iso6393: 'smo',
    direction: 'ltr',
    stage: 4,
    latitude: -13.92,
    longitude: -171.83
  },
  {
    code: 'sna',
    name: 'Shona',
    bcp47: 'sn',
    ohchr: 'shd',
    iso6393: 'sna',
    direction: 'ltr',
    stage: 4,
    latitude: -17.21,
    longitude: 29.76
  },
  {
    code: 'snk',
    name: 'Soninke',
    bcp47: 'snk',
    ohchr: 'snn',
    iso6393: 'snk',
    direction: 'ltr',
    stage: 4,
    latitude: 13.13,
    longitude: -11.72
  },
  {
    code: 'snn',
    name: 'Siona',
    bcp47: 'snn',
    ohchr: '1121',
    iso6393: 'snn',
    direction: 'ltr',
    stage: 4,
    latitude: 0.32,
    longitude: -76.02
  },
  {
    code: 'som',
    name: 'Somali',
    bcp47: 'so',
    ohchr: 'som',
    iso6393: 'som',
    direction: 'ltr',
    stage: 4,
    latitude: 4.78,
    longitude: 45.15
  },
  {
    code: 'sot',
    name: 'Sotho, Southern',
    bcp47: 'st',
    ohchr: 'sso',
    iso6393: 'sot',
    direction: 'ltr',
    stage: 4,
    latitude: -30.44,
    longitude: 27.9
  },
  {
    code: 'spa',
    name: 'Spanish',
    bcp47: 'es',
    ohchr: 'spn',
    iso6393: 'spa',
    direction: 'ltr',
    stage: 4,
    latitude: 40.44,
    longitude: -1.12
  },
  {
    code: 'src',
    name: 'Sardinian, Logudorese',
    bcp47: 'sc',
    ohchr: 'srd',
    iso6393: 'src',
    direction: 'ltr',
    stage: 4,
    latitude: 40.49,
    longitude: 9.1
  },
  {
    code: 'srp_cyrl',
    name: 'Serbian (Cyrillic)',
    bcp47: 'sr-Cyrl',
    ohchr: 'src5',
    iso6393: 'srp',
    direction: 'ltr',
    stage: 4,
    latitude: 44.32,
    longitude: 21.92
  },
  {
    code: 'srp_latn',
    name: 'Serbian (Latin)',
    bcp47: 'sr-Latn',
    ohchr: 'src3',
    iso6393: 'srp',
    direction: 'ltr',
    stage: 4,
    latitude: 44.32,
    longitude: 21.92
  },
  {
    code: 'srr',
    name: 'Serer-Sine',
    bcp47: 'srr',
    ohchr: 'ses',
    iso6393: 'srr',
    direction: 'ltr',
    stage: 4,
    latitude: 13.89,
    longitude: -16.39
  },
  {
    code: 'ssw',
    name: 'Swati',
    bcp47: 'ss',
    ohchr: 'swz1',
    iso6393: 'ssw',
    direction: 'ltr',
    stage: 4,
    latitude: -26,
    longitude: 31.5
  },
  {
    code: 'suk',
    name: 'Sukuma',
    bcp47: 'suk',
    ohchr: 'sua',
    iso6393: 'suk',
    direction: 'ltr',
    stage: 4,
    latitude: -3.16,
    longitude: 32.88
  },
  {
    code: 'sun',
    name: 'Sunda',
    bcp47: 'su',
    ohchr: 'suo',
    iso6393: 'sun',
    direction: 'ltr',
    stage: 4,
    latitude: -6.9,
    longitude: 107.11
  },
  {
    code: 'sus',
    name: 'Susu',
    bcp47: 'sus',
    ohchr: 'sus',
    iso6393: 'sus',
    direction: 'ltr',
    stage: 4,
    latitude: 10.4,
    longitude: -13.36
  },
  {
    code: 'swb',
    name: 'Comorian, Maore',
    bcp47: 'swb',
    ohchr: 'swb',
    iso6393: 'swb',
    direction: 'ltr',
    stage: 4,
    latitude: -12.97,
    longitude: 45.14
  },
  {
    code: 'swe',
    name: 'Swedish',
    bcp47: 'sv',
    ohchr: 'swd',
    iso6393: 'swe',
    direction: 'ltr',
    stage: 4,
    latitude: 59.8,
    longitude: 17.39
  },
  {
    code: 'swh',
    name: 'Swahili',
    bcp47: 'sw',
    ohchr: 'swa',
    iso6393: 'swh',
    direction: 'ltr',
    stage: 4,
    latitude: -8.26,
    longitude: 37.62
  },
  {
    code: 'tah',
    name: 'Tahitian',
    bcp47: 'ty',
    ohchr: 'tht',
    iso6393: 'tah',
    direction: 'ltr',
    stage: 4,
    latitude: -17.65,
    longitude: -149.45
  },
  {
    code: 'taj',
    name: 'Tamang, Eastern',
    bcp47: 'taj',
    ohchr: 'taj',
    iso6393: 'taj',
    direction: 'ltr',
    stage: 3,
    latitude: 27.32,
    longitude: 87.08
  },
  {
    code: 'tam',
    name: 'Tamil',
    bcp47: 'ta',
    ohchr: 'tcv',
    iso6393: 'tam',
    direction: 'ltr',
    stage: 4,
    latitude: 10.52,
    longitude: 78.83
  },
  {
    code: 'tam_LK',
    name: 'Tamil (Sri Lanka)',
    bcp47: 'ta-LK',
    ohchr: null,
    iso6393: 'tam',
    direction: 'ltr',
    stage: 4,
    latitude: 9,
    longitude: 80
  },
  {
    code: 'tat',
    name: 'Tatar',
    bcp47: 'tt',
    ohchr: 'ttr',
    iso6393: 'tat',
    direction: 'ltr',
    stage: 4,
    latitude: 55,
    longitude: 50
  },
  {
    code: 'tbz',
    name: 'Ditammari',
    bcp47: 'tbz',
    ohchr: 'tbz',
    iso6393: 'tbz',
    direction: 'ltr',
    stage: 4,
    latitude: 10.16,
    longitude: 1.18
  },
  {
    code: 'tca',
    name: 'Ticuna',
    bcp47: 'tca',
    ohchr: 'tca',
    iso6393: 'tca',
    direction: 'ltr',
    stage: 4,
    latitude: -3.66,
    longitude: -69.87
  },
  {
    code: 'tel',
    name: 'Telugu',
    bcp47: 'te',
    ohchr: 'tcw',
    iso6393: 'tel',
    direction: 'ltr',
    stage: 4,
    latitude: 16.45,
    longitude: 78.7
  },
  {
    code: 'tem',
    name: 'Themne',
    bcp47: 'tem',
    ohchr: 'tej',
    iso6393: 'tem',
    direction: 'ltr',
    stage: 4,
    latitude: 8.9,
    longitude: -12.33
  },
  {
    code: 'tet',
    name: 'Tetun',
    bcp47: 'tet',
    ohchr: 'ttm',
    iso6393: 'tet',
    direction: 'ltr',
    stage: 4,
    latitude: -9.11,
    longitude: 125.53
  },
  {
    code: 'tgk',
    name: 'Tajiki',
    bcp47: 'tg',
    ohchr: 'pet',
    iso6393: 'tgk',
    direction: 'ltr',
    stage: 4,
    latitude: 38.82,
    longitude: 68.55
  },
  {
    code: 'tgl',
    name: 'Tagalog',
    bcp47: 'tl',
    ohchr: 'tgl',
    iso6393: 'tgl',
    direction: 'ltr',
    stage: 4,
    latitude: 14.06,
    longitude: 121.75
  },
  {
    code: 'tgl_tglg',
    name: 'Tagalog (Tagalog)',
    bcp47: 'tl-Tglg',
    ohchr: null,
    iso6393: 'tgl',
    direction: 'ltr',
    stage: 1,
    latitude: 14.06,
    longitude: 121.75
  },
  {
    code: 'tha',
    name: 'Thai',
    bcp47: 'th',
    ohchr: 'thj',
    iso6393: 'tha',
    direction: 'ltr',
    stage: 4,
    latitude: 14.19,
    longitude: 100.67
  },
  {
    code: 'tha2',
    name: 'Thai (2)',
    bcp47: 'th',
    ohchr: null,
    iso6393: 'tha',
    direction: 'ltr',
    stage: 4,
    latitude: 14.19,
    longitude: 100.67
  },
  {
    code: 'tir',
    name: 'Tigrigna',
    bcp47: 'ti',
    ohchr: 'tgn',
    iso6393: 'tir',
    direction: 'ltr',
    stage: 4,
    latitude: 15.34,
    longitude: 38.93
  },
  {
    code: 'tiv',
    name: 'Tiv',
    bcp47: 'tiv',
    ohchr: 'tiv',
    iso6393: 'tiv',
    direction: 'ltr',
    stage: 4,
    latitude: 6.88,
    longitude: 9.26
  },
  {
    code: 'tly',
    name: 'Talysh',
    bcp47: 'tly',
    ohchr: 'tly',
    iso6393: 'tly',
    direction: 'ltr',
    stage: 4,
    latitude: 38.46,
    longitude: 48.63
  },
  {
    code: 'tob',
    name: 'Toba',
    bcp47: 'tob',
    ohchr: 'tob',
    iso6393: 'tob',
    direction: 'ltr',
    stage: 4,
    latitude: -24.4,
    longitude: -60.45
  },
  {
    code: 'toi',
    name: 'Tonga',
    bcp47: 'toi',
    ohchr: 'toi',
    iso6393: 'toi',
    direction: 'ltr',
    stage: 4,
    latitude: -17.42,
    longitude: 27.1
  },
  {
    code: 'toj',
    name: 'Tojolabal',
    bcp47: 'toj',
    ohchr: 'toj',
    iso6393: 'toj',
    direction: 'ltr',
    stage: 4,
    latitude: 16.26,
    longitude: -91.78
  },
  {
    code: 'ton',
    name: 'Tongan',
    bcp47: 'to',
    ohchr: 'tov',
    iso6393: 'ton',
    direction: 'ltr',
    stage: 4,
    latitude: -21.17,
    longitude: -175.25
  },
  {
    code: 'top',
    name: 'Totonac, Papantla',
    bcp47: 'top',
    ohchr: 'top',
    iso6393: 'top',
    direction: 'ltr',
    stage: 4,
    latitude: 20.57,
    longitude: -97.26
  },
  {
    code: 'tpi',
    name: 'Tok Pisin',
    bcp47: 'tpi',
    ohchr: 'pdg',
    iso6393: 'tpi',
    direction: 'ltr',
    stage: 4,
    latitude: -9.42,
    longitude: 147.3
  },
  {
    code: 'tsn',
    name: 'Tswana',
    bcp47: 'tn',
    ohchr: 'tsw',
    iso6393: 'tsn',
    direction: 'ltr',
    stage: 4,
    latitude: -24.37,
    longitude: 24.76
  },
  {
    code: 'tso_MZ',
    name: 'Tsonga (Mozambique)',
    bcp47: 'ts',
    ohchr: 'tso',
    iso6393: 'tso',
    direction: 'ltr',
    stage: 4,
    latitude: -23.58,
    longitude: 31.81
  },
  {
    code: 'tso_ZW',
    name: 'Tsonga (Zimbabwe)',
    bcp47: 'ts',
    ohchr: 'tso1',
    iso6393: 'tso',
    direction: 'ltr',
    stage: 4,
    latitude: -23.58,
    longitude: 31.81
  },
  {
    code: 'tsz',
    name: 'Purepecha',
    bcp47: 'tsz',
    ohchr: '1112',
    iso6393: 'tsz',
    direction: 'ltr',
    stage: 4,
    latitude: 19.25,
    longitude: -101.63
  },
  {
    code: 'tuk_cyrl',
    name: 'Turkmen (Cyrillic)',
    bcp47: 'tk-Cyrl',
    ohchr: 'tck',
    iso6393: 'tuk',
    direction: 'ltr',
    stage: 4,
    latitude: 37.09,
    longitude: 59.18
  },
  {
    code: 'tuk_latn',
    name: 'Turkmen (Latin)',
    bcp47: 'tk-Latn',
    ohchr: null,
    iso6393: 'tuk',
    direction: 'ltr',
    stage: 4,
    latitude: 37.09,
    longitude: 59.18
  },
  {
    code: 'tur',
    name: 'Turkish',
    bcp47: 'tr',
    ohchr: 'trk',
    iso6393: 'tur',
    direction: 'ltr',
    stage: 4,
    latitude: 39.87,
    longitude: 32.87
  },
  {
    code: 'tyv',
    name: 'Tuva',
    bcp47: 'tyv',
    ohchr: 'tyv',
    iso6393: 'tyv',
    direction: 'ltr',
    stage: 4,
    latitude: 48.44,
    longitude: 92.67
  },
  {
    code: 'tzc',
    name: 'Tzotzil (Chamula)',
    bcp47: 'tzo',
    ohchr: 'tzc',
    iso6393: 'tzo',
    direction: 'ltr',
    stage: 4,
    latitude: 16.64,
    longitude: -92.74
  },
  {
    code: 'tzh',
    name: 'Tzeltal, Oxchuc',
    bcp47: 'tzh',
    ohchr: 'tzc1',
    iso6393: 'tzh',
    direction: 'ltr',
    stage: 4,
    latitude: 16.64,
    longitude: -92.28
  },
  {
    code: 'tzm',
    name: 'Tamazight, Central Atlas',
    bcp47: 'tzm',
    ohchr: 'tzm',
    iso6393: 'tzm',
    direction: 'ltr',
    stage: 4,
    latitude: 32.74,
    longitude: -2.41
  },
  {
    code: 'tzm_tfng',
    name: 'Tamazight, Central Atlas (Tifinagh)',
    bcp47: 'tzm-Tfng',
    ohchr: null,
    iso6393: 'tzm',
    direction: 'ltr',
    stage: 1,
    latitude: 32.74,
    longitude: -2.41
  },
  {
    code: 'uig_arab',
    name: 'Uyghur (Arabic)',
    bcp47: 'ug-Arab',
    ohchr: 'uig',
    iso6393: 'uig',
    direction: 'rtl',
    stage: 4,
    latitude: 43.67,
    longitude: 79.75
  },
  {
    code: 'uig_latn',
    name: 'Uyghur (Latin)',
    bcp47: 'ug-Latn',
    ohchr: null,
    iso6393: 'uig',
    direction: 'ltr',
    stage: 4,
    latitude: 43.67,
    longitude: 79.75
  },
  {
    code: 'ukr',
    name: 'Ukrainian',
    bcp47: 'uk',
    ohchr: 'ukr',
    iso6393: 'ukr',
    direction: 'ltr',
    stage: 4,
    latitude: 48.18,
    longitude: 24.4
  },
  {
    code: 'umb',
    name: 'Umbundu',
    bcp47: 'umb',
    ohchr: 'mnf',
    iso6393: 'umb',
    direction: 'ltr',
    stage: 4,
    latitude: -12.48,
    longitude: 14.41
  },
  {
    code: 'ura',
    name: 'Urarina',
    bcp47: 'ura',
    ohchr: 'ura',
    iso6393: 'ura',
    direction: 'ltr',
    stage: 4,
    latitude: -4.44,
    longitude: -75.42
  },
  {
    code: 'urd',
    name: 'Urdu',
    bcp47: 'ur',
    ohchr: 'urd',
    iso6393: 'urd',
    direction: 'rtl',
    stage: 4,
    latitude: 25,
    longitude: 67
  },
  {
    code: 'urd_2',
    name: 'Urdu (2)',
    bcp47: 'ur',
    ohchr: 'urd',
    iso6393: 'urd',
    direction: 'rtl',
    stage: 4,
    latitude: 25,
    longitude: 67
  },
  {
    code: 'uzn_cyrl',
    name: 'Uzbek, Northern (Cyrillic)',
    bcp47: 'uz-Cyrl',
    ohchr: 'uzb1',
    iso6393: 'uzn',
    direction: 'ltr',
    stage: 4,
    latitude: 43.75,
    longitude: 59.23
  },
  {
    code: 'uzn_latn',
    name: 'Uzbek, Northern (Latin)',
    bcp47: 'uz-Latn',
    ohchr: 'uzb',
    iso6393: 'uzn',
    direction: 'ltr',
    stage: 4,
    latitude: 43.75,
    longitude: 59.23
  },
  {
    code: 'vai',
    name: 'Vai',
    bcp47: 'vai',
    ohchr: 'vai',
    iso6393: 'vai',
    direction: 'ltr',
    stage: 4,
    latitude: 7.05,
    longitude: -11.33
  },
  {
    code: 'vec',
    name: 'Venetian',
    bcp47: 'vec',
    ohchr: 'vec',
    iso6393: 'vec',
    direction: 'ltr',
    stage: 4,
    latitude: 45.41,
    longitude: 13.03
  },
  {
    code: 'ven',
    name: 'Venda',
    bcp47: 've',
    ohchr: 'tsh',
    iso6393: 'ven',
    direction: 'ltr',
    stage: 4,
    latitude: -22.19,
    longitude: 29.95
  },
  {
    code: 'ven2',
    name: 'Venda',
    bcp47: 've',
    ohchr: 'ven',
    iso6393: 'ven',
    direction: 'ltr',
    stage: 4,
    latitude: -22.19,
    longitude: 29.95
  },
  {
    code: 'vep',
    name: 'Veps',
    bcp47: 'vep',
    ohchr: 'vep',
    iso6393: 'vep',
    direction: 'ltr',
    stage: 4,
    latitude: 60.34,
    longitude: 34.79
  },
  {
    code: 'vie',
    name: 'Vietnamese',
    bcp47: 'vi',
    ohchr: 'vie',
    iso6393: 'vie',
    direction: 'ltr',
    stage: 4,
    latitude: 18.39,
    longitude: 106.76
  },
  {
    code: 'vie_han',
    name: 'Vietnamese (Han nom)',
    bcp47: 'vi-Hani',
    ohchr: null,
    iso6393: 'vie',
    direction: 'ltr',
    stage: 4,
    latitude: 18.39,
    longitude: 106.76
  },
  {
    code: 'vmw',
    name: 'Makhuwa',
    bcp47: 'vmw',
    ohchr: 'vmw',
    iso6393: 'vmw',
    direction: 'ltr',
    stage: 4,
    latitude: -14.85,
    longitude: 38.81
  },
  {
    code: 'war',
    name: 'Waray-Waray',
    bcp47: 'war',
    ohchr: 'wry',
    iso6393: 'war',
    direction: 'ltr',
    stage: 4,
    latitude: 11.49,
    longitude: 125.01
  },
  {
    code: 'wln',
    name: 'Walloon',
    bcp47: 'wa',
    ohchr: 'frn1',
    iso6393: 'wln',
    direction: 'ltr',
    stage: 4,
    latitude: 50.22,
    longitude: 5.15
  },
  {
    code: 'wol',
    name: 'Wolof',
    bcp47: 'wo',
    ohchr: 'wol',
    iso6393: 'wol',
    direction: 'ltr',
    stage: 4,
    latitude: 15.25,
    longitude: -15.38
  },
  {
    code: 'wuu',
    name: 'Chinese, Wu',
    bcp47: 'wuu',
    ohchr: 'wuu',
    iso6393: 'wuu',
    direction: 'ltr',
    stage: 4,
    latitude: 31.23,
    longitude: 121.47
  },
  {
    code: 'wwa',
    name: 'Waama',
    bcp47: 'wwa',
    ohchr: 'ako',
    iso6393: 'wwa',
    direction: 'ltr',
    stage: 4,
    latitude: 10.6,
    longitude: 1.65
  },
  {
    code: 'xho',
    name: 'Xhosa',
    bcp47: 'xh',
    ohchr: 'xos',
    iso6393: 'xho',
    direction: 'ltr',
    stage: 4,
    latitude: -31.04,
    longitude: 28.08
  },
  {
    code: 'xsm',
    name: 'Kasem',
    bcp47: 'xsm',
    ohchr: 'kas',
    iso6393: 'xsm',
    direction: 'ltr',
    stage: 4,
    latitude: 11.08,
    longitude: -1.39
  },
  {
    code: 'yad',
    name: 'Yagua',
    bcp47: 'yad',
    ohchr: 'yad',
    iso6393: 'yad',
    direction: 'ltr',
    stage: 4,
    latitude: -3.43,
    longitude: -72.22
  },
  {
    code: 'yao',
    name: 'Yao',
    bcp47: 'yao',
    ohchr: 'yao',
    iso6393: 'yao',
    direction: 'ltr',
    stage: 4,
    latitude: -13.61,
    longitude: 35.24
  },
  {
    code: 'yap',
    name: 'Yapese',
    bcp47: 'yap',
    ohchr: 'yps',
    iso6393: 'yap',
    direction: 'ltr',
    stage: 4,
    latitude: 9.56,
    longitude: 138.12
  },
  {
    code: 'ydd',
    name: 'Yiddish, Eastern',
    bcp47: 'yi',
    ohchr: 'ydd',
    iso6393: 'ydd',
    direction: 'rtl',
    stage: 4,
    latitude: 51.75,
    longitude: 19.42
  },
  {
    code: 'ykg',
    name: 'Yukaghir, Northern',
    bcp47: 'ykg',
    ohchr: 'ykg',
    iso6393: 'ykg',
    direction: 'ltr',
    stage: 4,
    latitude: 65.39,
    longitude: 151.32
  },
  {
    code: 'yor',
    name: 'Yoruba',
    bcp47: 'yo',
    ohchr: 'yor',
    iso6393: 'yor',
    direction: 'ltr',
    stage: 4,
    latitude: 7.15,
    longitude: 3.67
  },
  {
    code: 'yua',
    name: 'Maya, Yucatán',
    bcp47: 'yua',
    ohchr: 'yua',
    iso6393: 'yua',
    direction: 'ltr',
    stage: 4,
    latitude: 18.78,
    longitude: -88.96
  },
  {
    code: 'yue',
    name: 'Chinese, Yue',
    bcp47: 'yue',
    ohchr: 'yue',
    iso6393: 'yue',
    direction: 'ltr',
    stage: 4,
    latitude: 31.13,
    longitude: 121.29
  },
  {
    code: 'zam',
    name: 'Zapotec, Miahuatlán',
    bcp47: 'zam',
    ohchr: 'zam',
    iso6393: 'zam',
    direction: 'ltr',
    stage: 4,
    latitude: 16.22,
    longitude: -96.66
  },
  {
    code: 'zdj',
    name: 'Comorian, Ngazidja',
    bcp47: 'zdj',
    ohchr: 'zdj',
    iso6393: 'zdj',
    direction: 'ltr',
    stage: 4,
    latitude: -12,
    longitude: 44
  },
  {
    code: 'zgh',
    name: 'Tamazight, Standard Morocan',
    bcp47: 'zgh',
    ohchr: 'ama',
    iso6393: 'zgh',
    direction: 'ltr',
    stage: 4,
    latitude: 14.2,
    longitude: -2.41
  },
  {
    code: 'zro',
    name: 'Záparo',
    bcp47: 'zro',
    ohchr: '1124',
    iso6393: 'zro',
    direction: 'ltr',
    stage: 4,
    latitude: -2,
    longitude: -76.36
  },
  {
    code: 'ztu',
    name: 'Zapotec, Güilá',
    bcp47: 'ztu',
    ohchr: 'ztu1',
    iso6393: 'ztu',
    direction: 'ltr',
    stage: 4,
    latitude: 16.88,
    longitude: -96.46
  },
  {
    code: 'zul',
    name: 'Zulu',
    bcp47: 'zu',
    ohchr: 'zuu',
    iso6393: 'zul',
    direction: 'ltr',
    stage: 4,
    latitude: -25.33,
    longitude: 31.35
  }
]
