-- This file is part of the Wire Server implementation.
--
-- Copyright (C) 2022 Wire Swiss GmbH <opensource@wire.com>
--
-- This program is free software: you can redistribute it and/or modify it under
-- the terms of the GNU Affero General Public License as published by the Free
-- Software Foundation, either version 3 of the License, or (at your option) any
-- later version.
--
-- This program is distributed in the hope that it will be useful, but WITHOUT
-- ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
-- FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
-- details.
--
-- You should have received a copy of the GNU Affero General Public License along
-- with this program. If not, see <https://www.gnu.org/licenses/>.

module Galley.Effects
  ( -- * Effects needed in Galley
    GalleyEffects1,

    -- * Effects to access the Intra API
    BrigAPIAccess,
    FederationAPIAccess,
    SparAPIAccess,

    -- * External services
    ExternalAccess,

    -- * Fire-and-forget async
    FireAndForget,

    -- * Store effects
    ClientStore,
    CodeStore,
    ConversationStore,
    CustomBackendStore,
    LegalHoldStore,
    ProposalStore,
    SearchVisibilityStore,
    ServiceStore,
    Random,
    TeamFeatureStore,
    TeamMemberStore,
    TeamNotificationStore,
    TeamStore,

    -- * Paging effects
    ListItems,

    -- * Other effects
    Queue,

    -- * Polysemy re-exports
    Member,
    Members,

    -- * Queueing effects
    BackendNotificationQueueAccess,
  )
where

import Data.Id
import Data.Qualified
import Galley.Effects.ClientStore
import Galley.Effects.CodeStore
import Galley.Effects.CustomBackendStore
import Galley.Effects.Queue
import Galley.Effects.SearchVisibilityStore
import Galley.Effects.TeamFeatureStore
import Galley.Effects.TeamMemberStore
import Galley.Effects.TeamNotificationStore
import Galley.Env
import Galley.Options
import Galley.Types.Teams
import Polysemy
import Polysemy.Error
import Polysemy.Input
import Wire.API.Error
import Wire.API.Error.Galley
import Wire.API.Federation.Client
import Wire.API.Team.Feature
import Wire.BackendNotificationQueueAccess
import Wire.BrigAPIAccess
import Wire.ConversationStore (ConversationStore, MLSCommitLockStore)
import Wire.ConversationSubsystem
import Wire.ExternalAccess
import Wire.FederationAPIAccess
import Wire.FireAndForget
import Wire.GundeckAPIAccess
import Wire.HashPassword
import Wire.LegalHoldStore
import Wire.LegalHoldStore.Env (LegalHoldEnv)
import Wire.ListItems
import Wire.NotificationSubsystem
import Wire.ProposalStore
import Wire.RateLimit
import Wire.Rpc
import Wire.Sem.Now
import Wire.Sem.Paging.Cassandra
import Wire.Sem.Random
import Wire.ServiceStore
import Wire.SparAPIAccess
import Wire.TeamCollaboratorsStore (TeamCollaboratorsStore)
import Wire.TeamCollaboratorsSubsystem (TeamCollaboratorsSubsystem)
import Wire.TeamJournal (TeamJournal)
import Wire.TeamStore
import Wire.TeamSubsystem (TeamSubsystem)
import Wire.UserGroupStore

-- All the possible high-level effects.
type GalleyEffects1 =
  '[ TeamCollaboratorsSubsystem,
     ConversationSubsystem,
     TeamSubsystem,
     SparAPIAccess,
     NotificationSubsystem,
     ExternalAccess,
     BrigAPIAccess,
     GundeckAPIAccess,
     Rpc,
     FederationAPIAccess FederatorClient,
     BackendNotificationQueueAccess,
     FireAndForget,
     TeamCollaboratorsStore,
     ClientStore,
     CodeStore,
     ProposalStore,
     RateLimit,
     HashPassword,
     Random,
     CustomBackendStore,
     SearchVisibilityStore,
     TeamStore,
     TeamJournal,
     LegalHoldStore,
     Input LegalHoldEnv,
     UserGroupStore,
     ServiceStore,
     TeamNotificationStore,
     ConversationStore,
     MLSCommitLockStore,
     TeamFeatureStore,
     TeamMemberStore InternalPaging,
     TeamMemberStore CassandraPaging,
     ListItems LegacyPaging TeamId,
     ListItems InternalPaging TeamId,
     Input FanoutLimit,
     Input AllTeamFeatures,
     Input (FeatureDefaults LegalholdConfig),
     Input (Local ()),
     Input Opts,
     Now,
     Queue DeleteItem,
     Error DynError,
     Error RateLimitExceeded,
     ErrorS OperationDenied,
     ErrorS 'NotATeamMember
   ]
