-- This file is part of the Wire Server implementation.
--
-- Copyright (C) 2022 Wire Swiss GmbH <opensource@wire.com>
--
-- This program is free software: you can redistribute it and/or modify it under
-- the terms of the GNU Affero General Public License as published by the Free
-- Software Foundation, either version 3 of the License, or (at your option) any
-- later version.
--
-- This program is distributed in the hope that it will be useful, but WITHOUT
-- ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
-- FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
-- details.
--
-- You should have received a copy of the GNU Affero General Public License along
-- with this program. If not, see <https://www.gnu.org/licenses/>.

module Test.Wire.API.Golden.Generated.VerifyDeleteUser_user where

import Data.Code (Key (Key, asciiKey), Value (Value, asciiValue))
import Data.Range (unsafeRange)
import Data.Text.Ascii (AsciiChars (validate))
import Imports (fromRight, undefined)
import Wire.API.User (VerifyDeleteUser (..))

testObject_VerifyDeleteUser_user_1 :: VerifyDeleteUser
testObject_VerifyDeleteUser_user_1 =
  VerifyDeleteUser
    { verifyDeleteUserKey = Key {asciiKey = unsafeRange (fromRight undefined (validate "Zd0E7PAbtX63Snj90YXv"))},
      verifyDeleteUserCode = Value {asciiValue = unsafeRange (fromRight undefined (validate "5rfJK3iplxf"))}
    }

testObject_VerifyDeleteUser_user_2 :: VerifyDeleteUser
testObject_VerifyDeleteUser_user_2 =
  VerifyDeleteUser
    { verifyDeleteUserKey = Key {asciiKey = unsafeRange (fromRight undefined (validate "s48e7_P53jCRq78HcwiU"))},
      verifyDeleteUserCode =
        Value {asciiValue = unsafeRange (fromRight undefined (validate "e1l63AUTj8r9-V-UPzdg"))}
    }

testObject_VerifyDeleteUser_user_3 :: VerifyDeleteUser
testObject_VerifyDeleteUser_user_3 =
  VerifyDeleteUser
    { verifyDeleteUserKey = Key {asciiKey = unsafeRange (fromRight undefined (validate "b0y=TFQAfoE_RZq574Z2"))},
      verifyDeleteUserCode = Value {asciiValue = unsafeRange (fromRight undefined (validate "ZsSbzICF1f6rqrpIt"))}
    }

testObject_VerifyDeleteUser_user_4 :: VerifyDeleteUser
testObject_VerifyDeleteUser_user_4 =
  VerifyDeleteUser
    { verifyDeleteUserKey = Key {asciiKey = unsafeRange (fromRight undefined (validate "GoiC6j6NhdBWPKinvc6j"))},
      verifyDeleteUserCode =
        Value {asciiValue = unsafeRange (fromRight undefined (validate "Vg_NWfbdvJ8xl56YWAD"))}
    }

testObject_VerifyDeleteUser_user_5 :: VerifyDeleteUser
testObject_VerifyDeleteUser_user_5 =
  VerifyDeleteUser
    { verifyDeleteUserKey = Key {asciiKey = unsafeRange (fromRight undefined (validate "VZleCLl8lhKpijYBZQxp"))},
      verifyDeleteUserCode = Value {asciiValue = unsafeRange (fromRight undefined (validate "eAGAd=kP"))}
    }

testObject_VerifyDeleteUser_user_6 :: VerifyDeleteUser
testObject_VerifyDeleteUser_user_6 =
  VerifyDeleteUser
    { verifyDeleteUserKey = Key {asciiKey = unsafeRange (fromRight undefined (validate "1m6Idt-8Z5xWCZCUnI2H"))},
      verifyDeleteUserCode = Value {asciiValue = unsafeRange (fromRight undefined (validate "s8pkN3EAVU"))}
    }

testObject_VerifyDeleteUser_user_7 :: VerifyDeleteUser
testObject_VerifyDeleteUser_user_7 =
  VerifyDeleteUser
    { verifyDeleteUserKey = Key {asciiKey = unsafeRange (fromRight undefined (validate "GUyhsrPHJX3kUsIRwl7o"))},
      verifyDeleteUserCode = Value {asciiValue = unsafeRange (fromRight undefined (validate "xbSGHeEI6Mlp"))}
    }

testObject_VerifyDeleteUser_user_8 :: VerifyDeleteUser
testObject_VerifyDeleteUser_user_8 =
  VerifyDeleteUser
    { verifyDeleteUserKey = Key {asciiKey = unsafeRange (fromRight undefined (validate "aREjT9kV_k3n28smib=q"))},
      verifyDeleteUserCode = Value {asciiValue = unsafeRange (fromRight undefined (validate "4XaaX1lunI0SVIdQF"))}
    }

testObject_VerifyDeleteUser_user_9 :: VerifyDeleteUser
testObject_VerifyDeleteUser_user_9 =
  VerifyDeleteUser
    { verifyDeleteUserKey = Key {asciiKey = unsafeRange (fromRight undefined (validate "ZTAxgwL1puDBVlJm7ISB"))},
      verifyDeleteUserCode = Value {asciiValue = unsafeRange (fromRight undefined (validate "_O8MZmb7koe=-HHfv"))}
    }

testObject_VerifyDeleteUser_user_10 :: VerifyDeleteUser
testObject_VerifyDeleteUser_user_10 =
  VerifyDeleteUser
    { verifyDeleteUserKey = Key {asciiKey = unsafeRange (fromRight undefined (validate "iOznLTQU0YCvP-PFJVnw"))},
      verifyDeleteUserCode = Value {asciiValue = unsafeRange (fromRight undefined (validate "5e6hcZ"))}
    }

testObject_VerifyDeleteUser_user_11 :: VerifyDeleteUser
testObject_VerifyDeleteUser_user_11 =
  VerifyDeleteUser
    { verifyDeleteUserKey = Key {asciiKey = unsafeRange (fromRight undefined (validate "ITPDRKuIM0E9TCUWuMc4"))},
      verifyDeleteUserCode = Value {asciiValue = unsafeRange (fromRight undefined (validate "GnTV8MhtczPmB"))}
    }

testObject_VerifyDeleteUser_user_12 :: VerifyDeleteUser
testObject_VerifyDeleteUser_user_12 =
  VerifyDeleteUser
    { verifyDeleteUserKey = Key {asciiKey = unsafeRange (fromRight undefined (validate "JgyOMcGrMkAp=P6gCC42"))},
      verifyDeleteUserCode = Value {asciiValue = unsafeRange (fromRight undefined (validate "r1AjgtYIwq4bJede"))}
    }

testObject_VerifyDeleteUser_user_13 :: VerifyDeleteUser
testObject_VerifyDeleteUser_user_13 =
  VerifyDeleteUser
    { verifyDeleteUserKey = Key {asciiKey = unsafeRange (fromRight undefined (validate "H=577C1Rz4bi6FTP3Fsu"))},
      verifyDeleteUserCode =
        Value {asciiValue = unsafeRange (fromRight undefined (validate "NycA_22ZMY9yEpug7jrb"))}
    }

testObject_VerifyDeleteUser_user_14 :: VerifyDeleteUser
testObject_VerifyDeleteUser_user_14 =
  VerifyDeleteUser
    { verifyDeleteUserKey = Key {asciiKey = unsafeRange (fromRight undefined (validate "WVR7aRLpUPokwVqUNvO="))},
      verifyDeleteUserCode =
        Value {asciiValue = unsafeRange (fromRight undefined (validate "x1YQXKDCBOhXSIlv4TM"))}
    }

testObject_VerifyDeleteUser_user_15 :: VerifyDeleteUser
testObject_VerifyDeleteUser_user_15 =
  VerifyDeleteUser
    { verifyDeleteUserKey = Key {asciiKey = unsafeRange (fromRight undefined (validate "7NsqcSFb1haHGW3T6afk"))},
      verifyDeleteUserCode =
        Value {asciiValue = unsafeRange (fromRight undefined (validate "pNUQx7xtswWQZDKus3"))}
    }

testObject_VerifyDeleteUser_user_16 :: VerifyDeleteUser
testObject_VerifyDeleteUser_user_16 =
  VerifyDeleteUser
    { verifyDeleteUserKey = Key {asciiKey = unsafeRange (fromRight undefined (validate "pIRiVnNmSyYIPoPWw-Ge"))},
      verifyDeleteUserCode = Value {asciiValue = unsafeRange (fromRight undefined (validate "mBaXfRCP5pcBl"))}
    }

testObject_VerifyDeleteUser_user_17 :: VerifyDeleteUser
testObject_VerifyDeleteUser_user_17 =
  VerifyDeleteUser
    { verifyDeleteUserKey = Key {asciiKey = unsafeRange (fromRight undefined (validate "-wW78mNmAvg=ObKVCxhP"))},
      verifyDeleteUserCode = Value {asciiValue = unsafeRange (fromRight undefined (validate "YkGMHpzkep3_VBz"))}
    }

testObject_VerifyDeleteUser_user_18 :: VerifyDeleteUser
testObject_VerifyDeleteUser_user_18 =
  VerifyDeleteUser
    { verifyDeleteUserKey = Key {asciiKey = unsafeRange (fromRight undefined (validate "V_w1B5J=5XdUk5d9nGYg"))},
      verifyDeleteUserCode = Value {asciiValue = unsafeRange (fromRight undefined (validate "WX-UIuIp17ybHeyx"))}
    }

testObject_VerifyDeleteUser_user_19 :: VerifyDeleteUser
testObject_VerifyDeleteUser_user_19 =
  VerifyDeleteUser
    { verifyDeleteUserKey = Key {asciiKey = unsafeRange (fromRight undefined (validate "EfdiPJ-CCnEoldV-yqdD"))},
      verifyDeleteUserCode = Value {asciiValue = unsafeRange (fromRight undefined (validate "op_PNw4M"))}
    }

testObject_VerifyDeleteUser_user_20 :: VerifyDeleteUser
testObject_VerifyDeleteUser_user_20 =
  VerifyDeleteUser
    { verifyDeleteUserKey = Key {asciiKey = unsafeRange (fromRight undefined (validate "KD9ei9WvBc9rlzpFS7If"))},
      verifyDeleteUserCode = Value {asciiValue = unsafeRange (fromRight undefined (validate "kdbu6kPH"))}
    }
