-- This file is part of the Wire Server implementation.
--
-- Copyright (C) 2022 Wire Swiss GmbH <opensource@wire.com>
--
-- This program is free software: you can redistribute it and/or modify it under
-- the terms of the GNU Affero General Public License as published by the Free
-- Software Foundation, either version 3 of the License, or (at your option) any
-- later version.
--
-- This program is distributed in the hope that it will be useful, but WITHOUT
-- ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
-- FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
-- details.
--
-- You should have received a copy of the GNU Affero General Public License along
-- with this program. If not, see <https://www.gnu.org/licenses/>.

module Test.Wire.API.Golden.Generated.UserHandleInfo_user where

import Data.Domain (Domain (Domain, _domainText))
import Data.Id (Id (Id))
import Data.Qualified (Qualified (Qualified, qDomain, qUnqualified))
import Data.UUID qualified as UUID (fromString)
import Imports (fromJust)
import Wire.API.User.Handle (UserHandleInfo (..))

testObject_UserHandleInfo_user_1 :: UserHandleInfo
testObject_UserHandleInfo_user_1 =
  UserHandleInfo
    { userHandleId =
        Qualified
          { qUnqualified = Id (fromJust (UUID.fromString "00006bd9-0000-61c8-0000-35df0000024b")),
            qDomain = Domain {_domainText = "1a87.k2y7pp"}
          }
    }

testObject_UserHandleInfo_user_2 :: UserHandleInfo
testObject_UserHandleInfo_user_2 =
  UserHandleInfo
    { userHandleId =
        Qualified
          { qUnqualified = Id (fromJust (UUID.fromString "00007b9d-0000-35b1-0000-795e00002e78")),
            qDomain = Domain {_domainText = "862ey.zjv-41"}
          }
    }

testObject_UserHandleInfo_user_3 :: UserHandleInfo
testObject_UserHandleInfo_user_3 =
  UserHandleInfo
    { userHandleId =
        Qualified
          { qUnqualified = Id (fromJust (UUID.fromString "0000292f-0000-6f63-0000-6052000045db")),
            qDomain = Domain {_domainText = "5-75.s-4.pp-a70873"}
          }
    }

testObject_UserHandleInfo_user_4 :: UserHandleInfo
testObject_UserHandleInfo_user_4 =
  UserHandleInfo
    { userHandleId =
        Qualified
          { qUnqualified = Id (fromJust (UUID.fromString "00002211-0000-5060-0000-5c0600002885")),
            qDomain = Domain {_domainText = "r30.mb4-u"}
          }
    }

testObject_UserHandleInfo_user_5 :: UserHandleInfo
testObject_UserHandleInfo_user_5 =
  UserHandleInfo
    { userHandleId =
        Qualified
          { qUnqualified = Id (fromJust (UUID.fromString "00005168-0000-1fc2-0000-2e8e00001b48")),
            qDomain = Domain {_domainText = "3iq.1g04h.a15.0l.r"}
          }
    }

testObject_UserHandleInfo_user_6 :: UserHandleInfo
testObject_UserHandleInfo_user_6 =
  UserHandleInfo
    { userHandleId =
        Qualified
          { qUnqualified = Id (fromJust (UUID.fromString "00001e1f-0000-5ed2-0000-276700007eb0")),
            qDomain = Domain {_domainText = "d0x--x8.0qv.2.2og1.b5zsc4.x-t"}
          }
    }

testObject_UserHandleInfo_user_7 :: UserHandleInfo
testObject_UserHandleInfo_user_7 =
  UserHandleInfo
    { userHandleId =
        Qualified
          { qUnqualified = Id (fromJust (UUID.fromString "00004c44-0000-084d-0000-700400006fbf")),
            qDomain = Domain {_domainText = "18-y.8-37.084.m"}
          }
    }

testObject_UserHandleInfo_user_8 :: UserHandleInfo
testObject_UserHandleInfo_user_8 =
  UserHandleInfo
    { userHandleId =
        Qualified
          { qUnqualified = Id (fromJust (UUID.fromString "00005af3-0000-7015-0000-0c6c00006a00")),
            qDomain = Domain {_domainText = "333u--53.b-l.8-6j57m.t-7u"}
          }
    }

testObject_UserHandleInfo_user_9 :: UserHandleInfo
testObject_UserHandleInfo_user_9 =
  UserHandleInfo
    { userHandleId =
        Qualified
          { qUnqualified = Id (fromJust (UUID.fromString "000034cd-0000-0a58-0000-48f90000595b")),
            qDomain = Domain {_domainText = "0.4-h.736.4.5c0y27-ii.y5wn4r1i906ch-he.5q5h.t92"}
          }
    }

testObject_UserHandleInfo_user_10 :: UserHandleInfo
testObject_UserHandleInfo_user_10 =
  UserHandleInfo
    { userHandleId =
        Qualified
          { qUnqualified = Id (fromJust (UUID.fromString "00001ac9-0000-4979-0000-23bf00007d42")),
            qDomain = Domain {_domainText = "5-t4.zo1"}
          }
    }

testObject_UserHandleInfo_user_11 :: UserHandleInfo
testObject_UserHandleInfo_user_11 =
  UserHandleInfo
    { userHandleId =
        Qualified
          { qUnqualified = Id (fromJust (UUID.fromString "00002afa-0000-5c37-0000-154b00003fb6")),
            qDomain = Domain {_domainText = "d.w7wyx-u23"}
          }
    }

testObject_UserHandleInfo_user_12 :: UserHandleInfo
testObject_UserHandleInfo_user_12 =
  UserHandleInfo
    { userHandleId =
        Qualified
          { qUnqualified = Id (fromJust (UUID.fromString "0000247e-0000-06f0-0000-5c5800000177")),
            qDomain = Domain {_domainText = "1gcz-c391mp-w.x7h.r"}
          }
    }

testObject_UserHandleInfo_user_13 :: UserHandleInfo
testObject_UserHandleInfo_user_13 =
  UserHandleInfo
    { userHandleId =
        Qualified
          { qUnqualified = Id (fromJust (UUID.fromString "00006ccd-0000-1a2e-0000-343d00004647")),
            qDomain = Domain {_domainText = "wg.a"}
          }
    }

testObject_UserHandleInfo_user_14 :: UserHandleInfo
testObject_UserHandleInfo_user_14 =
  UserHandleInfo
    { userHandleId =
        Qualified
          { qUnqualified = Id (fromJust (UUID.fromString "0000135c-0000-4c2e-0000-19f4000008f2")),
            qDomain = Domain {_domainText = "u93dcsebe5-y.05sbzviq.z"}
          }
    }

testObject_UserHandleInfo_user_15 :: UserHandleInfo
testObject_UserHandleInfo_user_15 =
  UserHandleInfo
    { userHandleId =
        Qualified
          { qUnqualified = Id (fromJust (UUID.fromString "0000746b-0000-2892-0000-1fa70000195a")),
            qDomain = Domain {_domainText = "c.33--y.07fz8y.w5"}
          }
    }

testObject_UserHandleInfo_user_16 :: UserHandleInfo
testObject_UserHandleInfo_user_16 =
  UserHandleInfo
    { userHandleId =
        Qualified
          { qUnqualified = Id (fromJust (UUID.fromString "000069cf-0000-6ac1-0000-587100000e90")),
            qDomain = Domain {_domainText = "843pv5u.we-wv1lh5"}
          }
    }

testObject_UserHandleInfo_user_17 :: UserHandleInfo
testObject_UserHandleInfo_user_17 =
  UserHandleInfo
    { userHandleId =
        Qualified
          { qUnqualified = Id (fromJust (UUID.fromString "00002713-0000-6fab-0000-684500003b9a")),
            qDomain = Domain {_domainText = "hjk59y.cv275f6km.325-091594.mz-13"}
          }
    }

testObject_UserHandleInfo_user_18 :: UserHandleInfo
testObject_UserHandleInfo_user_18 =
  UserHandleInfo
    { userHandleId =
        Qualified
          { qUnqualified = Id (fromJust (UUID.fromString "0000146a-0000-6704-0000-552100002f68")),
            qDomain = Domain {_domainText = "05.o1--g.cw"}
          }
    }

testObject_UserHandleInfo_user_19 :: UserHandleInfo
testObject_UserHandleInfo_user_19 =
  UserHandleInfo
    { userHandleId =
        Qualified
          { qUnqualified = Id (fromJust (UUID.fromString "00005d29-0000-655d-0000-0cea00001b87")),
            qDomain = Domain {_domainText = "9g.n-1"}
          }
    }

testObject_UserHandleInfo_user_20 :: UserHandleInfo
testObject_UserHandleInfo_user_20 =
  UserHandleInfo
    { userHandleId =
        Qualified
          { qUnqualified = Id (fromJust (UUID.fromString "000052c0-0000-0cc3-0000-4aac00007ccd")),
            qDomain = Domain {_domainText = "d.dfkh"}
          }
    }
