-- This file is part of the Wire Server implementation.
--
-- Copyright (C) 2022 Wire Swiss GmbH <opensource@wire.com>
--
-- This program is free software: you can redistribute it and/or modify it under
-- the terms of the GNU Affero General Public License as published by the Free
-- Software Foundation, either version 3 of the License, or (at your option) any
-- later version.
--
-- This program is distributed in the hope that it will be useful, but WITHOUT
-- ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
-- FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
-- details.
--
-- You should have received a copy of the GNU Affero General Public License along
-- with this program. If not, see <https://www.gnu.org/licenses/>.

module Test.Wire.API.Golden.Generated.TurnUsername_user where

import Control.Lens ((.~))
import Data.Time (secondsToNominalDiffTime)
import Imports ((&))
import Wire.API.Call.Config (TurnUsername, tuKeyindex, tuT, tuVersion, turnUsername)

testObject_TurnUsername_user_1 :: TurnUsername
testObject_TurnUsername_user_1 =
  turnUsername (secondsToNominalDiffTime 15527713.000000000000) "ptwsd7g5za2solzq6qhub3"
    & tuVersion .~ 18
    & tuKeyindex .~ 4829
    & tuT .~ ';'

testObject_TurnUsername_user_2 :: TurnUsername
testObject_TurnUsername_user_2 =
  turnUsername (secondsToNominalDiffTime 13392461.000000000000) "ehn30n10n6op"
    & tuVersion .~ 9
    & tuKeyindex .~ 13335
    & tuT .~ 'r'

testObject_TurnUsername_user_3 :: TurnUsername
testObject_TurnUsername_user_3 =
  turnUsername (secondsToNominalDiffTime 11177852.000000000000) "txrqjvuzw5uokh21hitqy070mjmj"
    & tuVersion .~ 20
    & tuKeyindex .~ 10953
    & tuT .~ '9'

testObject_TurnUsername_user_4 :: TurnUsername
testObject_TurnUsername_user_4 =
  turnUsername (secondsToNominalDiffTime 14690986.000000000000) "st5xpvjb3"
    & tuVersion .~ 1
    & tuKeyindex .~ 2644
    & tuT .~ '+'

testObject_TurnUsername_user_5 :: TurnUsername
testObject_TurnUsername_user_5 =
  turnUsername (secondsToNominalDiffTime 4615190.000000000000) "u86l0yvllw39"
    & tuVersion .~ 8
    & tuKeyindex .~ 9984
    & tuT .~ 'S'

testObject_TurnUsername_user_6 :: TurnUsername
testObject_TurnUsername_user_6 =
  turnUsername (secondsToNominalDiffTime 13876542.000000000000) "eg21qov6rkavdo4etld2agglp6q"
    & tuVersion .~ 9
    & tuKeyindex .~ 544
    & tuT .~ '\DC3'

testObject_TurnUsername_user_7 :: TurnUsername
testObject_TurnUsername_user_7 =
  turnUsername (secondsToNominalDiffTime 604256.000000000000) "v3ectdcmttrhx8qi2jtqhmy"
    & tuVersion .~ 28
    & tuKeyindex .~ 10304
    & tuT .~ '\1056774'

testObject_TurnUsername_user_8 :: TurnUsername
testObject_TurnUsername_user_8 =
  turnUsername (secondsToNominalDiffTime 11461340.000000000000) "55dox167gmdusgejbcu3p0kk"
    & tuVersion .~ 30
    & tuKeyindex .~ 32328
    & tuT .~ '='

testObject_TurnUsername_user_9 :: TurnUsername
testObject_TurnUsername_user_9 =
  turnUsername (secondsToNominalDiffTime 9116692.000000000000) "9xedqmed5p"
    & tuVersion .~ 12
    & tuKeyindex .~ 3780
    & tuT .~ '\''

testObject_TurnUsername_user_10 :: TurnUsername
testObject_TurnUsername_user_10 =
  turnUsername (secondsToNominalDiffTime 2632630.000000000000) "yagwhzw2d8tddoj4"
    & tuVersion .~ 30
    & tuKeyindex .~ 19902
    & tuT .~ '\v'

testObject_TurnUsername_user_11 :: TurnUsername
testObject_TurnUsername_user_11 =
  turnUsername (secondsToNominalDiffTime 3719294.000000000000) "xevuwd5vsfydbvo5"
    & tuVersion .~ 15
    & tuKeyindex .~ 20428
    & tuT .~ '\28541'

testObject_TurnUsername_user_12 :: TurnUsername
testObject_TurnUsername_user_12 =
  turnUsername (secondsToNominalDiffTime 11821785.000000000000) "1t2k2a3ua0pwp196rs"
    & tuVersion .~ 29
    & tuKeyindex .~ 14407
    & tuT .~ '@'

testObject_TurnUsername_user_13 :: TurnUsername
testObject_TurnUsername_user_13 =
  turnUsername (secondsToNominalDiffTime 5664368.000000000000) "w"
    & tuVersion .~ 28
    & tuKeyindex .~ 1216
    & tuT .~ '\1076387'

testObject_TurnUsername_user_14 :: TurnUsername
testObject_TurnUsername_user_14 =
  turnUsername (secondsToNominalDiffTime 3247777.000000000000) "83sca0pn0dxoizci0g"
    & tuVersion .~ 3
    & tuKeyindex .~ 21012
    & tuT .~ '`'

testObject_TurnUsername_user_15 :: TurnUsername
testObject_TurnUsername_user_15 =
  turnUsername (secondsToNominalDiffTime 11893034.000000000000) "09x4jnuekod"
    & tuVersion .~ 18
    & tuKeyindex .~ 28830
    & tuT .~ 'J'

testObject_TurnUsername_user_16 :: TurnUsername
testObject_TurnUsername_user_16 =
  turnUsername (secondsToNominalDiffTime 8117361.000000000000) "ao8bs8og70"
    & tuVersion .~ 19
    & tuKeyindex .~ 2488
    & tuT .~ ','

testObject_TurnUsername_user_17 :: TurnUsername
testObject_TurnUsername_user_17 =
  turnUsername (secondsToNominalDiffTime 716501.000000000000) "nct4"
    & tuVersion .~ 1
    & tuKeyindex .~ 5062
    & tuT .~ '\10507'

testObject_TurnUsername_user_18 :: TurnUsername
testObject_TurnUsername_user_18 =
  turnUsername (secondsToNominalDiffTime 5517978.000000000000) "mxlyrynabc3fkdt9ze9"
    & tuVersion .~ 11
    & tuKeyindex .~ 20637
    & tuT .~ '\FS'

testObject_TurnUsername_user_19 :: TurnUsername
testObject_TurnUsername_user_19 =
  turnUsername (secondsToNominalDiffTime 12116794.000000000000) "pfa5lx43lko41m"
    & tuVersion .~ 8
    & tuKeyindex .~ 19266
    & tuT .~ ':'

testObject_TurnUsername_user_20 :: TurnUsername
testObject_TurnUsername_user_20 =
  turnUsername (secondsToNominalDiffTime 3040922.000000000000) "csp6eh0ti"
    & tuVersion .~ 15
    & tuKeyindex .~ 30634
    & tuT .~ '\SI'
