-- This file is part of the Wire Server implementation.
--
-- Copyright (C) 2022 Wire Swiss GmbH <opensource@wire.com>
--
-- This program is free software: you can redistribute it and/or modify it under
-- the terms of the GNU Affero General Public License as published by the Free
-- Software Foundation, either version 3 of the License, or (at your option) any
-- later version.
--
-- This program is distributed in the hope that it will be useful, but WITHOUT
-- ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
-- FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
-- details.
--
-- You should have received a copy of the GNU Affero General Public License along
-- with this program. If not, see <https://www.gnu.org/licenses/>.

module Test.Wire.API.Golden.Generated.ServiceToken_provider where

import Data.Text.Ascii (AsciiChars (validate))
import Imports (fromRight, undefined)
import Wire.API.Provider (ServiceToken (..))

testObject_ServiceToken_provider_1 :: ServiceToken
testObject_ServiceToken_provider_1 = ServiceToken (fromRight undefined (validate "V1srydDCyQ=="))

testObject_ServiceToken_provider_2 :: ServiceToken
testObject_ServiceToken_provider_2 = ServiceToken (fromRight undefined (validate "Za4="))

testObject_ServiceToken_provider_3 :: ServiceToken
testObject_ServiceToken_provider_3 = ServiceToken (fromRight undefined (validate "sC9FtVElsunEoBPLsgMA8Y1omvZ4"))

testObject_ServiceToken_provider_4 :: ServiceToken
testObject_ServiceToken_provider_4 = ServiceToken (fromRight undefined (validate "P3nGe5OyrKSlCyN1NVI_yGOZM61u120="))

testObject_ServiceToken_provider_5 :: ServiceToken
testObject_ServiceToken_provider_5 = ServiceToken (fromRight undefined (validate "a6t043kTszYx0AXSSNI2i0U="))

testObject_ServiceToken_provider_6 :: ServiceToken
testObject_ServiceToken_provider_6 =
  ServiceToken (fromRight undefined (validate "-XYFjqWLjSywi6BDFCV0_JPBhva_zkcS9Q=="))

testObject_ServiceToken_provider_7 :: ServiceToken
testObject_ServiceToken_provider_7 =
  ServiceToken (fromRight undefined (validate "OKVkjsnwvtYyHV4M85BTQPGikkwiJYmdDfAFk7I="))

testObject_ServiceToken_provider_8 :: ServiceToken
testObject_ServiceToken_provider_8 = ServiceToken (fromRight undefined (validate "9Ybx78vkjjA3yrZzr1DBlA=="))

testObject_ServiceToken_provider_9 :: ServiceToken
testObject_ServiceToken_provider_9 = ServiceToken (fromRight undefined (validate "KxTUvDyDJ_7KHkQDKGGNbQNpFg=="))

testObject_ServiceToken_provider_10 :: ServiceToken
testObject_ServiceToken_provider_10 = ServiceToken (fromRight undefined (validate "WzFBduViWNGq46-pywEE1KtDivs="))

testObject_ServiceToken_provider_11 :: ServiceToken
testObject_ServiceToken_provider_11 = ServiceToken (fromRight undefined (validate "dUVhthRe"))

testObject_ServiceToken_provider_12 :: ServiceToken
testObject_ServiceToken_provider_12 = ServiceToken (fromRight undefined (validate "LxO8Yetkiw=="))

testObject_ServiceToken_provider_13 :: ServiceToken
testObject_ServiceToken_provider_13 =
  ServiceToken (fromRight undefined (validate "sodNVoFqls-45A7-P1u9RgISgeTDPlpx1CpxcAE="))

testObject_ServiceToken_provider_14 :: ServiceToken
testObject_ServiceToken_provider_14 = ServiceToken (fromRight undefined (validate "nf5djv1f0VJStHFdqqntMirCdFcjQ1A="))

testObject_ServiceToken_provider_15 :: ServiceToken
testObject_ServiceToken_provider_15 = ServiceToken (fromRight undefined (validate "PjxnUW7Pgb6WQy-Llq8CpX1Q90cD"))

testObject_ServiceToken_provider_16 :: ServiceToken
testObject_ServiceToken_provider_16 = ServiceToken (fromRight undefined (validate "6w=="))

testObject_ServiceToken_provider_17 :: ServiceToken
testObject_ServiceToken_provider_17 =
  ServiceToken (fromRight undefined (validate "HkAiI2q0CAtMTwnqXuuAqYF8lRfzariDrpxhLCg="))

testObject_ServiceToken_provider_18 :: ServiceToken
testObject_ServiceToken_provider_18 = ServiceToken (fromRight undefined (validate "5UFP75w="))

testObject_ServiceToken_provider_19 :: ServiceToken
testObject_ServiceToken_provider_19 = ServiceToken (fromRight undefined (validate "OsXGs-8XGz9MJArpwkZpexaomKV5Xg=="))

testObject_ServiceToken_provider_20 :: ServiceToken
testObject_ServiceToken_provider_20 = ServiceToken (fromRight undefined (validate "tjiTereTUbmfAMwwIi1dQPk="))
