{-# LANGUAGE OverloadedLists #-}

-- This file is part of the Wire Server implementation.
--
-- Copyright (C) 2022 Wire Swiss GmbH <opensource@wire.com>
--
-- This program is free software: you can redistribute it and/or modify it under
-- the terms of the GNU Affero General Public License as published by the Free
-- Software Foundation, either version 3 of the License, or (at your option) any
-- later version.
--
-- This program is distributed in the hope that it will be useful, but WITHOUT
-- ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
-- FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
-- details.
--
-- You should have received a copy of the GNU Affero General Public License along
-- with this program. If not, see <https://www.gnu.org/licenses/>.

module Test.Wire.API.Golden.Generated.ServiceTagList_provider where

import Wire.API.Provider
  ( ServiceTag
      ( AudioTag,
        BooksTag,
        BusinessTag,
        DesignTag,
        EducationTag,
        EntertainmentTag,
        FinanceTag,
        FitnessTag,
        FoodDrinkTag,
        GamesTag,
        GraphicsTag,
        HealthTag,
        IntegrationTag,
        LifestyleTag,
        MediaTag,
        MedicalTag,
        MoviesTag,
        MusicTag,
        NewsTag,
        PhotographyTag,
        PollTag,
        ProductivityTag,
        QuizTag,
        RatingTag,
        ShoppingTag,
        SocialTag,
        SportsTag,
        TravelTag,
        TutorialTag,
        VideoTag,
        WeatherTag
      ),
  )
import Wire.API.Provider.Service.Tag (ServiceTagList (..))

testObject_ServiceTagList_provider_1 :: ServiceTagList
testObject_ServiceTagList_provider_1 =
  ServiceTagList
    [ PhotographyTag,
      FitnessTag,
      MusicTag,
      IntegrationTag,
      RatingTag,
      HealthTag,
      SocialTag,
      ShoppingTag,
      PhotographyTag,
      EntertainmentTag,
      TutorialTag,
      QuizTag,
      ProductivityTag,
      FitnessTag,
      FitnessTag,
      PhotographyTag,
      QuizTag,
      MusicTag,
      EntertainmentTag
    ]

testObject_ServiceTagList_provider_2 :: ServiceTagList
testObject_ServiceTagList_provider_2 = ServiceTagList [EducationTag, FinanceTag]

testObject_ServiceTagList_provider_3 :: ServiceTagList
testObject_ServiceTagList_provider_3 = ServiceTagList [VideoTag]

testObject_ServiceTagList_provider_4 :: ServiceTagList
testObject_ServiceTagList_provider_4 =
  ServiceTagList
    [ EntertainmentTag,
      MedicalTag,
      ProductivityTag,
      PollTag,
      BusinessTag,
      MoviesTag,
      BusinessTag,
      SocialTag,
      FoodDrinkTag,
      IntegrationTag,
      MoviesTag,
      NewsTag,
      PollTag,
      MusicTag
    ]

testObject_ServiceTagList_provider_5 :: ServiceTagList
testObject_ServiceTagList_provider_5 =
  ServiceTagList
    [ MusicTag,
      BooksTag,
      DesignTag,
      PhotographyTag,
      BusinessTag,
      FinanceTag,
      HealthTag,
      FoodDrinkTag,
      ProductivityTag,
      GraphicsTag,
      WeatherTag,
      SocialTag,
      WeatherTag,
      BooksTag
    ]

testObject_ServiceTagList_provider_6 :: ServiceTagList
testObject_ServiceTagList_provider_6 =
  ServiceTagList [EducationTag, MoviesTag, VideoTag, EntertainmentTag, EducationTag]

testObject_ServiceTagList_provider_7 :: ServiceTagList
testObject_ServiceTagList_provider_7 =
  ServiceTagList
    [ LifestyleTag,
      SportsTag,
      RatingTag,
      MusicTag,
      RatingTag,
      MedicalTag,
      DesignTag,
      IntegrationTag,
      TravelTag,
      HealthTag,
      MedicalTag,
      FoodDrinkTag,
      TutorialTag,
      LifestyleTag,
      ProductivityTag,
      GraphicsTag,
      DesignTag,
      LifestyleTag,
      SportsTag
    ]

testObject_ServiceTagList_provider_8 :: ServiceTagList
testObject_ServiceTagList_provider_8 =
  ServiceTagList
    [ GraphicsTag,
      SportsTag,
      ProductivityTag,
      DesignTag,
      BooksTag,
      FitnessTag,
      VideoTag,
      SportsTag,
      SocialTag,
      HealthTag,
      LifestyleTag,
      WeatherTag,
      TravelTag,
      VideoTag
    ]

testObject_ServiceTagList_provider_9 :: ServiceTagList
testObject_ServiceTagList_provider_9 =
  ServiceTagList
    [ SportsTag,
      TravelTag,
      FinanceTag,
      EntertainmentTag,
      FinanceTag,
      RatingTag,
      EducationTag,
      RatingTag,
      IntegrationTag,
      MoviesTag
    ]

testObject_ServiceTagList_provider_10 :: ServiceTagList
testObject_ServiceTagList_provider_10 =
  ServiceTagList [SocialTag, EntertainmentTag, QuizTag, NewsTag, MoviesTag, SocialTag]

testObject_ServiceTagList_provider_11 :: ServiceTagList
testObject_ServiceTagList_provider_11 =
  ServiceTagList
    [ QuizTag,
      FitnessTag,
      DesignTag,
      SportsTag,
      SocialTag,
      NewsTag,
      ProductivityTag,
      IntegrationTag,
      AudioTag,
      PollTag,
      MoviesTag,
      PhotographyTag,
      DesignTag,
      MoviesTag,
      FitnessTag
    ]

testObject_ServiceTagList_provider_12 :: ServiceTagList
testObject_ServiceTagList_provider_12 =
  ServiceTagList
    [ VideoTag,
      HealthTag,
      MedicalTag,
      GraphicsTag,
      RatingTag,
      PhotographyTag,
      HealthTag,
      TravelTag,
      AudioTag,
      TravelTag,
      GamesTag,
      MedicalTag,
      NewsTag,
      ProductivityTag,
      EntertainmentTag,
      HealthTag,
      FitnessTag,
      MedicalTag,
      ProductivityTag,
      RatingTag,
      GamesTag,
      ShoppingTag,
      MusicTag,
      FinanceTag,
      TravelTag,
      GraphicsTag,
      IntegrationTag,
      EntertainmentTag,
      ProductivityTag,
      HealthTag
    ]

testObject_ServiceTagList_provider_13 :: ServiceTagList
testObject_ServiceTagList_provider_13 = ServiceTagList [LifestyleTag, MediaTag, TutorialTag, IntegrationTag, PollTag]

testObject_ServiceTagList_provider_14 :: ServiceTagList
testObject_ServiceTagList_provider_14 =
  ServiceTagList
    [BusinessTag, EntertainmentTag, FitnessTag, FinanceTag, GraphicsTag, FitnessTag, MoviesTag, TravelTag, DesignTag]

testObject_ServiceTagList_provider_15 :: ServiceTagList
testObject_ServiceTagList_provider_15 =
  ServiceTagList
    [ EducationTag,
      EntertainmentTag,
      TutorialTag,
      PollTag,
      DesignTag,
      EducationTag,
      IntegrationTag,
      LifestyleTag,
      NewsTag,
      FitnessTag,
      FoodDrinkTag,
      SocialTag,
      FitnessTag,
      MediaTag
    ]

testObject_ServiceTagList_provider_16 :: ServiceTagList
testObject_ServiceTagList_provider_16 =
  ServiceTagList
    [ ProductivityTag,
      RatingTag,
      WeatherTag,
      PhotographyTag,
      EntertainmentTag,
      VideoTag,
      LifestyleTag,
      ShoppingTag,
      FinanceTag
    ]

testObject_ServiceTagList_provider_17 :: ServiceTagList
testObject_ServiceTagList_provider_17 =
  ServiceTagList
    [ RatingTag,
      FinanceTag,
      VideoTag,
      AudioTag,
      WeatherTag,
      RatingTag,
      MusicTag,
      ShoppingTag,
      VideoTag,
      GamesTag,
      DesignTag,
      NewsTag,
      PollTag,
      PhotographyTag,
      WeatherTag,
      IntegrationTag
    ]

testObject_ServiceTagList_provider_18 :: ServiceTagList
testObject_ServiceTagList_provider_18 =
  ServiceTagList
    [ VideoTag,
      TravelTag,
      TravelTag,
      LifestyleTag,
      TravelTag,
      SportsTag,
      SocialTag,
      TravelTag,
      FoodDrinkTag,
      IntegrationTag,
      MusicTag,
      LifestyleTag,
      ShoppingTag,
      MoviesTag,
      MoviesTag,
      MusicTag,
      RatingTag,
      RatingTag,
      ProductivityTag,
      GamesTag,
      TutorialTag
    ]

testObject_ServiceTagList_provider_19 :: ServiceTagList
testObject_ServiceTagList_provider_19 =
  ServiceTagList
    [ AudioTag,
      LifestyleTag,
      GraphicsTag,
      SportsTag,
      MoviesTag,
      MusicTag,
      RatingTag,
      GraphicsTag,
      QuizTag,
      MusicTag,
      GraphicsTag,
      MoviesTag,
      NewsTag,
      BusinessTag,
      FoodDrinkTag,
      LifestyleTag
    ]

testObject_ServiceTagList_provider_20 :: ServiceTagList
testObject_ServiceTagList_provider_20 =
  ServiceTagList
    [ SocialTag,
      MediaTag,
      MedicalTag,
      RatingTag,
      MediaTag,
      SportsTag,
      BusinessTag,
      FoodDrinkTag,
      MediaTag,
      MusicTag,
      ShoppingTag,
      BooksTag
    ]
