-- This file is part of the Wire Server implementation.
--
-- Copyright (C) 2022 Wire Swiss GmbH <opensource@wire.com>
--
-- This program is free software: you can redistribute it and/or modify it under
-- the terms of the GNU Affero General Public License as published by the Free
-- Software Foundation, either version 3 of the License, or (at your option) any
-- later version.
--
-- This program is distributed in the hope that it will be useful, but WITHOUT
-- ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
-- FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
-- details.
--
-- You should have received a copy of the GNU Affero General Public License along
-- with this program. If not, see <https://www.gnu.org/licenses/>.

module Test.Wire.API.Golden.Generated.ServiceRef_provider where

import Data.Id (Id (Id))
import Data.UUID qualified as UUID (fromString)
import Imports (fromJust)
import Wire.API.Provider.Service (ServiceRef (..))

testObject_ServiceRef_provider_1 :: ServiceRef
testObject_ServiceRef_provider_1 =
  ServiceRef
    { _serviceRefId = Id (fromJust (UUID.fromString "0000001b-0000-0079-0000-00770000000d")),
      _serviceRefProvider = Id (fromJust (UUID.fromString "00000001-0000-0002-0000-008000000059"))
    }

testObject_ServiceRef_provider_2 :: ServiceRef
testObject_ServiceRef_provider_2 =
  ServiceRef
    { _serviceRefId = Id (fromJust (UUID.fromString "00000024-0000-0064-0000-00010000004b")),
      _serviceRefProvider = Id (fromJust (UUID.fromString "00000063-0000-000c-0000-003e00000073"))
    }

testObject_ServiceRef_provider_3 :: ServiceRef
testObject_ServiceRef_provider_3 =
  ServiceRef
    { _serviceRefId = Id (fromJust (UUID.fromString "00000016-0000-0046-0000-002a00000067")),
      _serviceRefProvider = Id (fromJust (UUID.fromString "0000006f-0000-0046-0000-000400000043"))
    }

testObject_ServiceRef_provider_4 :: ServiceRef
testObject_ServiceRef_provider_4 =
  ServiceRef
    { _serviceRefId = Id (fromJust (UUID.fromString "00000010-0000-007a-0000-005d0000005c")),
      _serviceRefProvider = Id (fromJust (UUID.fromString "00000046-0000-0080-0000-001400000049"))
    }

testObject_ServiceRef_provider_5 :: ServiceRef
testObject_ServiceRef_provider_5 =
  ServiceRef
    { _serviceRefId = Id (fromJust (UUID.fromString "0000000e-0000-0043-0000-004000000065")),
      _serviceRefProvider = Id (fromJust (UUID.fromString "00000024-0000-0019-0000-00300000004b"))
    }

testObject_ServiceRef_provider_6 :: ServiceRef
testObject_ServiceRef_provider_6 =
  ServiceRef
    { _serviceRefId = Id (fromJust (UUID.fromString "00000039-0000-001e-0000-00000000002a")),
      _serviceRefProvider = Id (fromJust (UUID.fromString "0000005f-0000-0000-0000-00110000007f"))
    }

testObject_ServiceRef_provider_7 :: ServiceRef
testObject_ServiceRef_provider_7 =
  ServiceRef
    { _serviceRefId = Id (fromJust (UUID.fromString "00000064-0000-007c-0000-003c00000051")),
      _serviceRefProvider = Id (fromJust (UUID.fromString "0000001f-0000-0058-0000-004400000068"))
    }

testObject_ServiceRef_provider_8 :: ServiceRef
testObject_ServiceRef_provider_8 =
  ServiceRef
    { _serviceRefId = Id (fromJust (UUID.fromString "0000002c-0000-0077-0000-004f0000002b")),
      _serviceRefProvider = Id (fromJust (UUID.fromString "00000039-0000-0051-0000-002d00000080"))
    }

testObject_ServiceRef_provider_9 :: ServiceRef
testObject_ServiceRef_provider_9 =
  ServiceRef
    { _serviceRefId = Id (fromJust (UUID.fromString "0000006f-0000-001a-0000-00780000002f")),
      _serviceRefProvider = Id (fromJust (UUID.fromString "00000050-0000-0011-0000-001200000028"))
    }

testObject_ServiceRef_provider_10 :: ServiceRef
testObject_ServiceRef_provider_10 =
  ServiceRef
    { _serviceRefId = Id (fromJust (UUID.fromString "00000045-0000-003a-0000-00290000002d")),
      _serviceRefProvider = Id (fromJust (UUID.fromString "0000003f-0000-001b-0000-001c00000079"))
    }

testObject_ServiceRef_provider_11 :: ServiceRef
testObject_ServiceRef_provider_11 =
  ServiceRef
    { _serviceRefId = Id (fromJust (UUID.fromString "00000026-0000-0047-0000-000100000019")),
      _serviceRefProvider = Id (fromJust (UUID.fromString "00000078-0000-0041-0000-005c00000008"))
    }

testObject_ServiceRef_provider_12 :: ServiceRef
testObject_ServiceRef_provider_12 =
  ServiceRef
    { _serviceRefId = Id (fromJust (UUID.fromString "0000002e-0000-004e-0000-007200000079")),
      _serviceRefProvider = Id (fromJust (UUID.fromString "00000053-0000-0053-0000-005700000059"))
    }

testObject_ServiceRef_provider_13 :: ServiceRef
testObject_ServiceRef_provider_13 =
  ServiceRef
    { _serviceRefId = Id (fromJust (UUID.fromString "0000003f-0000-005a-0000-001d00000057")),
      _serviceRefProvider = Id (fromJust (UUID.fromString "0000005c-0000-0056-0000-006e0000004c"))
    }

testObject_ServiceRef_provider_14 :: ServiceRef
testObject_ServiceRef_provider_14 =
  ServiceRef
    { _serviceRefId = Id (fromJust (UUID.fromString "00000023-0000-001c-0000-00050000004d")),
      _serviceRefProvider = Id (fromJust (UUID.fromString "0000000b-0000-0029-0000-007300000038"))
    }

testObject_ServiceRef_provider_15 :: ServiceRef
testObject_ServiceRef_provider_15 =
  ServiceRef
    { _serviceRefId = Id (fromJust (UUID.fromString "0000002d-0000-0030-0000-004000000057")),
      _serviceRefProvider = Id (fromJust (UUID.fromString "0000005a-0000-0037-0000-001e00000051"))
    }

testObject_ServiceRef_provider_16 :: ServiceRef
testObject_ServiceRef_provider_16 =
  ServiceRef
    { _serviceRefId = Id (fromJust (UUID.fromString "00000076-0000-000b-0000-005e0000007d")),
      _serviceRefProvider = Id (fromJust (UUID.fromString "00000071-0000-0020-0000-006b00000051"))
    }

testObject_ServiceRef_provider_17 :: ServiceRef
testObject_ServiceRef_provider_17 =
  ServiceRef
    { _serviceRefId = Id (fromJust (UUID.fromString "00000065-0000-0041-0000-00010000001a")),
      _serviceRefProvider = Id (fromJust (UUID.fromString "0000007b-0000-0018-0000-005b00000065"))
    }

testObject_ServiceRef_provider_18 :: ServiceRef
testObject_ServiceRef_provider_18 =
  ServiceRef
    { _serviceRefId = Id (fromJust (UUID.fromString "00000074-0000-005d-0000-004100000057")),
      _serviceRefProvider = Id (fromJust (UUID.fromString "00000011-0000-0033-0000-004200000003"))
    }

testObject_ServiceRef_provider_19 :: ServiceRef
testObject_ServiceRef_provider_19 =
  ServiceRef
    { _serviceRefId = Id (fromJust (UUID.fromString "00000041-0000-0011-0000-00190000004b")),
      _serviceRefProvider = Id (fromJust (UUID.fromString "00000070-0000-002f-0000-007000000046"))
    }

testObject_ServiceRef_provider_20 :: ServiceRef
testObject_ServiceRef_provider_20 =
  ServiceRef
    { _serviceRefId = Id (fromJust (UUID.fromString "00000030-0000-0057-0000-00760000002d")),
      _serviceRefProvider = Id (fromJust (UUID.fromString "00000061-0000-0075-0000-000200000069"))
    }
