-- This file is part of the Wire Server implementation.
--
-- Copyright (C) 2022 Wire Swiss GmbH <opensource@wire.com>
--
-- This program is free software: you can redistribute it and/or modify it under
-- the terms of the GNU Affero General Public License as published by the Free
-- Software Foundation, either version 3 of the License, or (at your option) any
-- later version.
--
-- This program is distributed in the hope that it will be useful, but WITHOUT
-- ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
-- FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
-- details.
--
-- You should have received a copy of the GNU Affero General Public License along
-- with this program. If not, see <https://www.gnu.org/licenses/>.

module Test.Wire.API.Golden.Generated.RmClient_user where

import Data.Misc (plainTextPassword6Unsafe)
import Imports (Maybe (Just, Nothing))
import Wire.API.User.Client (RmClient (..))

testObject_RmClient_user_1 :: RmClient
testObject_RmClient_user_1 =
  RmClient
    { rmPassword =
        Just
          ( plainTextPassword6Unsafe
              ",b>\NAKH'\149031\180170Q\EM\EM\175816{FX\160350\nu\NAKZ\177637w\1042829Pou\1099274WkQ\1032820e\STXWa\188817\FS\16300W\1000322P\110706J\ETB\988765J\EM\146149\986240M\1105177t _\161776\1072052~{.\78470u\1102696\vC\1737#b\37586<\DEL\129312\167517\1077035\37142\FS?n\ACKe\v\167493\EMh\1031373\SOHm\\T8tX3b\1020934C$*\1108469++\58420|ln|\167199s\r\1068066\22176K5d\21086| Vt\43503\149386"
          )
    }

testObject_RmClient_user_2 :: RmClient
testObject_RmClient_user_2 =
  RmClient
    { rmPassword =
        Just
          ( plainTextPassword6Unsafe
              "|\38219\146109\1104272\68001\1007158cyJ\DC1/1W \b3}\27171O&\SOH?2\GSbT\69848OEg\ESC\RS$phd\1106057"
          )
    }

testObject_RmClient_user_3 :: RmClient
testObject_RmClient_user_3 =
  RmClient
    { rmPassword =
        Just
          ( plainTextPassword6Unsafe
              "\DC1C$\SUB&\9779 \74999m?Ao_i\994908\&5|(\74373\993551\1080071\ry\63906f\EM\67654\1047832\136850\1003353L\1080749yJ.\182225\&8\SI!.\bck\1104779p\ETX\173093\ESC\ACK\23225Ye\1007809\RS\n\985303\184009\95306\r\175489\1108039D\DC4\DELQ,''\NAK\160353\995523\&7l\120655@A\1093222\1107668Dd\n\1046822\1023527f\1029486p.N\SYN\998111\t\a^\986679R\\<\154586q o~\1095316=zN\t*B\167273-x\EOT\190128\SYN-\STXV\SIHbXi^\DC1\1096966\DC3N\ACKPMu(\ESC+VW5_H\185168\SOG\RS\"H`F0\1005392A\NAK]\75030\DC4\r\94424\9717kqk\\IV\1098464\5522\1014922-\1005479M:'6C*\168360\182775b4C@\DC1co\SO\SUB=\44742\1068818vV%\bM\DC1l~GI\1109000\t<\64505\DC4.Y\4871x6{\178251\1003872\SO\990516\1049646\GS\DLEi\1020935\SIG#IDo#\1083579\146691T\92763Y1\190785\ETX3U_\5182,GND0xT\EOT\ETXbT\1038139=\1023104\1066274a\DC1\DC3(o\995303~e\DC1\vnj\92360\voU\ESC9\1041053\ACKP%\1027535M`KT\94715Bp5m%Gd\b?M\1108211\EMM\1093455W\RS\bd\SYN\ENQ].Jj\19271.\t\US\158337k\177222%5.W\1007030dwbE\45342tlAYC8?\62378\1018506r,\b\SI:\STX\172291A\8228\RS\DC1,\1087495\146080-z\1111297W\1001491b\191422\147711\r\STXL\100907\"\1064084\&4\fK\135548B\GS\125113>\986449\983148!j\1077315\SOH\ESC\160941YN#"
          )
    }

testObject_RmClient_user_4 :: RmClient
testObject_RmClient_user_4 = RmClient {rmPassword = Nothing}

testObject_RmClient_user_5 :: RmClient
testObject_RmClient_user_5 =
  RmClient
    { rmPassword =
        Just
          ( plainTextPassword6Unsafe
              "u\r\RSKc\vwqO\DC1\ESC`\FS^T\SO\78233\2870,\NAK]:\190015b{\12662\ENQ>\1012526\53265wv\FS?\DC1Y]\GSJ4>\161019\127036\SIDt\NAK7\148811G\GSL\SOHI~?\152998\1079668M3\151251\160635Q\146150\136855\175056j/d\DC4[\GSh@sX2\DLE\36822\20669\r\1054692n?\NAKX\1021192:\NAK:S\FS%4\1000357\1023125\1094223\27882\NULFv~2\tdY&\1068216{V[\DC3Ob\4028\1113384Q7\189965xR*y8B!Z+1s<f4\DC4\1012066F\fJ@\189061?+O\DC4r\SOH\1071818O\DC3b\58540\&8a\RS\183581#\SOH\145107\52463k\1093310\GS\174979\GS>}\1078810\EOT\ESC@\1060206\1064133\&9\1053766t\EOT\RS7\1082630-.\ENQ\28754\SOH\1024734m\EMu\DC1\1045651\20414W2C-eXl\1029878\54144L^X\a=E\996400'\1023967Kf\60191\t\1035046[6\1067319Er4\DC3\1067750\1034154\134998\&0\1010935'~ri\1049095\&6fHra\1000663d\DLE\\\36326U\1109249\1049434\1000455v\1079865S\ETX\EOT\28189\v\51876!*cU^>~~\41196\64528~F[ EA~6Ff\1112130FP/\111016OAa\39220\&6GY8*C%\EOT\1087848\SOHI\NAK\EOTY\61539ov\STX'\1023772\DC3\SI\FS{N\188089\DC3}eIr\RS\65287\42560\ETX\CANN%\EMv6\26591\21049\&3S\EOT\ETBf c\52779r\70741d"
          )
    }

testObject_RmClient_user_6 :: RmClient
testObject_RmClient_user_6 =
  RmClient
    { rmPassword =
        Just
          ( plainTextPassword6Unsafe
              "f\1068600mj)\183679P\992997\US\1079905\&0sc\ENQ\167406\FSf,\50185\SI\988607\1032080\NULzRen)+.7O8\DC28\11736\&8z1\137184<}oQ GLfC\1098125\SUB\1108593\ENQHc\178829\&3Z7+\CANPg|\SYN~\1034724@>8.E2\148916"
          )
    }

testObject_RmClient_user_7 :: RmClient
testObject_RmClient_user_7 =
  RmClient
    { rmPassword =
        Just
          ( plainTextPassword6Unsafe
              "\194881\51083\&9_\1004885ETt\19904\DLE\1005738+\149283CE\1066640c\RS\1050216\1056071\a\SO\a\1084135?\995655i\1049139o\CANh9\bF,{\183672xd'F\n\166668dfh\50610z\1067294\\j\28361\RS\RS?\51780\t\r'\tN5'j"
          )
    }

testObject_RmClient_user_8 :: RmClient
testObject_RmClient_user_8 =
  RmClient
    { rmPassword =
        Just
          ( plainTextPassword6Unsafe
              "\\k\STXlDk\58709\168637&2M\b\DC3$gY\DC1\30177\SOGN\NAK\1020644\47145\ENQ$\EMp\SUB>\a;2\31773D/VktO\ETB\94786F\ETB\1063431\140361tGN\RSj\1097924H\1032883D?\1097409}>\12036w\1090856\ETXt0\120613n\1083811\19125+@I\181604x\DC2\139380jaoz'\GSP\ETX\132230|\ETBh3\EOT\138288r?7\DC2($\1054761\SYN\57353@\18013\39702>jL\1085777\&4\165044\186257\f;\DC3QO\1051006\9938G\FS\159207T\1036643=4\997105\140882\143332\US\ACK7\10935`\1026212H#\DLEbvb*\SYN*r\ETB\CANU&7'\97152N\133078\139852 4\t\1063173YJ\990648R7EJ'Cz~\v\"Z\1093198\1111312\37180\FS6b\DC1\62530\53959\1084720\181077e\1066979\ETXM\1043717t\38480[vg\1062558c,h&\tc0bm\1008860\62413=\US\59351r\SYN'0\GS\SOH\DLE`\CANq\ETB/s\1099041\158297\SOH\97324\DC1@\1031711\1033584P\25573\1111610\54934\1058576FH\66043\29556\n\1075739\996981?\NAK\STX\ETXRE3\FS\b\1063480\&2\1074988uH+q\185430\NAKb\995672\&5\\U_\GS\EOT,=\ENQ\nR\39177\1013849\1051954Z;H\57419g\1044344!G\DC2VUR9L\1090937\158091d(\DC1[s)wo6/3{\CANnxbq\"8\1105102;\50111\1082295e\1040029\&3Y\1029848d\1019994\STX>\NAKRH\NAK\176304\FSn\167700\SYN.\\|\1099362\CANL!H'\ESC:\1030596\1108869\143976\1043575Z\rs\SYNrN\33118\&5f\988325s\RS2\149587\1069227\177299\1057591\1023168v`\1045856\141152/\ESC\176589,d\566uG\996075\1024740\ENQ\118812\984941\DEL.uii \EML\CAN\a.\1092342\137112Pl\119859HK&\ETX_4\94605\ESC\EMqW\178369\USUM\ESCa\SYN\STX\taV\165246g\1013286\35382\1029703Oz\177867c\RS\DC1\EM\EOTZ>:#L\DLE\DC4\1028084.+_\bh\25871`B!}\4944\r#\131948\n;.\98171\&3+E\v+\986054c\62608\&3h@\164124j\EOTl\53853\&2I\16178]\168403\1015589+\1047817&\NAK\1010737WF\\\994386\181181\&7\r$e\SO\SI\1022270\\\ESC9^\983485E|HW\DEL~<a\58098\1083483\DC2s\1004278\bbAl\ENQ\137076\54448\EOTRyrI?m\1079696\27867\1093853,\US\158008\&7-E\1072053%H\176907K\SUBIm;,B\11533Gtk\167333^\2761?\GSksd\1003115w\1006773\ETX-]\1056775;\1079107\&6\1065457q-\1041591|\147097p3{\US\NUL\ACK\95134\vy0\143739\158264\69992\1063385\176981L\52580\1074701\989334f\USD8+\33838hy\1048243Y\163131\1092646\&6co7G[\f\DC2@YY\20021|{e)\EM\1007587(V\SOHkw\DC2\1091032\111164\33044\DEL]\983407\r\ETX\n\DC4L$&\136054r\ESCJ6\1073852!\143493z\1103390XDD+y\1087219\CANu\1044601[]`P\SOH\FS\GS\SI\989096,W\1054799S\133129qjB\US]7h}\987304\1003812\v%NDx\DC4\1082642|91}\CAN\74504g=\SYNG\EOTWS:\rVs\992588\DC3\1056845\1002603Z\190380\STXTg,\1004124\rbNw\65727\SYN\DC4\1032983\ETX\12983\9777\&5\vc\1012919|\STXz\t>*b\995284\1015292\bB\133206\1024480(\DLE\30931\RS\1016271\DC2"
          )
    }

testObject_RmClient_user_9 :: RmClient
testObject_RmClient_user_9 = RmClient {rmPassword = Nothing}

testObject_RmClient_user_10 :: RmClient
testObject_RmClient_user_10 = RmClient {rmPassword = Nothing}

testObject_RmClient_user_11 :: RmClient
testObject_RmClient_user_11 =
  RmClient
    { rmPassword =
        Just
          ( plainTextPassword6Unsafe
              "\ETB\a'\\@)m\1059075\EM^\72201\1015541k\"dx\ETB\ESCk\a\nh\US15\SO\ak\39185\1081304\STX\ETX\ETXe\FSgPVGxoq~\160709m?\1091458pf$$\bwW\ESC\1026890\137523\&6\138333([$\DC1\1002695\DLE\1053749\986572G_KQ.\STX;\CAN\1040541Op\1039745\fz\23042\1111245^\992408\SYNFZ\48538$iW\174178\CANMF4SCdf\183630'\EMvO\1088031\68872Fg!a5=&\"wGT\ETX\re\160574\1068011\1070114I\NULQ\1079966W}\"iI\DC1\1010245GW\1006838bn@\ACK\12510\DC2U\998156\2120*0\EM\59045\1089866-\tH\1040686y\1030608S\1022283\181615\917559\1050355^\143688Po\NAKC\DLEG\1092512\&0\\V\136027\DLE?\DLE%\1040722\77835\ETB<t>\190551'H\55061;v>+w4\EM\189653L\1045896\&73>z\1100545\GS\1046690C;m\a#\1102454F\EOTeE \1017094\&7\DELS;\EM\SUBc\95703\5551\141533-\41407\&8Rwm\ni\US\153804\161848(k[Q\1088187J\1006045\f>5#\177947\DC3>\1000951\1000056vL|\187670#\177307\154490\CANh:\9975\1089780\99284\SOH4H\ENQQ\190920*,;k\38432\SO\1006676\b\US\17954\1077355\DLE\tGL8\DELJ\24433Al\1011516hg\177209:\DLE\39726{g\1084006\aT\1108183o]|\1079519M\1082621+\1001591nf8m\14960\121239\DLE4 \154263jI\1113295]\FS\45303|3i\DC3\35299#\129557A\1062233i{\156175\n2:\DEL\DLE&p\40502\1081945#59\1044160:F\32935\35480y^\152665\&07\v?M\ACK\bH\368\20580}Xt;\ENQ0C\n!\1077494\19077\167442O3o_\ESC\STXNbB(\132160\1017760W\1018075HA\1089009\164474F\DC4N\1058101=pk\aL\12176\&8~\57813b1\ETB%J\DLEm\991879\121092TI\1062650\t\RSM<1 U\21056-7Wn!w\1078469\DC3\SUB \DLE\GSjx\"`\SUB\1055719\EOT]tc0]\"Lk\1089957\FS\18169\STX.uO\SUB/s\1006294\&3T\ACK\1009623.^\1108849D\DEL\1055418\&7Ic\1098123\SYN0,;:M:G\ETB^\SO.\1103088\SUB\1050786b\5905\25243'\NULR\fgy\NAK\34318\EOT\GS\ETX$\137105*\RS|\30344\DC3T\5529\rWY(1&8\DC3\1066256\159300\SYN\1087588\1113798\SYN]JC8#?\ENQqtkp*\DLEj\SYN\1098070@\ACKLzE&\DC4\111339/2jBel|B}\SIe\190306vM-\1019151\EMY+\t\1013622J\170034G\DEL\1078519y\vm\1018713&\nf\GS\1102895\41043\DC2D\43946A\49667\b .w\SOg\1017121\1001682?'0\44391\1389\CANO\1077433\40773,\92582\1012359\r\1011515B\1073868$\136645,\USGn\SO\36290\STX0Q\1110755\&5\NULN+a\SO&SQ\36504R\96913efu\1074135E\1063004\69816\ESC\DC2cb\DLE\CANsnz\52286\1015052_\1066195\vI4\1107184\v7\GS\998814\NAK\GS\986796\998902\1095537\1049320\136576NT\177463\&8NP\23931M\DEL\998395}L\ETB\1107078\ENQ\133738\"-\ri+\162913\STX\1067349dYK\12305gNI\STX\t\1091824r\1009246p\991411\20642k,+\1076655cJU\ACKc2\179407d\DC3\ACK\NUL\ETB0\1104172\SOH\44872t\DLE\7912;L\ENQ\134463\998861\&4\RS\b\189089\1077954\SOHh\1018425\aB\DC1J\23425Pz\67331d\187576p\24975\v )<!\17596\54166J\r\"\64892\SYNt\EMD4Fx\ACK( GEZd\1105569Rf\159685\119138CH?/O\SOU\183823\44575!t\ESC&Cw^G_\"\\;\DC2\92229W\DC3vC\ETX)\1028263l2\145991\v|g6\1015713\39857\GS\1048984*QC\1075133k9R\154526,\119089\138148\&18\6017\&6i\ENQ\1113077;\59524u\71682=\1016871z\989311D\186500M\1081473\136275\ESC(\GS\1046224~w)\CANl\SOH+\1102521\SOHt\7212B\ETB\RSf\SYN)ku\1001018Z\NAK$\1084777h\DEL\DC2\995423wbW\1026471\DELw\1024121<P\n\v\SUB\100900nTE\1057486?6\ACKfBnf\SYN\161768\1038128\70466y\174644"
          )
    }

testObject_RmClient_user_12 :: RmClient
testObject_RmClient_user_12 = RmClient {rmPassword = Nothing}

testObject_RmClient_user_13 :: RmClient
testObject_RmClient_user_13 =
  RmClient
    { rmPassword =
        Just
          ( plainTextPassword6Unsafe
              "\181172\1047849\182895\"\143845;r\98393e\EM=km-y.\71343\NAKZZ\1002162]0\\2\142866[I\1051858\23759r\\#m\131534^|q\RS|]L\138654\140420_~jLFMlz\NAK\993284\&4\53858\1041097\997630)\RS\ACK\DC3x>.\SYN\163714\NAK%\1015879\64593\1002966\1061172\n\1025501oe\1011894\STX;\EM/\t!il\1012248O\a\1097530r-BSLX$8\n\ACKBF$e\1001493\CANr\1017210\ETB\183079\EOTq\995822nrqAeT;\1100221\10430%7\DLE\NAKvP*pJ'\35280Ur\"y\n\SUB\FS\35772\170674q\1023935iW\62447\74646j\29562\EMXPv2\SUB8V\74822Y\184675x\NAK\64876EfH\"9\1089441<@\141755>\f\1092300\98292}QO6$ZI\ACK\a\SYNxLa\1074036\DC3qwGZx\DC3&cc\1073565\t?\1029925\1062160S\DC2xNC(:\ENQ\ESC!:52=\142112:,' \78760\DC1`GHZ\179155\163413\97615\t\34193,\SYN=X\1102133;x\23553(iT\DC3\172249Ni.\t\1080519\&0L0\STXln\NAK5b?!\b\1112670\22572\158487r\ENQ\1011620\"G}\DC2\DLE\133297\&0\DC4\FSU\159706"
          )
    }

testObject_RmClient_user_14 :: RmClient
testObject_RmClient_user_14 =
  RmClient
    { rmPassword =
        Just
          ( plainTextPassword6Unsafe
              "JS,)\apP&^\US\fP\n{\DC4bwQPl\139468\1095461*`9\\\EOT\STXD8\CAN\10743\148195\1005784,\143168\1005601&@\SI\22672\&2\DC2\128381'U=64Z<\64338a\fe\29861U\35725dMJ|\t%?\a1\73972;\GS\190755d\SI&\ACKjgC\1042133\58072\ETXWP\DC3ZN\959Xv\137301\1034484c\f>\1079348udVB\1092880A}RHF\1109691\"\126246S\RS9\985146g\10146y,\1027865Q7n\SO\1056019\DC4<\1071322-\"\EM6\44193Yq\v\1022842\&6\17324qN\150474\EMyV\62280\DLEf\"xt\1071474{\1012500~I?\DC1Z\f\141931OEz\1083265JGdEb\1100849C\SUB\1029802\171738v\1094740\58371\83338\995436\&4\18752{R\FS:\GS\ENQA\985299\1049855+5\"\159265VxN\131406c|\SOH\180495O\1067889\1096101\181191W<\177853{v)\GS\SO\33042b)\v\990437\39439\ESC{'P4\RS\136975yu<t+SV2-\f\ENQ\129553\&2\1023746^%\\x\STX?]OS\ETB\1033130\159017bF\SOH\FS\1007945e-\21417[\f3o\74469*\92890Q:\av\NUL9U\1079845\RSr5\1040341Ad\ETX\ENQ2\v}E\1045863JQ\1086361u\159614\DC4\SYN\ESC\1031144\132477\1039529\1093917\&49b\DC2D\NAK\47876\1060240 vm4\\\SOO\1019219\154186[nq\50482\a+\1044957\r-{L\1031850l\42826l-\1095004H1V\26177\SI\1101249\NUL\SOH\15432\1071516\1060214\EOT\1028702W\\U\SO#%r{\1029325\v(\RS\ETB{/GA\re\EOTW2 vJ5\1111378+\57481Ux\155125\152782\DC4\1032328\n$\fL\1095012c\135738\ENQ\EM\RSYM\26917\998009m\1087185N7P,`yk\EOT6%\ETXut=3?\b\96996\ESC\1049044(E\1040114bGR\1100704\156135/\CAN\1011419v4)v)\166393 \138668\DC2W\noQ\ETB\SI=n\ETX3>\ETX(X+1&\1107240\&5\1036872\988610f\128486\&6/{\1072363\2106A\NAK#\1021527^\985809\SUB\1061227\EM~{f\1070917\1056635\SOE\SOHVF(&zL\1061708f@~\51296\ESC7V\SUB#\160477\DC4\GSq\vd03\SOHoX6\1078388\DC1\DC3\1096865\998527\1011292O1\SO\141874\18191\t;\DC3\1034008\ACK\GS9\180579eY\127851D~\1063586c\EM\SOHn\997603\EOT\1000820Y\1086755k(\n?n\ETB?\1033490g\SOHK;N\986426\&9\ETX\997547\32787\1101424\187624)\51954\NUL\NAK\157227\SYNw9b\1010290@h\1099763)\SYNY\1105508\149194\&2\1013323Iv6!\1086161\DC3Q\EMAq^BK\ACKOhm~g\SI\b-35\994294H\151366V\181790\ENQ\ACK\ENQ\r\DC1\183450j\42936\&3\FS\157601(\149094\1097849|CC\43541\997243z%\190687oq<}\175058\1000174G}\ENQ\1002175 \DC3\DC1o\160995Z2-\11011[h\EOT4#>\1066859\60829Mn\aR\ENQy\1006323j\t\r\1054622s\SYN\158717\1053679( \17700B\18157@L\DLE\1000031\1075133\127484Z\36271pD\58813f3|\1097266T\167390\1042802E\r\DLE\SOH\1069786\174606\45404\v15eR,\ACK gQ%fhE\137991-o\1102116(J\1066702knt\ACK\1005141[O\rx\RS\n\64739i\1100555\182947tQ8\54609\&3`;\FS+\1099126\37776\&7?$o\1031939|\186091\CAN\59235\139215\23039Z\DC2[\SIv\SUB\SI\ETB\ETBR8\121042z\DC1!H}!\EML\36933\170734J\ESC\74828%k^\1092735B\1003335/Efm\23384Gv\CAN{"
          )
    }

testObject_RmClient_user_15 :: RmClient
testObject_RmClient_user_15 = RmClient {rmPassword = Nothing}

testObject_RmClient_user_16 :: RmClient
testObject_RmClient_user_16 = RmClient {rmPassword = Nothing}

testObject_RmClient_user_17 :: RmClient
testObject_RmClient_user_17 =
  RmClient
    { rmPassword =
        Just
          ( plainTextPassword6Unsafe
              ":^\1064227rW]\71111[C\ETBth\172645c\\i%Bh62xX\ETX\1003291\&7\1088794\1015330\n\DC2g&\r\SO\98557U\t\1849\161566\1085916>\1053071Qk,$i\CANaj?\21418\1005710^\186062\alB\1036347Y2Hj\1020009\990636\23254\&1.d\1009177}$\1031958\1030039Wg=HR\78422ev$\ESC\a\73012\1038678\12665\129352\&5\f\28309\1051661v\996552X0\21269J+\53984;\DC22l#Ikr3\\\NAK('HA)q_m\US?zDcx4\168332\&1y\149573m\8674\173780\EMcx\\\44711\t>\SI\"3\GS\STX\157812;DtMbX\62897u\45382\1057316!1\DELZ\21661Y>5\1072885\&9\SI:\790_$}\EMH\SOHy/\ajc=\RSof\DEL?0\SOH\158349\178108zZ\RS-\DC3\994567\&2<5\CANH\127293\191190j\139970\&8/A#-V@IgQ\1028998\STXqNi%I).i\DC2\1044694'y~[\EM,\47073o=\DLEc\1100011i\FS0\1001994\&4RA<S7]\158642NY#\1047659\&1/\65466I\10874\41322w\67229\133382\ag\ETXXHF;^]\DLE6\ACK\EM;\997168*\EM5n\39404\&3Hg(E*F3e4\DLE7v\NAKU)s\ESCTt\SItm_\1110369\21852d,\78859[S[`\1100258\175970Q\999786\1082739\\\101057\&9B]f!+q\GS(-[I\EOT^F\SOH|\1045106\NAK,4\1042120\DC3;zuy\160745\62158\990548K\fUD\1062517\173202\159596o\f`\DELX!\1011728\&5\1074502Y\1103862j\987940\152578mG\1036055.\b7fB\128934T{2\EOTab8V#!t\aqh)vh(T\SUBj\1007646Hn\1004558I\n\188397*R\22143d\DEL\SUB&:\STXFW\RS\149991\1098846\&2W\989032,3\62909\&1\1040504\1110444Av\2608\65363\1018234d\ESCyVO\ESC\1053588u\83387#(5(e\SOH)O\STXh,Ig\RSC\NUL\1087041=#\NAK\1046087Kt\194990\&5\68497\123192cp\54479\155198\ESC`\1047395\1044065\1111961\994706O=P\1047716\DC1Q\US\SI\US:t\62522)Z:\1065051]\54853\996342\73738j\SI#J8m\ETX#Xn\1021408y\1094259u/^7d3$\DEL\1005404\ETB.\EM^\DELk%\1103817\ETB\SI\DC3o\SOH'\SOH\ETX8LJ\57967u\1090099\65267\&93\CAN-\r\35832O\9075\\\DEL\NAKa\CAN\1056274\1043768\DEL\184138!\ETX`\1048061<\NAK\DC1\CANO \1087130\DC2rZS);t\SOHQCJ\\Ue\SOHS\ENQ*\1055274\"X\34182bU0IF\NUL\10839\DC2\ah,\1041117m.L\57866[\142739f\1112882\SImv\175679\1012431\31604}v =\83405E~\ETX\1069935Y\DC3\1016564\96530e+\GS\SI,r\177447~k|f\1061039\1103770\1050131\39829\SYN\\o\21113\SUB{\1084678\6947\1075306,\1045884CJ\36384s\155575F\985444te.|l\US\ENQ:\EMQ\984856d6\1096086\b\180368xO7<I\r~{S\DC4U\EOTOi|\SO^5\r\169009}re1\30496\1049377lWs&"
          )
    }

testObject_RmClient_user_18 :: RmClient
testObject_RmClient_user_18 = RmClient {rmPassword = Nothing}

testObject_RmClient_user_19 :: RmClient
testObject_RmClient_user_19 =
  RmClient
    { rmPassword =
        Just
          ( plainTextPassword6Unsafe
              "6@\1013231q\DC4\999281mcj\74251\SO\DLE\1049216\STXZ \1043412> \SOHNx\1044774\&5`6P\985133\154298/l\1035874A|\SOH@}\NUL!R7*\1067646Y\EOT\SO\DEL>\EOT\NUL4\176080\tQLZ\14795\DC4\166607\SYN%\1019393x\1034448%\STXmRk=KI\1062040\1010121\ESC\991763\US\FS\166933\EOT\994930<>\NULRt\SOv\1073987\98391\fSl7\50002\121034 U_\FS\1086509FY+\ENQY\187880\1085508QVuo]bH\30696Z\FS\19827\17889p-^pD\62997\&3\DC4ZH\NAKG,t\FSU\DLEq:haf@\1097538@\1017660JsNQ\ACK\1093827\&7\SOHf\DLE\1073590\RSw3\1072223\FS\143760tw\162052Su^h\995522 \1074155\6548;_\"\68918=\\U\139264+\1033999\&1\v\1095259\43939Rl\134822-u;\SOHT\SO\SOHy]a\993692\149269\71120p5&ub\NUL\SI}\1107\1023682\1045554\182225\DC3(m|\1095432\1033702\DC1\npQ1\62892\1064567\DC4NH{;@,Y\t\SUBRi8\61771_]\STX\1020112\1022473\1065928\1046385\SI\134676\&0E\58889)1F\1010862\DC2\158347H\SO\DC1\1101828\28722\135590i\134246c'O\1002376\"\194733\SUB S~)\1033861\4030&V H\172870w'\188631-\"af\"8A pXN,a{sVN>8;Z\995796\150250/\f/\f\95037\DC3e\48613\SO\3262\&6wH\tl&\DC1H\995904\f\CAN\DEL\NUL`\n~\\\158630\&1\SOH"
          )
    }

testObject_RmClient_user_20 :: RmClient
testObject_RmClient_user_20 =
  RmClient
    { rmPassword =
        Just
          ( plainTextPassword6Unsafe
              "\\\179922\ETX\1063876gq\DC2\CAN\151652=\19388k\78018\1006299\GSdPY9\126638\1075436\n\ETBs;\"\USJ\146\SYN}s\\\DEL\149791\DC4\1009471W\1066869\"h\1050077\154303\174087&\34924\FS\DC3@\DLE\tpC!\NULj\1033662\SOH\44555}RsW\1002820[\12613)\FSTy<\SUB\SYN\DEL\GS\1102230g,[\1049430A\74421c8g\DLE(g\52062G%rmt\992360\1013971j\ETB\SOH\989970\1110618\25626\159497N't\ETB)[d\DLE)T\SO=\18676\ACK\DC4L~r\1033945;I$z\996571XI(ia5]C=\SOOk\57352(85\STX\SOb&V\163119;\53604UIHhrO`\NAKvpx\b[\62002U\ETX\1071858*\az\1094108\DC47>xS\SI\RSU\fU\SYN&\154636(?Ju\NUL\1076043\&6Of)\1010856J\25403^\171422\121331(\DC4\n\v\172750\35293#\98964\&7\36306_\EOT\1100877%()P\ACKT7\1084781g\DC2Eq\178647\1010593ZGV+\98214K\tl\1075434\992552ej\147375\SI\1005868\177430k9Y:\FSI{\163043WHD\169883\&4<6\FS/\DEL7\tM4Js6\100092\155924\&7Wo+7\61675\17819S\DLEd^f\184182?\DC4%\50344\1108647\EMo\bmR-j\142268GE\v#Hm%j\EM}~u\NUL3e\nn\1063407_\DELt5[\994606By\bn,\r\187693\SYN\vo\142453[\97973$:5\1036737+!\ENQA2UL4\168297`\181100\&3\1007444\EM%\\\b\1005402T\DC1\f.\72807wK~\DC1^~\143572i\DLE\SO\1081338\DLEb\nz\ESC\32124\&6\189340\95862\SYN\29594\&9\bX\n=j.\1094027\a)BB\1019205\1035208\FSD\1000886jw\175947\&3[LhSu)\141403Ko!\n\CANy\1016531T\EOTA\ETX\99030Sm'\1048650,\24162f$\ACK\27733\1218N_[*\1075509\82994\b\FS\SUB:\1045237N\998570ay\ESC\8175\983838d\nBy\1088104Hn\US3?\191176\190202r'L\RS*[S\145039o\1063510i\STXp#w^;\DC1x\ENQS\ETX(X\DC1e>\1018817+M.o[\1104806:[N"
          )
    }
