{-# LANGUAGE OverloadedLists #-}

-- This file is part of the Wire Server implementation.
--
-- Copyright (C) 2022 Wire Swiss GmbH <opensource@wire.com>
--
-- This program is free software: you can redistribute it and/or modify it under
-- the terms of the GNU Affero General Public License as published by the Free
-- Software Foundation, either version 3 of the License, or (at your option) any
-- later version.
--
-- This program is distributed in the hope that it will be useful, but WITHOUT
-- ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
-- FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
-- details.
--
-- You should have received a copy of the GNU Affero General Public License along
-- with this program. If not, see <https://www.gnu.org/licenses/>.

module Test.Wire.API.Golden.Generated.RichInfo_user where

import Wire.API.User.RichInfo
  ( RichField (RichField, richFieldType, richFieldValue),
    RichInfo (..),
    mkRichInfoAssocList,
  )

testObject_RichInfo_user_1 :: RichInfo
testObject_RichInfo_user_1 =
  RichInfo
    { unRichInfo =
        mkRichInfoAssocList
          [ RichField
              { richFieldType = "g\2429z\DC1\CAN",
                richFieldValue = "P\\\DC1\187432:S\ETX\32153#?\1094758D-\53832\ETX!G*d\27577Q\r@iUL~{"
              },
            RichField {richFieldType = "D\FS2\1060013\1040590I=&\"jB", richFieldValue = "3B\f82S3g\1050810"},
            RichField
              { richFieldType = "\ESC\DLE\1010374\148212)\\_\1069792R\SO\169388\&6\131938(sj\1058023\r \5289c\DC3",
                richFieldValue = "D\SUB={#%\"@\149963\134601\24217"
              },
            RichField
              { richFieldType = "\ENQ\1067691\1082151#=\1081297\144071\52731\&4\191119U>?I59.\SILW",
                richFieldValue =
                  "\173232Q)`\NUL=\1064973\RS @)\GS\r\59682\1038627~\1011963v\DC1|'\135254\1067331\&1\2425`\164333"
              },
            RichField
              { richFieldType =
                  "\t\1031482;\1085515!\1064099\ESC7\np-$\1014378\f\DC1\US\1050862\63813K9\DC3Z\NAK\EOTmi;@qL",
                richFieldValue = "S\ENQ\989696"
              },
            RichField
              { richFieldType = "\DC2Q\1034570\EM'O\1005017\1010419D(F\1076993\ETB\180349\1083956\1091601m",
                richFieldValue = "s\b|\US\DC3\EOT\62682q#\174887\983530W;\v]p\ACK\95382~\1048359Z?\154887,\1065610"
              },
            RichField
              { richFieldType = "\ENQ\180890\1043361\96286\40660\1068097c",
                richFieldValue =
                  "\189561=Z\SIJ\NAK\49254:\1038074xgo\1048189\STXw\EOTJ$\SUB5$\23982S\1081594\27123\EOT"
              },
            RichField {richFieldType = "\SO\170317o\140811i\1071183/\DLE\1025125d", richFieldValue = "t\STX\16212"},
            RichField
              { richFieldType =
                  "\RS\148708\STXW3]d\b\991238\67362_\1013583\USW,\akL\DC1\1050950p\SUBf\1057033\1024344gcL",
                richFieldValue = "z\GS)hw\NAK\r\151713C\CAN\1108320\1030921\&4\ESC\23284\ACK"
              },
            RichField
              { richFieldType = "\")6\17875\5468Pkk\1045073}Z\1110179@\125026V\179761ndaZQ\NAKE2",
                richFieldValue = "\143300\18455Lr\154689\53965ipVJ\175301DdYj#~\t\1028764\58578\b\1081333\RS!j\US"
              },
            RichField
              { richFieldType = "[9\1073852\168436=\20418\51657\95646j.r\ESC\US\tR\fz\ETX\EOT\1019370T",
                richFieldValue = "\RSp\166374"
              },
            RichField
              { richFieldType = "\STX\STXk,O\1060196\STX?\DC3\SOb\38907@\1027869",
                richFieldValue = "\12437\DC1\994185j\189202\RS\\\1088457\a\ETB\fZhL\t\DC3u"
              },
            RichField {richFieldType = "^\83050", richFieldValue = "q3"},
            RichField {richFieldType = "\1055672A\DC3*J", richFieldValue = "[\68088\b"},
            RichField
              { richFieldType = "z=t\t\f\1085812G9F\\k)\1091523\&3\NAK%\1057406\t\98873*\DC2df\SOH",
                richFieldValue = "q\1063201M7UBI\b\EOT\1011587W\t\NUL6>_Q\DC3}3\b\"x"
              }
          ]
    }

testObject_RichInfo_user_2 :: RichInfo
testObject_RichInfo_user_2 =
  RichInfo
    { unRichInfo =
        mkRichInfoAssocList
          [ RichField {richFieldType = "\1026845n\DC3`", richFieldValue = "&jij\174483"},
            RichField
              { richFieldType = "$\SUBV2M:$\FS\FS\983478\1036867 \188370K\DC3O\994673B\1040851**O(v",
                richFieldValue =
                  "\984118Y\1052071Z\174654'\45711jw\92200q\131756\1060137\177667g1<\127066bj\1012864[\15994"
              },
            RichField
              { richFieldType = "%^\1055456co\DC2\1023692-}\RS\1066540]\95288A@\8581\13205",
                richFieldValue = "&\DC3\".9\147680a\NUL\"TM\1028285\USD\1027224\r\167865U"
              },
            RichField
              { richFieldType =
                  "\SI<$o\1080065{x\1084348dJQ\1028519\US\1061646,\1081852e!\65125\\\190502\1045352\176028\ACK1\987572s",
                richFieldValue = "."
              },
            RichField {richFieldType = "+[#5Y", richFieldValue = "\FS\fW\1056959\1109241\STX"},
            RichField
              { richFieldType = "q\CAN\DC1\178224\US\a\DC1%:\1010427w\178018wR\99191\168866MI$KYwui",
                richFieldValue = "{\RS\SYN\188327(\1082423"
              },
            RichField
              { richFieldType = "Jw\r\ESCa\8321s\EOT\61199fI\GSvbN\"\DC4",
                richFieldValue = "w\txslJ\1020914\1019999:\17704*[g\\\rQ\31267~p}Id\n\SI\97643O"
              },
            RichField
              { richFieldType = "",
                richFieldValue =
                  "\ESCqo?\GS\32435l\993979\182775d\ACK\SUB\137952\&0\145394\b\1087713y\92570Z\SIe[w\489\1011252\995040\155780"
              },
            RichField
              { richFieldType = "\bfpK\a#\127847\&8r\983899v;xl$b\ENQ\vQ\170504'!m\1050214_j",
                richFieldValue = "$\NULbF\1061453z%\152393"
              },
            RichField
              { richFieldType = "\b\1011378\SUB\CANzlI.sA\177124(\1052796%\1069280\873\t\SUB3S",
                richFieldValue = "\1102669Y\SUB\177803B\119808CMK}P{\ESC\74560PE\EM\1099246"
              },
            RichField
              { richFieldType = "V",
                richFieldValue =
                  "\187112*\1112986\CAN\126084\46509x\989987\1080949\asm\GS*y\146261\154786\20555^hz1\1880-\DLEL\69769\1001767t\1041360"
              },
            RichField {richFieldType = "\1078861\fcO\135489F", richFieldValue = "\ACK\FS}"},
            RichField
              { richFieldType = "\987511\30083\1003719\&2:",
                richFieldValue = "@~99h\9823\&9\1055586j\1049594\US\1076810\fR\176843\SOH\49280\SO\25775o"
              },
            RichField
              { richFieldType = "\18259^\74414\1109348\1104732-\51802\1021424+??\ACK\44078\155474C=",
                richFieldValue = "NX\SO*B@h?l\ACKy\SYN\137774.40E\NAK"
              },
            RichField
              { richFieldType = "\1061888\ETX\EOT'2\189418~7KQs\1079491>\CAN$\DC3kn?\SI+\6940\173932aO\a\128390",
                richFieldValue = "\DLE\54911N\DC2DaZ\SIt\1066992EMf`N\1071075.\178352"
              },
            RichField
              { richFieldType = ",\SYNP\SUB\SUB@C",
                richFieldValue = "\" X\DC4\EOT<n$n=gyY\18620\EM\1021188:."
              },
            RichField
              { richFieldType = "Tg\b\173913v\167782YB\1021331v0w:\EM\fZ\95273yQ",
                richFieldValue =
                  "\1025830p9?\DEL\1096870\SOH\CAN\ETX\r\CAN`lPB$\1091075z\1101696aT\10409W+/`\SOH\1075184"
              },
            RichField
              { richFieldType = "jv\1054282h5U\NULkd4\1063190\DEL2BG\16643Q\19315\1061945",
                richFieldValue = "\r"
              },
            RichField
              { richFieldType = "\1036947\DC4\29441\v\1002978\b\164177}\27883\SOHC\DEL\143850",
                richFieldValue = "`\62230\DELO\1059922<\NAK^\vc\164665xb\RS"
              }
          ]
    }

testObject_RichInfo_user_3 :: RichInfo
testObject_RichInfo_user_3 =
  RichInfo
    { unRichInfo =
        mkRichInfoAssocList
          [ RichField
              { richFieldType = "t\1024461v&>M\CAN4?Bvxr\CAN\1076280",
                richFieldValue = "\ESCb>K}\38615\1040804Y/\1048016\SI;\1096919w\DC4\1082463\&8"
              },
            RichField
              { richFieldType = "\RS\SI$\187800xP >\NAKjGF(xRw",
                richFieldValue =
                  "\a\9557\1026585q\DC4\1018495w\134366\152669\ACK{(r#\1106494\SO\1092375\985453=c\1082787"
              },
            RichField
              { richFieldType =
                  "\1050304\176395of#\30220A\1088996\47289\CAN\b{7\1053786\ESC\EM\171511F?M\1090325 E4\95842-+",
                richFieldValue = "\146076;C\f]\FS\1078031\STX6o\1081985a{\64711^\STXXS"
              },
            RichField {richFieldType = "\SUBN", richFieldValue = "\ACKCI\1054448\12163S\1044803e\NAK\133266"},
            RichField
              { richFieldType = "S\100562A\ETB\b4\180783\"\1031515H\ETXL\DC4\152027YF\SUBj\186510xij\EOT\1070020Sl",
                richFieldValue = "5C\1113830"
              }
          ]
    }

testObject_RichInfo_user_4 :: RichInfo
testObject_RichInfo_user_4 =
  RichInfo
    { unRichInfo =
        mkRichInfoAssocList
          [ RichField
              { richFieldType = ">NN\184215\RS[N@x\STX\1044432X\1036744\NUL\r)w\1066544\ESCu\fg\61700\160192@\DC1",
                richFieldValue = "N\r\t\1006657\33991\97459\995407"
              },
            RichField {richFieldType = "\18052;", richFieldValue = "\184918\68001\30896 \US\EMp\DC1\SOHr\1066536"},
            RichField
              { richFieldType = "\1025988\ACK\1045120i\139213;=/3\1087376\"U",
                richFieldValue = "\ETBK\SUB\SUB\SO:\1027091y\SOH\173945]`\58105\ETXe\DC1O:\159156h~akL\NULu\999959t"
              },
            RichField
              { richFieldType = "\1110994\1037410\ETBJ\1022016K\1061472K\161981ct\132829B\992158\1107226\148096\&2",
                richFieldValue = "\DC4\164340\&8,\61665*\1019296&JP\bpzN\73861a\n\DLE{\DEL& Z+/i\96649"
              },
            RichField
              { richFieldType = "\23507\111040\101002]7\165650\1104101;\1014368L[)3\SI\vfZ=[",
                richFieldValue =
                  "^\ETXq(P\STX_\137162k\1080450i\153078\983225'\DC4\ENQ\DC12J\SI\1071012i\1073773\1008155"
              },
            RichField {richFieldType = "\137399\1082136\\\NULhOWZZ\48526(t", richFieldValue = "}8\ETX|n1\12176"},
            RichField
              { richFieldType = "{\188409=",
                richFieldValue = "^\1001460_\STX\CAN_\25489\CAN\ESCp#BS~\1109647#\SI"
              },
            RichField
              { richFieldType =
                  "\53139O\RS$7[J\1016551\&7W\61439b\171218\DC4\1007833\997544\EOT){2)\t\62610\DC1\1065678qG\1054082\997682",
                richFieldValue = "\18445\&3>\"sn\1072416\&4"
              },
            RichField
              { richFieldType =
                  "J\1096579[gHH\rjs\DC1%h\996332\ACK\161759}rh\183657\STX6\ENQ\994477_\US\DC3-.\CAN\57462",
                richFieldValue =
                  "V\173325~\a\144121h\tq\t[S\1013480\FSDa\STXN4\99669\152357\24029\&0\1099787o\60898~\145739"
              },
            RichField
              { richFieldType = "]|:\184436`\16885\1054533A\RS6",
                richFieldValue = "0R\5037\1104789\986919CrX\5130oA;K\148428\1089410A"
              },
            RichField
              { richFieldType = "-\ETB\136638kI\1084383",
                richFieldValue = "\a\RSN B\a\1006274\177369\GSoc*%"
              },
            RichField {richFieldType = "\\Y\fr\ETX\SI", richFieldValue = "4\1043727M6J"},
            RichField
              { richFieldType = ".\FS%N5=`\EM\ETX\1042853\DC4t3@\178711Oz.\DEL\1058566\40011\&0IG\tdk>-\1093087",
                richFieldValue = "8U\RSJ6uNV_\v"
              },
            RichField
              { richFieldType = "(7j\1113940\57870S.,_",
                richFieldValue =
                  "\139990C~\36700&=\1093292\NUL\1093495Va<\99224\78597!\776\1055220zK\7834~\\\42673\170534\EM;a\101078)\63284"
              },
            RichField
              { richFieldType =
                  "\137386Q\"[\1094790\ESC\1080088[{\1012551\EOT\153991\ETB\65105\&5Cl\EOT\SOH\63159\1033642ZA\1087819R,\28980/\136301\1021968",
                richFieldValue = "K\133182"
              },
            RichField
              { richFieldType = "\ETX\ETXW\DC3\NAK\1112125=U\1030033\1057159\n\984643Fd\33768'\a\RS3\a,\NAK#\NAK",
                richFieldValue = "\ESC\US\1093980\155242"
              },
            RichField
              { richFieldType = "3#u\157205\67212zf'G\US\SON\39399\1038358\1061837\145791n",
                richFieldValue = "J<~ \13084?1\SOh\r\1113196\SO9s\1036192\65759a\1090172\153198\DC14\132642CNI|"
              },
            RichField {richFieldType = "^3\59726\1021500&", richFieldValue = "4/S\fC\1092592\998665J\"|\SIHy\FS"},
            RichField
              { richFieldType = "\t@\96065\7066Pt\989465\1015135ql.\DC2\132219-\US\149402un=\GSmM\v\SOHR",
                richFieldValue = "\19317TQ^(HF'<JVF\RSbX%p\1046589x"
              },
            RichField
              { richFieldType = "\STXHe\r\SUBk\36037,\USM2v\b\RS\189773z\34652\ETB\1019627\DC4\NUL\n\1042148=io",
                richFieldValue =
                  ">\157407\186370\&7f}\DC1rZ\rs\48680Nh\"\111114k\2311\37338\1052055as\62033$|7\1023374A\990573\1015545"
              }
          ]
    }

testObject_RichInfo_user_5 :: RichInfo
testObject_RichInfo_user_5 =
  RichInfo
    { unRichInfo =
        mkRichInfoAssocList
          [ RichField
              { richFieldType = "\6820\t\b]\1056536\USx\ESC\178974jk\129614/X\DELiyg\US\t\1077298",
                richFieldValue = "oR+o\43203\&7e\1099830\&6MA\ENQ3Y\1089962W~J"
              },
            RichField
              { richFieldType = "+\1068744\172657BQ4\1020089bZ>?\1099625?\NUL a\92434|K\1039090>5kR",
                richFieldValue = "\SIbs2`\DLEMD&\1070231}RUx\FSi\DC2\ENQSjt6\166010\1057829\NAKV\t\EM"
              },
            RichField
              { richFieldType = "",
                richFieldValue =
                  "\1110695\1097480Tq\16015\156907\USM\1067573vr>\RS\992825r\194921~Ho4\178423Fpq\1066729y]^"
              },
            RichField
              { richFieldType = "\29745\1000303U\US\n\1111538\r ",
                richFieldValue = "@\805cl\SOH/\97433\1039371n\1097054"
              },
            RichField
              { richFieldType = "\37590\131324`",
                richFieldValue = "\8967\nv\EOT\10967\RS\82995y&jy5F \1049295G\1040173+\156573\fu\SOM\98366\&0\ESC"
              }
          ]
    }

testObject_RichInfo_user_6 :: RichInfo
testObject_RichInfo_user_6 =
  RichInfo
    { unRichInfo =
        mkRichInfoAssocList
          [ RichField
              { richFieldType = "\\\43009\SOH\133826tV",
                richFieldValue = "\ESC\184321/\1076982ZA\54627\1029646\DC3IE\64065{\ACKpV\48701k"
              },
            RichField {richFieldType = "[0\DLE\172396", richFieldValue = "L,5tm9\EM"},
            RichField
              { richFieldType =
                  "(\1056899\&94\1068984\SYN/\1090403\DC1@s\1024296\1029175\1099709:{\SOH\"K\ESCX\12540Fs\1081566\1032508",
                richFieldValue = "AL\n\42405\128525\EMO1}\DEL\18075\rO#.gxE"
              },
            RichField
              { richFieldType = "\190199\44619k\1060713\SIdzA45\"j\62171\25208b$\ACK8Fg{UQ.",
                richFieldValue =
                  "!3\CANV\FS\r(*'\1046479\1072827\1111092z=\1033680\7976\DLE\1089119-\SYNt\DC3\1084330b\STX\ETXV\SOH"
              },
            RichField
              { richFieldType = "\RS",
                richFieldValue =
                  ">{I\48810$\189299\128703\191362\SYN\SI\183475x\63481Og2\GSv0\1006696Ih\SYNP\148138m]\61394r"
              },
            RichField
              { richFieldType = "=P\1059943xO4\15200n\FS\1032310U\1043187pnHu{\152121;\1029448",
                richFieldValue = "-\1092750\&3w(n\7300\190533>\SI\FSO\67319\&05~\f"
              },
            RichField
              { richFieldType = "co\GSP\1088511B\1009528,&\52920\986643\ACK$kap",
                richFieldValue =
                  "d\SOH\991613\11391\ACKD\1100648z/\DEL\NAKK\30183\1077152\ENQ-\EOT\SYN\DELy\DC1\NUL#\USlT"
              },
            RichField
              { richFieldType = ")\r\ACK\GS\1043890\&3f\ENQ\1041726U`\SYN\34924,\SUB'\NULB",
                richFieldValue = ";\FS\126223\USD"
              },
            RichField
              { richFieldType = "\vAA9\n\DC16)h;\42048\1012586Qj{d\33864%\1004205c\RS\1038376\\\99811O\DC1,a",
                richFieldValue = "\"xaCQ;\37852C^\USwm\179289(N\1065173\&6 +\DC2\USX;"
              },
            RichField
              { richFieldType = "O\CAN)p\149374W\ESCa\1041977\169728\NAK",
                richFieldValue = "\EOT\1042388r:[G\GS]\SO6B\1019567\141536#W\DC2\158237\68627\ETX\1050656,\DC2\ESC"
              },
            RichField
              { richFieldType = "Pn\ESCA\ACKbc\134214hv\"M\185501\33235\29556\v'C",
                richFieldValue = "]-f_\ETB"
              },
            RichField
              { richFieldType = "\1102745D\1008540:\SI\DC4f\27021\1079064|@",
                richFieldValue = "Ka\f\NUL2y\983919u\1061024wh\DC1\\\1086719\1064224\v6Y"
              },
            RichField
              { richFieldType = "\1056530\&6.\1018673<\120773\998464l\41416\DC1",
                richFieldValue = "\1109906\99906\CAN\1087700\1094984\ve\176866\1034268\ENQd"
              },
            RichField
              { richFieldType = "\GS\160173T~+\DC1\171828\1078883p\12312_\r(\1015242\USP\EM#X\169561\126241\27018",
                richFieldValue = "\SI\154350\1003041\&4S"
              },
            RichField
              { richFieldType = "\1098164\t\127100\r",
                richFieldValue = "8U\15253\&2A\1029816/J\aD57\1087174\SYNdC\181524\n\19313l\ACK\DC2="
              },
            RichField
              { richFieldType = "CK%\136674\21597[\1053416,}cMJU/@\1068826\40545",
                richFieldValue = ")\SI1q\ENQ"
              },
            RichField
              { richFieldType = "wm\STX\165315\ETB\a6\1014425G8\1053002f\121073\SUB\1039792m\DC1Y\v)9x~>Q\n",
                richFieldValue = "=21yL\b\"\168592,\1034030\DC2\b\60830\r\134463\USm hf}iU\155381\SUB\b}3I"
              },
            RichField
              { richFieldType = "\NAK >\SUB\SOhem=,1\CAN\STX\166471\&8",
                richFieldValue = "{\DC2T_\ESC(JaC7|\EOTYKi\DC3\ESC:l,\167224"
              }
          ]
    }

testObject_RichInfo_user_7 :: RichInfo
testObject_RichInfo_user_7 =
  RichInfo
    { unRichInfo =
        mkRichInfoAssocList
          [ RichField
              { richFieldType = "xNP\1049100z\CANs2\987661",
                richFieldValue =
                  "[#ok\FSR\v.@Al\1064744\154659\&0]\1089611*4$0u<\173498\59461\66810\STXS\SYNc\51629"
              },
            RichField {richFieldType = "\995507\US1>c", richFieldValue = "Ly\FS3bG9\1043657H\20460g>(\DC4"},
            RichField
              { richFieldType = "%f\61759\DC4\n\1058224C\1062392m\f\ETBqUa\EOTC",
                richFieldValue = "3rXe#Hlq=z\176833*;|\1014731"
              },
            RichField
              { richFieldType = ")\160204.\DEL{\996888t_\STX\1092919E\137060\a 8?",
                richFieldValue = "W\169422&\1026034\n^\176216ME\CAN\ETX\1090011f\1110687\48242fsL\38118"
              },
            RichField {richFieldType = "\DELL4", richFieldValue = "V\f+{x\1006327\121401Uew$at"},
            RichField
              { richFieldType = "7\FS\SOHr\a\62100\917588\22363a4",
                richFieldValue = "'\EMa1\40150\DC1S*z]\139187:&M"
              },
            RichField {richFieldType = "\NULGo\65772\&3\10817\1021570", richFieldValue = "H\1013025I\60747L_"},
            RichField {richFieldType = "", richFieldValue = "\13196\1007995\DC4\tx\178421d|q\DC1t:0"},
            RichField
              { richFieldType =
                  "b<\1092750\GS\68040\DC4\1086388\1103364/\1067257:\51893)U\5505\175390\SOH\162803\GSp",
                richFieldValue = "@9\b\t\r,^\1082496\844\985421\SOHBL2=\180250S%\NUL"
              },
            RichField
              { richFieldType = "+",
                richFieldValue = "X\FS$\1106188\22234e\DC3$X1VI\\\169355`\165248z\EM^\v\SO\1074392aq\1001898H"
              },
            RichField
              { richFieldType = "fWu\SOH\1113202\NAK\STXQVk\180684_g\NULlAK\154794M,b\99737\1095059",
                richFieldValue = "o6!M\DLE\1089465\19837\STX[\189720\993500\74187\191020[\1080325\r\144524\64614Y"
              },
            RichField
              { richFieldType = "\SOHo\RS\35961-(\1102197)f\ETB\995930S\1020981k",
                richFieldValue = "NO#r\995433]\ETX4hX}\1040553\NUL\10166\SI\US\CAN\152188\&1\DLE\DC2I=y"
              },
            RichField
              { richFieldType = "8\50898\&8Mh<\" G[-W]\RS\DEL%\160175\1021098a\a3\NUL\169094\72791\SYN",
                richFieldValue = "\993468\1041193_\SO\49981B^"
              },
            RichField
              { richFieldType = "Vx\SOH\24511{\1072255le^\FSp\1052403\97860\38253Z\177575\ENQ]}?\189892n\ETB",
                richFieldValue = "\5244\983510C\SI:<\36686\&0nN\ba\21143\DC4c(m9)\ESC }>\"|\CANk`\f"
              },
            RichField {richFieldType = "\39899\1019692", richFieldValue = "\1017708"}
          ]
    }

testObject_RichInfo_user_8 :: RichInfo
testObject_RichInfo_user_8 =
  RichInfo
    { unRichInfo =
        mkRichInfoAssocList
          [ RichField
              { richFieldType = "\996744\1040115\147468k#3\rq\CAN",
                richFieldValue = "Y\nz'\186344gm\172323ambJ\992129\v\"\aSo)oD\f\ETB"
              },
            RichField
              { richFieldType =
                  "yxP?wI\24757O\1351QO%\DC3\131814\ETBE\75036\1066295\155581:\1032172\1025380\b\STX\989849\SOH\11090\92397\"\12866",
                richFieldValue = "H\DELqg\b\94447\23996S\EOT\176015\155222L\1084850"
              },
            RichField
              { richFieldType = "\\\78873n",
                richFieldValue = "~\FS\v4\1079307zS\SO(2-Ud\1070675\v\fq\"z\STX"
              }
          ]
    }

testObject_RichInfo_user_9 :: RichInfo
testObject_RichInfo_user_9 =
  RichInfo
    { unRichInfo =
        mkRichInfoAssocList
          [ RichField
              { richFieldType = "dG\DC42\51806>+\ENQJ\nxE",
                richFieldValue = "b\GS\61321\1083098\a\96353\&5\ACKr;jN\22592\DC4\17664\ETX"
              },
            RichField
              { richFieldType = "^8OeZneC",
                richFieldValue = "\SOD\a\989682\1042575H\19797\1094384\1062105Eh\995364G\DC2mp\30208"
              },
            RichField
              { richFieldType = "z\59319k\78088\132108s`AJ\8069=R\"AD\EM\ark_\175232\&1\au!\151517$",
                richFieldValue = "&\171354:\SOH\\@\f\1086433\47766C\39740\&8*\1068287\\y<"
              },
            RichField
              { richFieldType = "\EMK9\DC4'`zu~\\\177586X+\DC1\136898\ETX\DLE*0\n\194804",
                richFieldValue = "y"
              },
            RichField
              { richFieldType = "\172791?",
                richFieldValue = "\93843\EM\STX\SOH\NAKT\994262\24112`\1103632\v"
              },
            RichField
              { richFieldType = "\DELEt\SIz)\DC1\NAK|mp\1108553\ACK\20179\997087\DC1v\164126\SOH\58965]\STX",
                richFieldValue = "euR\EOT\133332KC\t\SUB\23119\140712\74009M\GS\ACKP0\1074111o\"j\60195"
              },
            RichField
              { richFieldType = "\STX\1068428)T\124990\"6",
                richFieldValue = "\984541\163078bIB@\SYN\DC25\54902\FS\EM\ESCy\t\21520b"
              },
            RichField
              { richFieldType = "\ETX\58455\1012497B",
                richFieldValue = "\ESCnd\NAK\ESC;Ch\49479d @\US\FS\1088714}17Hb=x\1103297\10289\ETB"
              },
            RichField
              { richFieldType = "!i",
                richFieldValue = "-j\176648,\24865\SYN#\ACK\1066770G\1100549\DLE\15747\NUL"
              },
            RichField
              { richFieldType =
                  "\870\SI4\172785\rN*\RSuG\DEL\DC3\STXf\n\ESC\155932\ETX\DC4\1093311\83220\1003038W\1025832",
                richFieldValue = "\ENQ3M\42564\1100947\fk\180860\CAN\129409b>e\STX X\63642KB\21649{1"
              },
            RichField {richFieldType = "T\DLE\SI9\1050714\GSs\NAK\NAK", richFieldValue = ".\r\5027P\EMs\991431"},
            RichField
              { richFieldType =
                  "\USE\t3\NAK$\1024518X\1073745\67685\21705\1060555\&4\ESC=QU\SYN%#\1073993%hT\EOT\1031319",
                richFieldValue = "\RSZm3"
              },
            RichField {richFieldType = "E\28759\SO", richFieldValue = "\1054689\EOT"},
            RichField
              { richFieldType = "I\182277z\177877$\SIGf&>\DEL<h\SOH\137183\ESCZ\1100935",
                richFieldValue = "Gw\ACK\US\189369\EM\1101274\STXmd\ACK\SOH%_mS=\1012437Z"
              },
            RichField
              { richFieldType = "\1065708sR\185993\v\29282?'\DC4\r.\ENQ=",
                richFieldValue =
                  "\38444y\"J!>'\1064172}/Y\1061779?\1041416\71840\1036110\23841\SO\8255\\=\33718I\99375`~7"
              },
            RichField
              { richFieldType = "JL\1075555'\STXN\NULi\"8%`\ESCmBk74^\168234j\FS\181808\SUBG`ZW\FS",
                richFieldValue = "+IkzzeG:&\b\EMl\NAK\60543"
              },
            RichField
              { richFieldType = "\1369\164654\&4:\148996t\59418\&9\59097\&7",
                richFieldValue = "CS)\48559_\r"
              }
          ]
    }

testObject_RichInfo_user_10 :: RichInfo
testObject_RichInfo_user_10 =
  RichInfo
    { unRichInfo =
        mkRichInfoAssocList
          [ RichField
              { richFieldType = "\SOPX\1027633_f\rw,S6\DC1\nF\STXO\DC2\SUB+\ESC\166811\1104425\STX1\19418",
                richFieldValue = "\33494aEIuIc\5245(p9p"
              },
            RichField
              { richFieldType =
                  "\40295\CAN 1\GSn\RS!X\SUB\153582\59295DXM\STXks\1095401\1081096\RS\1016479\SI\CAN|\NAKB",
                richFieldValue = "@\NUL\20896!#}"
              },
            RichField
              { richFieldType =
                  "\1080518\132546\1104035r\1011309\NAK@\DC4Oh\EOT\60905\\\r\983916;E\1145\SUBgM3\DC3\188575\131886",
                richFieldValue = "\CAN_\46754\64756{"
              },
            RichField
              { richFieldType = "N8]@W\1005031\1044578",
                richFieldValue = "(}qXz\SYN\v\135879\185617A$*\1012653q\100033xz\tv@"
              },
            RichField
              { richFieldType = "\129176\1106421\1042142'~\1037209\1084768Lyj",
                richFieldValue = "g8\1060434\ENQj]m\170801\SYN\SUB\STX\t\140983\&5"
              },
            RichField
              { richFieldType = "*<\1103682\FS\1024394\&4\1095255\163632UZ\20204Wv",
                richFieldValue = "u)Cp\1007443u<@\ETXcs-J5\1041579'\ETX}0\DC2E\984152\US\52983.\r0\160508"
              },
            RichField
              { richFieldType = "]",
                richFieldValue = "~}9\DLEZG\142993d\1054746h\172268\15548g\188284\&0)6\DC2=\181714\&3"
              },
            RichField {richFieldType = "F\149516", richFieldValue = "LJY2?\1017439\FS\NAK\1005028\1045714\1002574"},
            RichField
              { richFieldType = "\GS#\1075143<SF\DC3>\58503YAc<I\1017396\EOT>S^",
                richFieldValue = "\171511\&6qK+P\SI\EOTq\83131*C\1029137t\1070148\96495P\t\985260Z\r\1037341"
              },
            RichField {richFieldType = ":ba", richFieldValue = ";"},
            RichField {richFieldType = "\v\DC1\DEL\FSr", richFieldValue = "/\DC3\1005753\f\26465o\STXk\1090533/>"},
            RichField
              { richFieldType = "8;",
                richFieldValue = "5\a\NAK\146167\STX\\\f\NAKG\992570\SUB\21373\ETB\48770Qj.\33305\113793u!D;\166930"
              },
            RichField {richFieldType = "VnHyJ5z<QA\1016199\a", richFieldValue = "\1000823g\aj\19079\\"},
            RichField
              { richFieldType = "\SUB",
                richFieldValue = "\NAK(\1076796A\DEL\SYN{\NULZ\1095384kE\990248\ETB\ENQW\v\SUB"
              },
            RichField
              { richFieldType =
                  "K\1052634?\GS[N\b\95820 x8\DC3b\1105709\12146\36026\&6B+`\2733\1028543\161542\171910\18589",
                richFieldValue = "U\SYN M\DC19\GSv\32294\1044199f\SI\74800N\1022109\DC2\ETB"
              }
          ]
    }

testObject_RichInfo_user_11 :: RichInfo
testObject_RichInfo_user_11 =
  RichInfo
    { unRichInfo =
        mkRichInfoAssocList
          [ RichField
              { richFieldType =
                  "\181496K\128334\43850\&6Y\1018569<\95501\ESC\97001\DEL\DC3\SYN\127039Ih39s\50773aC\25668\EOTY\1073842",
                richFieldValue = "F`?n\1108704"
              },
            RichField
              { richFieldType = "~\148750\838\1051306\1066451c2",
                richFieldValue = "\1057918\21793\SOH\tF\1110960~\165681\48165\&6"
              },
            RichField
              { richFieldType = "\1045898(,F\EM\SUB\DC17\vx\DC19\DC1qk\1027219FFU\29082OE\1109845V\27815[V9\SI",
                richFieldValue = "\68776\1034946\&1_GcM`\985055Z\62111n\17678\GS]"
              },
            RichField
              { richFieldType = "\1104001%vlo\990162i\36450E\94376I\SOHR\EM\118893G\138192n\62272r",
                richFieldValue = "\40732r\1077660\ENQlG"
              },
            RichField
              { richFieldType = "\ETX9V21\1090424WT\67216~/}h7*3j",
                richFieldValue = "v!\\\DC1\DC4@5\1046476\DC2\SYN"
              },
            RichField
              { richFieldType = "\1034165\22905qa^r\DEL.\1018757?c\DC3\157181K\SUB`-n\SO\178601=\NAK1\NUL",
                richFieldValue = "\SYN\\h-\43064ro7AQh\1000694"
              },
            RichField
              { richFieldType = "3\fRT7\1028686~",
                richFieldValue =
                  "e3Y\1108680F|\1081710\1019404\RS\1076950X_B8\1326\95177Ov\156405n\27293P\\tq\65410d"
              },
            RichField
              { richFieldType = "3\1011603\NAK+Uho*\FS\SUB{\1051900u\"\25931\27103\1054395\SUBgl\SYN",
                richFieldValue = "\110818\ESC\ESCZ6\1095572TbKn\1074509I\1109662\170807\&2He6"
              },
            RichField
              { richFieldType = "F5zYY\120105$a\119188\SYNu\1038558#w\NUL]\EM\43676oy\b\SUBkKBC\RS\1073620L",
                richFieldValue = "\15825IX\23477\1076316Ckl_\171122W^\GSI"
              },
            RichField {richFieldType = "6x\ETX/\995793D\1080761Qy0Z\\", richFieldValue = "\20953VP)\a\ENQ\GS\ESCl`"},
            RichField {richFieldType = "\ao\164897O:\25281\a", richFieldValue = "\1024146"},
            RichField
              { richFieldType = "R>,\37567N*E\123614-\DC1b4D\30593N\180897%dU",
                richFieldValue = "\1084452:^\DC4\STX"
              },
            RichField
              { richFieldType = "\1103012\160707\CAN\RSKYPg,\188305n)\SOu\163821b\NUL3\NAK\DC3L",
                richFieldValue = "Pm\182166`\SUB\38452<F\1081678\DC47g\r5"
              },
            RichField
              { richFieldType =
                  "<cW\SO\GS1\DEL{\26768\1030976\ACK4\SOHn\47648\&7;&\DC4\SOH\STXk\GS\1096557q\166472\n%\186138\&9",
                richFieldValue = "\1080445\988398sCpj\ETB\t\ACK\bQ\USA\145366\&2\1082437\SOH6"
              },
            RichField
              { richFieldType = "\CANOAYI!\57771P\59570\990465\&2\1065241",
                richFieldValue = "\FS\DC2^\17821"
              }
          ]
    }

testObject_RichInfo_user_12 :: RichInfo
testObject_RichInfo_user_12 =
  RichInfo
    { unRichInfo =
        mkRichInfoAssocList
          [ RichField
              { richFieldType = "!_ZO\128191\78114\140777#zFc\bT",
                richFieldValue = "L\1074791A\nF6\176354\ESC\983230\bt"
              }
          ]
    }

testObject_RichInfo_user_13 :: RichInfo
testObject_RichInfo_user_13 =
  RichInfo
    { unRichInfo =
        mkRichInfoAssocList
          [ RichField
              { richFieldType = "\DC1\24072u\ENQ\ETB&\4554z'\1088108%",
                richFieldValue = "9i5k4>/\1084170P\178867\125043\EOT _\95110\b\36745v]NZ\166546\&8\41183}%"
              },
            RichField
              { richFieldType = "L*;\37119Q\1070203\EMdAB\1010742j,%2d?\27879\985000\STXi",
                richFieldValue = "\1027646\1007110\USk\fiZ\ACK>\101052U"
              },
            RichField
              { richFieldType = ",'\\$\a.\1109166\44708\ENQ\70074\STX\1039298\SUB\1056169!\tY\ESC\128831\EOT~\\",
                richFieldValue = "\1027088\1095777\&3T"
              },
            RichField
              { richFieldType =
                  "\119563!kP\29370\1012860y\SUB\38419\189018\r\CANnle\1095041K\1925E\NUL2\\\CAN\48463\STX\"$\1073945\&0\DC1",
                richFieldValue = "\189490.\1063496\ESC\SYNM#"
              },
            RichField
              { richFieldType = "|_T~\SO\1022534z8#$\135450\52000\1031573J \1065932X\10384\133525v$",
                richFieldValue = "x|\28060k\94531\a\917852l`hv\1030003\US\STX\1024659\CANa|\t\50480\48061$"
              },
            RichField
              { richFieldType = "\1019059i\1078290\DEL\ENQ\"\1081801\CAN}[",
                richFieldValue = "\1016282\1113241\1037865P"
              },
            RichField {richFieldType = "Bo'\1071691", richFieldValue = "\1074849G\USW.A*"}
          ]
    }

testObject_RichInfo_user_14 :: RichInfo
testObject_RichInfo_user_14 =
  RichInfo
    { unRichInfo =
        mkRichInfoAssocList
          [ RichField
              { richFieldType = "\1014091\1093623.n[\"I\38788\1105100\31720\95800D\nk\40479Xl\SIKNV\DC3\66017\&6s",
                richFieldValue =
                  "e\1084965PG@4\1015833\DC4A<\r{\1112398{V*\DC1\f\DEL\179428\DC2\CAN\1012291U+\31781"
              },
            RichField
              { richFieldType = "\181679\33025P\19610\&9/\t7\1061431!\FS5\20975M\98454\blB\fvr",
                richFieldValue =
                  "\1071654\&07\1104094w,;7\a\1054443\SOH\1112898TAM\r`\DC1:\1031521\191112\101080F}\ESC\127986\EMf\1035128r"
              },
            RichField
              { richFieldType = "\ENQ`Ws\ESCG\SOH\\\\9lR8\37341$\b*\NUL. \SI\DC4",
                richFieldValue = "y\1004237\1005188L[\DC1"
              },
            RichField
              { richFieldType = "mM#",
                richFieldValue = "\136822\34377\1098535e\DC3+\990454[\ACK\1091108'\180365h\1017300"
              },
            RichField
              { richFieldType = "\STXKms_\147875\1013676\DLE\1065323\&0\1055030\fK=\\!'\DC1",
                richFieldValue = "4%\SIGO\aJw,\152681Tg\US\1110016\RS5[\18050\EOT!\1050271G\1010373:\1000335N"
              },
            RichField
              { richFieldType = "T7a)3\EM\180358\r",
                richFieldValue =
                  "\917Wn|(u\DC2:ua\137861\&7\1068934QCS\r>PsL\1036871\1010307\156099\1096637\ETX\n\30862"
              },
            RichField
              { richFieldType = "\RS\1083417\GS(\1025144=\USo($V9Cj*\GS>M\4403#\SYN/",
                richFieldValue = "e\r\1000228\1007131NyA \4739b\1069467'\GS\1107548:"
              },
            RichField
              { richFieldType =
                  "B1>\ETB:\162105r\1031637\19430h\b\\dq\1061655K\146453\158772\DC3Y?\\ \995746\NUL\48071\1046242[\v#",
                richFieldValue = "\SUB=\NULItaqMR\29680u\120358"
              },
            RichField {richFieldType = "\4181", richFieldValue = "\1003269y\ENQ\1079409qU"},
            RichField
              { richFieldType = "Yz\DC1C'1\1087781\43049\"U+i\\\1064196I\SUBw",
                richFieldValue = "uz4\188775K\1009032\ETB\164781OI"
              },
            RichField
              { richFieldType = "p^\1036228f\DC2\1058801\1076288?h\1065533\1002307\SUB@\f\EM\1012893\936",
                richFieldValue = "~\US\1037681\989399\SIFX[\917929\165326\154483L|`\1095268&"
              },
            RichField {richFieldType = "\t\1097932f\986554hU\1028149Rdk3\ACKP\ENQAu2,D", richFieldValue = "7\98067"},
            RichField
              { richFieldType = "Ud=\22968\1109413oJ:\1005775P\1064835",
                richFieldValue = "U\ENQ\ETX\SUB\nz\b^\1083316!\r\1001089\1098359\t"
              },
            RichField
              { richFieldType = "\NAKSp\DC3U%t\41605S\ENQ$",
                richFieldValue = ",j.\DC2r\SUB\ACK\"\SYN\1020624'2<\f\37077\99687=4"
              },
            RichField {richFieldType = "\DC3Il4", richFieldValue = "\FS\DC39W\n:\999550\&13\62323\&0\ENQ,]2X\62000"},
            RichField
              { richFieldType = "N\v1\132939\52614r\NUL\1110615\50555\1094310e\139052)u\990450\1022995\17425FF",
                richFieldValue = "\1015477\8070G\NUL\US'xQ\DC1jc\83340\9630&\SUB)f\bM\1029846"
              },
            RichField {richFieldType = "\DEL~\SIjHN^0\187078\132217\ENQ\174399\SYN;-8U", richFieldValue = "\30972"},
            RichField
              { richFieldType = "3*\45297\FS`(u\184681\EMZ\179715=\RS",
                richFieldValue = "K\1055335\993384q\984657li "
              },
            RichField
              { richFieldType = "]J\1112371O\SOud>8\ACK\tX9",
                richFieldValue =
                  "\DC1\1079759\&6\185422\ACK\"\145409Z)\28995,W\ENQ=\1034030\1095464II\EOTL\136311@0\1012257\ETX\1015906W!"
              },
            RichField
              { richFieldType = "sk&6@t\1104003\&9\1067181\DC2\1070908\59777\1054421\ESC\DC3\985203\CAN'\SUB7a",
                richFieldValue = "\94461\1049112rT\FS$R'|\GSBD2\174166\ETXA\182983\182818N\182682"
              }
          ]
    }

testObject_RichInfo_user_15 :: RichInfo
testObject_RichInfo_user_15 =
  RichInfo
    { unRichInfo =
        mkRichInfoAssocList
          [ RichField
              { richFieldType = "M\22765#\44551`C\1063368\SUB\1107863v@d\DC1\1091936\1018613QL'4>",
                richFieldValue = "\\hON#Tb'\995992\49679wE"
              },
            RichField
              { richFieldType = "\187503,\1028350~\175782<,v\1004238\1067608",
                richFieldValue = "\DLE\1081424?\5595\DC1"
              },
            RichField
              { richFieldType = "y\1022706B\14933",
                richFieldValue = "<\1023925\RS-\n\GS'\1065221%z\DLE\SUB,\DLEtSpS\1873"
              },
            RichField
              { richFieldType =
                  ";t\SUBj\1025376F\DC3i\1043475\989585=\ACK`d\1051011\95787,D\171062\6190\GS\DEL\166764",
                richFieldValue =
                  "\ETBsg\132399(Ji\134995\&4\59968L\25249\DLExG\33813\1110833!\EMIeo%sDJ\119361%\162905\&8"
              },
            RichField
              { richFieldType = "`\"\ENQ't\1043002\19452:\ENQ\29189F\DC4[KO%\168573\STX\ESC8\7536%s",
                richFieldValue = "\1010742\EM_)\1021042\83239~W:\1037825u"
              },
            RichField
              { richFieldType =
                  "-W\EOTc\145999DP|\1049982\985494\ETX\ETX/\DLEKr\39316\\\DLE\190923|\6119\148147\SOH\b\1072322",
                richFieldValue = " \ETB\t\fkR!\DLE"
              },
            RichField
              { richFieldType = "X^?U04\RS4\DC2w.{GyR\1037425i5\ACKu*\ENQ\DLE\54931f\US",
                richFieldValue = "xbF\NUL\1045664V-Jd0\NAK>x_\153552\27674\nKz\STX!\ETX"
              },
            RichField
              { richFieldType = "2\1113191\99658P(9\22865\133057\ENQ)\FS\991058\30747\&4\1024412T\187968\&8yQvP;\r",
                richFieldValue = "1\SUB;n\1013014\tl\26611\EM_-C\1014755Q6]}Y\1073009\EMzq"
              },
            RichField
              { richFieldType =
                  "'sB %\NUL\1037909d\58470i\10510\1014574\&9\25013'=\rC\182308\1092760\158838\127489\1071968*",
                richFieldValue = "0v\156492\DC37\41322"
              },
            RichField
              { richFieldType = "!,dHU\97824\RS0usQt}\1093012\&5\96594{^\v",
                richFieldValue = "\NAK&\1108383\\\\\vJ\EM\GS&tBvv>Rgq\152376ZlPy\\"
              },
            RichField {richFieldType = "\EOT", richFieldValue = ">nSp\ESCq\DC2\r\SYNe\DC2SToL]iq\t>\1054318Y)"},
            RichField {richFieldType = "\ETBV\153348&\ACKN\1045624", richFieldValue = "p\1094345cX\ESC<\19181"},
            RichField
              { richFieldType =
                  "\167658N\157255?%\b\1015267\46013\1082579?\DC1\1061799\189782)@\998920\1055016\SOH\EOT\1111749\24879\\&>`",
                richFieldValue = "%X/\36896Bi\DEL%:\14950}g)c\1074443\ESC\USY9\1048060"
              },
            RichField
              { richFieldType = "91!\1008309@l\"\987793G\ETX\EOT{\1048654\1084773yaJ",
                richFieldValue = ".3w4u,Y@\SOH\161059A\1039579\133439t\16191\"i\994375n\"%\1069886\28684\&2\1007817"
              },
            RichField
              { richFieldType = "\DC4b\aX\1038114\SUB\1007573",
                richFieldValue = "V B\1060869$HHl\1022141\1094970\165064\1095191o\1036107,~\EOTp(E\173404\&6r2\RSC`"
              },
            RichField
              { richFieldType =
                  "a\v\1099093LsE\1034580\1057375GD'\1084459a\1000511\153844`G\EM]\EOT\GS`3i\SUB\99366\DELK",
                richFieldValue = "\EOTRnwnF\1047075;5\nDK\70353KHT(\FSX"
              },
            RichField
              { richFieldType = "\147030\DEL\1101478\t\1001903Tu\1089835h3M8\1107128\1073609\&6\57804",
                richFieldValue = "WoQ\ESCa\74567F\DLE\GSmH9\1056959k\1086972\1017942\1058932H"
              },
            RichField
              { richFieldType = "\1073266~!\1008925\1055373D\1094218\ENQ\166383\&2r",
                richFieldValue =
                  "\177259\\R\DC1*A\1075870\&7/\SI\1021476\SUBiRI|\by\NAKe\1018825S\1052646OL'\1050007\58728\1067493*"
              },
            RichField {richFieldType = "-\16392", richFieldValue = "\1092654\DC1H\1039884\ACK1>_'"},
            RichField
              { richFieldType = "",
                richFieldValue = "xL\SO\1018503(\ENQ\tY\DC4\NULF\1072796[\53750\tU`twpU\ETX7\1003036!w\7002"
              },
            RichField
              { richFieldType = "BP8i3\182727@[g\189023\&3\94681OHq\CAN7",
                richFieldValue = "x&\33758\EOTiKb6t\1020639"
              },
            RichField
              { richFieldType = "D\NULq\157482|.\NUL\984337'\92184mkCiG\NAK:\a\vv's\999704\&0(\a\vV",
                richFieldValue = "\US\39041=\b\DC1,E"
              },
            RichField {richFieldType = "t\STX", richFieldValue = "\991125\&7n\173760\DC1\23641x"},
            RichField
              { richFieldType = "Z\1072137\RS\1044160\FSq\NULE\US+\1109478B\"\\Y72t`<R?",
                richFieldValue = "\EOT\1045553\186984\166475d\1024637#+r"
              },
            RichField
              { richFieldType =
                  "\DC4\"\26049\1067033\t\1036727\r\119151V\RS~\986203Fp[1PS\9012\1050835\78528g8\153659\31657YO2?",
                richFieldValue = "f"
              },
            RichField
              { richFieldType =
                  "\182235.A\1064933RX=:P\125188+3\SYN\NUL\1073662v\8360)\1060659Xn\174832\ETX\1046591\NULp\1062994\fb",
                richFieldValue = "\50912>\1102063\f+=\1016908)\f:PL\60544\1040387\1082138R>^\SOHb\ENQa"
              },
            RichField {richFieldType = "\1019521\n5\EOT\SYN\SUBp[+N\STXA\67126\&7uQ", richFieldValue = "\SOH"},
            RichField {richFieldType = "r\996362\&9K\EM3-5^)9\DC4\83199", richFieldValue = "l\FS\US"},
            RichField
              { richFieldType = "}\SOHQ=\163991a\1053863|\1042397\EOT\64759#f\1079154?\NUL#%O9fap\52814\46012L$~",
                richFieldValue = "\128003G>v<1\1044480W5s't\154006\FS\FSx>%\134986\GSb(1\f1\RS\SOH"
              },
            RichField
              { richFieldType = "V&\NAKk\5777Wm\FS\175377^\1085151\1079472\1056209\b]k-",
                richFieldValue = "\a-\STX5C\1064324\&6t\EM\1071720R\182102J- 4'\1027285@\n2\SYN"
              }
          ]
    }

testObject_RichInfo_user_16 :: RichInfo
testObject_RichInfo_user_16 =
  RichInfo
    { unRichInfo =
        mkRichInfoAssocList
          [ RichField
              { richFieldType = "\69996\1018044(\DLEad\1009697\ETX|\1032400\v\159677+\1083424NGSH\EOT*.",
                richFieldValue = ")\EOTf\DEL`j?t\1026495^/\ETX\1033332z3\1081601\f\f\GS"
              },
            RichField
              { richFieldType = "",
                richFieldValue = "S\1063143\b0\168774\SOH\SOHOj\132357\1030987LI|d\50858\SO"
              },
            RichField
              { richFieldType = "\986651\ENQ\150694>\DC3\EM\NAK\1050973RB.\22162\ETX{\NAK\EMUUq{",
                richFieldValue = "d\1064493\DLE\994288\DLE"
              },
            RichField {richFieldType = "@ffF\a(~a\EM\11790\ETX6\SYN", richFieldValue = "\r\DEL\6822~\GSn\1094005"},
            RichField
              { richFieldType =
                  "*\47340\1085467\US\RS\984588D\1052888\182344P\ACK=A\SYN-Ap\179789\1021617L\GS\GS\GS",
                richFieldValue = "g"
              },
            RichField
              { richFieldType = "M'*F*\12705v\183625\1015534\1012050Iqo\GS\1031416B1Tg\4587",
                richFieldValue = "S="
              },
            RichField
              { richFieldType = "\65625\1478j@\1004015,@w>\1048797\161243q",
                richFieldValue = "25\SOH|\SYNw\1001016\1072760\1061893jW\SOH|G\SYN\ACK\DC2\GScjV."
              },
            RichField
              { richFieldType =
                  "lPj\169130sR\1112025AV`I\1076650\185072h\RS\f\NUL\STX\1111378\CAN\990417\1044988si\"'P\ENQfQ",
                richFieldValue = "=\992370MBp)\120746\DC2\1000551\29628\1113683x\1031341x4"
              }
          ]
    }

testObject_RichInfo_user_17 :: RichInfo
testObject_RichInfo_user_17 =
  RichInfo
    { unRichInfo =
        mkRichInfoAssocList
          [ RichField
              { richFieldType = "\1109343_\142528\138815\STXqF\SYN\71236",
                richFieldValue = "qx\GS\v\GSE\97764\19005s\171451`\DEL?\EOT\DC4\US*\13002"
              }
          ]
    }

testObject_RichInfo_user_18 :: RichInfo
testObject_RichInfo_user_18 =
  RichInfo
    { unRichInfo =
        mkRichInfoAssocList
          [ RichField
              { richFieldType = "%2V\1095252\1010176D\182318[AM/S8\40410^\v\RS",
                richFieldValue = "88A$Jfrz\74346>CV^M\SI\28803\1061373uG\118883\93034\&7~o\184038\t|\rJG"
              },
            RichField {richFieldType = "\bC\1039663\&4a\69376-rVr\1023253Ok", richFieldValue = "\FS"},
            RichField
              { richFieldType = "v\DC1\167850\1060417v;\FSYp$J]\996360",
                richFieldValue =
                  "vd\13027\135325A|\a\SYN\ACKyV1\180612\"y\14201x\ENQ1Y\ENQ\173423\176610w\r\CANC\n$\EOT"
              },
            RichField
              { richFieldType = "\"\51235\DC1w\a{3W;\1109227[FS\b\92967v\1034205\998051%t}",
                richFieldValue = "\f\153104u_hv\1002985\nn\1009396S_"
              },
            RichField {richFieldType = "L'\\\67371\SUBN6\GSB2*2B", richFieldValue = "Brh"},
            RichField
              { richFieldType = "\987049",
                richFieldValue = ";E\aK%S\SYNST1/\tJ7\ENQ\a\FS\1034048\188423\r\37394\&0]r\f\1111556l("
              },
            RichField
              { richFieldType =
                  "[\SOH=\97692\135905\1031167x\20540Ob\178135\&8Q\EM5\999693y%|\ETB\DLE-\131809|\1010025\183221\54548\&7[",
                richFieldValue = "(\6642\f\"~\1083901\DEL\191218R"
              },
            RichField
              { richFieldType = "FW\ETX\US\ENQ ~a\157675gt\70352\52800{",
                richFieldValue = "\1015326\"\29580QE\1045232"
              },
            RichField {richFieldType = "s\34949", richFieldValue = "|"},
            RichField
              { richFieldType = "n\1034370\&5@\ETX\37613\US\43656",
                richFieldValue = "~q\1094854U\"\ACK\DC1.{\32242t\ESC8\20259"
              },
            RichField
              { richFieldType = "m\"N8\10851\1093529\r",
                richFieldValue = "\157692\STX\1012979A\tA\1017307mEz"
              },
            RichField
              { richFieldType = "\ENQl%g|R\26079",
                richFieldValue = "\ESC;\1033103\DC2\1020250Vi\EOT\b@k\GS~M\44511\GS|\1021725\EM\1012147\&55d}91'"
              },
            RichField
              { richFieldType = "c`EBW",
                richFieldValue = "g\DC3\DELm\NUL\1007863\NUL\32923\1039665Y\ACK\b\vy\NUL"
              },
            RichField {richFieldType = "\ACK\1036196A\n\b8", richFieldValue = "pj:"},
            RichField {richFieldType = "x|\t-\a\NUL", richFieldValue = "2\SO\353\NAK\DC3?"},
            RichField
              { richFieldType = "'3\1066359+)\183746{K\42431ZeL\ACK'\n\95067>)\ba+UfQ0I\ENQN\1053857\11556",
                richFieldValue = "\DC2\ETB\74035"
              },
            RichField
              { richFieldType = "\1010253\1049969r@\163856F~R\51994\SIud\1101925N)b\DC4\72999\1103205\SYN\35970",
                richFieldValue = "\1111732^,U\1109054\33766_\DLE^]\985387>|\983623\1023681x\1006646\1019799b\133804"
              },
            RichField
              { richFieldType = "\EM\ETX\EM{\1033181\&1\t\1097560\ACK\39673i",
                richFieldValue = "\RSS}xmTq\ACKWZ\100288\27173\DC4\DC3\189559 'C#V*d\SI~\1030342\&8"
              },
            RichField {richFieldType = "x", richFieldValue = "tI"},
            RichField
              { richFieldType = "\SI\v\ETB\SOH\ETB\SOH\RS\NAK>\188201\a\1083287\US^*",
                richFieldValue = " [\1084699L>\f\1086054"
              }
          ]
    }

testObject_RichInfo_user_19 :: RichInfo
testObject_RichInfo_user_19 =
  RichInfo
    { unRichInfo =
        mkRichInfoAssocList
          [ RichField
              { richFieldType = "\1015489\1064072\SUB,\SUB\DLE1\996289o0!&\DLE\1038878\127107\SI0\73810gk?nflN",
                richFieldValue = "O\1049034\164513v7#R9"
              },
            RichField
              { richFieldType = "29Rd\EOTn\21452\EMi\1066668\989649\&52,\EM$\69638\133262\998687l\SOWo}e",
                richFieldValue = "\3440\1097785\ESCM\125223Q6\SO\1059631\149375"
              },
            RichField
              { richFieldType = "\60256V(jc\996037b\27068u",
                richFieldValue =
                  "|l3\1034349\&1\131551)\1090308cBT\1106151\166606l\ENQ|\49962\61121\fw\1082263i\17406\DEL\GS\1077365"
              },
            RichField {richFieldType = "r\DLE\1054044\41585_Y\1002044\&0QX", richFieldValue = "b_\\\1050496C"},
            RichField {richFieldType = "vHxq\27406h\998177%J", richFieldValue = ":}"},
            RichField
              { richFieldType = "\1113081\DC2\1098831:.=9_|t3W\f",
                richFieldValue = "\10629C^B}\1080839;\148022\DELNh`/\995058<\181538-\1072087D\53575)\64715)Q"
              },
            RichField
              { richFieldType = "\143881:\ESC[&\164873\&6a\r-}\1077566",
                richFieldValue =
                  "i\1014759\GS-\1090341\DEL\136595\1046852\SIJ\46509\DC3P\37854\986378,\51628\SUB0a8\1089243\b[f\ETX"
              },
            RichField
              { richFieldType = "}rExd\1089934\CAN*O>",
                richFieldValue =
                  "&3kSY\1025832\DC3=\ESC(1\1090224\1109369\ENQ\1042954\&14\NUL'\NAK}w\33238\FS \v\1107478d|\1015150"
              },
            RichField
              { richFieldType = "\162528\1029622K8ss]\SUBR\RS!\60309!\RS?Eb\DC1`Z\45666\"0\1080195:&",
                richFieldValue = "ql\1110862y_w\b"
              },
            RichField
              { richFieldType =
                  "\vb\bSF\1043112\v[\170566\166059\DC4\USaL\DLE\1080562P\1061301J=u\"n\1065011k\71052r%",
                richFieldValue = "\120067\184886\b\n"
              },
            RichField
              { richFieldType = "9\SYND",
                richFieldValue = "\n#!d\19241G\a=&9\1083974\RSM\t\1113297\&4b\tf)~%\SOHD"
              },
            RichField {richFieldType = "\14981X", richFieldValue = "M"},
            RichField
              { richFieldType = "\a=\161876\ENQ\ETB\1004260U\SOH!@\154373\&9^\1033234{ \158498\993033\&1t!\1087499",
                richFieldValue = "\EMq\CAN\49722\&3\GS\67273-r|\ENQr\US-z\1088408%lI\183586\SUB<{\b\DC3"
              },
            RichField
              { richFieldType = "w4{2V\9102\917974 \SUB+\185894\a\48041\1018066\\+",
                richFieldValue = "Q\SIJy\1099372,\vP.\SI\ENQD/\SI\22784\1085244&\4144\&37lp"
              },
            RichField
              { richFieldType = "\SO\r\ENQ\1068159p\SO\68447<",
                richFieldValue = "V\152422e5E\GS{\987420\&2UPj\1055012"
              }
          ]
    }

testObject_RichInfo_user_20 :: RichInfo
testObject_RichInfo_user_20 =
  RichInfo
    { unRichInfo =
        mkRichInfoAssocList
          [ RichField
              { richFieldType =
                  "\1054470\&5t?\EOT\1053854#*c\1091846\EOT}\1038823\1044110u\1006349 i \48467x\1096767} ;\bp9;",
                richFieldValue = "\EMVIp\181302IDO~%6vK\EML\1079134\GSj\\"
              },
            RichField
              { richFieldType = "\DC1D&)5EOo\DC1\EM\rYArK`w^qG\50491\ETX\US@\179685\STX\SI2\v\SOH",
                richFieldValue = "d\917840D\EOT\167848w_\1036766\47041\1009030P5\b\177667JTw\vv;\SO`v^{\DEL1\ETXH"
              },
            RichField
              { richFieldType = "}w*dioz%w\1064804zJ\142392)\1018264Yr2L\SUBAQQ.rsH/",
                richFieldValue = "\t\\\998353\180134\51421r`\140532-a%\v"
              },
            RichField
              { richFieldType = "O\DC3\DC2\v\1046476sFHe\4676G'Z[k\1075454\r?\1054610",
                richFieldValue = "6)(%\EMU\1019343\EM0(E4Y%\1020801\EOTi\152951\DC2\148950}/|"
              },
            RichField
              { richFieldType =
                  "\15075u\1015306\NULNbb\989204\EMdJO\"w\v\1054768\145723\50491\&4#\EM1T\RSj\1020307\191099\41818\DC4",
                richFieldValue = "D\1067141,"
              },
            RichField
              { richFieldType = "/{t\189366*\98392/QO\1107750u\DC4\DLE[\SI\DEL44J\STX",
                richFieldValue = "\17533>\r\fZR\FSp\148269\1043328"
              },
            RichField
              { richFieldType = "Q\145717d\DC1\aj\SOHz\142682\ETBx%dC\ngaY\SYN\172017\34647",
                richFieldValue = "K{8\156875$I8Y%\1038236\54891\991952\1019539]\"rp\US\ACKK\USu\DC3\1017206"
              },
            RichField
              { richFieldType = "\FSk\48451\SI\1106066\1110636P\1087784\1092086@h\1070850{",
                richFieldValue = "\179436L\32074;\NAK\1105345\&4%\NUL2\ACK,wg'\58725\1074593]\STX"
              },
            RichField {richFieldType = "\DC2", richFieldValue = "\SOwC\US\SIQ\EOT\1030459\SO0\ETX,\CAN=\ENQ\DELPj"},
            RichField
              { richFieldType = "Y@\r?\83020!b,:,\1091216]DY\161662\155283\58191\ENQ9\NULm(aQ)",
                richFieldValue = "((\1100937\STX\DC3\26702\ETXX\987003(*A@1?\137411\&7"
              },
            RichField
              { richFieldType = "pd6\EM\53969Y\1032073\&8\30883vY\1039206\917942\1055059\"u\DLE",
                richFieldValue =
                  "* \US\1025699)\US\1029686\b\EOT(\1103647\61832*\53415\SUB(\f)S`\NULG\1104420&\1014109\172081"
              },
            RichField {richFieldType = "\v\US\65149\83292z\1079256\65560\SOH", richFieldValue = "PA"},
            RichField
              { richFieldType =
                  "\ESC\SOH(\142886M\1049171\NAK>\1018049\DC2]uc\991321\f\1112290rG\1099982#R\48740\US",
                richFieldValue = "\1087955\FS\136741t"
              },
            RichField
              { richFieldType =
                  "{0J;\67715ul\63242C*\995153\SUB.>YK\DC4@Ul\120572;Om\60727\1098276,\137724U\1008404",
                richFieldValue = "\51050\SO\ETX\5115t\1086970\SUB\SO8'="
              },
            RichField {richFieldType = "l", richFieldValue = "\66293\1029785\62768&\ETB\177091"},
            RichField {richFieldType = "\v", richFieldValue = "\1071316 \185590\&9\29560\NUL\22699\1028840Q$"}
          ]
    }
