{-# LANGUAGE OverloadedLists #-}

-- This file is part of the Wire Server implementation.
--
-- Copyright (C) 2022 Wire Swiss GmbH <opensource@wire.com>
--
-- This program is free software: you can redistribute it and/or modify it under
-- the terms of the GNU Affero General Public License as published by the Free
-- Software Foundation, either version 3 of the License, or (at your option) any
-- later version.
--
-- This program is distributed in the hope that it will be useful, but WITHOUT
-- ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
-- FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
-- details.
--
-- You should have received a copy of the GNU Affero General Public License along
-- with this program. If not, see <https://www.gnu.org/licenses/>.

module Test.Wire.API.Golden.Generated.RichInfoAssocList_user where

import Wire.API.User.RichInfo (RichField (RichField, richFieldType, richFieldValue), RichInfoAssocList (..), mkRichInfoAssocList)

testObject_RichInfoAssocList_user_1 :: RichInfoAssocList
testObject_RichInfoAssocList_user_1 =
  mkRichInfoAssocList
    [ RichField
        { richFieldType =
            "\175690U\1001990z\1062812\1034953pFn\46922\n\152230uF*\ACK\v\SUB\ENQOx\1113270\61465\74578t3+\DC1\1019107K",
          richFieldValue = "\1066577"
        },
      RichField
        { richFieldType = "M\DC1M\1016348\CAN\178322\1023014\&5d\1032312>VVg",
          richFieldValue = "\1104094\1016210\92746\44474.&\DC3\1075849Y\155369\1934 zZjp?X"
        },
      RichField {richFieldType = ",\1113069\NAK\"yC}\1093085\1084246e[;\10771b+", richFieldValue = "k6"},
      RichField
        { richFieldType = "FYx}|N\DC4M\a\b]w%$F\1058804b1\180791?n\1062811\&6\1014474[\66243\DC1}\1089377",
          richFieldValue = "s\v\1067524u"
        },
      RichField
        { richFieldType =
            "\SYN9nO\SYN\68308\18659\984437\1027352\171032\CAN\160163k\1048886=4\ETX<DM\n\DC3\1093705\rnn8\1039754",
          richFieldValue = "~H\RSH3ht\1345+"
        },
      RichField {richFieldType = ":;", richFieldValue = "\\*"}
    ]

testObject_RichInfoAssocList_user_2 :: RichInfoAssocList
testObject_RichInfoAssocList_user_2 =
  mkRichInfoAssocList
    [ RichField {richFieldType = "Gp\1044050kC\FS\175967FcQ\37728EP8\166216", richFieldValue = "~\td"},
      RichField
        { richFieldType =
            "(ZlgZk\STX\1071695\NAKkw1\1035834i\183303X\189935\1041606qA\1033830\34271\&8\166824\b\6561\&8\1020729O",
          richFieldValue = "+Ne\1057281Q\159902G\SUB\SUB<\"z\142036\195047Z\1018917VL\f\44324\n\CAN\1069000|yd"
        },
      RichField {richFieldType = "", richFieldValue = "O\SO+_\146764i(*\1001374"},
      RichField
        { richFieldType =
            "\bB$\1084082R$\999787[cm\46044/y\41367\SUB\DELM\1055678\156995\SI\"\1052276\1059309T@$Hv\SO",
          richFieldValue = "\59418Y"
        },
      RichField
        { richFieldType = "\n\v1f\FS\182795\EMR!`K\f:",
          richFieldValue = "?GW\93764\1093182_}\nZ\1027014\1071949\&6\r4\SO>\1088935\SUB"
        },
      RichField
        { richFieldType = "\ETX\DEL\99748\DC2",
          richFieldValue = "\EOT\150151@b\SI\SO\EM\1045385bql\7278A\1060910;\NAK\EOTBBgn!lB\fe"
        },
      RichField
        { richFieldType = "^&;\121188\180567}\DC4\USL!\1077137G\1080951L\143968G[",
          richFieldValue = "\f]CyK.\1034420rIi\USt?0\\P``\ETBG"
        },
      RichField
        { richFieldType = "K8\b\ESCo\t",
          richFieldValue = "4\f\EM\STX\182364\NAK$/4Y>\ENQg\SIS\1067296\1029770\1021057^G\FS\18107H4Q\1063263\STX7"
        },
      RichField
        { richFieldType = "\999192\16681 \1013130\1015057b\\FoD\ETB\83328\ENQ\1052581\16505eB(E",
          richFieldValue = "|"
        },
      RichField
        { richFieldType = "\147626aoe\158670%,5\SIM6\ETX\23824?B\43259j\18516\17828\139727*\t\1000338",
          richFieldValue =
            "3\110725\DC1%\US\145933\141565.\176650\169146\64106\19287yU\1038767\DC1\CANOj\70393Y\1067955\ESC\FS"
        },
      RichField
        { richFieldType = "F\DC1\fc\DC2\139920J\1063306\100568&\v3\62110\th-Vg%\176829\EMMb\USo\1050289\1050613\t",
          richFieldValue = "\DLE\ETX\998354\f\1096571\GSvf\DC4Cooi\DELMnUT71"
        },
      RichField {richFieldType = "\1088118+\DC4", richFieldValue = "\1066719\33386e\34324\30086gN"},
      RichField
        { richFieldType = "\1005320\DC3~#*\ETX\7974Y=eHI\11098\171782",
          richFieldValue = "\STX\139400\27346\66625=\1021417:\1042948\97326\ETX\v\US\1048577C\7253"
        },
      RichField
        { richFieldType = "\ETXF\DC1D\DC4\a\83006",
          richFieldValue = "qx2.\1065414\1070403vjw<\1013125\1032500\EOT\1004287\1029277\SOH"
        },
      RichField
        { richFieldType = "T:;p\n\STX",
          richFieldValue = "9\SIMi;9\1060504\1042306\EOT<$,S^4s\187349\DC1*V\f\157790jV\1010738)\b\33294"
        },
      RichField
        { richFieldType = "\"\57810by!\CAN",
          richFieldValue = "\STX\ETX\170259\1092981rl\a\183560\&4\1053241\NAKO"
        },
      RichField {richFieldType = "\STX", richFieldValue = "\b\33872G"},
      RichField {richFieldType = "X\DC4o\SO", richFieldValue = "g-!1W\135639\DC1\DLE"},
      RichField
        { richFieldType = "\15355\DC4Fp\154948]\1050487\1010212\ENQtOJ +T\188975\83006\ACK",
          richFieldValue = "\1101310\1005945\DLEY;k"
        },
      RichField
        { richFieldType =
            "jV\36121b0\FSq~t\1084696\125081;ae\97950\ENQ\1697\984252\997923\1092687\SIm\1046185\173538\31580",
          richFieldValue = "\176275.|\NAK_^\aI;\189679}hD1t\1040312j0o]H\rq6"
        },
      RichField
        { richFieldType =
            "\126595\165576\&5u\162694y\1016821\1096596Ng\f>\18561ygxJCXX\1001592}\1086193\EOT\1029978\NULBI",
          richFieldValue = "\181670\CAN'f\46768\&1X\95193\1017832n/\155865\&7'\STX\7195XvG\1088455+\10022m\SI]"
        },
      RichField
        { richFieldType = "\162153Cy\46767`*\f\1024362\137139.=}\DC3V\996360(\bb`\v\ENQ",
          richFieldValue = "7}H\DELZg&V.\136826g"
        },
      RichField
        { richFieldType = "o\ETB\1091033\1014944\\g\98509w\US\aOsko\DC3}[\41196Tno\ETB",
          richFieldValue = "\1104736\13635\"\73952"
        },
      RichField
        { richFieldType =
            "a\991899l0vr\164444\ax%\r\985008\9732\38517\&4O+\181596\1031735&%\128604|\155652&\CAN\1100158\1002876",
          richFieldValue = "O\1019876n\v-J<ei\1010482s9\172727\22198\US/\186391K'V0_A-\1056806\13805ixm"
        },
      RichField {richFieldType = "\ah,e\SOoWiB\1065761", richFieldValue = "m?\141673\DC3|/dC\983844\10620\171116"},
      RichField
        { richFieldType = "ni\69723\150095wL\v\2474\1069005gL\147158J($h D=\1030766\&4\v\73066\151468T\129078",
          richFieldValue = "1\1057898\998247W\1029610\62761C\999316\DC1.H>r\180984Y\21832\182082H K\bZ$"
        },
      RichField
        { richFieldType = "C\NUL1v\n(l\1013990\EOT\SYN\ACK\1038467Fq\avmS\1056596\134435qD'e\292",
          richFieldValue = "\CAN*\r\59432\SIz%\NAK\EOT,\1024477\ACK\94045\1104087-"
        }
    ]

testObject_RichInfoAssocList_user_3 :: RichInfoAssocList
testObject_RichInfoAssocList_user_3 =
  mkRichInfoAssocList
    [ RichField {richFieldType = "=\SI2\USH4g\1062242\f\DELL", richFieldValue = "a_*l8=\DLE$\1059691`\DC4\27751G"},
      RichField
        { richFieldType = "\ESC&\DELws\1008180j\141960B\1030633\GS\n5\1048921\18933fI",
          richFieldValue =
            "h\DEL\1086305\1051590\1057796\5309\149513|ll/\CANe\ENQ\1020084NS\148765\&6>\SOH\t\25583\SIJC"
        },
      RichField
        { richFieldType = "\1111249DJ:\v\ACK\72192\985685hw0\t5",
          richFieldValue =
            "%\1091251\1085038\1059328\170243\136224\157033\1109474\142450\ETB\RS=7q\142668\75071SIs|\188045"
        },
      RichField
        { richFieldType = "G\ETX\ENQ\NUL\158597%@u\1023936\ESC\1034951ekh*\47107=",
          richFieldValue = "\CAN/\n\CAN7;\1070882~X\3661nn\ETB\EMk|"
        },
      RichField
        { richFieldType = "-q\1023900\&3*Z\13478\NAK\US\bz67x; \SI",
          richFieldValue = "\NAKr\185504e3x\STX>I#\ETB"
        }
    ]

testObject_RichInfoAssocList_user_4 :: RichInfoAssocList
testObject_RichInfoAssocList_user_4 =
  mkRichInfoAssocList
    [ RichField
        { richFieldType = "\1063796Rv\"\ENQs\CAN:1\SUBy\24238:",
          richFieldValue = "\1058512F\NULhN\119622\1085667\&0\35686\181574"
        },
      RichField
        { richFieldType = "\1072040\16645s-\DLE\DC26\ESC@\SOH{\1064389\STX\194917\SO[4\SI\SOH",
          richFieldValue = "9z=+\NAK*\SYNv3\136097\&7c\SI\DEL,Uy(u\r\nD\1045945\f\1088722"
        },
      RichField
        { richFieldType = "\154903\191088\NUL_\139176\164860\SOH\a.Q%IS\DC4",
          richFieldValue =
            "9Em\1063039\54874\ETXn\52578\EOT\NAKg+OF:\25064\NAKf\136698\97355\DLEQ8\EOT\ENQ\ETB`\SOH"
        },
      RichField
        { richFieldType = "\135951\DC1\US\NULH\EM2\GS\1031474\r\1043874&\16461\1013753~\61075g\1077972",
          richFieldValue = "\ETBX"
        },
      RichField
        { richFieldType = "\1104463A+J.U+Q\DC2Py\1072407#.\1095281\1082444\nQ\44985_\1082407\16166.\1045722U;}",
          richFieldValue = "\992542u\b*V5.>^-\26805-6V\174900\&6W/=\6501@\DC37k&;L\16676\ENQ\f"
        },
      RichField
        { richFieldType = "\134553\1036306O\1044451\1070819e\vk",
          richFieldValue = "q\DC2sp/Y`44aRH}vs/<&\1067308?"
        },
      RichField
        { richFieldType = "&pL>5\997769\98479@",
          richFieldValue = "\15639T\22034P<9qowDH\992582\159448p\16784\1071699C]#:\992074\18883\1111543\24972g"
        },
      RichField
        { richFieldType = "V\159272~yRTv\SOH\1091070C\1083996{D?0\27179\EOT&:\EOT]\1110508n\FSM\1029905",
          richFieldValue = "\b\1094782\ETX\CANeeJab\NAK9\DC2\36545"
        },
      RichField
        { richFieldType = "\n\1104020\RS\181086\DELy\53844w",
          richFieldValue = "=hJSu\a\STX\119918\&0$\SOHh>B\r\7410X>\STX\61823\&9\DLE,LOFw_P"
        },
      RichField
        { richFieldType = "",
          richFieldValue = "{`\CAN\69918\1027349hI\1456\1058251y\1060373\f\30561\6721:u6\EM"
        },
      RichField
        { richFieldType = "\1087288R\1071817\190670+\2641& M\FS\186013Ulb,\1047278F}",
          richFieldValue = "(\1061394\CANg\62997g\DC2=-AI-ZA8h\1074489\&7\STX\51230\EOT%R\GS\GSQW\21501\GS\NUL"
        },
      RichField
        { richFieldType = "\1026517sQddV[JX3\144338uPC\73930_",
          richFieldValue = " \b\996044a%\1088184~\"\26135\GSHtZn\NAK\NAKEAYo\ACK2h\1102057\v"
        },
      RichField
        { richFieldType =
            "xj\a\59803\1082871F\37221\DELSP\989768U(\31784]K\1082084t\1108265,\SUB*\1009478\DC3\173155J\1028380u\DC4",
          richFieldValue = "#t[(a!\39215\&9z\\\181430kD\31932\ENQ\SI\DC1R\SYN\1056336\SYN\149936\FSLj"
        },
      RichField {richFieldType = "XldA/\1108527\ESC\994759\94477&\"W<\f,\50096\f", richFieldValue = "\168892"},
      RichField
        { richFieldType = "hZz",
          richFieldValue = "\EOT\1064667\142317\1033140(?&\SI\1018361\ETX\f\NULK\1040290"
        },
      RichField
        { richFieldType = "T\162850-\NULjvKg7\46656\ETB\a@}",
          richFieldValue = "\DLE\t\21385\SYNA\RS\RS\v\1043435\1065850L\SIID\STX\31932KD;l?G\SOHp\1040338u]"
        },
      RichField
        { richFieldType = "\DC4\1044844d\1031332\DC2!y%\1089873Mal<",
          richFieldValue = "\tv\ETBw\GS\1034593\ACK\999322"
        },
      RichField
        { richFieldType = "\\L45&\r\171350\&5\SUBL\1084727\1094820rnD\SO36\1074959]mqnq",
          richFieldValue = "i\GSv@<\ENQ\r\CANk\7534\174235O\44135&\153712"
        },
      RichField {richFieldType = "\aS<", richFieldValue = "\174385@wz.\GS\188137M"}
    ]

testObject_RichInfoAssocList_user_5 :: RichInfoAssocList
testObject_RichInfoAssocList_user_5 =
  mkRichInfoAssocList
    [ RichField
        { richFieldType =
            "\1058074Sp\b[I\29193\997210\1058853\19289B,}\DC3\NUL\187059!\1012205\987236~\tTqV\SUB\a\SYN\110844k",
          richFieldValue = "=S\140630\1012243\161698F\SYN~\fR\ETXqZ`Bx"
        },
      RichField
        { richFieldType = "hE\1012964\1056279~\SOH\nN/\FS\t\17418dO\2151O;T8_\n\1021592\t\NULOv\USb\153584",
          richFieldValue = "``]Q\1071467\bA\ACK\"\f\RS\183455\998498\83488\&2\1106229\128464,"
        },
      RichField
        { richFieldType = "'v\150628B\16214\&0\1073332\1103105\35421\1113333\170900#",
          richFieldValue = "=\142650F"
        },
      RichField {richFieldType = "\4034E", richFieldValue = "\1045535#Q\180166[W"},
      RichField
        { richFieldType = "\DC3}\a\994220",
          richFieldValue = "rBpC\1024450\SUBo00}\f\63157\39933\44397&V4U\1101222qI<"
        },
      RichField
        { richFieldType = "\SOHe",
          richFieldValue = "\DEL<\1050297ThA\4266\&35\61423OIR+\SO0\NULGTv\STX\ESC\DLE\1076990M\NAK"
        },
      RichField
        { richFieldType = "\49319\1053232\54741&\37706\NUL,(z\97385\DC1p\STX\1076216(",
          richFieldValue = "i_\1098716\EMM!\26326"
        },
      RichField
        { richFieldType =
            "?.J\1019207\&3um+\48924jD\SYNd\39798\CAN\ACK/\tP&\147834\65883z)\\\1020210\5241\1071076n6",
          richFieldValue = "=GTO\v\1092875d~f_R/\ENQE\187859p_N\EM2Y4\DC1p\182613\1026233\1031051\&1"
        },
      RichField
        { richFieldType = "$jc\99360\1012255\EM\v\ETX\1061187\31226\&5W\\\1041202lk$",
          richFieldValue = "\1099337\ETB\NUL>Pb\1093386\n\1098407\&7t\1068018MHR\1034725*"
        },
      RichField {richFieldType = "\1050912", richFieldValue = "/"},
      RichField
        { richFieldType = "G\DC1D\SUBRr\SYN.\ETX\1087908,\SOH\f(\SUB",
          richFieldValue =
            "\144978W\SO\1030982+a\1093774}\999895\151152\151022\1056699\147086\ENQ\74190I\150719\1056992\17624[p\NAK\ETB\DEL91:="
        },
      RichField
        { richFieldType = "D\DLE\1106169\SYN.CXF>c\1047901\1056176",
          richFieldValue = "\25918uT,-/\1079561\\\GS"
        },
      RichField
        { richFieldType = "\167873\EMUt\65679\1108698Qi\194661w\GS&\20039\EOT5\NAK\173596\&1\23481",
          richFieldValue =
            "\SYNM\92352B'\993478\1036322y\EMB8\1015721C\28847\ETX\47769\SYNZ\DLE\144749.j;C)4\153569r"
        },
      RichField
        { richFieldType = "0x{\12350';\EOT\55052\49650\ENQ8\136958?>\FS=-j\bx",
          richFieldValue = "Hb\1070422\1045972-\172774g\NUL\29030.\b\176622xRxg\1005506n=\997223\ENQqf}\EOT\GSo"
        },
      RichField
        { richFieldType = "d\1087700\FS+^\174809\1045962\">T\SYNq/f\1069165\&8ik",
          richFieldValue = "L\r\40597D\ESCajF\1100046\986986\78522O\t\1105182.\r7\144450"
        },
      RichField
        { richFieldType = "n\DC1\1078355=\33947\1111389\68166\ENQ\RS\SOp/>y\1037592'lgq\136635\1554\DC38^>G",
          richFieldValue = "t\SYNx\US\FS{9\160406\133909gr:\ACK~\CAN1\SUB(Kyo+\993260>"
        },
      RichField
        { richFieldType = "Td",
          richFieldValue =
            "\69934/\STXDl\USb\n\GS\144622)]\DC2s{M(m\1021550\26164\1056212\SYN\ENQU\1064419\ETXU\8643!:"
        },
      RichField
        { richFieldType = "z\110859UTUu\ETXxB*\1020552R\DC4",
          richFieldValue =
            "2\1024021\1090650\ETX\177428\1080339+}\45258\1021612<\ESCa\97827\&9\STX\1044763\v\37608\1040635\1031653\1111650\987794"
        },
      RichField
        { richFieldType = "6\NAK\1019574\txd\1011615\fD\CANWap\ETXO\1097230r\1039464\36065z\DLE",
          richFieldValue = "\1065855\SYN\US||\1112228}\97211S[\1071544K\r\32092.g\59753"
        }
    ]

testObject_RichInfoAssocList_user_6 :: RichInfoAssocList
testObject_RichInfoAssocList_user_6 =
  mkRichInfoAssocList
    [ RichField
        { richFieldType = "a\998215y\1077716\RS\100535\37565n\SUBMr&Pw32Ov\DC3S\FS\34138W\54492}\4177(\13419\SO",
          richFieldValue = "\120944{y\97231NE\f-\1047143zG~7x`\ENQ\164539\ENQ\1028264;\25203\170629\33810\EM\DC4"
        },
      RichField
        { richFieldType = "gS\64579L2RM\f~\b]5$vT",
          richFieldValue = "\29272\1078238gN\156081(v\58001:ZHY\63999M"
        },
      RichField {richFieldType = "8\ACK\DC2\SUBC\SYN", richFieldValue = "S\998908\917537\DC3;"},
      RichField {richFieldType = "%\162737c[6\SOH", richFieldValue = "2\24307\"<\154824"},
      RichField
        { richFieldType = "@\CAN\bH\157749TB Hf mgi",
          richFieldValue = "\EMZ`>\1062402w.\EMVz\137144\1051317\STX\SUBO\DC1\100606\94682\NAK\CANXAO5@"
        },
      RichField
        { richFieldType = "E\CAN\f\DLE\a\SOH/G\f\1059169\38328\1059714U]:y\ETB[j8:\37815\150478\43855u",
          richFieldValue = "O,&`\1101021\STX\1015213i.\DLEF G\1101217\&5"
        },
      RichField
        { richFieldType = "\1096285\FSs\r\73789t\ETX\175357h",
          richFieldValue = "_&j\152667\172804c\EOT\a\GSw\n\157792Ot\31750\37291O\1025275\993101\121061!w\143203\n"
        },
      RichField
        { richFieldType = "J\1004813\36545WP\rFxM\ESC\SYNS",
          richFieldValue =
            "f\1063472nX\16750`\DC3\160311\DC1\DC1\131450\1048339WhW\SI;\NUL}p\58983\188907\DC4>\34382e"
        },
      RichField
        { richFieldType = "ZTu\CANc\SO\DC4[=2\1052981UcC-jV@\1092854fN",
          richFieldValue = "8\"gFT\51988X&\23259\1001492D\1096274\1043113\1031228"
        },
      RichField
        { richFieldType = "E~L\DC4\CAN\128531p)\ESCW",
          richFieldValue = "?X\US\SYN\v\126535\174210\&2\23683J\175559\&5F*BT\EOT\985655\ETX\DC3&"
        },
      RichField
        { richFieldType = "6z\1009540\1092302G/T)e!v\175881\ENQ|\US%B9\ETB]\DC2lL\1106533",
          richFieldValue = "\f\994495n\161852\&3\1032458:\177020\1072546}\\BI\185727@'[\RS2w\1050892"
        },
      RichField
        { richFieldType = "]S\1070258\984714\1107851w\US\1015967\ACK*o\1105591O`\EM\v\STXl(",
          richFieldValue = "\ESC\1060700V\1010105jv"
        },
      RichField
        { richFieldType = "6\SOl\SO\SYNEb!\1106786\159268C",
          richFieldValue = "\189345\SYNas\1054844r>\986723"
        },
      RichField
        { richFieldType = "BkfZq*C>I\1010114\1044822\DC3#\158977.\1034261%\CANX\1029958(_,\36557",
          richFieldValue = "xy\1037182\61200Pw\22772\US\991289\DC1p\NUL\ENQ#"
        },
      RichField
        { richFieldType = ",{\ENQ\ENQER\151822\bB\US\\;\DC4\34102\1020482\&7\DLE\996367Bk\1032765\EM\1074745]\SOHY",
          richFieldValue = "\GS\67664\&4\vH\194626\15866\DC2\68473\1017057\ACKJZc\74900"
        },
      RichField
        { richFieldType = "\ESC4\1099678\35269A\"9\DC34\DEL\DLE\1005531g",
          richFieldValue = "\RSM[\987902x\60790\1036742\f\DC2/\ab\r.#s\\\"w)?\161633\1099638\&3\SYNw\1089908"
        },
      RichField
        { richFieldType = "\1074883G\132288\1056622\SOH\STX\1086605._e\SUBQv\1099099dn\GS\1085394\1008173\18149",
          richFieldValue = "\95396H\133595"
        },
      RichField
        { richFieldType = "3\RS<\NAK>O\51074\1044903\vHJDXU+\1105619~4+",
          richFieldValue = "T\1032335\DEL\1015247\EOT*"
        },
      RichField {richFieldType = ",", richFieldValue = "\SOx\2364X\ETX@\168743xll;*\137532"},
      RichField
        { richFieldType =
            "ksP~R\994672\171515mo\999143\1086881\NAK\32864K\v\1047794\GS\nV\48748\181856\RSZ\1061540\1012713",
          richFieldValue = "\a\5508"
        }
    ]

testObject_RichInfoAssocList_user_7 :: RichInfoAssocList
testObject_RichInfoAssocList_user_7 =
  mkRichInfoAssocList
    [ RichField {richFieldType = "\59760O,*w%5inz`\1079939", richFieldValue = " "},
      RichField
        { richFieldType = "Bz\DC2\59467g\v\STX\fY\57696,\1001271mvfB*#;",
          richFieldValue = "\1014004\170809\1044242kYf\41280\164164\96853P\1011806\1010965\94530\SIr\1015277\SYN"
        },
      RichField
        { richFieldType = "\DC2\13392\a2\52387X\FS\1104589",
          richFieldValue = "\fw\1003354\&6\49983\b\1060610lJmp;\1004965"
        },
      RichField
        { richFieldType = "3\1018102\&8@\USw",
          richFieldValue = "p\USl\SOH\1056408\33374\138542jM|\FS\96426o\155784\DC2FeN\DC1\94061\v\10893\ACK\ENQ"
        },
      RichField
        { richFieldType = "m\57461+\NUL\ETB\SUBZw\95429+T2",
          richFieldValue = "\DC2\9735\1060543m\185975E\20063.\bu6\"#w\24235\ETXs<\a'@\RS\EMy\DC4\ETX\SOs"
        },
      RichField
        { richFieldType = "%2\1036525=[\1073532M([w",
          richFieldValue = "n\111074\174053<8\1060215E]R-S5]Blc\NAK\STX\1075421\DC3Y\147359\SYN\EM?"
        },
      RichField
        { richFieldType = ".\1077117L\tgU\DELM4\1018961ypK\1107896\990422/\182543+u]V{\20798",
          richFieldValue = "\1049116\ETX\1103128-l\183670bXBE\1015532\985399\&2\1105082"
        },
      RichField
        { richFieldType = "\1049031\&1G&\1071220\1109534}\1085264(p\1113553\SOH",
          richFieldValue = "J\EOT\DC1O\RSb\917996;\ETB8NQ\DC3\t"
        },
      RichField
        { richFieldType = "Wa\1105889dR+p\98617\1041299\SI\180275\995201p\bx\175081t\1037024\NUL1\SO\SIPD",
          richFieldValue = "7\1087241f\1031652f"
        },
      RichField
        { richFieldType = "JW\SO\STXus\STX\1112624\992907K\984541\127051\141895",
          richFieldValue = "\SO\SI.1\1064812\SOH\1076879:^kJ\154373\fdQj\1089754]\SOH"
        },
      RichField
        { richFieldType = "<p\ETXt\RS}({!\994118|A|^V\25635\19960K\1077659\SI\DC1\1013703\\F\1038925\ETB",
          richFieldValue = "E\23009&)<\94283[yF[\1049895\190763\USBZ\1094184;\33340\EM~\138326~+u\ENQp"
        },
      RichField
        { richFieldType = "\DELJ\1050046Z\23265]\1016563Z{`@K@,",
          richFieldValue = "vB\SYNe1\189298F#R\999355@\155496|\1067956X"
        },
      RichField
        { richFieldType = "R\134327\ENQ\1063833\&4E+D\aA9\ENQ\61525P\128056'$\a",
          richFieldValue = "U\33565l"
        },
      RichField
        { richFieldType = "W\1029115Wyx\EMJs\tH7\DC4Usn\1058026\986883P\20172V\DC1Zi",
          richFieldValue =
            "\49031\&3\171653\53623!\"\t%zz\STX\10381.M\1034326\14048\1028848%\1070910\tB1wC\1075588K)\1007087"
        }
    ]

testObject_RichInfoAssocList_user_8 :: RichInfoAssocList
testObject_RichInfoAssocList_user_8 =
  mkRichInfoAssocList
    [ RichField
        { richFieldType =
            "Dz\155855s\999889\1101510\157964\&7u\998749\15517\EOT\25197}k=R\139889\DC4\ETB+\SYNY73\1014748:",
          richFieldValue = "+5+[\v\a*>\DC3n/.BG\166195\NUL\185948Y?i"
        },
      RichField
        { richFieldType = "g\DC2\1084586\DC3\37348h\1089059\&8`\SYN\EMx<\1044822\ACKc@3\t&Cv",
          richFieldValue = "\1051479\28869K]\128252j8\4946\167477#,\1010498\185879\1106675V}\STX\SI\ETB"
        },
      RichField
        { richFieldType = "Z\997327\1019741@07\1059071\ESC\DC30\SI\SOH\EOTfVP\20857\DLE)",
          richFieldValue = "I\EMO\168876\DEL\SI&bP\1014446\SOHb\1074688Z\168011S\1005710E\r]3j<|2:\a"
        },
      RichField
        { richFieldType = "\1111387/ guMT\SOH\1068615\"{S\t\1027927\917983M\160781\ETXZ.F6",
          richFieldValue = "a]\1071896\EOT?@;!\1080766\a\178638\990706\1072699\t#x\STX\1004848"
        },
      RichField
        { richFieldType = "\ETBVLH%B&\STXq\1066510\"o\CAN",
          richFieldValue = "\SOZ}\t\ESCY(G\128003'\EOTJ:\f[g^X\r\984532"
        },
      RichField
        { richFieldType = "\1068401\GS\\\4179\RS/w\ACK\170076,f",
          richFieldValue = "s\SOon\SOHt\150057M\1029781\SO\33256Ul\65130GG+b3\167477"
        },
      RichField {richFieldType = "Nl\SUB\175775Qk\DC3", richFieldValue = "\156365\187519\1073758{&\SO\62820P2@"},
      RichField {richFieldType = "d\1111898\1096424g", richFieldValue = "2\1039259"},
      RichField
        { richFieldType = "\NAK:%j\ETBD\154437\1103727M?\69721Jo<j3",
          richFieldValue = "Wd\rd\23267\&8=\DEL%:qO,\139384Bt\1079783\ETX^(\992521\1086302^\1009248-"
        },
      RichField
        { richFieldType = "\GS9M",
          richFieldValue =
            "\1039700\119958[\134364&\EOTC:$B\158664\EOT\1045744\GSH\146726\NUL\13576Y\1113629\138787\":om"
        },
      RichField {richFieldType = "x\1102939qa\DLEq\27892pP#.\1074315*8z", richFieldValue = "y"},
      RichField
        { richFieldType = ")\1044940\SYNrv\59030Q\EM\1087088\&4J\SO\1091665x-\1102666J\ENQ?\44567hG*=",
          richFieldValue = "m2v\DLE\NAKble\1106418\1070073\v;*]\NAK\1028204L\164327="
        },
      RichField
        { richFieldType = "\1044026aG'#\1087397\a\1071666><\33290\tDfd\ENQe\989627\25180\1033171\154577\999405\SO!",
          richFieldValue = ".y\1034141S=k\EMr0\ETB\97879\1061337gYR_\14770\78802DE\NAKv\SYN"
        },
      RichField
        { richFieldType = "IdX\1068667\\\EOT}kx\DC13V\984938_\997191A\tmz\RS\988725&",
          richFieldValue = "Y\1031183\&3\DC2&\40565\ACK\b+*\SOHb\CAN"
        },
      RichField {richFieldType = "-PV0\1045522go\STX-SJ\998318v6\145226n-", richFieldValue = "X:\tn\1060418dM9d%n"},
      RichField {richFieldType = "m\GS<\v\168665)\175024\ETB4y", richFieldValue = "\ENQ\SUBo"},
      RichField {richFieldType = "Hqa1\77853]", richFieldValue = "Y"},
      RichField
        { richFieldType = "3\SO/I\\\53959\\\1062665:\120019\US\142481",
          richFieldValue = "\f$|\95741\1071175\1012674("
        },
      RichField
        { richFieldType = "\DC2",
          richFieldValue = "ZA#\1092440\1111082\SOHE\53346.\t<X\152975<\146317F\SOp|pJ\FS?\78298"
        },
      RichField
        { richFieldType = "\1074423\1087935\43084#\STX\1087504\SUBx\ESCm\1089934_\1063286UU=\ETB_",
          richFieldValue = "\33601m\154672J\ACKo"
        },
      RichField
        { richFieldType = ",G\DC3\1025033\&59!9\aTMV{\SOH0>F[[HZ\62302\34708w\"JF\DEL\135246",
          richFieldValue =
            "QY\DEL\GS\1754\DC2\ETB\SUB\156352\127009ZW\\>\ENQ\185659\&5l\1041167\&3n{\ACK\CANU\18977"
        },
      RichField
        { richFieldType = "72&9B$o\DELAzN`C\US\SOD\1063128\&8",
          richFieldValue = "\DC3/\96708<\1062693\NAK\36858\59443\1067685\EOTm(_PL"
        },
      RichField
        { richFieldType = "9\ENQU\1051553\991936HU^l\29748\ENQ?*\DC1\131383Td\1033364",
          richFieldValue = "\1022953\138591\139774?f"
        },
      RichField
        { richFieldType = "O\DEL\USX4h\50123a\1095417\RSf{/<\1051397@\\CbvtN\v\v2\1009859t\NAK\ETB",
          richFieldValue = "\1026487\1067138FS`#\ESC"
        },
      RichField
        { richFieldType =
            "KGO\1076639X\1038322%}\1063168Z\155249U\1055475_`\1029627q\DC1\25719\EOT$\US\178421\SYNXN\DC2R",
          richFieldValue =
            "8g\990491\48286\US\\<\1007728\ESCI\NUL\7993l\SO\1014465i\STXg\121153\\y\171297\ENQ\FS_\62300"
        },
      RichField
        { richFieldType =
            "\1099017\147532nF\1025208$>\1008575#\159235\ENQ\DC4d\NAK\US\984526F]\166620\1074705w\35634\1034322",
          richFieldValue = "\rx{\ACKu\134937vL\38752\DEL\1074929\\;)*Kk\DC3\DC4~\ETX{\66629$\99826"
        },
      RichField
        { richFieldType = "kd(X$\190599\ETX]rP6\25769>wi\39881\CAN8\STX}\1009277\SUBw2",
          richFieldValue = "\185962\1111906q4t\EOTB"
        },
      RichField {richFieldType = "90\1061585#\b-/G", richFieldValue = "m\DC1,\8378"}
    ]

testObject_RichInfoAssocList_user_9 :: RichInfoAssocList
testObject_RichInfoAssocList_user_9 =
  mkRichInfoAssocList
    [ RichField
        { richFieldType = "",
          richFieldValue =
            "Q\53780\EMf\SO\DC1\1048800(W\1056864\988934;\179116s5\GSb;U\ETB\984630D*\DC3\30451\SUB\f4"
        },
      RichField
        { richFieldType = "\SUB\27593o$\tm1\NULPIe\96689!e\151526\CAND\139821b\73918\1012381\&87N\1106457\SOH",
          richFieldValue =
            "\\\CAN-%N\186394rW\1069397\182654\STX\32472\1096218?{\t\1103035c\992153}C\v\1051414>\156522\&9"
        },
      RichField
        { richFieldType =
            "\DC2\ETB:#j\1016570\995014R\SUB\8139\46197\DC3\1001317\fX\1019967{\a\FS\1088211$\DC1@\NUL",
          richFieldValue = "!3\ENQ#\8659\984383aA\990391\RS\1024087"
        },
      RichField
        { richFieldType = "\GS!\EOT\DC1[.\EM\43062\18906\NAK\73677\1008044 \1031011V@\1103400\995687uX",
          richFieldValue = "\ENQF\143759}w"
        },
      RichField {richFieldType = "i|O;?\f8*\NUL{\r`\1102254", richFieldValue = "\1058311],%5gtF&\DC1\100311"},
      RichField
        { richFieldType =
            "\1083150X\53916\28226\&6Y|\SOHq\21832,$\992122k\ESCA\156055\121501X\EOT\181872^^\142236\&4\US#Lh",
          richFieldValue = "E(*\166750\SIF\191040\ETBf\STX."
        },
      RichField
        { richFieldType = "D\96871|\19034\t\165096\ENQP\DLE\135992.HT%\148302\STX21\r\137838]\t\DC4\DC4\1023982\f",
          richFieldValue = ")#\ETB\1093437Xv\172325\DLEC\n\995484"
        },
      RichField {richFieldType = "_\1100172DV", richFieldValue = "<_y\NULnqk\rQCrz\FS2\ENQ\1019845\&3\DC4."},
      RichField
        { richFieldType = "A\26230AyU*U\1040076X\2792p\1089124/\49419\US^\NULA\ESC\EM]\159839\58492\1084799%?C",
          richFieldValue = " {\171966&\134026M7c@&_\US\1041536\DC2q\71108\179421"
        },
      RichField
        { richFieldType = "\SI\132269W2\DC1O\1035974t\SOH\1003251\36469",
          richFieldValue = "\ETX\1025341\ESC"
        },
      RichField
        { richFieldType = "\"k\GS\70419\26199\1014184\ESC05M\f\n\r\t,;",
          richFieldValue = "9Q\168871\1056271\&2&8`\137772\\J;\SI&\44400\1097338\14079\&0\1086128|"
        },
      RichField
        { richFieldType =
            " \992150T\1002985+\US)q<\989166s\1014574\1092067]M\SO\v<\b@c\1001106)\SO\139144o6\1010975\21132S",
          richFieldValue = "\1060216\1083797.-\SUB"
        },
      RichField
        { richFieldType = "\34229!1\185302\&0\f\r\120200\ETB\170354",
          richFieldValue = "+q\158710\181545\&5%O-\SOZG\EM\DC3\f:J\995860D_^\31249\SOH"
        },
      RichField
        { richFieldType = "\EOTo1bv\EOT+\EOT\155925d\1066890\SYN?'w\30888\177205\1058893M7kV\DC3\ETB\GSqc",
          richFieldValue = "J[\DLE~gi/\DC4EW\"64b\NAK1\1048818':_1"
        },
      RichField
        { richFieldType =
            "\73962\62453\CAN\SI\1066456RF(T\CAN\983962`\145919\RS\DC4\14179\DC3\188204:E\1014493\180955\22787",
          richFieldValue = "\ETBp\28133\SUB&"
        },
      RichField
        { richFieldType = "\"4\1079772\1085218\996306h\SUBu\1033018\DC1\186497\STX",
          richFieldValue = "\1003323!R|jE\31928"
        }
    ]

testObject_RichInfoAssocList_user_10 :: RichInfoAssocList
testObject_RichInfoAssocList_user_10 =
  mkRichInfoAssocList
    [ RichField
        { richFieldType = "K\CANS\DELN0\72832\149961.54\19512\1108628fY\1004417\45657)",
          richFieldValue = "_=x\ACK\SOHh\ETB"
        },
      RichField
        { richFieldType = "\154824\1070277\&1O\1087683o\1062374\NUL\1004673\ETX\1103214\1102453\1065475zri=",
          richFieldValue = ".=\DEL@}OdoKl*YU_I(H\t \985441\DC2-"
        },
      RichField {richFieldType = "\bu\15327\CAN\DC1u@}", richFieldValue = "]09|\1082373\\\1079514\a}xY"},
      RichField
        { richFieldType = ": U\fLm\1030806CZ\SO4}Nt",
          richFieldValue = "\1112946\DC3o\f+\137006\&8\143818\ETB.cq/0u**\41286\SOs"
        },
      RichField
        { richFieldType = "a\9906\v",
          richFieldValue = "\134958~\DLE`\EOTEF\DC3\\\t\1061880g\1052395f_D\FS\NAKvn\DELE\1096954\RS\1000011D"
        },
      RichField
        { richFieldType = "\1057131\1054895I\"\1084918c\1042046",
          richFieldValue = "\1085897]f\1059629\FSAe\7735$\EM\29111\175788a%A\DC3\1089240\1105420\GSI"
        },
      RichField
        { richFieldType = "\67130v3|JT^?@!j\RS\1031456\a",
          richFieldValue = "v-)i\1017124=\DC3Ww\b\1044637D2\1069284#CZ"
        },
      RichField
        { richFieldType = "\180696$\CANh=?G^\175140\152687\&89<M>^\9515\RS\b\1090022#\1012534\194602a",
          richFieldValue = "@\"\DC4\70346t@\v\1028945N6\1003753\b\188898b\EOT`%\1100090\ENQ\41979|"
        },
      RichField
        { richFieldType = "$1\GS\14382\39424n",
          richFieldValue = "9\179845{\CAN'T\DC1q-\98814\152376\1092545_\\j]\NULSp\110834N\US\1068418)&D\EM"
        },
      RichField
        { richFieldType = "b\STX\54181\173461:~}\997096i\1018231Q\42164\SI\28267nI9C\52603\99308\DEL'\9572A",
          richFieldValue = "c(L\1093389\160911\136219\64532^\1032670\DC4\FS\1048424\\V\1086409\&1eOsl\US\"]"
        },
      RichField {richFieldType = "<F", richFieldValue = "\f|XCf|cCe\EMs@/\ESC-$\DELM"},
      RichField
        { richFieldType = "\131324\&1\1077118@\"k`\\\1075940\ETB*4`;&\n\DC4\1081904%5\DC1]p\1036503f\SO",
          richFieldValue = "(c!\60901?9Q8\1023444n\33294\DC2"
        },
      RichField
        { richFieldType = "F[\aZg\71043\SUB\NAK\77942\165238-A$*A5z\SO\1034347P{\n!\f\ACK!\SUB*",
          richFieldValue = "\992556{Ox\ETBsS\EOT.^\64343\1041050Af\r\59328\r\USn\NUL\SO\48324"
        },
      RichField
        { richFieldType = "\US[]>\f!\1092689\10494\&5@[\1084074\166182~O",
          richFieldValue = "\1099915\1069312~B\EM6\t\15414B\1030663\&8s\SOH1\SIS</=q\1101404\DC4\SYNn+\CAN\50262"
        },
      RichField
        { richFieldType = "\"N\1011285$l+\ESC\26823~A\182574\NAK\1025002\1055071\47482G(\181847.c\41387",
          richFieldValue = "\FS\"\180035N\SUB\168465dz%\1041016\EMpP\DC4\1080941\138804xJvFrc\DEL"
        },
      RichField
        { richFieldType = "\ACKw\74796b\"\1012917\ACK)L\176987\1009305\63475\SYN:\1034732e\b*{\SO\NAK",
          richFieldValue = "\175401I&\SI/]\USP\1100889\1035753C\1090685b"
        },
      RichField
        { richFieldType = "K\1032826\US\DC2?q2/\48485M\1021927y(\1111265~\DC2",
          richFieldValue = ">!D\NUL\NAK+\t\1112767\138527ZwE\RSvI\v\ETB\94238 \177994,C{O"
        },
      RichField
        { richFieldType = "\62091\n\1097855\1054285s\159771\46994\frp\\8\162182{",
          richFieldValue = "\US\SO\DC4Sg$M~\14643K67&gud\1051007O4cvc.q\\\36208W\"c\1108322"
        },
      RichField {richFieldType = "\a~NT\CAN0\DEL^", richFieldValue = "3z\v((}!\"\1092060Q"}
    ]

testObject_RichInfoAssocList_user_11 :: RichInfoAssocList
testObject_RichInfoAssocList_user_11 =
  mkRichInfoAssocList
    [ RichField {richFieldType = "%\SYNA\ENQ@O\1014133\SO)y ", richFieldValue = "\1096740\1024372\987815Y~\"Y"},
      RichField
        { richFieldType = ")\1039064c\1074846\1039059P @(^x\RS5",
          richFieldValue = "r>\rh\NUL>\1044429$?\19446\SOH\EM&T"
        },
      RichField
        { richFieldType = "\1060481UK",
          richFieldValue = "~\7474c\182864R\58649\95355qz\182951$>z\ACK`5\EML#\ETB;\18314T"
        },
      RichField {richFieldType = "/c^z\1010950", richFieldValue = "\RST*\a"},
      RichField
        { richFieldType = "\DC3M\1048131`\38151\\\148994E\152441\NAK\EME\f`\a<czn\44164a\128716\129601\t\53896t\ESC",
          richFieldValue = "\190626u\GS\a\1032215e\1033530T/\1077225\1059375\NUL"
        },
      RichField
        { richFieldType = "#)pnE\1095641\SYN\1060400",
          richFieldValue = "\182036v\NUL\1086185X\ENQ\101101s@z\1088513\37438v\1075422y\32410\EOTb\166748\1084613"
        },
      RichField
        { richFieldType = "=OHSv\"{+V>iFy\DC2\1021166\189442d\"eV,\1003575;\DEL\a(\1022161",
          richFieldValue = "b\NUL\45571\991124g\183057=\1014985\ACK^\94975^\a\1110019\&9\136337'c?"
        },
      RichField
        { richFieldType = "\1000130\FS6\NUL\US)n$\1003097\SIY~",
          richFieldValue = "\3329 :\NUL5\1089559z\1016906\1062456N\1058351\175725\&5@Qb"
        },
      RichField {richFieldType = "\\\1030927\1084367", richFieldValue = "#(N\EOT\fL\55225]K,\44208\1051392"},
      RichField {richFieldType = "K\DEL", richFieldValue = "\142451\NUL?.[_JU`"},
      RichField
        { richFieldType = "\1041679;8\154902n=\vA\foZcKo\EOT\1041969=g{*\EM",
          richFieldValue = "\1095683\45550\tI4VNUh"
        }
    ]

testObject_RichInfoAssocList_user_12 :: RichInfoAssocList
testObject_RichInfoAssocList_user_12 =
  mkRichInfoAssocList
    [ RichField
        { richFieldType = "",
          richFieldValue =
            "t\DLE\148634e\23003j\18631L\1086162\DC1\SUB\145633\SUB\1077695\ETB\DC4sTk\33039\1091745\&2#-"
        },
      RichField
        { richFieldType = "W['&]\1050921_\1079506\DC2kW\ESCs\1092389\EOT1}Xm\1020116`\DC1\1043008its\1064350",
          richFieldValue = "5=[n\131583%\1108118\134584\18919aEv#CS\1079492=\r\1017862g1,HM\NAK\\\51441"
        },
      RichField
        { richFieldType = "oRl\992064-*\EM?:M'/\n\133906\145327",
          richFieldValue = "`E_J\ACK|BXW/.\59551*M\CAN\FSP\DC2\1016301Jj7|U\ENQ\STXH"
        },
      RichField
        { richFieldType = "h\135051\SOH\1036512\CAN9\68637]\1008353\DEL\1047560\&3]",
          richFieldValue = "h\STXs)\1022692C6\ACK\1085551(=\1085875\1034442\\v\ENQ\t-)\985664-^R@e\DC4;d\1002359D"
        },
      RichField
        { richFieldType = "hjp\f\1022302\NAK\168399\FS\n\44376\194617\r2\128305y\STX",
          richFieldValue = "\DC4@ PC\1030676\DC1.H\1104780\DLE\1102785,2n"
        },
      RichField
        { richFieldType = "xmAm\SO`\111027f#\DC3I\DC2QC#|lu_c\CAN\64758l",
          richFieldValue = "v:^\EOT\142194H\101000"
        },
      RichField
        { richFieldType = ";\1065386\t\n*\NAKUq|\1058447.\EOT\16800A\38963z\143264\1097416\1054127T;+\SI1`Hk^",
          richFieldValue = "\f\1104642_kH\b\bQG-m\SYNNJ<_jft@\6784{&{o9\EOT\1004862*"
        },
      RichField
        { richFieldType = "'\146668gRX\996133\NUL\171676pvh\NAK_p\ESC\GS\1052545\1062264ygA1K\1053755",
          richFieldValue = "\28970^PW\RS2_OZ\125031N\SI\US\DC1\1094238=i1\SI#g\1041191\SYN\SUB`U"
        },
      RichField
        { richFieldType = "|h\a_@\159199K\SYN<D^",
          richFieldValue = "\1045779\1057582/\1012443\1085106\63160.\43746\&38y\155257\DC1\RS\1098605a("
        },
      RichField
        { richFieldType = "\57995nxyx2T\ETX:p+\43372q>\EM:n2",
          richFieldValue =
            "eNN\DC1\22270K\1059229/e:I\149524K\39607\61778J\99933C@\168054\NUL\1089735\DLE9m\1048684\DC3\DEL\1011386\EM"
        },
      RichField {richFieldType = "`\ETB", richFieldValue = "7c\US4hx\SUB\62395\155450@\1034512VwtQ-o\1070742"},
      RichField
        { richFieldType = "\1011975\152313\nl\64577\12700\&3\ESC\US\43620\19654\983576\7341\1006732.\1018099FWs",
          richFieldValue = "6\GS~\t\6528\1079742C\NAK!\78666^2\67594\1048974:\984167I\b"
        },
      RichField
        { richFieldType =
            "\180937\120026\24895T\ENQ2S4_\1103589p\134820\\\160842\&7\SYN\1002932Q%\ESCF\SYNc\988958\1080927#\DC3\DC4",
          richFieldValue = "\1041974^\DLE5n\1080014\FS\139952P\ETB\FS_\SOH&\"\990906"
        },
      RichField
        { richFieldType = "\96615;A}^\1005983g\\3\SUB03\157883\158253X\EM",
          richFieldValue = "OZ\SUB\US\38786z\1098883\DC44A<"
        },
      RichField
        { richFieldType = "zOr\1093917&",
          richFieldValue = "G)/h8v\EM\DC3\134115?\185177\&2\NULk\154821\ACK#W\SOlG\SUB\992154\\"
        },
      RichField
        { richFieldType = ">\121207Se!~pz\23748\&1\t\992332\1093180",
          richFieldValue = "D?\SUBssN]2\CANy\EOTuiN\189333,h\1042653\36506Q\95941["
        },
      RichField
        { richFieldType =
            "j\59527X\189880\DC3?\990608Pf\1084871\38046\GS}>s;@\1016366\147728\134294\1042468\34840+\bQ\SOHb\SUB",
          richFieldValue = "\CAN"
        },
      RichField
        { richFieldType = "\7203$\998893\1095441\1000456\r\1095001PJ\1035417|7\95018\31453ddi\135639\f",
          richFieldValue =
            "X\1097244\1100125\EM\49220+\133929M\1059039Z\DC3\147368\"L\nOD\31402Wf\ACKn\SI\GS\1074117"
        },
      RichField {richFieldType = "6\24420L\GS\185021Ycgi}o#", richFieldValue = "Ze"},
      RichField
        { richFieldType = "%\1110214\&9Mp2",
          richFieldValue = "\r\182466\148037\1072548I\GS<\988315\FS\9939@"
        },
      RichField
        { richFieldType = "\NUL\STX\SO\1100778\to\tc",
          richFieldValue = "\155686\ETB\1011159\144437cg!`\1019631\a\EOTq&\SYNp[\SOH\SOf"
        },
      RichField
        { richFieldType = "\GSf\1062854}MV;u\NULV\11221#Nm\175360_M]\t_6?\SYN\r\ACK7Y\1005701$X",
          richFieldValue = "\181525\37639"
        },
      RichField {richFieldType = "S+V1\aH\1031581A3\DEL\DC4\"\DC3\19120;jK<wa_QTjT~,h", richFieldValue = "hX\EOT"},
      RichField
        { richFieldType =
            "\1024354\SI>XE4\998157Jy]_+R\1012299\173977\CAN\65058\t\DC48\150835\25267\47373\157659\1017683A\35411",
          richFieldValue = "Fuj\n\134903|\78484\DLE\SId3\183407\1072096{rZV"
        },
      RichField
        { richFieldType = "f\151892\177151\NAKsJ&\")\1075883,\1030117\DC3\DC2hu\1072042P\134770\173515t",
          richFieldValue = "Q=e\bf\f\69415\1061667\&1/m~M\DC2\152938\128922WT\1005374\&4\CAN\CAN\154644\29221s"
        },
      RichField
        { richFieldType = "R u\1006552~\92515\SUB\43813\29591\DC4\170171kE\183750H@\176287\1068967Yx,g\152483",
          richFieldValue = "{\39126\SUBu>\CAN\44830v4~{"
        },
      RichField
        { richFieldType = "R\USj\RSY\CANL",
          richFieldValue = "2\"^g\EMY\1071435\nMny\31093\1039466\1031533s\36258\DC3U\1030452.\DLE\FSrE{r1E"
        },
      RichField
        { richFieldType = "\1062033$\9393\CAN\48956'2(\EM\140921\SUB\DC2\991441_7[\1002178\1060316\FS\DC2$\1074974",
          richFieldValue = "3u8K\v\\\n\f^=\1030450\DLE`\nu\136951;\1100432\30791.\172068\1087728\SO\30866\SYN\DC2"
        }
    ]

testObject_RichInfoAssocList_user_13 :: RichInfoAssocList
testObject_RichInfoAssocList_user_13 =
  mkRichInfoAssocList
    [ RichField
        { richFieldType = "z*\DLE\31321I\1077672\134474m[\148755)\9512fKT\1020823\NAK\"p\ENQ8:cp\SOHxi",
          richFieldValue = "\189083y]*GCEk9?\ESC.\1030218^r\1079191\&6\8171{P0\DEL\1016504\&1;\CANv\14838a"
        },
      RichField
        { richFieldType = "`\ESCHBX\176949\989433\DC1\tX\47848Q)1\SI\1036075d",
          richFieldValue = "3:aru=B(YX/\39193\1041309U\996066\\?\1058753\ETX"
        },
      RichField
        { richFieldType = "\166872R\FS\SYN[\DC3\r\22084\1103594\&5h\ESCl\1030588\EM7t\GS ,\bKj\1040655\ESCG6",
          richFieldValue = "_\SI>|%\ACK\NAK0\DELk\1015390N ef\1105518\1017325c\23243)\7007\&2\8552N>|\141095"
        },
      RichField {richFieldType = "Nf\\T", richFieldValue = "\b\110753[\62680\US\120398rVr]\145902pw\1049222nT3FG"},
      RichField
        { richFieldType =
            "\69223y\SI\US\172832\983886LU\EOT8h\RS\SOH\1011542\NUL\1037009t \47998\180586\19102\CANxX",
          richFieldValue = "\1078914\ETB\SO]\f'\SI\ESC"
        },
      RichField
        { richFieldType = "FN\EM&\1110855U\188712~\1008639t\152157`\1103563s",
          richFieldValue = "\153838=\32995!9nRi\GS\1100075\43424"
        },
      RichField
        { richFieldType = "\99828\61985;R\ay\"\ESC:\1019725\94567f\a\5102DD\1078450",
          richFieldValue = " \1067811\SI\DEL\"u\993873\60871\&3\1040938Jl\RSxx:\FShx\DEL\ENQu"
        },
      RichField
        { richFieldType = "\1044052\1077640|\3935\1061461GmZ\95079\&8k_JF\SUBlI\128437LP\123176",
          richFieldValue = "\153973#{\54355\&5s\DC3/s\"#\FS:el\SOH"
        },
      RichField {richFieldType = "L", richFieldValue = "\1043935]"},
      RichField
        { richFieldType = "\23372q)r\70829*SA1:",
          richFieldValue = "*\95281\SOH~-6i ?\1060940`\ETX\SO\139351R\f\136994t\DC1\1095903-3c.\38557"
        },
      RichField
        { richFieldType = "\125072m\DELSH\1043641Y\US\94416\1084814\CAN,w4uFD\SO\"A\32214\SOH",
          richFieldValue = "N"
        },
      RichField
        { richFieldType = "\174674\989621 :T0\14263\n\49265\&3\SOH\DC1\SO@\1033839\ETX\48176\&0\161673",
          richFieldValue = "/\142036;\169241E%\94322l\n\DC4.:{|]T@%\DC4\1093834`\1051069\SI\1110394\EM\185572"
        },
      RichField
        { richFieldType = "I5\RS\96725\&1;v?\147690@4\1112574\1095920\983961|Pc",
          richFieldValue = "!\SOHu?\92753\1054641Dz\178220aIu"
        },
      RichField
        { richFieldType = "\1009136 ?\ETBL+\t\nq\113815\DC2\NUL+\48474\ENQ\b/F\153958o\99707\SOHG",
          richFieldValue = "\b18c0\SIU\1093193'\1034908\162955\&8\ETX"
        },
      RichField {richFieldType = "`vi\ESC\1031206z+%\1080549", richFieldValue = "\182432\1031952"},
      RichField
        { richFieldType = "\1088160^TJ",
          richFieldValue = "\r8\\\60064YqNh\148872\ETX8u\1003970Q\162050o&\14731\43508s\1083131\SUB\991285LV\RSqKu"
        },
      RichField
        { richFieldType = "\101030(B\a/'\35699\1001724\DC40\41844#U@CJV\1032544\500pzR_\ENQ\183810[F\191069 5",
          richFieldValue = "\STX?fB\1043911\23842\177720iNI\ETXiH\1084560\SYN+\DC3&o"
        },
      RichField
        { richFieldType = "\ETBV{\f?Z#b\1061992\120046\163615]\RSG\DC2\15471bi\1025939\49463(\1003889\991384\bu\\",
          richFieldValue = "\1083296\26385%Y\1048194\96776WDE\1038521^\190773jt\1052690\SOH\FS0\1069662N\f\100270"
        },
      RichField
        { richFieldType = "\ACKr\a\t[\DC3'(\"/vSeljA\DLE{\SOH\1028813m\DEL\147968",
          richFieldValue = "\1071832Z<\DC4\21657<\SUBF(MQq\991303\EOT\\\1015006\95427x|\RS\b\DC1m\165083U"
        },
      RichField
        { richFieldType = "\168063my5_\28282\DC3\GS?iA\997869i\ACK\42697\1039319[~\997273GPc",
          richFieldValue = "\DC1\SI\EOT\SYN\STX@\DC1='h\CAN8\STXd^GM\985740\1087667n"
        },
      RichField
        { richFieldType = "'H\"\1001346\1016998\1044621\r\110660D\61926;rP\EM \12364e\CAN",
          richFieldValue = "\DC3\CAN,N\ENQ"
        },
      RichField
        { richFieldType =
            "\147972\1039228\\\DC2\\%(j\1103902\1046720\1067115_@\157861X\EOT\162276\EM6\DC3\1045522\NUL\194583\EM",
          richFieldValue = "/"
        },
      RichField {richFieldType = "\SUBogWc\182133oCY\1028241\1099230\133244\&2PO_", richFieldValue = "-\186026M"},
      RichField {richFieldType = "vV9~\1111403\&4L,\DC3jz{\1087288\990666;", richFieldValue = "B"},
      RichField
        { richFieldType =
            "\190901(\175512#\1021845\73107\994211\&7\t\ETBA\23938y\1108785\US\ACK\ETB\NUL\66688\983969\62023",
          richFieldValue =
            "x\1061o\DC4\146905,\153006\DC4\1102566t\1063122\&0\tq\ETB\1079045u\83491Q\1087141\1042247TpM\131093\US:"
        },
      RichField
        { richFieldType = "y\DLE\STX]\DC1R\GSH>^'\1039075v\18508\v",
          richFieldValue = "8Av1Gu+(\16771\180818IK]r\RS\f\FS\53783\12276*6^x|N\1060399e\93031-w"
        }
    ]

testObject_RichInfoAssocList_user_14 :: RichInfoAssocList
testObject_RichInfoAssocList_user_14 =
  mkRichInfoAssocList
    [ RichField
        { richFieldType = "Y\1097278d\NULRI",
          richFieldValue = "\"\175546/8\1104241&n\20186:\18558\n\US\170938@gB_K"
        },
      RichField
        { richFieldType = "\ETXM&S<\DC1d2Pk+\apM\b",
          richFieldValue = "\1097099|\CANj\EMLuCp \146457\1074891l3h\1067130\38003\&5g\1022231\155107X"
        },
      RichField
        { richFieldType = "\1099895r$ss>~0[\1079495:9\75013]Ew%\1018618\146400\53026(\1021664}\ESC",
          richFieldValue = ":\""
        },
      RichField
        { richFieldType = "w\160820\t\137366K/\DC4Um\ACK\121176\1017693I\SOr=$W_\CAN",
          richFieldValue = "f\1088765\DC1\FS\1040413\DC4\1110769\988254y\92162\64522\1074674:G\ESC"
        },
      RichField
        { richFieldType = "",
          richFieldValue =
            "\ETXB\164951\NAK\171616C\138976H~T*6\SI\16458\STXdb\DEL\n\991433\ENQTC\ACK%\SI\r\ru\1077920"
        },
      RichField
        { richFieldType = "\DC3cYvJ\1021129dBMW\SI _\142549V",
          richFieldValue = "\DC2e\48476\rR\162679W0\DC2\ACK\1040001\r\1102288"
        },
      RichField
        { richFieldType = "\1063575\1011847W0fY\v\995827\r>l3mo6s2+\DLE\1034735*g'H",
          richFieldValue = "\1010358\ETBX\fQ@2\DC3!TH\987799X\STX\bz\SUBt`\STXa]\1103652o\1040123\1075382\54633\NUL"
        },
      RichField
        { richFieldType = "RAc\ETXu[\1045432rFF7s",
          richFieldValue = "\150126Q\fNq\DC3S=hT9\999699\t\EOT\DC2\16565\58633\DLEl\DEL"
        },
      RichField
        { richFieldType = "HM\n\DEL\FS&x\US\157560!\t\15295\CAN\SI8\USJ\US\72311\DELK\CANODm\a\ETBh\146734",
          richFieldValue = "\127256\1062065<\1084134G\1013838\57436\1055208\DC1?%"
        },
      RichField
        { richFieldType = "C\STX\5295F\1066043Io{\1084579}h",
          richFieldValue =
            "%t[\DC3\a\1097838\b-\DC3r\\\DC1/1\1080556\EMgn\1090973\42459\DEL\1075433,?\180913w\145836"
        },
      RichField {richFieldType = ">ldT\43466", richFieldValue = "\EOT@\988446\&4O\SUB9\SYN\STX\EM/,1\1043788"},
      RichField
        { richFieldType = "(cCiV\1049352\SUB\1079784\&5\STX\"*\1093981\147914\&2DK\ro0q]5\34259/<",
          richFieldValue = "\v\NAK\1039703\1017160Z\19335'\DC4K%\t\DC1\RS\47565C\176722HtuLW%\DC4LQ7%!\GSy"
        },
      RichField
        { richFieldType = " {YA7\DC2\92747\40298\1001169",
          richFieldValue =
            "A\1030311.^P$u0\CAN\111199fP\129523\1099159NZ\GS\RSn\1035384\189801<<\994100\1068633\ACK\DC23f"
        },
      RichField {richFieldType = "4%+i\54430\1042341a\a_J\ETX*", richFieldValue = "\990556\STXOq~"},
      RichField {richFieldType = "\ESC\37189DD\EM(+9&axn\\", richFieldValue = "^\FS\ETX\148544"},
      RichField
        { richFieldType =
            "QM+\1049013s]\1005208\1046292\13212\1018425\ETB\14896+a%\1006669\1011902\1019721\NUL\1030068{G\985550I\DEL\1094491h",
          richFieldValue = "\1110451_ru?\177123G^_\1037833.\1012576\1096856\1105016\169817K=QH"
        },
      RichField
        { richFieldType = "{r\DLEv\DC4z\t.p\1007902\142703|Ld@\GSh^\1070198\&8",
          richFieldValue = "\1052479\&3\21714\1040108rJ\DC3/\DEL\DC3\51045)<?d|\FS\1006478]\ENQ\18106\t\FS"
        },
      RichField
        { richFieldType = "vx\EOTiy=>\22626~4\1092666\1088011\1055205\"b]\FS\STXX\"^==1l1",
          richFieldValue = "\DLE'X-_\a\STXHaR\SUBZ\US\EMAu\1001395\32538\60712\RS"
        },
      RichField
        { richFieldType = "\f\DC4Q\EM8\US\35453[e\39694\ACK\1066257",
          richFieldValue = "TZb\1034718ps\28692Yf\174875w["
        },
      RichField
        { richFieldType = "\31940\1043617K,3\1075707*C.w\1049282\SYNh\1004322c",
          richFieldValue = "&1uQ\"xsPA\1097585\a\1083181}\DEL\DC2\DLE\121455\33537,\1029578f\ETB+$"
        },
      RichField
        { richFieldType = "\SOH\1029313B\1008715\17751\992279bQ\DC1\r\RS\ft\CAN\138436\49486\ENQ\GS",
          richFieldValue = "x$#\ENQ\vtMJ,\DEL\38676k\1113690h\1033164 9\GS;)fQS?i"
        },
      RichField
        { richFieldType = "\48107p7\62073$\1031007\f-Bq",
          richFieldValue = "~\132861[m|V\1006179p\35718N\139105\&2PPp+(\CAN"
        },
      RichField
        { richFieldType = "\DC14\SOH\33641\151576\1022090d\995914\1106034\1111939x\30824j\44610y\DLE",
          richFieldValue = "\94553\t,\n*C\RS"
        },
      RichField
        { richFieldType = "\164033%\a\SOH^\a\SO\US\161788@}\1034691\119984g99h",
          richFieldValue = "\172519P\67358;\14146Dlw:c\DC2\1092080\158061\175487\b>\RS<\1018130`u\DELN\1062895"
        }
    ]

testObject_RichInfoAssocList_user_15 :: RichInfoAssocList
testObject_RichInfoAssocList_user_15 =
  mkRichInfoAssocList
    [ RichField
        { richFieldType = "\GS{!\SUB\1083131\134054\1040277K\133871,\1011175\NAK\1010828",
          richFieldValue = "f\STX\rb"
        },
      RichField
        { richFieldType = "/\1013214#\DLEXxM\54627Dg\tI\121274I9%",
          richFieldValue = "\1709\1012581\"N\1023165(Jm"
        },
      RichField {richFieldType = "\1082871-yR7L\ENQ\1567'Ly", richFieldValue = "\1077720 \132842f\DC4I\1067140\&2v"},
      RichField
        { richFieldType = "p)J*f \181598\&9\1061422/$\bO\1003862\66209\1039628\EOT\NAK\rmS\DLEw\175790dN",
          richFieldValue = "]\STX<\97559\1066211$:\92367\149442\"4\16922\GS\1110134IO\996894%kZ\b"
        },
      RichField
        { richFieldType = "k\DC4H\167541X\182285\&8,bJK\aH\ESC\as\1109280\STXm \1042478}8\991578gaOPJ",
          richFieldValue = "\b+\155297\1068427\988226V\1092290\&0\147573g N\DC1O0<p\SOH\1108253[7aT~"
        },
      RichField {richFieldType = "Y;Q\1092186\60788%\986648\CAN\DLE", richFieldValue = "<d\SUB\181187S?"},
      RichField {richFieldType = "3H?\RS", richFieldValue = "\\W'\RSC4\64568\1111876w\992132\US_*"}
    ]

testObject_RichInfoAssocList_user_16 :: RichInfoAssocList
testObject_RichInfoAssocList_user_16 =
  mkRichInfoAssocList
    [ RichField
        { richFieldType = "\ENQ\GS\140204Msn?\tl\SUB\1094138n\1030927}\SI\f",
          richFieldValue = "1(\SO7>K\ETXl/Mg"
        },
      RichField
        { richFieldType = "\ETB3\SIU<Ay",
          richFieldValue = "\ACK0\1042372\ACK8\DC2JJ\986254t\52790\DC2R\992366tT~x"
        },
      RichField
        { richFieldType = "\156958>\138263_ek\DC4\FS\SI-\RSv\fRo7\25051\189963\SOH*0",
          richFieldValue =
            "\SYN\1107335\t\271\1049535ql_\1066343\DC1D\152675\2466F\NAKS\USdZ\160426\14602\&07\1063869\&7C\118882\DC29"
        },
      RichField
        { richFieldType = "itT@\137668L5SOl'%l\CANA\SYN\DC2>^\SOH\5665oK\135056\DC2\21100\v",
          richFieldValue = "\DC3Z\94833\SYNOPH\29064\SYNsW1"
        },
      RichField
        { richFieldType = "\1078919\&0\72859\FS$~\DC1KA\167694\DC1\DC3\n\27347\n",
          richFieldValue =
            "#tP\t\1050497\1096622\989091\v1\DLE&B\DC14]Bd\t\58864\1044228\SUB\1073513P\DC4b\GSRz\1060376"
        }
    ]

testObject_RichInfoAssocList_user_17 :: RichInfoAssocList
testObject_RichInfoAssocList_user_17 =
  mkRichInfoAssocList
    [ RichField
        { richFieldType = "%\STX-\171033]\SUB\57566\179175\EOT+4\120243\FS\v;\ESC#]{\ACK\DLEM\97282*\RS",
          richFieldValue = "\1022279\1107009\1084199\&24\ETB\1028868y7h\96665"
        },
      RichField
        { richFieldType = "[[eF\"\1098044J~d\SYN`B\b\147962[\ESC\163775\169568\nP\154510!'\156206j",
          richFieldValue = "\DC1\181881)<%4$?\46231:Xc\61592pN\CANu\186478\178675\126240\&6p"
        },
      RichField
        { richFieldType = "\SUB;I\120501},\ETBE\DC4K]\917957\SUBV-\aP\GS\NAKN\51773\DC1\SI6\DEL<\NULM",
          richFieldValue = "Xx`P6f\1105829\&3<\160986\RS&\1027838yf\DC4\ACK\138690Zb"
        },
      RichField
        { richFieldType = "2&\DC2wG\EM\1083654i\24941\67352\n|\DC2,67",
          richFieldValue = "\STXv\156834|O\63507(\EM\"{z$8\ETXo\162424t?\1049897=R\ENQ"
        },
      RichField
        { richFieldType = "F\54906\fY\r\1090121\RS`j$\987238\&4",
          richFieldValue = "\b\1073003jp\159698}r\997738'\9253-Cu\184695)\v\NAK"
        },
      RichField
        { richFieldType = "\992519\&1g*\1032393\v\26731\n\1097356 \5419\GS\1015851\&6",
          richFieldValue = "kW3!x\DC1e\DLE\180330\1024546\1002152h\144848)w"
        },
      RichField
        { richFieldType = "Xg\1112937ij\DC2",
          richFieldValue =
            "'\1061876+\35224gV\1014259\1040820&\1044056\27427\FS--ye\158934+\131504\GS@Z \158204C\16508uY"
        },
      RichField
        { richFieldType = "\r",
          richFieldValue = "\190972\31407\&8@\183341Lg\142518%\RSL\59211\50191\120188\1037109\&9YbVAZzSI\125002g"
        },
      RichField
        { richFieldType = "U0$\42642",
          richFieldValue = "xT\1084716\aRy4?0\STX\121242\20097\GS\98528c>Oa\110999"
        },
      RichField
        { richFieldType = "\40064I{DR\ETB\1008634\SOH\\4?hV\1070561\SUB+GS\155446Gy\25478-iX=i<[",
          richFieldValue = "\\&\66360y&\1024194) l\1009781\993852\tQqS`ZT`\1069831Di#Ea\1076361a\989306q"
        },
      RichField {richFieldType = "@", richFieldValue = "\f\SUB\SO3\"\GS\998339\DC2#q\NAK"},
      RichField
        { richFieldType = "\119131\n\SOTb7\DC2\7131u\1018453\t54\985924\1109041\ntp0i",
          richFieldValue = "\FSe\1047813\EM<6=\RS\"U83\1035385a\ETBI[?\STX\v\1004740\59035s78>>"
        },
      RichField {richFieldType = "i\20224=", richFieldValue = "\US\58796bnE\156085\155507\&9;@\1030069v"},
      RichField
        { richFieldType = "\NUL\EM^t\DLEP^+/\54036N\178634\ETXH\160143\1103847\SUB\SO?xfC\133011zZ\1062666\49732",
          richFieldValue = " \1014695\987898\NAKprv\1009646\180617\US2j_\1055693\17674\n}>6\FS\25406g?X\ETX"
        },
      RichField
        { richFieldType = "F ]QW\1114078\37987\1020224dEZ\1056088xqD\SYN50y\fU\b}N",
          richFieldValue = "\36531\&7\8787b,\1031595j\60628\STX\14393\SI\NULg\10255$\\e"
        },
      RichField
        { richFieldType = "\1029823a\992503\STX`ZQ\3265nu\1044545\DLE>wv&\983255\NUL\134239$\194707\CANK\rCG",
          richFieldValue = "N\12980V)$F\172321\1084828"
        },
      RichField {richFieldType = "\1042524\&25\3526", richFieldValue = "\USo\FS\129442\1067574:`"}
    ]

testObject_RichInfoAssocList_user_18 :: RichInfoAssocList
testObject_RichInfoAssocList_user_18 =
  mkRichInfoAssocList
    [ RichField
        { richFieldType =
            "L<\186477\163586\11004'Da\1081342DB\1029274\DC1\100728u}!%g\174312`d\EOT\r5\1004363\v\8710\1109576",
          richFieldValue =
            "\22192\1037799p\STX\FS\1067474\v#\19332s'\1086200\1106461\178090\f\1100455)\142729\10966\187741\ETBs\95831 \132527\1073794M\ru("
        },
      RichField
        { richFieldType = "R/\GS\1057103v{\1022626t5\173636\331\1107831)\NAK\1096345",
          richFieldValue = "D\ETXb\EOT3\1106708\&6\DC1\1069851\1047601"
        },
      RichField
        { richFieldType = "\49246 2\27702^z}\\\1076963\GS\GSlk(Jb\DC1P\158643D\1077633\&2\1041396(\1040155\&8 \DC3^",
          richFieldValue = "\SUBl\8673El=\EM\CAN\53814"
        },
      RichField
        { richFieldType =
            "\1060368R6m \SOHqNn\1023530\EOT\DC4<It\r{\RSc\1040911'X\137836\160716\1042419Z\RSL\1089620\1102170",
          richFieldValue = "C1\53030\63677\US?\SI2q\1061428\1014748\&393\41989X:Fg\r\DC4\ACK|=U\59986vMj\28960"
        },
      RichField {richFieldType = "\15692\CAN%w\RS+", richFieldValue = "l"},
      RichField
        { richFieldType = "\t\41631\DEL\ESC%D5c\1110624\1076648-\61855",
          richFieldValue =
            "{dh[\rv\156622\189016\169034Dw\v\1047420N\48876\&4\ETBZ \NAK\SOH\ETB!\180394\&2\ENQ~\SO\17921"
        },
      RichField {richFieldType = "", richFieldValue = "\1006268p\1012424\\\1080936\EOTM\EM^l|\133765]z\1029544"},
      RichField
        { richFieldType = "Q\1010497\985076_\a\152912{\169849p",
          richFieldValue = "\1092275lb\1008981<q\100541\988634\1066512\STXGCg\DEL\t}T\10102\143926R\1045878"
        },
      RichField
        { richFieldType = "!\vU\1039267F2d0n\STX\NAKew\1079201&K\SUB<\DC3\1077546\66275\1072790\50287x",
          richFieldValue = "\EM>"
        },
      RichField
        { richFieldType = "'5\NUL\EOT\183319TU\SIC+\53187\155064K\1036832\94780\&7\DC3g\1083841\189170\190452fo",
          richFieldValue =
            "\187036}\66291\NAK<\EOT\1058760@\1071865\a$\173392\984189\1001340:\994089\35499m9\SO\ENQ\1013627smv\ay"
        },
      RichField
        { richFieldType = "&r#\1060321tn\ENQ\994041\1093572`-\t\33560\ENQ\EOT3\ETX\SIs",
          richFieldValue = "\54557ZNM}W\187056}\19116f*\\\DLE"
        },
      RichField
        { richFieldType = "3c\1018090g4\SYN9\ETX\ETXH;\987138\NUL\NAKH\1023041\"y\EOTd",
          richFieldValue = "\169839%h\4436%\172247\&4\92427\156695\&6Cg"
        },
      RichField {richFieldType = "^1h,;V\SUBL\16012S)\68234O\ETBd0j", richFieldValue = "\SO\179624\1030035"},
      RichField {richFieldType = "\ETB4J\185429\"\1002676IVSy", richFieldValue = "G\\-\DELb\CANcm\1007409y\DC2_)"},
      RichField
        { richFieldType = "\ACKFR\92595\96400\1105487\RS\141419\DC2\GSEG;c\ETX*N\SOO4DwV\30354\v\99083MQ",
          richFieldValue = "S\1045115r=\1019156\41997\ETB\NAKg%\v\42581]-\SOHc{\155136)mn\v\681\9766Xr\CAN"
        },
      RichField
        { richFieldType =
            "yO\1084988V\1062416\ESC8'\129468]KH\97062b\187027\1095174\34747\DC1L\194941\&9\20480<?Q\v\ENQ",
          richFieldValue = "\14113\\\51518q\ETB"
        },
      RichField
        { richFieldType = "\EOTv",
          richFieldValue = "\f\nV8\39194\989631\SO<\t\ACKY\1083828j\DC1\146608Q\GS!"
        },
      RichField
        { richFieldType = "W.\143343o&#VG\139793\1035848\EOT?s\120969\NAKM\n\65782\1102174l&mG[\SUB\US\t\f\43166\r",
          richFieldValue = "NOW^T\EOT\143417\1027553\ENQNTw\1090545 -\1017211PNo\br\1112840H\1031273s\1073224"
        },
      RichField {richFieldType = "B\60000\DC4\2842B\n\DLE\60233\EMrT $*$]E\r\992755", richFieldValue = "=\174151"},
      RichField
        { richFieldType = "\1048995G`\59596\DC4*@\1001711p\54231\1104950\144575\14240\EM;]",
          richFieldValue = ";]\99503^z\1054246szi"
        },
      RichField
        { richFieldType = "o=,\t\DC2`Nq\EM\67633\132285\1019270c(uf",
          richFieldValue = "=\78645a\129644\DC1R\135107G\DC2T$,\1072977\SYN"
        }
    ]

testObject_RichInfoAssocList_user_19 :: RichInfoAssocList
testObject_RichInfoAssocList_user_19 =
  mkRichInfoAssocList
    [ RichField
        { richFieldType = "\SUB\ETB\SYN\v\SUB\33422V=%r\60183;Q6:L\"+O\1096806u\bC\EOT\DC2",
          richFieldValue = "B\135767\99387'\r\1069230\ESC7~G\31396\&6]lT7q\190918\vz\NULJd\50363\t\148727\&7"
        },
      RichField
        { richFieldType = "\25725\&2U\159667\SUB\tK$ l\ESC\ETXOZ\GS",
          richFieldValue =
            "J`D`%u\182313\99428\1027565\990990\GS\1107793\1025797\DC2\SO\1086164\165505e.G\GS\1024681*8Mea"
        },
      RichField
        { richFieldType = "\1095344\EM\STX/\SYNk4p%\NAKW\SYN\983628=\183600",
          richFieldValue = "\DEL\RS\1108906\133072es\FS0T`U\NAK\1087290=vnb\993881"
        },
      RichField
        { richFieldType = "\ETX\1044341<f\ETBO\ETX~|",
          richFieldValue = "X\"S\1088082$\t\27562-\DC1\38228g\140077:\tLK@\ACK"
        },
      RichField
        { richFieldType = "6\151793\NULd\184079\DEL\1055747Lv;\1065988>\1093433U^W\"\DC4a\n",
          richFieldValue = "0\DELV"
        },
      RichField
        { richFieldType = "\STXD\f\1095258(o\984854>={)\\\59046\148556",
          richFieldValue = "\1095415M{\SUB\1045416\1073653*o"
        }
    ]

testObject_RichInfoAssocList_user_20 :: RichInfoAssocList
testObject_RichInfoAssocList_user_20 = mkRichInfoAssocList []
