-- This file is part of the Wire Server implementation.
--
-- Copyright (C) 2022 Wire Swiss GmbH <opensource@wire.com>
--
-- This program is free software: you can redistribute it and/or modify it under
-- the terms of the GNU Affero General Public License as published by the Free
-- Software Foundation, either version 3 of the License, or (at your option) any
-- later version.
--
-- This program is distributed in the hope that it will be useful, but WITHOUT
-- ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
-- FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
-- details.
--
-- You should have received a copy of the GNU Affero General Public License along
-- with this program. If not, see <https://www.gnu.org/licenses/>.

module Test.Wire.API.Golden.Generated.PropertyKey_user where

import Data.Text.Ascii (AsciiChars (validate))
import Imports (fromRight, undefined)
import Wire.API.Properties (PropertyKey (..))

testObject_PropertyKey_user_1 :: PropertyKey
testObject_PropertyKey_user_1 = PropertyKey {propertyKeyName = fromRight undefined (validate "\\#(pEr>=1=|[3U8#*-")}

testObject_PropertyKey_user_2 :: PropertyKey
testObject_PropertyKey_user_2 = PropertyKey {propertyKeyName = fromRight undefined (validate ".ir59 BUmxiD]")}

testObject_PropertyKey_user_3 :: PropertyKey
testObject_PropertyKey_user_3 = PropertyKey {propertyKeyName = fromRight undefined (validate "nk?o0R&)7>W")}

testObject_PropertyKey_user_4 :: PropertyKey
testObject_PropertyKey_user_4 =
  PropertyKey {propertyKeyName = fromRight undefined (validate "bv\"s1=]&\"^\\$05T=h$U.Qd:")}

testObject_PropertyKey_user_5 :: PropertyKey
testObject_PropertyKey_user_5 =
  PropertyKey {propertyKeyName = fromRight undefined (validate "9$\\K\\e*]z[nPd|y.loOEHk")}

testObject_PropertyKey_user_6 :: PropertyKey
testObject_PropertyKey_user_6 =
  PropertyKey {propertyKeyName = fromRight undefined (validate "&32zNqRJI.L:yD!\"Y(P")}

testObject_PropertyKey_user_7 :: PropertyKey
testObject_PropertyKey_user_7 =
  PropertyKey {propertyKeyName = fromRight undefined (validate "to(YvZL!ukU8_lIvP4HD6G 5r.82")}

testObject_PropertyKey_user_8 :: PropertyKey
testObject_PropertyKey_user_8 = PropertyKey {propertyKeyName = fromRight undefined (validate "8Ki&S<z")}

testObject_PropertyKey_user_9 :: PropertyKey
testObject_PropertyKey_user_9 =
  PropertyKey {propertyKeyName = fromRight undefined (validate "i&m.{ok6}b:9_]5{ m=] ,H,{;h")}

testObject_PropertyKey_user_10 :: PropertyKey
testObject_PropertyKey_user_10 = PropertyKey {propertyKeyName = fromRight undefined (validate "{4JU(")}

testObject_PropertyKey_user_11 :: PropertyKey
testObject_PropertyKey_user_11 =
  PropertyKey {propertyKeyName = fromRight undefined (validate "OHeuP_;raj|3E3p6L!gbXC&dz$~")}

testObject_PropertyKey_user_12 :: PropertyKey
testObject_PropertyKey_user_12 = PropertyKey {propertyKeyName = fromRight undefined (validate "ubsV.n^Rg\"Sk_KtM=")}

testObject_PropertyKey_user_13 :: PropertyKey
testObject_PropertyKey_user_13 = PropertyKey {propertyKeyName = fromRight undefined (validate "K@\"B0-ht4]`)<BW")}

testObject_PropertyKey_user_14 :: PropertyKey
testObject_PropertyKey_user_14 =
  PropertyKey {propertyKeyName = fromRight undefined (validate ".a}WC8fxMc+8{AEM6C1ba2c")}

testObject_PropertyKey_user_15 :: PropertyKey
testObject_PropertyKey_user_15 =
  PropertyKey {propertyKeyName = fromRight undefined (validate "LQ%Y:{w~X9;3sjHSoc/")}

testObject_PropertyKey_user_16 :: PropertyKey
testObject_PropertyKey_user_16 = PropertyKey {propertyKeyName = fromRight undefined (validate "w")}

testObject_PropertyKey_user_17 :: PropertyKey
testObject_PropertyKey_user_17 = PropertyKey {propertyKeyName = fromRight undefined (validate "@[wt.MA[~~g%t#")}

testObject_PropertyKey_user_18 :: PropertyKey
testObject_PropertyKey_user_18 = PropertyKey {propertyKeyName = fromRight undefined (validate "")}

testObject_PropertyKey_user_19 :: PropertyKey
testObject_PropertyKey_user_19 = PropertyKey {propertyKeyName = fromRight undefined (validate "/qUJ,5HHe=E3,z`+")}

testObject_PropertyKey_user_20 :: PropertyKey
testObject_PropertyKey_user_20 = PropertyKey {propertyKeyName = fromRight undefined (validate ":7)V]/Gc5Y~n=")}
