-- This file is part of the Wire Server implementation.
--
-- Copyright (C) 2022 Wire Swiss GmbH <opensource@wire.com>
--
-- This program is free software: you can redistribute it and/or modify it under
-- the terms of the GNU Affero General Public License as published by the Free
-- Software Foundation, either version 3 of the License, or (at your option) any
-- later version.
--
-- This program is distributed in the hope that it will be useful, but WITHOUT
-- ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
-- FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
-- details.
--
-- You should have received a copy of the GNU Affero General Public License along
-- with this program. If not, see <https://www.gnu.org/licenses/>.

module Test.Wire.API.Golden.Generated.PendingLoginCode_user where

import Data.Code (Timeout (Timeout))
import Data.Time (secondsToNominalDiffTime)
import Wire.API.User.Auth (LoginCode (LoginCode, fromLoginCode), PendingLoginCode (..))

testObject_PendingLoginCode_user_1 :: PendingLoginCode
testObject_PendingLoginCode_user_1 =
  PendingLoginCode
    { pendingLoginCode = LoginCode {fromLoginCode = "GZd\DC4)K Yi"},
      pendingLoginTimeout = Timeout (secondsToNominalDiffTime 2.000000000000)
    }

testObject_PendingLoginCode_user_2 :: PendingLoginCode
testObject_PendingLoginCode_user_2 =
  PendingLoginCode
    { pendingLoginCode = LoginCode {fromLoginCode = ""},
      pendingLoginTimeout = Timeout (secondsToNominalDiffTime 3.000000000000)
    }

testObject_PendingLoginCode_user_3 :: PendingLoginCode
testObject_PendingLoginCode_user_3 =
  PendingLoginCode
    { pendingLoginCode = LoginCode {fromLoginCode = "\DLE\1036330?"},
      pendingLoginTimeout = Timeout (secondsToNominalDiffTime 9.000000000000)
    }

testObject_PendingLoginCode_user_4 :: PendingLoginCode
testObject_PendingLoginCode_user_4 =
  PendingLoginCode
    { pendingLoginCode = LoginCode {fromLoginCode = "R;`n\NUL\1007309\ETB})1\r\1025774\&0\1065943\72805"},
      pendingLoginTimeout = Timeout (secondsToNominalDiffTime (-14.000000000000))
    }

testObject_PendingLoginCode_user_5 :: PendingLoginCode
testObject_PendingLoginCode_user_5 =
  PendingLoginCode
    { pendingLoginCode = LoginCode {fromLoginCode = "\1027460\1021149$bn R6"},
      pendingLoginTimeout = Timeout (secondsToNominalDiffTime 14.000000000000)
    }

testObject_PendingLoginCode_user_6 :: PendingLoginCode
testObject_PendingLoginCode_user_6 =
  PendingLoginCode
    { pendingLoginCode = LoginCode {fromLoginCode = "\bQ\172710h'v"},
      pendingLoginTimeout = Timeout (secondsToNominalDiffTime 15.000000000000)
    }

testObject_PendingLoginCode_user_7 :: PendingLoginCode
testObject_PendingLoginCode_user_7 =
  PendingLoginCode
    { pendingLoginCode = LoginCode {fromLoginCode = ""},
      pendingLoginTimeout = Timeout (secondsToNominalDiffTime 3.000000000000)
    }

testObject_PendingLoginCode_user_8 :: PendingLoginCode
testObject_PendingLoginCode_user_8 =
  PendingLoginCode
    { pendingLoginCode = LoginCode {fromLoginCode = "\994813F\STX\1107161H}"},
      pendingLoginTimeout = Timeout (secondsToNominalDiffTime 6.000000000000)
    }

testObject_PendingLoginCode_user_9 :: PendingLoginCode
testObject_PendingLoginCode_user_9 =
  PendingLoginCode
    { pendingLoginCode = LoginCode {fromLoginCode = "l0[Yv"},
      pendingLoginTimeout = Timeout (secondsToNominalDiffTime (-7.000000000000))
    }

testObject_PendingLoginCode_user_10 :: PendingLoginCode
testObject_PendingLoginCode_user_10 =
  PendingLoginCode
    { pendingLoginCode = LoginCode {fromLoginCode = "1vr*M|\DC4\DC4,\28983Z"},
      pendingLoginTimeout = Timeout (secondsToNominalDiffTime (-1.000000000000))
    }

testObject_PendingLoginCode_user_11 :: PendingLoginCode
testObject_PendingLoginCode_user_11 =
  PendingLoginCode
    { pendingLoginCode = LoginCode {fromLoginCode = "b@|zB<"},
      pendingLoginTimeout = Timeout (secondsToNominalDiffTime (-14.000000000000))
    }

testObject_PendingLoginCode_user_12 :: PendingLoginCode
testObject_PendingLoginCode_user_12 =
  PendingLoginCode
    { pendingLoginCode = LoginCode {fromLoginCode = "of_\1090404%2\16549BP\SI6\1018205"},
      pendingLoginTimeout = Timeout (secondsToNominalDiffTime 2.000000000000)
    }

testObject_PendingLoginCode_user_13 :: PendingLoginCode
testObject_PendingLoginCode_user_13 =
  PendingLoginCode
    { pendingLoginCode = LoginCode {fromLoginCode = "k\4965:i'"},
      pendingLoginTimeout = Timeout (secondsToNominalDiffTime (-9.000000000000))
    }

testObject_PendingLoginCode_user_14 :: PendingLoginCode
testObject_PendingLoginCode_user_14 =
  PendingLoginCode
    { pendingLoginCode = LoginCode {fromLoginCode = "o\39955G\61707"},
      pendingLoginTimeout = Timeout (secondsToNominalDiffTime (-11.000000000000))
    }

testObject_PendingLoginCode_user_15 :: PendingLoginCode
testObject_PendingLoginCode_user_15 =
  PendingLoginCode
    { pendingLoginCode = LoginCode {fromLoginCode = "I)#\a%\15452s\SOH\f\1015637\DC1!g"},
      pendingLoginTimeout = Timeout (secondsToNominalDiffTime (-10.000000000000))
    }

testObject_PendingLoginCode_user_16 :: PendingLoginCode
testObject_PendingLoginCode_user_16 =
  PendingLoginCode
    { pendingLoginCode = LoginCode {fromLoginCode = "%5\DLE\83474\1063007F\aR\153920\ENQ"},
      pendingLoginTimeout = Timeout (secondsToNominalDiffTime (-5.000000000000))
    }

testObject_PendingLoginCode_user_17 :: PendingLoginCode
testObject_PendingLoginCode_user_17 =
  PendingLoginCode
    { pendingLoginCode = LoginCode {fromLoginCode = "Jx\1084496i\992150\ACK"},
      pendingLoginTimeout = Timeout (secondsToNominalDiffTime 15.000000000000)
    }

testObject_PendingLoginCode_user_18 :: PendingLoginCode
testObject_PendingLoginCode_user_18 =
  PendingLoginCode
    { pendingLoginCode = LoginCode {fromLoginCode = ""},
      pendingLoginTimeout = Timeout (secondsToNominalDiffTime 2.000000000000)
    }

testObject_PendingLoginCode_user_19 :: PendingLoginCode
testObject_PendingLoginCode_user_19 =
  PendingLoginCode
    { pendingLoginCode = LoginCode {fromLoginCode = "u3\166268\US\142669E"},
      pendingLoginTimeout = Timeout (secondsToNominalDiffTime (-9.000000000000))
    }

testObject_PendingLoginCode_user_20 :: PendingLoginCode
testObject_PendingLoginCode_user_20 =
  PendingLoginCode
    { pendingLoginCode = LoginCode {fromLoginCode = "e\78720\NUL"},
      pendingLoginTimeout = Timeout (secondsToNominalDiffTime 15.000000000000)
    }
