-- This file is part of the Wire Server implementation.
--
-- Copyright (C) 2022 Wire Swiss GmbH <opensource@wire.com>
--
-- This program is free software: you can redistribute it and/or modify it under
-- the terms of the GNU Affero General Public License as published by the Free
-- Software Foundation, either version 3 of the License, or (at your option) any
-- later version.
--
-- This program is distributed in the hope that it will be useful, but WITHOUT
-- ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
-- FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
-- details.
--
-- You should have received a copy of the GNU Affero General Public License along
-- with this program. If not, see <https://www.gnu.org/licenses/>.

module Test.Wire.API.Golden.Generated.PasswordResetKey_user where

import Data.Text.Ascii (AsciiChars (validate))
import Imports (fromRight, undefined)
import Wire.API.User.Password (PasswordResetKey (..))

testObject_PasswordResetKey_user_1 :: PasswordResetKey
testObject_PasswordResetKey_user_1 = PasswordResetKey {fromPasswordResetKey = fromRight undefined (validate "")}

testObject_PasswordResetKey_user_2 :: PasswordResetKey
testObject_PasswordResetKey_user_2 =
  PasswordResetKey {fromPasswordResetKey = fromRight undefined (validate "g0pDhT2io2we8pT4P3SI5K1hEOuqhlgr")}

testObject_PasswordResetKey_user_3 :: PasswordResetKey
testObject_PasswordResetKey_user_3 =
  PasswordResetKey {fromPasswordResetKey = fromRight undefined (validate "sP9UlBCOng==")}

testObject_PasswordResetKey_user_4 :: PasswordResetKey
testObject_PasswordResetKey_user_4 =
  PasswordResetKey
    { fromPasswordResetKey = fromRight undefined (validate "cUigWYIeFro_uPJTq_Nb2DpiQHEARzMOjLRmJw==")
    }

testObject_PasswordResetKey_user_5 :: PasswordResetKey
testObject_PasswordResetKey_user_5 =
  PasswordResetKey {fromPasswordResetKey = fromRight undefined (validate "lPJNfPNKQUdGHBnmfStc9CyX")}

testObject_PasswordResetKey_user_6 :: PasswordResetKey
testObject_PasswordResetKey_user_6 =
  PasswordResetKey {fromPasswordResetKey = fromRight undefined (validate "5hytdEvbgEY=")}

testObject_PasswordResetKey_user_7 :: PasswordResetKey
testObject_PasswordResetKey_user_7 =
  PasswordResetKey {fromPasswordResetKey = fromRight undefined (validate "NzCRCk-v-hxNW7ZM08D1lUB-")}

testObject_PasswordResetKey_user_8 :: PasswordResetKey
testObject_PasswordResetKey_user_8 = PasswordResetKey {fromPasswordResetKey = fromRight undefined (validate "CP8=")}

testObject_PasswordResetKey_user_9 :: PasswordResetKey
testObject_PasswordResetKey_user_9 =
  PasswordResetKey {fromPasswordResetKey = fromRight undefined (validate "Vg9OYTx_vr8c")}

testObject_PasswordResetKey_user_10 :: PasswordResetKey
testObject_PasswordResetKey_user_10 =
  PasswordResetKey {fromPasswordResetKey = fromRight undefined (validate "xuk=")}

testObject_PasswordResetKey_user_11 :: PasswordResetKey
testObject_PasswordResetKey_user_11 =
  PasswordResetKey {fromPasswordResetKey = fromRight undefined (validate "KDnmIKWtN05-lUhE")}

testObject_PasswordResetKey_user_12 :: PasswordResetKey
testObject_PasswordResetKey_user_12 =
  PasswordResetKey {fromPasswordResetKey = fromRight undefined (validate "IGKDqfCYsFkOZw==")}

testObject_PasswordResetKey_user_13 :: PasswordResetKey
testObject_PasswordResetKey_user_13 =
  PasswordResetKey {fromPasswordResetKey = fromRight undefined (validate "wFmjRzld-Y8KFP5n24viRe0K_6rP1pPMVfM=")}

testObject_PasswordResetKey_user_14 :: PasswordResetKey
testObject_PasswordResetKey_user_14 =
  PasswordResetKey {fromPasswordResetKey = fromRight undefined (validate "og7OvTf3bJiUgIZE")}

testObject_PasswordResetKey_user_15 :: PasswordResetKey
testObject_PasswordResetKey_user_15 =
  PasswordResetKey {fromPasswordResetKey = fromRight undefined (validate "EL9g")}

testObject_PasswordResetKey_user_16 :: PasswordResetKey
testObject_PasswordResetKey_user_16 =
  PasswordResetKey {fromPasswordResetKey = fromRight undefined (validate "8fR1oMv9pfSM1ncA93eob_1y12WaDuXilb4=")}

testObject_PasswordResetKey_user_17 :: PasswordResetKey
testObject_PasswordResetKey_user_17 = PasswordResetKey {fromPasswordResetKey = fromRight undefined (validate "")}

testObject_PasswordResetKey_user_18 :: PasswordResetKey
testObject_PasswordResetKey_user_18 =
  PasswordResetKey {fromPasswordResetKey = fromRight undefined (validate "W3RLTh1wbik=")}

testObject_PasswordResetKey_user_19 :: PasswordResetKey
testObject_PasswordResetKey_user_19 =
  PasswordResetKey {fromPasswordResetKey = fromRight undefined (validate "m-Zh-cCYzhYY1vLf4gW6")}

testObject_PasswordResetKey_user_20 :: PasswordResetKey
testObject_PasswordResetKey_user_20 =
  PasswordResetKey {fromPasswordResetKey = fromRight undefined (validate "2Ei3ppMzZm8Y23uKu9ta-ZT69CGG6kkH1w==")}
