-- This file is part of the Wire Server implementation.
--
-- Copyright (C) 2022 Wire Swiss GmbH <opensource@wire.com>
--
-- This program is free software: you can redistribute it and/or modify it under
-- the terms of the GNU Affero General Public License as published by the Free
-- Software Foundation, either version 3 of the License, or (at your option) any
-- later version.
--
-- This program is distributed in the hope that it will be useful, but WITHOUT
-- ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
-- FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
-- details.
--
-- You should have received a copy of the GNU Affero General Public License along
-- with this program. If not, see <https://www.gnu.org/licenses/>.

module Test.Wire.API.Golden.Generated.PasswordResetCode_user where

import Data.Text.Ascii (AsciiChars (validate))
import Imports (fromRight, undefined)
import Wire.API.User.Password (PasswordResetCode (..))

testObject_PasswordResetCode_user_1 :: PasswordResetCode
testObject_PasswordResetCode_user_1 =
  PasswordResetCode
    { fromPasswordResetCode =
        fromRight
          undefined
          ( validate
              "qkRjzBBw5T15N03ATRzYOb7rbsiMZpvvs3CZ-aCr3X5E5VeW1xeefNWqTX2jQ7_4siC8baRtlvKdCSuwri_nuPtI1opZNpkEZmuN1gCWPritW_jNSTtjLsfZmo-H6aEem4A-Gljm2oq_m-lWx2LxF_fEg-N=-mYIsueLOOJm4wz_N4DqvGUQttX3pDJFhiZS_grUhGytHLGcMSjznQMJmVNELqLkKe7akS1ioWWHCo3dStn5qnb0N1WgJ=1JevpWnKxqY9IFOoes--iaifxYYeCpaClMmwVUcr_urk=lnCcFEklZ4YBygGOXBuFVkbJ5yvH1ihByJhKZODxbCQRVchO87=tInw_tiUll2Xo_OxXxMIx7Df9DlDm"
          )
    }

testObject_PasswordResetCode_user_2 :: PasswordResetCode
testObject_PasswordResetCode_user_2 =
  PasswordResetCode
    { fromPasswordResetCode =
        fromRight
          undefined
          ( validate
              "bXyG5XLFih2LcOjvgmaksGlSeqsrAgh2HcFVJYYl5WTN5CI31WlUijf=Q-JNoBdKtYZQVcVTWUQotMGl-olS9=GpyPoVX=JlzGjIAffi51vEMH6BC4B4=I5zjXZfG275ItEvOrsTeq_kU6Eb5kh42agWD=aGDz69x6wd4uoa6MGJsb7rolSD1Jucb3vNstHQgFwUefkTQW2dfPnjMrLVefZh0CMBL969pkpyE"
          )
    }

testObject_PasswordResetCode_user_3 :: PasswordResetCode
testObject_PasswordResetCode_user_3 =
  PasswordResetCode
    { fromPasswordResetCode =
        fromRight
          undefined
          ( validate
              "3y9hV_whpiLPPvrVcaHaGg5GuL-0yHG6cIk6-H2O6SOHy-XC6CeTatemT-3GpOT_q4UaZFBmGQA-9t5FqzQhq0gyvRCmXv6d0ofUeZGKTglS7Q=3ew5at-V_V1l8uAPSoYqqLxtT505YKA-MGi5Df4mE2ulsJ6_oMaxrfx=FJZX4h72kBknQJpLgdfpI_8uNUUl9GJVbsva=W35G4ACfdcsts2=VZ2P3qwuIs-EtuCNIujx78O5noZ=EBM0tpb3Mzwj6ZhH_iOnCXCaf89ybQsaS6=UgKSYdkUpbsU3N0ySM-6QOtRFysOMKWRshs9LYGDLRmVKioTbh5zRA7B7YVM-8j3AnyHpb52FIOagob=4Ht0vmDVMqcyFTIXZIYhvG8OiHmii9edPdkbb2ORXO51Xya1ogt=mwEJpqvZnjZi25ps=LQsBv6W8pGAkyv7Lpy896NkYjLCix6Pb=b_qL3Uf8yjBKnrwaxl8MFxQsjQHhD5skNNQrjU2oggk9PaLFALZWhABFGm1I4QkohfGn0qTLBWR1uF7BdsMVfstKHrSZv5j=hpD39H0NUs6xBZwOI7UrPpLwfLlCSk_ibf=A82LeWKazKVncAspiwFjXxW3tQrM=sXKzytRaLLYfrx69jMT0l0jnXbWH3t6f-SZ9TKqCPh5ge6lftZTkglbdb_VtOIcYIUWNel71Rv9MKNyjJd4I-U0qxk=CfkJOIhxncoAWKoTBRqVrUc8fgQfnpmABNsij2AXOV3sNHhmKsUSJiUXkDjGbE9EFzNkSiP2aUmfjXr9O4avm5yg8CO7=-C-hqflNHQ1TgqQWRXkm2Y-6M-7Rttap6jitzwIDjmwt61A2qfx-dONMVvfSYTxc79tlO6zb=CuR9hPpbNP=s_gcr6ugJmO4O3s0W6y=tRqcbqkPXmdl_Lp-vtykya2hEAUS-H_T2dd46cHNsUG5axJg7lzG_WuOLbpfEh0ch3_kI4sxy6o4fpQNf"
          )
    }

testObject_PasswordResetCode_user_4 :: PasswordResetCode
testObject_PasswordResetCode_user_4 =
  PasswordResetCode
    { fromPasswordResetCode =
        fromRight
          undefined
          ( validate
              "xyq4HKh19XywmKznhfk_qHop0Q28wvP-xM3ekfYpoV7F03B9pGoO7jZKAcgxf2jCPJ_YMT4KbPOJmZpl1LiDYxPwMrJM_6EQUghalFY1_=ZUUZdpLQjPdPqsgHquqrYNP==Riey=5UdqbTDPOhwG4PFDzMExV58W8WBVQJA6HsljJixe5Zx91FEodBWNw9O7vWQHTSQ1fwPuK6RS4vrjj1gU2OV1eAMTlb3xsZcCvbzmOgXSbtswkdubdQD8XsPKxuopHyrWzIQnnM38onnpvoxVjOMEMSWa-Qbw5IGrdXtbdzmi3gNcviLfMsw8541WVgjrvPaUNYU9leskXE4tz1FK=PWkoMNBtdV=cqzp-=hbvkN9FOxhaf4e7AVBKuGjVvHuWM9sjGCTQAm7kPQ4jIKIhMPyMb1N_FVKu7XAPRxBed3Wz3Y4_uVipNDTdQ6siWM4_jGRn9x8ESiPWaDMtRF5XLe-PSRjS8OqUzspjmE3Yzev8A4L2wQEx5pop4hdH0cny29Qq0qrXSe3wqse3P_gfw9x2WWfKV=seg6SSVEe3y9V3h3R4Z=MqboaUQDIvwgn7fYdGGtJmbYC4Mf5GwcHEhxUupZ4oCkT85bJ81RoA3eEpytHCltVsGCG2Rust_KeYR=9FWXE1Y4zCNo8TU1MbQ1HOz7hyl-SEYfzNoA1r0HFo2OCBqJ7KbkDV9_yImmBibKfA-kXfM_jpTZF2oQXkzyela_SrLbtXnmwsrzU2pW9sGWEe4ef_BO13JoEv-5tKmK0Rm-ZD4wOn3yZ18-559XKNzBA"
          )
    }

testObject_PasswordResetCode_user_5 :: PasswordResetCode
testObject_PasswordResetCode_user_5 =
  PasswordResetCode
    { fromPasswordResetCode =
        fromRight
          undefined
          ( validate
              "vrpuZROq=nohTjClGY07mpz_QnkiJU2-2xE4TFymIPo3vLE7fUGRDzFyp7VQdfOMnlGcGTencV4aUJvRyl0VhRbLF5AnhDmtZpp0_nRfFu48dreccQdyeHAFr1Kexx6Up5n=d0dyvyULLq-J0uZignbnAFy1R4HlSMpOfpE-JmtXlaXgmWtIq5G96qvNRdaz2m1-JogSJ5uWUNkrlEKiirfx1Kg422lV1ZwdQLjIDWW8MYA4m2ZqXkTDThEfeSSi0jN48kCulTDJcvIhOS38euVp6UdLr=dH9=jvx0D0ZRMFS3_WkMlSoiuP2PToVac4Q7M4JEtLgex5sDvx8uZ9jV-UBHCeKUJ9i1AZufheZ3TghdqdWbjMP7Yc521ln4PXtc4C_JDpWTuEplHWg84Bhyym=qwXl0i5P=A0eycc-HUxd8mFP6iyGzjJY4dYBCK4w_dbaf45Op_Qmz_B3S28mpXwQ=nxfzX0bmjpQujSYHTM53Q2sZbzDjMPxA8OAdh9W4K3VUfuwlHA8NCXtsLquOjHG_JFu4cOXCBgCIbnBfAyt0NdnBDQelZ37=b7hN_bUn3Q2X09HCYIf1BNXX8BdpH7YpwSBpp4f5iB_XevnLm8PKuffy0mxruk21Ker98ARTGG91ECleRbdv5teYMwXWao0IzxVij5sy4B3aDnWbyAS0P3iCLaE5QG4MA6qeaQjnRQIJSWXyvIQOGuZHdcBqVdIu3GQiFi4RdlMghz6_9vkOEECJR=VbR1ZW4yx5POCmzBvK_qjCN=pss4sDIQ7Oeo1RgwVWIm3mkESF72dNO2OhaneQVOguA5wOU_ubJZoC0H04OBD6UUdbdiI7gDYCjKusxqoD1y0qNN8xYmcbcw00jwlDi8YzVN3bB-Myw95X6r8XalM1nXLDFzfM8WeHujxMNwAltp7SSqO6u3KGmPVcX3Jhdj32Q7C7AXLZaD_9llXRtwbt_k6J9PwmOnplRsfmEdwMsGjRXBK_d6tSZNo5"
          )
    }

testObject_PasswordResetCode_user_6 :: PasswordResetCode
testObject_PasswordResetCode_user_6 =
  PasswordResetCode
    { fromPasswordResetCode =
        fromRight
          undefined
          ( validate
              "3T58zkUPzOEui-YO4qpkRwNCbO9pXpnzeHntQulTD0-Z4Yv8DEXDgvWGlTPjUy8s07Zynj86gbNcOBsB0wP6FBBLIRRMjvz8PdcvYJB4z1kyBhjU9V24lGCvdTN6yWQKnPfmPRMJRValwKjEK=emFNF6TMfwnJX69TuBoK0tPpIX6LSTgQzEqf2sBCO3TbjEd1KUArpMA1ToGjrlfwP5qDEtRQt8pOLTJ=AJ82cm5Be7R0QG5h1D_9ZCodc6uOho=UeNu_pSkv9eHMV5kHIIWR=qJiI0aG1_pfAFPzX7W0=qy04-4m0Nb7d2glq=1vf5UhgjnjCbiwf3SnFTb8Pp8pnr"
          )
    }

testObject_PasswordResetCode_user_7 :: PasswordResetCode
testObject_PasswordResetCode_user_7 =
  PasswordResetCode
    { fromPasswordResetCode =
        fromRight
          undefined
          ( validate
              "ct5f42l4Gs1Et=b4jRn9JA=uWjAuwExxg8ALFl6DtECh87rZt1=bmRsx9_OCnoOpSv2P=OGkF=TdUgAo=LHhPp0eLiaDf4wTfbDg0h_hQM0sGf2gNTtiEDblBslbhkw9AzbqbPOihQWoGuc0yUtxUMRFlbUXzipTLan5eF6TQHU0o0mYgIFBAXbSceLoFjsxIQi0pFEHqbts9u70iw1czjSsvQfR7a2fE5th4K9rlNdM7G1b5q3FOkrVKN5ngm5-oc35uq0kb61-hOpXY1vSWCGXeNB-Pi4i9qvhDEoYl=K-xMwB4ef7CCNBUdpgcp9qcTgKKqdlfv3N0yaMq_MB6FCVFeFWHQoR-68MHGEn0l5YxclITf_2b_Fxth_oyOF=yhjN55c_XjUg5vx=H8vATzUNOYNGoYDDsV06oz3=-LIVYCujv1FqSlbjpbXkUjGOZoGXaJnaf=q3pPhno9_nI"
          )
    }

testObject_PasswordResetCode_user_8 :: PasswordResetCode
testObject_PasswordResetCode_user_8 =
  PasswordResetCode
    { fromPasswordResetCode =
        fromRight
          undefined
          ( validate
              "xDVrK2upjM0ijbe-mTFMX4Oj2Xz9wczY7Gg27=9b6GeY4_bj6tY1Ofa3urdpRbAK9zw6Ro-xLZntJYNUpgsQKFdnwkZtEfxP9X5ddUD4Us_pf26NoYSRbbzM9ONbu0P88h2SfJ2oqPdf6xz500EYprE6a2R7xyNkmNbgSJf26lRqVkQCABTPrpbbbE_1ah5Oz-c3lXQph=nb"
          )
    }

testObject_PasswordResetCode_user_9 :: PasswordResetCode
testObject_PasswordResetCode_user_9 =
  PasswordResetCode
    { fromPasswordResetCode =
        fromRight
          undefined
          ( validate
              "RAxVH7Nx9wLrjYlmhoz37XNTNzJ-BZ0Wqgr0K7JM_B8U5YEk5o6fGcjmPxSzQWBsEMFASQx=ZfUg4HGHHlYPln8ar_v4AiudJxC2L_vHb72_gpGNpMTqXPVf_"
          )
    }

testObject_PasswordResetCode_user_10 :: PasswordResetCode
testObject_PasswordResetCode_user_10 =
  PasswordResetCode
    { fromPasswordResetCode =
        fromRight
          undefined
          ( validate
              "jzUinT2hVYRkGj3lXaePbIZWdUem6zgm=nBe7N9oc6JEZrAtPMNneQ0CalcavpdwI_=3P5SrqGerOeO3UO57-pHZwr2ACL9exYEuSeU50B0SMX7GpdtqzK2wTZ_Hjb2K6OSmeXAgX4ZmAtDi-uLzC5DST4rDxA9wbaJ=57LKcu-1tY_9Z3tdXiReO2vMAAwc3gArD4jBblNpqeEO7Ku1qmEGIwJcZ=xE1=e2E0FQsdOat=uPi1-=u4PS2BEKjXIHjFeVm0rSG=-eLiabb_GbKGMj84We1gNzvNjqwhjgniFVEw7Z7TokhnkEXMzuf23ghIkIQ2lPBKTHlQ7AIflEKFfM4MY1ga=gycVbiW3rNFpRNJUYOKmG2rQvD4=eJgZtNdvBHH-rcCxAbl4UVJbg0gSgPfozOMbftEL_KOSopL76UEE=h=DXnc-MGdM_b_vURTgEr1Bk3DeMbOpHQKSXW3KhGylgeqrc6tNFTD2L_PXvS39poNhi38VlCK0QWxbJ8sw6TGcnPWUD4jo7ZL9yA_ps4Me6H0vWt=2IdgGGtTMUR-XlEKk8nweOgRNWcMdEp9v4csVnaTfYRK-QTy8GBS969RrhPWZbQbtfmhMBlFimVf6kmv5vntmtd86J5X69K_V4pjRuaTulHjkletviTtZzCEx4bTM3qScHJfBR35dJ8YiOTvfwF6u=UnV6exO-Y-SWKfu8SNZmd72rVByh0GJiANd28D73IVCsHW2UsrKO98wpmM_yZ1FdsagxqO03VVrRL9pOEX4TLfqAKCgtJ2ExwsKl1MzpAOSOxsn=PBcWY--2Wqg3c8tUmN4I9gMai0oU31Uc8c6AkY67u61qO6DXzQ7F0brTJ1af9H2o_jhUfHqv=JwHWJjngKiQzX599fAvXcny5nV_gm"
          )
    }

testObject_PasswordResetCode_user_11 :: PasswordResetCode
testObject_PasswordResetCode_user_11 =
  PasswordResetCode
    { fromPasswordResetCode =
        fromRight
          undefined
          ( validate
              "4zmo3bi7rz967AZBNHCOypgyvoXDuYEbVzK0IJ4NhiB0K9B-DW9vhgUqlB_E5c_JOF5EyY=YYDkl7iQIUkE_wSqJdl_6xtDmfuOpTw45EE=aEYZrvr9TPQZmguBbgYFDsKXJJkp_5=00BZLSFpwgVp7CpWY9YAst5YS3jrxteEDg4LfhMnFXzwjEpXNgZIZNmgze32GTSJVYBfno7bgQjc-c9YUYCCS57Xq1sueg3MrbWwh=Sx9q2s4a-FNlty0RobyyB9VS__nWcdue1fDVfh91EUbap8piq50-3sZT3YIBioBXpkX1OV4aGcGqxKhoYcf9TwjzywEoOGVmxwKjbt5TJ7A=pb01elmbMXXqR-ZlR7T7umCBAxCFyHBQYcO2h7-fUnApIvO=Q-1tcH7jNtoSwvLI8jipPHTxhWnXRtj-NaIuBBmIcndtEXVH_dn8wJJPHZfjyZ6lAfdqYmUpkcj4ojIcPsdxQqO29dCWZ9rtGe4f13SzIiNR4A2BSmjVQyJ=2HZxUWBzwkKvIZkc3pFpoOHwJL1QOR2jgFvgm1Pirhpj2OhU9pgg7X6DF5I_-dr7bUJ_xKZmh9jkVyxwxxzmgylQz_cxp-J3__hryXHINaAB0khFgQ24r6p7b4zS8hoBuplO_vVIhdDMZrGFKv5POZXWMxIHC7QS045pmXxanFMPxZXNhrnHb8eAYNTzVRotD15v82JE5djNXK_h1mrIwkpcyREXJJdVokS=WBvc30Zo8MMumPyCoPWms_8-LzgfmkF6NiqQKErR9n_GWIIxA3mkGmoOf5t69oMLNOLKKpsRrIs2SVLBo1zBVJILSIncvfROeemL95=solpZUol7lKY-UWQSj38xkKGwM4OqQKLckFbf2DYkrD=aBNIx4ygdcGwOPHeYXqzxDOPy99ipzURywB3qpFSj8CJNSgjArkUPufApDyMngIlNyUXhvnwvQGGbPQDCu8WQ5bOexMOTPudP7BLax1zL-77WvHwKxjB"
          )
    }

testObject_PasswordResetCode_user_12 :: PasswordResetCode
testObject_PasswordResetCode_user_12 =
  PasswordResetCode
    { fromPasswordResetCode =
        fromRight
          undefined
          ( validate
              "7B5RbyOOT8LTS7BPuwihZ8UjY8EhhJ29WTv6loe2iSvv=UXurtFgeBJPaRC15AwNMjZguDbldUjJUAAOMc7dcwcQn5PwvYbKHhz3apJfRfWidG1_VU3t=4655CqZd0oVIT4cXHSC8vtf=kftZbi=QIjoOc53Yxuci4uT0z5gsL3iD1bWizEjvA6txdvqzaftfkx=08UzBIe20l4uPPXhAfNAB0VBF8lYVPEO7_7VkflX8tyvF4Aq6e2R8Hl2mmQ=hUuYnBv_ArASVQblW49nkeTaTZBfxX-wugIgYD0Gk2-0sjId5VZrxwzfB0VZA5hxL52KzFWJXn-=W=1zdzROUd2Jd5jrTbW4ID3CuVceV5TeyejLnKTph7=dOxZwSwzpKb9z=91QhFBr=H6eVUAirSHhONThnoElBkFaGYYnfMtiaV9DmsNbBi3d7ixwNsPKoT1bKIOk6cTlZHB__ZhfE_dS34sEy520TP9rg9emlFyPz-Mip6a36FDr9SOgbb=eunv9QVcVsmTaSTGHC9iynJfSzBlsJIV1S8jOQV2=Ke=tR3uhyD-J0PRVWyLv85BMgRJK3uI2tPyWjmSK5Sf_f3oOcT_MHiJUE15UCl_MuhkbJ8G=mEJHunybzt6b=zM94JPanP=ALCsk4oFMKs067z=g4rMF=j41Twil--sacddn2CLZnDqGRqusjxG2Sy9eiyJvbGPmLB3OWR9Nw38uLOrBUV5ws9Lv4WOuuvavXl5qsOCY9k5Y_kTIZPPJGhvJq4ujPL4zji7P70LqYAGzO440yCJMwt4rQpnR3uxwM1qbXd-0cyM2XcsYPPEOzchqdNH0bK2JuxTipyrQdEY0YeHmhgqh2Ajk22T9ZHoRvbQGzgq7qm0DKSVGYoWM7rocK02AAN4ywcFE9qCrZIbWCRGGLW2mmpIR4GCDm0e=jzDir9fG3pbWqoMNc7NCxD4bIV_4kSaOfN31zly0SFpBTl-xnplSDY0G"
          )
    }

testObject_PasswordResetCode_user_13 :: PasswordResetCode
testObject_PasswordResetCode_user_13 =
  PasswordResetCode
    { fromPasswordResetCode =
        fromRight
          undefined
          ( validate
              "uLy6-eoNSfheQSUol2hgEpjCV8tPRESrxVC49FNE_98Qh0DvuPiXL3Qb0YToWC_azXVKeb34R63N7VRrpmb_pxNfOSLhNYrD2lwO=qMQVYDkxJ1LiPghXs5x2mPOOGTx4Xs1kRTySQ5TUNoPtLdTW1kbhRBLqg84fwP8W6PTbuOBQJh3QqM4gWDuMx3NrNY0RwtE6q7ydIHZOPjkE5IJGDMXP1WcCD6SlEx=yUMZ0_ke_N1ESDd8gwQk9XPoRzO=KNRyrM=1vVcY0tTJTB5IwZ8k7K7XOt9w52=u_v2lv3y6OZagm2a-ImiHrsCQoa1NsZzWfCRURWwuoOALttH53oNhOGQ0wCgW0K5LKUsZBX4q6adKTp_OTYAGQPFdzfTu=87zUvD-bOnqbZPvpOsQQ1_1Dr6CF1WhkbpqGiSyBGMjskcPGx=vYYhzp0mWNXJiEkI8Gr61CmT4vaTs7-5vfhhoQviE=MS=f=v13j3ySsWRlKqE_UTecoEXXbVg09KmQ-07teiHWnLnUvAp8s=HWI7N-q0akEGzHYjIUkxhdJmkoGH-POt0B9neh6A20csZNvdLN9Q9dUNrz7xho1Cn1YMJ3RPaR17VH2yrWy6yWuNsko7QQ4ADy6oFDaN0OLfXTl8D4d=JLRxbvvhjPnyrVWew3Qtp6T2cy6kRqYspx7VpkgCpudQtRj9167qBumroKecMC2qdmowfxtkkfn8E5dbB1euR-7ZIuBUoCaczABv7VCbFa_rFaLD0o24OjnAaG=tUK_tGX2TgR=xE0"
          )
    }

testObject_PasswordResetCode_user_14 :: PasswordResetCode
testObject_PasswordResetCode_user_14 =
  PasswordResetCode
    { fromPasswordResetCode =
        fromRight
          undefined
          ( validate
              "aJvhrwwqoMevSVUhYAaS4xQJXZKbBtbsNCxdeE61CwGw34BsqURBD3J7oZmOdeI_-Hiedcr7rug=TBqmSVFmJ34DqJjM2AAk8IYs7fId7AA=n2gRY65J3p8kRn3yO2GyF2ek7i8SzGDojsyeV3upvmTHrwESRrbi3jI-lT8KmuiNy9xA4LY0O5JyIwsDzX73XgfQQbBvWcsIC=K2yHMLoZs6hkDv8uqLAb0pXGsitx6mN3ym6a99w-usMYoNsnwOKltIGMDgWNygvejdRFc1uf0pRAH8pfkmJ25HdgkREV5uuSTvfEk57bMCXKdrBh0bRGcs2nisUURLnLy3D-ji-R2-DW1s9YIRLuJCe9c1DCVei1BCL21uz1lvZ8nw2edwf=xZ9ytB8Rm34wfjP5YNpA70D42mPwuvy5eg3UjKj3bD2X5hGN-aOFVYqdA3CnLojKsEovZCxjINV4f-cZOY3lVhAmk0IpuO5=d_CRql4xH6lOcZFGCjjLmd8jgaqSw=3DdpiFGHj18ipyt2yR3EVoc08m1EegrrBRnMVHATnCOKF4EU53"
          )
    }

testObject_PasswordResetCode_user_15 :: PasswordResetCode
testObject_PasswordResetCode_user_15 =
  PasswordResetCode
    { fromPasswordResetCode =
        fromRight
          undefined
          ( validate
              "pxxDsIykdeWTEOLEoBfHjEGu7XjeHDjSNVOpKMQvJu4oom0HWC0tlxlVRjtMuaRE0235jC2V8nx10Hk7wsGeGEF9LJrLZ=Sdo4kUapeL24THawpjXhGZCWgHpaJQ5T3nhtZ5eT1leeEn4TmRy3Bq-sBUkllDvZeYdrpMixua6ZPVXDppuwp2CYPbWtCML=TOiHlcrbIDJhrY4kV-vFBpQVoBFwAFgWHoEtg6HJ3Afcu2LbTAlKCdsqir1yMsTokyrF1XyouYpa=f3j-omVxfR78gRNeWMiilqwIzkzQ19PXdC_wltgRQPF1Xieu_99SqGwmFAaxkXleJL0Quxw=iN2wjEIl7U56YKnUv74-Eem7Xlcao13Wtpfqv465RmXOjt8Ik=aMvh4H9Jyl3-Kc99coVAV1p1MS9XiiWDQLMI4WES8k7y77QL1N1kO72qYiHg7zrLktdfP-ALuhynEfPnzELRXLeJJf6fA5kmBotJn=I=OUsNVqDhsnI5j-X24Kmra7f30WsaL_DWt6eIErHRJC3rvmEjwOmxy7tU=YLyxQfhOexYzH1gu5dK2Rjp8e-pGkbucRQk_avhJoWVSoBCQSFQhHTFdj_52816glriA6bQwdI6xxHERHlFcnB5aIwiAoD2Ao9_3S3A3djGsTqKYaHxMrUoj_9a_6M=TanHTLO9HWh77sR95yBmffmbdKGY_HnhbWwy8=_mD2eetLBcMiy4RnoGcGwRIKBc6v6d6idiiLybg=ClXql4sEU=m4Mr5I9l"
          )
    }

testObject_PasswordResetCode_user_16 :: PasswordResetCode
testObject_PasswordResetCode_user_16 =
  PasswordResetCode
    { fromPasswordResetCode =
        fromRight
          undefined
          ( validate
              "f4qA-GZ_WLuHpcWPbgWo8N5g6g6WNLjEEXNOwPxdZx=LY6ulDwsz4Oix_C1gHpeY0m2Zkh_hjNiQS2FMF=d4vbG3GSByV_Ji84o2daD_MmIFW1ROmHdl2ld5SnVoLaq6qXMfKFkgwpH6u0d26ltymV9VKfl2c5uaqssRci-GNREWfR5IjNEYmEcPBOIHpLI6OA0qziJFsh4WpIEXw=f_HriQXEJsbcW_woeSxFwt8n0eKfr7_FpOL5bjXI8_E1RI1t8ITb-BmoYzlA-H2MK_6FOGdRfetzyQm0m9vt3IPpoIASVucr5hcpdzJcVDwFCbEsVDT3w_YXkHeiB-I5utNJzyd8JXrE46yZJ3fEJXTx99EON6rIYDBx1u12EP_RWCLZUDH2-PhyDa_a_8L8faaj8=zUzCcla6tPEAf9Z_Q=LmNr9zFI5Aj1S1SLePw5COfTeX9brfeCxZW5XR0KtoVgRgFsGTfihKoAN1d3keN9W1c_Dj8XAED_2xYwJMOQRy6zyAWijOBUse8UH2kngFK_DQ7-EGXvgXTkW57DDa1WFrgA0CdRvOzviIpP=MjXqFrL7uxPTFl=_29cTVjIxu4PRyoNr8du7PLe7PctN0NiFHszTAfM8wBDvRV3qYvlMSzWXmFGT3Pn2z6=wPue8pqPG5s-sr7DhzLpyq0_Y7G8PlzmqXJEdA96nkH2xpZB_Ds=khlnBpfY0zCW0m=s8oILcJuF3WU2_Q=wCzP9rw2TT0hr_d8fmhNvFcKme2zcTyb0Sbt6pF9V90TVTpZi=XS8Gh=6wWQFQgt=FM=kjWdWD4d=MeJDMjXQ2Z4n3uC9V00xe_uaq-rcfwQg5-WQU5Hn=kTq8-DoOzrUYFVTL2lrnMT9WFQtlYznWM0xQ6ROTnkL_dgR9bvYgt3REomQrpuzlcG0qvUO=K=JDzQAk8mN4Sh4yTakVGQ0UcnLanx9Y9Ucvzl4MdT"
          )
    }

testObject_PasswordResetCode_user_17 :: PasswordResetCode
testObject_PasswordResetCode_user_17 =
  PasswordResetCode
    { fromPasswordResetCode =
        fromRight
          undefined
          ( validate
              "BIgADnGw9xXCxxBdZCME1T_FRhpurIQIJOQb_KdsO_6O2YdPGhunxTSKe36CUvB4FWzvk1qdEo-MZmNbjCrQSVuZZjppLbCiW4QKWQeVfsYus7QS=o7AjGS6-vBB6Cn_bHO0_lxJAvRzhIJ9ff9TtT_jHek3I1uNTL7E__Jw0D=OuZmaBN-EYhb-wMiO5VuLRyZiXTOIq54SkKurZ0Rngn3Z2xpecWTxhv5-xuvQB-8yoGEOaSgqMyyTUbXceCMxF9G0zWuCWsFnwLRa=4nO2KofovEGBz3B6Hrabi2sXkzoWJYIx"
          )
    }

testObject_PasswordResetCode_user_18 :: PasswordResetCode
testObject_PasswordResetCode_user_18 =
  PasswordResetCode
    { fromPasswordResetCode =
        fromRight
          undefined
          ( validate
              "meLcIOikfNpisJ6XdRPSlAoST9LM0RlmUnPwN3kA0XK3bcPWLD8NDt8H66aHlzw6u3G1RMBUA1pPaDEWyYe47DXHIW67Qs9YEsAaULt-cazp3x108zgmnC7r05HgRNtEinpKrszH9mRs2Qmolek-hI3rBqsnHIXXjK77xD_Fyn0p1yY5eWkMgp3B6VDmCgZUN_Q9kp5ouSbrnSCIBmoMcpPXWmF4wFWOqqN2A0j4p-N6O7c4ptoT3WqPAFTmcDYqmKNfQSB0Kve=r_uuvXU5NNVYt08acM4UBwrPhFvhQZirnix8ynJL4fX38sdkSPt9Bh3-Y-6HEUowmcJ9hapHIcsvKf5o4h99N0HXhoFB9mUmbfpAo9Tfup2eTPWnsFk_uD2NG_-yqMiGMRxY5ba3A4-Pi_l6L4t8KVnRxy9XZm-yHuxwU2-dsQ3JHwRjPkrndCWwmEW1gqGnfGAA9xRpc2fYyMAHMjfD9NkiHaXggiYphtyqa_LOvLKUT1tbPDkXqr1jov-yM_8xIoeVeRonNBde_O_Qj7NgN2oSjwYpj1zZnWn=TzHbN-Xblj=sW=JM2Up1UNL7VmSG0osWy3H8NJjTHJPpKbb1m=oRF6QLelLVVhenQHZWFqjcGfeyieYDH3S5pnvPSUj53Xyrtsj7Vasf3Syi6Ym7Ps_f9vjzR=fbXG0O4WNpY_6kBQrx95cnCpQciPMTUG0Rh6JTEEmY0658m7_J3ywOeQBmibTCEDvgWMVGcpown1MndxdG=G8qHNJ80iPZc7zr0LXYsuK1BA_09hALN=rJVDruu1VleouhohGybe5ZTkweiFK-VlQqNBOmqR8KDroyTqrOc22pI40-3eP6S-q0kAmY54mmPuF-cfw79o=qdQGEjNt2KSUegP1Z2ASAm4i8DGTVrEoYl=nh2zejnDdMssLtBoPe4U"
          )
    }

testObject_PasswordResetCode_user_19 :: PasswordResetCode
testObject_PasswordResetCode_user_19 =
  PasswordResetCode
    { fromPasswordResetCode =
        fromRight
          undefined
          ( validate
              "6rfuE95RuDaa7Kx3neuvC_Zb81Xe5ADzRP6QwHfon6Q5aiFtXUquRy3kl5E4P48UVPH5gIPkBNb_BskNUfiSYCfItGCOAIoiLITSJOX3rN2uTFTzDhW3QO2zjvFMSlgmT_Ew2rcCt"
          )
    }

testObject_PasswordResetCode_user_20 :: PasswordResetCode
testObject_PasswordResetCode_user_20 =
  PasswordResetCode
    { fromPasswordResetCode =
        fromRight
          undefined
          ( validate
              "i_v2THLu-oaTQDdbBLhfcTJrCPRiyGC=p40dGNfFMRJAJuLbv=RasCBzDYpTNkb7yIZMge1Uijc5KG3pWHAoavVJWJ9VtE-Pkf3Te-P1hp"
          )
    }
