-- This file is part of the Wire Server implementation.
--
-- Copyright (C) 2022 Wire Swiss GmbH <opensource@wire.com>
--
-- This program is free software: you can redistribute it and/or modify it under
-- the terms of the GNU Affero General Public License as published by the Free
-- Software Foundation, either version 3 of the License, or (at your option) any
-- later version.
--
-- This program is distributed in the hope that it will be useful, but WITHOUT
-- ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
-- FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
-- details.
--
-- You should have received a copy of the GNU Affero General Public License along
-- with this program. If not, see <https://www.gnu.org/licenses/>.

module Test.Wire.API.Golden.Generated.PasswordChange_provider where

import Data.Misc (plainTextPassword6Unsafe)
import Wire.API.Provider (PasswordChange (..))

testObject_PasswordChange_provider_1 :: PasswordChange
testObject_PasswordChange_provider_1 =
  PasswordChange
    { oldPassword =
        plainTextPassword6Unsafe
          "\RS\148930<7jc~MQ\SOH\US\7333[\1084132Lz\US\1022735?q'p\1099657\ETBy\DLE\EOT\FS\1107730x\ETB$<lPN~J\17212\53485\18815\983736\NUL\US\1057264b\1038502_Iw\1100753\134113M\184634\1085836uj\46450L\1082526'W@\162438\1009757r\1000811\&9>\1060369\DLE\61681\13692\993364\b9\FSiU\NULz\fb\22561bP\60643f\SO^\\\1008115\NUL\ESC\STXd\DLE>\1040220\1103806\SYNOIc\189228l^l]\1031063JY8J\1036381t\70171AcI\SIi]Bh\989297\ESC\140714R\r\NULz\ACK\1088597' A\DEL\\feuBiG\993059SDoWa\DLE\ACKW'\ESC!\"erY7Y`\\I\4948\"`y)\1045668iN)Z\1012930T5Q\1076971\147595\993658g|)\US\1003237\ETXJ\39701\1106744\NAKY_\a\vJL\1027083\CAN P\ETB\1078145+%.BF\153802Ay9M\98346\1008748\1104393s\25042pI\1005219_\1002925\rM\CAN\39386EZ\58119ZXS\1105928\RS5\DC4b\97371\SOH\1106103\184422b\100457\\X\STX\144554;l\49694xQo\NAK\138070\SOHJ\989399XE0^&\167968\n_1\USS\DEL^\SO?W9~\1099319\DC3=\DC2\1068564@*\155081yLc\ACK9\15796\1059875\RS\98699bV\1105827W\1005933o\1072486\FS\1000032Bmr>\1053735\1030072\157751\1056352m\1072516\142673G\STX'\1013038\&3K\"%Hk]\61616f\178900\RS[\ACK\1112290\DELvq7n\146589}F*m\DC2\ETX\1038640w$R?%\1048405\991130T%\1086216o\DC1\139752G\1070667\SYN|\1085639\111068\1068350B\a\ESC\1063604\1088194T\1019860@\SOH,1\1094852?\DC3\ENQ,)ipt\146004NXe\DELd\1015278\DC2 6\984739\1037131\&14\31204p\f\23571\134629\60442q|\EOTh!\DC4z\GS\NAK\1046271\RS0\120694\ACK\b\DC1\1057519\ENQN\22139P\139372?\",\955a\ETB\f\ESC+\"JpO\39005\1043690\54002\ETB\ENQ\1093734\CAN\1005666\SOH\DLE\DEL\2414I\55278'=I\EOT\62705N \SO{Vtdy\DEL\"\163827\37015hC,\1053062i\NAK!o\SUB\1075233(u&\fz\1049825\ETBA\1045850\175742\RS\US~A\40004:D<C\SO\34942*\57689Wb\1083986Y\1065752\STXY\46855'}\CANj\128883\1064885V\146168\&4\SIPK\EOT>-\ESC~A:p^\1079564\135140:\151246w\1025133m\61429>\6832:.M\1073891\10252'\CAN\1071280\24496R\1003679P\1024693*\SYNq\GSUX\1072603|\r\US.\1062109\NAK\1109389W~5O\1000925\STX\184929s\1006565\150194\DC1r\SUB\b\1057499ZN\SUB\rf\20741\SOH5\GSJe\66771\1067879b:z\SI!\DLE\ESC\t\NAKd\v@'C/6\DC4h\983790@",
      newPassword =
        plainTextPassword6Unsafe
          "l\992017jfd]\CANOG\1037448\9679E-FG\DELb\DC3c\168198\179584\r\EM\98126~\tW+\ACK\33446,\1082952M\128295s\1000699M'\DEL\STX\SIz\ESC}\EM\154156\CAN~;k\53216t\ETXx\149224\132305y\96580\ESC\DEL\142174#O\r\bJacD\GS}}M\n\aY\1033126\&01C\EM$E/\NAK-B\175854I\1023972\1070217\6129\1013299\184147\&83$E\1009863\22083\&0\SOn[T\GSB\DLE-\1007136cZ\46079\174945\38508\985022\173232\ESC7\1110907'/2\9477B$SL\NUL^\EM2\NAKG\1093469\&2H\ACK\DLE\DEL\43539\58839XR\1080271h,\78748\174767\1054239\1041868Y?\SOH8DF\EOTCh#;/x\DLE-\EM\bA\DLE\159735\bkX\SO\188157g\94522\172555\NUL:2<\166889\998353\1083925zp\SI#\1022316\48223\NUL\ESC\141660\1089351T\27451\&0bA\7868\v\v$&qMQD\994988\12182}\SOZM\ETX\179973.\ENQ\21913\58375\47428\191199f=j{\47820\1111986\1073477\100913\61587\1073940@\ESC!u\1077743R\7637EJ\1016579\1016763\DLE\1058455\FS_@\1076367V\1005325j1Z\NUL\1004454>t6\1079007\ENQ\1084309$\SO\DC3\98064\137557\47918M\ACK\ETB\172727r\b\1100397)\SOw\ETX3\1010263\DC4\1066921w5>\1035509\96260Ga\USz\1047694n\SUB>\t'\92445\r\148219 \1025075;(4!\1073109,\",\"x\EOTyf \f\aRW'z\133849\1048674\24036\ETXYx%\1080586\42394\1045626n\13335[/'\"2-2jR{=\1012515E;\1026542\SO0+\142703H\987291\24296@\1106752%\SUBNnZVt-k1\DC2\155707bTV\DC1k\1003798a\1071366\DEL(%*h#\1030597\SUBL\STXa"
    }

testObject_PasswordChange_provider_2 :: PasswordChange
testObject_PasswordChange_provider_2 =
  PasswordChange
    { oldPassword =
        plainTextPassword6Unsafe
          "J6\1063462\\\ETB\1078893\993390\ru.# ?_\DC4=\1064091E\a\1053958-\150000L\1061533\&3\1048772`'\DC2I\SI\31152,0K\NUL\\G}];\187087\RS\176174d\136667\1076870\t\1047442\48335.\152068\15337{\70067a\EM{9W\1063171\SO}'U\SYNB0a\SOHI\EM:^~\DC1\146030]\ETX\1068275E\ENQ\EOT\SUB\GS\38515-,d\1087008\146851:\1009309\DLE3\nn*4U8\f\f/\164529_Jq<\23032j\163500*e0\152734\DC3\58971v{'\57450^3;\EOT&yY\NUL~\194865\94514ct\33770o}\1015771\1008056?Y/<\SOH\1076816iJ\62386V$\\\CANd\CAN?\DC3n}\1001195\t\1017145\139912\1110640\r\EM&C\FS(A!Ke\DLEV]iB\136999\137089]\173378~\995379\&9\NAK/sY\FS5\165215\142850\&3\1074963\ETBX\DC2\92297\nzeKE\\\v3\128136\r\ETX\n\1110227Mr:M:\n-#'L\142407\121103\&7eo\57512\1043763!L$#",
      newPassword =
        plainTextPassword6Unsafe
          "\STX5{IYj.N\1097942\1034521]}l~\ETB+\DC2XU\51470pB\121102\25755\ACKH)V\ENQ{\DEL}\ACK\SOH\991933\SO~YZ\1000116`vCT\CANU\3236<\NUL\ETB\1097339\SO\SOHgfBz\NUL\DEL\27119V+q\n\53764 \1025256\FSG\145697\184862~+]A\97342\70080N4r3ly$\EOT\1088639Mv\1002336\1050997$\CAN\DC4\23032\ETX\a\SOi+L\1016399Q4\99029c\1019418\EM>z?'\CANO\SOH\77963l2\SI-nZ\\\NAK\187610\&7'VHQ\ACKf\182917\US\1083627H.1\US*\SI\35903\SYNw\1090044\EOTR(Z\165917\1084964t\1085428\ETXV\184675\b\RSbU>\986822\NUL\DLEZ)X\137883\22578*n\1035455a\RS\SIvZ\CAN\ACKe?eB\998053\991381~\CAN(\ESC\a\1007645;\121445q\1042993\1070820{\SYNk\GSA\DLE@8#sG\1095900O\78803oKfrR*\SI)'\22262L\35087I\1030025;LR\988091\STX\917885\93968b\1033563\986558\&3SJ</\1044490+1\RS`\FS*\DC3\129685e\SOH\175179js\989100]|%COiv\1034086hbM?\NUL\175920$[\1037028\ESC\145420\146926\135913\997042\1038723%\1098071%\DC1\175831n\174018\24586\nQ\1089074ig9/E=\14974\191014x7\"l\NULI\1040913-\f\73854\1085317_\1090940\1053238{K9\ETXr\1019117\&78\n\GSM7v\1035425[\60561\n<J\USRh.`*\1111996\191447\6625\123628\USx6[\1053498{\SUB\1005622K\986637\v\SO\999871,~\NUL_\DC4\ENQ\ACK\SUBREY\1067572\",\144420!euFjDF\FS]P\100150*t\ESC&,)\a\170658Rj0\59733\1049770\5076>|\61654E\54642(}<G;`t\RS\DC3\n\v\nM_\159834^\RSs\1013124\1035826\138076\NUL2\1043699A@/\49717\SO!_\CANv\US)\SYN:uxY0U?\61912P{\1015719\ETX\2999mx\158058\ESC\EMQ\1050989pZQ\FS\17723C\SI\1031056\SYNf=\150871\49258\163666{#d\127251:\995953\ETX[.\DC4J\98188\&9\160436\RS\ENQr1\rk;\ETX\39688ibE\RSDLma\v23Z\1073635\1009216\1005891X,/j\3559Q0\186394Gk\1052204\7987\NAKQ\DEL8\53628\&70FQO\1085497S\33475\GSvJ9y\SYNI4&\1069436\73915\33225\&8_WPsV\SYN\DC2TV\NULfJ\"\990019WQQN\177751\148776}\ETB\SYN\19643\20719o\DC1\ACK\ENQLF\92661-\1102472!\989365\CANa\1050343D\59778\1110107=/\FS.\11983Nf\ACK\ENQf&\1093232V\nt\994546\n\129130@A$\1070816;X\SUB\985536\DLE\1085787\&0\1058417oz\154599\1055778r\DEL\1029683Urb\136713\SO\77938\RS\34804*\a\51049=\DC3\SUBb\136373ANR\"\38644\SOHu-:c\FS\12107=f>\985223J+\\ED\187753\182558\987551\&7*6\ETX9V5mm79s\b<5\146014\ETXe\1070748\\=1|>J \DLE\DC1#\1036249\174789\a\119052\DC4\ENQ\7214A\1057521\991526\ETB\1096433\159048=B\DLE\b\EOT\99076mR7\GS\\_{||o\191444)\1077352SJA5"
    }

testObject_PasswordChange_provider_3 :: PasswordChange
testObject_PasswordChange_provider_3 =
  PasswordChange
    { oldPassword =
        plainTextPassword6Unsafe
          "\1090639\STX\132492\SI/\183791\DEL|9\\\b_\1111257E\18560\1026473\37179O-9\SYN1L\11112\153612SYM6`XP\185928x\1091969BP\SIV\1094629\1099550\&3Dt\1051594 \185390\127986\STX\993509\1072672\\P\182591\ACK5\v6\SIW;\178969\&1\nE:[\182420\96819a>\1066339\17724rv\12096OvI'-\1062972\166884\ETX\SO\SOu{\999818\164786\"_\984751~_u\1023831L\RS?\1032751L\97379m\1012949\b\189539H\DC3\3277Zd8\CAN\173661j\STX\59973\STXU\b\1058747\EOT\39158a(\ESC\NAK\"\ETBc_?95\1048328\r\SYNpa\NAK\b\SI!\DLE;\GSI\b@\20755D\1058888 \DLE}f\1025872\989393*\\\DLE\DC4l4sG#{\175474O~3!n\1070630\1046460`X>n\r%\vR%\12500\GS\SO\b \NAKJ\FSe6y:\DEL)T!\163863\19105(p\STX\ETXS\1035778g.v7\EOTU\\\ESC{9\1029424\&7\1096509\182402 \11429`3\v'\1011010\6241H\SUB\67713`\1102842\SI\ENQ\36671XSL\5184\74631i6*H[`bk\187634DB|\1082864tF\STX\1095470\40232\24100W$\DEL\SYN|AjF\SYN\1060698\ETX\1002438\151035s)$.U++'\n\DC3C\1092666.k\ESCgAo?,\1098414\SUB(sBt\994422X\51349C!\1079241<\1003009)5\147358[\25065\RS\993654\988949~(8:\1099034\94463\67647M\NAK\STXFs\\\162758u|<j\DC3\EM\134691\ETB|D^x.\24045\v\SOa\1057288Q\1066237E\174467_c\ETXuf\1048145\989129\138930FB4\13453\ETX\tb\ETBN\USR;\191449K\ETXeQ\DC4\ESC\SYN\DC4u\ENQ@i\1022819)\163001R\150756sZ~\995904\141184\151666ip\15907\987134\1097988<\ACK\162144]\160863\SOH\162082\1107414'\ENQ\31938~\1048786!1<g5\22495\1038783\1096981\ETBV\NAKDhp9\DC1O\"fZ\CAN?@P\23609Z\DC2\1017307\SO\32102~HjCw~w\1096156\n\STX\1108905iZ\NUL\CAN/v\14205Ur\1001553\ACK\1111501\\\138666\ENQ\EOTr\n\52674Asv:x\1074173K/S\NULU\1039657\1096265_\1099090k\168869r`\54594{>~\DC22@D\39863?L\SOH\EOT\CAN\78252_\95345+\b\1047730)f\DC3\147188r\SYN+=8\17990+\131480k\n\1004620kv\ENQ%zD\1087067Q\EOT\DEL<\DC4U\EOT\98368$\CANw<+\125229*\171804/\az[q[\DLE\ACK\132467d\bv\DC1\DC1{Q]\155471\n\rokp\CAN\DLE\180903\EOTNn\147253.!\63250\65540z&|\983968W\164923\1015875\47406\r%B\NUL0\62411\58998\989796jn\EOTg1\1030731U|\1069001.Z\147615-\DLEUdT\SOHP\ENQr:\993057@J\172264r+\22908f\189795\1008819\12565\1059459?!rR\184591\1059540d\1010396\153681\1087402\ETBms\157686SQ\SO\1013566\159622\"S8aV\t\ETX\69642\NUL\1018708\GSj>0!f\1048850\172491d<\1090475c-!+\v\157251\USB\CAN0u\f\1109289@n\US=\EOT&;\FS\1094127\147561Sc1\tkL\f\ETB.V.m\1102645NZ\1025114\171053=\9900w\SI=p)\983196\110627\n*\EOT\4264S\142455c`h\1064905\CAN\DC1}U\16412\RS(.\ETXBQ\RS\SI|2\DC2\t\58697\26979J\1059222\t\n:1\1076824\DC4\20071\DEL\\?AkiJ&\ax^0\t\RS\1008082\145465'\vEB*\n\133263C;EZh*\1096287\v\172007\&27nR\1030319'7\1067756\ETBV\1096588\SIC\25035\NUL\ACKcl\1015672a\DC2\1054753_X3\1087036\&3\174910mvT&\v`r>\1008758_.\28801\DELo*\USR@!g\5064\DELo6'\61374~\11251\1055297Rv\96087",
      newPassword =
        plainTextPassword6Unsafe
          "\ACKb\65690.z\DELS\RS\1043455|@ou6\SI)^#Nv\173721\nK (\49735\"+\180317r\168250hgU_\NAK>.~\42075\EM\DC3rNA\1003405\1064814O\1080126f\DEL\170710@Mj\DC1\rd6\157492)<\NULZN\STX\EOT]\164074%Ki\ETX;\1074300\&1lkk:Mk\1032789{\1085268Hq\1095137\991423[\1046704\1069727Y;(\DEL<<\NAKGs *\1064528\SYNGz+\r_f\162493\EME\179877\SOHo\GSA%'+v\145346:lQ\183770\120729\1008624\54333~\46645a\18566h\RS\nEX=*~\b\38738\DELk\47265\26012Y,r=\SOH2\12321\&9\FS\f\61703\146118\1101857\41261_\177617~\150584\1101236rA\1057119JA\\~\t\67201\GSrIk%3\179007%\EOT=%\13237\1079931b\FS\1080016`}\SI\167993`@\NAK\1037573\f\179386{\984491b\DC4\191263\SUB`\tV\ETX$\34881\DC2FH\ETX4E\128495\1074641\155862\f SL\176565{A&\FS@\DC3q~p78<\1029510t\1072174&&\1064641W\62128T\148445gn^K\1032060\DEL\1073914TK-\1032280t\69863*B\NAK\ACK}G3W\119556aj\135982\&0\35872\48740O1\EOT[o>\SYN5w\GS\tEd\ESC.}\27602\&1{'\1023415\1007968a|\am\181403\bu\DELo5$07\tK\1101735*\t\bv@F\ACK\ENQrQx\RS\52315\r\f\18064\60859\1043018\42814\1082068\16599p,*\RS\DLE6\SUBH_\994350\SIi\145754\17091\1001085\NULUq\176242\\\1081511[j\1020996PN1<w'y2$\1086822\ETBN^\137696\DC2|\CAN\1082731S\992027\152721\1026112\ETX@\r&nw\128380h5Gd\1086508\SI\1060959\158267-\1078558\DC1\63884\f\SYN\a\1095440\DC1\v7\1107109-F}\189209\NAK#+\DC3m$\DC3\vrrj>\DC15+!\1067420.\34561+7mLuRk\1036698)N)dlu.^\1109734\EOTzU\1019326#3\1055275V/\SUB6^\DLEq\60060\153909j1\n\ENQ\143934\DLEC\1094908\174654w)\SI\1095019\17787\155204\\y0/@_\1036276\\;\1044245U+\":|\1008444L\\"
    }

testObject_PasswordChange_provider_4 :: PasswordChange
testObject_PasswordChange_provider_4 =
  PasswordChange
    { oldPassword =
        plainTextPassword6Unsafe
          "\1005314~=N\SI\SOH\a alq\ENQ\ESCj\163982U\133814*f\"\72875\SI\1015050\1072188\52409\177675M@0\\\1060741s\b\131914\&4\NAK{\EOT\125006\ESC7\1042522\n\DC3\ACK\41709\CAN\DEL&\RS\984654\DC2\1039379\GS\NAKbHZNbM,\53068\EOT\SOH\1086193Qw>56\NAKF\"Q6\USp0\ACK_\1071681\22914\GS+\1113265\1033881\&1XL\1057692\r\b,l\1090712UrQ3) \DLE\1020313I{\ENQ\168366\v&\STX\182716k\1077895zs\1099425 \120690G(gf\1060305O\38802\n\1054049\1065585j>|Kg{.V\163868\ENQL\131757[\1096643@;=zg\134436\183794\158027biF\132561\&6ZPA\n\135254\t\1032483\NAK0\CAN\SO\SOHaE\1060005\EOT}Ys )\STX5\172564\SOH\1025776\1058126\1057981Tx#\r\b\DC1Lc5#\1035228Y\1093589/B-Sv\159168\161208\n\1031751S\39534\f\r-\167002Gq:;\168477\&4T\96990\917580,ST\FS\1079935&c\ETB@<C\1050816>+\180969\DC1\NULd\167999\143044\CANP\1021550\988126\1020951\1108300z\ACKU\SUB?UV\148371p5\161618D\f\USo\165498#x#_\1054438\991493H\1053912\1101113$m\1108341,$\1028517(\1361\EM\FSr{(\DC2\36604:Hr02Z\CANj\EOT_C\RS\SIt\143715{(-\f\184102\&2q\r\r\155913Z\1042726Ko\t\ENQY\1105826}\a7h\40363\&39\DC1\40241}1P L\nj\GS\123621'\94253Q\1094248%n\144018\"$R'S=W\EOT\nr\v%O_\187746Pz(&v\t8V!\150217O\1087987\1109209G\120191'~q\6433b;\b\33127\&6\6978XNr\ENQ~K\DC1\184383O\STX\43136\186449q,~A\STX\995391f=JwT\f-Z0\DC1\STXJ\135448\SYN)\t\28369\989463oI`'s\aG.ggB\SUB\1089552s\7042Iv\995920f\DC4.NGl\167789\SUB6\ESC\SOfJpG2\ESC\151792J\165772\1060235\RS9\164444@pMICAP\a\STX*_\41597^e(M\EOT\a\GSuYl\1027529\\*\ETB\1000487GSnZO\184505\a\151353D<v'WA\917540sD3\ETX]^\EM\NAKem>o\185571S,\n\ETX[\1024125\12994%\1048335\158640\b$fm\DELJYdZSTOY\1011389\1000717\22006K-~n\101099Us<\63668\42529r\SOH{\1001552}\1035280\143766-\SI\191007\&0\30696\1067137\1100998y\34996\&3\1012120,d\t{\1060327\1023821H\EOTV.\CANu\1087782A\78628r",
      newPassword =
        plainTextPassword6Unsafe
          "=:kk\1018981\&8-\\HYms@'?v\ESC\133198\147317\t\1008759.\v\1033547R\DEL\1060763\DC1Z1\95927\CANSmD\143932\1024564\ENQ\FS\"Z\1030825@n?zS\119833\DLE\988733bz\189538\1082413\SYNSv1(\132603\rQ\EM\f\149020'.9\SI^|v`\a\1039850+\DLElBv \RS\23734\35305\1109565\DC2\bJm\1085701\1095232?_rXd\1019687T\137292\STX\147778VK0\134410H?.H3H|\1089668\&5\1020896\RStKw1k\1046876e$A\1046587\66888\1106484w\22514\aRYT\1048339T{|!\1076458\50629;*\1111661\169350\1009115\1100512\&6B^\36743Hbz\DLEK.w\STX]m\1105522\3984`3@\1035182/\113800Y#\1048181{X\74883?^aYz)\STX:$\148676\nd:\"Q\FS1\1083955\DC4}s*}%^CWY\SOH5w<\NULla\65202\1015084\STXa1\1073755L]\GS\ETBV8\SUB\133836\1011042rS\152914\1109488}\SYNl}\1018153p?Yi\1111523\&7v}reh\993180w\DC3\DC1k\US`)\f\181331bSd\184792A6hx\1018142#n<~V-\987055h\143466LT\53862q\f7\SYN\\92\137339\ENQ\r\CANU\1071144%lYedK\vGHs?rN\177663\&9\99852\52785FV\22264\127076\154269`.\DELXv,\1085673\&4\r*\191239\135780\152535\&6/\EOT;V\1045100.Z\DC3\1073857\SYN%\ETBTVv\ACK\5241\&40c\STX\\:_T\49351\&0D=\138839\ESCg\SO2\16967\RS0\1009235b\n\SIe\NUL]=Ir\\[,;\ENQ\1109755E]\b3\1057051\100809c\NULya\1062732\NAK/t\US\r\DELS \1052333QQYH\53161\15320\EOT6\1045701pY-\EOT4\7658L\1039028\155730kB\172820\EM$,8\120808[\1087257DGgn@\ACK\16782+@\169718[\teJf$G/B\8949\\&k)bT<\1074663iE2h`\189858&p2\DC3r4g*\1040011M\SUB\1034202.\14977\25151\994175\1080867\r\156624\&6V\163857?Z\7344(\SOHF(z\1085772\EM@r.\1041715\EMBi_\1023342!I\DLEj\1069951\NULHy?\SYN\1024843R\1061663J4kQ\DC4\SYN`1\SOHNnp\167659\ETB\36188\ACK6p[.q\DLEZBF\\\b\NUL|\f,\989077\161119\150164z1\187508M\DC4!\1041102\DC1\1034211c~\1085907\DC3\1085359V\1024822\SUBJ/#'U4t\119160\1101637\ETXW]\EM\1003131V\FS},\1018388z\28107nOj<%7\SIk^\ETXiZ^*Fz\STX\\g.\np\DLE4o\NAK\DEL\DC1,\1048642\&4L\EOT\DC3]\83046[\DC3y\1111455\RS\ETB0L\US;\\\161083\1038455\165809VOG\97134 R/\1068148\136637J\1008468\SOi\31819Qm9\DC3P\178289\1062875m;\33449\151544\1112165g%\119045\ETX\SOH\9817U\ETB9\63207M\68250\EOT\12530\&3:1\8937s\ETB\t\1073799\160211\1013614\99221Ycje\US\1021337\bC:<m\183398 Bc\1084891H\16183\92689y\140073oL\162766\186442\DC4ey\GS\1017468o\NAKR4\SOHd\92230\60899d\1008744r\999316\1010513+5}[\997667\1108924\n\1068636L\SUBc\997074\1074111\1099379Dw\GS\DC2)C\US\NAK\FS{.\\\176432\1068504Ep;p\26525,\1001464\1084821\SYN\STX[m\30484\SYN\DLE\185384\1001717s\37700J\1106203\&5cZ\1049315}\"\"OuL\156548|\165508\70033\16940HmDlK\CAN\ETXeS\178704D\60978v2/vH\1028583=n'\n\1108726\NUL\1078014)WXd\36803\NAKL\64670\1094610#\1008192-\1050555\121012M5\1019902+`\EM\1062143k\24259\ETB]2\1042275\154630}\1002607\"\992512)\40663'\DC1\USbZM\100762\nJP\1111907e0q\9228\FS)tB\ETX]xq\DC4 \DLEj3Bm\1066585/9\46481\128041f\1083028[6\1027471.\1063870\DC41r5*&\172051\&21|-\177145\97995mx|5k%\1044061}\30688)Zx<\1057460\DEL\tz%*LP\1110212|C"
    }

testObject_PasswordChange_provider_5 :: PasswordChange
testObject_PasswordChange_provider_5 =
  PasswordChange
    { oldPassword =
        plainTextPassword6Unsafe
          "H\83433fK\125079\SOH\nKPF+Y]1y_\29517\136895\154920\SO\989098*\139921=V\94302j nmB\SI\SOXX E\SOH;.B\ACKRr\ng\RSU\EMQ\RS;2\140776)\128385 \ENQ\1076041\97976e\1063758@3u\38730|0y\DLEE\29153\1049924\1030541\&4s\159445q0K\180655\a\DLE\fYx\159605\DC2\ACK\174111\13342\36514\13442;\987842\&6\1044668A\SYN\r\180853\v!z\1016791\167199~C\ENQ2\ACKWc3UoG\23998\DC3K\179499\156402\&4ir\1065763\1012676&\46648\34920/E#]+\1103455oZ\1107126\SIUL\21568\\S\22776y\1045130_lUBMG#\NAK\SOod\1100619&`\995704b|iV\r\1095086\&9>S\EM\DC3\EM\1080393\&0;Y\1006472unM#\ENQs3(\1012482\ETB\SUB$\1108830\SUB\SO\ESC\1011341\&9xk#\"\1107050o\152443`leDo?\EOT\166427'\178290<BE\110675\&05C7j\177813:X\177134J\1088274\29067\26403\&3C\157041\f\GSJRW\SYN\f\FS\1090406/<?\DC1\157398\1037522\DC2\\{\v6i\SO\164929-Y,[u\1025370:V\1005363\23960\tlj4b\147106\ETBv\120325-%Zd9\NUL'kp*\a2\148359@\ENQ>\1083767KWa\SI\983521\&5N\1062943\ETX*\1069873E\95635\49809B0~\rG\146763Pkj\134528C\994565\1112409\FS\77994\DLE\DLE\1083005G\1079213q\1078280\SO)\SO`\1044446\r,\GS;\141525\13757\USO5\184789\1024674\1052970a\SUB5G\DEL\vN)\1061733\SIi\EOT\1053143`\181217\RS]VL\b\1013194\&0<Qi\27081P-\145272\1060563\"\19814\1012566\&4XIh\FS`\\tW)\DC4ER\1076810#e2}p\166538\67736\ETB\996835\n\152879\1113494(\NAKS:lO0C\14572\&7\"bKJ\156869\DC1\127150\1101203e\1097670k\SYN\148624v 4\21689Z\57743\CAN\150347M^`\f\70110\ETX\EM[v\1045776\DC3\STXK\ENQ(\1056920\ACK\1065588\18732\68341:_\168561|\b\1099101\49175Jr\1047983\1030090sI~el\15222KO~L/\FST\49522\DEL1\SYN\128643\138522@ThB'J}N!\DC2\EM\GS_\2538J.\STXE\USLA;9\50741;\1083889x)\155642\74794d\986852\1010281\985457\ETB\168693\n\54273\1088932\143257\ENQ\GSx\1073397%:\EM\46822\1074964o`w\f\SIi\ESCJe\1037086\1052828\1110115<<\1068710 \DC3\22657(FY\1001707\n\tL\11833\CAN\DC3\1031938<\173495\n\1083745\173781\DC1\12807\&0\ACKNF_v\157475\1005148\1002828\DC2\ESC0\SI\GS\US+\1001895\&3\1005997y0\1089511\1098367\1099465\DC3\SOH\1109863\\A\ESC=**\1079630%_8\n\996709\DC3\160088\ETX(S\170590\1038528Dc\62317\SYN\SUBk\1048845l\24724v\1084638\SUB\SYN\r\"T\\\178479\58025m\EOT\62655\144330\134069\ru\182437Q8\162056\61996\EOT\1056235\1012713\ESCA\DC2\\'V2VHY\n\FS\STX\144464\4211\RS(p\1013225\188094'\995058I\v\30726FO\1030848FY-@l#\"\SUBb\14010\995647\n\DC4\"\1068725MO\ACKYfFW\133786!$?\DC3\61887",
      newPassword =
        plainTextPassword6Unsafe
          "\36830\1064859\1088981ZkYFN\1022213\NAKs\97032\\WB/p\46094lWY`U\19170\148834\1028015\STXy\nQ\1066464\1073966U\GS\51260]|\1009290_F\n\ESC\EM3Zox{-\44532\165651L\164238\67604\&4\ESC>\a\EOT\1039988W\51437c\SO\1065070*av\98257'\170757 ;c\996012.\131792~\DEL\4838\182631\1055951a\135094I\ACK\1052557\f{\1072125\&1\27594Jd\1063195|\8005\SOH\1024659\EM\ESC8\120279\986941,HPp\3786\ETX=\135249\SOHD.\DC4\GSwi\1040647\CAN\SOH;\1021350!|^\DC1\ETX\ACK\1063454~y<8\1011154=|\134143q\f\FSE\149852\bnT\25647I\NAK\STXYB\1111567\1092081Gp)\1057864\STXj\EOTBi\1015288\72231\1105732\vzO\EOT)\1021734IRz\1036141Ty[\SOtj\994518q\ESC\DC1\ENQA\78643`\1033140\SUB\1086534\119199pUM\74032U5\SOE>i\DC4\1026198H\r\f\a\ETX\SYN\EM#\STX0m[\DC4Y\ETX\nY\1041053\1032715\&2xROJP_\1069998\r[\139994o\1038593\1022439-\CAN\FS\1053876\162419\GSI\1114021\1099881\DC2\ENQ=\DC1]\14160\178652ee\NUL3\165586CA$\1096608>,Sc\"\DC24$\98460\US\1104391|\148368vh\EM\b\1110174\SOH\51262EC[7Kh\n\26878\1037105qWk\142931\NULQ7i~gM\RSp\r^\nJy-[\41948\v\1088158!\164120\&4\DC4\41370\1083111\1100437\1027623gln%\r7q2\8168\DC2!\EM\NAK\175295Tl6\1071902\STX\38040+<m~T2#\DC4\181498\&0OU'2T\41952\177947\ETX \19803<WBg\SUBi\1009816\128595\171116l*\DLE'!\r\1059259.\49689L)H\73059\ENQ\38256\NUL\rm\NAKJ\ACKIw\ACK\SI\ENQ\ETX\188736[c\r\av0\1026769}\STX#B\26601\191200\177934\31334'@;\1023815\DC3~\CAN\EOT@\27718!.;t\144393<\43143a\SOV-<0W-gyA\DC2\1063567a`M\NAK\NAK84mo\DC2\RS\1069394x\1015890\1076765VS3D4b\ACK\USw\STXMO\EOTt\187334g43\30701%\44995#\nuo6\DC3^p\SOHOE\1003703gS^a\74246\ACK\150510\986622\50947&hn\20687@b\n\nK\n\SOb[\ESC}\1081561\917866\78879S5DBxr1\1009175\SYN\1092319M\168509Uf\DC2R\t\1085199MpA4^\ESCB/\SOmu\1079382]\31695\39325\39046H\1084547\fT\EOT\999811.\1040991\SOAFDU\n1\ENQ|?BW_\133311\RS\DLE1\CAN\123142\58011b\1071626q\145791\37164z\995618\ESCZ\na\171885\&5\1058434|\"\DC2\70343\SUB$\1096272\"q\1082936)f%+m\1049797*=\DC3Z\45709|\a\1023016d\65308\62970\137057\&0\35306\149208\&4Ms\141942\172559@!6ddfxWEXN\DC2sP{\SI\993838:\1029931\SI\154895\1089674\\\EMr\40903,iO\r5,\34725\ENQ;\US;7o/\1063445[!\DC1=\ETX`\120484\1027721\10785~\1105868\5223Ma|\SUB\1042674Q\rYv\61795k\\\99408\144912\1016586\&8x.W]\DC3S\174760\DC20\1096552\1039254\DC2)\28650\GSk\1090670\DC3\n\1027587f\182388+\RS\159200\1013551\SOH.U\120349\74072\SI\DC4\SO\137440\177265\SI5e\1061450`M4Z\48621\&1\\&rv1|a\149894-8{\1094467\1103010\1058888\154401\tB4E\1058002\173764s?\v(\1074642}R0l\DC2\1007089\1100386<N\163207\1049432\SIux\1071649\2603v\1095731$xe\17307\&6S\4120\992857\158095a\1047360\32100\1064320eqz\DC2{ry(\SOH\8564\DEL9;]\13329\1096834 \42472\1029900\SUB\1059608%\1107416\DC4\1002623z\1036299\f\SOH\SOHy\186651\&9z\134017\1078471\1052167t\NUL\t\150911u\1013921\ACK!\46450%\DC2u\1096172K\SOH4M\DEL\SYN\DEL\t\DLEs\\\1092189\&9\127954\EM."
    }

testObject_PasswordChange_provider_6 :: PasswordChange
testObject_PasswordChange_provider_6 =
  PasswordChange
    { oldPassword =
        plainTextPassword6Unsafe
          "\29292|\184454\DC3o\170327`y-\20597\&7}1z\1034300\NUL\150080O\187889W\998675\1022879\41883\a\42180\SOH\SYN\74426J~\CAN\ETXf:\SOH-l?6\DC37\1027608\162174Ix\1105172W%}&pm\190571xb+\v~\16309\180822\1087691\&2h\ACKL\1069753\1112764I\DC1k\62903\NAKH\180720f!\tur\ESC\1010400,fTv%\65667\183067\993572,y\DC2\6002!$X\58847\984394\SIo\ETB\10301\CAN\ESCWp\NAK\DC2l\b\DELZ>mo`VuL!\n7<*\\\157558>\68039\64688\RS\CAN\37133\ENQ#\DC1zi(3OU\ESC\NAK\ESC%\137946\1049584[8.G\1111459-E\1110194\1084255\1058892\v\1064396\1062440\&9M\99681v\SYNl=\US\15311\1047155&\1053601\ESC\SOH\1047114\1071949\172567$H\n1Y\51322\CANLg\47625\ETX(;\GS\61177lZP|E\ACK-8\GS~\ENQ\v\189891\1107362zv\bQ\USbkv\94908*S\DLEs\1075777B`]\1046292\SO\52998I:\65296D\167913\r\37306\182476P-wN\173628\RS\bD4WD?\63663\SO\1113823\1023204\149429\fI6,6h\b\1004711nP9!G\27578-\DLE.\SYNF[\160877%Q\1097530^\STXH\157909}\v\US:hx{\1038469+\1090842|\1014387M\DEL\\;G\28870\1101783\48530\EM\SO\162503zq\r%\SYNCUS!+%{\127862'w\996607q\1104160^!XSCAa[N'Vm\DC1\DC4~\189916P+w\164548\5708#LI-k\118975V!\121316\1113106md:\SUB\t\FS4\1004433z\1078080Zg:^\NUL\995376Qs\184644o\1095386\SOH\158723\EOT\1021483lPb\nBT@}\2545'&e\NUL\1065941,X0\135225c\tu\CAN|`4\1020041t*wK\DC3\f\25439RD\b\SYNGZ\1006639g0F^n\f\1105456R>f\1100409\1100823\\;`\SUBoh9\ACK\DC3\1071927K\v\11722\"\1060736\DEL\99248\GS\1040422\8236h\194957\23896+T{\52879\1008639\ETB\57964\987068\&6\DC4\998395\&99\SO\1098197\1097876\STXR\1090815\EMQb\165117a|c\150904~\FS\NUL\132829\DC3\15008V\DLE7K\167075\DC16=E\ETX\fTv\1034496<;\rLEGuZY\118839iNm\SYNJ\rI\190474\&2\1095050lI\ENQ\GS\1034351\63865\STXaPo\FS=8DtkQe\SO\147814\&0vQm\153309\1071911x\128401\164053\1008099$o-(t\DC2z\"AQ\1020511e;\SI\70124C\ETBH\29202#\1074721nCh'#\1094035'\1064442\35450Nx5=\37407\177998\94806\49674\\Y\35646Bec\1095406\1051005\DC1r|*\EM\38243}.A~\1079182\1042143\ETB\SI{Pt\1011810\ESCS8\160032\ESC\22627\SI\153862h\998542dZLu A\7299\149281+jc\1513<^\157390\DC4:\1083899\f\1031499]\bl\1036256\128520\38650d\1056973\DC2v\1044284\987395r\ESC#R\1022711Xr\27081\20760R|f\1092090?\1013931+\ACK\1107788M\CAN\1020010;\USJ\DC4\1012811\1028415>\1053853\STXj_)cWt B\18936f\1012599p-\vJ8\51800m7\167922R\NUL\171175\1057562\STXk\1020080(9\DC3%x\34431\DC2}(dMC1<k|\aB>\ESC[",
      newPassword =
        plainTextPassword6Unsafe
          "\131784\138514\157899#Jk\r\1106537K\DC4RP~\ESC\150747\1093719\NUL_\1070253F\EOT*a\RS3we+u\163806\SYN[\183120BlK\n\FSF\DC3\SI\1031201\51899\1091000\1006948y\b;\83374$=\EOT$\100771\tJvs\155623\&2H\1097133<3\49632\18894\&7&L'W\169743\&9\1100463\1016241\DC3\EM1\998556V\DC3Spzv\rZ\98169M\rg\60865d\r}\1017655\6434"
    }

testObject_PasswordChange_provider_7 :: PasswordChange
testObject_PasswordChange_provider_7 =
  PasswordChange
    { oldPassword =
        plainTextPassword6Unsafe
          "o\194642\1097637\NAK\1096957q;\40241\78060@G7os\ACK&\NUL\rb\1064652\r!\v\EMh\SIf\1009912\FS\1111085\994910/m\1095852zr\21631\&70p\ESCxcNP;>ah\1038533<o\US\78087j%c%eAt\149265}2\SOHy\USJ\169017\&0>\1088598?s\DC2\161084+l=\SYNtKk\1112851\NAK<%Wy\DC2\rdO\"wl\r\1073877&P[ x\EOT4\1070910\94261k\110789\EOTO\2408CJ\FSh\CAN,j\FS\1051419\&8\145785\EMDM=?\1044107rN'uaGQD\DC3c\DC1\SYN\50022\SYN\SI\191191\23297_\f\f}(lT\1001335-<e\SIk\DC1\131353\SO\DC1\1020210\f;}\183274d~\144414\29001e\\)70\NULA$]GgG\1039500\n\1031326 \EM\SOHUv\54125u\GS\11195Be\GS8i\1096638\ESC\DEL\1084338`\ACK\99991\77846\1044487\t\155958\998169.%\tc\ACKO\45335B\144272hKh\SUBZ\CANpL\ESCm\f&\ENQ\68459/\aE\120162\SUB@\RS*H\ETXYi\30256x]\1032821F\1008321*\NAK\1097191uT\SOH?U(ob\1078450\1077777\1101607\1021844\ENQ\1095752r`\988582#\1025993$\ACKER\FSFY\1074606\&52ImCLS\22424/P>\1102617\1055091an\ETX\",S#\182773\ETXhx\ETX\"S\29957\133313\44208$Gpk\135573\74317\28585]Dx\SOVr]\1106090\15330\EMt][\190740e#B ;#\RSwWZ`'-K\1031198\1079899\149986'G:I<\ESCgN79G5\1076698\134552\1001620\&4k\178721Z\61166\ENQ\DC2A(@ScQ\1036811\RSS.\1083926?&5\59387\&4N/S\162222\1084995\&74w\171315\176694\31631\132086\f0l\vn\1041562\&22.\995582\162439\178300\DLE\CAN\GS?!\SI\19976usZ8sJD\1016223A]ExUW\18012tdEm\160005{7\b{\ETB<\DEL.\187515\26357\1022998!<\\\ESCGPS%b\1101700\13570\EOT_X6\\a~u.E,\145264\151278B,\1110132\178446!\146205}j\DELw\1094539wAOIN\74851suE\1011582LH\50805\1075175.8g,4\b\994127\158463A\STXO\CANYgM_<\134150`2t\5592/\184130\ESC\1025744\a\EOT@\t\n6\SYN\1051619\153044\US\24861\NAKqOwDI;\158935\STX\142163T\153718\EOT#EZVVq\nj*w\1099335*\SI@[5\1010626\n\DC4\\1\DC4\DEL[\CAN}\NULBUTcW\DLE;-D-\GS[\EOT8o/\26515\b\FSU\DC4}\\\140030~\SOH.%r\24914\33259\ESC=aoY\121055z\135293\180565t:\18518NUy\986819o\v%\1031392\EOT_\1056629\990992Vv\96494\1073204>%E@H\t\171158*\1055587W\131453U#p\ACK:\1001700{?.Dv'\US4VZR\140754\138375\14865\ACK=\1010074\a?\DC3\DC1\1104713F\1094183%\NUL\11085\NUL\119900\50952\1091734\1096788Z\131351\1071405K\STX$H\b\25145\SYN\137614}Uu>\1059256QJ}\1092477c\1005961f?\1098417dP\ESC\1112602eA\f3q\EOT\DC3\1085835\SUBP\DEL$\\\1043723\148046x\EM$J^ I[\ACKgl@k9\14259oq8\60943f%\"J\1057317\73689\1041929t\SO\fi\NUL'tD38k\ESC*z\v\DC4'\38081i2}}K\1000483\NAK ]=\GSzA\SI\STX\GS\65784@5\DEL\32084\RSJ'I\1061395\ENQC\132576k\36936Bde\132392S_]e\22951K\STXh\1080765\&9w\1031828\1079907\"\1075875x]\v\"\1004384\1034557\a\13954X+!S\188785k9\1336\STXL*Z\992108E\988071E\157741\1059002\49383l&M\78548\68781\1059405\&1\1024148\98156\&4JY\vb\1009588\CAN\1012372Xqx\DC4\STX\rW\3001RRPX\GS\RS^m\58278\a\1082402\US\990568QD\1066036\EOTAzaVl\NUL0[[\997199\992592SJ\100209Io K\US\SI?'.\100329Zv\26227\183271\&9?C\\\SUB\1055968\&5x{",
      newPassword =
        plainTextPassword6Unsafe
          "_90\1017274=\175182\\eIq\EM\29319@\US\ESC\USr\GS{\bq\SYNX{k\998765\1113634#>\v\127239\\L4z^\47811+N\1113429\STX?9C!^\1072965\155787\1051243f\n\189595\DLE\a\ENQ\1019894\50928&\rJw\CANZE\178133jc\ETBb%\50684va\11406<\US*\77953\&9?P\f"
    }

testObject_PasswordChange_provider_8 :: PasswordChange
testObject_PasswordChange_provider_8 =
  PasswordChange
    { oldPassword =
        plainTextPassword6Unsafe
          "\180818[@\EOTO\EOTr\t0h\154811\1097619Ls,\RS\177254\1001237\US\53799!\174182i\33534gi\12980Ul\DC2c\"Q!h\1078688\ETB\32168j<\143648\SYN8\120997\&3z\1109784\140076\8229\EML\DC4)L\1086339hE\FSYD v\60832\&3:\b\127281~\t\DC2|\NUL\STX>\1037988\&9\52889\ETB%2TZ\1057438\1019124\34595Ba\36978\&5\n\f\66575M\DEL'.HktRZK\US\b\1045482\SUBQfa:NA.(\az\DEL\131940Jviu\SYNt\141599$5b];W\SUBPM\1063367\1063525\135883,\17207W2L~_\DC2\6631@DJ;|\DELa\ESC.h\1052121\1098974\1033911p\1087765\EM^\t1X<15#N\1026411\1084279\&8G!R\147770\&2t;\ETB\ESC\1064735d~\v\NUL\1102025\DC4B1T\"\1109782}x;!no\r\1106009\RSt\18334uj\EM#r.W'}@b)\STX\162952i\SYN\167204Y\NAK g.xl\63576L\1084858\&5\186390\182838\990328\th\DC14\26177Np\ENQRLe\1082057\&5k\SOH\997985\1062349D;KY\189276A|\ETX&t:7$\ESC\NAKX\176629&\ETB,S\SI\18829\29542K;\CAN\184587,RWVP\RS6C\24675\a\187635\992522\154218\41884\b\STX\ENQX\9568$\SYNK",
      newPassword =
        plainTextPassword6Unsafe
          "x\1083148\ETX+:\1080028wSH\SOH\62978\1102729N6\182762a.$\992539\120747GK\158987%\136043\DC2S\1037479Ym\1008949\NUL_Fe\GS\n4\990156\39344\1010528\&9\t\ESCEZ\"\aE\SIO]\1045645\1079319mZv\14455\&4Ie\166474iF$\n5\EM\ACK\1075904\1113583F\SOHG|\STX4g\1002980XHN\989865?\1099099\173477\&3\50673\83417\11655\1099379B\ETB1\r\1013634Tn[\EOT$&}'}\141322\&3_m\1077163W\3968Pt\ESC\1071158\&6f\1068159=\183495:\1036808\DLE/p\1004364:\r\1085290\ETB9`\1080065\984968h\1027137kOs7\NUL(t\10489\1068176,G@C\63384\1024509\186856\190455B\1113082\SUB\CANQjW\1008166~U(\1009483\&5\1109177\20348!\1077035E\1005&Mj.(\DC3y\152919\172701\ETX8p)'1ep\n~&{\62654\167895\DC2*7\990132\DEL\185308<\DEL\SI\1098650)j-abs\CAN\GSL\25312\DC3Pl\51906\&2`$bh\SYN_\1086252+>h\59671#\1056101RE\"{n.wh\n\64038\154124c\1069890\GS\170451\1076325N#I\1062645\nX\n3S0+\tr\CAN\39868\t9\1031811`/\1019167\1036273(N\57792\ACKD5\1096310a5\DC2Tf=}\ETB\1108347_yHue0\n\1092905\1099428H\b'\1091583T+:\183409${\1057811\GSE0\RS\1043155ly\SIobfRk\ENQ\RS\145619h`\\\95626\NUL>rV1\ETBfXk=cyaI\EOT\ETX!_\CAN\26741xR\DC4\1038343<%\1073241,`TXaz@^\\^s\180706Y\NUL\1081447\156985\DC2c\EOT&\n\DC3S\44890\NULE@\13815\&0`B\t\1039059N\CAN\32617\167086\999897\34753B\149257\USp[\SYN\186181\ETX\1040852<o)\1001765`\GS:u\120937M5DO\54145MoB'&\179160\&6m\NULH&&z\120366\DC3\GS[f]\SO\EOT \152680i\f\1047923\100550\ENQH\987261Z\67825\1065261t\SI\28877\as$a#,oguS\EOTo\ETX\DLE \1029905\SIA\191154\\\DC3Ky\SOHBWObo,\1091353\989136xHm%C\a\1007525\1008551\b-\DC2\RS\SIVI\DEL$r)\983271\1062390?\vY~d.\1047359@6\1018445\NUL\131908b\FS\ETX\1007058`\1096229T[kU\GS\1008824~\153276\1007783\ETX\1033769\148987bs\f\1089766\FS\1039765Q\FSg\140662]Nu_\SOH\NAK\v\146471m/PS\132395<n\17290K\1043404\120485+\32923"
    }

testObject_PasswordChange_provider_9 :: PasswordChange
testObject_PasswordChange_provider_9 =
  PasswordChange
    { oldPassword =
        plainTextPassword6Unsafe
          "\CANY\1080225\\\GS\1086497w\142606x6\38581\1070365YB\175683\CANd\DC1H6\185340\&3V\vJ:\1084277\1036221\1070955\&2i\aRIml\33629Y\SO\ACK\155512\60466\SI9\1040955\SOH\EM\1082555,LK\1095400\fa\999797'\998184\991380g8\EOTk=\DEL;K7\NAK\15872\14096I9N\SI+\DC20w\v\145929\38676\1047330\SO)vO. ^'N\ESC\11599\DC1\49892i9q\f]2\b\SYN\t\161856{h\155246<\"\987852<\1105919{\ENQx+\1082549\DC2Q}L$]\1081973F#\SO=\991100Y\991500\1025832#\1068854S\136065+\1011422+5L\1040627\1079177\1022773\5132R\131221AgU\9757+KA\161948\30665Zj0\1072511\93981\SUBJ\156482\&6\DC4\DC3R\SUBY\1091489gC\"\\Jz\917575\&1y=\1044203L\EM\EOT2\1053951\&2Cj\1010342u\1009141:-b\157748 J<p|\RS~\1029024\1010535\&6\NUL^\t\ACK\1083183\&2I8`\FSY\1058325\159397lh~\17761f\DC1 \STX\985040\47944\SUBO\120261\&7\143794)</\1109806\ACK@wO\ETXh\1038886u\1041219\tZ$u{qg;a\996139>=;\ENQ+$\a#\1020966\ACKc<\1106724\NAK\ACK\CAN#\41741\66650\DC2^\f\1089620!\ENQ\ACKC\SUB+\NAK\1070506f}\SOH>\bz\184367-{\37662z\128698\191437G\ENQ\n\1036769O\1112827\ENQPs}T'q\1049540\1059171+\ESCW9U\ETB1m\ETX\1044364\1110248\1011325\1077049\\\1070234}z^f\v8p\58049u\DC1Dn@7\SO\178338y'\t\CAN\DELX\138703\44901\111212Mz\1060998\&5\\\"\128701>\EOTNZdWO*\177619\DC3NV\1105635\44906vyM\45692\145400z\CAN\63310J\DC4\RS\ESC-FY]`k\DLE\DLE\GS\US4l\DC3(Ot\SOH1\156591\DC1Daok\131703\1053478u\1047598\RS=ES?\1105503v\119021\1077338\1108555\1105842!\EOTICQ\64082\167240\1027279\ETBu?%\1093608v/\47051e\DEL!M\bLA\SOHN\STXWi\1013467\176220*\aU+\SOAiO-(\n\7942m_\1015104khe^:\rQ\bZS?\1043829k\n8eh\984956\ETBU\146314k#]\ESC\32013\58442,\ETX\DC3.3\SI}\30711=8\NAK\1023884o`TI(\992144-\ENQUR?\152908\DLE\1110035\1106113?VYfS\EM\SUB\1095315\33553\1096655\ETXC\RS8j0\tKC\190493[_&\46172\1060818\SOl}:\r\SI8(x\135429?8\98588\&7)R\985918Q\ESC\ACK(z\SOH.\1107353\&2Y\US\SOH\1035764|\DEL|3&\DC3\94271Q'D{\NUL??\ETX7HDW\184522]`f\bPO\ENQx?\33111A\DC2|hP@;We\35075;\1057215R\ACK8\"$!A3.[\ag\997090\1017693.\STXI\1107916\1089611\19348U\983048Y\1008717)G\RSY\1107954\DC3+u/\DC2\DLE$\STXN\DLE\185464(>[\SIH\12867'KOC\DC4P\38328.\65734M\ns\ETXl\NAKj\DC4M\1046104=v\US\FS\1033829=p\157189s\SYN\DC4T\113713e\SIXhO\v0\SYN\159832\SOH>!\161626\n\RS\999549\135814\49229\1051757.\EOT'(,f8NT+J\1006984O\1062064\RS\187616\309D\152878<N8J4h\1060951\1090860n\1056125\SO\65833\SOHn\DC1y?9\":\179924An\23186|\99031d#=\EM\1086868d\1060693\ACK\1019507!b\1016071\DC2rR\1066265\&4\SYN,\4637tjjVd\16799\191287\143241\60079\EOT;~:jI\82998XYnH\1106861\160048\1077639\US1\ETX\1095043+I\986512\178932;\55080h\20631[NqS\rTW\STX\DC2\DC2RKq#\1045746*\989426w\64561VK\SO\98218H\150664n\EOT\a\STXrLOi\RS\997201\151391\154349\156030\NUL\NULXkV\135151-t[\1103857K5A\990611\175373v{>\b\EMg\v^\22870\SYN\1026918\62565\ACKf",
      newPassword =
        plainTextPassword6Unsafe
          "\47540\188511\&0\STX\SOHF!v\ENQ\11373 l[\SYN\137894\&4R\15581\&7\1083947rK\15414+\n\135750\1065844\SUB\afb'|\RS\"\995385\1090151\DC4\132765/\SOH\153829P\33605B=\72999\a1\1017925F\1051495k\ETXmF\1017174#\177930\148698b\168141ZG$\1112470dbB\SOH\983969\72724\EOT!\996099\&7\SI\1066289{\ETB\1024612\DC1\NAKSr$o\63124\&4<\163973q\1060394\NULXX\DC1;#%fM[dR\EM\1044817N\62150\139272\US\SI\1073067\985245d\RS\GS\DC2EbQ\191179l\1028785r`Tf\DEL\191144\&0\ACKHJ\1016730T6X\DC1cypE\ACKy \DC3\DC2\25565\SI7Wv\SI\1046192Z\vY\"\v\156204\DEL\1106419\995387/\DLE+D?\f;B\163188(\FSyI\1060531Zi\1051115~\993288XN\13032M\DLEPzB\US6\38727gj&L_\1061368\EMj9\1018863V8*Hf`?25\154173Y\SO!dS\1033424O'\1099719`\GS_T\1012344\48568\NAK\1052118\b 'ss\179793Ug\62366\ENQ\rQ:NVc\46684\ETX\147041$\33117K\97385]rNq\1088791\14261\&5g\1108158>i\1060212t@=Io/nm\ENQE{\1051318\v\181086Yk:\SYN9o\NUL\v\16507 [K%J\97955\fM-\1066437rvqm$^b9mkM\1039402\&2;\ETX2\1043146\SUBU\18461]\SOHD\ESCF\DC3<\CANu:\EM\174389\n\DLE\24984\142121yXK\1034045\52191\FSA\62973\&4(K,\168483\SO%gE/B1D\1107948\DC2\161658C\SYN\EOT\DLE\CAN9O5De\29644seu*9\DELk~B\ESC\DLE-\rT?t@\1000006\151230;6\ETB$\1003656\FS\1041307\637\1085577\1005683u\194601{>6\DC1E\48817kO\1071212\DEL60\183739\&9wk\177129\DC3\156315VX\1016207C\141727\"\155769N\153799\CANT\SI\STX\1049621\985530Rl1Qr\21745eC\GS\SYN2z\RSi\161367D6s1y\1095652F&\1040517lTt\ENQ$p\GSRi\1048949-\58685\SIu\21111v\19578P\1077429l:IZ\181939\17566V9e.\DELp\v_6)|q\1034902{\ENQ\29955MXK\1056306ax\1003137_\1006056#0\US\r\CAN\"\DC4`O\1049859\CAN<E\SYN\1011410\994806\45148\"\1035621\194591[\148023K\1012265\1076915-g\ETB\ENQ\998293\SI\n,_eq\r\\;Q\GS}ey\EM!r+\74147:Z\1058469\142592-\ESCE\SOH\DELZ\149036!>~w|f\EM\126607Oi\1023015\SO\FS?h/('\DC1^\39065i\185517J`a3\ENQ\v\1060183\11345g\DC3\48063X\29116Ya\"6\r \132135Bb\1062624\DC1&\13220\EM\ENQy8anV7y\134882T\1047562\SUBcn\SUBk\168542\US_a\EM?\1106016\1088608\DC3I.Z\1069178\ETX\SIrX )!p\1067306Y\183358\&07\GS\1086052?\169845#m\EOTuZegqUxW{\100361\34246\33073\36773L\EOTg\154155\998821]\ETB\a\1059432\ENQz-\97879\187856j4\ACK\STXM\STX%4\EOT{\59661s"
    }

testObject_PasswordChange_provider_10 :: PasswordChange
testObject_PasswordChange_provider_10 =
  PasswordChange
    { oldPassword =
        plainTextPassword6Unsafe
          "1\RS\10044\NULv\987768z\1055172|%\1068184n\150620-g\146786\100842a\132317\EOT%?\97207\1068876AA\"Hmj-\EM\29734\&8\39432,\EOTP\58685>`L\STX:\127298\ACKhOh*\54301md\DC3\STX\144021\1098966LJ+\ACK\"\186180+\1079127\1032187\1090115\SYN9\147876`\63187X9(i\48707\163570\&6\1042913dn~\f>\DC2\1059432\1061679\1009814gq>!\1009228\1047046\63767R&|/\996634fC(D\180586\163947p\\0D$G\23465(J\btdn\1057718u\SYN\NAK:[gvX\50684\NULA\DC3T |@A)\f;\10521R-q?fi\142601\34542#\131181\68251\NULF\1056804\RS\1089058?*\1094737iy \1005023\126576EJ3\153530F\SUB\3963\&2\16235\1015286\SUB\1066520X($}aH\118969!M\1077359\SOH3])\\\ESC\1049797h4sn\FS\10735ztNR\STXxt~:Rb\12611\996694\SI\n\1112987\b\154951C\83302+\\K\1035224\STXs\RSa\47166+d\1073064\&1Z9g\RS)\93030&)\1043446,EIg?K\EOTm\1090815\&9\n\175897\US.u\51778\\\DEL\195063^\DC1|\DC2\SO\SO*LJVVT\1033808WO\USWmOS\1066607\"Z.\SO\1113376C-8\f\DC2miZ\ACK\1084935~C\153854sbIc\"\\-x\10336L\162894\NAK\EOT\1011330\DC4\1065068 \DC1I;\50247;\FS\STX9gU]\151272\154324;\131933v\ESC\n9?QY\SUB\176268\137386Y\78635\1037339Y\DC4\1005665@ll\26187\FS-\v\1059041l\1096164\1084819\SIWrw\ACKU:\135072{\GS\SO\1015883*\f@n.\70686f~\1087845\1045524u0y\SUB\1057096fX\SUB\1018748#e~V\"/[\ESC\CAN\152318\&4\27910_6 q\1092940P<8.MdP\CANV\RS\1046864\991518\NUL\ETXy<\CAN!\US,\RSt`\t\CAN~2E\vs6E\28962\1105957J\vo\1034354O?h7\NULQ>\1091553\&6\"V\138663s.<\"\1088335Myg\"\1103252}>O8\\N\FS\EOTu\DC3\SOF/\RS\GSO\27243?t\177484p$<\1089949VrW+\148070\"Ss\CAN``\v\DC3j@\NAKkeV\bE\164215\11921\FS\NAK1\1061345~aQ\f\RS\SO\1083547~\RS\1064714\GS/t:\DC2\tH\1019658\176743'2\77831\ETX\SO\CAND\SUB\19747ux\DC2\1085285\b@b#\US\17662\NULS>\ENQp\DC1\EM2\NUL\145191\"\"Z\133654\&1, Isn\f\160554\EMR-\58719RsaR\FSu\b\1055113>O\1004908\n\59796\136706\DC2F\1085126y\SOZ\93820\ESC\158354\DC2 \46585\n\1106215J!\STXg\ETX\988927\1065461rba\NUL_\42383\STX\STX\ETB#\aAqacXF1b.$\fFvU\173641\ESCAa:\154419\67985",
      newPassword =
        plainTextPassword6Unsafe
          "\1903\59455\FS2\DELpfHg\1002321@hB\1104441\136229ae\"@\178717\DC1[;F?\1059559{<yBC\997030\1068717aFI\44794qw@V]\164271P\SOHX\b\33743\SO~\1051934@Q)\32875u;\GS>\r.~Q8q^^\1032632p~\54629A\SO8epx\v\1091069\36029\&9Q<!|\1014664ACom\174632\&8\26920v\a\1091843\163740.1\46287\NAK+\18631\1109691\22078\ETXjW\43088\NUL{n\94554\&8\986235\f\v\DC3LE^#\1036192`Dt\1076523\1017441\SYNb\DC3\1057761j0\DEL\SI\v\1062870\a\1024974\EM\95949R\NAK|M[L&7?X\1093116>#`B>\\\STX\ESC]\62056a\aH\GS\1017283=\133882\DLE\US|K\1089241SU\"`TOG)E\1107458\EM\ENQ\1100349V\DC3\SUB\131700\35766\&11eL\136082.\1077925\f\30081\139237\ETX\1018509\&33\3857\1020021@\\56/RC\9618VomQo\189775\1090226\54508|b5\1008980\t\38541\148813W\1052824u\172429\19279\1097359\&2\SIHs\1009437'\\\bt)A\DC4|\vh\141292\US9K\1006653\1113093wY\SO\1070366\40254\17618\&4u\997723'\1071258Wtl,\1028539\180872c\SYN\169621p5<\989014\SOd\1098426(P\SYN41.!\1051130(\DC4L{m\SUB\1109045dYlO\ENQ\180749l\27773r\1015113tS\DC1d\1103375\RS\150389\\U\137134)\1068287\EOTRc\DC4N\ETB\SYNrzEm\763#q39\1045616lY\CANHr\156951\26672:\877w\135480\DC2\r:CA\29971\110984\1082925\n\DC3VE,od{J@]\21278P\29049\FS\139994\1100241\1102005!\136294\1017333H\23052\&5\\\DC1\148824%\181207\165938-p\bN{Ky(N\52156B\a\990465u\119232\")\14788Q\1031053.\183810J\160516a\18817\EM`c\DLEh3\150349\SI>\59607\58218\987987L7II@C%\170472b>\NAKgl*\EOTzI4Vc\78060\22721+)\ETX,\DC3:\42649\&5\1054588\SO[UL\SYNCQ\41627(\12611\ACK-;O|\120383\SOH\25185;VBv[\fj\n$jq\"\NULuYx\EOT\1042364\&9:F\94542\1103197omPG6\fX$\DC1\ETX\SO\EOT-\137576Yk\147970M`\DC4K0\v?\1041183t\ESCT\1068218\30904Z\ta\1045178\SOH\EM0tf\4343U\NULz \98491~jq\1078216\ETXV\174194=\47181vn\143157oly\DC2i\n~_R$8;fbOK\NULz-?CM*\STX5!\1105218\181223\98689i~\189811!\DC3\134655\DEL+\1100972\1088541>\US\1083023\988420\59101'75K\FSf\CANY\SOzC^b2w-uD\1106649p"
    }

testObject_PasswordChange_provider_11 :: PasswordChange
testObject_PasswordChange_provider_11 =
  PasswordChange
    { oldPassword =
        plainTextPassword6Unsafe
          "\1020927\1032547/~G!t3\ETBpT(lfd\987373Uv\US\1047331n/\1037165\v\1000590\&4P\SI\1060450gP\1107120\&3\132634\147692\&0o\57446~\1081825\&4.p\155579xg\169376\1084103yGDY\1068206\EMx^\151320\141047u*R\t21=|\\2\7811\ESC\11201W\147769\STX&\USGu\1097263+#&\ACK]m\159187>\94801\186556\&6W\ESC;w\1017208b\\\ENQqz\\|\95815o`\\\184139\&1\ENQ&@\SUBF\DELC]G[G\164490$z\1112723\1032192\ESC\1044057\EM\1048741\NUL>d\1033451\1015039\1073811\n\166720\180329P&s/!qt\162927@\vP\DC1p\n.n_N\1112206\DLEV~\1101479$h\138762Is\1004025`!\22537$\996552\r\RS\1098882@\16250Rd87\16682\69640\1041864Zo_Ps?\58225\ETB\DEL\25967wU\r [t\174359/\GS.\ETB\178764}UyN\DEL{w\NUL\1036907:u\\\US\SYN\179040K\1072719\6945J>%.\147824'\19885\184555Z\DEL?\4231\STXjg\145989G\DC4\SO\37110\ACK\43793\SIv\134991\NUL\174407ei\\]\n\998741f/a y\1002649F\SIlm\995784\1000687\141212\ESC\RS\US$|\1035150\&1\CAN;6\150884\&6rxN\135999RVa\STX(\GS\ENQ*pSX2-\GS\53557\DC1x\b\".\38402\ETBM\"\1082676\178592\DC4g\r\1100889)\DLEk\190056t\1043965^0\1008489\DC36\US\t\52881m\SUB\DEL;OV\1030445p]-p\DLE\152006D\37776\19566>d\DC34@/\994339\141918c\SI+dol\r{\RS\DC1\1017180\1064450\SUB1>\FSy&#\169442>\DEL?x[~^dAc\f\DLEW\SI1\995822\&0S\ETX_\1047048<US\1108471F\1001225\59673*\CANS~/'\NAK7cZz\1063386Cd<\1002252\1043570k\NUL\SYNEi\100882H6\STXN8\a\rM\NAK\US9\45963\fR2@\DLE\985593\\Ql\EMQ*u\DELU5\110634\DC3pY?P`\US\175647B\EM\DC2R\SO9^\24096VY\aR/\1031402\177669\1050814\ESC#1\ENQkFDv\f\DLE;\US\ETB=p~\1078252\\l\bG'2^Y\GS\173970\1037598\40172\1080779\177183Yz\1101543\t\ETB\ETX`7\145528f}\ESC\ETX:&na@MQ8-y\SO\SUB\988195\n\147858%2BH3\1065531\1001140\SUB\988129\bo/(\1019924\DC3ni8,\997288\1039034\v\149008\1110188`~M\"'>#9\175054wfVhc\1042539\1020713L#J7GBX(\4705\1048737\989333/W5\SOH\1112863@gv\STX\162785Z\ACKw^\CANk\986491HyU@I#}Xc?\1028091\28123\DC3\DC2)5+\1059942h\DC1\NAK[>\58609\ENQ#\RS\997513\nG\135550\&3\CAN\FS2:M\49436\ENQ\1074694\1023446\1073068\1089664>pne\178174s\SOd\1091829\138029\&1\24380_\1036947PM)\EMGb\986632$z\46384\ETXv'\re\CAN2\12453NA\n\1033330H:\148549y\ETB4\ETBm\132498\185138\DC3\1010645c\at\184247^\b\ETB\1097131*\SUB\1075368Q}\1107305r%\984574gdAS\EMX\ETB\ENQ\NUL\ETB3\NUL\DC1\99185k\fJ.\1031366\48850A\DC2\185849i5V\1044560\996851:)*\tO\DLE",
      newPassword =
        plainTextPassword6Unsafe
          "P7\8027gJ\1025598\1050728\tb\1046936s\179130\FS*\r\163897~yj\67377qm)Y\EM\1082698k]SS\990645~;\rp\ENQ\SUBm\1109081QAT\SYNe:\1037799\3798\a=nU\DC2n2\97679c\1105464|\SOH\NAK\EOTL\STX\1014848>\n\SON\US\990037\SI\GS`JOJ\991087v\USY\43061\NULp(S\1006785<\1009666\DC2j\ETB\1074651\1111117s\49393\167041J.,OGU\1015263\1026361.\1082540\&71U\1093020\&8/\1053449\1043583T\EOT\GS c=\53746t}RiOL\RSUsY*h\120237_| \1025261\991499\63211\27137s2redy\1033031V<A\ENQ7Y\DC2|'n}\ENQv\SYN\fvO\4950\SOHML\137390\1081106\DELB\39728:\1027179.TP\1051892\SUB^@]\32112$WR\1045783U\47344\135618\ACK\99592\1104745P\153090w\34711\72193u\1037360x\1087422.\tlV#\989238+\NULWZ\69943,i \SOH3\SYN\b2\1019746w\1022460\SYN\1013907'\\\ETXY'\1016226$\ESC\1026140I:~\1065199\135646*Hp.\1077956\STX`\119214\185445n\1039842mn;\v \1052198\119313)?\11905G\1084714R\ryw\186312\ETX\995820\1068177\NUL\134152\DC3*[v\993622\8962wU\1064798A\176371\&5H.\r4TbV@\DC4\96469G\ACK\140743rMi\GSZoR>g\6578\EOT\155956\62493bdQ\EM\1060795-\1079855\1078796\EM\ETB\18365\170958\5129\1084739(Qw!\SOHh\1045601N\52593\STXb\43616d1\1081703{\1034023\FSBE+\r\a\1042611I\988095Rbat=\DEL\57734\v\1087456\139092\1002353oA$\ETX\EOT{o|\DC1Y6\SIleK\984319c\DC2\NAK\9960H\SI\97430\&5\988979\&8'\142119\SOH/\12561\bKo6+Iw\179708\18608\v\SYNN\1061814\SILuF\164362J\1037455\&1\1050949\&0\168187\12201/i\SO\990270\996257\&6g\DC2eR;\ACK\159365\1095404\83044\1057125\SOH\42192_=\1021400"
    }

testObject_PasswordChange_provider_12 :: PasswordChange
testObject_PasswordChange_provider_12 =
  PasswordChange
    { oldPassword =
        plainTextPassword6Unsafe
          "t\176015z\63099\RS\1019165\72134\1094758\1087142Z\NAKB\1067933+\ETXXj`3.Q\1032039\SUBK\1109183r\1017216\141033\EOT\1016663\52892f=\t\b\CAN\SOH\40431\ETB\a1\187032J4n2eUq\165606\STX\1002769\95144\n\DC1\v'P K\ENQC\49957\&6\995828\abB\\\SYN$E\rCp(\ENQ\997577Z\r\5958\1064586\6052\169035(2\DC3\nwz\EM\1057822`[,\a(\168052\ETBn\1024741\170909\&3\166910-\NAKTp26!\EM%\1067691\983629\1105810X\1084137Ww\160494.S\SUB\RSs5\tS/\188321\STX\179825\14815E\143720\5499::Y%\SI\151589iV\139252BU}]*\GSp'\51146\77903\40692\1032384\EM}\14702k\EOT\1048493a\1024981\&8<X`\1062872\10505E\NUL>E\26598\f\1016469\"1uT\US\97604\1086313hC$ND\99182\ENQJ\"S\vCyu\SO\DLE9\137054b\44966\DC3Pe\21040l\44235u\1093696\2097VSM\a\n\1107484\&9\DC4(\a\177489\150593>-\NAK\1030177Mr\1050563\&8\DC3\194810\141213PiK9\EMm\ACKW\SOHvIFX\984936\ac4<\SUBU'\ENQ\SYN\155860x\9048Y>@\1041311\STXp5C\r\163993!z$\1015059\GS\ESC?# UW\1052214\&0&w\ETX\1102267H\190128>-[9z\29338\1008713\SUB@\EOTiA\1113779n1S\136784\tG\DC3\DC4RT*",
      newPassword =
        plainTextPassword6Unsafe
          "\1029941\182208*\50406\144479mqK=\SYN\NULg\3986a^U !\164592\1000979F\1091010J\137728\43445\ENQTB\152909=N[/5\187278\SYNT\SOH\NULp\1045227\&8\155213q\ETB\v\ESCA!w=x\DC1\RS\29768Z\EM\vpx\US\b(\143914mvW6~'\DC2n&\RS\ETB^]\1092638\b|\1066156d\SOHv-\1092522T\b\ETB\158149x\46579 Mo3)\FS_5\182825Mf\156710VFG\STXOEC\142253(\ESC<1bYVMM7h.:n+\ESCXB~juz{<\GS1\23218\1073013v\1085890Ge\SYN9X\STX\1027702<\ENQx\61722>\ACK^\1108099\1049394\140867P\ETXuh\ESC0\15060?R\SO\CANcT\1025381\1026223C\DC2\"8BY*8\121167XO1\v?z\US9RR\139465\NAKdG\160065\DC4/k\1101568\1097562\46923\ENQk\70387HNx\139984#\997549 \apU\24875\161412E~p\DELe\1024027\32616%(\EOT/\165473Oa\1068906:9'b\b\48968\63083bSw\1089284\DC2pQ\DC4\SO\997853G\143790(A+!\SI\SOH9O\1021380\rWZ\ETBHVe\1038354\SO\SYN>\1084362\SOH}Bcj\1040105\SODC8\180947F\t\1078880yrR\126464|\1002350\CAN\9877e\160489\SYN\fo\n#M\140761\1050789u:j\DC4\"\39095\SOH\1091919I\64643`tpdU\SOH@\ETX5\1015281\169940\&8\1084283C\EMI\70725\EM\DC2M\172398\1098890\&20\17785\ENQzq\v=KLK\1026521\160303\191191\FS\1022904&\1044176\EOT;e\DEL\1092828,59~\DC4\1095506s04[C\74207YbmD\f\40061\\\ETX\EM\153974\169857Z\f~:.\r^?#e\1054794du_I\ETBHy\NAK\DC3C@]Q\167956\65170a\v\1065540<\1097822zRr\vA\1005063\1042686%]\US!\99727.dfV\STXR\54637\1083007CJ3\t\1100221d=\DC4b0\96187\ETB\STXc\NUL\32051B(\RSsx\DLE\FSlYr#@\1048685\145684\1032535\995750\NUL7Py\176787aL?7\SOH'\1032303\1026443\166147;\ENQ\1101976\178862\1064385CP\GSy\NAK2@h4D\74062\98439\98790;\991778+%\142285\1032969V\DLE+Af\ETXr*}v\74561\EOT\b\SYN\DLE\SOH\CAN\NUL\DLElI\1103471Kof\59742\DC4\ESC\185307O\1025693fr/\STXq\62224{\SYN@\1075147p\1092437\DELmvx:fk\1096766\r4\1079176\9458\ETX\t\fP\1068111%c:\\4\403\1072385A\SI\1107936\188641\154662?1\US-\EM5j<F\vj\ETX4V:xin\RSa\SO\SI\DLE(\54934\&1\NAK[\1049037$u)5tWk\SO\1082333\GSwZ^\b\ENQW\CANbV\vV?X\bq\6036a5\148758\1074509\&0`&o\n\53835J%.Z]\1035401\1109190?fSi\DLEw\1015383>[([\40806\aQWI1\1012550\1013491H3Xf+A#YF\SUB_<o\145711&\997424\DEL\ACK{\vKV\100693;\64202\189513\1077183\&7q\15997\SYN\52069\RSQ&\1015762\1090382\SI\1055146C!f 3\1073828-w^Sz\EMo\1003405\1048758\n\1055170\&5\1069649b\50263\1010578.\NAK\1039175!z\170640]\DC1@e8Ko\\Eta\SI\149736?\111179Lv\70353H\182950\DC3\tr+]\160486\1105425\ENQ\DC4\66192e\SUB^)\1052813QZ\14882\EM\"b\120638\FSl)\DC1=t2R\b\994210#\150061Sm\CAN\54716\45421F\nN\aQI\143065\t:\t\1091665\t\beD\985513\29924qPm\EOT$0C\1032206\1092175\DEL\1109538\41396\&1\STX\\\1013942ZB\SI9\EOT\ESCx9\SUB\SOH\ESC#&V\26976e\GS\STXD\99038\ENQ_\ENQ#o\141436\DC2\v \RS[m%{\b| \DEL\41784Xn\DC36Vj\1043845^Q\1081508\1095541\127484\SIc\"}\52267\v4~H\182192so2\1073388\&5X\4914#\DLEI~F\1106477\r\1092432\&6\97341\92395\169362=\65704\ESCV\1088931\54810\49995\b0Xd\39140Y\1018332L\DC1\92469\1113197\&1\STXY\n\149353&\EM)\1089791\188671*b\1108025\SUBpPY\GSF\1073695OF;cH\152413f+9\143110\1108745\SYN\r\1051325g\64809\ETXr\ETX2j\1097965\156154\155073b\1032272\69665\GS *O\SYNY(f \1055635qw;}\1059525\EMxvr2`\NULLK-B"
    }

testObject_PasswordChange_provider_13 :: PasswordChange
testObject_PasswordChange_provider_13 =
  PasswordChange
    { oldPassword =
        plainTextPassword6Unsafe
          "YhSb\18076\1096630\EM.\13990o@uV\SUB<c[\1057109 {\52423*\18949\1084624\164237$_ &\26120\1083698\SO\1034328\21530\EOT\158238\\\1003353\&7^T\1109090%3_F\r1\98729\EM\1052505D\988429lJ-\EOT]_lJv\1066396\1011215hW \1114095\188162RH\50130UH&\1103173\1104594it\1034335\97757\165456\NUL\70443\t`S4QPvE_\996403=>lIo\169072\997652\998922X\13580X\1093433<x1W\SOH\45799\&7\1094773\SUB]!\SYN\SYN}[fj/\144627n\DC4\ETXbw\1102463m\1039447\DLEFpPT\135748\rm\1033855\ETX\140484a:\DC1D+5'2\1081090LE<uk4`M\1061548+\1010483BVbe\2052\fMy\tM\DC1\NAK\n}-Q71#\1001095Pm0|\1058882\18130\184913\ENQD\9731\1108589\1063801WU\140481\160717#\1059031\FSL\DC1_\NAK\a\DEL\t\DC1\au]}h!wBXKH(\ETX)?\137207^\fea_A\1063143K\991779\158532e\137940\78128\1097287{\1070688h\RS(b[\1067551w{u$vKawo\EOT\1002510RE\DC4\SOn\ACK#}\73796X\1020264\\J_p\"PZ\1047717\CAN-U\153269\1100618\\\1031460\66806\132371\137851\995103(u0\f\137936\186489\&5\USlzFe(`!XA\29100f\1097950`\f\DLEcGJ\\8b\SYN\68497\150502m\DC33\EM\1070400\66589\40122U\99650\r\179001z\1015429~\bI\1081648\SUBx\168204;L\145699g1\NAK/AiES)uYj=\f\1092823ygc\1100153;\GS|;\DC3e\DC1}\1057472\10440@oV{n\f\1096676\n%\1033766\r+|31j\1098756q\v2\EM\"\1076664\&6)52w\nOj\SYN\SYNU&\USU\SOH\ETX\SOHAb\NAKv\STXv\1087027\"H9TJ\DLE-nq\DC4H\b^I\SIs/-\DC2:ay:>\SOH\1032578\989439)P\172195\&0\1014194d\a\RS|\174744$Eu \SOH\ETXF8 a\b\1022530\1066904/]\US{3E9Sf\138114\a_:V\ACK\1111019QWU3\1098773\3051OS XdA[\183160\28570.\31939(b\nL#\1107788[\STX7l*C\1033328\984136\GS1.Z\998716\EOT\46839H\n\1071926\1079240\SOH(l\RS\143037\v\38887>\1090554:-\NULj?%F\1084391I[6v\170273\22502\100077\49274~7G\166097\4519\EM!'\ETX\38398Q?,\GSUu@%(H(I\ETX~>\DC4K\DC3>\72246\EM5\1022086 \1090756O\f\1111314\&2\DC3\25931\994780G9\999039\990590*%\1000152\NAK-\983159\SYN\\\US;\152905JP0$\1106049\37822]\DLE`\1036169:0K\997106hkB\144462\RSH\1102093\33454\RS\989572\1107706:A#]R\SIXFW\"8\STXHW0\986050\45557j\37948\995320\1100585A\1035623}\61155l\49913\1091660\ETXg&?\SO\&H\1054389\1089082\NAKL\98924RG\1101738\&76\5639\1081113@\EOT\SOv:\29442*\DC2xph\136453\"F\n3lu\61648\STXuf\DC1A2M\154097\1091702\ACK\DELtXj\DLE\1096523fT\168155\160774\62409Q\ETX\1073552ah:\1045093ctrC\1008972&:\ENQ1\984019\DEL\72254_,}\1059043Y9`:\DLE\DC3d\1103970\1096003\1102898*Z!\187234\148461\v\52269\&7\63614\SOH'\\TOs!%?\SOH\1093845Z>\DC4\1204t^P\v\a\34585`\147989_\SOE*\1011406\SI\162221<\DC4\USW{\83494[\1054677\&1\1049205duWR\25182\1059779\&9l\FS\a\US\ETB\r\1036646J$Ea\1052569\173473\SUBLpR2\27762A\167459\b\SOUJao\1025597@\17412h`\SO\163155\DC4\1066350E\157076o\1110972dZPjbt\54921\985661k{\1102674\&0|\ETB\50568Q\SOH\152060\&5\rfAj\1062496T\983117U N\31082u\1075887\DC1\157116\DC1IP>\995210'\rz\1046533A\1066921\"\181434\&8\164987|\63500wXC\NUL\1064912?,X\1019667m\US\EOT\96637N\185883_:d\USU\167304A\1106870*'`w|6\1045529\&9+\166106mjC:v\1053515\39282\1093638<C\134079\1195P!\FS\185298X3MO\39743\156771K'\ESC\996168\190976h\a\153223E7wmXm\EOTF\66212\SUBeL<\NAK4",
      newPassword =
        plainTextPassword6Unsafe
          "4I\984039\145689Sfof\DC2c<7\43372!.Y\150114N^\SUB\US}v\1076212H\46159g.*\SOH\FS\1061957\23442?\1058060\992123\36612\DC4Q?gN\DC3\134434)^Y% \34680\118865.dM$\1044529\&9M0E\DLE\153131\rR7y\1015864XT\v%-yJ\USTt_#Qo\EOT\SO'QQ.i\53454Eu<l\1009275M\SOH\SYN\186850\39417]I4k^n\DC1\DC4\DC1=HW\63553`\187702X\DLEQ\15506,u}\22284\&2\ENQa|\1060716\186008*Rq~za\153650ep\SOU\1008849\CANE\138684\SUB}ZJFG\1080yI\STX\CAN\1053406\\r\52981L\DC2I\1005769\&1\37350G\a)5^\nG\34489=\"\GSG\DC3\SO\39547w\"\1110831\a`\RS)Q\1046135\&1eBe\USR\SUBN\1090523\CANE\b\47443v\SI\50248\57929;#\\OtYp\181127\&7\1014425r\1038000\1092461$\1040196ujG\99062\1028834\DC2C/1ab({\DC4(/L\1104442\ENQj\1026068-\10609\195064Wo\DC38uWyq\1009803\&4\173518=w\GS\DC1&Vho\94898m\STX\1008596S/\STXAv+\ACK\DC4\USM\NAK\SI?\1007232)FB\STXI\DC4\989128\65693\ETX\160724$PA\DC4\120614a\RS\1027776_\EM!ON6>8!Acu\a\ETB6k\SYN>\EM-\22513g\149536S\DEL\RS\1023314\1096302jyZ\1066742\1070063U1G\SYN(\180738\US\1006809\SOH\1114037M\172262\a$CT\CAN;iezO\150819!\1105298t<\1055348\149076oogs\SI\ESCO\a~\DC1\a\DC3\1018432\159829t\15910\37325|\DEL\CAN%\1010165\&9i\156087\&5\144925k\1050355\49336\11211\174004\1051581\DC1K:\RSE\ETX\5991:f\1098856\19403\rN\49047:t\SI\1053824\1038465z\149922V^?D\v\vki\SI\ETB\1001377?u\"4L\1021111&\987357\21606B2H\173390\35107\&5F\34214\GS\DC3\\\1059063\&4"
    }

testObject_PasswordChange_provider_14 :: PasswordChange
testObject_PasswordChange_provider_14 =
  PasswordChange
    { oldPassword =
        plainTextPassword6Unsafe
          ")\1036280s\137216'`\59330\STX_\CAN\180010D\t\ENQzJ\1063390\1045233`D^\111264>\132440\NAK\DC3\176932\49323l\SOH\99704\1013404\&8\1098260\DC3&>\43426\30743x\173643.o\158967=6\1633\1098022P1M\162604\"RG\SUB\1038025\FS\STX\CAN:\DC4\ETBu\CANx\1089236\1061187@(E\1002850\&4~\ETX\NUL\51238\&4X\NULH\DC2pll\EOT\DC2\177807\1104201\DLE\17185[K|W\DLE;\144266z,C\USD\983816O\NUL\riV\">=^oX#&L\1049388Kq\25975YW\1033425t\1055427\22674\nPF~\1082938;42%b.;t \1040882\1039127\165132\DC1\1064926PV\26969z_xZ\SOH)Bz\t1f\DLE9/\FS7\1093628,J\33998\72145&Q\NULe=\FSK+\SI\25383\1028788\1022136n\97202\SO\173088\&8p\DLE\ETX\111158|,\STX\1033460\1104436d\1050868o`C\SO\132042\f?Hy&\36586A\46227\141006e\NAK\DC1wJ[\fc\b\1070422l\141230\DC4\64151W\DC4R\1045214t$\136334v\61852~r\1060898f\1071586\&3\SI\1019583\\D\ETB>\164308b\EM\133344w)\1053343_(\1058134[ra5U\SYN\178080\72861fC\141152\&6\1011495\STXy\100396Ii\1109445\f\184085z0\164727~\78749D\rhqu'\DLE\SOH\DC4\145824V\\\SOH+Mu\1041477S;w\141810Z\1041792\EOT\NAK5mo\USZ\1079915\172082\1069321\1090200/\ETB]\a<or]\NAK]W\153114N\GS\8888\1006117xopL\1040026 +\"\DC3U\DEL\181174d\990070\181346tz\ETB\1041154%\140011\&1\DLEHm4LC\t\1009974X\USX*oB\\e\GS\SYN\134114\t\n'\f\1009200K\\\US\1028123)E\RS[f\RS\SI*;\SOiC:bE|@\19768'\92737\GS\n\62524X\23489\158795!6e@5+\998224r4_*U\1110454n_)jds\ETX;s>D'\NULx+\STX\ENQI\NUL\DEL8\RS\1055834gcU7\1066759\NUL\7502\RS\995972T-",
      newPassword =
        plainTextPassword6Unsafe
          "\DC2\t!' czxpt\186414}\1036760Z|\1105851\&3\1098742\&9cE9;qlI\128862\&0d\1041894\1071062\ETB\SUB\13291C(q\CAN\DC4\92178r\992045\n\37621\SOH*\26079\&3xLD\97230<iz\b\1099952a\ESCz&\DLE\12647\aa\1084359\36555hslodj[\996135\1074923,4mN0}\DLE\1198N\vi{2\ETBw\1060641j\US\1041001\f\b1l\67856Pg\168961\36482\996753\1047309s\FS\1107183\194946Z\1073964\1057645O@b3\US'{W\1004373\1055657\RSk|\178308&-\33246\DEL\143973\1089738\nNf!\5792c=]\RS\1073994Ha\1002561\1110174]mr~\1037256\&8DBsgMI\DC3q'\1040753n#;\\I2,\1082140RlR2\NAK\SYNg\66227l\1054090l{p\25955\52310k{Q\1058\988291\1063442HW\"\DLEx.\158534p\\di\1092228/*\1037740\&7x_L\GSsuY\182987\&2\8178'|\1037994<\1093568^`u\1057438uq\19971!\\Jp\128227/\1081159\EOT\bV\SYN\15399\141173J13\tMJuu\NUL\1040450\DELc>\SI/AS\CANX\DC40\NULC\134548\DLE^\1113807P\SYN6U\"2N\STXv%\1078605} <e5\bj?\ACK\1098173,\1054591\SYN\15509\1084964\\\CAN\1000533p<\ENQ\1004686b\120629\5262\1109509i;\42828U\EOTrr#y\b\NAK~\990728@\DC1@\DC1us\996582yb\STX\1036261\ETB\989987\&2\ENQ[]\178609H\USs4\132550F8E\DLE\1051990\171110\ETB\136138'Y@\US)A\1000612\54417\189168{|2\US\12436\FS\DC1Y\1095832\131189\US\1008574\f\SUB\DC2\1003953x%`-\ACK\ACK/\154736\&9\EOT\83272zUl\CAN\1102755\988521\137065ov\135564\179630tV?~y\1094183\&4\1002043aE\148110n \66828\NULM\1004819\DC3\SOH7\131256\155286\t\b_\DLEk\1000209ORJP\1001622\RSb)jpl`XF*F\ETB\DLE}\1015654\&7zsM\47274V8\FS\74288\1015656Q\83371\1053709tH\1035398\50165P_\"AOYo-\NAKa\EOT\RS\FSM\STX\1012755x<\159958\&2\160777\1015388\1028872a/\31164r\STX\182366\a\DC1\1082881%\1102969\1076806:\21469|\v\50676?\r5g5\59802\f4n\DC1T\GSj:\DC38~\1051880s90@\nwOht\5866\1023217a\151648/evB\DC1\162640\987644\b7Gb^`q\DELPe\t*d<X(fmo\SI~\1036762(W9J@5\"\"\100124  \ETXE\1031773,\ESC\917959PT\SYN?\DC3..:8V\1108829L\165282\DC4\1112934?[\1028055\181498\1003275-\FS\31669lgiJb\ACKW\39308v6^;0\EM9O\512\32480\38747\150214\47625Km\DLE^e\RSX(E^\nUqzz\DELZE9\1071125\1058283~\1098214\ESC?\SOH@\ENQ\SICTA\30674d\SYN0\998291)\62919\ESCq\110800\1074529e\1013616"
    }

testObject_PasswordChange_provider_15 :: PasswordChange
testObject_PasswordChange_provider_15 =
  PasswordChange
    { oldPassword =
        plainTextPassword6Unsafe
          "nvS\1003283\1089951\52530:J\1058176\b\EM*[]E\987877\&0c\US\"Pu\DC2rh\995518\1044307P\62587e*\SO\bI+\7988\SI5\1044216n:Y\"'\ESCL\f\1003871\ACK\452\SUB@\998369`\b\SOrr\60627\&5a\SUBdT\1042465\ENQim0a\FS\1012713\&1>\17042\4719\ACKB\v\t\989972s\138208\&5\DLE#\53263\1088280\STX13H\173756#@t)\188467BEV\ACKLCX\SYN]\DC2P\181437\FSN\149514\186718?\22604(\1090926\15413\1065637\EMO\27585\\r\FS\\\SI\1035346\18565\1013435vU\at#\1062175\"\EOT\SOH{pE\12478xJ\DC2g]\ETX\DEL\DC3c\SOH\fPX|\1066931wEAe!\993681R\ACKu\1113614..$\1068793\27316\&9(\SYN\58010c\1002603\RSw!\SOi\1030926>qPl\ACK\STXXmG-\v\120608`\1088763B\FS%gW\ENQ\DC4\n\STX(\1074703\b\DC2N\1109769\&7H\"k\EMty\ETB\187962A\1020329.:\ESCj\re\GS\161991\1034321-*q\ETX\1093441Y%A\46791hf\n\141128\DC3J\157117\SUB}4\EOT\161237\v 8$d%\b\28128n\989856K\DELf\t\NUL|;X\ACK\142667*\CAN\SYN\24303\v\4878\1760Yj\vyyk\1026116'i\1080447?U]\ACKb\ETX\48209&\"\29031\1039525}\63031P\13226%\ESC\t\1047966\1098216\ENQ\ACK\NUL@\ENQ\1106062%D\41968\94208C\NAK~p\SI;\GSz&\SOj\DC1\"7\66276\1081689\EOT\DEL\990793\bdiX@[%}\1072552\1098336\&6K]S\ENQ\1012057T\990893\154290\&24g\USe\STXpS\82979E\FS\ACK\71075\1087888\DELo\29366'\t\SIv\995645\&7,\ETX\SOH!i\1031533\1081283\&43XW\t4\FS7\1101016\1108161\31300?\1083887@\1048301g\DLE\DC3\1067632Mn\GS;\1044539*k\147748\&1\DLEW\1112391\1103992*\vB6\158062\f\68308=P!\1112874\45394|9Qv\DC4q\1063868\1105018\1004357Z\DC4\1097524;9J\160053+\fLa\DC4\1010823\&2\1049908<\1055415\EM\1053244M\ACKDO7NUa\34227\1041181[ \181881\a1\US\vc.\1012405\ACKhi)\162677\35949nG\27679;\132913\1026232f\182327#t\1027272B=\152450`\180605\&4\NUL\1006343*\1075473\b\\*\ESC\177216\CAN;\ao%pAH|\n\EM\tC\143291ZrZ\151170IF\ETBO6=bh\STXzV\1013862P\1064457\\\159157:,U)\58595\DC4\1013245\1075630\GSg\SUByv\110788l\\\v\b^\31887Ii\ENQ[\65195y\1088707\&8a\CAN\t\vDeb\1007440i{t;oR]",
      newPassword =
        plainTextPassword6Unsafe
          "\152852s\1068988Df{\1109851>\DLEN\1096871:,\1104054 \134810\3245;L\133604uN\989402-\"A9t\1089099f\CAN;q\1046261\36961R<&3\ESC\DEL\72254\NULq\n9e\SUB[d\1062509^\v\CAN\61899U\18913BM)\DC1r\SOHevfz\EOT\118837k\152950\&8zn![nE\40274\a\148239\146181\1034404\DLE\NAK#\1021834\\\7383\f)We<x\1084738\&0\1085361H%\177704mm\FSoB\r\1023720\1071415\a\1034887<\58078{\1039623\DLE\aO\tLN\120664\ETB\169854e:\SUBVg\7633\1096705\ACKc\74121O\SUB=\1023970\1021372\&7\1095669\SI\146258\1039279M]\tV+F =\986106!\42733'[\5940\138632b\ENQC+RO\1062354\EMrWcB^\DC4i\ESC08;@\EOTzL\SUB`KaW\NAK\1016638\1021636\&9\1000295\1095903U\ESC@\1031654w\160029\EOT\185706\1065108\&74\1009580\DEL<\1065225ZXg7\143032vnsdL\33929O/\44172UMleG\990324\SUBH6*9\1071351]Dk\1031086Z.\vh\DEL8V\1078371-\31204s1iu\DC2(\1030715vx\b6.K\1018960\41438TR\NAKPh%R5\DEL\1010030I=\132690A\69911ACi\186980\1072860\1015687\1090081\1092497\SO99l#V\33337\161061ySJI\EOTX\164875Ju\t%Ab\FS\GS$`6HB\16142\95182c\FS\CAN\1027481\138748\1080245J\139629\DC1\ACK\af\44134\141771\&8\160845,\148334\tzUY\SYNGh\ESC\27549>\135919\ENQ\1003933\1042129Y\1083464W\184760\1043368\&3\DLE\\\b/\1058055<<S\7939\1015539\64214M\1090510\1087641\16993\1011916l]Z-\22802-JS\DLEB\STX|;\182480`U;K\DC3\31472^mU\10072( \1077618k\EMW\RS#(\1083524\1008319{\DC2e\22030\ETX`<\1005868m_)\SYN\70814V\182860\190313(X\ACKI=\22634\1080338\146205_s`u!Tlq\ACKM[\40979tn2Ip\CAN)\t'\1066826\&3\1098023nl\52291U.zG+LNJdvI18\RS)\134931\154581c\ENQn\1113759^\r\179247\n\US\189843E\119917*\158446 y\7913\149872FEQ\1088650\&7\DC3\1031401\FS\SUBF\NAKVm\EM\ah<\1095241[r\v\189278pq]\13103\US\fo\DC4\DC1\142141-\1098650!-.J=8\1040495\NAK\59358P(p;*s\r\CAN3~\NUL\139172\DC1\STX0O1\ESC\STX\SYNnQ\21981oUqG\SUB\EOT\1074321'p>JXk3\78374\987565\151899\147262\27256\ENQLe\138865V3>\142078\32373\&4\1065316\35039<zOu\EMO\998367\STXm\ACKHI\"Q\DC3F_\993645=-\b\39128y\43869v\CANL-7\DC1+CHJR\1035395\DC4\1057447\25684]\US\ETB\1054012~\"b\1040375~Xv\134931\US\1025465\1068886\1017477\70200\166767\RSW?_\159622\DC4\27137\34490I\EOT\DC2\49960~(6 \187646\1053641\EM\f\177483:\9353Zxn\SO.9i,\185485\&7\1065460ae\SOz\152039\177744\157498fB\44816Vn\FSh'\DC1\FS8Y\1014302[>F\\$k1\f\DC2f \v\121169\FS_\1066161b-\6727&\995927'X?Jb,\12990\158842\9204-\ACK/\983518\1100707`\ETX*\9732!\DELf2&/\SO\78519\ENQ\1006374\ESCU\1108463\993917\USJq\155123R\133864\&2Q@\ETXq\30171sM\"\DC2{b\v}i=\118851\DC4p98\DELsa\1110153 NiV\1016779f@\162996\1062077F+Z\154196\DC1\1093124Zd\66026gh^\SOK%\142282I"
    }

testObject_PasswordChange_provider_16 :: PasswordChange
testObject_PasswordChange_provider_16 =
  PasswordChange
    { oldPassword =
        plainTextPassword6Unsafe
          "gB[\SOa\136597\&4I_\1070522$\US-E\f\bD\184839l\53618j\145196\1063189e\96537*\1053243g(hJ+E\\\STX\100410/\ENQb.\7738\1113147\\\27214\9423\EMu)-\DEL\FSRh\DC1G>\DLE\ENQ#\162187\94536\v&\DLEd[5\DEL\DEL7U+wZ~e\1065056RT\1015376~\47206\1049409\SUBL~\ESC]\175086KpHWu_\1093704uN=\b\1029782\EM\US\1041680\DC3\DLEd47\1016259\1094650\SYNZOiX\61511M\DLE\DC14\1023510\55250d3h>Jw<\SUB\1105863$*)\173139\&5\t~\36451U\v\1007351\&8nb\DLEXH\137571\DC1Q7kP\186382L<\1078705$+\1081663#\ESC\38858*K\180009%\154955\65738\f2\v~A\1011551\f}\1100334}(%\SUB\997989PA\NUL\1081198o\1064382\SYNV\NULv\159271\ETX\54311\1064618os-\1091683\NULE\STXcl0\137068f\1050864\186833\174746\EM\25158sQ\1071799\60428\5196k^=_l\1066392f;O|\1063397YO\"P\NUL\69230\\\35862\"\ACK\"~\141584X\1038172\ETB$\95964\CAN\27381%UQ\NAKy\1029066\1073585-W\1020228z~\GS\22450\1113567J~\DC4-?:\1110536\rf\1065914\a\187988\1098168^.\26197T!*\1037028~\1073514\SOHF\am\27257\158078\175061\\\SI\147288Vk\99196w\1092949\186929_D\DLEq\1086094r\131393\NAKy2\ETX\ACK{Pq)\1037265\99424\993708t\169393e\NUL\US\988887`\159377\EM\1002749\STXY!\50906\fY\ENQ\1078545ERU\990479>\NUL:ZT\1035772.3\CAN\1096695J\SUBN\ETBZ\153481\a\16088\DC2m\ENQ\ACKDzhd(<\SIF9-N^|\983096;3\993521%\164480|\SOH\1080654\32149L\DELs\72704/G\161452\&6\1001045T<\US\SO\176234\b\132812}\1056421\7504<I\190000jXr\RS\1064330\1001264)<f23gZQ\DLE;'\52173>k\19220\NAK[t\DC2U\SOHIX(\1069119E?9*|-/)3U\ETX\ESCo\SO\1099860\SO\RS\1009682E\te#\DC4m;\DLEfx\SIm\1046538\a\97848\187828\&1\137971Kd\CAN\1042040%\ENQ\173735;\1027791:4kcX\37202!>j\153067hT\DC4\163467~\1060082\995785\1005593\190617\1113881\199\DEL(6r\DC3\145739\EM\ENQx\GS9E\SOH,6\1064646\984090\&5Zv\US\70154)dssy(\NULco.#\"\NAKXW\119053gS_\31565O*\142194\"\1067622&Xt\DC2\r{Fi\48778 ]ZZq\994122:\177062:\1052139U\ESC$zN\SYN9\"\10761\&10b}X'`\190793C\1043334}\r\1111369\1021511*\r\SIk\1062958`E?=`\46022\78512l\1068151*j\36518M\1020065\37308;\159311j&\DC4?#\191316\ACKs[iF:\n\16090\991139\1059764v!b\1112922\1068230\SO\985232\141755\1112084j\DC4A\SYNT\NULNY1\1078882\a\136436\1088153blf_n\DC3\GSB\ETB\11380\50340q\991037-B/B\16269j<g\98191W\n4bQ\1498\&3KG\1057898{\n\a\\\5712\1033526\20469A`B\1081175\33941\73082\984412\ETBt\58845GK)\ny^@7/\CAN\157585\&6WErO\167312\69812-\ETX\SYN\b\1019966\US\SI\1046425q.=\1073165\1031713\"g\996204vV}\US>\178019\ACK\1079155rr7x.x~\151350\DLEcIIK l~\vt8z!)/\24279~?yP1BY\ESC\1044'#7\\(p\159717Xx}\150971\145409x\15522X}8\SIw$\1067337Dy\68912SR\7036\54589\1086756R'\EOT\1016478 \1086591>\1072777\&65\DLE+\EOTm\1097089*vMO,4\24600R\1049889W\991833\FS\EM\154481\":H\SYN_K\v1(\23407\&5g\189510=\ESCY\v||]A3\1090464\&8fI\f\1089249d\27681dw:\53053:e\FSX\140812&\26383\58555\1020960\153568\&6\ETX7?Z8\DC3i\10727\32848U\987253'D>\ACK\1099263\167302n\1084348\SUBe\5445\DC4=F\SI\GS,!jSM\1037019_\n",
      newPassword =
        plainTextPassword6Unsafe
          "s/\DC3\a\1019919;\186152\DC1\ACKL\NAK\SUB\123639\&0\DLE5\988934\1085942\ENQ]y\n\1088660\EOT%#o\181283k'N\5859\164247\1012481.U+D\ACK\US7^\1106302\DC4&\73089\US46zmN\1078548EX\1100831&hV\147473\&2#B,EY\1062234`\DLE\986448\25566\EOT\EOTv\1060131\1011335\6586\8606[H89oS\141447\v(Isb\DLE\1009984\999533Dv>S\ENQ8\NAK\1013739\31809CBi9C\f\ENQ<\1060837\EM\1002394\RS,/g\1021216\&6S$\CAN\CANTc\145792+~\CAN\38440<b)\v|5}\1013928\v\1022015K\ESCgSo0\CAN\1097842\&0Ch\40048Q\997355\DC4`\ENQ\140242q\1055353s:R(\DC2\SYNYdXT\149533[I\FSpyP\a:\1021100d\137770\bk\179199\1028191`z\1023858\&5.\1048071\r>;P\EOTh\SOH\990223\GS3}j {p\1006877\169025\158467D`\1014376mN-\\V\STX\1106691{\SI\ETB \NAK1#6p\994323~\992677\1043440\&6\1059978Q\\8\ENQ\STX\1011902]ynrf~>n&\6380\94374 m_`\1080547D@\DC2k1,>\1098067v\132299\&6?\ACK\1012654\DC1\SOHjL\16576\&6\USld\1008037\189738\&5\7878w\62207$l\f57\NUL\64524\1073108sg\"Mf\ETBuKPsa\190219zLTtY\136016\&2\"R\18939\66650\FSw\b\167281\US\1065135\50725W/\126507\94452}S\164388;X\EMe`\94080\NULZ-\995401\43858\n\\\EOTy\187923f?\1090882!\SI3\n\ETX0\1046274S\39868T\189058\ENQ\SOHB_{&\FS:\FS\CAN\988362\9506k\1054019N\GSWR_>J?,(\1101196r\1035425\1088638\1003569\43364)\997661\1029696q4U{\21915uqQA/\1036564\1028269 ]4L\100553\29035\25204m\ETX\179784b\64823\1106448\GS\151115\DC4F\1004969G0@6\1077837\DLE\137744BV\1081634l\1081851C\1065998Q*<\SUB4\ENQ\99901\DC1dh\1085582\1100640V\128022\FS\1012025oZ6>\24971I\1046586\&2@I^\DC4B\ETB\ACKmD.\137741`sB\19558\183636L2\DC32;\GS1L;\DEL\141722p/\bCj\47458G\27338SXe\97073Z\ENQf\43154\&2_\6385\SYNr\DC4/C1R\DC2"
    }

testObject_PasswordChange_provider_17 :: PasswordChange
testObject_PasswordChange_provider_17 =
  PasswordChange
    { oldPassword =
        plainTextPassword6Unsafe
          "I{A\1081115\1040244WH\t^\1024680\STX\DEL]~D\n9:\NAK\ESCy\1040393$%7?\1048769>bm\DC26V\1065346\16705\ESCQMle,\1015761\21766\1105355\NUL\1020694\GS\v@K\1043881aC\1094072GI\37368\1075187\1079031@W\1038319\1001363\997424\157615\EMa}\SOH\12756\1081169RP\1087906\SImNi\98040.6\14300\35116\STXe2S:X\\y\1027289R1\163603}\1012190\1110662\119901d\146377Xi_\1058064z \185806\47296\28402f#\ACK\b\1018085\fDK>\1092488AV=6\b\DLE\GSi\DC1\SYN\1108215=W$M\1102069\ESC \DC4u\990358Q\FS\78744u)\1056471Qf\US\SOH-\STX,\DELnCr\\[\25698\CAN\ENQ-G\SO7\9176m\RSs5\CAN\NAK\NAK\1081901`-fY\1028198\ETBL\63765\ETBX2[X$B\FS\ESC|\n\SOc\1093611X\NAKW\1010429q\1046880^`CD\DC3SMJ\STX/wR\NAKmB(\EM-\1034880xI\DC4A\1078737\1103535\1083873yw\fn\1057985E\1101283cP1\189927\141738\1011422j\1037710_\NULb>&^\EOT\58470<\r\b\rr#hu.LY,\tS}\ETX=Jz\1113866\78095B[\f(yR\997282\SUB3\140630\DELl\1016964\SYNIa^\50526*\988502\&3z\11825%<\ESCx\48956=H&u=\FSs5_X/\1021976Q\1059092dJ\172609ghu\44563\ESCE>3\1072325\189630Wls=)'NG\1094331r\SYN\DC1%}8%&\154657\&8:\ETBKQ@?>k\1027270\NULb\9895+Xmu\1011506\n\33550-\f\49393\51542\DEL6\1055009\CANw70*;Q\1072772}y#\ACK}\ENQu+2\163564\171133\vTF\v.Pq\DC2`M\174005\96741\&1\SO\njL^sg7\1081135C*\1102887o\1088885{y\52998\ETX|\1023709\EMF\135291vxdQ\137699:\SYN]e\DC3^\SOrv\SUBf[5\NUL6x1E\1005855\1048944\1080103\v\993780\v\DC1\SO\988187<S\1074594y\49125%.(\983512^\r\1071271p`wYXp\1026176q_\DC3\CAN+\1064297\FS\1063403\DC1\1114025G&z\26673 \166009\152152\1092164_6\SUB\58880S,l'|\v&(F\1035615=-?v\1050656A\nYVc:o\1097457Ho\176590p\NUL2ho\1034982\1018761\SI\1073292\ACK\11961N|G\n'hv\SOHE{\f;.Q[u\DC2lL\1109078,lj%\170901\DEL@Nr!;wN7G]K\1111819\992828\&9l\bT\167336;?\65678y*\1008899\ACK8k\176336\DLE\172053cz=8\r\34858}@\NULPa\SI\11738\&3\166596&=\DLE\1071894\NUL\1031987\&4\1093861\34501\&9\145992\44569\149477\1005548\&2\5832RlI\134016B\138025l\tJ#\98607nZN\CAN_\1080429\FSv5tL\1107693\180278\60724mN\DC3s!Y%s_\DC1H\1073863dSq\162143`\RS:\145354f\ETXjge\RS\RSML\49583#\999129o\1010180\GS-P$T2k\1014277m\44635Q\143194;D\r\\\1012101#zYz!Z(\35861P:tmxqb\1038943\1108366\DELm\998570wq>\"p\35477k]^/=+\1067771\n\1074075\SUB}A\DEL_8\RS62\ESC\DC2Bk\29783C~S\EM-`\n\186446\EM\NAK<Z\DC4r\ETBA@\STXX\SOH\22287m6'\SOZM\140022fa\43378\1026557\US\US\1051233w\DLE\1035339?%\26937\n\f\ENQC\ESC\NUL+@U=.if\111307\158632am\SOW\13902\a\DC3Nj\147325\14908\tza,v#\42872\1013653\141398Q\22920\SO\21486p\1061198\SUBd\f\r*\49842j\1079297\4129S\STX#@8\167026b\1090344\b~X\ETB@+[A*\23712B",
      newPassword =
        plainTextPassword6Unsafe
          ":z\998337\&7qH?\DC2\991826W\1045632=\30522Qq\5831I\DEL)\ETXW\141029 ?<ld$\1001802T\1009489{B,\1054773_\167414\rm\994795m\SOT-\ETX\162981B)REnd%\CAN4\RS\DC3@P\SUB7S\1009615\30250\EOT\"-t8\USn\DLE|`M\985224\1026346<\ETB\ETX13VcZ\984462xJr\DC3;\136719D*~j\9361\1024621e\SO\1103323<#\1668~!\ACK\ESCnIg\ENQ\r`Wh}E\1035825?\GS\1079257\1021535\162876l#\1004297`v\95280\12099a^S\a~1j\1060269\&5dsh\96159\ETB\USl'0\a\ETX\1064165\\\ETB>]J!p\SUB!Y\SI8m(cS,\176277<\168390\1057601\1082774'\1092313z\989733\ETBwe\1013727\aa\n\59433Fb>A\1088804|\SYN-\STXXz&/'~(cy)hIF\181057\DLE-/XyR\147207\1035531\99846\ENQr[\r\1052642Q\1054366u/r\995938\NUL\ETX\r\tTj\190394\155541d\1046953\DELm\vb'<\1059546\45701@v\53022T5dlF\f\157714gRJ\1037469\995950\1090231\US\62219j\bF\\\v\f]}4[\1091004\&1J5\1101864fM\1002697P}\1109954]xd\44742rn\USi\127844zuK2\64008qwmc\57449\SYN\SUB\r55w5q|\DEL\1004339\DC4\1000580\NAK\\;\97824(d\STX\1069352\126106#\SIeP\1014578pc\b\1006213\78367C\119203\b\DC4#C\183272M_\DC4 EY \140657\STXg\US\rq.\99689._\44617E\ENQ\STX\21293\994346.\1010642\165378s 7p?I\\\1016448NG\1016271\vH.\1011097\&4Hz\DC3a\1112965\1099391LS\956\NULnx\ESCK]\v\1014996\ESC\1001785\DC1<\1059607M)\1103444M\52771o\DLE\FS)6\52537\78102YfQ@F\140229W\NAK+\158031\f_b\999514_p\1026159N\vF\RS\"f0\FS\DEL?#v{\1062480\GS\ETX_p\STX[\170629Qb\37443\&5\1079682b\b\1113122O\987041\r\30653z\GS\1034134I`\ENQ\1074991\ENQ4\NUL|\GS\rt-\FSY\ETXea\164217'\ETX|\25860qY\137837\EOT9Gyz$ME\1012376HF8\1101936\DC4\1040797\&4\DC3d\38807w\EM\1087666PY6$aKV\RSkHNh\ENQ7\b\154234;I-J\1010947rSDa\51431C\157687\SUB\US\SOHV%\ETXB\DC2N\DELGq#Q\173949>\1049166\ETB&\SUB\1027480\&6c{:\NUL\1026276{\tq3\96886\1014266n\DC2C\993425\17816nLR<2bXS\ESCe[l\1097388\fjjZ\1004264w,a\143819\r\SYNL\1049703K\EOT\FS\v(x\141566\1002452\49875l{\986046cp\\\GS>DA*\186399\189082v1`[I\1087573f\160956\&8j\SO\144181n\60434\EOT7jx \v\DC4\SOH-\"\1051346+`\STXF{y56\186936T\17962D\111297^C:F%5B\1113608\183649eU"
    }

testObject_PasswordChange_provider_18 :: PasswordChange
testObject_PasswordChange_provider_18 =
  PasswordChange
    { oldPassword =
        plainTextPassword6Unsafe
          "\ENQ>$;GNS\NAKq\178874\58968$-\68366|\151635\70868GG\1069152+N\994629igAv\68290\n\1040872\DC2Tl\ETX\CAN\173661\ETX\161735N\42419v\149562\98179\&9$v$R/\69765U,\a\21766\CAN\ETB\1040043-O\DC1HY\fK\1067449aS6V\NAK\1040221\996914\850D\54816Ke\ACKj!|!\ETBo]Xg)X8P=\ETX\ENQ\RS.b\"xp\1105843\&3i?kTDu\1098220T'.\1071583x%0\DC1+GA$A\45313\a\ETB\ESCa\1028493\1096329+\1019183\1111460\SO\n\SOH\ESC\65042\155997\STX(]\1046910GL\DC2a\151097F\a\168528\fdB\ETB'\165547+\vTf\992507I\1045958\&4r\175158%\RS\999749Xq_*g\994465q\RS\SYN.\1013841 \SYNzQ\NAK\986554:\181318(d0i\1025168Z\1057887\nn\988266sa\61001\SYNx\DEL\170759A\1027650?LZ\CANO\1039286\57543\&8\RS\EOT\992522M:unvs\ACKco/\1103889\61376:$\1017208O0l:\4771j\1071859\NULB\DC4\165947e|\1104789\119138`BCH\92363\&42\59532\999574%Y6\1036574\b|\119002n\1008926\NAK\FSb\EOTso`\DELy7H\1144\SI0\12299B`!\n\EOT#L\51662\1103006|\ESCa\1038787\DLE\r\1067701\&0Y\135747#NKj\1106283\42365\SO,9\ETXh\DLEw\128979R\"(\EOTV\r\14540\&1\989621\DC1yq-e\f\1035089r1YU2\1087695\171952\DC2\SO\1105513\1062941[\1019605_Za\52679\DC2\ENQ\v\1046141\\#\1076425\a\FS\16658b5<kh}d\1006023\&1\177209A\176321\167887[\174365\54060\164573;e\154491\995939\STX; S\154267\39126\&8\"Sy\b\DC4\RS\152360\&6\94506C\b'w*a\rb\1014889p\159839~yn\t\818Pywa\1084674F0n$\1028369nK\ENQ\19180\1069321}\ESC\EOTV\NUL\NUL<P\1090555\NAK|\NUL \47254^jn\ACKIwu1\FS\142184\174835`\992529\1077385\&3@\SOH]EN\1103974!q\1011754Y\r\169901\13238\55015x(X![5\DC4\1035985\1001469_\182864+tV\1062925n\NUL7\1103575\&7\1086880S\ACK\DELh)\SUB\992316rF.\996185\ACK\DC4(\\\SUB4OOv\f\DC1\EMua\1050989\DC4&n.\74133\176117\170260\EM\1063073b\120663\1020167M\CAN0\RS\NAKf(\1009017\67173\1033080\EOTS\111185&\42372Qcxr,\121403\SO\&Hz\f\189709\DC4\155065J\1078998v=@\43115\&5{\DC2`a\ETB#Wq\177921\&6;\SO\SUB\51101\1043265L\139428\STX\1073541\NUL>C&>dt~y)\66452\ETXg\141548@\DC3\182735\ETB*$\DLE\1313UnKs:vVS\1095798m\997335\15618X5f)}@{ha\DC2\f\1041518\ETB-\1054867\t@\STX,\1099907\990571\STXD\1087623\SOH Cm\1004594sDY#YL\1090422;F\156423\v\GS n\a\v\157412c6+,\1004205\EOTH\1063061\33351\vf\1065194-ZS\ACKB\SIFd\buy)\128544\1074733i<vb39\EMq\ESC+\ACK\1034412\ETXL!0?\1051914\&14\155913\987584\ry\ENQ\1092562\1046857T\39898< d#9\DC4hP\ETB\tw\ESC\US\DC4=\\ezX\EOT\6588\&7 \194876\DC1\78166\SUB\NUL\140439-\144270'G`\1048636\1022424\US\v\r\183787V\43064%C\15642I#\150256\1040473\RS\DC2\GS\1035339\29895\1103337@d#\ENQ,B}`b@\SYNAj)\SOH}{\RS\FS\110786\1065354\NUL\988423\1074114.\9608\DC1r\160028!\GS@?@\2495c\1031030fX7\51569Q\FS\1063397\158353%\EM:(-\ETXi~pc!Xh51]\SUB\83497\&7\181090",
      newPassword =
        plainTextPassword6Unsafe
          "3\1088217\38115@\ETXcW#\992487\SIV3W\DC4\1037271VGgf}_R\1034386\1025850\1034892\1110694S=0d@\1085519\\JfQ\1087177\42806V\40142\&2\50499\f\NAK@0\1032859\1000658\&3\1025529/\nM\DC2Qp\186233\175896S|.*Ul\185755\1047728\"k\1111673YRQ%-\f&$&+\997255Ha\1006661\164253P^eA\EM_r\NUL1\1015383\16634\GS}\ESC!yY\1023328\1027252>\1092468/\SOvZw`JB>\RSu}\1107475\1036872\35763%\185556n5\CAN\60703js\1039874\1078173\135796uvW\"\28047h\1043723P\DLE\1097958S-<\187968\34464\186710/wb(\26583\&3\n*kt+\180850\SUB\1021642\1068226x\983171@\DC3\SI\US\\0\NULRA?\SO\RS\189447LuW:Xh1\SOHT\DLE\94916 VOG\DEL\RSO\189514k\3015\1025016;l`g?q_ \1011679\92993\984171~\ny\US\1045482\52577N\1029913\EOT\SIA/j\STX\1084693\DEL\176033\136608m\GS#z(\127161jW[\1038238\1073630\a\1060787\&6\nnn\145137\188550\DC1\1068174\989085t(l;\1017830Sm`tO\r\57362\NUL\1101579|`x\1071012t\153686\EM\163617/\DC2yuB\1072146s_\183212UrcO\99677\1081043\n\41654b\1797\GS^\132600\142485}Q\1109755\DC3G!\1035773\&9L\195083y\2453*\SIU\vk?T\1064435;\f\\Q\RSk\1085726\172950\188191|\6976\1114033Z\155291\tl\NULb%WA\49679r}u2\1059498I\DC3V'i0\158983/Icz\74116\1054934\DLE5L2K.\ESCKLr\DC4\1046820\1052056\STX\\\SYN+\DC4G>\132569>N%R\DEL\vR\\L\1082431*D\SI4u7\DC3AW\STXG\144748e2%y\bw\US\SUBZ4x,\ESC\67889\f\47421\DC2r\1004074r]%ws\DC4]y0\1014309I\993296n\1010689.l\NAKLAv\EOTJ3z@d\27165\42869\t"
    }

testObject_PasswordChange_provider_19 :: PasswordChange
testObject_PasswordChange_provider_19 =
  PasswordChange
    { oldPassword =
        plainTextPassword6Unsafe
          ";\93029\64850k{\EM\ETB\183122'\ACK`{2\16834\ETB\DC17\b\aQ}P%O!_^d Tf\STX\177895sQDd\DC1?}\b\NAK\64801!7T\180836L\ENQ\30743\STX\DC3\GS\a\US\1011186\DC2\DEL1EEV(x'\DC1\SUB\1061407\t\GS\ri\1100649\&4*\1060200Fs<3\FS>}Y:\DC2)8+4+\STX\985320\1012240\134405\vl\NUL$\v]rZ~Dy\1045002MF\CANlw\995758x\1076847-I*bE\1065762A\189306\&5\50057c:R^f\\G)\44960\&9\DC4$|\STX\"y\1020665\39604AW =\20322\1091813\&1\1108618'\1051166x\39102\&6U_\997336\ENQ\50873<\1066165*\ENQ\1029616z\186193U\DC1:4a\148141\32437@\135977\177323\&5p\1110836\NAK$[\US\74077.\987765\&7\NUL_\988982\&8\ETX\r\bg+'R\1027482\1029411~E\rP\1034583\r\181175\46544S\\&.^\60125L\1104199L\a\144365G:Wiws\NAKQc\r\164901\b\141361;\999696|Q\23549\&4\1036417\72875y\29622\f_&fGgH[\1029620u\1052069\23938$\ACK\STX}M2y\99985Z&\189182\f\1110805nzK&\1066016w\n\NUL!-U\SOH\ESC7\ETX6\1026958so$\991139\t\138455\DC1A\27842M1\DC3\SO3.Q[Uy\1006799e\1005623\fl\146202\171029W\1104958C\SIk\71104p@$+\ENQr5\1029753\nB(X)Y\62054>\149953%'\180534H\187026\135153s\11937A2MqW/\18450$#I]\137728\&8sv\49908\ESC\1061880t\1103799sB\988567\&5\"\a\128637{t\23482oJA($\RS;\1067956:\SO\98842\128224\v\141160c\992280\"\1037303\95310oQ>\STXyD\186030\1035343\186166g@&\EOT\95865{x0R6\989091tn\12077x\1106050d}\1016609m\DC4bHo{\f\rM\184517\t\137817\147706<\NAK\179286;dz\EOTC9.\CAN\15836V\SUB;\992386\RS\44724Ho\DC2\93805/\1100285\141534\RS\t\1016167c\STX\1023078\1034365\1046848DavSJ\SOH\STXk\NAK.\FS{Z4\1035470\&0j\1013919{\161435\59533{\148113\EMIW\143598\147178_[",
      newPassword =
        plainTextPassword6Unsafe
          "4)N`WV1t\171789cC\1064787\SUBi\r\181549K.\1026553\EOTpO\USm\172246\&4JS\119270\NUL)bL>\ENQDBd!\SYNc@\SI,Y\30028`M\47712M\SO\8923{\1025087\ETXk.\30014\EOT\1066825`\120441Zu\169464;>\1079442\CAN\1106555\1111972\ETB\51402%\1109382,Zp+\rM~Q\r)Hv#l\168927\FSDHS\174628\999635j\987945\163692eWG\156827\\7\RS\1052535\&9\\\t\DC1t\1112332\1073530`\143677N\1010456h&\188126\1030547b\6757\1027169\1067336\183902[U\136396\991560>\CAN%\nO\78186\24509\b\1052137\&3Za.u\160812T\US\1033241\CAN6VR>P\188486\1062205\1040066!n(\1023327sWSekN@\24878t\985533V\145005\1095963\r+\1017241B*K\ACK\1074664]Ani&\tsuX/a|,,\74249^\129600\SOHty\ESCf\146951\NAK\150050\DC3E\fS\1032730\SOH\3856\SUB:7=\bgux(Q}s\20372]\DLE\r\44488(\1014999\148549\&2E`yqv;=\DC1\985264#{\EOT=l4PE5\181488D\1035492\138684:_a.{\"F[\n#~\1063106\&50K>\bTp\US\DC4K\1084112/zT\186543\991672\&7\150007\1111071X)\DC1\\,\22596%\SUB1\SIA\STX\RS\10664l\135150\1044470:e\SYN\179418a\17938v\34834\ENQj\NAK[\1095674f\177286W\159061\19064\180331\\]\162954&\EOT,6\GS\DLE\v&g\1039892&36\120707\1051886[IO\1066559<s\NAKs\917911\184419\ACK}\1035992\a2\njA-Bh;/\SO\157971s4\1080375\vYc\FS\rY2\ETX\1003495x2\997430\n\DC4D\1055770YX)\\.\n\1043855:\120234\58957\131967\1032943tK(\DC4/\ENQ='U\SYN\DC4\ACK\n1\28019\&1\DC4I\983826\1026068\vd\46567\ACKx\n>\RSd\a\bZ\tAVn<m\SO7EV !\DC3n\DC3\DC2&\SYN`ncs\DLE\DC4|\137634\97875\&0{Z\1105401\RS8x>\138638\CAN64\165009B]wi#!C\US\60105v\991897\SOH\165490lwaI_.\DC36q[\1098542\&6\SYN!5\ESC\"\GSj\ACK>\1036904^sW\1085173\1101480\US\\\1061623\&4\EM\EMS*G\1081642\DLEh` w\DC1BIW\ACK\SOH\1058576;80\1036044"
    }

testObject_PasswordChange_provider_20 :: PasswordChange
testObject_PasswordChange_provider_20 =
  PasswordChange
    { oldPassword =
        plainTextPassword6Unsafe
          "p\1083126\ENQ8F<\1052109\SUB[\135323zK\119137\v\SO\GS>\187813\ACK\1070478{#\983389\ETX\r\ETB\n`\1057369\n>\FS\74541zg\144907b\994068K.\FSdP\31134\188699\SUB*n\ESCU\23255\183897\139035E\41355o\ACK\DC30ZUGA\4214ES\42691\34888\EOTt\NAKvy\161692kL\168633Z\178845\&6\26688pU 6\ETB(\"2\SI\nf\ESC]\31963\1003735a\136163 nO+\1070087*,R\SYN\1038252O}#)%\ESCb;;\ETBZmE\v\SYN\10210\RSUy<\20686\&6\DLE\ETB0%C+Q\EOT\DLE/\45733z\bEGJG\ACKx=\GS\DC2\68917[rI\ETBJ\DC3\n\DC4\NUL\GS!2G\f\FSw\r%*L\1071155\37227Jv%l\DC1v\DC1UX\177325Y!\1112448\"\v\187099a\SYN776'8FsDn2\GSx%!cE\179818t$\121444bDC\b\52924\aG`1\ETXF\1109471\99230?\SUBD*\185062&\EOT\"T\ESCW\58470FlY`Tof\1048965\96573 \f<TK\"\166132(\GS_\1106583\1103365\ENQ;\EOT\993851\993011\DC4\r\DC41\b\1055652e9\1105871\1047592^>\ESC\DC4sS\1010996_a><\f\1020047(.Y}%7z\DC2Q\NUL\CAN\1050803v\1028497\US\DC3J\EM\DC1dEh'Em\133130\999811\SIH\FS\120427E\v\1050653,{<cKS\59272(Z\DLEn\SI\31485\t*?\1032204\SOH\\\DC4\GS?\EOTy\1016704?5\USl\1073730\190051X\1111302\1047685\66698#\DC2Si}\1006825\46214\SOH\DLEL4w\ETX\1006750P*ST#|\1006013\&4\1079005\1043985\96486IWQR\SOH2eUl\60163\&1\161808s&;_>\190522iQ\1097210\165473k\FS\1112852\&3}6#\1003388 \94215\1112185\n{\vY\ETB\70801\1019457\v|~W{\1035159\8185\1045959'\DLEO!\SO[\DLEUk\23328)\1101657*\1069854B7#\988898`\992584$C\r\SI\1055353\1075772i\121086\1096003e{N\a\US\SYN\7098\1049584\DC1\SYN\164973\1005568^\US\1074252\1056920\FS\180867^6\SYNWPe\nx\1022949:^\SUB[\EOT~u\26460\&7\RS \44431\DC2\23328O\ENQ}zi\1081683d d\166200t\996444\fk\172000r0\1044826\50464*\994866\&1)$j*<\51631\1008420v|F~\1020301\NAKm#^l\EOT\148762\139353\US\GSW\15496^j\DC3\1080990\aA\\.=3J\995313>\95982}.u\STX\989998:sk\ESC\1107636E\ACKBR2o)\STX\7667S(V\"\n\50026dvp\997353f\DC1\DC3\2034\ACK~KH4K\92412'\58542h\1050852<S\ETX\DC19I\1045842$\185546\&2>k\1045053i&\a~\20933W\1033711{\1058407mp%\1091729H\1011114i\DLEdZ\1104024W\NAKYb%\bXwgAa\1084701/\1060643\ACK\DC4W+h\1089169S~\EOTQzZ~\SO\1094174E\1061848\t*\100572v\STX#\\K<P\194666HnF\1010750@!:c@<\1047131\&973U\ETXco\1080072\1046239q\155736M\NUL2JUU&\1001059lEu\189809\1062670\&5d\27755{\1104696\66482\1105459C\ACKA\DLE>\RS\1045046\111171\EM\149568O'\DC2!4]\DC2\163000\ACK\ESC:\59217\NAK>Y|\31158\t\149865\NULuv\1087835\aV\tb\STX7\1095030~#\184376\165077\41742\1035571\US\DLE\13715\v\1079101\NUL\EOT\1064658\136028\ESC`\1005448V?\1069622{x\SO)\DC24n*\997306nsI L\DC2\CANvo\EM\ap_P\tJ-Pk#ui\1049155\159822b[\1067444Yd\180222\35890\42013V|\49216q\1097565\r\CAN(yW?#+E\SO?Y\29463\63850\DC3\DLE3Q$\a'1\1110820%\r\153831@W\26659-\DC4\52370v\DC1\1013997a\r\SUB\NUL\1009250Jz\983893n\986832\133570\5867\163028O\t\ENQ\999543\&8\DLE\38142A\\$\5442\n)\1058130t\178355\166333CE\163128rpj \DC4O|}\72274\150000&1\1012087)\98960\138897\133873\53513",
      newPassword =
        plainTextPassword6Unsafe
          "\GSATD~\GS\EMK$\1042815h\993958PO\rPp6}vL}Q\SIO?\SO\SYN2!%\140960\98456\14965IQ\SYN\DC3T\DEL\EMb\\n.\EM\v6G)j\NAKo*G\vn\DC1q\DLE4\1057182\190279\FSG\a\1078359\CAN\STX5\US\r\SO&JH\v\v\GS\SOy\FSZ\1087012*\1054369C36Z\100291I\1006927d\167128\136845X\NAK}\vX\13655\ETBE@\1047002}S\DC1\44983:nS\1033701y\1032307\&6\a1\RSF\151742;\78820|\NAK0\1046714\ACK-\DC3'\1052372\t\DC1J\1031338\t\60374\ACK\1100306<P\997585SjS.BI\US\127744\SYN`8\40391lV\1104712[E\DC2\1095840\NAKDL\137868`Q\187690\99218@\ENQ\1083912CW6\990626j\1100014\t\1063513\78205\EOT\SUB!\1015340\9700}\994954\&8z=F3Hg>&\EOT\USfx\1078008\998032ev\t\17415^p\ESC\41380=1de]\988835zK\ETXt\168935\EM_\133793\SI\128297A\GS"
    }
