{-# LANGUAGE OverloadedLists #-}

-- This file is part of the Wire Server implementation.
--
-- Copyright (C) 2022 Wire Swiss GmbH <opensource@wire.com>
--
-- This program is free software: you can redistribute it and/or modify it under
-- the terms of the GNU Affero General Public License as published by the Free
-- Software Foundation, either version 3 of the License, or (at your option) any
-- later version.
--
-- This program is distributed in the hope that it will be useful, but WITHOUT
-- ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
-- FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
-- details.
--
-- You should have received a copy of the GNU Affero General Public License along
-- with this program. If not, see <https://www.gnu.org/licenses/>.

module Test.Wire.API.Golden.Generated.NewLegalHoldClient_team where

import Wire.API.Team.LegalHold.External (NewLegalHoldClient (..))
import Wire.API.User.Client.Prekey (Prekey (Prekey, prekeyId, prekeyKey), PrekeyId (PrekeyId, keyId), lastPrekey)

testObject_NewLegalHoldClient_team_1 :: NewLegalHoldClient
testObject_NewLegalHoldClient_team_1 =
  NewLegalHoldClient {newLegalHoldClientPrekeys = [], newLegalHoldClientLastKey = lastPrekey "|\62431)\165170"}

testObject_NewLegalHoldClient_team_2 :: NewLegalHoldClient
testObject_NewLegalHoldClient_team_2 =
  NewLegalHoldClient
    { newLegalHoldClientPrekeys =
        [ Prekey {prekeyId = PrekeyId {keyId = 2}, prekeyKey = ",5!"},
          Prekey {prekeyId = PrekeyId {keyId = 1}, prekeyKey = "0<\1030053"}
        ],
      newLegalHoldClientLastKey = lastPrekey "\1104977\DLE\1065349\6667\&9,\1015715tft\FS"
    }

testObject_NewLegalHoldClient_team_3 :: NewLegalHoldClient
testObject_NewLegalHoldClient_team_3 =
  NewLegalHoldClient
    { newLegalHoldClientPrekeys = [],
      newLegalHoldClientLastKey = lastPrekey "\1008655\45238b}-ql\EMLL[\37930U:g"
    }

testObject_NewLegalHoldClient_team_4 :: NewLegalHoldClient
testObject_NewLegalHoldClient_team_4 =
  NewLegalHoldClient
    { newLegalHoldClientPrekeys = [Prekey {prekeyId = PrekeyId {keyId = 5}, prekeyKey = "tp"}],
      newLegalHoldClientLastKey = lastPrekey "u%vZ\DC3\1088709D\173228\ENQ\"\188001"
    }

testObject_NewLegalHoldClient_team_5 :: NewLegalHoldClient
testObject_NewLegalHoldClient_team_5 =
  NewLegalHoldClient
    { newLegalHoldClientPrekeys =
        [ Prekey {prekeyId = PrekeyId {keyId = 2}, prekeyKey = "Y"},
          Prekey {prekeyId = PrekeyId {keyId = 1}, prekeyKey = "n"}
        ],
      newLegalHoldClientLastKey = lastPrekey "\\\1028142c\128341\&1\182736jO\CAN}T\58009D"
    }

testObject_NewLegalHoldClient_team_6 :: NewLegalHoldClient
testObject_NewLegalHoldClient_team_6 =
  NewLegalHoldClient {newLegalHoldClientPrekeys = [], newLegalHoldClientLastKey = lastPrekey "n/\1080481b<"}

testObject_NewLegalHoldClient_team_7 :: NewLegalHoldClient
testObject_NewLegalHoldClient_team_7 =
  NewLegalHoldClient
    { newLegalHoldClientPrekeys =
        [ Prekey {prekeyId = PrekeyId {keyId = 0}, prekeyKey = ""},
          Prekey {prekeyId = PrekeyId {keyId = 1}, prekeyKey = ""},
          Prekey {prekeyId = PrekeyId {keyId = 0}, prekeyKey = ""},
          Prekey {prekeyId = PrekeyId {keyId = 1}, prekeyKey = ""},
          Prekey {prekeyId = PrekeyId {keyId = 1}, prekeyKey = ""},
          Prekey {prekeyId = PrekeyId {keyId = 0}, prekeyKey = ""},
          Prekey {prekeyId = PrekeyId {keyId = 1}, prekeyKey = ""},
          Prekey {prekeyId = PrekeyId {keyId = 0}, prekeyKey = ""},
          Prekey {prekeyId = PrekeyId {keyId = 1}, prekeyKey = ""},
          Prekey {prekeyId = PrekeyId {keyId = 1}, prekeyKey = ""},
          Prekey {prekeyId = PrekeyId {keyId = 0}, prekeyKey = ""}
        ],
      newLegalHoldClientLastKey = lastPrekey ""
    }

testObject_NewLegalHoldClient_team_8 :: NewLegalHoldClient
testObject_NewLegalHoldClient_team_8 =
  NewLegalHoldClient {newLegalHoldClientPrekeys = [], newLegalHoldClientLastKey = lastPrekey "%\EOT\139980"}

testObject_NewLegalHoldClient_team_9 :: NewLegalHoldClient
testObject_NewLegalHoldClient_team_9 =
  NewLegalHoldClient
    { newLegalHoldClientPrekeys =
        [ Prekey {prekeyId = PrekeyId {keyId = 1}, prekeyKey = ""},
          Prekey {prekeyId = PrekeyId {keyId = 0}, prekeyKey = "\1027435"},
          Prekey {prekeyId = PrekeyId {keyId = 1}, prekeyKey = ""},
          Prekey {prekeyId = PrekeyId {keyId = 0}, prekeyKey = "}"},
          Prekey {prekeyId = PrekeyId {keyId = 1}, prekeyKey = ""},
          Prekey {prekeyId = PrekeyId {keyId = 1}, prekeyKey = ""}
        ],
      newLegalHoldClientLastKey = lastPrekey "y<Q\NULKE\DC1M\158699f"
    }

testObject_NewLegalHoldClient_team_10 :: NewLegalHoldClient
testObject_NewLegalHoldClient_team_10 =
  NewLegalHoldClient
    { newLegalHoldClientPrekeys =
        [ Prekey {prekeyId = PrekeyId {keyId = 0}, prekeyKey = "\73057`"},
          Prekey {prekeyId = PrekeyId {keyId = 1}, prekeyKey = "&"},
          Prekey {prekeyId = PrekeyId {keyId = 0}, prekeyKey = ""}
        ],
      newLegalHoldClientLastKey = lastPrekey "I!6<\\\DLE\17074\158352V\DC3"
    }

testObject_NewLegalHoldClient_team_11 :: NewLegalHoldClient
testObject_NewLegalHoldClient_team_11 =
  NewLegalHoldClient {newLegalHoldClientPrekeys = [], newLegalHoldClientLastKey = lastPrekey "2\1065191"}

testObject_NewLegalHoldClient_team_12 :: NewLegalHoldClient
testObject_NewLegalHoldClient_team_12 =
  NewLegalHoldClient
    { newLegalHoldClientPrekeys =
        [ Prekey {prekeyId = PrekeyId {keyId = 0}, prekeyKey = ""},
          Prekey {prekeyId = PrekeyId {keyId = 1}, prekeyKey = ""},
          Prekey {prekeyId = PrekeyId {keyId = 1}, prekeyKey = ""},
          Prekey {prekeyId = PrekeyId {keyId = 1}, prekeyKey = ""},
          Prekey {prekeyId = PrekeyId {keyId = 1}, prekeyKey = ""},
          Prekey {prekeyId = PrekeyId {keyId = 1}, prekeyKey = ""},
          Prekey {prekeyId = PrekeyId {keyId = 1}, prekeyKey = ""},
          Prekey {prekeyId = PrekeyId {keyId = 0}, prekeyKey = ""}
        ],
      newLegalHoldClientLastKey = lastPrekey "&G\DC4\1061504{\1086332wOPM\37946\DC3wx"
    }

testObject_NewLegalHoldClient_team_13 :: NewLegalHoldClient
testObject_NewLegalHoldClient_team_13 =
  NewLegalHoldClient
    { newLegalHoldClientPrekeys =
        [ Prekey {prekeyId = PrekeyId {keyId = 1}, prekeyKey = ""},
          Prekey {prekeyId = PrekeyId {keyId = 1}, prekeyKey = ""},
          Prekey {prekeyId = PrekeyId {keyId = 0}, prekeyKey = ""},
          Prekey {prekeyId = PrekeyId {keyId = 0}, prekeyKey = ""},
          Prekey {prekeyId = PrekeyId {keyId = 1}, prekeyKey = "\SO"},
          Prekey {prekeyId = PrekeyId {keyId = 0}, prekeyKey = ""},
          Prekey {prekeyId = PrekeyId {keyId = 0}, prekeyKey = ""}
        ],
      newLegalHoldClientLastKey = lastPrekey "!"
    }

testObject_NewLegalHoldClient_team_14 :: NewLegalHoldClient
testObject_NewLegalHoldClient_team_14 =
  NewLegalHoldClient
    { newLegalHoldClientPrekeys = [Prekey {prekeyId = PrekeyId {keyId = 0}, prekeyKey = "+4\"'G\69426S"}],
      newLegalHoldClientLastKey = lastPrekey "4\GS\1054356\DC3\DC1#^\NAK\r"
    }

testObject_NewLegalHoldClient_team_15 :: NewLegalHoldClient
testObject_NewLegalHoldClient_team_15 =
  NewLegalHoldClient
    { newLegalHoldClientPrekeys =
        [ Prekey {prekeyId = PrekeyId {keyId = 1}, prekeyKey = ""},
          Prekey {prekeyId = PrekeyId {keyId = 0}, prekeyKey = ""},
          Prekey {prekeyId = PrekeyId {keyId = 1}, prekeyKey = ""},
          Prekey {prekeyId = PrekeyId {keyId = 1}, prekeyKey = ""},
          Prekey {prekeyId = PrekeyId {keyId = 1}, prekeyKey = ""},
          Prekey {prekeyId = PrekeyId {keyId = 0}, prekeyKey = ""},
          Prekey {prekeyId = PrekeyId {keyId = 1}, prekeyKey = ""},
          Prekey {prekeyId = PrekeyId {keyId = 0}, prekeyKey = ""}
        ],
      newLegalHoldClientLastKey = lastPrekey "\1003553mQ\r`"
    }

testObject_NewLegalHoldClient_team_16 :: NewLegalHoldClient
testObject_NewLegalHoldClient_team_16 =
  NewLegalHoldClient
    { newLegalHoldClientPrekeys =
        [ Prekey {prekeyId = PrekeyId {keyId = 0}, prekeyKey = "{-\99849"},
          Prekey {prekeyId = PrekeyId {keyId = 2}, prekeyKey = "N"}
        ],
      newLegalHoldClientLastKey = lastPrekey "'|\US\DC3\SI/`-\DC4\EOT\fo\ap"
    }

testObject_NewLegalHoldClient_team_17 :: NewLegalHoldClient
testObject_NewLegalHoldClient_team_17 =
  NewLegalHoldClient
    { newLegalHoldClientPrekeys =
        [ Prekey {prekeyId = PrekeyId {keyId = 1}, prekeyKey = ""},
          Prekey {prekeyId = PrekeyId {keyId = 1}, prekeyKey = ""},
          Prekey {prekeyId = PrekeyId {keyId = 1}, prekeyKey = "\150965"},
          Prekey {prekeyId = PrekeyId {keyId = 0}, prekeyKey = ""}
        ],
      newLegalHoldClientLastKey = lastPrekey "\164807p\24685\&4"
    }

testObject_NewLegalHoldClient_team_18 :: NewLegalHoldClient
testObject_NewLegalHoldClient_team_18 =
  NewLegalHoldClient
    { newLegalHoldClientPrekeys =
        [ Prekey {prekeyId = PrekeyId {keyId = 1}, prekeyKey = ""},
          Prekey {prekeyId = PrekeyId {keyId = 0}, prekeyKey = ""},
          Prekey {prekeyId = PrekeyId {keyId = 1}, prekeyKey = ""},
          Prekey {prekeyId = PrekeyId {keyId = 1}, prekeyKey = ""},
          Prekey {prekeyId = PrekeyId {keyId = 0}, prekeyKey = ""},
          Prekey {prekeyId = PrekeyId {keyId = 0}, prekeyKey = ""},
          Prekey {prekeyId = PrekeyId {keyId = 0}, prekeyKey = ""},
          Prekey {prekeyId = PrekeyId {keyId = 0}, prekeyKey = ""},
          Prekey {prekeyId = PrekeyId {keyId = 0}, prekeyKey = ""},
          Prekey {prekeyId = PrekeyId {keyId = 0}, prekeyKey = ""},
          Prekey {prekeyId = PrekeyId {keyId = 1}, prekeyKey = ""}
        ],
      newLegalHoldClientLastKey = lastPrekey "<\SUB\188332mp\1028288UI\t\DELq~\ESC"
    }

testObject_NewLegalHoldClient_team_19 :: NewLegalHoldClient
testObject_NewLegalHoldClient_team_19 =
  NewLegalHoldClient
    { newLegalHoldClientPrekeys =
        [ Prekey {prekeyId = PrekeyId {keyId = 0}, prekeyKey = "f"},
          Prekey {prekeyId = PrekeyId {keyId = 1}, prekeyKey = "w"},
          Prekey {prekeyId = PrekeyId {keyId = 1}, prekeyKey = "H"},
          Prekey {prekeyId = PrekeyId {keyId = 0}, prekeyKey = ""},
          Prekey {prekeyId = PrekeyId {keyId = 0}, prekeyKey = "_"},
          Prekey {prekeyId = PrekeyId {keyId = 0}, prekeyKey = ""}
        ],
      newLegalHoldClientLastKey = lastPrekey "\96658\1086778z\DC2\EOT"
    }

testObject_NewLegalHoldClient_team_20 :: NewLegalHoldClient
testObject_NewLegalHoldClient_team_20 =
  NewLegalHoldClient
    { newLegalHoldClientPrekeys = [Prekey {prekeyId = PrekeyId {keyId = 6}, prekeyKey = "{\992138\1098288\SOH.f"}],
      newLegalHoldClientLastKey = lastPrekey "\f\1075762_~b\SYNyh\\z-<"
    }
