-- This file is part of the Wire Server implementation.
--
-- Copyright (C) 2022 Wire Swiss GmbH <opensource@wire.com>
--
-- This program is free software: you can redistribute it and/or modify it under
-- the terms of the GNU Affero General Public License as published by the Free
-- Software Foundation, either version 3 of the License, or (at your option) any
-- later version.
--
-- This program is distributed in the hope that it will be useful, but WITHOUT
-- ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
-- FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
-- details.
--
-- You should have received a copy of the GNU Affero General Public License along
-- with this program. If not, see <https://www.gnu.org/licenses/>.

module Test.Wire.API.Golden.Generated.DeleteService_provider where

import Data.Misc (plainTextPassword6Unsafe)
import Wire.API.Provider.Service (DeleteService (..))

testObject_DeleteService_provider_1 :: DeleteService
testObject_DeleteService_provider_1 =
  DeleteService
    { deleteServicePassword =
        plainTextPassword6Unsafe
          "\1060280\FS$\30718\9055\&4y\a\SO\1022285{H\24156\10884Xw/\1067721k?QwB%\190845I6\146604jYG\NAK\16926\SO<\1023504V\1109820/\181734\&3\NAK\1017784\t\DC3H:\v\1086294B~\189775(K\994571s\160490f3A|\141497\bC0\EOT=\134504:\GSJb@m]\158402\EOT\991757lP(=wp8N[V\b\74475j\1007810\1052640y\CAN\ETB\US:\SI\DC1;$,\1010096.\990495fs\ACK:\988982D:\SO\a\149288\n\180825H(\SYNP\167091Au\DC1Q\DEL\SOH["
    }

testObject_DeleteService_provider_2 :: DeleteService
testObject_DeleteService_provider_2 =
  DeleteService
    { deleteServicePassword =
        plainTextPassword6Unsafe
          "\"\1035785\b\7312F-V\28444DL=n\134671\146884m\34806Qr\1031969Y\NUL\1097357[\\\ETB\10421G4\65714\1036135\&4QL=#h\NAK9\3898\1060396R/N\NUL\STX=\1062953\ESCag@:\190798l\1076936\&6zz\174118+\EM]\DC4\1040887\59430\49771\SI.&n\987923\EM\1068546x\162532\ETXM\b@\1017255\f\DC28+8.\1080191\179514O!4\DC2GXD\1093047\1021167\NAK<\14616\n\151737\23416\1096116\SUBqBSA\1026281't\59177*\CANov\152408\CAN\1080069%\DC4\SOHcv0t\SO\\\t\1017225\ENQS;\SYN)\1056533\DC3/\r\186936\37752\16318.\1075780\1110290\38602\78116\\%H\983850g* Sq\SOH\32503\NULR\DC1F1Sai\137919\53440\ACKdh*\144627\67155\ETB-\1049034iM\v,r\EOT\55142\NUL'F\183574e\ENQ\f.N\1091624\&1~\41219E_F\ENQ`\21386^%1\131822~xz\ESC,*0{\\;L,5e(\1059792(~\DLEE\60512\"&\1013137a\5457>g\DLE\36252\DC4\984848\DC4N\US\1107596e%e\31671Wj*/Xd\1107774X+\NUL\NULi\SO\nyl\1106773\983090Tt\54445\179129zO\DEL9@\DC3\STX\SOH?*Z\ETX\1123>`\ETB\1084869GW\SOH\vZv\SO\991538.a_\FSP\b\18597\143860\34448AMq\b|JSh.6\1072749\&2\29972\39815o\184644\52955/T;>g%\RS?_[h'\66707~\1075477\1104377`E6o\NUL\1035887\44786\RS\GS'\1056127|\18783\152960d@\1050621UG\985068c\DC1\139084\154956.TQ\1048778\b\CAN\DC2zE\1024549V\129551\1100529\74753\ETX;\ESC\1057712Yl\1018818u\166935\36297\1109093\141493ZO#\r\t\NAK\179138\USh\n\984366O\140762\142254\168039a.K\DC2\142191Gy\154465<\158304+D\1018755a\180376q\ESC\t\1052272\1001618\121095R\a\15159$<e^\1036144\STX\2314\94970)\SI\bH\\8gp\159802\DC1\DC17\38593?\994112'\DLE\50735P\143627.\DC4yi/\DEL\CAN\57964\161743\995137'\1010451\&2L\CAN\"'O<3d\ETX\163384\164606\183848\10503\172847TRrZ;\181649 2vt\EM\55042\1019841d\139167E\SUBa\DC1\33773\1097934\\]\96105\1059367\SO\SUB~\CAN\DC3~\v=\994561\1083583\1069628\21747\NUL\1060504,i\ENQ\DC1"
    }

testObject_DeleteService_provider_3 :: DeleteService
testObject_DeleteService_provider_3 =
  DeleteService
    { deleteServicePassword =
        plainTextPassword6Unsafe
          "\127150\1013542\1022226Q\1096100\1110241\132333?\179352\1022364\170877n\SUB,U@U^W%\13459q\DC4vwX?uYF=\SOHa\SOZ\143538@\NUL\ESC4\1051737m`Y\135888XhGa\9480*\30339s-\97658\176772j\CAN\USO\986333M!\185433\SO\153011\as\149545#!1\CANOU$p\STX\152425\68464\983212\ETB4,\1048538\9601%Z\148014<\DC4\152446bTl3\1068308\ENQ\DEL\FSb\1010212qw\43166Q#\"\DC3o#i\ESC\NUL\194612\n4o(G\31273\59720Rfm\144134]2\119070\&5-|\162339I\"@V\1082984\44410r\ETBD\DC2mp\1017110~DZ`ID\61849\&8N|-{\v\nC\1061502Av\1052399\b!ZG_\160220\1019209\&0=\1059092$+h\158551\1099624\ENQUs\USv7\166962=\16509\1024091^;1\ACK\DC2j\ETX\35349&[cXzz\DC4HcI\96453nMg\"\1054376\&2t%*\97531R\1005025cEX%6\8268\1069602=^\ETXi'\DLE67a2EH+\RS\DLE]l\1050200a!\USeT6j\RS\t\\\142099 \1078660,D\95513x\DEL\DC3\166840ME12u\47860\183061\b9\aWc\GSv|\23925A>%R LRT:jH\62211\DC3d\1022968\bR\152452*t| 3\ENQk\18884\1046962\&4%{\ENQs\SO8x\RSkw\996530V+O\ENQmT)Y/$Q\59511&?\1005279\&4EZ\983385~\1085280$U7H\1002122}e\1070772i\51290\1019872D!C\NAK\n!\FSE;V\1107110bj\NAK\1061098_\DC1\SOk\1058268),H0PE\152123r;+*l\985176\&1w`\DC2\64347\SYN$vR\1096368*ij52\151566\1046919D;e\1092443E\51993\DC2B9\1087497k\36419z(KTc=f)\43746\1106998\SUBc\DLE\989733itu\170967{k\1037793\14705\180217 G%\NUL(\1035152e\1030842|*mU<7w7\993260O\DEL\NAKvd\14637\69389\1094203&\1110919F\NAKg\1040202\992282\DC2cI\SI_\n\SI\993477H\137225\95199\1017269?\1075780\1085076G\1022476\r\SYN\168876\DC2\b\\m^\1053642\&5uh?N*\DC2\1084667|/\173546\17888U\ETXI\174769\f\1028908\EOT0\188238#vQC\fv\SUBS9\1044569\&4\1088016\1074352c\NAK\993004\&4-6M\137104s2\EOT6\SOH\DLE!\tShpJT9\1043618\1078275\163874~G%\147280K\FS\US\nH\EMc_\CAN\1087805ty\48054\"(\996357Jal\48065w,Q\26254MM\135033\1048832\78030\ENQ\135666\&8!\35782\t\34344\7132;-<\39833\2650S[\1066982\1022614\1024833vF.\SYN\1040678wu\SOcNpEY\1105650q\DC1;\a<\ETB\b\1094990\1048314D:\1018980^B=\b\177470T\1083410|a\1056080LK\DLE\DC32)h\vi\98283\DC4e\EOT_\ff\175617_W\nM8_B6\1017235^\52537lN\1102453Q \95310\1003587\13893^>\DEL\1006142`\998340\1107872\54544T\13283:\\\ty\FS\188230\NAK9\DC4W40\DC38?\CANhOX9\SYN\162545}\DC3\"\176375\1090658\95340`-5!\NUL&\988094R.\f\8339\DC3-g\a\ETB\n\37512\119835\DC1\ESC\1009823}\1046441Ke\179036\&6Ma\SI>\1081261\r,b^`:\1069901Un\990762\148377\13503}h4\25577\1108679H-\n0P{\153394\f\1114021\f7\fe\64438\60791\161330B/V0\1058234)\51833\DC4,v\160202U\DC4i\194755_>\SO@8?D\1029214=\n\182111\DLEo\1110681\DLE\1054551\146791\&2\DC3);K\NULo\ESC\DC2,\CANXX]9\162319\&6K'b\989499/\165610\989186\33910\&7F06\1084196b(L\GS\1050134\&3{[\1108824.N\v\1109096\nGb>X"
    }

testObject_DeleteService_provider_4 :: DeleteService
testObject_DeleteService_provider_4 =
  DeleteService
    { deleteServicePassword =
        plainTextPassword6Unsafe
          "L2\"V\6753r3\21384F\1004100\ETB?\US\1022278\23420@\1034750\&4\nzp\"\ETX\CAN\1020846\SIz\1052126J\12165\1025906)\STXa4\27812\1000964j\6260\157933\1070050\&1G7\96926\USO\1110814\SOH\50833\26545\&2@,.io\1075695\&0\27267\&9?;5M;n\1098431\EOTS\STXLNQ\\\SYN\"Z/z\SUB[Dw\180898\341\111115\&7\1009591X\32939\1096608I\a^\tT|\DC1k\DC2x5\10464\170244\ESC[s'3\63609\&5HC\1950N\148830F\1029548\1059110u\DC3\ESCh0\NAKVY@\DC2\DC4\985223\DC3\62363\&3\DC1'vA\SYN.*2llS\97030J6\1098113P(\1069570\1055988\52837wg\b{\156428s+J\129477\1067080\998577_\133791\DC4{\ETX\ENQRx7v\1033468iS\v\GSYv|\1006295mY\49707\DC4A\ENQ`XJ\DC1TM\1039522\CANi\STX_\3143!\DC4>UW\"_I\f\FS\998242,w\136697\1024216<\992580if\ETX\SOH\SOH#\62779X_\DC1\CANg?\1023357\&2\1010176\DC4\139562\&2\EOT\145727I\1047364P\ACK\164378\24874e\ENQ\96920\174821*\63977'3\DC1\DC1v\12684\&3\n,>m\SOHw?zqp\STXQoGf\t[g\1001958\ESC\1062317r$\EOT{D\1029860\&0`\188502\140808\1102082\EOTU\986732\140410a\CANo\173950k@5s\1113153o\1055827\49856+S\STXn@I.%\148298\n\1101092\DC4 \1056737p'\128936YcN\SO\60490l@\1036155\&9?\42343A\NULat\1109075\EM9\1113569\f#d\STXPP ^6&?\11000_\61012\ENQ*M#\36501R\25749p\SI\154166K<}t:P\984299\ENQ\n=\1035698\"v=@H_\SI(\DC1PV[\57739{0\140392\a\"K\vXD\144064\66295LRB{+\9504:l\1102414r`\1113738\&4Zh:\EM\128474?\1058326*\1090019Y|]\174030\EM\1036213\SOH\183356#\1000903\1035926\&5Vz\DEL\SUB\SYN'ZX!1\43994\&1yc\DC3p 0\1068860\1085354[o,2\1091212IVq\ENQ\983215\SYN+,\f\59521Tqx2|jc\f\b*.C\STX9c+\7769\21087\EMV\160699\1110293\24375p@\144691\1096790\136541]u\RS7M\ETB\SOHu6\155675r!X\67180\EOT\nx\ENQt\ACK\1072004\ACKEG\SO\USb\DC3\10246\&7.g!c[y\SI\1077060Q\993055%\ETX(\135156AX\STXlH<xX\NAK\ETB\FS[2\ENQ'GtP\ESCM\SYN\ETB-V%_\68758mOe%L\DC1ozF\SYN\1073768\nD^\8692\21313\ETB5/\SI/p\1015864B^:<\1081590R\142694\tf<\DLE&=*AD\"UU_\SYNp\1000109-\154599lOC\144896\62381\NUL\127300\137063\CANsq.\10293\165885=:\ACK\\\146922\11602\EM\1104585t!\n*\59459<\999678\179022oi\DC2\SUB\165840\DC3\USg\USA\1027540G]\DC4\ACKO\NUL\26882f\EM\151702*s[\1112442\&9\GS\1061261\ACKN*y\NUL%\1030194\83326=wp<Q\1013757hY\DLE\1091511,?pM\1069363\SOH\af\1071525\62088r2\NAK>P@Yf\DC4\NAKzjs\SI\v\SO\1085889\NAK\9804L(/]k\1051473b}\1017916?\179327\1075800}W\USG~\128139N_2\25917q?*^MQNL\\\ESC\FS \163401I,\1110667\DC2i\32846\1105436[\ETX\177036cOam\1009736\bD\50866\110872\r\RS \tr\985779\69978&t\1050041P#1@N\1040570_\1042320\1102184\1085170\39341\v\RS%\t^\993553\SUB{\GS5!NP\nC\35824\SUB\1067488\1050717s41\181692F\134397VOb\DELHV\aj('5hkr\1095355L\151305N\1094082\&5\172446\NUL\DC3\1007647\161512U1\983204nS3\DC4jf\1030456\43037i\17090\1080707&A\1004875\r\DLED*GJ^eH\30653\1101701(_~v\b\1085954\US\DC2\n\182353A O\DC4#H\a\83302mx\74596Hq\t\n<1n\\>U~gcqCErC@#\131787HyEr\nHF\EOTN\165554qR\DC26u\1052388bn\DC2%G\v\b1\96521\&6g\EMp\170871i\32661\&0*hL8\SI\n\180656Mpms"
    }

testObject_DeleteService_provider_5 :: DeleteService
testObject_DeleteService_provider_5 =
  DeleteService
    { deleteServicePassword =
        plainTextPassword6Unsafe
          "\t\172857\42813C\CAN\GS\161736\a' h\ESCN$\bE\DC4*F/[\r\6924y\ESC\GS\1057486\vF!<bh\83114Lmk\f\1031004$eW\144531-f\NAK\b;\1033771}q\RSK\19515ZJ\b\986288G1\r\GS\31891M8#\43564\172173_\38827\33261,K\141710\95905ki\GS[\STX\1070615\1067753zuM\GS.\FS\69716YZUs\DC13\187102\t\139162,|8pp\a~\ENQ\FS\SUB9\1014557\1018229&W\1085532\190154\ACK$\DELdN@~\1063129t9r!\DC1Z\NAK-\1009576\139565\186393M\1022187!\STX\1004852\"c_Lm\62893T'\1109307BO}eI={\CAN\SI\DC1\FS\1037746ld\ENQY6\176938\993527\1004885)=0)\157622\1047155UqzKiQ>r]\"\10020r$\1083003-\1108025\ACK\168132p\SIc\1013251\EM8\DC4\NULq=\NAK`U/\RS{e)\DC4\DC3\74597\186929U\ETB\1088221J\ESC\fh\991495K5`s(<:\EM\f\ENQSE\1104616\&8A\1083480Kmh\EM\\\1036835B\NAK\1099687K\26605\988753lBp'J_%\128829\48697\1054594G\DC2n;pt\SI\SUB+i1\EOT_\142578\1004730aR{\1049051\CAN\vV\31101jmy8\STX'\140278\&5i@+u\1086394\1004758\996051\EOT-\1070519\163184A],J(L\ETX\165645r5\39997F\20971gN\r\GS\1096859\ETB~\voX\NAK\DLE\1057183N$\"2 %xsk\DC3\997612\141019+cmN\SYNr\983491\NAK\ETB\SYN\DLE\ETBCt\1036568\1080751\ENQo:\123596LL/\ETX\bJGqv4\\\25512MAt`>G wFML6d=\146826\EOT}|\GS1\DLE\EOTi\DC4\n\r\138718n\72975i[Z5d\STXx<x\119979!\DC1LQ\1028895Ap>]\GS><\60749\32184\78324bx[\"p,xeLS\1038078\190378\DLEd\vxote\168399,\187447\f\18411>B\DC2\1036527\CAN\44361k\SIG([w,\1102557#P3.7!3Wr\v\rM2;g>%\50923Q\1045600`uy=*\1081173\ETXyo\SYN]\190840wJd]/d\151668*`\1084306D\DELZ\1027879}H=5\NAKG%K"
    }

testObject_DeleteService_provider_6 :: DeleteService
testObject_DeleteService_provider_6 =
  DeleteService
    { deleteServicePassword =
        plainTextPassword6Unsafe
          "\128376EhL|Lu\23379\1080483H_~K\8066*\tX\1035800\STX\DC1]z);.\SIG\ACKBV\1102139\1082533 \120015:0\157693\162521]\ESCu(\v\1014410\1023814\1012657w\14968~U\"\EMf\166514q]l-)BSsx\18821H0\145814g\v] \1045056\n\NULA\997958\132031$\20514&e\DC4\DC2c*s\149852\1045753\32216\&9+\1072506-\22880\186724q<\EOT@\1046997\95854\GS\SOHw\10768C\t\DC4R\1015074|\1013866\988177z#]9.\1090164*\736\a6\985230g\DC3*\SOH\SOHr\ETX`\992329t5-R\46692o\34976mW\DELC\NAKs}.%W\SYN'GA\NAK\DC3]-Jj=,V\186648s\1075877\137116g\38327D\1025836\10179H7\68640\DC4\"\150298ST.\35152\994016\CAN\135344\a\DC3\f\1067223@\CANJ0\v\t\SOK\61106`?\DEL\95854\50324P|\GS\CANrE\992378la\1082907GWLq\ETXmc\1081729sM@R0h\ETXB\1036016\SOH]'\158367\DC1*N\1080973T\998376\92956\DC2d\1038903\RS\188257\1060904\993321\1044087\&5Z\STX$e\1103845O)0/\44061~\DC3\DC3Hd\998585Yt6Wo94\1036192\147855A\US%&\68303\FS\1052800\1081644_|w)\1109140\RS\162501\NUL$?AHR\19420\f\bPl\DC3\54563\DC4\33018*\186381\SOH\NULf\DEL\DC3v73W\1107996\83019\1045844N.\ESC=\180831Ptu\SUB#(f;Wm\7415\\0d\1095311\EOT1a'O[\71125z8|;S\STXP\62324I%\60473z/`\182696PF<=x!@\SOH\EOT\DC4\bY\v_/\a@Y fLE/aC\60167_w\1018128\SUB\CANf\135056`I\SOH\1055086A\tt\132582\27088GO\FSl+\DC3\1011310r\59704\GS\6624%mbT\55138\ENQG &j\1057843\td{\161063Z\1055111D[1\96530=n\169420b\20176\998614{\RS\1005601\"\39342\1027237?DV\61675\v(P\1097380\SO\181027\27659\20728pR/\1078103j\96346y\53377\164734\r3\ETX\39384j\50759k\DC3\1040693/\1104301\SI\NAKx\44875^\177769\1080050\&2Sk&evu\101060\187206^N)@H\GS\1079756\bA\DC3W\1013638\EM\1041225T7D\95543^\\6\NUL\SUBw\1057725b\1016188*\1043975\1014298a\RS\1012013p\SOHd\NAK[&\1103345T\98112\"Q\60620\33674\FS$\US~\SI(\1073485Ko\RS \1012751\EMF]V\170752CF\fP<bHv\185217\DC2\DLE\ESC\ESC\EOTDs1wdW\1063055\DEL\ESC\\=\178113\1020816XF\98855\NAK_h5>\SOHQ\NUL!\DLEH\1087861\SYN#\EOTq^\993604\151199\1038802.\988853E?B9\ESC\f\ACKKF\162140\164353\SOH\146902"
    }

testObject_DeleteService_provider_7 :: DeleteService
testObject_DeleteService_provider_7 =
  DeleteService
    { deleteServicePassword =
        plainTextPassword6Unsafe
          "\136983\ESC<Rm'23hO`\n\987322\1093702xpmV\SO?\1092623\18686A\NAK<:\EMXdz\1109102\DC1\"?#`M4.\195036\n\59998\178351\&3,C\54393\DC4afb\19553\171149@c,ro$Ci\SIk\"\1030247\&80v=c*@\53085\167703tT6\191422\169504|s \SIy\985230):)\27936Q\67269\1084029k\ETXW\170274\1061889\1056352=81K\21711\v?bzd=1{\1044647\SUB,\NAKV\vG\70123\1088726\170082,aIlYNu\NUL\"\54232}c\DLE\140848\&5}W\ETX\ENQ\STX~RP\b\v\1109614\121093\&5\ESC\td\1106929\ETBA)v~#\1056688\1017653\DC4W\RS\ESCM\FS\1046194\128611<Q\1047481\656'\1061244\1065109\a?\155090\&8p#\a\989346\154520Z\140079\43127\183035b\1005631f\1004425\ETB\5853:\1017015C\EOT\ACK\a\42274#'\1001194\165548L\GS\19615YM@4N\68015\&6:]?x%?\149231\1104999\&7j\40547\142129X\165166\39089\DC3\NAKG>QE\1031569\DC1m\DC2\SOH@I#\fnJ\ETX\38914^\1113665\1018472\1082131N\1022796\182352\DC1TPq.!8\169378FqJzQf-.\10416\40128\&9s\64369GC\43913t\1030201\SOH\16112\1098240\&6\133919)\SOc\17130\985217\SOHUF\16066\ESCoZB\DC276Tw>UJ\n\FSn:0\144123\ACKY'*e-\1098900\59543Bj\150654SX\DC2\v\FSK\SOlXY-\1113154P\SYN\1032888x\1097596qf\48246w}\rc\165617im4)\1031691\&0T`/\1046585'\1041485\b`\ESCP\1090958#\vN\\\DLEZ$D6U3f'\36612\985822+\1047049\DC2\SYN\n\94587\atI<edqNb+\1021421mv0\11142\166437\1037304jUu\1005644\150376\1095341St4\DC1\63762xc\DLE\ENQOd\996106+\rF\SOHZ\1081473D\v\46063X/4B\184597}\SOHn\69739\b\CANp2\1055214@ve\1008739\95023\1006006zn\185268fh3UL\FS\6746\97640\FS<y\ETX+\1057581\EOTNpBW%Pz8D1Q\EOT\v\1027094ne\1042923LU8\1018903\&4\RSM\35098K\tO\v\ESC\\\1010903\DC4\1109177\SYN\US\SOH.u\1024710B\1072538\174725(x\136478\&31YQ:sF:Q\1029209\SOIi)S\23235\FS\1007065B!\STX0\RS\CANj"
    }

testObject_DeleteService_provider_8 :: DeleteService
testObject_DeleteService_provider_8 =
  DeleteService
    { deleteServicePassword =
        plainTextPassword6Unsafe
          "\1072013\DC1\DC2a\ETX\25200o\63527iZu\NAK\1074298{wUD~\1058989y5%\143622\133556\158448V}O3T2\a\DEL\ETB@)\SOH3q\1103168e$\179508hQ3D\SI\DC3^>c\1023477cr\NAK\32429l\r\182656\1026919\DC1'\SO9T.\ESC~\74564\165585\11714M\18761\13838\52007`\96738)L\158049a\24389\1011390\DC1{\50619\22441wu\DEL\GS:\DC3xhp-\SYN\161044d\NUL\DC3@4\1101155\"@0\1079248\GSr\\\1111460\DC3\27560K={Ae&uQy;u\1059410z~\1100715x2Y,{\1074143\GSoF?o\1082020\71318\DELSr\993616G\42927R\FS0?\1069779^)\SUB\1090952\71703\r\GS\ESC\998256\ENQ\a\vy\1021237\FS\\Pl?aM\SYN_3\t[\987821\&9IKG2kc^\99089g\"i\1085089\159329\t\181764a\1053641y&\SOE7\DC46>>\187064\25144~\t\DELy"
    }

testObject_DeleteService_provider_9 :: DeleteService
testObject_DeleteService_provider_9 =
  DeleteService
    { deleteServicePassword =
        plainTextPassword6Unsafe
          "[\r=\1010928\ESC\NAKPq\1091744_\29858\f\152928(\243\1089953\n\1086813[\SO(\DC26\171315\SOHR6\1070191\1059359T,\138258,\"\175571FJ\1063162\&3A\EM8\1003695=C-\1048718\&7\25307\NAK\144818\&2y]\182318\DC4C^1&H\1051688\&5DG\1100017hB\986897\1079098\CANE_.\1041564\"\ENQ\1049879\v(\EM\EM\1046376LROmrW\CANN+\SYN\1023612.WoZ\US\SOC$b\23372\DLE\129288A/x(j\1108387tO\174309K4SP\15428\NAK\ESC\1064811[I\NULC\127304\1081191[U\EM<&\45631\28921\27182B\RS_l&\3177&$/$F\148093\DLEUq+`\153269*i"
    }

testObject_DeleteService_provider_10 :: DeleteService
testObject_DeleteService_provider_10 =
  DeleteService
    { deleteServicePassword =
        plainTextPassword6Unsafe
          "\SI\162050\1010608[\1049535n\b\ENQiN<Z{&\988447X\20320\13472}$\NAKbQ}2';6lVS}je\1093913\1065572@\1003151S\46350MOU}'[\\K\1029658\DC4<\DC4BsQ\1055835G\t\ETB\1050351r\181317\&0\SO\141972v\CAN\57773\DC1 e\181853\t\137966\1112980e\30732t\ENQqc\1073558YaC<wi4\1094585N\1094955\"L`0\1043202s\CAN\1074603\ACK7\a F\1065819\ETBY\984268\SYNy{\1109683:=\DC2\63468_\12062fR\SYN=T\156297\25700|\96479|\n\1077812s\EOT\rl\FS&\1036976\134197\1097777\26621\1109080\997573\95555\1049522\tW G-\138376J\DC3\3763:b\1068068+<\SI\5855\ETXo\1083809\&4\1045078\nO\tX2\NAK)-\1057645\983167J\1032530Y\64728'\SYN=f\ETBd\1105635P*%#&\a\STX\ACK\DC4ld.-\ENQ\1027270:|f\28830eoA\162705\&1H\ETBd\1061139-\74150\175505aK\1001414?\160893\1110742WWzI\159498\t\36991]6W\SOH\18715\DC4*Rq\1101235\&8\1009396\141069\61050w\136052\1021359\&2D=\1013285S\ESC|'w\FSP\DC1|Al8tr4\1036143'\ACK\SYN\1076328\US<\DC1\EM<\36459\1091995J!\SI +\1098855X\142773\3559\US1\12628\nJ\RSd\24393b-%\DC4\984093)\DC1oNn\100857\1024801'@\DC1.B\998118-3\DC2;\1065985\23457z\tS=BT={j\EOT\US\US\7550\182780m=w`\48658x\12717(\144735\39694b\aFY\137586F&\1026910eQOE\\Z\1111014\195011\ETB\DC2m\SUB\ETX\1464b;#\1066258\1097094C(+\191375\134861\&8:\17681\1048985\1026422\&1\DELMGW\STXN\RS\1073562&Hk\175665T\CAN!\26188\1099137\DC1\USu(-JT\1075203E\25263$e1\46842\169395\US\\91n+\v\ad8pI\1100283\987158\&5\62294\DC2\984738\1060369ZW\29669DY|\1047022\14066;/\58281\170714\1006437$2\1067656q-\DC3M\70103N\US\167001\1093760\ETX\180590\&4S$TS\96144~\1011136\"v\t.\n!CG\t\f\52086\SYNa\f\17008k&\152833E\fZguaP%vR;\15596x\29388\1101917\EOT\1080888\180967aP\v\GSFC\1040891\DC2\985439d\GS\NUL\157016\r{\DC1\DLET7\RSu\n&]\986053;'i\1031756\&7\NUL\195022\DC1\1026276a9]p\DC49*$'tl1\10922\DC3\ACK\bj\27166\GS?\EOT3\1097840.T\144966GM\NUL\CAN\DELH )li\154647\100772Ym\ACKF\1437\&0t\RSyl\US\186261\&9*\US]D\SYNbVu\GS\63817h}<vf\995674WbWk\DC3\b\142714\92697\EM\185859\39569<4<oz.t\DLE$\1009776_\ETX7J\38614\&0WM\EMI\bB@>\NAK\US\NUL\SYN,\157238)Ac)]d\1008845\1006824Y\1022374\1082018FhaWXY\NUL\EOTbCK\49929\95708(7\1106169\1010949F\EOTxP9\FS\GS\1082851\NAK\1011817P\46197QJw\STX?\176946+Q\NUL\190459!x!~\155567\1048077\NULi,Q'<s9VG\DC3\1046189\&2\EOT\vP2XB\68820\146361\997414h\v\991211{\83177{P3\989931\RS\152659\DC3h\8415\NAKh\FS\1029531\EM@n>\5401h\1000486jp\1029658\ACK:Oq&v\DC4\1012006\&8\CAN\DLE+\ACK}\1038820\"5L7\1053147\1109810\74179\&7m\v\RS\161930\1075844\RSS\30116P\132230k\717\1040324\v\rBP\994309W*M63-J\157232\163200\&6RH\1026767'\FS'r\DELsf\DC48\DLET\")K\DLE\DC2X<}\1040651^\163594S:\1007149\158242UZ\1069548\EOTi\33002\158326_<f\16219\69730\DEL"
    }

testObject_DeleteService_provider_11 :: DeleteService
testObject_DeleteService_provider_11 =
  DeleteService
    { deleteServicePassword =
        plainTextPassword6Unsafe
          "\25901nR\1042755\1110476\SUB\ACKt3v+\f4W{/e\164138Hy\158053N\SYN\DC1%\158516oV{l7\12058\1057199S_gA\15534TmCiX\160366'\1087463\t{W\STXex\41528*R,;e\252\&1\1065052\162061Z<\bS@\ETBgp\DEL\NAK\1085556\ACK\139811S\176610\FS\13059`)@\35134\1106812\1060712Er\DC1\1046124 \995210\DLE%\118819\FSn\\ZUx\ACK\1097966\163791k\ESC]\RS\DC1\143355\20723A(\NAK\SUB\1014978zeK\US_$4\SUB5@F\159281\26729@*\nd\ETXU\1018489\EM1\997420\1079124\50586sS99*\99984\STXhH\1070682&Px@cn\1088759\EM\DC2\1046238Jcq\SUB44\1006586\NUL\1107136\vQ\DC38<z_}?\135504\&2U\53039\ENQ\1065183\1112874$Rwc\97125)\EOTab\NUL\138556W\175076=\ETB\169678Q&\136209<\"\SOHN_\rYylk\11815\EM\157072l\917944kX\\\127302C6\1086572M\b XtI\1089687\73024\ETX\62068]!C$\FS\SOa`\DC2\183009\1080452\7624\26801d4c\ENQ\NAKN\190635\DC1>\27737%\177997Kq\1003460%~\v\34758\58147T\GSps\1103527\&1\1011413\30309to\DC2t$\1017630I\170455|1D\170894\160641+\1103518+v7\STX~\5395\1004330Ju\EM\25814cx\"#E9w\166343ONY\1071128O1\121062p%t^\ETXNT\78812\v\f~\RS\SOH\SI\n'{\r\CAN\NAK\SOt\STX\68818@P\GS\1007512\USy9^U\ETB)mj:\1062680B^\1008595x+\RS5U\139534\98639\GS\180227\25236H\1060521$)wbin\188907\987276\ETX:5\1039916\ACK\ACK\986245\1048529hl'\tb?`%vC\"D1[\110860+\166283)PV\1044669Gh\"\19964\12043R>\1006662\DEL\180850\ENQA?\SOH\132636H\1108426$2\96437\1013325\DC3?mLdM\188499/%\DC2\FS[I8v\ACK\1061666U\67987$GrCg\SO\167134\1077919n4?r \ESC\1050882Tq\ETXu\1023983\ACK_|L\20449a\1094815vAaO\139479r=4\39568:p\1060300\a\1092447?\1110782q9\ETXE\SO\bK-\48132\SYN\48687\146156\&2\SOSj#\ACK\1083773l)%G\1078272K\156921R\8373\CAN\993378v\DC1\ACK\128360\1039196\EMo`6\b\31597v|WoQ3<\STX\97186o\986190\CAN\1088664\NAK`\FS6\SOHF\1063772[zXs\1044292$\171854\GSoH-|\ETB=B\1112836\52633\NAKox\DEL\73760q\ENQ\DLE\144879\176649\1093334\CAN\1049023\&4K\71172[Y\144809\SO\1076788f\"7\DC2Xj]s\SOHj\1088788\&7i\1111376b\10639\NUL=\RS\23060\997561\191212A0\DC1N\STX\ETX\SO\128338[\39744OU\SOH^x\1032678J@F~`n;\57681i\RS\SUB)jI\EOT^\73047Y\aM\13358\22601\100792\51350\"o\1077272R\\\DEL\178673\49995'&\EOTUtq\140882.I\156694t\41032\17600cBk?\"4}\1058055\1113533'\n\1018860\12101\NULa,\1094524'Jl\1062808\nS:<\GS\1064267t\ENQ)5ow\1055684\1089983\ACK\163808\&6\16512{%5\1095796^\1024905\1066253$\GS\DC1`W\r\31878\ftiT\SO\1071558\&1E;Zd\fx\1037175\DC2\121349\128283\NUL\992725\SO)\1055782D\992230"
    }

testObject_DeleteService_provider_12 :: DeleteService
testObject_DeleteService_provider_12 =
  DeleteService
    { deleteServicePassword =
        plainTextPassword6Unsafe
          "hW; ''\v)Eou>D.9b\26680\1057700\t\CANTe\NULRQT@\1002782\t\ESCNaY\186493\152332\NUL\1075769~h\150526\1097365\1021739\96557CNA,(b\DC22PB`Xe\ETBI\GS\DC4`_YVE*\99429?k\61179S\169097\1020602C\1008782\CAN1U0\187652aq\a\1038379o\1085901Z{)%b\SUBX\146310B_\1049028+ag$=]\1063273\20925;QY&M]\171897g\ETX\997959T"
    }

testObject_DeleteService_provider_13 :: DeleteService
testObject_DeleteService_provider_13 =
  DeleteService
    { deleteServicePassword =
        plainTextPassword6Unsafe
          "\aF*\1056058.J\1072915b\ETB\988555cDt\1012701{M\1007131\1064187\1046279m\a\1016299xR\1074348\1073660\1089710\162480\1023560*\999059\DC4K\GS\SYN\NAK\SI}<;\US\19573\1074826EN\DC1\1068526\&8\1059620\b\175256\1033927\1027860\SI\t\DC4\1029714k\135937xj\DC3;i5\ETB\\\100057\164428\187088\16736kE\ETB4X\9242WZ\US\143241y\"\994502f\ETB\SOm\129169r\ESCh\GSwN&Q:K\68129\141105\64409J\99068\11299\1011531\ACK\1047483\1022907N5=&b2\SOH\995316P\996499E8\1092551!|\SOH\ESC:9*5\1070832:h2`\68032\DC3g\4440G\1059756\24716\1041762v\SUB\SYN\1041661\&7+5vGr+f\t\ETX8\SUBvk\EOTP!?[9\29758\1111629:\DC2\169224\3221k\137789#\45939Kx\n\174109\1042790,\ESC\44492VM\994186\14327pG\172068\1062750\&0%{;J\ACK\34102\1044167\41271r\6389~|\b\ve\DC2|\1096047\1101984).!\DC2\1029543Jw(5\46702t\63234\160349\49957\&1\EM\987340xC\DLE\n\RS{(\DC4\\\v\FS\1008849|.5_\164914\&2d5\991610\SYN>\SOHw\1023032Iw\164733\1020115\"\52458\US|Zn\"w\RSb?\984015"
    }

testObject_DeleteService_provider_14 :: DeleteService
testObject_DeleteService_provider_14 =
  DeleteService
    { deleteServicePassword =
        plainTextPassword6Unsafe
          "\DC1\22955\USO\v\2556\187895\ETBX\187498\STXL$\1039087$\a7\DC1c\CAN\"(\18295\1038981\1088462\STXW7\136317]=\1083968\t!/\SIg\1037805\49165n\"\\\"c\US\DC3xB%=I\1009690\ENQ6m\DC1\166931 N\EM@s\1112051\ESC\\s\190990\"\986386x.&K\180570\&1b1]\1052809\1021645vQ\149506+z\55274\1085173f?6\1009631y/Z\CANA\t#\\02x\159617WF,FJ^A_\1084872\&7o\FShuK\ETX*#\1033514]qK/W\145176QI?@\1002085p\SUB\DLEg\ACK\1077055\DLE\141695_G\149813{\ETX\STX:)A\1021354Qd\RS@\1094570\"!\ESC\SOH=\CANHu#>\153870\&0'Jmv]\STX\SUB\NULIj\1058287HGw\988502\1054602\13562-\SYNCR\SYN\1069893#E'w\1104113;\1055038\1095467f}2GV\1109390\&1\140032\1018034@7\GS0[O\180741\165383\&9\168573Ah"
    }

testObject_DeleteService_provider_15 :: DeleteService
testObject_DeleteService_provider_15 =
  DeleteService
    { deleteServicePassword =
        plainTextPassword6Unsafe
          ">s$:Gkysvp)1g`^C:\1097285\DLE\1042037\1060873}\SOHgS\EOT\1014770-,Wg\1059821W_r'\50698\174026X>\1057524\\\37373r$\f?\1047617L\aLAw\DC1h2\fJ\153848x\r\"\DC2=\989118\SO\ETB%\SUBp\ACK6\1041904\26946\NULqJ\1042107UZTK\CANu\984810\1000877.A8h\12469'\DLE\DLE\45777\DC2\v\119004X0qXo\1016220MVB\188426Hrv=\NULG\177882\f\ESC\f\1072755\1063768\RS\tB!t'\US0v\1094678H\ESC5\1052529V\24969\179998E\183293E\1089081L<?\1012403\38329x="
    }

testObject_DeleteService_provider_16 :: DeleteService
testObject_DeleteService_provider_16 =
  DeleteService
    { deleteServicePassword =
        plainTextPassword6Unsafe
          "Q\83071y96=\15610]V\97381\t\DEL\SIuq5\156370c%=1{Z\SYNF,\1059454\US\EOTEWB\32330im\1068170\19953\nO\t^"
    }

testObject_DeleteService_provider_17 :: DeleteService
testObject_DeleteService_provider_17 =
  DeleteService
    { deleteServicePassword =
        plainTextPassword6Unsafe
          "Sy1\fQ\12977(\13797\btq9\1002194\1107091\NAK\EMm?\1053177\ETB')0|/\156658\&8[y r\ENQ\v\n\FS\RSv:\1060616\FS\DC1n;\ETB3\ENQB\133402\DC4|a\US\1013477\vC\9387\997832+dVF\SUBwjq\984267\19335\32561M-\RS\997550\"Oc\v\173499i\SOHFX\1031163\DC1\1009190\1014586\24709q1m\1547\f\DEL2\37238j\b\GSw\1003742cNa\1089444\27074\136087\ACK[\a\NAK\58423<QDE{d\RS\1027939'l\63591r\15045\SOHK,77m?\1013300s0vm\t\SI\119539\1032354\163177by\1057291z\ENQzy\136758h\ETX?\t\179064\SOH\t\35596.\ETX\191368qAY\64349\1021276>\142474\2212d\1015371\ETB{5\b\1085433r\fN+\ETX5\917990\NAK ==5^\24976W\1094896\\\1087724\46810r\1034783\1099955\&1D7\NUL$\150130\23080\ETBU\983748j\DC2F!.\1011478\&5\1005216\1010480\&8<RY\"\SYND\v\1012522<\1081935p}\78112(-p\1002945p\4338e\31906)\UST_\SOHB_o\1061442\ETX\EOTW\SI_\DLE5~\RSY:}\1022284\r\1064313\"u&8d~\n1LJ\RS\178467B\126625N:\1051235\&0\1099165$P1\1072138V!c\r\174711\ENQ+\111306\ACK\f1V\RS\1007695\&5\2611\EM;\DC4\1058280ri*c\SUBm%tIc\1068471.\EMP1FrJ6\CANbS*>0\152760\1068360\96897\&5\160838/\17409\167739\1064995\21447\1069604\1091697\29270L\150565\4350\1008571GR\DC1\1024278:\834\1104790b\41841\1064198)Jn\48676\1051373\US\16820\998967/>'d&hQP\28827MC\SYNaq\83339(*\191321\DC4>l\39576~\RS*\DC3OAh\33301z{\33059JK\aYw\DC3;d\FS\1051228!W\SYN\992738n\SI\1030884V\US\EM\160254Mp\1061773~!\20793h\DLE+M\DLEi\EOT?5t@4!/0\1010526D;\US6Oj\143485`+\DC2^\182923:)7\SUB\164499\16263y~\ENQ#!\179196\15568\1057566\n2\DC1Z\113767\1005048y\t?\1081555&w_\1019029S<\29361O\STX\65137\DC4\1039625H\SO[\DC3\rH\1085267\1056334\1059773m\EOT%\142377\&2\SI\24993\57810\&5PC\1003072\&1\12115[\v\140175\n\997659M\n&?q\1088276Q\1021868\&9\96760F;v\DEL{<\1051978\97388h\92704\NUL\NUL\DLEn\169914\15551\NAKl@\1028759+\SIzb#\FS\SYN*gX[{H{)\b\44577\42072\DLE8H+0<X+\1098674ev\1095744=\185199Zp\989749}b\STXt;3\139568M\RS}#\1012934\16840\73866\25686q\1030627N>~@\25029\1099003;/+\v\CAN* \1018086\28116\&4\awM\v!KR\STXB\119577B\SI.s\NAK\ETB\EMD\120066\DC3Y8Md0\1016568KHS\1087988\ETB\ACK\1050352\&9\162700\DEL\f\1065134uV\988036l]\1076941\&9\1073834\NAKG\1052530\136250?\SUBm\179047\n\RS]\DC2wkgn\DC44\145653\1042881Ah@\182842\1051447k\998400j\61720a\994060\SOH\22802\RSo\SOH\7673.\1109414\1029022\FS\SUB\1057319\&7eW\40506\SOF\fD\DC4Zq\DEL)\50727a|\1039642\ESC\44613\1084395\SYN\990755\6567c\fl\144203\vk\n\ENQ\1051810h\b\NAK\NULpc\1003207:\21145'6~\18883\136716:\t\1113525*\1062609\70033;\177276`\DEL\\XM9\1099577Y\"\vX\1096963\vI\1064869t<\1019336F\RS\29205\&5\12817\EOT\ETX\1051299\1007913W\1082285akuU\1096842A+.\1102005\189823\142876\DC1\1075627kJ\1036321S\1016366t\125116\&7.J\EOTf\30180X\1097269\DC1WO\152648`\1079570\12741\1027795\70515\f\168890~y\DC4\DLEc7BGJ"
    }

testObject_DeleteService_provider_18 :: DeleteService
testObject_DeleteService_provider_18 =
  DeleteService
    { deleteServicePassword =
        plainTextPassword6Unsafe
          "<\ACK(\94072\&7\tg\28689x\US[\1015715$r\129494\21483n\145539P]\1095866\DC4\ACK\119849qP\163760W\1023008\1083754\1112401\1039398\146736 d4\180222dw\US\NAKS/\13356.\ENQ\99074W<gE`CLJ\ESC\DC1\RSU]\SOH V\1077112\95042\194622h\SYN\EOT[>c\1057568\137602\1029979=;<C~Gs\EOT\RS e'\145691Z\138364=w<\1090510\DLE\186922Qt5\f\NULL\1012800\NULd\137593L\1060121\1029922\&5\DC1\1100011\&8\FSdJ\v\1096685w\"p,6,Ug\1015072u\145746W\1105181p1 lt\GS\1028488r\1093064\1042108qX\993852D;=ImE\DLEMp+\EOT\1042317\&2\GS[\SYN\1077708\983254\ACKX\155725J1M\1045366\1063611%\ETX2\65429\1050156\174285\EOT\164338x\917592!z\150716K\1101065\1006039#\tE\USP\5496\ETX\140662&pn{8\GS\1014726V4RQG\ESCb\1037810SV\FS0i\136423\157507s/\\a\fy\1039641=\1033637>\SYN\1005115 \DEL\a\RS\47125\&87R\143400\1101827{\f{\171248?Bu\984165An6\t\997933gw1!\25291]\1096376[M\1056072\1058952TBu6Xs)WmT\990423\168687<N-*qR|.Z)u\SI0TSY\178215h1z9\185890\&6\158320*dSLh\1054150k\SUBLr6S./\NUL\EOT\ESC\1019485k\19614\DC3\43795\6758\43548\&6\51401+Rj.8\155986,,3\STXd>\ESC<:\SI\EMi\DEL\24488{\25238\&78n#\DC3\134177b|\b}\RS\\7|W(\190278 w\ETB\1100914]\999230#\SOH&\94715M!%.\SO?\168524\1011741lM\1095332\DC1Y\42522\78297\&4\STX\SUBn\ETXsGD\991578\r\1080713\1023773$\171\&1d\62022p.\US\ETB\SUB\FS`o\DEL\EOTnX\53121c*owi=&\158540\182939\b\1016827\r\t\SI6pTy\RS\GSk\1036061-O\SOH0\29622P\150571X\1015616\1078661c\1053453\&6Oi9\1119ua\5870F\77833S\38185NtB!KUf\152878\&1\1093703}\1026958Q#m\ETX>Z?E\SI,Nmc\n\US\1094741\&3\DC3\f\DC3`\SYNt\SUB<[\b\ETX8\151074h\1003990,\NUL\99442'5\SOHC\92301#\40443\ACK*Y\72211m"
    }

testObject_DeleteService_provider_19 :: DeleteService
testObject_DeleteService_provider_19 =
  DeleteService
    { deleteServicePassword =
        plainTextPassword6Unsafe
          ">\ACK\137107\SYN0P\44360\172737C\1082549pv\1097196/\ETX\187668L\96910\186315O|i\DEL\ETB\SO0\RSL\58627\999623\USvv\DC3Ka\1076973.>\GS?\1109724_\\\1011475I\62581\94753\1080472\&06pm`l\1041148\13550\&0\1010473\EM^\12453\ESC\f\EMB4g\r\1098984\18005\1107485\n5^f\ETX&G\23020T\n\FS\NAK\1039529<|\ESCw\n\154667G\US|f\DLE|5\DLE\1882$\1074936\1090991`^\140786\rA*~R.\22974*Q$Z*I\1039592^\162938K\57774C\1070778ZF\1060972\17798)\DC46\ENQ\SI0\1007803ze\9764\44341\184077\1080223\ETBj0\1111883yx\ESC\EOT|VW|\nQs\53595]N\1083127h\1042851\DC4G\1000718T3I%n\1017404qER\1002839A\148023\162227A\33101a(\ETXP|\t^\78794u\1097203\DC1\EOT\a\SYN\CAN\b\16644Y\986968pn-\SOH#\998434\984832&\1017292\&9G#\SI\EM\"$K\ETBgg6e\ETX!vQ\DEL\159252\DC2C*\SI?~\STX\1007689`Ue\"\1059830\USkh&9BZUuVl2\RS`\1025452\ACKxtOiU#{%x[\v1@\STXa&\RS\168275\ACK~PXM\154154\CAN*}&\1062787wt\1019634\1016421\EOTVT-o#\DLE\FSnw\SYN\1013453r'/u\DLE\15428#\DC2\31268\SOH\f6\14115akz\FSF;wq+\54251[\ESC<\174919(E&+eOh\DC3h\1028793T\24665\ETB\46823\ENQf\1109264w1+b\1108914s\"\33736E\1019264<\988069j\1071489t?\48682u\STX\ETX\US9/>\1081043\994356\DELT/\a\174484\1014268\1032749yI\49343JS\SI\\_\1043925\&1W\DC3:\48547h\25736\nZ\SUB\f\54942)No\1020941x\184463H\1106526v\78215\164362\&1;\RS\34983\160864.\1058424*\SUB\174437\1560TA\1112917^s3\1038351[\1053260\r5J\1049652\n\61845\157334>,[`h?-W\1013026\NAK\a\ACK\"\1004020WM\26663\18741\&5X\1092442W^KY\f\1049222\161658\&4d'\54786\DLEU\ETXQCbQ\33992\&3ci\\\aj\132464X\EMV9<p\DC17U:BL\144489rV\US\SYNU\ETB\tP,x\DLE&\184769^[n\r\FS{s\983371M8X\14520H\4145E\990621]o\142323j\990214\1102787\&0=\RS\b6\f\1025460+Mg\RS*\n\ESCP%_ks\STX\NUL\SIE\ACK\1045172k\ENQ'I{B)\SOi7>\100888t*7JF\1046979R>\136\30675\127315?f\164663\&4\ACK\1071913\993153\SUBjY(#r\1005229o/Yi\1041186l\bX90G\178671W\NAKe\1036212\983560Jk\"\USmW\GSz?+S[RM;FI\189237\CANT(\EOT\b`c\1005148q3B1r\182228)N\EOTy|Vsjb|\94530h\1034532g|w$5\139841\&8?QE\26569d78\1034073{n2lJZ\US6\DC1=|r\1055494\1044748\ESC\DC3x!w&\1113410\54516l\1023594\988578\nMR\1083559!N\62887\1030136\1009971\&6J5\183632;\64651\100866\GS\1008941\35467\74968\CANe\GS>\1013377\1100280w4\nI\57731r6\21870]FN\NULW\167503*U\1036724\987806\r_w\fl\27837\EOT\ENQ\4427\FS\33006\153667\4617m\170844L\b\DLE\46159\a\GS\1068707#3\GS\7624X6\DELP\10065\DC1o]F\1003847G(_9\ACK\a6\ETXP\DC4[i\1031304_A\1079639{\47811\&2+fn\\pyx\"B\DC4\1007948;9,\38686\t\ACKo\142161'BV\1033757\26211M\1050397N\DEL\146663\92331\1041718'\148612\1061104hf~2:\DC2"
    }

testObject_DeleteService_provider_20 :: DeleteService
testObject_DeleteService_provider_20 =
  DeleteService
    { deleteServicePassword =
        plainTextPassword6Unsafe
          "\46501M0\128273%rM\1066180\&9\ETBC\SO=\FS\n1\ETB4\ENQ\"E\"FUnG\994814!b\68765\1011902\1107231\5233\f\163953eO\39323C9o\167833a\1226\151640~\1075567HEg\1096875\&2?!+a\1035907\10212\1020711n\1045468#%|m\993099\a\92674\&8:[\DEL\US\1085710@qD1/\\O\DELG!\33361\1000772%w\"\1100656&\SUBE\DC3;w]\1028104hz\1082600MN.\1056702\1087194 \183582m\CAN!2;\rAH:9#\78634\&1%\1112704?6\1039413\SUB\GSC\SOH\n\DC3oj\NULh\t\1032478[BH\1075969a\1036438:m;OKj\SOHz,<\36751R\\\a\1006373\1083019Z'z\996413\1094670\DC3V\RS\193yq]G\999388\187945\11204\NUL\23900\&0-\v\1085533\66631\SOH\DELf\18953\17727f/\DLET\ETB\1073706.x\190003xR&\1051834\DC3Db*|\172679d\"fHx.x\f\1052427!\vv\172092\SYNlSC4 #\167493\139910\&2j=\ACKE8\bjc\NULC3`\1028591#\3507\1062196\1059545MTJ\1057868[:r\SOH3c\DLE\r\171193|M5a\DEL\vCn\17756^\1062889\DLEyc7\"\DC2T#\"ms\rM\1020351N&\NAK\1088713CS\SYN\185705\ENQ\DELbe;Z\47369=yS|f\ESCA\DC3\FSF4mv\1088644\NULN6u\ETB|\\ \ETB\38645\48401(u\97780N2\1016220\&5\1025214\NUL\"=L$`)"
    }
