-- This file is part of the Wire Server implementation.
--
-- Copyright (C) 2022 Wire Swiss GmbH <opensource@wire.com>
--
-- This program is free software: you can redistribute it and/or modify it under
-- the terms of the GNU Affero General Public License as published by the Free
-- Software Foundation, either version 3 of the License, or (at your option) any
-- later version.
--
-- This program is distributed in the hope that it will be useful, but WITHOUT
-- ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
-- FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
-- details.
--
-- You should have received a copy of the GNU Affero General Public License along
-- with this program. If not, see <https://www.gnu.org/licenses/>.

module Test.Wire.API.Golden.Generated.DeleteProvider_provider where

import Data.Misc (plainTextPassword6Unsafe)
import Wire.API.Provider (DeleteProvider (..))

testObject_DeleteProvider_provider_1 :: DeleteProvider
testObject_DeleteProvider_provider_1 =
  DeleteProvider
    { deleteProviderPassword =
        plainTextPassword6Unsafe
          "\DC1@\DC1>'\1102947\995024\1043045'\NULUr,\"\1053599\154586\\\983184\1005060'\CAN*\r\119092Jx\158738(\1034236\1111068\GS`\RS\1023229$#\181515\186716\t=\16360z9\\,v\SYN9\1081993\v\1003036>\a\10046\&42Y\NAKS\176274|\54053x=a9k\SYNepY\44071N\1020919\30201\DEL/\EOT\1024289\&1\158768`P\140:Zgr\EM\17418?\141760>[\DEL\4472\27674j\141802N\183910\SUBl\170710{\171194\156957v\50468\\yDx\27333x\1070509\&8O\10189\DC3\ESC\SIwn]\1002158:\NUL'\NUL5\\(\bi\83316F\DEL\1107124X\SI\SUBi\990574I[Z\1028861\CAN1\1105411P@S\SYNI\179180%\NUL1#8}\\;}])\USh_N9\1079200d\803m\SO_\1072463B\SUB\NULX\tc\NULR\ACKw|3_xn\\\1020350\11339m\1017300Q&}\DLEk&+\46848M\191189\1077146h\DC4,\DC19|FB}\97649\f\1002295\996162.\DEL\ETXAL\52088/\ETBX\b;<\GSX\19235\SI\boB\185334\FS[!\166871P\1029617?R|\EOT\1090605\EM\NUL}\144677\GSk\v9\ETBGL\23477-\25258B\CAN\189512\&0\ETB\131990\1014508\a}ns\\~[\167960\&4D\DEL4V\SI*\ENQk8gBN\SI \18554i\990272\149977\1008889o\1091527[(I\165811:\SIc@]V>>\SOH*\DC39h?\92463U\FS\SI\rR\989411o\54904']s\1021357\1095599\1037065\28114\b\160993y\996966\165520n)\ENQ\998845~\1070129\1071107bA\fc<\5532\33882#pUG\GS/\CAN\155833\52960"
    }

testObject_DeleteProvider_provider_2 :: DeleteProvider
testObject_DeleteProvider_provider_2 =
  DeleteProvider
    { deleteProviderPassword =
        plainTextPassword6Unsafe
          "\984525\1043960OXS9n+u\v3\SUB9\189261)\NUL\GSd.\DELxf.3H1mc\CAN\SI@i8>7ob\1047764\ry\SO\147692J`U{\93847j@)\179667\"{\1053310,\188059s\1045477\n@\f#\15153\ETBE4?7\31129)\vh\1005526\b'\132397~-{CwZ*\1037033\190558\ETBeJ%\DC4\1023444\vr\160978\34762|A[!U\SUB\128583\nv\5189\CAN}r_\57489\NAK\ETXk.\RS\137427>\1054128,\33000[w\SYN\v\176083SHH\DC3i\119359\ACKa\v*\SOHo)P3nB\ETBVI\EOT@3;5pl\SYN\DC1\NULl\1113634g\CAN\DC3G\1057089\161998\&4\nn\97904\1043436\vk\EM\SYNV-\\ 4Lu+\173185C:fd'\32161]\SOHDW\NUL^9\NUL\ENQM4r\ETX\27301u\1041008O\162963`2+4l\1101064\1077396\1082420Z31&OE\EM\1087511\&3\1034203R\EOT\1000625h\FS\1045021\1105250kV\190547|PP\1037249+hYd\SO=\t_\STX\50344\1035551,\r|\7757)\1000692 \EOT)Q9S\1048123rH^\ETX\26197m\ETX\120622\SYN`\DC4\159476L(\1032667\DC3nGeQ\1340\ACK\1035560\67715ha\SI\RS\DC3Ph8#R\7873S#Q\EOT#/\1037058Crw\152923OK\SYN\SIpT{6f\1037408j\\Yb\168691\&6/v\STX\SOH\1001257\CAN7P\1090994\1003374\65195\96273\1002856O\ETXZ&\998950A\SYNZ\1079101@We\SOHyeD\1047023]\a@\1052273F\ESC\SO\995299\NUL?#K\DC4\"\5054&_[:TEq?w\181853\DEL\153239\DC1\"\SYNrd\145008y\DC3c\1042973\1035111{\CAN\ETB;>?\996728\SO\"\RS\167515\63621\SUB2\DC3n-\1093919z\EOTGD-S6b\24090\1006310:0[#Bb\DC2\1089765\NAKzF\ae\rC\SUBx<\987227K\ETX\\\SO=\1087219,943m \183245\190748-\n=\DC1\NAK\142118%[YX\64073?\SO~2R~h\b\bX\93045e-7?\1398D.OLru}L\131183\t8\8708\25653)\994590\1065269Z~l\DC2\49866\162561\nZ>[mZ\ESC\CAN7,\SOH\NUL*\169477\&7|\1095835[l\171154\SOH\SYN\SIF|f\EOT\"\45145W\988489wtC\131467\42228],K\EM=d\162347\\\998674e7u=\1087050;\SO&\DELlIT)K2\30282\29522U0W8\143297\&5v\159176\&7Pb\49357\1086563{ \r]\1035947\SOt\USv\1111251\GSMk%\STX\r\DEL;zw\1045585k\a6T\DC1I\rk\4589lQ\v\1087379U^U(f%\27173W\990453\FSF63V\ENQQ\1039545\&9\ETX\1027888K\CAN;?N\5575#p=\1103580m\1021118\135827\NAKq.p\1026570k;.\SOHgF\1065081\1100911g6\STXR\1085500\168383a\a\SYNZ\NUL\1043812A\97854\&7[w\1060519\34962l\DELhR\EOT\36730\72839\DC1(l\aav3q{*P\1083959\60318\ETXRbJO<\173398\1066886\&6\14855\aLs\DC3\NAK7]\STX\32065\n\45961\DEL\65810\&5\1077711<\993297\SO-c\47037l\SOH+\r*`0O\ETX\1065442_3\DC4$I[\SO^\1093967h'^Ir:\DC1\997590=W\US\NULW\987020-fR\NAKk}hxB\NUL"
    }

testObject_DeleteProvider_provider_3 :: DeleteProvider
testObject_DeleteProvider_provider_3 =
  DeleteProvider
    { deleteProviderPassword =
        plainTextPassword6Unsafe
          "+\DC4M\1079446\bN\1092976\7721WC\1046938W\ACK2\NUL5\1054739\v\179949{Q\1070052ZnyA-\GS# ;;\1058412"
    }

testObject_DeleteProvider_provider_4 :: DeleteProvider
testObject_DeleteProvider_provider_4 =
  DeleteProvider
    { deleteProviderPassword =
        plainTextPassword6Unsafe
          "{k\1032127j89m\1028940!.,\1011366\989738Tg \GSG\1062577i\179248X\DC3\17357~\35308\1080081KB\ETB3Z\120005\SO\27779ytV&UZ\USjaO/\1014772\ACK~\ENQ{\186280\v\170867\129409G\1056004\1000425)\158906.\n>\1081241:@\152049\ETXa\ESCMW|%\USh\1029384x_{\n.>\DLE6R@d\tCW\140369\SOH_\DC4<n\SI\SO\1030530\NUL`E\1034829H\1085064\96348<l\ENQ\EOT\SI\\~$0\10913H0\1028987{ku\69951\1080100\&6m\RS\ENQ\"\ENQ\f\1027075\1066711\DLEBt\r\EOT[ic\aH7T\1076877\1112863\USz\128709H;\77936d1BX\DLE\172729\1051516\25857\DC1\60083\36232\168& (s\30181u1C\1004036\CAN\DC1*(\1035332\190970_\1098998)@P\SYN\175110\159205v\SYNi-\r'\7015r\DC3%\1009645\SI\1066590\1095061lmxi6\SUB\DC4\ENQV\ETXG5\1075205\&5X~B\\\EOT\DC4\186749L\31723D\22117\ENQ\DC2<QA\t~\USBE\993894\1042175\GS\142563\1094244#]\73822YY!RK]mtlXau\988630q!z\DLE)H\1082712vW\RSim\1023907\DELN\ESC3\1088383\1107349AS?\1029654B#\DC2\1071270;\\\100888)\18880E\ETX\ETX\1103220\DC2\DC4Z\US\DC1~1(&\190366m\72715iBK8\aP\997980O\r\10327/\138572.\131710#$\1033281A\1026958X]\ENQ\1060341-\n\162356,%\142868 P4Z\25856`\ACK\DELH=O,?\NAK!\FS(*HhNU\DC1b\SOH\1108216\EMb\SYNGt\996420c*\1016843l(b\1055412\53547.\1110929\1090557?4Q\160925'\63371&\1093029\1073192\1112560p\SOH\1112854th{|\DC1\157856]\r`=!\STX9`2j{\n\1106687r\ACKO)1Vz\160583\983496\SYN\1052651\ESCmV\n\66466\&3\DLE\NAK\US\1081123W\GS`\70787\CAN\ETBy\1042514\DELsu~\EOTa\STX9\SIs\149233E1Sh\CANpu\1004665+\r\nW\1104189,\52370\EM|!n\ETX\30166R5\EOTV\36011\1069579\1018328\RS\999832:7\70828\7742B\136554h\1053592sl~\1022586H!:q\SOB \119612\td\31093^8h\991534\1058038\1060155\"}L\STXd\1016502\161963\152581\NAKjt?PBW,Wq:!\999725Fx\984803\1000890YGD\DC3lhe0G\ETX?\1046749\&8xk\ACKi;z\1038186\1051255\999135\36494\SYNPr0\1057090-4\1072531\EM|EV+p*V\1058630y\1053941\STX\5388Y\NUL\24814c\179635;vW\1099760\&3Z\1003221Ij|\FS\1037976Q\1048147_\12308\15635\1096681+g!\1079312\ESC\48898\1110672\&9eV}C\RS\61187\142946\&2\42448\ETBdA\CAN\\\"K\174392*%,fQ\ACK*\DC2\DC2\1098171w\FS3Nz\1073325x\1039908c_j1D\FSM\SI\1026081Fm\146919Hno\121027\1097494Oqb\SOH\FS@jW\1076039e\121185\EOT?r\143437Igm\ENQ\27037a\165667\1045909w!\1071957(<\DC1\984567\1006134\990094\STX\DLE\1057576\1074966Dd\va\1042569 J\73061lW\159664\48018\16102AHU\992472A\STX'\1076335Rr\31329\43684}\EM*\1293\2305 8'+]/AmR\74246\SIk\997437\1108803\&6=.^'0\1084925=\\\fZKVb \NUL\ENQYJrK\11517\n#"
    }

testObject_DeleteProvider_provider_5 :: DeleteProvider
testObject_DeleteProvider_provider_5 =
  DeleteProvider
    { deleteProviderPassword =
        plainTextPassword6Unsafe
          "m^+\38081\ETBe.R\NUL\1078385:\1112978jr\162501O\1040392I\30132i\1023642'I1\1073734AK\FS\SUB+Q8S\td\1083435\17643>\78572!'g\SYN\1044903!RS\f\NAK\6544\STX(\36031:F|=\DC3\GStg\172165&\SYN,r_\1025883O\DELT\27292Y6HquP`\ENQQ\SOH\SOD)=\ESCs\29741\SI?\1073240BO%[\160823!P\26163\1014284Rp\RS!Xe$x\1110728\144032S\988049\990894\18495\GST\1105691\49284\174626\917911}o\57602Zl"
    }

testObject_DeleteProvider_provider_6 :: DeleteProvider
testObject_DeleteProvider_provider_6 =
  DeleteProvider
    { deleteProviderPassword =
        plainTextPassword6Unsafe
          ",\fT\n\11037\150521\1112935\&6\24772\STX2\142196Rjw\rX!Us\1077738f\ENQ%MA\1089631\140112O\41617fs\23343u^\31774\5501k9\\g4&CyT\1081061.\1102377\119305\1039223\FS\NAKVQX={\f9\\\1075870$w(w=\DC2\ETB\988694\t\135307\rX0\74402]\1098792G\1070616Z\ENQ[M1S\143908\996439\v\167213`nwh^\12408^\141240,\55182VM\NULW\158742J\1034824\1042748\\\a=6\23807uF\8041j\160911\ACK\DC3\1061055c=\SO\v\49989C[']<\ETX\GSFm\1095852\\J$jd\ACKw\28402}\CAN!^-\RS^\v`\145626\&9E{\139362>\STX1n\139165V\1015510fN\RS\49877x\382m73\1052448\NAK4\171724wtm\94543f-V\52768\RS\61464\1024899(Ey\187608~\DLE\126606\EOT\988290\1094131<(\1102453\15963M\987791\&1L*\178238\986389<s\1101429\58667c{&r\DLE/%Ap\DEL.\DC4\191103}w\1011537\1038916\EM\1020669\SOHI\1099360\1100851\DC1O\1044581\DC1ih\1097995`\1094313\169536\r)\SOQ\NAK\1047712_A\DC4+t?C\8872\ETX\157206`R\">P\1110638ew\SUB*;\1020562\156439\1047006b\1096691\&2\ETX,3_\ETBg\184769w\ETX-\7809FwX\1008433)&\144525^+  =n}S(\SI\1018943\tM{Q\GS3z\1105280s\133855\GS\EOTFs3\70669)\6660\amom:R\8110\DC3\35666O;c\DC4qM\168664f#;E\US:(\33568(\STX\1010570FN\ETX)\1053483\nIOuG\ACK\1016055xoA\FS`m\SOHs]:\1025351^5\EM\ETB\DEL\159157z\1021102~\b\48196\135249\STX\1092689oj\ETB$\133413$MK\1069196n\n\8575G\RS\1024958E%\1082021iLRpbg\DLE6\120928\20506=\GS.\151888?qW\1102074&0\f)\SO^V_-Utb\52528\31472]RT\145602|\SUB%l\NAK\ETX\1067340P\CAN\EM >\EM\1106918\179190M#3\SIQ\NUL\1018740s\60067i- \187088\DC1HT\95859T\1104463/\DC3\STX\US\1001037M\r\157436\16960\993091\1085868\1022183V\ETB4\SIB\1085605(=BQw$\SUB\1067953\139343Z\CAN0\DC1\127556B7<(mb\DC3h\96162\55002\DC2z\b\145908QaQV\175250\151327\n\985159&\n\SO\1018855Q\STXj\v3\RS=_, \SI\EMQu\EOT\SIY\DC1\RS{\EM\1065344\SYNW\144838\149272X\1081686j\99102yg\ENQw\14545Y4g%\DLE\1023519z\1057216>_\1027401\SI\1077238W\SI\1092706\SUB/E/\b#*\DC4(\")I\176856\1001466\&4>3\37037O\DC2\GS\94771x\111120\1033261\DC3\SOH\1052866T\50307A8N+`:f\t\EM\985835<\1064255EL\160636\&3\14480\127849\r`\ACKy\RS\f\151666\165718QdS'Rw\179457>S\160451\1078575\n\\L\150549}\DEL\134027\1065618qj=\1059318\173025Qz\22020\188172\SUB9yf\EMc\188027le\128231\DLE=G,k\t\ETX\EOT\1133\DC4^'\r\CANS\39323;f\a\1037800w\vjV>\EM\DC3\1091368W$rc\1089926\172604\SO\ENQ\1074216NE\NUL\SYN\6921\169203Bz,[/2W\988557\ACK\989352\178741~s=\1072691\fA"
    }

testObject_DeleteProvider_provider_7 :: DeleteProvider
testObject_DeleteProvider_provider_7 =
  DeleteProvider
    { deleteProviderPassword =
        plainTextPassword6Unsafe
          " \624M\23418J\FS\1054202Lej\ACK\22365\41654\46673\95301^5\DC2\984400<K\n\1049171&:\1092421Dt\ESCg;/R\EMw\ESC\DC2,Q\133910\&9\1079265\EOT|S\ETX\aAyB]\EOT\1023941`g\r}37P\1007491\181868l\SUB2\ETBH4\643\v]Q1eL<fw\")\DC4-p\SI\\\FS\134149#{\1065550\1071355(vM7\4909XG\155819z\137760hq\DC3\DC1<\SOH\EOTl\ETBLu>TJ\984916\&9R\DC4\1050813,,$E[\SO0\ETXsb\t'\t0>U\1089416\SIr33f\137027\143327fQ\ENQQ\b\ESC@51u*!\ETB\1049788\DELw\46535>]L\36134\1039185\163894L\EM2i\\m\1091968\&4c%\SYN\9242\DC4i>\120056R\164597\r:z\DC3,`49s\44254\138481\1103072m\DC20I2\993122\137231\1077346[ge\DC3HS\DLEG\175034:#j\DC2X(*KSOs>\NAKrB\1058112!'\RS\DLE*.j\CAN\GSJpS\a/,\a\37202)\n\1027944s\1091946\RSe\1098612\1086816\SON\43847r\GS\1105154\1019251\EM|!\96749n\DC4k\1023808\1001051\1069320+\998856%\118987S\DC2U[\61135O\ENQ\1110955\NAK\1001308\170546\SO\EOTL\1111010d\ESCP\ACKYF\DC1\SOH\65867\28419\177258\SUB\1062425\985666\t\151420xI\1020274\175005\DC31\DELF\176479I\169549;\993159\NUL4:\1010330!\n}k\1080461AaoT\150654X(_\n\GS\ESCf\49821\98930>)\DC26\DC28\157333B\1060776\60653:\1023707}=3\NUL\995126\97810T-%fT#`,J,\NAK[\NULe]D\CAN\nw\DC2\120860\RSpW%\147220X\986014o{Jek\ACK9\182559?H\DC4\996934\t>^Sa\GSK\140398\SOQHX\141574+W3L\CAN|\1068172\\\ESCl\174698g\987261 P\n#3\f\1013264X</\DC1\36306\DC3%\SUBtfMDVd\DC4\FS\1008056n\1022569\STXm\1046078}_,|pF\DLE(`\37640do~:\DC33\1029301\SI^\1110920\16070U\1086209\1028723\b(p\1030902`\DEL_\178765H\1026492\1051884\STX8r\997925\b+y\1112140\1060438D%S\1090298S\DC4\1092967\78197On\DC4kt\1106848\57593\&1\98804;\DEL\US\1034580\ACK'\SUB\DC4u}\30539\t9zI\SYN8-\nD\SO]fQ\12846\1015762c>\v\SI\tm-\RS\185875:'\1053231\990328%j<vY\SI\EOThv\DC2MlKt\163049j\1625\1073665,K\1065639\&5e\1042646\38762XP\1059474NN?\1008068\av_]\EOT\2022%\167971\GS\ENQ?|\190514l\n3r7Ux\ACKv\STXLja\NUL\1112244h3tLRe=2\DEL8a\DC2\CAN\140463AfamV\1088799b\1044508@V\47890\EOT\18317l\82996.3Fz\1099485L\"\USSKK\a\4428\1113326EKG\"FBq\nR\184252+\1069724\1099305Jbo\44937//\ENQ>\120308\SI_\1000210\&1/tiHCDZ\SOHZ\139905\1113168\&3m4Qq\FS\SOHkuS6Tx2b\EM\SO!\1023256XT\1101340/3V\1071327\&5\1086459.`C\CANwOA@3\1069157Wqx\aK\DC4\FS\1035400Zu`\129142\1079715m?f\1073033\GS\EOT}X\6820\&2:<.C\158741E\66192\&2.\1073847;2g\SUBd\SOX\181466P]\1103031V\99500\1597\ENQ\ESC\31838\RS\21975\CAN,g\SYNu\SOH=^\71324\155428u@\b\STX\aD\n\110745F\ETB@&\1016259Z\t\143067\EM_\DC1~m\155177\1055559y84c\"[;DU\141586N^~\1017673s\DC3I\95006\STXm\US@_\1083426H\93812Z\EMZ(\183277\ACK\1089255\133426J_NE-\154549\170008\FS~a\1058991\181123\EM.\176985=\176509\SYN\t\1019377p\100335Y\1027317}\1070781\DEL~\60615\DC4d\EMw\ETXnYW<V3\v\1028963\STX\1009135\1055917v\184745[ \ay\NULqZ\SO\SOH~\95137\63843\1111013DP P\1021548\SO5~\1051224\1009629\137654\94689L.85S\ESC\r&h\t8g\USB6"
    }

testObject_DeleteProvider_provider_8 :: DeleteProvider
testObject_DeleteProvider_provider_8 =
  DeleteProvider
    { deleteProviderPassword =
        plainTextPassword6Unsafe
          "z\RS\1030713K&\35010\1039856_@\NAK\CANYuW\GS# \63353a? a>B\1103855\1007484R\EM\1081389'ZXzP\1001276\ACKB\ENQy9(}z\18379'1x\STXp?MM\ENQ\1033401\1095702u?\137539\45622;\65599\26469l:)w\145127\GS\ETX\1061851z\1080393_v{\151849\164975\8631X\EMI\24721Y\NUL\149184\STX\175455\a4\157755\&0e.r\999201%b<mHH\167016k\DC3\42301\FS=ctK\US'\1101877\STXqBQ\987487\1046916\1004818\CAN\1078337\991661\1091539;d\"4bBW\n\DC4!;:|\1003304\NAKj\DC2d\94098\160517O\ENQv4>6\190409%\SOH\SUB \1109498\984390\182849K^CERXA~#v\33651{\STX\1048885\26836\SOGbz\DC3\1056261K\1057379\&1)\186016\r\51132\&2\189152\NAK\996489Vr\aG\1026756ax\FSN\1004712\FSc\ACK\US3K6=\54958\tY_\1067945|\1084323\FS\SUB\1055497\DLE9<\1065761\DC2#\1013541\EM{Z'd\50849\33048\DC24\70681\178096-\1028926\NULC1d\SO\1047114\FSN\fB\157482\111105/\DLE\57509\&8h\f\1034246e\997247[\110814\176299\DC1l#\100151\996255\34863\173136\DEL\1090949\US\DC3\STX\DLE\1051161\r\SOHGR:\20017'2\US\13757\21938\ESC\1015967%\1111544\1013576VXq~a-2\ETX2f\DC2>.E\1082947tY@Y?uEX\1042210J-F`\62692LL2N\\O\ENQIE"
    }

testObject_DeleteProvider_provider_9 :: DeleteProvider
testObject_DeleteProvider_provider_9 =
  DeleteProvider
    { deleteProviderPassword =
        plainTextPassword6Unsafe "\DC1\1064292\SUB!8V\166314\SO\ACK\ETB\"5\64599j\189708e\DC47dNxU'\16357J"
    }

testObject_DeleteProvider_provider_10 :: DeleteProvider
testObject_DeleteProvider_provider_10 =
  DeleteProvider
    { deleteProviderPassword =
        plainTextPassword6Unsafe
          "~\1040972jRa\SOH\n\SI0K\990428\133439\DC49\FS,|\SI6\1022952P6G5\ETX6\t\1075581:k\96553Q\SOH\35898\DC1j\172175}5fvp4\FSc7\1098045/J\68898\&46\1018453\CANZ\1065057\1090165\NAK\1072358\DLE\EOT\65446\26156/XU\1079115R$=\fa6f\b\1098528\&8?E\1062300OU\US\SUB\FSC\1113609\f\"\5545M\174668e\ENQ\DC1M\989929A~qq\STX\EOTY\ESCG\1052864>\ETX\50239\995133T\rB\bn\ESC\ACKL\146046\166566\171485Z\ve,\160056\1094193UZ\t\1002621\ENQd/\DC1\5473\63971[.%01w3\EMtZt\1004605\1099738v\t\187486)<GI_4I\NUL\983799<\992426[\1085236\DEL\42331\&8%wg\STX\49832l\ENQ@u\66651\1016956<\1031000\CAN\183146\42844h\DC3\1091806\al2x_t\ETX\6843\DC4\EM\190911\f<|4^\190408\164321\NAK=0\132196!Fm3\181378V\1046175\STX\177579\1065909\1106797(F0\b\992576)w\bjH\DC4'C\GS\STX\ETB\DC1\182392\9157\&0eo\nX|\CANz`\SOK\SYN>LM\RSf\ACK\140763\1014776\&9\SI@\1035887\DLE\FS\ESC0oQe?[\1035913\1111740\&3$_\189385\GSZ\NAK\38187i<\DC1\1072354\&3\1076164YF-\SI\9828\2130\a\"nP\1085224e?1\16223nIWsC\37896\ETX\1063189\1000812\RSax'\185030\ETX\147022O9\STXE\990294\EM\DC4t&;X\r\EOT%E9\bM\ETX\188586pfI\46096lm\179262\"B\1039905\SUB\38603<[ u\\\1058099\986546\988823\178253j|\DC1\f\EOTz\"\986225fs\1088266y\216%.\138588KU\b\NUL\1038063\&3S\163149\1081752W`\DC3U\185513\28773\61686A\1031101\\eM\\)OB]xep4z\142267ml<:0\1097056\ETBr\FS=f\f*3\SYN'M_\DLE\STX\SOH\161576}\985376R*\191128\55073M\NUL\SI\41927\ESC`\183647#q\vc@$Z\1071926\SYNQ*,[\187915\131597\1002663\1111830\t\151977o\GS{\ESC4\US[2gGs\DLEY)\152942E\1084490|\32920\&7\171342\1057558j\CAN\1095607~=\FSI\1075491\&03=\r\1004914\1010211\60429|\DC3\CAN\STX(}^\1065299w\FSJ\53542H\1098143\157584\SYN\49771\983932\DEL\1105851\"5~o\54484\121456r\154102:ov\189215F\1105398;6HkT\48486\99906ei\1102176\1035874;A\US^\DLE\166094\EM\DLEt5\39199\1000398*\987236\36310U\20442}\1071144\ETX\64424Os?\1040194.s1\1104551\n\EM\1083665\54846wuY_Q\SO1\\Y#\21726S\23739'\GS=\ENQ\v\ESC\ACK\164113\ENQtA/R;\158105\131797\CAN\172442\1064571\DEL]sq\SO<\b^\EM\DC3\ENQ\1003433{\SYN\26868\&3\47069ik^\GS\DC4P\SOH\1082140\EM<z&5Y\176669\26888F\28888\&5bh,:\50486,a\GS\r.P}\GS\187293\DC1&7\SYNVj\ESCy~\ETXX\EOT97Y\CAN\165937\RS\CANM\44350MI\157706!\1082189S\EOT|\NUL\ETX\SIL\EM\1029258^\v{"
    }

testObject_DeleteProvider_provider_11 :: DeleteProvider
testObject_DeleteProvider_provider_11 =
  DeleteProvider
    { deleteProviderPassword =
        plainTextPassword6Unsafe
          "\DELf\ESCr<\SO\36078%vg#=\151279\&9&\176318\\-b\151176\t9\STX\SO\150243%\173078\180945K\EOT\30697\1084981\21524\STX~u1e\SO4\1021456\156277\47832G\1005946:S\1093118\1078090\184163W\1081696G|\44254K\\^s\SI\992837{!\171605i\ETB\b<W[M\156821[jd0\FS\1085995\a\ACKQU6\1067819\1045103,\SIMS1\1086328\137751+\36675\1006390V\1021622t\GSO85\vN>\67980+:\1060625\1036803R:9\1100130\USi\r|]\178537\1089051\1019056=\1002762]Hd!,3\US\nt\160073R\2576i(og\1111195u\15456\SO\1040617V-\1071988\US\1022948\SOHL!\182613?IsQ\RS:l?I;*#\1046129_K[\1041748XA1a\1024880\986414X\18008aYf\1045309\1053346\1038859\"\142308\995622\b\NAK74\1008952\\eCp\30226\NUL\SO\143524}v$\1050141\18217\34711S;T\1005256"
    }

testObject_DeleteProvider_provider_12 :: DeleteProvider
testObject_DeleteProvider_provider_12 =
  DeleteProvider
    { deleteProviderPassword =
        plainTextPassword6Unsafe
          "\1007892\166298.1\35067q<\DELR\179909Iu\SYNWP\US\1042902.\120669V\7259\EM\1061036\EM\7817\EOTHh\190352jY;=SRhp\16588.dkc\169263>|X\NAK\1080314\&5O}\CAN\1043753c|~HBX|k(\1053055j\1108065J\f(W\1107955\ETB\166679CO@\GSX\1112489\1091049\\BCg!\rX\GS\987727\DEL\70816\t./\SYN\21028tkovvp\1107555s\GS\143204\1005238{\985690V9;"
    }

testObject_DeleteProvider_provider_13 :: DeleteProvider
testObject_DeleteProvider_provider_13 =
  DeleteProvider
    { deleteProviderPassword =
        plainTextPassword6Unsafe
          "\1082093s>O}(4\189851=h\127772\&7\1094821\STX\39698GR\1077438?\1008267,\176101M,/Z\EOTs~\100263zj\NAK\94052/_'-=3\f\\~8W\CAN\983872/\USm\129494\&1\FS\180953\&5\47911Z\n3?\1001530\n\1037936'6\1073619\144126m\SO\STX8\NAK/\1084245Z=\SI\1061631\1054559B\v3yU*\DC2\1025567@T\ENQ\FS\1018948\STXi\DC1w\157694c\1083418\NUL\119939:\167173\96905\US\139551\1099836\&3*\SI\FSb+Z\DC1K\1095387R\21991n.\6600=D@NX\NAK4_&\DC2\n,XM\678\USUw\EOTR\62649Mi)-\37650J=\ETX-\f$k\a%4\n\135411\1013583U\1061907>\15674z\52528nV>\SYNa*\139458\22648/!\145080K\1088356s\f\996120u\NAK\1101690\f\RS7\ETB\995731\46942oA\12088\62892IK(\a?\128017i7\1047542\DLE\1015992\DC4e\136695\1097623yyJ\1050424>]\178185\a\37397c\64716\SOz\DEL\1037853z_\vK52}B\EOTQ`'k\16203\1085598\1045965+\1113033\1108508v\1069069\CAN\1049355qsJ\ACK>y\NAK\33210\&6b\DC2b|HtPl\24067W^%\CAN\126568\v1\1076330Ts(Km\NAK(c\n30\CANe%\DC20\ACKAv\1105666\SYN\NAKn\US\51276\&4y[\997438qo+f\47599\990691\1063656\1040123_zn\NUL%Q^FZ\ENQ%\64647\7165\NUL\1040652\178170\GSs\1074533Q\DLE?-&= \ENQ\993080g\998803Y?\GSzb+\DLEN\DC4\STXDa3\1010949\r\STXwQ\1018740\FS]T\1079943\GS@P\FS\1085\1113380\&2\25177\v\DC4\92483`\NAK\DLE;\16890\175811?\DC1\1066402\SI\1086327E\DELm\152922.\172491W\999440\58559\189616*\1090337G~O\ETB\DC2Y\1025522J\f\163887\NULx\172426@\DC1A(\168166GC%\SI{t\DC4F\DEL\20907\DELWE\1073704\ETB_%m=\184124\f\47174A3\fI,\46251y\\\\Y-\v\92982A\1027677oY\ENQd\r/\r\NULF\991639&HHqr=Y\SUBX_\128625H6(qXk\b\1025750NR\RS\18562?,\1047164\1107498p`\r\1074813\US\1106686\16834\&4d/)_`\DC3\SUB\128275'QL\1024034k.\23619\1019113^w7\165946Qt\1083998\1108588i\157558}H(n\EOT\\\1057760\r\1048983\1065683\990896\b3b\v/e\1009653W\ajg\DC2\1033673Mu+g\ESC!\19357h\DC1Y;\FS@;Jd\DC4]P1Y\vY\EM[\\\1044982#\SIZN\DEL!k\DC1a7\1108339\&1\11532D\US\25783f`\DC2\1050644\1103528'v\"\1069716m\1108792\1106047j\1044188\1087005\DC3\57801\DC11\bt+k8\GS\DC4'hh\1056281j\SUBk\1037401\DC3\RS\DC2,\1005521o\51371t\ETX\1051670\1109590\b?\126115\189762e\32865?)h\n>=\EMw\EOT>LeG\b\vZ0\GS_[\SOH9\DLEc\1021058\&5\101013^\DC2\ETB4\ETX\1038029s\SOH\188620K\FS\GS\92438\rL\ETBU\ETB@\74427\ETX@\"e\39077LUj\1069428\10801\SUB?\DC2w\SOHZZ\FS9\16133X2\ETB\rq&\1014748\1019808pO+?\1102310\&6T"
    }

testObject_DeleteProvider_provider_14 :: DeleteProvider
testObject_DeleteProvider_provider_14 =
  DeleteProvider
    { deleteProviderPassword =
        plainTextPassword6Unsafe
          "b\58964t\43509CR[\30082\ENQ7\100247\1034461\1087199[\1076643R;\SYN+\EOT\128754j/\1080285y\1093960\1074869\1111511\1104150\FS\27079\&2\EM\RS%\1082459\SI\36007\b\1047331l\SI\DC4a\vA\1042157z\FS\ETB)\1064065\SI!d\1079928\FS\48559\992612\&0X#\135600r\1064811P]X=AC\8677\EM)\a\31588\151769\1084526\5443\180158\134162T_\GSe,+dh\RS\13107_UD;Y\1015192q#K\1061942\97367\1040156\\Y:\33421h!_]\1048452\a$/\ENQ\SO\DC25\94744Pw2;G\170952\ETX\NULy!pb\45112\1103992\994562\1108199\ETX<uXZ\146987>\DLE6\178134\STXL^\9774\DC1Y\ETB\21002\177094\1075624\987871s\118876\1073267~\6034c=.G\1052723\73447;>[\1059144\&0\151875\26991|\1110095\1006840Cz\990775,U6\1104366\4586\1061238e\166472&>79\SYNY!<\19984@92\175732\57726Z\DC1$!\nkI\SYN6GN\1081932'2S\NUL\1019754\nL\183592i\CANiE;\DEL\1016455~\987760u5\999910Q\CAN;x\1087031\154161\8330\991716BUW\182886v\138451%\vL\72727NI&OMAda\ENQ1J \fn\161210d_ne\NULln>vBY2\DEL\DLE\36843\177112m\1104121\STX\DC417,~\3514\SO\1071353Ze\58200\SOW\1099316 h\1091883/\SOH\EM1\a4\GS\1086744=\1077430N\147549\&5\EM\997507\63121\119025\ENQ\1066003z\100958M\DLEzjMOt\1073319:\1017862*\16993\96231\SOHX\STXm\CANu\NUL\110651.\FS^\1080562M/\169642\1007425\&3UJ\NUL]\1090144`4\1054369<0$\411\ETX\DC16\818A\1110569\SO.\180475\1089094\\\1047981\16200#\t3y\RS\f\11238\v-FO1'dC3 \988541!\1109624\NAK}p\137074 \t\ETX\1089664\ETB\DEL>\1033232]\SO]\41807\ENQz A\48291\1080313\998629{\SI\43105[\tM\38214h%{7\DLEA\990402>\169399nC&\1010809\f?\1089890\1045417SW'\134489Vi5\1063266T)\EOT<!\1060605A\SI\13527\&8&ku?e\tp'~,X6\EM\155844\DELJ\985623m(g@hXitI4K\ETXDu\ESC@r_\62065'kywhWvCG\184513>\136130\DC2\rA-2\1077967\171766E^\155561.\ENQGU\SIeK*j\ETB\1066886>|\1016171\161797N\995265\r/^?\DEL\176863SH[\48944F\1008201G;W\ETX.\\\54392\133906\1099838xPTzJOxK#+\SOHQS\ESC_\ENQ\987918\ETX/J\ACK\NAK\US\CAN\FS;\FSh\t\1075773\GS\1003463U\140135\STX\\{5\126649\1044119\163168\DLE'\1058566\SYNr{\126548Yn\1102570_\128667U\31090M2\a\1058972\RS\GS8\ESC<\1004867WJ\1083668\DLEj\NUL\175358@XnT\ENQagg&\SIj\STX:8\FSsD"
    }

testObject_DeleteProvider_provider_15 :: DeleteProvider
testObject_DeleteProvider_provider_15 =
  DeleteProvider
    { deleteProviderPassword =
        plainTextPassword6Unsafe
          "\RS\SOH\163246|\1081576&\1075890.N\GSU.3Oq\151879a\FS\DELH\SYNs\1076516\1106106\RS\1112048nH-LN\42248\&1\v\181047\1113105j\1001303C\1004626\&5g}\1065015cw\986165\1070943\61101:EvZ\174578(\13913\STXF\rs=\SI\44701k\140660\&9\1076022\1013260\tK\1041887\164216\1034762\1047302$o\r6\168682\&9f\169746\167284+P\1090200\1035482\172491zW\1102752i\992639&M\917933y(\ETB\ETB\1073015\1101769Z<A\DLEVmc{QWT>\nd\144149\59717!p\NUL>\1054017\&7\1009114h\170904\1100109E(\161156\ENQc\\\1077220\50624\&7vZ\2371rwu_\1053440]C\140470\1092234.\"5\US*\137224\&6\SUB\1046146\SUB8q\NAK\173329\63177A\167607=^a\1085502{\\*\83220\1003880\ENQ\10500l~W\1063837\DELT\DELr\1004181\DC1\DC2x?\49524wO}\r\EOT\144109*\1068005 \f\120687v\nBs\181134ja!\"oi\1037158)\ETX\74886gOW7-\DLE-\nP1A\63650O\1033878F\DC2\f.\ENQ]\DC2\134995vL\CANR\1063068\ESC>UMz+\1091884r\nDsb\163979\NAK\a \RS\96765\36103Zf@\ETB\SIm\SO5\nkr\FSc\996842\US\ACK\175700\1009400\&4r\74926:\1107913|7\SUBE\DC1\985699`C\150786^\57829\191390\1076416\FSeX=C\19389S\SYN_\39050\38611 \1092584\DEL\172018\NAK\23389\bi23U\8829.\DC4\US\EOT\GSc]_y\1074588H\47815\&3\ESCL\1092515\&3j\NUL\NAK\1101578,\12565:\r3\167203R,n\100484\ETB\DC3\DLEEPw\1075213\r\1027682P\1015026H0\46948\1009050tE\ENQ\aL`\ETX\39936\NULb\1092605\991410D(\63685\1025013\DC1\"\NULc\118802G\48098\a$\1031302\1093860I\27655>#\148108o\57701t2\1029904\&1\22701Mp\6046[W5\184395h\37434\vO\12585\985865)\NUL\143558W\t,@\EOT\994743\1097630G\27848\141382\EM8mc\8959\SYN\SYN/[\173572j\EM\20360\1111592\27686\ENQ3\1035412b\1037050\993709EFnU}9\1021599\1102061\ACK \ESC\1045396`\22327]\NAKx\74630W\1079807\t\6512\&5yR\1028421Nc0]:^\588:\ESC8uz>o\SIP,[\ESC{\1048188\170536w=]2\SO\1009630\EM\"\t\ESC\EOT1\DEL\41025\153517\&8\n\136032N]\"c*c1uH\ENQ0qjKC\1034529@&\168350\SUBb\1101720*d8\FS{\180679^\DC2\DC2\1035986\1112759\1025915\&7\155709\1103075\64400\40440\1039882\ACK\69406z)\DC2M#C\NUL])\ACK_D?\ACK>+}7^^<sG\ETX<\1007809=\NUL\60242A\EM\1007881^Q\bRu|+\1034020\1098965\1074308Q$PBQ\1021557\v\155588E\62992qwcb\147136 J5\1056199\146420\998068*7J\58374f\160303\1092344\1011929\1093451d\DLE\EOT\1028709Zt\b\1077031l\1076938\ETX#!|33\a$\133971\147906Z\DC4$Z\ETX\1102460R\1001615\&3y|\b3\40791oaY\1031931\ESC\1038508z\FS\21713_CX\1039546\1060470\1101386:G\v~F\168666m\1056300Jo\"\DC2X't\94888\DC2 2I\SIVW/wV\1110798W?C\988050z\1080655\1039814\&9\144926\74868\b\a?^\DC1Bw2,!x\b[O_\FS;c1'e7?y9\1062032\"\34643\SOH\145539\EOT\184462^oc\78875\a\SOQf\164513K<\140043t(;n+\16833\fl\ENQ| \ENQV']\NUL\179943AT\n0Dk\ESC\19651\137430'M9\1073363_A#6\145504\1030863@Q\51559GRR\GS\1032445q@\DC1c\ENQRf\1099753\SYN\1064098\167277.\ETB\DLE\DLE"
    }

testObject_DeleteProvider_provider_16 :: DeleteProvider
testObject_DeleteProvider_provider_16 =
  DeleteProvider
    { deleteProviderPassword =
        plainTextPassword6Unsafe
          "\1081796\CAN\54018b[2\DC1{|y\6834ALGcEv\ETXO\1043657\DC4\DLE\182436&\100395>*>\vOj\44865G/k\NAKZy\n\35781\DC4q\1018031P\151611:G\1106921v\1080679\n\1043025\21106d8\190025\DC3e7d\66589\991382\CANOY$KN@+\DC4y=tt\SYN\187543\v\996590OH(\26817\DC4\SUBB\1075843\&4Q\143566t\SYN-\\\b\19213w.\GS~\1057961rB\SI\1104286um\1026778\186266\&6\ETB^\ESC\US\RS\1060059\SUB\175508y\SOH\1031791n\FSty\166317\ESC|\n[\EM4\158389t\RS\t6K\GS\1062433]\NAKE%\DC3q^R0\94889Ya\1092835o\1103087&\1012475s#j,\1088050DYum\17114\53975\18506\170767\988594\1106611\138262!\98848\DELT_!1X\986364\1040882\GS\20624mA\1012611\15315U\SI\RS.v\rQ\SUB\78422eh\SOks:Ke\r\136392"
    }

testObject_DeleteProvider_provider_17 :: DeleteProvider
testObject_DeleteProvider_provider_17 =
  DeleteProvider
    { deleteProviderPassword =
        plainTextPassword6Unsafe
          "Y\1111686{C\SUB$)A5}\1037699r\64320i\EM\DC2l$\1080256B'/N#^(\165678\34179}\174928\1030133\f~hK5)*%a)o\1027470B\b\fm$F\98914v\147309(\158225\1097652\&6\1018954=>pzgR\68163D4\11771&\DC3?\99182\165889\ETB\ETBH`Lly#^Iz\"mp5'\1030424i\187500N\10233\1091522\12122\&3\\\1038681[XZb\1111103\1008586x\DEL\98369\DLEU!Q5\NUL\DC4Mi|M\NAKq\SYN\146639k\\R\NULx\DLE\47985R;V#=|=\ETB&\US\141694p1\ETX\DLE\1036965'\GS\DC4,b1\1001651\NULb(Q\SUBhu\EMD<\180686\159770\&9\SOHXm)\1055998\159683\1099970:9\99357hLfB#Fw`e\1013324\EOTFb\v\ETB\33707Y\SO-\917817\1075524R \1089165\SOHg*!2\ETB\1091876o33.I@8\190235l\1064222\SYN\1035414\37496\bhp-\US{\1076177E%r\"&\14430\DC29\r\NAKAb6\DC3\1102220\134593\38926\&6-U\ENQ\31570\21170^=\DLE\37772\141550\&5\ESCL\ETB-\1045961\1053532wo\1099915'vt\72729\SOH9\142176\78110\DC3\SYN\ESCI\142104\1029509l\EOT\163661\&7\DC2t\SO\1079897~$;\61461g\GS\51504\GS3\162463s\188827\28282rZL\989190L\1040493^h[h\1059704\18006\ETX\ACK\51711T\41593C\160950\1089468}-+U,B\43472\18750\DC2^\1109666\53210\119346\74988\1018132\GS\10434\1041335\25217\NUL\1055413\\q.2\ETBF\1071025\52062O\36781\60964\1017409k\1069787H\1087543;\167027\NAKr\994597b8!-\175535\19285\121482\59568\46793z\998810\1068682D\EMk\SUB#*\111355gzC\FSg-{\RS\96607W9\168210\151686\SUB4\DC2\DLEE\EOTr\156887\1110622r\a|eY3\167679x4\70151\&4\v\985172\DC4]\ENQ\DC4\9412\999921\9133(\61253O@`@\40016\DLE[Em\1020245/96f\186696Y}lftO\1052392_SiS\147632\23259\60158\USSL\ACK\v\EOT-{R\1033058k6 \70113\&3\ETX^\SOH\10941u%V\1111562\9529\71728g\47762D\16143J2?Z|\1049927\DC2Z\ETB\141688\DC3A\120792(@\183856\995526\ENQ\996855+\DC1D\DEL\5033\&8a6>\1036623\DC2P[\1024005\&3a5P\ENQ/\156230\151368\12046\&7B\ESCk\47755S\304%\1008766\1061238a\166179\NUL\133901Ya\58953hy\1080315g@\1073839\1034222BvE\DLE#Pe\1060144;\SI\1036063\1096979[U&\26840f;Bc\1065091R\1091793(l\ETX\1026868VT]%0\DC1\CANe\ETX\1011732\a\DC4\ACK4Y\t~\"a\1068011\"\1052055\"{a7\1084777(;J`\DELla(K0\SIeE\28309\18904~\171294\EOT\SI\999388\t=\1068077\1079397\1068594d3}8\21072\EOTM+\70402\1040161\52377\1061479# \1066933\1011184. \35779\\\SYN(V]}\EM\1046997z\1015251c\1059552>\148901\1025421z6\999624\1002310\SUB\39894\SYNY\12850rK9S\14047\996190ps\NUL^e\ACKS\1031053g\26960+\1011451\1024730^\a\1040759i\97575w\1075975\1061444\&4a\RS\FS\92968\1099246\135015\EOTE\35685ON$`\DLEG\118943l\1094375\137265$\5932\ACK\1095091\SO\1037386|\1074130^\1057249r\47614\FSw\ETX\1030398tH3m\187374\NUL\ETXop\182636"
    }

testObject_DeleteProvider_provider_18 :: DeleteProvider
testObject_DeleteProvider_provider_18 =
  DeleteProvider
    { deleteProviderPassword =
        plainTextPassword6Unsafe
          ";inV{\ACK:k<\159032'f\194800OO\171908Jg~\16950y \1063289\&4f\185251L8\1067002\NAKE)\n$[\153877\164020W)\1090118Vq\1076661\1056381\ETBv\FS3\"\44071L\ETXY3|\17433D.\175929\141623\35056OW\169598 c\993540\&9#c`]\DC2oZl\168383EYp04qh^u\\\119175\1102533\1049137PB:\DC2x\FS\1100667\ETBR&e\b\1029890\SYNVq\b\132190\t^q2\SYN\1106187C\186092\1091537|3H\1005501\129514Q\rQ\65896\\'%F5yon\180549g!*JR\DC3|_XT:\STX/\SI\1089648\1073482ts\1112740\156579\10425\ETB\996553\RS+\986289R}4\19735K.y\1021391\161879!6Qe\142179\1050604\188602\EOTv\172728H\DLE\toXZv\70156\&2\141492$\163293l\140322\1064732#\DC2\1045997\25474\NAK\vJ\1006867&B-^5A\1042940\ETXjz6R|{]f\1074871~..U }#s\132245\DEL\NUL\132562s|\94652\"\DEL\133115\DLE\CANLhq\1033726\ESC\v\1002946\1061222\&8\EOTEC\SI\144619cP\10760\DC2x\997216h\155878\&9\FSA}1\RSsx'\fK\7536DDH\8857\"QBw\NUL8\STX{~\ENQ\ETBB\RS\1053865:i\NUL]\FSuOG\28206\63332@|=#\EM'W9d*_@\ETXgo\995815\t\EOTh\SID?T9\181985\1020008m\143442>c\1001882\NULi\149569y\CAN\180906EPq\78481=I>\US\FS\SO\1094604\986242p\1033389\33784/\n\a~exe\996608&E|A\137812\ESC\169170GV\1065628:\1012118\983414\1082272m\33380\GS\ESC\1074967\b\154149*p~*=)g\ENQ\"\66625\r+\1038096\&1Mg*A\1060855h\v\45287>K }HCM\985362\SYN3tr\1040974) Fs+1R\148331\&4\183209\US\ENQ\1107835wp\7962\v\\\148159r\1067131u\185237\"'\163734$\FS\ESC5\1005766=#'\ACKa\1030348\1025970\1111229\&6hb\ENQ\bh\fz-\SOH\110742U\11663O\11334\NAK\1066984+>\1106918\1100386\133478\DEL$\DC4\1044763I\987097s\SI\14989s\DC4^q\GS42Y\ETXFI\FS6L\ETX\1053178&\989232\1036131\52123\1049385\&5\1090940|\ACK}0T\83124\1001336iP+[\EOTZ\\U\a\127841AZ\23434Ik\707#0`RB\DC2{\153322\"1\149405s\DC3V!<\164942\157369\1039498\121459\1032366\175383\50990iyh_\GSP=e}\190818a6\NAK=\ENQ\18951\a\1086109C\194976\152534\DC2N[\176451\1004378o\1110379{\NAK\1010009H%\186064e\DC4\ACK\67223\1031998P|\1072232O\SI"
    }

testObject_DeleteProvider_provider_19 :: DeleteProvider
testObject_DeleteProvider_provider_19 =
  DeleteProvider
    { deleteProviderPassword =
        plainTextPassword6Unsafe
          "Kl\ENQBCU\1040121X^\119359\bK&\SYN>ij\a\20640\n+R\1053680%^'\38115jae@?\1043893\121467uy:2@'y Q\SOF\t\57777Q\995951\1077777km4\USx2\1095595X\1098369\67400\SOH44\1031165z%\1082145B\ESC\1046966\145847\175890\SOH\128321\1006495-3LD\STX)f\140657?\US\n\152489\&3\ESC\190466<y_\152314\989444i@g&\131652P\DC3o\30658:7$GU\SO\160588\40659\&4sbo\ENQ\46273Zk\\\1029882.p<\1014929D_\158043L_S*B\1027749T\1015579\1046430t\997380iO\1084285;E\30060lM\131644\994746\ACK\1044118^\1053005s\1027530\993199R[<\GS\ETX\178277\1052550?^?\1036533\ETBm\992818G}\DELK\a~\187\SI[\ETX\150124\22181\DC1=zr\GSF\"\vw\1012298\a7L%mC\SOH\RS\159427\1034266j,<\ETXF\1025290\26585lJC~K\1058930#n\139669\DLE?`\1086743\&2]\29844\1009193U\48628\DC3}CkP\24230,*\164994\SYN\1026306*\SO\1050113<j\1069204l^v\ETX\1026678^\45690a3v(yz\bj\EOT2\172127$@1\f\995909\NAK~y\987270\CAN\1000564Qcv\20523\1098321\194683dI<\1037941G\48537\EOTy\EMVr\NUL\186351(\SOHz\DEL\ENQ%(\132735v\SUBEWcrY]'\STX\GS\ETBC\CAN5\1091055^_\a\"\41376\128326P\DC3\DEL|O\1019274i\47069=\CAN5\ETXxl\bvm\US,G:~\ENQY\SOCF\SYN#\49840HZN-p\59653\nd\29353}Re`\EOT\ENQM\63434\STX6\126218\1066648\97498|IA*\SOHc\1011058[\1033208\RS\1035952avPC\1985\nMV\158424Jo\1021957\&9H\158304\992518m\34043NX\96245\1022438Pc\181340#\139708|\SOH\DC4\1055138`\150318.Ud\187802\DC4\"\154241S\ACKF\1084544V\DC4\1072237\53652\34156\&0\1105265\ETXo.\ETBG.n~\bT@#v\1053085\&9\GS\DELj\1012418o\1007703\DC45PeKO*Nd\37921\t'&B\NAKEMq4m\1082125j\SOH3\983815\1079522\62341|\\\EMX\fK\NUL\USW\1048597\163910\b#rL\134609\SOH0I\FSexU*\5742t{\DC3\94734N4\1053742MND\ENQ\83119F\DC35Q9\DC3&\ESC\DC1Z#Y\ETB\ACK\1015421J\1030635\1041370\"}r\SI\r\1042671SR)<g&]t\1081863\120032\1021052`\132820\DLE\b\1031528t\SIq=L.\33448\1069573:\1025815\159905m%Hs!j\ACKP\8728#9o\39525nm\51527^f\1101574\RS\154004]>tI\DELH\FS%!\26875\ETB0\34759L\ETB\178829o\188053\aEs\994404|0\6918\&8(b!xZz\14160C\4765\ACK\NAKS/\STX\ETXm\993644E\24839E\1010197\NAK\1094339\&6\bU\1084257\NUL\1089839\EMoM\a\151540H\SYN\EOT\t\59644p]wK\160326\131200\170825oCzL\NUL\37401\6800`\1008455\SOH`\155066F+B\191214\DC4s\GS\1107951\1011415\145930\1011719*Va\1016814\&3\92352U\1041768$\986653\170164i\150222\40514s\6185K\152534\1068598\&6a\1112830A\CANyO\4385\SIf\1066008\1027423;\GS\ACK\DC1H\ETB9$\1077719\40661-5\1081849h\GS\1006428\SO\ETX{\\BCh:Vh\ESCv\r.\142946\1012400fo\186827\1092563\188990no\ETX8\v\"/j\1003711\1102444bHq)s\CAN~q\54496\ACK2\1085077\984760\GS|\n\990808R\165347Me#/_\46160\FS3\ETX\22209&L\b'pT\"UR\996906+=>^\SO5?r\187101}Q:\NUL3/$6\43895\1078788"
    }

testObject_DeleteProvider_provider_20 :: DeleteProvider
testObject_DeleteProvider_provider_20 =
  DeleteProvider
    { deleteProviderPassword =
        plainTextPassword6Unsafe
          ",P\NUL/\1062674c\1025500\ETX\DC2\1092782\7515\10241\1051631\f xY}\51863\166763Ys^>\\&\1101626\DLE@%\1001692l\1048977\r\SYN\EOT\1098659uJ\1090892\1001335\176845zR\tm\991213\EOT\1104050S:\NULq~\78186QQj\134242FFS\ESCT\1041187C\DC45/4\41800L\1021674]nn\ESC:&zx\23773DY*se)Gjyt\SI\DEL\63167t\b\158189\1011791\74151\186784\988726q\1054928\128241\1084393\1083799\RS\157739\140294/>y\nB*WG\US\ACK?E\1077605\SOH\ACK`F\NULwv\USBFZEi\1057971\1071701\"(\ENQ\SYNw\10435qD\ACK{\1045581\NAK\1000974?@\1054465\ESCd\160366\14434\EOT\SO[[2Q\71914q\ETX8\186443\17218\DC4<J\DC1\DC29\NUL*\43647sD+<\46312v4\n\DLEVM\1084279\61639\&2F\129029V'Fd\CAN);xg3*OZq:\DC1\SOH\46801\&3\1024552Wrb@\65093\1046968\68341\150728\&0\164134.\"<\3668+\1020154x\NAK:*2\1015872q?\1086385A\NULZ\1040302s\USP\120719\1066405\b\DEL\nr`\ENQ1\10766CPOD4\NUL8\1015434$\nh\\HQ?\45686 \CANIg\ETBvxmG\177649\1009613\&5\1081524\DC1\14769\SYN^\US\188633;7:\1065177h\tF\1055799\FS\ETB\\B\161891\t3\n\a1#Pq\ETX\168359\DC1)\SIu\ACK\1041296aUk\59258\NUL \USw\ESCF\1014208@\ETX.\1099909i\DC3\152486<\1060156\20522G&oA\1060015:\184905G\1085380\rvG{\60897O[`W#l:\DC3\1069012(?\SI'Y\168662\&9Qo\nh\1057464\SUB\60108\v\ETBR0WFx^\51621\12835%\SO=v)\FS\15885\n\64724\100580\147591If\1002493\1108652\139277H\FS?}V\bT>[\SO<9F\SI/:\135535\vp\ACK*X\38920# x=(\148764\94655\1031460\19272$iWu\159354\174694\SIDXF\"\1102911:r\NULI\1022649\EOT+\1033453\DC2x\STX\NUL\1023640{r\NUL]\STX<q\v\191385Q\r\DC1#\ENQ(\ETBz'\SOH\DC2\r\22366A\182696\146309z\52265\1025948N!\58870\&1\DC1DEJ\r\ESC\DC3h\EM\2969\1046861\1015802\FS5t`}O\CANbM\1057076~\v\SUBh\59441\1084844zt/J\a<\1032001\DC1># \60640\1092332S\20202w\71172;\DELFo\a\SO\67356hzv\1000950iJZZ\47361I?|~Zz\n$N7\182716s\a\NAKHG\ETX_zp\SOH]\ESC\7155H#?uu\v\181957J\a\EM3\58109#9\r\DEL\NAK\127271/v-\1096160s\7800-\SUB=\1045407\997527\191133\993768\998501Z`\19245\68758DY\140737\178607\98172#\1097525\&9\DLEahKQ!wk{c\157906\&4\132479?\t<O:{1%\2497ta\19606\171822\991680\144647\"\190539m)m\78648l\SUBTV}-(d\143778\190148\1113205LC\am\1048557q\b\1075344\SUBk\DC1yh\1043095\46436\148793\1097998\53492\8833\1029154q\31451\STX\1113810$\72288\131924.g\1097919\132666,\1089536KZ\vJ\1056978^\35721me\40222M\142754wE\96790iG\"Y\GSfkU\ETX\35188\DLE\EOT\1061275#*0\1017304\191092\28096m"
    }
