{-# LANGUAGE OverloadedLists #-}

-- This file is part of the Wire Server implementation.
--
-- Copyright (C) 2022 Wire Swiss GmbH <opensource@wire.com>
--
-- This program is free software: you can redistribute it and/or modify it under
-- the terms of the GNU Affero General Public License as published by the Free
-- Software Foundation, either version 3 of the License, or (at your option) any
-- later version.
--
-- This program is distributed in the hope that it will be useful, but WITHOUT
-- ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
-- FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
-- details.
--
-- You should have received a copy of the GNU Affero General Public License along
-- with this program. If not, see <https://www.gnu.org/licenses/>.

module Test.Wire.API.Golden.Generated.CookieList_user where

import Imports (Maybe (Just, Nothing), read)
import Wire.API.User.Auth
  ( Cookie (Cookie),
    CookieId (CookieId, cookieIdNum),
    CookieLabel (CookieLabel, cookieLabelText),
    CookieList (..),
    CookieType (PersistentCookie, SessionCookie),
  )

testObject_CookieList_user_1 :: CookieList
testObject_CookieList_user_1 =
  CookieList
    { cookieList =
        [ Cookie
            (CookieId {cookieIdNum = 1})
            PersistentCookie
            (read "1864-05-09 08:11:45.247059932094 UTC")
            (read "1864-05-09 16:19:23.612072754054 UTC")
            Nothing
            (Just (CookieId {cookieIdNum = 0}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            SessionCookie
            (read "1864-05-09 12:23:41.340450966061 UTC")
            (read "1864-05-09 16:26:21.672514665806 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 1}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            SessionCookie
            (read "1864-05-09 00:30:18.630967130428 UTC")
            (read "1864-05-09 16:27:25.033827715997 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 0}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            SessionCookie
            (read "1864-05-09 01:38:25.011758527197 UTC")
            (read "1864-05-09 00:53:49.0388530702 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 0}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            SessionCookie
            (read "1864-05-09 08:15:25.293754839567 UTC")
            (read "1864-05-09 03:04:32.680681666495 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 1}))
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            PersistentCookie
            (read "1864-05-09 07:13:26.879210569284 UTC")
            (read "1864-05-09 22:44:15.24273381487 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 0}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            SessionCookie
            (read "1864-05-09 03:29:48.880520840213 UTC")
            (read "1864-05-09 13:14:10.114388869333 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 1}))
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            SessionCookie
            (read "1864-05-09 20:03:42.485268756732 UTC")
            (read "1864-05-09 15:10:30.315157691402 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            Nothing
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            SessionCookie
            (read "1864-05-09 13:32:43.602366474813 UTC")
            (read "1864-05-09 10:38:51.062644241792 UTC")
            Nothing
            (Just (CookieId {cookieIdNum = 0}))
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            PersistentCookie
            (read "1864-05-09 01:25:21.950720939454 UTC")
            (read "1864-05-09 15:05:12.304221339079 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 1}))
            ()
        ]
    }

testObject_CookieList_user_2 :: CookieList
testObject_CookieList_user_2 =
  CookieList
    { cookieList =
        [ Cookie
            (CookieId {cookieIdNum = 1})
            SessionCookie
            (read "1864-05-09 22:19:39.925259747571 UTC")
            (read "1864-05-09 04:30:18.185378588445 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            Nothing
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            SessionCookie
            (read "1864-05-09 08:39:54.342548571166 UTC")
            (read "1864-05-09 18:28:31.576724733065 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 1}))
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            SessionCookie
            (read "1864-05-09 23:54:29.966336228433 UTC")
            (read "1864-05-09 15:35:01.695251247096 UTC")
            Nothing
            (Just (CookieId {cookieIdNum = 1}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            PersistentCookie
            (read "1864-05-09 04:20:31.592673496648 UTC")
            (read "1864-05-09 19:59:24.79675052948 UTC")
            Nothing
            (Just (CookieId {cookieIdNum = 0}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            SessionCookie
            (read "1864-05-09 00:17:18.209473244544 UTC")
            (read "1864-05-09 08:56:09.569836364185 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            Nothing
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            SessionCookie
            (read "1864-05-09 01:27:05.499052889737 UTC")
            (read "1864-05-09 19:07:47.285063809584 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 0}))
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            PersistentCookie
            (read "1864-05-09 04:27:10.027218640074 UTC")
            (read "1864-05-09 15:02:40.621672564484 UTC")
            Nothing
            (Just (CookieId {cookieIdNum = 1}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            PersistentCookie
            (read "1864-05-09 17:52:24.162768351125 UTC")
            (read "1864-05-09 19:47:14.34928403508 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 1}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            PersistentCookie
            (read "1864-05-09 14:40:37.509012674163 UTC")
            (read "1864-05-09 02:05:47.644898374187 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 1}))
            ()
        ]
    }

testObject_CookieList_user_3 :: CookieList
testObject_CookieList_user_3 =
  CookieList
    { cookieList =
        [ Cookie
            (CookieId {cookieIdNum = 0})
            PersistentCookie
            (read "1864-05-09 01:27:25.557815452016 UTC")
            (read "1864-05-09 05:20:38.194678667052 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            Nothing
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            SessionCookie
            (read "1864-05-09 05:43:23.971529012662 UTC")
            (read "1864-05-09 02:53:38.455864708797 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            Nothing
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            PersistentCookie
            (read "1864-05-09 16:36:50.475665468766 UTC")
            (read "1864-05-09 22:30:52.701870277174 UTC")
            Nothing
            Nothing
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            SessionCookie
            (read "1864-05-09 21:37:19.243912276549 UTC")
            (read "1864-05-09 00:26:08.451232804077 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            Nothing
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            SessionCookie
            (read "1864-05-09 01:20:39.296454423491 UTC")
            (read "1864-05-09 15:01:33.122231286251 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 0}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            SessionCookie
            (read "1864-05-09 13:53:46.838517153788 UTC")
            (read "1864-05-09 11:30:45.539559560638 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 1}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            SessionCookie
            (read "1864-05-09 18:04:19.816315114891 UTC")
            (read "1864-05-09 04:56:50.534152910338 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            Nothing
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            SessionCookie
            (read "1864-05-09 15:39:15.937068331222 UTC")
            (read "1864-05-09 13:49:06.675383967114 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            Nothing
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            SessionCookie
            (read "1864-05-09 11:04:07.726296806999 UTC")
            (read "1864-05-09 06:32:10.667028238269 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 1}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            PersistentCookie
            (read "1864-05-09 02:25:05.446979993128 UTC")
            (read "1864-05-09 11:23:36.038765999786 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            Nothing
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            SessionCookie
            (read "1864-05-09 01:53:39.407752379484 UTC")
            (read "1864-05-09 03:45:15.602509018717 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 1}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            SessionCookie
            (read "1864-05-09 05:36:47.625411610475 UTC")
            (read "1864-05-09 18:17:43.492825079869 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            Nothing
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            PersistentCookie
            (read "1864-05-09 02:23:35.872761506436 UTC")
            (read "1864-05-09 13:27:54.741895768202 UTC")
            Nothing
            (Just (CookieId {cookieIdNum = 0}))
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            SessionCookie
            (read "1864-05-09 10:28:24.868631031378 UTC")
            (read "1864-05-09 17:15:13.501502999199 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 1}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            PersistentCookie
            (read "1864-05-09 01:26:44.617166083564 UTC")
            (read "1864-05-09 05:44:07.442049379405 UTC")
            Nothing
            Nothing
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            SessionCookie
            (read "1864-05-09 13:47:18.386913379894 UTC")
            (read "1864-05-09 15:19:03.601505694263 UTC")
            Nothing
            (Just (CookieId {cookieIdNum = 0}))
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            PersistentCookie
            (read "1864-05-09 13:06:58.743967376954 UTC")
            (read "1864-05-09 19:17:18.167156642404 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 1}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            SessionCookie
            (read "1864-05-09 21:23:34.336759134675 UTC")
            (read "1864-05-09 08:47:11.021709818734 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 1}))
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            PersistentCookie
            (read "1864-05-09 16:10:24.643222325816 UTC")
            (read "1864-05-09 19:15:56.335527820672 UTC")
            Nothing
            (Just (CookieId {cookieIdNum = 0}))
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            PersistentCookie
            (read "1864-05-09 15:40:20.805988933454 UTC")
            (read "1864-05-09 19:49:23.296340858621 UTC")
            Nothing
            Nothing
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            PersistentCookie
            (read "1864-05-09 15:30:40.550989406474 UTC")
            (read "1864-05-09 01:32:05.586237465851 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 0}))
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            PersistentCookie
            (read "1864-05-09 07:24:46.114369594397 UTC")
            (read "1864-05-09 22:43:01.421438522142 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 1}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            PersistentCookie
            (read "1864-05-09 07:50:01.995354759779 UTC")
            (read "1864-05-09 09:01:18.013357675717 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 1}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            SessionCookie
            (read "1864-05-09 20:03:54.418818066667 UTC")
            (read "1864-05-09 12:59:11.322184322816 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            Nothing
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            PersistentCookie
            (read "1864-05-09 04:59:17.24854512091 UTC")
            (read "1864-05-09 15:29:41.78704703621 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 0}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            PersistentCookie
            (read "1864-05-09 12:49:18.045557329831 UTC")
            (read "1864-05-09 20:46:55.228537922885 UTC")
            Nothing
            (Just (CookieId {cookieIdNum = 1}))
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            PersistentCookie
            (read "1864-05-09 13:41:49.602725874348 UTC")
            (read "1864-05-09 10:05:12.943838359329 UTC")
            Nothing
            (Just (CookieId {cookieIdNum = 1}))
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            PersistentCookie
            (read "1864-05-09 11:34:22.2140404788 UTC")
            (read "1864-05-09 02:05:51.050444108567 UTC")
            Nothing
            (Just (CookieId {cookieIdNum = 0}))
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            SessionCookie
            (read "1864-05-09 12:04:47.125300697894 UTC")
            (read "1864-05-09 01:25:14.385551280732 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 1}))
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            SessionCookie
            (read "1864-05-09 21:20:52.163408857872 UTC")
            (read "1864-05-09 15:18:07.231580997227 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            Nothing
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            SessionCookie
            (read "1864-05-09 13:44:02.471530610404 UTC")
            (read "1864-05-09 06:38:59.669089688544 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 0}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            SessionCookie
            (read "1864-05-09 05:33:48.288298198745 UTC")
            (read "1864-05-09 01:59:32.505125066582 UTC")
            Nothing
            (Just (CookieId {cookieIdNum = 1}))
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            SessionCookie
            (read "1864-05-09 00:44:56.438503040562 UTC")
            (read "1864-05-09 21:00:07.48604242911 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 1}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            PersistentCookie
            (read "1864-05-09 07:20:47.968477268183 UTC")
            (read "1864-05-09 23:52:06.472967194305 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            Nothing
            ()
        ]
    }

testObject_CookieList_user_4 :: CookieList
testObject_CookieList_user_4 =
  CookieList
    { cookieList =
        [ Cookie
            (CookieId {cookieIdNum = 1})
            PersistentCookie
            (read "1864-05-09 22:43:55.881865613322 UTC")
            (read "1864-05-09 08:56:47.675779265864 UTC")
            Nothing
            Nothing
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            SessionCookie
            (read "1864-05-09 20:00:55.407915876625 UTC")
            (read "1864-05-09 07:46:54.345549772213 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 0}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            PersistentCookie
            (read "1864-05-09 04:07:57.947385008952 UTC")
            (read "1864-05-09 19:25:27.529068654403 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 1}))
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            SessionCookie
            (read "1864-05-09 02:20:26.147424008137 UTC")
            (read "1864-05-09 05:49:43.73124293629 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            Nothing
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            SessionCookie
            (read "1864-05-09 00:14:24.709257954742 UTC")
            (read "1864-05-09 04:01:49.187385201039 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 0}))
            ()
        ]
    }

testObject_CookieList_user_5 :: CookieList
testObject_CookieList_user_5 =
  CookieList
    { cookieList =
        [ Cookie
            (CookieId {cookieIdNum = 0})
            PersistentCookie
            (read "1864-05-09 02:24:33.409929272836 UTC")
            (read "1864-05-09 09:28:14.894312093718 UTC")
            Nothing
            (Just (CookieId {cookieIdNum = 1}))
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            PersistentCookie
            (read "1864-05-09 22:16:21.031766916159 UTC")
            (read "1864-05-09 02:17:58.908743803962 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            Nothing
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            SessionCookie
            (read "1864-05-09 23:58:40.43481054969 UTC")
            (read "1864-05-09 01:08:15.083891456454 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            Nothing
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            PersistentCookie
            (read "1864-05-09 07:52:00.957508665782 UTC")
            (read "1864-05-09 10:58:02.674587451183 UTC")
            Nothing
            (Just (CookieId {cookieIdNum = 0}))
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            SessionCookie
            (read "1864-05-09 04:11:22.130421642978 UTC")
            (read "1864-05-09 04:55:18.957214306738 UTC")
            Nothing
            (Just (CookieId {cookieIdNum = 1}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            PersistentCookie
            (read "1864-05-09 00:12:35.717981578059 UTC")
            (read "1864-05-09 07:46:10.51530247067 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            Nothing
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            SessionCookie
            (read "1864-05-09 14:53:57.714043632542 UTC")
            (read "1864-05-09 12:22:56.570590160379 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 1}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            SessionCookie
            (read "1864-05-09 16:12:21.802019785973 UTC")
            (read "1864-05-09 10:17:31.721949677856 UTC")
            Nothing
            Nothing
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            PersistentCookie
            (read "1864-05-09 00:24:07.508270461346 UTC")
            (read "1864-05-09 14:20:30.637854904307 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 0}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            SessionCookie
            (read "1864-05-09 01:02:43.844591482658 UTC")
            (read "1864-05-09 10:10:08.846001197278 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 0}))
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            PersistentCookie
            (read "1864-05-09 16:55:15.663670762289 UTC")
            (read "1864-05-09 08:40:35.826337206312 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 1}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            PersistentCookie
            (read "1864-05-09 01:50:42.873693144224 UTC")
            (read "1864-05-09 18:41:46.968652247087 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            Nothing
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            PersistentCookie
            (read "1864-05-09 20:41:45.103795474205 UTC")
            (read "1864-05-09 20:45:46.921795958856 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            Nothing
            ()
        ]
    }

testObject_CookieList_user_6 :: CookieList
testObject_CookieList_user_6 = CookieList {cookieList = []}

testObject_CookieList_user_7 :: CookieList
testObject_CookieList_user_7 =
  CookieList
    { cookieList =
        [ Cookie
            (CookieId {cookieIdNum = 0})
            PersistentCookie
            (read "1864-05-09 11:14:58.099749644105 UTC")
            (read "1864-05-09 20:24:55.029381103828 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 0}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            SessionCookie
            (read "1864-05-09 10:06:10.491020367007 UTC")
            (read "1864-05-09 15:04:30.093775016306 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            Nothing
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            PersistentCookie
            (read "1864-05-09 00:16:19.909453661738 UTC")
            (read "1864-05-09 05:54:39.512772120746 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 0}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            SessionCookie
            (read "1864-05-09 18:26:23.718288941861 UTC")
            (read "1864-05-09 16:11:38.770254728195 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 0}))
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            PersistentCookie
            (read "1864-05-09 15:13:20.879830850957 UTC")
            (read "1864-05-09 01:25:18.552525669912 UTC")
            Nothing
            Nothing
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            PersistentCookie
            (read "1864-05-09 22:54:28.824084324791 UTC")
            (read "1864-05-09 17:04:10.053358596502 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 0}))
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            PersistentCookie
            (read "1864-05-09 02:27:17.023081634382 UTC")
            (read "1864-05-09 01:10:27.638644713358 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 1}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            PersistentCookie
            (read "1864-05-09 20:54:04.990126375152 UTC")
            (read "1864-05-09 00:53:54.744162891679 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 0}))
            ()
        ]
    }

testObject_CookieList_user_8 :: CookieList
testObject_CookieList_user_8 =
  CookieList
    { cookieList =
        [ Cookie
            (CookieId {cookieIdNum = 3})
            PersistentCookie
            (read "1864-05-05 03:14:14.790089963935 UTC")
            (read "1864-05-12 17:48:11.290884688409 UTC")
            (Just (CookieLabel {cookieLabelText = "L"}))
            (Just (CookieId {cookieIdNum = 1}))
            ()
        ]
    }

testObject_CookieList_user_9 :: CookieList
testObject_CookieList_user_9 =
  CookieList
    { cookieList =
        [ Cookie
            (CookieId {cookieIdNum = 2})
            SessionCookie
            (read "1864-05-09 12:01:58.187598453223 UTC")
            (read "1864-05-06 13:12:12.711748693487 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 3}))
            ()
        ]
    }

testObject_CookieList_user_10 :: CookieList
testObject_CookieList_user_10 =
  CookieList
    { cookieList =
        [ Cookie
            (CookieId {cookieIdNum = 0})
            PersistentCookie
            (read "1864-05-09 04:57:13.636138144232 UTC")
            (read "1864-05-09 06:08:36.968195238867 UTC")
            Nothing
            Nothing
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            SessionCookie
            (read "1864-05-09 23:50:51.792305176524 UTC")
            (read "1864-05-09 03:18:04.608330256629 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 0}))
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            PersistentCookie
            (read "1864-05-09 10:32:27.054576834831 UTC")
            (read "1864-05-09 23:13:27.56360005727 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 0}))
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            SessionCookie
            (read "1864-05-09 21:38:37.888899460143 UTC")
            (read "1864-05-09 21:55:16.206930486572 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 1}))
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            PersistentCookie
            (read "1864-05-09 11:09:02.103624280483 UTC")
            (read "1864-05-09 01:56:31.540275991461 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 0}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            PersistentCookie
            (read "1864-05-09 14:48:28.152138016055 UTC")
            (read "1864-05-09 15:27:07.486485718422 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            Nothing
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            PersistentCookie
            (read "1864-05-09 07:55:47.416846033422 UTC")
            (read "1864-05-09 11:24:43.689150545273 UTC")
            Nothing
            (Just (CookieId {cookieIdNum = 0}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            PersistentCookie
            (read "1864-05-09 07:04:46.718340155686 UTC")
            (read "1864-05-09 09:46:41.711855764238 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 0}))
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            SessionCookie
            (read "1864-05-09 04:39:39.746532251047 UTC")
            (read "1864-05-09 17:35:50.22617001945 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 0}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            SessionCookie
            (read "1864-05-09 12:07:58.91972156339 UTC")
            (read "1864-05-09 01:24:39.345224418125 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 0}))
            ()
        ]
    }

testObject_CookieList_user_11 :: CookieList
testObject_CookieList_user_11 =
  CookieList
    { cookieList =
        [ Cookie
            (CookieId {cookieIdNum = 2})
            SessionCookie
            (read "1864-05-13 08:19:14.217624017961 UTC")
            (read "1864-05-05 05:14:27.024865656105 UTC")
            (Just (CookieLabel {cookieLabelText = "\r8^"}))
            (Just (CookieId {cookieIdNum = 4}))
            ()
        ]
    }

testObject_CookieList_user_12 :: CookieList
testObject_CookieList_user_12 = CookieList {cookieList = []}

testObject_CookieList_user_13 :: CookieList
testObject_CookieList_user_13 =
  CookieList
    { cookieList =
        [ Cookie
            (CookieId {cookieIdNum = 1})
            PersistentCookie
            (read "1864-05-10 17:25:06.901627917177 UTC")
            (read "1864-05-10 23:16:48.964734609311 UTC")
            (Just (CookieLabel {cookieLabelText = "A"}))
            (Just (CookieId {cookieIdNum = 0}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            PersistentCookie
            (read "1864-05-08 00:59:53.715758102357 UTC")
            (read "1864-05-09 02:53:10.370977876871 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 0}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            SessionCookie
            (read "1864-05-10 04:00:37.506988047232 UTC")
            (read "1864-05-09 20:15:08.356758949536 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 1}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            PersistentCookie
            (read "1864-05-08 23:15:35.154377472412 UTC")
            (read "1864-05-10 22:54:59.641375513427 UTC")
            (Just (CookieLabel {cookieLabelText = "\b"}))
            (Just (CookieId {cookieIdNum = 1}))
            ()
        ]
    }

testObject_CookieList_user_14 :: CookieList
testObject_CookieList_user_14 =
  CookieList
    { cookieList =
        [ Cookie
            (CookieId {cookieIdNum = 2})
            PersistentCookie
            (read "1864-05-08 13:06:48.101997018718 UTC")
            (read "1864-05-09 12:29:39.285437577229 UTC")
            Nothing
            (Just (CookieId {cookieIdNum = 0}))
            (),
          Cookie
            (CookieId {cookieIdNum = 2})
            PersistentCookie
            (read "1864-05-11 18:36:14.96072575364 UTC")
            (read "1864-05-08 20:00:26.995784443177 UTC")
            (Just (CookieLabel {cookieLabelText = "y\46839"}))
            (Just (CookieId {cookieIdNum = 2}))
            ()
        ]
    }

testObject_CookieList_user_15 :: CookieList
testObject_CookieList_user_15 =
  CookieList
    { cookieList =
        [ Cookie
            (CookieId {cookieIdNum = 0})
            PersistentCookie
            (read "1864-05-09 23:42:22.463805358522 UTC")
            (read "1864-05-09 18:28:03.932826813077 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 0}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            SessionCookie
            (read "1864-05-09 15:46:20.719053342851 UTC")
            (read "1864-05-09 02:45:00.119890827496 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 1}))
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            PersistentCookie
            (read "1864-05-09 15:04:00.936256506363 UTC")
            (read "1864-05-09 09:08:56.792900807158 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            Nothing
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            PersistentCookie
            (read "1864-05-09 23:09:22.403535680059 UTC")
            (read "1864-05-09 07:57:11.854146729099 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 1}))
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            PersistentCookie
            (read "1864-05-09 09:43:36.838179452985 UTC")
            (read "1864-05-09 10:23:43.915798699963 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            Nothing
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            PersistentCookie
            (read "1864-05-09 09:49:18.595961881808 UTC")
            (read "1864-05-09 10:51:57.490564487066 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 1}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            SessionCookie
            (read "1864-05-09 02:11:22.633124161057 UTC")
            (read "1864-05-09 06:14:08.602895294174 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 1}))
            ()
        ]
    }

testObject_CookieList_user_16 :: CookieList
testObject_CookieList_user_16 =
  CookieList
    { cookieList =
        [ Cookie
            (CookieId {cookieIdNum = 0})
            PersistentCookie
            (read "1864-05-09 12:00:27.276658197151 UTC")
            (read "1864-05-09 01:54:16.672289842468 UTC")
            Nothing
            (Just (CookieId {cookieIdNum = 0}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            PersistentCookie
            (read "1864-05-09 16:01:15.129996103969 UTC")
            (read "1864-05-09 05:49:57.556804885534 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            Nothing
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            SessionCookie
            (read "1864-05-09 05:55:16.46479580635 UTC")
            (read "1864-05-09 20:42:10.458648722298 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            Nothing
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            SessionCookie
            (read "1864-05-09 11:15:08.365259295213 UTC")
            (read "1864-05-09 18:00:18.662996900631 UTC")
            Nothing
            (Just (CookieId {cookieIdNum = 0}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            SessionCookie
            (read "1864-05-09 11:45:20.397833179427 UTC")
            (read "1864-05-09 07:07:18.247068306493 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 0}))
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            PersistentCookie
            (read "1864-05-09 01:42:04.76385204735 UTC")
            (read "1864-05-09 16:46:25.33589399408 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 1}))
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            SessionCookie
            (read "1864-05-09 03:25:44.710313848676 UTC")
            (read "1864-05-09 19:46:29.959694540229 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 0}))
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            SessionCookie
            (read "1864-05-09 16:59:32.170300107165 UTC")
            (read "1864-05-09 14:56:15.800372774188 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 0}))
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            SessionCookie
            (read "1864-05-09 21:04:37.60538916949 UTC")
            (read "1864-05-09 12:14:07.019845858128 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 1}))
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            PersistentCookie
            (read "1864-05-09 00:25:48.382730928676 UTC")
            (read "1864-05-09 02:41:51.123612675322 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            Nothing
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            SessionCookie
            (read "1864-05-09 19:14:33.950057302805 UTC")
            (read "1864-05-09 01:47:05.737848270671 UTC")
            Nothing
            (Just (CookieId {cookieIdNum = 0}))
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            PersistentCookie
            (read "1864-05-09 04:44:31.697866013259 UTC")
            (read "1864-05-09 04:07:44.709319258579 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 1}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            SessionCookie
            (read "1864-05-09 21:33:23.515716434732 UTC")
            (read "1864-05-09 06:15:22.054257588544 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 1}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            SessionCookie
            (read "1864-05-09 03:39:01.113036868526 UTC")
            (read "1864-05-09 21:39:55.354063482533 UTC")
            Nothing
            (Just (CookieId {cookieIdNum = 1}))
            ()
        ]
    }

testObject_CookieList_user_17 :: CookieList
testObject_CookieList_user_17 =
  CookieList
    { cookieList =
        [ Cookie
            (CookieId {cookieIdNum = 0})
            PersistentCookie
            (read "1864-05-09 21:38:36.962487709315 UTC")
            (read "1864-05-09 17:24:08.4207201721 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 1}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            PersistentCookie
            (read "1864-05-09 05:32:54.535236659092 UTC")
            (read "1864-05-09 02:08:31.382135612599 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 1}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            PersistentCookie
            (read "1864-05-09 02:58:57.072719529853 UTC")
            (read "1864-05-09 19:37:02.8130152956 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            Nothing
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            PersistentCookie
            (read "1864-05-09 23:51:38.654707901616 UTC")
            (read "1864-05-09 03:57:54.743030292927 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 0}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            SessionCookie
            (read "1864-05-09 04:36:48.48199209557 UTC")
            (read "1864-05-09 05:21:46.868629016909 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            Nothing
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            PersistentCookie
            (read "1864-05-09 04:07:33.742323455186 UTC")
            (read "1864-05-09 19:38:39.447967135478 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 1}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            SessionCookie
            (read "1864-05-09 08:44:40.136721832699 UTC")
            (read "1864-05-09 03:39:04.647771815878 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 0}))
            ()
        ]
    }

testObject_CookieList_user_18 :: CookieList
testObject_CookieList_user_18 =
  CookieList
    { cookieList =
        [ Cookie
            (CookieId {cookieIdNum = 2})
            PersistentCookie
            (read "1864-05-10 20:39:22.959383769615 UTC")
            (read "1864-05-11 06:07:15.274794340493 UTC")
            Nothing
            (Just (CookieId {cookieIdNum = 1}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            PersistentCookie
            (read "1864-05-08 19:20:12.20001762321 UTC")
            (read "1864-05-09 19:29:38.456132738603 UTC")
            Nothing
            (Just (CookieId {cookieIdNum = 1}))
            ()
        ]
    }

testObject_CookieList_user_19 :: CookieList
testObject_CookieList_user_19 =
  CookieList
    { cookieList =
        [ Cookie
            (CookieId {cookieIdNum = 0})
            PersistentCookie
            (read "1864-05-09 22:44:30.730713163284 UTC")
            (read "1864-05-09 16:18:29.456765614188 UTC")
            (Just (CookieLabel {cookieLabelText = "\1076326\998540"}))
            (Just (CookieId {cookieIdNum = 0}))
            (),
          Cookie
            (CookieId {cookieIdNum = 2})
            SessionCookie
            (read "1864-05-08 16:19:58.811779123243 UTC")
            (read "1864-05-09 03:10:20.890964940734 UTC")
            (Just (CookieLabel {cookieLabelText = "H\r"}))
            (Just (CookieId {cookieIdNum = 2}))
            ()
        ]
    }

testObject_CookieList_user_20 :: CookieList
testObject_CookieList_user_20 =
  CookieList
    { cookieList =
        [ Cookie
            (CookieId {cookieIdNum = 0})
            PersistentCookie
            (read "1864-05-09 08:06:58.639041928672 UTC")
            (read "1864-05-09 15:54:22.365531263189 UTC")
            Nothing
            Nothing
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            PersistentCookie
            (read "1864-05-09 18:48:47.558654197171 UTC")
            (read "1864-05-09 04:32:10.969833190745 UTC")
            Nothing
            Nothing
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            SessionCookie
            (read "1864-05-09 09:10:02.113796886536 UTC")
            (read "1864-05-09 14:15:47.860550523473 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 0}))
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            PersistentCookie
            (read "1864-05-09 05:00:36.84392117539 UTC")
            (read "1864-05-09 18:21:04.675856170753 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 1}))
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            SessionCookie
            (read "1864-05-09 16:55:28.997986847556 UTC")
            (read "1864-05-09 06:15:55.387941840828 UTC")
            Nothing
            (Just (CookieId {cookieIdNum = 0}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            SessionCookie
            (read "1864-05-09 15:25:40.867545726854 UTC")
            (read "1864-05-09 17:01:15.858285083915 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 0}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            PersistentCookie
            (read "1864-05-09 22:29:23.772075463246 UTC")
            (read "1864-05-09 16:31:33.536750998413 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 1}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            SessionCookie
            (read "1864-05-09 08:28:42.7055861658 UTC")
            (read "1864-05-09 06:01:17.508326921451 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 0}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            SessionCookie
            (read "1864-05-09 00:35:33.330185032381 UTC")
            (read "1864-05-09 14:36:03.873052358125 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 0}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            SessionCookie
            (read "1864-05-09 12:09:10.29317763797 UTC")
            (read "1864-05-09 22:11:01.462326681794 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 0}))
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            SessionCookie
            (read "1864-05-09 04:13:26.504756178954 UTC")
            (read "1864-05-09 20:14:55.998946168576 UTC")
            Nothing
            (Just (CookieId {cookieIdNum = 1}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            PersistentCookie
            (read "1864-05-09 03:29:09.783324332702 UTC")
            (read "1864-05-09 03:01:33.387304269326 UTC")
            Nothing
            (Just (CookieId {cookieIdNum = 0}))
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            SessionCookie
            (read "1864-05-09 05:39:50.110190658859 UTC")
            (read "1864-05-09 15:32:10.979833482735 UTC")
            Nothing
            Nothing
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            SessionCookie
            (read "1864-05-09 02:03:15.187534976039 UTC")
            (read "1864-05-09 11:53:25.444713695811 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            Nothing
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            PersistentCookie
            (read "1864-05-09 06:28:52.941909526183 UTC")
            (read "1864-05-09 06:20:37.901798616734 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 0}))
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            SessionCookie
            (read "1864-05-09 17:47:27.661022872816 UTC")
            (read "1864-05-09 23:44:20.944594867149 UTC")
            Nothing
            Nothing
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            SessionCookie
            (read "1864-05-09 05:50:00.529587302706 UTC")
            (read "1864-05-09 09:32:05.839236279076 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            Nothing
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            PersistentCookie
            (read "1864-05-09 07:56:02.85544994417 UTC")
            (read "1864-05-09 18:01:18.902001307651 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 1}))
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            PersistentCookie
            (read "1864-05-09 12:24:49.643960000241 UTC")
            (read "1864-05-09 08:29:12.96271476677 UTC")
            Nothing
            (Just (CookieId {cookieIdNum = 1}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            SessionCookie
            (read "1864-05-09 05:16:55.098143637525 UTC")
            (read "1864-05-09 10:50:30.117720286179 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 1}))
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            SessionCookie
            (read "1864-05-09 15:34:54.252671447276 UTC")
            (read "1864-05-09 17:18:31.73847583527 UTC")
            Nothing
            (Just (CookieId {cookieIdNum = 1}))
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            SessionCookie
            (read "1864-05-09 04:13:22.834095234235 UTC")
            (read "1864-05-09 09:06:58.83050803106 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 1}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            SessionCookie
            (read "1864-05-09 15:56:00.791675801548 UTC")
            (read "1864-05-09 19:36:26.357858789968 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 1}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            PersistentCookie
            (read "1864-05-09 02:55:57.906310333752 UTC")
            (read "1864-05-09 08:04:52.147590690645 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            Nothing
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            PersistentCookie
            (read "1864-05-09 13:50:02.63156654108 UTC")
            (read "1864-05-09 21:24:37.629738475035 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 1}))
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            PersistentCookie
            (read "1864-05-09 06:34:25.097135193354 UTC")
            (read "1864-05-09 04:22:54.991041026267 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            Nothing
            (),
          Cookie
            (CookieId {cookieIdNum = 0})
            SessionCookie
            (read "1864-05-09 12:42:17.003849254404 UTC")
            (read "1864-05-09 06:07:35.98955454546 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 1}))
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            SessionCookie
            (read "1864-05-09 17:27:37.8613473328 UTC")
            (read "1864-05-09 15:55:53.309850731813 UTC")
            (Just (CookieLabel {cookieLabelText = ""}))
            (Just (CookieId {cookieIdNum = 1}))
            (),
          Cookie
            (CookieId {cookieIdNum = 1})
            PersistentCookie
            (read "1864-05-09 12:25:30.408292737207 UTC")
            (read "1864-05-09 05:30:34.287748326165 UTC")
            Nothing
            (Just (CookieId {cookieIdNum = 0}))
            ()
        ]
    }
