{-# LANGUAGE OverloadedLists #-}

-- This file is part of the Wire Server implementation.
--
-- Copyright (C) 2022 Wire Swiss GmbH <opensource@wire.com>
--
-- This program is free software: you can redistribute it and/or modify it under
-- the terms of the GNU Affero General Public License as published by the Free
-- Software Foundation, either version 3 of the License, or (at your option) any
-- later version.
--
-- This program is distributed in the hope that it will be useful, but WITHOUT
-- ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
-- FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
-- details.
--
-- You should have received a copy of the GNU Affero General Public License along
-- with this program. If not, see <https://www.gnu.org/licenses/>.

module Test.Wire.API.Golden.Generated.CheckHandles_user where

import Data.Range (unsafeRange)
import Wire.API.User.Handle (CheckHandles (..))

testObject_CheckHandles_user_1 :: CheckHandles
testObject_CheckHandles_user_1 =
  CheckHandles
    { checkHandlesList =
        unsafeRange
          [ "",
            ":\DC4J",
            "04Z\DLE",
            "\GS\ETX@\165102<\ETX8O\1058589nTqg\DEL",
            "\1108438\1037389\20349\ENQ",
            "K\ENQ",
            "\f\b\148008O\ACK",
            ".\SOHH:dbp\SUBc\100327\ETXu\1062201",
            "(\185907\57620{\1067885G\60953Aa",
            ")KPQ\DC3<\46322?9\41349\NAK\GS",
            "Ay\92753&i6?h&}eR",
            "H\128601?t\f\EOT7;",
            "\44876\nrh&\STX}2\t\SUB",
            "\DEL<\a\150925",
            "_\139097ta9\DLE(~",
            "5{",
            "l@+\1016430\"",
            "\\\47593\&5\1009699\&0",
            "",
            "Fn'\SUB&\145884\1084346",
            "V\73074lx",
            "\54793EQk\DC3*\ETBl\148644\1020567B\f\31787\1076574>",
            "\992351\178530#8i)F\1044365}L-4.",
            "\1052822\DC4c",
            "\EOT}.\NUL\DC2\v>",
            "N\\\994180'\54803y",
            "-w}\1080639y\15773\997319\n\141466",
            "",
            "\EMYu\99813c%\DC2",
            "",
            "sT\1052496\986432\a",
            "2\STXc\58521",
            "r(\EOT\1037603\FS\"m\1017451~4",
            "Q9Y+\SYN\ETB\tdE\1050930\ENQl\DLE"
          ],
      checkHandlesNum = unsafeRange 6
    }

testObject_CheckHandles_user_2 :: CheckHandles
testObject_CheckHandles_user_2 =
  CheckHandles
    { checkHandlesList =
        unsafeRange
          [ "\ETX\US\1011800W`V",
            "\a\DEL\1074747<\1112708\\\DLEE\1021488\\\r\162701\EM\SOH\1112742",
            "`\DC3\DEL\1033396(\21713b\65183",
            "6brO\999409T\70165w\SI\"",
            "",
            ":\SI\DC4n\SOH\DC1\1058186O\CAN\t",
            "\SO\b\1099130\SO",
            "\155635\ACKT",
            "m\STXa\1049695&'\DC3\1089935\173008\ETXHg\1055857@",
            "\36340\71482l\1098238\1071091>M>[+",
            "vh=C\ESCu\1036942 \146839.=\ETX\1003596",
            "\173209k/W",
            "\DC1\127357CSx\166942\1085221Y5",
            "\97745\61138\DEL:b|W\DC1fQn)5\24628",
            "",
            "\USGU\STX",
            "e|\148631s\1086450\100750.]",
            "\RS\US\1050951[\1108025",
            "w\"#!]",
            "\157776\167165\171633C\b",
            "!\v\73776\&5\1030036\SI\ENQ7k\1062822TM}",
            "\ESCG\DEL\SI\997775\150887(iP\20776.Q",
            "%T\1086514\\}\RSj\CAN\163096\&9\NUL}\ENQp-",
            "&O\144038\1046498ZH\39578tC\985256",
            "!\DEL\917995r=c\GS\1070682P9\SUBS\1076942\998766",
            "\r\167075r\59976>}b\EMm\SI\43205\ETB\ESC\15353",
            "\NAKiMX!!",
            ")fx",
            "P\1059321|\999307\EM\t\1027127?qQ;",
            "2`?g\1090857\1077270'[Iaj>'M|",
            "`\DC2",
            "/\1067190N ",
            "\145390\&52U\FSv#U\71066%1",
            ";V/"
          ],
      checkHandlesNum = unsafeRange 7
    }

testObject_CheckHandles_user_3 :: CheckHandles
testObject_CheckHandles_user_3 =
  CheckHandles
    { checkHandlesList =
        unsafeRange
          [ "%",
            "\ETX\FSq\EM",
            "-",
            "e",
            ")\nM\"S\1000237m\ETBf\44763J",
            "\1070721a+[\993555\SYN\164564\1106273",
            "7\CANGw\DC2k\t5?",
            "\7460.<\61871\SOIT\a\1069209?%\50379\v\1018910",
            "\SOH\13434\1076352ht1qTa\FS\EOT\1015456\1080759",
            "/Q0\ENQk~:%<\1092550\&3{",
            "h\a",
            "\152359\48029.'\1063641\153927",
            "4;>\140417\1000263",
            "&\68820Cg\SOy\1036659\53474B;h",
            "\1047548\n\STX`",
            "MF\1066514",
            "\ACKK\158638\ENQi\STXK4\1025469",
            "2/EqE=EW:g{z\SI-",
            "\180632\FS;\142071\&2\ETXV\997110\DC2 i\1098662'\10915"
          ],
      checkHandlesNum = unsafeRange 8
    }

testObject_CheckHandles_user_4 :: CheckHandles
testObject_CheckHandles_user_4 =
  CheckHandles
    { checkHandlesList =
        unsafeRange
          [ "\SOh~\18676Wo\FSY\NULSD\1088688.=",
            "r\1098367\FS\b\27022\&8\US_\DELu",
            "\DELLl\DLE",
            "\SO\169165bz\ESC\1040451y\1101056@&&?[2",
            "\t\1011303",
            "\1092006",
            "",
            "",
            "\nmUpoT#ZS\1050174T\CAN\CAN",
            "-\DC1\1096502}Hwo\984180",
            "\DELL\\\ETX\10027\144011",
            "\ENQ\NAKu\139422[\1052813\136510`\a\165117V,)\41654",
            "\1007804}<Je\SI\ETX8\1083548?7\b\136243^J",
            "\1008996\1086592@`EVI\1050247\5445\DC4\rzM\DLE",
            "iMgr\EOT\148118M=G\1070320:",
            "\1106394n9eV\DC1O\ETXRx+\1025313\1103594\8037",
            "\a",
            "lku\DC1;\b\ETB\1053598",
            "\155344\a5\ESC",
            "",
            "r\98909\141971h!\ETXm)\147390&qcR",
            "/\DC1z\DC2\ba\ESCGk|`\RS\b",
            "\ACKR",
            "",
            "+^-\1004873",
            "5On|'z\1089053\&3K,\64025*~",
            "dO\1109673\136177",
            "d\DC1\182475~\v",
            "\EOT9>\1092209="
          ],
      checkHandlesNum = unsafeRange 7
    }

testObject_CheckHandles_user_5 :: CheckHandles
testObject_CheckHandles_user_5 =
  CheckHandles
    { checkHandlesList =
        unsafeRange
          [ "e\994837[\20266KK\131962\47110\&7\SO\997764bN+",
            "vZ\35982J\1049231K\1028639\aP3",
            "",
            "o\21845?L",
            "V\100106\177510\10850\184652\ESCnv",
            "WK\1080310\990223",
            "\ESC\a",
            "\1053034k",
            "Pv\NUL\26989?m\SOM\63041\SUB\DC2)",
            "\NUL\139078b",
            "E\1094567-\DC1HOyx?y]a\ACK7",
            "",
            "g'\141141\RSi\37688tOlwDQ",
            "",
            "t[\r-GP\137250",
            "Ne\f`w\1081815H\92460P_",
            "\1035715!\SO\n\CAN)",
            "\997350Imq\DC1\\\42707b[\DC1\990789\51986Z",
            "7^\133487k\41414\DLE",
            "\US+U\137856z\18034(\EOTXi(\SO<\169907\DC3",
            "\nqe",
            "3\r\SYNr1\993605",
            "t\990275\11344\51058\ENQ\74970t",
            "@\1081195?\SOI[S\1083\ENQeR\1108930",
            "d\SUB+\38740\SYNE",
            "\151876",
            "7.\"\39712",
            "N(\1100208\&8\42768U\145177)zB",
            "&j\1093501\178684k\DEL4\83442_Yd\n",
            "\ETXy%\133071n>Y\68897ou\CAND\DC1Q",
            "4\145920\&2)\10868\CAN\EOTWD\42157\SUB`\58277\DC4-",
            "",
            "\ESC\32496Y\94302~\USW\"L",
            "P\fn\ENQ\RSg",
            "T\1008102d+\GS\GS\120729\EM40\1019692<? \b",
            "\1109068\166446\30169\&0\1023943#\RSyl\35621P?\1013471\STX",
            "\DEL[\f\NUL\\;w\NULi\t",
            "SIl[N\185079\vrQQVKt\1044277\DC1",
            "",
            "\1079895\STX s\DC2\DEL[\NUL\NAKriJR\161535",
            "U\"G\RS\92245\ESC\1006028\3136",
            "Q\135991",
            "",
            "e\ETB&s\31115]\40936\EM'\ACKx\35978",
            "\1075363Fu\ENQ\DELC#\36348|\1001906\1051006\&6",
            "\1066555\CAN}\1863\23598x",
            "g"
          ],
      checkHandlesNum = unsafeRange 3
    }

testObject_CheckHandles_user_6 :: CheckHandles
testObject_CheckHandles_user_6 =
  CheckHandles
    { checkHandlesList =
        unsafeRange
          [ "]_\16847U^=/",
            "\1021820(RJxy;fK7\f\1090959}",
            "\162024\DC3+P3\US",
            "<J\1016992\1110686P\1074021\GS\172401Q^\SOH",
            "\b>\1032814k\ESC\r!#\167164m,\94903\&0\1086063",
            "+F8R\1024516ER\vt(\FS",
            "\GS\1048349\SO",
            "\8316",
            "\DC3\148396:.A+\DC4;\1106144jf\14226Q",
            "\FS5\n\50376\121191\EM\ACKU\1097293s",
            "N\SUB\61130\1044138\NULo",
            "\188700(G\1029149\ENQ{\45424~\1103965\1075687W\1084143\48070\&3[",
            "\151474\1080833",
            "\40902",
            "p|#\132128\ESC#E\ETB\161438/\DC1/\46158T",
            "\1053576TV\1063652\ESC\DEL\1090279\ETBU",
            "\n\63214Os\1025409j",
            "\RS",
            "\92334v\rA",
            "",
            "\998242\999405\rQE!",
            "\1007633\DC1",
            "7+1u\157258\229Ne\DELj\\\168325\STX",
            "U\fNvj\1065586\1046044`95",
            "Ut\a\1108925\SYNT\STX^",
            "C,\FS\998146L"
          ],
      checkHandlesNum = unsafeRange 8
    }

testObject_CheckHandles_user_7 :: CheckHandles
testObject_CheckHandles_user_7 =
  CheckHandles
    { checkHandlesList =
        unsafeRange
          [ "6f\DC2T\42225\145254\CANNw\58424\STX\DEL\DELM\1092526",
            "\1097402",
            "$y",
            "xN\SOH\51866XrJlr",
            "~L.\21976e<i\")G",
            "Eh\1066652p\1037761",
            "kO\US\ETXW\GS^RGY",
            "\994364\&8\123157.9FQ",
            "::\EM\1066862\GSX+\988958<$\140183ch\1097034",
            "Z\\\1113410",
            "H\RS\1053124?\EOT^ON*\1057077Xq\1077226\RS",
            "(J",
            "",
            "P\RS*m,)\GS\191292{?\1065080,\ETB5f",
            "i\DLE\US\a\ESC6f\SI\140694",
            "\1015999\&4\25474BJAt-\"j",
            "$\SO\SOH~K\STX\1021739/-3\28403@\137287U",
            "$\DC2\DC2",
            "7\ENQ:d\SI",
            "K:\GSpE_=\SYN\1075412z^",
            "kJsLZo",
            "Xp=\EM\1079918(\184433h\DC4",
            "\45428\&7\1028001_\141123\ACK\1035755",
            "g\STX+D\1089828$c",
            "\ACKwUjCo$\1071374\1043995",
            "",
            "\1066575c\71708\r\1078505rQcngl",
            ">\NAKw|d\176896\7835\DC2SK`\SUB\v\1009349",
            "\1025234\&8\1050844i",
            "~:\CANIN\1086151DP",
            "",
            "\DEL\51552R\1072390l ",
            "\ETX1`l\fh5",
            "2",
            "\47009\991371nJl\1062084\1013196\EOT\DELhR\1057319",
            ">fY\NAKy\47596P\US7\78275'm\157722.\ESC",
            "-K\1108878\v\44476F\26460J\99297",
            "\RS"
          ],
      checkHandlesNum = unsafeRange 8
    }

testObject_CheckHandles_user_8 :: CheckHandles
testObject_CheckHandles_user_8 =
  CheckHandles
    { checkHandlesList =
        unsafeRange
          [ "\184492\nP\1058201\989220xh\1087263e:\125093\1051984\1015861\DC4\18628",
            ".\998552\1075248Ck\1008766fj\1006097\&5",
            "\183617\83353\RS\NAK\DC4<\24407:Fw",
            "8?",
            "jM",
            "",
            "\SO\1019804DyM\NULQgRH~X",
            "u\167741\1104536\1013951;D\ESCF\127090\EM&+%{\DC1",
            "",
            ":a_W\r\SUB-$9\"RE",
            "1J]RF",
            "\3944M4\EOT\ESC(k"
          ],
      checkHandlesNum = unsafeRange 9
    }

testObject_CheckHandles_user_9 :: CheckHandles
testObject_CheckHandles_user_9 =
  CheckHandles
    { checkHandlesList =
        unsafeRange
          [ ".\100983$\RS/",
            "O~P\DEL\DC13hJ\15373r\124984^",
            "\189260\1065489m\STX\33143\1107245)\1092010\62865oV",
            "\1095747j\1052950SG7\ETB\1058728\96621XR\41217\50564",
            "A\48101\145584\DC1\SO@.d\SUBc:",
            "\994682\998169OllGwDB\r4`U9",
            ",q\"\1113611)r\ETB<q\NUL,\1039495p3",
            "m\DC3\DLE\ETX6\155369@Cw",
            "\GS \b\987619|\SOu\1102685Y",
            "zT\FS_\152593\184298)\DC1",
            "\1036020\DC4\1103038\EM%!I.\ACKf|N",
            "Z\127093\136852H\a",
            "\24144\1051679Cq\NUL-[ ",
            "hyk\131518#\GS\18693yNG",
            "\b}\21212,",
            "5\16799\b\1100276\DC4>\53053\1075637",
            "O,D<7yc>V",
            "\"\DC3\t\68044\&2\1071647zn\20443\CAN4-",
            "\141844Yn]\168578$&=-",
            "\2959",
            "",
            "\FSp\32703\1052213\170397\50219E!\72226\GS&^%E",
            "\GS",
            "xta",
            "\DC4dG53",
            "X/ip;f\RS\983793\1042499H\45339\DLEO\ETB",
            "8be\DLE\1047290p\GS\53196\1049623v7-",
            "ta\1019403m[@\\zY\16466/\1072219",
            "zF\ACKx\DC1}",
            "o5\1041570",
            "",
            "\917942\1080259\&8\166823[7\1078960'[",
            "Ha')\RS\147341\151987\ENQ\1057292\v",
            "\SUB\ENQ]70h_\148184\&9\53901\\\1026759n",
            "",
            "\ACKe\DC4Ke\ACKv\1103098\a"
          ],
      checkHandlesNum = unsafeRange 1
    }

testObject_CheckHandles_user_10 :: CheckHandles
testObject_CheckHandles_user_10 =
  CheckHandles
    { checkHandlesList = unsafeRange ["%\DC4=.\DC1", ")", "\16076\CAN\3777", "\1020499PH\DLEq\NUL", "\19843H\SIP"],
      checkHandlesNum = unsafeRange 6
    }

testObject_CheckHandles_user_11 :: CheckHandles
testObject_CheckHandles_user_11 =
  CheckHandles
    { checkHandlesList = unsafeRange ["=v\fS4y\19095C>P\1054077", "j\159181\SOH\NUL\996921\CAN}&R", "a?Z\\@"],
      checkHandlesNum = unsafeRange 7
    }

testObject_CheckHandles_user_12 :: CheckHandles
testObject_CheckHandles_user_12 =
  CheckHandles
    { checkHandlesList =
        unsafeRange
          [ "D\DC1}V",
            "\1054321:\12395m\1022956\170704>\1029176Z\23696b\1070983r(\161939",
            "\FS",
            "uT?sBN{\94507\RSU",
            "\1036777Mh\bT\1003239i\168663\n)\FS3\1072273s\FS",
            "\nI\46947\14879\1012333\1080242b%\14424G\29775a",
            "\159868",
            "X\DEL\113687",
            "",
            ":j!\1060833\181208N\SOH\1037003\&6^\SYN",
            "\vi\\Vcg\46651",
            "4\148559O#\133370|v<>flE",
            "\RS:\15829\132766M\RS",
            "\1098428\985462\&3_\1020993\&3T\99489`/GA\SYN",
            ".Yg ",
            "s2Tj\1026465",
            "\997744\f*\70341\47837R<>e\162659\1055989",
            "N\US\1099048@47>\140306\1095132Mx\1060936m\151420;",
            "_RPuN*\996054\133897E\\\DC13\1111987q",
            "%>\97076",
            "\1082006\&5#;\174216s\DC1\GSQ3\CAN5>",
            "\ETX3\1024427\ENQD\1026984ta",
            "r\66902\184447{",
            "\59713\&8\40905\1061804h\186426",
            "\1016072Uum\2389G",
            "\DC2\ACK\SYN\t-_\DC1m",
            "p;\145802\&2",
            "%\1000144(\STXm\SO\USI/w\1077885",
            "\1088996,-\1079948t\DC4\153236\1060199\SYN",
            "v;\19813Q\1065567\EOT\GS\FS\DC2V%\33281<\DC3\1025585",
            "u0\1030880#,:e<\169422\98806<\150030!",
            "",
            "\DC1\37500\1006434p/\1085513P\NUL\b\987127c?",
            "h.\DC4]\NUL",
            "\SUB\26468&\34872T\194923\1019266\1024398E\EMe}L",
            "\DC2\DC4",
            "\50206_`B",
            "\998314I\1038986K\vq'aV/",
            "\DC4\178859",
            "\136365NkH\187879",
            "?e\aTv\44044\&0\23989",
            "4o\GS",
            "$#",
            "",
            "h/\ETX\1037208",
            "\188485Z\DEL<\DC2~1\1015943\64787\ACKgL\1111939D\n"
          ],
      checkHandlesNum = unsafeRange 9
    }

testObject_CheckHandles_user_13 :: CheckHandles
testObject_CheckHandles_user_13 =
  CheckHandles
    { checkHandlesList =
        unsafeRange
          [ "S\15015!\nf",
            "x\1021573\992181\v\163972",
            "J\33645\SI5\GSND\f\190160]\SOHX^pu",
            "\186308\1049776",
            "M\20246i\11425Ix\189991A\SOHR)\64929\1040887=",
            "~\18349\n\f\40711\"F",
            "b;\1102788\&2\46162_!\643UJw",
            "O\DC4l\23492+E\120045Cr\SI{\154107f1\98246",
            "\CANQo\1046013YQ",
            "t\1022065\vYU<6\\\DC2\137054y6\NAK5",
            "\a\150949 \1056646z\1090215\1077455\ENQ\1047454\ETX",
            "n\EOT|:G\160710\1058464&cf%T\1048903\RS",
            "\t\\\1049743<\b\184935>.",
            "b",
            "\994178\1007826\1084104j",
            "\DC3c\166075\DC1\EM\69665~",
            "",
            "V-,\ETB\134973HU\1038119\66455wV\60782\&8",
            "\DEL\1076372\1070494.:\SYN\DC2\1112443\42180~u\SOH\162455Q\984559",
            "\1061878\&0",
            "AG+\vD\SI}0\1695D\r",
            "{^Y)\1059099\97683\FSO",
            "}:\DEL\179943j\1113180?9",
            "\1009408\ETX\DC4X\178922\1037388\\@F9\ESC\135104t",
            "\SOG}s^\38667*j\SOHgAV\v",
            "d",
            "\ESC\EM8\15021^\1113091:",
            "A\DC4-",
            "\142292cS\NAKEt^\62814\FS",
            "\1024008\SIu/Ok\149283\194749",
            "\RS\1028189\&38\1098158\US\1082289Se",
            "X\ETX]",
            "\33293Q|p\1040707\n",
            "D\GS\1106983\1084856\1050222r;r\rR",
            "AC;Tn\DC4\DLEY;",
            "\50117^\1041787\&9\v",
            "`\145607\1051193\ACKk",
            "KHy\1102097\SYNI\150138gAy\GS",
            "\993611h3V\"\129493\nv\nj;!4"
          ],
      checkHandlesNum = unsafeRange 8
    }

testObject_CheckHandles_user_14 :: CheckHandles
testObject_CheckHandles_user_14 =
  CheckHandles
    { checkHandlesList =
        unsafeRange
          [ "\b\7686@L[6y\GS)M.\f\SOHj\159978",
            "7P\ESCAtMGn\n9n7]",
            "\EM\29251DE\133717q\180013 \NUL\n\1056285\&8fna",
            "3\1040624uF\141558\DC1#\140221y=\ACK\1009896&",
            "\ETX",
            "1\1039110\&4\20030\&6&L\171514fl\DC4Mz'\t",
            "e'\EMu|>\985641U\30623",
            "s%\SOH\SO\r\ENQ",
            "0&\EOToFh&w6\RSk",
            "e",
            "A",
            "O\166688%\1052933*\FS",
            "\1027506\1091407\DC3\188436r\100563E\28152\EOT\RSl",
            ":\SOH\1021924\ESCN?1\184009\99834\991186\ESCN{",
            "^Vtz\37742\1098827d",
            "/9ds8AT\SUB))"
          ],
      checkHandlesNum = unsafeRange 4
    }

testObject_CheckHandles_user_15 :: CheckHandles
testObject_CheckHandles_user_15 =
  CheckHandles
    { checkHandlesList =
        unsafeRange
          [ "",
            "[\1002676\&3\179628,\f.\ETBtY@h",
            "WG\SO{f\t8\f",
            "gq\1016674",
            "Vu[\ESCV\EOT2c\NUL",
            "\DEL*\11219",
            "",
            "\47494",
            "\1090525g\150999\163879H\42244>FB\SI",
            "\152666\&4|\1045255,@\aC*w4@U",
            "\46762\191272/9hX\144988",
            "'",
            "!\n7<\989753\1009276~9\1113517T",
            "\n%(57\GS\31067?\\75w",
            "~\ACK\v\1023179\992425@\1043537\152587\DC4\SUB5-",
            "\SYNx\1060659\STX?I \73744",
            "O.#UB\140560\NAK@\CAN\RS",
            "\SUB\DELB\1075792\40410",
            "aoD]\DC3SA\FS3\DC2\1111594\ENQ",
            "\1069743<M6\15104\v\183159\1036772\&3gg\14840",
            "5Wpf(\STX9GqT\1011713",
            "\NUL\132696\&5\113792^@",
            "\45043\FS\nv",
            "Btz",
            "f\20365\\)B\1071872f\b2\984050\EM",
            "\185820\ETX\DC3\1113759R\1054662J;\vf",
            "",
            "/n\"a%OF\DLEo.\1008547.\bz\31106",
            "\SOH\160462",
            "U\147643\STXC*\1053489*\10066",
            "k|{N\187815f9\8844x\DLE\t",
            ",",
            "[\f! L\1108964<jD\"-]",
            "NOkN",
            "\1005187",
            "in",
            "GB$Y",
            "8\1052417\32662\&8E\CAN,)\155888\\\r",
            "Z\187554V\1061926\ETX\US\FSsG\1016589\&6?",
            "\SYNj`=\t/p2\127480*\DC4",
            "K\1097602p\2739R\DELd",
            "J5\1000493\1105790\993658\&1\172855;\1082575\97739QCv\""
          ],
      checkHandlesNum = unsafeRange 1
    }

testObject_CheckHandles_user_16 :: CheckHandles
testObject_CheckHandles_user_16 =
  CheckHandles
    { checkHandlesList =
        unsafeRange
          [ "\1019739\16821\64308\21650\&7\ACK^gW",
            "\2826F\1045745n",
            ".",
            "+nFS\1075735\GSKxK\131324.\148012\1080538/Z",
            "M\ETB\996768kH\SYN\b[m",
            "F\45640^\DLE^\131574\1021546H4xw",
            "q\f c\44679\ENQI\1032086\DEL%4",
            "k0",
            "\24660:,",
            "}\STX^\1059814*\25958OT\166032"
          ],
      checkHandlesNum = unsafeRange 7
    }

testObject_CheckHandles_user_17 :: CheckHandles
testObject_CheckHandles_user_17 =
  CheckHandles
    { checkHandlesList =
        unsafeRange
          [ "\1080457W\ESCbTB\1101544:\97757\&7",
            "$N\180665",
            "\US\ENQy+c\CAN",
            ";",
            "3/\ENQ\14791",
            "\"~%\1069355m*\62411oi+",
            "#A\t\NAK\146489\177032\n",
            "\r\EM\f:",
            "\38942\142382s^\179029\1078865\DC4",
            "e\1011926\69798\a)>F\NUL\1018120e[",
            "E0qZB\DC1\53449",
            "yG15\NAK\DC2",
            "\CAN_\1105170J^fL\US&-\EOTW\1031840\1037426"
          ],
      checkHandlesNum = unsafeRange 5
    }

testObject_CheckHandles_user_18 :: CheckHandles
testObject_CheckHandles_user_18 =
  CheckHandles
    { checkHandlesList =
        unsafeRange
          [ "[\1037746\a\NAK",
            "*",
            "SF",
            "\GS'=~\1065070\"\NAKHz\1040371y",
            "\1105525\83374\1109155\ACK\1070503n\EMt\189569+y\78507c\991824W",
            "\1051018hO4\EOT\1081342\22356\&5\46401P$o",
            "\1022992w",
            "\1017969FWk\EMR\168449G vTm",
            "\STX\1061521\CAN(l[u",
            "\63383w\1076617\11946S\137258\67082\&6\1094273\1081984\DC2\CAN",
            "2\70416\1058782\&2mm\1019530\1001873\SIdHz",
            "",
            "\EOT*E^\DELlq\1055875aE"
          ],
      checkHandlesNum = unsafeRange 4
    }

testObject_CheckHandles_user_19 :: CheckHandles
testObject_CheckHandles_user_19 =
  CheckHandles
    { checkHandlesList =
        unsafeRange
          [ "\DEL+N^\1015666\1096081'z%E%\16912M\ETX",
            "{]",
            "\t\CAN\n\120008",
            "",
            "(oR\99471*\ENQ0",
            "\1047587\1081744\EMz\1042198\&1\999487Q{\137883(sa",
            "\ESC.{\DC1i ]\100701\1095714\FS\STXX\58472",
            "",
            "",
            "\NAKuF",
            "\1040802y?g\1071581\DEL\48836\172732",
            "`\1046365rl\STX\73862o\DC3\71074)",
            "\35293^7o\US?m",
            "\ve\1053919\37325\FS~",
            "~\DC3T\1013577\&4|",
            "\13498\RSZJ$ST![=\SOH\CAN\7838\173674e",
            "\15380\&6\1104939\rY\154312\&3x\\\1094887Uu\SYN$",
            "\1020642|3_/",
            "\SYN\1092520(A8V6\t\NUL",
            "\US\ESC_\EOT\DLE0{tz\1090698\SYN",
            "u\1076266\1076143j",
            "Zp\DC1\EOTh\37293\n\GS\1017545,\aX",
            "G\194890>:",
            "\46558\136164$\1062028=n",
            "Ix1\1102453;p\ESC\ETB1P",
            "\61237X={*\DEL",
            "R\1050470\32261b\1044556g\1029499\nC6",
            ".\DC3`\60269\FS\r",
            "hY\EOT'\97160\161598exO-\183898\vO",
            "\984208xY\1097669{w\181634)hJ\1068569)",
            "\SI\DC4,\v\74936jDd6\186491y\t\61944~y",
            "A}",
            "\GS5\1076639)\987307\GS|5CA",
            "\176656",
            "\58459\34244\DC4\EMc\165691L\5763Y",
            "\155918n/\1049704D$",
            "Zq\rH-of\999657\fE\989424",
            "%} \1036847V\n\170003\DC1N",
            "\12750\SI\b0\1029205\US\996064\NAKN=,2\166275@/",
            "\NULg;9MoP",
            "]%`O@\143048p",
            "y",
            "\DC3i\139590V|\a\ETX\SOHntA\1010828cB\ETX",
            "cl\DC34\29806`\176058Ne\r",
            "%c\96943\15473y\b\rT",
            "A\61118`\DEL-SE\9529\DC3GW\53458G\1047123L",
            "\1104894\ETX",
            "\SUB|}F8\FS`\SO\DEL#\166992"
          ],
      checkHandlesNum = unsafeRange 7
    }

testObject_CheckHandles_user_20 :: CheckHandles
testObject_CheckHandles_user_20 =
  CheckHandles
    { checkHandlesList =
        unsafeRange
          [ "Ej}",
            "\1111670t",
            "\STX\141952j",
            "\1034371\1101287\1040122\1033558\1041031( \aB\24530\DC2\59919=\DC3\189614",
            "",
            "",
            "W\128324\163637\&2\DC1\153934\45432\\L+\NUL\NAKj\141982\1067776",
            "&@E",
            "\"\DC3",
            "\1036445\&4\ACKs",
            "\DC3\ESC\64116\153090(\SUB`\987825",
            "",
            "\9000!}",
            "t",
            "{=\100231,1\EM",
            "\987309\23323a7>\59655\SUB}p\SOH}j\13657",
            "~\FS\t%\74590\1012010\1072990jk8",
            "U\68768",
            "b@\22652",
            "P\180819E`E\US\SI`\FS",
            "\a`\n\60292p",
            "\a.9\185651L",
            "",
            "&g_",
            "\CAN\DEL\47134</\20387]\1052090\984732",
            "*kR",
            "Q_?\1110688d'L\1106616J\ETB!5\SI"
          ],
      checkHandlesNum = unsafeRange 5
    }
