-- This file is part of the Wire Server implementation.
--
-- Copyright (C) 2022 Wire Swiss GmbH <opensource@wire.com>
--
-- This program is free software: you can redistribute it and/or modify it under
-- the terms of the GNU Affero General Public License as published by the Free
-- Software Foundation, either version 3 of the License, or (at your option) any
-- later version.
--
-- This program is distributed in the hope that it will be useful, but WITHOUT
-- ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
-- FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
-- details.
--
-- You should have received a copy of the GNU Affero General Public License along
-- with this program. If not, see <https://www.gnu.org/licenses/>.

module Test.Wire.API.Golden.Generated.ActivationKey_user where

import Data.Text.Ascii (AsciiChars (validate))
import Imports (fromRight, undefined)
import Wire.API.User.Activation (ActivationKey (..))

testObject_ActivationKey_user_1 :: ActivationKey
testObject_ActivationKey_user_1 =
  ActivationKey {fromActivationKey = fromRight undefined (validate "15uY_g6pACNmzgXy")}

testObject_ActivationKey_user_2 :: ActivationKey
testObject_ActivationKey_user_2 =
  ActivationKey {fromActivationKey = fromRight undefined (validate "0MrwcsDxLHCymg==")}

testObject_ActivationKey_user_3 :: ActivationKey
testObject_ActivationKey_user_3 =
  ActivationKey {fromActivationKey = fromRight undefined (validate "rR2dx4uT3AT0SeU8C_XQxrwW")}

testObject_ActivationKey_user_4 :: ActivationKey
testObject_ActivationKey_user_4 =
  ActivationKey {fromActivationKey = fromRight undefined (validate "FzQ949ghFJI7ZBVbd4zIASZ5")}

testObject_ActivationKey_user_5 :: ActivationKey
testObject_ActivationKey_user_5 =
  ActivationKey {fromActivationKey = fromRight undefined (validate "vhW086ve4RewjSd8o_m3CC3tFBea")}

testObject_ActivationKey_user_6 :: ActivationKey
testObject_ActivationKey_user_6 = ActivationKey {fromActivationKey = fromRight undefined (validate "31xP7w==")}

testObject_ActivationKey_user_7 :: ActivationKey
testObject_ActivationKey_user_7 = ActivationKey {fromActivationKey = fromRight undefined (validate "")}

testObject_ActivationKey_user_8 :: ActivationKey
testObject_ActivationKey_user_8 = ActivationKey {fromActivationKey = fromRight undefined (validate "Ggj1BK4=")}

testObject_ActivationKey_user_9 :: ActivationKey
testObject_ActivationKey_user_9 = ActivationKey {fromActivationKey = fromRight undefined (validate "2a8zyNgB")}

testObject_ActivationKey_user_10 :: ActivationKey
testObject_ActivationKey_user_10 =
  ActivationKey {fromActivationKey = fromRight undefined (validate "Q-Tg4Wl5sOubb_TT2628Y_7_7qVb")}

testObject_ActivationKey_user_11 :: ActivationKey
testObject_ActivationKey_user_11 =
  ActivationKey {fromActivationKey = fromRight undefined (validate "9kHgasEE6ljb2Z8XmXCFWiwUiw==")}

testObject_ActivationKey_user_12 :: ActivationKey
testObject_ActivationKey_user_12 =
  ActivationKey {fromActivationKey = fromRight undefined (validate "YYAuRUqFvZCEB6g=")}

testObject_ActivationKey_user_13 :: ActivationKey
testObject_ActivationKey_user_13 =
  ActivationKey {fromActivationKey = fromRight undefined (validate "aAFrcaOtda8RrtQ=")}

testObject_ActivationKey_user_14 :: ActivationKey
testObject_ActivationKey_user_14 =
  ActivationKey {fromActivationKey = fromRight undefined (validate "XSt3htt1fnRfLIZvlUkgoCdJfA==")}

testObject_ActivationKey_user_15 :: ActivationKey
testObject_ActivationKey_user_15 = ActivationKey {fromActivationKey = fromRight undefined (validate "ANJZ")}

testObject_ActivationKey_user_16 :: ActivationKey
testObject_ActivationKey_user_16 = ActivationKey {fromActivationKey = fromRight undefined (validate "CUg=")}

testObject_ActivationKey_user_17 :: ActivationKey
testObject_ActivationKey_user_17 = ActivationKey {fromActivationKey = fromRight undefined (validate "c8c-Beze1OzP")}

testObject_ActivationKey_user_18 :: ActivationKey
testObject_ActivationKey_user_18 = ActivationKey {fromActivationKey = fromRight undefined (validate "3A==")}

testObject_ActivationKey_user_19 :: ActivationKey
testObject_ActivationKey_user_19 =
  ActivationKey {fromActivationKey = fromRight undefined (validate "YFGSNZuGPhdPKg_7T2DI2CszNurdqC7sxjjuOQ==")}

testObject_ActivationKey_user_20 :: ActivationKey
testObject_ActivationKey_user_20 =
  ActivationKey {fromActivationKey = fromRight undefined (validate "z64wDSw3pOs7hTHHdhld")}
