-- This file is part of the Wire Server implementation.
--
-- Copyright (C) 2022 Wire Swiss GmbH <opensource@wire.com>
--
-- This program is free software: you can redistribute it and/or modify it under
-- the terms of the GNU Affero General Public License as published by the Free
-- Software Foundation, either version 3 of the License, or (at your option) any
-- later version.
--
-- This program is distributed in the hope that it will be useful, but WITHOUT
-- ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
-- FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
-- details.
--
-- You should have received a copy of the GNU Affero General Public License along
-- with this program. If not, see <https://www.gnu.org/licenses/>.

module Test.Wire.API.Golden.Generated.ActivationCode_user where

import Data.Text.Ascii (AsciiChars (validate))
import Imports (fromRight, undefined)
import Wire.API.User.Activation (ActivationCode (..))

testObject_ActivationCode_user_1 :: ActivationCode
testObject_ActivationCode_user_1 =
  ActivationCode {fromActivationCode = fromRight undefined (validate "FJwIy9tvYg==")}

testObject_ActivationCode_user_2 :: ActivationCode
testObject_ActivationCode_user_2 =
  ActivationCode {fromActivationCode = fromRight undefined (validate "yvuBLOmFLzk1FHpUap8x")}

testObject_ActivationCode_user_3 :: ActivationCode
testObject_ActivationCode_user_3 = ActivationCode {fromActivationCode = fromRight undefined (validate "EvM5Jn5M")}

testObject_ActivationCode_user_4 :: ActivationCode
testObject_ActivationCode_user_4 =
  ActivationCode {fromActivationCode = fromRight undefined (validate "OxGrorjqOUKHYSBbTILDuXp3GH0bLYd2")}

testObject_ActivationCode_user_5 :: ActivationCode
testObject_ActivationCode_user_5 =
  ActivationCode {fromActivationCode = fromRight undefined (validate "JhhDE2fz95cZ-cRPtgNHPcBRyqS8CA==")}

testObject_ActivationCode_user_6 :: ActivationCode
testObject_ActivationCode_user_6 =
  ActivationCode {fromActivationCode = fromRight undefined (validate "Z9k5agzylBHv0J19Z0uenoE=")}

testObject_ActivationCode_user_7 :: ActivationCode
testObject_ActivationCode_user_7 =
  ActivationCode {fromActivationCode = fromRight undefined (validate "e99bkpy0I-QVIA8A7yRJgYWvB81Cxx3v")}

testObject_ActivationCode_user_8 :: ActivationCode
testObject_ActivationCode_user_8 =
  ActivationCode {fromActivationCode = fromRight undefined (validate "9YI6jlTVs_2iAHUadQ7RPBo3bI7Sr9i0f9VXiw==")}

testObject_ActivationCode_user_9 :: ActivationCode
testObject_ActivationCode_user_9 = ActivationCode {fromActivationCode = fromRight undefined (validate "rYg=")}

testObject_ActivationCode_user_10 :: ActivationCode
testObject_ActivationCode_user_10 =
  ActivationCode {fromActivationCode = fromRight undefined (validate "ElTR5oKEkVX7_iMtw0UWePQv4LTkra90Hape")}

testObject_ActivationCode_user_11 :: ActivationCode
testObject_ActivationCode_user_11 =
  ActivationCode {fromActivationCode = fromRight undefined (validate "MwcmBl8I-ytX-ssz1u3cy7tFHJQ=")}

testObject_ActivationCode_user_12 :: ActivationCode
testObject_ActivationCode_user_12 =
  ActivationCode {fromActivationCode = fromRight undefined (validate "JXwE8B8yGcmngjxN0g==")}

testObject_ActivationCode_user_13 :: ActivationCode
testObject_ActivationCode_user_13 =
  ActivationCode {fromActivationCode = fromRight undefined (validate "xp-TMSz6BbROrYGCOep_S9U=")}

testObject_ActivationCode_user_14 :: ActivationCode
testObject_ActivationCode_user_14 =
  ActivationCode {fromActivationCode = fromRight undefined (validate "aXpaX2RHq2j_OujDGlQt")}

testObject_ActivationCode_user_15 :: ActivationCode
testObject_ActivationCode_user_15 =
  ActivationCode {fromActivationCode = fromRight undefined (validate "QL_kpur1eCmcmZKf87Or")}

testObject_ActivationCode_user_16 :: ActivationCode
testObject_ActivationCode_user_16 =
  ActivationCode {fromActivationCode = fromRight undefined (validate "BtfTK0X0TkdU5710gME=")}

testObject_ActivationCode_user_17 :: ActivationCode
testObject_ActivationCode_user_17 =
  ActivationCode {fromActivationCode = fromRight undefined (validate "2c3OtWcjyg==")}

testObject_ActivationCode_user_18 :: ActivationCode
testObject_ActivationCode_user_18 = ActivationCode {fromActivationCode = fromRight undefined (validate "1pI=")}

testObject_ActivationCode_user_19 :: ActivationCode
testObject_ActivationCode_user_19 =
  ActivationCode {fromActivationCode = fromRight undefined (validate "0QO1c30yeQ==")}

testObject_ActivationCode_user_20 :: ActivationCode
testObject_ActivationCode_user_20 =
  ActivationCode {fromActivationCode = fromRight undefined (validate "MrTs72sNAmcOF4JLBtcsQQ==")}
