-- This file is part of the Wire Server implementation.
--
-- Copyright (C) 2022 Wire Swiss GmbH <opensource@wire.com>
--
-- This program is free software: you can redistribute it and/or modify it under
-- the terms of the GNU Affero General Public License as published by the Free
-- Software Foundation, either version 3 of the License, or (at your option) any
-- later version.
--
-- This program is distributed in the hope that it will be useful, but WITHOUT
-- ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
-- FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
-- details.
--
-- You should have received a copy of the GNU Affero General Public License along
-- with this program. If not, see <https://www.gnu.org/licenses/>.

module Test.Wire.API.Golden.Generated where

import Imports
import Test.Tasty
import Test.Wire.API.Golden.Generated.AccessRoleLegacy_user qualified
import Test.Wire.API.Golden.Generated.AccessToken_user qualified
import Test.Wire.API.Golden.Generated.Access_user qualified
import Test.Wire.API.Golden.Generated.Action_user qualified
import Test.Wire.API.Golden.Generated.ActivationCode_user qualified
import Test.Wire.API.Golden.Generated.ActivationKey_user qualified
import Test.Wire.API.Golden.Generated.ActivationResponse_user qualified
import Test.Wire.API.Golden.Generated.AddBotResponse_user qualified
import Test.Wire.API.Golden.Generated.AddBot_user qualified
import Test.Wire.API.Golden.Generated.AppName_user qualified
import Test.Wire.API.Golden.Generated.ApproveLegalHoldForUserRequest_team qualified
import Test.Wire.API.Golden.Generated.AssetKey_user qualified
import Test.Wire.API.Golden.Generated.AssetRetention_user qualified
import Test.Wire.API.Golden.Generated.AssetSettings_user qualified
import Test.Wire.API.Golden.Generated.AssetSize_user qualified
import Test.Wire.API.Golden.Generated.AssetToken_user qualified
import Test.Wire.API.Golden.Generated.Asset_asset qualified
import Test.Wire.API.Golden.Generated.BindingNewTeamUser_user qualified
import Test.Wire.API.Golden.Generated.BotConvView_provider qualified
import Test.Wire.API.Golden.Generated.BotUserView_provider qualified
import Test.Wire.API.Golden.Generated.CheckHandles_user qualified
import Test.Wire.API.Golden.Generated.ClientClass_user qualified
import Test.Wire.API.Golden.Generated.ClientMismatch_user qualified
import Test.Wire.API.Golden.Generated.ClientPrekey_user qualified
import Test.Wire.API.Golden.Generated.ClientType_user qualified
import Test.Wire.API.Golden.Generated.Client_user qualified
import Test.Wire.API.Golden.Generated.ColourId_user qualified
import Test.Wire.API.Golden.Generated.CompletePasswordReset_provider qualified
import Test.Wire.API.Golden.Generated.CompletePasswordReset_user qualified
import Test.Wire.API.Golden.Generated.Connect_user qualified
import Test.Wire.API.Golden.Generated.ConnectionRequest_user qualified
import Test.Wire.API.Golden.Generated.ConnectionUpdate_user qualified
import Test.Wire.API.Golden.Generated.Contact_user qualified
import Test.Wire.API.Golden.Generated.ConvMembers_user qualified
import Test.Wire.API.Golden.Generated.ConvTeamInfo_user qualified
import Test.Wire.API.Golden.Generated.ConvType_user qualified
import Test.Wire.API.Golden.Generated.ConversationAccessData_user qualified
import Test.Wire.API.Golden.Generated.ConversationCode_user qualified
import Test.Wire.API.Golden.Generated.ConversationList_20Conversation_user qualified
import Test.Wire.API.Golden.Generated.ConversationList_20_28Id_20_2a_20C_29_user qualified
import Test.Wire.API.Golden.Generated.ConversationMessageTimerUpdate_user qualified
import Test.Wire.API.Golden.Generated.ConversationReceiptModeUpdate_user qualified
import Test.Wire.API.Golden.Generated.ConversationRename_user qualified
import Test.Wire.API.Golden.Generated.ConversationRole_user qualified
import Test.Wire.API.Golden.Generated.ConversationRolesList_user qualified
import Test.Wire.API.Golden.Generated.Conversation_user qualified
import Test.Wire.API.Golden.Generated.CookieId_user qualified
import Test.Wire.API.Golden.Generated.CookieLabel_user qualified
import Test.Wire.API.Golden.Generated.CookieList_user qualified
import Test.Wire.API.Golden.Generated.CookieType_user qualified
import Test.Wire.API.Golden.Generated.Cookie_20_28_29_user qualified
import Test.Wire.API.Golden.Generated.CustomBackend_user qualified
import Test.Wire.API.Golden.Generated.DeleteProvider_provider qualified
import Test.Wire.API.Golden.Generated.DeleteService_provider qualified
import Test.Wire.API.Golden.Generated.DeleteUser_user qualified
import Test.Wire.API.Golden.Generated.DeletionCodeTimeout_user qualified
import Test.Wire.API.Golden.Generated.DisableLegalHoldForUserRequest_team qualified
import Test.Wire.API.Golden.Generated.EmailUpdate_provider qualified
import Test.Wire.API.Golden.Generated.EmailUpdate_user qualified
import Test.Wire.API.Golden.Generated.Email_user qualified
import Test.Wire.API.Golden.Generated.EventType_team qualified
import Test.Wire.API.Golden.Generated.EventType_user qualified
import Test.Wire.API.Golden.Generated.Event_conversation qualified
import Test.Wire.API.Golden.Generated.Event_featureConfig qualified
import Test.Wire.API.Golden.Generated.Event_team qualified
import Test.Wire.API.Golden.Generated.Event_user qualified
import Test.Wire.API.Golden.Generated.Feature_team qualified
import Test.Wire.API.Golden.Generated.HandleUpdate_user qualified
import Test.Wire.API.Golden.Generated.InvitationCode_user qualified
import Test.Wire.API.Golden.Generated.InvitationList_team qualified
import Test.Wire.API.Golden.Generated.InvitationRequest_team qualified
import Test.Wire.API.Golden.Generated.Invitation_team qualified
import Test.Wire.API.Golden.Generated.Invite_user qualified
import Test.Wire.API.Golden.Generated.LastPrekey_user qualified
import Test.Wire.API.Golden.Generated.LegalHoldServiceConfirm_team qualified
import Test.Wire.API.Golden.Generated.LegalHoldServiceRemove_team qualified
import Test.Wire.API.Golden.Generated.LimitedQualifiedUserIdList_user qualified
import Test.Wire.API.Golden.Generated.ListType_team qualified
import Test.Wire.API.Golden.Generated.LocaleUpdate_user qualified
import Test.Wire.API.Golden.Generated.Locale_user qualified
import Test.Wire.API.Golden.Generated.LockableFeaturePatch_team qualified
import Test.Wire.API.Golden.Generated.LockableFeature_team qualified
import Test.Wire.API.Golden.Generated.LoginCodeTimeout_user qualified
import Test.Wire.API.Golden.Generated.LoginCode_user qualified
import Test.Wire.API.Golden.Generated.ManagedBy_user qualified
import Test.Wire.API.Golden.Generated.MemberUpdateData_user qualified
import Test.Wire.API.Golden.Generated.MemberUpdate_user qualified
import Test.Wire.API.Golden.Generated.Member_user qualified
import Test.Wire.API.Golden.Generated.MembersJoin_user qualified
import Test.Wire.API.Golden.Generated.MutedStatus_user qualified
import Test.Wire.API.Golden.Generated.NameUpdate_user qualified
import Test.Wire.API.Golden.Generated.Name_user qualified
import Test.Wire.API.Golden.Generated.NewAssetToken_user qualified
import Test.Wire.API.Golden.Generated.NewBotRequest_provider qualified
import Test.Wire.API.Golden.Generated.NewBotResponse_provider qualified
import Test.Wire.API.Golden.Generated.NewClient_user qualified
import Test.Wire.API.Golden.Generated.NewConv_user qualified
import Test.Wire.API.Golden.Generated.NewLegalHoldClient_team qualified
import Test.Wire.API.Golden.Generated.NewLegalHoldService_team qualified
import Test.Wire.API.Golden.Generated.NewOne2OneConv_user qualified
import Test.Wire.API.Golden.Generated.NewOtrMessage_user qualified
import Test.Wire.API.Golden.Generated.NewPasswordReset_user qualified
import Test.Wire.API.Golden.Generated.NewProviderResponse_provider qualified
import Test.Wire.API.Golden.Generated.NewProvider_provider qualified
import Test.Wire.API.Golden.Generated.NewServiceResponse_provider qualified
import Test.Wire.API.Golden.Generated.NewService_provider qualified
import Test.Wire.API.Golden.Generated.NewTeamMember_team qualified
import Test.Wire.API.Golden.Generated.NewTeam_team qualified
import Test.Wire.API.Golden.Generated.NewUserPublic_user qualified
import Test.Wire.API.Golden.Generated.NewUser_user qualified
import Test.Wire.API.Golden.Generated.OtherMemberUpdate_user qualified
import Test.Wire.API.Golden.Generated.OtherMember_user qualified
import Test.Wire.API.Golden.Generated.OtrMessage_user qualified
import Test.Wire.API.Golden.Generated.OtrRecipients_user qualified
import Test.Wire.API.Golden.Generated.PasswordChange_provider qualified
import Test.Wire.API.Golden.Generated.PasswordChange_user qualified
import Test.Wire.API.Golden.Generated.PasswordResetCode_user qualified
import Test.Wire.API.Golden.Generated.PasswordResetKey_user qualified
import Test.Wire.API.Golden.Generated.PasswordReset_provider qualified
import Test.Wire.API.Golden.Generated.PendingLoginCode_user qualified
import Test.Wire.API.Golden.Generated.Permissions_team qualified
import Test.Wire.API.Golden.Generated.PhoneUpdate_user qualified
import Test.Wire.API.Golden.Generated.Phone_user qualified
import Test.Wire.API.Golden.Generated.Pict_user qualified
import Test.Wire.API.Golden.Generated.PrekeyBundle_user qualified
import Test.Wire.API.Golden.Generated.PrekeyId_user qualified
import Test.Wire.API.Golden.Generated.Prekey_user qualified
import Test.Wire.API.Golden.Generated.Priority_user qualified
import Test.Wire.API.Golden.Generated.PropertyKey_user qualified
import Test.Wire.API.Golden.Generated.ProviderActivationResponse_provider qualified
import Test.Wire.API.Golden.Generated.ProviderLogin_provider qualified
import Test.Wire.API.Golden.Generated.ProviderProfile_provider qualified
import Test.Wire.API.Golden.Generated.Provider_provider qualified
import Test.Wire.API.Golden.Generated.PubClient_user qualified
import Test.Wire.API.Golden.Generated.PushTokenList_user qualified
import Test.Wire.API.Golden.Generated.PushToken_user qualified
import Test.Wire.API.Golden.Generated.Push_2eToken_2eTransport_user qualified
import Test.Wire.API.Golden.Generated.QualifiedUserClientPrekeyMapV4_user qualified
import Test.Wire.API.Golden.Generated.QueuedNotificationList_user qualified
import Test.Wire.API.Golden.Generated.QueuedNotification_user qualified
import Test.Wire.API.Golden.Generated.RTCConfiguration_user qualified
import Test.Wire.API.Golden.Generated.RTCIceServer_user qualified
import Test.Wire.API.Golden.Generated.ReceiptMode_user qualified
import Test.Wire.API.Golden.Generated.Relation_user qualified
import Test.Wire.API.Golden.Generated.RemoveBotResponse_user qualified
import Test.Wire.API.Golden.Generated.RemoveCookies_user qualified
import Test.Wire.API.Golden.Generated.RemoveLegalHoldSettingsRequest_team qualified
import Test.Wire.API.Golden.Generated.RequestNewLegalHoldClient_team qualified
import Test.Wire.API.Golden.Generated.RichField_user qualified
import Test.Wire.API.Golden.Generated.RichInfoAssocList_user qualified
import Test.Wire.API.Golden.Generated.RichInfo_user qualified
import Test.Wire.API.Golden.Generated.RmClient_user qualified
import Test.Wire.API.Golden.Generated.RoleName_user qualified
import Test.Wire.API.Golden.Generated.Role_team qualified
import Test.Wire.API.Golden.Generated.SFTServer_user qualified
import Test.Wire.API.Golden.Generated.Scheme_user qualified
import Test.Wire.API.Golden.Generated.SearchResult_20Contact_user qualified
import Test.Wire.API.Golden.Generated.SearchResult_20TeamContact_user qualified
import Test.Wire.API.Golden.Generated.SelfProfile_user qualified
import Test.Wire.API.Golden.Generated.SendLoginCode_user qualified
import Test.Wire.API.Golden.Generated.ServiceKeyPEM_provider qualified
import Test.Wire.API.Golden.Generated.ServiceKeyType_provider qualified
import Test.Wire.API.Golden.Generated.ServiceKey_provider qualified
import Test.Wire.API.Golden.Generated.ServiceProfilePage_provider qualified
import Test.Wire.API.Golden.Generated.ServiceProfile_provider qualified
import Test.Wire.API.Golden.Generated.ServiceRef_provider qualified
import Test.Wire.API.Golden.Generated.ServiceTagList_provider qualified
import Test.Wire.API.Golden.Generated.ServiceTag_provider qualified
import Test.Wire.API.Golden.Generated.ServiceToken_provider qualified
import Test.Wire.API.Golden.Generated.Service_provider qualified
import Test.Wire.API.Golden.Generated.SimpleMember_user qualified
import Test.Wire.API.Golden.Generated.TeamBinding_team qualified
import Test.Wire.API.Golden.Generated.TeamContact_user qualified
import Test.Wire.API.Golden.Generated.TeamConversationList_team qualified
import Test.Wire.API.Golden.Generated.TeamConversation_team qualified
import Test.Wire.API.Golden.Generated.TeamDeleteData_team qualified
import Test.Wire.API.Golden.Generated.TeamList_team qualified
import Test.Wire.API.Golden.Generated.TeamMemberDeleteData_team qualified
import Test.Wire.API.Golden.Generated.TeamMemberList_team qualified
import Test.Wire.API.Golden.Generated.TeamMember_team qualified
import Test.Wire.API.Golden.Generated.TeamSearchVisibilityView_team qualified
import Test.Wire.API.Golden.Generated.TeamSearchVisibility_team qualified
import Test.Wire.API.Golden.Generated.TeamUpdateData_team qualified
import Test.Wire.API.Golden.Generated.Team_team qualified
import Test.Wire.API.Golden.Generated.TokenType_user qualified
import Test.Wire.API.Golden.Generated.Token_user qualified
import Test.Wire.API.Golden.Generated.Transport_user qualified
import Test.Wire.API.Golden.Generated.TurnHost_user qualified
import Test.Wire.API.Golden.Generated.TurnURI_user qualified
import Test.Wire.API.Golden.Generated.TurnUsername_user qualified
import Test.Wire.API.Golden.Generated.TypingStatus_user qualified
import Test.Wire.API.Golden.Generated.UpdateBotPrekeys_user qualified
import Test.Wire.API.Golden.Generated.UpdateClient_user qualified
import Test.Wire.API.Golden.Generated.UpdateProvider_provider qualified
import Test.Wire.API.Golden.Generated.UpdateServiceConn_provider qualified
import Test.Wire.API.Golden.Generated.UpdateServiceWhitelist_provider qualified
import Test.Wire.API.Golden.Generated.UpdateService_provider qualified
import Test.Wire.API.Golden.Generated.UserClientMap_20Int_user qualified
import Test.Wire.API.Golden.Generated.UserClients_user qualified
import Test.Wire.API.Golden.Generated.UserConnectionList_user qualified
import Test.Wire.API.Golden.Generated.UserConnection_user qualified
import Test.Wire.API.Golden.Generated.UserHandleInfo_user qualified
import Test.Wire.API.Golden.Generated.UserLegalHoldStatusResponse_team qualified
import Test.Wire.API.Golden.Generated.UserProfile_user qualified
import Test.Wire.API.Golden.Generated.UserSSOId_user qualified
import Test.Wire.API.Golden.Generated.UserUpdate_user qualified
import Test.Wire.API.Golden.Generated.User_2eProfile_2eAsset_user qualified
import Test.Wire.API.Golden.Generated.User_user qualified
import Test.Wire.API.Golden.Generated.VerificationAction_user qualified
import Test.Wire.API.Golden.Generated.VerifyDeleteUser_user qualified
import Test.Wire.API.Golden.Generated.ViewLegalHoldServiceInfo_team qualified
import Test.Wire.API.Golden.Generated.ViewLegalHoldService_team qualified
import Test.Wire.API.Golden.Generated.Wrapped_20_22some_5fint_22_20Int_user qualified
import Test.Wire.API.Golden.Runner
import Wire.API.Routes.Version
import Wire.API.Routes.Versioned

tests :: TestTree
tests =
  testGroup
    "Golden tests"
    [ testGroup "Golden: AssetToken_user" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.AssetToken_user.testObject_AssetToken_user_1, "testObject_AssetToken_user_1.json"),
            (Test.Wire.API.Golden.Generated.AssetToken_user.testObject_AssetToken_user_4, "testObject_AssetToken_user_4.json"),
            (Test.Wire.API.Golden.Generated.AssetToken_user.testObject_AssetToken_user_5, "testObject_AssetToken_user_5.json"),
            (Test.Wire.API.Golden.Generated.AssetToken_user.testObject_AssetToken_user_7, "testObject_AssetToken_user_7.json"),
            (Test.Wire.API.Golden.Generated.AssetToken_user.testObject_AssetToken_user_12, "testObject_AssetToken_user_12.json"),
            (Test.Wire.API.Golden.Generated.AssetToken_user.testObject_AssetToken_user_15, "testObject_AssetToken_user_15.json"),
            (Test.Wire.API.Golden.Generated.AssetToken_user.testObject_AssetToken_user_20, "testObject_AssetToken_user_20.json")
          ],
      testGroup "Golden: NewAssetToken_user" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.NewAssetToken_user.testObject_NewAssetToken_user_3, "testObject_NewAssetToken_user_3.json"),
            (Test.Wire.API.Golden.Generated.NewAssetToken_user.testObject_NewAssetToken_user_6, "testObject_NewAssetToken_user_6.json"),
            (Test.Wire.API.Golden.Generated.NewAssetToken_user.testObject_NewAssetToken_user_9, "testObject_NewAssetToken_user_9.json")
          ],
      testGroup "Golden: AssetRetention_user" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.AssetRetention_user.testObject_AssetRetention_user_1, "testObject_AssetRetention_user_1.json"),
            (Test.Wire.API.Golden.Generated.AssetRetention_user.testObject_AssetRetention_user_2, "testObject_AssetRetention_user_2.json"),
            (Test.Wire.API.Golden.Generated.AssetRetention_user.testObject_AssetRetention_user_3, "testObject_AssetRetention_user_3.json"),
            (Test.Wire.API.Golden.Generated.AssetRetention_user.testObject_AssetRetention_user_8, "testObject_AssetRetention_user_8.json"),
            (Test.Wire.API.Golden.Generated.AssetRetention_user.testObject_AssetRetention_user_13, "testObject_AssetRetention_user_13.json")
          ],
      testGroup "Golden: AssetSettings_user" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.AssetSettings_user.testObject_AssetSettings_user_1, "testObject_AssetSettings_user_1.json"),
            (Test.Wire.API.Golden.Generated.AssetSettings_user.testObject_AssetSettings_user_2, "testObject_AssetSettings_user_2.json"),
            (Test.Wire.API.Golden.Generated.AssetSettings_user.testObject_AssetSettings_user_3, "testObject_AssetSettings_user_3.json"),
            (Test.Wire.API.Golden.Generated.AssetSettings_user.testObject_AssetSettings_user_5, "testObject_AssetSettings_user_5.json"),
            (Test.Wire.API.Golden.Generated.AssetSettings_user.testObject_AssetSettings_user_6, "testObject_AssetSettings_user_6.json"),
            (Test.Wire.API.Golden.Generated.AssetSettings_user.testObject_AssetSettings_user_10, "testObject_AssetSettings_user_10.json"),
            (Test.Wire.API.Golden.Generated.AssetSettings_user.testObject_AssetSettings_user_14, "testObject_AssetSettings_user_14.json"),
            (Test.Wire.API.Golden.Generated.AssetSettings_user.testObject_AssetSettings_user_15, "testObject_AssetSettings_user_15.json"),
            (Test.Wire.API.Golden.Generated.AssetSettings_user.testObject_AssetSettings_user_16, "testObject_AssetSettings_user_16.json"),
            (Test.Wire.API.Golden.Generated.AssetSettings_user.testObject_AssetSettings_user_19, "testObject_AssetSettings_user_19.json"),
            (Test.Wire.API.Golden.Generated.AssetSettings_user.testObject_AssetSettings_user_20, "testObject_AssetSettings_user_20.json")
          ],
      testGroup "Golden: AssetKey_user" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.AssetKey_user.testObject_AssetKey_user_1, "testObject_AssetKey_user_1.json"),
            (Test.Wire.API.Golden.Generated.AssetKey_user.testObject_AssetKey_user_2, "testObject_AssetKey_user_2.json"),
            (Test.Wire.API.Golden.Generated.AssetKey_user.testObject_AssetKey_user_3, "testObject_AssetKey_user_3.json"),
            (Test.Wire.API.Golden.Generated.AssetKey_user.testObject_AssetKey_user_4, "testObject_AssetKey_user_4.json"),
            (Test.Wire.API.Golden.Generated.AssetKey_user.testObject_AssetKey_user_5, "testObject_AssetKey_user_5.json")
          ],
      testGroup "Golden: TurnHost_user" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.TurnHost_user.testObject_TurnHost_user_1, "testObject_TurnHost_user_1.json"),
            (Test.Wire.API.Golden.Generated.TurnHost_user.testObject_TurnHost_user_2, "testObject_TurnHost_user_2.json"),
            (Test.Wire.API.Golden.Generated.TurnHost_user.testObject_TurnHost_user_8, "testObject_TurnHost_user_8.json"),
            (Test.Wire.API.Golden.Generated.TurnHost_user.testObject_TurnHost_user_9, "testObject_TurnHost_user_9.json"),
            (Test.Wire.API.Golden.Generated.TurnHost_user.testObject_TurnHost_user_12, "testObject_TurnHost_user_12.json"),
            (Test.Wire.API.Golden.Generated.TurnHost_user.testObject_TurnHost_user_14, "testObject_TurnHost_user_14.json"),
            (Test.Wire.API.Golden.Generated.TurnHost_user.testObject_TurnHost_user_20, "testObject_TurnHost_user_20.json")
          ],
      testGroup "Golden: Scheme_user" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.Scheme_user.testObject_Scheme_user_1, "testObject_Scheme_user_1.json"),
            (Test.Wire.API.Golden.Generated.Scheme_user.testObject_Scheme_user_2, "testObject_Scheme_user_2.json")
          ],
      testGroup "Golden: Transport_user" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.Transport_user.testObject_Transport_user_1, "testObject_Transport_user_1.json"),
            (Test.Wire.API.Golden.Generated.Transport_user.testObject_Transport_user_2, "testObject_Transport_user_2.json")
          ],
      testGroup "Golden: TurnURI_user" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.TurnURI_user.testObject_TurnURI_user_1, "testObject_TurnURI_user_1.json"),
            (Test.Wire.API.Golden.Generated.TurnURI_user.testObject_TurnURI_user_9, "testObject_TurnURI_user_9.json")
          ],
      testGroup "Golden: TurnUsername_user" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.TurnUsername_user.testObject_TurnUsername_user_1, "testObject_TurnUsername_user_1.json"),
            (Test.Wire.API.Golden.Generated.TurnUsername_user.testObject_TurnUsername_user_2, "testObject_TurnUsername_user_2.json"),
            (Test.Wire.API.Golden.Generated.TurnUsername_user.testObject_TurnUsername_user_3, "testObject_TurnUsername_user_3.json"),
            (Test.Wire.API.Golden.Generated.TurnUsername_user.testObject_TurnUsername_user_4, "testObject_TurnUsername_user_4.json"),
            (Test.Wire.API.Golden.Generated.TurnUsername_user.testObject_TurnUsername_user_5, "testObject_TurnUsername_user_5.json"),
            (Test.Wire.API.Golden.Generated.TurnUsername_user.testObject_TurnUsername_user_6, "testObject_TurnUsername_user_6.json"),
            (Test.Wire.API.Golden.Generated.TurnUsername_user.testObject_TurnUsername_user_7, "testObject_TurnUsername_user_7.json"),
            (Test.Wire.API.Golden.Generated.TurnUsername_user.testObject_TurnUsername_user_8, "testObject_TurnUsername_user_8.json"),
            (Test.Wire.API.Golden.Generated.TurnUsername_user.testObject_TurnUsername_user_9, "testObject_TurnUsername_user_9.json"),
            (Test.Wire.API.Golden.Generated.TurnUsername_user.testObject_TurnUsername_user_10, "testObject_TurnUsername_user_10.json"),
            (Test.Wire.API.Golden.Generated.TurnUsername_user.testObject_TurnUsername_user_11, "testObject_TurnUsername_user_11.json"),
            (Test.Wire.API.Golden.Generated.TurnUsername_user.testObject_TurnUsername_user_12, "testObject_TurnUsername_user_12.json"),
            (Test.Wire.API.Golden.Generated.TurnUsername_user.testObject_TurnUsername_user_13, "testObject_TurnUsername_user_13.json"),
            (Test.Wire.API.Golden.Generated.TurnUsername_user.testObject_TurnUsername_user_14, "testObject_TurnUsername_user_14.json"),
            (Test.Wire.API.Golden.Generated.TurnUsername_user.testObject_TurnUsername_user_15, "testObject_TurnUsername_user_15.json"),
            (Test.Wire.API.Golden.Generated.TurnUsername_user.testObject_TurnUsername_user_16, "testObject_TurnUsername_user_16.json"),
            (Test.Wire.API.Golden.Generated.TurnUsername_user.testObject_TurnUsername_user_17, "testObject_TurnUsername_user_17.json"),
            (Test.Wire.API.Golden.Generated.TurnUsername_user.testObject_TurnUsername_user_18, "testObject_TurnUsername_user_18.json"),
            (Test.Wire.API.Golden.Generated.TurnUsername_user.testObject_TurnUsername_user_19, "testObject_TurnUsername_user_19.json"),
            (Test.Wire.API.Golden.Generated.TurnUsername_user.testObject_TurnUsername_user_20, "testObject_TurnUsername_user_20.json")
          ],
      testGroup "Golden: RTCIceServer_user" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.RTCIceServer_user.testObject_RTCIceServer_user_1, "testObject_RTCIceServer_user_1.json"),
            (Test.Wire.API.Golden.Generated.RTCIceServer_user.testObject_RTCIceServer_user_2, "testObject_RTCIceServer_user_2.json")
          ],
      testGroup "Golden: RTCConfiguration_user" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.RTCConfiguration_user.testObject_RTCConfiguration_user_1, "testObject_RTCConfiguration_user_1.json"),
            (Test.Wire.API.Golden.Generated.RTCConfiguration_user.testObject_RTCConfiguration_user_2, "testObject_RTCConfiguration_user_2.json"),
            (Test.Wire.API.Golden.Generated.RTCConfiguration_user.testObject_RTCConfiguration_user_3, "testObject_RTCConfiguration_user_3.json"),
            (Test.Wire.API.Golden.Generated.RTCConfiguration_user.testObject_RTCConfiguration_user_4, "testObject_RTCConfiguration_user_4.json"),
            (Test.Wire.API.Golden.Generated.RTCConfiguration_user.testObject_RTCConfiguration_user_5, "testObject_RTCConfiguration_user_5.json"),
            (Test.Wire.API.Golden.Generated.RTCConfiguration_user.testObject_RTCConfiguration_user_6, "testObject_RTCConfiguration_user_6.json"),
            (Test.Wire.API.Golden.Generated.RTCConfiguration_user.testObject_RTCConfiguration_user_7, "testObject_RTCConfiguration_user_7.json"),
            (Test.Wire.API.Golden.Generated.RTCConfiguration_user.testObject_RTCConfiguration_user_8, "testObject_RTCConfiguration_user_8.json")
          ],
      testGroup "Golden: SFTServer_user" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.SFTServer_user.testObject_SFTServer_user_1, "testObject_SFTServer_user_1.json")
          ],
      testGroup "Golden: ConnectionRequest_user" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.ConnectionRequest_user.testObject_ConnectionRequest_user_1, "testObject_ConnectionRequest_user_1.json"),
            (Test.Wire.API.Golden.Generated.ConnectionRequest_user.testObject_ConnectionRequest_user_2, "testObject_ConnectionRequest_user_2.json")
          ],
      testGroup "Golden: Relation_user" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.Relation_user.testObject_Relation_user_1, "testObject_Relation_user_1.json"),
            (Test.Wire.API.Golden.Generated.Relation_user.testObject_Relation_user_2, "testObject_Relation_user_2.json"),
            (Test.Wire.API.Golden.Generated.Relation_user.testObject_Relation_user_3, "testObject_Relation_user_3.json"),
            (Test.Wire.API.Golden.Generated.Relation_user.testObject_Relation_user_4, "testObject_Relation_user_4.json"),
            (Test.Wire.API.Golden.Generated.Relation_user.testObject_Relation_user_5, "testObject_Relation_user_5.json"),
            (Test.Wire.API.Golden.Generated.Relation_user.testObject_Relation_user_6, "testObject_Relation_user_6.json"),
            (Test.Wire.API.Golden.Generated.Relation_user.testObject_Relation_user_7, "testObject_Relation_user_7.json")
          ],
      testGroup "Golden: UserConnection_user" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.UserConnection_user.testObject_UserConnection_user_1, "testObject_UserConnection_user_1.json"),
            (Test.Wire.API.Golden.Generated.UserConnection_user.testObject_UserConnection_user_2, "testObject_UserConnection_user_2.json")
          ],
      testGroup "Golden: UserConnectionList_user" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.UserConnectionList_user.testObject_UserConnectionList_user_1, "testObject_UserConnectionList_user_1.json"),
            (Test.Wire.API.Golden.Generated.UserConnectionList_user.testObject_UserConnectionList_user_2, "testObject_UserConnectionList_user_2.json")
          ],
      testGroup "Golden: ConnectionUpdate_user" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.ConnectionUpdate_user.testObject_ConnectionUpdate_user_1, "testObject_ConnectionUpdate_user_1.json")
          ],
      testGroup "Golden: Conversation_user V2" $
        testObjects
          [ (Versioned @'V2 Test.Wire.API.Golden.Generated.Conversation_user.testObject_Conversation_user_1, "testObject_Conversation_v2_user_1.json"),
            (Versioned @'V2 Test.Wire.API.Golden.Generated.Conversation_user.testObject_Conversation_user_2, "testObject_Conversation_v2_user_2.json"),
            (Versioned @'V2 Test.Wire.API.Golden.Generated.Conversation_user.testObject_Conversation_user_3, "testObject_Conversation_v2_user_3.json"),
            (Versioned @'V2 Test.Wire.API.Golden.Generated.Conversation_user.testObject_Conversation_user_4, "testObject_Conversation_v2_user_4.json"),
            (Versioned @'V2 Test.Wire.API.Golden.Generated.Conversation_user.testObject_Conversation_user_5, "testObject_Conversation_v2_user_5.json")
          ],
      testGroup "Golden: Conversation_user V5" $
        testObjects
          [ (Versioned @'V5 Test.Wire.API.Golden.Generated.Conversation_user.testObject_Conversation_user_1, "testObject_Conversation_v5_user_1.json"),
            (Versioned @'V5 Test.Wire.API.Golden.Generated.Conversation_user.testObject_Conversation_user_2, "testObject_Conversation_v5_user_2.json"),
            (Versioned @'V5 Test.Wire.API.Golden.Generated.Conversation_user.testObject_Conversation_user_3, "testObject_Conversation_v5_user_3.json"),
            (Versioned @'V5 Test.Wire.API.Golden.Generated.Conversation_user.testObject_Conversation_user_4, "testObject_Conversation_v5_user_4.json"),
            (Versioned @'V5 Test.Wire.API.Golden.Generated.Conversation_user.testObject_Conversation_user_5, "testObject_Conversation_v5_user_5.json")
          ],
      testGroup "Golden: Conversation_user" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.Conversation_user.testObject_Conversation_user_1, "testObject_Conversation_user_1.json"),
            (Test.Wire.API.Golden.Generated.Conversation_user.testObject_Conversation_user_2, "testObject_Conversation_user_2.json"),
            (Test.Wire.API.Golden.Generated.Conversation_user.testObject_Conversation_user_3, "testObject_Conversation_user_3.json"),
            (Test.Wire.API.Golden.Generated.Conversation_user.testObject_Conversation_user_4, "testObject_Conversation_user_4.json"),
            (Test.Wire.API.Golden.Generated.Conversation_user.testObject_Conversation_user_5, "testObject_Conversation_user_5.json")
          ],
      testGroup "Golden: NewConv_user V2" $
        testObjects
          [ (Versioned @'V2 Test.Wire.API.Golden.Generated.NewConv_user.testObject_NewConv_user_1, "testObject_NewConv_v2_user_1.json"),
            (Versioned @'V2 Test.Wire.API.Golden.Generated.NewConv_user.testObject_NewConv_user_3, "testObject_NewConv_v2_user_3.json")
          ],
      testGroup "Golden: NewConv_user" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.NewConv_user.testObject_NewConv_user_1, "testObject_NewConv_user_1.json"),
            (Test.Wire.API.Golden.Generated.NewConv_user.testObject_NewConv_user_3, "testObject_NewConv_user_3.json")
          ],
      testGroup "Golden: NewOne2OneConv_user" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.NewOne2OneConv_user.testObject_NewOne2OneConv_user_1, "testObject_NewOne2OneConv_user_1.json"),
            (Test.Wire.API.Golden.Generated.NewOne2OneConv_user.testObject_NewOne2OneConv_user_3, "testObject_NewOne2OneConv_user_3.json")
          ],
      testGroup "Golden: ConversationList_20_28Id_20_2a_20C_29_user" $
        testObjects
          [ ( Test.Wire.API.Golden.Generated.ConversationList_20_28Id_20_2a_20C_29_user.testObject_ConversationList_20_28Id_20_2a_20C_29_user_1,
              "testObject_ConversationList_20_28Id_20_2a_20C_29_user_1.json"
            ),
            ( Test.Wire.API.Golden.Generated.ConversationList_20_28Id_20_2a_20C_29_user.testObject_ConversationList_20_28Id_20_2a_20C_29_user_2,
              "testObject_ConversationList_20_28Id_20_2a_20C_29_user_2.json"
            )
          ],
      testGroup "Golden: ConversationList_20Conversation_user V2" $
        testObjects
          [ ( Versioned @'V2 Test.Wire.API.Golden.Generated.ConversationList_20Conversation_user.testObject_ConversationList_20Conversation_user_1,
              "testObject_ConversationList_20Conversation_v2_user_1.json"
            ),
            ( Versioned @'V2 Test.Wire.API.Golden.Generated.ConversationList_20Conversation_user.testObject_ConversationList_20Conversation_user_2,
              "testObject_ConversationList_20Conversation_v2_user_2.json"
            )
          ],
      testGroup "Golden: Access_user" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.Access_user.testObject_Access_user_1, "testObject_Access_user_1.json"),
            (Test.Wire.API.Golden.Generated.Access_user.testObject_Access_user_2, "testObject_Access_user_2.json"),
            (Test.Wire.API.Golden.Generated.Access_user.testObject_Access_user_3, "testObject_Access_user_3.json"),
            (Test.Wire.API.Golden.Generated.Access_user.testObject_Access_user_4, "testObject_Access_user_4.json")
          ],
      testGroup "Golden: AccessRoleLegacy_user" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.AccessRoleLegacy_user.testObject_AccessRoleLegacy_user_1, "testObject_AccessRoleLegacy_user_1.json"),
            (Test.Wire.API.Golden.Generated.AccessRoleLegacy_user.testObject_AccessRoleLegacy_user_2, "testObject_AccessRoleLegacy_user_2.json"),
            (Test.Wire.API.Golden.Generated.AccessRoleLegacy_user.testObject_AccessRoleLegacy_user_3, "testObject_AccessRoleLegacy_user_3.json"),
            (Test.Wire.API.Golden.Generated.AccessRoleLegacy_user.testObject_AccessRoleLegacy_user_4, "testObject_AccessRoleLegacy_user_4.json")
          ],
      testGroup "Golden: ConvType_user" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.ConvType_user.testObject_ConvType_user_1, "testObject_ConvType_user_1.json"),
            (Test.Wire.API.Golden.Generated.ConvType_user.testObject_ConvType_user_2, "testObject_ConvType_user_2.json"),
            (Test.Wire.API.Golden.Generated.ConvType_user.testObject_ConvType_user_3, "testObject_ConvType_user_3.json"),
            (Test.Wire.API.Golden.Generated.ConvType_user.testObject_ConvType_user_4, "testObject_ConvType_user_4.json")
          ],
      testGroup "Golden: ReceiptMode_user" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.ReceiptMode_user.testObject_ReceiptMode_user_1, "testObject_ReceiptMode_user_1.json"),
            (Test.Wire.API.Golden.Generated.ReceiptMode_user.testObject_ReceiptMode_user_2, "testObject_ReceiptMode_user_2.json")
          ],
      testGroup "Golden: ConvTeamInfo_user" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.ConvTeamInfo_user.testObject_ConvTeamInfo_user_1, "testObject_ConvTeamInfo_user_1.json")
          ],
      testGroup "Golden: Invite_user" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.Invite_user.testObject_Invite_user_1, "testObject_Invite_user_1.json")
          ],
      testGroup "Golden: ConversationRename_user" $
        testObjects
          [ ( Test.Wire.API.Golden.Generated.ConversationRename_user.testObject_ConversationRename_user_1,
              "testObject_ConversationRename_user_1.json"
            )
          ],
      testGroup "Golden: ConversationAccessData_user V2" $
        testObjects
          [ ( Versioned @'V2 Test.Wire.API.Golden.Generated.ConversationAccessData_user.testObject_ConversationAccessData_user_1,
              "testObject_ConversationAccessData_v2_user_1.json"
            ),
            ( Versioned @'V2 Test.Wire.API.Golden.Generated.ConversationAccessData_user.testObject_ConversationAccessData_user_2,
              "testObject_ConversationAccessData_v2_user_2.json"
            )
          ],
      testGroup "Golden: ConversationAccessData_user" $
        testObjects
          [ ( Test.Wire.API.Golden.Generated.ConversationAccessData_user.testObject_ConversationAccessData_user_1,
              "testObject_ConversationAccessData_user_1.json"
            ),
            ( Test.Wire.API.Golden.Generated.ConversationAccessData_user.testObject_ConversationAccessData_user_2,
              "testObject_ConversationAccessData_user_2.json"
            )
          ],
      testGroup "Golden: ConversationReceiptModeUpdate_user" $
        testObjects
          [ ( Test.Wire.API.Golden.Generated.ConversationReceiptModeUpdate_user.testObject_ConversationReceiptModeUpdate_user_1,
              "testObject_ConversationReceiptModeUpdate_user_1.json"
            )
          ],
      testGroup "Golden: ConversationMessageTimerUpdate_user" $
        testObjects
          [ ( Test.Wire.API.Golden.Generated.ConversationMessageTimerUpdate_user.testObject_ConversationMessageTimerUpdate_user_1,
              "testObject_ConversationMessageTimerUpdate_user_1.json"
            ),
            ( Test.Wire.API.Golden.Generated.ConversationMessageTimerUpdate_user.testObject_ConversationMessageTimerUpdate_user_2,
              "testObject_ConversationMessageTimerUpdate_user_2.json"
            )
          ],
      testGroup "Golden: AddBot_user" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.AddBot_user.testObject_AddBot_user_1, "testObject_AddBot_user_1.json"),
            (Test.Wire.API.Golden.Generated.AddBot_user.testObject_AddBot_user_2, "testObject_AddBot_user_2.json")
          ],
      testGroup "Golden: AddBotResponse_user" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.AddBotResponse_user.testObject_AddBotResponse_user_1, "testObject_AddBotResponse_user_1.json"),
            (Test.Wire.API.Golden.Generated.AddBotResponse_user.testObject_AddBotResponse_user_2, "testObject_AddBotResponse_user_2.json")
          ],
      testGroup "Golden: RemoveBotResponse_user" $
        testObjects
          [ ( Test.Wire.API.Golden.Generated.RemoveBotResponse_user.testObject_RemoveBotResponse_user_1,
              "testObject_RemoveBotResponse_user_1.json"
            )
          ],
      testGroup "Golden: UpdateBotPrekeys_user" $
        testObjects
          [ ( Test.Wire.API.Golden.Generated.UpdateBotPrekeys_user.testObject_UpdateBotPrekeys_user_1,
              "testObject_UpdateBotPrekeys_user_1.json"
            ),
            ( Test.Wire.API.Golden.Generated.UpdateBotPrekeys_user.testObject_UpdateBotPrekeys_user_2,
              "testObject_UpdateBotPrekeys_user_2.json"
            )
          ],
      testGroup "Golden: ConversationCode_user" $
        testObjects
          [ ( Test.Wire.API.Golden.Generated.ConversationCode_user.testObject_ConversationCode_user_1,
              "testObject_ConversationCode_user_1.json"
            ),
            ( Test.Wire.API.Golden.Generated.ConversationCode_user.testObject_ConversationCode_user_2,
              "testObject_ConversationCode_user_2.json"
            )
          ],
      testGroup "Golden: MemberUpdate_user" $
        testObjects
          [ ( Test.Wire.API.Golden.Generated.MemberUpdate_user.testObject_MemberUpdate_user_1,
              "testObject_MemberUpdate_user_1.json"
            ),
            ( Test.Wire.API.Golden.Generated.MemberUpdate_user.testObject_MemberUpdate_user_2,
              "testObject_MemberUpdate_user_2.json"
            )
          ],
      testGroup "Golden: MutedStatus_user" $
        testObjects
          [ ( Test.Wire.API.Golden.Generated.MutedStatus_user.testObject_MutedStatus_user_1,
              "testObject_MutedStatus_user_1.json"
            )
          ],
      testGroup "Golden: Member_user" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.Member_user.testObject_Member_user_1, "testObject_Member_user_1.json"),
            (Test.Wire.API.Golden.Generated.Member_user.testObject_Member_user_2, "testObject_Member_user_2.json")
          ],
      testGroup "Golden: OtherMember_user" $
        testObjects
          [ ( Test.Wire.API.Golden.Generated.OtherMember_user.testObject_OtherMember_user_1,
              "testObject_OtherMember_user_1.json"
            ),
            ( Test.Wire.API.Golden.Generated.OtherMember_user.testObject_OtherMember_user_2,
              "testObject_OtherMember_user_2.json"
            )
          ],
      testGroup "Golden: ConvMembers_user" $
        testObjects
          [ ( Test.Wire.API.Golden.Generated.ConvMembers_user.testObject_OwnConvMembers_user_1,
              "testObject_OwnConvMembers_user_1.json"
            ),
            ( Test.Wire.API.Golden.Generated.ConvMembers_user.testObject_OwnConvMembers_user_2,
              "testObject_OwnConvMembers_user_2.json"
            )
          ],
      testGroup "Golden: OtherMemberUpdate_user" $
        testObjects
          [ ( Test.Wire.API.Golden.Generated.OtherMemberUpdate_user.testObject_OtherMemberUpdate_user_1,
              "testObject_OtherMemberUpdate_user_1.json"
            )
          ],
      testGroup "Golden: RoleName_user" $
        testObjects
          [ ( Test.Wire.API.Golden.Generated.RoleName_user.testObject_RoleName_user_1,
              "testObject_RoleName_user_1.json"
            )
          ],
      testGroup "Golden: Action_user" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.Action_user.testObject_Action_user_1, "testObject_Action_user_1.json"),
            (Test.Wire.API.Golden.Generated.Action_user.testObject_Action_user_2, "testObject_Action_user_2.json"),
            (Test.Wire.API.Golden.Generated.Action_user.testObject_Action_user_3, "testObject_Action_user_3.json"),
            (Test.Wire.API.Golden.Generated.Action_user.testObject_Action_user_4, "testObject_Action_user_4.json"),
            (Test.Wire.API.Golden.Generated.Action_user.testObject_Action_user_5, "testObject_Action_user_5.json"),
            (Test.Wire.API.Golden.Generated.Action_user.testObject_Action_user_6, "testObject_Action_user_6.json"),
            (Test.Wire.API.Golden.Generated.Action_user.testObject_Action_user_7, "testObject_Action_user_7.json"),
            (Test.Wire.API.Golden.Generated.Action_user.testObject_Action_user_8, "testObject_Action_user_8.json"),
            (Test.Wire.API.Golden.Generated.Action_user.testObject_Action_user_9, "testObject_Action_user_9.json")
          ],
      testGroup "Golden: ConversationRole_user" $
        testObjects
          [ ( Test.Wire.API.Golden.Generated.ConversationRole_user.testObject_ConversationRole_user_1,
              "testObject_ConversationRole_user_1.json"
            ),
            ( Test.Wire.API.Golden.Generated.ConversationRole_user.testObject_ConversationRole_user_2,
              "testObject_ConversationRole_user_2.json"
            ),
            ( Test.Wire.API.Golden.Generated.ConversationRole_user.testObject_ConversationRole_user_3,
              "testObject_ConversationRole_user_3.json"
            )
          ],
      testGroup "Golden: ConversationRolesList_user" $
        testObjects
          [ ( Test.Wire.API.Golden.Generated.ConversationRolesList_user.testObject_ConversationRolesList_user_1,
              "testObject_ConversationRolesList_user_1.json"
            ),
            ( Test.Wire.API.Golden.Generated.ConversationRolesList_user.testObject_ConversationRolesList_user_2,
              "testObject_ConversationRolesList_user_2.json"
            )
          ],
      testGroup "Golden: TypingStatus_user" $
        testObjects
          [ ( Test.Wire.API.Golden.Generated.TypingStatus_user.testObject_TypingStatus_user_1,
              "testObject_TypingStatus_user_1.json"
            ),
            ( Test.Wire.API.Golden.Generated.TypingStatus_user.testObject_TypingStatus_user_2,
              "testObject_TypingStatus_user_2.json"
            )
          ],
      testGroup "Golden: CustomBackend_user" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.CustomBackend_user.testObject_CustomBackend_user_1, "testObject_CustomBackend_user_1.json"),
            (Test.Wire.API.Golden.Generated.CustomBackend_user.testObject_CustomBackend_user_2, "testObject_CustomBackend_user_2.json"),
            (Test.Wire.API.Golden.Generated.CustomBackend_user.testObject_CustomBackend_user_3, "testObject_CustomBackend_user_3.json"),
            (Test.Wire.API.Golden.Generated.CustomBackend_user.testObject_CustomBackend_user_4, "testObject_CustomBackend_user_4.json"),
            (Test.Wire.API.Golden.Generated.CustomBackend_user.testObject_CustomBackend_user_5, "testObject_CustomBackend_user_5.json"),
            (Test.Wire.API.Golden.Generated.CustomBackend_user.testObject_CustomBackend_user_6, "testObject_CustomBackend_user_6.json"),
            (Test.Wire.API.Golden.Generated.CustomBackend_user.testObject_CustomBackend_user_7, "testObject_CustomBackend_user_7.json"),
            (Test.Wire.API.Golden.Generated.CustomBackend_user.testObject_CustomBackend_user_8, "testObject_CustomBackend_user_8.json"),
            (Test.Wire.API.Golden.Generated.CustomBackend_user.testObject_CustomBackend_user_9, "testObject_CustomBackend_user_9.json"),
            (Test.Wire.API.Golden.Generated.CustomBackend_user.testObject_CustomBackend_user_10, "testObject_CustomBackend_user_10.json"),
            (Test.Wire.API.Golden.Generated.CustomBackend_user.testObject_CustomBackend_user_11, "testObject_CustomBackend_user_11.json"),
            (Test.Wire.API.Golden.Generated.CustomBackend_user.testObject_CustomBackend_user_12, "testObject_CustomBackend_user_12.json"),
            (Test.Wire.API.Golden.Generated.CustomBackend_user.testObject_CustomBackend_user_13, "testObject_CustomBackend_user_13.json"),
            (Test.Wire.API.Golden.Generated.CustomBackend_user.testObject_CustomBackend_user_14, "testObject_CustomBackend_user_14.json"),
            (Test.Wire.API.Golden.Generated.CustomBackend_user.testObject_CustomBackend_user_15, "testObject_CustomBackend_user_15.json"),
            (Test.Wire.API.Golden.Generated.CustomBackend_user.testObject_CustomBackend_user_16, "testObject_CustomBackend_user_16.json"),
            (Test.Wire.API.Golden.Generated.CustomBackend_user.testObject_CustomBackend_user_17, "testObject_CustomBackend_user_17.json"),
            (Test.Wire.API.Golden.Generated.CustomBackend_user.testObject_CustomBackend_user_18, "testObject_CustomBackend_user_18.json"),
            (Test.Wire.API.Golden.Generated.CustomBackend_user.testObject_CustomBackend_user_19, "testObject_CustomBackend_user_19.json"),
            (Test.Wire.API.Golden.Generated.CustomBackend_user.testObject_CustomBackend_user_20, "testObject_CustomBackend_user_20.json")
          ],
      testGroup "Golden: Event_user" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.Event_user.testObject_Event_user_1, "testObject_Event_user_1.json"),
            (Test.Wire.API.Golden.Generated.Event_user.testObject_Event_user_2, "testObject_Event_user_2.json"),
            (Test.Wire.API.Golden.Generated.Event_user.testObject_Event_user_3, "testObject_Event_user_3.json"),
            (Test.Wire.API.Golden.Generated.Event_user.testObject_Event_user_4, "testObject_Event_user_4.json"),
            (Test.Wire.API.Golden.Generated.Event_user.testObject_Event_user_5, "testObject_Event_user_5.json"),
            (Test.Wire.API.Golden.Generated.Event_user.testObject_Event_user_6, "testObject_Event_user_6.json"),
            (Test.Wire.API.Golden.Generated.Event_user.testObject_Event_user_7, "testObject_Event_user_7.json"),
            (Test.Wire.API.Golden.Generated.Event_user.testObject_Event_user_8, "testObject_Event_user_8.json"),
            (Test.Wire.API.Golden.Generated.Event_user.testObject_Event_user_9, "testObject_Event_user_9.json"),
            (Test.Wire.API.Golden.Generated.Event_user.testObject_Event_user_10, "testObject_Event_user_10.json"),
            (Test.Wire.API.Golden.Generated.Event_user.testObject_Event_user_11, "testObject_Event_user_11.json"),
            (Test.Wire.API.Golden.Generated.Event_user.testObject_Event_user_12, "testObject_Event_user_12.json"),
            (Test.Wire.API.Golden.Generated.Event_user.testObject_Event_user_13, "testObject_Event_user_13.json"),
            (Test.Wire.API.Golden.Generated.Event_user.testObject_Event_user_14, "testObject_Event_user_14.json"),
            (Test.Wire.API.Golden.Generated.Event_user.testObject_Event_user_15, "testObject_Event_user_15.json"),
            (Test.Wire.API.Golden.Generated.Event_user.testObject_Event_user_16, "testObject_Event_user_16.json")
          ],
      testGroup "Golden: EventType_user" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.EventType_user.testObject_EventType_user_1, "testObject_EventType_user_1.json"),
            (Test.Wire.API.Golden.Generated.EventType_user.testObject_EventType_user_2, "testObject_EventType_user_2.json"),
            (Test.Wire.API.Golden.Generated.EventType_user.testObject_EventType_user_3, "testObject_EventType_user_3.json"),
            (Test.Wire.API.Golden.Generated.EventType_user.testObject_EventType_user_4, "testObject_EventType_user_4.json"),
            (Test.Wire.API.Golden.Generated.EventType_user.testObject_EventType_user_5, "testObject_EventType_user_5.json"),
            (Test.Wire.API.Golden.Generated.EventType_user.testObject_EventType_user_6, "testObject_EventType_user_6.json"),
            (Test.Wire.API.Golden.Generated.EventType_user.testObject_EventType_user_7, "testObject_EventType_user_7.json"),
            (Test.Wire.API.Golden.Generated.EventType_user.testObject_EventType_user_8, "testObject_EventType_user_8.json"),
            (Test.Wire.API.Golden.Generated.EventType_user.testObject_EventType_user_9, "testObject_EventType_user_9.json"),
            (Test.Wire.API.Golden.Generated.EventType_user.testObject_EventType_user_10, "testObject_EventType_user_10.json"),
            (Test.Wire.API.Golden.Generated.EventType_user.testObject_EventType_user_11, "testObject_EventType_user_11.json"),
            (Test.Wire.API.Golden.Generated.EventType_user.testObject_EventType_user_12, "testObject_EventType_user_12.json"),
            (Test.Wire.API.Golden.Generated.EventType_user.testObject_EventType_user_13, "testObject_EventType_user_13.json"),
            (Test.Wire.API.Golden.Generated.EventType_user.testObject_EventType_user_14, "testObject_EventType_user_14.json")
          ],
      testGroup "Golden: SimpleMember_user" $
        testObjects
          [ ( Test.Wire.API.Golden.Generated.SimpleMember_user.testObject_SimpleMember_user_1,
              "testObject_SimpleMember_user_1.json"
            )
          ],
      testGroup "Golden: MembersJoin_user" $
        testObjects
          [ ( Test.Wire.API.Golden.Generated.MembersJoin_user.testObject_MembersJoin_user_1,
              "testObject_MembersJoin_user_1.json"
            ),
            ( Test.Wire.API.Golden.Generated.MembersJoin_user.testObject_MembersJoin_user_2,
              "testObject_MembersJoin_user_2.json"
            )
          ],
      testGroup "Golden: Connect_user" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.Connect_user.testObject_Connect_user_1, "testObject_Connect_user_1.json"),
            (Test.Wire.API.Golden.Generated.Connect_user.testObject_Connect_user_2, "testObject_Connect_user_2.json")
          ],
      testGroup "Golden: MemberUpdateData_user" $
        testObjects
          [ ( Test.Wire.API.Golden.Generated.MemberUpdateData_user.testObject_MemberUpdateData_user_1,
              "testObject_MemberUpdateData_user_1.json"
            ),
            ( Test.Wire.API.Golden.Generated.MemberUpdateData_user.testObject_MemberUpdateData_user_2,
              "testObject_MemberUpdateData_user_2.json"
            )
          ],
      testGroup "Golden: OtrMessage_user" $
        testObjects
          [ ( Test.Wire.API.Golden.Generated.OtrMessage_user.testObject_OtrMessage_user_1,
              "testObject_OtrMessage_user_1.json"
            ),
            ( Test.Wire.API.Golden.Generated.OtrMessage_user.testObject_OtrMessage_user_2,
              "testObject_OtrMessage_user_2.json"
            )
          ],
      testGroup "Golden: Priority_user" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.Priority_user.testObject_Priority_user_1, "testObject_Priority_user_1.json"),
            (Test.Wire.API.Golden.Generated.Priority_user.testObject_Priority_user_2, "testObject_Priority_user_2.json")
          ],
      testGroup "Golden: OtrRecipients_user" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.OtrRecipients_user.testObject_OtrRecipients_user_1, "testObject_OtrRecipients_user_1.json")
          ],
      testGroup "Golden: NewOtrMessage_user" $
        testObjects
          [ ( Test.Wire.API.Golden.Generated.NewOtrMessage_user.testObject_NewOtrMessage_user_1,
              "testObject_NewOtrMessage_user_1.json"
            ),
            ( Test.Wire.API.Golden.Generated.NewOtrMessage_user.testObject_NewOtrMessage_user_2,
              "testObject_NewOtrMessage_user_2.json"
            )
          ],
      testGroup "Golden: ClientMismatch_user" $
        testObjects
          [ ( Test.Wire.API.Golden.Generated.ClientMismatch_user.testObject_ClientMismatch_user_1,
              "testObject_ClientMismatch_user_1.json"
            )
          ],
      testGroup "Golden: QueuedNotification_user" $
        testObjects
          [ ( Test.Wire.API.Golden.Generated.QueuedNotification_user.testObject_QueuedNotification_user_1,
              "testObject_QueuedNotification_user_1.json"
            )
          ],
      testGroup "Golden: QueuedNotificationList_user" $
        testObjects
          [ ( Test.Wire.API.Golden.Generated.QueuedNotificationList_user.testObject_QueuedNotificationList_user_1,
              "testObject_QueuedNotificationList_user_1.json"
            ),
            ( Test.Wire.API.Golden.Generated.QueuedNotificationList_user.testObject_QueuedNotificationList_user_2,
              "testObject_QueuedNotificationList_user_2.json"
            )
          ],
      testGroup "Golden: PropertyKey_user" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.PropertyKey_user.testObject_PropertyKey_user_1, "testObject_PropertyKey_user_1.json"),
            (Test.Wire.API.Golden.Generated.PropertyKey_user.testObject_PropertyKey_user_2, "testObject_PropertyKey_user_2.json"),
            (Test.Wire.API.Golden.Generated.PropertyKey_user.testObject_PropertyKey_user_3, "testObject_PropertyKey_user_3.json"),
            (Test.Wire.API.Golden.Generated.PropertyKey_user.testObject_PropertyKey_user_4, "testObject_PropertyKey_user_4.json"),
            (Test.Wire.API.Golden.Generated.PropertyKey_user.testObject_PropertyKey_user_5, "testObject_PropertyKey_user_5.json"),
            (Test.Wire.API.Golden.Generated.PropertyKey_user.testObject_PropertyKey_user_6, "testObject_PropertyKey_user_6.json"),
            (Test.Wire.API.Golden.Generated.PropertyKey_user.testObject_PropertyKey_user_7, "testObject_PropertyKey_user_7.json"),
            (Test.Wire.API.Golden.Generated.PropertyKey_user.testObject_PropertyKey_user_8, "testObject_PropertyKey_user_8.json"),
            (Test.Wire.API.Golden.Generated.PropertyKey_user.testObject_PropertyKey_user_9, "testObject_PropertyKey_user_9.json"),
            (Test.Wire.API.Golden.Generated.PropertyKey_user.testObject_PropertyKey_user_10, "testObject_PropertyKey_user_10.json"),
            (Test.Wire.API.Golden.Generated.PropertyKey_user.testObject_PropertyKey_user_11, "testObject_PropertyKey_user_11.json"),
            (Test.Wire.API.Golden.Generated.PropertyKey_user.testObject_PropertyKey_user_12, "testObject_PropertyKey_user_12.json"),
            (Test.Wire.API.Golden.Generated.PropertyKey_user.testObject_PropertyKey_user_13, "testObject_PropertyKey_user_13.json"),
            (Test.Wire.API.Golden.Generated.PropertyKey_user.testObject_PropertyKey_user_14, "testObject_PropertyKey_user_14.json"),
            (Test.Wire.API.Golden.Generated.PropertyKey_user.testObject_PropertyKey_user_15, "testObject_PropertyKey_user_15.json"),
            (Test.Wire.API.Golden.Generated.PropertyKey_user.testObject_PropertyKey_user_16, "testObject_PropertyKey_user_16.json"),
            (Test.Wire.API.Golden.Generated.PropertyKey_user.testObject_PropertyKey_user_17, "testObject_PropertyKey_user_17.json"),
            (Test.Wire.API.Golden.Generated.PropertyKey_user.testObject_PropertyKey_user_18, "testObject_PropertyKey_user_18.json"),
            (Test.Wire.API.Golden.Generated.PropertyKey_user.testObject_PropertyKey_user_19, "testObject_PropertyKey_user_19.json"),
            (Test.Wire.API.Golden.Generated.PropertyKey_user.testObject_PropertyKey_user_20, "testObject_PropertyKey_user_20.json")
          ],
      testGroup "Golden: Push_2eToken_2eTransport_user" $
        testObjects
          [ ( Test.Wire.API.Golden.Generated.Push_2eToken_2eTransport_user.testObject_Push_2eToken_2eTransport_user_1,
              "testObject_Push_2eToken_2eTransport_user_1.json"
            ),
            ( Test.Wire.API.Golden.Generated.Push_2eToken_2eTransport_user.testObject_Push_2eToken_2eTransport_user_2,
              "testObject_Push_2eToken_2eTransport_user_2.json"
            ),
            ( Test.Wire.API.Golden.Generated.Push_2eToken_2eTransport_user.testObject_Push_2eToken_2eTransport_user_3,
              "testObject_Push_2eToken_2eTransport_user_3.json"
            ),
            ( Test.Wire.API.Golden.Generated.Push_2eToken_2eTransport_user.testObject_Push_2eToken_2eTransport_user_4,
              "testObject_Push_2eToken_2eTransport_user_4.json"
            ),
            ( Test.Wire.API.Golden.Generated.Push_2eToken_2eTransport_user.testObject_Push_2eToken_2eTransport_user_5,
              "testObject_Push_2eToken_2eTransport_user_5.json"
            )
          ],
      testGroup "Golden: Token_user" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.Token_user.testObject_Token_user_1, "testObject_Token_user_1.json")
          ],
      testGroup "Golden: AppName_user" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.AppName_user.testObject_AppName_user_1, "testObject_AppName_user_1.json")
          ],
      testGroup "Golden: PushToken_user" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.PushToken_user.testObject_PushToken_user_1, "testObject_PushToken_user_1.json")
          ],
      testGroup "Golden: PushTokenList_user" $
        testObjects
          [ ( Test.Wire.API.Golden.Generated.PushTokenList_user.testObject_PushTokenList_user_1,
              "testObject_PushTokenList_user_1.json"
            ),
            ( Test.Wire.API.Golden.Generated.PushTokenList_user.testObject_PushTokenList_user_2,
              "testObject_PushTokenList_user_2.json"
            )
          ],
      testGroup "Golden: NameUpdate_user" $
        testObjects
          [ ( Test.Wire.API.Golden.Generated.NameUpdate_user.testObject_NameUpdate_user_1,
              "testObject_NameUpdate_user_1.json"
            )
          ],
      testGroup "Golden: NewUser_user" $
        testObjects
          [ ( Test.Wire.API.Golden.Generated.NewUser_user.testObject_NewUser_user_1,
              "testObject_NewUser_user_1.json"
            ),
            ( Test.Wire.API.Golden.Generated.NewUser_user.testObject_NewUser_user_2,
              "testObject_NewUser_user_2.json"
            ),
            ( Test.Wire.API.Golden.Generated.NewUser_user.testObject_NewUser_user_3,
              "testObject_NewUser_user_3.json"
            ),
            ( Test.Wire.API.Golden.Generated.NewUser_user.testObject_NewUser_user_4,
              "testObject_NewUser_user_4.json"
            ),
            ( Test.Wire.API.Golden.Generated.NewUser_user.testObject_NewUser_user_5,
              "testObject_NewUser_user_5.json"
            ),
            ( Test.Wire.API.Golden.Generated.NewUser_user.testObject_NewUser_user_6,
              "testObject_NewUser_user_6.json"
            ),
            ( Test.Wire.API.Golden.Generated.NewUser_user.testObject_NewUser_user_7,
              "testObject_NewUser_user_7.json"
            ),
            ( Test.Wire.API.Golden.Generated.NewUser_user.testObject_NewUser_user_8,
              "testObject_NewUser_user_8.json"
            )
          ],
      testGroup "Golden: NewUserPublic_user" $
        testObjects
          [ ( Test.Wire.API.Golden.Generated.NewUserPublic_user.testObject_NewUserPublic_user_1,
              "testObject_NewUserPublic_user_1.json"
            )
          ],
      testGroup "Golden: LimitedQualifiedUserIdList_user_1" $
        testObjects
          [ ( Test.Wire.API.Golden.Generated.LimitedQualifiedUserIdList_user.testObject_LimitedQualifiedUserIdList_user_1,
              "testObject_LimitedQualifiedUserIdList_user_1.json"
            )
          ],
      testGroup "Golden: LimitedQualifiedUserIdList_user_2" $
        testObjects
          [ ( Test.Wire.API.Golden.Generated.LimitedQualifiedUserIdList_user.testObject_LimitedQualifiedUserIdList_user_2,
              "testObject_LimitedQualifiedUserIdList_user_2.json"
            )
          ],
      testGroup "Golden: LimitedQualifiedUserIdList_user_3" $
        testObjects
          [ ( Test.Wire.API.Golden.Generated.LimitedQualifiedUserIdList_user.testObject_LimitedQualifiedUserIdList_user_3,
              "testObject_LimitedQualifiedUserIdList_user_3.json"
            )
          ],
      testGroup "Golden: UserProfile_user" $
        testObjects
          [ ( Test.Wire.API.Golden.Generated.UserProfile_user.testObject_UserProfile_user_1,
              "testObject_UserProfile_user_1.json"
            ),
            ( Test.Wire.API.Golden.Generated.UserProfile_user.testObject_UserProfile_user_2,
              "testObject_UserProfile_user_2.json"
            )
          ],
      testGroup "Golden: User_user" $
        testObjects
          [ ( Test.Wire.API.Golden.Generated.User_user.testObject_User_user_1,
              "testObject_User_user_1.json"
            ),
            ( Test.Wire.API.Golden.Generated.User_user.testObject_User_user_2,
              "testObject_User_user_2.json"
            ),
            ( Test.Wire.API.Golden.Generated.User_user.testObject_User_user_3,
              "testObject_User_user_3.json"
            ),
            ( Test.Wire.API.Golden.Generated.User_user.testObject_User_user_4,
              "testObject_User_user_4.json"
            ),
            ( Test.Wire.API.Golden.Generated.User_user.testObject_User_user_5,
              "testObject_User_user_5.json"
            )
          ],
      testGroup "Golden: SelfProfile_user" $
        testObjects
          [ ( Test.Wire.API.Golden.Generated.SelfProfile_user.testObject_SelfProfile_user_1,
              "testObject_SelfProfile_user_1.json"
            )
          ],
      testGroup "Golden: InvitationCode_user" $
        testObjects
          [ ( Test.Wire.API.Golden.Generated.InvitationCode_user.testObject_InvitationCode_user_1,
              "testObject_InvitationCode_user_1.json"
            ),
            ( Test.Wire.API.Golden.Generated.InvitationCode_user.testObject_InvitationCode_user_2,
              "testObject_InvitationCode_user_2.json"
            ),
            ( Test.Wire.API.Golden.Generated.InvitationCode_user.testObject_InvitationCode_user_3,
              "testObject_InvitationCode_user_3.json"
            ),
            ( Test.Wire.API.Golden.Generated.InvitationCode_user.testObject_InvitationCode_user_4,
              "testObject_InvitationCode_user_4.json"
            ),
            ( Test.Wire.API.Golden.Generated.InvitationCode_user.testObject_InvitationCode_user_5,
              "testObject_InvitationCode_user_5.json"
            )
          ],
      testGroup "Golden: BindingNewTeamUser_user" $
        testObjects
          [ ( Test.Wire.API.Golden.Generated.BindingNewTeamUser_user.testObject_BindingNewTeamUser_user_1,
              "testObject_BindingNewTeamUser_user_1.json"
            ),
            ( Test.Wire.API.Golden.Generated.BindingNewTeamUser_user.testObject_BindingNewTeamUser_user_2,
              "testObject_BindingNewTeamUser_user_2.json"
            )
          ],
      testGroup "Golden: UserUpdate_user" $
        testObjects
          [ ( Test.Wire.API.Golden.Generated.UserUpdate_user.testObject_UserUpdate_user_1,
              "testObject_UserUpdate_user_1.json"
            ),
            ( Test.Wire.API.Golden.Generated.UserUpdate_user.testObject_UserUpdate_user_2,
              "testObject_UserUpdate_user_2.json"
            )
          ],
      testGroup "Golden: PasswordChange_user" $
        testObjects [(Test.Wire.API.Golden.Generated.PasswordChange_user.testObject_PasswordChange_user_1, "testObject_PasswordChange_user_1.json"), (Test.Wire.API.Golden.Generated.PasswordChange_user.testObject_PasswordChange_user_2, "testObject_PasswordChange_user_2.json"), (Test.Wire.API.Golden.Generated.PasswordChange_user.testObject_PasswordChange_user_3, "testObject_PasswordChange_user_3.json"), (Test.Wire.API.Golden.Generated.PasswordChange_user.testObject_PasswordChange_user_4, "testObject_PasswordChange_user_4.json"), (Test.Wire.API.Golden.Generated.PasswordChange_user.testObject_PasswordChange_user_5, "testObject_PasswordChange_user_5.json"), (Test.Wire.API.Golden.Generated.PasswordChange_user.testObject_PasswordChange_user_6, "testObject_PasswordChange_user_6.json"), (Test.Wire.API.Golden.Generated.PasswordChange_user.testObject_PasswordChange_user_7, "testObject_PasswordChange_user_7.json"), (Test.Wire.API.Golden.Generated.PasswordChange_user.testObject_PasswordChange_user_8, "testObject_PasswordChange_user_8.json"), (Test.Wire.API.Golden.Generated.PasswordChange_user.testObject_PasswordChange_user_9, "testObject_PasswordChange_user_9.json"), (Test.Wire.API.Golden.Generated.PasswordChange_user.testObject_PasswordChange_user_10, "testObject_PasswordChange_user_10.json"), (Test.Wire.API.Golden.Generated.PasswordChange_user.testObject_PasswordChange_user_11, "testObject_PasswordChange_user_11.json"), (Test.Wire.API.Golden.Generated.PasswordChange_user.testObject_PasswordChange_user_12, "testObject_PasswordChange_user_12.json"), (Test.Wire.API.Golden.Generated.PasswordChange_user.testObject_PasswordChange_user_13, "testObject_PasswordChange_user_13.json"), (Test.Wire.API.Golden.Generated.PasswordChange_user.testObject_PasswordChange_user_14, "testObject_PasswordChange_user_14.json"), (Test.Wire.API.Golden.Generated.PasswordChange_user.testObject_PasswordChange_user_15, "testObject_PasswordChange_user_15.json"), (Test.Wire.API.Golden.Generated.PasswordChange_user.testObject_PasswordChange_user_16, "testObject_PasswordChange_user_16.json"), (Test.Wire.API.Golden.Generated.PasswordChange_user.testObject_PasswordChange_user_17, "testObject_PasswordChange_user_17.json"), (Test.Wire.API.Golden.Generated.PasswordChange_user.testObject_PasswordChange_user_18, "testObject_PasswordChange_user_18.json"), (Test.Wire.API.Golden.Generated.PasswordChange_user.testObject_PasswordChange_user_19, "testObject_PasswordChange_user_19.json"), (Test.Wire.API.Golden.Generated.PasswordChange_user.testObject_PasswordChange_user_20, "testObject_PasswordChange_user_20.json")],
      testGroup "Golden: LocaleUpdate_user" $
        testObjects [(Test.Wire.API.Golden.Generated.LocaleUpdate_user.testObject_LocaleUpdate_user_1, "testObject_LocaleUpdate_user_1.json"), (Test.Wire.API.Golden.Generated.LocaleUpdate_user.testObject_LocaleUpdate_user_2, "testObject_LocaleUpdate_user_2.json"), (Test.Wire.API.Golden.Generated.LocaleUpdate_user.testObject_LocaleUpdate_user_3, "testObject_LocaleUpdate_user_3.json"), (Test.Wire.API.Golden.Generated.LocaleUpdate_user.testObject_LocaleUpdate_user_4, "testObject_LocaleUpdate_user_4.json"), (Test.Wire.API.Golden.Generated.LocaleUpdate_user.testObject_LocaleUpdate_user_5, "testObject_LocaleUpdate_user_5.json"), (Test.Wire.API.Golden.Generated.LocaleUpdate_user.testObject_LocaleUpdate_user_6, "testObject_LocaleUpdate_user_6.json"), (Test.Wire.API.Golden.Generated.LocaleUpdate_user.testObject_LocaleUpdate_user_7, "testObject_LocaleUpdate_user_7.json"), (Test.Wire.API.Golden.Generated.LocaleUpdate_user.testObject_LocaleUpdate_user_8, "testObject_LocaleUpdate_user_8.json"), (Test.Wire.API.Golden.Generated.LocaleUpdate_user.testObject_LocaleUpdate_user_9, "testObject_LocaleUpdate_user_9.json"), (Test.Wire.API.Golden.Generated.LocaleUpdate_user.testObject_LocaleUpdate_user_10, "testObject_LocaleUpdate_user_10.json"), (Test.Wire.API.Golden.Generated.LocaleUpdate_user.testObject_LocaleUpdate_user_11, "testObject_LocaleUpdate_user_11.json"), (Test.Wire.API.Golden.Generated.LocaleUpdate_user.testObject_LocaleUpdate_user_12, "testObject_LocaleUpdate_user_12.json"), (Test.Wire.API.Golden.Generated.LocaleUpdate_user.testObject_LocaleUpdate_user_13, "testObject_LocaleUpdate_user_13.json"), (Test.Wire.API.Golden.Generated.LocaleUpdate_user.testObject_LocaleUpdate_user_14, "testObject_LocaleUpdate_user_14.json"), (Test.Wire.API.Golden.Generated.LocaleUpdate_user.testObject_LocaleUpdate_user_15, "testObject_LocaleUpdate_user_15.json"), (Test.Wire.API.Golden.Generated.LocaleUpdate_user.testObject_LocaleUpdate_user_16, "testObject_LocaleUpdate_user_16.json"), (Test.Wire.API.Golden.Generated.LocaleUpdate_user.testObject_LocaleUpdate_user_17, "testObject_LocaleUpdate_user_17.json"), (Test.Wire.API.Golden.Generated.LocaleUpdate_user.testObject_LocaleUpdate_user_18, "testObject_LocaleUpdate_user_18.json"), (Test.Wire.API.Golden.Generated.LocaleUpdate_user.testObject_LocaleUpdate_user_19, "testObject_LocaleUpdate_user_19.json"), (Test.Wire.API.Golden.Generated.LocaleUpdate_user.testObject_LocaleUpdate_user_20, "testObject_LocaleUpdate_user_20.json")],
      testGroup "Golden: EmailUpdate_user" $
        testObjects [(Test.Wire.API.Golden.Generated.EmailUpdate_user.testObject_EmailUpdate_user_1, "testObject_EmailUpdate_user_1.json"), (Test.Wire.API.Golden.Generated.EmailUpdate_user.testObject_EmailUpdate_user_2, "testObject_EmailUpdate_user_2.json"), (Test.Wire.API.Golden.Generated.EmailUpdate_user.testObject_EmailUpdate_user_3, "testObject_EmailUpdate_user_3.json"), (Test.Wire.API.Golden.Generated.EmailUpdate_user.testObject_EmailUpdate_user_4, "testObject_EmailUpdate_user_4.json"), (Test.Wire.API.Golden.Generated.EmailUpdate_user.testObject_EmailUpdate_user_5, "testObject_EmailUpdate_user_5.json"), (Test.Wire.API.Golden.Generated.EmailUpdate_user.testObject_EmailUpdate_user_6, "testObject_EmailUpdate_user_6.json"), (Test.Wire.API.Golden.Generated.EmailUpdate_user.testObject_EmailUpdate_user_7, "testObject_EmailUpdate_user_7.json"), (Test.Wire.API.Golden.Generated.EmailUpdate_user.testObject_EmailUpdate_user_8, "testObject_EmailUpdate_user_8.json"), (Test.Wire.API.Golden.Generated.EmailUpdate_user.testObject_EmailUpdate_user_9, "testObject_EmailUpdate_user_9.json"), (Test.Wire.API.Golden.Generated.EmailUpdate_user.testObject_EmailUpdate_user_10, "testObject_EmailUpdate_user_10.json"), (Test.Wire.API.Golden.Generated.EmailUpdate_user.testObject_EmailUpdate_user_11, "testObject_EmailUpdate_user_11.json"), (Test.Wire.API.Golden.Generated.EmailUpdate_user.testObject_EmailUpdate_user_12, "testObject_EmailUpdate_user_12.json"), (Test.Wire.API.Golden.Generated.EmailUpdate_user.testObject_EmailUpdate_user_13, "testObject_EmailUpdate_user_13.json"), (Test.Wire.API.Golden.Generated.EmailUpdate_user.testObject_EmailUpdate_user_14, "testObject_EmailUpdate_user_14.json"), (Test.Wire.API.Golden.Generated.EmailUpdate_user.testObject_EmailUpdate_user_15, "testObject_EmailUpdate_user_15.json"), (Test.Wire.API.Golden.Generated.EmailUpdate_user.testObject_EmailUpdate_user_16, "testObject_EmailUpdate_user_16.json"), (Test.Wire.API.Golden.Generated.EmailUpdate_user.testObject_EmailUpdate_user_17, "testObject_EmailUpdate_user_17.json"), (Test.Wire.API.Golden.Generated.EmailUpdate_user.testObject_EmailUpdate_user_18, "testObject_EmailUpdate_user_18.json"), (Test.Wire.API.Golden.Generated.EmailUpdate_user.testObject_EmailUpdate_user_19, "testObject_EmailUpdate_user_19.json"), (Test.Wire.API.Golden.Generated.EmailUpdate_user.testObject_EmailUpdate_user_20, "testObject_EmailUpdate_user_20.json")],
      testGroup "Golden: PhoneUpdate_user" $
        testObjects [(Test.Wire.API.Golden.Generated.PhoneUpdate_user.testObject_PhoneUpdate_user_1, "testObject_PhoneUpdate_user_1.json"), (Test.Wire.API.Golden.Generated.PhoneUpdate_user.testObject_PhoneUpdate_user_2, "testObject_PhoneUpdate_user_2.json"), (Test.Wire.API.Golden.Generated.PhoneUpdate_user.testObject_PhoneUpdate_user_3, "testObject_PhoneUpdate_user_3.json"), (Test.Wire.API.Golden.Generated.PhoneUpdate_user.testObject_PhoneUpdate_user_4, "testObject_PhoneUpdate_user_4.json"), (Test.Wire.API.Golden.Generated.PhoneUpdate_user.testObject_PhoneUpdate_user_5, "testObject_PhoneUpdate_user_5.json"), (Test.Wire.API.Golden.Generated.PhoneUpdate_user.testObject_PhoneUpdate_user_6, "testObject_PhoneUpdate_user_6.json"), (Test.Wire.API.Golden.Generated.PhoneUpdate_user.testObject_PhoneUpdate_user_7, "testObject_PhoneUpdate_user_7.json"), (Test.Wire.API.Golden.Generated.PhoneUpdate_user.testObject_PhoneUpdate_user_8, "testObject_PhoneUpdate_user_8.json"), (Test.Wire.API.Golden.Generated.PhoneUpdate_user.testObject_PhoneUpdate_user_9, "testObject_PhoneUpdate_user_9.json"), (Test.Wire.API.Golden.Generated.PhoneUpdate_user.testObject_PhoneUpdate_user_10, "testObject_PhoneUpdate_user_10.json"), (Test.Wire.API.Golden.Generated.PhoneUpdate_user.testObject_PhoneUpdate_user_11, "testObject_PhoneUpdate_user_11.json"), (Test.Wire.API.Golden.Generated.PhoneUpdate_user.testObject_PhoneUpdate_user_12, "testObject_PhoneUpdate_user_12.json"), (Test.Wire.API.Golden.Generated.PhoneUpdate_user.testObject_PhoneUpdate_user_13, "testObject_PhoneUpdate_user_13.json"), (Test.Wire.API.Golden.Generated.PhoneUpdate_user.testObject_PhoneUpdate_user_14, "testObject_PhoneUpdate_user_14.json"), (Test.Wire.API.Golden.Generated.PhoneUpdate_user.testObject_PhoneUpdate_user_15, "testObject_PhoneUpdate_user_15.json"), (Test.Wire.API.Golden.Generated.PhoneUpdate_user.testObject_PhoneUpdate_user_16, "testObject_PhoneUpdate_user_16.json"), (Test.Wire.API.Golden.Generated.PhoneUpdate_user.testObject_PhoneUpdate_user_17, "testObject_PhoneUpdate_user_17.json"), (Test.Wire.API.Golden.Generated.PhoneUpdate_user.testObject_PhoneUpdate_user_18, "testObject_PhoneUpdate_user_18.json"), (Test.Wire.API.Golden.Generated.PhoneUpdate_user.testObject_PhoneUpdate_user_19, "testObject_PhoneUpdate_user_19.json"), (Test.Wire.API.Golden.Generated.PhoneUpdate_user.testObject_PhoneUpdate_user_20, "testObject_PhoneUpdate_user_20.json")],
      testGroup "Golden: HandleUpdate_user" $
        testObjects [(Test.Wire.API.Golden.Generated.HandleUpdate_user.testObject_HandleUpdate_user_1, "testObject_HandleUpdate_user_1.json"), (Test.Wire.API.Golden.Generated.HandleUpdate_user.testObject_HandleUpdate_user_2, "testObject_HandleUpdate_user_2.json"), (Test.Wire.API.Golden.Generated.HandleUpdate_user.testObject_HandleUpdate_user_3, "testObject_HandleUpdate_user_3.json"), (Test.Wire.API.Golden.Generated.HandleUpdate_user.testObject_HandleUpdate_user_4, "testObject_HandleUpdate_user_4.json"), (Test.Wire.API.Golden.Generated.HandleUpdate_user.testObject_HandleUpdate_user_5, "testObject_HandleUpdate_user_5.json"), (Test.Wire.API.Golden.Generated.HandleUpdate_user.testObject_HandleUpdate_user_6, "testObject_HandleUpdate_user_6.json"), (Test.Wire.API.Golden.Generated.HandleUpdate_user.testObject_HandleUpdate_user_7, "testObject_HandleUpdate_user_7.json"), (Test.Wire.API.Golden.Generated.HandleUpdate_user.testObject_HandleUpdate_user_8, "testObject_HandleUpdate_user_8.json"), (Test.Wire.API.Golden.Generated.HandleUpdate_user.testObject_HandleUpdate_user_9, "testObject_HandleUpdate_user_9.json"), (Test.Wire.API.Golden.Generated.HandleUpdate_user.testObject_HandleUpdate_user_10, "testObject_HandleUpdate_user_10.json"), (Test.Wire.API.Golden.Generated.HandleUpdate_user.testObject_HandleUpdate_user_11, "testObject_HandleUpdate_user_11.json"), (Test.Wire.API.Golden.Generated.HandleUpdate_user.testObject_HandleUpdate_user_12, "testObject_HandleUpdate_user_12.json"), (Test.Wire.API.Golden.Generated.HandleUpdate_user.testObject_HandleUpdate_user_13, "testObject_HandleUpdate_user_13.json"), (Test.Wire.API.Golden.Generated.HandleUpdate_user.testObject_HandleUpdate_user_14, "testObject_HandleUpdate_user_14.json"), (Test.Wire.API.Golden.Generated.HandleUpdate_user.testObject_HandleUpdate_user_15, "testObject_HandleUpdate_user_15.json"), (Test.Wire.API.Golden.Generated.HandleUpdate_user.testObject_HandleUpdate_user_16, "testObject_HandleUpdate_user_16.json"), (Test.Wire.API.Golden.Generated.HandleUpdate_user.testObject_HandleUpdate_user_17, "testObject_HandleUpdate_user_17.json"), (Test.Wire.API.Golden.Generated.HandleUpdate_user.testObject_HandleUpdate_user_18, "testObject_HandleUpdate_user_18.json"), (Test.Wire.API.Golden.Generated.HandleUpdate_user.testObject_HandleUpdate_user_19, "testObject_HandleUpdate_user_19.json"), (Test.Wire.API.Golden.Generated.HandleUpdate_user.testObject_HandleUpdate_user_20, "testObject_HandleUpdate_user_20.json")],
      testGroup "Golden: DeleteUser_user" $
        testObjects [(Test.Wire.API.Golden.Generated.DeleteUser_user.testObject_DeleteUser_user_1, "testObject_DeleteUser_user_1.json"), (Test.Wire.API.Golden.Generated.DeleteUser_user.testObject_DeleteUser_user_2, "testObject_DeleteUser_user_2.json"), (Test.Wire.API.Golden.Generated.DeleteUser_user.testObject_DeleteUser_user_3, "testObject_DeleteUser_user_3.json"), (Test.Wire.API.Golden.Generated.DeleteUser_user.testObject_DeleteUser_user_4, "testObject_DeleteUser_user_4.json"), (Test.Wire.API.Golden.Generated.DeleteUser_user.testObject_DeleteUser_user_5, "testObject_DeleteUser_user_5.json"), (Test.Wire.API.Golden.Generated.DeleteUser_user.testObject_DeleteUser_user_6, "testObject_DeleteUser_user_6.json"), (Test.Wire.API.Golden.Generated.DeleteUser_user.testObject_DeleteUser_user_7, "testObject_DeleteUser_user_7.json"), (Test.Wire.API.Golden.Generated.DeleteUser_user.testObject_DeleteUser_user_8, "testObject_DeleteUser_user_8.json"), (Test.Wire.API.Golden.Generated.DeleteUser_user.testObject_DeleteUser_user_9, "testObject_DeleteUser_user_9.json"), (Test.Wire.API.Golden.Generated.DeleteUser_user.testObject_DeleteUser_user_10, "testObject_DeleteUser_user_10.json"), (Test.Wire.API.Golden.Generated.DeleteUser_user.testObject_DeleteUser_user_11, "testObject_DeleteUser_user_11.json"), (Test.Wire.API.Golden.Generated.DeleteUser_user.testObject_DeleteUser_user_12, "testObject_DeleteUser_user_12.json"), (Test.Wire.API.Golden.Generated.DeleteUser_user.testObject_DeleteUser_user_13, "testObject_DeleteUser_user_13.json"), (Test.Wire.API.Golden.Generated.DeleteUser_user.testObject_DeleteUser_user_14, "testObject_DeleteUser_user_14.json"), (Test.Wire.API.Golden.Generated.DeleteUser_user.testObject_DeleteUser_user_15, "testObject_DeleteUser_user_15.json"), (Test.Wire.API.Golden.Generated.DeleteUser_user.testObject_DeleteUser_user_16, "testObject_DeleteUser_user_16.json"), (Test.Wire.API.Golden.Generated.DeleteUser_user.testObject_DeleteUser_user_17, "testObject_DeleteUser_user_17.json"), (Test.Wire.API.Golden.Generated.DeleteUser_user.testObject_DeleteUser_user_18, "testObject_DeleteUser_user_18.json"), (Test.Wire.API.Golden.Generated.DeleteUser_user.testObject_DeleteUser_user_19, "testObject_DeleteUser_user_19.json"), (Test.Wire.API.Golden.Generated.DeleteUser_user.testObject_DeleteUser_user_20, "testObject_DeleteUser_user_20.json")],
      testGroup "Golden: VerifyDeleteUser_user" $
        testObjects [(Test.Wire.API.Golden.Generated.VerifyDeleteUser_user.testObject_VerifyDeleteUser_user_1, "testObject_VerifyDeleteUser_user_1.json"), (Test.Wire.API.Golden.Generated.VerifyDeleteUser_user.testObject_VerifyDeleteUser_user_2, "testObject_VerifyDeleteUser_user_2.json"), (Test.Wire.API.Golden.Generated.VerifyDeleteUser_user.testObject_VerifyDeleteUser_user_3, "testObject_VerifyDeleteUser_user_3.json"), (Test.Wire.API.Golden.Generated.VerifyDeleteUser_user.testObject_VerifyDeleteUser_user_4, "testObject_VerifyDeleteUser_user_4.json"), (Test.Wire.API.Golden.Generated.VerifyDeleteUser_user.testObject_VerifyDeleteUser_user_5, "testObject_VerifyDeleteUser_user_5.json"), (Test.Wire.API.Golden.Generated.VerifyDeleteUser_user.testObject_VerifyDeleteUser_user_6, "testObject_VerifyDeleteUser_user_6.json"), (Test.Wire.API.Golden.Generated.VerifyDeleteUser_user.testObject_VerifyDeleteUser_user_7, "testObject_VerifyDeleteUser_user_7.json"), (Test.Wire.API.Golden.Generated.VerifyDeleteUser_user.testObject_VerifyDeleteUser_user_8, "testObject_VerifyDeleteUser_user_8.json"), (Test.Wire.API.Golden.Generated.VerifyDeleteUser_user.testObject_VerifyDeleteUser_user_9, "testObject_VerifyDeleteUser_user_9.json"), (Test.Wire.API.Golden.Generated.VerifyDeleteUser_user.testObject_VerifyDeleteUser_user_10, "testObject_VerifyDeleteUser_user_10.json"), (Test.Wire.API.Golden.Generated.VerifyDeleteUser_user.testObject_VerifyDeleteUser_user_11, "testObject_VerifyDeleteUser_user_11.json"), (Test.Wire.API.Golden.Generated.VerifyDeleteUser_user.testObject_VerifyDeleteUser_user_12, "testObject_VerifyDeleteUser_user_12.json"), (Test.Wire.API.Golden.Generated.VerifyDeleteUser_user.testObject_VerifyDeleteUser_user_13, "testObject_VerifyDeleteUser_user_13.json"), (Test.Wire.API.Golden.Generated.VerifyDeleteUser_user.testObject_VerifyDeleteUser_user_14, "testObject_VerifyDeleteUser_user_14.json"), (Test.Wire.API.Golden.Generated.VerifyDeleteUser_user.testObject_VerifyDeleteUser_user_15, "testObject_VerifyDeleteUser_user_15.json"), (Test.Wire.API.Golden.Generated.VerifyDeleteUser_user.testObject_VerifyDeleteUser_user_16, "testObject_VerifyDeleteUser_user_16.json"), (Test.Wire.API.Golden.Generated.VerifyDeleteUser_user.testObject_VerifyDeleteUser_user_17, "testObject_VerifyDeleteUser_user_17.json"), (Test.Wire.API.Golden.Generated.VerifyDeleteUser_user.testObject_VerifyDeleteUser_user_18, "testObject_VerifyDeleteUser_user_18.json"), (Test.Wire.API.Golden.Generated.VerifyDeleteUser_user.testObject_VerifyDeleteUser_user_19, "testObject_VerifyDeleteUser_user_19.json"), (Test.Wire.API.Golden.Generated.VerifyDeleteUser_user.testObject_VerifyDeleteUser_user_20, "testObject_VerifyDeleteUser_user_20.json")],
      testGroup "Golden: DeletionCodeTimeout_user" $
        testObjects [(Test.Wire.API.Golden.Generated.DeletionCodeTimeout_user.testObject_DeletionCodeTimeout_user_1, "testObject_DeletionCodeTimeout_user_1.json"), (Test.Wire.API.Golden.Generated.DeletionCodeTimeout_user.testObject_DeletionCodeTimeout_user_2, "testObject_DeletionCodeTimeout_user_2.json"), (Test.Wire.API.Golden.Generated.DeletionCodeTimeout_user.testObject_DeletionCodeTimeout_user_3, "testObject_DeletionCodeTimeout_user_3.json"), (Test.Wire.API.Golden.Generated.DeletionCodeTimeout_user.testObject_DeletionCodeTimeout_user_4, "testObject_DeletionCodeTimeout_user_4.json"), (Test.Wire.API.Golden.Generated.DeletionCodeTimeout_user.testObject_DeletionCodeTimeout_user_5, "testObject_DeletionCodeTimeout_user_5.json"), (Test.Wire.API.Golden.Generated.DeletionCodeTimeout_user.testObject_DeletionCodeTimeout_user_6, "testObject_DeletionCodeTimeout_user_6.json"), (Test.Wire.API.Golden.Generated.DeletionCodeTimeout_user.testObject_DeletionCodeTimeout_user_7, "testObject_DeletionCodeTimeout_user_7.json"), (Test.Wire.API.Golden.Generated.DeletionCodeTimeout_user.testObject_DeletionCodeTimeout_user_8, "testObject_DeletionCodeTimeout_user_8.json"), (Test.Wire.API.Golden.Generated.DeletionCodeTimeout_user.testObject_DeletionCodeTimeout_user_9, "testObject_DeletionCodeTimeout_user_9.json"), (Test.Wire.API.Golden.Generated.DeletionCodeTimeout_user.testObject_DeletionCodeTimeout_user_10, "testObject_DeletionCodeTimeout_user_10.json"), (Test.Wire.API.Golden.Generated.DeletionCodeTimeout_user.testObject_DeletionCodeTimeout_user_11, "testObject_DeletionCodeTimeout_user_11.json"), (Test.Wire.API.Golden.Generated.DeletionCodeTimeout_user.testObject_DeletionCodeTimeout_user_12, "testObject_DeletionCodeTimeout_user_12.json"), (Test.Wire.API.Golden.Generated.DeletionCodeTimeout_user.testObject_DeletionCodeTimeout_user_13, "testObject_DeletionCodeTimeout_user_13.json"), (Test.Wire.API.Golden.Generated.DeletionCodeTimeout_user.testObject_DeletionCodeTimeout_user_14, "testObject_DeletionCodeTimeout_user_14.json"), (Test.Wire.API.Golden.Generated.DeletionCodeTimeout_user.testObject_DeletionCodeTimeout_user_15, "testObject_DeletionCodeTimeout_user_15.json"), (Test.Wire.API.Golden.Generated.DeletionCodeTimeout_user.testObject_DeletionCodeTimeout_user_16, "testObject_DeletionCodeTimeout_user_16.json"), (Test.Wire.API.Golden.Generated.DeletionCodeTimeout_user.testObject_DeletionCodeTimeout_user_17, "testObject_DeletionCodeTimeout_user_17.json"), (Test.Wire.API.Golden.Generated.DeletionCodeTimeout_user.testObject_DeletionCodeTimeout_user_18, "testObject_DeletionCodeTimeout_user_18.json"), (Test.Wire.API.Golden.Generated.DeletionCodeTimeout_user.testObject_DeletionCodeTimeout_user_19, "testObject_DeletionCodeTimeout_user_19.json"), (Test.Wire.API.Golden.Generated.DeletionCodeTimeout_user.testObject_DeletionCodeTimeout_user_20, "testObject_DeletionCodeTimeout_user_20.json")],
      testGroup "Golden: ActivationKey_user" $
        testObjects [(Test.Wire.API.Golden.Generated.ActivationKey_user.testObject_ActivationKey_user_1, "testObject_ActivationKey_user_1.json"), (Test.Wire.API.Golden.Generated.ActivationKey_user.testObject_ActivationKey_user_2, "testObject_ActivationKey_user_2.json"), (Test.Wire.API.Golden.Generated.ActivationKey_user.testObject_ActivationKey_user_3, "testObject_ActivationKey_user_3.json"), (Test.Wire.API.Golden.Generated.ActivationKey_user.testObject_ActivationKey_user_4, "testObject_ActivationKey_user_4.json"), (Test.Wire.API.Golden.Generated.ActivationKey_user.testObject_ActivationKey_user_5, "testObject_ActivationKey_user_5.json"), (Test.Wire.API.Golden.Generated.ActivationKey_user.testObject_ActivationKey_user_6, "testObject_ActivationKey_user_6.json"), (Test.Wire.API.Golden.Generated.ActivationKey_user.testObject_ActivationKey_user_7, "testObject_ActivationKey_user_7.json"), (Test.Wire.API.Golden.Generated.ActivationKey_user.testObject_ActivationKey_user_8, "testObject_ActivationKey_user_8.json"), (Test.Wire.API.Golden.Generated.ActivationKey_user.testObject_ActivationKey_user_9, "testObject_ActivationKey_user_9.json"), (Test.Wire.API.Golden.Generated.ActivationKey_user.testObject_ActivationKey_user_10, "testObject_ActivationKey_user_10.json"), (Test.Wire.API.Golden.Generated.ActivationKey_user.testObject_ActivationKey_user_11, "testObject_ActivationKey_user_11.json"), (Test.Wire.API.Golden.Generated.ActivationKey_user.testObject_ActivationKey_user_12, "testObject_ActivationKey_user_12.json"), (Test.Wire.API.Golden.Generated.ActivationKey_user.testObject_ActivationKey_user_13, "testObject_ActivationKey_user_13.json"), (Test.Wire.API.Golden.Generated.ActivationKey_user.testObject_ActivationKey_user_14, "testObject_ActivationKey_user_14.json"), (Test.Wire.API.Golden.Generated.ActivationKey_user.testObject_ActivationKey_user_15, "testObject_ActivationKey_user_15.json"), (Test.Wire.API.Golden.Generated.ActivationKey_user.testObject_ActivationKey_user_16, "testObject_ActivationKey_user_16.json"), (Test.Wire.API.Golden.Generated.ActivationKey_user.testObject_ActivationKey_user_17, "testObject_ActivationKey_user_17.json"), (Test.Wire.API.Golden.Generated.ActivationKey_user.testObject_ActivationKey_user_18, "testObject_ActivationKey_user_18.json"), (Test.Wire.API.Golden.Generated.ActivationKey_user.testObject_ActivationKey_user_19, "testObject_ActivationKey_user_19.json"), (Test.Wire.API.Golden.Generated.ActivationKey_user.testObject_ActivationKey_user_20, "testObject_ActivationKey_user_20.json")],
      testGroup "Golden: ActivationCode_user" $
        testObjects [(Test.Wire.API.Golden.Generated.ActivationCode_user.testObject_ActivationCode_user_1, "testObject_ActivationCode_user_1.json"), (Test.Wire.API.Golden.Generated.ActivationCode_user.testObject_ActivationCode_user_2, "testObject_ActivationCode_user_2.json"), (Test.Wire.API.Golden.Generated.ActivationCode_user.testObject_ActivationCode_user_3, "testObject_ActivationCode_user_3.json"), (Test.Wire.API.Golden.Generated.ActivationCode_user.testObject_ActivationCode_user_4, "testObject_ActivationCode_user_4.json"), (Test.Wire.API.Golden.Generated.ActivationCode_user.testObject_ActivationCode_user_5, "testObject_ActivationCode_user_5.json"), (Test.Wire.API.Golden.Generated.ActivationCode_user.testObject_ActivationCode_user_6, "testObject_ActivationCode_user_6.json"), (Test.Wire.API.Golden.Generated.ActivationCode_user.testObject_ActivationCode_user_7, "testObject_ActivationCode_user_7.json"), (Test.Wire.API.Golden.Generated.ActivationCode_user.testObject_ActivationCode_user_8, "testObject_ActivationCode_user_8.json"), (Test.Wire.API.Golden.Generated.ActivationCode_user.testObject_ActivationCode_user_9, "testObject_ActivationCode_user_9.json"), (Test.Wire.API.Golden.Generated.ActivationCode_user.testObject_ActivationCode_user_10, "testObject_ActivationCode_user_10.json"), (Test.Wire.API.Golden.Generated.ActivationCode_user.testObject_ActivationCode_user_11, "testObject_ActivationCode_user_11.json"), (Test.Wire.API.Golden.Generated.ActivationCode_user.testObject_ActivationCode_user_12, "testObject_ActivationCode_user_12.json"), (Test.Wire.API.Golden.Generated.ActivationCode_user.testObject_ActivationCode_user_13, "testObject_ActivationCode_user_13.json"), (Test.Wire.API.Golden.Generated.ActivationCode_user.testObject_ActivationCode_user_14, "testObject_ActivationCode_user_14.json"), (Test.Wire.API.Golden.Generated.ActivationCode_user.testObject_ActivationCode_user_15, "testObject_ActivationCode_user_15.json"), (Test.Wire.API.Golden.Generated.ActivationCode_user.testObject_ActivationCode_user_16, "testObject_ActivationCode_user_16.json"), (Test.Wire.API.Golden.Generated.ActivationCode_user.testObject_ActivationCode_user_17, "testObject_ActivationCode_user_17.json"), (Test.Wire.API.Golden.Generated.ActivationCode_user.testObject_ActivationCode_user_18, "testObject_ActivationCode_user_18.json"), (Test.Wire.API.Golden.Generated.ActivationCode_user.testObject_ActivationCode_user_19, "testObject_ActivationCode_user_19.json"), (Test.Wire.API.Golden.Generated.ActivationCode_user.testObject_ActivationCode_user_20, "testObject_ActivationCode_user_20.json")],
      testGroup "Golden: ActivationResponse_user" $
        testObjects [(Test.Wire.API.Golden.Generated.ActivationResponse_user.testObject_ActivationResponse_user_1, "testObject_ActivationResponse_user_1.json"), (Test.Wire.API.Golden.Generated.ActivationResponse_user.testObject_ActivationResponse_user_2, "testObject_ActivationResponse_user_2.json"), (Test.Wire.API.Golden.Generated.ActivationResponse_user.testObject_ActivationResponse_user_3, "testObject_ActivationResponse_user_3.json"), (Test.Wire.API.Golden.Generated.ActivationResponse_user.testObject_ActivationResponse_user_4, "testObject_ActivationResponse_user_4.json"), (Test.Wire.API.Golden.Generated.ActivationResponse_user.testObject_ActivationResponse_user_5, "testObject_ActivationResponse_user_5.json"), (Test.Wire.API.Golden.Generated.ActivationResponse_user.testObject_ActivationResponse_user_6, "testObject_ActivationResponse_user_6.json"), (Test.Wire.API.Golden.Generated.ActivationResponse_user.testObject_ActivationResponse_user_7, "testObject_ActivationResponse_user_7.json"), (Test.Wire.API.Golden.Generated.ActivationResponse_user.testObject_ActivationResponse_user_8, "testObject_ActivationResponse_user_8.json"), (Test.Wire.API.Golden.Generated.ActivationResponse_user.testObject_ActivationResponse_user_9, "testObject_ActivationResponse_user_9.json"), (Test.Wire.API.Golden.Generated.ActivationResponse_user.testObject_ActivationResponse_user_10, "testObject_ActivationResponse_user_10.json")],
      testGroup "Golden: LoginCode_user" $
        testObjects [(Test.Wire.API.Golden.Generated.LoginCode_user.testObject_LoginCode_user_1, "testObject_LoginCode_user_1.json"), (Test.Wire.API.Golden.Generated.LoginCode_user.testObject_LoginCode_user_2, "testObject_LoginCode_user_2.json"), (Test.Wire.API.Golden.Generated.LoginCode_user.testObject_LoginCode_user_3, "testObject_LoginCode_user_3.json"), (Test.Wire.API.Golden.Generated.LoginCode_user.testObject_LoginCode_user_4, "testObject_LoginCode_user_4.json"), (Test.Wire.API.Golden.Generated.LoginCode_user.testObject_LoginCode_user_5, "testObject_LoginCode_user_5.json"), (Test.Wire.API.Golden.Generated.LoginCode_user.testObject_LoginCode_user_6, "testObject_LoginCode_user_6.json"), (Test.Wire.API.Golden.Generated.LoginCode_user.testObject_LoginCode_user_7, "testObject_LoginCode_user_7.json"), (Test.Wire.API.Golden.Generated.LoginCode_user.testObject_LoginCode_user_8, "testObject_LoginCode_user_8.json"), (Test.Wire.API.Golden.Generated.LoginCode_user.testObject_LoginCode_user_9, "testObject_LoginCode_user_9.json"), (Test.Wire.API.Golden.Generated.LoginCode_user.testObject_LoginCode_user_10, "testObject_LoginCode_user_10.json"), (Test.Wire.API.Golden.Generated.LoginCode_user.testObject_LoginCode_user_11, "testObject_LoginCode_user_11.json"), (Test.Wire.API.Golden.Generated.LoginCode_user.testObject_LoginCode_user_12, "testObject_LoginCode_user_12.json"), (Test.Wire.API.Golden.Generated.LoginCode_user.testObject_LoginCode_user_13, "testObject_LoginCode_user_13.json"), (Test.Wire.API.Golden.Generated.LoginCode_user.testObject_LoginCode_user_14, "testObject_LoginCode_user_14.json"), (Test.Wire.API.Golden.Generated.LoginCode_user.testObject_LoginCode_user_15, "testObject_LoginCode_user_15.json"), (Test.Wire.API.Golden.Generated.LoginCode_user.testObject_LoginCode_user_16, "testObject_LoginCode_user_16.json"), (Test.Wire.API.Golden.Generated.LoginCode_user.testObject_LoginCode_user_17, "testObject_LoginCode_user_17.json"), (Test.Wire.API.Golden.Generated.LoginCode_user.testObject_LoginCode_user_18, "testObject_LoginCode_user_18.json"), (Test.Wire.API.Golden.Generated.LoginCode_user.testObject_LoginCode_user_19, "testObject_LoginCode_user_19.json"), (Test.Wire.API.Golden.Generated.LoginCode_user.testObject_LoginCode_user_20, "testObject_LoginCode_user_20.json")],
      testGroup "Golden: PendingLoginCode_user" $
        testObjects [(Test.Wire.API.Golden.Generated.PendingLoginCode_user.testObject_PendingLoginCode_user_1, "testObject_PendingLoginCode_user_1.json"), (Test.Wire.API.Golden.Generated.PendingLoginCode_user.testObject_PendingLoginCode_user_2, "testObject_PendingLoginCode_user_2.json"), (Test.Wire.API.Golden.Generated.PendingLoginCode_user.testObject_PendingLoginCode_user_3, "testObject_PendingLoginCode_user_3.json"), (Test.Wire.API.Golden.Generated.PendingLoginCode_user.testObject_PendingLoginCode_user_4, "testObject_PendingLoginCode_user_4.json"), (Test.Wire.API.Golden.Generated.PendingLoginCode_user.testObject_PendingLoginCode_user_5, "testObject_PendingLoginCode_user_5.json"), (Test.Wire.API.Golden.Generated.PendingLoginCode_user.testObject_PendingLoginCode_user_6, "testObject_PendingLoginCode_user_6.json"), (Test.Wire.API.Golden.Generated.PendingLoginCode_user.testObject_PendingLoginCode_user_7, "testObject_PendingLoginCode_user_7.json"), (Test.Wire.API.Golden.Generated.PendingLoginCode_user.testObject_PendingLoginCode_user_8, "testObject_PendingLoginCode_user_8.json"), (Test.Wire.API.Golden.Generated.PendingLoginCode_user.testObject_PendingLoginCode_user_9, "testObject_PendingLoginCode_user_9.json"), (Test.Wire.API.Golden.Generated.PendingLoginCode_user.testObject_PendingLoginCode_user_10, "testObject_PendingLoginCode_user_10.json"), (Test.Wire.API.Golden.Generated.PendingLoginCode_user.testObject_PendingLoginCode_user_11, "testObject_PendingLoginCode_user_11.json"), (Test.Wire.API.Golden.Generated.PendingLoginCode_user.testObject_PendingLoginCode_user_12, "testObject_PendingLoginCode_user_12.json"), (Test.Wire.API.Golden.Generated.PendingLoginCode_user.testObject_PendingLoginCode_user_13, "testObject_PendingLoginCode_user_13.json"), (Test.Wire.API.Golden.Generated.PendingLoginCode_user.testObject_PendingLoginCode_user_14, "testObject_PendingLoginCode_user_14.json"), (Test.Wire.API.Golden.Generated.PendingLoginCode_user.testObject_PendingLoginCode_user_15, "testObject_PendingLoginCode_user_15.json"), (Test.Wire.API.Golden.Generated.PendingLoginCode_user.testObject_PendingLoginCode_user_16, "testObject_PendingLoginCode_user_16.json"), (Test.Wire.API.Golden.Generated.PendingLoginCode_user.testObject_PendingLoginCode_user_17, "testObject_PendingLoginCode_user_17.json"), (Test.Wire.API.Golden.Generated.PendingLoginCode_user.testObject_PendingLoginCode_user_18, "testObject_PendingLoginCode_user_18.json"), (Test.Wire.API.Golden.Generated.PendingLoginCode_user.testObject_PendingLoginCode_user_19, "testObject_PendingLoginCode_user_19.json"), (Test.Wire.API.Golden.Generated.PendingLoginCode_user.testObject_PendingLoginCode_user_20, "testObject_PendingLoginCode_user_20.json")],
      testGroup "Golden: SendLoginCode_user" $
        testObjects [(Test.Wire.API.Golden.Generated.SendLoginCode_user.testObject_SendLoginCode_user_1, "testObject_SendLoginCode_user_1.json"), (Test.Wire.API.Golden.Generated.SendLoginCode_user.testObject_SendLoginCode_user_2, "testObject_SendLoginCode_user_2.json"), (Test.Wire.API.Golden.Generated.SendLoginCode_user.testObject_SendLoginCode_user_3, "testObject_SendLoginCode_user_3.json"), (Test.Wire.API.Golden.Generated.SendLoginCode_user.testObject_SendLoginCode_user_4, "testObject_SendLoginCode_user_4.json"), (Test.Wire.API.Golden.Generated.SendLoginCode_user.testObject_SendLoginCode_user_5, "testObject_SendLoginCode_user_5.json"), (Test.Wire.API.Golden.Generated.SendLoginCode_user.testObject_SendLoginCode_user_6, "testObject_SendLoginCode_user_6.json"), (Test.Wire.API.Golden.Generated.SendLoginCode_user.testObject_SendLoginCode_user_7, "testObject_SendLoginCode_user_7.json"), (Test.Wire.API.Golden.Generated.SendLoginCode_user.testObject_SendLoginCode_user_8, "testObject_SendLoginCode_user_8.json"), (Test.Wire.API.Golden.Generated.SendLoginCode_user.testObject_SendLoginCode_user_9, "testObject_SendLoginCode_user_9.json"), (Test.Wire.API.Golden.Generated.SendLoginCode_user.testObject_SendLoginCode_user_10, "testObject_SendLoginCode_user_10.json"), (Test.Wire.API.Golden.Generated.SendLoginCode_user.testObject_SendLoginCode_user_11, "testObject_SendLoginCode_user_11.json"), (Test.Wire.API.Golden.Generated.SendLoginCode_user.testObject_SendLoginCode_user_12, "testObject_SendLoginCode_user_12.json"), (Test.Wire.API.Golden.Generated.SendLoginCode_user.testObject_SendLoginCode_user_13, "testObject_SendLoginCode_user_13.json"), (Test.Wire.API.Golden.Generated.SendLoginCode_user.testObject_SendLoginCode_user_14, "testObject_SendLoginCode_user_14.json"), (Test.Wire.API.Golden.Generated.SendLoginCode_user.testObject_SendLoginCode_user_15, "testObject_SendLoginCode_user_15.json"), (Test.Wire.API.Golden.Generated.SendLoginCode_user.testObject_SendLoginCode_user_16, "testObject_SendLoginCode_user_16.json"), (Test.Wire.API.Golden.Generated.SendLoginCode_user.testObject_SendLoginCode_user_17, "testObject_SendLoginCode_user_17.json"), (Test.Wire.API.Golden.Generated.SendLoginCode_user.testObject_SendLoginCode_user_18, "testObject_SendLoginCode_user_18.json"), (Test.Wire.API.Golden.Generated.SendLoginCode_user.testObject_SendLoginCode_user_19, "testObject_SendLoginCode_user_19.json"), (Test.Wire.API.Golden.Generated.SendLoginCode_user.testObject_SendLoginCode_user_20, "testObject_SendLoginCode_user_20.json")],
      testGroup "Golden: LoginCodeTimeout_user" $
        testObjects [(Test.Wire.API.Golden.Generated.LoginCodeTimeout_user.testObject_LoginCodeTimeout_user_1, "testObject_LoginCodeTimeout_user_1.json"), (Test.Wire.API.Golden.Generated.LoginCodeTimeout_user.testObject_LoginCodeTimeout_user_2, "testObject_LoginCodeTimeout_user_2.json"), (Test.Wire.API.Golden.Generated.LoginCodeTimeout_user.testObject_LoginCodeTimeout_user_3, "testObject_LoginCodeTimeout_user_3.json"), (Test.Wire.API.Golden.Generated.LoginCodeTimeout_user.testObject_LoginCodeTimeout_user_4, "testObject_LoginCodeTimeout_user_4.json"), (Test.Wire.API.Golden.Generated.LoginCodeTimeout_user.testObject_LoginCodeTimeout_user_5, "testObject_LoginCodeTimeout_user_5.json"), (Test.Wire.API.Golden.Generated.LoginCodeTimeout_user.testObject_LoginCodeTimeout_user_6, "testObject_LoginCodeTimeout_user_6.json"), (Test.Wire.API.Golden.Generated.LoginCodeTimeout_user.testObject_LoginCodeTimeout_user_7, "testObject_LoginCodeTimeout_user_7.json"), (Test.Wire.API.Golden.Generated.LoginCodeTimeout_user.testObject_LoginCodeTimeout_user_8, "testObject_LoginCodeTimeout_user_8.json"), (Test.Wire.API.Golden.Generated.LoginCodeTimeout_user.testObject_LoginCodeTimeout_user_9, "testObject_LoginCodeTimeout_user_9.json"), (Test.Wire.API.Golden.Generated.LoginCodeTimeout_user.testObject_LoginCodeTimeout_user_10, "testObject_LoginCodeTimeout_user_10.json"), (Test.Wire.API.Golden.Generated.LoginCodeTimeout_user.testObject_LoginCodeTimeout_user_11, "testObject_LoginCodeTimeout_user_11.json"), (Test.Wire.API.Golden.Generated.LoginCodeTimeout_user.testObject_LoginCodeTimeout_user_12, "testObject_LoginCodeTimeout_user_12.json"), (Test.Wire.API.Golden.Generated.LoginCodeTimeout_user.testObject_LoginCodeTimeout_user_13, "testObject_LoginCodeTimeout_user_13.json"), (Test.Wire.API.Golden.Generated.LoginCodeTimeout_user.testObject_LoginCodeTimeout_user_14, "testObject_LoginCodeTimeout_user_14.json"), (Test.Wire.API.Golden.Generated.LoginCodeTimeout_user.testObject_LoginCodeTimeout_user_15, "testObject_LoginCodeTimeout_user_15.json"), (Test.Wire.API.Golden.Generated.LoginCodeTimeout_user.testObject_LoginCodeTimeout_user_16, "testObject_LoginCodeTimeout_user_16.json"), (Test.Wire.API.Golden.Generated.LoginCodeTimeout_user.testObject_LoginCodeTimeout_user_17, "testObject_LoginCodeTimeout_user_17.json"), (Test.Wire.API.Golden.Generated.LoginCodeTimeout_user.testObject_LoginCodeTimeout_user_18, "testObject_LoginCodeTimeout_user_18.json"), (Test.Wire.API.Golden.Generated.LoginCodeTimeout_user.testObject_LoginCodeTimeout_user_19, "testObject_LoginCodeTimeout_user_19.json"), (Test.Wire.API.Golden.Generated.LoginCodeTimeout_user.testObject_LoginCodeTimeout_user_20, "testObject_LoginCodeTimeout_user_20.json")],
      testGroup "Golden: CookieLabel_user" $
        testObjects [(Test.Wire.API.Golden.Generated.CookieLabel_user.testObject_CookieLabel_user_1, "testObject_CookieLabel_user_1.json"), (Test.Wire.API.Golden.Generated.CookieLabel_user.testObject_CookieLabel_user_2, "testObject_CookieLabel_user_2.json"), (Test.Wire.API.Golden.Generated.CookieLabel_user.testObject_CookieLabel_user_3, "testObject_CookieLabel_user_3.json"), (Test.Wire.API.Golden.Generated.CookieLabel_user.testObject_CookieLabel_user_4, "testObject_CookieLabel_user_4.json"), (Test.Wire.API.Golden.Generated.CookieLabel_user.testObject_CookieLabel_user_5, "testObject_CookieLabel_user_5.json"), (Test.Wire.API.Golden.Generated.CookieLabel_user.testObject_CookieLabel_user_6, "testObject_CookieLabel_user_6.json"), (Test.Wire.API.Golden.Generated.CookieLabel_user.testObject_CookieLabel_user_7, "testObject_CookieLabel_user_7.json"), (Test.Wire.API.Golden.Generated.CookieLabel_user.testObject_CookieLabel_user_8, "testObject_CookieLabel_user_8.json"), (Test.Wire.API.Golden.Generated.CookieLabel_user.testObject_CookieLabel_user_9, "testObject_CookieLabel_user_9.json"), (Test.Wire.API.Golden.Generated.CookieLabel_user.testObject_CookieLabel_user_10, "testObject_CookieLabel_user_10.json"), (Test.Wire.API.Golden.Generated.CookieLabel_user.testObject_CookieLabel_user_11, "testObject_CookieLabel_user_11.json"), (Test.Wire.API.Golden.Generated.CookieLabel_user.testObject_CookieLabel_user_12, "testObject_CookieLabel_user_12.json"), (Test.Wire.API.Golden.Generated.CookieLabel_user.testObject_CookieLabel_user_13, "testObject_CookieLabel_user_13.json"), (Test.Wire.API.Golden.Generated.CookieLabel_user.testObject_CookieLabel_user_14, "testObject_CookieLabel_user_14.json"), (Test.Wire.API.Golden.Generated.CookieLabel_user.testObject_CookieLabel_user_15, "testObject_CookieLabel_user_15.json"), (Test.Wire.API.Golden.Generated.CookieLabel_user.testObject_CookieLabel_user_16, "testObject_CookieLabel_user_16.json"), (Test.Wire.API.Golden.Generated.CookieLabel_user.testObject_CookieLabel_user_17, "testObject_CookieLabel_user_17.json"), (Test.Wire.API.Golden.Generated.CookieLabel_user.testObject_CookieLabel_user_18, "testObject_CookieLabel_user_18.json"), (Test.Wire.API.Golden.Generated.CookieLabel_user.testObject_CookieLabel_user_19, "testObject_CookieLabel_user_19.json"), (Test.Wire.API.Golden.Generated.CookieLabel_user.testObject_CookieLabel_user_20, "testObject_CookieLabel_user_20.json")],
      testGroup "Golden: CookieId_user" $
        testObjects [(Test.Wire.API.Golden.Generated.CookieId_user.testObject_CookieId_user_1, "testObject_CookieId_user_1.json"), (Test.Wire.API.Golden.Generated.CookieId_user.testObject_CookieId_user_2, "testObject_CookieId_user_2.json"), (Test.Wire.API.Golden.Generated.CookieId_user.testObject_CookieId_user_3, "testObject_CookieId_user_3.json"), (Test.Wire.API.Golden.Generated.CookieId_user.testObject_CookieId_user_4, "testObject_CookieId_user_4.json"), (Test.Wire.API.Golden.Generated.CookieId_user.testObject_CookieId_user_5, "testObject_CookieId_user_5.json"), (Test.Wire.API.Golden.Generated.CookieId_user.testObject_CookieId_user_6, "testObject_CookieId_user_6.json"), (Test.Wire.API.Golden.Generated.CookieId_user.testObject_CookieId_user_7, "testObject_CookieId_user_7.json"), (Test.Wire.API.Golden.Generated.CookieId_user.testObject_CookieId_user_8, "testObject_CookieId_user_8.json"), (Test.Wire.API.Golden.Generated.CookieId_user.testObject_CookieId_user_9, "testObject_CookieId_user_9.json"), (Test.Wire.API.Golden.Generated.CookieId_user.testObject_CookieId_user_10, "testObject_CookieId_user_10.json"), (Test.Wire.API.Golden.Generated.CookieId_user.testObject_CookieId_user_11, "testObject_CookieId_user_11.json"), (Test.Wire.API.Golden.Generated.CookieId_user.testObject_CookieId_user_12, "testObject_CookieId_user_12.json"), (Test.Wire.API.Golden.Generated.CookieId_user.testObject_CookieId_user_13, "testObject_CookieId_user_13.json"), (Test.Wire.API.Golden.Generated.CookieId_user.testObject_CookieId_user_14, "testObject_CookieId_user_14.json"), (Test.Wire.API.Golden.Generated.CookieId_user.testObject_CookieId_user_15, "testObject_CookieId_user_15.json"), (Test.Wire.API.Golden.Generated.CookieId_user.testObject_CookieId_user_16, "testObject_CookieId_user_16.json"), (Test.Wire.API.Golden.Generated.CookieId_user.testObject_CookieId_user_17, "testObject_CookieId_user_17.json"), (Test.Wire.API.Golden.Generated.CookieId_user.testObject_CookieId_user_18, "testObject_CookieId_user_18.json"), (Test.Wire.API.Golden.Generated.CookieId_user.testObject_CookieId_user_19, "testObject_CookieId_user_19.json"), (Test.Wire.API.Golden.Generated.CookieId_user.testObject_CookieId_user_20, "testObject_CookieId_user_20.json")],
      testGroup "Golden: CookieType_user" $
        testObjects [(Test.Wire.API.Golden.Generated.CookieType_user.testObject_CookieType_user_1, "testObject_CookieType_user_1.json"), (Test.Wire.API.Golden.Generated.CookieType_user.testObject_CookieType_user_2, "testObject_CookieType_user_2.json"), (Test.Wire.API.Golden.Generated.CookieType_user.testObject_CookieType_user_3, "testObject_CookieType_user_3.json"), (Test.Wire.API.Golden.Generated.CookieType_user.testObject_CookieType_user_4, "testObject_CookieType_user_4.json"), (Test.Wire.API.Golden.Generated.CookieType_user.testObject_CookieType_user_5, "testObject_CookieType_user_5.json"), (Test.Wire.API.Golden.Generated.CookieType_user.testObject_CookieType_user_6, "testObject_CookieType_user_6.json"), (Test.Wire.API.Golden.Generated.CookieType_user.testObject_CookieType_user_7, "testObject_CookieType_user_7.json"), (Test.Wire.API.Golden.Generated.CookieType_user.testObject_CookieType_user_8, "testObject_CookieType_user_8.json"), (Test.Wire.API.Golden.Generated.CookieType_user.testObject_CookieType_user_9, "testObject_CookieType_user_9.json"), (Test.Wire.API.Golden.Generated.CookieType_user.testObject_CookieType_user_10, "testObject_CookieType_user_10.json"), (Test.Wire.API.Golden.Generated.CookieType_user.testObject_CookieType_user_11, "testObject_CookieType_user_11.json"), (Test.Wire.API.Golden.Generated.CookieType_user.testObject_CookieType_user_12, "testObject_CookieType_user_12.json"), (Test.Wire.API.Golden.Generated.CookieType_user.testObject_CookieType_user_13, "testObject_CookieType_user_13.json"), (Test.Wire.API.Golden.Generated.CookieType_user.testObject_CookieType_user_14, "testObject_CookieType_user_14.json"), (Test.Wire.API.Golden.Generated.CookieType_user.testObject_CookieType_user_15, "testObject_CookieType_user_15.json"), (Test.Wire.API.Golden.Generated.CookieType_user.testObject_CookieType_user_16, "testObject_CookieType_user_16.json"), (Test.Wire.API.Golden.Generated.CookieType_user.testObject_CookieType_user_17, "testObject_CookieType_user_17.json"), (Test.Wire.API.Golden.Generated.CookieType_user.testObject_CookieType_user_18, "testObject_CookieType_user_18.json"), (Test.Wire.API.Golden.Generated.CookieType_user.testObject_CookieType_user_19, "testObject_CookieType_user_19.json"), (Test.Wire.API.Golden.Generated.CookieType_user.testObject_CookieType_user_20, "testObject_CookieType_user_20.json")],
      testGroup "Golden: Cookie_20_28_29_user" $
        testObjects [(Test.Wire.API.Golden.Generated.Cookie_20_28_29_user.testObject_Cookie_20_28_29_user_1, "testObject_Cookie_20_28_29_user_1.json"), (Test.Wire.API.Golden.Generated.Cookie_20_28_29_user.testObject_Cookie_20_28_29_user_2, "testObject_Cookie_20_28_29_user_2.json"), (Test.Wire.API.Golden.Generated.Cookie_20_28_29_user.testObject_Cookie_20_28_29_user_3, "testObject_Cookie_20_28_29_user_3.json"), (Test.Wire.API.Golden.Generated.Cookie_20_28_29_user.testObject_Cookie_20_28_29_user_4, "testObject_Cookie_20_28_29_user_4.json"), (Test.Wire.API.Golden.Generated.Cookie_20_28_29_user.testObject_Cookie_20_28_29_user_5, "testObject_Cookie_20_28_29_user_5.json"), (Test.Wire.API.Golden.Generated.Cookie_20_28_29_user.testObject_Cookie_20_28_29_user_6, "testObject_Cookie_20_28_29_user_6.json"), (Test.Wire.API.Golden.Generated.Cookie_20_28_29_user.testObject_Cookie_20_28_29_user_7, "testObject_Cookie_20_28_29_user_7.json"), (Test.Wire.API.Golden.Generated.Cookie_20_28_29_user.testObject_Cookie_20_28_29_user_8, "testObject_Cookie_20_28_29_user_8.json"), (Test.Wire.API.Golden.Generated.Cookie_20_28_29_user.testObject_Cookie_20_28_29_user_9, "testObject_Cookie_20_28_29_user_9.json"), (Test.Wire.API.Golden.Generated.Cookie_20_28_29_user.testObject_Cookie_20_28_29_user_10, "testObject_Cookie_20_28_29_user_10.json"), (Test.Wire.API.Golden.Generated.Cookie_20_28_29_user.testObject_Cookie_20_28_29_user_11, "testObject_Cookie_20_28_29_user_11.json"), (Test.Wire.API.Golden.Generated.Cookie_20_28_29_user.testObject_Cookie_20_28_29_user_12, "testObject_Cookie_20_28_29_user_12.json"), (Test.Wire.API.Golden.Generated.Cookie_20_28_29_user.testObject_Cookie_20_28_29_user_13, "testObject_Cookie_20_28_29_user_13.json"), (Test.Wire.API.Golden.Generated.Cookie_20_28_29_user.testObject_Cookie_20_28_29_user_14, "testObject_Cookie_20_28_29_user_14.json"), (Test.Wire.API.Golden.Generated.Cookie_20_28_29_user.testObject_Cookie_20_28_29_user_15, "testObject_Cookie_20_28_29_user_15.json"), (Test.Wire.API.Golden.Generated.Cookie_20_28_29_user.testObject_Cookie_20_28_29_user_16, "testObject_Cookie_20_28_29_user_16.json"), (Test.Wire.API.Golden.Generated.Cookie_20_28_29_user.testObject_Cookie_20_28_29_user_17, "testObject_Cookie_20_28_29_user_17.json"), (Test.Wire.API.Golden.Generated.Cookie_20_28_29_user.testObject_Cookie_20_28_29_user_18, "testObject_Cookie_20_28_29_user_18.json"), (Test.Wire.API.Golden.Generated.Cookie_20_28_29_user.testObject_Cookie_20_28_29_user_19, "testObject_Cookie_20_28_29_user_19.json"), (Test.Wire.API.Golden.Generated.Cookie_20_28_29_user.testObject_Cookie_20_28_29_user_20, "testObject_Cookie_20_28_29_user_20.json")],
      testGroup "Golden: CookieList_user" $
        testObjects [(Test.Wire.API.Golden.Generated.CookieList_user.testObject_CookieList_user_1, "testObject_CookieList_user_1.json"), (Test.Wire.API.Golden.Generated.CookieList_user.testObject_CookieList_user_2, "testObject_CookieList_user_2.json"), (Test.Wire.API.Golden.Generated.CookieList_user.testObject_CookieList_user_3, "testObject_CookieList_user_3.json"), (Test.Wire.API.Golden.Generated.CookieList_user.testObject_CookieList_user_4, "testObject_CookieList_user_4.json"), (Test.Wire.API.Golden.Generated.CookieList_user.testObject_CookieList_user_5, "testObject_CookieList_user_5.json"), (Test.Wire.API.Golden.Generated.CookieList_user.testObject_CookieList_user_6, "testObject_CookieList_user_6.json"), (Test.Wire.API.Golden.Generated.CookieList_user.testObject_CookieList_user_7, "testObject_CookieList_user_7.json"), (Test.Wire.API.Golden.Generated.CookieList_user.testObject_CookieList_user_8, "testObject_CookieList_user_8.json"), (Test.Wire.API.Golden.Generated.CookieList_user.testObject_CookieList_user_9, "testObject_CookieList_user_9.json"), (Test.Wire.API.Golden.Generated.CookieList_user.testObject_CookieList_user_10, "testObject_CookieList_user_10.json"), (Test.Wire.API.Golden.Generated.CookieList_user.testObject_CookieList_user_11, "testObject_CookieList_user_11.json"), (Test.Wire.API.Golden.Generated.CookieList_user.testObject_CookieList_user_12, "testObject_CookieList_user_12.json"), (Test.Wire.API.Golden.Generated.CookieList_user.testObject_CookieList_user_13, "testObject_CookieList_user_13.json"), (Test.Wire.API.Golden.Generated.CookieList_user.testObject_CookieList_user_14, "testObject_CookieList_user_14.json"), (Test.Wire.API.Golden.Generated.CookieList_user.testObject_CookieList_user_15, "testObject_CookieList_user_15.json"), (Test.Wire.API.Golden.Generated.CookieList_user.testObject_CookieList_user_16, "testObject_CookieList_user_16.json"), (Test.Wire.API.Golden.Generated.CookieList_user.testObject_CookieList_user_17, "testObject_CookieList_user_17.json"), (Test.Wire.API.Golden.Generated.CookieList_user.testObject_CookieList_user_18, "testObject_CookieList_user_18.json"), (Test.Wire.API.Golden.Generated.CookieList_user.testObject_CookieList_user_19, "testObject_CookieList_user_19.json"), (Test.Wire.API.Golden.Generated.CookieList_user.testObject_CookieList_user_20, "testObject_CookieList_user_20.json")],
      testGroup "Golden: RemoveCookies_user" $
        testObjects [(Test.Wire.API.Golden.Generated.RemoveCookies_user.testObject_RemoveCookies_user_1, "testObject_RemoveCookies_user_1.json"), (Test.Wire.API.Golden.Generated.RemoveCookies_user.testObject_RemoveCookies_user_2, "testObject_RemoveCookies_user_2.json"), (Test.Wire.API.Golden.Generated.RemoveCookies_user.testObject_RemoveCookies_user_3, "testObject_RemoveCookies_user_3.json"), (Test.Wire.API.Golden.Generated.RemoveCookies_user.testObject_RemoveCookies_user_4, "testObject_RemoveCookies_user_4.json"), (Test.Wire.API.Golden.Generated.RemoveCookies_user.testObject_RemoveCookies_user_5, "testObject_RemoveCookies_user_5.json"), (Test.Wire.API.Golden.Generated.RemoveCookies_user.testObject_RemoveCookies_user_6, "testObject_RemoveCookies_user_6.json"), (Test.Wire.API.Golden.Generated.RemoveCookies_user.testObject_RemoveCookies_user_7, "testObject_RemoveCookies_user_7.json"), (Test.Wire.API.Golden.Generated.RemoveCookies_user.testObject_RemoveCookies_user_8, "testObject_RemoveCookies_user_8.json"), (Test.Wire.API.Golden.Generated.RemoveCookies_user.testObject_RemoveCookies_user_9, "testObject_RemoveCookies_user_9.json"), (Test.Wire.API.Golden.Generated.RemoveCookies_user.testObject_RemoveCookies_user_10, "testObject_RemoveCookies_user_10.json"), (Test.Wire.API.Golden.Generated.RemoveCookies_user.testObject_RemoveCookies_user_11, "testObject_RemoveCookies_user_11.json"), (Test.Wire.API.Golden.Generated.RemoveCookies_user.testObject_RemoveCookies_user_12, "testObject_RemoveCookies_user_12.json"), (Test.Wire.API.Golden.Generated.RemoveCookies_user.testObject_RemoveCookies_user_13, "testObject_RemoveCookies_user_13.json"), (Test.Wire.API.Golden.Generated.RemoveCookies_user.testObject_RemoveCookies_user_14, "testObject_RemoveCookies_user_14.json"), (Test.Wire.API.Golden.Generated.RemoveCookies_user.testObject_RemoveCookies_user_15, "testObject_RemoveCookies_user_15.json"), (Test.Wire.API.Golden.Generated.RemoveCookies_user.testObject_RemoveCookies_user_16, "testObject_RemoveCookies_user_16.json"), (Test.Wire.API.Golden.Generated.RemoveCookies_user.testObject_RemoveCookies_user_17, "testObject_RemoveCookies_user_17.json"), (Test.Wire.API.Golden.Generated.RemoveCookies_user.testObject_RemoveCookies_user_18, "testObject_RemoveCookies_user_18.json"), (Test.Wire.API.Golden.Generated.RemoveCookies_user.testObject_RemoveCookies_user_19, "testObject_RemoveCookies_user_19.json"), (Test.Wire.API.Golden.Generated.RemoveCookies_user.testObject_RemoveCookies_user_20, "testObject_RemoveCookies_user_20.json")],
      testGroup "Golden: TokenType_user" $
        testObjects [(Test.Wire.API.Golden.Generated.TokenType_user.testObject_TokenType_user_1, "testObject_TokenType_user_1.json"), (Test.Wire.API.Golden.Generated.TokenType_user.testObject_TokenType_user_2, "testObject_TokenType_user_2.json"), (Test.Wire.API.Golden.Generated.TokenType_user.testObject_TokenType_user_3, "testObject_TokenType_user_3.json"), (Test.Wire.API.Golden.Generated.TokenType_user.testObject_TokenType_user_4, "testObject_TokenType_user_4.json"), (Test.Wire.API.Golden.Generated.TokenType_user.testObject_TokenType_user_5, "testObject_TokenType_user_5.json"), (Test.Wire.API.Golden.Generated.TokenType_user.testObject_TokenType_user_6, "testObject_TokenType_user_6.json"), (Test.Wire.API.Golden.Generated.TokenType_user.testObject_TokenType_user_7, "testObject_TokenType_user_7.json"), (Test.Wire.API.Golden.Generated.TokenType_user.testObject_TokenType_user_8, "testObject_TokenType_user_8.json"), (Test.Wire.API.Golden.Generated.TokenType_user.testObject_TokenType_user_9, "testObject_TokenType_user_9.json"), (Test.Wire.API.Golden.Generated.TokenType_user.testObject_TokenType_user_10, "testObject_TokenType_user_10.json"), (Test.Wire.API.Golden.Generated.TokenType_user.testObject_TokenType_user_11, "testObject_TokenType_user_11.json"), (Test.Wire.API.Golden.Generated.TokenType_user.testObject_TokenType_user_12, "testObject_TokenType_user_12.json"), (Test.Wire.API.Golden.Generated.TokenType_user.testObject_TokenType_user_13, "testObject_TokenType_user_13.json"), (Test.Wire.API.Golden.Generated.TokenType_user.testObject_TokenType_user_14, "testObject_TokenType_user_14.json"), (Test.Wire.API.Golden.Generated.TokenType_user.testObject_TokenType_user_15, "testObject_TokenType_user_15.json"), (Test.Wire.API.Golden.Generated.TokenType_user.testObject_TokenType_user_16, "testObject_TokenType_user_16.json"), (Test.Wire.API.Golden.Generated.TokenType_user.testObject_TokenType_user_17, "testObject_TokenType_user_17.json"), (Test.Wire.API.Golden.Generated.TokenType_user.testObject_TokenType_user_18, "testObject_TokenType_user_18.json"), (Test.Wire.API.Golden.Generated.TokenType_user.testObject_TokenType_user_19, "testObject_TokenType_user_19.json"), (Test.Wire.API.Golden.Generated.TokenType_user.testObject_TokenType_user_20, "testObject_TokenType_user_20.json")],
      testGroup "Golden: AccessToken_user" $
        testObjects [(Test.Wire.API.Golden.Generated.AccessToken_user.testObject_AccessToken_user_1, "testObject_AccessToken_user_1.json"), (Test.Wire.API.Golden.Generated.AccessToken_user.testObject_AccessToken_user_2, "testObject_AccessToken_user_2.json"), (Test.Wire.API.Golden.Generated.AccessToken_user.testObject_AccessToken_user_3, "testObject_AccessToken_user_3.json"), (Test.Wire.API.Golden.Generated.AccessToken_user.testObject_AccessToken_user_4, "testObject_AccessToken_user_4.json"), (Test.Wire.API.Golden.Generated.AccessToken_user.testObject_AccessToken_user_5, "testObject_AccessToken_user_5.json"), (Test.Wire.API.Golden.Generated.AccessToken_user.testObject_AccessToken_user_6, "testObject_AccessToken_user_6.json"), (Test.Wire.API.Golden.Generated.AccessToken_user.testObject_AccessToken_user_7, "testObject_AccessToken_user_7.json"), (Test.Wire.API.Golden.Generated.AccessToken_user.testObject_AccessToken_user_8, "testObject_AccessToken_user_8.json"), (Test.Wire.API.Golden.Generated.AccessToken_user.testObject_AccessToken_user_9, "testObject_AccessToken_user_9.json"), (Test.Wire.API.Golden.Generated.AccessToken_user.testObject_AccessToken_user_10, "testObject_AccessToken_user_10.json"), (Test.Wire.API.Golden.Generated.AccessToken_user.testObject_AccessToken_user_11, "testObject_AccessToken_user_11.json"), (Test.Wire.API.Golden.Generated.AccessToken_user.testObject_AccessToken_user_12, "testObject_AccessToken_user_12.json"), (Test.Wire.API.Golden.Generated.AccessToken_user.testObject_AccessToken_user_13, "testObject_AccessToken_user_13.json"), (Test.Wire.API.Golden.Generated.AccessToken_user.testObject_AccessToken_user_14, "testObject_AccessToken_user_14.json"), (Test.Wire.API.Golden.Generated.AccessToken_user.testObject_AccessToken_user_15, "testObject_AccessToken_user_15.json"), (Test.Wire.API.Golden.Generated.AccessToken_user.testObject_AccessToken_user_16, "testObject_AccessToken_user_16.json"), (Test.Wire.API.Golden.Generated.AccessToken_user.testObject_AccessToken_user_17, "testObject_AccessToken_user_17.json"), (Test.Wire.API.Golden.Generated.AccessToken_user.testObject_AccessToken_user_18, "testObject_AccessToken_user_18.json"), (Test.Wire.API.Golden.Generated.AccessToken_user.testObject_AccessToken_user_19, "testObject_AccessToken_user_19.json"), (Test.Wire.API.Golden.Generated.AccessToken_user.testObject_AccessToken_user_20, "testObject_AccessToken_user_20.json")],
      testGroup "Golden: UserClientMap_20Int_user" $
        testObjects [(Test.Wire.API.Golden.Generated.UserClientMap_20Int_user.testObject_UserClientMap_20Int_user_1, "testObject_UserClientMap_20Int_user_1.json"), (Test.Wire.API.Golden.Generated.UserClientMap_20Int_user.testObject_UserClientMap_20Int_user_2, "testObject_UserClientMap_20Int_user_2.json"), (Test.Wire.API.Golden.Generated.UserClientMap_20Int_user.testObject_UserClientMap_20Int_user_3, "testObject_UserClientMap_20Int_user_3.json"), (Test.Wire.API.Golden.Generated.UserClientMap_20Int_user.testObject_UserClientMap_20Int_user_4, "testObject_UserClientMap_20Int_user_4.json"), (Test.Wire.API.Golden.Generated.UserClientMap_20Int_user.testObject_UserClientMap_20Int_user_5, "testObject_UserClientMap_20Int_user_5.json"), (Test.Wire.API.Golden.Generated.UserClientMap_20Int_user.testObject_UserClientMap_20Int_user_6, "testObject_UserClientMap_20Int_user_6.json"), (Test.Wire.API.Golden.Generated.UserClientMap_20Int_user.testObject_UserClientMap_20Int_user_7, "testObject_UserClientMap_20Int_user_7.json"), (Test.Wire.API.Golden.Generated.UserClientMap_20Int_user.testObject_UserClientMap_20Int_user_8, "testObject_UserClientMap_20Int_user_8.json"), (Test.Wire.API.Golden.Generated.UserClientMap_20Int_user.testObject_UserClientMap_20Int_user_9, "testObject_UserClientMap_20Int_user_9.json"), (Test.Wire.API.Golden.Generated.UserClientMap_20Int_user.testObject_UserClientMap_20Int_user_10, "testObject_UserClientMap_20Int_user_10.json"), (Test.Wire.API.Golden.Generated.UserClientMap_20Int_user.testObject_UserClientMap_20Int_user_11, "testObject_UserClientMap_20Int_user_11.json"), (Test.Wire.API.Golden.Generated.UserClientMap_20Int_user.testObject_UserClientMap_20Int_user_12, "testObject_UserClientMap_20Int_user_12.json"), (Test.Wire.API.Golden.Generated.UserClientMap_20Int_user.testObject_UserClientMap_20Int_user_13, "testObject_UserClientMap_20Int_user_13.json"), (Test.Wire.API.Golden.Generated.UserClientMap_20Int_user.testObject_UserClientMap_20Int_user_14, "testObject_UserClientMap_20Int_user_14.json"), (Test.Wire.API.Golden.Generated.UserClientMap_20Int_user.testObject_UserClientMap_20Int_user_15, "testObject_UserClientMap_20Int_user_15.json"), (Test.Wire.API.Golden.Generated.UserClientMap_20Int_user.testObject_UserClientMap_20Int_user_16, "testObject_UserClientMap_20Int_user_16.json"), (Test.Wire.API.Golden.Generated.UserClientMap_20Int_user.testObject_UserClientMap_20Int_user_17, "testObject_UserClientMap_20Int_user_17.json"), (Test.Wire.API.Golden.Generated.UserClientMap_20Int_user.testObject_UserClientMap_20Int_user_18, "testObject_UserClientMap_20Int_user_18.json"), (Test.Wire.API.Golden.Generated.UserClientMap_20Int_user.testObject_UserClientMap_20Int_user_19, "testObject_UserClientMap_20Int_user_19.json"), (Test.Wire.API.Golden.Generated.UserClientMap_20Int_user.testObject_UserClientMap_20Int_user_20, "testObject_UserClientMap_20Int_user_20.json")],
      testGroup "Golden: UserClients_user" $
        testObjects [(Test.Wire.API.Golden.Generated.UserClients_user.testObject_UserClients_user_1, "testObject_UserClients_user_1.json"), (Test.Wire.API.Golden.Generated.UserClients_user.testObject_UserClients_user_2, "testObject_UserClients_user_2.json"), (Test.Wire.API.Golden.Generated.UserClients_user.testObject_UserClients_user_3, "testObject_UserClients_user_3.json"), (Test.Wire.API.Golden.Generated.UserClients_user.testObject_UserClients_user_4, "testObject_UserClients_user_4.json"), (Test.Wire.API.Golden.Generated.UserClients_user.testObject_UserClients_user_5, "testObject_UserClients_user_5.json"), (Test.Wire.API.Golden.Generated.UserClients_user.testObject_UserClients_user_6, "testObject_UserClients_user_6.json"), (Test.Wire.API.Golden.Generated.UserClients_user.testObject_UserClients_user_7, "testObject_UserClients_user_7.json"), (Test.Wire.API.Golden.Generated.UserClients_user.testObject_UserClients_user_8, "testObject_UserClients_user_8.json"), (Test.Wire.API.Golden.Generated.UserClients_user.testObject_UserClients_user_9, "testObject_UserClients_user_9.json"), (Test.Wire.API.Golden.Generated.UserClients_user.testObject_UserClients_user_10, "testObject_UserClients_user_10.json"), (Test.Wire.API.Golden.Generated.UserClients_user.testObject_UserClients_user_11, "testObject_UserClients_user_11.json"), (Test.Wire.API.Golden.Generated.UserClients_user.testObject_UserClients_user_12, "testObject_UserClients_user_12.json"), (Test.Wire.API.Golden.Generated.UserClients_user.testObject_UserClients_user_13, "testObject_UserClients_user_13.json"), (Test.Wire.API.Golden.Generated.UserClients_user.testObject_UserClients_user_14, "testObject_UserClients_user_14.json"), (Test.Wire.API.Golden.Generated.UserClients_user.testObject_UserClients_user_15, "testObject_UserClients_user_15.json"), (Test.Wire.API.Golden.Generated.UserClients_user.testObject_UserClients_user_16, "testObject_UserClients_user_16.json"), (Test.Wire.API.Golden.Generated.UserClients_user.testObject_UserClients_user_17, "testObject_UserClients_user_17.json"), (Test.Wire.API.Golden.Generated.UserClients_user.testObject_UserClients_user_18, "testObject_UserClients_user_18.json"), (Test.Wire.API.Golden.Generated.UserClients_user.testObject_UserClients_user_19, "testObject_UserClients_user_19.json"), (Test.Wire.API.Golden.Generated.UserClients_user.testObject_UserClients_user_20, "testObject_UserClients_user_20.json")],
      testGroup "Golden: ClientType_user" $
        testObjects [(Test.Wire.API.Golden.Generated.ClientType_user.testObject_ClientType_user_1, "testObject_ClientType_user_1.json"), (Test.Wire.API.Golden.Generated.ClientType_user.testObject_ClientType_user_2, "testObject_ClientType_user_2.json"), (Test.Wire.API.Golden.Generated.ClientType_user.testObject_ClientType_user_3, "testObject_ClientType_user_3.json"), (Test.Wire.API.Golden.Generated.ClientType_user.testObject_ClientType_user_4, "testObject_ClientType_user_4.json"), (Test.Wire.API.Golden.Generated.ClientType_user.testObject_ClientType_user_5, "testObject_ClientType_user_5.json"), (Test.Wire.API.Golden.Generated.ClientType_user.testObject_ClientType_user_6, "testObject_ClientType_user_6.json"), (Test.Wire.API.Golden.Generated.ClientType_user.testObject_ClientType_user_7, "testObject_ClientType_user_7.json"), (Test.Wire.API.Golden.Generated.ClientType_user.testObject_ClientType_user_8, "testObject_ClientType_user_8.json"), (Test.Wire.API.Golden.Generated.ClientType_user.testObject_ClientType_user_9, "testObject_ClientType_user_9.json"), (Test.Wire.API.Golden.Generated.ClientType_user.testObject_ClientType_user_10, "testObject_ClientType_user_10.json"), (Test.Wire.API.Golden.Generated.ClientType_user.testObject_ClientType_user_11, "testObject_ClientType_user_11.json"), (Test.Wire.API.Golden.Generated.ClientType_user.testObject_ClientType_user_12, "testObject_ClientType_user_12.json"), (Test.Wire.API.Golden.Generated.ClientType_user.testObject_ClientType_user_13, "testObject_ClientType_user_13.json"), (Test.Wire.API.Golden.Generated.ClientType_user.testObject_ClientType_user_14, "testObject_ClientType_user_14.json"), (Test.Wire.API.Golden.Generated.ClientType_user.testObject_ClientType_user_15, "testObject_ClientType_user_15.json"), (Test.Wire.API.Golden.Generated.ClientType_user.testObject_ClientType_user_16, "testObject_ClientType_user_16.json"), (Test.Wire.API.Golden.Generated.ClientType_user.testObject_ClientType_user_17, "testObject_ClientType_user_17.json"), (Test.Wire.API.Golden.Generated.ClientType_user.testObject_ClientType_user_18, "testObject_ClientType_user_18.json"), (Test.Wire.API.Golden.Generated.ClientType_user.testObject_ClientType_user_19, "testObject_ClientType_user_19.json"), (Test.Wire.API.Golden.Generated.ClientType_user.testObject_ClientType_user_20, "testObject_ClientType_user_20.json")],
      testGroup "Golden: ClientClass_user" $
        testObjects [(Test.Wire.API.Golden.Generated.ClientClass_user.testObject_ClientClass_user_1, "testObject_ClientClass_user_1.json"), (Test.Wire.API.Golden.Generated.ClientClass_user.testObject_ClientClass_user_2, "testObject_ClientClass_user_2.json"), (Test.Wire.API.Golden.Generated.ClientClass_user.testObject_ClientClass_user_3, "testObject_ClientClass_user_3.json"), (Test.Wire.API.Golden.Generated.ClientClass_user.testObject_ClientClass_user_4, "testObject_ClientClass_user_4.json"), (Test.Wire.API.Golden.Generated.ClientClass_user.testObject_ClientClass_user_5, "testObject_ClientClass_user_5.json"), (Test.Wire.API.Golden.Generated.ClientClass_user.testObject_ClientClass_user_6, "testObject_ClientClass_user_6.json"), (Test.Wire.API.Golden.Generated.ClientClass_user.testObject_ClientClass_user_7, "testObject_ClientClass_user_7.json"), (Test.Wire.API.Golden.Generated.ClientClass_user.testObject_ClientClass_user_8, "testObject_ClientClass_user_8.json"), (Test.Wire.API.Golden.Generated.ClientClass_user.testObject_ClientClass_user_9, "testObject_ClientClass_user_9.json"), (Test.Wire.API.Golden.Generated.ClientClass_user.testObject_ClientClass_user_10, "testObject_ClientClass_user_10.json"), (Test.Wire.API.Golden.Generated.ClientClass_user.testObject_ClientClass_user_11, "testObject_ClientClass_user_11.json"), (Test.Wire.API.Golden.Generated.ClientClass_user.testObject_ClientClass_user_12, "testObject_ClientClass_user_12.json"), (Test.Wire.API.Golden.Generated.ClientClass_user.testObject_ClientClass_user_13, "testObject_ClientClass_user_13.json"), (Test.Wire.API.Golden.Generated.ClientClass_user.testObject_ClientClass_user_14, "testObject_ClientClass_user_14.json"), (Test.Wire.API.Golden.Generated.ClientClass_user.testObject_ClientClass_user_15, "testObject_ClientClass_user_15.json"), (Test.Wire.API.Golden.Generated.ClientClass_user.testObject_ClientClass_user_16, "testObject_ClientClass_user_16.json"), (Test.Wire.API.Golden.Generated.ClientClass_user.testObject_ClientClass_user_17, "testObject_ClientClass_user_17.json"), (Test.Wire.API.Golden.Generated.ClientClass_user.testObject_ClientClass_user_18, "testObject_ClientClass_user_18.json"), (Test.Wire.API.Golden.Generated.ClientClass_user.testObject_ClientClass_user_19, "testObject_ClientClass_user_19.json"), (Test.Wire.API.Golden.Generated.ClientClass_user.testObject_ClientClass_user_20, "testObject_ClientClass_user_20.json")],
      testGroup "Golden: PubClient_user" $
        testObjects [(Test.Wire.API.Golden.Generated.PubClient_user.testObject_PubClient_user_1, "testObject_PubClient_user_1.json"), (Test.Wire.API.Golden.Generated.PubClient_user.testObject_PubClient_user_2, "testObject_PubClient_user_2.json"), (Test.Wire.API.Golden.Generated.PubClient_user.testObject_PubClient_user_3, "testObject_PubClient_user_3.json"), (Test.Wire.API.Golden.Generated.PubClient_user.testObject_PubClient_user_4, "testObject_PubClient_user_4.json"), (Test.Wire.API.Golden.Generated.PubClient_user.testObject_PubClient_user_5, "testObject_PubClient_user_5.json"), (Test.Wire.API.Golden.Generated.PubClient_user.testObject_PubClient_user_6, "testObject_PubClient_user_6.json"), (Test.Wire.API.Golden.Generated.PubClient_user.testObject_PubClient_user_7, "testObject_PubClient_user_7.json"), (Test.Wire.API.Golden.Generated.PubClient_user.testObject_PubClient_user_8, "testObject_PubClient_user_8.json"), (Test.Wire.API.Golden.Generated.PubClient_user.testObject_PubClient_user_9, "testObject_PubClient_user_9.json"), (Test.Wire.API.Golden.Generated.PubClient_user.testObject_PubClient_user_10, "testObject_PubClient_user_10.json"), (Test.Wire.API.Golden.Generated.PubClient_user.testObject_PubClient_user_11, "testObject_PubClient_user_11.json"), (Test.Wire.API.Golden.Generated.PubClient_user.testObject_PubClient_user_12, "testObject_PubClient_user_12.json"), (Test.Wire.API.Golden.Generated.PubClient_user.testObject_PubClient_user_13, "testObject_PubClient_user_13.json"), (Test.Wire.API.Golden.Generated.PubClient_user.testObject_PubClient_user_14, "testObject_PubClient_user_14.json"), (Test.Wire.API.Golden.Generated.PubClient_user.testObject_PubClient_user_15, "testObject_PubClient_user_15.json"), (Test.Wire.API.Golden.Generated.PubClient_user.testObject_PubClient_user_16, "testObject_PubClient_user_16.json"), (Test.Wire.API.Golden.Generated.PubClient_user.testObject_PubClient_user_17, "testObject_PubClient_user_17.json"), (Test.Wire.API.Golden.Generated.PubClient_user.testObject_PubClient_user_18, "testObject_PubClient_user_18.json"), (Test.Wire.API.Golden.Generated.PubClient_user.testObject_PubClient_user_19, "testObject_PubClient_user_19.json"), (Test.Wire.API.Golden.Generated.PubClient_user.testObject_PubClient_user_20, "testObject_PubClient_user_20.json")],
      testGroup "Golden: ClientV6_user" $
        testObjects [(Versioned @'V6 Test.Wire.API.Golden.Generated.Client_user.testObject_Client_user_1, "testObject_ClientV6_user_1.json"), (Versioned @'V6 Test.Wire.API.Golden.Generated.Client_user.testObject_Client_user_2, "testObject_ClientV6_user_2.json"), (Versioned @'V6 Test.Wire.API.Golden.Generated.Client_user.testObject_Client_user_3, "testObject_ClientV6_user_3.json"), (Versioned @'V6 Test.Wire.API.Golden.Generated.Client_user.testObject_Client_user_4, "testObject_ClientV6_user_4.json"), (Versioned @'V6 Test.Wire.API.Golden.Generated.Client_user.testObject_Client_user_5, "testObject_ClientV6_user_5.json"), (Versioned @'V6 Test.Wire.API.Golden.Generated.Client_user.testObject_Client_user_6, "testObject_ClientV6_user_6.json"), (Versioned @'V6 Test.Wire.API.Golden.Generated.Client_user.testObject_Client_user_7, "testObject_ClientV6_user_7.json"), (Versioned @'V6 Test.Wire.API.Golden.Generated.Client_user.testObject_Client_user_8, "testObject_ClientV6_user_8.json"), (Versioned @'V6 Test.Wire.API.Golden.Generated.Client_user.testObject_Client_user_9, "testObject_ClientV6_user_9.json"), (Versioned @'V6 Test.Wire.API.Golden.Generated.Client_user.testObject_Client_user_10, "testObject_ClientV6_user_10.json"), (Versioned @'V6 Test.Wire.API.Golden.Generated.Client_user.testObject_Client_user_11, "testObject_ClientV6_user_11.json"), (Versioned @'V6 Test.Wire.API.Golden.Generated.Client_user.testObject_Client_user_12, "testObject_ClientV6_user_12.json"), (Versioned @'V6 Test.Wire.API.Golden.Generated.Client_user.testObject_Client_user_13, "testObject_ClientV6_user_13.json"), (Versioned @'V6 Test.Wire.API.Golden.Generated.Client_user.testObject_Client_user_14, "testObject_ClientV6_user_14.json"), (Versioned @'V6 Test.Wire.API.Golden.Generated.Client_user.testObject_Client_user_15, "testObject_ClientV6_user_15.json"), (Versioned @'V6 Test.Wire.API.Golden.Generated.Client_user.testObject_Client_user_16, "testObject_ClientV6_user_16.json"), (Versioned @'V6 Test.Wire.API.Golden.Generated.Client_user.testObject_Client_user_17, "testObject_ClientV6_user_17.json"), (Versioned @'V6 Test.Wire.API.Golden.Generated.Client_user.testObject_Client_user_18, "testObject_ClientV6_user_18.json"), (Versioned @'V6 Test.Wire.API.Golden.Generated.Client_user.testObject_Client_user_19, "testObject_ClientV6_user_19.json"), (Versioned @'V6 Test.Wire.API.Golden.Generated.Client_user.testObject_Client_user_20, "testObject_ClientV6_user_20.json")],
      testGroup "Golden: Client_user" $
        testObjects [(Test.Wire.API.Golden.Generated.Client_user.testObject_Client_user_1, "testObject_Client_user_1.json"), (Test.Wire.API.Golden.Generated.Client_user.testObject_Client_user_2, "testObject_Client_user_2.json"), (Test.Wire.API.Golden.Generated.Client_user.testObject_Client_user_3, "testObject_Client_user_3.json"), (Test.Wire.API.Golden.Generated.Client_user.testObject_Client_user_4, "testObject_Client_user_4.json"), (Test.Wire.API.Golden.Generated.Client_user.testObject_Client_user_5, "testObject_Client_user_5.json"), (Test.Wire.API.Golden.Generated.Client_user.testObject_Client_user_6, "testObject_Client_user_6.json"), (Test.Wire.API.Golden.Generated.Client_user.testObject_Client_user_7, "testObject_Client_user_7.json"), (Test.Wire.API.Golden.Generated.Client_user.testObject_Client_user_8, "testObject_Client_user_8.json"), (Test.Wire.API.Golden.Generated.Client_user.testObject_Client_user_9, "testObject_Client_user_9.json"), (Test.Wire.API.Golden.Generated.Client_user.testObject_Client_user_10, "testObject_Client_user_10.json"), (Test.Wire.API.Golden.Generated.Client_user.testObject_Client_user_11, "testObject_Client_user_11.json"), (Test.Wire.API.Golden.Generated.Client_user.testObject_Client_user_12, "testObject_Client_user_12.json"), (Test.Wire.API.Golden.Generated.Client_user.testObject_Client_user_13, "testObject_Client_user_13.json"), (Test.Wire.API.Golden.Generated.Client_user.testObject_Client_user_14, "testObject_Client_user_14.json"), (Test.Wire.API.Golden.Generated.Client_user.testObject_Client_user_15, "testObject_Client_user_15.json"), (Test.Wire.API.Golden.Generated.Client_user.testObject_Client_user_16, "testObject_Client_user_16.json"), (Test.Wire.API.Golden.Generated.Client_user.testObject_Client_user_17, "testObject_Client_user_17.json"), (Test.Wire.API.Golden.Generated.Client_user.testObject_Client_user_18, "testObject_Client_user_18.json"), (Test.Wire.API.Golden.Generated.Client_user.testObject_Client_user_19, "testObject_Client_user_19.json"), (Test.Wire.API.Golden.Generated.Client_user.testObject_Client_user_20, "testObject_Client_user_20.json")],
      testGroup "Golden: NewClient_user" $
        testObjects [(Test.Wire.API.Golden.Generated.NewClient_user.testObject_NewClient_user_1, "testObject_NewClient_user_1.json"), (Test.Wire.API.Golden.Generated.NewClient_user.testObject_NewClient_user_2, "testObject_NewClient_user_2.json"), (Test.Wire.API.Golden.Generated.NewClient_user.testObject_NewClient_user_3, "testObject_NewClient_user_3.json"), (Test.Wire.API.Golden.Generated.NewClient_user.testObject_NewClient_user_4, "testObject_NewClient_user_4.json"), (Test.Wire.API.Golden.Generated.NewClient_user.testObject_NewClient_user_5, "testObject_NewClient_user_5.json"), (Test.Wire.API.Golden.Generated.NewClient_user.testObject_NewClient_user_6, "testObject_NewClient_user_6.json"), (Test.Wire.API.Golden.Generated.NewClient_user.testObject_NewClient_user_7, "testObject_NewClient_user_7.json"), (Test.Wire.API.Golden.Generated.NewClient_user.testObject_NewClient_user_8, "testObject_NewClient_user_8.json"), (Test.Wire.API.Golden.Generated.NewClient_user.testObject_NewClient_user_9, "testObject_NewClient_user_9.json"), (Test.Wire.API.Golden.Generated.NewClient_user.testObject_NewClient_user_10, "testObject_NewClient_user_10.json"), (Test.Wire.API.Golden.Generated.NewClient_user.testObject_NewClient_user_11, "testObject_NewClient_user_11.json"), (Test.Wire.API.Golden.Generated.NewClient_user.testObject_NewClient_user_12, "testObject_NewClient_user_12.json"), (Test.Wire.API.Golden.Generated.NewClient_user.testObject_NewClient_user_13, "testObject_NewClient_user_13.json"), (Test.Wire.API.Golden.Generated.NewClient_user.testObject_NewClient_user_14, "testObject_NewClient_user_14.json"), (Test.Wire.API.Golden.Generated.NewClient_user.testObject_NewClient_user_15, "testObject_NewClient_user_15.json"), (Test.Wire.API.Golden.Generated.NewClient_user.testObject_NewClient_user_16, "testObject_NewClient_user_16.json"), (Test.Wire.API.Golden.Generated.NewClient_user.testObject_NewClient_user_17, "testObject_NewClient_user_17.json"), (Test.Wire.API.Golden.Generated.NewClient_user.testObject_NewClient_user_18, "testObject_NewClient_user_18.json"), (Test.Wire.API.Golden.Generated.NewClient_user.testObject_NewClient_user_19, "testObject_NewClient_user_19.json"), (Test.Wire.API.Golden.Generated.NewClient_user.testObject_NewClient_user_20, "testObject_NewClient_user_20.json")],
      testGroup "Golden: UpdateClient_user" $
        testObjects [(Test.Wire.API.Golden.Generated.UpdateClient_user.testObject_UpdateClient_user_1, "testObject_UpdateClient_user_1.json"), (Test.Wire.API.Golden.Generated.UpdateClient_user.testObject_UpdateClient_user_2, "testObject_UpdateClient_user_2.json"), (Test.Wire.API.Golden.Generated.UpdateClient_user.testObject_UpdateClient_user_3, "testObject_UpdateClient_user_3.json"), (Test.Wire.API.Golden.Generated.UpdateClient_user.testObject_UpdateClient_user_4, "testObject_UpdateClient_user_4.json"), (Test.Wire.API.Golden.Generated.UpdateClient_user.testObject_UpdateClient_user_5, "testObject_UpdateClient_user_5.json"), (Test.Wire.API.Golden.Generated.UpdateClient_user.testObject_UpdateClient_user_6, "testObject_UpdateClient_user_6.json"), (Test.Wire.API.Golden.Generated.UpdateClient_user.testObject_UpdateClient_user_7, "testObject_UpdateClient_user_7.json"), (Test.Wire.API.Golden.Generated.UpdateClient_user.testObject_UpdateClient_user_8, "testObject_UpdateClient_user_8.json"), (Test.Wire.API.Golden.Generated.UpdateClient_user.testObject_UpdateClient_user_9, "testObject_UpdateClient_user_9.json"), (Test.Wire.API.Golden.Generated.UpdateClient_user.testObject_UpdateClient_user_10, "testObject_UpdateClient_user_10.json"), (Test.Wire.API.Golden.Generated.UpdateClient_user.testObject_UpdateClient_user_11, "testObject_UpdateClient_user_11.json"), (Test.Wire.API.Golden.Generated.UpdateClient_user.testObject_UpdateClient_user_12, "testObject_UpdateClient_user_12.json"), (Test.Wire.API.Golden.Generated.UpdateClient_user.testObject_UpdateClient_user_13, "testObject_UpdateClient_user_13.json"), (Test.Wire.API.Golden.Generated.UpdateClient_user.testObject_UpdateClient_user_14, "testObject_UpdateClient_user_14.json"), (Test.Wire.API.Golden.Generated.UpdateClient_user.testObject_UpdateClient_user_15, "testObject_UpdateClient_user_15.json"), (Test.Wire.API.Golden.Generated.UpdateClient_user.testObject_UpdateClient_user_16, "testObject_UpdateClient_user_16.json"), (Test.Wire.API.Golden.Generated.UpdateClient_user.testObject_UpdateClient_user_17, "testObject_UpdateClient_user_17.json"), (Test.Wire.API.Golden.Generated.UpdateClient_user.testObject_UpdateClient_user_18, "testObject_UpdateClient_user_18.json"), (Test.Wire.API.Golden.Generated.UpdateClient_user.testObject_UpdateClient_user_19, "testObject_UpdateClient_user_19.json"), (Test.Wire.API.Golden.Generated.UpdateClient_user.testObject_UpdateClient_user_20, "testObject_UpdateClient_user_20.json")],
      testGroup "Golden: RmClient_user" $
        testObjects [(Test.Wire.API.Golden.Generated.RmClient_user.testObject_RmClient_user_1, "testObject_RmClient_user_1.json"), (Test.Wire.API.Golden.Generated.RmClient_user.testObject_RmClient_user_2, "testObject_RmClient_user_2.json"), (Test.Wire.API.Golden.Generated.RmClient_user.testObject_RmClient_user_3, "testObject_RmClient_user_3.json"), (Test.Wire.API.Golden.Generated.RmClient_user.testObject_RmClient_user_4, "testObject_RmClient_user_4.json"), (Test.Wire.API.Golden.Generated.RmClient_user.testObject_RmClient_user_5, "testObject_RmClient_user_5.json"), (Test.Wire.API.Golden.Generated.RmClient_user.testObject_RmClient_user_6, "testObject_RmClient_user_6.json"), (Test.Wire.API.Golden.Generated.RmClient_user.testObject_RmClient_user_7, "testObject_RmClient_user_7.json"), (Test.Wire.API.Golden.Generated.RmClient_user.testObject_RmClient_user_8, "testObject_RmClient_user_8.json"), (Test.Wire.API.Golden.Generated.RmClient_user.testObject_RmClient_user_9, "testObject_RmClient_user_9.json"), (Test.Wire.API.Golden.Generated.RmClient_user.testObject_RmClient_user_10, "testObject_RmClient_user_10.json"), (Test.Wire.API.Golden.Generated.RmClient_user.testObject_RmClient_user_11, "testObject_RmClient_user_11.json"), (Test.Wire.API.Golden.Generated.RmClient_user.testObject_RmClient_user_12, "testObject_RmClient_user_12.json"), (Test.Wire.API.Golden.Generated.RmClient_user.testObject_RmClient_user_13, "testObject_RmClient_user_13.json"), (Test.Wire.API.Golden.Generated.RmClient_user.testObject_RmClient_user_14, "testObject_RmClient_user_14.json"), (Test.Wire.API.Golden.Generated.RmClient_user.testObject_RmClient_user_15, "testObject_RmClient_user_15.json"), (Test.Wire.API.Golden.Generated.RmClient_user.testObject_RmClient_user_16, "testObject_RmClient_user_16.json"), (Test.Wire.API.Golden.Generated.RmClient_user.testObject_RmClient_user_17, "testObject_RmClient_user_17.json"), (Test.Wire.API.Golden.Generated.RmClient_user.testObject_RmClient_user_18, "testObject_RmClient_user_18.json"), (Test.Wire.API.Golden.Generated.RmClient_user.testObject_RmClient_user_19, "testObject_RmClient_user_19.json"), (Test.Wire.API.Golden.Generated.RmClient_user.testObject_RmClient_user_20, "testObject_RmClient_user_20.json")],
      testGroup "Golden: LastPrekey_user" $
        testObjects [(Test.Wire.API.Golden.Generated.LastPrekey_user.testObject_LastPrekey_user_1, "testObject_LastPrekey_user_1.json"), (Test.Wire.API.Golden.Generated.LastPrekey_user.testObject_LastPrekey_user_2, "testObject_LastPrekey_user_2.json"), (Test.Wire.API.Golden.Generated.LastPrekey_user.testObject_LastPrekey_user_3, "testObject_LastPrekey_user_3.json"), (Test.Wire.API.Golden.Generated.LastPrekey_user.testObject_LastPrekey_user_4, "testObject_LastPrekey_user_4.json"), (Test.Wire.API.Golden.Generated.LastPrekey_user.testObject_LastPrekey_user_5, "testObject_LastPrekey_user_5.json"), (Test.Wire.API.Golden.Generated.LastPrekey_user.testObject_LastPrekey_user_6, "testObject_LastPrekey_user_6.json"), (Test.Wire.API.Golden.Generated.LastPrekey_user.testObject_LastPrekey_user_7, "testObject_LastPrekey_user_7.json"), (Test.Wire.API.Golden.Generated.LastPrekey_user.testObject_LastPrekey_user_8, "testObject_LastPrekey_user_8.json"), (Test.Wire.API.Golden.Generated.LastPrekey_user.testObject_LastPrekey_user_9, "testObject_LastPrekey_user_9.json"), (Test.Wire.API.Golden.Generated.LastPrekey_user.testObject_LastPrekey_user_10, "testObject_LastPrekey_user_10.json"), (Test.Wire.API.Golden.Generated.LastPrekey_user.testObject_LastPrekey_user_11, "testObject_LastPrekey_user_11.json"), (Test.Wire.API.Golden.Generated.LastPrekey_user.testObject_LastPrekey_user_12, "testObject_LastPrekey_user_12.json"), (Test.Wire.API.Golden.Generated.LastPrekey_user.testObject_LastPrekey_user_13, "testObject_LastPrekey_user_13.json"), (Test.Wire.API.Golden.Generated.LastPrekey_user.testObject_LastPrekey_user_14, "testObject_LastPrekey_user_14.json"), (Test.Wire.API.Golden.Generated.LastPrekey_user.testObject_LastPrekey_user_15, "testObject_LastPrekey_user_15.json"), (Test.Wire.API.Golden.Generated.LastPrekey_user.testObject_LastPrekey_user_16, "testObject_LastPrekey_user_16.json"), (Test.Wire.API.Golden.Generated.LastPrekey_user.testObject_LastPrekey_user_17, "testObject_LastPrekey_user_17.json"), (Test.Wire.API.Golden.Generated.LastPrekey_user.testObject_LastPrekey_user_18, "testObject_LastPrekey_user_18.json"), (Test.Wire.API.Golden.Generated.LastPrekey_user.testObject_LastPrekey_user_19, "testObject_LastPrekey_user_19.json"), (Test.Wire.API.Golden.Generated.LastPrekey_user.testObject_LastPrekey_user_20, "testObject_LastPrekey_user_20.json")],
      testGroup "Golden: PrekeyId_user" $
        testObjects [(Test.Wire.API.Golden.Generated.PrekeyId_user.testObject_PrekeyId_user_1, "testObject_PrekeyId_user_1.json"), (Test.Wire.API.Golden.Generated.PrekeyId_user.testObject_PrekeyId_user_2, "testObject_PrekeyId_user_2.json"), (Test.Wire.API.Golden.Generated.PrekeyId_user.testObject_PrekeyId_user_3, "testObject_PrekeyId_user_3.json"), (Test.Wire.API.Golden.Generated.PrekeyId_user.testObject_PrekeyId_user_4, "testObject_PrekeyId_user_4.json"), (Test.Wire.API.Golden.Generated.PrekeyId_user.testObject_PrekeyId_user_5, "testObject_PrekeyId_user_5.json"), (Test.Wire.API.Golden.Generated.PrekeyId_user.testObject_PrekeyId_user_6, "testObject_PrekeyId_user_6.json"), (Test.Wire.API.Golden.Generated.PrekeyId_user.testObject_PrekeyId_user_7, "testObject_PrekeyId_user_7.json"), (Test.Wire.API.Golden.Generated.PrekeyId_user.testObject_PrekeyId_user_8, "testObject_PrekeyId_user_8.json"), (Test.Wire.API.Golden.Generated.PrekeyId_user.testObject_PrekeyId_user_9, "testObject_PrekeyId_user_9.json"), (Test.Wire.API.Golden.Generated.PrekeyId_user.testObject_PrekeyId_user_10, "testObject_PrekeyId_user_10.json"), (Test.Wire.API.Golden.Generated.PrekeyId_user.testObject_PrekeyId_user_11, "testObject_PrekeyId_user_11.json"), (Test.Wire.API.Golden.Generated.PrekeyId_user.testObject_PrekeyId_user_12, "testObject_PrekeyId_user_12.json"), (Test.Wire.API.Golden.Generated.PrekeyId_user.testObject_PrekeyId_user_13, "testObject_PrekeyId_user_13.json"), (Test.Wire.API.Golden.Generated.PrekeyId_user.testObject_PrekeyId_user_14, "testObject_PrekeyId_user_14.json"), (Test.Wire.API.Golden.Generated.PrekeyId_user.testObject_PrekeyId_user_15, "testObject_PrekeyId_user_15.json"), (Test.Wire.API.Golden.Generated.PrekeyId_user.testObject_PrekeyId_user_16, "testObject_PrekeyId_user_16.json"), (Test.Wire.API.Golden.Generated.PrekeyId_user.testObject_PrekeyId_user_17, "testObject_PrekeyId_user_17.json"), (Test.Wire.API.Golden.Generated.PrekeyId_user.testObject_PrekeyId_user_18, "testObject_PrekeyId_user_18.json"), (Test.Wire.API.Golden.Generated.PrekeyId_user.testObject_PrekeyId_user_19, "testObject_PrekeyId_user_19.json"), (Test.Wire.API.Golden.Generated.PrekeyId_user.testObject_PrekeyId_user_20, "testObject_PrekeyId_user_20.json")],
      testGroup "Golden: Prekey_user" $
        testObjects [(Test.Wire.API.Golden.Generated.Prekey_user.testObject_Prekey_user_1, "testObject_Prekey_user_1.json"), (Test.Wire.API.Golden.Generated.Prekey_user.testObject_Prekey_user_2, "testObject_Prekey_user_2.json"), (Test.Wire.API.Golden.Generated.Prekey_user.testObject_Prekey_user_3, "testObject_Prekey_user_3.json"), (Test.Wire.API.Golden.Generated.Prekey_user.testObject_Prekey_user_4, "testObject_Prekey_user_4.json"), (Test.Wire.API.Golden.Generated.Prekey_user.testObject_Prekey_user_5, "testObject_Prekey_user_5.json"), (Test.Wire.API.Golden.Generated.Prekey_user.testObject_Prekey_user_6, "testObject_Prekey_user_6.json"), (Test.Wire.API.Golden.Generated.Prekey_user.testObject_Prekey_user_7, "testObject_Prekey_user_7.json"), (Test.Wire.API.Golden.Generated.Prekey_user.testObject_Prekey_user_8, "testObject_Prekey_user_8.json"), (Test.Wire.API.Golden.Generated.Prekey_user.testObject_Prekey_user_9, "testObject_Prekey_user_9.json"), (Test.Wire.API.Golden.Generated.Prekey_user.testObject_Prekey_user_10, "testObject_Prekey_user_10.json"), (Test.Wire.API.Golden.Generated.Prekey_user.testObject_Prekey_user_11, "testObject_Prekey_user_11.json"), (Test.Wire.API.Golden.Generated.Prekey_user.testObject_Prekey_user_12, "testObject_Prekey_user_12.json"), (Test.Wire.API.Golden.Generated.Prekey_user.testObject_Prekey_user_13, "testObject_Prekey_user_13.json"), (Test.Wire.API.Golden.Generated.Prekey_user.testObject_Prekey_user_14, "testObject_Prekey_user_14.json"), (Test.Wire.API.Golden.Generated.Prekey_user.testObject_Prekey_user_15, "testObject_Prekey_user_15.json"), (Test.Wire.API.Golden.Generated.Prekey_user.testObject_Prekey_user_16, "testObject_Prekey_user_16.json"), (Test.Wire.API.Golden.Generated.Prekey_user.testObject_Prekey_user_17, "testObject_Prekey_user_17.json"), (Test.Wire.API.Golden.Generated.Prekey_user.testObject_Prekey_user_18, "testObject_Prekey_user_18.json"), (Test.Wire.API.Golden.Generated.Prekey_user.testObject_Prekey_user_19, "testObject_Prekey_user_19.json"), (Test.Wire.API.Golden.Generated.Prekey_user.testObject_Prekey_user_20, "testObject_Prekey_user_20.json")],
      testGroup "Golden: ClientPrekey_user" $
        testObjects [(Test.Wire.API.Golden.Generated.ClientPrekey_user.testObject_ClientPrekey_user_1, "testObject_ClientPrekey_user_1.json"), (Test.Wire.API.Golden.Generated.ClientPrekey_user.testObject_ClientPrekey_user_2, "testObject_ClientPrekey_user_2.json"), (Test.Wire.API.Golden.Generated.ClientPrekey_user.testObject_ClientPrekey_user_3, "testObject_ClientPrekey_user_3.json"), (Test.Wire.API.Golden.Generated.ClientPrekey_user.testObject_ClientPrekey_user_4, "testObject_ClientPrekey_user_4.json"), (Test.Wire.API.Golden.Generated.ClientPrekey_user.testObject_ClientPrekey_user_5, "testObject_ClientPrekey_user_5.json"), (Test.Wire.API.Golden.Generated.ClientPrekey_user.testObject_ClientPrekey_user_6, "testObject_ClientPrekey_user_6.json"), (Test.Wire.API.Golden.Generated.ClientPrekey_user.testObject_ClientPrekey_user_7, "testObject_ClientPrekey_user_7.json"), (Test.Wire.API.Golden.Generated.ClientPrekey_user.testObject_ClientPrekey_user_8, "testObject_ClientPrekey_user_8.json"), (Test.Wire.API.Golden.Generated.ClientPrekey_user.testObject_ClientPrekey_user_9, "testObject_ClientPrekey_user_9.json"), (Test.Wire.API.Golden.Generated.ClientPrekey_user.testObject_ClientPrekey_user_10, "testObject_ClientPrekey_user_10.json"), (Test.Wire.API.Golden.Generated.ClientPrekey_user.testObject_ClientPrekey_user_11, "testObject_ClientPrekey_user_11.json"), (Test.Wire.API.Golden.Generated.ClientPrekey_user.testObject_ClientPrekey_user_12, "testObject_ClientPrekey_user_12.json"), (Test.Wire.API.Golden.Generated.ClientPrekey_user.testObject_ClientPrekey_user_13, "testObject_ClientPrekey_user_13.json"), (Test.Wire.API.Golden.Generated.ClientPrekey_user.testObject_ClientPrekey_user_14, "testObject_ClientPrekey_user_14.json"), (Test.Wire.API.Golden.Generated.ClientPrekey_user.testObject_ClientPrekey_user_15, "testObject_ClientPrekey_user_15.json"), (Test.Wire.API.Golden.Generated.ClientPrekey_user.testObject_ClientPrekey_user_16, "testObject_ClientPrekey_user_16.json"), (Test.Wire.API.Golden.Generated.ClientPrekey_user.testObject_ClientPrekey_user_17, "testObject_ClientPrekey_user_17.json"), (Test.Wire.API.Golden.Generated.ClientPrekey_user.testObject_ClientPrekey_user_18, "testObject_ClientPrekey_user_18.json"), (Test.Wire.API.Golden.Generated.ClientPrekey_user.testObject_ClientPrekey_user_19, "testObject_ClientPrekey_user_19.json"), (Test.Wire.API.Golden.Generated.ClientPrekey_user.testObject_ClientPrekey_user_20, "testObject_ClientPrekey_user_20.json")],
      testGroup "Golden: PrekeyBundle_user" $
        testObjects [(Test.Wire.API.Golden.Generated.PrekeyBundle_user.testObject_PrekeyBundle_user_1, "testObject_PrekeyBundle_user_1.json"), (Test.Wire.API.Golden.Generated.PrekeyBundle_user.testObject_PrekeyBundle_user_2, "testObject_PrekeyBundle_user_2.json"), (Test.Wire.API.Golden.Generated.PrekeyBundle_user.testObject_PrekeyBundle_user_3, "testObject_PrekeyBundle_user_3.json"), (Test.Wire.API.Golden.Generated.PrekeyBundle_user.testObject_PrekeyBundle_user_4, "testObject_PrekeyBundle_user_4.json"), (Test.Wire.API.Golden.Generated.PrekeyBundle_user.testObject_PrekeyBundle_user_5, "testObject_PrekeyBundle_user_5.json"), (Test.Wire.API.Golden.Generated.PrekeyBundle_user.testObject_PrekeyBundle_user_6, "testObject_PrekeyBundle_user_6.json"), (Test.Wire.API.Golden.Generated.PrekeyBundle_user.testObject_PrekeyBundle_user_7, "testObject_PrekeyBundle_user_7.json"), (Test.Wire.API.Golden.Generated.PrekeyBundle_user.testObject_PrekeyBundle_user_8, "testObject_PrekeyBundle_user_8.json"), (Test.Wire.API.Golden.Generated.PrekeyBundle_user.testObject_PrekeyBundle_user_9, "testObject_PrekeyBundle_user_9.json"), (Test.Wire.API.Golden.Generated.PrekeyBundle_user.testObject_PrekeyBundle_user_10, "testObject_PrekeyBundle_user_10.json"), (Test.Wire.API.Golden.Generated.PrekeyBundle_user.testObject_PrekeyBundle_user_11, "testObject_PrekeyBundle_user_11.json"), (Test.Wire.API.Golden.Generated.PrekeyBundle_user.testObject_PrekeyBundle_user_12, "testObject_PrekeyBundle_user_12.json"), (Test.Wire.API.Golden.Generated.PrekeyBundle_user.testObject_PrekeyBundle_user_13, "testObject_PrekeyBundle_user_13.json"), (Test.Wire.API.Golden.Generated.PrekeyBundle_user.testObject_PrekeyBundle_user_14, "testObject_PrekeyBundle_user_14.json"), (Test.Wire.API.Golden.Generated.PrekeyBundle_user.testObject_PrekeyBundle_user_15, "testObject_PrekeyBundle_user_15.json"), (Test.Wire.API.Golden.Generated.PrekeyBundle_user.testObject_PrekeyBundle_user_16, "testObject_PrekeyBundle_user_16.json"), (Test.Wire.API.Golden.Generated.PrekeyBundle_user.testObject_PrekeyBundle_user_17, "testObject_PrekeyBundle_user_17.json"), (Test.Wire.API.Golden.Generated.PrekeyBundle_user.testObject_PrekeyBundle_user_18, "testObject_PrekeyBundle_user_18.json"), (Test.Wire.API.Golden.Generated.PrekeyBundle_user.testObject_PrekeyBundle_user_19, "testObject_PrekeyBundle_user_19.json"), (Test.Wire.API.Golden.Generated.PrekeyBundle_user.testObject_PrekeyBundle_user_20, "testObject_PrekeyBundle_user_20.json")],
      testGroup "Golden: UserHandleInfo_user" $
        testObjects [(Test.Wire.API.Golden.Generated.UserHandleInfo_user.testObject_UserHandleInfo_user_1, "testObject_UserHandleInfo_user_1.json"), (Test.Wire.API.Golden.Generated.UserHandleInfo_user.testObject_UserHandleInfo_user_2, "testObject_UserHandleInfo_user_2.json"), (Test.Wire.API.Golden.Generated.UserHandleInfo_user.testObject_UserHandleInfo_user_3, "testObject_UserHandleInfo_user_3.json"), (Test.Wire.API.Golden.Generated.UserHandleInfo_user.testObject_UserHandleInfo_user_4, "testObject_UserHandleInfo_user_4.json"), (Test.Wire.API.Golden.Generated.UserHandleInfo_user.testObject_UserHandleInfo_user_5, "testObject_UserHandleInfo_user_5.json"), (Test.Wire.API.Golden.Generated.UserHandleInfo_user.testObject_UserHandleInfo_user_6, "testObject_UserHandleInfo_user_6.json"), (Test.Wire.API.Golden.Generated.UserHandleInfo_user.testObject_UserHandleInfo_user_7, "testObject_UserHandleInfo_user_7.json"), (Test.Wire.API.Golden.Generated.UserHandleInfo_user.testObject_UserHandleInfo_user_8, "testObject_UserHandleInfo_user_8.json"), (Test.Wire.API.Golden.Generated.UserHandleInfo_user.testObject_UserHandleInfo_user_9, "testObject_UserHandleInfo_user_9.json"), (Test.Wire.API.Golden.Generated.UserHandleInfo_user.testObject_UserHandleInfo_user_10, "testObject_UserHandleInfo_user_10.json"), (Test.Wire.API.Golden.Generated.UserHandleInfo_user.testObject_UserHandleInfo_user_11, "testObject_UserHandleInfo_user_11.json"), (Test.Wire.API.Golden.Generated.UserHandleInfo_user.testObject_UserHandleInfo_user_12, "testObject_UserHandleInfo_user_12.json"), (Test.Wire.API.Golden.Generated.UserHandleInfo_user.testObject_UserHandleInfo_user_13, "testObject_UserHandleInfo_user_13.json"), (Test.Wire.API.Golden.Generated.UserHandleInfo_user.testObject_UserHandleInfo_user_14, "testObject_UserHandleInfo_user_14.json"), (Test.Wire.API.Golden.Generated.UserHandleInfo_user.testObject_UserHandleInfo_user_15, "testObject_UserHandleInfo_user_15.json"), (Test.Wire.API.Golden.Generated.UserHandleInfo_user.testObject_UserHandleInfo_user_16, "testObject_UserHandleInfo_user_16.json"), (Test.Wire.API.Golden.Generated.UserHandleInfo_user.testObject_UserHandleInfo_user_17, "testObject_UserHandleInfo_user_17.json"), (Test.Wire.API.Golden.Generated.UserHandleInfo_user.testObject_UserHandleInfo_user_18, "testObject_UserHandleInfo_user_18.json"), (Test.Wire.API.Golden.Generated.UserHandleInfo_user.testObject_UserHandleInfo_user_19, "testObject_UserHandleInfo_user_19.json"), (Test.Wire.API.Golden.Generated.UserHandleInfo_user.testObject_UserHandleInfo_user_20, "testObject_UserHandleInfo_user_20.json")],
      testGroup "Golden: CheckHandles_user" $
        testObjects [(Test.Wire.API.Golden.Generated.CheckHandles_user.testObject_CheckHandles_user_1, "testObject_CheckHandles_user_1.json"), (Test.Wire.API.Golden.Generated.CheckHandles_user.testObject_CheckHandles_user_2, "testObject_CheckHandles_user_2.json"), (Test.Wire.API.Golden.Generated.CheckHandles_user.testObject_CheckHandles_user_3, "testObject_CheckHandles_user_3.json"), (Test.Wire.API.Golden.Generated.CheckHandles_user.testObject_CheckHandles_user_4, "testObject_CheckHandles_user_4.json"), (Test.Wire.API.Golden.Generated.CheckHandles_user.testObject_CheckHandles_user_5, "testObject_CheckHandles_user_5.json"), (Test.Wire.API.Golden.Generated.CheckHandles_user.testObject_CheckHandles_user_6, "testObject_CheckHandles_user_6.json"), (Test.Wire.API.Golden.Generated.CheckHandles_user.testObject_CheckHandles_user_7, "testObject_CheckHandles_user_7.json"), (Test.Wire.API.Golden.Generated.CheckHandles_user.testObject_CheckHandles_user_8, "testObject_CheckHandles_user_8.json"), (Test.Wire.API.Golden.Generated.CheckHandles_user.testObject_CheckHandles_user_9, "testObject_CheckHandles_user_9.json"), (Test.Wire.API.Golden.Generated.CheckHandles_user.testObject_CheckHandles_user_10, "testObject_CheckHandles_user_10.json"), (Test.Wire.API.Golden.Generated.CheckHandles_user.testObject_CheckHandles_user_11, "testObject_CheckHandles_user_11.json"), (Test.Wire.API.Golden.Generated.CheckHandles_user.testObject_CheckHandles_user_12, "testObject_CheckHandles_user_12.json"), (Test.Wire.API.Golden.Generated.CheckHandles_user.testObject_CheckHandles_user_13, "testObject_CheckHandles_user_13.json"), (Test.Wire.API.Golden.Generated.CheckHandles_user.testObject_CheckHandles_user_14, "testObject_CheckHandles_user_14.json"), (Test.Wire.API.Golden.Generated.CheckHandles_user.testObject_CheckHandles_user_15, "testObject_CheckHandles_user_15.json"), (Test.Wire.API.Golden.Generated.CheckHandles_user.testObject_CheckHandles_user_16, "testObject_CheckHandles_user_16.json"), (Test.Wire.API.Golden.Generated.CheckHandles_user.testObject_CheckHandles_user_17, "testObject_CheckHandles_user_17.json"), (Test.Wire.API.Golden.Generated.CheckHandles_user.testObject_CheckHandles_user_18, "testObject_CheckHandles_user_18.json"), (Test.Wire.API.Golden.Generated.CheckHandles_user.testObject_CheckHandles_user_19, "testObject_CheckHandles_user_19.json"), (Test.Wire.API.Golden.Generated.CheckHandles_user.testObject_CheckHandles_user_20, "testObject_CheckHandles_user_20.json")],
      testGroup "Golden: Email_user" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.Email_user.testObject_Email_user_1, "testObject_Email_user_1.json")
          ],
      testGroup "Golden: Phone_user" $
        testObjects [(Test.Wire.API.Golden.Generated.Phone_user.testObject_Phone_user_1, "testObject_Phone_user_1.json"), (Test.Wire.API.Golden.Generated.Phone_user.testObject_Phone_user_2, "testObject_Phone_user_2.json"), (Test.Wire.API.Golden.Generated.Phone_user.testObject_Phone_user_3, "testObject_Phone_user_3.json"), (Test.Wire.API.Golden.Generated.Phone_user.testObject_Phone_user_4, "testObject_Phone_user_4.json"), (Test.Wire.API.Golden.Generated.Phone_user.testObject_Phone_user_5, "testObject_Phone_user_5.json"), (Test.Wire.API.Golden.Generated.Phone_user.testObject_Phone_user_6, "testObject_Phone_user_6.json"), (Test.Wire.API.Golden.Generated.Phone_user.testObject_Phone_user_7, "testObject_Phone_user_7.json"), (Test.Wire.API.Golden.Generated.Phone_user.testObject_Phone_user_8, "testObject_Phone_user_8.json"), (Test.Wire.API.Golden.Generated.Phone_user.testObject_Phone_user_9, "testObject_Phone_user_9.json"), (Test.Wire.API.Golden.Generated.Phone_user.testObject_Phone_user_10, "testObject_Phone_user_10.json"), (Test.Wire.API.Golden.Generated.Phone_user.testObject_Phone_user_11, "testObject_Phone_user_11.json"), (Test.Wire.API.Golden.Generated.Phone_user.testObject_Phone_user_12, "testObject_Phone_user_12.json"), (Test.Wire.API.Golden.Generated.Phone_user.testObject_Phone_user_13, "testObject_Phone_user_13.json"), (Test.Wire.API.Golden.Generated.Phone_user.testObject_Phone_user_14, "testObject_Phone_user_14.json"), (Test.Wire.API.Golden.Generated.Phone_user.testObject_Phone_user_15, "testObject_Phone_user_15.json"), (Test.Wire.API.Golden.Generated.Phone_user.testObject_Phone_user_16, "testObject_Phone_user_16.json"), (Test.Wire.API.Golden.Generated.Phone_user.testObject_Phone_user_17, "testObject_Phone_user_17.json"), (Test.Wire.API.Golden.Generated.Phone_user.testObject_Phone_user_18, "testObject_Phone_user_18.json"), (Test.Wire.API.Golden.Generated.Phone_user.testObject_Phone_user_19, "testObject_Phone_user_19.json"), (Test.Wire.API.Golden.Generated.Phone_user.testObject_Phone_user_20, "testObject_Phone_user_20.json")],
      testGroup "Golden: UserSSOId_user" $
        testObjects [(Test.Wire.API.Golden.Generated.UserSSOId_user.testObject_UserSSOId_user_2, "testObject_UserSSOId_user_2.json"), (Test.Wire.API.Golden.Generated.UserSSOId_user.testObject_UserSSOId_user_9, "testObject_UserSSOId_user_9.json"), (Test.Wire.API.Golden.Generated.UserSSOId_user.testObject_UserSSOId_user_13, "testObject_UserSSOId_user_13.json")],
      testGroup "Golden: NewPasswordReset_user" $
        testObjects [(Test.Wire.API.Golden.Generated.NewPasswordReset_user.testObject_NewPasswordReset_user_1, "testObject_NewPasswordReset_user_1.json")],
      testGroup "Golden: PasswordResetKey_user" $
        testObjects [(Test.Wire.API.Golden.Generated.PasswordResetKey_user.testObject_PasswordResetKey_user_1, "testObject_PasswordResetKey_user_1.json"), (Test.Wire.API.Golden.Generated.PasswordResetKey_user.testObject_PasswordResetKey_user_2, "testObject_PasswordResetKey_user_2.json"), (Test.Wire.API.Golden.Generated.PasswordResetKey_user.testObject_PasswordResetKey_user_3, "testObject_PasswordResetKey_user_3.json"), (Test.Wire.API.Golden.Generated.PasswordResetKey_user.testObject_PasswordResetKey_user_4, "testObject_PasswordResetKey_user_4.json"), (Test.Wire.API.Golden.Generated.PasswordResetKey_user.testObject_PasswordResetKey_user_5, "testObject_PasswordResetKey_user_5.json"), (Test.Wire.API.Golden.Generated.PasswordResetKey_user.testObject_PasswordResetKey_user_6, "testObject_PasswordResetKey_user_6.json"), (Test.Wire.API.Golden.Generated.PasswordResetKey_user.testObject_PasswordResetKey_user_7, "testObject_PasswordResetKey_user_7.json"), (Test.Wire.API.Golden.Generated.PasswordResetKey_user.testObject_PasswordResetKey_user_8, "testObject_PasswordResetKey_user_8.json"), (Test.Wire.API.Golden.Generated.PasswordResetKey_user.testObject_PasswordResetKey_user_9, "testObject_PasswordResetKey_user_9.json"), (Test.Wire.API.Golden.Generated.PasswordResetKey_user.testObject_PasswordResetKey_user_10, "testObject_PasswordResetKey_user_10.json"), (Test.Wire.API.Golden.Generated.PasswordResetKey_user.testObject_PasswordResetKey_user_11, "testObject_PasswordResetKey_user_11.json"), (Test.Wire.API.Golden.Generated.PasswordResetKey_user.testObject_PasswordResetKey_user_12, "testObject_PasswordResetKey_user_12.json"), (Test.Wire.API.Golden.Generated.PasswordResetKey_user.testObject_PasswordResetKey_user_13, "testObject_PasswordResetKey_user_13.json"), (Test.Wire.API.Golden.Generated.PasswordResetKey_user.testObject_PasswordResetKey_user_14, "testObject_PasswordResetKey_user_14.json"), (Test.Wire.API.Golden.Generated.PasswordResetKey_user.testObject_PasswordResetKey_user_15, "testObject_PasswordResetKey_user_15.json"), (Test.Wire.API.Golden.Generated.PasswordResetKey_user.testObject_PasswordResetKey_user_16, "testObject_PasswordResetKey_user_16.json"), (Test.Wire.API.Golden.Generated.PasswordResetKey_user.testObject_PasswordResetKey_user_17, "testObject_PasswordResetKey_user_17.json"), (Test.Wire.API.Golden.Generated.PasswordResetKey_user.testObject_PasswordResetKey_user_18, "testObject_PasswordResetKey_user_18.json"), (Test.Wire.API.Golden.Generated.PasswordResetKey_user.testObject_PasswordResetKey_user_19, "testObject_PasswordResetKey_user_19.json"), (Test.Wire.API.Golden.Generated.PasswordResetKey_user.testObject_PasswordResetKey_user_20, "testObject_PasswordResetKey_user_20.json")],
      testGroup "Golden: PasswordResetCode_user" $
        testObjects [(Test.Wire.API.Golden.Generated.PasswordResetCode_user.testObject_PasswordResetCode_user_1, "testObject_PasswordResetCode_user_1.json"), (Test.Wire.API.Golden.Generated.PasswordResetCode_user.testObject_PasswordResetCode_user_2, "testObject_PasswordResetCode_user_2.json"), (Test.Wire.API.Golden.Generated.PasswordResetCode_user.testObject_PasswordResetCode_user_3, "testObject_PasswordResetCode_user_3.json"), (Test.Wire.API.Golden.Generated.PasswordResetCode_user.testObject_PasswordResetCode_user_4, "testObject_PasswordResetCode_user_4.json"), (Test.Wire.API.Golden.Generated.PasswordResetCode_user.testObject_PasswordResetCode_user_5, "testObject_PasswordResetCode_user_5.json"), (Test.Wire.API.Golden.Generated.PasswordResetCode_user.testObject_PasswordResetCode_user_6, "testObject_PasswordResetCode_user_6.json"), (Test.Wire.API.Golden.Generated.PasswordResetCode_user.testObject_PasswordResetCode_user_7, "testObject_PasswordResetCode_user_7.json"), (Test.Wire.API.Golden.Generated.PasswordResetCode_user.testObject_PasswordResetCode_user_8, "testObject_PasswordResetCode_user_8.json"), (Test.Wire.API.Golden.Generated.PasswordResetCode_user.testObject_PasswordResetCode_user_9, "testObject_PasswordResetCode_user_9.json"), (Test.Wire.API.Golden.Generated.PasswordResetCode_user.testObject_PasswordResetCode_user_10, "testObject_PasswordResetCode_user_10.json"), (Test.Wire.API.Golden.Generated.PasswordResetCode_user.testObject_PasswordResetCode_user_11, "testObject_PasswordResetCode_user_11.json"), (Test.Wire.API.Golden.Generated.PasswordResetCode_user.testObject_PasswordResetCode_user_12, "testObject_PasswordResetCode_user_12.json"), (Test.Wire.API.Golden.Generated.PasswordResetCode_user.testObject_PasswordResetCode_user_13, "testObject_PasswordResetCode_user_13.json"), (Test.Wire.API.Golden.Generated.PasswordResetCode_user.testObject_PasswordResetCode_user_14, "testObject_PasswordResetCode_user_14.json"), (Test.Wire.API.Golden.Generated.PasswordResetCode_user.testObject_PasswordResetCode_user_15, "testObject_PasswordResetCode_user_15.json"), (Test.Wire.API.Golden.Generated.PasswordResetCode_user.testObject_PasswordResetCode_user_16, "testObject_PasswordResetCode_user_16.json"), (Test.Wire.API.Golden.Generated.PasswordResetCode_user.testObject_PasswordResetCode_user_17, "testObject_PasswordResetCode_user_17.json"), (Test.Wire.API.Golden.Generated.PasswordResetCode_user.testObject_PasswordResetCode_user_18, "testObject_PasswordResetCode_user_18.json"), (Test.Wire.API.Golden.Generated.PasswordResetCode_user.testObject_PasswordResetCode_user_19, "testObject_PasswordResetCode_user_19.json"), (Test.Wire.API.Golden.Generated.PasswordResetCode_user.testObject_PasswordResetCode_user_20, "testObject_PasswordResetCode_user_20.json")],
      testGroup "Golden: CompletePasswordReset_user" $
        testObjects [(Test.Wire.API.Golden.Generated.CompletePasswordReset_user.testObject_CompletePasswordReset_user_1, "testObject_CompletePasswordReset_user_1.json"), (Test.Wire.API.Golden.Generated.CompletePasswordReset_user.testObject_CompletePasswordReset_user_2, "testObject_CompletePasswordReset_user_2.json"), (Test.Wire.API.Golden.Generated.CompletePasswordReset_user.testObject_CompletePasswordReset_user_3, "testObject_CompletePasswordReset_user_3.json"), (Test.Wire.API.Golden.Generated.CompletePasswordReset_user.testObject_CompletePasswordReset_user_4, "testObject_CompletePasswordReset_user_4.json"), (Test.Wire.API.Golden.Generated.CompletePasswordReset_user.testObject_CompletePasswordReset_user_5, "testObject_CompletePasswordReset_user_5.json"), (Test.Wire.API.Golden.Generated.CompletePasswordReset_user.testObject_CompletePasswordReset_user_6, "testObject_CompletePasswordReset_user_6.json"), (Test.Wire.API.Golden.Generated.CompletePasswordReset_user.testObject_CompletePasswordReset_user_7, "testObject_CompletePasswordReset_user_7.json"), (Test.Wire.API.Golden.Generated.CompletePasswordReset_user.testObject_CompletePasswordReset_user_8, "testObject_CompletePasswordReset_user_8.json"), (Test.Wire.API.Golden.Generated.CompletePasswordReset_user.testObject_CompletePasswordReset_user_9, "testObject_CompletePasswordReset_user_9.json"), (Test.Wire.API.Golden.Generated.CompletePasswordReset_user.testObject_CompletePasswordReset_user_10, "testObject_CompletePasswordReset_user_10.json"), (Test.Wire.API.Golden.Generated.CompletePasswordReset_user.testObject_CompletePasswordReset_user_11, "testObject_CompletePasswordReset_user_11.json"), (Test.Wire.API.Golden.Generated.CompletePasswordReset_user.testObject_CompletePasswordReset_user_12, "testObject_CompletePasswordReset_user_12.json"), (Test.Wire.API.Golden.Generated.CompletePasswordReset_user.testObject_CompletePasswordReset_user_13, "testObject_CompletePasswordReset_user_13.json"), (Test.Wire.API.Golden.Generated.CompletePasswordReset_user.testObject_CompletePasswordReset_user_14, "testObject_CompletePasswordReset_user_14.json"), (Test.Wire.API.Golden.Generated.CompletePasswordReset_user.testObject_CompletePasswordReset_user_15, "testObject_CompletePasswordReset_user_15.json"), (Test.Wire.API.Golden.Generated.CompletePasswordReset_user.testObject_CompletePasswordReset_user_16, "testObject_CompletePasswordReset_user_16.json"), (Test.Wire.API.Golden.Generated.CompletePasswordReset_user.testObject_CompletePasswordReset_user_17, "testObject_CompletePasswordReset_user_17.json"), (Test.Wire.API.Golden.Generated.CompletePasswordReset_user.testObject_CompletePasswordReset_user_18, "testObject_CompletePasswordReset_user_18.json"), (Test.Wire.API.Golden.Generated.CompletePasswordReset_user.testObject_CompletePasswordReset_user_19, "testObject_CompletePasswordReset_user_19.json"), (Test.Wire.API.Golden.Generated.CompletePasswordReset_user.testObject_CompletePasswordReset_user_20, "testObject_CompletePasswordReset_user_20.json")],
      testGroup "Golden: Pict_user" $
        testObjects [(Test.Wire.API.Golden.Generated.Pict_user.testObject_Pict_user_1, "testObject_Pict_user_1.json"), (Test.Wire.API.Golden.Generated.Pict_user.testObject_Pict_user_2, "testObject_Pict_user_2.json"), (Test.Wire.API.Golden.Generated.Pict_user.testObject_Pict_user_3, "testObject_Pict_user_3.json"), (Test.Wire.API.Golden.Generated.Pict_user.testObject_Pict_user_4, "testObject_Pict_user_4.json"), (Test.Wire.API.Golden.Generated.Pict_user.testObject_Pict_user_5, "testObject_Pict_user_5.json"), (Test.Wire.API.Golden.Generated.Pict_user.testObject_Pict_user_6, "testObject_Pict_user_6.json"), (Test.Wire.API.Golden.Generated.Pict_user.testObject_Pict_user_7, "testObject_Pict_user_7.json"), (Test.Wire.API.Golden.Generated.Pict_user.testObject_Pict_user_8, "testObject_Pict_user_8.json"), (Test.Wire.API.Golden.Generated.Pict_user.testObject_Pict_user_9, "testObject_Pict_user_9.json"), (Test.Wire.API.Golden.Generated.Pict_user.testObject_Pict_user_10, "testObject_Pict_user_10.json"), (Test.Wire.API.Golden.Generated.Pict_user.testObject_Pict_user_11, "testObject_Pict_user_11.json"), (Test.Wire.API.Golden.Generated.Pict_user.testObject_Pict_user_12, "testObject_Pict_user_12.json"), (Test.Wire.API.Golden.Generated.Pict_user.testObject_Pict_user_13, "testObject_Pict_user_13.json"), (Test.Wire.API.Golden.Generated.Pict_user.testObject_Pict_user_14, "testObject_Pict_user_14.json"), (Test.Wire.API.Golden.Generated.Pict_user.testObject_Pict_user_15, "testObject_Pict_user_15.json"), (Test.Wire.API.Golden.Generated.Pict_user.testObject_Pict_user_16, "testObject_Pict_user_16.json"), (Test.Wire.API.Golden.Generated.Pict_user.testObject_Pict_user_17, "testObject_Pict_user_17.json"), (Test.Wire.API.Golden.Generated.Pict_user.testObject_Pict_user_18, "testObject_Pict_user_18.json"), (Test.Wire.API.Golden.Generated.Pict_user.testObject_Pict_user_19, "testObject_Pict_user_19.json"), (Test.Wire.API.Golden.Generated.Pict_user.testObject_Pict_user_20, "testObject_Pict_user_20.json")],
      testGroup "Golden: Name_user" $
        testObjects [(Test.Wire.API.Golden.Generated.Name_user.testObject_Name_user_1, "testObject_Name_user_1.json"), (Test.Wire.API.Golden.Generated.Name_user.testObject_Name_user_2, "testObject_Name_user_2.json"), (Test.Wire.API.Golden.Generated.Name_user.testObject_Name_user_3, "testObject_Name_user_3.json"), (Test.Wire.API.Golden.Generated.Name_user.testObject_Name_user_4, "testObject_Name_user_4.json"), (Test.Wire.API.Golden.Generated.Name_user.testObject_Name_user_5, "testObject_Name_user_5.json"), (Test.Wire.API.Golden.Generated.Name_user.testObject_Name_user_6, "testObject_Name_user_6.json"), (Test.Wire.API.Golden.Generated.Name_user.testObject_Name_user_7, "testObject_Name_user_7.json"), (Test.Wire.API.Golden.Generated.Name_user.testObject_Name_user_8, "testObject_Name_user_8.json"), (Test.Wire.API.Golden.Generated.Name_user.testObject_Name_user_9, "testObject_Name_user_9.json"), (Test.Wire.API.Golden.Generated.Name_user.testObject_Name_user_10, "testObject_Name_user_10.json"), (Test.Wire.API.Golden.Generated.Name_user.testObject_Name_user_11, "testObject_Name_user_11.json"), (Test.Wire.API.Golden.Generated.Name_user.testObject_Name_user_12, "testObject_Name_user_12.json"), (Test.Wire.API.Golden.Generated.Name_user.testObject_Name_user_13, "testObject_Name_user_13.json"), (Test.Wire.API.Golden.Generated.Name_user.testObject_Name_user_14, "testObject_Name_user_14.json"), (Test.Wire.API.Golden.Generated.Name_user.testObject_Name_user_15, "testObject_Name_user_15.json"), (Test.Wire.API.Golden.Generated.Name_user.testObject_Name_user_16, "testObject_Name_user_16.json"), (Test.Wire.API.Golden.Generated.Name_user.testObject_Name_user_17, "testObject_Name_user_17.json"), (Test.Wire.API.Golden.Generated.Name_user.testObject_Name_user_18, "testObject_Name_user_18.json"), (Test.Wire.API.Golden.Generated.Name_user.testObject_Name_user_19, "testObject_Name_user_19.json"), (Test.Wire.API.Golden.Generated.Name_user.testObject_Name_user_20, "testObject_Name_user_20.json")],
      testGroup "Golden: ColourId_user" $
        testObjects [(Test.Wire.API.Golden.Generated.ColourId_user.testObject_ColourId_user_1, "testObject_ColourId_user_1.json"), (Test.Wire.API.Golden.Generated.ColourId_user.testObject_ColourId_user_2, "testObject_ColourId_user_2.json"), (Test.Wire.API.Golden.Generated.ColourId_user.testObject_ColourId_user_3, "testObject_ColourId_user_3.json"), (Test.Wire.API.Golden.Generated.ColourId_user.testObject_ColourId_user_4, "testObject_ColourId_user_4.json"), (Test.Wire.API.Golden.Generated.ColourId_user.testObject_ColourId_user_5, "testObject_ColourId_user_5.json"), (Test.Wire.API.Golden.Generated.ColourId_user.testObject_ColourId_user_6, "testObject_ColourId_user_6.json"), (Test.Wire.API.Golden.Generated.ColourId_user.testObject_ColourId_user_7, "testObject_ColourId_user_7.json"), (Test.Wire.API.Golden.Generated.ColourId_user.testObject_ColourId_user_8, "testObject_ColourId_user_8.json"), (Test.Wire.API.Golden.Generated.ColourId_user.testObject_ColourId_user_9, "testObject_ColourId_user_9.json"), (Test.Wire.API.Golden.Generated.ColourId_user.testObject_ColourId_user_10, "testObject_ColourId_user_10.json"), (Test.Wire.API.Golden.Generated.ColourId_user.testObject_ColourId_user_11, "testObject_ColourId_user_11.json"), (Test.Wire.API.Golden.Generated.ColourId_user.testObject_ColourId_user_12, "testObject_ColourId_user_12.json"), (Test.Wire.API.Golden.Generated.ColourId_user.testObject_ColourId_user_13, "testObject_ColourId_user_13.json"), (Test.Wire.API.Golden.Generated.ColourId_user.testObject_ColourId_user_14, "testObject_ColourId_user_14.json"), (Test.Wire.API.Golden.Generated.ColourId_user.testObject_ColourId_user_15, "testObject_ColourId_user_15.json"), (Test.Wire.API.Golden.Generated.ColourId_user.testObject_ColourId_user_16, "testObject_ColourId_user_16.json"), (Test.Wire.API.Golden.Generated.ColourId_user.testObject_ColourId_user_17, "testObject_ColourId_user_17.json"), (Test.Wire.API.Golden.Generated.ColourId_user.testObject_ColourId_user_18, "testObject_ColourId_user_18.json"), (Test.Wire.API.Golden.Generated.ColourId_user.testObject_ColourId_user_19, "testObject_ColourId_user_19.json"), (Test.Wire.API.Golden.Generated.ColourId_user.testObject_ColourId_user_20, "testObject_ColourId_user_20.json")],
      testGroup "Golden: AssetSize_user" $
        testObjects [(Test.Wire.API.Golden.Generated.AssetSize_user.testObject_AssetSize_user_1, "testObject_AssetSize_user_1.json"), (Test.Wire.API.Golden.Generated.AssetSize_user.testObject_AssetSize_user_2, "testObject_AssetSize_user_2.json"), (Test.Wire.API.Golden.Generated.AssetSize_user.testObject_AssetSize_user_3, "testObject_AssetSize_user_3.json"), (Test.Wire.API.Golden.Generated.AssetSize_user.testObject_AssetSize_user_4, "testObject_AssetSize_user_4.json"), (Test.Wire.API.Golden.Generated.AssetSize_user.testObject_AssetSize_user_5, "testObject_AssetSize_user_5.json"), (Test.Wire.API.Golden.Generated.AssetSize_user.testObject_AssetSize_user_6, "testObject_AssetSize_user_6.json"), (Test.Wire.API.Golden.Generated.AssetSize_user.testObject_AssetSize_user_7, "testObject_AssetSize_user_7.json"), (Test.Wire.API.Golden.Generated.AssetSize_user.testObject_AssetSize_user_8, "testObject_AssetSize_user_8.json"), (Test.Wire.API.Golden.Generated.AssetSize_user.testObject_AssetSize_user_9, "testObject_AssetSize_user_9.json"), (Test.Wire.API.Golden.Generated.AssetSize_user.testObject_AssetSize_user_10, "testObject_AssetSize_user_10.json"), (Test.Wire.API.Golden.Generated.AssetSize_user.testObject_AssetSize_user_11, "testObject_AssetSize_user_11.json"), (Test.Wire.API.Golden.Generated.AssetSize_user.testObject_AssetSize_user_12, "testObject_AssetSize_user_12.json"), (Test.Wire.API.Golden.Generated.AssetSize_user.testObject_AssetSize_user_13, "testObject_AssetSize_user_13.json"), (Test.Wire.API.Golden.Generated.AssetSize_user.testObject_AssetSize_user_14, "testObject_AssetSize_user_14.json"), (Test.Wire.API.Golden.Generated.AssetSize_user.testObject_AssetSize_user_15, "testObject_AssetSize_user_15.json"), (Test.Wire.API.Golden.Generated.AssetSize_user.testObject_AssetSize_user_16, "testObject_AssetSize_user_16.json"), (Test.Wire.API.Golden.Generated.AssetSize_user.testObject_AssetSize_user_17, "testObject_AssetSize_user_17.json"), (Test.Wire.API.Golden.Generated.AssetSize_user.testObject_AssetSize_user_18, "testObject_AssetSize_user_18.json"), (Test.Wire.API.Golden.Generated.AssetSize_user.testObject_AssetSize_user_19, "testObject_AssetSize_user_19.json"), (Test.Wire.API.Golden.Generated.AssetSize_user.testObject_AssetSize_user_20, "testObject_AssetSize_user_20.json")],
      testGroup "Golden: User_2eProfile_2eAsset_user" $
        testObjects [(Test.Wire.API.Golden.Generated.User_2eProfile_2eAsset_user.testObject_User_2eProfile_2eAsset_user_1, "testObject_User_2eProfile_2eAsset_user_1.json"), (Test.Wire.API.Golden.Generated.User_2eProfile_2eAsset_user.testObject_User_2eProfile_2eAsset_user_2, "testObject_User_2eProfile_2eAsset_user_2.json"), (Test.Wire.API.Golden.Generated.User_2eProfile_2eAsset_user.testObject_User_2eProfile_2eAsset_user_3, "testObject_User_2eProfile_2eAsset_user_3.json"), (Test.Wire.API.Golden.Generated.User_2eProfile_2eAsset_user.testObject_User_2eProfile_2eAsset_user_4, "testObject_User_2eProfile_2eAsset_user_4.json"), (Test.Wire.API.Golden.Generated.User_2eProfile_2eAsset_user.testObject_User_2eProfile_2eAsset_user_5, "testObject_User_2eProfile_2eAsset_user_5.json"), (Test.Wire.API.Golden.Generated.User_2eProfile_2eAsset_user.testObject_User_2eProfile_2eAsset_user_6, "testObject_User_2eProfile_2eAsset_user_6.json"), (Test.Wire.API.Golden.Generated.User_2eProfile_2eAsset_user.testObject_User_2eProfile_2eAsset_user_7, "testObject_User_2eProfile_2eAsset_user_7.json"), (Test.Wire.API.Golden.Generated.User_2eProfile_2eAsset_user.testObject_User_2eProfile_2eAsset_user_8, "testObject_User_2eProfile_2eAsset_user_8.json"), (Test.Wire.API.Golden.Generated.User_2eProfile_2eAsset_user.testObject_User_2eProfile_2eAsset_user_9, "testObject_User_2eProfile_2eAsset_user_9.json"), (Test.Wire.API.Golden.Generated.User_2eProfile_2eAsset_user.testObject_User_2eProfile_2eAsset_user_10, "testObject_User_2eProfile_2eAsset_user_10.json"), (Test.Wire.API.Golden.Generated.User_2eProfile_2eAsset_user.testObject_User_2eProfile_2eAsset_user_11, "testObject_User_2eProfile_2eAsset_user_11.json"), (Test.Wire.API.Golden.Generated.User_2eProfile_2eAsset_user.testObject_User_2eProfile_2eAsset_user_12, "testObject_User_2eProfile_2eAsset_user_12.json"), (Test.Wire.API.Golden.Generated.User_2eProfile_2eAsset_user.testObject_User_2eProfile_2eAsset_user_13, "testObject_User_2eProfile_2eAsset_user_13.json"), (Test.Wire.API.Golden.Generated.User_2eProfile_2eAsset_user.testObject_User_2eProfile_2eAsset_user_14, "testObject_User_2eProfile_2eAsset_user_14.json"), (Test.Wire.API.Golden.Generated.User_2eProfile_2eAsset_user.testObject_User_2eProfile_2eAsset_user_15, "testObject_User_2eProfile_2eAsset_user_15.json"), (Test.Wire.API.Golden.Generated.User_2eProfile_2eAsset_user.testObject_User_2eProfile_2eAsset_user_16, "testObject_User_2eProfile_2eAsset_user_16.json"), (Test.Wire.API.Golden.Generated.User_2eProfile_2eAsset_user.testObject_User_2eProfile_2eAsset_user_17, "testObject_User_2eProfile_2eAsset_user_17.json"), (Test.Wire.API.Golden.Generated.User_2eProfile_2eAsset_user.testObject_User_2eProfile_2eAsset_user_18, "testObject_User_2eProfile_2eAsset_user_18.json"), (Test.Wire.API.Golden.Generated.User_2eProfile_2eAsset_user.testObject_User_2eProfile_2eAsset_user_19, "testObject_User_2eProfile_2eAsset_user_19.json"), (Test.Wire.API.Golden.Generated.User_2eProfile_2eAsset_user.testObject_User_2eProfile_2eAsset_user_20, "testObject_User_2eProfile_2eAsset_user_20.json")],
      testGroup "Golden: Locale_user" $
        testObjects [(Test.Wire.API.Golden.Generated.Locale_user.testObject_Locale_user_1, "testObject_Locale_user_1.json"), (Test.Wire.API.Golden.Generated.Locale_user.testObject_Locale_user_2, "testObject_Locale_user_2.json"), (Test.Wire.API.Golden.Generated.Locale_user.testObject_Locale_user_3, "testObject_Locale_user_3.json"), (Test.Wire.API.Golden.Generated.Locale_user.testObject_Locale_user_4, "testObject_Locale_user_4.json"), (Test.Wire.API.Golden.Generated.Locale_user.testObject_Locale_user_5, "testObject_Locale_user_5.json"), (Test.Wire.API.Golden.Generated.Locale_user.testObject_Locale_user_6, "testObject_Locale_user_6.json"), (Test.Wire.API.Golden.Generated.Locale_user.testObject_Locale_user_7, "testObject_Locale_user_7.json"), (Test.Wire.API.Golden.Generated.Locale_user.testObject_Locale_user_8, "testObject_Locale_user_8.json"), (Test.Wire.API.Golden.Generated.Locale_user.testObject_Locale_user_9, "testObject_Locale_user_9.json"), (Test.Wire.API.Golden.Generated.Locale_user.testObject_Locale_user_10, "testObject_Locale_user_10.json"), (Test.Wire.API.Golden.Generated.Locale_user.testObject_Locale_user_11, "testObject_Locale_user_11.json"), (Test.Wire.API.Golden.Generated.Locale_user.testObject_Locale_user_12, "testObject_Locale_user_12.json"), (Test.Wire.API.Golden.Generated.Locale_user.testObject_Locale_user_13, "testObject_Locale_user_13.json"), (Test.Wire.API.Golden.Generated.Locale_user.testObject_Locale_user_14, "testObject_Locale_user_14.json"), (Test.Wire.API.Golden.Generated.Locale_user.testObject_Locale_user_15, "testObject_Locale_user_15.json"), (Test.Wire.API.Golden.Generated.Locale_user.testObject_Locale_user_16, "testObject_Locale_user_16.json"), (Test.Wire.API.Golden.Generated.Locale_user.testObject_Locale_user_17, "testObject_Locale_user_17.json"), (Test.Wire.API.Golden.Generated.Locale_user.testObject_Locale_user_18, "testObject_Locale_user_18.json"), (Test.Wire.API.Golden.Generated.Locale_user.testObject_Locale_user_19, "testObject_Locale_user_19.json"), (Test.Wire.API.Golden.Generated.Locale_user.testObject_Locale_user_20, "testObject_Locale_user_20.json")],
      testGroup "Golden: ManagedBy_user" $
        testObjects [(Test.Wire.API.Golden.Generated.ManagedBy_user.testObject_ManagedBy_user_1, "testObject_ManagedBy_user_1.json"), (Test.Wire.API.Golden.Generated.ManagedBy_user.testObject_ManagedBy_user_2, "testObject_ManagedBy_user_2.json"), (Test.Wire.API.Golden.Generated.ManagedBy_user.testObject_ManagedBy_user_3, "testObject_ManagedBy_user_3.json"), (Test.Wire.API.Golden.Generated.ManagedBy_user.testObject_ManagedBy_user_4, "testObject_ManagedBy_user_4.json"), (Test.Wire.API.Golden.Generated.ManagedBy_user.testObject_ManagedBy_user_5, "testObject_ManagedBy_user_5.json"), (Test.Wire.API.Golden.Generated.ManagedBy_user.testObject_ManagedBy_user_6, "testObject_ManagedBy_user_6.json"), (Test.Wire.API.Golden.Generated.ManagedBy_user.testObject_ManagedBy_user_7, "testObject_ManagedBy_user_7.json"), (Test.Wire.API.Golden.Generated.ManagedBy_user.testObject_ManagedBy_user_8, "testObject_ManagedBy_user_8.json"), (Test.Wire.API.Golden.Generated.ManagedBy_user.testObject_ManagedBy_user_9, "testObject_ManagedBy_user_9.json"), (Test.Wire.API.Golden.Generated.ManagedBy_user.testObject_ManagedBy_user_10, "testObject_ManagedBy_user_10.json"), (Test.Wire.API.Golden.Generated.ManagedBy_user.testObject_ManagedBy_user_11, "testObject_ManagedBy_user_11.json"), (Test.Wire.API.Golden.Generated.ManagedBy_user.testObject_ManagedBy_user_12, "testObject_ManagedBy_user_12.json"), (Test.Wire.API.Golden.Generated.ManagedBy_user.testObject_ManagedBy_user_13, "testObject_ManagedBy_user_13.json"), (Test.Wire.API.Golden.Generated.ManagedBy_user.testObject_ManagedBy_user_14, "testObject_ManagedBy_user_14.json"), (Test.Wire.API.Golden.Generated.ManagedBy_user.testObject_ManagedBy_user_15, "testObject_ManagedBy_user_15.json"), (Test.Wire.API.Golden.Generated.ManagedBy_user.testObject_ManagedBy_user_16, "testObject_ManagedBy_user_16.json"), (Test.Wire.API.Golden.Generated.ManagedBy_user.testObject_ManagedBy_user_17, "testObject_ManagedBy_user_17.json"), (Test.Wire.API.Golden.Generated.ManagedBy_user.testObject_ManagedBy_user_18, "testObject_ManagedBy_user_18.json"), (Test.Wire.API.Golden.Generated.ManagedBy_user.testObject_ManagedBy_user_19, "testObject_ManagedBy_user_19.json"), (Test.Wire.API.Golden.Generated.ManagedBy_user.testObject_ManagedBy_user_20, "testObject_ManagedBy_user_20.json")],
      testGroup "Golden: RichField_user" $
        testObjects [(Test.Wire.API.Golden.Generated.RichField_user.testObject_RichField_user_1, "testObject_RichField_user_1.json"), (Test.Wire.API.Golden.Generated.RichField_user.testObject_RichField_user_2, "testObject_RichField_user_2.json"), (Test.Wire.API.Golden.Generated.RichField_user.testObject_RichField_user_3, "testObject_RichField_user_3.json"), (Test.Wire.API.Golden.Generated.RichField_user.testObject_RichField_user_4, "testObject_RichField_user_4.json"), (Test.Wire.API.Golden.Generated.RichField_user.testObject_RichField_user_5, "testObject_RichField_user_5.json"), (Test.Wire.API.Golden.Generated.RichField_user.testObject_RichField_user_6, "testObject_RichField_user_6.json"), (Test.Wire.API.Golden.Generated.RichField_user.testObject_RichField_user_7, "testObject_RichField_user_7.json"), (Test.Wire.API.Golden.Generated.RichField_user.testObject_RichField_user_8, "testObject_RichField_user_8.json"), (Test.Wire.API.Golden.Generated.RichField_user.testObject_RichField_user_9, "testObject_RichField_user_9.json"), (Test.Wire.API.Golden.Generated.RichField_user.testObject_RichField_user_10, "testObject_RichField_user_10.json"), (Test.Wire.API.Golden.Generated.RichField_user.testObject_RichField_user_11, "testObject_RichField_user_11.json"), (Test.Wire.API.Golden.Generated.RichField_user.testObject_RichField_user_12, "testObject_RichField_user_12.json"), (Test.Wire.API.Golden.Generated.RichField_user.testObject_RichField_user_13, "testObject_RichField_user_13.json"), (Test.Wire.API.Golden.Generated.RichField_user.testObject_RichField_user_14, "testObject_RichField_user_14.json"), (Test.Wire.API.Golden.Generated.RichField_user.testObject_RichField_user_15, "testObject_RichField_user_15.json"), (Test.Wire.API.Golden.Generated.RichField_user.testObject_RichField_user_16, "testObject_RichField_user_16.json"), (Test.Wire.API.Golden.Generated.RichField_user.testObject_RichField_user_17, "testObject_RichField_user_17.json"), (Test.Wire.API.Golden.Generated.RichField_user.testObject_RichField_user_18, "testObject_RichField_user_18.json"), (Test.Wire.API.Golden.Generated.RichField_user.testObject_RichField_user_19, "testObject_RichField_user_19.json"), (Test.Wire.API.Golden.Generated.RichField_user.testObject_RichField_user_20, "testObject_RichField_user_20.json")],
      testGroup "Golden: RichInfoAssocList_user" $
        testObjects [(Test.Wire.API.Golden.Generated.RichInfoAssocList_user.testObject_RichInfoAssocList_user_1, "testObject_RichInfoAssocList_user_1.json"), (Test.Wire.API.Golden.Generated.RichInfoAssocList_user.testObject_RichInfoAssocList_user_2, "testObject_RichInfoAssocList_user_2.json"), (Test.Wire.API.Golden.Generated.RichInfoAssocList_user.testObject_RichInfoAssocList_user_3, "testObject_RichInfoAssocList_user_3.json"), (Test.Wire.API.Golden.Generated.RichInfoAssocList_user.testObject_RichInfoAssocList_user_4, "testObject_RichInfoAssocList_user_4.json"), (Test.Wire.API.Golden.Generated.RichInfoAssocList_user.testObject_RichInfoAssocList_user_5, "testObject_RichInfoAssocList_user_5.json"), (Test.Wire.API.Golden.Generated.RichInfoAssocList_user.testObject_RichInfoAssocList_user_6, "testObject_RichInfoAssocList_user_6.json"), (Test.Wire.API.Golden.Generated.RichInfoAssocList_user.testObject_RichInfoAssocList_user_7, "testObject_RichInfoAssocList_user_7.json"), (Test.Wire.API.Golden.Generated.RichInfoAssocList_user.testObject_RichInfoAssocList_user_8, "testObject_RichInfoAssocList_user_8.json"), (Test.Wire.API.Golden.Generated.RichInfoAssocList_user.testObject_RichInfoAssocList_user_9, "testObject_RichInfoAssocList_user_9.json"), (Test.Wire.API.Golden.Generated.RichInfoAssocList_user.testObject_RichInfoAssocList_user_10, "testObject_RichInfoAssocList_user_10.json"), (Test.Wire.API.Golden.Generated.RichInfoAssocList_user.testObject_RichInfoAssocList_user_11, "testObject_RichInfoAssocList_user_11.json"), (Test.Wire.API.Golden.Generated.RichInfoAssocList_user.testObject_RichInfoAssocList_user_12, "testObject_RichInfoAssocList_user_12.json"), (Test.Wire.API.Golden.Generated.RichInfoAssocList_user.testObject_RichInfoAssocList_user_13, "testObject_RichInfoAssocList_user_13.json"), (Test.Wire.API.Golden.Generated.RichInfoAssocList_user.testObject_RichInfoAssocList_user_14, "testObject_RichInfoAssocList_user_14.json"), (Test.Wire.API.Golden.Generated.RichInfoAssocList_user.testObject_RichInfoAssocList_user_15, "testObject_RichInfoAssocList_user_15.json"), (Test.Wire.API.Golden.Generated.RichInfoAssocList_user.testObject_RichInfoAssocList_user_16, "testObject_RichInfoAssocList_user_16.json"), (Test.Wire.API.Golden.Generated.RichInfoAssocList_user.testObject_RichInfoAssocList_user_17, "testObject_RichInfoAssocList_user_17.json"), (Test.Wire.API.Golden.Generated.RichInfoAssocList_user.testObject_RichInfoAssocList_user_18, "testObject_RichInfoAssocList_user_18.json"), (Test.Wire.API.Golden.Generated.RichInfoAssocList_user.testObject_RichInfoAssocList_user_19, "testObject_RichInfoAssocList_user_19.json"), (Test.Wire.API.Golden.Generated.RichInfoAssocList_user.testObject_RichInfoAssocList_user_20, "testObject_RichInfoAssocList_user_20.json")],
      testGroup "Golden: RichInfo_user" $
        testObjects [(Test.Wire.API.Golden.Generated.RichInfo_user.testObject_RichInfo_user_1, "testObject_RichInfo_user_1.json"), (Test.Wire.API.Golden.Generated.RichInfo_user.testObject_RichInfo_user_2, "testObject_RichInfo_user_2.json"), (Test.Wire.API.Golden.Generated.RichInfo_user.testObject_RichInfo_user_3, "testObject_RichInfo_user_3.json"), (Test.Wire.API.Golden.Generated.RichInfo_user.testObject_RichInfo_user_4, "testObject_RichInfo_user_4.json"), (Test.Wire.API.Golden.Generated.RichInfo_user.testObject_RichInfo_user_5, "testObject_RichInfo_user_5.json"), (Test.Wire.API.Golden.Generated.RichInfo_user.testObject_RichInfo_user_6, "testObject_RichInfo_user_6.json"), (Test.Wire.API.Golden.Generated.RichInfo_user.testObject_RichInfo_user_7, "testObject_RichInfo_user_7.json"), (Test.Wire.API.Golden.Generated.RichInfo_user.testObject_RichInfo_user_8, "testObject_RichInfo_user_8.json"), (Test.Wire.API.Golden.Generated.RichInfo_user.testObject_RichInfo_user_9, "testObject_RichInfo_user_9.json"), (Test.Wire.API.Golden.Generated.RichInfo_user.testObject_RichInfo_user_10, "testObject_RichInfo_user_10.json"), (Test.Wire.API.Golden.Generated.RichInfo_user.testObject_RichInfo_user_11, "testObject_RichInfo_user_11.json"), (Test.Wire.API.Golden.Generated.RichInfo_user.testObject_RichInfo_user_12, "testObject_RichInfo_user_12.json"), (Test.Wire.API.Golden.Generated.RichInfo_user.testObject_RichInfo_user_13, "testObject_RichInfo_user_13.json"), (Test.Wire.API.Golden.Generated.RichInfo_user.testObject_RichInfo_user_14, "testObject_RichInfo_user_14.json"), (Test.Wire.API.Golden.Generated.RichInfo_user.testObject_RichInfo_user_15, "testObject_RichInfo_user_15.json"), (Test.Wire.API.Golden.Generated.RichInfo_user.testObject_RichInfo_user_16, "testObject_RichInfo_user_16.json"), (Test.Wire.API.Golden.Generated.RichInfo_user.testObject_RichInfo_user_17, "testObject_RichInfo_user_17.json"), (Test.Wire.API.Golden.Generated.RichInfo_user.testObject_RichInfo_user_18, "testObject_RichInfo_user_18.json"), (Test.Wire.API.Golden.Generated.RichInfo_user.testObject_RichInfo_user_19, "testObject_RichInfo_user_19.json"), (Test.Wire.API.Golden.Generated.RichInfo_user.testObject_RichInfo_user_20, "testObject_RichInfo_user_20.json")],
      testGroup "Golden: SearchResult_20Contact_user" $
        testObjects [(Test.Wire.API.Golden.Generated.SearchResult_20Contact_user.testObject_SearchResult_20Contact_user_1, "testObject_SearchResult_20Contact_user_1.json"), (Test.Wire.API.Golden.Generated.SearchResult_20Contact_user.testObject_SearchResult_20Contact_user_2, "testObject_SearchResult_20Contact_user_2.json"), (Test.Wire.API.Golden.Generated.SearchResult_20Contact_user.testObject_SearchResult_20Contact_user_3, "testObject_SearchResult_20Contact_user_3.json"), (Test.Wire.API.Golden.Generated.SearchResult_20Contact_user.testObject_SearchResult_20Contact_user_4, "testObject_SearchResult_20Contact_user_4.json"), (Test.Wire.API.Golden.Generated.SearchResult_20Contact_user.testObject_SearchResult_20Contact_user_5, "testObject_SearchResult_20Contact_user_5.json"), (Test.Wire.API.Golden.Generated.SearchResult_20Contact_user.testObject_SearchResult_20Contact_user_6, "testObject_SearchResult_20Contact_user_6.json"), (Test.Wire.API.Golden.Generated.SearchResult_20Contact_user.testObject_SearchResult_20Contact_user_7, "testObject_SearchResult_20Contact_user_7.json"), (Test.Wire.API.Golden.Generated.SearchResult_20Contact_user.testObject_SearchResult_20Contact_user_8, "testObject_SearchResult_20Contact_user_8.json"), (Test.Wire.API.Golden.Generated.SearchResult_20Contact_user.testObject_SearchResult_20Contact_user_9, "testObject_SearchResult_20Contact_user_9.json"), (Test.Wire.API.Golden.Generated.SearchResult_20Contact_user.testObject_SearchResult_20Contact_user_10, "testObject_SearchResult_20Contact_user_10.json"), (Test.Wire.API.Golden.Generated.SearchResult_20Contact_user.testObject_SearchResult_20Contact_user_11, "testObject_SearchResult_20Contact_user_11.json"), (Test.Wire.API.Golden.Generated.SearchResult_20Contact_user.testObject_SearchResult_20Contact_user_12, "testObject_SearchResult_20Contact_user_12.json"), (Test.Wire.API.Golden.Generated.SearchResult_20Contact_user.testObject_SearchResult_20Contact_user_13, "testObject_SearchResult_20Contact_user_13.json"), (Test.Wire.API.Golden.Generated.SearchResult_20Contact_user.testObject_SearchResult_20Contact_user_14, "testObject_SearchResult_20Contact_user_14.json"), (Test.Wire.API.Golden.Generated.SearchResult_20Contact_user.testObject_SearchResult_20Contact_user_15, "testObject_SearchResult_20Contact_user_15.json"), (Test.Wire.API.Golden.Generated.SearchResult_20Contact_user.testObject_SearchResult_20Contact_user_16, "testObject_SearchResult_20Contact_user_16.json"), (Test.Wire.API.Golden.Generated.SearchResult_20Contact_user.testObject_SearchResult_20Contact_user_17, "testObject_SearchResult_20Contact_user_17.json"), (Test.Wire.API.Golden.Generated.SearchResult_20Contact_user.testObject_SearchResult_20Contact_user_18, "testObject_SearchResult_20Contact_user_18.json"), (Test.Wire.API.Golden.Generated.SearchResult_20Contact_user.testObject_SearchResult_20Contact_user_19, "testObject_SearchResult_20Contact_user_19.json"), (Test.Wire.API.Golden.Generated.SearchResult_20Contact_user.testObject_SearchResult_20Contact_user_20, "testObject_SearchResult_20Contact_user_20.json")],
      testGroup "Golden: Contact_user" $
        testObjects [(Test.Wire.API.Golden.Generated.Contact_user.testObject_Contact_user_1, "testObject_Contact_user_1.json"), (Test.Wire.API.Golden.Generated.Contact_user.testObject_Contact_user_2, "testObject_Contact_user_2.json"), (Test.Wire.API.Golden.Generated.Contact_user.testObject_Contact_user_3, "testObject_Contact_user_3.json"), (Test.Wire.API.Golden.Generated.Contact_user.testObject_Contact_user_4, "testObject_Contact_user_4.json"), (Test.Wire.API.Golden.Generated.Contact_user.testObject_Contact_user_5, "testObject_Contact_user_5.json"), (Test.Wire.API.Golden.Generated.Contact_user.testObject_Contact_user_6, "testObject_Contact_user_6.json"), (Test.Wire.API.Golden.Generated.Contact_user.testObject_Contact_user_7, "testObject_Contact_user_7.json"), (Test.Wire.API.Golden.Generated.Contact_user.testObject_Contact_user_8, "testObject_Contact_user_8.json"), (Test.Wire.API.Golden.Generated.Contact_user.testObject_Contact_user_9, "testObject_Contact_user_9.json"), (Test.Wire.API.Golden.Generated.Contact_user.testObject_Contact_user_10, "testObject_Contact_user_10.json"), (Test.Wire.API.Golden.Generated.Contact_user.testObject_Contact_user_11, "testObject_Contact_user_11.json"), (Test.Wire.API.Golden.Generated.Contact_user.testObject_Contact_user_12, "testObject_Contact_user_12.json"), (Test.Wire.API.Golden.Generated.Contact_user.testObject_Contact_user_13, "testObject_Contact_user_13.json"), (Test.Wire.API.Golden.Generated.Contact_user.testObject_Contact_user_14, "testObject_Contact_user_14.json"), (Test.Wire.API.Golden.Generated.Contact_user.testObject_Contact_user_15, "testObject_Contact_user_15.json"), (Test.Wire.API.Golden.Generated.Contact_user.testObject_Contact_user_16, "testObject_Contact_user_16.json"), (Test.Wire.API.Golden.Generated.Contact_user.testObject_Contact_user_17, "testObject_Contact_user_17.json"), (Test.Wire.API.Golden.Generated.Contact_user.testObject_Contact_user_18, "testObject_Contact_user_18.json"), (Test.Wire.API.Golden.Generated.Contact_user.testObject_Contact_user_19, "testObject_Contact_user_19.json"), (Test.Wire.API.Golden.Generated.Contact_user.testObject_Contact_user_20, "testObject_Contact_user_20.json")],
      testGroup "Golden: SearchResult_20TeamContact_user" $
        testObjects [(Test.Wire.API.Golden.Generated.SearchResult_20TeamContact_user.testObject_SearchResult_20TeamContact_user_1, "testObject_SearchResult_20TeamContact_user_1.json"), (Test.Wire.API.Golden.Generated.SearchResult_20TeamContact_user.testObject_SearchResult_20TeamContact_user_2, "testObject_SearchResult_20TeamContact_user_2.json"), (Test.Wire.API.Golden.Generated.SearchResult_20TeamContact_user.testObject_SearchResult_20TeamContact_user_3, "testObject_SearchResult_20TeamContact_user_3.json"), (Test.Wire.API.Golden.Generated.SearchResult_20TeamContact_user.testObject_SearchResult_20TeamContact_user_4, "testObject_SearchResult_20TeamContact_user_4.json"), (Test.Wire.API.Golden.Generated.SearchResult_20TeamContact_user.testObject_SearchResult_20TeamContact_user_5, "testObject_SearchResult_20TeamContact_user_5.json"), (Test.Wire.API.Golden.Generated.SearchResult_20TeamContact_user.testObject_SearchResult_20TeamContact_user_6, "testObject_SearchResult_20TeamContact_user_6.json"), (Test.Wire.API.Golden.Generated.SearchResult_20TeamContact_user.testObject_SearchResult_20TeamContact_user_7, "testObject_SearchResult_20TeamContact_user_7.json"), (Test.Wire.API.Golden.Generated.SearchResult_20TeamContact_user.testObject_SearchResult_20TeamContact_user_8, "testObject_SearchResult_20TeamContact_user_8.json"), (Test.Wire.API.Golden.Generated.SearchResult_20TeamContact_user.testObject_SearchResult_20TeamContact_user_9, "testObject_SearchResult_20TeamContact_user_9.json"), (Test.Wire.API.Golden.Generated.SearchResult_20TeamContact_user.testObject_SearchResult_20TeamContact_user_10, "testObject_SearchResult_20TeamContact_user_10.json"), (Test.Wire.API.Golden.Generated.SearchResult_20TeamContact_user.testObject_SearchResult_20TeamContact_user_11, "testObject_SearchResult_20TeamContact_user_11.json"), (Test.Wire.API.Golden.Generated.SearchResult_20TeamContact_user.testObject_SearchResult_20TeamContact_user_12, "testObject_SearchResult_20TeamContact_user_12.json"), (Test.Wire.API.Golden.Generated.SearchResult_20TeamContact_user.testObject_SearchResult_20TeamContact_user_13, "testObject_SearchResult_20TeamContact_user_13.json"), (Test.Wire.API.Golden.Generated.SearchResult_20TeamContact_user.testObject_SearchResult_20TeamContact_user_14, "testObject_SearchResult_20TeamContact_user_14.json"), (Test.Wire.API.Golden.Generated.SearchResult_20TeamContact_user.testObject_SearchResult_20TeamContact_user_15, "testObject_SearchResult_20TeamContact_user_15.json"), (Test.Wire.API.Golden.Generated.SearchResult_20TeamContact_user.testObject_SearchResult_20TeamContact_user_16, "testObject_SearchResult_20TeamContact_user_16.json"), (Test.Wire.API.Golden.Generated.SearchResult_20TeamContact_user.testObject_SearchResult_20TeamContact_user_17, "testObject_SearchResult_20TeamContact_user_17.json"), (Test.Wire.API.Golden.Generated.SearchResult_20TeamContact_user.testObject_SearchResult_20TeamContact_user_18, "testObject_SearchResult_20TeamContact_user_18.json"), (Test.Wire.API.Golden.Generated.SearchResult_20TeamContact_user.testObject_SearchResult_20TeamContact_user_19, "testObject_SearchResult_20TeamContact_user_19.json"), (Test.Wire.API.Golden.Generated.SearchResult_20TeamContact_user.testObject_SearchResult_20TeamContact_user_20, "testObject_SearchResult_20TeamContact_user_20.json")],
      testGroup "Golden: TeamContact_user" $
        testObjects [(Test.Wire.API.Golden.Generated.TeamContact_user.testObject_TeamContact_user_1, "testObject_TeamContact_user_1.json"), (Test.Wire.API.Golden.Generated.TeamContact_user.testObject_TeamContact_user_2, "testObject_TeamContact_user_2.json"), (Test.Wire.API.Golden.Generated.TeamContact_user.testObject_TeamContact_user_3, "testObject_TeamContact_user_3.json"), (Test.Wire.API.Golden.Generated.TeamContact_user.testObject_TeamContact_user_4, "testObject_TeamContact_user_4.json"), (Test.Wire.API.Golden.Generated.TeamContact_user.testObject_TeamContact_user_5, "testObject_TeamContact_user_5.json"), (Test.Wire.API.Golden.Generated.TeamContact_user.testObject_TeamContact_user_6, "testObject_TeamContact_user_6.json"), (Test.Wire.API.Golden.Generated.TeamContact_user.testObject_TeamContact_user_7, "testObject_TeamContact_user_7.json"), (Test.Wire.API.Golden.Generated.TeamContact_user.testObject_TeamContact_user_8, "testObject_TeamContact_user_8.json"), (Test.Wire.API.Golden.Generated.TeamContact_user.testObject_TeamContact_user_9, "testObject_TeamContact_user_9.json"), (Test.Wire.API.Golden.Generated.TeamContact_user.testObject_TeamContact_user_10, "testObject_TeamContact_user_10.json"), (Test.Wire.API.Golden.Generated.TeamContact_user.testObject_TeamContact_user_11, "testObject_TeamContact_user_11.json"), (Test.Wire.API.Golden.Generated.TeamContact_user.testObject_TeamContact_user_12, "testObject_TeamContact_user_12.json"), (Test.Wire.API.Golden.Generated.TeamContact_user.testObject_TeamContact_user_13, "testObject_TeamContact_user_13.json"), (Test.Wire.API.Golden.Generated.TeamContact_user.testObject_TeamContact_user_14, "testObject_TeamContact_user_14.json"), (Test.Wire.API.Golden.Generated.TeamContact_user.testObject_TeamContact_user_15, "testObject_TeamContact_user_15.json"), (Test.Wire.API.Golden.Generated.TeamContact_user.testObject_TeamContact_user_16, "testObject_TeamContact_user_16.json"), (Test.Wire.API.Golden.Generated.TeamContact_user.testObject_TeamContact_user_17, "testObject_TeamContact_user_17.json"), (Test.Wire.API.Golden.Generated.TeamContact_user.testObject_TeamContact_user_18, "testObject_TeamContact_user_18.json"), (Test.Wire.API.Golden.Generated.TeamContact_user.testObject_TeamContact_user_19, "testObject_TeamContact_user_19.json"), (Test.Wire.API.Golden.Generated.TeamContact_user.testObject_TeamContact_user_20, "testObject_TeamContact_user_20.json")],
      testGroup "Golden: Wrapped_20_22some_5fint_22_20Int_user" $
        testObjects [(Test.Wire.API.Golden.Generated.Wrapped_20_22some_5fint_22_20Int_user.testObject_Wrapped_20_22some_5fint_22_20Int_user_1, "testObject_Wrapped_20_22some_5fint_22_20Int_user_1.json"), (Test.Wire.API.Golden.Generated.Wrapped_20_22some_5fint_22_20Int_user.testObject_Wrapped_20_22some_5fint_22_20Int_user_2, "testObject_Wrapped_20_22some_5fint_22_20Int_user_2.json"), (Test.Wire.API.Golden.Generated.Wrapped_20_22some_5fint_22_20Int_user.testObject_Wrapped_20_22some_5fint_22_20Int_user_3, "testObject_Wrapped_20_22some_5fint_22_20Int_user_3.json"), (Test.Wire.API.Golden.Generated.Wrapped_20_22some_5fint_22_20Int_user.testObject_Wrapped_20_22some_5fint_22_20Int_user_4, "testObject_Wrapped_20_22some_5fint_22_20Int_user_4.json"), (Test.Wire.API.Golden.Generated.Wrapped_20_22some_5fint_22_20Int_user.testObject_Wrapped_20_22some_5fint_22_20Int_user_5, "testObject_Wrapped_20_22some_5fint_22_20Int_user_5.json"), (Test.Wire.API.Golden.Generated.Wrapped_20_22some_5fint_22_20Int_user.testObject_Wrapped_20_22some_5fint_22_20Int_user_6, "testObject_Wrapped_20_22some_5fint_22_20Int_user_6.json"), (Test.Wire.API.Golden.Generated.Wrapped_20_22some_5fint_22_20Int_user.testObject_Wrapped_20_22some_5fint_22_20Int_user_7, "testObject_Wrapped_20_22some_5fint_22_20Int_user_7.json"), (Test.Wire.API.Golden.Generated.Wrapped_20_22some_5fint_22_20Int_user.testObject_Wrapped_20_22some_5fint_22_20Int_user_8, "testObject_Wrapped_20_22some_5fint_22_20Int_user_8.json"), (Test.Wire.API.Golden.Generated.Wrapped_20_22some_5fint_22_20Int_user.testObject_Wrapped_20_22some_5fint_22_20Int_user_9, "testObject_Wrapped_20_22some_5fint_22_20Int_user_9.json"), (Test.Wire.API.Golden.Generated.Wrapped_20_22some_5fint_22_20Int_user.testObject_Wrapped_20_22some_5fint_22_20Int_user_10, "testObject_Wrapped_20_22some_5fint_22_20Int_user_10.json"), (Test.Wire.API.Golden.Generated.Wrapped_20_22some_5fint_22_20Int_user.testObject_Wrapped_20_22some_5fint_22_20Int_user_11, "testObject_Wrapped_20_22some_5fint_22_20Int_user_11.json"), (Test.Wire.API.Golden.Generated.Wrapped_20_22some_5fint_22_20Int_user.testObject_Wrapped_20_22some_5fint_22_20Int_user_12, "testObject_Wrapped_20_22some_5fint_22_20Int_user_12.json"), (Test.Wire.API.Golden.Generated.Wrapped_20_22some_5fint_22_20Int_user.testObject_Wrapped_20_22some_5fint_22_20Int_user_13, "testObject_Wrapped_20_22some_5fint_22_20Int_user_13.json"), (Test.Wire.API.Golden.Generated.Wrapped_20_22some_5fint_22_20Int_user.testObject_Wrapped_20_22some_5fint_22_20Int_user_14, "testObject_Wrapped_20_22some_5fint_22_20Int_user_14.json"), (Test.Wire.API.Golden.Generated.Wrapped_20_22some_5fint_22_20Int_user.testObject_Wrapped_20_22some_5fint_22_20Int_user_15, "testObject_Wrapped_20_22some_5fint_22_20Int_user_15.json"), (Test.Wire.API.Golden.Generated.Wrapped_20_22some_5fint_22_20Int_user.testObject_Wrapped_20_22some_5fint_22_20Int_user_16, "testObject_Wrapped_20_22some_5fint_22_20Int_user_16.json"), (Test.Wire.API.Golden.Generated.Wrapped_20_22some_5fint_22_20Int_user.testObject_Wrapped_20_22some_5fint_22_20Int_user_17, "testObject_Wrapped_20_22some_5fint_22_20Int_user_17.json"), (Test.Wire.API.Golden.Generated.Wrapped_20_22some_5fint_22_20Int_user.testObject_Wrapped_20_22some_5fint_22_20Int_user_18, "testObject_Wrapped_20_22some_5fint_22_20Int_user_18.json"), (Test.Wire.API.Golden.Generated.Wrapped_20_22some_5fint_22_20Int_user.testObject_Wrapped_20_22some_5fint_22_20Int_user_19, "testObject_Wrapped_20_22some_5fint_22_20Int_user_19.json"), (Test.Wire.API.Golden.Generated.Wrapped_20_22some_5fint_22_20Int_user.testObject_Wrapped_20_22some_5fint_22_20Int_user_20, "testObject_Wrapped_20_22some_5fint_22_20Int_user_20.json")],
      testGroup "Golden: Asset_asset" $
        testObjects [(Test.Wire.API.Golden.Generated.Asset_asset.testObject_Asset_asset_1, "testObject_Asset_asset_1.json"), (Test.Wire.API.Golden.Generated.Asset_asset.testObject_Asset_asset_2, "testObject_Asset_asset_2.json"), (Test.Wire.API.Golden.Generated.Asset_asset.testObject_Asset_asset_3, "testObject_Asset_asset_3.json"), (Test.Wire.API.Golden.Generated.Asset_asset.testObject_Asset_asset_4, "testObject_Asset_asset_4.json"), (Test.Wire.API.Golden.Generated.Asset_asset.testObject_Asset_asset_5, "testObject_Asset_asset_5.json"), (Test.Wire.API.Golden.Generated.Asset_asset.testObject_Asset_asset_6, "testObject_Asset_asset_6.json"), (Test.Wire.API.Golden.Generated.Asset_asset.testObject_Asset_asset_7, "testObject_Asset_asset_7.json"), (Test.Wire.API.Golden.Generated.Asset_asset.testObject_Asset_asset_8, "testObject_Asset_asset_8.json"), (Test.Wire.API.Golden.Generated.Asset_asset.testObject_Asset_asset_9, "testObject_Asset_asset_9.json"), (Test.Wire.API.Golden.Generated.Asset_asset.testObject_Asset_asset_10, "testObject_Asset_asset_10.json"), (Test.Wire.API.Golden.Generated.Asset_asset.testObject_Asset_asset_11, "testObject_Asset_asset_11.json"), (Test.Wire.API.Golden.Generated.Asset_asset.testObject_Asset_asset_12, "testObject_Asset_asset_12.json"), (Test.Wire.API.Golden.Generated.Asset_asset.testObject_Asset_asset_13, "testObject_Asset_asset_13.json"), (Test.Wire.API.Golden.Generated.Asset_asset.testObject_Asset_asset_14, "testObject_Asset_asset_14.json"), (Test.Wire.API.Golden.Generated.Asset_asset.testObject_Asset_asset_15, "testObject_Asset_asset_15.json"), (Test.Wire.API.Golden.Generated.Asset_asset.testObject_Asset_asset_16, "testObject_Asset_asset_16.json"), (Test.Wire.API.Golden.Generated.Asset_asset.testObject_Asset_asset_17, "testObject_Asset_asset_17.json"), (Test.Wire.API.Golden.Generated.Asset_asset.testObject_Asset_asset_18, "testObject_Asset_asset_18.json"), (Test.Wire.API.Golden.Generated.Asset_asset.testObject_Asset_asset_19, "testObject_Asset_asset_19.json"), (Test.Wire.API.Golden.Generated.Asset_asset.testObject_Asset_asset_20, "testObject_Asset_asset_20.json")],
      testGroup "Golden: Event_team" $
        testObjects [(Test.Wire.API.Golden.Generated.Event_team.testObject_Event_team_1, "testObject_Event_team_1.json"), (Test.Wire.API.Golden.Generated.Event_team.testObject_Event_team_2, "testObject_Event_team_2.json"), (Test.Wire.API.Golden.Generated.Event_team.testObject_Event_team_3, "testObject_Event_team_3.json"), (Test.Wire.API.Golden.Generated.Event_team.testObject_Event_team_4, "testObject_Event_team_4.json"), (Test.Wire.API.Golden.Generated.Event_team.testObject_Event_team_5, "testObject_Event_team_5.json"), (Test.Wire.API.Golden.Generated.Event_team.testObject_Event_team_6, "testObject_Event_team_6.json"), (Test.Wire.API.Golden.Generated.Event_team.testObject_Event_team_7, "testObject_Event_team_7.json"), (Test.Wire.API.Golden.Generated.Event_team.testObject_Event_team_8, "testObject_Event_team_8.json"), (Test.Wire.API.Golden.Generated.Event_team.testObject_Event_team_9, "testObject_Event_team_9.json"), (Test.Wire.API.Golden.Generated.Event_team.testObject_Event_team_10, "testObject_Event_team_10.json"), (Test.Wire.API.Golden.Generated.Event_team.testObject_Event_team_11, "testObject_Event_team_11.json"), (Test.Wire.API.Golden.Generated.Event_team.testObject_Event_team_12, "testObject_Event_team_12.json"), (Test.Wire.API.Golden.Generated.Event_team.testObject_Event_team_13, "testObject_Event_team_13.json"), (Test.Wire.API.Golden.Generated.Event_team.testObject_Event_team_14, "testObject_Event_team_14.json"), (Test.Wire.API.Golden.Generated.Event_team.testObject_Event_team_15, "testObject_Event_team_15.json"), (Test.Wire.API.Golden.Generated.Event_team.testObject_Event_team_16, "testObject_Event_team_16.json"), (Test.Wire.API.Golden.Generated.Event_team.testObject_Event_team_17, "testObject_Event_team_17.json"), (Test.Wire.API.Golden.Generated.Event_team.testObject_Event_team_18, "testObject_Event_team_18.json"), (Test.Wire.API.Golden.Generated.Event_team.testObject_Event_team_19, "testObject_Event_team_19.json"), (Test.Wire.API.Golden.Generated.Event_team.testObject_Event_team_20, "testObject_Event_team_20.json")],
      testGroup "Golden: EventType_team" $
        testObjects [(Test.Wire.API.Golden.Generated.EventType_team.testObject_EventType_team_1, "testObject_EventType_team_1.json"), (Test.Wire.API.Golden.Generated.EventType_team.testObject_EventType_team_2, "testObject_EventType_team_2.json"), (Test.Wire.API.Golden.Generated.EventType_team.testObject_EventType_team_3, "testObject_EventType_team_3.json"), (Test.Wire.API.Golden.Generated.EventType_team.testObject_EventType_team_4, "testObject_EventType_team_4.json"), (Test.Wire.API.Golden.Generated.EventType_team.testObject_EventType_team_5, "testObject_EventType_team_5.json"), (Test.Wire.API.Golden.Generated.EventType_team.testObject_EventType_team_6, "testObject_EventType_team_6.json"), (Test.Wire.API.Golden.Generated.EventType_team.testObject_EventType_team_7, "testObject_EventType_team_7.json"), (Test.Wire.API.Golden.Generated.EventType_team.testObject_EventType_team_8, "testObject_EventType_team_8.json"), (Test.Wire.API.Golden.Generated.EventType_team.testObject_EventType_team_9, "testObject_EventType_team_9.json"), (Test.Wire.API.Golden.Generated.EventType_team.testObject_EventType_team_10, "testObject_EventType_team_10.json"), (Test.Wire.API.Golden.Generated.EventType_team.testObject_EventType_team_11, "testObject_EventType_team_11.json"), (Test.Wire.API.Golden.Generated.EventType_team.testObject_EventType_team_12, "testObject_EventType_team_12.json"), (Test.Wire.API.Golden.Generated.EventType_team.testObject_EventType_team_13, "testObject_EventType_team_13.json"), (Test.Wire.API.Golden.Generated.EventType_team.testObject_EventType_team_14, "testObject_EventType_team_14.json"), (Test.Wire.API.Golden.Generated.EventType_team.testObject_EventType_team_15, "testObject_EventType_team_15.json"), (Test.Wire.API.Golden.Generated.EventType_team.testObject_EventType_team_16, "testObject_EventType_team_16.json"), (Test.Wire.API.Golden.Generated.EventType_team.testObject_EventType_team_17, "testObject_EventType_team_17.json"), (Test.Wire.API.Golden.Generated.EventType_team.testObject_EventType_team_18, "testObject_EventType_team_18.json"), (Test.Wire.API.Golden.Generated.EventType_team.testObject_EventType_team_19, "testObject_EventType_team_19.json"), (Test.Wire.API.Golden.Generated.EventType_team.testObject_EventType_team_20, "testObject_EventType_team_20.json")],
      testGroup "Golden: Provider_provider" $
        testObjects [(Test.Wire.API.Golden.Generated.Provider_provider.testObject_Provider_provider_1, "testObject_Provider_provider_1.json"), (Test.Wire.API.Golden.Generated.Provider_provider.testObject_Provider_provider_2, "testObject_Provider_provider_2.json"), (Test.Wire.API.Golden.Generated.Provider_provider.testObject_Provider_provider_3, "testObject_Provider_provider_3.json"), (Test.Wire.API.Golden.Generated.Provider_provider.testObject_Provider_provider_4, "testObject_Provider_provider_4.json"), (Test.Wire.API.Golden.Generated.Provider_provider.testObject_Provider_provider_5, "testObject_Provider_provider_5.json"), (Test.Wire.API.Golden.Generated.Provider_provider.testObject_Provider_provider_6, "testObject_Provider_provider_6.json"), (Test.Wire.API.Golden.Generated.Provider_provider.testObject_Provider_provider_7, "testObject_Provider_provider_7.json"), (Test.Wire.API.Golden.Generated.Provider_provider.testObject_Provider_provider_8, "testObject_Provider_provider_8.json"), (Test.Wire.API.Golden.Generated.Provider_provider.testObject_Provider_provider_9, "testObject_Provider_provider_9.json"), (Test.Wire.API.Golden.Generated.Provider_provider.testObject_Provider_provider_10, "testObject_Provider_provider_10.json"), (Test.Wire.API.Golden.Generated.Provider_provider.testObject_Provider_provider_11, "testObject_Provider_provider_11.json"), (Test.Wire.API.Golden.Generated.Provider_provider.testObject_Provider_provider_12, "testObject_Provider_provider_12.json"), (Test.Wire.API.Golden.Generated.Provider_provider.testObject_Provider_provider_13, "testObject_Provider_provider_13.json"), (Test.Wire.API.Golden.Generated.Provider_provider.testObject_Provider_provider_14, "testObject_Provider_provider_14.json"), (Test.Wire.API.Golden.Generated.Provider_provider.testObject_Provider_provider_15, "testObject_Provider_provider_15.json"), (Test.Wire.API.Golden.Generated.Provider_provider.testObject_Provider_provider_16, "testObject_Provider_provider_16.json"), (Test.Wire.API.Golden.Generated.Provider_provider.testObject_Provider_provider_17, "testObject_Provider_provider_17.json"), (Test.Wire.API.Golden.Generated.Provider_provider.testObject_Provider_provider_18, "testObject_Provider_provider_18.json"), (Test.Wire.API.Golden.Generated.Provider_provider.testObject_Provider_provider_19, "testObject_Provider_provider_19.json"), (Test.Wire.API.Golden.Generated.Provider_provider.testObject_Provider_provider_20, "testObject_Provider_provider_20.json")],
      testGroup "Golden: ProviderProfile_provider" $
        testObjects [(Test.Wire.API.Golden.Generated.ProviderProfile_provider.testObject_ProviderProfile_provider_1, "testObject_ProviderProfile_provider_1.json"), (Test.Wire.API.Golden.Generated.ProviderProfile_provider.testObject_ProviderProfile_provider_2, "testObject_ProviderProfile_provider_2.json"), (Test.Wire.API.Golden.Generated.ProviderProfile_provider.testObject_ProviderProfile_provider_3, "testObject_ProviderProfile_provider_3.json"), (Test.Wire.API.Golden.Generated.ProviderProfile_provider.testObject_ProviderProfile_provider_4, "testObject_ProviderProfile_provider_4.json"), (Test.Wire.API.Golden.Generated.ProviderProfile_provider.testObject_ProviderProfile_provider_5, "testObject_ProviderProfile_provider_5.json"), (Test.Wire.API.Golden.Generated.ProviderProfile_provider.testObject_ProviderProfile_provider_6, "testObject_ProviderProfile_provider_6.json"), (Test.Wire.API.Golden.Generated.ProviderProfile_provider.testObject_ProviderProfile_provider_7, "testObject_ProviderProfile_provider_7.json"), (Test.Wire.API.Golden.Generated.ProviderProfile_provider.testObject_ProviderProfile_provider_8, "testObject_ProviderProfile_provider_8.json"), (Test.Wire.API.Golden.Generated.ProviderProfile_provider.testObject_ProviderProfile_provider_9, "testObject_ProviderProfile_provider_9.json"), (Test.Wire.API.Golden.Generated.ProviderProfile_provider.testObject_ProviderProfile_provider_10, "testObject_ProviderProfile_provider_10.json"), (Test.Wire.API.Golden.Generated.ProviderProfile_provider.testObject_ProviderProfile_provider_11, "testObject_ProviderProfile_provider_11.json"), (Test.Wire.API.Golden.Generated.ProviderProfile_provider.testObject_ProviderProfile_provider_12, "testObject_ProviderProfile_provider_12.json"), (Test.Wire.API.Golden.Generated.ProviderProfile_provider.testObject_ProviderProfile_provider_13, "testObject_ProviderProfile_provider_13.json"), (Test.Wire.API.Golden.Generated.ProviderProfile_provider.testObject_ProviderProfile_provider_14, "testObject_ProviderProfile_provider_14.json"), (Test.Wire.API.Golden.Generated.ProviderProfile_provider.testObject_ProviderProfile_provider_15, "testObject_ProviderProfile_provider_15.json"), (Test.Wire.API.Golden.Generated.ProviderProfile_provider.testObject_ProviderProfile_provider_16, "testObject_ProviderProfile_provider_16.json"), (Test.Wire.API.Golden.Generated.ProviderProfile_provider.testObject_ProviderProfile_provider_17, "testObject_ProviderProfile_provider_17.json"), (Test.Wire.API.Golden.Generated.ProviderProfile_provider.testObject_ProviderProfile_provider_18, "testObject_ProviderProfile_provider_18.json"), (Test.Wire.API.Golden.Generated.ProviderProfile_provider.testObject_ProviderProfile_provider_19, "testObject_ProviderProfile_provider_19.json"), (Test.Wire.API.Golden.Generated.ProviderProfile_provider.testObject_ProviderProfile_provider_20, "testObject_ProviderProfile_provider_20.json")],
      testGroup "Golden: NewProvider_provider" $
        testObjects [(Test.Wire.API.Golden.Generated.NewProvider_provider.testObject_NewProvider_provider_1, "testObject_NewProvider_provider_1.json"), (Test.Wire.API.Golden.Generated.NewProvider_provider.testObject_NewProvider_provider_2, "testObject_NewProvider_provider_2.json"), (Test.Wire.API.Golden.Generated.NewProvider_provider.testObject_NewProvider_provider_3, "testObject_NewProvider_provider_3.json"), (Test.Wire.API.Golden.Generated.NewProvider_provider.testObject_NewProvider_provider_4, "testObject_NewProvider_provider_4.json"), (Test.Wire.API.Golden.Generated.NewProvider_provider.testObject_NewProvider_provider_5, "testObject_NewProvider_provider_5.json"), (Test.Wire.API.Golden.Generated.NewProvider_provider.testObject_NewProvider_provider_6, "testObject_NewProvider_provider_6.json"), (Test.Wire.API.Golden.Generated.NewProvider_provider.testObject_NewProvider_provider_7, "testObject_NewProvider_provider_7.json"), (Test.Wire.API.Golden.Generated.NewProvider_provider.testObject_NewProvider_provider_8, "testObject_NewProvider_provider_8.json"), (Test.Wire.API.Golden.Generated.NewProvider_provider.testObject_NewProvider_provider_9, "testObject_NewProvider_provider_9.json"), (Test.Wire.API.Golden.Generated.NewProvider_provider.testObject_NewProvider_provider_10, "testObject_NewProvider_provider_10.json"), (Test.Wire.API.Golden.Generated.NewProvider_provider.testObject_NewProvider_provider_11, "testObject_NewProvider_provider_11.json"), (Test.Wire.API.Golden.Generated.NewProvider_provider.testObject_NewProvider_provider_12, "testObject_NewProvider_provider_12.json"), (Test.Wire.API.Golden.Generated.NewProvider_provider.testObject_NewProvider_provider_13, "testObject_NewProvider_provider_13.json"), (Test.Wire.API.Golden.Generated.NewProvider_provider.testObject_NewProvider_provider_14, "testObject_NewProvider_provider_14.json"), (Test.Wire.API.Golden.Generated.NewProvider_provider.testObject_NewProvider_provider_15, "testObject_NewProvider_provider_15.json"), (Test.Wire.API.Golden.Generated.NewProvider_provider.testObject_NewProvider_provider_16, "testObject_NewProvider_provider_16.json"), (Test.Wire.API.Golden.Generated.NewProvider_provider.testObject_NewProvider_provider_17, "testObject_NewProvider_provider_17.json"), (Test.Wire.API.Golden.Generated.NewProvider_provider.testObject_NewProvider_provider_18, "testObject_NewProvider_provider_18.json"), (Test.Wire.API.Golden.Generated.NewProvider_provider.testObject_NewProvider_provider_19, "testObject_NewProvider_provider_19.json"), (Test.Wire.API.Golden.Generated.NewProvider_provider.testObject_NewProvider_provider_20, "testObject_NewProvider_provider_20.json")],
      testGroup "Golden: NewProviderResponse_provider" $
        testObjects [(Test.Wire.API.Golden.Generated.NewProviderResponse_provider.testObject_NewProviderResponse_provider_1, "testObject_NewProviderResponse_provider_1.json"), (Test.Wire.API.Golden.Generated.NewProviderResponse_provider.testObject_NewProviderResponse_provider_2, "testObject_NewProviderResponse_provider_2.json"), (Test.Wire.API.Golden.Generated.NewProviderResponse_provider.testObject_NewProviderResponse_provider_3, "testObject_NewProviderResponse_provider_3.json"), (Test.Wire.API.Golden.Generated.NewProviderResponse_provider.testObject_NewProviderResponse_provider_4, "testObject_NewProviderResponse_provider_4.json"), (Test.Wire.API.Golden.Generated.NewProviderResponse_provider.testObject_NewProviderResponse_provider_5, "testObject_NewProviderResponse_provider_5.json"), (Test.Wire.API.Golden.Generated.NewProviderResponse_provider.testObject_NewProviderResponse_provider_6, "testObject_NewProviderResponse_provider_6.json"), (Test.Wire.API.Golden.Generated.NewProviderResponse_provider.testObject_NewProviderResponse_provider_7, "testObject_NewProviderResponse_provider_7.json"), (Test.Wire.API.Golden.Generated.NewProviderResponse_provider.testObject_NewProviderResponse_provider_8, "testObject_NewProviderResponse_provider_8.json"), (Test.Wire.API.Golden.Generated.NewProviderResponse_provider.testObject_NewProviderResponse_provider_9, "testObject_NewProviderResponse_provider_9.json"), (Test.Wire.API.Golden.Generated.NewProviderResponse_provider.testObject_NewProviderResponse_provider_10, "testObject_NewProviderResponse_provider_10.json"), (Test.Wire.API.Golden.Generated.NewProviderResponse_provider.testObject_NewProviderResponse_provider_11, "testObject_NewProviderResponse_provider_11.json"), (Test.Wire.API.Golden.Generated.NewProviderResponse_provider.testObject_NewProviderResponse_provider_12, "testObject_NewProviderResponse_provider_12.json"), (Test.Wire.API.Golden.Generated.NewProviderResponse_provider.testObject_NewProviderResponse_provider_13, "testObject_NewProviderResponse_provider_13.json"), (Test.Wire.API.Golden.Generated.NewProviderResponse_provider.testObject_NewProviderResponse_provider_14, "testObject_NewProviderResponse_provider_14.json"), (Test.Wire.API.Golden.Generated.NewProviderResponse_provider.testObject_NewProviderResponse_provider_15, "testObject_NewProviderResponse_provider_15.json"), (Test.Wire.API.Golden.Generated.NewProviderResponse_provider.testObject_NewProviderResponse_provider_16, "testObject_NewProviderResponse_provider_16.json"), (Test.Wire.API.Golden.Generated.NewProviderResponse_provider.testObject_NewProviderResponse_provider_17, "testObject_NewProviderResponse_provider_17.json"), (Test.Wire.API.Golden.Generated.NewProviderResponse_provider.testObject_NewProviderResponse_provider_18, "testObject_NewProviderResponse_provider_18.json"), (Test.Wire.API.Golden.Generated.NewProviderResponse_provider.testObject_NewProviderResponse_provider_19, "testObject_NewProviderResponse_provider_19.json"), (Test.Wire.API.Golden.Generated.NewProviderResponse_provider.testObject_NewProviderResponse_provider_20, "testObject_NewProviderResponse_provider_20.json")],
      testGroup "Golden: UpdateProvider_provider" $
        testObjects [(Test.Wire.API.Golden.Generated.UpdateProvider_provider.testObject_UpdateProvider_provider_1, "testObject_UpdateProvider_provider_1.json"), (Test.Wire.API.Golden.Generated.UpdateProvider_provider.testObject_UpdateProvider_provider_2, "testObject_UpdateProvider_provider_2.json"), (Test.Wire.API.Golden.Generated.UpdateProvider_provider.testObject_UpdateProvider_provider_3, "testObject_UpdateProvider_provider_3.json"), (Test.Wire.API.Golden.Generated.UpdateProvider_provider.testObject_UpdateProvider_provider_4, "testObject_UpdateProvider_provider_4.json"), (Test.Wire.API.Golden.Generated.UpdateProvider_provider.testObject_UpdateProvider_provider_5, "testObject_UpdateProvider_provider_5.json"), (Test.Wire.API.Golden.Generated.UpdateProvider_provider.testObject_UpdateProvider_provider_6, "testObject_UpdateProvider_provider_6.json"), (Test.Wire.API.Golden.Generated.UpdateProvider_provider.testObject_UpdateProvider_provider_7, "testObject_UpdateProvider_provider_7.json"), (Test.Wire.API.Golden.Generated.UpdateProvider_provider.testObject_UpdateProvider_provider_8, "testObject_UpdateProvider_provider_8.json"), (Test.Wire.API.Golden.Generated.UpdateProvider_provider.testObject_UpdateProvider_provider_9, "testObject_UpdateProvider_provider_9.json"), (Test.Wire.API.Golden.Generated.UpdateProvider_provider.testObject_UpdateProvider_provider_10, "testObject_UpdateProvider_provider_10.json"), (Test.Wire.API.Golden.Generated.UpdateProvider_provider.testObject_UpdateProvider_provider_11, "testObject_UpdateProvider_provider_11.json"), (Test.Wire.API.Golden.Generated.UpdateProvider_provider.testObject_UpdateProvider_provider_12, "testObject_UpdateProvider_provider_12.json"), (Test.Wire.API.Golden.Generated.UpdateProvider_provider.testObject_UpdateProvider_provider_13, "testObject_UpdateProvider_provider_13.json"), (Test.Wire.API.Golden.Generated.UpdateProvider_provider.testObject_UpdateProvider_provider_14, "testObject_UpdateProvider_provider_14.json"), (Test.Wire.API.Golden.Generated.UpdateProvider_provider.testObject_UpdateProvider_provider_15, "testObject_UpdateProvider_provider_15.json"), (Test.Wire.API.Golden.Generated.UpdateProvider_provider.testObject_UpdateProvider_provider_16, "testObject_UpdateProvider_provider_16.json"), (Test.Wire.API.Golden.Generated.UpdateProvider_provider.testObject_UpdateProvider_provider_17, "testObject_UpdateProvider_provider_17.json"), (Test.Wire.API.Golden.Generated.UpdateProvider_provider.testObject_UpdateProvider_provider_18, "testObject_UpdateProvider_provider_18.json"), (Test.Wire.API.Golden.Generated.UpdateProvider_provider.testObject_UpdateProvider_provider_19, "testObject_UpdateProvider_provider_19.json"), (Test.Wire.API.Golden.Generated.UpdateProvider_provider.testObject_UpdateProvider_provider_20, "testObject_UpdateProvider_provider_20.json")],
      testGroup "Golden: ProviderActivationResponse_provider" $
        testObjects [(Test.Wire.API.Golden.Generated.ProviderActivationResponse_provider.testObject_ProviderActivationResponse_provider_1, "testObject_ProviderActivationResponse_provider_1.json"), (Test.Wire.API.Golden.Generated.ProviderActivationResponse_provider.testObject_ProviderActivationResponse_provider_2, "testObject_ProviderActivationResponse_provider_2.json"), (Test.Wire.API.Golden.Generated.ProviderActivationResponse_provider.testObject_ProviderActivationResponse_provider_3, "testObject_ProviderActivationResponse_provider_3.json"), (Test.Wire.API.Golden.Generated.ProviderActivationResponse_provider.testObject_ProviderActivationResponse_provider_4, "testObject_ProviderActivationResponse_provider_4.json"), (Test.Wire.API.Golden.Generated.ProviderActivationResponse_provider.testObject_ProviderActivationResponse_provider_5, "testObject_ProviderActivationResponse_provider_5.json"), (Test.Wire.API.Golden.Generated.ProviderActivationResponse_provider.testObject_ProviderActivationResponse_provider_6, "testObject_ProviderActivationResponse_provider_6.json"), (Test.Wire.API.Golden.Generated.ProviderActivationResponse_provider.testObject_ProviderActivationResponse_provider_7, "testObject_ProviderActivationResponse_provider_7.json"), (Test.Wire.API.Golden.Generated.ProviderActivationResponse_provider.testObject_ProviderActivationResponse_provider_8, "testObject_ProviderActivationResponse_provider_8.json"), (Test.Wire.API.Golden.Generated.ProviderActivationResponse_provider.testObject_ProviderActivationResponse_provider_9, "testObject_ProviderActivationResponse_provider_9.json"), (Test.Wire.API.Golden.Generated.ProviderActivationResponse_provider.testObject_ProviderActivationResponse_provider_10, "testObject_ProviderActivationResponse_provider_10.json"), (Test.Wire.API.Golden.Generated.ProviderActivationResponse_provider.testObject_ProviderActivationResponse_provider_11, "testObject_ProviderActivationResponse_provider_11.json"), (Test.Wire.API.Golden.Generated.ProviderActivationResponse_provider.testObject_ProviderActivationResponse_provider_12, "testObject_ProviderActivationResponse_provider_12.json"), (Test.Wire.API.Golden.Generated.ProviderActivationResponse_provider.testObject_ProviderActivationResponse_provider_13, "testObject_ProviderActivationResponse_provider_13.json"), (Test.Wire.API.Golden.Generated.ProviderActivationResponse_provider.testObject_ProviderActivationResponse_provider_14, "testObject_ProviderActivationResponse_provider_14.json"), (Test.Wire.API.Golden.Generated.ProviderActivationResponse_provider.testObject_ProviderActivationResponse_provider_15, "testObject_ProviderActivationResponse_provider_15.json"), (Test.Wire.API.Golden.Generated.ProviderActivationResponse_provider.testObject_ProviderActivationResponse_provider_16, "testObject_ProviderActivationResponse_provider_16.json"), (Test.Wire.API.Golden.Generated.ProviderActivationResponse_provider.testObject_ProviderActivationResponse_provider_17, "testObject_ProviderActivationResponse_provider_17.json"), (Test.Wire.API.Golden.Generated.ProviderActivationResponse_provider.testObject_ProviderActivationResponse_provider_18, "testObject_ProviderActivationResponse_provider_18.json"), (Test.Wire.API.Golden.Generated.ProviderActivationResponse_provider.testObject_ProviderActivationResponse_provider_19, "testObject_ProviderActivationResponse_provider_19.json"), (Test.Wire.API.Golden.Generated.ProviderActivationResponse_provider.testObject_ProviderActivationResponse_provider_20, "testObject_ProviderActivationResponse_provider_20.json")],
      testGroup "Golden: ProviderLogin_provider" $
        testObjects [(Test.Wire.API.Golden.Generated.ProviderLogin_provider.testObject_ProviderLogin_provider_1, "testObject_ProviderLogin_provider_1.json"), (Test.Wire.API.Golden.Generated.ProviderLogin_provider.testObject_ProviderLogin_provider_2, "testObject_ProviderLogin_provider_2.json"), (Test.Wire.API.Golden.Generated.ProviderLogin_provider.testObject_ProviderLogin_provider_3, "testObject_ProviderLogin_provider_3.json"), (Test.Wire.API.Golden.Generated.ProviderLogin_provider.testObject_ProviderLogin_provider_4, "testObject_ProviderLogin_provider_4.json"), (Test.Wire.API.Golden.Generated.ProviderLogin_provider.testObject_ProviderLogin_provider_5, "testObject_ProviderLogin_provider_5.json"), (Test.Wire.API.Golden.Generated.ProviderLogin_provider.testObject_ProviderLogin_provider_6, "testObject_ProviderLogin_provider_6.json"), (Test.Wire.API.Golden.Generated.ProviderLogin_provider.testObject_ProviderLogin_provider_7, "testObject_ProviderLogin_provider_7.json"), (Test.Wire.API.Golden.Generated.ProviderLogin_provider.testObject_ProviderLogin_provider_8, "testObject_ProviderLogin_provider_8.json"), (Test.Wire.API.Golden.Generated.ProviderLogin_provider.testObject_ProviderLogin_provider_9, "testObject_ProviderLogin_provider_9.json"), (Test.Wire.API.Golden.Generated.ProviderLogin_provider.testObject_ProviderLogin_provider_10, "testObject_ProviderLogin_provider_10.json"), (Test.Wire.API.Golden.Generated.ProviderLogin_provider.testObject_ProviderLogin_provider_11, "testObject_ProviderLogin_provider_11.json"), (Test.Wire.API.Golden.Generated.ProviderLogin_provider.testObject_ProviderLogin_provider_12, "testObject_ProviderLogin_provider_12.json"), (Test.Wire.API.Golden.Generated.ProviderLogin_provider.testObject_ProviderLogin_provider_13, "testObject_ProviderLogin_provider_13.json"), (Test.Wire.API.Golden.Generated.ProviderLogin_provider.testObject_ProviderLogin_provider_14, "testObject_ProviderLogin_provider_14.json"), (Test.Wire.API.Golden.Generated.ProviderLogin_provider.testObject_ProviderLogin_provider_15, "testObject_ProviderLogin_provider_15.json"), (Test.Wire.API.Golden.Generated.ProviderLogin_provider.testObject_ProviderLogin_provider_16, "testObject_ProviderLogin_provider_16.json"), (Test.Wire.API.Golden.Generated.ProviderLogin_provider.testObject_ProviderLogin_provider_17, "testObject_ProviderLogin_provider_17.json"), (Test.Wire.API.Golden.Generated.ProviderLogin_provider.testObject_ProviderLogin_provider_18, "testObject_ProviderLogin_provider_18.json"), (Test.Wire.API.Golden.Generated.ProviderLogin_provider.testObject_ProviderLogin_provider_19, "testObject_ProviderLogin_provider_19.json"), (Test.Wire.API.Golden.Generated.ProviderLogin_provider.testObject_ProviderLogin_provider_20, "testObject_ProviderLogin_provider_20.json")],
      testGroup "Golden: DeleteProvider_provider" $
        testObjects [(Test.Wire.API.Golden.Generated.DeleteProvider_provider.testObject_DeleteProvider_provider_1, "testObject_DeleteProvider_provider_1.json"), (Test.Wire.API.Golden.Generated.DeleteProvider_provider.testObject_DeleteProvider_provider_2, "testObject_DeleteProvider_provider_2.json"), (Test.Wire.API.Golden.Generated.DeleteProvider_provider.testObject_DeleteProvider_provider_3, "testObject_DeleteProvider_provider_3.json"), (Test.Wire.API.Golden.Generated.DeleteProvider_provider.testObject_DeleteProvider_provider_4, "testObject_DeleteProvider_provider_4.json"), (Test.Wire.API.Golden.Generated.DeleteProvider_provider.testObject_DeleteProvider_provider_5, "testObject_DeleteProvider_provider_5.json"), (Test.Wire.API.Golden.Generated.DeleteProvider_provider.testObject_DeleteProvider_provider_6, "testObject_DeleteProvider_provider_6.json"), (Test.Wire.API.Golden.Generated.DeleteProvider_provider.testObject_DeleteProvider_provider_7, "testObject_DeleteProvider_provider_7.json"), (Test.Wire.API.Golden.Generated.DeleteProvider_provider.testObject_DeleteProvider_provider_8, "testObject_DeleteProvider_provider_8.json"), (Test.Wire.API.Golden.Generated.DeleteProvider_provider.testObject_DeleteProvider_provider_9, "testObject_DeleteProvider_provider_9.json"), (Test.Wire.API.Golden.Generated.DeleteProvider_provider.testObject_DeleteProvider_provider_10, "testObject_DeleteProvider_provider_10.json"), (Test.Wire.API.Golden.Generated.DeleteProvider_provider.testObject_DeleteProvider_provider_11, "testObject_DeleteProvider_provider_11.json"), (Test.Wire.API.Golden.Generated.DeleteProvider_provider.testObject_DeleteProvider_provider_12, "testObject_DeleteProvider_provider_12.json"), (Test.Wire.API.Golden.Generated.DeleteProvider_provider.testObject_DeleteProvider_provider_13, "testObject_DeleteProvider_provider_13.json"), (Test.Wire.API.Golden.Generated.DeleteProvider_provider.testObject_DeleteProvider_provider_14, "testObject_DeleteProvider_provider_14.json"), (Test.Wire.API.Golden.Generated.DeleteProvider_provider.testObject_DeleteProvider_provider_15, "testObject_DeleteProvider_provider_15.json"), (Test.Wire.API.Golden.Generated.DeleteProvider_provider.testObject_DeleteProvider_provider_16, "testObject_DeleteProvider_provider_16.json"), (Test.Wire.API.Golden.Generated.DeleteProvider_provider.testObject_DeleteProvider_provider_17, "testObject_DeleteProvider_provider_17.json"), (Test.Wire.API.Golden.Generated.DeleteProvider_provider.testObject_DeleteProvider_provider_18, "testObject_DeleteProvider_provider_18.json"), (Test.Wire.API.Golden.Generated.DeleteProvider_provider.testObject_DeleteProvider_provider_19, "testObject_DeleteProvider_provider_19.json"), (Test.Wire.API.Golden.Generated.DeleteProvider_provider.testObject_DeleteProvider_provider_20, "testObject_DeleteProvider_provider_20.json")],
      testGroup "Golden: PasswordReset_provider" $
        testObjects [(Test.Wire.API.Golden.Generated.PasswordReset_provider.testObject_PasswordReset_provider_1, "testObject_PasswordReset_provider_1.json"), (Test.Wire.API.Golden.Generated.PasswordReset_provider.testObject_PasswordReset_provider_2, "testObject_PasswordReset_provider_2.json"), (Test.Wire.API.Golden.Generated.PasswordReset_provider.testObject_PasswordReset_provider_3, "testObject_PasswordReset_provider_3.json"), (Test.Wire.API.Golden.Generated.PasswordReset_provider.testObject_PasswordReset_provider_4, "testObject_PasswordReset_provider_4.json"), (Test.Wire.API.Golden.Generated.PasswordReset_provider.testObject_PasswordReset_provider_5, "testObject_PasswordReset_provider_5.json"), (Test.Wire.API.Golden.Generated.PasswordReset_provider.testObject_PasswordReset_provider_6, "testObject_PasswordReset_provider_6.json"), (Test.Wire.API.Golden.Generated.PasswordReset_provider.testObject_PasswordReset_provider_7, "testObject_PasswordReset_provider_7.json"), (Test.Wire.API.Golden.Generated.PasswordReset_provider.testObject_PasswordReset_provider_8, "testObject_PasswordReset_provider_8.json"), (Test.Wire.API.Golden.Generated.PasswordReset_provider.testObject_PasswordReset_provider_9, "testObject_PasswordReset_provider_9.json"), (Test.Wire.API.Golden.Generated.PasswordReset_provider.testObject_PasswordReset_provider_10, "testObject_PasswordReset_provider_10.json"), (Test.Wire.API.Golden.Generated.PasswordReset_provider.testObject_PasswordReset_provider_11, "testObject_PasswordReset_provider_11.json"), (Test.Wire.API.Golden.Generated.PasswordReset_provider.testObject_PasswordReset_provider_12, "testObject_PasswordReset_provider_12.json"), (Test.Wire.API.Golden.Generated.PasswordReset_provider.testObject_PasswordReset_provider_13, "testObject_PasswordReset_provider_13.json"), (Test.Wire.API.Golden.Generated.PasswordReset_provider.testObject_PasswordReset_provider_14, "testObject_PasswordReset_provider_14.json"), (Test.Wire.API.Golden.Generated.PasswordReset_provider.testObject_PasswordReset_provider_15, "testObject_PasswordReset_provider_15.json"), (Test.Wire.API.Golden.Generated.PasswordReset_provider.testObject_PasswordReset_provider_16, "testObject_PasswordReset_provider_16.json"), (Test.Wire.API.Golden.Generated.PasswordReset_provider.testObject_PasswordReset_provider_17, "testObject_PasswordReset_provider_17.json"), (Test.Wire.API.Golden.Generated.PasswordReset_provider.testObject_PasswordReset_provider_18, "testObject_PasswordReset_provider_18.json"), (Test.Wire.API.Golden.Generated.PasswordReset_provider.testObject_PasswordReset_provider_19, "testObject_PasswordReset_provider_19.json"), (Test.Wire.API.Golden.Generated.PasswordReset_provider.testObject_PasswordReset_provider_20, "testObject_PasswordReset_provider_20.json")],
      testGroup "Golden: CompletePasswordReset_provider" $
        testObjects [(Test.Wire.API.Golden.Generated.CompletePasswordReset_provider.testObject_CompletePasswordReset_provider_1, "testObject_CompletePasswordReset_provider_1.json"), (Test.Wire.API.Golden.Generated.CompletePasswordReset_provider.testObject_CompletePasswordReset_provider_2, "testObject_CompletePasswordReset_provider_2.json"), (Test.Wire.API.Golden.Generated.CompletePasswordReset_provider.testObject_CompletePasswordReset_provider_3, "testObject_CompletePasswordReset_provider_3.json"), (Test.Wire.API.Golden.Generated.CompletePasswordReset_provider.testObject_CompletePasswordReset_provider_4, "testObject_CompletePasswordReset_provider_4.json"), (Test.Wire.API.Golden.Generated.CompletePasswordReset_provider.testObject_CompletePasswordReset_provider_5, "testObject_CompletePasswordReset_provider_5.json"), (Test.Wire.API.Golden.Generated.CompletePasswordReset_provider.testObject_CompletePasswordReset_provider_6, "testObject_CompletePasswordReset_provider_6.json"), (Test.Wire.API.Golden.Generated.CompletePasswordReset_provider.testObject_CompletePasswordReset_provider_7, "testObject_CompletePasswordReset_provider_7.json"), (Test.Wire.API.Golden.Generated.CompletePasswordReset_provider.testObject_CompletePasswordReset_provider_8, "testObject_CompletePasswordReset_provider_8.json"), (Test.Wire.API.Golden.Generated.CompletePasswordReset_provider.testObject_CompletePasswordReset_provider_9, "testObject_CompletePasswordReset_provider_9.json"), (Test.Wire.API.Golden.Generated.CompletePasswordReset_provider.testObject_CompletePasswordReset_provider_10, "testObject_CompletePasswordReset_provider_10.json"), (Test.Wire.API.Golden.Generated.CompletePasswordReset_provider.testObject_CompletePasswordReset_provider_11, "testObject_CompletePasswordReset_provider_11.json"), (Test.Wire.API.Golden.Generated.CompletePasswordReset_provider.testObject_CompletePasswordReset_provider_12, "testObject_CompletePasswordReset_provider_12.json"), (Test.Wire.API.Golden.Generated.CompletePasswordReset_provider.testObject_CompletePasswordReset_provider_13, "testObject_CompletePasswordReset_provider_13.json"), (Test.Wire.API.Golden.Generated.CompletePasswordReset_provider.testObject_CompletePasswordReset_provider_14, "testObject_CompletePasswordReset_provider_14.json"), (Test.Wire.API.Golden.Generated.CompletePasswordReset_provider.testObject_CompletePasswordReset_provider_15, "testObject_CompletePasswordReset_provider_15.json"), (Test.Wire.API.Golden.Generated.CompletePasswordReset_provider.testObject_CompletePasswordReset_provider_16, "testObject_CompletePasswordReset_provider_16.json"), (Test.Wire.API.Golden.Generated.CompletePasswordReset_provider.testObject_CompletePasswordReset_provider_17, "testObject_CompletePasswordReset_provider_17.json"), (Test.Wire.API.Golden.Generated.CompletePasswordReset_provider.testObject_CompletePasswordReset_provider_18, "testObject_CompletePasswordReset_provider_18.json"), (Test.Wire.API.Golden.Generated.CompletePasswordReset_provider.testObject_CompletePasswordReset_provider_19, "testObject_CompletePasswordReset_provider_19.json"), (Test.Wire.API.Golden.Generated.CompletePasswordReset_provider.testObject_CompletePasswordReset_provider_20, "testObject_CompletePasswordReset_provider_20.json")],
      testGroup "Golden: PasswordChange_provider" $
        testObjects [(Test.Wire.API.Golden.Generated.PasswordChange_provider.testObject_PasswordChange_provider_1, "testObject_PasswordChange_provider_1.json"), (Test.Wire.API.Golden.Generated.PasswordChange_provider.testObject_PasswordChange_provider_2, "testObject_PasswordChange_provider_2.json"), (Test.Wire.API.Golden.Generated.PasswordChange_provider.testObject_PasswordChange_provider_3, "testObject_PasswordChange_provider_3.json"), (Test.Wire.API.Golden.Generated.PasswordChange_provider.testObject_PasswordChange_provider_4, "testObject_PasswordChange_provider_4.json"), (Test.Wire.API.Golden.Generated.PasswordChange_provider.testObject_PasswordChange_provider_5, "testObject_PasswordChange_provider_5.json"), (Test.Wire.API.Golden.Generated.PasswordChange_provider.testObject_PasswordChange_provider_6, "testObject_PasswordChange_provider_6.json"), (Test.Wire.API.Golden.Generated.PasswordChange_provider.testObject_PasswordChange_provider_7, "testObject_PasswordChange_provider_7.json"), (Test.Wire.API.Golden.Generated.PasswordChange_provider.testObject_PasswordChange_provider_8, "testObject_PasswordChange_provider_8.json"), (Test.Wire.API.Golden.Generated.PasswordChange_provider.testObject_PasswordChange_provider_9, "testObject_PasswordChange_provider_9.json"), (Test.Wire.API.Golden.Generated.PasswordChange_provider.testObject_PasswordChange_provider_10, "testObject_PasswordChange_provider_10.json"), (Test.Wire.API.Golden.Generated.PasswordChange_provider.testObject_PasswordChange_provider_11, "testObject_PasswordChange_provider_11.json"), (Test.Wire.API.Golden.Generated.PasswordChange_provider.testObject_PasswordChange_provider_12, "testObject_PasswordChange_provider_12.json"), (Test.Wire.API.Golden.Generated.PasswordChange_provider.testObject_PasswordChange_provider_13, "testObject_PasswordChange_provider_13.json"), (Test.Wire.API.Golden.Generated.PasswordChange_provider.testObject_PasswordChange_provider_14, "testObject_PasswordChange_provider_14.json"), (Test.Wire.API.Golden.Generated.PasswordChange_provider.testObject_PasswordChange_provider_15, "testObject_PasswordChange_provider_15.json"), (Test.Wire.API.Golden.Generated.PasswordChange_provider.testObject_PasswordChange_provider_16, "testObject_PasswordChange_provider_16.json"), (Test.Wire.API.Golden.Generated.PasswordChange_provider.testObject_PasswordChange_provider_17, "testObject_PasswordChange_provider_17.json"), (Test.Wire.API.Golden.Generated.PasswordChange_provider.testObject_PasswordChange_provider_18, "testObject_PasswordChange_provider_18.json"), (Test.Wire.API.Golden.Generated.PasswordChange_provider.testObject_PasswordChange_provider_19, "testObject_PasswordChange_provider_19.json"), (Test.Wire.API.Golden.Generated.PasswordChange_provider.testObject_PasswordChange_provider_20, "testObject_PasswordChange_provider_20.json")],
      testGroup "Golden: EmailUpdate_provider" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.EmailUpdate_provider.testObject_EmailUpdate_provider_1, "testObject_EmailUpdate_provider_1.json")
          ],
      testGroup "Golden: BotConvView_provider" $
        testObjects [(Test.Wire.API.Golden.Generated.BotConvView_provider.testObject_BotConvView_provider_1, "testObject_BotConvView_provider_1.json"), (Test.Wire.API.Golden.Generated.BotConvView_provider.testObject_BotConvView_provider_2, "testObject_BotConvView_provider_2.json"), (Test.Wire.API.Golden.Generated.BotConvView_provider.testObject_BotConvView_provider_3, "testObject_BotConvView_provider_3.json"), (Test.Wire.API.Golden.Generated.BotConvView_provider.testObject_BotConvView_provider_4, "testObject_BotConvView_provider_4.json"), (Test.Wire.API.Golden.Generated.BotConvView_provider.testObject_BotConvView_provider_5, "testObject_BotConvView_provider_5.json"), (Test.Wire.API.Golden.Generated.BotConvView_provider.testObject_BotConvView_provider_6, "testObject_BotConvView_provider_6.json"), (Test.Wire.API.Golden.Generated.BotConvView_provider.testObject_BotConvView_provider_7, "testObject_BotConvView_provider_7.json"), (Test.Wire.API.Golden.Generated.BotConvView_provider.testObject_BotConvView_provider_8, "testObject_BotConvView_provider_8.json"), (Test.Wire.API.Golden.Generated.BotConvView_provider.testObject_BotConvView_provider_9, "testObject_BotConvView_provider_9.json"), (Test.Wire.API.Golden.Generated.BotConvView_provider.testObject_BotConvView_provider_10, "testObject_BotConvView_provider_10.json"), (Test.Wire.API.Golden.Generated.BotConvView_provider.testObject_BotConvView_provider_11, "testObject_BotConvView_provider_11.json"), (Test.Wire.API.Golden.Generated.BotConvView_provider.testObject_BotConvView_provider_12, "testObject_BotConvView_provider_12.json"), (Test.Wire.API.Golden.Generated.BotConvView_provider.testObject_BotConvView_provider_13, "testObject_BotConvView_provider_13.json"), (Test.Wire.API.Golden.Generated.BotConvView_provider.testObject_BotConvView_provider_14, "testObject_BotConvView_provider_14.json"), (Test.Wire.API.Golden.Generated.BotConvView_provider.testObject_BotConvView_provider_15, "testObject_BotConvView_provider_15.json"), (Test.Wire.API.Golden.Generated.BotConvView_provider.testObject_BotConvView_provider_16, "testObject_BotConvView_provider_16.json"), (Test.Wire.API.Golden.Generated.BotConvView_provider.testObject_BotConvView_provider_17, "testObject_BotConvView_provider_17.json"), (Test.Wire.API.Golden.Generated.BotConvView_provider.testObject_BotConvView_provider_18, "testObject_BotConvView_provider_18.json"), (Test.Wire.API.Golden.Generated.BotConvView_provider.testObject_BotConvView_provider_19, "testObject_BotConvView_provider_19.json"), (Test.Wire.API.Golden.Generated.BotConvView_provider.testObject_BotConvView_provider_20, "testObject_BotConvView_provider_20.json")],
      testGroup "Golden: BotUserView_provider" $
        testObjects [(Test.Wire.API.Golden.Generated.BotUserView_provider.testObject_BotUserView_provider_1, "testObject_BotUserView_provider_1.json"), (Test.Wire.API.Golden.Generated.BotUserView_provider.testObject_BotUserView_provider_2, "testObject_BotUserView_provider_2.json"), (Test.Wire.API.Golden.Generated.BotUserView_provider.testObject_BotUserView_provider_3, "testObject_BotUserView_provider_3.json"), (Test.Wire.API.Golden.Generated.BotUserView_provider.testObject_BotUserView_provider_4, "testObject_BotUserView_provider_4.json"), (Test.Wire.API.Golden.Generated.BotUserView_provider.testObject_BotUserView_provider_5, "testObject_BotUserView_provider_5.json"), (Test.Wire.API.Golden.Generated.BotUserView_provider.testObject_BotUserView_provider_6, "testObject_BotUserView_provider_6.json"), (Test.Wire.API.Golden.Generated.BotUserView_provider.testObject_BotUserView_provider_7, "testObject_BotUserView_provider_7.json"), (Test.Wire.API.Golden.Generated.BotUserView_provider.testObject_BotUserView_provider_8, "testObject_BotUserView_provider_8.json"), (Test.Wire.API.Golden.Generated.BotUserView_provider.testObject_BotUserView_provider_9, "testObject_BotUserView_provider_9.json"), (Test.Wire.API.Golden.Generated.BotUserView_provider.testObject_BotUserView_provider_10, "testObject_BotUserView_provider_10.json"), (Test.Wire.API.Golden.Generated.BotUserView_provider.testObject_BotUserView_provider_11, "testObject_BotUserView_provider_11.json"), (Test.Wire.API.Golden.Generated.BotUserView_provider.testObject_BotUserView_provider_12, "testObject_BotUserView_provider_12.json"), (Test.Wire.API.Golden.Generated.BotUserView_provider.testObject_BotUserView_provider_13, "testObject_BotUserView_provider_13.json"), (Test.Wire.API.Golden.Generated.BotUserView_provider.testObject_BotUserView_provider_14, "testObject_BotUserView_provider_14.json"), (Test.Wire.API.Golden.Generated.BotUserView_provider.testObject_BotUserView_provider_15, "testObject_BotUserView_provider_15.json"), (Test.Wire.API.Golden.Generated.BotUserView_provider.testObject_BotUserView_provider_16, "testObject_BotUserView_provider_16.json"), (Test.Wire.API.Golden.Generated.BotUserView_provider.testObject_BotUserView_provider_17, "testObject_BotUserView_provider_17.json"), (Test.Wire.API.Golden.Generated.BotUserView_provider.testObject_BotUserView_provider_18, "testObject_BotUserView_provider_18.json"), (Test.Wire.API.Golden.Generated.BotUserView_provider.testObject_BotUserView_provider_19, "testObject_BotUserView_provider_19.json"), (Test.Wire.API.Golden.Generated.BotUserView_provider.testObject_BotUserView_provider_20, "testObject_BotUserView_provider_20.json")],
      testGroup "Golden: NewBotRequest_provider" $
        testObjects [(Test.Wire.API.Golden.Generated.NewBotRequest_provider.testObject_NewBotRequest_provider_1, "testObject_NewBotRequest_provider_1.json"), (Test.Wire.API.Golden.Generated.NewBotRequest_provider.testObject_NewBotRequest_provider_2, "testObject_NewBotRequest_provider_2.json"), (Test.Wire.API.Golden.Generated.NewBotRequest_provider.testObject_NewBotRequest_provider_3, "testObject_NewBotRequest_provider_3.json"), (Test.Wire.API.Golden.Generated.NewBotRequest_provider.testObject_NewBotRequest_provider_4, "testObject_NewBotRequest_provider_4.json"), (Test.Wire.API.Golden.Generated.NewBotRequest_provider.testObject_NewBotRequest_provider_5, "testObject_NewBotRequest_provider_5.json"), (Test.Wire.API.Golden.Generated.NewBotRequest_provider.testObject_NewBotRequest_provider_6, "testObject_NewBotRequest_provider_6.json"), (Test.Wire.API.Golden.Generated.NewBotRequest_provider.testObject_NewBotRequest_provider_7, "testObject_NewBotRequest_provider_7.json"), (Test.Wire.API.Golden.Generated.NewBotRequest_provider.testObject_NewBotRequest_provider_8, "testObject_NewBotRequest_provider_8.json"), (Test.Wire.API.Golden.Generated.NewBotRequest_provider.testObject_NewBotRequest_provider_9, "testObject_NewBotRequest_provider_9.json"), (Test.Wire.API.Golden.Generated.NewBotRequest_provider.testObject_NewBotRequest_provider_10, "testObject_NewBotRequest_provider_10.json"), (Test.Wire.API.Golden.Generated.NewBotRequest_provider.testObject_NewBotRequest_provider_11, "testObject_NewBotRequest_provider_11.json"), (Test.Wire.API.Golden.Generated.NewBotRequest_provider.testObject_NewBotRequest_provider_12, "testObject_NewBotRequest_provider_12.json"), (Test.Wire.API.Golden.Generated.NewBotRequest_provider.testObject_NewBotRequest_provider_13, "testObject_NewBotRequest_provider_13.json"), (Test.Wire.API.Golden.Generated.NewBotRequest_provider.testObject_NewBotRequest_provider_14, "testObject_NewBotRequest_provider_14.json"), (Test.Wire.API.Golden.Generated.NewBotRequest_provider.testObject_NewBotRequest_provider_15, "testObject_NewBotRequest_provider_15.json"), (Test.Wire.API.Golden.Generated.NewBotRequest_provider.testObject_NewBotRequest_provider_16, "testObject_NewBotRequest_provider_16.json"), (Test.Wire.API.Golden.Generated.NewBotRequest_provider.testObject_NewBotRequest_provider_17, "testObject_NewBotRequest_provider_17.json"), (Test.Wire.API.Golden.Generated.NewBotRequest_provider.testObject_NewBotRequest_provider_18, "testObject_NewBotRequest_provider_18.json"), (Test.Wire.API.Golden.Generated.NewBotRequest_provider.testObject_NewBotRequest_provider_19, "testObject_NewBotRequest_provider_19.json"), (Test.Wire.API.Golden.Generated.NewBotRequest_provider.testObject_NewBotRequest_provider_20, "testObject_NewBotRequest_provider_20.json")],
      testGroup "Golden: NewBotResponse_provider" $
        testObjects [(Test.Wire.API.Golden.Generated.NewBotResponse_provider.testObject_NewBotResponse_provider_1, "testObject_NewBotResponse_provider_1.json"), (Test.Wire.API.Golden.Generated.NewBotResponse_provider.testObject_NewBotResponse_provider_2, "testObject_NewBotResponse_provider_2.json"), (Test.Wire.API.Golden.Generated.NewBotResponse_provider.testObject_NewBotResponse_provider_3, "testObject_NewBotResponse_provider_3.json"), (Test.Wire.API.Golden.Generated.NewBotResponse_provider.testObject_NewBotResponse_provider_4, "testObject_NewBotResponse_provider_4.json"), (Test.Wire.API.Golden.Generated.NewBotResponse_provider.testObject_NewBotResponse_provider_5, "testObject_NewBotResponse_provider_5.json"), (Test.Wire.API.Golden.Generated.NewBotResponse_provider.testObject_NewBotResponse_provider_6, "testObject_NewBotResponse_provider_6.json"), (Test.Wire.API.Golden.Generated.NewBotResponse_provider.testObject_NewBotResponse_provider_7, "testObject_NewBotResponse_provider_7.json"), (Test.Wire.API.Golden.Generated.NewBotResponse_provider.testObject_NewBotResponse_provider_8, "testObject_NewBotResponse_provider_8.json"), (Test.Wire.API.Golden.Generated.NewBotResponse_provider.testObject_NewBotResponse_provider_9, "testObject_NewBotResponse_provider_9.json"), (Test.Wire.API.Golden.Generated.NewBotResponse_provider.testObject_NewBotResponse_provider_10, "testObject_NewBotResponse_provider_10.json"), (Test.Wire.API.Golden.Generated.NewBotResponse_provider.testObject_NewBotResponse_provider_11, "testObject_NewBotResponse_provider_11.json"), (Test.Wire.API.Golden.Generated.NewBotResponse_provider.testObject_NewBotResponse_provider_12, "testObject_NewBotResponse_provider_12.json"), (Test.Wire.API.Golden.Generated.NewBotResponse_provider.testObject_NewBotResponse_provider_13, "testObject_NewBotResponse_provider_13.json"), (Test.Wire.API.Golden.Generated.NewBotResponse_provider.testObject_NewBotResponse_provider_14, "testObject_NewBotResponse_provider_14.json"), (Test.Wire.API.Golden.Generated.NewBotResponse_provider.testObject_NewBotResponse_provider_15, "testObject_NewBotResponse_provider_15.json"), (Test.Wire.API.Golden.Generated.NewBotResponse_provider.testObject_NewBotResponse_provider_16, "testObject_NewBotResponse_provider_16.json"), (Test.Wire.API.Golden.Generated.NewBotResponse_provider.testObject_NewBotResponse_provider_17, "testObject_NewBotResponse_provider_17.json"), (Test.Wire.API.Golden.Generated.NewBotResponse_provider.testObject_NewBotResponse_provider_18, "testObject_NewBotResponse_provider_18.json"), (Test.Wire.API.Golden.Generated.NewBotResponse_provider.testObject_NewBotResponse_provider_19, "testObject_NewBotResponse_provider_19.json"), (Test.Wire.API.Golden.Generated.NewBotResponse_provider.testObject_NewBotResponse_provider_20, "testObject_NewBotResponse_provider_20.json")],
      testGroup "Golden: ServiceRef_provider" $
        testObjects [(Test.Wire.API.Golden.Generated.ServiceRef_provider.testObject_ServiceRef_provider_1, "testObject_ServiceRef_provider_1.json"), (Test.Wire.API.Golden.Generated.ServiceRef_provider.testObject_ServiceRef_provider_2, "testObject_ServiceRef_provider_2.json"), (Test.Wire.API.Golden.Generated.ServiceRef_provider.testObject_ServiceRef_provider_3, "testObject_ServiceRef_provider_3.json"), (Test.Wire.API.Golden.Generated.ServiceRef_provider.testObject_ServiceRef_provider_4, "testObject_ServiceRef_provider_4.json"), (Test.Wire.API.Golden.Generated.ServiceRef_provider.testObject_ServiceRef_provider_5, "testObject_ServiceRef_provider_5.json"), (Test.Wire.API.Golden.Generated.ServiceRef_provider.testObject_ServiceRef_provider_6, "testObject_ServiceRef_provider_6.json"), (Test.Wire.API.Golden.Generated.ServiceRef_provider.testObject_ServiceRef_provider_7, "testObject_ServiceRef_provider_7.json"), (Test.Wire.API.Golden.Generated.ServiceRef_provider.testObject_ServiceRef_provider_8, "testObject_ServiceRef_provider_8.json"), (Test.Wire.API.Golden.Generated.ServiceRef_provider.testObject_ServiceRef_provider_9, "testObject_ServiceRef_provider_9.json"), (Test.Wire.API.Golden.Generated.ServiceRef_provider.testObject_ServiceRef_provider_10, "testObject_ServiceRef_provider_10.json"), (Test.Wire.API.Golden.Generated.ServiceRef_provider.testObject_ServiceRef_provider_11, "testObject_ServiceRef_provider_11.json"), (Test.Wire.API.Golden.Generated.ServiceRef_provider.testObject_ServiceRef_provider_12, "testObject_ServiceRef_provider_12.json"), (Test.Wire.API.Golden.Generated.ServiceRef_provider.testObject_ServiceRef_provider_13, "testObject_ServiceRef_provider_13.json"), (Test.Wire.API.Golden.Generated.ServiceRef_provider.testObject_ServiceRef_provider_14, "testObject_ServiceRef_provider_14.json"), (Test.Wire.API.Golden.Generated.ServiceRef_provider.testObject_ServiceRef_provider_15, "testObject_ServiceRef_provider_15.json"), (Test.Wire.API.Golden.Generated.ServiceRef_provider.testObject_ServiceRef_provider_16, "testObject_ServiceRef_provider_16.json"), (Test.Wire.API.Golden.Generated.ServiceRef_provider.testObject_ServiceRef_provider_17, "testObject_ServiceRef_provider_17.json"), (Test.Wire.API.Golden.Generated.ServiceRef_provider.testObject_ServiceRef_provider_18, "testObject_ServiceRef_provider_18.json"), (Test.Wire.API.Golden.Generated.ServiceRef_provider.testObject_ServiceRef_provider_19, "testObject_ServiceRef_provider_19.json"), (Test.Wire.API.Golden.Generated.ServiceRef_provider.testObject_ServiceRef_provider_20, "testObject_ServiceRef_provider_20.json")],
      testGroup "Golden: ServiceKeyPEM_provider" $
        testObjects [(Test.Wire.API.Golden.Generated.ServiceKeyPEM_provider.testObject_ServiceKeyPEM_provider_1, "testObject_ServiceKeyPEM_provider_1.json"), (Test.Wire.API.Golden.Generated.ServiceKeyPEM_provider.testObject_ServiceKeyPEM_provider_2, "testObject_ServiceKeyPEM_provider_2.json"), (Test.Wire.API.Golden.Generated.ServiceKeyPEM_provider.testObject_ServiceKeyPEM_provider_3, "testObject_ServiceKeyPEM_provider_3.json"), (Test.Wire.API.Golden.Generated.ServiceKeyPEM_provider.testObject_ServiceKeyPEM_provider_4, "testObject_ServiceKeyPEM_provider_4.json"), (Test.Wire.API.Golden.Generated.ServiceKeyPEM_provider.testObject_ServiceKeyPEM_provider_5, "testObject_ServiceKeyPEM_provider_5.json"), (Test.Wire.API.Golden.Generated.ServiceKeyPEM_provider.testObject_ServiceKeyPEM_provider_6, "testObject_ServiceKeyPEM_provider_6.json"), (Test.Wire.API.Golden.Generated.ServiceKeyPEM_provider.testObject_ServiceKeyPEM_provider_7, "testObject_ServiceKeyPEM_provider_7.json"), (Test.Wire.API.Golden.Generated.ServiceKeyPEM_provider.testObject_ServiceKeyPEM_provider_8, "testObject_ServiceKeyPEM_provider_8.json"), (Test.Wire.API.Golden.Generated.ServiceKeyPEM_provider.testObject_ServiceKeyPEM_provider_9, "testObject_ServiceKeyPEM_provider_9.json"), (Test.Wire.API.Golden.Generated.ServiceKeyPEM_provider.testObject_ServiceKeyPEM_provider_10, "testObject_ServiceKeyPEM_provider_10.json"), (Test.Wire.API.Golden.Generated.ServiceKeyPEM_provider.testObject_ServiceKeyPEM_provider_11, "testObject_ServiceKeyPEM_provider_11.json"), (Test.Wire.API.Golden.Generated.ServiceKeyPEM_provider.testObject_ServiceKeyPEM_provider_12, "testObject_ServiceKeyPEM_provider_12.json"), (Test.Wire.API.Golden.Generated.ServiceKeyPEM_provider.testObject_ServiceKeyPEM_provider_13, "testObject_ServiceKeyPEM_provider_13.json"), (Test.Wire.API.Golden.Generated.ServiceKeyPEM_provider.testObject_ServiceKeyPEM_provider_14, "testObject_ServiceKeyPEM_provider_14.json"), (Test.Wire.API.Golden.Generated.ServiceKeyPEM_provider.testObject_ServiceKeyPEM_provider_15, "testObject_ServiceKeyPEM_provider_15.json"), (Test.Wire.API.Golden.Generated.ServiceKeyPEM_provider.testObject_ServiceKeyPEM_provider_16, "testObject_ServiceKeyPEM_provider_16.json"), (Test.Wire.API.Golden.Generated.ServiceKeyPEM_provider.testObject_ServiceKeyPEM_provider_17, "testObject_ServiceKeyPEM_provider_17.json"), (Test.Wire.API.Golden.Generated.ServiceKeyPEM_provider.testObject_ServiceKeyPEM_provider_18, "testObject_ServiceKeyPEM_provider_18.json"), (Test.Wire.API.Golden.Generated.ServiceKeyPEM_provider.testObject_ServiceKeyPEM_provider_19, "testObject_ServiceKeyPEM_provider_19.json"), (Test.Wire.API.Golden.Generated.ServiceKeyPEM_provider.testObject_ServiceKeyPEM_provider_20, "testObject_ServiceKeyPEM_provider_20.json")],
      testGroup "Golden: ServiceKeyType_provider" $
        testObjects [(Test.Wire.API.Golden.Generated.ServiceKeyType_provider.testObject_ServiceKeyType_provider_1, "testObject_ServiceKeyType_provider_1.json"), (Test.Wire.API.Golden.Generated.ServiceKeyType_provider.testObject_ServiceKeyType_provider_2, "testObject_ServiceKeyType_provider_2.json"), (Test.Wire.API.Golden.Generated.ServiceKeyType_provider.testObject_ServiceKeyType_provider_3, "testObject_ServiceKeyType_provider_3.json"), (Test.Wire.API.Golden.Generated.ServiceKeyType_provider.testObject_ServiceKeyType_provider_4, "testObject_ServiceKeyType_provider_4.json"), (Test.Wire.API.Golden.Generated.ServiceKeyType_provider.testObject_ServiceKeyType_provider_5, "testObject_ServiceKeyType_provider_5.json"), (Test.Wire.API.Golden.Generated.ServiceKeyType_provider.testObject_ServiceKeyType_provider_6, "testObject_ServiceKeyType_provider_6.json"), (Test.Wire.API.Golden.Generated.ServiceKeyType_provider.testObject_ServiceKeyType_provider_7, "testObject_ServiceKeyType_provider_7.json"), (Test.Wire.API.Golden.Generated.ServiceKeyType_provider.testObject_ServiceKeyType_provider_8, "testObject_ServiceKeyType_provider_8.json"), (Test.Wire.API.Golden.Generated.ServiceKeyType_provider.testObject_ServiceKeyType_provider_9, "testObject_ServiceKeyType_provider_9.json"), (Test.Wire.API.Golden.Generated.ServiceKeyType_provider.testObject_ServiceKeyType_provider_10, "testObject_ServiceKeyType_provider_10.json"), (Test.Wire.API.Golden.Generated.ServiceKeyType_provider.testObject_ServiceKeyType_provider_11, "testObject_ServiceKeyType_provider_11.json"), (Test.Wire.API.Golden.Generated.ServiceKeyType_provider.testObject_ServiceKeyType_provider_12, "testObject_ServiceKeyType_provider_12.json"), (Test.Wire.API.Golden.Generated.ServiceKeyType_provider.testObject_ServiceKeyType_provider_13, "testObject_ServiceKeyType_provider_13.json"), (Test.Wire.API.Golden.Generated.ServiceKeyType_provider.testObject_ServiceKeyType_provider_14, "testObject_ServiceKeyType_provider_14.json"), (Test.Wire.API.Golden.Generated.ServiceKeyType_provider.testObject_ServiceKeyType_provider_15, "testObject_ServiceKeyType_provider_15.json"), (Test.Wire.API.Golden.Generated.ServiceKeyType_provider.testObject_ServiceKeyType_provider_16, "testObject_ServiceKeyType_provider_16.json"), (Test.Wire.API.Golden.Generated.ServiceKeyType_provider.testObject_ServiceKeyType_provider_17, "testObject_ServiceKeyType_provider_17.json"), (Test.Wire.API.Golden.Generated.ServiceKeyType_provider.testObject_ServiceKeyType_provider_18, "testObject_ServiceKeyType_provider_18.json"), (Test.Wire.API.Golden.Generated.ServiceKeyType_provider.testObject_ServiceKeyType_provider_19, "testObject_ServiceKeyType_provider_19.json"), (Test.Wire.API.Golden.Generated.ServiceKeyType_provider.testObject_ServiceKeyType_provider_20, "testObject_ServiceKeyType_provider_20.json")],
      testGroup "Golden: ServiceKey_provider" $
        testObjects [(Test.Wire.API.Golden.Generated.ServiceKey_provider.testObject_ServiceKey_provider_1, "testObject_ServiceKey_provider_1.json"), (Test.Wire.API.Golden.Generated.ServiceKey_provider.testObject_ServiceKey_provider_2, "testObject_ServiceKey_provider_2.json"), (Test.Wire.API.Golden.Generated.ServiceKey_provider.testObject_ServiceKey_provider_3, "testObject_ServiceKey_provider_3.json"), (Test.Wire.API.Golden.Generated.ServiceKey_provider.testObject_ServiceKey_provider_4, "testObject_ServiceKey_provider_4.json"), (Test.Wire.API.Golden.Generated.ServiceKey_provider.testObject_ServiceKey_provider_5, "testObject_ServiceKey_provider_5.json"), (Test.Wire.API.Golden.Generated.ServiceKey_provider.testObject_ServiceKey_provider_6, "testObject_ServiceKey_provider_6.json"), (Test.Wire.API.Golden.Generated.ServiceKey_provider.testObject_ServiceKey_provider_7, "testObject_ServiceKey_provider_7.json"), (Test.Wire.API.Golden.Generated.ServiceKey_provider.testObject_ServiceKey_provider_8, "testObject_ServiceKey_provider_8.json"), (Test.Wire.API.Golden.Generated.ServiceKey_provider.testObject_ServiceKey_provider_9, "testObject_ServiceKey_provider_9.json"), (Test.Wire.API.Golden.Generated.ServiceKey_provider.testObject_ServiceKey_provider_10, "testObject_ServiceKey_provider_10.json"), (Test.Wire.API.Golden.Generated.ServiceKey_provider.testObject_ServiceKey_provider_11, "testObject_ServiceKey_provider_11.json"), (Test.Wire.API.Golden.Generated.ServiceKey_provider.testObject_ServiceKey_provider_12, "testObject_ServiceKey_provider_12.json"), (Test.Wire.API.Golden.Generated.ServiceKey_provider.testObject_ServiceKey_provider_13, "testObject_ServiceKey_provider_13.json"), (Test.Wire.API.Golden.Generated.ServiceKey_provider.testObject_ServiceKey_provider_14, "testObject_ServiceKey_provider_14.json"), (Test.Wire.API.Golden.Generated.ServiceKey_provider.testObject_ServiceKey_provider_15, "testObject_ServiceKey_provider_15.json"), (Test.Wire.API.Golden.Generated.ServiceKey_provider.testObject_ServiceKey_provider_16, "testObject_ServiceKey_provider_16.json"), (Test.Wire.API.Golden.Generated.ServiceKey_provider.testObject_ServiceKey_provider_17, "testObject_ServiceKey_provider_17.json"), (Test.Wire.API.Golden.Generated.ServiceKey_provider.testObject_ServiceKey_provider_18, "testObject_ServiceKey_provider_18.json"), (Test.Wire.API.Golden.Generated.ServiceKey_provider.testObject_ServiceKey_provider_19, "testObject_ServiceKey_provider_19.json"), (Test.Wire.API.Golden.Generated.ServiceKey_provider.testObject_ServiceKey_provider_20, "testObject_ServiceKey_provider_20.json")],
      testGroup "Golden: ServiceToken_provider" $
        testObjects [(Test.Wire.API.Golden.Generated.ServiceToken_provider.testObject_ServiceToken_provider_1, "testObject_ServiceToken_provider_1.json"), (Test.Wire.API.Golden.Generated.ServiceToken_provider.testObject_ServiceToken_provider_2, "testObject_ServiceToken_provider_2.json"), (Test.Wire.API.Golden.Generated.ServiceToken_provider.testObject_ServiceToken_provider_3, "testObject_ServiceToken_provider_3.json"), (Test.Wire.API.Golden.Generated.ServiceToken_provider.testObject_ServiceToken_provider_4, "testObject_ServiceToken_provider_4.json"), (Test.Wire.API.Golden.Generated.ServiceToken_provider.testObject_ServiceToken_provider_5, "testObject_ServiceToken_provider_5.json"), (Test.Wire.API.Golden.Generated.ServiceToken_provider.testObject_ServiceToken_provider_6, "testObject_ServiceToken_provider_6.json"), (Test.Wire.API.Golden.Generated.ServiceToken_provider.testObject_ServiceToken_provider_7, "testObject_ServiceToken_provider_7.json"), (Test.Wire.API.Golden.Generated.ServiceToken_provider.testObject_ServiceToken_provider_8, "testObject_ServiceToken_provider_8.json"), (Test.Wire.API.Golden.Generated.ServiceToken_provider.testObject_ServiceToken_provider_9, "testObject_ServiceToken_provider_9.json"), (Test.Wire.API.Golden.Generated.ServiceToken_provider.testObject_ServiceToken_provider_10, "testObject_ServiceToken_provider_10.json"), (Test.Wire.API.Golden.Generated.ServiceToken_provider.testObject_ServiceToken_provider_11, "testObject_ServiceToken_provider_11.json"), (Test.Wire.API.Golden.Generated.ServiceToken_provider.testObject_ServiceToken_provider_12, "testObject_ServiceToken_provider_12.json"), (Test.Wire.API.Golden.Generated.ServiceToken_provider.testObject_ServiceToken_provider_13, "testObject_ServiceToken_provider_13.json"), (Test.Wire.API.Golden.Generated.ServiceToken_provider.testObject_ServiceToken_provider_14, "testObject_ServiceToken_provider_14.json"), (Test.Wire.API.Golden.Generated.ServiceToken_provider.testObject_ServiceToken_provider_15, "testObject_ServiceToken_provider_15.json"), (Test.Wire.API.Golden.Generated.ServiceToken_provider.testObject_ServiceToken_provider_16, "testObject_ServiceToken_provider_16.json"), (Test.Wire.API.Golden.Generated.ServiceToken_provider.testObject_ServiceToken_provider_17, "testObject_ServiceToken_provider_17.json"), (Test.Wire.API.Golden.Generated.ServiceToken_provider.testObject_ServiceToken_provider_18, "testObject_ServiceToken_provider_18.json"), (Test.Wire.API.Golden.Generated.ServiceToken_provider.testObject_ServiceToken_provider_19, "testObject_ServiceToken_provider_19.json"), (Test.Wire.API.Golden.Generated.ServiceToken_provider.testObject_ServiceToken_provider_20, "testObject_ServiceToken_provider_20.json")],
      testGroup "Golden: Service_provider" $
        testObjects [(Test.Wire.API.Golden.Generated.Service_provider.testObject_Service_provider_1, "testObject_Service_provider_1.json"), (Test.Wire.API.Golden.Generated.Service_provider.testObject_Service_provider_2, "testObject_Service_provider_2.json"), (Test.Wire.API.Golden.Generated.Service_provider.testObject_Service_provider_3, "testObject_Service_provider_3.json"), (Test.Wire.API.Golden.Generated.Service_provider.testObject_Service_provider_4, "testObject_Service_provider_4.json"), (Test.Wire.API.Golden.Generated.Service_provider.testObject_Service_provider_5, "testObject_Service_provider_5.json"), (Test.Wire.API.Golden.Generated.Service_provider.testObject_Service_provider_6, "testObject_Service_provider_6.json"), (Test.Wire.API.Golden.Generated.Service_provider.testObject_Service_provider_7, "testObject_Service_provider_7.json"), (Test.Wire.API.Golden.Generated.Service_provider.testObject_Service_provider_8, "testObject_Service_provider_8.json"), (Test.Wire.API.Golden.Generated.Service_provider.testObject_Service_provider_9, "testObject_Service_provider_9.json"), (Test.Wire.API.Golden.Generated.Service_provider.testObject_Service_provider_10, "testObject_Service_provider_10.json"), (Test.Wire.API.Golden.Generated.Service_provider.testObject_Service_provider_11, "testObject_Service_provider_11.json"), (Test.Wire.API.Golden.Generated.Service_provider.testObject_Service_provider_12, "testObject_Service_provider_12.json"), (Test.Wire.API.Golden.Generated.Service_provider.testObject_Service_provider_13, "testObject_Service_provider_13.json"), (Test.Wire.API.Golden.Generated.Service_provider.testObject_Service_provider_14, "testObject_Service_provider_14.json"), (Test.Wire.API.Golden.Generated.Service_provider.testObject_Service_provider_15, "testObject_Service_provider_15.json"), (Test.Wire.API.Golden.Generated.Service_provider.testObject_Service_provider_16, "testObject_Service_provider_16.json"), (Test.Wire.API.Golden.Generated.Service_provider.testObject_Service_provider_17, "testObject_Service_provider_17.json"), (Test.Wire.API.Golden.Generated.Service_provider.testObject_Service_provider_18, "testObject_Service_provider_18.json"), (Test.Wire.API.Golden.Generated.Service_provider.testObject_Service_provider_19, "testObject_Service_provider_19.json"), (Test.Wire.API.Golden.Generated.Service_provider.testObject_Service_provider_20, "testObject_Service_provider_20.json")],
      testGroup "Golden: ServiceProfile_provider" $
        testObjects [(Test.Wire.API.Golden.Generated.ServiceProfile_provider.testObject_ServiceProfile_provider_1, "testObject_ServiceProfile_provider_1.json"), (Test.Wire.API.Golden.Generated.ServiceProfile_provider.testObject_ServiceProfile_provider_2, "testObject_ServiceProfile_provider_2.json"), (Test.Wire.API.Golden.Generated.ServiceProfile_provider.testObject_ServiceProfile_provider_3, "testObject_ServiceProfile_provider_3.json"), (Test.Wire.API.Golden.Generated.ServiceProfile_provider.testObject_ServiceProfile_provider_4, "testObject_ServiceProfile_provider_4.json"), (Test.Wire.API.Golden.Generated.ServiceProfile_provider.testObject_ServiceProfile_provider_5, "testObject_ServiceProfile_provider_5.json"), (Test.Wire.API.Golden.Generated.ServiceProfile_provider.testObject_ServiceProfile_provider_6, "testObject_ServiceProfile_provider_6.json"), (Test.Wire.API.Golden.Generated.ServiceProfile_provider.testObject_ServiceProfile_provider_7, "testObject_ServiceProfile_provider_7.json"), (Test.Wire.API.Golden.Generated.ServiceProfile_provider.testObject_ServiceProfile_provider_8, "testObject_ServiceProfile_provider_8.json"), (Test.Wire.API.Golden.Generated.ServiceProfile_provider.testObject_ServiceProfile_provider_9, "testObject_ServiceProfile_provider_9.json"), (Test.Wire.API.Golden.Generated.ServiceProfile_provider.testObject_ServiceProfile_provider_10, "testObject_ServiceProfile_provider_10.json"), (Test.Wire.API.Golden.Generated.ServiceProfile_provider.testObject_ServiceProfile_provider_11, "testObject_ServiceProfile_provider_11.json"), (Test.Wire.API.Golden.Generated.ServiceProfile_provider.testObject_ServiceProfile_provider_12, "testObject_ServiceProfile_provider_12.json"), (Test.Wire.API.Golden.Generated.ServiceProfile_provider.testObject_ServiceProfile_provider_13, "testObject_ServiceProfile_provider_13.json"), (Test.Wire.API.Golden.Generated.ServiceProfile_provider.testObject_ServiceProfile_provider_14, "testObject_ServiceProfile_provider_14.json"), (Test.Wire.API.Golden.Generated.ServiceProfile_provider.testObject_ServiceProfile_provider_15, "testObject_ServiceProfile_provider_15.json"), (Test.Wire.API.Golden.Generated.ServiceProfile_provider.testObject_ServiceProfile_provider_16, "testObject_ServiceProfile_provider_16.json"), (Test.Wire.API.Golden.Generated.ServiceProfile_provider.testObject_ServiceProfile_provider_17, "testObject_ServiceProfile_provider_17.json"), (Test.Wire.API.Golden.Generated.ServiceProfile_provider.testObject_ServiceProfile_provider_18, "testObject_ServiceProfile_provider_18.json"), (Test.Wire.API.Golden.Generated.ServiceProfile_provider.testObject_ServiceProfile_provider_19, "testObject_ServiceProfile_provider_19.json"), (Test.Wire.API.Golden.Generated.ServiceProfile_provider.testObject_ServiceProfile_provider_20, "testObject_ServiceProfile_provider_20.json")],
      testGroup "Golden: ServiceProfilePage_provider" $
        testObjects [(Test.Wire.API.Golden.Generated.ServiceProfilePage_provider.testObject_ServiceProfilePage_provider_1, "testObject_ServiceProfilePage_provider_1.json"), (Test.Wire.API.Golden.Generated.ServiceProfilePage_provider.testObject_ServiceProfilePage_provider_2, "testObject_ServiceProfilePage_provider_2.json"), (Test.Wire.API.Golden.Generated.ServiceProfilePage_provider.testObject_ServiceProfilePage_provider_3, "testObject_ServiceProfilePage_provider_3.json"), (Test.Wire.API.Golden.Generated.ServiceProfilePage_provider.testObject_ServiceProfilePage_provider_4, "testObject_ServiceProfilePage_provider_4.json"), (Test.Wire.API.Golden.Generated.ServiceProfilePage_provider.testObject_ServiceProfilePage_provider_5, "testObject_ServiceProfilePage_provider_5.json"), (Test.Wire.API.Golden.Generated.ServiceProfilePage_provider.testObject_ServiceProfilePage_provider_6, "testObject_ServiceProfilePage_provider_6.json"), (Test.Wire.API.Golden.Generated.ServiceProfilePage_provider.testObject_ServiceProfilePage_provider_7, "testObject_ServiceProfilePage_provider_7.json"), (Test.Wire.API.Golden.Generated.ServiceProfilePage_provider.testObject_ServiceProfilePage_provider_8, "testObject_ServiceProfilePage_provider_8.json"), (Test.Wire.API.Golden.Generated.ServiceProfilePage_provider.testObject_ServiceProfilePage_provider_9, "testObject_ServiceProfilePage_provider_9.json"), (Test.Wire.API.Golden.Generated.ServiceProfilePage_provider.testObject_ServiceProfilePage_provider_10, "testObject_ServiceProfilePage_provider_10.json"), (Test.Wire.API.Golden.Generated.ServiceProfilePage_provider.testObject_ServiceProfilePage_provider_11, "testObject_ServiceProfilePage_provider_11.json"), (Test.Wire.API.Golden.Generated.ServiceProfilePage_provider.testObject_ServiceProfilePage_provider_12, "testObject_ServiceProfilePage_provider_12.json"), (Test.Wire.API.Golden.Generated.ServiceProfilePage_provider.testObject_ServiceProfilePage_provider_13, "testObject_ServiceProfilePage_provider_13.json"), (Test.Wire.API.Golden.Generated.ServiceProfilePage_provider.testObject_ServiceProfilePage_provider_14, "testObject_ServiceProfilePage_provider_14.json"), (Test.Wire.API.Golden.Generated.ServiceProfilePage_provider.testObject_ServiceProfilePage_provider_15, "testObject_ServiceProfilePage_provider_15.json"), (Test.Wire.API.Golden.Generated.ServiceProfilePage_provider.testObject_ServiceProfilePage_provider_16, "testObject_ServiceProfilePage_provider_16.json"), (Test.Wire.API.Golden.Generated.ServiceProfilePage_provider.testObject_ServiceProfilePage_provider_17, "testObject_ServiceProfilePage_provider_17.json"), (Test.Wire.API.Golden.Generated.ServiceProfilePage_provider.testObject_ServiceProfilePage_provider_18, "testObject_ServiceProfilePage_provider_18.json"), (Test.Wire.API.Golden.Generated.ServiceProfilePage_provider.testObject_ServiceProfilePage_provider_19, "testObject_ServiceProfilePage_provider_19.json"), (Test.Wire.API.Golden.Generated.ServiceProfilePage_provider.testObject_ServiceProfilePage_provider_20, "testObject_ServiceProfilePage_provider_20.json")],
      testGroup "Golden: NewService_provider" $
        testObjects [(Test.Wire.API.Golden.Generated.NewService_provider.testObject_NewService_provider_1, "testObject_NewService_provider_1.json"), (Test.Wire.API.Golden.Generated.NewService_provider.testObject_NewService_provider_2, "testObject_NewService_provider_2.json"), (Test.Wire.API.Golden.Generated.NewService_provider.testObject_NewService_provider_3, "testObject_NewService_provider_3.json"), (Test.Wire.API.Golden.Generated.NewService_provider.testObject_NewService_provider_4, "testObject_NewService_provider_4.json"), (Test.Wire.API.Golden.Generated.NewService_provider.testObject_NewService_provider_5, "testObject_NewService_provider_5.json"), (Test.Wire.API.Golden.Generated.NewService_provider.testObject_NewService_provider_6, "testObject_NewService_provider_6.json"), (Test.Wire.API.Golden.Generated.NewService_provider.testObject_NewService_provider_7, "testObject_NewService_provider_7.json"), (Test.Wire.API.Golden.Generated.NewService_provider.testObject_NewService_provider_8, "testObject_NewService_provider_8.json"), (Test.Wire.API.Golden.Generated.NewService_provider.testObject_NewService_provider_9, "testObject_NewService_provider_9.json"), (Test.Wire.API.Golden.Generated.NewService_provider.testObject_NewService_provider_10, "testObject_NewService_provider_10.json"), (Test.Wire.API.Golden.Generated.NewService_provider.testObject_NewService_provider_11, "testObject_NewService_provider_11.json"), (Test.Wire.API.Golden.Generated.NewService_provider.testObject_NewService_provider_12, "testObject_NewService_provider_12.json"), (Test.Wire.API.Golden.Generated.NewService_provider.testObject_NewService_provider_13, "testObject_NewService_provider_13.json"), (Test.Wire.API.Golden.Generated.NewService_provider.testObject_NewService_provider_14, "testObject_NewService_provider_14.json"), (Test.Wire.API.Golden.Generated.NewService_provider.testObject_NewService_provider_15, "testObject_NewService_provider_15.json"), (Test.Wire.API.Golden.Generated.NewService_provider.testObject_NewService_provider_16, "testObject_NewService_provider_16.json"), (Test.Wire.API.Golden.Generated.NewService_provider.testObject_NewService_provider_17, "testObject_NewService_provider_17.json"), (Test.Wire.API.Golden.Generated.NewService_provider.testObject_NewService_provider_18, "testObject_NewService_provider_18.json"), (Test.Wire.API.Golden.Generated.NewService_provider.testObject_NewService_provider_19, "testObject_NewService_provider_19.json"), (Test.Wire.API.Golden.Generated.NewService_provider.testObject_NewService_provider_20, "testObject_NewService_provider_20.json")],
      testGroup "Golden: NewServiceResponse_provider" $
        testObjects [(Test.Wire.API.Golden.Generated.NewServiceResponse_provider.testObject_NewServiceResponse_provider_1, "testObject_NewServiceResponse_provider_1.json"), (Test.Wire.API.Golden.Generated.NewServiceResponse_provider.testObject_NewServiceResponse_provider_2, "testObject_NewServiceResponse_provider_2.json"), (Test.Wire.API.Golden.Generated.NewServiceResponse_provider.testObject_NewServiceResponse_provider_3, "testObject_NewServiceResponse_provider_3.json"), (Test.Wire.API.Golden.Generated.NewServiceResponse_provider.testObject_NewServiceResponse_provider_4, "testObject_NewServiceResponse_provider_4.json"), (Test.Wire.API.Golden.Generated.NewServiceResponse_provider.testObject_NewServiceResponse_provider_5, "testObject_NewServiceResponse_provider_5.json"), (Test.Wire.API.Golden.Generated.NewServiceResponse_provider.testObject_NewServiceResponse_provider_6, "testObject_NewServiceResponse_provider_6.json"), (Test.Wire.API.Golden.Generated.NewServiceResponse_provider.testObject_NewServiceResponse_provider_7, "testObject_NewServiceResponse_provider_7.json"), (Test.Wire.API.Golden.Generated.NewServiceResponse_provider.testObject_NewServiceResponse_provider_8, "testObject_NewServiceResponse_provider_8.json"), (Test.Wire.API.Golden.Generated.NewServiceResponse_provider.testObject_NewServiceResponse_provider_9, "testObject_NewServiceResponse_provider_9.json"), (Test.Wire.API.Golden.Generated.NewServiceResponse_provider.testObject_NewServiceResponse_provider_10, "testObject_NewServiceResponse_provider_10.json"), (Test.Wire.API.Golden.Generated.NewServiceResponse_provider.testObject_NewServiceResponse_provider_11, "testObject_NewServiceResponse_provider_11.json"), (Test.Wire.API.Golden.Generated.NewServiceResponse_provider.testObject_NewServiceResponse_provider_12, "testObject_NewServiceResponse_provider_12.json"), (Test.Wire.API.Golden.Generated.NewServiceResponse_provider.testObject_NewServiceResponse_provider_13, "testObject_NewServiceResponse_provider_13.json"), (Test.Wire.API.Golden.Generated.NewServiceResponse_provider.testObject_NewServiceResponse_provider_14, "testObject_NewServiceResponse_provider_14.json"), (Test.Wire.API.Golden.Generated.NewServiceResponse_provider.testObject_NewServiceResponse_provider_15, "testObject_NewServiceResponse_provider_15.json"), (Test.Wire.API.Golden.Generated.NewServiceResponse_provider.testObject_NewServiceResponse_provider_16, "testObject_NewServiceResponse_provider_16.json"), (Test.Wire.API.Golden.Generated.NewServiceResponse_provider.testObject_NewServiceResponse_provider_17, "testObject_NewServiceResponse_provider_17.json"), (Test.Wire.API.Golden.Generated.NewServiceResponse_provider.testObject_NewServiceResponse_provider_18, "testObject_NewServiceResponse_provider_18.json"), (Test.Wire.API.Golden.Generated.NewServiceResponse_provider.testObject_NewServiceResponse_provider_19, "testObject_NewServiceResponse_provider_19.json"), (Test.Wire.API.Golden.Generated.NewServiceResponse_provider.testObject_NewServiceResponse_provider_20, "testObject_NewServiceResponse_provider_20.json")],
      testGroup "Golden: UpdateService_provider" $
        testObjects [(Test.Wire.API.Golden.Generated.UpdateService_provider.testObject_UpdateService_provider_1, "testObject_UpdateService_provider_1.json"), (Test.Wire.API.Golden.Generated.UpdateService_provider.testObject_UpdateService_provider_2, "testObject_UpdateService_provider_2.json"), (Test.Wire.API.Golden.Generated.UpdateService_provider.testObject_UpdateService_provider_3, "testObject_UpdateService_provider_3.json"), (Test.Wire.API.Golden.Generated.UpdateService_provider.testObject_UpdateService_provider_4, "testObject_UpdateService_provider_4.json"), (Test.Wire.API.Golden.Generated.UpdateService_provider.testObject_UpdateService_provider_5, "testObject_UpdateService_provider_5.json"), (Test.Wire.API.Golden.Generated.UpdateService_provider.testObject_UpdateService_provider_6, "testObject_UpdateService_provider_6.json"), (Test.Wire.API.Golden.Generated.UpdateService_provider.testObject_UpdateService_provider_7, "testObject_UpdateService_provider_7.json"), (Test.Wire.API.Golden.Generated.UpdateService_provider.testObject_UpdateService_provider_8, "testObject_UpdateService_provider_8.json"), (Test.Wire.API.Golden.Generated.UpdateService_provider.testObject_UpdateService_provider_9, "testObject_UpdateService_provider_9.json"), (Test.Wire.API.Golden.Generated.UpdateService_provider.testObject_UpdateService_provider_10, "testObject_UpdateService_provider_10.json"), (Test.Wire.API.Golden.Generated.UpdateService_provider.testObject_UpdateService_provider_11, "testObject_UpdateService_provider_11.json"), (Test.Wire.API.Golden.Generated.UpdateService_provider.testObject_UpdateService_provider_12, "testObject_UpdateService_provider_12.json"), (Test.Wire.API.Golden.Generated.UpdateService_provider.testObject_UpdateService_provider_13, "testObject_UpdateService_provider_13.json"), (Test.Wire.API.Golden.Generated.UpdateService_provider.testObject_UpdateService_provider_14, "testObject_UpdateService_provider_14.json"), (Test.Wire.API.Golden.Generated.UpdateService_provider.testObject_UpdateService_provider_15, "testObject_UpdateService_provider_15.json"), (Test.Wire.API.Golden.Generated.UpdateService_provider.testObject_UpdateService_provider_16, "testObject_UpdateService_provider_16.json"), (Test.Wire.API.Golden.Generated.UpdateService_provider.testObject_UpdateService_provider_17, "testObject_UpdateService_provider_17.json"), (Test.Wire.API.Golden.Generated.UpdateService_provider.testObject_UpdateService_provider_18, "testObject_UpdateService_provider_18.json"), (Test.Wire.API.Golden.Generated.UpdateService_provider.testObject_UpdateService_provider_19, "testObject_UpdateService_provider_19.json"), (Test.Wire.API.Golden.Generated.UpdateService_provider.testObject_UpdateService_provider_20, "testObject_UpdateService_provider_20.json")],
      testGroup "Golden: UpdateServiceConn_provider" $
        testObjects [(Test.Wire.API.Golden.Generated.UpdateServiceConn_provider.testObject_UpdateServiceConn_provider_1, "testObject_UpdateServiceConn_provider_1.json"), (Test.Wire.API.Golden.Generated.UpdateServiceConn_provider.testObject_UpdateServiceConn_provider_2, "testObject_UpdateServiceConn_provider_2.json"), (Test.Wire.API.Golden.Generated.UpdateServiceConn_provider.testObject_UpdateServiceConn_provider_3, "testObject_UpdateServiceConn_provider_3.json"), (Test.Wire.API.Golden.Generated.UpdateServiceConn_provider.testObject_UpdateServiceConn_provider_4, "testObject_UpdateServiceConn_provider_4.json"), (Test.Wire.API.Golden.Generated.UpdateServiceConn_provider.testObject_UpdateServiceConn_provider_5, "testObject_UpdateServiceConn_provider_5.json"), (Test.Wire.API.Golden.Generated.UpdateServiceConn_provider.testObject_UpdateServiceConn_provider_6, "testObject_UpdateServiceConn_provider_6.json"), (Test.Wire.API.Golden.Generated.UpdateServiceConn_provider.testObject_UpdateServiceConn_provider_7, "testObject_UpdateServiceConn_provider_7.json"), (Test.Wire.API.Golden.Generated.UpdateServiceConn_provider.testObject_UpdateServiceConn_provider_8, "testObject_UpdateServiceConn_provider_8.json"), (Test.Wire.API.Golden.Generated.UpdateServiceConn_provider.testObject_UpdateServiceConn_provider_9, "testObject_UpdateServiceConn_provider_9.json"), (Test.Wire.API.Golden.Generated.UpdateServiceConn_provider.testObject_UpdateServiceConn_provider_10, "testObject_UpdateServiceConn_provider_10.json"), (Test.Wire.API.Golden.Generated.UpdateServiceConn_provider.testObject_UpdateServiceConn_provider_11, "testObject_UpdateServiceConn_provider_11.json"), (Test.Wire.API.Golden.Generated.UpdateServiceConn_provider.testObject_UpdateServiceConn_provider_12, "testObject_UpdateServiceConn_provider_12.json"), (Test.Wire.API.Golden.Generated.UpdateServiceConn_provider.testObject_UpdateServiceConn_provider_13, "testObject_UpdateServiceConn_provider_13.json"), (Test.Wire.API.Golden.Generated.UpdateServiceConn_provider.testObject_UpdateServiceConn_provider_14, "testObject_UpdateServiceConn_provider_14.json"), (Test.Wire.API.Golden.Generated.UpdateServiceConn_provider.testObject_UpdateServiceConn_provider_15, "testObject_UpdateServiceConn_provider_15.json"), (Test.Wire.API.Golden.Generated.UpdateServiceConn_provider.testObject_UpdateServiceConn_provider_16, "testObject_UpdateServiceConn_provider_16.json"), (Test.Wire.API.Golden.Generated.UpdateServiceConn_provider.testObject_UpdateServiceConn_provider_17, "testObject_UpdateServiceConn_provider_17.json"), (Test.Wire.API.Golden.Generated.UpdateServiceConn_provider.testObject_UpdateServiceConn_provider_18, "testObject_UpdateServiceConn_provider_18.json"), (Test.Wire.API.Golden.Generated.UpdateServiceConn_provider.testObject_UpdateServiceConn_provider_19, "testObject_UpdateServiceConn_provider_19.json"), (Test.Wire.API.Golden.Generated.UpdateServiceConn_provider.testObject_UpdateServiceConn_provider_20, "testObject_UpdateServiceConn_provider_20.json")],
      testGroup "Golden: DeleteService_provider" $
        testObjects [(Test.Wire.API.Golden.Generated.DeleteService_provider.testObject_DeleteService_provider_1, "testObject_DeleteService_provider_1.json"), (Test.Wire.API.Golden.Generated.DeleteService_provider.testObject_DeleteService_provider_2, "testObject_DeleteService_provider_2.json"), (Test.Wire.API.Golden.Generated.DeleteService_provider.testObject_DeleteService_provider_3, "testObject_DeleteService_provider_3.json"), (Test.Wire.API.Golden.Generated.DeleteService_provider.testObject_DeleteService_provider_4, "testObject_DeleteService_provider_4.json"), (Test.Wire.API.Golden.Generated.DeleteService_provider.testObject_DeleteService_provider_5, "testObject_DeleteService_provider_5.json"), (Test.Wire.API.Golden.Generated.DeleteService_provider.testObject_DeleteService_provider_6, "testObject_DeleteService_provider_6.json"), (Test.Wire.API.Golden.Generated.DeleteService_provider.testObject_DeleteService_provider_7, "testObject_DeleteService_provider_7.json"), (Test.Wire.API.Golden.Generated.DeleteService_provider.testObject_DeleteService_provider_8, "testObject_DeleteService_provider_8.json"), (Test.Wire.API.Golden.Generated.DeleteService_provider.testObject_DeleteService_provider_9, "testObject_DeleteService_provider_9.json"), (Test.Wire.API.Golden.Generated.DeleteService_provider.testObject_DeleteService_provider_10, "testObject_DeleteService_provider_10.json"), (Test.Wire.API.Golden.Generated.DeleteService_provider.testObject_DeleteService_provider_11, "testObject_DeleteService_provider_11.json"), (Test.Wire.API.Golden.Generated.DeleteService_provider.testObject_DeleteService_provider_12, "testObject_DeleteService_provider_12.json"), (Test.Wire.API.Golden.Generated.DeleteService_provider.testObject_DeleteService_provider_13, "testObject_DeleteService_provider_13.json"), (Test.Wire.API.Golden.Generated.DeleteService_provider.testObject_DeleteService_provider_14, "testObject_DeleteService_provider_14.json"), (Test.Wire.API.Golden.Generated.DeleteService_provider.testObject_DeleteService_provider_15, "testObject_DeleteService_provider_15.json"), (Test.Wire.API.Golden.Generated.DeleteService_provider.testObject_DeleteService_provider_16, "testObject_DeleteService_provider_16.json"), (Test.Wire.API.Golden.Generated.DeleteService_provider.testObject_DeleteService_provider_17, "testObject_DeleteService_provider_17.json"), (Test.Wire.API.Golden.Generated.DeleteService_provider.testObject_DeleteService_provider_18, "testObject_DeleteService_provider_18.json"), (Test.Wire.API.Golden.Generated.DeleteService_provider.testObject_DeleteService_provider_19, "testObject_DeleteService_provider_19.json"), (Test.Wire.API.Golden.Generated.DeleteService_provider.testObject_DeleteService_provider_20, "testObject_DeleteService_provider_20.json")],
      testGroup "Golden: UpdateServiceWhitelist_provider" $
        testObjects [(Test.Wire.API.Golden.Generated.UpdateServiceWhitelist_provider.testObject_UpdateServiceWhitelist_provider_1, "testObject_UpdateServiceWhitelist_provider_1.json"), (Test.Wire.API.Golden.Generated.UpdateServiceWhitelist_provider.testObject_UpdateServiceWhitelist_provider_2, "testObject_UpdateServiceWhitelist_provider_2.json"), (Test.Wire.API.Golden.Generated.UpdateServiceWhitelist_provider.testObject_UpdateServiceWhitelist_provider_3, "testObject_UpdateServiceWhitelist_provider_3.json"), (Test.Wire.API.Golden.Generated.UpdateServiceWhitelist_provider.testObject_UpdateServiceWhitelist_provider_4, "testObject_UpdateServiceWhitelist_provider_4.json"), (Test.Wire.API.Golden.Generated.UpdateServiceWhitelist_provider.testObject_UpdateServiceWhitelist_provider_5, "testObject_UpdateServiceWhitelist_provider_5.json"), (Test.Wire.API.Golden.Generated.UpdateServiceWhitelist_provider.testObject_UpdateServiceWhitelist_provider_6, "testObject_UpdateServiceWhitelist_provider_6.json"), (Test.Wire.API.Golden.Generated.UpdateServiceWhitelist_provider.testObject_UpdateServiceWhitelist_provider_7, "testObject_UpdateServiceWhitelist_provider_7.json"), (Test.Wire.API.Golden.Generated.UpdateServiceWhitelist_provider.testObject_UpdateServiceWhitelist_provider_8, "testObject_UpdateServiceWhitelist_provider_8.json"), (Test.Wire.API.Golden.Generated.UpdateServiceWhitelist_provider.testObject_UpdateServiceWhitelist_provider_9, "testObject_UpdateServiceWhitelist_provider_9.json"), (Test.Wire.API.Golden.Generated.UpdateServiceWhitelist_provider.testObject_UpdateServiceWhitelist_provider_10, "testObject_UpdateServiceWhitelist_provider_10.json"), (Test.Wire.API.Golden.Generated.UpdateServiceWhitelist_provider.testObject_UpdateServiceWhitelist_provider_11, "testObject_UpdateServiceWhitelist_provider_11.json"), (Test.Wire.API.Golden.Generated.UpdateServiceWhitelist_provider.testObject_UpdateServiceWhitelist_provider_12, "testObject_UpdateServiceWhitelist_provider_12.json"), (Test.Wire.API.Golden.Generated.UpdateServiceWhitelist_provider.testObject_UpdateServiceWhitelist_provider_13, "testObject_UpdateServiceWhitelist_provider_13.json"), (Test.Wire.API.Golden.Generated.UpdateServiceWhitelist_provider.testObject_UpdateServiceWhitelist_provider_14, "testObject_UpdateServiceWhitelist_provider_14.json"), (Test.Wire.API.Golden.Generated.UpdateServiceWhitelist_provider.testObject_UpdateServiceWhitelist_provider_15, "testObject_UpdateServiceWhitelist_provider_15.json"), (Test.Wire.API.Golden.Generated.UpdateServiceWhitelist_provider.testObject_UpdateServiceWhitelist_provider_16, "testObject_UpdateServiceWhitelist_provider_16.json"), (Test.Wire.API.Golden.Generated.UpdateServiceWhitelist_provider.testObject_UpdateServiceWhitelist_provider_17, "testObject_UpdateServiceWhitelist_provider_17.json"), (Test.Wire.API.Golden.Generated.UpdateServiceWhitelist_provider.testObject_UpdateServiceWhitelist_provider_18, "testObject_UpdateServiceWhitelist_provider_18.json"), (Test.Wire.API.Golden.Generated.UpdateServiceWhitelist_provider.testObject_UpdateServiceWhitelist_provider_19, "testObject_UpdateServiceWhitelist_provider_19.json"), (Test.Wire.API.Golden.Generated.UpdateServiceWhitelist_provider.testObject_UpdateServiceWhitelist_provider_20, "testObject_UpdateServiceWhitelist_provider_20.json")],
      testGroup "Golden: ServiceTag_provider" $
        testObjects [(Test.Wire.API.Golden.Generated.ServiceTag_provider.testObject_ServiceTag_provider_1, "testObject_ServiceTag_provider_1.json"), (Test.Wire.API.Golden.Generated.ServiceTag_provider.testObject_ServiceTag_provider_2, "testObject_ServiceTag_provider_2.json"), (Test.Wire.API.Golden.Generated.ServiceTag_provider.testObject_ServiceTag_provider_3, "testObject_ServiceTag_provider_3.json"), (Test.Wire.API.Golden.Generated.ServiceTag_provider.testObject_ServiceTag_provider_4, "testObject_ServiceTag_provider_4.json"), (Test.Wire.API.Golden.Generated.ServiceTag_provider.testObject_ServiceTag_provider_5, "testObject_ServiceTag_provider_5.json"), (Test.Wire.API.Golden.Generated.ServiceTag_provider.testObject_ServiceTag_provider_6, "testObject_ServiceTag_provider_6.json"), (Test.Wire.API.Golden.Generated.ServiceTag_provider.testObject_ServiceTag_provider_7, "testObject_ServiceTag_provider_7.json"), (Test.Wire.API.Golden.Generated.ServiceTag_provider.testObject_ServiceTag_provider_8, "testObject_ServiceTag_provider_8.json"), (Test.Wire.API.Golden.Generated.ServiceTag_provider.testObject_ServiceTag_provider_9, "testObject_ServiceTag_provider_9.json"), (Test.Wire.API.Golden.Generated.ServiceTag_provider.testObject_ServiceTag_provider_10, "testObject_ServiceTag_provider_10.json"), (Test.Wire.API.Golden.Generated.ServiceTag_provider.testObject_ServiceTag_provider_11, "testObject_ServiceTag_provider_11.json"), (Test.Wire.API.Golden.Generated.ServiceTag_provider.testObject_ServiceTag_provider_12, "testObject_ServiceTag_provider_12.json"), (Test.Wire.API.Golden.Generated.ServiceTag_provider.testObject_ServiceTag_provider_13, "testObject_ServiceTag_provider_13.json"), (Test.Wire.API.Golden.Generated.ServiceTag_provider.testObject_ServiceTag_provider_14, "testObject_ServiceTag_provider_14.json"), (Test.Wire.API.Golden.Generated.ServiceTag_provider.testObject_ServiceTag_provider_15, "testObject_ServiceTag_provider_15.json"), (Test.Wire.API.Golden.Generated.ServiceTag_provider.testObject_ServiceTag_provider_16, "testObject_ServiceTag_provider_16.json"), (Test.Wire.API.Golden.Generated.ServiceTag_provider.testObject_ServiceTag_provider_17, "testObject_ServiceTag_provider_17.json"), (Test.Wire.API.Golden.Generated.ServiceTag_provider.testObject_ServiceTag_provider_18, "testObject_ServiceTag_provider_18.json"), (Test.Wire.API.Golden.Generated.ServiceTag_provider.testObject_ServiceTag_provider_19, "testObject_ServiceTag_provider_19.json"), (Test.Wire.API.Golden.Generated.ServiceTag_provider.testObject_ServiceTag_provider_20, "testObject_ServiceTag_provider_20.json")],
      testGroup "Golden: ServiceTagList_provider" $
        testObjects [(Test.Wire.API.Golden.Generated.ServiceTagList_provider.testObject_ServiceTagList_provider_1, "testObject_ServiceTagList_provider_1.json"), (Test.Wire.API.Golden.Generated.ServiceTagList_provider.testObject_ServiceTagList_provider_2, "testObject_ServiceTagList_provider_2.json"), (Test.Wire.API.Golden.Generated.ServiceTagList_provider.testObject_ServiceTagList_provider_3, "testObject_ServiceTagList_provider_3.json"), (Test.Wire.API.Golden.Generated.ServiceTagList_provider.testObject_ServiceTagList_provider_4, "testObject_ServiceTagList_provider_4.json"), (Test.Wire.API.Golden.Generated.ServiceTagList_provider.testObject_ServiceTagList_provider_5, "testObject_ServiceTagList_provider_5.json"), (Test.Wire.API.Golden.Generated.ServiceTagList_provider.testObject_ServiceTagList_provider_6, "testObject_ServiceTagList_provider_6.json"), (Test.Wire.API.Golden.Generated.ServiceTagList_provider.testObject_ServiceTagList_provider_7, "testObject_ServiceTagList_provider_7.json"), (Test.Wire.API.Golden.Generated.ServiceTagList_provider.testObject_ServiceTagList_provider_8, "testObject_ServiceTagList_provider_8.json"), (Test.Wire.API.Golden.Generated.ServiceTagList_provider.testObject_ServiceTagList_provider_9, "testObject_ServiceTagList_provider_9.json"), (Test.Wire.API.Golden.Generated.ServiceTagList_provider.testObject_ServiceTagList_provider_10, "testObject_ServiceTagList_provider_10.json"), (Test.Wire.API.Golden.Generated.ServiceTagList_provider.testObject_ServiceTagList_provider_11, "testObject_ServiceTagList_provider_11.json"), (Test.Wire.API.Golden.Generated.ServiceTagList_provider.testObject_ServiceTagList_provider_12, "testObject_ServiceTagList_provider_12.json"), (Test.Wire.API.Golden.Generated.ServiceTagList_provider.testObject_ServiceTagList_provider_13, "testObject_ServiceTagList_provider_13.json"), (Test.Wire.API.Golden.Generated.ServiceTagList_provider.testObject_ServiceTagList_provider_14, "testObject_ServiceTagList_provider_14.json"), (Test.Wire.API.Golden.Generated.ServiceTagList_provider.testObject_ServiceTagList_provider_15, "testObject_ServiceTagList_provider_15.json"), (Test.Wire.API.Golden.Generated.ServiceTagList_provider.testObject_ServiceTagList_provider_16, "testObject_ServiceTagList_provider_16.json"), (Test.Wire.API.Golden.Generated.ServiceTagList_provider.testObject_ServiceTagList_provider_17, "testObject_ServiceTagList_provider_17.json"), (Test.Wire.API.Golden.Generated.ServiceTagList_provider.testObject_ServiceTagList_provider_18, "testObject_ServiceTagList_provider_18.json"), (Test.Wire.API.Golden.Generated.ServiceTagList_provider.testObject_ServiceTagList_provider_19, "testObject_ServiceTagList_provider_19.json"), (Test.Wire.API.Golden.Generated.ServiceTagList_provider.testObject_ServiceTagList_provider_20, "testObject_ServiceTagList_provider_20.json")],
      testGroup "Golden: BindingNewTeam_team" $
        testObjects [(Test.Wire.API.Golden.Generated.NewTeam_team.testObject_NewTeam_team_1, "testObject_NewTeam_team_1.json"), (Test.Wire.API.Golden.Generated.NewTeam_team.testObject_NewTeam_team_2, "testObject_NewTeam_team_2.json"), (Test.Wire.API.Golden.Generated.NewTeam_team.testObject_NewTeam_team_3, "testObject_NewTeam_team_3.json"), (Test.Wire.API.Golden.Generated.NewTeam_team.testObject_NewTeam_team_4, "testObject_NewTeam_team_4.json"), (Test.Wire.API.Golden.Generated.NewTeam_team.testObject_NewTeam_team_5, "testObject_NewTeam_team_5.json"), (Test.Wire.API.Golden.Generated.NewTeam_team.testObject_NewTeam_team_6, "testObject_NewTeam_team_6.json"), (Test.Wire.API.Golden.Generated.NewTeam_team.testObject_NewTeam_team_7, "testObject_NewTeam_team_7.json"), (Test.Wire.API.Golden.Generated.NewTeam_team.testObject_NewTeam_team_8, "testObject_NewTeam_team_8.json"), (Test.Wire.API.Golden.Generated.NewTeam_team.testObject_NewTeam_team_9, "testObject_NewTeam_team_9.json"), (Test.Wire.API.Golden.Generated.NewTeam_team.testObject_NewTeam_team_10, "testObject_NewTeam_team_10.json"), (Test.Wire.API.Golden.Generated.NewTeam_team.testObject_NewTeam_team_11, "testObject_NewTeam_team_11.json"), (Test.Wire.API.Golden.Generated.NewTeam_team.testObject_NewTeam_team_12, "testObject_NewTeam_team_12.json"), (Test.Wire.API.Golden.Generated.NewTeam_team.testObject_NewTeam_team_13, "testObject_NewTeam_team_13.json"), (Test.Wire.API.Golden.Generated.NewTeam_team.testObject_NewTeam_team_14, "testObject_NewTeam_team_14.json"), (Test.Wire.API.Golden.Generated.NewTeam_team.testObject_NewTeam_team_15, "testObject_NewTeam_team_15.json"), (Test.Wire.API.Golden.Generated.NewTeam_team.testObject_NewTeam_team_16, "testObject_NewTeam_team_16.json"), (Test.Wire.API.Golden.Generated.NewTeam_team.testObject_NewTeam_team_17, "testObject_NewTeam_team_17.json"), (Test.Wire.API.Golden.Generated.NewTeam_team.testObject_NewTeam_team_18, "testObject_NewTeam_team_18.json"), (Test.Wire.API.Golden.Generated.NewTeam_team.testObject_NewTeam_team_19, "testObject_NewTeam_team_19.json"), (Test.Wire.API.Golden.Generated.NewTeam_team.testObject_NewTeam_team_20, "testObject_NewTeam_team_20.json")],
      testGroup "Golden: TeamBinding_team" $
        testObjects [(Test.Wire.API.Golden.Generated.TeamBinding_team.testObject_TeamBinding_team_1, "testObject_TeamBinding_team_1.json"), (Test.Wire.API.Golden.Generated.TeamBinding_team.testObject_TeamBinding_team_2, "testObject_TeamBinding_team_2.json"), (Test.Wire.API.Golden.Generated.TeamBinding_team.testObject_TeamBinding_team_3, "testObject_TeamBinding_team_3.json"), (Test.Wire.API.Golden.Generated.TeamBinding_team.testObject_TeamBinding_team_4, "testObject_TeamBinding_team_4.json"), (Test.Wire.API.Golden.Generated.TeamBinding_team.testObject_TeamBinding_team_5, "testObject_TeamBinding_team_5.json"), (Test.Wire.API.Golden.Generated.TeamBinding_team.testObject_TeamBinding_team_6, "testObject_TeamBinding_team_6.json"), (Test.Wire.API.Golden.Generated.TeamBinding_team.testObject_TeamBinding_team_7, "testObject_TeamBinding_team_7.json"), (Test.Wire.API.Golden.Generated.TeamBinding_team.testObject_TeamBinding_team_8, "testObject_TeamBinding_team_8.json"), (Test.Wire.API.Golden.Generated.TeamBinding_team.testObject_TeamBinding_team_9, "testObject_TeamBinding_team_9.json"), (Test.Wire.API.Golden.Generated.TeamBinding_team.testObject_TeamBinding_team_10, "testObject_TeamBinding_team_10.json"), (Test.Wire.API.Golden.Generated.TeamBinding_team.testObject_TeamBinding_team_11, "testObject_TeamBinding_team_11.json"), (Test.Wire.API.Golden.Generated.TeamBinding_team.testObject_TeamBinding_team_12, "testObject_TeamBinding_team_12.json"), (Test.Wire.API.Golden.Generated.TeamBinding_team.testObject_TeamBinding_team_13, "testObject_TeamBinding_team_13.json"), (Test.Wire.API.Golden.Generated.TeamBinding_team.testObject_TeamBinding_team_14, "testObject_TeamBinding_team_14.json"), (Test.Wire.API.Golden.Generated.TeamBinding_team.testObject_TeamBinding_team_15, "testObject_TeamBinding_team_15.json"), (Test.Wire.API.Golden.Generated.TeamBinding_team.testObject_TeamBinding_team_16, "testObject_TeamBinding_team_16.json"), (Test.Wire.API.Golden.Generated.TeamBinding_team.testObject_TeamBinding_team_17, "testObject_TeamBinding_team_17.json"), (Test.Wire.API.Golden.Generated.TeamBinding_team.testObject_TeamBinding_team_18, "testObject_TeamBinding_team_18.json"), (Test.Wire.API.Golden.Generated.TeamBinding_team.testObject_TeamBinding_team_19, "testObject_TeamBinding_team_19.json"), (Test.Wire.API.Golden.Generated.TeamBinding_team.testObject_TeamBinding_team_20, "testObject_TeamBinding_team_20.json")],
      testGroup "Golden: Team_team" $
        testObjects [(Test.Wire.API.Golden.Generated.Team_team.testObject_Team_team_1, "testObject_Team_team_1.json"), (Test.Wire.API.Golden.Generated.Team_team.testObject_Team_team_2, "testObject_Team_team_2.json"), (Test.Wire.API.Golden.Generated.Team_team.testObject_Team_team_3, "testObject_Team_team_3.json"), (Test.Wire.API.Golden.Generated.Team_team.testObject_Team_team_4, "testObject_Team_team_4.json"), (Test.Wire.API.Golden.Generated.Team_team.testObject_Team_team_5, "testObject_Team_team_5.json"), (Test.Wire.API.Golden.Generated.Team_team.testObject_Team_team_6, "testObject_Team_team_6.json"), (Test.Wire.API.Golden.Generated.Team_team.testObject_Team_team_7, "testObject_Team_team_7.json"), (Test.Wire.API.Golden.Generated.Team_team.testObject_Team_team_8, "testObject_Team_team_8.json"), (Test.Wire.API.Golden.Generated.Team_team.testObject_Team_team_9, "testObject_Team_team_9.json"), (Test.Wire.API.Golden.Generated.Team_team.testObject_Team_team_10, "testObject_Team_team_10.json"), (Test.Wire.API.Golden.Generated.Team_team.testObject_Team_team_11, "testObject_Team_team_11.json"), (Test.Wire.API.Golden.Generated.Team_team.testObject_Team_team_12, "testObject_Team_team_12.json"), (Test.Wire.API.Golden.Generated.Team_team.testObject_Team_team_13, "testObject_Team_team_13.json"), (Test.Wire.API.Golden.Generated.Team_team.testObject_Team_team_14, "testObject_Team_team_14.json"), (Test.Wire.API.Golden.Generated.Team_team.testObject_Team_team_15, "testObject_Team_team_15.json"), (Test.Wire.API.Golden.Generated.Team_team.testObject_Team_team_16, "testObject_Team_team_16.json"), (Test.Wire.API.Golden.Generated.Team_team.testObject_Team_team_17, "testObject_Team_team_17.json"), (Test.Wire.API.Golden.Generated.Team_team.testObject_Team_team_18, "testObject_Team_team_18.json"), (Test.Wire.API.Golden.Generated.Team_team.testObject_Team_team_19, "testObject_Team_team_19.json"), (Test.Wire.API.Golden.Generated.Team_team.testObject_Team_team_20, "testObject_Team_team_20.json")],
      testGroup "Golden: TeamList_team" $
        testObjects [(Test.Wire.API.Golden.Generated.TeamList_team.testObject_TeamList_team_1, "testObject_TeamList_team_1.json"), (Test.Wire.API.Golden.Generated.TeamList_team.testObject_TeamList_team_2, "testObject_TeamList_team_2.json"), (Test.Wire.API.Golden.Generated.TeamList_team.testObject_TeamList_team_3, "testObject_TeamList_team_3.json"), (Test.Wire.API.Golden.Generated.TeamList_team.testObject_TeamList_team_4, "testObject_TeamList_team_4.json"), (Test.Wire.API.Golden.Generated.TeamList_team.testObject_TeamList_team_5, "testObject_TeamList_team_5.json"), (Test.Wire.API.Golden.Generated.TeamList_team.testObject_TeamList_team_6, "testObject_TeamList_team_6.json"), (Test.Wire.API.Golden.Generated.TeamList_team.testObject_TeamList_team_7, "testObject_TeamList_team_7.json"), (Test.Wire.API.Golden.Generated.TeamList_team.testObject_TeamList_team_8, "testObject_TeamList_team_8.json"), (Test.Wire.API.Golden.Generated.TeamList_team.testObject_TeamList_team_9, "testObject_TeamList_team_9.json"), (Test.Wire.API.Golden.Generated.TeamList_team.testObject_TeamList_team_10, "testObject_TeamList_team_10.json"), (Test.Wire.API.Golden.Generated.TeamList_team.testObject_TeamList_team_11, "testObject_TeamList_team_11.json"), (Test.Wire.API.Golden.Generated.TeamList_team.testObject_TeamList_team_12, "testObject_TeamList_team_12.json"), (Test.Wire.API.Golden.Generated.TeamList_team.testObject_TeamList_team_13, "testObject_TeamList_team_13.json"), (Test.Wire.API.Golden.Generated.TeamList_team.testObject_TeamList_team_14, "testObject_TeamList_team_14.json"), (Test.Wire.API.Golden.Generated.TeamList_team.testObject_TeamList_team_15, "testObject_TeamList_team_15.json"), (Test.Wire.API.Golden.Generated.TeamList_team.testObject_TeamList_team_16, "testObject_TeamList_team_16.json"), (Test.Wire.API.Golden.Generated.TeamList_team.testObject_TeamList_team_17, "testObject_TeamList_team_17.json"), (Test.Wire.API.Golden.Generated.TeamList_team.testObject_TeamList_team_18, "testObject_TeamList_team_18.json"), (Test.Wire.API.Golden.Generated.TeamList_team.testObject_TeamList_team_19, "testObject_TeamList_team_19.json"), (Test.Wire.API.Golden.Generated.TeamList_team.testObject_TeamList_team_20, "testObject_TeamList_team_20.json")],
      testGroup "Golden: TeamUpdateData_team" $
        testObjects [(Test.Wire.API.Golden.Generated.TeamUpdateData_team.testObject_TeamUpdateData_team_1, "testObject_TeamUpdateData_team_1.json"), (Test.Wire.API.Golden.Generated.TeamUpdateData_team.testObject_TeamUpdateData_team_2, "testObject_TeamUpdateData_team_2.json"), (Test.Wire.API.Golden.Generated.TeamUpdateData_team.testObject_TeamUpdateData_team_3, "testObject_TeamUpdateData_team_3.json"), (Test.Wire.API.Golden.Generated.TeamUpdateData_team.testObject_TeamUpdateData_team_4, "testObject_TeamUpdateData_team_4.json"), (Test.Wire.API.Golden.Generated.TeamUpdateData_team.testObject_TeamUpdateData_team_5, "testObject_TeamUpdateData_team_5.json"), (Test.Wire.API.Golden.Generated.TeamUpdateData_team.testObject_TeamUpdateData_team_6, "testObject_TeamUpdateData_team_6.json"), (Test.Wire.API.Golden.Generated.TeamUpdateData_team.testObject_TeamUpdateData_team_7, "testObject_TeamUpdateData_team_7.json"), (Test.Wire.API.Golden.Generated.TeamUpdateData_team.testObject_TeamUpdateData_team_8, "testObject_TeamUpdateData_team_8.json"), (Test.Wire.API.Golden.Generated.TeamUpdateData_team.testObject_TeamUpdateData_team_9, "testObject_TeamUpdateData_team_9.json"), (Test.Wire.API.Golden.Generated.TeamUpdateData_team.testObject_TeamUpdateData_team_10, "testObject_TeamUpdateData_team_10.json"), (Test.Wire.API.Golden.Generated.TeamUpdateData_team.testObject_TeamUpdateData_team_11, "testObject_TeamUpdateData_team_11.json"), (Test.Wire.API.Golden.Generated.TeamUpdateData_team.testObject_TeamUpdateData_team_12, "testObject_TeamUpdateData_team_12.json"), (Test.Wire.API.Golden.Generated.TeamUpdateData_team.testObject_TeamUpdateData_team_13, "testObject_TeamUpdateData_team_13.json"), (Test.Wire.API.Golden.Generated.TeamUpdateData_team.testObject_TeamUpdateData_team_14, "testObject_TeamUpdateData_team_14.json"), (Test.Wire.API.Golden.Generated.TeamUpdateData_team.testObject_TeamUpdateData_team_15, "testObject_TeamUpdateData_team_15.json"), (Test.Wire.API.Golden.Generated.TeamUpdateData_team.testObject_TeamUpdateData_team_16, "testObject_TeamUpdateData_team_16.json"), (Test.Wire.API.Golden.Generated.TeamUpdateData_team.testObject_TeamUpdateData_team_17, "testObject_TeamUpdateData_team_17.json"), (Test.Wire.API.Golden.Generated.TeamUpdateData_team.testObject_TeamUpdateData_team_18, "testObject_TeamUpdateData_team_18.json"), (Test.Wire.API.Golden.Generated.TeamUpdateData_team.testObject_TeamUpdateData_team_19, "testObject_TeamUpdateData_team_19.json"), (Test.Wire.API.Golden.Generated.TeamUpdateData_team.testObject_TeamUpdateData_team_20, "testObject_TeamUpdateData_team_20.json")],
      testGroup "Golden: TeamDeleteData_team" $
        testObjects [(Test.Wire.API.Golden.Generated.TeamDeleteData_team.testObject_TeamDeleteData_team_1, "testObject_TeamDeleteData_team_1.json"), (Test.Wire.API.Golden.Generated.TeamDeleteData_team.testObject_TeamDeleteData_team_2, "testObject_TeamDeleteData_team_2.json"), (Test.Wire.API.Golden.Generated.TeamDeleteData_team.testObject_TeamDeleteData_team_3, "testObject_TeamDeleteData_team_3.json"), (Test.Wire.API.Golden.Generated.TeamDeleteData_team.testObject_TeamDeleteData_team_4, "testObject_TeamDeleteData_team_4.json"), (Test.Wire.API.Golden.Generated.TeamDeleteData_team.testObject_TeamDeleteData_team_5, "testObject_TeamDeleteData_team_5.json"), (Test.Wire.API.Golden.Generated.TeamDeleteData_team.testObject_TeamDeleteData_team_6, "testObject_TeamDeleteData_team_6.json"), (Test.Wire.API.Golden.Generated.TeamDeleteData_team.testObject_TeamDeleteData_team_7, "testObject_TeamDeleteData_team_7.json"), (Test.Wire.API.Golden.Generated.TeamDeleteData_team.testObject_TeamDeleteData_team_8, "testObject_TeamDeleteData_team_8.json"), (Test.Wire.API.Golden.Generated.TeamDeleteData_team.testObject_TeamDeleteData_team_9, "testObject_TeamDeleteData_team_9.json"), (Test.Wire.API.Golden.Generated.TeamDeleteData_team.testObject_TeamDeleteData_team_10, "testObject_TeamDeleteData_team_10.json"), (Test.Wire.API.Golden.Generated.TeamDeleteData_team.testObject_TeamDeleteData_team_11, "testObject_TeamDeleteData_team_11.json"), (Test.Wire.API.Golden.Generated.TeamDeleteData_team.testObject_TeamDeleteData_team_12, "testObject_TeamDeleteData_team_12.json"), (Test.Wire.API.Golden.Generated.TeamDeleteData_team.testObject_TeamDeleteData_team_13, "testObject_TeamDeleteData_team_13.json"), (Test.Wire.API.Golden.Generated.TeamDeleteData_team.testObject_TeamDeleteData_team_14, "testObject_TeamDeleteData_team_14.json"), (Test.Wire.API.Golden.Generated.TeamDeleteData_team.testObject_TeamDeleteData_team_15, "testObject_TeamDeleteData_team_15.json"), (Test.Wire.API.Golden.Generated.TeamDeleteData_team.testObject_TeamDeleteData_team_16, "testObject_TeamDeleteData_team_16.json"), (Test.Wire.API.Golden.Generated.TeamDeleteData_team.testObject_TeamDeleteData_team_17, "testObject_TeamDeleteData_team_17.json"), (Test.Wire.API.Golden.Generated.TeamDeleteData_team.testObject_TeamDeleteData_team_18, "testObject_TeamDeleteData_team_18.json"), (Test.Wire.API.Golden.Generated.TeamDeleteData_team.testObject_TeamDeleteData_team_19, "testObject_TeamDeleteData_team_19.json"), (Test.Wire.API.Golden.Generated.TeamDeleteData_team.testObject_TeamDeleteData_team_20, "testObject_TeamDeleteData_team_20.json")],
      testGroup "Golden: TeamConversation_team" $
        testObjects
          [ ( Test.Wire.API.Golden.Generated.TeamConversation_team.testObject_TeamConversation_team_1,
              "testObject_TeamConversation_team_1.json"
            ),
            ( Test.Wire.API.Golden.Generated.TeamConversation_team.testObject_TeamConversation_team_2,
              "testObject_TeamConversation_team_2.json"
            )
          ],
      testGroup "Golden: TeamConversationList_team" $
        testObjects
          [ ( Test.Wire.API.Golden.Generated.TeamConversationList_team.testObject_TeamConversationList_team_1,
              "testObject_TeamConversationList_team_1.json"
            ),
            ( Test.Wire.API.Golden.Generated.TeamConversationList_team.testObject_TeamConversationList_team_2,
              "testObject_TeamConversationList_team_2.json"
            )
          ],
      testGroup "Golden: Feature_team 1" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.Feature_team.testObject_Feature_team_1, "testObject_Feature_team_1.json"),
            (Test.Wire.API.Golden.Generated.Feature_team.testObject_Feature_team_2, "testObject_Feature_team_2.json"),
            (Test.Wire.API.Golden.Generated.Feature_team.testObject_Feature_team_3, "testObject_Feature_team_3.json")
          ],
      testGroup "Golden: Feature_team 2" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.Feature_team.testObject_Feature_team_4, "testObject_Feature_team_4.json"),
            (Test.Wire.API.Golden.Generated.Feature_team.testObject_Feature_team_5, "testObject_Feature_team_5.json"),
            (Test.Wire.API.Golden.Generated.Feature_team.testObject_Feature_team_6, "testObject_Feature_team_6.json")
          ],
      testGroup "Golden: Feature_team 3" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.Feature_team.testObject_Feature_team_7, "testObject_Feature_team_7.json"),
            (Test.Wire.API.Golden.Generated.Feature_team.testObject_Feature_team_8, "testObject_Feature_team_8.json"),
            (Test.Wire.API.Golden.Generated.Feature_team.testObject_Feature_team_9, "testObject_Feature_team_9.json")
          ],
      testGroup "Golden: Feature_team 4" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.Feature_team.testObject_Feature_team_10, "testObject_Feature_team_10.json")
          ],
      testGroup "Golden: Feature_team 5" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.Feature_team.testObject_Feature_team_11, "testObject_Feature_team_11.json")
          ],
      testGroup "Golden: Feature_team 6" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.Feature_team.testObject_Feature_team_12, "testObject_Feature_team_12.json")
          ],
      testGroup "Golden: Feature_team 7" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.Feature_team.testObject_Feature_team_13, "testObject_Feature_team_13.json")
          ],
      testGroup "Golden: Feature_team 8" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.Feature_team.testObject_Feature_team_14, "testObject_Feature_team_14.json")
          ],
      testGroup "Golden: Feature_team 9" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.Feature_team.testObject_Feature_team_15, "testObject_Feature_team_15.json")
          ],
      testGroup "Golden: Feature_team 10" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.Feature_team.testObject_Feature_team_16, "testObject_Feature_team_16.json")
          ],
      testGroup "Golden: Feature_team 11" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.Feature_team.testObject_Feature_team_17, "testObject_Feature_team_17.json")
          ],
      testGroup "Golden: LockableFeature_team 1" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.LockableFeature_team.testObject_LockableFeature_team_1, "testObject_LockableFeature_team_1.json"),
            (Test.Wire.API.Golden.Generated.LockableFeature_team.testObject_LockableFeature_team_2, "testObject_LockableFeature_team_2.json"),
            (Test.Wire.API.Golden.Generated.LockableFeature_team.testObject_LockableFeature_team_3, "testObject_LockableFeature_team_3.json")
          ],
      testGroup "Golden: LockableFeature_team 2" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.LockableFeature_team.testObject_LockableFeature_team_4, "testObject_LockableFeature_team_4.json"),
            (Test.Wire.API.Golden.Generated.LockableFeature_team.testObject_LockableFeature_team_5, "testObject_LockableFeature_team_5.json"),
            (Test.Wire.API.Golden.Generated.LockableFeature_team.testObject_LockableFeature_team_6, "testObject_LockableFeature_team_6.json")
          ],
      testGroup "Golden: LockableFeature_team 3" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.LockableFeature_team.testObject_LockableFeature_team_7, "testObject_LockableFeature_team_7.json"),
            (Test.Wire.API.Golden.Generated.LockableFeature_team.testObject_LockableFeature_team_8, "testObject_LockableFeature_team_8.json"),
            (Test.Wire.API.Golden.Generated.LockableFeature_team.testObject_LockableFeature_team_9, "testObject_LockableFeature_team_9.json")
          ],
      testGroup "Golden: LockableFeature_team 4" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.LockableFeature_team.testObject_LockableFeature_team_10, "testObject_LockableFeature_team_10.json")
          ],
      testGroup "Golden: LockableFeature_team 5" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.LockableFeature_team.testObject_LockableFeature_team_11, "testObject_LockableFeature_team_11.json")
          ],
      testGroup "Golden: LockableFeature_team 6" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.LockableFeature_team.testObject_LockableFeature_team_12, "testObject_LockableFeature_team_12.json")
          ],
      testGroup "Golden: LockableFeature_team 7" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.LockableFeature_team.testObject_LockableFeature_team_13, "testObject_LockableFeature_team_13.json")
          ],
      testGroup "Golden: LockableFeature_team 8" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.LockableFeature_team.testObject_LockableFeature_team_14, "testObject_LockableFeature_team_14.json")
          ],
      testGroup "Golden: LockableFeature_team 9" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.LockableFeature_team.testObject_LockableFeature_team_15, "testObject_LockableFeature_team_15.json")
          ],
      testGroup "Golden: LockableFeature_team 10" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.LockableFeature_team.testObject_LockableFeature_team_16, "testObject_LockableFeature_team_16.json")
          ],
      testGroup "Golden: LockableFeature_team 11" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.LockableFeature_team.testObject_LockableFeature_team_17, "testObject_LockableFeature_team_17.json")
          ],
      testGroup "Golden: LockableFeature_team 12" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.LockableFeature_team.testObject_LockableFeature_team_18, "testObject_LockableFeature_team_18.json"),
            (Test.Wire.API.Golden.Generated.LockableFeature_team.testObject_LockableFeature_team_19, "testObject_LockableFeature_team_19.json")
          ],
      testGroup "Golden: InvitationRequest_team" $
        testObjects [(Test.Wire.API.Golden.Generated.InvitationRequest_team.testObject_InvitationRequest_team_1, "testObject_InvitationRequest_team_1.json"), (Test.Wire.API.Golden.Generated.InvitationRequest_team.testObject_InvitationRequest_team_2, "testObject_InvitationRequest_team_2.json"), (Test.Wire.API.Golden.Generated.InvitationRequest_team.testObject_InvitationRequest_team_3, "testObject_InvitationRequest_team_3.json"), (Test.Wire.API.Golden.Generated.InvitationRequest_team.testObject_InvitationRequest_team_4, "testObject_InvitationRequest_team_4.json"), (Test.Wire.API.Golden.Generated.InvitationRequest_team.testObject_InvitationRequest_team_5, "testObject_InvitationRequest_team_5.json"), (Test.Wire.API.Golden.Generated.InvitationRequest_team.testObject_InvitationRequest_team_6, "testObject_InvitationRequest_team_6.json"), (Test.Wire.API.Golden.Generated.InvitationRequest_team.testObject_InvitationRequest_team_7, "testObject_InvitationRequest_team_7.json"), (Test.Wire.API.Golden.Generated.InvitationRequest_team.testObject_InvitationRequest_team_8, "testObject_InvitationRequest_team_8.json"), (Test.Wire.API.Golden.Generated.InvitationRequest_team.testObject_InvitationRequest_team_9, "testObject_InvitationRequest_team_9.json"), (Test.Wire.API.Golden.Generated.InvitationRequest_team.testObject_InvitationRequest_team_10, "testObject_InvitationRequest_team_10.json"), (Test.Wire.API.Golden.Generated.InvitationRequest_team.testObject_InvitationRequest_team_11, "testObject_InvitationRequest_team_11.json"), (Test.Wire.API.Golden.Generated.InvitationRequest_team.testObject_InvitationRequest_team_12, "testObject_InvitationRequest_team_12.json"), (Test.Wire.API.Golden.Generated.InvitationRequest_team.testObject_InvitationRequest_team_13, "testObject_InvitationRequest_team_13.json"), (Test.Wire.API.Golden.Generated.InvitationRequest_team.testObject_InvitationRequest_team_14, "testObject_InvitationRequest_team_14.json"), (Test.Wire.API.Golden.Generated.InvitationRequest_team.testObject_InvitationRequest_team_15, "testObject_InvitationRequest_team_15.json"), (Test.Wire.API.Golden.Generated.InvitationRequest_team.testObject_InvitationRequest_team_16, "testObject_InvitationRequest_team_16.json"), (Test.Wire.API.Golden.Generated.InvitationRequest_team.testObject_InvitationRequest_team_17, "testObject_InvitationRequest_team_17.json"), (Test.Wire.API.Golden.Generated.InvitationRequest_team.testObject_InvitationRequest_team_18, "testObject_InvitationRequest_team_18.json"), (Test.Wire.API.Golden.Generated.InvitationRequest_team.testObject_InvitationRequest_team_19, "testObject_InvitationRequest_team_19.json"), (Test.Wire.API.Golden.Generated.InvitationRequest_team.testObject_InvitationRequest_team_20, "testObject_InvitationRequest_team_20.json")],
      testGroup "Golden: Invitation_team" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.Invitation_team.testObject_Invitation_team_1, "testObject_Invitation_team_1.json"),
            (Test.Wire.API.Golden.Generated.Invitation_team.testObject_Invitation_team_2, "testObject_Invitation_team_2.json"),
            (Test.Wire.API.Golden.Generated.Invitation_team.testObject_Invitation_team_3, "testObject_Invitation_team_3.json"),
            (Test.Wire.API.Golden.Generated.Invitation_team.testObject_Invitation_team_4, "testObject_Invitation_team_4.json"),
            (Test.Wire.API.Golden.Generated.Invitation_team.testObject_Invitation_team_5, "testObject_Invitation_team_5.json"),
            (Test.Wire.API.Golden.Generated.Invitation_team.testObject_Invitation_team_6, "testObject_Invitation_team_6.json"),
            (Test.Wire.API.Golden.Generated.Invitation_team.testObject_Invitation_team_7, "testObject_Invitation_team_7.json"),
            (Test.Wire.API.Golden.Generated.Invitation_team.testObject_Invitation_team_8, "testObject_Invitation_team_8.json"),
            (Test.Wire.API.Golden.Generated.Invitation_team.testObject_Invitation_team_9, "testObject_Invitation_team_9.json"),
            (Test.Wire.API.Golden.Generated.Invitation_team.testObject_Invitation_team_10, "testObject_Invitation_team_10.json"),
            (Test.Wire.API.Golden.Generated.Invitation_team.testObject_Invitation_team_11, "testObject_Invitation_team_11.json"),
            (Test.Wire.API.Golden.Generated.Invitation_team.testObject_Invitation_team_12, "testObject_Invitation_team_12.json"),
            (Test.Wire.API.Golden.Generated.Invitation_team.testObject_Invitation_team_13, "testObject_Invitation_team_13.json"),
            (Test.Wire.API.Golden.Generated.Invitation_team.testObject_Invitation_team_14, "testObject_Invitation_team_14.json"),
            (Test.Wire.API.Golden.Generated.Invitation_team.testObject_Invitation_team_15, "testObject_Invitation_team_15.json"),
            (Test.Wire.API.Golden.Generated.Invitation_team.testObject_Invitation_team_16, "testObject_Invitation_team_16.json"),
            (Test.Wire.API.Golden.Generated.Invitation_team.testObject_Invitation_team_17, "testObject_Invitation_team_17.json"),
            (Test.Wire.API.Golden.Generated.Invitation_team.testObject_Invitation_team_18, "testObject_Invitation_team_18.json"),
            (Test.Wire.API.Golden.Generated.Invitation_team.testObject_Invitation_team_19, "testObject_Invitation_team_19.json"),
            (Test.Wire.API.Golden.Generated.Invitation_team.testObject_Invitation_team_20, "testObject_Invitation_team_20.json")
          ],
      testGroup "Golden: InvitationList_team" $
        testObjects [(Test.Wire.API.Golden.Generated.InvitationList_team.testObject_InvitationList_team_1, "testObject_InvitationList_team_1.json"), (Test.Wire.API.Golden.Generated.InvitationList_team.testObject_InvitationList_team_2, "testObject_InvitationList_team_2.json"), (Test.Wire.API.Golden.Generated.InvitationList_team.testObject_InvitationList_team_3, "testObject_InvitationList_team_3.json"), (Test.Wire.API.Golden.Generated.InvitationList_team.testObject_InvitationList_team_4, "testObject_InvitationList_team_4.json"), (Test.Wire.API.Golden.Generated.InvitationList_team.testObject_InvitationList_team_5, "testObject_InvitationList_team_5.json"), (Test.Wire.API.Golden.Generated.InvitationList_team.testObject_InvitationList_team_6, "testObject_InvitationList_team_6.json"), (Test.Wire.API.Golden.Generated.InvitationList_team.testObject_InvitationList_team_7, "testObject_InvitationList_team_7.json"), (Test.Wire.API.Golden.Generated.InvitationList_team.testObject_InvitationList_team_8, "testObject_InvitationList_team_8.json"), (Test.Wire.API.Golden.Generated.InvitationList_team.testObject_InvitationList_team_9, "testObject_InvitationList_team_9.json"), (Test.Wire.API.Golden.Generated.InvitationList_team.testObject_InvitationList_team_10, "testObject_InvitationList_team_10.json"), (Test.Wire.API.Golden.Generated.InvitationList_team.testObject_InvitationList_team_11, "testObject_InvitationList_team_11.json"), (Test.Wire.API.Golden.Generated.InvitationList_team.testObject_InvitationList_team_12, "testObject_InvitationList_team_12.json"), (Test.Wire.API.Golden.Generated.InvitationList_team.testObject_InvitationList_team_13, "testObject_InvitationList_team_13.json"), (Test.Wire.API.Golden.Generated.InvitationList_team.testObject_InvitationList_team_14, "testObject_InvitationList_team_14.json"), (Test.Wire.API.Golden.Generated.InvitationList_team.testObject_InvitationList_team_15, "testObject_InvitationList_team_15.json"), (Test.Wire.API.Golden.Generated.InvitationList_team.testObject_InvitationList_team_16, "testObject_InvitationList_team_16.json"), (Test.Wire.API.Golden.Generated.InvitationList_team.testObject_InvitationList_team_17, "testObject_InvitationList_team_17.json"), (Test.Wire.API.Golden.Generated.InvitationList_team.testObject_InvitationList_team_18, "testObject_InvitationList_team_18.json"), (Test.Wire.API.Golden.Generated.InvitationList_team.testObject_InvitationList_team_19, "testObject_InvitationList_team_19.json"), (Test.Wire.API.Golden.Generated.InvitationList_team.testObject_InvitationList_team_20, "testObject_InvitationList_team_20.json")],
      testGroup "Golden: NewLegalHoldService_team" $
        testObjects [(Test.Wire.API.Golden.Generated.NewLegalHoldService_team.testObject_NewLegalHoldService_team_1, "testObject_NewLegalHoldService_team_1.json"), (Test.Wire.API.Golden.Generated.NewLegalHoldService_team.testObject_NewLegalHoldService_team_2, "testObject_NewLegalHoldService_team_2.json"), (Test.Wire.API.Golden.Generated.NewLegalHoldService_team.testObject_NewLegalHoldService_team_3, "testObject_NewLegalHoldService_team_3.json"), (Test.Wire.API.Golden.Generated.NewLegalHoldService_team.testObject_NewLegalHoldService_team_4, "testObject_NewLegalHoldService_team_4.json"), (Test.Wire.API.Golden.Generated.NewLegalHoldService_team.testObject_NewLegalHoldService_team_5, "testObject_NewLegalHoldService_team_5.json"), (Test.Wire.API.Golden.Generated.NewLegalHoldService_team.testObject_NewLegalHoldService_team_6, "testObject_NewLegalHoldService_team_6.json"), (Test.Wire.API.Golden.Generated.NewLegalHoldService_team.testObject_NewLegalHoldService_team_7, "testObject_NewLegalHoldService_team_7.json"), (Test.Wire.API.Golden.Generated.NewLegalHoldService_team.testObject_NewLegalHoldService_team_8, "testObject_NewLegalHoldService_team_8.json"), (Test.Wire.API.Golden.Generated.NewLegalHoldService_team.testObject_NewLegalHoldService_team_9, "testObject_NewLegalHoldService_team_9.json"), (Test.Wire.API.Golden.Generated.NewLegalHoldService_team.testObject_NewLegalHoldService_team_10, "testObject_NewLegalHoldService_team_10.json"), (Test.Wire.API.Golden.Generated.NewLegalHoldService_team.testObject_NewLegalHoldService_team_11, "testObject_NewLegalHoldService_team_11.json"), (Test.Wire.API.Golden.Generated.NewLegalHoldService_team.testObject_NewLegalHoldService_team_12, "testObject_NewLegalHoldService_team_12.json"), (Test.Wire.API.Golden.Generated.NewLegalHoldService_team.testObject_NewLegalHoldService_team_13, "testObject_NewLegalHoldService_team_13.json"), (Test.Wire.API.Golden.Generated.NewLegalHoldService_team.testObject_NewLegalHoldService_team_14, "testObject_NewLegalHoldService_team_14.json"), (Test.Wire.API.Golden.Generated.NewLegalHoldService_team.testObject_NewLegalHoldService_team_15, "testObject_NewLegalHoldService_team_15.json"), (Test.Wire.API.Golden.Generated.NewLegalHoldService_team.testObject_NewLegalHoldService_team_16, "testObject_NewLegalHoldService_team_16.json"), (Test.Wire.API.Golden.Generated.NewLegalHoldService_team.testObject_NewLegalHoldService_team_17, "testObject_NewLegalHoldService_team_17.json"), (Test.Wire.API.Golden.Generated.NewLegalHoldService_team.testObject_NewLegalHoldService_team_18, "testObject_NewLegalHoldService_team_18.json"), (Test.Wire.API.Golden.Generated.NewLegalHoldService_team.testObject_NewLegalHoldService_team_19, "testObject_NewLegalHoldService_team_19.json"), (Test.Wire.API.Golden.Generated.NewLegalHoldService_team.testObject_NewLegalHoldService_team_20, "testObject_NewLegalHoldService_team_20.json")],
      testGroup "Golden: ViewLegalHoldServiceInfo_team" $
        testObjects [(Test.Wire.API.Golden.Generated.ViewLegalHoldServiceInfo_team.testObject_ViewLegalHoldServiceInfo_team_1, "testObject_ViewLegalHoldServiceInfo_team_1.json"), (Test.Wire.API.Golden.Generated.ViewLegalHoldServiceInfo_team.testObject_ViewLegalHoldServiceInfo_team_2, "testObject_ViewLegalHoldServiceInfo_team_2.json"), (Test.Wire.API.Golden.Generated.ViewLegalHoldServiceInfo_team.testObject_ViewLegalHoldServiceInfo_team_3, "testObject_ViewLegalHoldServiceInfo_team_3.json"), (Test.Wire.API.Golden.Generated.ViewLegalHoldServiceInfo_team.testObject_ViewLegalHoldServiceInfo_team_4, "testObject_ViewLegalHoldServiceInfo_team_4.json"), (Test.Wire.API.Golden.Generated.ViewLegalHoldServiceInfo_team.testObject_ViewLegalHoldServiceInfo_team_5, "testObject_ViewLegalHoldServiceInfo_team_5.json"), (Test.Wire.API.Golden.Generated.ViewLegalHoldServiceInfo_team.testObject_ViewLegalHoldServiceInfo_team_6, "testObject_ViewLegalHoldServiceInfo_team_6.json"), (Test.Wire.API.Golden.Generated.ViewLegalHoldServiceInfo_team.testObject_ViewLegalHoldServiceInfo_team_7, "testObject_ViewLegalHoldServiceInfo_team_7.json"), (Test.Wire.API.Golden.Generated.ViewLegalHoldServiceInfo_team.testObject_ViewLegalHoldServiceInfo_team_8, "testObject_ViewLegalHoldServiceInfo_team_8.json"), (Test.Wire.API.Golden.Generated.ViewLegalHoldServiceInfo_team.testObject_ViewLegalHoldServiceInfo_team_9, "testObject_ViewLegalHoldServiceInfo_team_9.json"), (Test.Wire.API.Golden.Generated.ViewLegalHoldServiceInfo_team.testObject_ViewLegalHoldServiceInfo_team_10, "testObject_ViewLegalHoldServiceInfo_team_10.json"), (Test.Wire.API.Golden.Generated.ViewLegalHoldServiceInfo_team.testObject_ViewLegalHoldServiceInfo_team_11, "testObject_ViewLegalHoldServiceInfo_team_11.json"), (Test.Wire.API.Golden.Generated.ViewLegalHoldServiceInfo_team.testObject_ViewLegalHoldServiceInfo_team_12, "testObject_ViewLegalHoldServiceInfo_team_12.json"), (Test.Wire.API.Golden.Generated.ViewLegalHoldServiceInfo_team.testObject_ViewLegalHoldServiceInfo_team_13, "testObject_ViewLegalHoldServiceInfo_team_13.json"), (Test.Wire.API.Golden.Generated.ViewLegalHoldServiceInfo_team.testObject_ViewLegalHoldServiceInfo_team_14, "testObject_ViewLegalHoldServiceInfo_team_14.json"), (Test.Wire.API.Golden.Generated.ViewLegalHoldServiceInfo_team.testObject_ViewLegalHoldServiceInfo_team_15, "testObject_ViewLegalHoldServiceInfo_team_15.json"), (Test.Wire.API.Golden.Generated.ViewLegalHoldServiceInfo_team.testObject_ViewLegalHoldServiceInfo_team_16, "testObject_ViewLegalHoldServiceInfo_team_16.json"), (Test.Wire.API.Golden.Generated.ViewLegalHoldServiceInfo_team.testObject_ViewLegalHoldServiceInfo_team_17, "testObject_ViewLegalHoldServiceInfo_team_17.json"), (Test.Wire.API.Golden.Generated.ViewLegalHoldServiceInfo_team.testObject_ViewLegalHoldServiceInfo_team_18, "testObject_ViewLegalHoldServiceInfo_team_18.json"), (Test.Wire.API.Golden.Generated.ViewLegalHoldServiceInfo_team.testObject_ViewLegalHoldServiceInfo_team_19, "testObject_ViewLegalHoldServiceInfo_team_19.json"), (Test.Wire.API.Golden.Generated.ViewLegalHoldServiceInfo_team.testObject_ViewLegalHoldServiceInfo_team_20, "testObject_ViewLegalHoldServiceInfo_team_20.json")],
      testGroup "Golden: ViewLegalHoldService_team" $
        testObjects [(Test.Wire.API.Golden.Generated.ViewLegalHoldService_team.testObject_ViewLegalHoldService_team_1, "testObject_ViewLegalHoldService_team_1.json"), (Test.Wire.API.Golden.Generated.ViewLegalHoldService_team.testObject_ViewLegalHoldService_team_2, "testObject_ViewLegalHoldService_team_2.json"), (Test.Wire.API.Golden.Generated.ViewLegalHoldService_team.testObject_ViewLegalHoldService_team_3, "testObject_ViewLegalHoldService_team_3.json"), (Test.Wire.API.Golden.Generated.ViewLegalHoldService_team.testObject_ViewLegalHoldService_team_4, "testObject_ViewLegalHoldService_team_4.json"), (Test.Wire.API.Golden.Generated.ViewLegalHoldService_team.testObject_ViewLegalHoldService_team_5, "testObject_ViewLegalHoldService_team_5.json"), (Test.Wire.API.Golden.Generated.ViewLegalHoldService_team.testObject_ViewLegalHoldService_team_6, "testObject_ViewLegalHoldService_team_6.json"), (Test.Wire.API.Golden.Generated.ViewLegalHoldService_team.testObject_ViewLegalHoldService_team_7, "testObject_ViewLegalHoldService_team_7.json"), (Test.Wire.API.Golden.Generated.ViewLegalHoldService_team.testObject_ViewLegalHoldService_team_8, "testObject_ViewLegalHoldService_team_8.json"), (Test.Wire.API.Golden.Generated.ViewLegalHoldService_team.testObject_ViewLegalHoldService_team_9, "testObject_ViewLegalHoldService_team_9.json"), (Test.Wire.API.Golden.Generated.ViewLegalHoldService_team.testObject_ViewLegalHoldService_team_10, "testObject_ViewLegalHoldService_team_10.json"), (Test.Wire.API.Golden.Generated.ViewLegalHoldService_team.testObject_ViewLegalHoldService_team_11, "testObject_ViewLegalHoldService_team_11.json"), (Test.Wire.API.Golden.Generated.ViewLegalHoldService_team.testObject_ViewLegalHoldService_team_12, "testObject_ViewLegalHoldService_team_12.json"), (Test.Wire.API.Golden.Generated.ViewLegalHoldService_team.testObject_ViewLegalHoldService_team_13, "testObject_ViewLegalHoldService_team_13.json"), (Test.Wire.API.Golden.Generated.ViewLegalHoldService_team.testObject_ViewLegalHoldService_team_14, "testObject_ViewLegalHoldService_team_14.json"), (Test.Wire.API.Golden.Generated.ViewLegalHoldService_team.testObject_ViewLegalHoldService_team_15, "testObject_ViewLegalHoldService_team_15.json"), (Test.Wire.API.Golden.Generated.ViewLegalHoldService_team.testObject_ViewLegalHoldService_team_16, "testObject_ViewLegalHoldService_team_16.json"), (Test.Wire.API.Golden.Generated.ViewLegalHoldService_team.testObject_ViewLegalHoldService_team_17, "testObject_ViewLegalHoldService_team_17.json"), (Test.Wire.API.Golden.Generated.ViewLegalHoldService_team.testObject_ViewLegalHoldService_team_18, "testObject_ViewLegalHoldService_team_18.json"), (Test.Wire.API.Golden.Generated.ViewLegalHoldService_team.testObject_ViewLegalHoldService_team_19, "testObject_ViewLegalHoldService_team_19.json"), (Test.Wire.API.Golden.Generated.ViewLegalHoldService_team.testObject_ViewLegalHoldService_team_20, "testObject_ViewLegalHoldService_team_20.json")],
      testGroup "Golden: UserLegalHoldStatusResponse_team" $
        testObjects [(Test.Wire.API.Golden.Generated.UserLegalHoldStatusResponse_team.testObject_UserLegalHoldStatusResponse_team_1, "testObject_UserLegalHoldStatusResponse_team_1.json"), (Test.Wire.API.Golden.Generated.UserLegalHoldStatusResponse_team.testObject_UserLegalHoldStatusResponse_team_2, "testObject_UserLegalHoldStatusResponse_team_2.json"), (Test.Wire.API.Golden.Generated.UserLegalHoldStatusResponse_team.testObject_UserLegalHoldStatusResponse_team_3, "testObject_UserLegalHoldStatusResponse_team_3.json"), (Test.Wire.API.Golden.Generated.UserLegalHoldStatusResponse_team.testObject_UserLegalHoldStatusResponse_team_4, "testObject_UserLegalHoldStatusResponse_team_4.json"), (Test.Wire.API.Golden.Generated.UserLegalHoldStatusResponse_team.testObject_UserLegalHoldStatusResponse_team_5, "testObject_UserLegalHoldStatusResponse_team_5.json"), (Test.Wire.API.Golden.Generated.UserLegalHoldStatusResponse_team.testObject_UserLegalHoldStatusResponse_team_6, "testObject_UserLegalHoldStatusResponse_team_6.json"), (Test.Wire.API.Golden.Generated.UserLegalHoldStatusResponse_team.testObject_UserLegalHoldStatusResponse_team_7, "testObject_UserLegalHoldStatusResponse_team_7.json"), (Test.Wire.API.Golden.Generated.UserLegalHoldStatusResponse_team.testObject_UserLegalHoldStatusResponse_team_8, "testObject_UserLegalHoldStatusResponse_team_8.json"), (Test.Wire.API.Golden.Generated.UserLegalHoldStatusResponse_team.testObject_UserLegalHoldStatusResponse_team_9, "testObject_UserLegalHoldStatusResponse_team_9.json"), (Test.Wire.API.Golden.Generated.UserLegalHoldStatusResponse_team.testObject_UserLegalHoldStatusResponse_team_10, "testObject_UserLegalHoldStatusResponse_team_10.json"), (Test.Wire.API.Golden.Generated.UserLegalHoldStatusResponse_team.testObject_UserLegalHoldStatusResponse_team_11, "testObject_UserLegalHoldStatusResponse_team_11.json"), (Test.Wire.API.Golden.Generated.UserLegalHoldStatusResponse_team.testObject_UserLegalHoldStatusResponse_team_12, "testObject_UserLegalHoldStatusResponse_team_12.json"), (Test.Wire.API.Golden.Generated.UserLegalHoldStatusResponse_team.testObject_UserLegalHoldStatusResponse_team_13, "testObject_UserLegalHoldStatusResponse_team_13.json"), (Test.Wire.API.Golden.Generated.UserLegalHoldStatusResponse_team.testObject_UserLegalHoldStatusResponse_team_14, "testObject_UserLegalHoldStatusResponse_team_14.json"), (Test.Wire.API.Golden.Generated.UserLegalHoldStatusResponse_team.testObject_UserLegalHoldStatusResponse_team_15, "testObject_UserLegalHoldStatusResponse_team_15.json"), (Test.Wire.API.Golden.Generated.UserLegalHoldStatusResponse_team.testObject_UserLegalHoldStatusResponse_team_16, "testObject_UserLegalHoldStatusResponse_team_16.json"), (Test.Wire.API.Golden.Generated.UserLegalHoldStatusResponse_team.testObject_UserLegalHoldStatusResponse_team_17, "testObject_UserLegalHoldStatusResponse_team_17.json"), (Test.Wire.API.Golden.Generated.UserLegalHoldStatusResponse_team.testObject_UserLegalHoldStatusResponse_team_18, "testObject_UserLegalHoldStatusResponse_team_18.json"), (Test.Wire.API.Golden.Generated.UserLegalHoldStatusResponse_team.testObject_UserLegalHoldStatusResponse_team_19, "testObject_UserLegalHoldStatusResponse_team_19.json"), (Test.Wire.API.Golden.Generated.UserLegalHoldStatusResponse_team.testObject_UserLegalHoldStatusResponse_team_20, "testObject_UserLegalHoldStatusResponse_team_20.json")],
      testGroup "Golden: RemoveLegalHoldSettingsRequest_team" $
        testObjects [(Test.Wire.API.Golden.Generated.RemoveLegalHoldSettingsRequest_team.testObject_RemoveLegalHoldSettingsRequest_team_1, "testObject_RemoveLegalHoldSettingsRequest_team_1.json"), (Test.Wire.API.Golden.Generated.RemoveLegalHoldSettingsRequest_team.testObject_RemoveLegalHoldSettingsRequest_team_2, "testObject_RemoveLegalHoldSettingsRequest_team_2.json"), (Test.Wire.API.Golden.Generated.RemoveLegalHoldSettingsRequest_team.testObject_RemoveLegalHoldSettingsRequest_team_3, "testObject_RemoveLegalHoldSettingsRequest_team_3.json"), (Test.Wire.API.Golden.Generated.RemoveLegalHoldSettingsRequest_team.testObject_RemoveLegalHoldSettingsRequest_team_4, "testObject_RemoveLegalHoldSettingsRequest_team_4.json"), (Test.Wire.API.Golden.Generated.RemoveLegalHoldSettingsRequest_team.testObject_RemoveLegalHoldSettingsRequest_team_5, "testObject_RemoveLegalHoldSettingsRequest_team_5.json"), (Test.Wire.API.Golden.Generated.RemoveLegalHoldSettingsRequest_team.testObject_RemoveLegalHoldSettingsRequest_team_6, "testObject_RemoveLegalHoldSettingsRequest_team_6.json"), (Test.Wire.API.Golden.Generated.RemoveLegalHoldSettingsRequest_team.testObject_RemoveLegalHoldSettingsRequest_team_7, "testObject_RemoveLegalHoldSettingsRequest_team_7.json"), (Test.Wire.API.Golden.Generated.RemoveLegalHoldSettingsRequest_team.testObject_RemoveLegalHoldSettingsRequest_team_8, "testObject_RemoveLegalHoldSettingsRequest_team_8.json"), (Test.Wire.API.Golden.Generated.RemoveLegalHoldSettingsRequest_team.testObject_RemoveLegalHoldSettingsRequest_team_9, "testObject_RemoveLegalHoldSettingsRequest_team_9.json"), (Test.Wire.API.Golden.Generated.RemoveLegalHoldSettingsRequest_team.testObject_RemoveLegalHoldSettingsRequest_team_10, "testObject_RemoveLegalHoldSettingsRequest_team_10.json"), (Test.Wire.API.Golden.Generated.RemoveLegalHoldSettingsRequest_team.testObject_RemoveLegalHoldSettingsRequest_team_11, "testObject_RemoveLegalHoldSettingsRequest_team_11.json"), (Test.Wire.API.Golden.Generated.RemoveLegalHoldSettingsRequest_team.testObject_RemoveLegalHoldSettingsRequest_team_12, "testObject_RemoveLegalHoldSettingsRequest_team_12.json"), (Test.Wire.API.Golden.Generated.RemoveLegalHoldSettingsRequest_team.testObject_RemoveLegalHoldSettingsRequest_team_13, "testObject_RemoveLegalHoldSettingsRequest_team_13.json"), (Test.Wire.API.Golden.Generated.RemoveLegalHoldSettingsRequest_team.testObject_RemoveLegalHoldSettingsRequest_team_14, "testObject_RemoveLegalHoldSettingsRequest_team_14.json"), (Test.Wire.API.Golden.Generated.RemoveLegalHoldSettingsRequest_team.testObject_RemoveLegalHoldSettingsRequest_team_15, "testObject_RemoveLegalHoldSettingsRequest_team_15.json"), (Test.Wire.API.Golden.Generated.RemoveLegalHoldSettingsRequest_team.testObject_RemoveLegalHoldSettingsRequest_team_16, "testObject_RemoveLegalHoldSettingsRequest_team_16.json"), (Test.Wire.API.Golden.Generated.RemoveLegalHoldSettingsRequest_team.testObject_RemoveLegalHoldSettingsRequest_team_17, "testObject_RemoveLegalHoldSettingsRequest_team_17.json"), (Test.Wire.API.Golden.Generated.RemoveLegalHoldSettingsRequest_team.testObject_RemoveLegalHoldSettingsRequest_team_18, "testObject_RemoveLegalHoldSettingsRequest_team_18.json"), (Test.Wire.API.Golden.Generated.RemoveLegalHoldSettingsRequest_team.testObject_RemoveLegalHoldSettingsRequest_team_19, "testObject_RemoveLegalHoldSettingsRequest_team_19.json"), (Test.Wire.API.Golden.Generated.RemoveLegalHoldSettingsRequest_team.testObject_RemoveLegalHoldSettingsRequest_team_20, "testObject_RemoveLegalHoldSettingsRequest_team_20.json")],
      testGroup "Golden: DisableLegalHoldForUserRequest_team" $
        testObjects [(Test.Wire.API.Golden.Generated.DisableLegalHoldForUserRequest_team.testObject_DisableLegalHoldForUserRequest_team_1, "testObject_DisableLegalHoldForUserRequest_team_1.json"), (Test.Wire.API.Golden.Generated.DisableLegalHoldForUserRequest_team.testObject_DisableLegalHoldForUserRequest_team_2, "testObject_DisableLegalHoldForUserRequest_team_2.json"), (Test.Wire.API.Golden.Generated.DisableLegalHoldForUserRequest_team.testObject_DisableLegalHoldForUserRequest_team_3, "testObject_DisableLegalHoldForUserRequest_team_3.json"), (Test.Wire.API.Golden.Generated.DisableLegalHoldForUserRequest_team.testObject_DisableLegalHoldForUserRequest_team_4, "testObject_DisableLegalHoldForUserRequest_team_4.json"), (Test.Wire.API.Golden.Generated.DisableLegalHoldForUserRequest_team.testObject_DisableLegalHoldForUserRequest_team_5, "testObject_DisableLegalHoldForUserRequest_team_5.json"), (Test.Wire.API.Golden.Generated.DisableLegalHoldForUserRequest_team.testObject_DisableLegalHoldForUserRequest_team_6, "testObject_DisableLegalHoldForUserRequest_team_6.json"), (Test.Wire.API.Golden.Generated.DisableLegalHoldForUserRequest_team.testObject_DisableLegalHoldForUserRequest_team_7, "testObject_DisableLegalHoldForUserRequest_team_7.json"), (Test.Wire.API.Golden.Generated.DisableLegalHoldForUserRequest_team.testObject_DisableLegalHoldForUserRequest_team_8, "testObject_DisableLegalHoldForUserRequest_team_8.json"), (Test.Wire.API.Golden.Generated.DisableLegalHoldForUserRequest_team.testObject_DisableLegalHoldForUserRequest_team_9, "testObject_DisableLegalHoldForUserRequest_team_9.json"), (Test.Wire.API.Golden.Generated.DisableLegalHoldForUserRequest_team.testObject_DisableLegalHoldForUserRequest_team_10, "testObject_DisableLegalHoldForUserRequest_team_10.json"), (Test.Wire.API.Golden.Generated.DisableLegalHoldForUserRequest_team.testObject_DisableLegalHoldForUserRequest_team_11, "testObject_DisableLegalHoldForUserRequest_team_11.json"), (Test.Wire.API.Golden.Generated.DisableLegalHoldForUserRequest_team.testObject_DisableLegalHoldForUserRequest_team_12, "testObject_DisableLegalHoldForUserRequest_team_12.json"), (Test.Wire.API.Golden.Generated.DisableLegalHoldForUserRequest_team.testObject_DisableLegalHoldForUserRequest_team_13, "testObject_DisableLegalHoldForUserRequest_team_13.json"), (Test.Wire.API.Golden.Generated.DisableLegalHoldForUserRequest_team.testObject_DisableLegalHoldForUserRequest_team_14, "testObject_DisableLegalHoldForUserRequest_team_14.json"), (Test.Wire.API.Golden.Generated.DisableLegalHoldForUserRequest_team.testObject_DisableLegalHoldForUserRequest_team_15, "testObject_DisableLegalHoldForUserRequest_team_15.json"), (Test.Wire.API.Golden.Generated.DisableLegalHoldForUserRequest_team.testObject_DisableLegalHoldForUserRequest_team_16, "testObject_DisableLegalHoldForUserRequest_team_16.json"), (Test.Wire.API.Golden.Generated.DisableLegalHoldForUserRequest_team.testObject_DisableLegalHoldForUserRequest_team_17, "testObject_DisableLegalHoldForUserRequest_team_17.json"), (Test.Wire.API.Golden.Generated.DisableLegalHoldForUserRequest_team.testObject_DisableLegalHoldForUserRequest_team_18, "testObject_DisableLegalHoldForUserRequest_team_18.json"), (Test.Wire.API.Golden.Generated.DisableLegalHoldForUserRequest_team.testObject_DisableLegalHoldForUserRequest_team_19, "testObject_DisableLegalHoldForUserRequest_team_19.json"), (Test.Wire.API.Golden.Generated.DisableLegalHoldForUserRequest_team.testObject_DisableLegalHoldForUserRequest_team_20, "testObject_DisableLegalHoldForUserRequest_team_20.json")],
      testGroup "Golden: ApproveLegalHoldForUserRequest_team" $
        testObjects [(Test.Wire.API.Golden.Generated.ApproveLegalHoldForUserRequest_team.testObject_ApproveLegalHoldForUserRequest_team_1, "testObject_ApproveLegalHoldForUserRequest_team_1.json"), (Test.Wire.API.Golden.Generated.ApproveLegalHoldForUserRequest_team.testObject_ApproveLegalHoldForUserRequest_team_2, "testObject_ApproveLegalHoldForUserRequest_team_2.json"), (Test.Wire.API.Golden.Generated.ApproveLegalHoldForUserRequest_team.testObject_ApproveLegalHoldForUserRequest_team_3, "testObject_ApproveLegalHoldForUserRequest_team_3.json"), (Test.Wire.API.Golden.Generated.ApproveLegalHoldForUserRequest_team.testObject_ApproveLegalHoldForUserRequest_team_4, "testObject_ApproveLegalHoldForUserRequest_team_4.json"), (Test.Wire.API.Golden.Generated.ApproveLegalHoldForUserRequest_team.testObject_ApproveLegalHoldForUserRequest_team_5, "testObject_ApproveLegalHoldForUserRequest_team_5.json"), (Test.Wire.API.Golden.Generated.ApproveLegalHoldForUserRequest_team.testObject_ApproveLegalHoldForUserRequest_team_6, "testObject_ApproveLegalHoldForUserRequest_team_6.json"), (Test.Wire.API.Golden.Generated.ApproveLegalHoldForUserRequest_team.testObject_ApproveLegalHoldForUserRequest_team_7, "testObject_ApproveLegalHoldForUserRequest_team_7.json"), (Test.Wire.API.Golden.Generated.ApproveLegalHoldForUserRequest_team.testObject_ApproveLegalHoldForUserRequest_team_8, "testObject_ApproveLegalHoldForUserRequest_team_8.json"), (Test.Wire.API.Golden.Generated.ApproveLegalHoldForUserRequest_team.testObject_ApproveLegalHoldForUserRequest_team_9, "testObject_ApproveLegalHoldForUserRequest_team_9.json"), (Test.Wire.API.Golden.Generated.ApproveLegalHoldForUserRequest_team.testObject_ApproveLegalHoldForUserRequest_team_10, "testObject_ApproveLegalHoldForUserRequest_team_10.json"), (Test.Wire.API.Golden.Generated.ApproveLegalHoldForUserRequest_team.testObject_ApproveLegalHoldForUserRequest_team_11, "testObject_ApproveLegalHoldForUserRequest_team_11.json"), (Test.Wire.API.Golden.Generated.ApproveLegalHoldForUserRequest_team.testObject_ApproveLegalHoldForUserRequest_team_12, "testObject_ApproveLegalHoldForUserRequest_team_12.json"), (Test.Wire.API.Golden.Generated.ApproveLegalHoldForUserRequest_team.testObject_ApproveLegalHoldForUserRequest_team_13, "testObject_ApproveLegalHoldForUserRequest_team_13.json"), (Test.Wire.API.Golden.Generated.ApproveLegalHoldForUserRequest_team.testObject_ApproveLegalHoldForUserRequest_team_14, "testObject_ApproveLegalHoldForUserRequest_team_14.json"), (Test.Wire.API.Golden.Generated.ApproveLegalHoldForUserRequest_team.testObject_ApproveLegalHoldForUserRequest_team_15, "testObject_ApproveLegalHoldForUserRequest_team_15.json"), (Test.Wire.API.Golden.Generated.ApproveLegalHoldForUserRequest_team.testObject_ApproveLegalHoldForUserRequest_team_16, "testObject_ApproveLegalHoldForUserRequest_team_16.json"), (Test.Wire.API.Golden.Generated.ApproveLegalHoldForUserRequest_team.testObject_ApproveLegalHoldForUserRequest_team_17, "testObject_ApproveLegalHoldForUserRequest_team_17.json"), (Test.Wire.API.Golden.Generated.ApproveLegalHoldForUserRequest_team.testObject_ApproveLegalHoldForUserRequest_team_18, "testObject_ApproveLegalHoldForUserRequest_team_18.json"), (Test.Wire.API.Golden.Generated.ApproveLegalHoldForUserRequest_team.testObject_ApproveLegalHoldForUserRequest_team_19, "testObject_ApproveLegalHoldForUserRequest_team_19.json"), (Test.Wire.API.Golden.Generated.ApproveLegalHoldForUserRequest_team.testObject_ApproveLegalHoldForUserRequest_team_20, "testObject_ApproveLegalHoldForUserRequest_team_20.json")],
      testGroup "Golden: RequestNewLegalHoldClientV0_team" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.RequestNewLegalHoldClient_team.testObject_RequestNewLegalHoldClientV0_team_1, "testObject_RequestNewLegalHoldClientV0_team_1.json"),
            (Test.Wire.API.Golden.Generated.RequestNewLegalHoldClient_team.testObject_RequestNewLegalHoldClientV0_team_2, "testObject_RequestNewLegalHoldClientV0_team_2.json")
          ],
      testGroup "Golden: RequestNewLegalHoldClient_team" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.RequestNewLegalHoldClient_team.testObject_RequestNewLegalHoldClient_team_1, "testObject_RequestNewLegalHoldClient_team_1.json"),
            (Test.Wire.API.Golden.Generated.RequestNewLegalHoldClient_team.testObject_RequestNewLegalHoldClient_team_2, "testObject_RequestNewLegalHoldClient_team_2.json")
          ],
      testGroup "Golden: NewLegalHoldClient_team" $
        testObjects [(Test.Wire.API.Golden.Generated.NewLegalHoldClient_team.testObject_NewLegalHoldClient_team_1, "testObject_NewLegalHoldClient_team_1.json"), (Test.Wire.API.Golden.Generated.NewLegalHoldClient_team.testObject_NewLegalHoldClient_team_2, "testObject_NewLegalHoldClient_team_2.json"), (Test.Wire.API.Golden.Generated.NewLegalHoldClient_team.testObject_NewLegalHoldClient_team_3, "testObject_NewLegalHoldClient_team_3.json"), (Test.Wire.API.Golden.Generated.NewLegalHoldClient_team.testObject_NewLegalHoldClient_team_4, "testObject_NewLegalHoldClient_team_4.json"), (Test.Wire.API.Golden.Generated.NewLegalHoldClient_team.testObject_NewLegalHoldClient_team_5, "testObject_NewLegalHoldClient_team_5.json"), (Test.Wire.API.Golden.Generated.NewLegalHoldClient_team.testObject_NewLegalHoldClient_team_6, "testObject_NewLegalHoldClient_team_6.json"), (Test.Wire.API.Golden.Generated.NewLegalHoldClient_team.testObject_NewLegalHoldClient_team_7, "testObject_NewLegalHoldClient_team_7.json"), (Test.Wire.API.Golden.Generated.NewLegalHoldClient_team.testObject_NewLegalHoldClient_team_8, "testObject_NewLegalHoldClient_team_8.json"), (Test.Wire.API.Golden.Generated.NewLegalHoldClient_team.testObject_NewLegalHoldClient_team_9, "testObject_NewLegalHoldClient_team_9.json"), (Test.Wire.API.Golden.Generated.NewLegalHoldClient_team.testObject_NewLegalHoldClient_team_10, "testObject_NewLegalHoldClient_team_10.json"), (Test.Wire.API.Golden.Generated.NewLegalHoldClient_team.testObject_NewLegalHoldClient_team_11, "testObject_NewLegalHoldClient_team_11.json"), (Test.Wire.API.Golden.Generated.NewLegalHoldClient_team.testObject_NewLegalHoldClient_team_12, "testObject_NewLegalHoldClient_team_12.json"), (Test.Wire.API.Golden.Generated.NewLegalHoldClient_team.testObject_NewLegalHoldClient_team_13, "testObject_NewLegalHoldClient_team_13.json"), (Test.Wire.API.Golden.Generated.NewLegalHoldClient_team.testObject_NewLegalHoldClient_team_14, "testObject_NewLegalHoldClient_team_14.json"), (Test.Wire.API.Golden.Generated.NewLegalHoldClient_team.testObject_NewLegalHoldClient_team_15, "testObject_NewLegalHoldClient_team_15.json"), (Test.Wire.API.Golden.Generated.NewLegalHoldClient_team.testObject_NewLegalHoldClient_team_16, "testObject_NewLegalHoldClient_team_16.json"), (Test.Wire.API.Golden.Generated.NewLegalHoldClient_team.testObject_NewLegalHoldClient_team_17, "testObject_NewLegalHoldClient_team_17.json"), (Test.Wire.API.Golden.Generated.NewLegalHoldClient_team.testObject_NewLegalHoldClient_team_18, "testObject_NewLegalHoldClient_team_18.json"), (Test.Wire.API.Golden.Generated.NewLegalHoldClient_team.testObject_NewLegalHoldClient_team_19, "testObject_NewLegalHoldClient_team_19.json"), (Test.Wire.API.Golden.Generated.NewLegalHoldClient_team.testObject_NewLegalHoldClient_team_20, "testObject_NewLegalHoldClient_team_20.json")],
      testGroup "Golden: LegalHoldServiceConfirmV0_team" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.LegalHoldServiceConfirm_team.testObject_LegalHoldServiceConfirmV0_team_1, "testObject_LegalHoldServiceConfirmV0_team_1.json"),
            (Test.Wire.API.Golden.Generated.LegalHoldServiceConfirm_team.testObject_LegalHoldServiceConfirmV0_team_2, "testObject_LegalHoldServiceConfirmV0_team_2.json")
          ],
      testGroup "Golden: LegalHoldServiceConfirm_team" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.LegalHoldServiceConfirm_team.testObject_LegalHoldServiceConfirm_team_1, "testObject_LegalHoldServiceConfirm_team_1.json"),
            (Test.Wire.API.Golden.Generated.LegalHoldServiceConfirm_team.testObject_LegalHoldServiceConfirm_team_2, "testObject_LegalHoldServiceConfirm_team_2.json")
          ],
      testGroup "Golden: LegalHoldServiceRemoveV0_team" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.LegalHoldServiceRemove_team.testObject_LegalHoldServiceRemoveV0_team_1, "testObject_LegalHoldServiceRemoveV0_team_1.json"),
            (Test.Wire.API.Golden.Generated.LegalHoldServiceRemove_team.testObject_LegalHoldServiceRemoveV0_team_2, "testObject_LegalHoldServiceRemoveV0_team_2.json")
          ],
      testGroup "Golden: LegalHoldServiceRemove_team" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.LegalHoldServiceRemove_team.testObject_LegalHoldServiceRemove_team_1, "testObject_LegalHoldServiceRemove_team_1.json"),
            (Test.Wire.API.Golden.Generated.LegalHoldServiceRemove_team.testObject_LegalHoldServiceRemove_team_2, "testObject_LegalHoldServiceRemove_team_2.json")
          ],
      testGroup "Golden: TeamMember_team" $
        testObjects [(Test.Wire.API.Golden.Generated.TeamMember_team.testObject_TeamMember_team_1, "testObject_TeamMember_team_1.json"), (Test.Wire.API.Golden.Generated.TeamMember_team.testObject_TeamMember_team_2, "testObject_TeamMember_team_2.json"), (Test.Wire.API.Golden.Generated.TeamMember_team.testObject_TeamMember_team_3, "testObject_TeamMember_team_3.json"), (Test.Wire.API.Golden.Generated.TeamMember_team.testObject_TeamMember_team_4, "testObject_TeamMember_team_4.json"), (Test.Wire.API.Golden.Generated.TeamMember_team.testObject_TeamMember_team_5, "testObject_TeamMember_team_5.json"), (Test.Wire.API.Golden.Generated.TeamMember_team.testObject_TeamMember_team_6, "testObject_TeamMember_team_6.json"), (Test.Wire.API.Golden.Generated.TeamMember_team.testObject_TeamMember_team_7, "testObject_TeamMember_team_7.json"), (Test.Wire.API.Golden.Generated.TeamMember_team.testObject_TeamMember_team_8, "testObject_TeamMember_team_8.json"), (Test.Wire.API.Golden.Generated.TeamMember_team.testObject_TeamMember_team_9, "testObject_TeamMember_team_9.json"), (Test.Wire.API.Golden.Generated.TeamMember_team.testObject_TeamMember_team_10, "testObject_TeamMember_team_10.json"), (Test.Wire.API.Golden.Generated.TeamMember_team.testObject_TeamMember_team_11, "testObject_TeamMember_team_11.json"), (Test.Wire.API.Golden.Generated.TeamMember_team.testObject_TeamMember_team_12, "testObject_TeamMember_team_12.json"), (Test.Wire.API.Golden.Generated.TeamMember_team.testObject_TeamMember_team_13, "testObject_TeamMember_team_13.json"), (Test.Wire.API.Golden.Generated.TeamMember_team.testObject_TeamMember_team_14, "testObject_TeamMember_team_14.json"), (Test.Wire.API.Golden.Generated.TeamMember_team.testObject_TeamMember_team_15, "testObject_TeamMember_team_15.json"), (Test.Wire.API.Golden.Generated.TeamMember_team.testObject_TeamMember_team_16, "testObject_TeamMember_team_16.json"), (Test.Wire.API.Golden.Generated.TeamMember_team.testObject_TeamMember_team_17, "testObject_TeamMember_team_17.json"), (Test.Wire.API.Golden.Generated.TeamMember_team.testObject_TeamMember_team_18, "testObject_TeamMember_team_18.json"), (Test.Wire.API.Golden.Generated.TeamMember_team.testObject_TeamMember_team_19, "testObject_TeamMember_team_19.json"), (Test.Wire.API.Golden.Generated.TeamMember_team.testObject_TeamMember_team_20, "testObject_TeamMember_team_20.json")],
      testGroup "Golden: ListType_team" $
        testObjects [(Test.Wire.API.Golden.Generated.ListType_team.testObject_ListType_team_1, "testObject_ListType_team_1.json"), (Test.Wire.API.Golden.Generated.ListType_team.testObject_ListType_team_2, "testObject_ListType_team_2.json"), (Test.Wire.API.Golden.Generated.ListType_team.testObject_ListType_team_3, "testObject_ListType_team_3.json"), (Test.Wire.API.Golden.Generated.ListType_team.testObject_ListType_team_4, "testObject_ListType_team_4.json"), (Test.Wire.API.Golden.Generated.ListType_team.testObject_ListType_team_5, "testObject_ListType_team_5.json"), (Test.Wire.API.Golden.Generated.ListType_team.testObject_ListType_team_6, "testObject_ListType_team_6.json"), (Test.Wire.API.Golden.Generated.ListType_team.testObject_ListType_team_7, "testObject_ListType_team_7.json"), (Test.Wire.API.Golden.Generated.ListType_team.testObject_ListType_team_8, "testObject_ListType_team_8.json"), (Test.Wire.API.Golden.Generated.ListType_team.testObject_ListType_team_9, "testObject_ListType_team_9.json"), (Test.Wire.API.Golden.Generated.ListType_team.testObject_ListType_team_10, "testObject_ListType_team_10.json"), (Test.Wire.API.Golden.Generated.ListType_team.testObject_ListType_team_11, "testObject_ListType_team_11.json"), (Test.Wire.API.Golden.Generated.ListType_team.testObject_ListType_team_12, "testObject_ListType_team_12.json"), (Test.Wire.API.Golden.Generated.ListType_team.testObject_ListType_team_13, "testObject_ListType_team_13.json"), (Test.Wire.API.Golden.Generated.ListType_team.testObject_ListType_team_14, "testObject_ListType_team_14.json"), (Test.Wire.API.Golden.Generated.ListType_team.testObject_ListType_team_15, "testObject_ListType_team_15.json"), (Test.Wire.API.Golden.Generated.ListType_team.testObject_ListType_team_16, "testObject_ListType_team_16.json"), (Test.Wire.API.Golden.Generated.ListType_team.testObject_ListType_team_17, "testObject_ListType_team_17.json"), (Test.Wire.API.Golden.Generated.ListType_team.testObject_ListType_team_18, "testObject_ListType_team_18.json"), (Test.Wire.API.Golden.Generated.ListType_team.testObject_ListType_team_19, "testObject_ListType_team_19.json"), (Test.Wire.API.Golden.Generated.ListType_team.testObject_ListType_team_20, "testObject_ListType_team_20.json")],
      testGroup "Golden: TeamMemberList_team" $
        testObjects [(Test.Wire.API.Golden.Generated.TeamMemberList_team.testObject_TeamMemberList_team_1, "testObject_TeamMemberList_team_1.json"), (Test.Wire.API.Golden.Generated.TeamMemberList_team.testObject_TeamMemberList_team_2, "testObject_TeamMemberList_team_2.json"), (Test.Wire.API.Golden.Generated.TeamMemberList_team.testObject_TeamMemberList_team_3, "testObject_TeamMemberList_team_3.json"), (Test.Wire.API.Golden.Generated.TeamMemberList_team.testObject_TeamMemberList_team_4, "testObject_TeamMemberList_team_4.json"), (Test.Wire.API.Golden.Generated.TeamMemberList_team.testObject_TeamMemberList_team_5, "testObject_TeamMemberList_team_5.json"), (Test.Wire.API.Golden.Generated.TeamMemberList_team.testObject_TeamMemberList_team_6, "testObject_TeamMemberList_team_6.json"), (Test.Wire.API.Golden.Generated.TeamMemberList_team.testObject_TeamMemberList_team_7, "testObject_TeamMemberList_team_7.json"), (Test.Wire.API.Golden.Generated.TeamMemberList_team.testObject_TeamMemberList_team_8, "testObject_TeamMemberList_team_8.json"), (Test.Wire.API.Golden.Generated.TeamMemberList_team.testObject_TeamMemberList_team_9, "testObject_TeamMemberList_team_9.json"), (Test.Wire.API.Golden.Generated.TeamMemberList_team.testObject_TeamMemberList_team_10, "testObject_TeamMemberList_team_10.json"), (Test.Wire.API.Golden.Generated.TeamMemberList_team.testObject_TeamMemberList_team_11, "testObject_TeamMemberList_team_11.json"), (Test.Wire.API.Golden.Generated.TeamMemberList_team.testObject_TeamMemberList_team_12, "testObject_TeamMemberList_team_12.json"), (Test.Wire.API.Golden.Generated.TeamMemberList_team.testObject_TeamMemberList_team_13, "testObject_TeamMemberList_team_13.json"), (Test.Wire.API.Golden.Generated.TeamMemberList_team.testObject_TeamMemberList_team_14, "testObject_TeamMemberList_team_14.json"), (Test.Wire.API.Golden.Generated.TeamMemberList_team.testObject_TeamMemberList_team_15, "testObject_TeamMemberList_team_15.json"), (Test.Wire.API.Golden.Generated.TeamMemberList_team.testObject_TeamMemberList_team_16, "testObject_TeamMemberList_team_16.json"), (Test.Wire.API.Golden.Generated.TeamMemberList_team.testObject_TeamMemberList_team_17, "testObject_TeamMemberList_team_17.json"), (Test.Wire.API.Golden.Generated.TeamMemberList_team.testObject_TeamMemberList_team_18, "testObject_TeamMemberList_team_18.json"), (Test.Wire.API.Golden.Generated.TeamMemberList_team.testObject_TeamMemberList_team_19, "testObject_TeamMemberList_team_19.json"), (Test.Wire.API.Golden.Generated.TeamMemberList_team.testObject_TeamMemberList_team_20, "testObject_TeamMemberList_team_20.json")],
      testGroup "Golden: NewTeamMember_team" $
        testObjects [(Test.Wire.API.Golden.Generated.NewTeamMember_team.testObject_NewTeamMember_team_1, "testObject_NewTeamMember_team_1.json"), (Test.Wire.API.Golden.Generated.NewTeamMember_team.testObject_NewTeamMember_team_2, "testObject_NewTeamMember_team_2.json"), (Test.Wire.API.Golden.Generated.NewTeamMember_team.testObject_NewTeamMember_team_3, "testObject_NewTeamMember_team_3.json"), (Test.Wire.API.Golden.Generated.NewTeamMember_team.testObject_NewTeamMember_team_4, "testObject_NewTeamMember_team_4.json"), (Test.Wire.API.Golden.Generated.NewTeamMember_team.testObject_NewTeamMember_team_5, "testObject_NewTeamMember_team_5.json"), (Test.Wire.API.Golden.Generated.NewTeamMember_team.testObject_NewTeamMember_team_6, "testObject_NewTeamMember_team_6.json"), (Test.Wire.API.Golden.Generated.NewTeamMember_team.testObject_NewTeamMember_team_7, "testObject_NewTeamMember_team_7.json"), (Test.Wire.API.Golden.Generated.NewTeamMember_team.testObject_NewTeamMember_team_8, "testObject_NewTeamMember_team_8.json"), (Test.Wire.API.Golden.Generated.NewTeamMember_team.testObject_NewTeamMember_team_9, "testObject_NewTeamMember_team_9.json"), (Test.Wire.API.Golden.Generated.NewTeamMember_team.testObject_NewTeamMember_team_10, "testObject_NewTeamMember_team_10.json"), (Test.Wire.API.Golden.Generated.NewTeamMember_team.testObject_NewTeamMember_team_11, "testObject_NewTeamMember_team_11.json"), (Test.Wire.API.Golden.Generated.NewTeamMember_team.testObject_NewTeamMember_team_12, "testObject_NewTeamMember_team_12.json"), (Test.Wire.API.Golden.Generated.NewTeamMember_team.testObject_NewTeamMember_team_13, "testObject_NewTeamMember_team_13.json"), (Test.Wire.API.Golden.Generated.NewTeamMember_team.testObject_NewTeamMember_team_14, "testObject_NewTeamMember_team_14.json"), (Test.Wire.API.Golden.Generated.NewTeamMember_team.testObject_NewTeamMember_team_15, "testObject_NewTeamMember_team_15.json"), (Test.Wire.API.Golden.Generated.NewTeamMember_team.testObject_NewTeamMember_team_16, "testObject_NewTeamMember_team_16.json"), (Test.Wire.API.Golden.Generated.NewTeamMember_team.testObject_NewTeamMember_team_17, "testObject_NewTeamMember_team_17.json"), (Test.Wire.API.Golden.Generated.NewTeamMember_team.testObject_NewTeamMember_team_18, "testObject_NewTeamMember_team_18.json"), (Test.Wire.API.Golden.Generated.NewTeamMember_team.testObject_NewTeamMember_team_19, "testObject_NewTeamMember_team_19.json"), (Test.Wire.API.Golden.Generated.NewTeamMember_team.testObject_NewTeamMember_team_20, "testObject_NewTeamMember_team_20.json")],
      testGroup "Golden: TeamMemberDeleteData_team" $
        testObjects [(Test.Wire.API.Golden.Generated.TeamMemberDeleteData_team.testObject_TeamMemberDeleteData_team_1, "testObject_TeamMemberDeleteData_team_1.json"), (Test.Wire.API.Golden.Generated.TeamMemberDeleteData_team.testObject_TeamMemberDeleteData_team_2, "testObject_TeamMemberDeleteData_team_2.json"), (Test.Wire.API.Golden.Generated.TeamMemberDeleteData_team.testObject_TeamMemberDeleteData_team_3, "testObject_TeamMemberDeleteData_team_3.json"), (Test.Wire.API.Golden.Generated.TeamMemberDeleteData_team.testObject_TeamMemberDeleteData_team_4, "testObject_TeamMemberDeleteData_team_4.json"), (Test.Wire.API.Golden.Generated.TeamMemberDeleteData_team.testObject_TeamMemberDeleteData_team_5, "testObject_TeamMemberDeleteData_team_5.json"), (Test.Wire.API.Golden.Generated.TeamMemberDeleteData_team.testObject_TeamMemberDeleteData_team_6, "testObject_TeamMemberDeleteData_team_6.json"), (Test.Wire.API.Golden.Generated.TeamMemberDeleteData_team.testObject_TeamMemberDeleteData_team_7, "testObject_TeamMemberDeleteData_team_7.json"), (Test.Wire.API.Golden.Generated.TeamMemberDeleteData_team.testObject_TeamMemberDeleteData_team_8, "testObject_TeamMemberDeleteData_team_8.json"), (Test.Wire.API.Golden.Generated.TeamMemberDeleteData_team.testObject_TeamMemberDeleteData_team_9, "testObject_TeamMemberDeleteData_team_9.json"), (Test.Wire.API.Golden.Generated.TeamMemberDeleteData_team.testObject_TeamMemberDeleteData_team_10, "testObject_TeamMemberDeleteData_team_10.json"), (Test.Wire.API.Golden.Generated.TeamMemberDeleteData_team.testObject_TeamMemberDeleteData_team_11, "testObject_TeamMemberDeleteData_team_11.json"), (Test.Wire.API.Golden.Generated.TeamMemberDeleteData_team.testObject_TeamMemberDeleteData_team_12, "testObject_TeamMemberDeleteData_team_12.json"), (Test.Wire.API.Golden.Generated.TeamMemberDeleteData_team.testObject_TeamMemberDeleteData_team_13, "testObject_TeamMemberDeleteData_team_13.json"), (Test.Wire.API.Golden.Generated.TeamMemberDeleteData_team.testObject_TeamMemberDeleteData_team_14, "testObject_TeamMemberDeleteData_team_14.json"), (Test.Wire.API.Golden.Generated.TeamMemberDeleteData_team.testObject_TeamMemberDeleteData_team_15, "testObject_TeamMemberDeleteData_team_15.json"), (Test.Wire.API.Golden.Generated.TeamMemberDeleteData_team.testObject_TeamMemberDeleteData_team_16, "testObject_TeamMemberDeleteData_team_16.json"), (Test.Wire.API.Golden.Generated.TeamMemberDeleteData_team.testObject_TeamMemberDeleteData_team_17, "testObject_TeamMemberDeleteData_team_17.json"), (Test.Wire.API.Golden.Generated.TeamMemberDeleteData_team.testObject_TeamMemberDeleteData_team_18, "testObject_TeamMemberDeleteData_team_18.json"), (Test.Wire.API.Golden.Generated.TeamMemberDeleteData_team.testObject_TeamMemberDeleteData_team_19, "testObject_TeamMemberDeleteData_team_19.json"), (Test.Wire.API.Golden.Generated.TeamMemberDeleteData_team.testObject_TeamMemberDeleteData_team_20, "testObject_TeamMemberDeleteData_team_20.json")],
      testGroup "Golden: Permissions_team" $
        testObjects [(Test.Wire.API.Golden.Generated.Permissions_team.testObject_Permissions_team_1, "testObject_Permissions_team_1.json"), (Test.Wire.API.Golden.Generated.Permissions_team.testObject_Permissions_team_2, "testObject_Permissions_team_2.json"), (Test.Wire.API.Golden.Generated.Permissions_team.testObject_Permissions_team_3, "testObject_Permissions_team_3.json"), (Test.Wire.API.Golden.Generated.Permissions_team.testObject_Permissions_team_4, "testObject_Permissions_team_4.json"), (Test.Wire.API.Golden.Generated.Permissions_team.testObject_Permissions_team_5, "testObject_Permissions_team_5.json"), (Test.Wire.API.Golden.Generated.Permissions_team.testObject_Permissions_team_6, "testObject_Permissions_team_6.json"), (Test.Wire.API.Golden.Generated.Permissions_team.testObject_Permissions_team_7, "testObject_Permissions_team_7.json"), (Test.Wire.API.Golden.Generated.Permissions_team.testObject_Permissions_team_8, "testObject_Permissions_team_8.json"), (Test.Wire.API.Golden.Generated.Permissions_team.testObject_Permissions_team_9, "testObject_Permissions_team_9.json"), (Test.Wire.API.Golden.Generated.Permissions_team.testObject_Permissions_team_10, "testObject_Permissions_team_10.json"), (Test.Wire.API.Golden.Generated.Permissions_team.testObject_Permissions_team_11, "testObject_Permissions_team_11.json"), (Test.Wire.API.Golden.Generated.Permissions_team.testObject_Permissions_team_12, "testObject_Permissions_team_12.json"), (Test.Wire.API.Golden.Generated.Permissions_team.testObject_Permissions_team_13, "testObject_Permissions_team_13.json"), (Test.Wire.API.Golden.Generated.Permissions_team.testObject_Permissions_team_14, "testObject_Permissions_team_14.json"), (Test.Wire.API.Golden.Generated.Permissions_team.testObject_Permissions_team_15, "testObject_Permissions_team_15.json"), (Test.Wire.API.Golden.Generated.Permissions_team.testObject_Permissions_team_16, "testObject_Permissions_team_16.json"), (Test.Wire.API.Golden.Generated.Permissions_team.testObject_Permissions_team_17, "testObject_Permissions_team_17.json"), (Test.Wire.API.Golden.Generated.Permissions_team.testObject_Permissions_team_18, "testObject_Permissions_team_18.json"), (Test.Wire.API.Golden.Generated.Permissions_team.testObject_Permissions_team_19, "testObject_Permissions_team_19.json"), (Test.Wire.API.Golden.Generated.Permissions_team.testObject_Permissions_team_20, "testObject_Permissions_team_20.json")],
      testGroup "Golden: Role_team" $
        testObjects [(Test.Wire.API.Golden.Generated.Role_team.testObject_Role_team_1, "testObject_Role_team_1.json"), (Test.Wire.API.Golden.Generated.Role_team.testObject_Role_team_2, "testObject_Role_team_2.json"), (Test.Wire.API.Golden.Generated.Role_team.testObject_Role_team_3, "testObject_Role_team_3.json"), (Test.Wire.API.Golden.Generated.Role_team.testObject_Role_team_4, "testObject_Role_team_4.json"), (Test.Wire.API.Golden.Generated.Role_team.testObject_Role_team_5, "testObject_Role_team_5.json"), (Test.Wire.API.Golden.Generated.Role_team.testObject_Role_team_6, "testObject_Role_team_6.json"), (Test.Wire.API.Golden.Generated.Role_team.testObject_Role_team_7, "testObject_Role_team_7.json"), (Test.Wire.API.Golden.Generated.Role_team.testObject_Role_team_8, "testObject_Role_team_8.json"), (Test.Wire.API.Golden.Generated.Role_team.testObject_Role_team_9, "testObject_Role_team_9.json"), (Test.Wire.API.Golden.Generated.Role_team.testObject_Role_team_10, "testObject_Role_team_10.json"), (Test.Wire.API.Golden.Generated.Role_team.testObject_Role_team_11, "testObject_Role_team_11.json"), (Test.Wire.API.Golden.Generated.Role_team.testObject_Role_team_12, "testObject_Role_team_12.json"), (Test.Wire.API.Golden.Generated.Role_team.testObject_Role_team_13, "testObject_Role_team_13.json"), (Test.Wire.API.Golden.Generated.Role_team.testObject_Role_team_14, "testObject_Role_team_14.json"), (Test.Wire.API.Golden.Generated.Role_team.testObject_Role_team_15, "testObject_Role_team_15.json"), (Test.Wire.API.Golden.Generated.Role_team.testObject_Role_team_16, "testObject_Role_team_16.json"), (Test.Wire.API.Golden.Generated.Role_team.testObject_Role_team_17, "testObject_Role_team_17.json"), (Test.Wire.API.Golden.Generated.Role_team.testObject_Role_team_18, "testObject_Role_team_18.json"), (Test.Wire.API.Golden.Generated.Role_team.testObject_Role_team_19, "testObject_Role_team_19.json"), (Test.Wire.API.Golden.Generated.Role_team.testObject_Role_team_20, "testObject_Role_team_20.json")],
      testGroup "Golden: TeamSearchVisibility_team" $
        testObjects [(Test.Wire.API.Golden.Generated.TeamSearchVisibility_team.testObject_TeamSearchVisibility_team_1, "testObject_TeamSearchVisibility_team_1.json"), (Test.Wire.API.Golden.Generated.TeamSearchVisibility_team.testObject_TeamSearchVisibility_team_2, "testObject_TeamSearchVisibility_team_2.json"), (Test.Wire.API.Golden.Generated.TeamSearchVisibility_team.testObject_TeamSearchVisibility_team_3, "testObject_TeamSearchVisibility_team_3.json"), (Test.Wire.API.Golden.Generated.TeamSearchVisibility_team.testObject_TeamSearchVisibility_team_4, "testObject_TeamSearchVisibility_team_4.json"), (Test.Wire.API.Golden.Generated.TeamSearchVisibility_team.testObject_TeamSearchVisibility_team_5, "testObject_TeamSearchVisibility_team_5.json"), (Test.Wire.API.Golden.Generated.TeamSearchVisibility_team.testObject_TeamSearchVisibility_team_6, "testObject_TeamSearchVisibility_team_6.json"), (Test.Wire.API.Golden.Generated.TeamSearchVisibility_team.testObject_TeamSearchVisibility_team_7, "testObject_TeamSearchVisibility_team_7.json"), (Test.Wire.API.Golden.Generated.TeamSearchVisibility_team.testObject_TeamSearchVisibility_team_8, "testObject_TeamSearchVisibility_team_8.json"), (Test.Wire.API.Golden.Generated.TeamSearchVisibility_team.testObject_TeamSearchVisibility_team_9, "testObject_TeamSearchVisibility_team_9.json"), (Test.Wire.API.Golden.Generated.TeamSearchVisibility_team.testObject_TeamSearchVisibility_team_10, "testObject_TeamSearchVisibility_team_10.json"), (Test.Wire.API.Golden.Generated.TeamSearchVisibility_team.testObject_TeamSearchVisibility_team_11, "testObject_TeamSearchVisibility_team_11.json"), (Test.Wire.API.Golden.Generated.TeamSearchVisibility_team.testObject_TeamSearchVisibility_team_12, "testObject_TeamSearchVisibility_team_12.json"), (Test.Wire.API.Golden.Generated.TeamSearchVisibility_team.testObject_TeamSearchVisibility_team_13, "testObject_TeamSearchVisibility_team_13.json"), (Test.Wire.API.Golden.Generated.TeamSearchVisibility_team.testObject_TeamSearchVisibility_team_14, "testObject_TeamSearchVisibility_team_14.json"), (Test.Wire.API.Golden.Generated.TeamSearchVisibility_team.testObject_TeamSearchVisibility_team_15, "testObject_TeamSearchVisibility_team_15.json"), (Test.Wire.API.Golden.Generated.TeamSearchVisibility_team.testObject_TeamSearchVisibility_team_16, "testObject_TeamSearchVisibility_team_16.json"), (Test.Wire.API.Golden.Generated.TeamSearchVisibility_team.testObject_TeamSearchVisibility_team_17, "testObject_TeamSearchVisibility_team_17.json"), (Test.Wire.API.Golden.Generated.TeamSearchVisibility_team.testObject_TeamSearchVisibility_team_18, "testObject_TeamSearchVisibility_team_18.json"), (Test.Wire.API.Golden.Generated.TeamSearchVisibility_team.testObject_TeamSearchVisibility_team_19, "testObject_TeamSearchVisibility_team_19.json"), (Test.Wire.API.Golden.Generated.TeamSearchVisibility_team.testObject_TeamSearchVisibility_team_20, "testObject_TeamSearchVisibility_team_20.json")],
      testGroup "Golden: TeamSearchVisibilityView_team" $
        testObjects [(Test.Wire.API.Golden.Generated.TeamSearchVisibilityView_team.testObject_TeamSearchVisibilityView_team_1, "testObject_TeamSearchVisibilityView_team_1.json"), (Test.Wire.API.Golden.Generated.TeamSearchVisibilityView_team.testObject_TeamSearchVisibilityView_team_2, "testObject_TeamSearchVisibilityView_team_2.json"), (Test.Wire.API.Golden.Generated.TeamSearchVisibilityView_team.testObject_TeamSearchVisibilityView_team_3, "testObject_TeamSearchVisibilityView_team_3.json"), (Test.Wire.API.Golden.Generated.TeamSearchVisibilityView_team.testObject_TeamSearchVisibilityView_team_4, "testObject_TeamSearchVisibilityView_team_4.json"), (Test.Wire.API.Golden.Generated.TeamSearchVisibilityView_team.testObject_TeamSearchVisibilityView_team_5, "testObject_TeamSearchVisibilityView_team_5.json"), (Test.Wire.API.Golden.Generated.TeamSearchVisibilityView_team.testObject_TeamSearchVisibilityView_team_6, "testObject_TeamSearchVisibilityView_team_6.json"), (Test.Wire.API.Golden.Generated.TeamSearchVisibilityView_team.testObject_TeamSearchVisibilityView_team_7, "testObject_TeamSearchVisibilityView_team_7.json"), (Test.Wire.API.Golden.Generated.TeamSearchVisibilityView_team.testObject_TeamSearchVisibilityView_team_8, "testObject_TeamSearchVisibilityView_team_8.json"), (Test.Wire.API.Golden.Generated.TeamSearchVisibilityView_team.testObject_TeamSearchVisibilityView_team_9, "testObject_TeamSearchVisibilityView_team_9.json"), (Test.Wire.API.Golden.Generated.TeamSearchVisibilityView_team.testObject_TeamSearchVisibilityView_team_10, "testObject_TeamSearchVisibilityView_team_10.json"), (Test.Wire.API.Golden.Generated.TeamSearchVisibilityView_team.testObject_TeamSearchVisibilityView_team_11, "testObject_TeamSearchVisibilityView_team_11.json"), (Test.Wire.API.Golden.Generated.TeamSearchVisibilityView_team.testObject_TeamSearchVisibilityView_team_12, "testObject_TeamSearchVisibilityView_team_12.json"), (Test.Wire.API.Golden.Generated.TeamSearchVisibilityView_team.testObject_TeamSearchVisibilityView_team_13, "testObject_TeamSearchVisibilityView_team_13.json"), (Test.Wire.API.Golden.Generated.TeamSearchVisibilityView_team.testObject_TeamSearchVisibilityView_team_14, "testObject_TeamSearchVisibilityView_team_14.json"), (Test.Wire.API.Golden.Generated.TeamSearchVisibilityView_team.testObject_TeamSearchVisibilityView_team_15, "testObject_TeamSearchVisibilityView_team_15.json"), (Test.Wire.API.Golden.Generated.TeamSearchVisibilityView_team.testObject_TeamSearchVisibilityView_team_16, "testObject_TeamSearchVisibilityView_team_16.json"), (Test.Wire.API.Golden.Generated.TeamSearchVisibilityView_team.testObject_TeamSearchVisibilityView_team_17, "testObject_TeamSearchVisibilityView_team_17.json"), (Test.Wire.API.Golden.Generated.TeamSearchVisibilityView_team.testObject_TeamSearchVisibilityView_team_18, "testObject_TeamSearchVisibilityView_team_18.json"), (Test.Wire.API.Golden.Generated.TeamSearchVisibilityView_team.testObject_TeamSearchVisibilityView_team_19, "testObject_TeamSearchVisibilityView_team_19.json"), (Test.Wire.API.Golden.Generated.TeamSearchVisibilityView_team.testObject_TeamSearchVisibilityView_team_20, "testObject_TeamSearchVisibilityView_team_20.json")],
      testGroup "Golden: VerificationAction_user" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.VerificationAction_user.testObject_VerificationAction_user_1, "testObject_VerificationAction_user_1"),
            (Test.Wire.API.Golden.Generated.VerificationAction_user.testObject_VerificationAction_user_2, "testObject_VerificationAction_user_2"),
            (Test.Wire.API.Golden.Generated.VerificationAction_user.testObject_VerificationAction_user_3, "testObject_VerificationAction_user_3")
          ],
      testGroup
        "Golden: LockableFeaturePatch_team 1"
        $ testObjects
          [(Test.Wire.API.Golden.Generated.LockableFeaturePatch_team.testObject_LockableFeaturePatch_team_1, "testObject_LockableFeaturePatch_team_1.json")],
      testGroup
        "Golden: LockableFeaturePatch_team 2"
        $ testObjects
          [(Test.Wire.API.Golden.Generated.LockableFeaturePatch_team.testObject_LockableFeaturePatch_team_2, "testObject_LockableFeaturePatch_team_2.json")],
      testGroup
        "Golden: LockableFeaturePatch_team 3"
        $ testObjects
          [(Test.Wire.API.Golden.Generated.LockableFeaturePatch_team.testObject_LockableFeaturePatch_team_3, "testObject_LockableFeaturePatch_team_3.json")],
      testGroup
        "Golden: LockableFeaturePatch_team 4"
        $ testObjects
          [(Test.Wire.API.Golden.Generated.LockableFeaturePatch_team.testObject_LockableFeaturePatch_team_4, "testObject_LockableFeaturePatch_team_4.json")],
      testGroup
        "Golden: LockableFeaturePatch_team 5"
        $ testObjects
          [(Test.Wire.API.Golden.Generated.LockableFeaturePatch_team.testObject_LockableFeaturePatch_team_5, "testObject_LockableFeaturePatch_team_5.json")],
      testGroup
        "Golden: LockableFeaturePatch_team 6"
        $ testObjects
          [(Test.Wire.API.Golden.Generated.LockableFeaturePatch_team.testObject_LockableFeaturePatch_team_6, "testObject_LockableFeaturePatch_team_6.json")],
      testGroup
        "Golden: LockableFeaturePatch_team 7"
        $ testObjects
          [(Test.Wire.API.Golden.Generated.LockableFeaturePatch_team.testObject_LockableFeaturePatch_team_7, "testObject_LockableFeaturePatch_team_7.json")],
      testGroup
        "Golden: LockableFeaturePatch_team 8"
        $ testObjects
          [(Test.Wire.API.Golden.Generated.LockableFeaturePatch_team.testObject_LockableFeaturePatch_team_8, "testObject_LockableFeaturePatch_team_8.json")],
      testGroup
        "Golden: LockableFeaturePatch_team 9"
        $ testObjects
          [(Test.Wire.API.Golden.Generated.LockableFeaturePatch_team.testObject_LockableFeaturePatch_team_9, "testObject_LockableFeaturePatch_team_9.json")],
      testGroup
        "Golden: LockableFeaturePatch_team 10"
        $ testObjects
          [(Test.Wire.API.Golden.Generated.LockableFeaturePatch_team.testObject_LockableFeaturePatch_team_10, "testObject_LockableFeaturePatch_team_10.json")],
      testGroup
        "Golden: LockableFeaturePatch_team 11"
        $ testObjects
          [(Test.Wire.API.Golden.Generated.LockableFeaturePatch_team.testObject_LockableFeaturePatch_team_11, "testObject_LockableFeaturePatch_team_11.json")],
      testGroup
        "Golden: LockableFeaturePatch_team 12"
        $ testObjects
          [(Test.Wire.API.Golden.Generated.LockableFeaturePatch_team.testObject_LockableFeaturePatch_team_12, "testObject_LockableFeaturePatch_team_12.json")],
      testGroup
        "Golden: LockableFeaturePatch_team 13"
        $ testObjects
          [(Test.Wire.API.Golden.Generated.LockableFeaturePatch_team.testObject_LockableFeaturePatch_team_13, "testObject_LockableFeaturePatch_team_13.json")],
      testGroup
        "Golden: LockableFeaturePatch_team 14"
        $ testObjects
          [(Test.Wire.API.Golden.Generated.LockableFeaturePatch_team.testObject_LockableFeaturePatch_team_14, "testObject_LockableFeaturePatch_team_14.json")],
      testGroup
        "Golden: LockableFeaturePatch_team 15"
        $ testObjects
          [(Test.Wire.API.Golden.Generated.LockableFeaturePatch_team.testObject_LockableFeaturePatch_team_15, "testObject_LockableFeaturePatch_team_15.json")],
      testGroup
        "Golden: LockableFeaturePatch_team 16"
        $ testObjects
          [(Test.Wire.API.Golden.Generated.LockableFeaturePatch_team.testObject_LockableFeaturePatch_team_16, "testObject_LockableFeaturePatch_team_16.json")],
      testGroup
        "Golden: LockableFeaturePatch_team 17"
        $ testObjects
          [(Test.Wire.API.Golden.Generated.LockableFeaturePatch_team.testObject_LockableFeaturePatch_team_17, "testObject_LockableFeaturePatch_team_17.json")],
      testGroup
        "Golden: LockableFeaturePatch_team 18"
        $ testObjects
          [(Test.Wire.API.Golden.Generated.LockableFeaturePatch_team.testObject_LockableFeaturePatch_team_18, "testObject_LockableFeaturePatch_team_18.json")],
      testGroup
        "Golden: LockableFeaturePatch_team 19"
        $ testObjects
          [(Test.Wire.API.Golden.Generated.LockableFeaturePatch_team.testObject_LockableFeaturePatch_team_19, "testObject_LockableFeaturePatch_team_19.json")],
      testGroup
        "Golden: Event_FeatureConfig"
        $ testObjects
          [ (Test.Wire.API.Golden.Generated.Event_featureConfig.testObject_Event_featureConfig_1, "testObject_Event_featureConfig_1.json"),
            (Test.Wire.API.Golden.Generated.Event_featureConfig.testObject_Event_featureConfig_2, "testObject_Event_featureConfig_2.json"),
            (Test.Wire.API.Golden.Generated.Event_featureConfig.testObject_Event_featureConfig_3, "testObject_Event_featureConfig_3.json"),
            (Test.Wire.API.Golden.Generated.Event_featureConfig.testObject_Event_featureConfig_4, "testObject_Event_featureConfig_4.json"),
            (Test.Wire.API.Golden.Generated.Event_featureConfig.testObject_Event_featureConfig_5, "testObject_Event_featureConfig_5.json"),
            (Test.Wire.API.Golden.Generated.Event_featureConfig.testObject_Event_featureConfig_6, "testObject_Event_featureConfig_6.json"),
            (Test.Wire.API.Golden.Generated.Event_featureConfig.testObject_Event_featureConfig_7, "testObject_Event_featureConfig_7.json"),
            (Test.Wire.API.Golden.Generated.Event_featureConfig.testObject_Event_featureConfig_8, "testObject_Event_featureConfig_8.json"),
            (Test.Wire.API.Golden.Generated.Event_featureConfig.testObject_Event_featureConfig_9, "testObject_Event_featureConfig_9.json"),
            (Test.Wire.API.Golden.Generated.Event_featureConfig.testObject_Event_featureConfig_10, "testObject_Event_featureConfig_10.json")
          ],
      testGroup
        "Golden: Event_Conversation"
        $ testObjects
          [ (Test.Wire.API.Golden.Generated.Event_conversation.testObject_Event_conversation_1, "testObject_Event_conversation_1.json"),
            (Test.Wire.API.Golden.Generated.Event_conversation.testObject_Event_conversation_2, "testObject_Event_conversation_2.json"),
            (Test.Wire.API.Golden.Generated.Event_conversation.testObject_Event_conversation_3, "testObject_Event_conversation_3.json"),
            (Test.Wire.API.Golden.Generated.Event_conversation.testObject_Event_conversation_4, "testObject_Event_conversation_4.json"),
            (Test.Wire.API.Golden.Generated.Event_conversation.testObject_Event_conversation_5, "testObject_Event_conversation_5.json"),
            (Test.Wire.API.Golden.Generated.Event_conversation.testObject_Event_conversation_6, "testObject_Event_conversation_6.json"),
            (Test.Wire.API.Golden.Generated.Event_conversation.testObject_Event_conversation_7, "testObject_Event_conversation_7.json"),
            (Test.Wire.API.Golden.Generated.Event_conversation.testObject_Event_conversation_8, "testObject_Event_conversation_8.json"),
            (Test.Wire.API.Golden.Generated.Event_conversation.testObject_Event_conversation_9, "testObject_Event_conversation_9.json"),
            (Test.Wire.API.Golden.Generated.Event_conversation.testObject_Event_conversation_11, "testObject_Event_conversation_11.json"),
            (Test.Wire.API.Golden.Generated.Event_conversation.testObject_Event_conversation_10, "testObject_Event_conversation_10.json")
          ],
      testGroup "Golden: QualifiedUserClientPrekeyMapV4" $
        testObjects
          [ (Test.Wire.API.Golden.Generated.QualifiedUserClientPrekeyMapV4_user.testObject_QualifiedUserClientPrekeyMapV4_user_1, "testObject_QualifiedUserClientPrekeyMapV4_1.json"),
            (Test.Wire.API.Golden.Generated.QualifiedUserClientPrekeyMapV4_user.testObject_QualifiedUserClientPrekeyMapV4_user_2, "testObject_QualifiedUserClientPrekeyMapV4_2.json"),
            (Test.Wire.API.Golden.Generated.QualifiedUserClientPrekeyMapV4_user.testObject_QualifiedUserClientPrekeyMapV4_user_3, "testObject_QualifiedUserClientPrekeyMapV4_3.json")
          ]
    ]
