{-# LANGUAGE OverloadedStrings #-}

-- | haskell representations of the sample data in /test/xml/.
module Samples where

import Crypto.PubKey.RSA as RSA
import SAML2.WebSSO
import URI.ByteString.QQ

-- source: https://docs.microsoft.com/en-us/azure/active-directory/develop/active-directory-single-sign-on-protocol-reference
microsoftAuthnRequest1 :: AuthnRequest
microsoftAuthnRequest1 = AuthnRequest {_rqID = ID {fromID = "id6c1c178c166d486687be4aaf5e482730"}, _rqIssueInstant = unsafeReadTime "2013-03-18T03:28:54.1839884Z", _rqIssuer = Issuer [uri|https://www.contoso.com|], _rqNameIDPolicy = Nothing}

microsoftIdpKeyinfo :: RSA.PublicKey
microsoftIdpKeyinfo = RSA.PublicKey {RSA.public_size = 256, RSA.public_n = 25266449847616032605280887180445946447207827183577848474184616846136744459013940059297388901949168945284876940449831022307515873851064478442088422354857937225651881330471758496854838771727042040743247357142715828206862944363464254559789249948813601166263148331870847174783313061359856986236119735646527697584352746595070831856826144035963401689203402892945174546914103842786133972997748592644348449313622309013132898328267351769300154913558618070904948090075390540412224001257219178211139174816497946208851160331679253663348572295658494523941468674192526945936020222447823781738913444250167710107767554511823728989391, RSA.public_e = 65537}
