-- This file is part of the Wire Server implementation.
--
-- Copyright (C) 2025 Wire Swiss GmbH <opensource@wire.com>
--
-- This program is free software: you can redistribute it and/or modify it under
-- the terms of the GNU Affero General Public License as published by the Free
-- Software Foundation, either version 3 of the License, or (at your option) any
-- later version.
--
-- This program is distributed in the hope that it will be useful, but WITHOUT
-- ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
-- FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
-- details.
--
-- You should have received a copy of the GNU Affero General Public License along
-- with this program. If not, see <https://www.gnu.org/licenses/>.

module Wire.Sem.Concurrency.Sequential where

import Imports
import Polysemy
import Wire.Sem.Concurrency

------------------------------------------------------------------------------

-- | Safely perform "concurrency" by doing it sequentially.
sequentiallyPerformConcurrency :: Sem (Concurrency safe ': r) a -> Sem r a
sequentiallyPerformConcurrency = interpretH $ \case
  UnsafePooledMapConcurrentlyN _ f t -> do
    st <- getInitialStateT
    ftraverse <- bindT $ traverse @[] f
    raise $ sequentiallyPerformConcurrency $ ftraverse $ toList t <$ st
  UnsafePooledMapConcurrentlyN_ _ f (t :: t x) -> do
    st <- getInitialStateT
    ftraverse_ <- bindT $ traverse_ @t f
    raise $ sequentiallyPerformConcurrency $ ftraverse_ $ t <$ st
