# This file was @generated by crate2nix 0.11.0 with the command:
#   "generate"
# See https://github.com/kolloch/crate2nix for more info.

{ nixpkgs ? <nixpkgs>
, pkgs ? import nixpkgs { config = { }; }
, lib ? pkgs.lib
, stdenv ? pkgs.stdenv
, buildRustCrateForPkgs ? pkgs: pkgs.buildRustCrate
  # This is used as the `crateOverrides` argument for `buildRustCrate`.
, defaultCrateOverrides ? pkgs.defaultCrateOverrides
  # The features to enable for the root_crate or the workspace_members.
, rootFeatures ? [ "default" ]
  # If true, throw errors instead of issueing deprecation warnings.
, strictDeprecation ? false
  # Used for conditional compilation based on CPU feature detection.
, targetFeatures ? [ ]
  # Whether to perform release builds: longer compile times, faster binaries.
, release ? true
  # Additional crate2nix configuration if it exists.
, crateConfig ? if builtins.pathExists ./crate-config.nix
  then pkgs.callPackage ./crate-config.nix { }
  else { }
}:

rec {
  #
  # "public" attributes that we attempt to keep stable with new versions of crate2nix.
  #

  rootCrate = rec {
    packageId = "zauth-c";

    # Use this attribute to refer to the derivation building your root crate package.
    # You can override the features with rootCrate.build.override { features = [ "default" "feature1" ... ]; }.
    build = internal.buildRustCrateWithFeatures {
      inherit packageId;
    };

    # Debug support which might change between releases.
    # File a bug if you depend on any for non-debug work!
    debug = internal.debugCrate { inherit packageId; };
  };
  # Refer your crate build derivation by name here.
  # You can override the features with
  # workspaceMembers."${crateName}".build.override { features = [ "default" "feature1" ... ]; }.
  workspaceMembers = {
    "zauth-c" = rec {
      packageId = "zauth-c";
      build = internal.buildRustCrateWithFeatures {
        packageId = "zauth-c";
      };

      # Debug support which might change between releases.
      # File a bug if you depend on any for non-debug work!
      debug = internal.debugCrate { inherit packageId; };
    };
  };

  # A derivation that joins the outputs of all workspace members together.
  allWorkspaceMembers = pkgs.symlinkJoin {
    name = "all-workspace-members";
    paths =
      let members = builtins.attrValues workspaceMembers;
      in builtins.map (m: m.build) members;
  };

  #
  # "internal" ("private") attributes that may change in every new version of crate2nix.
  #

  internal = rec {
    # Build and dependency information for crates.
    # Many of the fields are passed one-to-one to buildRustCrate.
    #
    # Noteworthy:
    # * `dependencies`/`buildDependencies`: similar to the corresponding fields for buildRustCrate.
    #   but with additional information which is used during dependency/feature resolution.
    # * `resolvedDependencies`: the selected default features reported by cargo - only included for debugging.
    # * `devDependencies` as of now not used by `buildRustCrate` but used to
    #   inject test dependencies into the build

    crates = {
      "aho-corasick" = rec {
        crateName = "aho-corasick";
        version = "1.1.3";
        edition = "2021";
        sha256 = "05mrpkvdgp5d20y2p989f187ry9diliijgwrs254fs9s1m1x6q4f";
        libName = "aho_corasick";
        authors = [
          "Andrew Gallant <jamslam@gmail.com>"
        ];
        dependencies = [
          {
            name = "memchr";
            packageId = "memchr";
            optional = true;
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "default" = [ "std" "perf-literal" ];
          "logging" = [ "dep:log" ];
          "perf-literal" = [ "dep:memchr" ];
          "std" = [ "memchr?/std" ];
        };
        resolvedDefaultFeatures = [ "perf-literal" "std" ];
      };
      "anyhow" = rec {
        crateName = "anyhow";
        version = "1.0.86";
        edition = "2018";
        sha256 = "1nk301x8qhpdaks6a9zvcp7yakjqnczjmqndbg7vk4494d3d1ldk";
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];
        features = {
          "backtrace" = [ "dep:backtrace" ];
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "asexp" = rec {
        crateName = "asexp";
        version = "0.3.2";
        edition = "2018";
        sha256 = "0li6h191ppfyrsv6iwppbaxsmcbpc3sb2b8wgwq4g2bmrrhqfdjy";
        authors = [
          "Michael Neumann <mneumann@ntecs.de>"
        ];

      };
      "autocfg" = rec {
        crateName = "autocfg";
        version = "1.3.0";
        edition = "2015";
        sha256 = "1c3njkfzpil03k92q0mij5y1pkhhfr4j3bf0h53bgl2vs85lsjqc";
        authors = [
          "Josh Stone <cuviper@gmail.com>"
        ];

      };
      "base16ct 0.1.1" = rec {
        crateName = "base16ct";
        version = "0.1.1";
        edition = "2021";
        sha256 = "1klccxr7igf73wpi0x3asjd8n0xjg0v6a7vxgvfk5ybvgh1hd6il";
        authors = [
          "RustCrypto Developers"
        ];
        features = {
          "std" = [ "alloc" ];
        };
        resolvedDefaultFeatures = [ "alloc" ];
      };
      "base16ct 0.2.0" = rec {
        crateName = "base16ct";
        version = "0.2.0";
        edition = "2021";
        sha256 = "1kylrjhdzk7qpknrvlphw8ywdnvvg39dizw9622w3wk5xba04zsc";
        authors = [
          "RustCrypto Developers"
        ];
        features = {
          "std" = [ "alloc" ];
        };
        resolvedDefaultFeatures = [ "alloc" ];
      };
      "base64" = rec {
        crateName = "base64";
        version = "0.21.7";
        edition = "2018";
        sha256 = "0rw52yvsk75kar9wgqfwgb414kvil1gn7mqkrhn9zf1537mpsacx";
        authors = [
          "Alice Maz <alice@alicemaz.com>"
          "Marshall Pierce <marshall@mpierce.org>"
        ];
        features = {
          "default" = [ "std" ];
          "std" = [ "alloc" ];
        };
        resolvedDefaultFeatures = [ "alloc" "default" "std" ];
      };
      "base64ct" = rec {
        crateName = "base64ct";
        version = "1.6.0";
        edition = "2021";
        sha256 = "0nvdba4jb8aikv60az40x2w1y96sjdq8z3yp09rwzmkhiwv1lg4c";
        authors = [
          "RustCrypto Developers"
        ];
        features = {
          "std" = [ "alloc" ];
        };
        resolvedDefaultFeatures = [ "alloc" ];
      };
      "binstring" = rec {
        crateName = "binstring";
        version = "0.1.1";
        edition = "2021";
        sha256 = "11bsghizyz2xwxmqvsj7hlxs6qp180kl2vr0n4n7484k7nbn03by";
        authors = [
          "Frank Denis <github@pureftpd.org>"
        ];

      };
      "block-buffer" = rec {
        crateName = "block-buffer";
        version = "0.10.4";
        edition = "2018";
        sha256 = "0w9sa2ypmrsqqvc20nhwr75wbb5cjr4kkyhpjm1z1lv2kdicfy1h";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "generic-array";
            packageId = "generic-array";
          }
        ];

      };
      "bumpalo" = rec {
        crateName = "bumpalo";
        version = "3.16.0";
        edition = "2021";
        sha256 = "0b015qb4knwanbdlp1x48pkb4pm57b8gidbhhhxr900q2wb6fabr";
        authors = [
          "Nick Fitzgerald <fitzgen@gmail.com>"
        ];
        features = {
          "allocator-api2" = [ "dep:allocator-api2" ];
          "serde" = [ "dep:serde" ];
        };
        resolvedDefaultFeatures = [ "default" ];
      };
      "byteorder" = rec {
        crateName = "byteorder";
        version = "1.5.0";
        edition = "2021";
        sha256 = "0jzncxyf404mwqdbspihyzpkndfgda450l0893pz5xj685cg5l0z";
        authors = [
          "Andrew Gallant <jamslam@gmail.com>"
        ];
        features = {
          "default" = [ "std" ];
        };
      };
      "cc" = rec {
        crateName = "cc";
        version = "1.0.98";
        edition = "2018";
        sha256 = "0gzhij74hblfkzwwyysdc8crfd6fr0m226vzmijmwwhdakkp1hj1";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        features = {
          "jobserver" = [ "dep:jobserver" ];
          "libc" = [ "dep:libc" ];
          "once_cell" = [ "dep:once_cell" ];
          "parallel" = [ "libc" "jobserver" "once_cell" ];
        };
      };
      "cfg-if" = rec {
        crateName = "cfg-if";
        version = "1.0.0";
        edition = "2018";
        sha256 = "1za0vb97n4brpzpv8lsbnzmq5r8f2b0cpqqr0sy8h5bn751xxwds";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        features = {
          "compiler_builtins" = [ "dep:compiler_builtins" ];
          "core" = [ "dep:core" ];
          "rustc-dep-of-std" = [ "core" "compiler_builtins" ];
        };
      };
      "coarsetime" = rec {
        crateName = "coarsetime";
        version = "0.1.34";
        edition = "2018";
        sha256 = "0pby1xsrzcxj0yq911hzr38bchgm80iwyg5y2h0rddqvy2f87cqk";
        authors = [
          "Frank Denis <github@pureftpd.org>"
        ];
        dependencies = [
          {
            name = "libc";
            packageId = "libc";
            target = { target, features }: (!(("wasix" == target."os") || ("wasi" == target."os")));
          }
          {
            name = "wasix";
            packageId = "wasix";
            target = { target, features }: (("wasix" == target."os") || ("wasi" == target."os"));
          }
          {
            name = "wasm-bindgen";
            packageId = "wasm-bindgen";
            target = { target, features }: ((("wasm32" == target."arch") || ("wasm64" == target."arch")) && ("unknown" == target."os"));
          }
        ];
        features = {
          "wasi-abi2" = [ "dep:wasi-abi2" ];
        };
      };
      "const-oid" = rec {
        crateName = "const-oid";
        version = "0.9.6";
        edition = "2021";
        sha256 = "1y0jnqaq7p2wvspnx7qj76m7hjcqpz73qzvr9l2p9n2s51vr6if2";
        authors = [
          "RustCrypto Developers"
        ];
        features = {
          "arbitrary" = [ "dep:arbitrary" ];
        };
      };
      "cpufeatures" = rec {
        crateName = "cpufeatures";
        version = "0.2.12";
        edition = "2018";
        sha256 = "012m7rrak4girqlii3jnqwrr73gv1i980q4wra5yyyhvzwk5xzjk";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "libc";
            packageId = "libc";
            target = { target, features }: (pkgs.rust.lib.toRustTarget stdenv.hostPlatform == "aarch64-linux-android");
          }
          {
            name = "libc";
            packageId = "libc";
            target = { target, features }: (("aarch64" == target."arch") && ("linux" == target."os"));
          }
          {
            name = "libc";
            packageId = "libc";
            target = { target, features }: (("aarch64" == target."arch") && ("apple" == target."vendor"));
          }
          {
            name = "libc";
            packageId = "libc";
            target = { target, features }: (("loongarch64" == target."arch") && ("linux" == target."os"));
          }
        ];

      };
      "crypto-bigint 0.4.9" = rec {
        crateName = "crypto-bigint";
        version = "0.4.9";
        edition = "2021";
        sha256 = "1vqprgj0aj1340w186zyspi58397ih78jsc0iydvhs6zrlilnazg";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "generic-array";
            packageId = "generic-array";
            optional = true;
          }
          {
            name = "rand_core";
            packageId = "rand_core";
            optional = true;
          }
          {
            name = "subtle";
            packageId = "subtle";
            usesDefaultFeatures = false;
          }
          {
            name = "zeroize";
            packageId = "zeroize";
            optional = true;
            usesDefaultFeatures = false;
          }
        ];
        devDependencies = [
          {
            name = "rand_core";
            packageId = "rand_core";
            features = [ "std" ];
          }
        ];
        features = {
          "default" = [ "rand" ];
          "der" = [ "dep:der" ];
          "generic-array" = [ "dep:generic-array" ];
          "rand" = [ "rand_core/std" ];
          "rand_core" = [ "dep:rand_core" ];
          "rlp" = [ "dep:rlp" ];
          "serde" = [ "serdect" ];
          "serdect" = [ "dep:serdect" ];
          "zeroize" = [ "dep:zeroize" ];
        };
        resolvedDefaultFeatures = [ "generic-array" "rand_core" "zeroize" ];
      };
      "crypto-bigint 0.5.5" = rec {
        crateName = "crypto-bigint";
        version = "0.5.5";
        edition = "2021";
        sha256 = "0xmbdff3g6ii5sbxjxc31xfkv9lrmyril4arh3dzckd4gjsjzj8d";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "generic-array";
            packageId = "generic-array";
            optional = true;
          }
          {
            name = "rand_core";
            packageId = "rand_core";
            optional = true;
          }
          {
            name = "subtle";
            packageId = "subtle";
            usesDefaultFeatures = false;
          }
          {
            name = "zeroize";
            packageId = "zeroize";
            optional = true;
            usesDefaultFeatures = false;
          }
        ];
        devDependencies = [
          {
            name = "rand_core";
            packageId = "rand_core";
            features = [ "std" ];
          }
        ];
        features = {
          "alloc" = [ "serdect?/alloc" ];
          "default" = [ "rand" ];
          "der" = [ "dep:der" ];
          "generic-array" = [ "dep:generic-array" ];
          "rand" = [ "rand_core/std" ];
          "rand_core" = [ "dep:rand_core" ];
          "rlp" = [ "dep:rlp" ];
          "serde" = [ "dep:serdect" ];
          "zeroize" = [ "dep:zeroize" ];
        };
        resolvedDefaultFeatures = [ "generic-array" "rand_core" "zeroize" ];
      };
      "crypto-common" = rec {
        crateName = "crypto-common";
        version = "0.1.6";
        edition = "2018";
        sha256 = "1cvby95a6xg7kxdz5ln3rl9xh66nz66w46mm3g56ri1z5x815yqv";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "generic-array";
            packageId = "generic-array";
            features = [ "more_lengths" ];
          }
          {
            name = "typenum";
            packageId = "typenum";
          }
        ];
        features = {
          "getrandom" = [ "rand_core/getrandom" ];
          "rand_core" = [ "dep:rand_core" ];
        };
        resolvedDefaultFeatures = [ "std" ];
      };
      "ct-codecs" = rec {
        crateName = "ct-codecs";
        version = "1.1.1";
        edition = "2018";
        sha256 = "1pvmrkk95jadmhhd5mn88mq2dfnq0yng8mk3pfd5l6dq0i2fpdzk";
        authors = [
          "Frank Denis <github@pureftpd.org>"
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "der 0.6.1" = rec {
        crateName = "der";
        version = "0.6.1";
        edition = "2021";
        sha256 = "1pnl3y52m1s6srxpfrfbazf6qilzq8fgksk5dv79nxaybjk6g97i";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "const-oid";
            packageId = "const-oid";
            optional = true;
          }
          {
            name = "pem-rfc7468";
            packageId = "pem-rfc7468 0.6.0";
            optional = true;
          }
          {
            name = "zeroize";
            packageId = "zeroize";
            optional = true;
            usesDefaultFeatures = false;
            features = [ "alloc" ];
          }
        ];
        features = {
          "const-oid" = [ "dep:const-oid" ];
          "der_derive" = [ "dep:der_derive" ];
          "derive" = [ "der_derive" ];
          "flagset" = [ "dep:flagset" ];
          "oid" = [ "const-oid" ];
          "pem" = [ "alloc" "pem-rfc7468/alloc" "zeroize" ];
          "pem-rfc7468" = [ "dep:pem-rfc7468" ];
          "std" = [ "alloc" ];
          "time" = [ "dep:time" ];
          "zeroize" = [ "dep:zeroize" ];
        };
        resolvedDefaultFeatures = [ "alloc" "const-oid" "oid" "pem" "pem-rfc7468" "std" "zeroize" ];
      };
      "der 0.7.9" = rec {
        crateName = "der";
        version = "0.7.9";
        edition = "2021";
        sha256 = "1h4vzjfa1lczxdf8avfj9qlwh1qianqlxdy1g5rn762qnvkzhnzm";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "const-oid";
            packageId = "const-oid";
            optional = true;
          }
          {
            name = "pem-rfc7468";
            packageId = "pem-rfc7468 0.7.0";
            optional = true;
            features = [ "alloc" ];
          }
          {
            name = "zeroize";
            packageId = "zeroize";
            optional = true;
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "alloc" = [ "zeroize?/alloc" ];
          "arbitrary" = [ "dep:arbitrary" "const-oid?/arbitrary" "std" ];
          "bytes" = [ "dep:bytes" "alloc" ];
          "derive" = [ "dep:der_derive" ];
          "flagset" = [ "dep:flagset" ];
          "oid" = [ "dep:const-oid" ];
          "pem" = [ "dep:pem-rfc7468" "alloc" "zeroize" ];
          "std" = [ "alloc" ];
          "time" = [ "dep:time" ];
          "zeroize" = [ "dep:zeroize" ];
        };
        resolvedDefaultFeatures = [ "alloc" "oid" "pem" "std" "zeroize" ];
      };
      "digest" = rec {
        crateName = "digest";
        version = "0.10.7";
        edition = "2018";
        sha256 = "14p2n6ih29x81akj097lvz7wi9b6b9hvls0lwrv7b6xwyy0s5ncy";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "block-buffer";
            packageId = "block-buffer";
            optional = true;
          }
          {
            name = "const-oid";
            packageId = "const-oid";
            optional = true;
          }
          {
            name = "crypto-common";
            packageId = "crypto-common";
          }
          {
            name = "subtle";
            packageId = "subtle";
            optional = true;
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "blobby" = [ "dep:blobby" ];
          "block-buffer" = [ "dep:block-buffer" ];
          "const-oid" = [ "dep:const-oid" ];
          "core-api" = [ "block-buffer" ];
          "default" = [ "core-api" ];
          "dev" = [ "blobby" ];
          "mac" = [ "subtle" ];
          "oid" = [ "const-oid" ];
          "rand_core" = [ "crypto-common/rand_core" ];
          "std" = [ "alloc" "crypto-common/std" ];
          "subtle" = [ "dep:subtle" ];
        };
        resolvedDefaultFeatures = [ "alloc" "block-buffer" "const-oid" "core-api" "default" "mac" "oid" "std" "subtle" ];
      };
      "ecdsa 0.15.1" = rec {
        crateName = "ecdsa";
        version = "0.15.1";
        edition = "2021";
        sha256 = "0zk3nz2qlczayd8w7zp3nh1skxh5nvrk1l16m62l3msab50l310j";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "der";
            packageId = "der 0.6.1";
            optional = true;
          }
          {
            name = "elliptic-curve";
            packageId = "elliptic-curve 0.12.3";
            usesDefaultFeatures = false;
            features = [ "digest" "sec1" ];
          }
          {
            name = "rfc6979";
            packageId = "rfc6979 0.3.1";
            optional = true;
          }
          {
            name = "signature";
            packageId = "signature 2.0.0";
            usesDefaultFeatures = false;
            features = [ "rand_core" ];
          }
        ];
        devDependencies = [
          {
            name = "elliptic-curve";
            packageId = "elliptic-curve 0.12.3";
            usesDefaultFeatures = false;
            features = [ "dev" ];
          }
        ];
        features = {
          "alloc" = [ "signature/alloc" ];
          "arithmetic" = [ "elliptic-curve/arithmetic" ];
          "default" = [ "digest" ];
          "der" = [ "dep:der" ];
          "dev" = [ "arithmetic" "digest" "elliptic-curve/dev" "hazmat" ];
          "digest" = [ "signature/digest" ];
          "pem" = [ "elliptic-curve/pem" "pkcs8" ];
          "pkcs8" = [ "elliptic-curve/pkcs8" "der" ];
          "rfc6979" = [ "dep:rfc6979" ];
          "serde" = [ "elliptic-curve/serde" "serdect" ];
          "serdect" = [ "dep:serdect" ];
          "signing" = [ "arithmetic" "digest" "hazmat" "rfc6979" ];
          "std" = [ "alloc" "elliptic-curve/std" "signature/std" ];
          "verifying" = [ "arithmetic" "digest" "hazmat" ];
        };
        resolvedDefaultFeatures = [ "alloc" "arithmetic" "der" "digest" "hazmat" "pem" "pkcs8" "rfc6979" "signing" "std" "verifying" ];
      };
      "ecdsa 0.16.9" = rec {
        crateName = "ecdsa";
        version = "0.16.9";
        edition = "2021";
        sha256 = "1jhb0bcbkaz4001sdmfyv8ajrv8a1cg7z7aa5myrd4jjbhmz69zf";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "der";
            packageId = "der 0.7.9";
            optional = true;
          }
          {
            name = "digest";
            packageId = "digest";
            optional = true;
            usesDefaultFeatures = false;
            features = [ "oid" ];
          }
          {
            name = "elliptic-curve";
            packageId = "elliptic-curve 0.13.8";
            usesDefaultFeatures = false;
            features = [ "digest" "sec1" ];
          }
          {
            name = "rfc6979";
            packageId = "rfc6979 0.4.0";
            optional = true;
          }
          {
            name = "signature";
            packageId = "signature 2.0.0";
            usesDefaultFeatures = false;
            features = [ "rand_core" ];
          }
          {
            name = "spki";
            packageId = "spki 0.7.3";
            optional = true;
            usesDefaultFeatures = false;
          }
        ];
        devDependencies = [
          {
            name = "elliptic-curve";
            packageId = "elliptic-curve 0.13.8";
            usesDefaultFeatures = false;
            features = [ "dev" ];
          }
        ];
        features = {
          "alloc" = [ "elliptic-curve/alloc" "signature/alloc" "spki/alloc" ];
          "arithmetic" = [ "elliptic-curve/arithmetic" ];
          "default" = [ "digest" ];
          "der" = [ "dep:der" ];
          "dev" = [ "arithmetic" "digest" "elliptic-curve/dev" "hazmat" ];
          "digest" = [ "dep:digest" "signature/digest" ];
          "pem" = [ "elliptic-curve/pem" "pkcs8" ];
          "pkcs8" = [ "digest" "elliptic-curve/pkcs8" "der" ];
          "rfc6979" = [ "dep:rfc6979" ];
          "serde" = [ "elliptic-curve/serde" "serdect" ];
          "serdect" = [ "dep:serdect" ];
          "sha2" = [ "dep:sha2" ];
          "signing" = [ "arithmetic" "digest" "hazmat" "rfc6979" ];
          "spki" = [ "dep:spki" ];
          "std" = [ "alloc" "elliptic-curve/std" "signature/std" ];
          "verifying" = [ "arithmetic" "digest" "hazmat" ];
        };
        resolvedDefaultFeatures = [ "alloc" "arithmetic" "der" "digest" "hazmat" "pem" "pkcs8" "rfc6979" "signing" "spki" "std" "verifying" ];
      };
      "ed25519" = rec {
        crateName = "ed25519";
        version = "1.5.3";
        edition = "2021";
        sha256 = "1rzydm5wd8szkddx3g55w4vm86y1ika8qp8qwckada5vf1fg7kwi";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "signature";
            packageId = "signature 1.6.4";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "alloc" = [ "pkcs8/alloc" ];
          "default" = [ "std" ];
          "pem" = [ "pkcs8/pem" ];
          "pkcs8" = [ "dep:pkcs8" ];
          "serde" = [ "dep:serde" ];
          "serde_bytes" = [ "serde" "serde_bytes_crate" "std" ];
          "serde_bytes_crate" = [ "dep:serde_bytes_crate" ];
          "std" = [ "signature/std" ];
          "zeroize" = [ "dep:zeroize" ];
        };
      };
      "ed25519-compact" = rec {
        crateName = "ed25519-compact";
        version = "2.1.1";
        edition = "2018";
        sha256 = "1431kxw67xkk5y5kamfdjxnqbzqy5y4p032syi3wva5y8h7ldcz9";
        authors = [
          "Frank Denis <github@pureftpd.org>"
        ];
        dependencies = [
          {
            name = "ct-codecs";
            packageId = "ct-codecs";
            optional = true;
          }
          {
            name = "getrandom";
            packageId = "getrandom";
            optional = true;
            target = { target, features }: ((("wasm32" == target."arch") || ("wasm64" == target."arch")) && ("unknown" == target."os"));
            features = [ "js" ];
          }
          {
            name = "getrandom";
            packageId = "getrandom";
            optional = true;
            target = { target, features }: (!((("wasm32" == target."arch") || ("wasm64" == target."arch")) && ("unknown" == target."os")));
          }
        ];
        devDependencies = [
          {
            name = "ct-codecs";
            packageId = "ct-codecs";
          }
          {
            name = "getrandom";
            packageId = "getrandom";
            target = { target, features }: ((("wasm32" == target."arch") || ("wasm64" == target."arch")) && ("unknown" == target."os"));
            features = [ "js" ];
          }
          {
            name = "getrandom";
            packageId = "getrandom";
            target = { target, features }: (!((("wasm32" == target."arch") || ("wasm64" == target."arch")) && ("unknown" == target."os")));
          }
        ];
        features = {
          "ct-codecs" = [ "dep:ct-codecs" ];
          "default" = [ "random" "std" "x25519" "pem" ];
          "ed25519" = [ "dep:ed25519" ];
          "getrandom" = [ "dep:getrandom" ];
          "pem" = [ "ct-codecs" ];
          "random" = [ "getrandom" ];
          "traits" = [ "ed25519" ];
        };
        resolvedDefaultFeatures = [ "ct-codecs" "default" "getrandom" "pem" "random" "std" "x25519" ];
      };
      "elliptic-curve 0.12.3" = rec {
        crateName = "elliptic-curve";
        version = "0.12.3";
        edition = "2021";
        sha256 = "1lwi108mh6drw5nzqzlz7ighdba5qxdg5vmwwnw1j2ihnn58ifz7";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "base16ct";
            packageId = "base16ct 0.1.1";
          }
          {
            name = "crypto-bigint";
            packageId = "crypto-bigint 0.4.9";
            usesDefaultFeatures = false;
            features = [ "rand_core" "generic-array" "zeroize" ];
          }
          {
            name = "der";
            packageId = "der 0.6.1";
            usesDefaultFeatures = false;
            features = [ "oid" ];
          }
          {
            name = "digest";
            packageId = "digest";
            optional = true;
          }
          {
            name = "ff";
            packageId = "ff 0.12.1";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "generic-array";
            packageId = "generic-array";
            usesDefaultFeatures = false;
          }
          {
            name = "group";
            packageId = "group 0.12.1";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "hkdf";
            packageId = "hkdf";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "pem-rfc7468";
            packageId = "pem-rfc7468 0.6.0";
            optional = true;
          }
          {
            name = "pkcs8";
            packageId = "pkcs8 0.9.0";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "rand_core";
            packageId = "rand_core";
            usesDefaultFeatures = false;
          }
          {
            name = "sec1";
            packageId = "sec1 0.3.0";
            optional = true;
            features = [ "subtle" "zeroize" ];
          }
          {
            name = "subtle";
            packageId = "subtle";
            usesDefaultFeatures = false;
          }
          {
            name = "zeroize";
            packageId = "zeroize";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "alloc" = [ "base16ct/alloc" "der/alloc" "sec1/alloc" "zeroize/alloc" ];
          "arithmetic" = [ "ff" "group" ];
          "base64ct" = [ "dep:base64ct" ];
          "bits" = [ "arithmetic" "ff/bits" ];
          "default" = [ "arithmetic" ];
          "dev" = [ "arithmetic" "hex-literal" "pem" "pkcs8" ];
          "digest" = [ "dep:digest" ];
          "ecdh" = [ "arithmetic" "digest" "hkdf" ];
          "ff" = [ "dep:ff" ];
          "group" = [ "dep:group" ];
          "hash2curve" = [ "arithmetic" "digest" ];
          "hex-literal" = [ "dep:hex-literal" ];
          "hkdf" = [ "dep:hkdf" ];
          "jwk" = [ "alloc" "base64ct/alloc" "serde" "serde_json" "zeroize/alloc" ];
          "pem" = [ "alloc" "arithmetic" "der/pem" "pem-rfc7468/alloc" "pkcs8" "sec1/pem" ];
          "pem-rfc7468" = [ "dep:pem-rfc7468" ];
          "pkcs8" = [ "dep:pkcs8" ];
          "sec1" = [ "dep:sec1" ];
          "serde" = [ "alloc" "pkcs8" "sec1/serde" "serdect" ];
          "serde_json" = [ "dep:serde_json" ];
          "serdect" = [ "dep:serdect" ];
          "std" = [ "alloc" "rand_core/std" ];
          "voprf" = [ "digest" ];
        };
        resolvedDefaultFeatures = [ "alloc" "arithmetic" "digest" "ecdh" "ff" "group" "hazmat" "hkdf" "pem" "pem-rfc7468" "pkcs8" "sec1" "std" ];
      };
      "elliptic-curve 0.13.8" = rec {
        crateName = "elliptic-curve";
        version = "0.13.8";
        edition = "2021";
        sha256 = "0ixx4brgnzi61z29r3g1606nh2za88hzyz8c5r3p6ydzhqq09rmm";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "base16ct";
            packageId = "base16ct 0.2.0";
          }
          {
            name = "crypto-bigint";
            packageId = "crypto-bigint 0.5.5";
            usesDefaultFeatures = false;
            features = [ "rand_core" "generic-array" "zeroize" ];
          }
          {
            name = "digest";
            packageId = "digest";
            optional = true;
          }
          {
            name = "ff";
            packageId = "ff 0.13.0";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "generic-array";
            packageId = "generic-array";
            usesDefaultFeatures = false;
            features = [ "zeroize" ];
          }
          {
            name = "group";
            packageId = "group 0.13.0";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "hkdf";
            packageId = "hkdf";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "pem-rfc7468";
            packageId = "pem-rfc7468 0.7.0";
            optional = true;
            features = [ "alloc" ];
          }
          {
            name = "pkcs8";
            packageId = "pkcs8 0.10.2";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "rand_core";
            packageId = "rand_core";
            usesDefaultFeatures = false;
          }
          {
            name = "sec1";
            packageId = "sec1 0.7.3";
            optional = true;
            features = [ "subtle" "zeroize" ];
          }
          {
            name = "subtle";
            packageId = "subtle";
            usesDefaultFeatures = false;
          }
          {
            name = "zeroize";
            packageId = "zeroize";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "alloc" = [ "base16ct/alloc" "ff?/alloc" "group?/alloc" "pkcs8?/alloc" "sec1?/alloc" "zeroize/alloc" ];
          "arithmetic" = [ "group" ];
          "bits" = [ "arithmetic" "ff/bits" "dep:tap" ];
          "default" = [ "arithmetic" ];
          "dev" = [ "arithmetic" "dep:hex-literal" "pem" "pkcs8" ];
          "digest" = [ "dep:digest" ];
          "ecdh" = [ "arithmetic" "digest" "dep:hkdf" ];
          "ff" = [ "dep:ff" ];
          "group" = [ "dep:group" "ff" ];
          "hash2curve" = [ "arithmetic" "digest" ];
          "jwk" = [ "dep:base64ct" "dep:serde_json" "alloc" "serde" "zeroize/alloc" ];
          "pem" = [ "dep:pem-rfc7468" "alloc" "arithmetic" "pkcs8" "sec1/pem" ];
          "pkcs8" = [ "dep:pkcs8" "sec1" ];
          "sec1" = [ "dep:sec1" ];
          "serde" = [ "dep:serdect" "alloc" "pkcs8" "sec1/serde" ];
          "std" = [ "alloc" "rand_core/std" "pkcs8?/std" "sec1?/std" ];
          "voprf" = [ "digest" ];
        };
        resolvedDefaultFeatures = [ "alloc" "arithmetic" "digest" "ecdh" "ff" "group" "hazmat" "pem" "pkcs8" "sec1" "std" ];
      };
      "ff 0.12.1" = rec {
        crateName = "ff";
        version = "0.12.1";
        edition = "2021";
        sha256 = "0q3imz4m3dj2cy182i20wa8kbclgj13ddfngqb2miicc6cjzq4yh";
        authors = [
          "Sean Bowe <ewillbefull@gmail.com>"
          "Jack Grigg <thestr4d@gmail.com>"
        ];
        dependencies = [
          {
            name = "rand_core";
            packageId = "rand_core";
            usesDefaultFeatures = false;
          }
          {
            name = "subtle";
            packageId = "subtle";
            usesDefaultFeatures = false;
            features = [ "i128" ];
          }
        ];
        features = {
          "bits" = [ "bitvec" ];
          "bitvec" = [ "dep:bitvec" ];
          "byteorder" = [ "dep:byteorder" ];
          "default" = [ "bits" "std" ];
          "derive" = [ "byteorder" "ff_derive" ];
          "derive_bits" = [ "bits" "ff_derive/bits" ];
          "ff_derive" = [ "dep:ff_derive" ];
          "std" = [ "alloc" ];
        };
      };
      "ff 0.13.0" = rec {
        crateName = "ff";
        version = "0.13.0";
        edition = "2021";
        sha256 = "0jcl8yhcs5kbfxfpnrhpkkvnk7s666vly6sgawg3nri9nx215m6y";
        authors = [
          "Sean Bowe <ewillbefull@gmail.com>"
          "Jack Grigg <thestr4d@gmail.com>"
        ];
        dependencies = [
          {
            name = "rand_core";
            packageId = "rand_core";
            usesDefaultFeatures = false;
          }
          {
            name = "subtle";
            packageId = "subtle";
            usesDefaultFeatures = false;
            features = [ "i128" ];
          }
        ];
        features = {
          "bits" = [ "bitvec" ];
          "bitvec" = [ "dep:bitvec" ];
          "byteorder" = [ "dep:byteorder" ];
          "default" = [ "bits" "std" ];
          "derive" = [ "byteorder" "ff_derive" ];
          "derive_bits" = [ "bits" "ff_derive/bits" ];
          "ff_derive" = [ "dep:ff_derive" ];
          "std" = [ "alloc" ];
        };
        resolvedDefaultFeatures = [ "alloc" ];
      };
      "generic-array" = rec {
        crateName = "generic-array";
        version = "0.14.7";
        edition = "2015";
        sha256 = "16lyyrzrljfq424c3n8kfwkqihlimmsg5nhshbbp48np3yjrqr45";
        libName = "generic_array";
        authors = [
          "Bartłomiej Kamiński <fizyk20@gmail.com>"
          "Aaron Trent <novacrazy@gmail.com>"
        ];
        dependencies = [
          {
            name = "typenum";
            packageId = "typenum";
          }
          {
            name = "zeroize";
            packageId = "zeroize";
            optional = true;
            usesDefaultFeatures = false;
          }
        ];
        buildDependencies = [
          {
            name = "version_check";
            packageId = "version_check";
          }
        ];
        features = {
          "serde" = [ "dep:serde" ];
          "zeroize" = [ "dep:zeroize" ];
        };
        resolvedDefaultFeatures = [ "more_lengths" "zeroize" ];
      };
      "getrandom" = rec {
        crateName = "getrandom";
        version = "0.2.15";
        edition = "2018";
        sha256 = "1mzlnrb3dgyd1fb84gvw10pyr8wdqdl4ry4sr64i1s8an66pqmn4";
        authors = [
          "The Rand Project Developers"
        ];
        dependencies = [
          {
            name = "cfg-if";
            packageId = "cfg-if";
          }
          {
            name = "js-sys";
            packageId = "js-sys";
            optional = true;
            target = { target, features }: ((("wasm32" == target."arch") || ("wasm64" == target."arch")) && ("unknown" == target."os"));
          }
          {
            name = "libc";
            packageId = "libc";
            usesDefaultFeatures = false;
            target = { target, features }: (target."unix" or false);
          }
          {
            name = "wasi";
            packageId = "wasi";
            usesDefaultFeatures = false;
            target = { target, features }: ("wasi" == target."os");
          }
          {
            name = "wasm-bindgen";
            packageId = "wasm-bindgen";
            optional = true;
            usesDefaultFeatures = false;
            target = { target, features }: ((("wasm32" == target."arch") || ("wasm64" == target."arch")) && ("unknown" == target."os"));
          }
        ];
        features = {
          "compiler_builtins" = [ "dep:compiler_builtins" ];
          "core" = [ "dep:core" ];
          "js" = [ "wasm-bindgen" "js-sys" ];
          "js-sys" = [ "dep:js-sys" ];
          "rustc-dep-of-std" = [ "compiler_builtins" "core" "libc/rustc-dep-of-std" "wasi/rustc-dep-of-std" ];
          "wasm-bindgen" = [ "dep:wasm-bindgen" ];
        };
        resolvedDefaultFeatures = [ "js" "js-sys" "std" "wasm-bindgen" ];
      };
      "group 0.12.1" = rec {
        crateName = "group";
        version = "0.12.1";
        edition = "2021";
        sha256 = "1ixspxqdpq0hxg0hd9s6rngrp6rll21v4jjnr7ar1lzvdhxgpysx";
        authors = [
          "Sean Bowe <ewillbefull@gmail.com>"
          "Jack Grigg <jack@z.cash>"
        ];
        dependencies = [
          {
            name = "ff";
            packageId = "ff 0.12.1";
            usesDefaultFeatures = false;
          }
          {
            name = "rand_core";
            packageId = "rand_core";
            usesDefaultFeatures = false;
          }
          {
            name = "subtle";
            packageId = "subtle";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "default" = [ "alloc" ];
          "memuse" = [ "dep:memuse" ];
          "rand" = [ "dep:rand" ];
          "rand_xorshift" = [ "dep:rand_xorshift" ];
          "tests" = [ "alloc" "rand" "rand_xorshift" ];
          "wnaf-memuse" = [ "alloc" "memuse" ];
        };
      };
      "group 0.13.0" = rec {
        crateName = "group";
        version = "0.13.0";
        edition = "2021";
        sha256 = "0qqs2p5vqnv3zvq9mfjkmw3qlvgqb0c3cm6p33srkh7pc9sfzygh";
        authors = [
          "Sean Bowe <ewillbefull@gmail.com>"
          "Jack Grigg <jack@z.cash>"
        ];
        dependencies = [
          {
            name = "ff";
            packageId = "ff 0.13.0";
            usesDefaultFeatures = false;
          }
          {
            name = "rand_core";
            packageId = "rand_core";
            usesDefaultFeatures = false;
          }
          {
            name = "subtle";
            packageId = "subtle";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "default" = [ "alloc" ];
          "memuse" = [ "dep:memuse" ];
          "rand" = [ "dep:rand" ];
          "rand_xorshift" = [ "dep:rand_xorshift" ];
          "tests" = [ "alloc" "rand" "rand_xorshift" ];
          "wnaf-memuse" = [ "alloc" "memuse" ];
        };
        resolvedDefaultFeatures = [ "alloc" ];
      };
      "hkdf" = rec {
        crateName = "hkdf";
        version = "0.12.4";
        edition = "2018";
        sha256 = "1xxxzcarz151p1b858yn5skmhyrvn8fs4ivx5km3i1kjmnr8wpvv";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "hmac";
            packageId = "hmac";
          }
        ];
        features = {
          "std" = [ "hmac/std" ];
        };
      };
      "hmac" = rec {
        crateName = "hmac";
        version = "0.12.1";
        edition = "2018";
        sha256 = "0pmbr069sfg76z7wsssfk5ddcqd9ncp79fyz6zcm6yn115yc6jbc";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "digest";
            packageId = "digest";
            features = [ "mac" ];
          }
        ];
        devDependencies = [
          {
            name = "digest";
            packageId = "digest";
            features = [ "dev" ];
          }
        ];
        features = {
          "std" = [ "digest/std" ];
        };
        resolvedDefaultFeatures = [ "reset" ];
      };
      "hmac-sha1-compact" = rec {
        crateName = "hmac-sha1-compact";
        version = "1.1.4";
        edition = "2018";
        sha256 = "19w4iiwrprcnvq3k2gkv6xm9b11alda4w9l7vvya6bvkxh2x9yfz";
        authors = [
          "Frank Denis <github@pureftpd.org>"
        ];
        features = {
          "digest010" = [ "dep:digest010" ];
          "digest09" = [ "dep:digest09" ];
          "traits" = [ "traits09" "traits010" ];
          "traits010" = [ "digest010" ];
          "traits09" = [ "digest09" ];
        };
        resolvedDefaultFeatures = [ "default" ];
      };
      "hmac-sha256" = rec {
        crateName = "hmac-sha256";
        version = "1.1.7";
        edition = "2018";
        sha256 = "0dapmabsj2mvblwjy64h518frj1cvk468kr5awayr3q172dyd21n";
        authors = [
          "Frank Denis <github@pureftpd.org>"
        ];
        dependencies = [
          {
            name = "digest";
            packageId = "digest";
            rename = "digest010";
            optional = true;
            features = [ "oid" ];
          }
        ];
        features = {
          "digest010" = [ "dep:digest010" ];
          "digest09" = [ "dep:digest09" ];
          "traits" = [ "traits09" "traits010" ];
          "traits010" = [ "digest010" ];
          "traits09" = [ "digest09" ];
        };
        resolvedDefaultFeatures = [ "default" "digest010" "traits010" ];
      };
      "hmac-sha512" = rec {
        crateName = "hmac-sha512";
        version = "1.1.5";
        edition = "2018";
        sha256 = "12pp9qdf0f62lgwcb8h1xnvlb1pmkgqgjf5rzaiqkrdsar31zkp4";
        authors = [
          "Frank Denis <github@pureftpd.org>"
        ];
        dependencies = [
          {
            name = "digest";
            packageId = "digest";
            rename = "digest010";
            optional = true;
            features = [ "oid" ];
          }
        ];
        features = {
          "default" = [ "sha384" ];
          "digest010" = [ "dep:digest010" ];
          "digest09" = [ "dep:digest09" ];
          "traits" = [ "traits09" "traits010" ];
          "traits010" = [ "digest010" ];
          "traits09" = [ "digest09" ];
        };
        resolvedDefaultFeatures = [ "default" "digest010" "sha384" "traits010" ];
      };
      "itoa" = rec {
        crateName = "itoa";
        version = "1.0.11";
        edition = "2018";
        sha256 = "0nv9cqjwzr3q58qz84dcz63ggc54yhf1yqar1m858m1kfd4g3wa9";
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];
        features = {
          "no-panic" = [ "dep:no-panic" ];
        };
      };
      "js-sys" = rec {
        crateName = "js-sys";
        version = "0.3.69";
        edition = "2018";
        sha256 = "0v99rz97asnzapb0jsc3jjhvxpfxr7h7qd97yqyrf9i7viimbh99";
        authors = [
          "The wasm-bindgen Developers"
        ];
        dependencies = [
          {
            name = "wasm-bindgen";
            packageId = "wasm-bindgen";
          }
        ];

      };
      "jwt-simple 0.11.3" = rec {
        crateName = "jwt-simple";
        version = "0.11.3";
        edition = "2018";
        workspace_member = null;
        src = pkgs.fetchgit {
          url = "https://github.com/wireapp/rust-jwt-simple";
          rev = "15a69f82288d68b74a75c1364e5d4bf681f1c07b";
          sha256 = "1ms7bym5j3gvn10gdbacai7v5dsdw8cf747py7igg5almk105n0z";
        };
        authors = [
          "Frank Denis <github@pureftpd.org>"
        ];
        dependencies = [
          {
            name = "anyhow";
            packageId = "anyhow";
          }
          {
            name = "binstring";
            packageId = "binstring";
          }
          {
            name = "coarsetime";
            packageId = "coarsetime";
          }
          {
            name = "ct-codecs";
            packageId = "ct-codecs";
          }
          {
            name = "ed25519-compact";
            packageId = "ed25519-compact";
            features = [ "pem" ];
          }
          {
            name = "hmac-sha1-compact";
            packageId = "hmac-sha1-compact";
          }
          {
            name = "hmac-sha256";
            packageId = "hmac-sha256";
            features = [ "traits010" ];
          }
          {
            name = "hmac-sha512";
            packageId = "hmac-sha512";
            features = [ "traits010" "sha384" ];
          }
          {
            name = "k256";
            packageId = "k256 0.12.0";
            features = [ "ecdsa" "std" "pkcs8" "pem" ];
          }
          {
            name = "p256";
            packageId = "p256 0.12.0";
            features = [ "ecdsa" "std" "pkcs8" "pem" ];
          }
          {
            name = "p384";
            packageId = "p384 0.12.0";
            features = [ "ecdsa" "std" "pkcs8" "pem" ];
          }
          {
            name = "rand";
            packageId = "rand";
          }
          {
            name = "rsa";
            packageId = "rsa";
          }
          {
            name = "serde";
            packageId = "serde";
            features = [ "derive" ];
          }
          {
            name = "serde_json";
            packageId = "serde_json";
          }
          {
            name = "spki";
            packageId = "spki 0.6.0";
          }
          {
            name = "thiserror";
            packageId = "thiserror";
          }
          {
            name = "zeroize";
            packageId = "zeroize";
          }
        ];
        features = {
          "ciborium" = [ "dep:ciborium" ];
          "cwt" = [ "ciborium" ];
        };
      };
      "jwt-simple 0.11.4" = rec {
        crateName = "jwt-simple";
        version = "0.11.4";
        edition = "2018";
        workspace_member = null;
        src = pkgs.fetchgit {
          url = "https://github.com/wireapp/rust-jwt-simple";
          rev = "5a35177ae37c06d65225df4ba2c2b065917748c5";
          sha256 = "1fkv1w82dy681qbw9wwja2dapgg1m8d01j5i2zxn1vccpsy89cnc";
        };
        authors = [
          "Frank Denis <github@pureftpd.org>"
        ];
        dependencies = [
          {
            name = "anyhow";
            packageId = "anyhow";
          }
          {
            name = "binstring";
            packageId = "binstring";
          }
          {
            name = "coarsetime";
            packageId = "coarsetime";
          }
          {
            name = "ct-codecs";
            packageId = "ct-codecs";
          }
          {
            name = "ed25519-compact";
            packageId = "ed25519-compact";
            features = [ "pem" ];
          }
          {
            name = "hmac-sha1-compact";
            packageId = "hmac-sha1-compact";
          }
          {
            name = "hmac-sha256";
            packageId = "hmac-sha256";
            features = [ "traits010" ];
          }
          {
            name = "hmac-sha512";
            packageId = "hmac-sha512";
            features = [ "traits010" "sha384" ];
          }
          {
            name = "k256";
            packageId = "k256 0.13.3";
            features = [ "ecdsa" "std" "pkcs8" "pem" ];
          }
          {
            name = "p256";
            packageId = "p256 0.13.2";
            features = [ "ecdsa" "std" "pkcs8" "pem" ];
          }
          {
            name = "p384";
            packageId = "p384 0.13.0";
            features = [ "ecdsa" "std" "pkcs8" "pem" ];
          }
          {
            name = "rand";
            packageId = "rand";
          }
          {
            name = "rsa";
            packageId = "rsa";
          }
          {
            name = "serde";
            packageId = "serde";
            features = [ "derive" ];
          }
          {
            name = "serde_json";
            packageId = "serde_json";
          }
          {
            name = "spki";
            packageId = "spki 0.6.0";
          }
          {
            name = "thiserror";
            packageId = "thiserror";
          }
          {
            name = "zeroize";
            packageId = "zeroize";
          }
        ];
        features = {
          "ciborium" = [ "dep:ciborium" ];
          "cwt" = [ "ciborium" ];
        };
      };
      "k256 0.12.0" = rec {
        crateName = "k256";
        version = "0.12.0";
        edition = "2021";
        sha256 = "15rk834ksg9jw96kh6hwiyv94i5qy6brw784rwmjcb5pyc7mx9cj";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "cfg-if";
            packageId = "cfg-if";
          }
          {
            name = "ecdsa";
            packageId = "ecdsa 0.15.1";
            rename = "ecdsa-core";
            optional = true;
            usesDefaultFeatures = false;
            features = [ "der" ];
          }
          {
            name = "elliptic-curve";
            packageId = "elliptic-curve 0.12.3";
            usesDefaultFeatures = false;
            features = [ "hazmat" "sec1" ];
          }
          {
            name = "once_cell";
            packageId = "once_cell";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "sha2";
            packageId = "sha2";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "signature";
            packageId = "signature 2.0.0";
            optional = true;
          }
        ];
        devDependencies = [
          {
            name = "ecdsa";
            packageId = "ecdsa 0.15.1";
            rename = "ecdsa-core";
            usesDefaultFeatures = false;
            features = [ "dev" ];
          }
        ];
        features = {
          "alloc" = [ "ecdsa-core?/alloc" "elliptic-curve/alloc" ];
          "arithmetic" = [ "elliptic-curve/arithmetic" ];
          "bits" = [ "arithmetic" "elliptic-curve/bits" ];
          "critical-section" = [ "once_cell/critical-section" "precomputed-tables" ];
          "default" = [ "arithmetic" "ecdsa" "pkcs8" "precomputed-tables" "schnorr" "std" ];
          "digest" = [ "ecdsa-core/digest" "ecdsa-core/hazmat" ];
          "ecdh" = [ "arithmetic" "elliptic-curve/ecdh" ];
          "ecdsa" = [ "arithmetic" "ecdsa-core/signing" "ecdsa-core/verifying" "sha256" ];
          "ecdsa-core" = [ "dep:ecdsa-core" ];
          "expose-field" = [ "arithmetic" ];
          "hash2curve" = [ "arithmetic" "elliptic-curve/hash2curve" ];
          "hex-literal" = [ "dep:hex-literal" ];
          "jwk" = [ "elliptic-curve/jwk" ];
          "once_cell" = [ "dep:once_cell" ];
          "pem" = [ "ecdsa-core/pem" "elliptic-curve/pem" "pkcs8" ];
          "pkcs8" = [ "ecdsa-core/pkcs8" "elliptic-curve/pkcs8" ];
          "precomputed-tables" = [ "arithmetic" "once_cell" ];
          "schnorr" = [ "arithmetic" "sha256" "signature" ];
          "serde" = [ "ecdsa-core/serde" "elliptic-curve/serde" "serdect" ];
          "serdect" = [ "dep:serdect" ];
          "sha2" = [ "dep:sha2" ];
          "sha256" = [ "digest" "sha2" ];
          "signature" = [ "dep:signature" ];
          "std" = [ "alloc" "ecdsa-core?/std" "elliptic-curve/std" "once_cell?/std" ];
          "test-vectors" = [ "hex-literal" ];
        };
        resolvedDefaultFeatures = [ "alloc" "arithmetic" "default" "digest" "ecdsa" "ecdsa-core" "once_cell" "pem" "pkcs8" "precomputed-tables" "schnorr" "sha2" "sha256" "signature" "std" ];
      };
      "k256 0.13.3" = rec {
        crateName = "k256";
        version = "0.13.3";
        edition = "2021";
        sha256 = "0ysq18pjz040am5llgly90464x7qqq98yxfbcsladq96gsvgjvwm";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "cfg-if";
            packageId = "cfg-if";
          }
          {
            name = "ecdsa";
            packageId = "ecdsa 0.16.9";
            rename = "ecdsa-core";
            optional = true;
            usesDefaultFeatures = false;
            features = [ "der" ];
          }
          {
            name = "elliptic-curve";
            packageId = "elliptic-curve 0.13.8";
            usesDefaultFeatures = false;
            features = [ "hazmat" "sec1" ];
          }
          {
            name = "once_cell";
            packageId = "once_cell";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "sha2";
            packageId = "sha2";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "signature";
            packageId = "signature 2.0.0";
            optional = true;
          }
        ];
        devDependencies = [
          {
            name = "ecdsa";
            packageId = "ecdsa 0.16.9";
            rename = "ecdsa-core";
            usesDefaultFeatures = false;
            features = [ "dev" ];
          }
        ];
        features = {
          "alloc" = [ "ecdsa-core?/alloc" "elliptic-curve/alloc" ];
          "arithmetic" = [ "elliptic-curve/arithmetic" ];
          "bits" = [ "arithmetic" "elliptic-curve/bits" ];
          "critical-section" = [ "once_cell/critical-section" "precomputed-tables" ];
          "default" = [ "arithmetic" "ecdsa" "pkcs8" "precomputed-tables" "schnorr" "std" ];
          "digest" = [ "ecdsa-core/digest" "ecdsa-core/hazmat" ];
          "ecdh" = [ "arithmetic" "elliptic-curve/ecdh" ];
          "ecdsa" = [ "arithmetic" "ecdsa-core/signing" "ecdsa-core/verifying" "sha256" ];
          "ecdsa-core" = [ "dep:ecdsa-core" ];
          "expose-field" = [ "arithmetic" ];
          "hash2curve" = [ "arithmetic" "elliptic-curve/hash2curve" ];
          "hex-literal" = [ "dep:hex-literal" ];
          "jwk" = [ "elliptic-curve/jwk" ];
          "once_cell" = [ "dep:once_cell" ];
          "pem" = [ "ecdsa-core/pem" "elliptic-curve/pem" "pkcs8" ];
          "pkcs8" = [ "ecdsa-core/pkcs8" "elliptic-curve/pkcs8" ];
          "precomputed-tables" = [ "arithmetic" "once_cell" ];
          "schnorr" = [ "arithmetic" "sha256" "signature" ];
          "serde" = [ "ecdsa-core/serde" "elliptic-curve/serde" "serdect" ];
          "serdect" = [ "dep:serdect" ];
          "sha2" = [ "dep:sha2" ];
          "sha256" = [ "digest" "sha2" ];
          "signature" = [ "dep:signature" ];
          "std" = [ "alloc" "ecdsa-core?/std" "elliptic-curve/std" "once_cell?/std" ];
          "test-vectors" = [ "hex-literal" ];
        };
        resolvedDefaultFeatures = [ "alloc" "arithmetic" "default" "digest" "ecdsa" "ecdsa-core" "once_cell" "pem" "pkcs8" "precomputed-tables" "schnorr" "sha2" "sha256" "signature" "std" ];
      };
      "lazy_static" = rec {
        crateName = "lazy_static";
        version = "1.4.0";
        edition = "2015";
        sha256 = "0in6ikhw8mgl33wjv6q6xfrb5b9jr16q8ygjy803fay4zcisvaz2";
        authors = [
          "Marvin Löbel <loebel.marvin@gmail.com>"
        ];
        dependencies = [
          {
            name = "spin";
            packageId = "spin";
            optional = true;
          }
        ];
        features = {
          "spin" = [ "dep:spin" ];
          "spin_no_std" = [ "spin" ];
        };
        resolvedDefaultFeatures = [ "spin" "spin_no_std" ];
      };
      "libc" = rec {
        crateName = "libc";
        version = "0.2.155";
        edition = "2015";
        sha256 = "0z44c53z54znna8n322k5iwg80arxxpdzjj5260pxxzc9a58icwp";
        authors = [
          "The Rust Project Developers"
        ];
        features = {
          "default" = [ "std" ];
          "rustc-dep-of-std" = [ "align" "rustc-std-workspace-core" ];
          "rustc-std-workspace-core" = [ "dep:rustc-std-workspace-core" ];
          "use_std" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "libm" = rec {
        crateName = "libm";
        version = "0.2.8";
        edition = "2018";
        sha256 = "0n4hk1rs8pzw8hdfmwn96c4568s93kfxqgcqswr7sajd2diaihjf";
        authors = [
          "Jorge Aparicio <jorge@japaric.io>"
        ];
        features = {
          "musl-reference-tests" = [ "rand" ];
          "rand" = [ "dep:rand" ];
        };
        resolvedDefaultFeatures = [ "default" ];
      };
      "libsodium-sys" = rec {
        crateName = "libsodium-sys";
        version = "0.2.7";
        edition = "2015";
        sha256 = "1zcjka23grayr8kjrgbada6vwagp0kkni9m45v0gpbanrn3r6xvb";
        libName = "libsodium_sys";
        authors = [
          "dnaq"
        ];
        dependencies = [
          {
            name = "libc";
            packageId = "libc";
            usesDefaultFeatures = false;
          }
        ];
        buildDependencies = [
          {
            name = "cc";
            packageId = "cc";
            target = { target, features }: (!("msvc" == target."env"));
          }
          {
            name = "libc";
            packageId = "libc";
            usesDefaultFeatures = false;
            target = { target, features }: ("msvc" == target."env");
          }
          {
            name = "pkg-config";
            packageId = "pkg-config";
          }
          {
            name = "walkdir";
            packageId = "walkdir";
          }
        ];
        features = { };
      };
      "log" = rec {
        crateName = "log";
        version = "0.4.21";
        edition = "2021";
        sha256 = "074hldq1q8rlzq2s2qa8f25hj4s3gpw71w64vdwzjd01a4g8rvch";
        authors = [
          "The Rust Project Developers"
        ];
        features = {
          "kv_serde" = [ "kv_std" "value-bag/serde" "serde" ];
          "kv_std" = [ "std" "kv" "value-bag/error" ];
          "kv_sval" = [ "kv" "value-bag/sval" "sval" "sval_ref" ];
          "kv_unstable" = [ "kv" "value-bag" ];
          "kv_unstable_serde" = [ "kv_serde" "kv_unstable_std" ];
          "kv_unstable_std" = [ "kv_std" "kv_unstable" ];
          "kv_unstable_sval" = [ "kv_sval" "kv_unstable" ];
          "serde" = [ "dep:serde" ];
          "sval" = [ "dep:sval" ];
          "sval_ref" = [ "dep:sval_ref" ];
          "value-bag" = [ "dep:value-bag" ];
        };
      };
      "memchr" = rec {
        crateName = "memchr";
        version = "2.7.2";
        edition = "2021";
        sha256 = "07bcqxb0vx4ji0648ny5xsicjnpma95x1n07v7mi7jrhsz2l11kc";
        authors = [
          "Andrew Gallant <jamslam@gmail.com>"
          "bluss"
        ];
        features = {
          "compiler_builtins" = [ "dep:compiler_builtins" ];
          "core" = [ "dep:core" ];
          "default" = [ "std" ];
          "logging" = [ "dep:log" ];
          "rustc-dep-of-std" = [ "core" "compiler_builtins" ];
          "std" = [ "alloc" ];
          "use_std" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "alloc" "std" ];
      };
      "num-bigint-dig" = rec {
        crateName = "num-bigint-dig";
        version = "0.8.4";
        edition = "2021";
        sha256 = "0lb12df24wgxxbspz4gw1sf1kdqwvpdcpwq4fdlwg4gj41c1k16w";
        authors = [
          "dignifiedquire <dignifiedquire@gmail.com>"
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "byteorder";
            packageId = "byteorder";
            usesDefaultFeatures = false;
          }
          {
            name = "lazy_static";
            packageId = "lazy_static";
            usesDefaultFeatures = false;
            features = [ "spin_no_std" ];
          }
          {
            name = "libm";
            packageId = "libm";
          }
          {
            name = "num-integer";
            packageId = "num-integer";
            usesDefaultFeatures = false;
            features = [ "i128" ];
          }
          {
            name = "num-iter";
            packageId = "num-iter";
            usesDefaultFeatures = false;
          }
          {
            name = "num-traits";
            packageId = "num-traits";
            usesDefaultFeatures = false;
            features = [ "i128" ];
          }
          {
            name = "rand";
            packageId = "rand";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "smallvec";
            packageId = "smallvec";
            usesDefaultFeatures = false;
          }
          {
            name = "zeroize";
            packageId = "zeroize";
            optional = true;
            usesDefaultFeatures = false;
          }
        ];
        devDependencies = [
          {
            name = "rand";
            packageId = "rand";
            features = [ "small_rng" ];
          }
        ];
        features = {
          "arbitrary" = [ "dep:arbitrary" ];
          "default" = [ "std" "u64_digit" ];
          "fuzz" = [ "arbitrary" "smallvec/arbitrary" ];
          "prime" = [ "rand/std_rng" ];
          "rand" = [ "dep:rand" ];
          "serde" = [ "dep:serde" ];
          "std" = [ "num-integer/std" "num-traits/std" "smallvec/write" "rand/std" "serde/std" ];
          "zeroize" = [ "dep:zeroize" ];
        };
        resolvedDefaultFeatures = [ "i128" "prime" "rand" "u64_digit" "zeroize" ];
      };
      "num-integer" = rec {
        crateName = "num-integer";
        version = "0.1.46";
        edition = "2018";
        sha256 = "13w5g54a9184cqlbsq80rnxw4jj4s0d8wv75jsq5r2lms8gncsbr";
        authors = [
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "num-traits";
            packageId = "num-traits";
            usesDefaultFeatures = false;
            features = [ "i128" ];
          }
        ];
        features = {
          "default" = [ "std" ];
          "std" = [ "num-traits/std" ];
        };
        resolvedDefaultFeatures = [ "i128" ];
      };
      "num-iter" = rec {
        crateName = "num-iter";
        version = "0.1.45";
        edition = "2018";
        sha256 = "1gzm7vc5g9qsjjl3bqk9rz1h6raxhygbrcpbfl04swlh0i506a8l";
        authors = [
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "num-integer";
            packageId = "num-integer";
            usesDefaultFeatures = false;
            features = [ "i128" ];
          }
          {
            name = "num-traits";
            packageId = "num-traits";
            usesDefaultFeatures = false;
            features = [ "i128" ];
          }
        ];
        buildDependencies = [
          {
            name = "autocfg";
            packageId = "autocfg";
          }
        ];
        features = {
          "default" = [ "std" ];
          "std" = [ "num-integer/std" "num-traits/std" ];
        };
      };
      "num-traits" = rec {
        crateName = "num-traits";
        version = "0.2.19";
        edition = "2021";
        sha256 = "0h984rhdkkqd4ny9cif7y2azl3xdfb7768hb9irhpsch4q3gq787";
        authors = [
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "libm";
            packageId = "libm";
            optional = true;
          }
        ];
        buildDependencies = [
          {
            name = "autocfg";
            packageId = "autocfg";
          }
        ];
        features = {
          "default" = [ "std" ];
          "libm" = [ "dep:libm" ];
        };
        resolvedDefaultFeatures = [ "i128" "libm" ];
      };
      "once_cell" = rec {
        crateName = "once_cell";
        version = "1.19.0";
        edition = "2021";
        sha256 = "14kvw7px5z96dk4dwdm1r9cqhhy2cyj1l5n5b29mynbb8yr15nrz";
        authors = [
          "Aleksey Kladov <aleksey.kladov@gmail.com>"
        ];
        features = {
          "alloc" = [ "race" ];
          "atomic-polyfill" = [ "critical-section" ];
          "critical-section" = [ "dep:critical-section" "portable-atomic" ];
          "default" = [ "std" ];
          "parking_lot" = [ "dep:parking_lot_core" ];
          "portable-atomic" = [ "dep:portable-atomic" ];
          "std" = [ "alloc" ];
        };
        resolvedDefaultFeatures = [ "alloc" "default" "race" "std" ];
      };
      "p256 0.12.0" = rec {
        crateName = "p256";
        version = "0.12.0";
        edition = "2021";
        sha256 = "0m8f1d0n69bvm4xpranhwv3nrvcq3lcfqn4cqsxbqhyfrfrj9ha9";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "ecdsa";
            packageId = "ecdsa 0.15.1";
            rename = "ecdsa-core";
            optional = true;
            usesDefaultFeatures = false;
            features = [ "der" ];
          }
          {
            name = "elliptic-curve";
            packageId = "elliptic-curve 0.12.3";
            usesDefaultFeatures = false;
            features = [ "hazmat" "sec1" ];
          }
          {
            name = "primeorder";
            packageId = "primeorder 0.12.1";
          }
          {
            name = "sha2";
            packageId = "sha2";
            optional = true;
            usesDefaultFeatures = false;
          }
        ];
        devDependencies = [
          {
            name = "ecdsa";
            packageId = "ecdsa 0.15.1";
            rename = "ecdsa-core";
            usesDefaultFeatures = false;
            features = [ "dev" ];
          }
        ];
        features = {
          "alloc" = [ "ecdsa-core?/alloc" "elliptic-curve/alloc" ];
          "arithmetic" = [ "elliptic-curve/arithmetic" ];
          "bits" = [ "arithmetic" "elliptic-curve/bits" ];
          "default" = [ "arithmetic" "ecdsa" "pkcs8" "std" ];
          "digest" = [ "ecdsa-core/digest" "ecdsa-core/hazmat" ];
          "ecdh" = [ "arithmetic" "elliptic-curve/ecdh" ];
          "ecdsa" = [ "arithmetic" "ecdsa-core/signing" "ecdsa-core/verifying" "sha256" ];
          "ecdsa-core" = [ "dep:ecdsa-core" ];
          "expose-field" = [ "arithmetic" ];
          "hash2curve" = [ "arithmetic" "elliptic-curve/hash2curve" ];
          "hex-literal" = [ "dep:hex-literal" ];
          "jwk" = [ "elliptic-curve/jwk" ];
          "pem" = [ "elliptic-curve/pem" "ecdsa-core/pem" "pkcs8" ];
          "pkcs8" = [ "ecdsa-core/pkcs8" "elliptic-curve/pkcs8" ];
          "serde" = [ "ecdsa-core/serde" "elliptic-curve/serde" "serdect" ];
          "serdect" = [ "dep:serdect" ];
          "sha2" = [ "dep:sha2" ];
          "sha256" = [ "digest" "sha2" ];
          "std" = [ "alloc" "ecdsa-core?/std" "elliptic-curve/std" ];
          "test-vectors" = [ "hex-literal" ];
          "voprf" = [ "elliptic-curve/voprf" "sha2" ];
        };
        resolvedDefaultFeatures = [ "alloc" "arithmetic" "default" "digest" "ecdsa" "ecdsa-core" "pem" "pkcs8" "sha2" "sha256" "std" ];
      };
      "p256 0.13.2" = rec {
        crateName = "p256";
        version = "0.13.2";
        edition = "2021";
        sha256 = "0jyd3c3k239ybs59ixpnl7dqkmm072fr1js8kh7ldx58bzc3m1n9";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "ecdsa";
            packageId = "ecdsa 0.16.9";
            rename = "ecdsa-core";
            optional = true;
            usesDefaultFeatures = false;
            features = [ "der" ];
          }
          {
            name = "elliptic-curve";
            packageId = "elliptic-curve 0.13.8";
            usesDefaultFeatures = false;
            features = [ "hazmat" "sec1" ];
          }
          {
            name = "primeorder";
            packageId = "primeorder 0.13.6";
            optional = true;
          }
          {
            name = "sha2";
            packageId = "sha2";
            optional = true;
            usesDefaultFeatures = false;
          }
        ];
        devDependencies = [
          {
            name = "ecdsa";
            packageId = "ecdsa 0.16.9";
            rename = "ecdsa-core";
            usesDefaultFeatures = false;
            features = [ "dev" ];
          }
          {
            name = "primeorder";
            packageId = "primeorder 0.13.6";
            features = [ "dev" ];
          }
        ];
        features = {
          "alloc" = [ "ecdsa-core?/alloc" "elliptic-curve/alloc" ];
          "arithmetic" = [ "dep:primeorder" "elliptic-curve/arithmetic" ];
          "bits" = [ "arithmetic" "elliptic-curve/bits" ];
          "default" = [ "arithmetic" "ecdsa" "pem" "std" ];
          "digest" = [ "ecdsa-core/digest" "ecdsa-core/hazmat" ];
          "ecdh" = [ "arithmetic" "elliptic-curve/ecdh" ];
          "ecdsa" = [ "arithmetic" "ecdsa-core/signing" "ecdsa-core/verifying" "sha256" ];
          "ecdsa-core" = [ "dep:ecdsa-core" ];
          "expose-field" = [ "arithmetic" ];
          "hash2curve" = [ "arithmetic" "elliptic-curve/hash2curve" ];
          "jwk" = [ "elliptic-curve/jwk" ];
          "pem" = [ "elliptic-curve/pem" "ecdsa-core/pem" "pkcs8" ];
          "pkcs8" = [ "ecdsa-core?/pkcs8" "elliptic-curve/pkcs8" ];
          "serde" = [ "ecdsa-core?/serde" "elliptic-curve/serde" "primeorder?/serde" "serdect" ];
          "serdect" = [ "dep:serdect" ];
          "sha2" = [ "dep:sha2" ];
          "sha256" = [ "digest" "sha2" ];
          "std" = [ "alloc" "ecdsa-core?/std" "elliptic-curve/std" ];
          "test-vectors" = [ "dep:hex-literal" ];
          "voprf" = [ "elliptic-curve/voprf" "sha2" ];
        };
        resolvedDefaultFeatures = [ "alloc" "arithmetic" "default" "digest" "ecdsa" "ecdsa-core" "pem" "pkcs8" "sha2" "sha256" "std" ];
      };
      "p384 0.12.0" = rec {
        crateName = "p384";
        version = "0.12.0";
        edition = "2021";
        sha256 = "1m6jw4zm5v9czk6ncbdzcdq82jsnby8a8qdfrz78wd0q4sdll2k3";
        authors = [
          "RustCrypto Developers"
          "Frank Denis <github@pureftpd.org>"
        ];
        dependencies = [
          {
            name = "ecdsa";
            packageId = "ecdsa 0.15.1";
            rename = "ecdsa-core";
            optional = true;
            usesDefaultFeatures = false;
            features = [ "der" ];
          }
          {
            name = "elliptic-curve";
            packageId = "elliptic-curve 0.12.3";
            usesDefaultFeatures = false;
            features = [ "hazmat" "sec1" ];
          }
          {
            name = "primeorder";
            packageId = "primeorder 0.12.1";
          }
          {
            name = "sha2";
            packageId = "sha2";
            optional = true;
            usesDefaultFeatures = false;
          }
        ];
        devDependencies = [
          {
            name = "ecdsa";
            packageId = "ecdsa 0.15.1";
            rename = "ecdsa-core";
            usesDefaultFeatures = false;
            features = [ "dev" ];
          }
        ];
        features = {
          "alloc" = [ "ecdsa-core?/alloc" "elliptic-curve/alloc" ];
          "arithmetic" = [ "elliptic-curve/arithmetic" "elliptic-curve/digest" ];
          "bits" = [ "arithmetic" "elliptic-curve/bits" ];
          "default" = [ "arithmetic" "ecdh" "ecdsa" "pem" "std" ];
          "digest" = [ "ecdsa-core/digest" "ecdsa-core/hazmat" ];
          "ecdh" = [ "arithmetic" "elliptic-curve/ecdh" ];
          "ecdsa" = [ "arithmetic" "ecdsa-core/signing" "ecdsa-core/verifying" "sha384" ];
          "ecdsa-core" = [ "dep:ecdsa-core" ];
          "expose-field" = [ "arithmetic" ];
          "hash2curve" = [ "arithmetic" "elliptic-curve/hash2curve" ];
          "hex-literal" = [ "dep:hex-literal" ];
          "jwk" = [ "elliptic-curve/jwk" ];
          "pem" = [ "elliptic-curve/pem" "ecdsa-core/pem" "pkcs8" ];
          "pkcs8" = [ "ecdsa-core/pkcs8" "elliptic-curve/pkcs8" ];
          "serde" = [ "ecdsa-core/serde" "elliptic-curve/serde" "serdect" ];
          "serdect" = [ "dep:serdect" ];
          "sha2" = [ "dep:sha2" ];
          "sha384" = [ "digest" "sha2" ];
          "std" = [ "alloc" "ecdsa-core?/std" "elliptic-curve/std" ];
          "test-vectors" = [ "hex-literal" ];
          "voprf" = [ "elliptic-curve/voprf" "sha2" ];
        };
        resolvedDefaultFeatures = [ "alloc" "arithmetic" "default" "digest" "ecdh" "ecdsa" "ecdsa-core" "pem" "pkcs8" "sha2" "sha384" "std" ];
      };
      "p384 0.13.0" = rec {
        crateName = "p384";
        version = "0.13.0";
        edition = "2021";
        sha256 = "02cjlxdvxwvhmnckqnydqpvrwhf5raj67q300d66m7y6pi8nyy3h";
        authors = [
          "RustCrypto Developers"
          "Frank Denis <github@pureftpd.org>"
        ];
        dependencies = [
          {
            name = "ecdsa";
            packageId = "ecdsa 0.16.9";
            rename = "ecdsa-core";
            optional = true;
            usesDefaultFeatures = false;
            features = [ "der" ];
          }
          {
            name = "elliptic-curve";
            packageId = "elliptic-curve 0.13.8";
            usesDefaultFeatures = false;
            features = [ "hazmat" "sec1" ];
          }
          {
            name = "primeorder";
            packageId = "primeorder 0.13.6";
          }
          {
            name = "sha2";
            packageId = "sha2";
            optional = true;
            usesDefaultFeatures = false;
          }
        ];
        devDependencies = [
          {
            name = "ecdsa";
            packageId = "ecdsa 0.16.9";
            rename = "ecdsa-core";
            usesDefaultFeatures = false;
            features = [ "dev" ];
          }
        ];
        features = {
          "alloc" = [ "ecdsa-core?/alloc" "elliptic-curve/alloc" ];
          "arithmetic" = [ "elliptic-curve/arithmetic" "elliptic-curve/digest" ];
          "bits" = [ "arithmetic" "elliptic-curve/bits" ];
          "default" = [ "arithmetic" "ecdh" "ecdsa" "pem" "std" ];
          "digest" = [ "ecdsa-core/digest" "ecdsa-core/hazmat" ];
          "ecdh" = [ "arithmetic" "elliptic-curve/ecdh" ];
          "ecdsa" = [ "arithmetic" "ecdsa-core/signing" "ecdsa-core/verifying" "sha384" ];
          "ecdsa-core" = [ "dep:ecdsa-core" ];
          "expose-field" = [ "arithmetic" ];
          "hash2curve" = [ "arithmetic" "elliptic-curve/hash2curve" ];
          "hex-literal" = [ "dep:hex-literal" ];
          "jwk" = [ "elliptic-curve/jwk" ];
          "pem" = [ "elliptic-curve/pem" "ecdsa-core/pem" "pkcs8" ];
          "pkcs8" = [ "ecdsa-core/pkcs8" "elliptic-curve/pkcs8" ];
          "serde" = [ "ecdsa-core/serde" "elliptic-curve/serde" "serdect" ];
          "serdect" = [ "dep:serdect" ];
          "sha2" = [ "dep:sha2" ];
          "sha384" = [ "digest" "sha2" ];
          "std" = [ "alloc" "ecdsa-core?/std" "elliptic-curve/std" ];
          "test-vectors" = [ "hex-literal" ];
          "voprf" = [ "elliptic-curve/voprf" "sha2" ];
        };
        resolvedDefaultFeatures = [ "alloc" "arithmetic" "default" "digest" "ecdh" "ecdsa" "ecdsa-core" "pem" "pkcs8" "sha2" "sha384" "std" ];
      };
      "pem-rfc7468 0.6.0" = rec {
        crateName = "pem-rfc7468";
        version = "0.6.0";
        edition = "2021";
        sha256 = "1b5d8rvc4lgwxhs72m99fnrg0wq7bqh4x4wq0c7501ci7a1mkl94";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "base64ct";
            packageId = "base64ct";
          }
        ];
        features = {
          "alloc" = [ "base64ct/alloc" ];
          "std" = [ "alloc" "base64ct/std" ];
        };
        resolvedDefaultFeatures = [ "alloc" ];
      };
      "pem-rfc7468 0.7.0" = rec {
        crateName = "pem-rfc7468";
        version = "0.7.0";
        edition = "2021";
        sha256 = "04l4852scl4zdva31c1z6jafbak0ni5pi0j38ml108zwzjdrrcw8";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "base64ct";
            packageId = "base64ct";
          }
        ];
        features = {
          "alloc" = [ "base64ct/alloc" ];
          "std" = [ "alloc" "base64ct/std" ];
        };
        resolvedDefaultFeatures = [ "alloc" ];
      };
      "pkcs1" = rec {
        crateName = "pkcs1";
        version = "0.4.1";
        edition = "2021";
        sha256 = "06gpasl1v2d2r74xa8vm72vqy6ryxjynwxna5s5cjk65vzdkpwzg";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "der";
            packageId = "der 0.6.1";
            features = [ "oid" ];
          }
          {
            name = "pkcs8";
            packageId = "pkcs8 0.9.0";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "spki";
            packageId = "spki 0.6.0";
          }
          {
            name = "zeroize";
            packageId = "zeroize";
            optional = true;
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "alloc" = [ "der/alloc" "pkcs8/alloc" "zeroize/alloc" ];
          "pem" = [ "alloc" "der/pem" "pkcs8/pem" ];
          "pkcs8" = [ "dep:pkcs8" ];
          "std" = [ "der/std" "alloc" ];
          "zeroize" = [ "dep:zeroize" ];
        };
        resolvedDefaultFeatures = [ "alloc" "pem" "pkcs8" "std" "zeroize" ];
      };
      "pkcs8 0.10.2" = rec {
        crateName = "pkcs8";
        version = "0.10.2";
        edition = "2021";
        sha256 = "1dx7w21gvn07azszgqd3ryjhyphsrjrmq5mmz1fbxkj5g0vv4l7r";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "der";
            packageId = "der 0.7.9";
            features = [ "oid" ];
          }
          {
            name = "spki";
            packageId = "spki 0.7.3";
          }
        ];
        features = {
          "3des" = [ "encryption" "pkcs5/3des" ];
          "alloc" = [ "der/alloc" "der/zeroize" "spki/alloc" ];
          "des-insecure" = [ "encryption" "pkcs5/des-insecure" ];
          "encryption" = [ "alloc" "pkcs5/alloc" "pkcs5/pbes2" "rand_core" ];
          "getrandom" = [ "rand_core/getrandom" ];
          "pem" = [ "alloc" "der/pem" "spki/pem" ];
          "pkcs5" = [ "dep:pkcs5" ];
          "rand_core" = [ "dep:rand_core" ];
          "sha1-insecure" = [ "encryption" "pkcs5/sha1-insecure" ];
          "std" = [ "alloc" "der/std" "spki/std" ];
          "subtle" = [ "dep:subtle" ];
        };
        resolvedDefaultFeatures = [ "alloc" "pem" "std" ];
      };
      "pkcs8 0.9.0" = rec {
        crateName = "pkcs8";
        version = "0.9.0";
        edition = "2021";
        sha256 = "1fm4sigvcd0zpzg9jcp862a8p272kk08b9lgcs1dm1az19cjrjly";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "der";
            packageId = "der 0.6.1";
            features = [ "oid" ];
          }
          {
            name = "spki";
            packageId = "spki 0.6.0";
          }
        ];
        features = {
          "3des" = [ "encryption" "pkcs5/3des" ];
          "alloc" = [ "der/alloc" "der/zeroize" "spki/alloc" ];
          "des-insecure" = [ "encryption" "pkcs5/des-insecure" ];
          "encryption" = [ "alloc" "pkcs5/alloc" "pkcs5/pbes2" "rand_core" ];
          "getrandom" = [ "rand_core/getrandom" ];
          "pem" = [ "alloc" "der/pem" "spki/pem" ];
          "pkcs5" = [ "dep:pkcs5" ];
          "rand_core" = [ "dep:rand_core" ];
          "sha1" = [ "encryption" "pkcs5/sha1" ];
          "std" = [ "alloc" "der/std" "spki/std" ];
          "subtle" = [ "dep:subtle" ];
        };
        resolvedDefaultFeatures = [ "alloc" "pem" "std" ];
      };
      "pkg-config" = rec {
        crateName = "pkg-config";
        version = "0.3.30";
        edition = "2015";
        sha256 = "1v07557dj1sa0aly9c90wsygc0i8xv5vnmyv0g94lpkvj8qb4cfj";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];

      };
      "ppv-lite86" = rec {
        crateName = "ppv-lite86";
        version = "0.2.17";
        edition = "2018";
        sha256 = "1pp6g52aw970adv3x2310n7glqnji96z0a9wiamzw89ibf0ayh2v";
        authors = [
          "The CryptoCorrosion Contributors"
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "simd" "std" ];
      };
      "primeorder 0.12.1" = rec {
        crateName = "primeorder";
        version = "0.12.1";
        edition = "2021";
        sha256 = "1cn5lh5pb1g7x9l0cq888qp6im36bg95pkqlyji6bfix3c9zfm0b";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "elliptic-curve";
            packageId = "elliptic-curve 0.12.3";
            usesDefaultFeatures = false;
            features = [ "arithmetic" "sec1" ];
          }
        ];
        features = {
          "serde" = [ "elliptic-curve/serde" "serdect" ];
          "serdect" = [ "dep:serdect" ];
          "std" = [ "elliptic-curve/std" ];
        };
      };
      "primeorder 0.13.6" = rec {
        crateName = "primeorder";
        version = "0.13.6";
        edition = "2021";
        sha256 = "1rp16710mxksagcjnxqjjq9r9wf5vf72fs8wxffnvhb6i6hiqgim";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "elliptic-curve";
            packageId = "elliptic-curve 0.13.8";
            usesDefaultFeatures = false;
            features = [ "arithmetic" "sec1" ];
          }
        ];
        features = {
          "alloc" = [ "elliptic-curve/alloc" ];
          "serde" = [ "elliptic-curve/serde" "serdect" ];
          "serdect" = [ "dep:serdect" ];
          "std" = [ "alloc" "elliptic-curve/std" ];
        };
      };
      "proc-macro2" = rec {
        crateName = "proc-macro2";
        version = "1.0.84";
        edition = "2021";
        sha256 = "1mj998115z75c0007glkdr8qj57ibv82h7kg6r8hnc914slwd5pc";
        libName = "proc_macro2";
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        dependencies = [
          {
            name = "unicode-ident";
            packageId = "unicode-ident";
          }
        ];
        features = {
          "default" = [ "proc-macro" ];
        };
        resolvedDefaultFeatures = [ "default" "proc-macro" ];
      };
      "quote" = rec {
        crateName = "quote";
        version = "1.0.36";
        edition = "2018";
        sha256 = "19xcmh445bg6simirnnd4fvkmp6v2qiwxh5f6rw4a70h76pnm9qg";
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];
        dependencies = [
          {
            name = "proc-macro2";
            packageId = "proc-macro2";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "default" = [ "proc-macro" ];
          "proc-macro" = [ "proc-macro2/proc-macro" ];
        };
        resolvedDefaultFeatures = [ "default" "proc-macro" ];
      };
      "rand" = rec {
        crateName = "rand";
        version = "0.8.5";
        edition = "2018";
        sha256 = "013l6931nn7gkc23jz5mm3qdhf93jjf0fg64nz2lp4i51qd8vbrl";
        authors = [
          "The Rand Project Developers"
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "libc";
            packageId = "libc";
            optional = true;
            usesDefaultFeatures = false;
            target = { target, features }: (target."unix" or false);
          }
          {
            name = "rand_chacha";
            packageId = "rand_chacha";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "rand_core";
            packageId = "rand_core";
          }
        ];
        features = {
          "alloc" = [ "rand_core/alloc" ];
          "default" = [ "std" "std_rng" ];
          "getrandom" = [ "rand_core/getrandom" ];
          "libc" = [ "dep:libc" ];
          "log" = [ "dep:log" ];
          "packed_simd" = [ "dep:packed_simd" ];
          "rand_chacha" = [ "dep:rand_chacha" ];
          "serde" = [ "dep:serde" ];
          "serde1" = [ "serde" "rand_core/serde1" ];
          "simd_support" = [ "packed_simd" ];
          "std" = [ "rand_core/std" "rand_chacha/std" "alloc" "getrandom" "libc" ];
          "std_rng" = [ "rand_chacha" ];
        };
        resolvedDefaultFeatures = [ "alloc" "default" "getrandom" "libc" "rand_chacha" "std" "std_rng" ];
      };
      "rand_chacha" = rec {
        crateName = "rand_chacha";
        version = "0.3.1";
        edition = "2018";
        sha256 = "123x2adin558xbhvqb8w4f6syjsdkmqff8cxwhmjacpsl1ihmhg6";
        authors = [
          "The Rand Project Developers"
          "The Rust Project Developers"
          "The CryptoCorrosion Contributors"
        ];
        dependencies = [
          {
            name = "ppv-lite86";
            packageId = "ppv-lite86";
            usesDefaultFeatures = false;
            features = [ "simd" ];
          }
          {
            name = "rand_core";
            packageId = "rand_core";
          }
        ];
        features = {
          "default" = [ "std" ];
          "serde" = [ "dep:serde" ];
          "serde1" = [ "serde" ];
          "std" = [ "ppv-lite86/std" ];
        };
        resolvedDefaultFeatures = [ "std" ];
      };
      "rand_core" = rec {
        crateName = "rand_core";
        version = "0.6.4";
        edition = "2018";
        sha256 = "0b4j2v4cb5krak1pv6kakv4sz6xcwbrmy2zckc32hsigbrwy82zc";
        authors = [
          "The Rand Project Developers"
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "getrandom";
            packageId = "getrandom";
            optional = true;
          }
        ];
        features = {
          "getrandom" = [ "dep:getrandom" ];
          "serde" = [ "dep:serde" ];
          "serde1" = [ "serde" ];
          "std" = [ "alloc" "getrandom" "getrandom/std" ];
        };
        resolvedDefaultFeatures = [ "alloc" "getrandom" "std" ];
      };
      "regex" = rec {
        crateName = "regex";
        version = "1.10.4";
        edition = "2021";
        sha256 = "0k5sb0h2mkwf51ab0gvv3x38jp1q7wgxf63abfbhi0wwvvgxn5y1";
        authors = [
          "The Rust Project Developers"
          "Andrew Gallant <jamslam@gmail.com>"
        ];
        dependencies = [
          {
            name = "aho-corasick";
            packageId = "aho-corasick";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "memchr";
            packageId = "memchr";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "regex-automata";
            packageId = "regex-automata";
            usesDefaultFeatures = false;
            features = [ "alloc" "syntax" "meta" "nfa-pikevm" ];
          }
          {
            name = "regex-syntax";
            packageId = "regex-syntax";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "default" = [ "std" "perf" "unicode" "regex-syntax/default" ];
          "logging" = [ "aho-corasick?/logging" "memchr?/logging" "regex-automata/logging" ];
          "perf" = [ "perf-cache" "perf-dfa" "perf-onepass" "perf-backtrack" "perf-inline" "perf-literal" ];
          "perf-backtrack" = [ "regex-automata/nfa-backtrack" ];
          "perf-dfa" = [ "regex-automata/hybrid" ];
          "perf-dfa-full" = [ "regex-automata/dfa-build" "regex-automata/dfa-search" ];
          "perf-inline" = [ "regex-automata/perf-inline" ];
          "perf-literal" = [ "dep:aho-corasick" "dep:memchr" "regex-automata/perf-literal" ];
          "perf-onepass" = [ "regex-automata/dfa-onepass" ];
          "std" = [ "aho-corasick?/std" "memchr?/std" "regex-automata/std" "regex-syntax/std" ];
          "unicode" = [ "unicode-age" "unicode-bool" "unicode-case" "unicode-gencat" "unicode-perl" "unicode-script" "unicode-segment" "regex-automata/unicode" "regex-syntax/unicode" ];
          "unicode-age" = [ "regex-automata/unicode-age" "regex-syntax/unicode-age" ];
          "unicode-bool" = [ "regex-automata/unicode-bool" "regex-syntax/unicode-bool" ];
          "unicode-case" = [ "regex-automata/unicode-case" "regex-syntax/unicode-case" ];
          "unicode-gencat" = [ "regex-automata/unicode-gencat" "regex-syntax/unicode-gencat" ];
          "unicode-perl" = [ "regex-automata/unicode-perl" "regex-automata/unicode-word-boundary" "regex-syntax/unicode-perl" ];
          "unicode-script" = [ "regex-automata/unicode-script" "regex-syntax/unicode-script" ];
          "unicode-segment" = [ "regex-automata/unicode-segment" "regex-syntax/unicode-segment" ];
          "unstable" = [ "pattern" ];
          "use_std" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "perf" "perf-backtrack" "perf-cache" "perf-dfa" "perf-inline" "perf-literal" "perf-onepass" "std" "unicode" "unicode-age" "unicode-bool" "unicode-case" "unicode-gencat" "unicode-perl" "unicode-script" "unicode-segment" ];
      };
      "regex-automata" = rec {
        crateName = "regex-automata";
        version = "0.4.6";
        edition = "2021";
        sha256 = "1spaq7y4im7s56d1gxa2hi4hzf6dwswb1bv8xyavzya7k25kpf46";
        authors = [
          "The Rust Project Developers"
          "Andrew Gallant <jamslam@gmail.com>"
        ];
        dependencies = [
          {
            name = "aho-corasick";
            packageId = "aho-corasick";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "memchr";
            packageId = "memchr";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "regex-syntax";
            packageId = "regex-syntax";
            optional = true;
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "default" = [ "std" "syntax" "perf" "unicode" "meta" "nfa" "dfa" "hybrid" ];
          "dfa" = [ "dfa-build" "dfa-search" "dfa-onepass" ];
          "dfa-build" = [ "nfa-thompson" "dfa-search" ];
          "dfa-onepass" = [ "nfa-thompson" ];
          "hybrid" = [ "alloc" "nfa-thompson" ];
          "internal-instrument" = [ "internal-instrument-pikevm" ];
          "internal-instrument-pikevm" = [ "logging" "std" ];
          "logging" = [ "dep:log" "aho-corasick?/logging" "memchr?/logging" ];
          "meta" = [ "syntax" "nfa-pikevm" ];
          "nfa" = [ "nfa-thompson" "nfa-pikevm" "nfa-backtrack" ];
          "nfa-backtrack" = [ "nfa-thompson" ];
          "nfa-pikevm" = [ "nfa-thompson" ];
          "nfa-thompson" = [ "alloc" ];
          "perf" = [ "perf-inline" "perf-literal" ];
          "perf-literal" = [ "perf-literal-substring" "perf-literal-multisubstring" ];
          "perf-literal-multisubstring" = [ "std" "dep:aho-corasick" ];
          "perf-literal-substring" = [ "aho-corasick?/perf-literal" "dep:memchr" ];
          "std" = [ "regex-syntax?/std" "memchr?/std" "aho-corasick?/std" "alloc" ];
          "syntax" = [ "dep:regex-syntax" "alloc" ];
          "unicode" = [ "unicode-age" "unicode-bool" "unicode-case" "unicode-gencat" "unicode-perl" "unicode-script" "unicode-segment" "unicode-word-boundary" "regex-syntax?/unicode" ];
          "unicode-age" = [ "regex-syntax?/unicode-age" ];
          "unicode-bool" = [ "regex-syntax?/unicode-bool" ];
          "unicode-case" = [ "regex-syntax?/unicode-case" ];
          "unicode-gencat" = [ "regex-syntax?/unicode-gencat" ];
          "unicode-perl" = [ "regex-syntax?/unicode-perl" ];
          "unicode-script" = [ "regex-syntax?/unicode-script" ];
          "unicode-segment" = [ "regex-syntax?/unicode-segment" ];
        };
        resolvedDefaultFeatures = [ "alloc" "dfa-onepass" "hybrid" "meta" "nfa-backtrack" "nfa-pikevm" "nfa-thompson" "perf-inline" "perf-literal" "perf-literal-multisubstring" "perf-literal-substring" "std" "syntax" "unicode" "unicode-age" "unicode-bool" "unicode-case" "unicode-gencat" "unicode-perl" "unicode-script" "unicode-segment" "unicode-word-boundary" ];
      };
      "regex-syntax" = rec {
        crateName = "regex-syntax";
        version = "0.8.3";
        edition = "2021";
        sha256 = "0mhzkm1pkqg6y53xv056qciazlg47pq0czqs94cn302ckvi49bdd";
        authors = [
          "The Rust Project Developers"
          "Andrew Gallant <jamslam@gmail.com>"
        ];
        features = {
          "arbitrary" = [ "dep:arbitrary" ];
          "default" = [ "std" "unicode" ];
          "unicode" = [ "unicode-age" "unicode-bool" "unicode-case" "unicode-gencat" "unicode-perl" "unicode-script" "unicode-segment" ];
        };
        resolvedDefaultFeatures = [ "default" "std" "unicode" "unicode-age" "unicode-bool" "unicode-case" "unicode-gencat" "unicode-perl" "unicode-script" "unicode-segment" ];
      };
      "rfc6979 0.3.1" = rec {
        crateName = "rfc6979";
        version = "0.3.1";
        edition = "2021";
        sha256 = "1fzsp705b5lhwd2r9il9grc3lj6rm3b2r89vh0xv181gy5xg2hvp";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "crypto-bigint";
            packageId = "crypto-bigint 0.4.9";
            usesDefaultFeatures = false;
            features = [ "generic-array" "zeroize" ];
          }
          {
            name = "hmac";
            packageId = "hmac";
            usesDefaultFeatures = false;
            features = [ "reset" ];
          }
          {
            name = "zeroize";
            packageId = "zeroize";
            usesDefaultFeatures = false;
          }
        ];

      };
      "rfc6979 0.4.0" = rec {
        crateName = "rfc6979";
        version = "0.4.0";
        edition = "2021";
        sha256 = "1chw95jgcfrysyzsq6a10b1j5qb7bagkx8h0wda4lv25in02mpgq";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "hmac";
            packageId = "hmac";
            usesDefaultFeatures = false;
            features = [ "reset" ];
          }
          {
            name = "subtle";
            packageId = "subtle";
            usesDefaultFeatures = false;
          }
        ];

      };
      "rsa" = rec {
        crateName = "rsa";
        version = "0.7.2";
        edition = "2021";
        sha256 = "1709a7gcb2h4r95qyrkdz8nz3jb8k4hafj5q3ibfzg0c8zam4h09";
        authors = [
          "RustCrypto Developers"
          "dignifiedquire <dignifiedquire@gmail.com>"
        ];
        dependencies = [
          {
            name = "byteorder";
            packageId = "byteorder";
            usesDefaultFeatures = false;
          }
          {
            name = "digest";
            packageId = "digest";
            usesDefaultFeatures = false;
            features = [ "alloc" "oid" ];
          }
          {
            name = "num-bigint-dig";
            packageId = "num-bigint-dig";
            rename = "num-bigint";
            usesDefaultFeatures = false;
            features = [ "i128" "u64_digit" "prime" "zeroize" ];
          }
          {
            name = "num-integer";
            packageId = "num-integer";
            usesDefaultFeatures = false;
          }
          {
            name = "num-iter";
            packageId = "num-iter";
            usesDefaultFeatures = false;
          }
          {
            name = "num-traits";
            packageId = "num-traits";
            usesDefaultFeatures = false;
            features = [ "libm" ];
          }
          {
            name = "pkcs1";
            packageId = "pkcs1";
            usesDefaultFeatures = false;
            features = [ "pkcs8" "alloc" ];
          }
          {
            name = "pkcs8";
            packageId = "pkcs8 0.9.0";
            usesDefaultFeatures = false;
            features = [ "alloc" ];
          }
          {
            name = "rand_core";
            packageId = "rand_core";
            usesDefaultFeatures = false;
          }
          {
            name = "signature";
            packageId = "signature 1.6.4";
            usesDefaultFeatures = false;
            features = [ "digest-preview" "rand-preview" ];
          }
          {
            name = "smallvec";
            packageId = "smallvec";
            usesDefaultFeatures = false;
          }
          {
            name = "subtle";
            packageId = "subtle";
            usesDefaultFeatures = false;
          }
          {
            name = "zeroize";
            packageId = "zeroize";
            features = [ "alloc" ];
          }
        ];
        devDependencies = [
          {
            name = "rand_core";
            packageId = "rand_core";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "default" = [ "std" "pem" ];
          "getrandom" = [ "rand_core/getrandom" ];
          "hazmat" = [ "signature/hazmat-preview" ];
          "nightly" = [ "num-bigint/nightly" ];
          "pem" = [ "pkcs1/pem" "pkcs8/pem" ];
          "pkcs5" = [ "pkcs8/encryption" ];
          "serde" = [ "num-bigint/serde" "serde_crate" ];
          "serde_crate" = [ "dep:serde_crate" ];
          "std" = [ "digest/std" "pkcs1/std" "pkcs8/std" "rand_core/std" "signature/std" ];
        };
        resolvedDefaultFeatures = [ "default" "pem" "std" ];
      };
      "rustc-serialize" = rec {
        crateName = "rustc-serialize";
        version = "0.3.25";
        edition = "2015";
        sha256 = "00c494bsxjqjvc15h9x2nkgwl6bjdp9bmb9v0xs4ckv0h33lp0zy";
        authors = [
          "The Rust Project Developers"
        ];

      };
      "ryu" = rec {
        crateName = "ryu";
        version = "1.0.18";
        edition = "2018";
        sha256 = "17xx2s8j1lln7iackzd9p0sv546vjq71i779gphjq923vjh5pjzk";
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];
        features = {
          "no-panic" = [ "dep:no-panic" ];
        };
      };
      "same-file" = rec {
        crateName = "same-file";
        version = "1.0.6";
        edition = "2018";
        sha256 = "00h5j1w87dmhnvbv9l8bic3y7xxsnjmssvifw2ayvgx9mb1ivz4k";
        authors = [
          "Andrew Gallant <jamslam@gmail.com>"
        ];
        dependencies = [
          {
            name = "winapi-util";
            packageId = "winapi-util";
            target = { target, features }: (target."windows" or false);
          }
        ];

      };
      "sec1 0.3.0" = rec {
        crateName = "sec1";
        version = "0.3.0";
        edition = "2021";
        sha256 = "0a09lk5w3nyggpyz54m10nnlg9v8qbh6kw3v1bgla31988c4rqiv";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "base16ct";
            packageId = "base16ct 0.1.1";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "der";
            packageId = "der 0.6.1";
            optional = true;
            features = [ "oid" ];
          }
          {
            name = "generic-array";
            packageId = "generic-array";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "pkcs8";
            packageId = "pkcs8 0.9.0";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "subtle";
            packageId = "subtle";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "zeroize";
            packageId = "zeroize";
            optional = true;
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "alloc" = [ "der/alloc" "pkcs8/alloc" "zeroize/alloc" ];
          "base16ct" = [ "dep:base16ct" ];
          "default" = [ "der" "point" ];
          "der" = [ "dep:der" ];
          "generic-array" = [ "dep:generic-array" ];
          "pem" = [ "alloc" "der/pem" "pkcs8/pem" ];
          "pkcs8" = [ "dep:pkcs8" ];
          "point" = [ "base16ct" "generic-array" ];
          "serde" = [ "serdect" ];
          "serdect" = [ "dep:serdect" ];
          "std" = [ "der/std" "alloc" ];
          "subtle" = [ "dep:subtle" ];
          "zeroize" = [ "dep:zeroize" ];
        };
        resolvedDefaultFeatures = [ "alloc" "base16ct" "default" "der" "generic-array" "pem" "pkcs8" "point" "subtle" "zeroize" ];
      };
      "sec1 0.7.3" = rec {
        crateName = "sec1";
        version = "0.7.3";
        edition = "2021";
        sha256 = "1p273j8c87pid6a1iyyc7vxbvifrw55wbxgr0dh3l8vnbxb7msfk";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "base16ct";
            packageId = "base16ct 0.2.0";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "der";
            packageId = "der 0.7.9";
            optional = true;
            features = [ "oid" ];
          }
          {
            name = "generic-array";
            packageId = "generic-array";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "pkcs8";
            packageId = "pkcs8 0.10.2";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "subtle";
            packageId = "subtle";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "zeroize";
            packageId = "zeroize";
            optional = true;
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "alloc" = [ "der?/alloc" "pkcs8?/alloc" "zeroize?/alloc" ];
          "default" = [ "der" "point" ];
          "der" = [ "dep:der" "zeroize" ];
          "pem" = [ "alloc" "der/pem" "pkcs8/pem" ];
          "pkcs8" = [ "dep:pkcs8" ];
          "point" = [ "dep:base16ct" "dep:generic-array" ];
          "serde" = [ "dep:serdect" ];
          "std" = [ "alloc" "der?/std" ];
          "subtle" = [ "dep:subtle" ];
          "zeroize" = [ "dep:zeroize" "der?/zeroize" ];
        };
        resolvedDefaultFeatures = [ "alloc" "default" "der" "pem" "pkcs8" "point" "std" "subtle" "zeroize" ];
      };
      "serde" = rec {
        crateName = "serde";
        version = "1.0.203";
        edition = "2018";
        sha256 = "1500ghq198n6py5anvz5qbqagd9h1hq04f4qpsvjzrvix56snlvj";
        authors = [
          "Erick Tryzelaar <erick.tryzelaar@gmail.com>"
          "David Tolnay <dtolnay@gmail.com>"
        ];
        dependencies = [
          {
            name = "serde_derive";
            packageId = "serde_derive";
            optional = true;
          }
          {
            name = "serde_derive";
            packageId = "serde_derive";
            target = { target, features }: false;
          }
        ];
        devDependencies = [
          {
            name = "serde_derive";
            packageId = "serde_derive";
          }
        ];
        features = {
          "default" = [ "std" ];
          "derive" = [ "serde_derive" ];
          "serde_derive" = [ "dep:serde_derive" ];
        };
        resolvedDefaultFeatures = [ "default" "derive" "serde_derive" "std" ];
      };
      "serde_derive" = rec {
        crateName = "serde_derive";
        version = "1.0.203";
        edition = "2015";
        sha256 = "1fmmqmfza3mwxb1v80737dj01gznrh8mhgqgylkndx5npq7bq32h";
        procMacro = true;
        authors = [
          "Erick Tryzelaar <erick.tryzelaar@gmail.com>"
          "David Tolnay <dtolnay@gmail.com>"
        ];
        dependencies = [
          {
            name = "proc-macro2";
            packageId = "proc-macro2";
            usesDefaultFeatures = false;
            features = [ "proc-macro" ];
          }
          {
            name = "quote";
            packageId = "quote";
            usesDefaultFeatures = false;
            features = [ "proc-macro" ];
          }
          {
            name = "syn";
            packageId = "syn";
            usesDefaultFeatures = false;
            features = [ "clone-impls" "derive" "parsing" "printing" "proc-macro" ];
          }
        ];
        features = { };
        resolvedDefaultFeatures = [ "default" ];
      };
      "serde_json" = rec {
        crateName = "serde_json";
        version = "1.0.117";
        edition = "2021";
        sha256 = "1hxziifjlc0kn1cci9d4crmjc7qwnfi20lxwyj9lzca2c7m84la5";
        authors = [
          "Erick Tryzelaar <erick.tryzelaar@gmail.com>"
          "David Tolnay <dtolnay@gmail.com>"
        ];
        dependencies = [
          {
            name = "itoa";
            packageId = "itoa";
          }
          {
            name = "ryu";
            packageId = "ryu";
          }
          {
            name = "serde";
            packageId = "serde";
            usesDefaultFeatures = false;
          }
        ];
        devDependencies = [
          {
            name = "serde";
            packageId = "serde";
            features = [ "derive" ];
          }
        ];
        features = {
          "alloc" = [ "serde/alloc" ];
          "default" = [ "std" ];
          "indexmap" = [ "dep:indexmap" ];
          "preserve_order" = [ "indexmap" "std" ];
          "std" = [ "serde/std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "sha2" = rec {
        crateName = "sha2";
        version = "0.10.8";
        edition = "2018";
        sha256 = "1j1x78zk9il95w9iv46dh9wm73r6xrgj32y6lzzw7bxws9dbfgbr";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "cfg-if";
            packageId = "cfg-if";
          }
          {
            name = "cpufeatures";
            packageId = "cpufeatures";
            target = { target, features }: (("aarch64" == target."arch") || ("x86_64" == target."arch") || ("x86" == target."arch"));
          }
          {
            name = "digest";
            packageId = "digest";
          }
        ];
        devDependencies = [
          {
            name = "digest";
            packageId = "digest";
            features = [ "dev" ];
          }
        ];
        features = {
          "asm" = [ "sha2-asm" ];
          "asm-aarch64" = [ "asm" ];
          "default" = [ "std" ];
          "oid" = [ "digest/oid" ];
          "sha2-asm" = [ "dep:sha2-asm" ];
          "std" = [ "digest/std" ];
        };
      };
      "signature 1.6.4" = rec {
        crateName = "signature";
        version = "1.6.4";
        edition = "2021";
        sha256 = "0z3xg405pg827g6hfdprnszsdqkkbrsfx7f1dl04nv9g7cxks8vl";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "digest";
            packageId = "digest";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "rand_core";
            packageId = "rand_core";
            optional = true;
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "default" = [ "std" ];
          "derive-preview" = [ "digest-preview" "signature_derive" ];
          "digest" = [ "dep:digest" ];
          "digest-preview" = [ "digest" ];
          "rand-preview" = [ "rand_core" ];
          "rand_core" = [ "dep:rand_core" ];
          "signature_derive" = [ "dep:signature_derive" ];
        };
        resolvedDefaultFeatures = [ "digest" "digest-preview" "rand-preview" "rand_core" "std" ];
      };
      "signature 2.0.0" = rec {
        crateName = "signature";
        version = "2.0.0";
        edition = "2021";
        sha256 = "0zg534qaa8cl5spq8d0rs0jq6km4w9vil69148awiy9khg4mir4g";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "digest";
            packageId = "digest";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "rand_core";
            packageId = "rand_core";
            optional = true;
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "derive" = [ "dep:derive" ];
          "digest" = [ "dep:digest" ];
          "rand_core" = [ "dep:rand_core" ];
          "std" = [ "alloc" ];
        };
        resolvedDefaultFeatures = [ "alloc" "digest" "rand_core" "std" ];
      };
      "smallvec" = rec {
        crateName = "smallvec";
        version = "1.13.2";
        edition = "2018";
        sha256 = "0rsw5samawl3wsw6glrsb127rx6sh89a8wyikicw6dkdcjd1lpiw";
        authors = [
          "The Servo Project Developers"
        ];
        features = {
          "arbitrary" = [ "dep:arbitrary" ];
          "const_new" = [ "const_generics" ];
          "drain_keep_rest" = [ "drain_filter" ];
          "serde" = [ "dep:serde" ];
        };
      };
      "sodiumoxide" = rec {
        crateName = "sodiumoxide";
        version = "0.2.7";
        edition = "2015";
        sha256 = "0a00rcp2vphrs8qh0477rzs6lhsng1m5i0l4qamagnf2nsnf6sz2";
        authors = [
          "dnaq"
        ];
        dependencies = [
          {
            name = "ed25519";
            packageId = "ed25519";
            usesDefaultFeatures = false;
          }
          {
            name = "libc";
            packageId = "libc";
            usesDefaultFeatures = false;
          }
          {
            name = "libsodium-sys";
            packageId = "libsodium-sys";
          }
          {
            name = "serde";
            packageId = "serde";
            optional = true;
            usesDefaultFeatures = false;
          }
        ];
        devDependencies = [
          {
            name = "serde";
            packageId = "serde";
          }
        ];
        features = {
          "default" = [ "serde" "std" ];
          "serde" = [ "dep:serde" ];
          "use-pkg-config" = [ "libsodium-sys/use-pkg-config" ];
        };
        resolvedDefaultFeatures = [ "default" "serde" "std" ];
      };
      "spin" = rec {
        crateName = "spin";
        version = "0.5.2";
        edition = "2015";
        sha256 = "0b84m6dbzrwf2kxylnw82d3dr8w06av7rfkr8s85fb5f43rwyqvf";
        authors = [
          "Mathijs van de Nes <git@mathijs.vd-nes.nl>"
          "John Ericson <git@JohnEricson.me>"
        ];

      };
      "spki 0.6.0" = rec {
        crateName = "spki";
        version = "0.6.0";
        edition = "2021";
        sha256 = "0ar1ldkl7svp8l3gfw2hyiiph7n2nqynjnjgdv1pscvsmjxh5kv7";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "base64ct";
            packageId = "base64ct";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "der";
            packageId = "der 0.6.1";
            features = [ "oid" ];
          }
        ];
        features = {
          "alloc" = [ "base64ct/alloc" "der/alloc" ];
          "base64ct" = [ "dep:base64ct" ];
          "fingerprint" = [ "sha2" ];
          "pem" = [ "alloc" "der/pem" ];
          "sha2" = [ "dep:sha2" ];
          "std" = [ "der/std" "alloc" ];
        };
        resolvedDefaultFeatures = [ "alloc" "base64ct" "pem" "std" ];
      };
      "spki 0.7.3" = rec {
        crateName = "spki";
        version = "0.7.3";
        edition = "2021";
        sha256 = "17fj8k5fmx4w9mp27l970clrh5qa7r5sjdvbsln987xhb34dc7nr";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "base64ct";
            packageId = "base64ct";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "der";
            packageId = "der 0.7.9";
            features = [ "oid" ];
          }
        ];
        features = {
          "alloc" = [ "base64ct?/alloc" "der/alloc" ];
          "arbitrary" = [ "std" "dep:arbitrary" "der/arbitrary" ];
          "base64" = [ "dep:base64ct" ];
          "fingerprint" = [ "sha2" ];
          "pem" = [ "alloc" "der/pem" ];
          "sha2" = [ "dep:sha2" ];
          "std" = [ "der/std" "alloc" ];
        };
        resolvedDefaultFeatures = [ "alloc" "pem" "std" ];
      };
      "subtle" = rec {
        crateName = "subtle";
        version = "2.5.0";
        edition = "2018";
        sha256 = "1g2yjs7gffgmdvkkq0wrrh0pxds3q0dv6dhkw9cdpbib656xdkc1";
        authors = [
          "Isis Lovecruft <isis@patternsinthevoid.net>"
          "Henry de Valence <hdevalence@hdevalence.ca>"
        ];
        features = {
          "default" = [ "std" "i128" ];
        };
        resolvedDefaultFeatures = [ "i128" ];
      };
      "syn" = rec {
        crateName = "syn";
        version = "2.0.66";
        edition = "2021";
        sha256 = "1xfgrprsbz8j31kabvfinb4fyhajlk2q7lxa18fb006yl90kyby4";
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];
        dependencies = [
          {
            name = "proc-macro2";
            packageId = "proc-macro2";
            usesDefaultFeatures = false;
          }
          {
            name = "quote";
            packageId = "quote";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "unicode-ident";
            packageId = "unicode-ident";
          }
        ];
        features = {
          "default" = [ "derive" "parsing" "printing" "clone-impls" "proc-macro" ];
          "printing" = [ "dep:quote" ];
          "proc-macro" = [ "proc-macro2/proc-macro" "quote?/proc-macro" ];
          "test" = [ "syn-test-suite/all-features" ];
        };
        resolvedDefaultFeatures = [ "clone-impls" "default" "derive" "full" "parsing" "printing" "proc-macro" "visit" ];
      };
      "thiserror" = rec {
        crateName = "thiserror";
        version = "1.0.61";
        edition = "2021";
        sha256 = "028prh962l16cmjivwb1g9xalbpqip0305zhq006mg74dc6whin5";
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];
        dependencies = [
          {
            name = "thiserror-impl";
            packageId = "thiserror-impl";
          }
        ];

      };
      "thiserror-impl" = rec {
        crateName = "thiserror-impl";
        version = "1.0.61";
        edition = "2021";
        sha256 = "0cvm37hp0kbcyk1xac1z0chpbd9pbn2g456iyid6sah0a113ihs6";
        procMacro = true;
        libName = "thiserror_impl";
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];
        dependencies = [
          {
            name = "proc-macro2";
            packageId = "proc-macro2";
          }
          {
            name = "quote";
            packageId = "quote";
          }
          {
            name = "syn";
            packageId = "syn";
          }
        ];

      };
      "typenum" = rec {
        crateName = "typenum";
        version = "1.17.0";
        edition = "2018";
        sha256 = "09dqxv69m9lj9zvv6xw5vxaqx15ps0vxyy5myg33i0kbqvq0pzs2";
        build = "build/main.rs";
        authors = [
          "Paho Lurie-Gregg <paho@paholg.com>"
          "Andre Bogus <bogusandre@gmail.com>"
        ];
        features = {
          "scale-info" = [ "dep:scale-info" ];
          "scale_info" = [ "scale-info/derive" ];
        };
      };
      "unicode-ident" = rec {
        crateName = "unicode-ident";
        version = "1.0.12";
        edition = "2018";
        sha256 = "0jzf1znfpb2gx8nr8mvmyqs1crnv79l57nxnbiszc7xf7ynbjm1k";
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];

      };
      "version_check" = rec {
        crateName = "version_check";
        version = "0.9.4";
        edition = "2015";
        sha256 = "0gs8grwdlgh0xq660d7wr80x14vxbizmd8dbp29p2pdncx8lp1s9";
        authors = [
          "Sergio Benitez <sb@sergio.bz>"
        ];

      };
      "walkdir" = rec {
        crateName = "walkdir";
        version = "2.5.0";
        edition = "2018";
        sha256 = "0jsy7a710qv8gld5957ybrnc07gavppp963gs32xk4ag8130jy99";
        authors = [
          "Andrew Gallant <jamslam@gmail.com>"
        ];
        dependencies = [
          {
            name = "same-file";
            packageId = "same-file";
          }
          {
            name = "winapi-util";
            packageId = "winapi-util";
            target = { target, features }: (target."windows" or false);
          }
        ];

      };
      "wasi" = rec {
        crateName = "wasi";
        version = "0.11.0+wasi-snapshot-preview1";
        edition = "2018";
        sha256 = "08z4hxwkpdpalxjps1ai9y7ihin26y9f476i53dv98v45gkqg3cw";
        authors = [
          "The Cranelift Project Developers"
        ];
        features = {
          "compiler_builtins" = [ "dep:compiler_builtins" ];
          "core" = [ "dep:core" ];
          "default" = [ "std" ];
          "rustc-dep-of-std" = [ "compiler_builtins" "core" "rustc-std-workspace-alloc" ];
          "rustc-std-workspace-alloc" = [ "dep:rustc-std-workspace-alloc" ];
        };
        resolvedDefaultFeatures = [ "std" ];
      };
      "wasix" = rec {
        crateName = "wasix";
        version = "0.12.21";
        edition = "2018";
        sha256 = "0v9wb03ddbnas75005l2d63bdqy9mclds00b1qbw385wkgpv9yy1";
        authors = [
          "The Cranelift Project Developers"
          "john-sharratt"
        ];
        dependencies = [
          {
            name = "wasi";
            packageId = "wasi";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "compiler_builtins" = [ "dep:compiler_builtins" ];
          "core" = [ "dep:core" ];
          "default" = [ "std" ];
          "rustc-dep-of-std" = [ "compiler_builtins" "core" "rustc-std-workspace-alloc" "wasi/rustc-dep-of-std" ];
          "rustc-std-workspace-alloc" = [ "dep:rustc-std-workspace-alloc" ];
          "std" = [ "wasi/std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "wasm-bindgen" = rec {
        crateName = "wasm-bindgen";
        version = "0.2.92";
        edition = "2018";
        sha256 = "1a4mcw13nsk3fr8fxjzf9kk1wj88xkfsmnm0pjraw01ryqfm7qjb";
        authors = [
          "The wasm-bindgen Developers"
        ];
        dependencies = [
          {
            name = "cfg-if";
            packageId = "cfg-if";
          }
          {
            name = "wasm-bindgen-macro";
            packageId = "wasm-bindgen-macro";
          }
        ];
        features = {
          "default" = [ "spans" "std" ];
          "enable-interning" = [ "std" ];
          "gg-alloc" = [ "wasm-bindgen-test/gg-alloc" ];
          "serde" = [ "dep:serde" ];
          "serde-serialize" = [ "serde" "serde_json" "std" ];
          "serde_json" = [ "dep:serde_json" ];
          "spans" = [ "wasm-bindgen-macro/spans" ];
          "strict-macro" = [ "wasm-bindgen-macro/strict-macro" ];
          "xxx_debug_only_print_generated_code" = [ "wasm-bindgen-macro/xxx_debug_only_print_generated_code" ];
        };
        resolvedDefaultFeatures = [ "default" "spans" "std" ];
      };
      "wasm-bindgen-backend" = rec {
        crateName = "wasm-bindgen-backend";
        version = "0.2.92";
        edition = "2018";
        sha256 = "1nj7wxbi49f0rw9d44rjzms26xlw6r76b2mrggx8jfbdjrxphkb1";
        authors = [
          "The wasm-bindgen Developers"
        ];
        dependencies = [
          {
            name = "bumpalo";
            packageId = "bumpalo";
          }
          {
            name = "log";
            packageId = "log";
          }
          {
            name = "once_cell";
            packageId = "once_cell";
          }
          {
            name = "proc-macro2";
            packageId = "proc-macro2";
          }
          {
            name = "quote";
            packageId = "quote";
          }
          {
            name = "syn";
            packageId = "syn";
            features = [ "full" ];
          }
          {
            name = "wasm-bindgen-shared";
            packageId = "wasm-bindgen-shared";
          }
        ];
        features = {
          "extra-traits" = [ "syn/extra-traits" ];
        };
        resolvedDefaultFeatures = [ "spans" ];
      };
      "wasm-bindgen-macro" = rec {
        crateName = "wasm-bindgen-macro";
        version = "0.2.92";
        edition = "2018";
        sha256 = "09npa1srjjabd6nfph5yc03jb26sycjlxhy0c2a1pdrpx4yq5y51";
        procMacro = true;
        authors = [
          "The wasm-bindgen Developers"
        ];
        dependencies = [
          {
            name = "quote";
            packageId = "quote";
          }
          {
            name = "wasm-bindgen-macro-support";
            packageId = "wasm-bindgen-macro-support";
          }
        ];
        features = {
          "spans" = [ "wasm-bindgen-macro-support/spans" ];
          "strict-macro" = [ "wasm-bindgen-macro-support/strict-macro" ];
        };
        resolvedDefaultFeatures = [ "spans" ];
      };
      "wasm-bindgen-macro-support" = rec {
        crateName = "wasm-bindgen-macro-support";
        version = "0.2.92";
        edition = "2018";
        sha256 = "1dqv2xs8zcyw4kjgzj84bknp2h76phmsb3n7j6hn396h4ssifkz9";
        authors = [
          "The wasm-bindgen Developers"
        ];
        dependencies = [
          {
            name = "proc-macro2";
            packageId = "proc-macro2";
          }
          {
            name = "quote";
            packageId = "quote";
          }
          {
            name = "syn";
            packageId = "syn";
            features = [ "visit" "full" ];
          }
          {
            name = "wasm-bindgen-backend";
            packageId = "wasm-bindgen-backend";
          }
          {
            name = "wasm-bindgen-shared";
            packageId = "wasm-bindgen-shared";
          }
        ];
        features = {
          "extra-traits" = [ "syn/extra-traits" ];
          "spans" = [ "wasm-bindgen-backend/spans" ];
        };
        resolvedDefaultFeatures = [ "spans" ];
      };
      "wasm-bindgen-shared" = rec {
        crateName = "wasm-bindgen-shared";
        version = "0.2.92";
        edition = "2018";
        sha256 = "15kyavsrna2cvy30kg03va257fraf9x00ny554vxngvpyaa0q6dg";
        authors = [
          "The wasm-bindgen Developers"
        ];

      };
      "winapi-util" = rec {
        crateName = "winapi-util";
        version = "0.1.8";
        edition = "2021";
        sha256 = "0svcgddd2rw06mj4r76gj655qsa1ikgz3d3gzax96fz7w62c6k2d";
        authors = [
          "Andrew Gallant <jamslam@gmail.com>"
        ];
        dependencies = [
          {
            name = "windows-sys";
            packageId = "windows-sys";
            target = { target, features }: (target."windows" or false);
            features = [ "Win32_Foundation" "Win32_Storage_FileSystem" "Win32_System_Console" "Win32_System_SystemInformation" ];
          }
        ];

      };
      "windows-sys" = rec {
        crateName = "windows-sys";
        version = "0.52.0";
        edition = "2021";
        sha256 = "0gd3v4ji88490zgb6b5mq5zgbvwv7zx1ibn8v3x83rwcdbryaar8";
        authors = [
          "Microsoft"
        ];
        dependencies = [
          {
            name = "windows-targets";
            packageId = "windows-targets";
          }
        ];
        features = {
          "Wdk_Foundation" = [ "Wdk" ];
          "Wdk_Graphics" = [ "Wdk" ];
          "Wdk_Graphics_Direct3D" = [ "Wdk_Graphics" ];
          "Wdk_Storage" = [ "Wdk" ];
          "Wdk_Storage_FileSystem" = [ "Wdk_Storage" ];
          "Wdk_Storage_FileSystem_Minifilters" = [ "Wdk_Storage_FileSystem" ];
          "Wdk_System" = [ "Wdk" ];
          "Wdk_System_IO" = [ "Wdk_System" ];
          "Wdk_System_OfflineRegistry" = [ "Wdk_System" ];
          "Wdk_System_Registry" = [ "Wdk_System" ];
          "Wdk_System_SystemInformation" = [ "Wdk_System" ];
          "Wdk_System_SystemServices" = [ "Wdk_System" ];
          "Wdk_System_Threading" = [ "Wdk_System" ];
          "Win32_Data" = [ "Win32" ];
          "Win32_Data_HtmlHelp" = [ "Win32_Data" ];
          "Win32_Data_RightsManagement" = [ "Win32_Data" ];
          "Win32_Devices" = [ "Win32" ];
          "Win32_Devices_AllJoyn" = [ "Win32_Devices" ];
          "Win32_Devices_BiometricFramework" = [ "Win32_Devices" ];
          "Win32_Devices_Bluetooth" = [ "Win32_Devices" ];
          "Win32_Devices_Communication" = [ "Win32_Devices" ];
          "Win32_Devices_DeviceAndDriverInstallation" = [ "Win32_Devices" ];
          "Win32_Devices_DeviceQuery" = [ "Win32_Devices" ];
          "Win32_Devices_Display" = [ "Win32_Devices" ];
          "Win32_Devices_Enumeration" = [ "Win32_Devices" ];
          "Win32_Devices_Enumeration_Pnp" = [ "Win32_Devices_Enumeration" ];
          "Win32_Devices_Fax" = [ "Win32_Devices" ];
          "Win32_Devices_HumanInterfaceDevice" = [ "Win32_Devices" ];
          "Win32_Devices_PortableDevices" = [ "Win32_Devices" ];
          "Win32_Devices_Properties" = [ "Win32_Devices" ];
          "Win32_Devices_Pwm" = [ "Win32_Devices" ];
          "Win32_Devices_Sensors" = [ "Win32_Devices" ];
          "Win32_Devices_SerialCommunication" = [ "Win32_Devices" ];
          "Win32_Devices_Tapi" = [ "Win32_Devices" ];
          "Win32_Devices_Usb" = [ "Win32_Devices" ];
          "Win32_Devices_WebServicesOnDevices" = [ "Win32_Devices" ];
          "Win32_Foundation" = [ "Win32" ];
          "Win32_Gaming" = [ "Win32" ];
          "Win32_Globalization" = [ "Win32" ];
          "Win32_Graphics" = [ "Win32" ];
          "Win32_Graphics_Dwm" = [ "Win32_Graphics" ];
          "Win32_Graphics_Gdi" = [ "Win32_Graphics" ];
          "Win32_Graphics_GdiPlus" = [ "Win32_Graphics" ];
          "Win32_Graphics_Hlsl" = [ "Win32_Graphics" ];
          "Win32_Graphics_OpenGL" = [ "Win32_Graphics" ];
          "Win32_Graphics_Printing" = [ "Win32_Graphics" ];
          "Win32_Graphics_Printing_PrintTicket" = [ "Win32_Graphics_Printing" ];
          "Win32_Management" = [ "Win32" ];
          "Win32_Management_MobileDeviceManagementRegistration" = [ "Win32_Management" ];
          "Win32_Media" = [ "Win32" ];
          "Win32_Media_Audio" = [ "Win32_Media" ];
          "Win32_Media_DxMediaObjects" = [ "Win32_Media" ];
          "Win32_Media_KernelStreaming" = [ "Win32_Media" ];
          "Win32_Media_Multimedia" = [ "Win32_Media" ];
          "Win32_Media_Streaming" = [ "Win32_Media" ];
          "Win32_Media_WindowsMediaFormat" = [ "Win32_Media" ];
          "Win32_NetworkManagement" = [ "Win32" ];
          "Win32_NetworkManagement_Dhcp" = [ "Win32_NetworkManagement" ];
          "Win32_NetworkManagement_Dns" = [ "Win32_NetworkManagement" ];
          "Win32_NetworkManagement_InternetConnectionWizard" = [ "Win32_NetworkManagement" ];
          "Win32_NetworkManagement_IpHelper" = [ "Win32_NetworkManagement" ];
          "Win32_NetworkManagement_Multicast" = [ "Win32_NetworkManagement" ];
          "Win32_NetworkManagement_Ndis" = [ "Win32_NetworkManagement" ];
          "Win32_NetworkManagement_NetBios" = [ "Win32_NetworkManagement" ];
          "Win32_NetworkManagement_NetManagement" = [ "Win32_NetworkManagement" ];
          "Win32_NetworkManagement_NetShell" = [ "Win32_NetworkManagement" ];
          "Win32_NetworkManagement_NetworkDiagnosticsFramework" = [ "Win32_NetworkManagement" ];
          "Win32_NetworkManagement_P2P" = [ "Win32_NetworkManagement" ];
          "Win32_NetworkManagement_QoS" = [ "Win32_NetworkManagement" ];
          "Win32_NetworkManagement_Rras" = [ "Win32_NetworkManagement" ];
          "Win32_NetworkManagement_Snmp" = [ "Win32_NetworkManagement" ];
          "Win32_NetworkManagement_WNet" = [ "Win32_NetworkManagement" ];
          "Win32_NetworkManagement_WebDav" = [ "Win32_NetworkManagement" ];
          "Win32_NetworkManagement_WiFi" = [ "Win32_NetworkManagement" ];
          "Win32_NetworkManagement_WindowsConnectionManager" = [ "Win32_NetworkManagement" ];
          "Win32_NetworkManagement_WindowsFilteringPlatform" = [ "Win32_NetworkManagement" ];
          "Win32_NetworkManagement_WindowsFirewall" = [ "Win32_NetworkManagement" ];
          "Win32_NetworkManagement_WindowsNetworkVirtualization" = [ "Win32_NetworkManagement" ];
          "Win32_Networking" = [ "Win32" ];
          "Win32_Networking_ActiveDirectory" = [ "Win32_Networking" ];
          "Win32_Networking_Clustering" = [ "Win32_Networking" ];
          "Win32_Networking_HttpServer" = [ "Win32_Networking" ];
          "Win32_Networking_Ldap" = [ "Win32_Networking" ];
          "Win32_Networking_WebSocket" = [ "Win32_Networking" ];
          "Win32_Networking_WinHttp" = [ "Win32_Networking" ];
          "Win32_Networking_WinInet" = [ "Win32_Networking" ];
          "Win32_Networking_WinSock" = [ "Win32_Networking" ];
          "Win32_Networking_WindowsWebServices" = [ "Win32_Networking" ];
          "Win32_Security" = [ "Win32" ];
          "Win32_Security_AppLocker" = [ "Win32_Security" ];
          "Win32_Security_Authentication" = [ "Win32_Security" ];
          "Win32_Security_Authentication_Identity" = [ "Win32_Security_Authentication" ];
          "Win32_Security_Authorization" = [ "Win32_Security" ];
          "Win32_Security_Credentials" = [ "Win32_Security" ];
          "Win32_Security_Cryptography" = [ "Win32_Security" ];
          "Win32_Security_Cryptography_Catalog" = [ "Win32_Security_Cryptography" ];
          "Win32_Security_Cryptography_Certificates" = [ "Win32_Security_Cryptography" ];
          "Win32_Security_Cryptography_Sip" = [ "Win32_Security_Cryptography" ];
          "Win32_Security_Cryptography_UI" = [ "Win32_Security_Cryptography" ];
          "Win32_Security_DiagnosticDataQuery" = [ "Win32_Security" ];
          "Win32_Security_DirectoryServices" = [ "Win32_Security" ];
          "Win32_Security_EnterpriseData" = [ "Win32_Security" ];
          "Win32_Security_ExtensibleAuthenticationProtocol" = [ "Win32_Security" ];
          "Win32_Security_Isolation" = [ "Win32_Security" ];
          "Win32_Security_LicenseProtection" = [ "Win32_Security" ];
          "Win32_Security_NetworkAccessProtection" = [ "Win32_Security" ];
          "Win32_Security_WinTrust" = [ "Win32_Security" ];
          "Win32_Security_WinWlx" = [ "Win32_Security" ];
          "Win32_Storage" = [ "Win32" ];
          "Win32_Storage_Cabinets" = [ "Win32_Storage" ];
          "Win32_Storage_CloudFilters" = [ "Win32_Storage" ];
          "Win32_Storage_Compression" = [ "Win32_Storage" ];
          "Win32_Storage_DistributedFileSystem" = [ "Win32_Storage" ];
          "Win32_Storage_FileHistory" = [ "Win32_Storage" ];
          "Win32_Storage_FileSystem" = [ "Win32_Storage" ];
          "Win32_Storage_Imapi" = [ "Win32_Storage" ];
          "Win32_Storage_IndexServer" = [ "Win32_Storage" ];
          "Win32_Storage_InstallableFileSystems" = [ "Win32_Storage" ];
          "Win32_Storage_IscsiDisc" = [ "Win32_Storage" ];
          "Win32_Storage_Jet" = [ "Win32_Storage" ];
          "Win32_Storage_Nvme" = [ "Win32_Storage" ];
          "Win32_Storage_OfflineFiles" = [ "Win32_Storage" ];
          "Win32_Storage_OperationRecorder" = [ "Win32_Storage" ];
          "Win32_Storage_Packaging" = [ "Win32_Storage" ];
          "Win32_Storage_Packaging_Appx" = [ "Win32_Storage_Packaging" ];
          "Win32_Storage_ProjectedFileSystem" = [ "Win32_Storage" ];
          "Win32_Storage_StructuredStorage" = [ "Win32_Storage" ];
          "Win32_Storage_Vhd" = [ "Win32_Storage" ];
          "Win32_Storage_Xps" = [ "Win32_Storage" ];
          "Win32_System" = [ "Win32" ];
          "Win32_System_AddressBook" = [ "Win32_System" ];
          "Win32_System_Antimalware" = [ "Win32_System" ];
          "Win32_System_ApplicationInstallationAndServicing" = [ "Win32_System" ];
          "Win32_System_ApplicationVerifier" = [ "Win32_System" ];
          "Win32_System_ClrHosting" = [ "Win32_System" ];
          "Win32_System_Com" = [ "Win32_System" ];
          "Win32_System_Com_Marshal" = [ "Win32_System_Com" ];
          "Win32_System_Com_StructuredStorage" = [ "Win32_System_Com" ];
          "Win32_System_Com_Urlmon" = [ "Win32_System_Com" ];
          "Win32_System_ComponentServices" = [ "Win32_System" ];
          "Win32_System_Console" = [ "Win32_System" ];
          "Win32_System_CorrelationVector" = [ "Win32_System" ];
          "Win32_System_DataExchange" = [ "Win32_System" ];
          "Win32_System_DeploymentServices" = [ "Win32_System" ];
          "Win32_System_DeveloperLicensing" = [ "Win32_System" ];
          "Win32_System_Diagnostics" = [ "Win32_System" ];
          "Win32_System_Diagnostics_Ceip" = [ "Win32_System_Diagnostics" ];
          "Win32_System_Diagnostics_Debug" = [ "Win32_System_Diagnostics" ];
          "Win32_System_Diagnostics_Debug_Extensions" = [ "Win32_System_Diagnostics_Debug" ];
          "Win32_System_Diagnostics_Etw" = [ "Win32_System_Diagnostics" ];
          "Win32_System_Diagnostics_ProcessSnapshotting" = [ "Win32_System_Diagnostics" ];
          "Win32_System_Diagnostics_ToolHelp" = [ "Win32_System_Diagnostics" ];
          "Win32_System_DistributedTransactionCoordinator" = [ "Win32_System" ];
          "Win32_System_Environment" = [ "Win32_System" ];
          "Win32_System_ErrorReporting" = [ "Win32_System" ];
          "Win32_System_EventCollector" = [ "Win32_System" ];
          "Win32_System_EventLog" = [ "Win32_System" ];
          "Win32_System_EventNotificationService" = [ "Win32_System" ];
          "Win32_System_GroupPolicy" = [ "Win32_System" ];
          "Win32_System_HostCompute" = [ "Win32_System" ];
          "Win32_System_HostComputeNetwork" = [ "Win32_System" ];
          "Win32_System_HostComputeSystem" = [ "Win32_System" ];
          "Win32_System_Hypervisor" = [ "Win32_System" ];
          "Win32_System_IO" = [ "Win32_System" ];
          "Win32_System_Iis" = [ "Win32_System" ];
          "Win32_System_Ioctl" = [ "Win32_System" ];
          "Win32_System_JobObjects" = [ "Win32_System" ];
          "Win32_System_Js" = [ "Win32_System" ];
          "Win32_System_Kernel" = [ "Win32_System" ];
          "Win32_System_LibraryLoader" = [ "Win32_System" ];
          "Win32_System_Mailslots" = [ "Win32_System" ];
          "Win32_System_Mapi" = [ "Win32_System" ];
          "Win32_System_Memory" = [ "Win32_System" ];
          "Win32_System_Memory_NonVolatile" = [ "Win32_System_Memory" ];
          "Win32_System_MessageQueuing" = [ "Win32_System" ];
          "Win32_System_MixedReality" = [ "Win32_System" ];
          "Win32_System_Ole" = [ "Win32_System" ];
          "Win32_System_PasswordManagement" = [ "Win32_System" ];
          "Win32_System_Performance" = [ "Win32_System" ];
          "Win32_System_Performance_HardwareCounterProfiling" = [ "Win32_System_Performance" ];
          "Win32_System_Pipes" = [ "Win32_System" ];
          "Win32_System_Power" = [ "Win32_System" ];
          "Win32_System_ProcessStatus" = [ "Win32_System" ];
          "Win32_System_Recovery" = [ "Win32_System" ];
          "Win32_System_Registry" = [ "Win32_System" ];
          "Win32_System_RemoteDesktop" = [ "Win32_System" ];
          "Win32_System_RemoteManagement" = [ "Win32_System" ];
          "Win32_System_RestartManager" = [ "Win32_System" ];
          "Win32_System_Restore" = [ "Win32_System" ];
          "Win32_System_Rpc" = [ "Win32_System" ];
          "Win32_System_Search" = [ "Win32_System" ];
          "Win32_System_Search_Common" = [ "Win32_System_Search" ];
          "Win32_System_SecurityCenter" = [ "Win32_System" ];
          "Win32_System_Services" = [ "Win32_System" ];
          "Win32_System_SetupAndMigration" = [ "Win32_System" ];
          "Win32_System_Shutdown" = [ "Win32_System" ];
          "Win32_System_StationsAndDesktops" = [ "Win32_System" ];
          "Win32_System_SubsystemForLinux" = [ "Win32_System" ];
          "Win32_System_SystemInformation" = [ "Win32_System" ];
          "Win32_System_SystemServices" = [ "Win32_System" ];
          "Win32_System_Threading" = [ "Win32_System" ];
          "Win32_System_Time" = [ "Win32_System" ];
          "Win32_System_TpmBaseServices" = [ "Win32_System" ];
          "Win32_System_UserAccessLogging" = [ "Win32_System" ];
          "Win32_System_Variant" = [ "Win32_System" ];
          "Win32_System_VirtualDosMachines" = [ "Win32_System" ];
          "Win32_System_WindowsProgramming" = [ "Win32_System" ];
          "Win32_System_Wmi" = [ "Win32_System" ];
          "Win32_UI" = [ "Win32" ];
          "Win32_UI_Accessibility" = [ "Win32_UI" ];
          "Win32_UI_ColorSystem" = [ "Win32_UI" ];
          "Win32_UI_Controls" = [ "Win32_UI" ];
          "Win32_UI_Controls_Dialogs" = [ "Win32_UI_Controls" ];
          "Win32_UI_HiDpi" = [ "Win32_UI" ];
          "Win32_UI_Input" = [ "Win32_UI" ];
          "Win32_UI_Input_Ime" = [ "Win32_UI_Input" ];
          "Win32_UI_Input_KeyboardAndMouse" = [ "Win32_UI_Input" ];
          "Win32_UI_Input_Pointer" = [ "Win32_UI_Input" ];
          "Win32_UI_Input_Touch" = [ "Win32_UI_Input" ];
          "Win32_UI_Input_XboxController" = [ "Win32_UI_Input" ];
          "Win32_UI_InteractionContext" = [ "Win32_UI" ];
          "Win32_UI_Magnification" = [ "Win32_UI" ];
          "Win32_UI_Shell" = [ "Win32_UI" ];
          "Win32_UI_Shell_PropertiesSystem" = [ "Win32_UI_Shell" ];
          "Win32_UI_TabletPC" = [ "Win32_UI" ];
          "Win32_UI_TextServices" = [ "Win32_UI" ];
          "Win32_UI_WindowsAndMessaging" = [ "Win32_UI" ];
          "Win32_Web" = [ "Win32" ];
          "Win32_Web_InternetExplorer" = [ "Win32_Web" ];
        };
        resolvedDefaultFeatures = [ "Win32" "Win32_Foundation" "Win32_Storage" "Win32_Storage_FileSystem" "Win32_System" "Win32_System_Console" "Win32_System_SystemInformation" "default" ];
      };
      "windows-targets" = rec {
        crateName = "windows-targets";
        version = "0.52.5";
        edition = "2021";
        sha256 = "1sz7jrnkygmmlj1ia8fk85wbyil450kq5qkh5qh9sh2rcnj161vg";
        authors = [
          "Microsoft"
        ];
        dependencies = [
          {
            name = "windows_aarch64_gnullvm";
            packageId = "windows_aarch64_gnullvm";
            target = { target, features }: (pkgs.rust.lib.toRustTarget stdenv.hostPlatform == "aarch64-pc-windows-gnullvm");
          }
          {
            name = "windows_aarch64_msvc";
            packageId = "windows_aarch64_msvc";
            target = { target, features }: (("aarch64" == target."arch") && ("msvc" == target."env") && (!(target."windows_raw_dylib" or false)));
          }
          {
            name = "windows_i686_gnu";
            packageId = "windows_i686_gnu";
            target = { target, features }: (("x86" == target."arch") && ("gnu" == target."env") && (!("llvm" == target."abi")) && (!(target."windows_raw_dylib" or false)));
          }
          {
            name = "windows_i686_gnullvm";
            packageId = "windows_i686_gnullvm";
            target = { target, features }: (pkgs.rust.lib.toRustTarget stdenv.hostPlatform == "i686-pc-windows-gnullvm");
          }
          {
            name = "windows_i686_msvc";
            packageId = "windows_i686_msvc";
            target = { target, features }: (("x86" == target."arch") && ("msvc" == target."env") && (!(target."windows_raw_dylib" or false)));
          }
          {
            name = "windows_x86_64_gnu";
            packageId = "windows_x86_64_gnu";
            target = { target, features }: (("x86_64" == target."arch") && ("gnu" == target."env") && (!("llvm" == target."abi")) && (!(target."windows_raw_dylib" or false)));
          }
          {
            name = "windows_x86_64_gnullvm";
            packageId = "windows_x86_64_gnullvm";
            target = { target, features }: (pkgs.rust.lib.toRustTarget stdenv.hostPlatform == "x86_64-pc-windows-gnullvm");
          }
          {
            name = "windows_x86_64_msvc";
            packageId = "windows_x86_64_msvc";
            target = { target, features }: ((("x86_64" == target."arch") || ("arm64ec" == target."arch")) && ("msvc" == target."env") && (!(target."windows_raw_dylib" or false)));
          }
        ];

      };
      "windows_aarch64_gnullvm" = rec {
        crateName = "windows_aarch64_gnullvm";
        version = "0.52.5";
        edition = "2021";
        sha256 = "0qrjimbj67nnyn7zqy15mzzmqg0mn5gsr2yciqjxm3cb3vbyx23h";
        authors = [
          "Microsoft"
        ];

      };
      "windows_aarch64_msvc" = rec {
        crateName = "windows_aarch64_msvc";
        version = "0.52.5";
        edition = "2021";
        sha256 = "1dmga8kqlmln2ibckk6mxc9n59vdg8ziqa2zr8awcl720hazv1cr";
        authors = [
          "Microsoft"
        ];

      };
      "windows_i686_gnu" = rec {
        crateName = "windows_i686_gnu";
        version = "0.52.5";
        edition = "2021";
        sha256 = "0w4np3l6qwlra9s2xpflqrs60qk1pz6ahhn91rr74lvdy4y0gfl8";
        authors = [
          "Microsoft"
        ];

      };
      "windows_i686_gnullvm" = rec {
        crateName = "windows_i686_gnullvm";
        version = "0.52.5";
        edition = "2021";
        sha256 = "1s9f4gff0cixd86mw3n63rpmsm4pmr4ffndl6s7qa2h35492dx47";
        authors = [
          "Microsoft"
        ];

      };
      "windows_i686_msvc" = rec {
        crateName = "windows_i686_msvc";
        version = "0.52.5";
        edition = "2021";
        sha256 = "1gw7fklxywgpnwbwg43alb4hm0qjmx72hqrlwy5nanrxs7rjng6v";
        authors = [
          "Microsoft"
        ];

      };
      "windows_x86_64_gnu" = rec {
        crateName = "windows_x86_64_gnu";
        version = "0.52.5";
        edition = "2021";
        sha256 = "1n8p2mcf3lw6300k77a0knksssmgwb9hynl793mhkzyydgvlchjf";
        authors = [
          "Microsoft"
        ];

      };
      "windows_x86_64_gnullvm" = rec {
        crateName = "windows_x86_64_gnullvm";
        version = "0.52.5";
        edition = "2021";
        sha256 = "15n56jrh4s5bz66zimavr1rmcaw6wa306myrvmbc6rydhbj9h8l5";
        authors = [
          "Microsoft"
        ];

      };
      "windows_x86_64_msvc" = rec {
        crateName = "windows_x86_64_msvc";
        version = "0.52.5";
        edition = "2021";
        sha256 = "1w1bn24ap8dp9i85s8mlg8cim2bl2368bd6qyvm0xzqvzmdpxi5y";
        authors = [
          "Microsoft"
        ];

      };
      "zauth" = rec {
        crateName = "zauth";
        version = "3.1.0";
        edition = "2015";
        # We can't filter paths with references in Nix 2.4
        # See https://github.com/NixOS/nix/issues/5410
        src =
          if ((lib.versionOlder builtins.nixVersion "2.4pre20211007") || (lib.versionOlder "2.5" builtins.nixVersion))
          then lib.cleanSourceWith { filter = sourceFilter; src = ../libzauth; }
          else ../libzauth;
        authors = [
          "Wire Swiss GmbH <backend@wire.com>"
        ];
        dependencies = [
          {
            name = "asexp";
            packageId = "asexp";
          }
          {
            name = "base64";
            packageId = "base64";
          }
          {
            name = "jwt-simple";
            packageId = "jwt-simple 0.11.3";
          }
          {
            name = "lazy_static";
            packageId = "lazy_static";
          }
          {
            name = "regex";
            packageId = "regex";
          }
          {
            name = "rustc-serialize";
            packageId = "rustc-serialize";
          }
          {
            name = "serde";
            packageId = "serde";
          }
          {
            name = "serde_json";
            packageId = "serde_json";
          }
          {
            name = "sodiumoxide";
            packageId = "sodiumoxide";
          }
          {
            name = "thiserror";
            packageId = "thiserror";
          }
        ];

      };
      "zauth-c" = rec {
        crateName = "zauth-c";
        version = "3.0.0";
        edition = "2015";
        # We can't filter paths with references in Nix 2.4
        # See https://github.com/NixOS/nix/issues/5410
        src =
          if ((lib.versionOlder builtins.nixVersion "2.4pre20211007") || (lib.versionOlder "2.5" builtins.nixVersion))
          then lib.cleanSourceWith { filter = sourceFilter; src = ./.; }
          else ./.;
        libName = "zauth";
        type = [ "cdylib" ];
        authors = [
          "Wire Swiss GmbH <backend@wire.com>"
        ];
        dependencies = [
          {
            name = "jwt-simple";
            packageId = "jwt-simple 0.11.4";
          }
          {
            name = "libc";
            packageId = "libc";
          }
          {
            name = "zauth";
            packageId = "zauth";
          }
        ];

      };
      "zeroize" = rec {
        crateName = "zeroize";
        version = "1.8.1";
        edition = "2021";
        sha256 = "1pjdrmjwmszpxfd7r860jx54cyk94qk59x13sc307cvr5256glyf";
        authors = [
          "The RustCrypto Project Developers"
        ];
        features = {
          "default" = [ "alloc" ];
          "derive" = [ "zeroize_derive" ];
          "serde" = [ "dep:serde" ];
          "std" = [ "alloc" ];
          "zeroize_derive" = [ "dep:zeroize_derive" ];
        };
        resolvedDefaultFeatures = [ "alloc" "default" ];
      };
    };

    #
    # crate2nix/default.nix (excerpt start)
    #

    /* Target (platform) data for conditional dependencies.
      This corresponds roughly to what buildRustCrate is setting.
    */
    makeDefaultTarget = platform: {
      unix = platform.isUnix;
      windows = platform.isWindows;
      fuchsia = true;
      test = false;

      /* We are choosing an arbitrary rust version to grab `lib` from,
      which is unfortunate, but `lib` has been version-agnostic the
      whole time so this is good enough for now.
      */
      os = pkgs.rust.lib.toTargetOs platform;
      arch = pkgs.rust.lib.toTargetArch platform;
      family = pkgs.rust.lib.toTargetFamily platform;
      env = "gnu";
      endian =
        if platform.parsed.cpu.significantByte.name == "littleEndian"
        then "little" else "big";
      pointer_width = toString platform.parsed.cpu.bits;
      vendor = platform.parsed.vendor.name;
      debug_assertions = false;
    };

    /* Filters common temp files and build files. */
    # TODO(pkolloch): Substitute with gitignore filter
    sourceFilter = name: type:
      let
        baseName = builtins.baseNameOf (builtins.toString name);
      in
        ! (
          # Filter out git
          baseName == ".gitignore"
          || (type == "directory" && baseName == ".git")

          # Filter out build results
          || (
            type == "directory" && (
              baseName == "target"
              || baseName == "_site"
              || baseName == ".sass-cache"
              || baseName == ".jekyll-metadata"
              || baseName == "build-artifacts"
            )
          )

          # Filter out nix-build result symlinks
          || (
            type == "symlink" && lib.hasPrefix "result" baseName
          )

          # Filter out IDE config
          || (
            type == "directory" && (
              baseName == ".idea" || baseName == ".vscode"
            )
          ) || lib.hasSuffix ".iml" baseName

          # Filter out nix build files
          || baseName == "Cargo.nix"

          # Filter out editor backup / swap files.
          || lib.hasSuffix "~" baseName
          || builtins.match "^\\.sw[a-z]$$" baseName != null
          || builtins.match "^\\..*\\.sw[a-z]$$" baseName != null
          || lib.hasSuffix ".tmp" baseName
          || lib.hasSuffix ".bak" baseName
          || baseName == "tests.nix"
        );

    /* Returns a crate which depends on successful test execution
      of crate given as the second argument.

      testCrateFlags: list of flags to pass to the test exectuable
      testInputs: list of packages that should be available during test execution
    */
    crateWithTest = { crate, testCrate, testCrateFlags, testInputs, testPreRun, testPostRun }:
      assert builtins.typeOf testCrateFlags == "list";
      assert builtins.typeOf testInputs == "list";
      assert builtins.typeOf testPreRun == "string";
      assert builtins.typeOf testPostRun == "string";
      let
        # override the `crate` so that it will build and execute tests instead of
        # building the actual lib and bin targets We just have to pass `--test`
        # to rustc and it will do the right thing.  We execute the tests and copy
        # their log and the test executables to $out for later inspection.
        test =
          let
            drv = testCrate.override
              (
                _: {
                  buildTests = true;
                }
              );
            # If the user hasn't set any pre/post commands, we don't want to
            # insert empty lines. This means that any existing users of crate2nix
            # don't get a spurious rebuild unless they set these explicitly.
            testCommand = pkgs.lib.concatStringsSep "\n"
              (pkgs.lib.filter (s: s != "") [
                testPreRun
                "$f $testCrateFlags 2>&1 | tee -a $out"
                testPostRun
              ]);
          in
          pkgs.runCommand "run-tests-${testCrate.name}"
            {
              inherit testCrateFlags;
              buildInputs = testInputs;
            } ''
            set -e

            export RUST_BACKTRACE=1

            # recreate a file hierarchy as when running tests with cargo

            # the source for test data
            ${pkgs.xorg.lndir}/bin/lndir ${crate.src}

            # build outputs
            testRoot=target/debug
            mkdir -p $testRoot

            # executables of the crate
            # we copy to prevent std::env::current_exe() to resolve to a store location
            for i in ${crate}/bin/*; do
              cp "$i" "$testRoot"
            done
            chmod +w -R .

            # test harness executables are suffixed with a hash, like cargo does
            # this allows to prevent name collision with the main
            # executables of the crate
            hash=$(basename $out)
            for file in ${drv}/tests/*; do
              f=$testRoot/$(basename $file)-$hash
              cp $file $f
              ${testCommand}
            done
          '';
      in
      pkgs.runCommand "${crate.name}-linked"
        {
          inherit (crate) outputs crateName;
          passthru = (crate.passthru or { }) // {
            inherit test;
          };
        } ''
        echo tested by ${test}
        ${lib.concatMapStringsSep "\n" (output: "ln -s ${crate.${output}} ${"$"}${output}") crate.outputs}
      '';

    /* A restricted overridable version of builtRustCratesWithFeatures. */
    buildRustCrateWithFeatures =
      { packageId
      , features ? rootFeatures
      , crateOverrides ? defaultCrateOverrides
      , buildRustCrateForPkgsFunc ? null
      , runTests ? false
      , testCrateFlags ? [ ]
      , testInputs ? [ ]
        # Any command to run immediatelly before a test is executed.
      , testPreRun ? ""
        # Any command run immediatelly after a test is executed.
      , testPostRun ? ""
      }:
      lib.makeOverridable
        (
          { features
          , crateOverrides
          , runTests
          , testCrateFlags
          , testInputs
          , testPreRun
          , testPostRun
          }:
          let
            buildRustCrateForPkgsFuncOverriden =
              if buildRustCrateForPkgsFunc != null
              then buildRustCrateForPkgsFunc
              else
                (
                  if crateOverrides == pkgs.defaultCrateOverrides
                  then buildRustCrateForPkgs
                  else
                    pkgs: (buildRustCrateForPkgs pkgs).override {
                      defaultCrateOverrides = crateOverrides;
                    }
                );
            builtRustCrates = builtRustCratesWithFeatures {
              inherit packageId features;
              buildRustCrateForPkgsFunc = buildRustCrateForPkgsFuncOverriden;
              runTests = false;
            };
            builtTestRustCrates = builtRustCratesWithFeatures {
              inherit packageId features;
              buildRustCrateForPkgsFunc = buildRustCrateForPkgsFuncOverriden;
              runTests = true;
            };
            drv = builtRustCrates.crates.${packageId};
            testDrv = builtTestRustCrates.crates.${packageId};
            derivation =
              if runTests then
                crateWithTest
                  {
                    crate = drv;
                    testCrate = testDrv;
                    inherit testCrateFlags testInputs testPreRun testPostRun;
                  }
              else drv;
          in
          derivation
        )
        { inherit features crateOverrides runTests testCrateFlags testInputs testPreRun testPostRun; };

    /* Returns an attr set with packageId mapped to the result of buildRustCrateForPkgsFunc
      for the corresponding crate.
    */
    builtRustCratesWithFeatures =
      { packageId
      , features
      , crateConfigs ? crates
      , buildRustCrateForPkgsFunc
      , runTests
      , makeTarget ? makeDefaultTarget
      } @ args:
        assert (builtins.isAttrs crateConfigs);
        assert (builtins.isString packageId);
        assert (builtins.isList features);
        assert (builtins.isAttrs (makeTarget stdenv.hostPlatform));
        assert (builtins.isBool runTests);
        let
          rootPackageId = packageId;
          mergedFeatures = mergePackageFeatures
            (
              args // {
                inherit rootPackageId;
                target = makeTarget stdenv.hostPlatform // { test = runTests; };
              }
            );
          # Memoize built packages so that reappearing packages are only built once.
          builtByPackageIdByPkgs = mkBuiltByPackageIdByPkgs pkgs;
          mkBuiltByPackageIdByPkgs = pkgs:
            let
              self = {
                crates = lib.mapAttrs (packageId: value: buildByPackageIdForPkgsImpl self pkgs packageId) crateConfigs;
                target = makeTarget pkgs.stdenv.hostPlatform;
                build = mkBuiltByPackageIdByPkgs pkgs.buildPackages;
              };
            in
            self;
          buildByPackageIdForPkgsImpl = self: pkgs: packageId:
            let
              features = mergedFeatures."${packageId}" or [ ];
              crateConfig' = crateConfigs."${packageId}";
              crateConfig =
                builtins.removeAttrs crateConfig' [ "resolvedDefaultFeatures" "devDependencies" ];
              devDependencies =
                lib.optionals
                  (runTests && packageId == rootPackageId)
                  (crateConfig'.devDependencies or [ ]);
              dependencies =
                dependencyDerivations {
                  inherit features;
                  inherit (self) target;
                  buildByPackageId = depPackageId:
                    # proc_macro crates must be compiled for the build architecture
                    if crateConfigs.${depPackageId}.procMacro or false
                    then self.build.crates.${depPackageId}
                    else self.crates.${depPackageId};
                  dependencies =
                    (crateConfig.dependencies or [ ])
                    ++ devDependencies;
                };
              buildDependencies =
                dependencyDerivations {
                  inherit features;
                  inherit (self.build) target;
                  buildByPackageId = depPackageId:
                    self.build.crates.${depPackageId};
                  dependencies = crateConfig.buildDependencies or [ ];
                };
              dependenciesWithRenames =
                let
                  buildDeps = filterEnabledDependencies {
                    inherit features;
                    inherit (self) target;
                    dependencies = crateConfig.dependencies or [ ] ++ devDependencies;
                  };
                  hostDeps = filterEnabledDependencies {
                    inherit features;
                    inherit (self.build) target;
                    dependencies = crateConfig.buildDependencies or [ ];
                  };
                in
                lib.filter (d: d ? "rename") (hostDeps ++ buildDeps);
              # Crate renames have the form:
              #
              # {
              #    crate_name = [
              #       { version = "1.2.3"; rename = "crate_name01"; }
              #    ];
              #    # ...
              # }
              crateRenames =
                let
                  grouped =
                    lib.groupBy
                      (dependency: dependency.name)
                      dependenciesWithRenames;
                  versionAndRename = dep:
                    let
                      package = crateConfigs."${dep.packageId}";
                    in
                    { inherit (dep) rename; version = package.version; };
                in
                lib.mapAttrs (name: choices: builtins.map versionAndRename choices) grouped;
            in
            buildRustCrateForPkgsFunc pkgs
              (
                crateConfig // {
                  # https://github.com/NixOS/nixpkgs/issues/218712
                  dontStrip = stdenv.hostPlatform.isDarwin;
                  src = crateConfig.src or (
                    pkgs.fetchurl rec {
                      name = "${crateConfig.crateName}-${crateConfig.version}.tar.gz";
                      # https://www.pietroalbini.org/blog/downloading-crates-io/
                      # Not rate-limited, CDN URL.
                      url = "https://static.crates.io/crates/${crateConfig.crateName}/${crateConfig.crateName}-${crateConfig.version}.crate";
                      sha256 =
                        assert (lib.assertMsg (crateConfig ? sha256) "Missing sha256 for ${name}");
                        crateConfig.sha256;
                    }
                  );
                  extraRustcOpts = lib.lists.optional (targetFeatures != [ ]) "-C target-feature=${lib.concatMapStringsSep "," (x: "+${x}") targetFeatures}";
                  inherit features dependencies buildDependencies crateRenames release;
                }
              );
        in
        builtByPackageIdByPkgs;

    /* Returns the actual derivations for the given dependencies. */
    dependencyDerivations =
      { buildByPackageId
      , features
      , dependencies
      , target
      }:
        assert (builtins.isList features);
        assert (builtins.isList dependencies);
        assert (builtins.isAttrs target);
        let
          enabledDependencies = filterEnabledDependencies {
            inherit dependencies features target;
          };
          depDerivation = dependency: buildByPackageId dependency.packageId;
        in
        map depDerivation enabledDependencies;

    /* Returns a sanitized version of val with all values substituted that cannot
      be serialized as JSON.
    */
    sanitizeForJson = val:
      if builtins.isAttrs val
      then lib.mapAttrs (n: v: sanitizeForJson v) val
      else if builtins.isList val
      then builtins.map sanitizeForJson val
      else if builtins.isFunction val
      then "function"
      else val;

    /* Returns various tools to debug a crate. */
    debugCrate = { packageId, target ? makeDefaultTarget stdenv.hostPlatform }:
      assert (builtins.isString packageId);
      let
        debug = rec {
          # The built tree as passed to buildRustCrate.
          buildTree = buildRustCrateWithFeatures {
            buildRustCrateForPkgsFunc = _: lib.id;
            inherit packageId;
          };
          sanitizedBuildTree = sanitizeForJson buildTree;
          dependencyTree = sanitizeForJson
            (
              buildRustCrateWithFeatures {
                buildRustCrateForPkgsFunc = _: crate: {
                  "01_crateName" = crate.crateName or false;
                  "02_features" = crate.features or [ ];
                  "03_dependencies" = crate.dependencies or [ ];
                };
                inherit packageId;
              }
            );
          mergedPackageFeatures = mergePackageFeatures {
            features = rootFeatures;
            inherit packageId target;
          };
          diffedDefaultPackageFeatures = diffDefaultPackageFeatures {
            inherit packageId target;
          };
        };
      in
      { internal = debug; };

    /* Returns differences between cargo default features and crate2nix default
      features.

      This is useful for verifying the feature resolution in crate2nix.
    */
    diffDefaultPackageFeatures =
      { crateConfigs ? crates
      , packageId
      , target
      }:
        assert (builtins.isAttrs crateConfigs);
        let
          prefixValues = prefix: lib.mapAttrs (n: v: { "${prefix}" = v; });
          mergedFeatures =
            prefixValues
              "crate2nix"
              (mergePackageFeatures { inherit crateConfigs packageId target; features = [ "default" ]; });
          configs = prefixValues "cargo" crateConfigs;
          combined = lib.foldAttrs (a: b: a // b) { } [ mergedFeatures configs ];
          onlyInCargo =
            builtins.attrNames
              (lib.filterAttrs (n: v: !(v ? "crate2nix") && (v ? "cargo")) combined);
          onlyInCrate2Nix =
            builtins.attrNames
              (lib.filterAttrs (n: v: (v ? "crate2nix") && !(v ? "cargo")) combined);
          differentFeatures = lib.filterAttrs
            (
              n: v:
                (v ? "crate2nix")
                && (v ? "cargo")
                && (v.crate2nix.features or [ ]) != (v."cargo".resolved_default_features or [ ])
            )
            combined;
        in
        builtins.toJSON {
          inherit onlyInCargo onlyInCrate2Nix differentFeatures;
        };

    /* Returns an attrset mapping packageId to the list of enabled features.

      If multiple paths to a dependency enable different features, the
      corresponding feature sets are merged. Features in rust are additive.
    */
    mergePackageFeatures =
      { crateConfigs ? crates
      , packageId
      , rootPackageId ? packageId
      , features ? rootFeatures
      , dependencyPath ? [ crates.${packageId}.crateName ]
      , featuresByPackageId ? { }
      , target
        # Adds devDependencies to the crate with rootPackageId.
      , runTests ? false
      , ...
      } @ args:
        assert (builtins.isAttrs crateConfigs);
        assert (builtins.isString packageId);
        assert (builtins.isString rootPackageId);
        assert (builtins.isList features);
        assert (builtins.isList dependencyPath);
        assert (builtins.isAttrs featuresByPackageId);
        assert (builtins.isAttrs target);
        assert (builtins.isBool runTests);
        let
          crateConfig = crateConfigs."${packageId}" or (builtins.throw "Package not found: ${packageId}");
          expandedFeatures = expandFeatures (crateConfig.features or { }) features;
          enabledFeatures = enableFeatures (crateConfig.dependencies or [ ]) expandedFeatures;
          depWithResolvedFeatures = dependency:
            let
              packageId = dependency.packageId;
              features = dependencyFeatures enabledFeatures dependency;
            in
            { inherit packageId features; };
          resolveDependencies = cache: path: dependencies:
            assert (builtins.isAttrs cache);
            assert (builtins.isList dependencies);
            let
              enabledDependencies = filterEnabledDependencies {
                inherit dependencies target;
                features = enabledFeatures;
              };
              directDependencies = map depWithResolvedFeatures enabledDependencies;
              foldOverCache = op: lib.foldl op cache directDependencies;
            in
            foldOverCache
              (
                cache: { packageId, features }:
                  let
                    cacheFeatures = cache.${packageId} or [ ];
                    combinedFeatures = sortedUnique (cacheFeatures ++ features);
                  in
                  if cache ? ${packageId} && cache.${packageId} == combinedFeatures
                  then cache
                  else
                    mergePackageFeatures {
                      features = combinedFeatures;
                      featuresByPackageId = cache;
                      inherit crateConfigs packageId target runTests rootPackageId;
                    }
              );
          cacheWithSelf =
            let
              cacheFeatures = featuresByPackageId.${packageId} or [ ];
              combinedFeatures = sortedUnique (cacheFeatures ++ enabledFeatures);
            in
            featuresByPackageId // {
              "${packageId}" = combinedFeatures;
            };
          cacheWithDependencies =
            resolveDependencies cacheWithSelf "dep"
              (
                crateConfig.dependencies or [ ]
                ++ lib.optionals
                  (runTests && packageId == rootPackageId)
                  (crateConfig.devDependencies or [ ])
              );
          cacheWithAll =
            resolveDependencies
              cacheWithDependencies "build"
              (crateConfig.buildDependencies or [ ]);
        in
        cacheWithAll;

    /* Returns the enabled dependencies given the enabled features. */
    filterEnabledDependencies = { dependencies, features, target }:
      assert (builtins.isList dependencies);
      assert (builtins.isList features);
      assert (builtins.isAttrs target);

      lib.filter
        (
          dep:
          let
            targetFunc = dep.target or (features: true);
          in
          targetFunc { inherit features target; }
          && (
            !(dep.optional or false)
            || builtins.any (doesFeatureEnableDependency dep) features
          )
        )
        dependencies;

    /* Returns whether the given feature should enable the given dependency. */
    doesFeatureEnableDependency = dependency: feature:
      let
        name = dependency.rename or dependency.name;
        prefix = "${name}/";
        len = builtins.stringLength prefix;
        startsWithPrefix = builtins.substring 0 len feature == prefix;
      in
      feature == name || feature == "dep:" + name || startsWithPrefix;

    /* Returns the expanded features for the given inputFeatures by applying the
      rules in featureMap.

      featureMap is an attribute set which maps feature names to lists of further
      feature names to enable in case this feature is selected.
    */
    expandFeatures = featureMap: inputFeatures:
      assert (builtins.isAttrs featureMap);
      assert (builtins.isList inputFeatures);
      let
        expandFeaturesNoCycle = oldSeen: inputFeatures:
          if inputFeatures != [ ]
          then
            let
              # The feature we're currently expanding.
              feature = builtins.head inputFeatures;
              # All the features we've seen/expanded so far, including the one
              # we're currently processing.
              seen = oldSeen // { ${feature} = 1; };
              # Expand the feature but be careful to not re-introduce a feature
              # that we've already seen: this can easily cause a cycle, see issue
              # #209.
              enables = builtins.filter (f: !(seen ? "${f}")) (featureMap."${feature}" or [ ]);
            in
            [ feature ] ++ (expandFeaturesNoCycle seen (builtins.tail inputFeatures ++ enables))
          # No more features left, nothing to expand to.
          else [ ];
        outFeatures = expandFeaturesNoCycle { } inputFeatures;
      in
      sortedUnique outFeatures;

    /* This function adds optional dependencies as features if they are enabled
      indirectly by dependency features. This function mimics Cargo's behavior
      described in a note at:
      https://doc.rust-lang.org/nightly/cargo/reference/features.html#dependency-features
    */
    enableFeatures = dependencies: features:
      assert (builtins.isList features);
      assert (builtins.isList dependencies);
      let
        additionalFeatures = lib.concatMap
          (
            dependency:
              assert (builtins.isAttrs dependency);
              let
                enabled = builtins.any (doesFeatureEnableDependency dependency) features;
              in
              if (dependency.optional or false) && enabled
              then [ (dependency.rename or dependency.name) ]
              else [ ]
          )
          dependencies;
      in
      sortedUnique (features ++ additionalFeatures);

    /*
      Returns the actual features for the given dependency.

      features: The features of the crate that refers this dependency.
    */
    dependencyFeatures = features: dependency:
      assert (builtins.isList features);
      assert (builtins.isAttrs dependency);
      let
        defaultOrNil =
          if dependency.usesDefaultFeatures or true
          then [ "default" ]
          else [ ];
        explicitFeatures = dependency.features or [ ];
        additionalDependencyFeatures =
          let
            name = dependency.rename or dependency.name;
            stripPrefixMatch = prefix: s:
              if lib.hasPrefix prefix s
              then lib.removePrefix prefix s
              else null;
            extractFeature = feature: lib.findFirst
              (f: f != null)
              null
              (map (prefix: stripPrefixMatch prefix feature) [
                (name + "/")
                (name + "?/")
              ]);
            dependencyFeatures = lib.filter (f: f != null) (map extractFeature features);
          in
          dependencyFeatures;
      in
      defaultOrNil ++ explicitFeatures ++ additionalDependencyFeatures;

    /* Sorts and removes duplicates from a list of strings. */
    sortedUnique = features:
      assert (builtins.isList features);
      assert (builtins.all builtins.isString features);
      let
        outFeaturesSet = lib.foldl (set: feature: set // { "${feature}" = 1; }) { } features;
        outFeaturesUnique = builtins.attrNames outFeaturesSet;
      in
      builtins.sort (a: b: a < b) outFeaturesUnique;

    deprecationWarning = message: value:
      if strictDeprecation
      then builtins.throw "strictDeprecation enabled, aborting: ${message}"
      else builtins.trace message value;

    #
    # crate2nix/default.nix (excerpt end)
    #
  };
}

