<a id="configure-federation"></a>

# Federation

See also [Wire Federation](federation/README.md#federation-understand), which explains the architecture and concepts.

#### NOTE
The Federation development is work in progress.

## Summary of necessary steps to configure federation

The steps needed to configure federation are as follows and they will be
detailed in the sections below:

- Choose a backend domain name
- DNS setup for federation (including an `SRV` record)
- Generate and configure TLS certificates:
  - server certificates
  - client certificates
  - a selection of CA certificates you trust when interacting with
    other backends
- Configure helm charts : federator and ingress and webapp subcharts
- Test that your configurations work as expected.

<a id="choose-backend-domain"></a>

## Choose a Backend Domain

As of the release [helm chart 0.129.0, Wire docker version 2.94.0] from
2020-12-15, `federationDomain` is a mandatory configuration setting, which
defines the [backend domain](federation/architecture.md#glossary-backend-domain) of your
installation. Regardless of whether you want to enable federation for a backend
or not, you must decide what its domain is going to be. This helps in keeping
things simpler across all components of Wire and also enables to turn on
federation in the future if required.

It is highly recommended that this domain is configured as something
that is controlled by the administrator/operator(s). The actual servers
do not need to be available on this domain, but you MUST be able to set
an SRV record for `_wire-server-federator._tcp.<Backend Domain>` that
informs other wire-server backends where to find your actual servers.

**IMPORTANT**: Once this option is set, it cannot be changed without
breaking experience for all the users which are already using the
backend.

<a id="consequences-backend-domain"></a>

## Consequences of the choice of a backend domain

- You need control over a specific subdomain of this backend domain
  (to set an SRV DNS record as explained in the next section). Without
  this control, you cannot federate with anyone.
- This backend domain becomes part of the underlying identity of all
  users on your servers.

  Example: Let’s say you choose `example.com` as your backend
  domain. Your user known to you as Alice, and known on your
  server with ID `ac41a202-2555-11ec-9341-00163e5e6c00` will
  become known for other servers you federate with as
  ```json
  {
    "user": {
      "id": "ac41a202-2555-11ec-9341-00163e5e6c00",
      "domain": "example.com"
    }
  }
  ```
- This domain is shown in the User Interface
  alongside user information.

  Example: Using the same example as above, for backends you
  federate with, Alice would be displayed with the
  human-readable username `@alice@example.com` for users on
  other backends.

#### WARNING
*Changing* the backend domain after existing user
activity with a client version (versions later than May/June 2021)
will lead to undefined behaviour (untested, not accounted for during
development) on some or all client platforms (Web, Android, iOS) for
those users: It is possible your clients could crash, or lose part of
their data about themselves or other users and conversations, or
otherwise exhibit unexpected behaviour. If at all possible, do not
change this backend domain. We do not intend to provide support if you
change the backend domain.

<a id="dns-configure-federation"></a>

## DNS setup for federation

### SRV record

One prerequisite to enable federation is an [SRV
record](https://en.wikipedia.org/wiki/SRV_record) as defined in [RFC
2782](https://datatracker.ietf.org/doc/html/rfc2782) that needs to be
set up to allow the wire-server to be discovered by other Wire backends.
See the documentation on
[discovery in federation](federation/backend-communication.md#discovery) for
more information on the role of discovery in federation.

The fields of the SRV record need to be populated as follows

- `service`: `wire-server-federator`
- `proto`: `tcp`
- `name`: <backend-domain>
- `TTL`: e.g. 600 (10 minutes) in an initial phase. This can be set to
  a higher value (e.g. 86400) if your systems are stable and DNS
  records don’t change a lot.
- `priority`: anything. A good default value would be 0
- `weight`: >0 for your server to be reachable. A good default value
  could be 10
- `port`: `443`
- `target`: the infrastructure domain

To give an example, assuming

- your federation
  [Backend Domain](federation/architecture.md#glossary-backend-domain) is `example.com`
- your domains for other services already set up follow the convention
  `<service>.wire.example.org`

then your federation
[Infrastructure Domain](federation/architecture.md#glossary-infra-domain)
would be `federator.wire.example.org`.

The SRV record would look as follows:

```bash
# _service._proto.name.                  ttl IN SRV priority weight port target.
_wire-server-federator._tcp.example.com. 600 IN SRV 0        10     443  federator.wire.example.org.
```

### DNS A record for the federator

Background: `federator` is the server component responsible for incoming
and outgoing requests to other backend; but it is proxied on the
incoming requests by the ingress component on kubernetes as shown in
[Federation Architecture](federation/architecture.md#federation-architecture)

As mentioned in [DNS setup for Helm](../how-to/install/helm-prod.md#helmdns), you also need a `federator.<domain>` record, which,
alongside your other DNS records that point to the ingress component,
also needs to point to the IP of your ingress, i.e. the IP you want to
provide services on.

<a id="federation-certificate-setup"></a>

## Generate and configure TLS server and client certificates

Are your servers on the public internet? Then you have the option of
using TLS certificates from [Let’s encrypt](https://letsencrypt.org/).
In such a case go to subsection (A). If your servers are not on the
public internet or you would like to use your own CA, go to subsection
(B).

### (A) Let’s encrypt TLS server and client certificate generation and renewal

The following will make use of [Let’s
encrypt](https://letsencrypt.org/) for both server certificates (used
when someone sends a request to your `federator.<domain-name>`) and
client certificates (used for making outgoing requests to other
backends).

For that, you need to have
[jetstack/cert-manager](https://github.com/jetstack/cert-manager)
installed. You can follow the helm chart installation
[here](https://cert-manager.io/docs/installation/helm/).

Once you have cert-manager, adjust the email address below, then set the
following in the nginx-ingress-services overrides:

```yaml
# override values for nginx-ingress-services
# (e.g. under ./helm_vars/nginx-ingress-services/values.yaml)
tls:
  useCertManager: true

certManager:
  inTestMode: false
  certmasterEmail: "certificates@example.com"
```

```yaml
# override values for wire-server
# (e.g. under ./helm_vars/wire-server/values.yaml)
federator:
  tls:
    useSharedFederatorSecret: true
```

You can now skip section (B) and go to Configure CA certificates you
trust when interacting with other backends.

### (B) Manual server and client certificates

Use your usual method of obtaining X.509 certificates for your [federation infrastructure domain](federation/architecture.md#glossary-infra-domain) (alongside the other domains needed for a
wire-server installation).

You can use one single certificate and key for both server and client
certificate use.

#### NOTE
Due to a limitation of the TLS library in use
for federation ([hs-tls](https://github.com/vincenthz/hs-tls)), only
some ciphers are supported. Moving to an openssl-based library is
planned, which will provide support for a wider range of ciphers.

Your certificates need to have the “Server” and “Client” key usage
listed among the X509 extensions:

```bash
# inspect your certificate:
openssl x509 -inform pem -noout -text < your-certificate.pem
```

```bash
X509v3 extensions:
    X509v3 Key Usage: critical
        Digital Signature, Key Encipherment
    X509v3 Extended Key Usage:
        TLS Web Server Authentication, TLS Web Client Authentication
```

And your [federation infrastructure domain](federation/architecture.md#glossary-infra-domain) (e.g.
`federator.wire.example.com` from the running example) needs to either figure
explictly in the list of your SAN (Subject Alternative Name):

```bash
X509v3 Subject Alternative Name:
    DNS:federator.wire.example.com, DNS:nginz-https.wire.example.com, ...
```

Or you need to have a wildcard certificate that includes it:

```bash
X509v3 Subject Alternative Name: critical
    DNS:*.wire.example.com
```

Configure the *client certificate* and *private key* inside
wire-server/federator:

```yaml
# override values for wire-server
# (e.g. under ./helm_vars/wire-server/values.yaml or helm_vars/wire-server/secrets.yaml)
federator:
  clientCertificateContents: |
    -----BEGIN CERTIFICATE-----
    .....
    -----END CERTIFICATE-----
  clientPrivateKeyContents: |
    -----BEGIN RSA PRIVATE KEY-----
    .....
    -----END RSA PRIVATE KEY-----
```

The *server certificate* and *private key* need to be configured in
`nginx-ingress-services`. Those are used for all of the services, not
just the federator component. If you have installed wire-server before
without federation, server certificates may already be configured
 *(though you probably need to create new certificates to include the
federation infrastructure domain if you’re not making use of wildcard
certificates)*. Server certificates go here:

```yaml
# override values for nginx-ingress-services
# (e.g. under ./helm_vars/nginx-ingress-services/secrets.yaml)
secrets:
  tlsWildcardCert: |
    -----BEGIN CERTIFICATE-----
    ... <cert goes here>
    -----END CERTIFICATE-----

  tlsWildcardKey: |
    -----BEGIN RSA PRIVATE KEY -----
    ... <private key goes here>
    -----END RSA PRIVATE KEY-----
```

### Configure CA certificates you trust when interacting with other backends

If you want to federate with servers at `othercompany.example.com`, then
you need to trust the CA (Certificate Authority) certificate that
`othercompany.example.com` has used to sign its client certificates.

They need to be set both for the nginx-ingress-services and the
wire-server chart.

```yaml
# override values for nginx-ingress-services
# (e.g. under ./helm_vars/nginx-ingress-services/values.yaml)
secrets:
  tlsClientCA: |
    -----BEGIN CERTIFICATE-----
    ... <CA in PEM format goes here>
    -----END CERTIFICATE-----
    -----BEGIN CERTIFICATE-----
    ... <another CA in PEM format goes here>
    -----END CERTIFICATE-----
```

```yaml
# override values for wire-server
# (e.g. under ./helm_vars/wire-server/values.yaml)
federator:
  remoteCAContents: |
    -----BEGIN CERTIFICATE-----
    ... <CA in PEM format goes here>
    -----END CERTIFICATE-----
    -----BEGIN CERTIFICATE-----
    ... <another CA in PEM format goes here>
    -----END CERTIFICATE-----
```

### Tell parties you intend to federate with about your certificates

The backends you want to federate with should add your (or Let’s
Encrypt’s) CA to their store, so you should give them your CA
certificate, or tell them to use the appropriate Let’s Encrypt root
certificate.

## Configure helm charts: federator and ingress and webapp subcharts

### Set your chosen backend domain

Read [Choose a Backend Domain](#choose-backend-domain) again, then
set the backend domain three times to the same value in the subcharts
cargohold, galley and brig. You also need to set `enableFederation` to
`true` in background-worker in addition to those charts.

```yaml
# override values for wire-server
# (e.g. under ./helm_vars/wire-server/values.yaml)
galley:
  config:
    enableFederation: true
    settings:
      federationDomain: example.com # your chosen "backend domain"

brig:
  config:
    enableFederation: true
    optSettings:
      setFederationDomain: example.com # your chosen "backend domain"

cargohold:
  config:
    enableFederation: true
    settings:
      federationDomain: example.com # your chosen "backend domain"

background-worker:
  config:
    enableFederation: true
```

<a id="configure-federation-strategy-in-brig"></a>

### Configure federation strategy (whom to federate with) in brig

**Since [PR#3260](https://github.com/wireapp/wire-server/pull/3260).**

Also see [Keeping track of federator remotes](../developer/developer/federation-design-aspects.md#configuring-remote-connections-dev-perspective) for the
developer’s point of view on this topic.

You also need to define the federation strategy (whom to federate
with), and the frequency with which the other backend services will
refresh their cache of this configuration.

```yaml
# override values for wire-server
# (e.g. under ./helm_vars/wire-server/values.yaml)
brig:
  config:
    optSettings:
      setFederationStrategy: allowNone # [allowAll | allowDynamic | allowNone]
      setFederationDomainConfigsUpdateFreq: 10 # seconds
```

The default strategy of `allowNone` effectively disables federation
(and probably isn’t what you want if you are reading this).
`allowAll` federates with any backend that requests contact or that a
user uses in a search.  `allowDynamic` only federates with known
remote backends listed in Cassandra.

The update frequency determines how often other services will refresh
the information about remote connections from brig.

#### Managing remote domains via internal API

Information about remote federation domains is stored in **brig’s Cassandra** and configured through the **internal brig API**.

**Create a Remote Domain:**

```
POST /i/federation/remotes
```

Body Example (no restriction, allow all teams):

```json
{
  "domain": "cloud.example.com",
  "search_policy": "full_search",
  "restriction": {
    "tag": "allow_all",
    "value": null
  }
}
```

Body Example (restrict by team):

```json
{
  "domain": "cloud.example.com",
  "search_policy": "full_search",
  "restriction": {
    "tag": "restrict_by_team",
    "value": [
      "aacea429-c8ba-4afc-9369-cae87404b820",
      "bf82dca7-0916-42af-8f84-88a47b34521e"
    ]
  }
}
```

*After adding a new remote backend, wait for the other end to do the same, and allow at least `update_interval * 2` (see below) for the federation state to stabilize.*

**Get Federation Remotes:**

```
GET /i/federation/remotes
```

Returns a list of all configured federation remotes and strategy settings.

Response Example:

```json
{
  "remotes": [
    {
      "domain": "example.com",
      "restriction": {
        "tag": "restrict_by_team",
        "value": [
          "99db9768-04e3-4b5d-9268-831b6a25c4ab"
        ]
      },
      "search_policy": "no_search"
    }
  ],
  "strategy": "allowDynamic",
  "update_interval": 30
}
```

Fields:

- `strategy`: Federation strategy, possible values:
  - `allowAll`: Federation with any domain is allowed
  - `allowDynamic`: If federation strategy is `allowDynamic`, only backends that are listed can be reached by us and can reach us.
  - `allowNone`: No domains are allowed to federate (federation disabled)
- `remotes`: An array of configured remote domains. Entries have the following fields:
  - `domain`: Remote backend domain name
  - `restriction`: Either `allow_all` or `restrict_by_team` (see section on **Team restriction** below)
  - `search_policy`: The search policy for a remote backend. Independently of the federation strategy, the list provides information about remote backends that may change dynamically (currently: `search_policy`). See [Searching users on another federated backend](searchability.md#searching-users-on-another-federated-backend) and [User Searchability](searchability.md#user-searchability) for more context. Values:
    - `no_search`: No users are returned by federated searches. Default.
    - `exact_handle_search`: Only users where the handle exactly matches are returned.
    - `full_search`: Additionally to `exact_handle_search`, users are found by a freetext search on handle and display name.
- `update_interval`: suggested polling frequency (in seconds) for consuming services

If federation strategy is `allowAll`, and there is no entry for a
domain in the database, default is `no_search`. The field in
Cassandra is not nullable, i.e., you always have to explicitly name a
search policy if you create an entry.


> ⚠️ This endpoint may have relatively high traffic on large instances. If you run >100 pods and use a short update interval (<10s), monitor brig’s load and Cassandra performance closely.


**Update a Remote Domain:**

```
PUT /i/federation/remotes/:domain
```

Use this to update the search policy or restriction mode of a given remote domain.

**Example (switching a remote to team restriction mode):**

```json
{
  "domain": "cloud.example.com",
  "search_policy": "full_search",
  "restriction": {
    "tag": "restrict_by_team",
    "value": [
      "aacea429-c8ba-4afc-9369-cae87404b820",
      "bf82dca7-0916-42af-8f84-88a47b34521e"
    ]
  }
}
```

#### Team Restriction

By default, federation can be configured at the **domain** level, but in some cases it is necessary to restrict communication further to specific **teams** within a remote domain.

The **team restriction** mechanism lets you define an allowlist of remote teams that are permitted to **find users from your domain**. In practice, this means that only users belonging to those teams will be discoverable in federated search or connection requests.

Typical deployment:

A customer runs an **on-premise instance** that needs to federate with **their team on Wire Cloud**, but not with other cloud teams or users.
The allowlist ensures that only the designated cloud team can find users on the on-prem instance.

**Important Limitations:**

* Team restrictions apply to **search and discovery**. Once a user is connected, they may still introduce other users, e.g. via adding them to a common group conversations with other non-allowed users.
* If a domain is configured via the **static federation config file**, it cannot be modified in the database. That means you cannot:
  * Add or update the domain itself,
  * Add or update team restrictions for that domain.
    Changes require editing the config file and restarting the service.
* Private (non-team) users are not eligible for team-restricted federation. They will always be excluded if restrictions apply.
* Removing a team from the allowlist **does not break existing connections** — users already connected or part of common conversations can still interact. Restrictions only apply to *new* searches and connection requests.

**Behavior in federated search**

The team restriction impacts **federated user search** results. Two modes are possible:

* `allow_all` (no restriction):
  All teams from the remote domain are discoverable.

* `restrict_by_team` (allowlist):
  Only users from explicitly allowed teams are discoverable.
  You must add teams via `POST /i/federation/remotes/:domain/teams`.

**Example:**

* If `domain1` allows only `teamA` from `domain2`, then a user from `teamB` in `domain2` will **not** show up in `domain1`’s federated search.
* Exact handle search and full search both respect these restrictions.

The following internal API endpoints are available for team restrictions (applicable if `restriction.tag` is set to `restrict_by_team`):

**Add a Remote Team:**

```
POST /i/federation/remotes/:domain/teams
```

Allow federation with a specific team from the remote domain.

Body:

```json
{
  "team_id": "8bec1ed8-6ca8-4457-bd54-8a7f8a0a398a"
}
```

**Get Allowed Remote Teams:**

```
GET /i/federation/remotes/:domain/teams
```

List all teams from the remote domain that are currently allowed to federate.

Response Example:

```json
[
  { "team_id": "2c41cd5a-6885-44c2-ae31-8d2bea5b59aa" },
  { "team_id": "5c78b3fa-1acc-444a-9ca9-df8a4703e603" }
]
```

**Delete a Remote Team:**

```
DELETE /i/federation/remotes/:domain/teams/:team_id
```

Remove a team from the allowlist. Once removed, users from that team will not be discoverable or accessible via federation.

#### If your instance has been federating before

You only need to read this section if your instance has been
federating with other instances prior to
[PR#3260](https://github.com/wireapp/wire-server/pull/3260), and you
are upgrading to the release containing that PR.

From now on the federation policy set in the federator config under
`federationStrategy` is ignored.  Instead, the federation strategy is
pulled by all services from brig, who in turn gets it from a
combination of config file and database (see
[Configure federation strategy (whom to federate with) in brig](#configure-federation-strategy-in-brig) above).

In order to achieve a zero-downtime upgrade, follow these steps:

1. Update the brig config values file as described above.
2. If you have chosen `brig.config.optSettings.setFederationStrategy: allowDynamic` you need to make sure the list of all domains you want
   to allow federation with is complete (before, there was a search
   policy default; now wire will stop federating with removes that are
   not listed here).  Example:
   ```yaml
   brig:
     config:
       optSettings:
         setFederationDomainConfigs:
         - domain: red.example.com
           search_policy: full_search
         - domain: blue.example.com
           search_policy: no_search
   ```

   This change is to cover the time window between upgrading the brig
   pods and populating cassandra with the information needed (see
   Step 3 below).

   Any later lookup of this information will return the union of what
   is in cassandra and what is in the config file.  Any attempt to
   write data to cassandra that contradicts data in the config file
   will result in an error.  Before you change any remote domain
   config, remove it from the config file.
3. Populate cassandra with remote domain configs as described above.
4. At any time after you are done with the upgrade and have convinced
   yourself everything went smoothly, remove outdated brig and
   federator config values, in particular:
   - `brig.config.optSettings.setFederationDomainConfigs`
   - `federator.config.optSettings.federationStrategy`

   At a later point, wire-server will start ignoring
   `setFederationDomainConfigs` altogether (follow future entries in
   the changelog to learn when that happens).

### Configure federator process to run and allow incoming traffic

For federation to work, the `federator` subchart of wire-server has to
be enabled:

```yaml
# override values for wire-server
# (e.g. under ./helm_vars/wire-server/values.yaml)
tags:
  federator: true
```

You also need to enable ingress->federator proxying and configure the
charts to use the DNS you configured as a target in
[DNS setup for federation](#dns-configure-federation) above

```yaml
# override values for nginx-ingress-services
# (e.g. under ./helm_vars/nginx-ingress-services/values.yaml)
federator:
  enabled: true

config:
  dns:
    federator: federator.wire.example.org # set this to your "infra" domain
```

### Configure the validation depth when handling client certificates

By default, `verify_depth` is `1`, meaning that in order to validate an
incoming request from another backend, this backend needs to have a
client certificate that is directly (without any intermediate
certificates) signed by a CA certificate from the trust store.

Example: If you trust a CA `root` which signs an intermediate
`intermediate-1` which in turn signs `intermediate-2` which finally
signs `leaf`, and `leaf` is used during mutual TLS when validating
incoming requests, then `verify_depth` would need to be set to `3`.

```yaml
# nginx-ingress-services/values.yaml
tls:
  # the validation depth between a federator client certificate and tlsClientCA
  verify_depth: 3 # default: 1
```

<a id="configure-federation-allow-list"></a>

### Configure the allow list

By default, federation is turned off (allow list set to the empty list):

```yaml
# override values for wire-server
# (e.g. under ./helm_vars/wire-server/values.yaml)
federator:
  config:
    optSettings:
      federationStrategy:
        allowedDomains: []
```

You can choose to federate with a specific list of allowed backends:

```yaml
# override values for wire-server
# (e.g. under ./helm_vars/wire-server/values.yaml)
federator:
  config:
    optSettings:
      federationStrategy:
        allowedDomains:
         - example.com
         - example.org
```

Alternatively, you can federate with everyone:

```yaml
# override values for wire-server
# (e.g. under ./helm_vars/wire-server/values.yaml)
federator:
  config:
    optSettings:
      federationStrategy:
        allowAll: true
```

## Applying all configuration changes

Depending on your installation method and time you initially installed
your first version of wire-server, commands to run to apply all of the
above configrations may vary. You want to ensure that you upgrade the
`nginx-ingress-services` and `wire-server` helm charts at a minimum.

## Manually test that your configurations work as expected

### Manually test DNS

If you use `dig` to check for SRV records, use e.g.:

```none
dig +short SRV _wire-server-federator._tcp.wire.example.com
```

Should yield something like:

```none
0 10 443 federator.wire.example.com.
```

The actual target:

```none
dig +short federator.wire.example.com
```

should also point to an IP address:

```none
1.2.3.4 # of course you should get a valid IP here
```

Ensure that the IP matches where your backend ingress runs.

### Manually test certificates

Refer to [How can I see if my TLS certificates are configured the way I expect?](../how-to/administrate/general-linux.md#how-to-see-tls-certs) and set
DOMAIN to your
[federation infrastructure domain](federation/architecture.md#glossary-infra-domain). They should include your domain as part of the SAN (Subject
Alternative Names) and not have expired.

### Manually test that federation works

Prerequisites:

- You need two backends with federation configured and enabled.
- They both need to have each other in the allow list.
- They both need to trust each other’s CA certificate.

Create user accounts on both backends.

With one user, search for the other user using the
`@username-1@example.com` syntax in the UI search field of the webapp.

### Federated Calling

To begin with, you need to make a few decisions:
 * How paranoid am I (separation of sensitive content) -- Do I want separation between "local" calling traffic between my backend and it's users, from the calling traffic to and from a remote (trusted) backend?
 * How paranoid am I (traffic across the internet) -- Do you want the extra security / simplified routing / greater maintainence of using DTLS for your federated calling traffic? This gives you the benefit of being simpler to route across a network and enhanced security with certificate checking between backend calling components.

To begin with, we are going to assume you have calling working "properly". that means your users can use both wire calling services, and can find direct calling routes to the calling services. If this is not you, or if you are unsure, contact wire support to schedule a checkup of your calling services.

For this document, we are going to assume "not that paranoid" and "simplify networking, please."

We will also assume you have a working non-federated calling infrastructure (because you should).

#### Federated Calling Traffic

In order for users on both federated backends to communicate, calling traffic needs to travel between your wire calling environment and the calling environment of your federation partner.

There are two options for how calling traffic is transfered between federating backends: with, or without DTLS.
If you have chosen DTLS, you need to have incoming port 9191 between your calling clusters. Federated calling traffic will be transmitted between federated environments on this port.

#### Configure Coturn

To set up federated 1on1 calling, coturn will need to be reconfigured and the following should be added to your coturn `values.yaml` file:

```yaml
coturnFederationListeningIP: '__COTURN_HOST_IP__'
federate:
  enabled: true
  port: 9191
```

If you are using DTLS (with `cert-manager`)

```yaml
coturnFederationListeningIP: '__COTURN_HOST_IP__'
federate:
  enabled: true
  port: 9191
  dtls:
    enabled: true
    tls:
      issuerRef:
        name: letsencrypt-http01
        kind: ClusterIssuer
      certificate:
        dnsNames:
          - coturn.example.com
```

or with your own certificates:

```yaml
coturnFederationListeningIP: '__COTURN_HOST_IP__'
federate:
  enabled: true
  port: 9191
  dtls:
    enabled: true
    tls:
      key: |
        -----BEGIN PRIVATE KEY-----
      crt: |
       ...
```

Then redeploy `coturn`

```bash
d helm upgrade --install coturn charts/coturn -f values/coturn/values.yaml -f values/coturn/secrets.yaml
```

If running into error with YAML and spacing (it happens), you can supply the certificate and key directly from the CLI like so:

```bash
d helm upgrade --install coturn charts/coturn -f values/coturn/values.yaml -f values/coturn/secrets.yaml --set-file federate.dtls.tls.key=key.pem --set-file federate.dtls.tls.crt=crt.pem
```

#### Configure SFTD (Federated Conference Calling)

To understand more on the architecture, read [Federated Conference Calling](https://docs.wire.com/latest/understand/sft.html#federated-conference-calling)

For setup of federated conference calling, a prerequisite should be met (not required, but recommended) of designating a coturn server that will be used exclusively for federated calls. 

To configure SFTD, in `values/sftd/values.yaml`: 
- `multiSFT` will have to be enabled
- turn secret from `brig`

```yaml
allowOrigin: "https://webapp.example.com"
multiSFT:
  enabled: true
  discoveryRequired: false
  turnServerURI: "turn:federation.or.local.coturnIP:3478?transport=udp"
  secret: "turnSecretFromBrig"
```

Calls between federated SFT servers can be enabled using the optional boolean `multiSFT.enabled`. If provided, the field `is_federating` in the response of `/calls/config/v2` will reflect `multiSFT.enabled`’s value.

```yaml
brig:
  config:
    multiSFT:
      enabled: true
```

Additionally `setSftListAllServers` should be set to `enabled` (disabled by default) then the `/calls/config/v2` endpoint will include a list of all servers that are load balanced by `setSftStaticUrl` at field `sft_servers_all`. This is also required to enable calls between federated instances of Wire.

```yaml
brig:
  config:
    optSettings:
      setSftListAllServers: enabled
```

Redeploy `sftd`
```bash
d helm upgrade --install sftd charts/sftd -f values/sftd/values.yaml
```

Redeploy `wire-server`
```bash
d helm upgrade --install wire-server ./charts/wire-server --timeout=15m0s --values ./values/wire-server/values.yaml --values ./values/wire-server/secrets.yaml
```