<?php

use Appwrite\Auth\Auth;
use Utopia\Config\Config;
use Utopia\Database\Database;
use Utopia\Database\ID;

$providers = Config::getParam('providers', []);
$auth = Config::getParam('auth', []);

/**
 * $collection => id of the parent collection where this will be inserted
 * $id => id of this collection
 * name => name of this collection
 * project => whether this collection should be created per project
 * attributes => list of attributes
 * indexes => list of indexes
 */

 $commonCollections = [
    'users' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('users'),
        'name' => 'Users',
        'attributes' => [
            [
                '$id' => ID::custom('name'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('email'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 320,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('phone'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16, // leading '+' and 15 digitts maximum by E.164 format
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('status'),
                'type' => Database::VAR_BOOLEAN,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('password'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['encrypt'],
            ],
            [
                '$id' => 'hash', // Hashing algorithm used to hash the password
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => Auth::DEFAULT_ALGO,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('hashOptions'), // Configuration of hashing algorithm
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 65535,
                'signed' => true,
                'required' => false,
                'default' => Auth::DEFAULT_ALGO_OPTIONS,
                'array' => false,
                'filters' => ['json'],
            ],
            [
                '$id' => ID::custom('passwordUpdate'),
                'type' => Database::VAR_DATETIME,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['datetime'],
            ],
            [
                '$id' => ID::custom('prefs'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 65535,
                'signed' => true,
                'required' => false,
                'default' => new \stdClass(),
                'array' => false,
                'filters' => ['json'],
            ],
            [
                '$id' => ID::custom('registration'),
                'type' => Database::VAR_DATETIME,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['datetime'],
            ],
            [
                '$id' => ID::custom('emailVerification'),
                'type' => Database::VAR_BOOLEAN,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('phoneVerification'),
                'type' => Database::VAR_BOOLEAN,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('reset'),
                'type' => Database::VAR_BOOLEAN,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('sessions'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['subQuerySessions'],
            ],
            [
                '$id' => ID::custom('tokens'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['subQueryTokens'],
            ],
            [
                '$id' => ID::custom('memberships'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['subQueryMemberships'],
            ],
            [
                '$id' => ID::custom('search'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ]
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_name'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['name'],
                'lengths' => [256],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_email'),
                'type' => Database::INDEX_UNIQUE,
                'attributes' => ['email'],
                'lengths' => [320],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_phone'),
                'type' => Database::INDEX_UNIQUE,
                'attributes' => ['phone'],
                'lengths' => [16],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_status'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['status'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_passwordUpdate'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['passwordUpdate'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_registration'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['registration'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_emailVerification'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['emailVerification'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_phoneVerification'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['phoneVerification'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_search'),
                'type' => Database::INDEX_FULLTEXT,
                'attributes' => ['search'],
                'lengths' => [],
                'orders' => [],
            ]
        ],
    ],

    'tokens' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('tokens'),
        'name' => 'Tokens',
        'attributes' => [
            [
                '$id' => ID::custom('userInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('userId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('type'),
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('secret'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 512, // https://www.tutorialspoint.com/how-long-is-the-sha256-hash-in-mysql (512 for encryption)
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['encrypt'],
            ],
            [
                '$id' => ID::custom('expire'),
                'type' => Database::VAR_DATETIME,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['datetime'],
            ],
            [
                '$id' => ID::custom('userAgent'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('ip'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 45, // https://stackoverflow.com/a/166157/2299554
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ]
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_user'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['userInternalId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
        ],
    ],

    'sessions' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('sessions'),
        'name' => 'Sessions',
        'attributes' => [
            [
                '$id' => ID::custom('userInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('userId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('provider'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 128,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('providerUid'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('providerAccessToken'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['encrypt'],
            ],
            [
                '$id' => ID::custom('providerAccessTokenExpiry'),
                'type' => Database::VAR_DATETIME,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['datetime'],
            ],
            [
                '$id' => ID::custom('providerRefreshToken'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['encrypt'],
            ],
            [
                '$id' => ID::custom('secret'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 512, // https://www.tutorialspoint.com/how-long-is-the-sha256-hash-in-mysql (512 for encryption)
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['encrypt'],
            ],
            [
                '$id' => ID::custom('userAgent'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('ip'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 45, // https://stackoverflow.com/a/166157/2299554
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('countryCode'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('osCode'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('osName'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('osVersion'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('clientType'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('clientCode'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('clientName'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('clientVersion'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('clientEngine'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('clientEngineVersion'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('deviceName'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('deviceBrand'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('deviceModel'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_provider_providerUid'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['provider', 'providerUid'],
                'lengths' => [100, 100],
                'orders' => [Database::ORDER_ASC, Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_user'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['userInternalId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
        ],
    ],

    'teams' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('teams'),
        'name' => 'Teams',
        'attributes' => [
            [
                '$id' => ID::custom('name'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 128,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('total'),
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('search'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_search'),
                'type' => Database::INDEX_FULLTEXT,
                'attributes' => ['search'],
                'lengths' => [],
                'orders' => [],
            ],
            [
                '$id' => ID::custom('_key_name'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['name'],
                'lengths' => [128],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_total'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['total'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
        ],
    ],

    'memberships' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('memberships'),
        'name' => 'Memberships',
        'attributes' => [
            [
                '$id' => ID::custom('userInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('userId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('teamInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('teamId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('roles'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 128,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => true,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('invited'),
                'type' => Database::VAR_DATETIME,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['datetime'],
            ],
            [
                '$id' => ID::custom('joined'),
                'type' => Database::VAR_DATETIME,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['datetime'],
            ],
            [
                '$id' => ID::custom('confirm'),
                'type' => Database::VAR_BOOLEAN,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('secret'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['encrypt'],
            ],
            [
                '$id' => ID::custom('search'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_unique'),
                'type' => Database::INDEX_UNIQUE,
                'attributes' => ['teamInternalId', 'userInternalId'],
                'lengths' => [Database::LENGTH_KEY, Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC, Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_user'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['userInternalId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_team'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['teamInternalId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_search'),
                'type' => Database::INDEX_FULLTEXT,
                'attributes' => ['search'],
                'lengths' => [],
                'orders' => [],
            ],
            [
                '$id' => ID::custom('_key_userId'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['userId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_teamId'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['teamId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_invited'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['invited'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_joined'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['joined'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_confirm'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['confirm'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
        ],
    ],

    'buckets' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('buckets'),
        'name' => 'Buckets',
        'attributes' => [
            [
                '$id' => ID::custom('enabled'),
                'type' => Database::VAR_BOOLEAN,
                'signed' => true,
                'size' => 0,
                'format' => '',
                'filters' => [],
                'required' => true,
                'array' => false,
            ],
            [
                '$id' => ID::custom('name'),
                'type' => Database::VAR_STRING,
                'signed' => true,
                'size' => 128,
                'format' => '',
                'filters' => [],
                'required' => true,
                'array' => false,
            ],
            [
                '$id' => ID::custom('fileSecurity'),
                'type' => Database::VAR_BOOLEAN,
                'signed' => true,
                'size' => 1,
                'format' => '',
                'filters' => [],
                'required' => false,
                'array' => false,
            ],
            [
                '$id' => ID::custom('maximumFileSize'),
                'type' => Database::VAR_INTEGER,
                'signed' => false,
                'size' => 8,
                'format' => '',
                'filters' => [],
                'required' => true,
                'array' => false,
            ],
            [
                '$id' => ID::custom('allowedFileExtensions'),
                'type' => Database::VAR_STRING,
                'signed' => true,
                'size' => 64,
                'format' => '',
                'filters' => [],
                'required' => true,
                'array' => true,
            ],
            [
                '$id' => 'compression',
                'type' => Database::VAR_STRING,
                'signed' => true,
                'size' => 10,
                'format' => '',
                'filters' => [],
                'required' => true,
                'array' => false,
            ],
            [
                '$id' => ID::custom('encryption'),
                'type' => Database::VAR_BOOLEAN,
                'signed' => true,
                'size' => 0,
                'format' => '',
                'filters' => [],
                'required' => true,
                'array' => false,
            ],
            [
                '$id' => ID::custom('antivirus'),
                'type' => Database::VAR_BOOLEAN,
                'signed' => true,
                'size' => 0,
                'format' => '',
                'filters' => [],
                'required' => true,
                'array' => false,
            ],
            [
                '$id' => ID::custom('search'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_fulltext_name'),
                'type' => Database::INDEX_FULLTEXT,
                'attributes' => ['name'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_search'),
                'type' => Database::INDEX_FULLTEXT,
                'attributes' => ['search'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_enabled'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['enabled'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_name'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['name'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_fileSecurity'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['fileSecurity'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_maximumFileSize'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['maximumFileSize'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_encryption'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['encryption'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_antivirus'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['antivirus'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
        ]
    ],

    'stats' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('stats'),
        'name' => 'Stats',
        'attributes' => [
            [
                '$id' => ID::custom('metric'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 255,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('region'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 255,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('value'),
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 8,
                'signed' => false,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('time'),
                'type' => Database::VAR_DATETIME,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['datetime'],
            ],
            [
                '$id' => ID::custom('period'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 4,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('type'),
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 1,
                'signed' => false,
                'required' => true,
                'default' => 0, // 0 -> count, 1 -> sum
                'array' => false,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_time'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['time'],
                'lengths' => [],
                'orders' => [Database::ORDER_DESC],
            ],
            [
                '$id' => ID::custom('_key_period_time'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['period', 'time'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_metric_period_time'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['metric', 'period', 'time'],
                'lengths' => [],
                'orders' => [Database::ORDER_DESC],
            ],
        ],
    ],
 ];

 $projectCollections = array_merge([
    'databases' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('databases'),
        'name' => 'Databases',
        'attributes' => [
            [
                '$id' => ID::custom('name'),
                'type' => Database::VAR_STRING,
                'size' => 256,
                'required' => true,
                'signed' => true,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('search'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_fulltext_search'),
                'type' => Database::INDEX_FULLTEXT,
                'attributes' => ['search'],
                'lengths' => [],
                'orders' => [],
            ],
            [
                '$id' => ID::custom('_key_name'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['name'],
                'lengths' => [256],
                'orders' => [Database::ORDER_ASC],
            ],
        ],
    ],

    'attributes' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('attributes'),
        'name' => 'Attributes',
        'attributes' => [
            [
                '$id' => ID::custom('databaseInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('databaseId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => false,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('collectionInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('collectionId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('key'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('type'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('status'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('size'),
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('required'),
                'type' => Database::VAR_BOOLEAN,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('default'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['casting'],
            ],
            [
                '$id' => ID::custom('signed'),
                'type' => Database::VAR_BOOLEAN,
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('array'),
                'type' => Database::VAR_BOOLEAN,
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('format'),
                'type' => Database::VAR_STRING,
                'size' => 64,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('formatOptions'),
                'type' => Database::VAR_STRING,
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => new stdClass(),
                'array' => false,
                'filters' => ['json', 'range', 'enum'],
            ],
            [
                '$id' => ID::custom('filters'),
                'type' => Database::VAR_STRING,
                'size' => 64,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => true,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_db_collection'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['databaseInternalId', 'collectionInternalId'],
                'lengths' => [Database::LENGTH_KEY, Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC, Database::ORDER_ASC],
            ],
        ],
    ],

    'indexes' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('indexes'),
        'name' => 'Indexes',
        'attributes' => [
            [
                '$id' => ID::custom('databaseInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('databaseId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => false,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('collectionInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('collectionId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('key'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('type'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('status'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('attributes'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => true,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('lengths'),
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => true,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('orders'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 4,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => true,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_db_collection'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['databaseInternalId', 'collectionInternalId'],
                'lengths' => [Database::LENGTH_KEY, Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC, Database::ORDER_ASC],
            ],
        ],
    ],

    'functions' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('functions'),
        'name' => 'Functions',
        'attributes' => [
            [
                '$id' => ID::custom('execute'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 128,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => true,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('name'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('enabled'),
                'type' => Database::VAR_BOOLEAN,
                'signed' => true,
                'size' => 0,
                'format' => '',
                'filters' => [],
                'required' => true,
                'array' => false,
            ],
            [
                '$id' => ID::custom('runtime'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('deployment'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('vars'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['subQueryVariables'],
            ],
            [
                '$id' => ID::custom('events'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => true,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('scheduleId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('schedule'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 128,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('timeout'),
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('search'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_search'),
                'type' => Database::INDEX_FULLTEXT,
                'attributes' => ['search'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_name'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['name'],
                'lengths' => [768],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_enabled'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['enabled'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_runtime'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['runtime'],
                'lengths' => [768],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_deployment'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['deployment'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_schedule'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['schedule'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_timeout'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['timeout'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
        ],
    ],

    'deployments' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('deployments'),
        'name' => 'Deployments',
        'attributes' => [
            [
                '$id' => ID::custom('resourceId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('resourceType'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('buildId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                'array' => false,
                '$id' => ID::custom('entrypoint'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => false,
                'default' => null,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('path'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('size'),
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('metadata'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384, // https://tools.ietf.org/html/rfc4288#section-4.2
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['json'],
            ],
            [
                '$id' => ID::custom('chunksTotal'),
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('chunksUploaded'),
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('search'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('activate'),
                'type' => Database::VAR_BOOLEAN,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => false,
                'array' => false,
                'filters' => [],
            ]
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_resource'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['resourceId'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_resource_type'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['resourceType'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_search'),
                'type' => Database::INDEX_FULLTEXT,
                'attributes' => ['search'],
                'lengths' => [],
                'orders' => [],
            ],
            [
                '$id' => ID::custom('_key_entrypoint'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['entrypoint'],
                'lengths' => [768],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_size'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['size'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_buildId'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['buildId'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_activate'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['activate'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
        ],
    ],

    'builds' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('builds'),
        'name' => 'Builds',
        'attributes' => [
            [
                '$id' => ID::custom('startTime'),
                'type' => Database::VAR_DATETIME,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['datetime'],
            ],
            [
                '$id' => ID::custom('endTime'),
                'type' => Database::VAR_DATETIME,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['datetime'],
            ],
            [
                '$id' => ID::custom('duration'),
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('deploymentId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('runtime'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => true,
                'default' => '',
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('status'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => true,
                'default' => 'processing',
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('outputPath'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => false,
                'default' => '',
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('stderr'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 1000000,
                'signed' => true,
                'required' => false,
                'default' => '',
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('stdout'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 1000000,
                'signed' => true,
                'required' => false,
                'default' => '',
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('sourceType'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => true,
                'default' => 'local',
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('source'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => true,
                'default' => '',
                'array' => false,
                'filters' => [],
            ]
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_deployment'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['deploymentId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ]
        ],
    ],

    'executions' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('executions'),
        'name' => 'Executions',
        'attributes' => [
            [
                '$id' => ID::custom('functionId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('deploymentId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                'array' => false,
                '$id' => ID::custom('trigger'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 128,
                'signed' => true,
                'required' => false,
                'default' => null,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('status'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 128,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('response'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 1000000,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('stderr'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 1000000,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('stdout'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 1000000,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('statusCode'),
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('duration'),
                'type' => Database::VAR_FLOAT,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('search'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_function'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['functionId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_fulltext_search'),
                'type' => Database::INDEX_FULLTEXT,
                'attributes' => ['search'],
                'lengths' => [],
                'orders' => [],
            ],
            [
                '$id' => ID::custom('_key_trigger'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['trigger'],
                'lengths' => [128],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_status'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['status'],
                'lengths' => [128],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_statusCode'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['statusCode'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_duration'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['duration'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
        ],
    ],

    'variables' => [
        '$collection' => Database::METADATA,
        '$id' => 'variables',
        'name' => 'variables',
        'attributes' => [
            [
                '$id' => 'functionInternalId',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'functionId',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'key',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'value',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 8192,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [ 'encrypt' ]
            ],
            [
                '$id' => ID::custom('search'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => '_key_function',
                'type' => Database::INDEX_KEY,
                'attributes' => ['functionInternalId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => '_key_uniqueKey',
                'type' => Database::INDEX_UNIQUE,
                'attributes' => ['functionInternalId', 'key'],
                'lengths' => [Database::LENGTH_KEY, Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC, Database::ORDER_ASC],
            ],
            [
                '$id' => '_key_key',
                'type' => Database::INDEX_KEY,
                'attributes' => ['key'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_fulltext_search'),
                'type' => Database::INDEX_FULLTEXT,
                'attributes' => ['search'],
                'lengths' => [],
                'orders' => [],
            ],
        ],
    ],

    'cache' => [
        '$collection' => Database::METADATA,
        '$id' => 'cache',
        'name' => 'Cache',
        'attributes' => [
            [
                '$id' => 'resource',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 255,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'accessedAt',
                'type' => Database::VAR_DATETIME,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['datetime'],
            ],
            [
                '$id' => 'signature',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 255,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
         ],
        'indexes' => [
            [
                '$id' => '_key_accessedAt',
                'type' => Database::INDEX_KEY,
                'attributes' => ['accessedAt'],
                'lengths' => [],
                'orders' => [],
            ],
            [
                '$id' => '_key_resource',
                'type' => Database::INDEX_KEY,
                'attributes' => ['resource'],
                'lengths' => [],
                'orders' => [],
            ],
        ],
    ],
 ], $commonCollections);

 $consoleCollections = array_merge([
    'projects' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('projects'),
        'name' => 'Projects',
        'attributes' => [
            [
                '$id' => ID::custom('teamInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('teamId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('name'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 128,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('region'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 128,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('description'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('database'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('logo'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('url'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('version'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('legalName'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('legalCountry'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('legalState'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('legalCity'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('legalAddress'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('legalTaxId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('services'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => [],
                'array' => false,
                'filters' => ['json'],
            ],
            [
                '$id' => ID::custom('auths'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => [],
                'array' => false,
                'filters' => ['json'],
            ],
            [
                '$id' => ID::custom('authProviders'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => [],
                'array' => false,
                'filters' => ['json', 'encrypt'],
            ],
            [
                '$id' => ID::custom('platforms'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['subQueryPlatforms'],
            ],
            [
                '$id' => ID::custom('webhooks'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['subQueryWebhooks'],
            ],
            [
                '$id' => ID::custom('keys'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['subQueryKeys'],
            ],
            [
                '$id' => ID::custom('domains'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['subQueryDomains'],
            ],
            [
                '$id' => ID::custom('search'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_search'),
                'type' => Database::INDEX_FULLTEXT,
                'attributes' => ['search'],
                'lengths' => [],
                'orders' => [],
            ],
            [
                '$id' => ID::custom('_key_name'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['name'],
                'lengths' => [128],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_team'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['teamId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
        ],
    ],

    'schedules' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('schedules'),
        'name' => 'schedules',
        'attributes' => [
            [
                '$id' => ID::custom('resourceType'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 100,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('resourceId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('resourceUpdatedAt'),
                'type' => Database::VAR_DATETIME,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['datetime'],
            ],
            [
                '$id' => ID::custom('projectId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('schedule'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 100,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('active'),
                'type' => Database::VAR_BOOLEAN,
                'signed' => true,
                'size' => 0,
                'format' => '',
                'filters' => [],
                'required' => false,
                'default' => null,
                'array' => false,
            ],
            [
                '$id' => ID::custom('region'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 10,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_region_resourceType_resourceUpdatedAt'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['region', 'resourceType','resourceUpdatedAt'],
                'lengths' => [],
                'orders' => [],
            ],
            [
                '$id' => ID::custom('_key_region_resourceType_projectId_resourceId'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['region', 'resourceType', 'projectId', 'resourceId'],
                'lengths' => [],
                'orders' => [],
            ],
        ],
    ],

    'platforms' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('platforms'),
        'name' => 'platforms',
        'attributes' => [
            [
                '$id' => ID::custom('projectInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('projectId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('type'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('name'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('key'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('store'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('hostname'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ]
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_project'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['projectInternalId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
        ],
    ],

    'domains' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('domains'),
        'name' => 'domains',
        'attributes' => [
            [
                '$id' => ID::custom('projectInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('projectId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('updated'),
                'type' => Database::VAR_DATETIME,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['datetime'],
            ],
            [
                '$id' => ID::custom('domain'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('tld'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('registerable'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('verification'),
                'type' => Database::VAR_BOOLEAN,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('certificateId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_project'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['projectInternalId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
        ],
    ],

    'keys' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('keys'),
        'name' => 'keys',
        'attributes' => [
            [
                '$id' => ID::custom('projectInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('projectId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => 0,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('name'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('scopes'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => true,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('secret'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 512, // Output of \bin2hex(\random_bytes(128)) => string(256) doubling for encryption
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => ['encrypt'],
            ],
            [
                '$id' => ID::custom('expire'),
                'type' => Database::VAR_DATETIME,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['datetime'],
            ],
            [
                '$id' => ID::custom('accessedAt'),
                'type' => Database::VAR_DATETIME,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['datetime'],
            ],
            [
                '$id' => ID::custom('sdks'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => true,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_project'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['projectInternalId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => '_key_accessedAt',
                'type' => Database::INDEX_KEY,
                'attributes' => ['accessedAt'],
                'lengths' => [],
                'orders' => [],
            ],
        ],
    ],

    'webhooks' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('webhooks'),
        'name' => 'webhooks',
        'attributes' => [
            [
                '$id' => ID::custom('projectInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('projectId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('name'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('url'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('httpUser'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('httpPass'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY, // TODO will the length suffice after encryption?
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['encrypt'],
            ],
            [
                '$id' => ID::custom('security'),
                'type' => Database::VAR_BOOLEAN,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('events'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => true,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('signatureKey'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_project'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['projectInternalId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ]
        ],
    ],

    'certificates' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('certificates'),
        'name' => 'Certificates',
        'attributes' => [
            [
                '$id' => ID::custom('domain'),
                'type' => Database::VAR_STRING,
                'format' => '',
                // The maximum total length of a domain name or number is 255 characters.
                // https://datatracker.ietf.org/doc/html/rfc2821#section-4.5.3.1
                // https://datatracker.ietf.org/doc/html/rfc5321#section-4.5.3.1.2
                'size' => 255,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('issueDate'),
                'type' => Database::VAR_DATETIME,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['datetime'],
            ],
            [
                '$id' => ID::custom('renewDate'),
                'type' => Database::VAR_DATETIME,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['datetime'],
            ],
            [
                '$id' => ID::custom('attempts'),
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('log'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('updated'),
                'type' => Database::VAR_DATETIME,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['datetime'],
            ],
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_domain'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['domain'],
                'lengths' => [255],
                'orders' => [Database::ORDER_ASC],
            ],
        ],
    ],

    'realtime' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('realtime'),
        'name' => 'Realtime Connections',
        'attributes' => [
            [
                '$id' => ID::custom('container'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('timestamp'),
                'type' => Database::VAR_DATETIME,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['datetime'],
            ],
            [
                '$id' => ID::custom('value'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [], //TODO: use json filter
            ]
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_timestamp'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['timestamp'],
                'lengths' => [],
                'orders' => [Database::ORDER_DESC],
            ],
        ]
    ],
 ], $commonCollections);

 $bucketCollections = [
    'files' => [
        '$collection' => ID::custom('buckets'),
        '$id' => ID::custom('files'),
        '$name' => 'Files',
        'attributes' => [
            [
                'array' => false,
                '$id' => ID::custom('bucketId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('name'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('path'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('signature'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('mimeType'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 255, // https://tools.ietf.org/html/rfc4288#section-4.2
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('metadata'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384, // https://tools.ietf.org/html/rfc4288#section-4.2
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['json'],
            ],
            [
                '$id' => ID::custom('sizeOriginal'),
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 8,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('sizeActual'),
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 8,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('algorithm'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 255,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('comment'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('openSSLVersion'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 64,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('openSSLCipher'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 64,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('openSSLTag'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('openSSLIV'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('chunksTotal'),
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('chunksUploaded'),
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('search'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_search'),
                'type' => Database::INDEX_FULLTEXT,
                'attributes' => ['search'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_bucket'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['bucketId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_name'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['name'],
                'lengths' => [768],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_signature'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['signature'],
                'lengths' => [768],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_mimeType'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['mimeType'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_sizeOriginal'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['sizeOriginal'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_chunksTotal'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['chunksTotal'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_chunksUploaded'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['chunksUploaded'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
        ]
    ],
 ];

 $dbCollections = [
    'collections' => [
        '$collection' => ID::custom('databases'),
        '$id' => ID::custom('collections'),
        'name' => 'Collections',
        'attributes' => [
            [
                '$id' => ID::custom('databaseInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('databaseId'),
                'type' => Database::VAR_STRING,
                'signed' => true,
                'size' => Database::LENGTH_KEY,
                'format' => '',
                'filters' => [],
                'required' => true,
                'default' => null,
                'array' => false,
            ],
            [
                '$id' => ID::custom('name'),
                'type' => Database::VAR_STRING,
                'size' => 256,
                'required' => true,
                'signed' => true,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('enabled'),
                'type' => Database::VAR_BOOLEAN,
                'signed' => true,
                'size' => 0,
                'format' => '',
                'filters' => [],
                'required' => true,
                'default' => null,
                'array' => false,
            ],
            [
                '$id' => ID::custom('documentSecurity'),
                'type' => Database::VAR_BOOLEAN,
                'signed' => true,
                'size' => 0,
                'format' => '',
                'filters' => [],
                'required' => true,
                'default' => null,
                'array' => false,
            ],
            [
                '$id' => ID::custom('attributes'),
                'type' => Database::VAR_STRING,
                'size' => 1000000,
                'required' => false,
                'signed' => true,
                'array' => false,
                'filters' => ['subQueryAttributes'],
            ],
            [
                '$id' => ID::custom('indexes'),
                'type' => Database::VAR_STRING,
                'size' => 1000000,
                'required' => false,
                'signed' => true,
                'array' => false,
                'filters' => ['subQueryIndexes'],
            ],
            [
                '$id' => ID::custom('search'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_fulltext_search'),
                'type' => Database::INDEX_FULLTEXT,
                'attributes' => ['search'],
                'lengths' => [],
                'orders' => [],
            ],
            [
                '$id' => ID::custom('_key_name'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['name'],
                'lengths' => [256],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_enabled'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['enabled'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_documentSecurity'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['documentSecurity'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
        ],
    ],
 ];


 $collections = [
    'projects' => $projectCollections,
    'console'  => $consoleCollections,
    'buckets' => $bucketCollections,
    'databases' => $dbCollections
 ];

 return $collections;
