## About s390x

- Dave's Garage at 2023-10: Why Do Mainframes Still Exist? What's Inside One? 40TB, 200+ Cores, AI, and more! https://www.youtube.com/watch?v=ouAG4vXFORc
- https://en.wikipedia.org/wiki/Linux_on_IBM_Z
- [FLOSS 564 Interview about Open Mainframe Project](https://twit.tv/shows/floss-weekly/episodes/564?autostart=false)
- [Open Mainframe Project](https://www.openmainframeproject.org)
- [LinuxOne Community Cloud](https://developer.ibm.com/linuxone/)
- [SWLUG Talk - Linux on the IBM Z mainframe platform](https://www.youtube.com/watch?v=V-5dqnTd09k)
- https://wiki.qemu.org/Documentation/Platforms/S390X
- https://arstechnica.com/information-technology/2023/07/the-ibm-mainframe-how-it-runs-and-why-it-survives/
- https://sdl-hercules-390.github.io/html/
- Big-endian s390x https://community.ibm.com/community/user/ibmz-and-linuxone/blogs/javier-perez1/2021/01/19/endianness-guidance-for-open-source-projects
- The Future of Big Iron: An Interview with IBM’s Christian Jacobi
  - https://morethanmoore.substack.com/p/the-future-of-big-iron-telum-ii-and
  - https://news.ycombinator.com/item?id=41846592

***

## Petclinic s390x

2024-01-20 Petclinic fork https://github.com/xet7/pet , with command `blink redbean.com`

- With Petclinic website, it is possible to add pets, visits to clinic, etc. There is no login system, it is possible to add to database directly at website http://127.0.0.1:8000/ or http://YOUR-COMPUTER-IP-ADDRESS:8000/
- When xet7 added issue about blink segfault at s390x, 5 minutes later jart added fix https://github.com/jart/blink/issues/162
- Blink is x86_86 emulator, similar to qemu https://github.com/jart/blink . With blink, it works at Linux s390x. Without blink, it works at x86_86/arm64 Win/Mac/Linux/BSD, but ASAN security feature does not work yet at arm64, like mentioned at Makefile of https://github.com/xet7/pet . If there is errors, maybe you need to run it with `chmod +x redbean.com && sh -c ./redbean.com`, or also need to install `ape` from https://github.com/jart/cosmopolitan .
- Redbean is webserver https://redbean.dev
- Fullmoon is Lua web framework https://github.com/pkulchenko/fullmoon . Petclinic has fork of Fullmoon, making possible to use SQLite across CGI-like Lua processes of Redbean, like mentioned at Readme https://github.com/xet7/pet
- SQLite has triggers, and it's possible to Redbean's cron like scheduled actions
- By using Makefile with `make all` or `make start` it makes one executeable. When starting, it creates SQLite database to same directory, adding data, with `srv/.lua/*.sql`
- At fork https://github.com/xet7/pet , xet7 added all external `.sql`, Javascript and CSS dependencies directly inside executeable. This can be seen at Makefile, where files from `srv` directory are are added to `.zip` file, that is added to end of `redbean.com` executeable.
- Releases at https://github.com/xet7/pet/releases

### Petclinic Benchmark

At Makefile, xet7 fixed `make benchmark` of wrk benchmarks to to work at Mac M1 `brew install wrk` and Linux `sudo apt install wrk` . But wrk does not yet work at s390x, xet7 added issue about it to https://github.com/jart/blink/issues/163 . If you start with silent mode `./redbean.com -s` , then at M1 Air macOS Sonoma is this benchmark:

```
 ~/Downloads/pet$ make benchmark
wrk -H 'Accept-Encoding: gzip' -t 12 -c 120 http://127.0.0.1:8000/
Running 10s test @ http://127.0.0.1:8000/
  12 threads and 120 connections
  Thread Stats   Avg      Stdev     Max   +/- Stdev
    Latency    73.21ms  136.41ms   1.25s    86.04%
    Req/Sec     7.72k    12.48k   65.33k    89.46%
  600013 requests in 10.09s, 708.40MB read
  Socket errors: connect 0, read 427, write 2, timeout 0
Requests/sec:  59485.18
Transfer/sec:     70.23MB
```

### Lua IDE

- It is possible to show hidden files like `.gitignore` with Lua IDE, ZeroBrane Studio, this way, and also debug redbean: https://github.com/xet7/pet/wiki/Redbean

### QuickJS

 - Unrelated to Lua, there is also QuickJS (similar like Node.js/Bun/Deno), where it is possible to embed Javascript to same Cosmopolitan x86_85/arm64 Win/Mac/Linux/BSD executeable binary https://github.com/xet7/pet/wiki/QuickJS 

***

## Other non-WeKan Open Source projects xet7 tried to build at s390x

- Works:
  - TSC platform game, C++ https://secretchronicles.org/en/news/2020/11/16/tsc-for-s390x-available/
  - Darkest Hour halloween text adventure game, C89, xet7 ported to 30+ CPU/OS https://github.com/xet7/darkesthour
- Does not work yet:
  - V https://github.com/vlang/v/issues/18737
  - LLVM, Zig, Bun https://github.com/wekan/wekan-node20#trying-to-compile-llvm-for-zig-and-bun-at-s390x-fails
  - Deno, because Rust ring (a crypto dependency) does not support s390x https://github.com/wekan/wekan-node20#trying-to-compile-deno-for-s390x-fails

Ported by others, not xet7:
- PostreSQL https://news.ycombinator.com/item?id=38398305


## From xet7, WeKan at s390x

- https://www.openmainframeproject.org/blog/2020/11/20/wekan-open-source-kanban-on-s390x

[xet7](https://github.com/xet7), as maintainer of [WeKan](https://wekan.fi), got access to mainframe at IBM LinuxOne Community Cloud. Access to those servers is monitored, it's running on a real mainframe.

Previously xet7 had ssh access. At 2023-09 xet7 got web console access, and IBM bumped quota to 2 VMs with 8 GB of memory, 200 GB disk and 4 CPUs each. At web console it is possible to create and remove VMs, and select distro like RHEL/SUSE/Ubuntu. xet7 did do-release-upgrade to upgrade newest Ubuntu 23.10.

## Download

- wekan-VERSION-s390x.zip at https://releases.wekan.team/s390x/

## Installing MongoDB for s390x

This Snap package https://snapcraft.io/juju-db , created by Canonical, has MongoDB for various CPU architectures . It is internal package for Canonical's Juju service https://jaas.ai . Snap repo at https://github.com/juju/juju-db-snap and copy at https://github.com/wekan/mongodb-snap

Install Snap for your distro https://snapcraft.io/docs/installing-snapd

Then:

```
ssh yourserver

sudo dnf install nano

sudo reboot

sudo snap install juju-db

sudo snap refresh juju-db --channel=5.3/stable

sudo snap enable juju-db

sudo snap start juju-db

nano .bashrc
```
There add path to commands mongo, mongodump, mongorestore etc
```
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/snap/juju-db/139/usr/lib/s390x-linux-gnu
export PATH="$PATH:/snap/juju-db/139/bin"
```
Save and exit: Ctrl-o Enter Ctrl-x

Exit ssh, and ssh to server again, 
```
exit

ssh yourserver
```
Or alternatively just read new paths to mongo etc commands:
```
source .bashrc
```

Now MongoDB is at localhost port 27017. You connect to CLI with command:
```
mongo
```

### RHEL 8
New info 2022-01-18:

1. Install snapd https://snapcraft.io/docs/installing-snap-on-red-hat

2. Reboot

3. Install MongoDB, so it will be at port 27017:
```
sudo snap install mongo36-configurable
```
4. Install WeKan s390x bundle from:
- [Raspberry Pi](Raspberry-Pi)
- https://releases.wekan.team/s390x/

Old info:
```
sudo yum -y update
sudo yum -y install git nano npm curl wget podman-docker openssl-devel libcurl-devel clang zip unzip
docker run --name wekan-db -d -p 127.0.0.1:27017:27017 mongo
sudo npm -g install n
sudo n 12.18.0  ## newest 12.x from https://nodejs.org
mkdir repos
cd repos
git clone https://github.com/wekan/wekan
cp wekan/start-wekan.sh .
nano start-wekan.sh
# Edit start-wekan.sh for ports and paths, so starts
# "node main.js" at "build" directory".
# Look for version number from https://releases.wekan.team/s390x/
wget https://releases.wekan.team/s390x/wekan-VERSION-s390x.zip
unzip wekan*s390x.zip
./start-wekan.sh
```

### RHEL 7

Node.js LTS newest 12.x release for s390x can be downloaded from https://nodejs.org

MongoDB v4.x Community Server for s390x RHEL7 is at https://www.mongodb.com.
For example files can be like these filenames:
- mongodb-org-mongos-4.2.3-1.el7.s390x.rpm
- mongodb-org-server-4.2.3-1.el7.s390x.rpm
- mongodb-org-shell-4.2.3-1.el7.s390x.rpm
- mongodb-org-tools-4.2.3-1.el7.s390x.rpm

## Install

Installing is similar like at [Raspberry Pi](Raspberry-Pi)

You can start it with start-wekan.sh from https://github.com/wekan/wekan or add SystemD service.

Setup ROOT_URL like described at [Settings](Settings)

At wiki is also info about Caddy/Nginx/Apache etc.

Some related links also at [Platforms](Platforms)

## How this s390x bundle package was created for RHEL 7

1. Install Node.js
2. scp wekan-VERSION.zip bundle to s390x server, and unzip it
2. Clone and build Fibers, copy fibers to bundle, and zip bundle.
```
git clone https://github.com/laverdet/node-fibers
cd node-fibers
node build.js
cd ..
cp -pR /home/linux1/node-fibers/bin/linux-s390x-72-glibc bundle/programs/server/node_modules/fibers/bin/
zip -r wekan-VERSION-s390x.zip bundle
```
