## Learning Course: Your First Meteor 3.1 Application

- https://www.youtube.com/watch?v=aFZzBb2oRi8&list=PLKKckIyt2nF863eP16mvVgWKR4JDyJoKy

## Meteor 3 Example Code

- https://github.com/fredmaiaarantes/simpletasks
  - MIT License
  - https://github.com/xet7/simpletasks
- https://github.com/henriquealbert/meteor-with-prisma
  - MIT License
  - https://github.com/xet7/meteor-with-prisma
- https://github.com/henriquealbert/meteor-pnpm
  - MIT License
  - https://github.com/xet7/meteor-pnpm

## Building Multi Platform Mobile Apps

- TWIM 058: Building Multi Platform Mobile Apps https://www.youtube.com/watch?v=ZTtXRJTUCIU 
- https://www.youtube.com/watch?v=ZTtXRJTUCIU
- https://github.com/jamauro/pwa-kit
- https://wekan.team/app/
- https://github.com/wekan/wekan/wiki/PWA
- Over 100 icons for different platforms https://github.com/wekan/wekan/blob/main/public/site.webmanifest

## Tip to any programmers

- Try to understand any error messages, and what to do to those errors

## Videos about upgrading to Meteor 3

- Storyteller
  - Upcoming:
    - 2024-09-02: Meteor.js generators https://www.youtube.com/watch?v=Z6nY2wqPgSE
    - 2024-09-09: Can we build static web pages with Meteor.js? https://www.youtube.com/watch?v=cr-Nm0YFb1w
    - 2024-09-16: Revisiting Mantra application architecture for today's Meteor.js https://www.youtube.com/watch?v=YyzY7ySqBAg
  - 2024-08-23: TWIM 052: Year of TWIM in review. Trying to of sometime have xet7 at TWIM show again. They recommended people to help xet7 when possible, xet7 is hitting some walls developing WeKan. https://www.youtube.com/watch?v=c5E3uZST4Vs
  - 2024-08-20:
    - Vazco interviewing Storyteller: How to approach building Open Source products? https://www.youtube.com/watch?v=j5BrTYcJDVc
    - Meteor inteviewing Storyteller: Programmer, open source contributor, entrepreneur https://www.youtube.com/watch?v=dsp0_r8uJx8
  - Meteor Roles:
    - 2024-07-33: Meteor Roles the full checkpoint https://www.youtube.com/watch?v=ow1i4UXdbbI
    - 2024-08-12: Meteor Roles building up teams https://www.youtube.com/watch?v=ZAuSYKfV114
  - 2024-07-15: WeKan Upgrades https://www.youtube.com/watch?v=Zjb3m9JsAD0
  - 2024-07-08: Upgrading Meteor examples https://www.youtube.com/watch?v=jzWXxOe93t4
  - Upcoming and past: https://www.youtube.com/@storytellercz/streams
- React.js
  - WeKan uses Blaze and Jade, not React.
  - 2024-09-25:
    - Meteor 3 React Compiler: https://x.com/FilipeNevola/status/1838911432282583432
  - 2024-08-02:
    - https://www.youtube.com/watch?v=NnT7AbVMnj4
    - https://thenewstack.io/after-a-decade-of-react-is-frontend-a-post-react-world-now/
    - https://thenewstack.io/pivoting-from-react-to-native-dom-apis-a-real-world-example/
    - https://thenewstack.io/how-web-components-are-used-at-github-and-salesforce/
    - https://devclass.com/2024/07/22/react-community-splitting-into-full-stack-and-client-only-camps-suggests-survey/
    - https://news.ycombinator.com/item?id=41068685
  - 2024-07-10: Storyteller at React Wroclaw Meetup, talking about Meteor.js and React: https://www.youtube.com/watch?v=4dnM6bXZCz4&t=741s
  - How A Small Team of Developers Created React at Facebook | React.js: The Documentary https://www.youtube.com/watch?v=8pDqJVdNa44
https://www.youtube.com/watch?v=8pDqJVdNa44
- Meteor Dispatches Podcast
  - 46: 2024-07-12: Packages you need in every app https://www.youtube.com/watch?v=S2YkZfKN0DI
  - 25: 2024-02-09: WeKan Security https://www.youtube.com/watch?v=zic-h8jG6F8
  - 16: 2023-12-08: WeKan interview https://www.youtube.com/watch?v=ke-mbnZM3zE
  - Upcoming and past: https://www.youtube.com/@meteorjscommunity/streams
  - Playlists: https://www.youtube.com/@meteorjscommunity/playlists
  - Some recent also had info, how to make dependencies compatible with both Meteor 2 and Meteor 3
- Add Eslint 3 and fix anything found
  - https://www.youtube.com/watch?v=rFjNNNc_7-E
  - https://github.com/quavedev/eslint-plugin
  - https://github.com/quavedev/meteor-template/pull/8

## Upgrading to Meteor 3

- Meteor 3 migration guide: https://v3-migration-docs.meteor.com ( older pages at https://guide.meteor.com/3.0-migration or https://guide.meteor.com/prepare-meteor-3.0 )
- Look at progress of migrated packages https://forums.meteor.com/t/looking-for-help-migrating-packages-to-meteor-3-0/60985
- Migrate from Fibers (works only at Meteor 2 and Node.js 14) to Async/Await (works with Meteor 3 and Node.js 20)
  - Helper tool https://forums.meteor.com/t/blaze-async-migration-helper-babel-plugin-tracker-async-enhance-for-the-client-side-released/60842
  - Info how Async/Await works, from Storyteller: https://github.com/wekan/wekan/wiki/AsyncAwait
- Forums posts about migrating: https://forums.meteor.com
- ( Older version upgrade to newest 2.14 https://guide.meteor.com/2.14-migration )

## Removing unused files

From Meteor Discord chat from someone:

> Nice tool that I found out about today. I was able to remove 58 unused files, functions, exports, types and dependencies 😄
>
> https://knip.dev

## Lint

From Meteor Discord chat from someone:

> We started using https://biomejs.dev to replace eslint and prettier on Galaxy 2, and it's been amazing. It's speedy, easy to configure, and has fewer packages to care about.
>
> Just sharing it here in case someone has never heard about it before


## Building WeKan

- https://github.com/wekan/wekan/wiki/Emoji
- Docs: https://github.com/wekan/wekan/tree/main/docs

## Similar technology

- https://en.wikipedia.org/wiki/JavaScript_engine
- https://en.wikipedia.org/wiki/Single-page_application
- https://en.wikipedia.org/wiki/Web_framework
- https://en.wikipedia.org/wiki/Progressive_web_app
- https://en.wikipedia.org/wiki/Web_2.0
- https://en.wikipedia.org/wiki/Meteor_(web_framework)
- https://en.wikipedia.org/wiki/Next.js
