# <a name="Wekan"></a>Wekan

# <a name="General"></a>General

* [Deep Dive Into WeKan](Deep-Dive-Into-WeKan)
* [Meteor WeKan Roadmap](https://boards.wekan.team/b/D2SzJKZDS4Z48yeQH/wekan-open-source-kanban-board-with-mit-license) - board at Wekan demo
* [Multiverse WeKan Roadmap](https://github.com/wekan/wekan/wiki/WeKan-Multiverse-Roadmap)
* [Docs/Manual](https://github.com/wekan/wekan/discussions/4522)
* [Change Language](Change-Language)
* [Forgot Password](Forgot-Password)
* [About](https://github.com/wekan/wekan/wiki)
* [Test Edge](Test-Edge)
* [WeKan Design Principles](Design-Principles)
* [FAQ](FAQ)
* [IRC FAQ](IRC-FAQ) - answers to questions asked at IRC
* [Team](Team)
* [Press](Press)
* [Blog](https://blog.wekan.team)
* [Wekan vs Trello vs Restyaboard](Wekan-vs-Trello-vs-Restyaboard)
* [Results of Survey 2020-01](https://blog.wekan.team/2020/06/results-of-wekan-survey-2020-01/)

# <a name="NotWeKan"></a>Fake: Not WeKan kanban

* [Hall of Shame: Fake companies that are NOT WeKan kanban](https://github.com/wekan/wekan/wiki/Hall-of-Shame:-Fake-companies)
* [Others NOT related to WeKan kanban](NOT-related-to-Wekan)

# <a name="Security"></a>Security

* [Allow private boards only: Disable Public Boards](Allow-private-boards-only)
* [Security Disclosure and details of Security in Wekan](https://github.com/wekan/wekan/blob/main/SECURITY.md)
* [Security issues](https://github.com/wekan/wekan/issues?q=is%3Aissue+is%3Aopen+label%3ASecurity)
* [Password Hashing](Password-Hashing)

# <a name="Scaling"></a>Scaling

* [Cron: Hourly restart WeKan, because of memory leaks](Cron)
* [Maybe: Add more RAM to Node.js to prevent crash](https://github.com/wekan/wekan/issues/3585)
* [Clustering AWS etc](AWS)
* [Scaling](Scaling)
* [Kubernetes](https://github.com/wekan/wekan/tree/main/helm/wekan)
* [Redis Oplog](https://github.com/cult-of-coders/redis-oplog)
* [Meteor Scaling](https://galaxy-guide.meteor.com/scaling.html) at [Meteor Cloud](https://www.meteor.com/cloud)
* [Scaling at Meteor forums](https://forums.meteor.com/t/meteor-scaling-performance-best-practices/52886/16)

# <a name="Migrating"></a>Migrating

* [From Previous Export, paste big WeKan JSON](https://github.com/wekan/wekan/wiki/From-Previous-Export)
* [Progress: Import/Export/Sync](Sync)
* [From CSV/TSV](CSV)
* [From Trello](Migrating-from-Trello)
* [From Jira](Jira)
* [From Asana](Asana)
* [From Zenkit](ZenKit)
* [From old Wekan manually](Migrating-from-old-Wekan-manually)
* [Converting Meteor Stylus to CSS](Converting-Meteor-Stylus-to-CSS)

# <a name="Support"></a>Support priorities for new features and bugfixes

1) [Commercial Support](https://wekan.team/commercial-support/)
2) [Community Support](https://github.com/wekan/wekan/issues)
3) [Debugging](Debugging)

# Backup

* [Backup and Restore](Backup)

# <a name="Repair"></a>Repair

* [Repair MongoDB](Repair-MongoDB)
* [Using Meteor MongoDB to repair files](Export-from-Wekan-Sandstorm-grain-.zip-file)
* [If board does not open and keeps loading](If-board-does-not-open-and-keeps-loading)
* [Repair Docker](Repair-Docker)

# <a name="Themes"></a> Themes

* [Themes](Custom-CSS-themes)
* [Dark Mode](Dark-Mode)

# <a name="MarkdownSyntax"></a>Markdown Syntax

* [Wekan Markdown](Wekan-Markdown)
* [Emoji](Emoji)
* [Mermaid Diagram](Mermaid-Diagram) DOES NOT WORK ANYMORE
* [Numbered text](Numbered-text)

# <a name="LoginAuth"></a>Login Auth

* [Automatic login](autologin)
* [Disable Password Login](Disable-Password-Login)
* [Forgot Password](Forgot-Password)
* [Admin: Impersonate user](Impersonate-user)
* [Adding Users](Adding-users)
* [Active users Presence](https://github.com/wekan/wekan/issues/3734)
* [Accounts Lockout: Brute force login protection](Accounts-Lockout)
* [LDAP](LDAP)
* [LDAP AD Simple Auth](LDAP-AD-Simple-Auth)
* [Keycloak](Keycloak)
* [Google login](Google-login)
* [Azure](Azure)
* [OAuth2](OAuth2), Auth0, GitLab, RocketChat
* [Oracle OIM on premise using OAuth2](Oracle-OIM)
* [ADFS 4.0 using OAuth2 and OpenID](ADFS)
* [Azure AD B2C using OAuth2](B2C)
* [Nextcloud](Nextcloud)
* [CAS](CAS) Please test
* [SAML](SAML) Please test
* [Zitadel](Zitadel)

# <a name="Logs"></a>Metrics, Logs, Stats

* [Metrics](Metrics)
* [Logs](Logs)
* [Stats](Features#stats)

# <a name="Integrations"></a>Integrations

* [IFTTT](IFTTT)
* [n8n Wekan docs](https://docs.n8n.io/nodes/n8n-nodes-base.wekan/#example-usage) - [n8n GitHub](https://github.com/n8n-io/n8n)
* [Integrations](Integrations)
* [Gogs](https://github.com/wekan/wekan-gogs)

# <a name="Time"></a>Time

* [Time Tracking](Time-Tracking)
* [Gantt Chart](Gantt)
* [Due Date](Due-Date)
* [Day of week start](Day-of-week-start)
* [Calendar](Calendar)

# <a name="Features"></a>Features

* [Linked Cards](Linked-Cards)
* [Drag Drop](https://github.com/wekan/wekan/wiki/Drag-Drop) on Mobile and Desktop
* [Rclone: Store attachments to cloud storage like S3, MinIO, etc](Rclone)
* [Python based features](Python)
* [Burndown and Velocity Chart](Burndown-and-Velocity-Chart)
* [Wait Spinners](Wait-Spinners)
* [Translations](Translations)
* [Default Language for All Users](https://github.com/wekan/wekan/issues/3927)
* [Roadmap](Roadmap)
* [Features](Features)
* [Planning Poker](Planning-Poker)
* [Scaling](Scaling)
* [Custom Logo](Custom-Logo)
* [Subtasks](Subtasks) <== Has fix
* [Templates](Templates)
* [Cover](Cover)
* [Archive and Delete](Archive-and-Delete)
* [Custom Fields](Custom-Fields)
* [Fix Export board menu not visible on some boards](https://github.com/wekan/wekan/issues/1060)
* [RAM usage](https://github.com/wekan/wekan/issues/1088#issuecomment-311843230)
* [Demo](https://wekan.indie.host/b/t2YaGmyXgNkppcFBq/wekan-fork-roadmap)
* [Swimlane Documentation](Swimlanes)
* [Customize Translations](Customize-Translations)

# <a name="Email"></a>Email

* [Email](Troubleshooting-Mail)

# <a name="Settings"></a>Required Settings

* [Requirements](Requirements)
* [Ports, hostsfile, how Internet works](https://github.com/wekan/wekan/issues/2896)
* [ROOT_URL Settings](Settings)

# <a name="Platforms"></a>Download

* [Download Wekan for various Platforms](Platforms): Supported by xet7, Operating Systems, NAS, Cloud
* [Helm Chart for Kubernetes](Helm)

# <a name="Webservers"></a>Webservers

* [Caddy](Caddy-Webserver-Config)
* [Nginx](Nginx-Webserver-Config)
* [Apache](Apache)
* [OpenLiteSpeed](https://github.com/wekan/wekan/issues/3334#issuecomment-723651328)
* [Local self signed TLS](Local-self-signed-TLS)
* [Let's Encrypt and Google Auth](Let's-Encrypt-and-Google-Auth)
* [TLS with Node.js](https://github.com/wekan/wekan/issues/916)
* [Traefik and self-signed SSL certs](Traefik-and-self-signed-SSL-certs)

# <a name="API"></a>REST API Docs

* [REST API Code](REST-API-Code)
* [Login](REST-API)
* [User](REST-API-User)
* [Role](REST-API-Role)
* [Boards](REST-API-Boards)
* [Lists](REST-API-Lists)
* [Cards](REST-API-Cards)
* [Checklists](REST-API-Checklists)
* [Swimlanes](REST-API-Swimlanes)
* [Custom Fields](REST-API-Custom-Fields)
* [Integrations](REST-API-Integrations)

# <a name="api-issue"></a>REST API issue

* [REST API Issue](https://github.com/wekan/wekan/issues/1037)

# <a name="api-client-code"></a>REST API client code

* [Example: New card with Python3 and REST API](New-card-with-Python3-and-REST-API)
* [Python client to REST API](https://github.com/wekan/wekan-python-api-client)
* [Go client to REST API](https://github.com/wekan/wego)
* [Java](Java)
* [Wekan Sandstorm cards to CSV using Python](Wekan-Sandstorm-cards-to-CSV-using-Python)
* [Excel and VBA](Excel-and-VBA)

# <a name="Webhooks"></a>Webhooks

* [Global Webhook](https://github.com/wekan/wekan/pull/2665)
* [Limiting Webhook data](https://github.com/wekan/wekan/issues/2830)
* [Receiving Webhooks](Receiving-Webhooks)
* [Outgoing Webhook to Discord/Slack/RocketChat/Riot](Outgoing-Webhook-to-Discord)
* [Outgoing Webhook to NodeRed](https://github.com/wekan/wekan/issues/2017)
* [Outgoing Webhook to PowerShell](https://github.com/wekan/wekan/issues/2518)
* [Security: Webhook and CA](WebHook-And-CA)
* [Outgoing Webhooks Data](Webhook-data)
* [Outgoing Webhooks and Let's Encrypt](WebHook-And-CA)
* Outgoing Webhooks [Original Pull Request](https://github.com/wekan/wekan/pull/1119), [multiple Webhooks](https://github.com/wekan/wekan/pull/1199), [more parameters and response order](https://github.com/wekan/wekan/pull/1263)

# <a name="Case-Studies"></a>Case Studies

* [Implementing GDPR](GDPR)

# <a name="Development"></a>Development

* [Kadira integration](https://github.com/wekan/wekan/issues/2152)
* [Debugging](Debugging)
* [Developer Docs for Standalone Wekan](Developer-Documentation)
* [Developer Docs for Sandstorm Wekan](https://github.com/wekan/wekan-maintainer/wiki/Developing-Wekan-for-Sandstorm)
* [Adding new Snap setting to code](Adding-new-Snap-settings-to-code)
* [Directory Structure](Directory-Structure)
* [Building Wekan for Sandstorm](https://github.com/wekan/wekan-maintainer/wiki/Building-Wekan-for-Sandstorm)
* [Docs - Sandstorm etc](https://github.com/wekan/wekan/labels/Documentation)
* [Beginner](https://github.com/wekan/wekan/labels/Beginner)
* [Maintainer FAQ](https://github.com/wekan/wekan-maintainer/wiki/FAQ)

# <a name="Issues"></a>Issues

* [Bugs](https://github.com/wekan/wekan/issues?q=is%3Aissue+is%3Aopen+label%3ABug)
* [Feature requests](https://github.com/wekan/wekan/issues?utf8=%E2%9C%93&q=is%3Aissue%20is%3Aopen%20feature)
* [Import / Export](https://github.com/wekan/wekan/issues?q=is%3Aissue+is%3Aopen+label%3AFeature%3AImport-export)
* [Drag and Drop](https://github.com/wekan/wekan/labels/Feature%3ADrag-and-drop)
* [Accessibility](https://github.com/wekan/wekan/labels/Accessibility)
* [Navigation:Keyboard](https://github.com/wekan/wekan/labels/Navigation%3AKeyboard)
* [Targets:Mobile-web](https://github.com/wekan/wekan/labels/Targets%3AMobile-web)
* [REST API](https://github.com/wekan/wekan/labels/API%3AREST)
* [Admin Panel](https://github.com/wekan/wekan/issues?q=is%3Aissue+is%3Aopen+label%3AFeature%3AAdmin-Panel)
* [Encryption](https://github.com/wekan/wekan/issues?q=is%3Aissue+is%3Aopen+label%3AFeature%3AEncryption)
* [Permissions](https://github.com/wekan/wekan/issues?q=is%3Aissue+is%3Aopen+label%3AFeature%3AUser-accounts%3APermissions)
* [Logs](https://github.com/wekan/wekan/issues?q=is%3Aissue+is%3Aopen+label%3AFeature%3ALogs)
* [Notifications](https://github.com/wekan/wekan/issues?q=is%3Aissue+is%3Aopen+label%3AFeature%3ANotifications)
* [Filters](https://github.com/wekan/wekan/issues?q=is%3Aissue+is%3Aopen+label%3AFeature%3AFilters)
* [Checklists](https://github.com/wekan/wekan/issues?q=is%3Aissue+is%3Aopen+label%3AFeature%3ACards%3AChecklists)
* [Swimlanes](https://github.com/wekan/wekan/issues?q=is%3Aissue+is%3Aopen+label%3AFeature%3ACards%3ASwimlanes)
* [LibreJS](https://github.com/wekan/wekan/issues/1040)
* [Markdown](https://github.com/wekan/wekan/issues?q=is%3Aissue+is%3Aopen+label%3AFeature%3AMarkdown)