// config keys
export const MIDSCENE_OPENAI_INIT_CONFIG_JSON =
  'MIDSCENE_OPENAI_INIT_CONFIG_JSON';
export const MIDSCENE_MODEL_NAME = 'MIDSCENE_MODEL_NAME';
export const MIDSCENE_LANGSMITH_DEBUG = 'MIDSCENE_LANGSMITH_DEBUG';
export const MIDSCENE_DEBUG_AI_PROFILE = 'MIDSCENE_DEBUG_AI_PROFILE';
export const MIDSCENE_DEBUG_AI_RESPONSE = 'MIDSCENE_DEBUG_AI_RESPONSE';
export const MIDSCENE_DANGEROUSLY_PRINT_ALL_CONFIG =
  'MIDSCENE_DANGEROUSLY_PRINT_ALL_CONFIG';
export const MIDSCENE_DEBUG_MODE = 'MIDSCENE_DEBUG_MODE';
export const MIDSCENE_MCP_USE_PUPPETEER_MODE =
  'MIDSCENE_MCP_USE_PUPPETEER_MODE';
export const MIDSCENE_MCP_CHROME_PATH = 'MIDSCENE_MCP_CHROME_PATH';
export const MIDSCENE_MCP_ANDROID_MODE = 'MIDSCENE_MCP_ANDROID_MODE';
export const DOCKER_CONTAINER = 'DOCKER_CONTAINER';
export const MIDSCENE_FORCE_DEEP_THINK = 'MIDSCENE_FORCE_DEEP_THINK';

export const MIDSCENE_OPENAI_SOCKS_PROXY = 'MIDSCENE_OPENAI_SOCKS_PROXY';
export const MIDSCENE_OPENAI_HTTP_PROXY = 'MIDSCENE_OPENAI_HTTP_PROXY';
export const OPENAI_API_KEY = 'OPENAI_API_KEY';
export const OPENAI_BASE_URL = 'OPENAI_BASE_URL';
export const OPENAI_MAX_TOKENS = 'OPENAI_MAX_TOKENS';

export const MIDSCENE_ADB_PATH = 'MIDSCENE_ADB_PATH';
export const MIDSCENE_ADB_REMOTE_HOST = 'MIDSCENE_ADB_REMOTE_HOST';
export const MIDSCENE_ADB_REMOTE_PORT = 'MIDSCENE_ADB_REMOTE_PORT';
export const MIDSCENE_ANDROID_IME_STRATEGY = 'MIDSCENE_ANDROID_IME_STRATEGY';

export const MIDSCENE_IOS_DEVICE_UDID = 'MIDSCENE_IOS_DEVICE_UDID';
export const MIDSCENE_IOS_SIMULATOR_UDID = 'MIDSCENE_IOS_SIMULATOR_UDID';

export const MIDSCENE_CACHE = 'MIDSCENE_CACHE';
export const MIDSCENE_USE_VLM_UI_TARS = 'MIDSCENE_USE_VLM_UI_TARS';
export const MIDSCENE_USE_QWEN_VL = 'MIDSCENE_USE_QWEN_VL';
export const MIDSCENE_USE_QWEN3_VL = 'MIDSCENE_USE_QWEN3_VL';
export const MIDSCENE_USE_DOUBAO_VISION = 'MIDSCENE_USE_DOUBAO_VISION';
export const MIDSCENE_USE_GEMINI = 'MIDSCENE_USE_GEMINI';
export const MIDSCENE_USE_VL_MODEL = 'MIDSCENE_USE_VL_MODEL';
export const MATCH_BY_POSITION = 'MATCH_BY_POSITION';
export const MIDSCENE_API_TYPE = 'MIDSCENE-API-TYPE';
export const MIDSCENE_REPORT_TAG_NAME = 'MIDSCENE_REPORT_TAG_NAME';

export const MIDSCENE_REPLANNING_CYCLE_LIMIT =
  'MIDSCENE_REPLANNING_CYCLE_LIMIT';

export const MIDSCENE_PREFERRED_LANGUAGE = 'MIDSCENE_PREFERRED_LANGUAGE';

export const MIDSCENE_USE_AZURE_OPENAI = 'MIDSCENE_USE_AZURE_OPENAI';
export const MIDSCENE_AZURE_OPENAI_SCOPE = 'MIDSCENE_AZURE_OPENAI_SCOPE';
export const MIDSCENE_AZURE_OPENAI_INIT_CONFIG_JSON =
  'MIDSCENE_AZURE_OPENAI_INIT_CONFIG_JSON';

export const MIDSCENE_CACHE_MAX_FILENAME_LENGTH =
  'MIDSCENE_CACHE_MAX_FILENAME_LENGTH';

export const AZURE_OPENAI_ENDPOINT = 'AZURE_OPENAI_ENDPOINT';
export const AZURE_OPENAI_KEY = 'AZURE_OPENAI_KEY';
export const AZURE_OPENAI_API_VERSION = 'AZURE_OPENAI_API_VERSION';
export const AZURE_OPENAI_DEPLOYMENT = 'AZURE_OPENAI_DEPLOYMENT';

export const MIDSCENE_USE_ANTHROPIC_SDK = 'MIDSCENE_USE_ANTHROPIC_SDK';
export const ANTHROPIC_API_KEY = 'ANTHROPIC_API_KEY';

export const MIDSCENE_RUN_DIR = 'MIDSCENE_RUN_DIR';

// default new
export const MIDSCENE_OPENAI_BASE_URL = 'MIDSCENE_OPENAI_BASE_URL';
export const MIDSCENE_OPENAI_API_KEY = 'MIDSCENE_OPENAI_API_KEY';
export const MIDSCENE_OPENAI_USE_AZURE = 'MIDSCENE_OPENAI_USE_AZURE';
export const MIDSCENE_AZURE_OPENAI_KEY = 'MIDSCENE_AZURE_OPENAI_KEY';
export const MIDSCENE_AZURE_OPENAI_ENDPOINT = 'MIDSCENE_AZURE_OPENAI_ENDPOINT';
export const MIDSCENE_AZURE_OPENAI_API_VERSION =
  'MIDSCENE_AZURE_OPENAI_API_VERSION';
export const MIDSCENE_AZURE_OPENAI_DEPLOYMENT =
  'MIDSCENE_AZURE_OPENAI_DEPLOYMENT';
export const MIDSCENE_ANTHROPIC_API_KEY = 'MIDSCENE_ANTHROPIC_API_KEY';
export const MIDSCENE_VL_MODE = 'MIDSCENE_VL_MODE';

// VQA
export const MIDSCENE_VQA_MODEL_NAME = 'MIDSCENE_VQA_MODEL_NAME';
export const MIDSCENE_VQA_OPENAI_SOCKS_PROXY =
  'MIDSCENE_VQA_OPENAI_SOCKS_PROXY';
export const MIDSCENE_VQA_OPENAI_HTTP_PROXY = 'MIDSCENE_VQA_OPENAI_HTTP_PROXY';
export const MIDSCENE_VQA_OPENAI_BASE_URL = 'MIDSCENE_VQA_OPENAI_BASE_URL';
export const MIDSCENE_VQA_OPENAI_API_KEY = 'MIDSCENE_VQA_OPENAI_API_KEY';
export const MIDSCENE_VQA_OPENAI_INIT_CONFIG_JSON =
  'MIDSCENE_VQA_OPENAI_INIT_CONFIG_JSON';
export const MIDSCENE_VQA_OPENAI_USE_AZURE = 'MIDSCENE_VQA_OPENAI_USE_AZURE';
export const MIDSCENE_VQA_USE_AZURE_OPENAI = 'MIDSCENE_VQA_USE_AZURE_OPENAI';
export const MIDSCENE_VQA_AZURE_OPENAI_SCOPE =
  'MIDSCENE_VQA_AZURE_OPENAI_SCOPE';
export const MIDSCENE_VQA_AZURE_OPENAI_KEY = 'MIDSCENE_VQA_AZURE_OPENAI_KEY';
export const MIDSCENE_VQA_AZURE_OPENAI_ENDPOINT =
  'MIDSCENE_VQA_AZURE_OPENAI_ENDPOINT';
export const MIDSCENE_VQA_AZURE_OPENAI_API_VERSION =
  'MIDSCENE_VQA_AZURE_OPENAI_API_VERSION';
export const MIDSCENE_VQA_AZURE_OPENAI_DEPLOYMENT =
  'MIDSCENE_VQA_AZURE_OPENAI_DEPLOYMENT';
export const MIDSCENE_VQA_AZURE_OPENAI_INIT_CONFIG_JSON =
  'MIDSCENE_VQA_AZURE_OPENAI_INIT_CONFIG_JSON';
export const MIDSCENE_VQA_USE_ANTHROPIC_SDK = 'MIDSCENE_VQA_USE_ANTHROPIC_SDK';
export const MIDSCENE_VQA_ANTHROPIC_API_KEY = 'MIDSCENE_VQA_ANTHROPIC_API_KEY';
export const MIDSCENE_VQA_VL_MODE = 'MIDSCENE_VQA_VL_MODE';

// PLANNING
export const MIDSCENE_PLANNING_MODEL_NAME = 'MIDSCENE_PLANNING_MODEL_NAME';
export const MIDSCENE_PLANNING_OPENAI_SOCKS_PROXY =
  'MIDSCENE_PLANNING_OPENAI_SOCKS_PROXY';
export const MIDSCENE_PLANNING_OPENAI_HTTP_PROXY =
  'MIDSCENE_PLANNING_OPENAI_HTTP_PROXY';
export const MIDSCENE_PLANNING_OPENAI_BASE_URL =
  'MIDSCENE_PLANNING_OPENAI_BASE_URL';
export const MIDSCENE_PLANNING_OPENAI_API_KEY =
  'MIDSCENE_PLANNING_OPENAI_API_KEY';
export const MIDSCENE_PLANNING_OPENAI_INIT_CONFIG_JSON =
  'MIDSCENE_PLANNING_OPENAI_INIT_CONFIG_JSON';
export const MIDSCENE_PLANNING_OPENAI_USE_AZURE =
  'MIDSCENE_PLANNING_OPENAI_USE_AZURE';
export const MIDSCENE_PLANNING_USE_AZURE_OPENAI =
  'MIDSCENE_PLANNING_USE_AZURE_OPENAI';
export const MIDSCENE_PLANNING_AZURE_OPENAI_SCOPE =
  'MIDSCENE_PLANNING_AZURE_OPENAI_SCOPE';
export const MIDSCENE_PLANNING_AZURE_OPENAI_KEY =
  'MIDSCENE_PLANNING_AZURE_OPENAI_KEY';
export const MIDSCENE_PLANNING_AZURE_OPENAI_ENDPOINT =
  'MIDSCENE_PLANNING_AZURE_OPENAI_ENDPOINT';
export const MIDSCENE_PLANNING_AZURE_OPENAI_API_VERSION =
  'MIDSCENE_PLANNING_AZURE_OPENAI_API_VERSION';
export const MIDSCENE_PLANNING_AZURE_OPENAI_DEPLOYMENT =
  'MIDSCENE_PLANNING_AZURE_OPENAI_DEPLOYMENT';
export const MIDSCENE_PLANNING_AZURE_OPENAI_INIT_CONFIG_JSON =
  'MIDSCENE_PLANNING_AZURE_OPENAI_INIT_CONFIG_JSON';
export const MIDSCENE_PLANNING_USE_ANTHROPIC_SDK =
  'MIDSCENE_PLANNING_USE_ANTHROPIC_SDK';
export const MIDSCENE_PLANNING_ANTHROPIC_API_KEY =
  'MIDSCENE_PLANNING_ANTHROPIC_API_KEY';
export const MIDSCENE_PLANNING_VL_MODE = 'MIDSCENE_PLANNING_VL_MODE';

// GROUNDING
export const MIDSCENE_GROUNDING_MODEL_NAME = 'MIDSCENE_GROUNDING_MODEL_NAME';
export const MIDSCENE_GROUNDING_OPENAI_SOCKS_PROXY =
  'MIDSCENE_GROUNDING_OPENAI_SOCKS_PROXY';
export const MIDSCENE_GROUNDING_OPENAI_HTTP_PROXY =
  'MIDSCENE_GROUNDING_OPENAI_HTTP_PROXY';
export const MIDSCENE_GROUNDING_OPENAI_BASE_URL =
  'MIDSCENE_GROUNDING_OPENAI_BASE_URL';
export const MIDSCENE_GROUNDING_OPENAI_API_KEY =
  'MIDSCENE_GROUNDING_OPENAI_API_KEY';
export const MIDSCENE_GROUNDING_OPENAI_INIT_CONFIG_JSON =
  'MIDSCENE_GROUNDING_OPENAI_INIT_CONFIG_JSON';
export const MIDSCENE_GROUNDING_OPENAI_USE_AZURE =
  'MIDSCENE_GROUNDING_OPENAI_USE_AZURE';
export const MIDSCENE_GROUNDING_USE_AZURE_OPENAI =
  'MIDSCENE_GROUNDING_USE_AZURE_OPENAI';
export const MIDSCENE_GROUNDING_AZURE_OPENAI_SCOPE =
  'MIDSCENE_GROUNDING_AZURE_OPENAI_SCOPE';
export const MIDSCENE_GROUNDING_AZURE_OPENAI_KEY =
  'MIDSCENE_GROUNDING_AZURE_OPENAI_KEY';
export const MIDSCENE_GROUNDING_AZURE_OPENAI_ENDPOINT =
  'MIDSCENE_GROUNDING_AZURE_OPENAI_ENDPOINT';
export const MIDSCENE_GROUNDING_AZURE_OPENAI_API_VERSION =
  'MIDSCENE_GROUNDING_AZURE_OPENAI_API_VERSION';
export const MIDSCENE_GROUNDING_AZURE_OPENAI_DEPLOYMENT =
  'MIDSCENE_GROUNDING_AZURE_OPENAI_DEPLOYMENT';
export const MIDSCENE_GROUNDING_AZURE_OPENAI_INIT_CONFIG_JSON =
  'MIDSCENE_GROUNDING_AZURE_OPENAI_INIT_CONFIG_JSON';
export const MIDSCENE_GROUNDING_USE_ANTHROPIC_SDK =
  'MIDSCENE_GROUNDING_USE_ANTHROPIC_SDK';
export const MIDSCENE_GROUNDING_ANTHROPIC_API_KEY =
  'MIDSCENE_GROUNDING_ANTHROPIC_API_KEY';
export const MIDSCENE_GROUNDING_VL_MODE = 'MIDSCENE_GROUNDING_VL_MODE';

// @deprecated
export const OPENAI_USE_AZURE = 'OPENAI_USE_AZURE';

/**
 * env keys declared but unused
 */
export const UNUSED_ENV_KEYS = [MIDSCENE_DANGEROUSLY_PRINT_ALL_CONFIG];

/**
 * env keys for debug or basic run
 * can not be override by overrideAIConfig
 */
export const BASIC_ENV_KEYS = [
  MIDSCENE_DEBUG_MODE,
  MIDSCENE_DEBUG_AI_PROFILE,
  MIDSCENE_DEBUG_AI_RESPONSE,
  MIDSCENE_RUN_DIR,
] as const;

export const BOOLEAN_ENV_KEYS = [
  MIDSCENE_CACHE,
  MIDSCENE_LANGSMITH_DEBUG,
  MIDSCENE_FORCE_DEEP_THINK,
  MIDSCENE_MCP_USE_PUPPETEER_MODE,
  MIDSCENE_MCP_ANDROID_MODE,
] as const;

export const NUMBER_ENV_KEYS = [
  MIDSCENE_CACHE_MAX_FILENAME_LENGTH,
  MIDSCENE_REPLANNING_CYCLE_LIMIT,
] as const;

export const STRING_ENV_KEYS = [
  OPENAI_MAX_TOKENS,
  MIDSCENE_ADB_PATH,
  MIDSCENE_ADB_REMOTE_HOST,
  MIDSCENE_ADB_REMOTE_PORT,
  MIDSCENE_ANDROID_IME_STRATEGY,
  MIDSCENE_IOS_DEVICE_UDID,
  MIDSCENE_IOS_SIMULATOR_UDID,
  MIDSCENE_REPORT_TAG_NAME,
  MIDSCENE_PREFERRED_LANGUAGE,
  MATCH_BY_POSITION,
  MIDSCENE_MCP_CHROME_PATH,
  DOCKER_CONTAINER,
] as const;

/**
 * Non model related env keys, used for globally controlling the behavior of midscene
 * Can not be override by agent.modelConfig but can be override by overrideAIConfig
 * Can be access at any time
 */
export const GLOBAL_ENV_KEYS = [
  ...BOOLEAN_ENV_KEYS,
  ...NUMBER_ENV_KEYS,
  ...STRING_ENV_KEYS,
] as const;

/**
 * Model related eve keys, used for declare which model to use.
 * Can be override by both agent.modelConfig and overrideAIConfig
 * Can only be access after agent.constructor
 */
export const MODEL_ENV_KEYS = [
  // model default
  MIDSCENE_MODEL_NAME,
  MIDSCENE_OPENAI_INIT_CONFIG_JSON,
  MIDSCENE_OPENAI_API_KEY,
  MIDSCENE_OPENAI_BASE_URL,
  MIDSCENE_OPENAI_USE_AZURE,
  MIDSCENE_OPENAI_SOCKS_PROXY,
  MIDSCENE_OPENAI_HTTP_PROXY,
  MIDSCENE_USE_AZURE_OPENAI,
  MIDSCENE_AZURE_OPENAI_SCOPE,
  MIDSCENE_AZURE_OPENAI_INIT_CONFIG_JSON,
  MIDSCENE_USE_ANTHROPIC_SDK,
  MIDSCENE_USE_VLM_UI_TARS,
  MIDSCENE_USE_QWEN_VL,
  MIDSCENE_USE_QWEN3_VL,
  MIDSCENE_USE_DOUBAO_VISION,
  MIDSCENE_USE_GEMINI,
  MIDSCENE_USE_VL_MODEL,
  ANTHROPIC_API_KEY,
  MIDSCENE_AZURE_OPENAI_ENDPOINT,
  MIDSCENE_AZURE_OPENAI_KEY,
  MIDSCENE_AZURE_OPENAI_API_VERSION,
  MIDSCENE_AZURE_OPENAI_DEPLOYMENT,
  MIDSCENE_VL_MODE,
  // model default legacy
  OPENAI_API_KEY,
  OPENAI_BASE_URL,
  OPENAI_USE_AZURE,
  ANTHROPIC_API_KEY,
  AZURE_OPENAI_ENDPOINT,
  AZURE_OPENAI_KEY,
  AZURE_OPENAI_API_VERSION,
  AZURE_OPENAI_DEPLOYMENT,
  // VQA
  MIDSCENE_VQA_MODEL_NAME,
  MIDSCENE_VQA_OPENAI_SOCKS_PROXY,
  MIDSCENE_VQA_OPENAI_HTTP_PROXY,
  MIDSCENE_VQA_OPENAI_BASE_URL,
  MIDSCENE_VQA_OPENAI_API_KEY,
  MIDSCENE_VQA_OPENAI_INIT_CONFIG_JSON,
  MIDSCENE_VQA_OPENAI_USE_AZURE,
  MIDSCENE_VQA_USE_AZURE_OPENAI,
  MIDSCENE_VQA_AZURE_OPENAI_SCOPE,
  MIDSCENE_VQA_AZURE_OPENAI_KEY,
  MIDSCENE_VQA_AZURE_OPENAI_ENDPOINT,
  MIDSCENE_VQA_AZURE_OPENAI_API_VERSION,
  MIDSCENE_VQA_AZURE_OPENAI_DEPLOYMENT,
  MIDSCENE_VQA_AZURE_OPENAI_INIT_CONFIG_JSON,
  MIDSCENE_VQA_USE_ANTHROPIC_SDK,
  MIDSCENE_VQA_ANTHROPIC_API_KEY,
  MIDSCENE_VQA_VL_MODE,
  // PLANNING
  MIDSCENE_PLANNING_MODEL_NAME,
  MIDSCENE_PLANNING_OPENAI_SOCKS_PROXY,
  MIDSCENE_PLANNING_OPENAI_HTTP_PROXY,
  MIDSCENE_PLANNING_OPENAI_BASE_URL,
  MIDSCENE_PLANNING_OPENAI_API_KEY,
  MIDSCENE_PLANNING_OPENAI_INIT_CONFIG_JSON,
  MIDSCENE_PLANNING_OPENAI_USE_AZURE,
  MIDSCENE_PLANNING_USE_AZURE_OPENAI,
  MIDSCENE_PLANNING_AZURE_OPENAI_SCOPE,
  MIDSCENE_PLANNING_AZURE_OPENAI_KEY,
  MIDSCENE_PLANNING_AZURE_OPENAI_ENDPOINT,
  MIDSCENE_PLANNING_AZURE_OPENAI_API_VERSION,
  MIDSCENE_PLANNING_AZURE_OPENAI_DEPLOYMENT,
  MIDSCENE_PLANNING_AZURE_OPENAI_INIT_CONFIG_JSON,
  MIDSCENE_PLANNING_USE_ANTHROPIC_SDK,
  MIDSCENE_PLANNING_ANTHROPIC_API_KEY,
  MIDSCENE_PLANNING_VL_MODE,
  // GROUNDING
  MIDSCENE_GROUNDING_MODEL_NAME,
  MIDSCENE_GROUNDING_OPENAI_SOCKS_PROXY,
  MIDSCENE_GROUNDING_OPENAI_HTTP_PROXY,
  MIDSCENE_GROUNDING_OPENAI_BASE_URL,
  MIDSCENE_GROUNDING_OPENAI_API_KEY,
  MIDSCENE_GROUNDING_OPENAI_INIT_CONFIG_JSON,
  MIDSCENE_GROUNDING_OPENAI_USE_AZURE,
  MIDSCENE_GROUNDING_USE_AZURE_OPENAI,
  MIDSCENE_GROUNDING_AZURE_OPENAI_SCOPE,
  MIDSCENE_GROUNDING_AZURE_OPENAI_KEY,
  MIDSCENE_GROUNDING_AZURE_OPENAI_ENDPOINT,
  MIDSCENE_GROUNDING_AZURE_OPENAI_API_VERSION,
  MIDSCENE_GROUNDING_AZURE_OPENAI_DEPLOYMENT,
  MIDSCENE_GROUNDING_AZURE_OPENAI_INIT_CONFIG_JSON,
  MIDSCENE_GROUNDING_USE_ANTHROPIC_SDK,
  MIDSCENE_GROUNDING_ANTHROPIC_API_KEY,
  MIDSCENE_GROUNDING_VL_MODE,
] as const;

export const ALL_ENV_KEYS = [
  ...UNUSED_ENV_KEYS,
  ...BASIC_ENV_KEYS,
  ...GLOBAL_ENV_KEYS,
  ...MODEL_ENV_KEYS,
] as const;

export type TEnvKeys = (typeof ALL_ENV_KEYS)[number];
export type TGlobalConfig = Record<TEnvKeys, string | undefined>;

export type TVlModeValues =
  | 'qwen-vl'
  | 'qwen3-vl'
  | 'doubao-vision'
  | 'gemini'
  | 'vlm-ui-tars'
  | 'vlm-ui-tars-doubao'
  | 'vlm-ui-tars-doubao-1.5';

export type TVlModeTypes =
  | 'qwen-vl'
  | 'qwen3-vl'
  | 'doubao-vision'
  | 'gemini'
  | 'vlm-ui-tars';

export interface IModelConfigForVQA {
  // model name
  [MIDSCENE_VQA_MODEL_NAME]: string;
  // proxy
  [MIDSCENE_VQA_OPENAI_SOCKS_PROXY]?: string;
  [MIDSCENE_VQA_OPENAI_HTTP_PROXY]?: string;
  // OpenAI
  [MIDSCENE_VQA_OPENAI_BASE_URL]?: string;
  [MIDSCENE_VQA_OPENAI_API_KEY]?: string;
  [MIDSCENE_VQA_OPENAI_INIT_CONFIG_JSON]?: string;
  // Azure
  [MIDSCENE_VQA_OPENAI_USE_AZURE]?: string;
  [MIDSCENE_VQA_USE_AZURE_OPENAI]?: string;
  [MIDSCENE_VQA_AZURE_OPENAI_SCOPE]?: string;
  [MIDSCENE_VQA_AZURE_OPENAI_KEY]?: string;
  [MIDSCENE_VQA_AZURE_OPENAI_ENDPOINT]?: string;
  [MIDSCENE_VQA_AZURE_OPENAI_API_VERSION]?: string;
  [MIDSCENE_VQA_AZURE_OPENAI_DEPLOYMENT]?: string;
  [MIDSCENE_VQA_AZURE_OPENAI_INIT_CONFIG_JSON]?: string;
  // Anthropic
  [MIDSCENE_VQA_USE_ANTHROPIC_SDK]?: string;
  [MIDSCENE_VQA_ANTHROPIC_API_KEY]?: string;
  // extra
  [MIDSCENE_VQA_VL_MODE]?: TVlModeValues;
}

export interface IModelConfigForPlanning {
  // model name
  [MIDSCENE_PLANNING_MODEL_NAME]: string;
  // proxy
  [MIDSCENE_PLANNING_OPENAI_SOCKS_PROXY]?: string;
  [MIDSCENE_PLANNING_OPENAI_HTTP_PROXY]?: string;
  // OpenAI
  [MIDSCENE_PLANNING_OPENAI_BASE_URL]?: string;
  [MIDSCENE_PLANNING_OPENAI_API_KEY]?: string;
  [MIDSCENE_PLANNING_OPENAI_INIT_CONFIG_JSON]?: string;
  // Azure
  [MIDSCENE_PLANNING_OPENAI_USE_AZURE]?: string;
  [MIDSCENE_PLANNING_USE_AZURE_OPENAI]?: string;
  [MIDSCENE_PLANNING_AZURE_OPENAI_SCOPE]?: string;
  [MIDSCENE_PLANNING_AZURE_OPENAI_KEY]?: string;
  [MIDSCENE_PLANNING_AZURE_OPENAI_ENDPOINT]?: string;
  [MIDSCENE_PLANNING_AZURE_OPENAI_API_VERSION]?: string;
  [MIDSCENE_PLANNING_AZURE_OPENAI_DEPLOYMENT]?: string;
  [MIDSCENE_PLANNING_AZURE_OPENAI_INIT_CONFIG_JSON]?: string;
  // Anthropic
  [MIDSCENE_PLANNING_USE_ANTHROPIC_SDK]?: string;
  [MIDSCENE_PLANNING_ANTHROPIC_API_KEY]?: string;
  // extra
  [MIDSCENE_PLANNING_VL_MODE]?: TVlModeValues;
}

export interface IModeConfigForGrounding {
  // model name
  [MIDSCENE_GROUNDING_MODEL_NAME]: string;
  // proxy
  [MIDSCENE_GROUNDING_OPENAI_SOCKS_PROXY]?: string;
  [MIDSCENE_GROUNDING_OPENAI_HTTP_PROXY]?: string;
  // OpenAI
  [MIDSCENE_GROUNDING_OPENAI_BASE_URL]?: string;
  [MIDSCENE_GROUNDING_OPENAI_API_KEY]?: string;
  [MIDSCENE_GROUNDING_OPENAI_INIT_CONFIG_JSON]?: string;
  // Azure
  [MIDSCENE_GROUNDING_OPENAI_USE_AZURE]?: string;
  [MIDSCENE_GROUNDING_USE_AZURE_OPENAI]?: string;
  [MIDSCENE_GROUNDING_AZURE_OPENAI_SCOPE]?: string;
  [MIDSCENE_GROUNDING_AZURE_OPENAI_KEY]?: string;
  [MIDSCENE_GROUNDING_AZURE_OPENAI_ENDPOINT]?: string;
  [MIDSCENE_GROUNDING_AZURE_OPENAI_API_VERSION]?: string;
  [MIDSCENE_GROUNDING_AZURE_OPENAI_DEPLOYMENT]?: string;
  [MIDSCENE_GROUNDING_AZURE_OPENAI_INIT_CONFIG_JSON]?: string;
  // Anthropic
  [MIDSCENE_GROUNDING_USE_ANTHROPIC_SDK]?: string;
  [MIDSCENE_GROUNDING_ANTHROPIC_API_KEY]?: string;
  // extra
  [MIDSCENE_GROUNDING_VL_MODE]?: TVlModeValues;
}

export interface IModelConfigForDefault {
  // model name
  [MIDSCENE_MODEL_NAME]: string;
  // proxy
  [MIDSCENE_OPENAI_SOCKS_PROXY]?: string;
  [MIDSCENE_OPENAI_HTTP_PROXY]?: string;
  // OpenAI
  [MIDSCENE_OPENAI_BASE_URL]?: string;
  [MIDSCENE_OPENAI_API_KEY]?: string;
  [MIDSCENE_OPENAI_INIT_CONFIG_JSON]?: string;
  // Azure
  [MIDSCENE_OPENAI_USE_AZURE]?: string;
  [MIDSCENE_USE_AZURE_OPENAI]?: string;
  [MIDSCENE_AZURE_OPENAI_SCOPE]?: string;
  [MIDSCENE_AZURE_OPENAI_KEY]?: string;
  [MIDSCENE_AZURE_OPENAI_ENDPOINT]?: string;
  [MIDSCENE_AZURE_OPENAI_API_VERSION]?: string;
  [MIDSCENE_AZURE_OPENAI_DEPLOYMENT]?: string;
  [MIDSCENE_AZURE_OPENAI_INIT_CONFIG_JSON]?: string;
  // Anthropic
  [MIDSCENE_USE_ANTHROPIC_SDK]?: string;
  [MIDSCENE_ANTHROPIC_API_KEY]?: string;
  // extra
  [MIDSCENE_VL_MODE]?: TVlModeValues;
}

export interface IModelConfigForDefaultLegacy {
  // model name
  [MIDSCENE_MODEL_NAME]: string;
  // proxy
  [MIDSCENE_OPENAI_SOCKS_PROXY]?: string;
  [MIDSCENE_OPENAI_HTTP_PROXY]?: string;
  // OpenAI
  [OPENAI_BASE_URL]?: string;
  [OPENAI_API_KEY]?: string;
  [MIDSCENE_OPENAI_INIT_CONFIG_JSON]?: string;
  // Azure
  [OPENAI_USE_AZURE]?: string;
  [MIDSCENE_USE_AZURE_OPENAI]?: string;
  [MIDSCENE_AZURE_OPENAI_SCOPE]?: string;
  [AZURE_OPENAI_KEY]?: string;
  [AZURE_OPENAI_ENDPOINT]?: string;
  [AZURE_OPENAI_API_VERSION]?: string;
  [AZURE_OPENAI_DEPLOYMENT]?: string;
  [MIDSCENE_AZURE_OPENAI_INIT_CONFIG_JSON]?: string;
  // Anthropic
  [MIDSCENE_USE_ANTHROPIC_SDK]?: string;
  [ANTHROPIC_API_KEY]?: string;
  // extra
  [MIDSCENE_VL_MODE]?: TVlModeValues;
}

/**
 * - VQA: Visual Question Answering
 * - grounding：short for Visual Grounding
 * - planning: planning
 * - default: all except VQA、grounding、planning
 */
export type TIntent = 'VQA' | 'planning' | 'grounding' | 'default';

export type TModelConfigFn = (options: {
  intent: TIntent;
}) =>
  | IModelConfigForVQA
  | IModelConfigForPlanning
  | IModeConfigForGrounding
  | IModelConfigForDefault;

export enum UITarsModelVersion {
  V1_0 = '1.0',
  V1_5 = '1.5',
  DOUBAO_1_5_15B = 'doubao-1.5-15B',
  DOUBAO_1_5_20B = 'doubao-1.5-20B',
}

export const VL_MODE_RAW_VALID_VALUES: TVlModeValues[] = [
  'doubao-vision',
  'gemini',
  'qwen-vl',
  'qwen3-vl',
  'vlm-ui-tars',
  'vlm-ui-tars-doubao',
  'vlm-ui-tars-doubao-1.5',
];

export interface IModelConfig {
  /**
   * proxy
   */
  socksProxy?: string;
  httpProxy?: string;
  /**
   * model
   */
  modelName: string;
  /**
   * OpenAI
   */
  openaiBaseURL?: string;
  openaiApiKey?: string;
  openaiExtraConfig?: Record<string, unknown>;
  /**
   * Azure
   */
  openaiUseAzureDeprecated?: boolean;
  useAzureOpenai?: boolean;
  azureOpenaiScope?: string;
  azureOpenaiKey?: string;
  azureOpenaiEndpoint?: string;
  azureOpenaiApiVersion?: string;
  azureOpenaiDeployment?: string;
  azureExtraConfig?: Record<string, unknown>;
  /**
   * Anthropic
   */
  useAnthropicSdk?: boolean;
  anthropicApiKey?: string;
  /**
   * - vlModeRaw: exists only in non-legacy logic. value can be 'doubao-vision', 'gemini', 'qwen-vl', 'vlm-ui-tars', 'vlm-ui-tars-doubao', 'vlm-ui-tars-doubao-1.5'
   * - vlMode: based on the results of the vlModoRaw classification，value can be 'doubao-vision', 'gemini', 'qwen-vl', 'vlm-ui-tars'
   */
  vlModeRaw?: string;
  vlMode?: TVlModeTypes;
  uiTarsModelVersion?: UITarsModelVersion;
  modelDescription: string;
  /**
   * for debug
   */
  intent: TIntent;
  from: 'modelConfig' | 'env' | 'legacy-env';
}
